<!-- http://robertfaurisson.blogspot.com/1998/11/six-questions-jean-paul-ii-propos.html -->

<!-- Wednesday, November 4, 1998 -->

Six questions à Jean-Paul II à propos d'Edith Stein

Au Vatican, sur la place Saint-Pierre, le dimanche 11 octobre 1998, Jean-Paul II a procédé à la canonisation de Thérèse Bénédicte de la Croix (dans le siècle, Edith Stein), religieuse carmélite d'origine juive, née à Breslau (Silésie) le 12 octobre 1896 et, selon la version officielle, morte à Auschwitz (Silésie) le 9 août 1942. Au cours de son homélie, le pape a prononcé la phrase suivante :

Parce qu'elle était juive, Edith Stein fut déportée [des Pays-Bas] avec sa soeur Rosa et de nombreux autres juifs des Pays-Bas dans le camp de concentration d'Auschwitz, où elle trouva la mort avec eux dans les chambres à gaz (1).

La fin de cette phrase implique que, pour le pape, les chambres à gaz nazies ont vraiment existé. Jamais jusqu'à présent ni Jean-Paul II ni aucun autre pape avant lui n'avait ainsi pris la responsabilité d'affirmer l'existence et le fonctionnement de véritables abattoirs chimiques dans un camp de concentration allemand. Pie XII en particulier, mort en 1958, s'était jusqu'au bout abstenu de le faire et, comme lui, dans leurs mémoires de guerre, rédigés de 1948 à 1959, Churchill, Eisenhower et De Gaulle s'étaient refusés à mentionner génocide et chambres à gaz.

Pourquoi Jean-Paul II a-t-il pris cette extraordinaire initiative et de quelles preuves disposait-il, d'abord pour affirmer l'existence de ces chambres à gaz, puis pour préciser qu'Edith Stein, sa soeur Rosa et de nombreux autres juifs des Pays-Bas avaient trouvé la mort dans de telles chambres à gaz à Auschwitz ? Par ailleurs, dans la même homélie, Jean-Paul II a ajouté :

En célébrant à partir d'aujourd'hui la mémoire de la nouvelle sainte, nous ne pourrons manquer de rappeler également, chaque année, la Shoah, ce programme barbare visant à éliminer un peuple, et qui coûta la vie à des millions de frères et de soeurs juifs.

Là encore se pose une question : de quelles preuves le pape disposait-il d'abord, pour affirmer l'existence d'un programme visant à éliminer le peuple juif, puis pour avancer le chiffre de plusieurs millions de victimes de ce programme ? Plus un seul historien, en particulier Raul Hilberg, n'ose prétendre avoir trouvé la trace d'un tel plan, y compris dans "le procès-verbal de Wannsee" ; quant aux millions de victimes juives, où le décompte des pertes juives a-t-il été vraiment fait ?

Avec ces questions et quelques autres à l'esprit, j'ai consulté, dans la vaste bibliographie qui était consacrée à E. Stein, d'abord un ouvrage de référence publié en France en 1990, puis trois livres récents publiés en 1998 ainsi qu'une étude datant également de 1998 et, enfin, un assez grand nombre d'articles en différentes langues. J'ai conscience de ce qu'il s'agit là d'une enquête limitée. Il est évident que, si la permission en était accordée aux révisionnistes, je consulterais, pour commencer, les archives, extrêmement étendues, du Service international de recherches (SIR) établi en Allemagne à Arolsen-Waldeck ; malheureusement ces archives sont l'objet d'une surveillance attentive et spécialement du fait de l'État d'Israël. Le dossier constitué en vue de la béatification d'E. Stein, puis de sa canonisation m'intéresserait également mais le Vatican n'en permet pas la consultation. Aussi me vois-je réduit à solliciter des autorités vaticanes en général et du pape en particulier la faveur de m'accorder une réponse aux quelques questions ci-dessous formulées et à d'autres questions aussi qu'on trouvera plus loin.

Des diverses publications que j'ai consultées, il ressort qu'en réalité on ne sait ni où, ni quand, ni comment sont disparues E. Stein et sa soeur. On n'a donc apparemment pas le droit d'avancer aujourd'hui comme une certitude qu'elles ont été 1) tuées, 2) dans une ou plusieurs chambres à gaz à Auschwitz, 3) le 9 août 1942 (puisque aussi bien c'est cette date qui a été retenue par de nombreux auteurs ainsi que par le pape, lequel a souhaité faire du jour anniversaire de la mort d'E. Stein une journée de commémoration, par toute l'Eglise catholique, de la Shoah).

Le "calendrier" d'Auschwitz

D'après le "calendrier des événements d'Auschwitz" établi par Danuta Czech, dans sa version de 1989, E. Stein, sa soeur Rosa et 985 juifs ont été déportés du camp de Westerbork, aux Pays-Bas, et sont parvenus au camp d'Auschwitz le 8 (et non le 9) août 1942. Sur ces 987 juifs, 464 auraient été enregistrés pour le travail (315 hommes et 149 femmes) tandis que les 523 autres auraient été immédiatement gazés (2). Comme toujours dans le "calendrier", cette dernière précision n'est étayée d'aucune preuve ; c'est d'ailleurs ainsi qu'ont été tenus pour gazés, d'après ce "calendrier", des juifs dont j'ai pu démontrer qu'ils avaient survécu à la guerre. Ces 523 personnes dont D. Czech ne semble pas avoir retrouvé trace dans les archives du camp ont pu être débarquées, avant Auschwitz, à Cosel ou bien encore, parvenues à Auschwitz, elles ont pu être directement acheminées vers l'un des sous-camps du complexe d'Auschwitz ou vers tout autre camp de concentration, tout autre camp de travail.

Selon l'ouvrage de Sœur Waltraud Herbstrith

Dans Le Vrai visage d'Edith Stein, ouvrage généralement considéré comme de référence, Sœur Waltraud Herbstrith écrit:

Le Journal officiel hollandais publia, le 16 février 1950, les noms de tous les juifs qui avaient été déportés de Hollande le 7 août [1942]. On y voit dans la liste 34 : « Numéro 44074, Edith Theresia Edwige Stein, née le 12 octobre 1891 à Breslau [Silésie], venant d'Echt [Pays-Bas], morte le 9 août 1942 » (3).

Et d'ajouter pour son compte :

Comme il était juridiquement notoire que personne de ce convoi n'était resté en vie, le 9 août [1942] fut déclaré jour de décès des victimes (4).

On aura remarqué que ce Journal officiel ne précise pas où est morte E. Stein et que la date de sa mort est dite, par W. Herbstrith, "juridiquement notoire", ce qui implique qu'aucune véritable recherche n'a été menée ; la date résulte d'une spéculation comme il arrive dans ce qu'on appelle en France un "jugement déclaratif de décès" (5).

Selon l'hebdomadaire La Vie

Dans un article récent de La Vie (anciennement La Vie catholique illustrée), on peut lire :

[E. Stein est] exécutée dans des conditions obscures, à Auschwitz sans doute, officiellement le 9 août 1942 (6).

On aura remarqué que l'auteur de l'article reconnaît qu'on ne sait, en fait, pas vraiment où et quand E. Stein est morte ; quant au mot d'"exécutée", il est abusif puisque, le lieu et la date de la mort n'étant pas connus, il s'ensuit qu'on ne peut guère savoir comment cette mort s'est produite.

Selon le livre de Joachim Bouflet

Dans Edith Stein, philosophe crucifiée, Joachim Bouflet écrit :

[E. Stein est déportée] vers l'Est. Vers Auschwitz où elle sera gazée à l'arrivée du convoi, le 9 août avec sa sœur Rosa (7).

Et d'ajouter dans sa "chronologie" :

9 août 1942 : gazée avec sa sœur Rosa à Auschwitz-Birkenau.

On aura remarqué que l'auteur, qui semble ignorer que le convoi est arrivé à Auschwitz le 8 août et non le 9, précise, sur la foi d'on ne sait quelle preuve, que le "gazage" s'est produit à Birkenau ; à cette date, selon la vulgate, ce "gazage" aurait encore pu se produire soit à Auschwitz I, soit dans une "ferme" de Birkenau.

Selon le livre de Bernard Molter

Dans Edith Stein, martyre juive de confession chrétienne, Bernard Molter écrit :

Le 7 août, le convoi [parti des Pays-Bas] se met en route. Vers l'Est. Puis, c'est le silence. Le grand silence d'Auschwitz-Birkenau où [E. Stein] est exterminée, probablement dès l'arrivée le 9 août (8).

Et d'ajouter dans ses "Repères biographiques" :

Le 9 août probablement, elle meurt gazée à Auschwitz-Birkenau.

On aura remarqué que l'auteur qui, là encore, semble ignorer que le convoi est arrivé à Auschwitz le 8 août et non le 9, a l'honnêteté d'écrire que c'est "probablement" à cette dernière date qu'E. Stein est morte. Quant au mot d' "exterminée", il est d'autant plus abusif qu'un tel mot ne peut s'appliquer qu'à un groupe de personnes et non pas à un individu. En écrivant : "le convoi se met en route. Vers l'Est. Puis, c'est le silence", l'auteur a frôlé la vérité ; il aurait dû s'en tenir là sans ajouter la phrase suivante.

Selon le livre de Christian Feldmann

Dans Edith Stein, juive, athée, moniale, Christian Feldmann écrit :

Selon les renseignements du Ministère de la justice [de quel pays ?], Edith et Rosa Stein ont été gazées immédiatement après leur arrivée à Auschwitz, le 9 août 1942 (9).

Selon l'étude de Bernard Dupuy

Dans une étude intitulée "Edith Stein dans les griffes de la Gestapo/Précisions nouvelles sur son envoi en déportation", Bernard Dupuy écrit :

Deux cent quarante deux Juifs catholiques [dont E. et R. Stein], fichés, arrêtés et déportés tous ensemble auraient été dès leur arrivée à Auschwitz-Birkenau, le 9 août, envoyés à la chambre à gaz (10).

L'auteur, qui s'avoue tributaire de l'ouvrage de référence de W. Herbstrith et du livre de J. Bouflet, a la prudence d'employer le conditionnel mais, contrairement aux auteurs dont il s'inspire, il commet l'imprudence d'ajouter que tous les Juifs catholiques auraient été, comme E. et R. Stein, gazés le 9 août [pour : le 8 août].

Un plagiat généralisé ?

En somme, tous ces auteurs semblent se copier les uns les autres ou puiser à une même source, pauvre et douteuse, et chacun, en fin de compte, orne le récit traditionnel de quelques inventions personnelles.

On peut se poser la question de savoir si le pape ou ses conseillers n'ont pas, à leur tour, simplement répété sur la mort d'E. Stein et des autres juifs de ce convoi ce que, pendant des années, on a ressassé sans procéder à aucune vérification.

Autre question : E. Stein serait-elle morte

du typhus ?

Si E. Stein est vraiment arrivée à Auschwitz en août 1942, peut-être est-elle morte de l'une de ces terrifiantes épidémies de typhus qui ravageaient le camp à l'époque ? Même la ville d'Auschwitz en était atteinte. Des Allemands sont morts du typhus dans le camp, y compris des médecins SS.

Autre question : des membres de la famille

Stein ont-ils survécu ?

Dans son homélie, le pape a salué

les nombreux pèlerins venus à Rome, avec une pensée particulière pour les membres de la famille Stein, qui ont bien voulu se joindre à nous pour cette heureuse circonstance.

Certes, des membres de la famille Stein avaient quitté l'Europe à temps mais d'autres étaient restés, à Breslau par exemple. C'est ainsi que, dans l'ouvrage de W. Herbstrith on lit :

Le 28 juillet [1942] arriva [à la connaissance d'E. Stein] la terrible nouvelle que les frères et sœurs d'Edith Stein à Breslau, la famille de son frère Paul et sa sœur Frieda avaient été conduits à Theresienstadt (11).

On aimerait savoir le sort de ces personnes. Certaines d'entre elles ont-elles survécu à la guerre ? Ou bien certains de leurs enfants, nés après la guerre, étaient-ils présents à la cérémonie ?

Les évêques des Pays-Bas portent-ils la responsabilité première de cette déportation ?

On nous affirme souvent que les autorités d'occupation ont cyniquement trompé les évêques des Pays-Bas : après leur avoir assuré que les juifs baptisés ne seraient touchés par aucune mesure coercitive, les Allemands auraient, manquant soudain à leur parole, décidé de déporter ces juifs-là. La vérité ne serait-elle pas toute différente ? L'Eglise catholique des Pays-Bas n'aurait-elle pas d'abord manqué à ses engagements explicites ou implicites, puis adopté une attitude résolument provocatrice à l'égard des autorités d'occupation ?

Pour répondre à cette grave question, on se reportera, pour les comparer, à un passage du livre de C. Feldmann où se trouve exposé le point de vue antiallemand, puis à un passage de l'ouvrage de W. Herbstrith où se trouve résumé, sous la forme d'un document, le point de vue allemand pendant la guerre.

C. Feldmann écrit :

Le 11 juillet 1942, des dirigeants religieux de toutes les confessions [catholiques et protestantes] envoyèrent un télégramme au Commissaire du Reich, Seyss-Inquart, dans lequel ils s'élevaient contre la déportation des familles juives. ― Pour tromper leur monde, les autorités du Reich assurèrent que les juifs baptisés n'étaient pas concernés par les mesures coercitives. Mais cela ne dissuada pas les Eglises des Pays-Bas de se déclarer solidaires des Juifs persécutés. Une protestation enflammée contre la déportation des familles juives fut lue le 26 juillet dans toutes les églises de Hollande, de toutes les confessions. Dans les églises catholiques, une lettre pastorale demandant aux croyants de faire leur autocritique fut lue en plus de la protestation : « […] N'avons-nous pas nourri des sentiments de haine et d'amertume impies ? » La lettre se terminait par une prière très provocante pour les forces d'occupation […]. Une résistance aussi démonstrative contre la mise au pas des consciences ne pouvait évidemment pas être tolérée. Cela d'autant plus qu'on avait passé outre à l'interdiction expresse qui avait été faite par Seyss-Inquart, le Commissaire du Reich, de lire en chaire le télégramme de protestation qui lui avait été adressé. Les occupants nazis réagirent violemment le 2 août […]. Ils arrêtèrent tous les Juifs catholiques, religieux et religieuses compris, soit 1200 personnes selon certaines estimations (12).

On aura remarqué que, même aux yeux d'un auteur très favorable à la cause des juifs et des catholiques, les évêques ont adopté en la circonstance une attitude délibérément provocante. "Une protestation enflammée … une prière très provocante … une résistance aussi démonstrative … on avait passé outre à l'interdiction expresse" : tels sont les mots choisis par C. Feldmann. Mais il est un autre point, sensiblement plus important, qui mérite d'être souligné et qui suscite une interrogation : d'où vient que les Allemands aient arrêté les juifs catholiques sans arrêter en même temps les juifs protestants ? Comment expliquer cette différence de réaction ? N'y aurait-il pas eu une raison précise à cette anomalie ?

La réponse à ces questions semble se trouver dans un document allemand que C. Feldmann passe sous silence et que W. Herbstrith cite de façon malheureusement partielle. Il ressort de ce document que, pour les Allemands, les Eglises chrétiennes (la catholique et les protestantes) avaient été prévenues qu'elles pouvaient intervenir en faveur des juifs chrétiens mais non en faveur des juifs mosaïques. Si ces Eglises s'occupaient de leurs ouailles, les Allemands ne s'en prendraient pas aux juifs chrétiens. Le document porte :

Les Eglises protestantes ne sont pas fermées à cette manière de voir et n'ont provoqué pour leur part dans leurs églises aucune manifestation, prière, etc. Au contraire, l'Eglise catholique a, dimanche dernier, parlé dans ses églises de la déportation des Juifs. Ce serait prétendument que le point de vue du Commissaire du Reich n'aurait pas été connu à temps partout … (13).

On voit par là que, selon le point de vue des autorités allemandes, l'Eglise catholique aurait feint d'ignorer un avertissement, une promesse et une défense expresse dont les Eglises protestantes, elles, auraient tenu compte. Il est possible que, dans certains lieux du culte protestant, on ait passé outre aux instructions de la hiérarchie des Eglises protestantes mais l'Eglise catholique, elle, du sommet de sa hiérarchie, a décidé de ne tenir aucun compte de l'avertissement, de la promesse et de la défense expresse des autorités d'occupation ; elle a même ajouté le défi au refus : elle a fait lire publiquement le télégramme de protestation et ajouté cette lettre pastorale.

En conséquence, n'est-ce pas ce comportement de refus et de défi qui a provoqué la déportation d'Edith Stein ? On peut juger courageuse l'initiative de l'Eglise catholique des Pays-Bas comme on peut tenir pour justifié l'acte, pour un terroriste ou un résistant, de poser une bombe ou d'assassiner quelqu'un mais, lorsque vient le moment des représailles ― inévitables dans ce cas selon C. Feldmann lui-même, ― où sont les premiers responsables ? E. Stein, R. Stein et les autres juifs catholiques ne se seraient-ils pas vu épargner la déportation suivie, pour certains d'entre eux, de la mort en déportation si l'Eglise catholique hollandaise avait observé le même comportement que les Eglises protestantes hollandaises ? Sans vouloir offenser personne, n'a-t-on pas au moins le droit de poser cette question ?

Pourquoi de telles variantes d'une langue à l'autre

dans le texte de l'homélie ?

Le Vatican et l'Osservatore Romano ont la réputation de se montrer pointilleux dans la traduction des documents pontificaux. Ils ne manquent pas d'experts en traductions. Or, si l'on compare entre elles les différentes versions de l'homélie du 11 octobre 1998 en français, en anglais, en allemand et en italien, il est deux questions qu'on peut formuler à leur propos:

1) Pourquoi dans les versions allemande et anglaise est-il dit qu'Edith et Rosa Stein ont été déportées "avec de nombreux autres juifs catholiques des Pays-Bas" tandis que, dans les versions française et italienne, le mot de "catholiques" n'apparaît pas ?

2) Pourquoi la version française est-elle judaïsée en ce sens que, là où les autres versions mentionnent le Seigneur ("the Lord", "der Herr", "il Signore"), cette version-là porte : Yahvé ?

Conclusion

Par l'intermédiaire de l'Osservatore Romano à qui j'adresse le présent texte pour qu'il soit transmis à l'autorité compétente du Vatican, je me permets donc, en résumé, de poser à Jean-Paul II les questions suivantes dans l'espoir d'une réponse que je puisse, avec son autorisation, rendre publique :

1. Quelles preuves avez-vous qu'Edith Stein soit morte à Auschwitz dans une chambre à gaz d'exécution le 9 août 1942 ?

2. Quelle preuve avez-vous que l'Allemagne avait un programme visant à éliminer physiquement le peuple juif?

3. Avez-vous ordonné une enquête, notamment auprès du Service international de recherches (SIR) d'Arolsen-Waldeck pour savoir si, par exemple, Edith et Rosa Stein ne sont pas mortes ailleurs qu'à Auschwitz ou si elles n'ont pas été victimes des épidémies de typhus qui, notamment en 1942, ont ravagé le camp d'Auschwitz jusqu'à y provoquer parfois des centaines de morts par jour, y compris chez les gardiens allemands et les médecins SS du camp ?

4. Des membres de la famille Stein, internés pendant la guerre par les Allemands, ont-ils survécu jusqu'à pouvoir assister à la cérémonie de canonisation du 11 octobre 1998 au Vatican ?

5. Les évêques des Pays-Bas ne portent-ils pas, à la différence des autorités protestantes, la responsabilité première de la décision allemande de déporter les juifs catholiques ?

6. Pourquoi relève-t-on, d'une langue à l'autre, de graves variantes dans le texte de l'homélie prononcée le 11 octobre 1998 ?

N.B. Vincent Reynouard vient de publier un examen révisionniste du cas d'Edith Stein ; voy. "Sur Edith Stein", ANEC Informations (BP 21, 44530 ST GILDAS DES BOIS), 29 octobre 1998, p. 3-5.

4 novembre 1998

NOTES

1. L'Osservatore Romano, édition hebdomadaire en langue française, 13 octobre 1998, p. 1.

2. Danuta Czech, Kalendarium der Ereignisse im Konzentrationslager Auschwitz-Birkenau 1939-1945, Hamburg, Rowohlt, 1989, p. 269.

3. Waltraud Herbstrith, Das Wahre Gesicht Edith Steins ("Le Vrai visage d'Edith Stein"), Aschaffenburg, Kaffke-Verlag, 1987 [1971], verbesserte Auflage [édition revue et corrigée], p. 176.

4. Ibid.

5. Quand la date de la disparition d'un déporté n'est pas connue, l'état civil retient pour date de son décès le jour où ce déporté est arrivé dans le camp. Dans certains cimetières juifs d'Allemagne on peut voir des inscriptions tombales qui portent, pour deux ou trois membres d'une même famille, la même date de décès dans le même camp de concentration ; on risque d'en déduire que toutes ces personnes ont été assassinées en même temps alors qu'en réalité chaque membre de cette famille a pu trouver la mort à des dates différentes pour des causes différentes, dans des circonstances différentes, et même dans des camps différents.

6. Jean-Pierre Manigne, "Edith Stein, juive et martyre", La Vie, 8 octobre 1998, p. 71.

7. Joachim Bouflet, Edith Stein, philosophe crucifiée, Presses de la Renaissance, 1998, p. 273.

8. Bernard Molter, Edith Stein, martyre juive de confession chrétienne, Cana, 1998, p. 145.

9. Christian Feldmann, Edith Stein, juive, athée, moniale, traduit de l'allemand par Yvan Mudry, éd. Saint-Augustin, 1998, p. 144.

10. Bernard Dupuy, "Edith Stein dans les griffes de la Gestapo/Précisions nouvelles sur son envoi en déportation", Istina XLIII (1998), p. 289.

11. Waltraud Herbstrith, op. cit. , p. 165.

12. Christian Feldmann, op. cit. , p. 138-139.

13. Waltraud Herbstrith, op. cit. , p. 177.

Labels: Arolsen-Waldeck, Bernard Dupuy, Bernard Molter, Christian Feldmann, Danuta Czech, Edith Stein, Jean-Paul II, Joachim Bouflet, le "calendrier" d'Auschwitz, Seyss-Inquart, Waltraud Herbstrith
