<!-- http://robertfaurisson.blogspot.com:80/1987/06/shoah-film-de-claude-lanzmann-vers-un.html -->

<!-- Thursday, June 18, 1987 -->

Shoah, film de Claude Lanzmann : Vers un krach du shoah-business…

« Shoah » est un mot hébreu qui signifie catastrophe. Il est devenu un synonyme d'extermination, de génocide, d'holocauste. Il sert de titre à un interminable film de Claude Lanzmann. Marek Edelman, l'un des anciens dirigeants du soulèvement, en 1943, du ghetto de Varsovie, a qualifié ce film d'« ennuyeux », de « peu intéressant » et de « manqué »[1]. En dépit d'une mobilisation générale des médias en sa faveur, les Français ― y compris la communauté juive française prise dans son ensemble ― ont résolument boudé ce pensum. En désespoir de cause, la secrétaire générale du prix de la Fondation du judaïsme français, attribué à Shoah, a déclaré : « Je terminerai par une exhortation, une supplication. Allez voir ce film, demandez à ceux qui vous entourent d'aller le voir [2]. » F. Mitterrand a cautionné ce film, Jean-Paul II aussi et bien d'autres grands de ce monde. Rien n'y a fait. Les chaînes de télévision ont longtemps résisté aux pressions mais les voici qui craquent : le gigantesque navet passera. Durée : près de neuf heures et demie.

Lanzmann veut nous faire croire que les chambres à gaz homicides et l'extermination des juifs ont réellement existé. Or, ce que son film montre surtout, c'est qu'il n'y a ni preuves, ni témoins et que, comme le démontrent les révisionnistes, ces chambres et cette extermination sont un seul et même mythe. D'ailleurs, s'il s'agissait d'une vérité, on s'empresserait de nous le prouver par une émission spéciale sur toutes les chaînes de télévision un beau soir à 20 h 30, avec des documents et non avec Shoah.

La vérité est que Hitler a traité les juifs en ennemis déclarés, a voulu les chasser d'Europe, en a mis un grand nombre en camps de travail ou de concentration. Certains de ces camps avaient des fours crématoires pour l'incinération des cadavres. Aucun n'avait de chambre à gaz homicide. L'existence de ces prétendus abattoirs à gaz se heurte à des impossibilités d'ordre physique, chimique, topographique, architectural, documentaire. Le sort des juifs a été banalement atroce. Qu'on songe aux enfants allemands tués ou mutilés au phosphore ou encore, de 1945 à 1947, massacrés lors de leur « transfert » de l'Est vers l'Ouest !

Ni ordre, ni plan, ni budget

Lanzmann savait parfaitement la fragilité de la thèse exterminationniste et la solidité des arguments révisionnistes. Voilà une colossale entreprise d'extermination pour laquelle on ne trouve trace ni d'un ordre, ni d'un plan, ni d'un budget ! Quant à l'arme spécifique de ce crime spécifique, elle a tout simplement disparu ! Même Le Nouvel Observateur a fini par se faire l'écho pour le grand public de l'aveu des spécialistes : « Il n'existe aucune photographie de chambre à gaz [3]», ce qui veut dire que ce qu'on persiste à présenter aux touristes en fait de chambres à gaz au Struthof, à Mauthausen, à Hartheim, à Dachau, à Majdanek, à Auschwitz, n'est que de l'attrape-nigaud. Lanzmann a participé au fameux colloque de la Sorbonne (29 juin ― 2 juillet 1982) où ces cruelles évidences étaient soudain apparues aux deux organisateurs, Raymond Aron et François Furet. Il s'est senti renforcé dans sa conviction : en l'absence de preuves et de documents, il allait rétorquer aux révisionnistes par un film incantatoire et des montages de « témoignages ».

Pourquoi pas ?

Faire ce film avec du rien

C'est ainsi que Lanzmann a filmé, jusqu'à la nausée, des rails de chemin de fer, des pierres ou des paysages ; il accompagne ces images lancinantes d'un commentaire lourdement lyrique et de jeux de caméra destinés à « évoquer » déportations et gazages. Il dit lui-même en son pathos : « A force de filmer ces pierres de Treblinka, sous tous les angles, elles ont fini par parler [4].» Il affirme, sans preuves, que les nazis ont effacé les traces de leur gigantesque crime. Il déclare : « Il fallait faire ce film avec du rien, sans documents d'archives, tout inventer [5].» Ou encore : « Il s'agissait donc de faire un film avec des traces de traces de traces. [...]. Avec le rien on revient au rien [6].» Ses thuriféraires ne l'en admirent que plus. « Pas une seule image d'archive », s'exclame J.-F. Held [7]. « Ce film est un fantastique ressassement [8].» Pour Glucksman, « La force de ce film est de montrer non ce qui s'est passé ― il s'en garde bien ― mais la possibilité de ce qui s'est passé [9].»

C'est ainsi qu'au spectateur le cinéaste fait croire ce qu'il veut. Les imaginations ne demandent qu'à être mises en branle. Il arrive que le résultat dépasse toute espérance. Fier de son art de persuader, Lanzmann déclarait à un journal américain : « Un homme m'a écrit après avoir vu le film que c'était la première fois qu'il avait entendu le cri d'un petit enfant dans une chambre à gaz. C'est peut-être parce que son imagination avait été mise en branle [10].» Au camp principal d'Auschwitz, Lanzmann a filmé le crématoire où l'on montre aux touristes, d'une part, la salle des fours et, d'autre part, une salle adjacente, baptisée chambre à gaz (en réalité : une chambre froide pour les cadavres). Or, sa caméra se maintient dans la première salle ; elle y multiplie les pirouettes et les virevoltes si bien que la brusque et infinitésimale apparition de la prétendue chambre à gaz, quasiment dans le noir, ne peut être décelée que par l'œil du spécialiste. Le spectateur non averti peut croire que Lanzmann lui a montré clairement une chambre à gaz. C'est de la pure esbroufe. Quant à Lanzmann il peut indifféremment soutenir qu'il a montré ou qu'il n'a pas montré cette « vraie » ou cette « fausse » chambre à gaz. Tout est à l'avenant.

Shoah s'ouvre sur un mensonge par omission. Dans la liste de ceux qui ont rendu possible, notamment sur le plan financier, la réalisation de ce film, Lanzmann se garde bien d'indiquer le premier de ses commanditaires : l'État d'Israël ; Menahem Begin en personne avait commencé par débloquer quatre-vingt-cinq mille dollars pour ce qu'il appelait un « projet d'intérêt national juif »[11]. Lanzmann a utilisé des supercheries matérielles ou verbales de toutes sortes pour tromper soit certaines personnes interviewées, soit le spectateur. Auprès de ses « témoins » allemands, il s'est parfois présenté « au nom d'un institut désireux de rétablir la vérité sur le prétendu génocide des juifs européens. [...] L'argent a décidé les hésitants [12]. » Il semble avoir usurpé un titre de «docteur » et utilisé le nom de « Dr Sorel » auprès du « témoin » Walter Stier. Son «témoin » numéro 1 est le coiffeur Abraham Bomba ; dans une scène « criante de vérité», on voit Bomba officier dans sa boutique et reproduire sur la chevelure d'un client les gestes qu'il avait, paraît-il, pour couper « dans la chambre à gaz de Treblinka » les cheveux des victimes. Esbroufe là encore : Bomba était coiffeur à New York, il avait pris sa retraite en Israël et c'est là que Lanzmann avait loué une boutique et procédé à toute une mise en scène en accord avec Bomba [13].

Un salon de coiffure dans la chambre à gaz

Venons-en précisément aux « témoins » de Shoah. Il ne s'agit pas de témoins au sens juridique du terme. Aucun des « témoignages » n'est vérifié ni contrôlé. Aucun « témoin » n'est contre-interrogé. Aucun « témoignage » ne semble avoir été restitué sous sa forme intégrale et, sur trois cent cinquante heures de tournage, Lanzmann n'a de toute façon prélevé que près de neuf heures et demie. Les « témoignages » sont, de plus, systématiquement tronçonnés et on nous les livre par fragments, sur fond d'images arbitrairement choisies pour mettre le spectateur en condition.

Le témoignage qu'ont retenu, avant tout autre les promoteurs de Shoah, est celui d'Abraham Bomba. Il fourmille pourtant d'impossibilités matérielles et de graves obscurités. Bomba veut nous faire croire qu'il officiait à Treblinka dans une pièce qui était à la fois un salon de coiffure et une chambre à gaz ! La pièce mesurait quatre mètres sur quatre. Dans cet espace exigu, il y avait, dit-il, seize ou dix-sept coiffeurs et des bancs ; soixante ou soixante-dix femmes nues environ entraient avec un nombre indéterminé d'enfants ; pour que la totalité de ce groupe eût les cheveux coupés, il suffisait de huit minutes environ. Personne ne quittait la pièce ; entraient alors soixante-dix ou quatre-vingt femmes avec, à nouveau, un nombre indéterminé d'enfants ; pour tout ce nouveau groupe la coupe durait environ dix minutes. Donc, le total des présents était alors d'environ cent quarante-six à cent soixante-sept, sans compter les enfants et l'espace occupé par les bancs. C'est du pur non-sens. Les coiffeurs ainsi comprimés travaillaient sans répit ; ils ne quittaient la pièce, de temps en temps, que pendant cinq minutes : juste le délai nécessaire pour le gazage des victimes, l'enlèvement des cadavres et le nettoyage de la pièce : tout « était propre » alors. On ne nous dit pas quel était le gaz employé ni par où il était envoyé. Et puis, comment procédait-on à la dispersion du gaz après l'opération ? Lanzmann ne pose pas ces questions. Il faudrait un gaz à l'effet foudroyant, sans adhérence aux surfaces et sans rémanence dans les corps à manipuler. Bomba est un mythomane qui s'est vraisemblablement inspiré de la page 191 du Treblinka de J.-F. Steiner, un livre qui a été dénoncé même par un P. Vidal-Naquet comme une immonde fabrication [14] et qui a été rédigé au moins partiellement par le romancier Gilles Perrault [15].

Le « témoin » Rudolf Vrba est à l'origine du mythe d'Auschwitz. Interné à Birkenau dans les meilleures conditions (il disposait d'une chambre personnelle), il a raconté sur Auschwitz, dès avril 1944, une telle somme d'inepties qu'il lui est arrivé en janvier 1985 au procès Zündel à Toronto une humiliante mésaventure : le procureur qui avait invoqué son témoignage contre un révisionniste avait brusquement renoncé à l'interroger plus avant, tant il était devenu évident que Vrba était un fieffé menteur. Il avait totalement inventé des faits et des chiffres. En particulier, il disait avoir personnellement dénombré cent cinquante mille juifs de France gazés en vingt-quatre mois à Birkenau ; or, pour toute la durée de la guerre, Klarsfeld avait démontré que les Allemands avaient déporté vers tous les camps environ 75.721 juifs de France. Sommé de s'expliquer sur une certaine visite de Himmler à Auschwitz pour l'inauguration de nouvelles chambres à gaz, il en appelait, lui, l'homme de toutes les précisions les plus scrupuleuses, à la « licentia poetarum ».

Un témoin sauvé par de jeunes beautés nues

Le « témoin » Filip Müller est de la même trempe. Il est l'auteur de Trois ans dans une chambre à gaz d'Auschwitz. Ce best-seller nauséabond est le résultat du travail d'un nègre allemand, Helmut Freitag, qui n'a pas hésité devant le plagiat ; voyez Carlo Mattogno, « The Filip Müller's Plagiarism » repris dans Auschwitz : un caso di plagio. La source du plagiat est Médecin à Auschwitz, autre best-seller signé de Miklos Nyiszli. Dans le film, il dit que dans la grande chambre à gaz de Birkenau on pouvait gazer jusqu'à trois mille personnes à la fois et qu'au moment du gazage « presque tous se précipitaient vers la porte » et, enfin, que « là où le Zyklon avait été versé, c'était vide ». Il se garde de dire que la pièce en question (en fait une chambre froide : Leichenkeller) mesurait tout au plus 210 m2, ce qui aurait interdit tout déplacement. Il dit qu'à cette foule il fallait seulement trois ou quatre heures pour pénétrer dans le vestiaire (avec trois mille patères !), s'y déshabiller, passer dans la chambre à gaz, y être gazées, être transportées dans la salle des fours, y être brûlées et réduites en cendres. Il ne dit pas qu'il n'y avait que quinze bouches à feu ; à raison d'une heure et demie pour réduire un cadavre en cendres, il aurait fallu douze jours et douze nuits de fonctionnement ininterrompu pour accomplir cette prouesse technique. Et il y avait plusieurs fournées par jour de victimes à gazer et à brûler! Dans le film, il raconte comment les victimes entonnèrent l'hymne national tchèque et l'hymne juif : la Hatikva. Il s'inspire ici d'un « témoignage » selon lequel des victimes entonnèrent l'hymne national polonais et la Hatikva jusqu'à ce que les deux chants se confondent dans... l'Internationale [16]. Dans le livre (p. 154-155) mais non dans le film, il raconte comment, décidé à mourir dans la chambre à gaz, il en fut dissuadé par un essaim de jeunes beautés nues qui l'expulsèrent manu militari pour mourir toutes seules : lui servirait de témoin. A la page 83, il rapporte que les médecins nazis palpaient les cuisses et les parties génitales des hommes et des femmes encore en vie et qu'après la mort des victimes les morceaux prélevés étaient jetés dans un récipient (dans la version allemande originale, les récipients étaient pris de mouvements saccadés sous l'effet de la convulsion des muscles [17]).

Tel est Filip Müller, le grand « témoin » de C. Lanzmann.

Son « témoin » Karski parle avec emphase du ghetto de Varsovie mais pour ne rien en dire. Il est dommage que Lanzmann ne nous l'ait pas fait entendre sur sa prétendue expérience du camp de Belzec. Jan Karski racontait que les juifs y étaient tués à la chaux vive dans des wagons. « Je ne le mentionnerais pas, même dans une note en bas de page », devait dire Raul Hilberg [18].

Le « témoin » Raul Hilberg, lui, a beaucoup plus de valeur. Lanzmann a été critiqué pour avoir fait place dans son film à ce professeur américain, d'origine juive autrichienne, qui n'a rien connu des camps. Hilberg est le pape de la théorie exterminationniste. Il est l'homme qui a fini par reconnaître qu'il n'avait existé ni ordre, ni plan, ni budget pour l'extermination des juifs. Il croit néanmoins désespérément à cette extermination. C'est son désespoir d'intellectuel qui est intéressant. Tout spectateur attentif du film verra à quel point Hilberg se livre à de pures spéculations pour défendre sa théorie. Cela saute aux yeux dans tout son développement sur les chemins de fer allemands qui, dit-il, emmenaient le plus ouvertement du monde les juifs de Varsovie vers Treblinka. Il rappelle les heures précises de départ et d'arrivée. Et il en conclut... que les juifs étaient ainsi envoyés aux chambres à gaz de Treblinka. A aucun instant il ne nous prouve que Treblinka possédait de telles chambres à gaz.

Le « témoin » Suchomel est un ancien sergent de Treblinka. Aussi longtemps qu'il parle d'autre chose que de gazage homicide il est relativement précis. Dès qu'il aborde le chapitre de ce gazage il devient nébuleux. Il ne précise ni l'emplacement, ni les dimensions, ni le fonctionnement. Tantôt il parle de « la chambre à gaz » et tantôt « des chambres à gaz » sans que Lanzmann lui demande de lever l'équivoque. Il ne révèle pas même la nature du gaz. Il parle de « moteurs ». La légende qui a force de loi est qu'il y avait un « moteur diesel » (Gerstein) ; or, le diesel est impropre à asphyxier. A aucun instant il ne dit avoir assisté à un gazage. Il dit que, le jour de son arrivée, « juste au moment où nous passions, ils étaient en train d'ouvrir les portes de la chambre à gaz... et les gens sont tombés comme des pommes de terre ». Il a donc, tout au plus, vu des cadavres. Rien ne lui permettait d'affirmer que le local était une chambre à gaz. Il venait d'arriver. Tout au plus rapporte-t-il un propos. Par ailleurs, tout ce qu'il dit implique que dans ce camp il y avait des juifs, des cadavres, un ou des bûchers peut-être et, probablement, des douches et des chambres à gaz de désinfection. Il montre le bas d'un plan mais dans l'obscurité. Quel est ce plan ? Il parle avec autorité des gazages d'Auschwitz où il n'a jamais mis les pieds. Il parle avec la même autorité des gazages de Treblinka mais jamais en témoin oculaire. Il ressemble à ces autodidactes qui débitent sur un sujet donné le résultat de leurs lectures et qu'une simple question directe et précise désarçonnerait. Mais jamais Lanzmann ne lui pose cette question.

Depuis que le mythe des chambres à gaz est en péril, on a tendance à se rabattre sur celui des fantomatiques camions à gaz. C. Lanzmann nous promène beaucoup en camion. C'est peut-être sur ce sujet que ses « témoins » sont les moins vraisemblables et les plus contradictoires. Pour sauver la mise, Lanzmann nous inflige la lecture d'un document (lui, qui ne voulait pas de document) sur les camions spéciaux Saurer. Il n'y a qu'un malheur pour lui : c'est qu'il a gravement manipulé le texte, cherchant notamment à lui enlever ses absurdités les plus voyantes. Les spécialistes trouveront l'intégralité du document dans NS-Massentötungen durch Giftgas [19].

Treblinka : rien de secret

Quant aux braves paysans polonais des environs de Treblinka et au mécanicien de locomotive, ils semblent avoir été surtout éblouis par la richesse des juifs arrivés en trains de voyageurs et, s'ils pensaient que les Allemands allaient tuer ces juifs, c'était surtout, croyaient-ils, en les étranglant ou en les pendant. Aucun n'a été le témoin de gazages homicides. Or, de tels gazages dans de telles quantités industrielles n'auraient pu leur échapper. Treblinka, situé à 100 km de Varsovie, n'avait rien de secret. Richard Glazar, interrogé par Lanzmann, ne dit pas dans le film ce qu'il a confié à l'historienne Gitta Sereny Honeyman : tous les Polonais entre Varsovie et Treblinka devaient connaître l'endroit, on y venait faire du troc avec les juifs du camp, les paysans en particulier ; il y avait de la prostitution avec les gardiens ukrainiens ; Treblinka était un vrai « cirque » pour les paysans et les prostituées [20].

Lanzmann a peur des révisionnistes. Il a déclaré : « Je rencontre souvent des gens qui disent que Shoah n'est pas objectif parce qu'on n'y montre pas d'interviews avec ceux qui ont nié l'Holocauste. Mais, si vous essayez de discuter de ce point, vous vous retrouvez pris dans un piège [21]. »

Effectivement, les rares fois où les révisionnistes ont pu attirer des exterminationnistes dans une discussion, ces derniers ont subi de cuisantes déconvenues. Mais le grand public comprend de moins en moins ce refus de la discussion à la radio et à la télévision. Si les révisionnistes disent des mensonges, pourquoi ne pas les confondre en public ? D'ailleurs, disent-ils des mensonges ? S. Klarsfeld n'a-t-il pas lui-même reconnu qu'on n'avait pas encore publié de « vraies preuves » de l'existence des chambres à gaz mais seulement des « débuts de preuves »[22]?

La dernière guerre avec l'Allemagne a pris fin le 8 mai 1945. Mais certains considèrent apparemment qu'il faut continuer cette guerre en persistant à propager les horribles inventions de la propagande de guerre ; ils le font par la voie des procès ou par celle des médias qui, de plus en plus, augmentent le tam-tam holocaustique. Il faudrait s'arrêter. On en a déjà trop fait. La paix et la réconciliation exigent un autre comportement. Le Shoah-business nous mène dans une impasse. Les jeunes générations juives ont mieux à faire que de s'enfermer dans les croyances absurdes de la religion de l'Holocauste. Leur refus de s'intéresser au film Shoah serait, s'il se confirmait, un premier signe du rejet, par la nouvelle génération, de la mythologie officielle au moins en ce qui concerne la seconde guerre mondiale et ses suites.

18 juin 1987



[Sous le titre « Ouvrez les yeux, cassez la télé ! », ce texte, sous forme de tract, a été distribué par Pierre Guillaume aux spectateurs qui se présentaient devant le cinéma où le film était projeté.]

***

Notes

------------------------------------------------------------------------

[1] Le Monde, 2 novembre 1985, p. 3.

[2] Hamoré, juin 1986, p. 37.

[3] Le Nouvel observateur, 26 avril 1983, p. 33.

[4] Libération, 25 avril 1985, p. 22.

[5] Le Matin de Paris, 29 avril 1985, p. 12.

[6] L'Express, 10 mai 1985, p. 40.

[7] L'Événement du jeudi, 2 mai 1985, p. 80.

[8] L'Autre Journal, mai 1985, p. 48.

[9] A. Glucksmann, Le Droit de vivre, fév.-mars 1986, p. 21.

[10] New York Times, 20 octobre 1985, sec. 2, p. H-l.

[11] The Jewish Journal (New York), 27 juin 1986, p. 3 et Agence télégraphique juive, 20 juin 1986.

[12] Reportage d'Annette Lévy-Willard et Laurent Joffrin, Libération, 25 avril 1985, p. 22.

[13] Jean-Charles Szurek, L'Autre Groupe, 10, 1986, p. 65 ; The Times, 2 mars 1986 ; L'Autre Journal, mai 1985, p. 47.

[14] P. Vidal-Naquet, Les Juifs, la mémoire et le présent, Maspero, 1981, p. 212.

[15] Le Journal du Dimanche, 30 mars 1986, p. 5.

[16] Récit reproduit par B. Mark, Des Voix dans la nuit, Plon, 1982, p. 247.

[17] Sonderbehandlung, Munich, Steinhausen, 1979, p. 74.

[18] E. Meyer, « Recording the Holocaust », The Jerusalem Post International Edition, 28 juin 1986, p. 9.

[19] E. Kogon, H. Langbein, A. Rückerl et al., NS-Massentötungen durch Giftgas, Francfort, S. Fischer, 1983, p. 333-337.

[20] G. Sereny Honeyman, Into that Darkness, Londres, André Deutsch, 1974, p. 193.

[21] Jewish Chronicle (Londres), 6 février 1986, p. 8.

[22] VSD, 29 mai 1986, p. 37.

Labels: "Shoah", Abraham Bomba, Auschwitz, Birkenau, Filip Müller, Gitta Sereny Honeyman, Hilberg, Klarsfeld, Lanzmann, Pierre Vidal-Naquet, Treblinka, Vrba
