<!-- http://robertfaurisson.blogspot.com/2003/03/retour-sur-le-pro-flacco-et-la.html -->

<!-- Wednesday, March 19, 2003 -->

# Retour sur le Pro Flacco et la description des juifs par Cicéron (Réplique à Gilles Karmasyn)

Dans l'introduction d'un ouvrage de plus de deux mille pages, Ecrits révisionnistes (1974-1998), publié en 1999, je consacrais un simple alinéa à la figure de l'aristocrate romain Lucius Flaccus, que Cicéron avait eu à défendre, en 59 avant notre ère, dans un procès pour concussion ; parmi les accusateurs de L. Flaccus figurait en particulier la communauté juive de Rome. A ce propos, je notais :

La description que fait l'illustre orateur de l'influence, de la puissance et des procédés des juifs de Rome dans le prétoire me donne à penser que, s'il revenait sur terre, au XXe siècle, pour y défendre un révisionniste, il n'aurait pour ainsi dire pas un mot à changer sur ce point dans sa plaidoirie du Pro Flacco (p. XLVII).
L'année suivante, un certain Gilles Karmasyn me prenait à partie dans un texte intitulé : « Faurisson, un antisémite / Faurisson se compare au politicien pourri Lucius Flaccus » (). Le 5 août de la même année, je publiais une analyse du factum où, avant de conclure à la faiblesse de l'ensemble, je signalais à son auteur, en plus de quatre types d'erreurs vénielles, les quatre erreurs capitales qui réduisaient à néant sa tentative de démonstration.
Ce dernier vient de diffuser une réplique, qui porte pour titre : « Faurisson un antisémite. A-t-on lu Cicéron ? Quand Faurisson falsifie Cicéron et invente un complot juif vieux de deux mille ans ». Ce nouveau texte est fort long mais la substance en est indigente. G. Karmasyn y répète à satiété sa double conviction que Flaccus était un voleur de l'argent des juifs et que Faurisson est inspiré par l'antisémitisme. Il ne fournit cependant aucune preuve à l'appui de ces allégations. Dans son premier texte, il avait caché au lecteur que Flaccus avait été acquitté par le tribunal. Je lui en avais fait la remarque. Piqué au vif, il me rétorque aujourd'hui qu'un tel acquittement ne signifie pas que L. Flaccus était innocent. Peut-être ! Mais ce n'était pas une raison pour passer sous silence le fait de l'acquittement. Il nous dit qu'André Boulanger lui-même, qui a établi et traduit le De Flacco pour « Les Belles Lettres », a la « conviction » que Cicéron avait défendu une crapule. C'est inexact. A. Boulanger exprime des doutes sur l'honnêteté de L. Flaccus mais, comme d'autres auteurs, en particulier juifs, il ne révèle pas les motifs de ces doutes et n'apporte pas de preuve, en tout cas, d'une culpabilité quelconque. En outre, à la différence de G. Karmasyn, il mentionne « l'issue favorable de l'affaire de Flaccus » (p.57) et répète que « Flaccus fut certainement acquitté » (p.67). A l'appui de ses doutes, A. Boulanger invoque l'autorité de Macrobe qui a parlé des « crimes manifestes » de L. Flaccus. Il n'en faut pas plus à G. Karmasyn pour brandir cette affirmation de Macrobe comme si elle provenait d'un contemporain de l'accusé. Il écrit : « Flaccus était coupable. Boulanger rappelle qu'un contemporain a lui-même souligné cet état de fait [sic] ». Mais G. Karmasyn s'égare : Macrobe n'était pas un contemporain de Flaccus : il a vécu cinq siècles après lui ! Cherchant à reproduire une phrase de Macrobe en latin, il l'orne d'un barbarisme. Citant un bref passage du De Oratore de Cicéron, il l'enrichit d'un autre barbarisme. Me reprochant de traduire par « tourbe » le latin turba, mot appliqué deux fois par Cicéron à la foule des juifs excités qui ont envahi le prétoire, il voit là une preuve de mon antisémitisme et il ajoute : « Nous remarquons d'ailleurs que le vieux Gaffiot que nous avons sous les yeux (F. Gaffiot, Dictionnaire latin-français, Hachette, 1934) se garde de traduire 'turba' (page[s] 1612-1613) par « tourbe » et donne les significations suivantes : trouble d'une foule en désordre, mêlée, foule, confusion ». Il est à croire que G. Karmasyn a des yeux pour ne pas voir : le « vieux Gaffiot » propose bel et bien le mot de « tourbe » et précisément au bas de la page 1612 ; le « nouveau Gaffiot » note également ce sens (Le Grand Gaffiot, nouvelle édition revue et augmentée sous la direction de Pierre Flobert, Hachette-Livre, 2000). G. Karmasyn erre sur le sens de certains mots français ; par exemple, il tend à confondre « tribut » (forcé) avec « contribution » (volontaire). Quand je rappelle que le procès de L. Flaccus s'est tenu non loin d'un quartier juif et que les juifs sont en nombre dans le prétoire, il me traite à nouveau d'antisémite et s'engage dans une digression sur l'emplacement du quartier juif dans la ville de Rome. Il ne semble pas voir que c'est Cicéron en personne qui donne ces indications sur la proximité d'un quartier juif et sur la multitude, dans la salle du tribunal, de juifs excités. Malgré mes explications sur le fait que Flaccus était, dans sa province d'Asie, propréteur et non préteur, il invoque sur ce point l'autorité d'A. Boulanger sans paraître voir que ce dernier a clairement écrit : « Après sa préture, en 62 [avant notre ère], Flaccus avait été chargé du gouvernement de la province d'Asie comme propréteur » (p.59). Un propréteur était un ancien préteur comme un proconsul était un ancien consul et c'est par le fait d'une licence d'usage qu'on pouvait continuer d'appeler « consul » ou « préteur » un homme devenu en fait proconsul ou propréteur pour une courte période de temps. La propension qu'on note chez G. Karmasyn à prendre le Pirée pour un homme, sa disposition à imiter le cordonnier qui « juge au-dessus de la chaussure » et sa tendance à s'inspirer de Garo qui « en remontre à son curé » font de la lecture de ses écrits une épreuve pour le correcteur : on dirait le pensum d'un potache à la fois irascible et outrecuidant.
On passera sur sa manie de prêter à l'adversaire des propos que ce dernier n'a en fait jamais tenus. Il utilise pour cela le procédé qui consiste à placer entre guillemets des mots comme « machination », « machination juive », « agent des Juifs » de telle sorte qu'on risque de croire que Faurisson en personne a utilisé ces mots dans l'un de ses écrits.
G. Karmasyn s'exprime avec difficulté et ne semble pas toujours comprendre ce qu'il lit. Il n'a manifestement pas saisi le sens ou la portée de certains extraits de Bernard Lazare, de Paul Rassinier ou, c'est un comble, d'un article du Bulletin quotidien de l'Agence télégraphique juive à propos du grand rabbin Sirat ; ce dernier, dès 1986, avait bel et bien décidé de se prononcer publiquement et ès qualités en faveur de la création d'une loi spécifique, à l'israélienne, contre la libre expression du révisionnisme historique. Surtout G. Karmasyn se répète jusqu'à l'étourdissement. Il pratique alors une sorte d'incantation qui le conduit à s'échauffer de plus en plus : ses mots se bousculent, sa vue se brouille et il donne l'impression de perdre la tête.
Enfin, lorsqu'un sujet l'embarrasse, il l'esquive par une pirouette. J'avais terminé mon commentaire de son premier article en lui disant : « Vous avancez que je suis antisémite. Puis-je vous demander si vous êtes juif ? ». Sa réponse avait été : « Qui est obsédé ? ». Voilà qui m'oblige de lui poser à nouveau la même question.

## La parole à Bernard Lazare et à Cicéron

Comme trop souvent dans les controverses, le sujet même de la dispute risque d'être perdu de vue. Dans le cas du Pro Flacco, ce serait particulièrement regrettable. Les quelques pages où Cicéron décrit les juifs sont d'une grande importance historique. Elles réduisent à néant la thèse, aujourd'hui si répandue, selon laquelle l'antisémitisme serait essentiellement une invention des chrétiens. Dans le Pro Flacco, on voit le plus grand des orateurs romains, dès avant l'ère chrétienne, dénoncer le comportement des juifs dans les termes mêmes où le feront, siècle après siècle, des auteurs prestigieux, que ceux-ci se trouvent être chrétiens, agnostiques ou athées, de gauche ou de droite et en quelque pays que ce puisse être où vit une communauté juive. Cicéron a, si l'on ose dire, fixé les traits du juif à la manière qui, plus tard, sera celle des « antisémites » les plus connus, qu'ils s'appellent Shakespeare, Voltaire, Dostoïevski, Drumont ou Céline. Les juifs, si prompts à se moquer de l'idée d'un « complot juif », sont eux-mêmes fortement enclins à dénoncer partout un « complot contre les juifs ». Il faut convenir que l'idée, en ces cas, de complot ou de conjuration (voyez le faux intitulé Les Protocoles des sages de Sion) est en elle-même totalement inadéquate. Il y a en fait non pas un « complot juif » mais un pouvoir juif, riche, comme tout pouvoir, de contradictions et de conflits ; ce pouvoir, cette puissance suscite obligatoirement des réactions d'une grande diversité et, parmi ces réactions, une possible hostilité. Le plus raisonnable est d'en conclure, comme l'a fait Bernard Lazare à la première page de son célèbre ouvrage sur L'Antisémitisme, son histoire et ses causes, publié en 1894 :
Si cette hostilité, cette répugnance même ne s'étaient exercées vis-à-vis des Juifs qu'en un temps et en un pays, il serait facile de démêler les causes restreintes de ces colères [contre les Juifs] ; mais cette race a été, au contraire, en butte à la haine de tous les peuples au milieu desquels elle s'est établie. Il faut donc, puisque les ennemis des Juifs appartenaient aux races les plus diverses, qu'ils vivaient dans des contrées fort éloignées les unes des autres, qu'ils étaient régis par des lois différentes, gouvernés par des principes opposés, qu'ils n'avaient ni les mêmes mœurs, ni les mêmes coutumes, qu'ils étaient animés d'esprits dissemblables ne leur permettant pas de juger également de toutes choses, il faut donc que les causes générales de l'antisémitisme aient toujours résidé en Israël même et non chez ceux qui le combattirent.
Pour Cicéron, dans le Pro Flacco, le mot de « juif » et celui d'« or » se conjuguent d'emblée : « auri Judaici », l'or judaïque. Puis, vient l'idée que les juifs s'entendent à la manigance et à l'intimidation. Ils savent s'unir pour peser d'un grand poids dans toutes les assemblées. Ils s'y déchaînent. Ils s'entendent à exciter la haine. Ils calomnient. Ils sont violents. Ils fraudent. Ils tournent les lois du pays. Ils n'ont d'attachement véritable que pour ce que Cicéron appelle leur « superstition », c'est-à-dire leur culte de l'or. Accessoirement, Cicéron constate que, pour ce procès où ils ont eu l'aplomb de prétendre que Flaccus leur avait pris leur or, les juifs sont venus en grand nombre dans ce prétoire où ils se conduisent avec l'arrogance de la tourbe. Ils ont obtenu avec d'autres qu'une formidable enquête fût entreprise contre Flaccus dans la province d'Asie et, pourtant, dit Cicéron, on a retrouvé dans le trésor public tout l'or prétendument volé aux juifs. Simplement, Flaccus avait, dans sa province, confisqué au profit du Trésor public l'or que les juifs avaient pris l'habitude d'exporter vers Jérusalem pour leur propre compte. Ils le faisaient aussi bien à partir de Rome et de toute l'Italie qu'à partir des provinces. A de multiples reprises ces exportations avaient été déclarées illégales mais les juifs s'étaient moqués de la loi. Flaccus, lui, avait pris l'initiative de faire appliquer la loi. Du coup, les juifs avaient crié au vol et avaient porté plainte contre le propréteur, dont la fonction principale était pourtant de faire appliquer les lois de Rome.
Sur les privilèges exorbitants arrachés par les juifs aux autorités romaines du temps de Cicéron et de César, on lira de Jules Isaac, qui passe bien trop rapidement sur le Pro Flacco, le chapitre intitulé : « La question juive à Rome » dans son célèbre ouvrage, Genèse de l'antisémitisme (Calmann-Lévy, 1985 [1956], p.94-98).
Un siècle plus tard, de tels privilèges allaient être suivis, comme on le sait, d'une catastrophe pour les juifs : en l'an 70 de notre ère, Titus prenait la ville de Jérusalem et en détruisait le Temple.
Dans bien des procès intentés par des organisations juives, en France et à l'étranger, j'ai personnellement constaté chez trop de juifs, jusque dans l'enceinte des palais de justice, cet aplomb, cette excitation, cette violence que Cicéron, un siècle avant notre ère, décrivait déjà. La tourbe n'a pas changé. Seul son pouvoir s'est accru. Elle ne devrait pas s'étonner des conséquences possibles d'un tel comportement. Il n'y a ni préjugé hostile, ni complot, ni conjuration à protester, à la fin des fins, contre ces manières. Aujourd'hui comme hier, aussi bien en notre temps qu'en celui de Cicéron, il est humain de se défendre contre toute tyrannie, même et surtout quand, comme c'est ici le cas, on voit cette dernière prendre dès l'abord le masque de la victime gémissante. Elle feint d'être en butte à la haine et à des agressions non provoquées, elle se couvre la tête de cendre, pousse des cris déchirants, alerte le monde entier, lance à grands frais campagnes et croisades. Puis, elle frappe sans pitié et sans répit. Ainsi qu'en toute guerre, elle ment à proportion.
Assurément, s'il revenait sur terre, l'illustre orateur romain n'aurait, pour ainsi dire, pas un mot à changer dans son bref discours sur les juifs, sur leur comportement et sur le destin qu'ils se forgent.

19 mars 2003

Labels: "Ecrits révisionnistes", Bernard Lazare, Cicéron, Gilles Karmazyn, Juifs, Rassinier, Rome antique, Samuel Sirat
