<!-- http://robertfaurisson.blogspot.com/1995/11/questions-jacques-verges-et-jacques.html -->

<!-- Wednesday, November 15, 1995 -->

Questions à Jacques Vergès et à Jacques Trémolet de Villers

Jacques Vergès, avocat de Klaus Barbie devant la cour d'assises du Rhône en 1987, et Jacques Trémolet de Villers, avocat de Paul Touvier devant la cour d'assises des Yvelines en 1994, se sont comportés avec courage et même avec panache. Personne n'a mis en doute leur talent d'avocat. K. Barbie, cancéreux, est mort en prison et P. Touvier, cancéreux, risque d'y mourir.

Placés dans une situation périlleuse, J. Vergès et J. Trémolet de Villers semblent n'avoir pas voulu aggraver leur propre cas en risquant le tout pour le tout dans la défense de leurs clients respectifs. Leur système de défense a été « de connivence » plutôt que « de rupture ». Ils n'ont pas fait montre d'une audace comparable à celle de leur confrère canadien Douglas Christie, le « battling barrister », qui, placé dans des conditions identiques, a bravé non seulement la fureur des médias mais aussi celle des juges. D. Christie que, dès 1985, je n'avais consenti à assister, devant les tribunaux de Toronto, qu'à la condition qu'il ne tiendrait aucun compte des interdits ou des tabous, a eu à défendre au Canada des hommes accusés de divers crimes contre les juifs (crime de révisionnisme dans le cas d'Ernst Zündel, « crimes contre l'humanité » dans le cas du Canadien d'origine hongroise Imre Finta, sans compter d'autres cas de même espèce). Son audace a consisté à exiger de l'accusation et des juges tout, absolument tout, ce qu'un avocat est en droit d'attendre, sans faire la moindre concession à l'esprit du temps qui veut que, dans de pareils procès, on se montre indulgent avec les témoins de l'accusation, accommodant sur la qualité des preuves, conciliant sur les règles de la procédure. Il se trouve, d'ailleurs, que D. Christie, au cours d'un exténuant combat de dix années, est parvenu jusqu'ici, soit à obtenir l'acquittement de ses clients, soit à leur éviter toute condamnation définitive ; il a même obtenu de la Cour suprême du Canada qu'elle déclare finalement contraire à la Constitution la loi qui avait permis l'atroce persécution judiciaire du révisionniste E. Zündel.

J. Vergès et J. Trémolet de Villers ont écrit, chacun de son côté, un livre sur le procès de leurs clients respectifs [1]. Dans ces livres, publiés après les verdicts, j'ai fait les mêmes constatations, lesquelles me conduisent à leur poser à peu près les mêmes questions au sujet du système de défense que les deux avocats ont adopté dans le prétoire.

K. Barbie était principalement accusé de complicité dans l'assassinat de cinquante juifs arrêtés à Izieu, internés à Lyon, transférés à Drancy, puis déportés, par d'autres que K. Barbie, vers l'Est où ils auraient tous été exterminés soit à Auschwitz, soit ailleurs. Quant à P. Touvier, il était principalement accusé de complicité d'assassinat de sept juifs fusillés, près de Lyon, à Rillieux-la-Pape.

En soi, ces accusations étaient graves mais ce qui leur donnait un caractère de gravité exceptionnelle, c'est que ces crimes étaient censés avoir été commis «dans le cadre du plan concerté d'extermination des juifs». Or, loin d'exiger, comme l'aurait fait D. Christie, qu'on leur prouve l'existence de ce plan abominable, les deux avocats en ont affirmé, avec insistance, la réalité. De quel droit ? Même une sommité de l'historiographie juive comme Raul Hilberg avait fini par écrire, deux ans avant le procès Barbie, que ce qu'il appelait « la destruction des juifs européens » s'était fait sans « plan préétabli » ; il ajoutait même qu'il n'y avait eu, pour mener à bien une aussi gigantesque entreprise criminelle, ni « agence unique », ni « organisme central chargé de diriger et coordonner à lui seul l'ensemble du processus », ni « organisme spécial », ni «budget particulier». L'explication de R. Hilberg tenait de la magie : il y avait eu « une incroyable rencontre des esprits, une consensuelle divination par télépathie au sein d'une vaste bureaucratie [2] ». La machine administrative allemande avait ainsi fonctionné à la communication de pensée !

Nos deux avocats ont agi comme s'ils avaient ignoré que, dès le début des années quatre-vingt, les historiens avaient renoncé aux fallacieuses explications du « génocide des juifs » par «l'ordre de Göring du 31 juillet 1941 [3] », par « la conférence de Wannsee » du 20 janvier 1942, par « l'opération Reinhardt », etc. Ces historiens du « génocide » des juifs avaient fini par se scinder en deux groupes : celui des « intentionnalistes », convaincus qu'il avait dû exister un ordre, introuvable, de Hitler d'exterminer physiquement les juifs, et le groupe, bien plus nombreux, des «fonctionnalistes», suggérant, sans aucune preuve, que tout avait dû se passer pour ainsi dire automatiquement, sans aucun ordre, sans aucun plan.

J. Vergès et J. Trémolet de Villers auraient pu, en dix minutes, démontrer que leurs clients respectifs ne pouvaient pas avoir agi « dans le cadre d'un plan concerté d'extermination » puisque celui-ci n'avait tout simplement pas existé. Prétendre que cet assassinat concerté de millions d'hommes avait effectivement eu lieu mais que leurs clients l'ignoraient n'était ni vrai ni vraisemblable.

Pourquoi les deux avocats, que j'avais mis ou fait mettre au courant des derniers acquis de la science historique la plus officielle, ont-ils, l'un et l'autre, tenu, en matière d'histoire (car ils ne se sont pas abstenus de considérations historiques sur le sujet !), des propos totalement périmés quant au « génocide » des juifs ? Pourquoi ont-ils refusé de déstabiliser une armada d'accusateurs qui ne craignaient rien tant que de voir révéler en plein prétoire, devant les médias assemblés, que les historiens spécialisés ne croyaient plus au « plan concerté de l'extermination des juifs » ?

J. Vergès est allé encore plus loin dans la défense «de connivence». Il n'a même pas exigé qu'on lui fournisse la preuve que les quarante-quatre enfants [4] et les six adultes d'Izieu avaient été assassinés. Pourquoi ? Il aurait fallu cinquante dossiers, témoignant, en particulier, de recherches menées en Allemagne auprès du Service international de recherches d'Arolsen-Waldeck sur le sort véritable de ces cinquante personnes. Par ailleurs, J. Vergès ne semble pas avoir insisté pour obtenir l'audition ou, à tout le moins, la déposition sous serment de Laja Feldblum, une responsable de la maison d'enfants d'Izieu, revenue de déportation et qu'on avait miraculeusement retrouvée en Israël. On a propagé la rumeur selon laquelle cette personne avait perdu l'esprit mais où sont l'expertise médicale et la contre-expertise sur l'aptitude ou l'inaptitude de L. Feldblum à témoigner ? Tous les procès comparables au procès Barbie reposent sur le scandaleux postulat israélien (voy. le procès Eichmann à Jérusalem en 1961) selon lequel, dans le cas des juifs, la déportation signifiait l'assassinat ; en conséquence, si la déportation est établie, on se dispense de prouver l'assassinat du déporté. Avec le cas de L. Feldblum, J. Vergès avait l'occasion de dénoncer ce postulat, adopté par la cour d'assises du Rhône, et de rappeler que les survivants juifs d'Auschwitz étaient encore si nombreux en 1987 qu'ils peuplaient toutes sortes d'associations en France et à l'étranger. Pourquoi ne l'a-t-il pas fait ? Enfin, où est l'expertise des locaux réputés avoir servi de chambres à gaz homicides, locaux dont certains qui sont soit « à l'état d'origine», soit à l'état de vestiges largement intacts, méritaient une enquête criminalistique [5] ?

Hors du prétoire, J. Vergès a déclaré à la télévision, en réponse à une question du journaliste Patrick Poivre d'Arvor, qu'« évidemment » les chambres à gaz nazies avaient existé. En est-il si sûr ? Il sait que j'ai personnellement de bonnes raisons de penser qu'il ne croit pas à ces « chambres à gaz ».

J. Trémolet de Villers n'a cessé d'affirmer l'existence du « plan concerté d'extermination des juifs ». Pourquoi l'a-t-il fait avec une telle insistance ? Et pourquoi a-t-il laissé le procès de Paul Touvier se dérouler, de bout en bout, sans exiger au préalable que la cour d'assises des Yvelines réponde aux conclusions qu'il avait déposées pour savoir quelle définition du crime contre l'humanité était retenue contre P. Touvier. Comment peut-on défendre un homme contre une accusation qui reste indéfinie [6] ?

Dans les siècles passés et, en particulier, de 1450 à 1650 mais aussi encore à la fin du XVIII^e^ siècle, les avocats des sorciers et des sorcières accusés d'avoir participé aux entreprises du Diable (avec ses pals, ses grils et ses fours) respectaient un interdit. Ils n'osaient mettre en cause le « plan concerté » entre le Malin et ses serviteurs. Aussi, tout en défendant leurs clients, cautionnaient-ils le système de persécution et de répression judiciaire qui allait condamner d'abord ces mêmes clients, puis bien d'autres accusés, par la suite, lors d'une infinité d'autres procès du même genre.

J. Vergès et J. Trémolet de Villers, en dépit, encore une fois, de leur courage et de leur talent, ont-ils fait mieux que leurs confrères des procès de sorcellerie ? Pourquoi ne se sont-ils pas battus comme leur prestigieux confrère canadien, D. Christie, lequel, sans entrer le moins du monde en conflit avec les règles en vigueur, a simplement exercé les droits, tous les droits, et les devoirs, tous les devoirs, de l'avocat ? [7]

Qu'on ne vienne pas prétendre que j'espérais voir les deux avocats français défendre la thèse révisionniste de la non-existence du « génocide » et des « chambres à gaz » ! Ils n'avaient, dans ces affaires, à ne prendre parti ni pour cette thèse ni pour son contraire. Or, ils ont pris parti pour la thèse officielle, celle que, depuis le 13 juillet 1990, défend la loi Sirat-Fabius-Gayssot.

L'essentiel des questions que je leur pose peut, au fond, se résumer dans l'interrogation suivante :

- Pourquoi avez-vous pris parti pour une thèse historique, celle de l'extermination physique des juifs ? Pourquoi, au surplus, avez-vous choisi de défendre, de facto, la forme la plus périmée de cette thèse, celle d'une extermination physique conduite selon un plan concerté ? Pourquoi, dans le cas de vos clients respectifs, n'avez-vous pas exigé que fussent observés tous les usages relatifs à l'administration des preuves, au contre-interrogatoire des témoins et au déroulement de la procédure, des usages qu'on voit normalement respecter aussi bien dans une affaire de simple vol par effraction que dans une affaire criminelle jugée en cour d'assises ?

J'ai lu de près les livres de ces deux éminents avocats français. J'espère, pour paraphraser Montaigne, qu'ils comprendront que mes questions, auxquelles j'aimerais avoir leurs réponses, sont celles d'« un lecteur de bonne foi ».

11 novembre 1995

_________

Notes

[1] J. Vergès, Je défends Barbie et J. Trémolet de Villers, L'Affaire Touvier.

[2] The Destruction of the European Jews, 1985, p. 53, 55, 62. La Destruction des juifs d'Europe, 1988, p. 51, 53, 60. « Thus came about not so much a plan carried out, but an incredible meeting of minds, a consensus-mind reading by a far-flung bureaucracy » (Ainsi se produisit-il non tant un plan mis à exécution qu'une incroyable rencontre des esprits, une consensuelle divination par télépathie au sein d'une vaste bureaucratie). Ces propos de R. Hilberg prononcés lors d'une conférence ont été rapportés par G. DeWan, « The Holocaust in Perspective », p. II-3. Au premier procès d'E. Zündel, en 1985, à Toronto, l'avocat D. Christie, que j'assistais, a obtenu confirmation de ces propos, et d'autres de même nature, de la bouche même de Raul Hilberg témoignant sous serment. Transcription du procès « Queen versus Ernst Zündel », 1985, p. 846-848.

[3] J. Vergès, op. cit., p. 152.

[4] De l'un d'entre eux, Hans Ament, Serge Klarsfeld n'hésite pas à écrire qu'il a été « assassiné à Sobibor ou à Maïdanek » mais, si on ne sait où est morte une personne, comment peut-on savoir si elle est morte et de quelle façon? (Les Enfants d'Izieu..., p. 39).

[5] De telles enquêtes ont été menées, à titre privé, par Fred Leuchter (USA), Germar Rudolf (Allemagne) et Walter Lüftl (Autriche). Leurs résultats ont confirmé le point de vue révisionniste sur les « chambres à gaz ». On attend toujours une enquête criminalistique, une « expertise de l'arme du crime », conduite par les adversaires des révisionnistes.

[6] Le 30 juin 1992, Éric Delcroix s'est trouvé dans la même situation. En plein prétoire, il a retiré sa robe d'avocat et n'a accepté de la reprendre qu'après que le tribunal de Fontainebleau eut clarifié sa position.

[7] D'une éloquence typiquement anglo-saxonne, c'est-à-dire dépourvue d'emphase, de grande taille et de belle prestance, D. Christie a toujours opposé un mépris de fer aux médias ; il refuse d'adresser la parole aux journalistes ou de répondre à leurs questions.

Labels: Douglas Christie, Hilberg, Izieu, Jacques Trémolet de Villers, Jacques Vergès, Klaus Barbie, Laja Feldblum, Loi Gayssot, Montaigne, Paul Touvier, Reinhardt, Rillieux-la-Pape, Wannsee
