<!-- http://robertfaurisson.blogspot.com/1993/06/primo-levi-sur-auschwitz.html -->

<!-- Tuesday, June 29, 1993 -->

Primo Levi sur Auschwitz

Son vrai témoignage en 1947 -

Son faux témoignage en 1976

Né à Turin en 1919, Primo Levi, qui a été interné à Auschwitz (plus exactement, à Auschwitz-Monowitz) de février 1944 à janvier 1945, est mort (accident ou suicide ?) à Turin en 1987. Ingénieur chimiste et écrivain, il est notamment connu pour avoir écrit Se questo è un uomo. Composé de décembre 1945 à janvier 1947, ce récit a été publié en 1947 par un obscur éditeur et réédité en 1958 par Einaudi. En 1961, la version française du récit a été éditée sous le titre de J'étais un homme, aux éditions Buchet-Chastel, dans une traduction de Michèle Causse. En 1987, une autre version française était publiée sous le titre de Si c'est un homme, aux éditions Julliard, dans une traduction de Martine Schruoffeneger ; s'y ajoutait un appendice rédigé en 1976, soit quelque trente ans après la composition du récit. C'est à cette dernière édition de 1987 que je me reporterai ici.

La différence est criante, et même choquante, entre, d'un côté, les quelque cent quatre-vingts pages du récit originel, composé juste après la guerre, et, d'un autre côté, les quelque vingt-cinq pages de l'appendice rédigé trente ans plus tard, pour, nous confie l'auteur, « l'édition scolaire de Si c'est un homme, afin de répondre aux questions qui me sont continuellement posées par les lycéens» ; l'auteur ajoute : «Mais comme ces questions coïncident dans une large mesure avec celles que me posent les lecteurs adultes, il m'a paru opportun d'inclure dans cette nouvelle édition le texte intégral de mes réponses.» Comme on va le constater, sur un même sujet Primo Levi a dit vrai en 1947 et a menti en 1976.

Son vrai témoignage en 1947

Le récit originel est poignant. Peu d'anciens internés d'Auschwitz et de ses sous-camps sont parvenus, comme P. Levi, à évoquer la déchéance physique et morale, les souffrances quotidiennes dues à la faim, à la soif, à l'épuisement physique, à la promiscuité, à la maladie, aux épidémies (de typhus, de dysenterie, de scarlatine), aux mauvais traitements des capos, que ceux-ci fussent des prisonniers de droit commun, des internés politiques, des internés résistants ou des juifs. Encore P. Levi a-t-il eu «la chance», comme il le dit dans la première phrase de sa préface, de n'être déporté à Auschwitz qu'en février 1944, c'est-à-dire à une époque où les conditions de vie s'étaient améliorées par rapport à l'année 1942 où le camp avait été ravagé par de graves épidémies de typhus. Son sort n'en sera pas moins détestable jusqu'au moment ― tardif ― où il sera employé comme chimiste. Les derniers jours seront à nouveau redoutables, surtout après le départ des Allemands, le 18 janvier 1945, et en attendant l'arrivée des Soviétiques, le 27 janvier. On sait que, le 18 janvier, les Allemands ont évacué le camp, emmenant avec eux vers l'intérieur de l'Allemagne tous les prisonniers valides (pour éviter que les Soviétiques ne les enrôlent dans l'armée ou dans l'industrie) ; ils ont également évacué, parmi les malades ou les bouches inutiles, tous les volontaires, y compris les juifs, qui préféraient partir avec les Allemands plutôt que d'attendre les Soviétiques ; tel fut le cas d'Élie Wiesel et de son père, ainsi que le rapporte l'intéressé dans La Nuit.

Après l'évacuation des Allemands, les prisonniers sont laissés à eux-mêmes ; le camp est touché par des obus ou des bombes soviétiques ; des baraques sont en flammes ; il n'y a plus ni eau ni électricité (les Soviétiques ont détruit la centrale électrique). L'auteur rapporte :

Une saleté indescriptible avait envahi toutes les parties du camp. Les latrines, que naturellement personne ne se souciait plus d'entretenir, étaient toutes bouchées, et les malades de dysenterie (plus d'une centaine) avaient souillé tous les coins [de l'hôpital-infirmerie], rempli tous les seaux, tous les bidons qui servaient pour la soupe, toutes les gamelles. On ne pouvait faire un pas sans regarder où on mettait les pieds ; il était impossible de se déplacer dans le noir. En dépit du froid qui était toujours intense, nous pensions avec horreur à ce qui arriverait en cas de dégel : les infections se propageraient sans recours possible, la puanteur deviendrait insupportable, et, la neige une fois fondue, nous resterions définitivement privés d'eau [1].

Les chambres à gaz dans le récit originel

Dans le récit originel, composé juste après la guerre, les chambres à gaz ou le gaz sont très rarement mentionnés ; toute précision sur l'emplacement de ces chambres, sur leur structure, sur leur fonctionnement, sur la nature du gaz employé et sur le rendement est absente ; pour commencer, à l'exception d'une seule occurrence, l'expression « chambre à gaz » n'apparaît qu'au singulier. Aucun interné, apparemment, n'a vu ni cette chambre à gaz, ni le Sonderkommando ; en effet, l'auteur écrit : « la fameuse chambre à gaz dont tout le monde parle [2] » , ou, sur le mode de l'interrogation : « C'est donc vrai ce qu'on raconte : les sélections, les gaz, le crématoire ? [3] » ou encore : « On parle du Sonderkommando [4]. » Il s'agit donc d'une rumeur, au demeurant très vague, dont on ignore si elle prend sa source dans une réalité quelconque.

Dans ce récit de 1947, j'ai relevé, en quelque cent quatre-vingt pages, huit occurrences de « chambre(s) à gaz » et de « gaz » (les mots importants sont en italique) :

- Ceux que le hasard faisait descendre du bon côté entraient dans le camp ; les autres finissaient à la chambre à gaz [5].

- Pour être soigné au K. B. [Krankenbau : hôpital-infirmerie], en effet, il faut être enclin à guérir, la propension contraire conduisant directement du K.B. à la chambre à gaz [6].

- Quand bien même aujourd'hui serait mon dernier jour, et cette chambre, la fameuse chambre à gaz dont tout le monde parle, que pourrais-je y faire [7] ?

- C'est donc vrai ce qu'on raconte : les sélections, les gaz, le crématoire [8] ?

- Tous les musulmans [internés atteints de cachexie] qui finissent à la chambre à gaz [...] [9].

- [La cloche sonne indiquant qu'il faut rester dans les baraques :] cela se produit quand il y a sélection pour que personne ne puisse y échapper, et quand les sélectionnés partent à la chambre à gaz pour que personne ne les voie partir [10].

- Beppo le Grec [...] qui partira après-demain à la chambre à gaz, qui le sait [...] [11].

- On parle de Sonderkommando, le Kommando spécial préposé aux chambres à gaz et aux fours crématoires, qui est lui-même périodiquement exterminé et tenu rigoureusement isolé du reste du camp [12].

Son faux témoignage en 1976

Dans l'appendice, rédigé environ trente ans après la guerre, les chambres à gaz ou le gaz sont, proportionnellement au texte, très souvent mentionnés ; des détails (il est vrai, plutôt vagues) sont donnés, qui concernent l'emplacement des chambres à gaz, leur structure, leur fonctionnement, la nature du gaz employé et le rendement ; dans toutes les occurrences, l'expression de « chambres à gaz » n'apparaît qu'au pluriel. Sauf en une occurrence [13], ces « chambres à gaz » sont présentées comme une réalité et non plus comme une rumeur ou un on-dit.

Dans cet appendice de vingt-cinq pages (environ trente pages si la typographie en était la même que pour le récit), j'ai relevé onze occurrences de « chambres à gaz » et de « gaz » (les mots importants sont en italique) :

- L'extermination méthodique et industrialisée de millions d'êtres humains, les chambres à gaz, les fours crématoires, l'exploitation abjecte des cadavres, tout cela devait rester caché et le resta effectivement pendant toute la durée de la guerre, sauf pour un nombre restreint d'individus [14]. »

- Au lieu d'« extermination » on écrivait « solution définitive », au lieu de « déportation » « transfert », au lieu de « mort par gaz », « traitement spécial » et ainsi de suite [15].

- Ces longues heures (et parfois ces longs jours) d'attente qui précédaient leur entrée dans les chambres à gaz [16].

- Les chambres à gaz étaient en effet camouflées en salles de douches, avec tuyauteries, robinets, vestiaires, portemanteaux, bancs, etc [17].

- Il suffit de rappeler que les chambres à gaz d'Auschwitz furent testées sur un groupe de trois cents prisonniers de guerre russes [18].

- Birkenau, qui alla jusqu'à contenir soixante mille prisonniers, dont quarante mille femmes, et où étaient installés les fours crématoires et les chambres à gaz [19].

- Vous remarquerez, par exemple, que je n'ai pas cité les chiffres du massacre d'Auschwitz, pas plus que je n'ai décrit le mécanisme des chambres à gaz et des fours crématoires ; cela parce que ce sont des données que je ne connaissais pas quand j'étais au Lager [camp de Monowitz], et que je n'ai possédées que par la suite, en même temps que tout le monde [20].

- A partir de 1941 environ, les Lager [camps] allemands deviennent de gigantesques machines de mort : les chambres à gaz et les fours crématoires avaient été délibérément conçus pour détruire des vies et des corps humains par millions : l'horrible record en revient à Auschwitz, avec vingt-quatre mille morts en une seule journée au mois d'août 1944 [21].

- [Ce massacre] n'épargnait même pas les enfants, qui furent tués par milliers dans les chambres à gaz, cas unique parmi toutes les atrocités de l'histoire de l'humanité [22].

- Le moyen même qui fut choisi (après de minutieux essais) pour opérer le massacre était hautement symbolique. On devait employer, et on employa, le gaz toxique déjà utilisé pour la désinfection des cales de bateaux et des locaux envahis par les punaises ou les poux [23].

- Les convois de victimes à envoyer aux chambres à gaz ou à évacuer des Lager [camps] proches du front avaient la priorité sur les trains militaires [24].

Différences entre le vrai et le faux témoignage

Un simple calcul arithmétique montre combien « les chambres à gaz » et les mentions de « gaz » ont proliféré entre le récit de 1947 et l'appendice de 1976. Supposons que le pluriel « chambres à gaz » implique l'existence de deux chambres à gaz. On obtient ainsi, pour un texte de cent quatre-vingts pages, neuf occurrences du mot « gaz », soit une mention pour vingt pages, tandis que, pour un texte de quelque trente pages, on relève vingt occurrences du même mot, soit une mention pour chaque page et demie. Ainsi le témoin a-t-il multiplié, au moins par treize, les « réalités » dont il prétend rendre témoignage. Cette inflation quantitative d'au moins 1300% s'accompagne, on l'a vu, d'une majoration qualitative tout aussi remarquable. Autant, dans le premier texte, la chambre à gaz est plutôt de l'ordre de la rumeur et, par conséquent, vague, autant, dans le second texte, l'auteur s'est efforcé de donner à ses chambres à gaz (toujours au pluriel) un peu de consistance physique.

Avant d'en venir à la description du processus qui conduit à transformer, avec le temps, un vrai témoignage en un faux témoignage, arrêtons-nous un instant sur une observation des plus simples : le cas, à lui seul, de P. Levi et l'expérience dramatique que ce juif a vécue de la résistance armée, de la déportation et de l'internement dans le camp d'Auschwitz, prouvent que les Allemands n'ont jamais pu avoir une politique d'extermination physique des juifs et n'ont jamais conçu, construit et utilisé des abattoirs chimiques pour mener à bien cette politique.

P. Levi était une preuve vivante qu'il n'y a pas eu de génocide

Si, comme on ose l'affirmer, les Allemands avaient pratiqué une politique d'extermination des juifs, ni P. Levi, ni tant d'autres juifs qui sont nés au camp d'Auschwitz ou qui y ont vécu, n'auraient survécu à la guerre. Un paradoxe veut même que sa qualité de juif ait valu à P. Levi le fait de n'avoir pas été fusillé peu après son arrestation le 13 décembre 1943. Comme l'écrit son ami Ferdinando Camon, « les fascistes l'avaient capturé en tant que partisan (il avait encore un pistolet sur lui), et il s'était déclaré juif afin de n'être pas fusillé immédiatement [conformément, ajouterons-nous, aux conventions internationales en vigueur]. Et c'est en tant que juif qu'il fut livré aux Allemands. Les Allemands l'envoyèrent à Auschwitz et ce fut Auschwitz qui fit de lui un écrivain [25]. » A Auschwitz, comme il le dira lui-même [26], c'est à peine s'il verra des SS. Assigné aux usines de Monowitz, il y sera blessé par la chute d'une poutrelle en fonte [27]. Il est hospitalisé. Au Krankenbau, où il est soigné, la soupe lui est servie au lit, il ne fait pas froid, il ne travaille pas, il peut faire la sieste [28]. Soit dit en passant, c'est là qu'on lui parle des « sélections » et des « gaz » ; un juif polonais le désigne à leurs camarades comme « l'Italien qui ne croit pas aux sélections [29] ». Il a la visite d'un compatriote, dont il dit : « [Il] a une très légère entérite, il est là depuis vingt jours, il s'y trouve bien, se repose et engraisse ; il se fiche pas mal des sélections et il a décidé de rester au K.B. jusqu'à la fin de l'hiver, coûte que coûte [30]. » P . Levi restera une vingtaine de jours au K.B. [31].

Le 11 janvier 1945, il contracte la scarlatine :

- Et [je] fus à nouveau hospitalisé au K.B. Infektionsabteilung [section des maladies infectieuses] : une petite chambre en vérité très propre, avec dix couchettes sur deux niveaux : une armoire, trois tabourets, et le seau hygiénique pour les besoins corporels. Le tout dans trois mètres sur cinq [32].

On lui administre de fortes doses de sulfamides [33], produit rare, à l'époque, en Europe. Il fera la connaissance d'un juif hollandais du nom de Lakmaker, âgé de dix-sept ans, grand, maigre, affable :

- Il était alité depuis trois mois et on se demande comment il avait échappé aux sélections [34]. Il avait d'abord eu le typhus, puis la scarlatine ; entretemps nous avions décelé chez lui une grave malformation cardiaque, et pour finir il était couvert d'escarres au point de ne pouvoir rester allongé que sur le ventre. Avec tout ça, un appétit féroce [35]. Lakmaker allait mourir quelques semaines après l'arrivée des Russes à l'infirmerie russe provisoire d'Auschwitz [36].

Il est évident que, si les Allemands avaient conduit une politique d'extermination physique des juifs, ils n'auraient pas, à Auschwitz, préservé la vie de P. Levi, ni celle de ce juif hollandais et, après la guerre, P. Levi n'aurait pas rencontré à Katowice des rescapés juifs comme Schenk et Alcalai [37] ou, à Dortmund, en Allemagne fédérale, le rabbin Mendi [38], décrit comme « fluet, fragile »[39] ; Mendi, « le rabbin moderniste », était venu de la Russie subcarpatique [40].

Le processus du faux témoignage

Selon un processus que j'ai observé chez de nombreux rescapés d'Auschwitz ou d'autres camps de concentration, P. Levi ne ment pas d'emblée mais se trouve graduellement conduit, entre 1947 et 1976, à mentir sur son expérience d'Auschwitz.

Pour commencer, cette expérience a été atroce, d'une atrocité vraie, quotidienne, sans rien de spectaculaire et, par conséquent, difficile à décrire. Le besoin de relater cette expérience et d'en faire sentir le caractère révoltant conduit à légèrement pimenter le récit d'inventions qu'en un premier temps on n'ose tout de même pas certifier vraies ; on se fait l'écho de rumeurs épouvantables qui enveloppent les réalités d'une sorte de halo sulfureux ; on crée une atmosphère ; on ne prétend pas avoir vu le diable mais on rapporte que d'autres l'ont vu.

Puis, les années passant, on s'en entretient avec d'autres survivants et surtout on lit ce qui s'est écrit sur le sujet ; on finit par intéresser des auditoires qui n'ont pas connu cette expérience, des auditoires à la fois complaisants et exigeants : d'une part, ils sont prêts à croire aux pires horreurs mais, d'autre part, il faut leur en fournir de toujours plus fortes, sous peine de les décevoir. C'est alors que, pour répondre à leur attente, on va puiser dans le fond d'une sorte de tradition écrite et orale. On va « enrichir » sa propre expérience de l'expérience supposée des autres et on va s'inspirer des ouvrages prétendument historiques et savants consacrés au sujet.

Peu à peu on en viendra ainsi à ne plus clairement distinguer entre ce qu'on a vécu et ce qu'on a trouvé chez autrui. Le petit mensonge deviendra un gros mensonge qui, lui-même, se mettra à enfler jusqu'à nourrir un mythe nécessaire aux chaudes retrouvailles entre gens qui ont subi les mêmes vraies souffrances et qui, par solidarité, se prêteront main forte dans la défense et l'illustration du récit de leur odyssée.

C'est le mensonge d'Ulysse.

Vrai témoin en 1947, P. Levi est, progressivement, devenu faux témoin en 1976.

Il a cédé à la tentation du mensonge d'Ulysse ; Paul Rassinier, lui, y a résisté [41].

29 juin 1993

Notes

[1] P. Levi, Si c'est un homme, p. 176.

[2] Id., p. 51.

[3] Id., p. 55.

[4] Id., p. 159.

[5] Id., p. 19.

[6] Id., p. 48.

[7] Id., p. 51.

[8] Id., p. 55.

[9] Id., p. 96.

[10] Id., p. 135.

[11] Id., p. 138.

[12] Id., p. 159.

[13] Id., p. 201.

[14] Id., p. 193.

[15] Ibid.

[16] Id., p. 198.

[17] Ibid.

[18] Ibid.

[19] Id., p. 199.

[20] Id., p. 201.

[21] Id., p. 201-202.

[22] Id., p. 202.

[23] Id., p. 209.

[24] Id., p. 210.

[25] F. Camon, « Chimie, Levi, la mort », Libération, 13 avril 1987, p. 29.

[26] P. Levi, op cit., p. 190.

[27] Id., p. 47.

[28] Id., p. 53.

[29] Id., p. 55.

[30] Id., p. 57.

[31] Id., p. 60.

[32] Id., p. 162.

[33] Id., p. 163.

[34] Sélection (en polonais du camp : « Selekcja ») : « Personne ne sait rien de précis, mais tout le monde en parle, même les ouvriers libres, polonais, italiens et français que nous rencontrions en cachette sur notre lieu de travail » (id., p. 133).

[35] Id., p. 179.

[36] Id., p. 186.

[37] Id., p. 186.

[38] Id., p. 204.

[39] Id., p. 73.

[40] Id., p. 111.

[41] Sur une invention un peu « forte » de P. Levi, on consultera Pierre Marais, En lisant de près les écrivains chantres de la Shoah. Primo Levi, Georges Wellers, Jean-Claude Pressac, Paris, La Vieille Taupe, 1991, p. 7-21.

Labels: Auschwitz, Birkenau, chambre à gaz, Primo Levi, Sonderkommando, Wiesel
