<!-- http://robertfaurisson.blogspot.com/2010/03/preface-de-grundlagen-zur.html -->

<!-- Friday, September 23, 1994 -->

Préface de "Grundlagen zur Zeitgeschichte" (Fondements pour l'histoire contemporaine)

Le révisionnisme historique est la grande aventure intellectuelle de la fin de ce siècle.

Malgré ses dimensions, le présent ouvrage n'offre qu'un aperçu de cette aventure ; aussi me paraît-il nécessaire de rappeler ici d'abord sur quel problème historique précis les révisionnistes ont concentré leurs recherches, puis comment le révisionnisme a pris naissance dans les années 40 et comment il s'est développé dans les années 50 à 78 ; enfin, comment il a vraiment pris son essor dans les années 78-79 pour connaître aujourd'hui une telle extension que, malgré les pires mesures répressives, plus rien ne semble devoir arrêter sa marche en avant.

Au procès de Nuremberg (1945-1946), l'Allemagne avait été jugée et condamnée pour des "crimes contre la paix", pour des "crimes de guerre" et pour des "crimes contre l'humanité". Or, par leurs découvertes successives sur ces trois points, les révisionnistes ont été en quelque sorte conduits à demander la révision du procès de Nuremberg. Sur les deux premiers points, les révisionnistes ont pu présenter leurs arguments sans trop de difficultés et il est probable qu'aujourd'hui aucun historien sérieux ne contestera qu'en matière de "crimes contre la paix" et de "crimes de guerre", l'Allemagne n'avait de leçon à recevoir de personne : il est, en effet, devenu évident que les Alliés ont, de leur côté, leur part de responsabilité dans le déclenchement de la guerre et qu'ils ont, de leur côté, commis d'innombrables "crimes de guerre" (si cette expression a un sens car la guerre elle-même peut être tenue pour un crime). En revanche, sur le troisième point, c'est-à-dire sur les "crimes contre l'humanité", l'Allemagne, nous répète-t-on encore à satiété, aurait eu l'exclusivité de l'horreur avec le "génocide des juifs". C'est sur l'étude de ce point précis que les révisionnistes ont concentré leurs efforts. Aussi, peu à peu, le révisionnisme historique est-il devenu ce que les Américains appellent maintenant Holocaust Revisionism.

Selon ses accusateurs, l'Allemagne ne se serait pas contentée de persécuter les juifs, de les déporter et de les mettre dans des camps de concentration ou dans des camps de travail forcé ; ces "crimes"-là ― tout historien le sait ― sont malheureusement fréquents dans l'histoire des hommes et il suffit aujourd'hui d'ouvrir son poste de télévision pour constater que toutes sortes de communautés humaines continuent à souffrir de tels "crimes". L'Allemagne, affirment encore ses accusateurs, serait allée beaucoup plus loin. Opérant un saut de géant dans l'horreur, elle aurait décidé vers 1941-1942 l'extermination totale des juifs européens et, afin de perpétrer ce crime spécifique, elle aurait mis au point et utilisé une arme spécifique : la chambre à gaz (ou le camion à gaz) homicide. S'aidant d'abominables abattoirs chimiques, elle aurait entrepris un assassinat collectif aux proportions industrielles. Ce crime (le génocide) et cette arme du crime (la chambre à gaz homicide) sont, en ce sens, indissociables et il est par conséquent impossible de prétendre, comme le font certains, que "chambre à gaz ou pas, il n'y a pas de différence fondamentale". L'Allemagne aurait, de cette manière, commis contre les juifs un crime intrinsèquement pervers. Les juifs ajoutent que le monde entier aurait, en connaissance de cause, laissé les Allemands perpétrer ce crime. Le résultat paradoxal d'une si vaste accusation est qu'aujourd'hui, dans le box des accusés, les "criminels" Hitler, Himmler et Goering sont rejoints par leurs "complices" : Roosevelt, Churchill, Staline, le pape Pie XII, le Comité international de la Croix-Rouge ainsi que les représentants de bien d'autres pays et instances. C'est ce qu'aux États-Unis, par exemple, de Los Angeles à Washington, on s'acharne à répéter dans les "musées de l'Holocauste" où les juifs d'aujourd'hui s'érigent en accusateurs du monde entier ; ils vont jusqu'à incriminer les responsables juifs qui vivaient durant la guerre en Europe, en Amérique ou en Palestine ; ils osent leur reprocher soit leur collaboration, soit leur indifférence, soit la mollesse de leurs réactions devant "l'extermination systématique" de leurs coreligionnaires.

Les premières rumeurs d'un gazage des juifs par les Allemands auraient circulé en décembre 1941 dans le ghetto de Varsovie [1]. Mais, pendant toute la guerre, de telles rumeurs n'ont trouvé qu'un faible écho dans les milieux hostiles à l'Allemagne. Il suffit de lire un ouvrage comme celui de Walter Laqueur, The Terrible Secret [2] pour se rendre compte que le scepticisme était général. Pendant la seconde guerre mondiale, on gardait encore un souvenir vivace des inventions de la propagande d'atrocités durant la première guerre mondiale où déjà se colportaient des histoires de gazages de populations civiles (dans des églises ou ailleurs) ainsi que des histoires d'usines à cadavres. Le Foreign Office ne voyait dans les nouvelles rumeurs de la seconde guerre mondiale que des inventions juives et beaucoup de milieux américains partageaient cette conviction [3]. Edward Benes, président (en exil à Londres) de la Tchécoslovaquie, déclarait en novembre 1942, après enquête de ses services, que les Allemands, contrairement à ce qu'on lui avait rapporté, n'exterminaient pas les juifs [4]. L'Américain d'origine juive, Felix Frankfurter, juge à la Cour suprême, déclarait sur le sujet à Jan Karski : "I can't believe you [5]". En août 1943, Cordell Hull, Secretary of State, prévenait par un télégramme l'ambassadeur US à Moscou qu'il convenait de supprimer dans le projet de déclaration commune des Alliés sur "les crimes allemands en Pologne" toute mention des chambres à gaz parce que, comme le faisaient remarquer les Britanniques, les preuves en la matière étaient insuffisantes ("insufficient evidence") [6].

Même après la guerre, de hauts responsables alliés, comme Eisenhower, Churchill et de Gaulle, allaient s'abstenir, dans leurs mémoires respectifs, de mentionner l'existence et le fonctionnement de chambres à gaz nazies.

D'une certaine manière, tous ces sceptiques étaient, à leur façon, des révisionnistes. Ni le Vatican, ni le Comité international de la Croix-Rouge, ni la Résistance allemande n'agirent comme s'ils ajoutaient foi à des rumeurs qui, d'ailleurs, prenaient les formes les plus fantastiques : invariablement les Allemands passaient pour exterminer les juifs mais les modes d'extermination étaient, eux, des plus variables : la vapeur d'eau, le gaz, l'électricité, le feu, l'acide, la piqûre d'air, la noyade, la pompe à faire le vide, etc. On ne sait trop exactement pourquoi, le gaz a fini par l'emporter sur le marché de cette Greuelpropaganda.

Le Français Paul Rassinier fut le premier véritable révisionniste d'après-guerre. En 1950, cet ancien déporté commença à dénoncer dans Le Mensonge d'Ulysse [7] et dans toute une série d'ouvrages le mythe des chambres à gaz . En 1976, l'Américain Arthur Robert Butz publia The Hoax of the Twentieth Century [8] qui constitue à ce jour l'ouvrage révisionniste le plus profond sur le sujet du génocide et des chambres à gaz. En 1979, un magistrat allemand, le Dr. Wilhelm Stäglich, publia à son tour Der Auschwitz Mythos, étude consacrée principalement à la manière dont les tribunaux allemands ont pu collaborer à la fabrication d'un mythe, un peu de la même manière que, dans le passé, les juges des procès de sorcellerie, surtout de 1450 à 1650, ont cautionné les récits les plus extravagants sur les pals, les grils et les fours de Satan [9].

Sans vouloir réduire l'importance majeure de P. Rassinier, d'A. R. Butz et de W. Stäglich, j'espère qu'on me permettra de dire qu'à la fin des années 70 le révisionnisme allait cette fois devenir matérialiste et scientifique avec les recherches menées sur le terrain par le Suédois Ditlieb Felderer ainsi qu'avec mes propres découvertes à Auschwitz même, avec mes considérations sur l'emploi du Zyklon B pour la désinsectisation (Entlausung) et avec mes réflexions sur l'utilisation, dans les chambres à gaz des pénitenciers américains, du gaz cyanhydrique pour exécuter des condamnés à mort. Ni P. Rassinier, ni A. Butz, ni W. Stäglich ne s'étaient rendus en Pologne sur les lieux supposés du crime et aucun d'entre eux n'avait pu encore vraiment utiliser dans toute leur étendue les arguments d'ordre physique, chimique, topographique et architectural qui aujourd'hui, à la suite des enquêtes de D. Felderer et de mes propres enquêtes, sont couramment employés par la plus jeune génération des chercheurs révisionnistes. Les chercheurs juifs, défenseurs de la théorie de l'extermination des juifs, étaient, eux, résolument demeurés ce que j'appelle des "historiens de papier" : Léon Poliakov et Raul Hilberg étaient restés dans le papier, dans les mots et dans le domaine des spéculations.

Il est surprenant que l'Allemagne, si riche en chimistes et en ingénieurs, et que les USA, eux-mêmes non dépourvus d'esprits scientifiques qui disposaient sur place de l'exemple de leurs chambres à gaz fonctionnant à l'acide cyanhydrique, n'aient pas aperçu le champ immense de l'argumentation proprement scientifique. En 1976, je découvrais à Auschwitz à la fois la configuration exacte des crématoires censés avoir contenu des chambres à gaz homicides, les chambres à gaz de désinsectisation (Entlausungsgaskammern) et les plans (jusque-là cachés) de certains crématoires. En 1978-1979, je publiais dans Le Monde [10] deux textes où je résumais certaines de mes découvertes. En 1979, à la première conférence de l'Institute for Historical Review, à Los Angeles, je présentais le détail de ces découvertes. Parmi mes auditeurs se trouvait Ernst Zündel, un Allemand établi à Toronto. A partir de 1985, ce dernier allait se révéler le plus ardent, le plus efficace et aussi ― beaucoup semblent l'ignorer ― l'un des esprits les plus novateurs parmi tous les révisionnistes. Il a été le premier à comprendre pourquoi j'insistais tellement sur l'argument chimique et, en particulier, sur l'importance, pour nous, de la technologie des chambres à gaz américaines dans les années 30 et 40. Il a compris pourquoi je souhaitais qu'un spécialiste de ces chambres à gaz américaines aille examiner sur place, en Pologne, les prétendues chambres à gaz d'exécution. Ayant, grâce à ma correspondance des années 70 avec les pénitenciers américains, découvert un tel spécialiste en la personne de Fred Leuchter, c'est E. Zündel, et lui seul, qui eut l'idée géniale de demander à ce dernier non seulement un examen des lieux mais un prélèvement d'échantillons de matériaux constituant, d'une part, les chambres à gaz de désinsectisation et, d'autre part, les prétendues chambres à gaz d'exécution. En février 1988, il prit le risque d'envoyer à ses frais en Pologne F. Leuchter et toute une équipe pour y étudier les prétendues chambres à gaz d'exécution d'Auschwitz, de Birkenau et de Majdanek. Le résultat de l'étude des lieux et de l'analyse des échantillons prélevés se révéla spectaculaire et totalement en faveur de la thèse révisionniste. Dans les années suivantes, d'autres rapports allaient confirmer la justesse du "rapport Leuchter" [11] : d'abord l'expertise, très savante, de Germar Rudolf [12], puis la contre-expertise, embarrassée et secrète, des Polonais [13] et enfin l'étude de l'Autrichien Walter Lüftl [14].

Il reste à dire que, si les accusateurs de l'Allemagne ne sont pas satisfaits de ces études, il leur est loisible de procéder eux-mêmes à leur propre expertise. Qu'attendent-ils, depuis cinquante ans, pour le faire au grand jour ?

Il faut comprendre le désarroi des accusateurs de l'Allemagne devant les succès du révisionnisme. Pendant un demi-siècle, ils ont sincèrement cru que la tragédie vécue par les juifs durant la seconde guerre mondiale avait été d'une gravité et d'une ampleur exceptionnelles alors que cette tragédie-là, ramenée à ses proportions réelles, c'est-à-dire sans génocide et sans chambres à gaz, s'inscrit parmi bien d'autres tragédies de cet atroce conflit. Leurs historiens ont dû progressivement admettre, sous la poussée des enquêtes révisionnistes, que, pour le prétendu génocide des juifs, on ne trouvait ni un ordre, ni un plan, ni un budget [15] ; que Wannsee n'était tout au plus qu'une "silly story" [16] ; qu'il n'existait aucune expertise de l'arme du crime concluant : "Ce local (soit intact, soit 'reconstruit', soit en ruines) a servi de chambre à gaz homicide" ; que pas une autopsie ne permettait de conclure : "Ce cadavre est celui d'un déporté tué par gaz-poison" ; que l'aveu de Rudolf Höss n'avait plus aucune valeur ("Höss was always a very weak and confused witness" [17]) ; que leurs prétendus témoins n'avaient probablement jamais vu de chambres à gaz ou de gazages puisque, en 1988, le meilleur d'entre eux, le fameux Rudolf Vrba, avait dû admettre devant un juge et un jury canadiens que, dans son fameux livre sur le sujet, il avait usé de la "poetic licence" ou "licentia poetarum" [18] ; que le savon juif n'avait jamais existé [19] ; que le chiffre de 4 millions de victimes à Auschwitz n'était qu'une fiction [20] ; et que les "sources for the study of the gas chambers are at once rare and unreliable […]. Besides, from 1942 to 1945, certainly at Auschwitz, but probably overall, more Jews were killed by so-called 'natural' causes [starvation, disease, sickness and overwork] than by 'unnatural' ones" [21]. Dès le 2 juillet 1982, à la fin d'un colloque international qu'ils avaient organisé à la Sorbonne (Paris) pour tenter de me donner la réplique, les exterminationnistes s'étaient révélés incapables de produire la moindre preuve de l'existence et du fonctionnement d'une seule chambre à gaz. En mai 1992, je lançais mon défi : "Show me or draw me a Nazi gas chamber" ! Jean-Claude Pressac, sur qui les exterminationnistes comptaient tant, s'était révélé incapable d'apporter autre chose que ce qu'il appelait des "indices du crime" et il s'était bien gardé de nous fournir une représentation physique totale de l'arme du crime [22].

Le 30 août 1994, je rencontrai dans son bureau, en présence de quatre témoins (deux de son côté et deux du mien), Michael Berenbaum, responsable scientifique de l'Holocaust Memorial Museum de Washington.

Je le contraignais à admettre que son musée ne contenait, paradoxalement, aucune représentation concrète d'une chambre à gaz nazie (la maquette du Krema II n'étant qu'une création artistique sans rapport avec la réalité). Je lui demandais pourquoi. Il finit par me répondre : "The decision had been made [by us] not to give any physical representation of the Nazi gas chambers". Sa réponse équivalait à celle d'un prêtre catholique ― M. Berenbaum est un théologien juif ― qui aurait décidé de supprimer dans son église toute représentation de la Croix. Pour en arriver à de telles extrémités, il faut se sentir aux abois.

Je pense que les coreligionnaires de M. Berenbaum finiront par abandonner la chambre à gaz comme ils ont abandonné le savon juif et les 4 millions d'Auschwitz.

Ils iront plus loin. Comme dans ces deux derniers cas, ils se présenteront en découvreurs du mythe et accuseront les Allemands, les Polonais ou les communistes d'avoir fabriqué le "mythe des chambres à gaz". Ils invoqueront alors à l'appui de leur impudente thèse les noms de juifs totalement ou partiellement révisionnistes (J. G. Burg, Jean-Gabriel Cohn-Bendit, Roger-Guy Dommergue, Arno Mayer, David Cole, Christopher Hitchens, Joel Hayward…). Ils se donneront le beau rôle.

Mais, en même temps, transformant l'"Holocauste" des juifs en une croyance religieuse, cette fois-ci débarrassée de tout contenu matériel, ils n'en seront que plus inflexibles pour dénoncer chez les authentiques révisionnistes des "négateurs" ou des "négationnistes", intolérants, sans cœur, bassement matérialistes et hostiles à la libre expression des sentiments religieux. Pour ces juifs, les vrais révisionnistes resteront donc diaboliques en esprit, même s'il faudra leur donner raison sur le plan des faits.

Les révisionnistes ne sont ni diaboliques ni négatifs. Ils n'ont rien de "l'esprit qui nie". Ils sont positifs. Ils affirment, au terme de leurs recherches ― qui sont de caractère positiviste ― que certaines croyances ne sont que des mythes. Ces mythes sont nocifs en ce qu'ils entretiennent la haine. Les révisionnistes s'efforcent de décrire ce qui s'est passé et non pas ce qui ne s'est pas passé. A la pauvre humanité, ils annoncent, somme toute, une bonne nouvelle. Recherchant la simple exactitude historique, ils se trouvent lutter contre la calomnie et pour la justice. Ils ont souffert et ils continueront de souffrir mais je crois qu'en fin de compte l'histoire leur donnera raison et leur rendra justice [23].

23 septembre 1994

------------------------------------------------------------------------

Ce texte constitue la préface de Grundlagen zur Zeitgeschichte, ouvrage collectif publié en 1994 sous la direction d'Ernst Gauss [Germar Rudolf] aux éditions Grabert de Tübingen. L'ouvrage fut saisi et pilonné tandis que le responsable et les auteurs de certaines contributions étaient condamnés. Germar Rudolf a connu, à cette occasion, sa troisième descente de police avec saisie de toutes ses archives et de tout son matériel informatique. Il s'est exilé à l'étranger avec sa famille. L'ouvrage est disponible sur Internet : http://www.vho.org/D/gzz.

Notes

[1] "Stockholm, Dec. 21 (JTA). More than 1,000 victims of spotted fever in the densely crowded Warsaw ghetto have been put to death by gas […], it is learned today from reliable sources" (Jewish Telegraphic Agency Bulletin, December 22, 1941, p. 1).

[2] The Terrible Secret/An Investigation into the Suppression of Information about Hitler's "Final Solution", London, Weidenfeld and Nicolson, 1980.

[3] Ibid., voy. "Foreign Office" dans l'index ainsi que p. 83, 91, 94, 116, 225, etc.

[4] Ibid., p. 162-163.

[5] "Je ne peux pas vous croire", Ibid., p. 237.

[6] Foreign Relations of the United States, Diplomatic Papers, US Printing Office, Washington, 1963, vol. 1 de 1943, p. 416-417 [http://digicoll.library.wisc.edu/cgi-bin/FRUS/FRUS-idx?type=article&did=FRUS.FRUS1943V01.I0012&id=FRUS.FRUS1943v01&isize=M].

[7] P. Rassinier, Le Mensonge d'Ulysse, La Librairie française, 1950 [http://www.vho.org/aaargh/fran/archRassi/prmu/prmu.html]. Voy. également Was ist Wahrheit ? Die Juden und das Dritte Reich, Druffel-Verlag, 1982, qui constitue la traduction d'une autre œuvre de P. Rassinier.

[8] A. Butz, The Hoax of the Twentieth Century/The Case against the presumed extermination of the Jews. Il convient de lire l'édition de 1993 qui contient, en trois suppléments distincts, les conférences prononcées par l'auteur en 1979, 1982 et 1992. Dans la conférence de 1982, je recommande l'éblouissante démonstration contenue dans les pages 350-362 autour de "l'histoire de l'éléphant invisible" (voy. RHR n° 2, août-octobre 1990, p. 87-137).

[9] W. Stäglich, Der Auschwitz-Mythos/Legende oder Wirklichkeit ? Eine kritische Bestandsaufnahme, Grabert-Verlag, 1979. L'ouvrage a été détruit sur ordre des autorités allemandes. Une seconde édition a été publiée en Grande-Bretagne : Der Auschwitz-Mythos [...], Historical Review Press, 1984. Dans les deux éditions, la documentation photographique provient de mes archives [edition française : http://vho.org/aaargh/fran/livres6/STAEGLICHmythe.pdf].

[10] Le Monde, 29 décembre 1978 et 16 janvier 1979 [http://robertfaurisson.blogspot.com/2000/05/trois-lettres-au-monde-1978-1979.html].

[11] F. Leuchter, An Engineering Report on the alleged execution gas chambers at Auschwitz, Birkenau and Majdanek, Poland, April 5, 1988, 193 p. [version française publiée par les Annales d'histoire révisionniste, n° 5, à http://www.vho.org/aaargh/fran/archVT/AHR/ahr2/rfl880609.html ]. Ernst Zündel a publié ce rapport avec une préface que j'ai rédigée le 23 avril 1988 [http://robertfaurisson.blogspot.com/1988/04/preface-au-rapport-leuchter-sur.html].

[12] Rüdiger Kammerer, Armin Solms, eds., Das Rudolf Gutachten, Cromwell Press, Londres, 1993 [http://vho.org/D/rga/index.html] ; la première édition de ce rapport est de 1991 [version française: http://www.vho.org/aaargh/fran/techniques/rapportRudolf1.html].

[13] Die offizielle polnische Antwort auf dem Leuchter-Bericht, traduit du polonais en allemand par T. Rudolph, distribué par E. Zündel (voy. note 11).

[14] Walter Lüftl, "Holocaust" in The Journal of Historical Review, 12, 4, hiver 1992-93, p. 391-420 [http://ihr.org/jhr/v12/v12p391_Luftl.html].

[15] En 1961, dans la première édition de The Destruction of the European Jews (Chicago, Quadrangle Books, p. 177), Raul Hilberg affirme tranquillement l'existence d'un ordre (et même de deux ordres consécutifs !) pour l'extermination des juifs. En 1985, dans la seconde édition de son livre (New York, Holmes and Meier), il change du tout au tout son explication des faits ; il ne mentionne plus aucun ordre ; il écrit qu'il n'y eut pas de "basic plan" (p. 53) et que "no single organization directed or coordinated the entire process [of destruction]" (p. 55) ; il ajoute : "No special agency was created and no special budget was devised to destroy the Jews of Europe" (p. 62). Il explique toute la prétendue entreprise d'extermination des juifs par… la transmission de pensée ou la divination par télépathie au sein de la bureaucratie allemande : "an incredible meeting of minds, a consensus-mind-reading by a far-flung bureaucracy" (propos tenus dans une conférence le 22 février 1983 et confirmés par R. Hilberg lors de son contre-interrogatoire au procès Zündel à Toronto en 1985, sténogrammes, p. 846-848) !

[16] Y. Bauer, professeur à l'Université hébraïque de Jérusalem, déclare exactement : "The public still repeats, time after time, the silly story that at Wannsee the extermination of the Jews was arrived at" (The Canadian Jewish News, 30 janvier 1992, p. 8, reproduisant une dépêche de la Jewish Telegraphic Agency).

[17] C. Browning, collaborateur de l'Encyclopædia of the Holocaust, à Christopher Hitchens, "Whose history is it ?", Vanity Fair, December 1993, p. 117. Le professeur a eu l'aplomb d'ajouter : "The revisionists use [R. Höss] all the time for this reason, in order to try and discredit the memory of Auschwitz as a whole."

[18] Procès Zündel à Toronto en 1985, sténogrammes, p. 1447-1448, 1636. Le livre en question est : R. Vrba, I cannot Forgive, Toronto, Bantam Books, 1964.

[19] Shmuel Krakowski, directeur des archives de Yad Vashem, et le professeur Yehuda Bauer ont fini par admettre en 1990 que "the Nazis never made soap from human fat" (The Jerusalem Post International Edition, 5 mai 1990). Dans un cimetière de Nice (France), un monument porte l'inscription suivante : "Cette urne renferme du savon à la graisse humaine fabriquée par les Allemands du IIIe Reich avec les corps de nos frères déportés".

[20] Pour Jean-Claude Pressac, le total des morts d'Auschwitz se situe, en chiffres ronds, entre 630 000 et 710 000 ; parmi ceux-ci il faudrait compter de 470 000 à 550 000 juifs gazés (Die Krematorien von Auschwitz/Die Technik des Massenmordes, Munich, Piper-Verlag, 1994, p. 202).

[21] Arno J. Mayer, The "Final Solution" in History, New York, Pantheon Books, 1988, p. 362, 365. L'auteur, d'origine juive, est professeur d'histoire à Princeton University (États-Unis).

[22] Il est remarquable que dans aucun de ses ouvrages J.-C. Pressac ne se hasarde, lui qui sait pourtant dessiner, à nous proposer une représentation concrète de la totalité d'une chambre à gaz avec l'explication de sa "technique and operation". Dans son énorme ouvrage Auschwitz: Technique and Operation of the Gas Chambers (New York, The Beate Klarsfeld Foundation, 1989), il dit qu'il n'existe pas de "direct proof" mais des "criminal traces" (des "indices du crime") ou des "indirect proof[s]" (p. 429).

[23] Un ouvrage de base, indispensable à l'étude du révisionnisme historique, est celui de l'avocate canadienne Barbara Kulaszka, Did Six Million Really Die ? Report of the Evidence in the Canadian "False News" Trial of Ernst Zündel ― 1988 [http://www.zundelsite.org/english/dsmrd/dsmrdtoc.html].

Labels: "Nuremberg", Butz, Germar Rudolf, Höss, Leuchter, Pressac, Rassinier, Vrba, Walter Laqueur, Zündel
