<!-- http://robertfaurisson.blogspot.com/1990/05/preface-au-second-rapport-leuchter.html -->

<!-- Tuesday, August 1, 1989 -->

Préface au second rapport Leuchter

Fred A. Leuchter est un ingénieur américain ; âgé de 46 ans, il vit près de Boston où il s'est spécialisé dans l'étude et la fabrication des systèmes d'exécution capitale dans certains pénitenciers de son pays. Il a notamment mis au point la modernisation de la chambre à gaz du pénitencier de Jefferson City (Missouri).

Ernst Zündel est allemand ; âgé de 50 ans, il vit à Toronto où, après une brillante carrière de graphiste et de publicitaire, qu'il a dû abandonner à cause de graves ennuis et du boycottage que lui ont valu ses opinions révisionnistes, il s'est presque entièrement consacré à la lutte contre le mensonge de l'« Holocauste». Je l'ai assisté dans cette lutte, notamment à l'occasion de deux procès qui lui ont été intentés à l'instigation d'une association juive du Canada, en 1985 et 1988. Le premier procès a duré sept semaines et s'est achevé par une condamnation à quinze mois de prison pour « publication de fausse nouvelle » (sic). Ce procès a été cassé en raison d'erreurs graves commises par le juge Hugh Locke. Le second procès a duré quatre mois et, cette fois-ci, E. Zündel a été condamné à neuf mois de prison par le juge Ron Thomas. Ce second procès pourrait, lui aussi, être cassé pour un motif identique.

En 1988, E. Zündel a demandé à F. Leuchter de se rendre en Pologne pour y examiner « les présumées chambres à gaz d'exécution » dans les trois camps d'Auschwitz, de Birkenau et de Majdanek. La conclusion de ce premier rapport Leuchter est formelle : il n'a jamais existé de telles chambres à gaz dans ces trois camps.

En 1989, E. Zündel a demandé à F. Leuchter de se rendre en République fédérale d'Allemagne pour y examiner « la présumée chambre à gaz d'exécution » de Dachau, près de Munich, ainsi qu'en Autriche pour y examiner, près de Linz, « les présumées chambres à gaz d'exécution » de Mauthausen et du château de Hartheim. La conclusion de ce second rapport, qu'on va lire ci-dessous, est tout aussi formelle : il n'a jamais existé de telles chambres à gaz en ces trois points d'Allemagne et d'Autriche.

On a dit du révisionnisme qu'il est la grande aventure intellectuelle de la fin de ce siècle. Cette aventure a commencé en réalité dès le lendemain de la seconde guerre mondiale avec la publication des travaux de Maurice Bardèche et de Paul Rassinier et s'est poursuivie avec la publication en 1976 de l'ouvrage magistral de l'Américain Arthur Robert Butz, The Hoax of the Twentieth Century, la publication en 1979 de Der Auschwitz Mythos de l'Allemand Wilhelm Stäglich et la première conférence internationale, en 1979 à Los Angeles, de l'Institute for Historical Review. Dans les années 80, grâce, en particulier, à l'action d'E. Zündel, le révisionnisme a connu un tel développement que, selon toute vraisemblance, les historiens de l'avenir parleront du révisionnisme historique avant et après E. Zündel. D'une certaine manière, ces deux actions judiciaires ― qui sont un déshonneur pour le Canada ― auront tout changé. E. Zündel avait promis en 1985 que son procès, même s'il devait le perdre, tournerait au procès du procès de Nuremberg et que les calomniateurs de l'Allemagne y connaîtraient leur Stalingrad. Il ne s'est pas trompé.

Avant Ernst Zündel

Contrairement à ce que s'imagine le grand public, jamais les accusateurs de l'Allemagne n'ont songé à prouver l'existence des chambres à gaz. Cette existence, ils l'ont tenue pour prouvée.

Selon Serge Klarsfeld lui-même :

Il est évident que dans les années qui ont suivi 1945 les aspects techniques des chambres à gaz ont été un sujet négligé parce que personne n'imaginait qu'un jour on aurait à prouver leur existence [1].

Lors des procès de Nuremberg, de Jérusalem, de Francfort comme lors de bien d'autres procès retentissants, dont celui de Klaus Barbie en 1987, on n'a pas davantage cherché à prouver l'horrible accusation qui continue de peser sur le grand vaincu. Ces mascarades judiciaires ont été comme des procès de sorcellerie où les accusés eux-mêmes et leurs avocats, à de rares exceptions près, n'ont pas pu ou n'ont pas voulu remettre en cause le tabou du siècle : celui de la magique chambre à gaz, laquelle défie toutes les lois de la physique et de la chimie. Même Jacques Vergès, courageux mais non héroïque, s'est gardé d'exiger la moindre preuve de l'existence des chambres à gaz auxquelles on ose prétendre que Klaus Barbie aurait envoyé les enfants d'Izieu.

Dans ces procès dits de « crimes de guerre » ou de « crimes contre l'humanité », des nations qui se disent civilisées ont bafoué les règles élémentaires de la criminalistique.

Pour illustrer ce point, prenons l'exemple d'un crime quelconque commis en France. Supposons dans ce cas l'existence d'une arme, d'un cadavre et d'un assassin (ou présumé tel). Sauf exception, la justice française pourra être amenée à exiger quatre rapports de routine :

1. une étude in situ (sur le terrain) de tout ce qui a pu être trouvé en fait de corps et d'objets suspects ;

2. une expertise de l'arme du crime ;

3. un rapport d'autopsie ;

4. un procès-verbal de la reconstitution du crime en présence de l'accusé.

A supposer que l'accusé soit passé aux aveux, jamais un magistrat ne décidera que, puisque aveu il y a, on ne souscrira pas à ces formalités. D'ailleurs un aveu n'a, par lui-même, pas grande valeur juridique ; l'aveu doit être vérifié et confirmé.

Or jamais, en près d'un demi-siècle, on n'a satisfait à ces exigences élémentaires quand il s'est agi, non pas d'un crime banal perpétré à l'encontre d'une seule personne avec une arme ordinaire (arme blanche ou arme à feu), mais d'un crime « sans précédent » censé avoir été perpétré à l'encontre de millions de personnes avec une arme extraordinaire qu'aucun juge n'avait encore vue de sa vie : la « chambre à gaz », véritable abattoir chimique aux prouesses industrielles.

Les premiers procès contre les Allemands accusés d'avoir été employés dans des camps munis de chambres à gaz ou de camions à gaz ont commencé à la fin de 1943 en Union soviétique (procès de Kharkov et de Krasnodar). Ils continuent à ce jour, spécialement en Israël avec le procès Demjanjuk. Or, encore aujourd'hui, après quarante-six ans de tels procès, on ne possède :

1. aucune étude in situ de tout ce qui a pu être trouvé en fait de corps et d'objets suspects ;

2. aucune expertise concluant que telle pièce ou tel camion a servi pour des gazages homicides ;

3. aucun rapport d'autopsie concluant à un assassinat par gaz-poison ;

4. aucun procès-verbal de reconstitution (ou simulacre) d'une opération de gazage homicide.

Dans le cadre d'un procès dit du Struthof-Natzweiler (Alsace), il y a bien eu expertise de la « chambre à gaz » et autopsie des cadavres de « gazés » conservés à l'hôpital civil de Strasbourg, mais, dans un cas comme dans l'autre, le professeur René Fabre, toxicologue, a conclu négativement. Dans le cas de Dachau, il y a bien eu une forme d'expertise conduite par le capitaine Fribourg, de l'Armée française, mais, alors que le rapport concluait à la nécessité de poursuivre l'examen de la pièce baptisée provisoirement « chambre à gaz », cet examen n'a pas été poursuivi.

Au cours de l'instruction du procès intenté à Rudolf Höss et à d'autres responsables du camp d'Auschwitz, le juge d'instruction Jan Sehn a confié à l'Institut d'expertises judiciaires de la rue Copernic, à Cracovie, l'étude de six fermetures en zinc censées provenir de ce qu'il appelait les orifices de ventilation de la chambre à gaz du Krematorium-II à Birkenau. S'y ajoutait l'expertise de 25,5 kg de cheveux ainsi que d'objets métalliques mêlés à ces cheveux. La présence d'acide cyanhydrique ou de ses composés avait été constatée (Rapports d'expertise du Dr Jan Z. Robel en date du 15 décembre 1945). Rien là que de très normal. Les Allemands utilisaient souvent l'acide cyanhydrique, sous la forme de Zyklon B, pour désinfecter locaux, vêtements, objets. En Pologne, comme dans toute l'Europe en guerre, on collectait les cheveux jusque dans les salons de coiffure pour la confection de textiles, après désinfection. Mais le paradoxe est que, disposant d'un tel institut de recherches, la justice polonaise n'a jamais, apparemment, procédé aux recherches élémentaires dans les pièces qualifiées de « chambres à gaz » homicides.

Des transports de justice ont bien eu lieu à l'occasion de certains procès et notamment celui de Francfort (1963-1965). Le scandale est qu'on y a examiné certains points du camp d'Auschwitz mais non les prétendues chambres à gaz qui étaient pourtant là, soit en l'état d'origine (sic), soit à l'état de ruines tout à fait parlantes [2].

Une reconstitution, qui est par définition un simulacre, aurait été facile à réaliser à Birkenau et elle aurait immédiatement fait apparaître le caractère grotesque des accusations de gazage. On tourne parfois à Birkenau des films hollywoodiens prétendant retracer l'arrivée de convois de juifs sur la rampe de Birkenau, à proximité des bâtiments des crématoires censés contenir (a) un vestiaire de déshabillage des victimes ; (b) une chambre à gaz homicide ; (c) une salle contenant cinq fours crématoires à trois bouches chacun. Chaque fournée de victimes s'élevait, nous dit-on, à 2.000 personnes et il y avait plusieurs fournées par jour pour chaque crématoire. La reconstitution donnerait lieu immédiatement à de fantastiques embouteillages vu la dimension des bâtiments et la configuration des alentours. L'engorgement des crématoires serait spectaculaire : à supposer qu'il faille une moyenne d'une heure et demie pour incinérer un cadavre, on se retrouverait encore, au bout de ce laps de temps, avec 2.000 ― 15 = 1.985 cadavres sans aucun emplacement pour les entreposer avant leur incinération ! La « machinerie de mort » s'arrêterait dès le premier gazage. Il faudrait huit jours et huit nuits pour incinérer ces 2.000 cadavres ; encore un four crématoire ne peut-il pas fonctionner ainsi jour et nuit en continu.

Venons-en à la question des témoins. Dans tous ces procès, des personnes sont venues se présenter en témoins vivants de l'« Holocauste » et des chambres à gaz. Comment ces personnes avaient-elles, pour leur propre compte, échappé aux chambres à gaz ? Leur réponse était bien simple : elles avaient toutes uniformément bénéficié d'un miracle. Chaque survivant était un miraculé ; le plus souvent, comme il était passé successivement par plusieurs camps d'extermination, ce survivant représentait même à lui seul une somme de miracles. Les membres des « Sonderkommandos » battaient tous les records ; normalement, selon leur récit, les Allemands les gazaient eux aussi tous les trois mois, ce qui fait qu'au bout du compte, deux ans de séjour à Auschwitz et Birkenau pouvaient représenter pour ces personnes un total de sept ou huit miracles consécutifs. Il est rare que des avocats ou des magistrats aient osé marquer leur surprise devant cette prolifération de miracles. Le champion de la chambre à gaz, Filip Müller (l'immortel auteur de Trois ans dans une chambre à gaz d'Auschwitz), eut quelques ennuis avec le tribunal de Francfort à ce sujet, mais il trouva la parade : l'histoire de la liquidation chronique des membres du « Sonderkommando » n'était, voulut-il bien reconnaître en grand seigneur, qu'une légende. Il est consternant que le grand public, les historiens et les magistrats se laissent à ce point abuser par les prétendus témoins de l'« Holocauste ». Simone Veil se présente généralement en témoin vivant et en preuve vivante de l'extermination des juifs à Auschwitz ; or, si elle est la preuve vivante de quelque chose, c'est bien de ce que les Allemands n'exterminaient pas les juifs à Auschwitz. Simone Veil, sa mère et l'une de ses sœurs ont toujours été ensemble : à Drancy, à Auschwitz, à Bobrek (sous-camp d'Auschwitz) et à Bergen-Belsen ; c'est dans ce dernier camp qu'elles ont eu à souffrir du typhus ; la mère de S. Veil en est morte ; elle avait, ainsi que ses deux filles, survécu à Auschwitz ; une autre de ses filles survécut à Ravensbrück.

Personnellement, je n'appelle pas « témoin » celui qui se présente comme tel, à moins qu'il n'ait passé victorieusement devant un tribunal l'épreuve du contre-interrogatoire sur la matérialité même des faits qu'il rapporte.

Je demande qu'on me lise ici avec attention : en aucun procès un prétendu témoin de « gazages » n'a été contre-interrogé sur la matérialité même d'un gazage auquel il disait avoir participé ou assisté. Même dans le procès des Allemands Tesch et Weinbacher, condamnés à mort et exécutés pour avoir fabriqué ou vendu du Zyklon B, le témoin Charles Sigismond Bendel a échappé à ce type de contre-interrogatoire [3]. Les avocats ont eu pour principe et pour ligne de défense d'éviter le tabou de la chambre à gaz et de se contenter de dire que leurs clients, eux, n'avaient gazé personne.

Après Zündel

Avec l'arrivée d'E. Zündel, le voile de toutes ces impostures s'est déchiré.

Cet homme a eu l'audace de ne pas se laisser intimider. Il a montré que le roi était nu. Il a confondu les fripons. Les experts et les témoins de l'accusation ont essuyé là une sévère défaite. Et E. Zündel, passant à la contre-offensive, a administré une superbe leçon aux historiens et aux magistrats : il leur a montré comment il aurait fallu faire. Il aurait fallu en quelque sorte commencer par le commencement, ce qui, comme on le sait, est parfois difficile à faire. Cherchant d'abord et avant tout à établir la matérialité des faits, il a envoyé à ses frais en Pologne un expert des chambres à gaz et son équipe. Cet expert a prélevé des échantillons des sols, des murs, des plafonds de ces prétendues chambres à gaz et il les a fait analyser par un laboratoire américain.

J'ai raconté ailleurs comment experts et témoins de l'accusation ont été mis à mal lors des procès de 1985 et de 1988 à Toronto [4]. Je n'y reviendrai pas. Je voudrais seulement préciser ici qu'il ne s'agit pas là de ma part d'un jugement subjectif. La preuve que je dis vrai réside dans le fait qu'au procès de 1988 l'expert numéro un de l'exterminationnisme, le professeur Raul Hilberg, a refusé de revenir témoigner tant il gardait un cuisant souvenir de sa défaite de 1985 : il l'avoue dans une correspondance qui aurait dû rester confidentiellemais dont nous avons eu vent et qu'il a bien fallu révéler. Quant au Dr. Rudolf Vrba et autres témoins de 1985, ils ne sont pas non plus revenus au procès de 1988 ; le procureur Pearson, prié par le juge Thomas de dire s'il viendrait des « survivants », a dû répondre piteusement (j'étais présent) qu'il n'en viendrait pas cette fois-ci. Par pitié pour eux, je n'évoquerai pas ici en détail, comme je l'ai déjà fait dans l'article susmentionné, les prestations en 1988 de l'expert Charles Biedermann, un homme honnête apparemment et intelligent mais mal préparé, et du professeur Christopher Browning qui, lui, devait donner une triste image de ce que peuvent être certains universitaires américains : ignorances confondantes, naïveté sans bornes, goût de l'argent et absence de scrupules ; voilà un professeur d'université qui n'a pas hésité à se faire payer cent cinquante dollars de l'heure par le contribuable canadien pour venir à Toronto accabler un homme ― E. Zündel ― en raison d'une opinion, et contribuer à le jeter en prison : le crime d'E. Zündel était d'avoir publié au Canada une étude vieille de quatorze ans (Did Six Million Really Die?), librement diffusée en Grande-Bretagne et dans la patrie même de Ch. Browning : les États-Unis.

A mes yeux, l'un des principaux mérites du premier rapport Leuchter aura été de rendre éclatant le simple fait... qu'aucune expertise de l'arme du crime n'existait encore. Depuis que ce rapport a été révélé, en avril 1988, il ne s'est pas trouvé une seule personne, y compris parmi celles qui manifestaient leur fureur, pour lui opposer un autre rapport qui aurait été établi dans le passé (je ne parle pas, bien entendu, des expertises ordonnées par le Polonais Jan Sehn, qui ont esquivé le sujet). Quant à ceux qui critiqueraient des points de ce rapport, je les invite à établir ou à faire établir leur propre rapport et nous comparerons. Il reste encore une solution préconisée par F. Leuchter lui-même dans sa conférence de février 1989 à Los Angeles lors du 9e congrès international de l'Institute for Historical Review : la constitution d'un comité international d'experts sur le problème des chambres à gaz. Dès 1982, l'historien français Henri Amouroux, que j'avais mis au courant de mes propres recherches, me confiait qu'il souhaitait cette solution ; il me disait en propres termes que, ce qu'il appelait de ses vœux, c'était une « commission internationale et surtout pas nationale » tant, en France, à son avis, les spécialistes manquaient d'ouverture d'esprit sur la question des chambres à gaz.

Les autorités polonaises, à moins d'un brusque appétit de « glasnost », s'opposeront de toutes leurs forces à une enquête de ce genre, comme elles s'opposent à tout accès normal aux archives du musée d'Auschwitz et, en particulier, aux registres de décès (Totenbücher) laissés par les Allemands et qui permettraient de se faire une idée du nombre réel des morts d'Auschwitz : « Si nous faisions des fouilles et si nous ne trouvions aucune preuve de l'existence de chambres à gaz, les juifs nous accuseraient, nous autres Polonais, d'avoir supprimé les traces » : telle fut la réponse en 1987 de Tadeusz Iwaszko, directeur des archives du musée, au journaliste français Michel Folco, et cela en présence du pharmacien Jean-Claude Pressac, ami de Serge Klarsfeld.

Il est probable que le premier rapport Leuchter restera longtemps le premier et le dernier mot sur la question des chambres à gaz d'Auschwitz, de Birkenau et de Majdanek. Il a certainement ses défauts puisque, aussi bien, il s'agit de l'œuvre d'un pionnier en la matière et qu'on n'a jamais encore vu de pionnier éviter toute possibilité d'erreur, mais il a le mérite d'ouvrir un champ de recherches particulièrement fertile.

Le second rapport Leuchter

Le second rapport Leuchter constitue, lui aussi, une œuvre de pionnier mais, cette fois-ci, sur la question des chambres à gaz de Dachau, de Mauthausen et de Hartheim.

Je n'avais pas accompagné F. Leuchter et son équipe à Auschwitz, Birkenau et Majdanek. C'est moi qui avais eu l'idée, en 1977, de préconiser l'étude des chambres à gaz américaines (utilisant l'acide cyanhydrique) pour montrer l'absurdité des prétendues chambres à gaz allemandes (utilisant le Zyklon B, un insecticide qui est aussi essentiellement de l'acide cyanhydrique aussi). J'espérais, sans trop y croire, qu'un jour un spécialiste des chambres à gaz américaines pourrait se rendre à Auschwitz pour y réaliser l'expertise physique et chimique qui aurait dû être conduite dans toute enquête juridique ou historique normale. En 1979, lors du premier congrès international de notre Institute for Historical Review, je m'étais ouvert de cette idée auprès de quelques personnes et, en particulier, d'Ernst Zündel. Dans les années qui suivirent, j'abandonnai tout espoir. Il faut dire que, même auprès des révisionnistes, je ne trouvais pas grand intérêt pour mon idée, qui peut-être paraissait trop hardie ou trop chimérique. E. Zündel, lui, n'abandonna ni cette idée, ni l'espoir de réussir. Dans la préface du premier rapport Leuchter, j'ai raconté comment, grâce à lui et à l'avocate canadienne Barbara Kulaszka, j'ai pu rencontrer à Boston l'ingénieur F. Leuchter et comment s'organisa l'expédition polonaise.

Pour l'expédition en RFA et en Autriche, je faisais partie de l'équipe de Fred Leuchter. Dans le rapport qu'on va lire, ce dernier nous livre évidemment toutes les informations nécessaires sur les membres de cette équipe et sur la nature et le résultat de sa mission.

Dachau

De 1945 à 1960, la propagande des Alliés et leurs tribunaux nous avaient certifié que des chambres à gaz homicides avaient fonctionné à Dachau, à Mauthausen et à Hartheim. Apparemment, ni les preuves, ni les témoins, ni les aveux ne manquaient.

On insistait particulièrement sur la chambre à gaz de Dachau et sur ses victimes. La propagande américaine avait été si tonitruante que, s'il existe aujourd'hui un pays au monde où les gazages de Dachau passent pour être aussi avérés que les pyramides d'Égypte, ce sont bien les États-Unis.

Au procès de Nuremberg, une journée décisive avait été celle de la projection d'un film sur les camps de concentration allemands où le summum de l'horreur avait été atteint avec une vue de la chambre à gaz de Dachau : le commentateur expliquait le fonctionnement de la machinerie qui était censée gazer « probablement cent personnes à la fois ». On ne dira jamais assez combien ce film ― d'une longueur de six mille pieds « choisis » sur quatre-vingt mille pieds ― a frappé les imaginations, y compris celles de la plupart des accusés allemands. Il est probable que, plus que tout l'ensemble du procès, les deux événements qui ont le plus contribué à exciter l'opinion contre les vaincus ont été, d'abord, la projection de ce film, puis l'espèce de confession publique, devant le tribunal, du témoin Rudolf Höss, « le commandant d'Auschwitz ». Aujourd'hui, l'on sait que cette confession avait été « dictée » : la substance en avait été inventée par l'imagination malade d'un juif britannique qui avait fait partie des arrestateurs et des tortionnaires de Rudolf Höss [5].

Mais l'histoire des gazages de Dachau, elle aussi, avait été fabriquée de toutes pièces et il fallut attendre 1960 pour que les défenseurs de l'« Holocauste » en conviennent. Le 19 août 1960, dans Die Zeit, Martin Broszat reconnaissait qu'il n'y avait jamais eu de gazage homicide dans ce camp. Cet historien, deux ans auparavant, avait, pour sa courte honte, publié la « confession » de Rudolf Höss en la présentant comme authentique et digne de foi : il s'agissait cette fois-là des mêmes aveux, pour l'essentiel, que ceux obtenus par les Britanniques mais, comme ces derniers avaient entre-temps livré Höss aux communistes polonais, la version Broszat n'était rien d'autre qu'une concoction et une amélioration à la sauce polonaise des inventions britanniques ! (En 1972, Martin Broszat allait devenir directeur de l'Institut d'histoire contemporaine de Munich).

Aujourd'hui, tout visiteur de la chambre à gaz de Dachau peut lire sur un panneau amovible l'inscription suivante en cinq langues :

CHAMBRE A GAZ ― « chambre de douche » camouflée ― ne fut jamais utilisée.

[La version anglaise est plus explicite (depuis quelques années) :

GAS CHAMBER ― disguised as a "shower room" ― never used as a gas chamber].

Comme ce panneau est mobile, les cinéastes en mal de sensations peuvent le retirer et filmer ou photographier la pièce sous tous les angles en persistant à dire qu'il s'agit d'une chambre à gaz qui a effectivement servi à gazer des détenus.

Je ne sais s'il faut admirer ici le cynisme des autorités du musée de Dachau ou la naïveté des visiteurs. La formule du panneau n'a aucun sens dans la réalité. En 1980, dans mon Mémoire en défense contre ceux qui m'accusent de falsifier l'histoire, [6] je pense en avoir fait la démonstration. J'y raconte comment j'ai réduit à quia Barbara Distel, responsable du musée, et le Dr Guerisse, président (aujourd'hui décédé) du Comité international de Dachau, sis à Bruxelles. Quand on demande à ces personnes comment il se fait que les Allemands n'aient pas trouvé le temps de terminer cette petite chambre à gaz commencée en 1942, la réponse est que les détenus employés à la construction ont saboté ou boycotté le travail. Mais comment ces détenus, qui jamais de leur vie n'avaient pu voir une arme qui n'existait nulle part au monde (une chambre à gaz pour cent personnes à la fois), pouvaient-ils savoir, dès le début des travaux, qu'une fois ces travaux achevés on aurait là une chambre à gaz homicide ? S'agit-il là d'un miracle de la divination personnelle et de la transmission de pensée ? Les détenus, pendant trois ans, s'étaient-ils passé le mot ? Les Allemands leur avaient donc confié une mission ultra-secrète sans se soucier de la mener à bien ? Et puis, comment Barbara Distel et le Dr Guerisse savent-ils qu'il s'agit d'une chambre à gaz inachevée ? Peuvent-ils nous énumérer ce qui manque pour que d' « inachevée » cette chambre à gaz devienne « achevée » ? Où ont-ils puisé leurs connaissances techniques? Ont-ils déjà vu des chambres à gaz « achevées » ? Où et quand ?

Lors de notre visite du 9 avril 1989, nous avons, Fred Leuchter, Mark Weber et moi-même été filmés par Eugen Ernst d'abord dans la chambre à gaz, puis, à la sortie de celle-ci, sur une esplanade en plein air. C'est sur cette esplanade que nous décidions d'enregistrer nos commentaires de la visite. Les touristes qui venaient eux-mêmes de visiter la « chambre à gaz » nous apercevaient et quelquefois s'arrêtaient et prêtaient l'oreille. F. Leuchter put faire son rapport en paix, à un léger incident près, provoqué par un touriste qui, sur un ton agressif, me demanda si nous n'étions pas en train de douter de la réalité de cette chambre à gaz. J'éludais sa question et il s'éloigna. Quand vinrent mon tour et celui de Mark Weber de commenter notre visite devant la caméra, les touristes commencèrent à s'attrouper en trop grand nombre. Certains se montraient déjà un peu nerveux. Nous aurions pu interrompre notre rapport et le poursuivre en un autre point du camp. Je décidais de rester sur place et d'exploiter la situation. Après tout, nous avions là en face de nous un public rêvé : tous ces gens venaient de « voir une chambre à gaz » et risquaient de raconter ultérieurement à leurs amis : « On ne saurait contester l'existence des chambres à gaz ; j'en ai vu une moi-même à Dachau. » J'engageais donc avec les visiteurs une sorte de débat improvisé. Je leur faisais notamment remarquer qu'ils n'avaient nullement visité une chambre à gaz mais un local que Madame Barbara Distel, directrice du musée, baptisait de ce nom. Cette dame se permettait là une grave accusation à l'appui de laquelle elle n'apportait aucune preuve (les quelques photos ou papiers affichés dans une pièce précédant la chambre à gaz ne démontraient rien du tout). Mais qui osait lui demander des preuves ? Apparemment personne. Je mettais ces touristes en garde contre la tentation d'aller raconter à leur entourage qu'ils avaient vu à Dachau une chambre à gaz ; en réalité, ils n'avaient rien vu de tel. Sur ma lancée, je leur révélais qu'il n'y avait eu, pour nous autres révisionnistes, aucune chambre à gaz homicide, y compris à Auschwitz, ni aucune politique d'extermination des juifs. Le tout prit l'allure d'une sorte de happening. Certains visiteurs se montraient hostiles, d'autres favorables ; tous paraissaient soit indignés, soit intéressés. Un jeune Allemand estima que, pour de tels propos, je méritais la prison. Les plus hostiles trouvèrent l'échappatoire habituelle : « Chambres à gaz ou pas, cela revenait au même » : argument qu'un Français ne peut que trouver étrange vu qu'en France Jean-Marie Le Pen a été lourdement condamné par les tribunaux, à la requête d'organisations juives, pour avoir précisément dit cela.

La magique chambre à gaz est le pilier central de la religion de l'« Holocauste ». Ce ne sont pas les révisionnistes qui, des chambres à gaz, font toute une affaire mais les tenants de cette religion ; c'est donc à ces derniers qu'il faut demander des explications sur leur attachement à la chambre à gaz. Ils sont d'ailleurs logiques dans leur raisonnement ; sans elle, c'est-à-dire sans le système de destruction spécifique, il devient impossible de prouver l'existence d'une destruction systématique et spécifique des juifs. Sans chambre à gaz, il n'y a plus de génocide. Et, sans génocide, l'histoire de la communauté juive ressemble à l'histoire de toute autre communauté humaine en proie aux horreurs de la seconde guerre mondiale.

Eugen Ernst a su filmer une bonne partie de ce happening qui m'a permis de donner ma première conférence publique en Allemagne sur le tabou des chambres à gaz et du génocide : juste en face de la fausse chambre à gaz de Dachau, un des hauts lieux du Culte.

Mauthausen

La minuscule chambre à gaz de Mauthausen n'a jamais eu beaucoup de fidèles pour la défendre. Elle est indéfendable. En près d'un demi-siècle, je ne vois guère que deux personnages pour avoir vraiment essayé de nous faire croire à sa réalité : l'Autrichien Hans Marsalek et le Français Pierre-Serge Choumoff. Dans leurs diverses publications, ils s'abstiennent prudemment de montrer une véritable photo de l'intérieur de la pièce. La raison en est simple : cette pièce a toutes les apparences d'une simple salle de douches et l'on n'aperçoit pas le moindre élément matériel qui donnerait à penser qu'il s'agit d'une chambre à gaz homicide avec toute la machinerie qui, en pareil cas, serait indispensable. Marsalek et Choumoff ne montrent rien du tout ou bien ― très rarement ― reproduisent en photo l'extérieur de l'une des deux portes (deux portes à une chambre à gaz, c'est-à-dire un redoublement délibéré des problèmes d'étanchéité !), ou bien encore ils laissent vaguement apercevoir un petit fragment de l'intérieur.

En 1978, lors de ma première visite, j'avais demandé à deux responsables du musée, et en particulier au directeur, ancien détenu espagnol, pourquoi, parmi tant de cartes postales du camp proposées aux touristes, il ne s'en trouvait aucune montrant ladite chambre à gaz. La réponse avait été : « Ce serait trop cruel ! » Réponse surprenante quand on songe que tous les musées de camps de concentration, y compris celui de Mauthausen, sont souvent comparables à ces « musées des horreurs » qu'on voit dans les foires et quand on sait que l'antinazisme de sex-shop est l'un des commerces les plus florissants du « Shoah business », dénoncé par bien des juifs.

Lors de la même visite, j'avais aussi voulu savoir pourquoi, dans la chambre à gaz elle-même ou dans le musée, on ne découvrait aucun document, aucune expertise établissant que cette pièce à apparence de douche était, paraît-il, une chambre à gaz homicide. Le directeur du camp avait eu l'audace de me répondre que le texte de l'expertise était bel et bien reproduit dans la chambre à gaz elle-même. C'était faux. Il dut en convenir et me parla d'une expertise qui se trouvait à Linz, sans autre précision. On pense bien que, si une telle expertise avait existé, le texte en serait reproduit dans tous les ouvrages consacrés à Mauthausen et dans toutes les bibliographies de l'« Holocauste ».

Lors de notre inspection du 10 avril 1989, un incident allait se produire avec les autorités du camp. Nous nous étions rendus sur place de bonne heure le matin afin de permettre à F. Leuchter d'opérer ses prélèvements d'échantillons sans trop de risques. Il n'eut pas plutôt achevé ce travail, qui provoquait un bruit effrayant, que des groupes de visiteurs commencèrent à se succéder dans la chambre à gaz. Il s'agissait surtout d'enfants des écoles qu'on endoctrine ainsi de façon systématique dans la honte et la haine de ce que les Allemands et les Autrichiens des générations antérieures sont supposés avoir fait pendant la guerre (l'Autriche est le pays d'élection de Simon Wiesenthal). Les guides, c'est-à-dire les officiels du musée ou les professeurs, prodiguaient sur la chambre à gaz et son fonctionnement des explications stéréotypées mais contradictoires en bien des points. Sans nous donner le mot, nous commençâmes, Mark Weber et moi-même, à interroger devant la caméra d'Eugen Ernst l'un des officiels du musée, celui qui nous paraissait le plus compétent. D'abord assez sûr de lui-même, le malheureux, pressé de questions, dut admettre en fin de compte qu'on ne savait pas trop bien comment cette chambre à gaz avait fonctionné. Il se révéla qu'au cours des années le mensonge avait pris des formes extrêmement variées. On avait successivement imposé aux visiteurs trois versions contradictoires de la procédure du gazage :

- procédure n° 1 : le gaz venait du plafond par les pommes de douches (encore existantes) ; cette version, nous dit l'officiel, fut abandonnée quand des gens eurent fait remarquer que, vu le peu de hauteur, il aurait suffi aux victimes d'apposer leurs mains sur ces pommes pour les obturer et empêcher ainsi l'arrivée du gaz ;

- procédure n° 2 : le gaz venait du plafond (et il en repartait au moment de l'évacuation) par une sorte d'ouverture de cheminée (encore existante) située dans la partie ouest ; l'officiel ne sut pas nous dire pourquoi cette version allait être abandonnée à son tour ;

- procédure n° 3 : le gaz venait par un mince tuyau perforé situé sur la paroi est à environ 80 cm du sol, c'est-à-dire qu'il venait de la partie diamétralement opposée à celle de la procédure n° 2 ; il n'existait plus aucune trace de ce tuyau, ni même de l'orifice par lequel il serait provenu d'une salle adjacente où se préparait le gaz ; la salle adjacente était totalement nue et ne recélait rien qui pût donner la moindre idée de sa fonction.

Tout cela était déjà troublant mais le plus troublant était peut-être que la seule explication indiquée sur une plaque de métal dans la chambre à gaz était celle de la procédure n° 2. Je le fis remarquer à l'officiel, qui nous expliqua qu'il s'agissait d'une « erreur » : la procédure décrite sur cette plaque n'était plus la bonne. Je lui fis observer que la procédure n° 3 (celle actuellement retenue comme vraie) se heurtait à une considérable invraisemblance physique. Placé à quatre-vingts centimètres de hauteur, le tuyau perforé, même s'il avait été partiellement inséré dans la paroi pour résister à la pression des corps, aurait été obstrué par les corps des victimes comprimées dans la chambre à gaz : comment le gaz se serait-il diffusé normalement pour tuer toutes les victimes dans l'ensemble de la chambre à gaz ? L'officiel finit par répondre qu'il n'était pas un scientifique et que son explication était celle que fournissait dans son livre... Hans Marsalek. Quelques minutes après son départ, il nous expédia deux agents de police (?) qui nous intimèrent l'ordre de cesser toute prise de vues : on pouvait tout photographier à Mauthausen, nous apprirent-ils, sauf... la chambre à gaz et le four crématoire. Pourtant, nul panneau n'en avertissait les touristes qui, de toute façon, photographiaient par milliers ces deux emplacements au vu et au su des autorités du camp.

A Mauthausen, j'ai eu le sentiment que les autorités du camp vivaient dans une sorte de fièvre obsidionale ; elles paraissent hantées par les progrès du révisionnisme en Autriche et par l'action en ce sens de personnes comme Emil Lachout, Gerd Honsik et Walter Ochensberger (je voudrais au passage rendre ici hommage à la mémoire d'un autre Autrichien, Franz Scheidl, qui a publié dans les années 60, à compte d'auteur, toute une série d'études sous le titre général de Geschichte der Verfemung Deutschlands [Histoire de la diffamation de l'Allemagne], laquelle est restée peu connue, même de bien des révisionnistes).

Hartheim

Le château de Hartheim se remarque de loin au milieu d'une plaine. Pour un endroit censé avoir servi aux crimes les plus secrets, il est vraiment impossible à dissimuler. Ce château a été, avant et pendant la guerre, une sorte d'asile et il l'est resté aujourd'hui. Il contient une petite pièce d'apparence inoffensive dont on se demande bien pourquoi on a décidé de la qualifier de « chambre à gaz » homicide. Il s'agit là de l'une des inventions les plus effrontées de la religion de l'« Holocauste ». Je ne lui vois aujourd'hui qu'une utilité : à ceux qui se moquent des superstitions religieuses du passé comme si notre époque était plus éclairée et plus intelligente que les époques passées, je dirais volontiers :

Allez visiter la chambre à gaz du château de Hartheim et, après cela, venez me dire si vous ne vous sentez pas humiliés d'être ainsi pris pour des naïfs par ceux qui osent affirmer qu'il s'agit là d'une ancienne chambre à gaz.

Je ne connais aucune publication qui reproduise une photo de cette minuscule « chambre à gaz », qualifiée par Hans Marsalek, dans la version anglaise de la confession qu'il est censé avoir recueillie de Franz Ziereis, commandant de Mauthausen, de :

grande installation de gazage où, selon les estimations de Ziereis, on extermina entre 1 et 1,5 million de personnes [!].

L'Intifada révisionniste

Le désarroi actuel des défenseurs de l'« Holocauste » a de curieux effets. Jusqu'à la fin des années 70, ces derniers croyaient détenir, avec Auschwitz, Birkenau et d'autres camps situés en Pologne, de solides preuves de l'existence des chambres à gaz et donc du génocide des juifs. Jusqu'à cette époque, ils pouvaient se permettre de dire qu'il y avait eu des exagérations et que les camps situés hors de l'actuelle Pologne ne possédaient certainement pas ou probablement pas de chambres à gaz. A partir du début des années 80, sous la pression des écrits révisionnistes, les chambres à gaz de Pologne et, en particulier, celles d'Auschwitz et de Birkenau parurent de plus en plus douteuses. Dans un mouvement comparable à celui de l'intégrisme religieux ou politique, les exterminationnistes préconisèrent un retour à la foi et à la doctrine des origines. Ils se remirent à affirmer qu'il avait certainement existé des chambres à gaz à Mauthausen, à Sachsenhausen, à Ravensbrück, à Neuengamme, au Struthof-Natzweiler et peut-être même à Dachau. Je renvoie là-dessus à l'ouvrage d'Adalbert Rückerl, Hermann Langbein, Eugen Kogon et vingt et un autres auteurs, NS-Massentötungen durch Giftgas (en français, Chambres à gaz, secret d'État).

Dans le cas de Mauthausen, des gens comme Claude Lanzmann ou Yehuda Bauer allèrent jusqu'à la rétractation. En 1982, ce dernier avait clairement écrit : « Aucun gazage n'a eu lieu à Mauthausen ». Quant à Claude Lanzmann, il avait été tout aussi net : en 1986, à l'occasion d'un violent débat à Radio Europe n° 1, sur l'affaire Roques, il avait marqué son désaccord avec le ministre Michel Noir qui s'était permis de parler de la chambre à gaz de Mauthausen. Il avait fermement repris le ministre sur ce point : jamais, lui dit-il, il n'y avait eu de chambre à gaz dans ce camp. Tout cela n'empêcha pas Y. Bauer et C. Lanzmann d'affirmer plus tard qu'il avait bel et bien existé une chambre à gaz à Mauthausen.

Ces rétractations, ces brusques changements de cap, ces explications constamment changeantes constituent une preuve supplémentaire de ce que la chambre à gaz et le génocide ne sont qu'un mythe : un mythe ne cesse de fluctuer au gré des opinions dominantes et des nécessités du moment [7].

Les exterminationnistes d'aujourd'hui n'ont plus guère que deux refuges, deux points où ils espèrent pouvoir ancrer leur foi : le « camion à gaz » et « Treblinka ».

Sur le premier point, je leur annonce que le Français Pierre Marais va prochainement publier une étude intitulée : Le Problème des camions à gaz [8]. Sur le second point, je leur annonce qu'ils vont perdre « Treblinka » comme ils ont perdu « Auschwitz ».

A l'avenir, les tenants de l'« Holocauste » conserveront leur argent, leur puissance, leur capacité de produire des films, de célébrer des cérémonies, de construire des musées : des films, des cérémonies, des musées de plus en plus vides de sens. Ils multiplieront les moyens de répression contre les révisionnistes par les coups et blessures, les campagnes de presse, les procès, le vote de lois spéciales. Ils multiplieront aussi, cinquante ans après la guerre, les poursuites contre ceux qu'ils appellent les « criminels de guerre ». Les révisionnistes, eux, leur répliqueront par des études historiques ou des ouvrages scientifiques et techniques. Ces ouvrages, ces études seront nos pierres, notre Intifada.

Quant aux juifs eux-mêmes, ils auront le choix : ou bien ils suivront l'exemple des rares d'entre eux qui ont eu le courage et le mérite de dénoncer la légende, ou bien ils cautionneront l'activité histrionique des Élie Wiesel et des Samuel Pisar et les chasses aux sorcières dans le style de Simon Wiesenthal.

David Irving, qui s'est tout récemment rallié à nos positions, vient de déclarer :

La communauté juive doit faire son examen de conscience. Elle propage quelque chose qui n'est pas vrai [9].

On ne saurait mieux dire.

1er août 1989

___________

[Publié dans la Revue d'histoire révisionniste, n° 1, p. 51-71.]

Notes

[1] Le Monde Juif, janvier-mars 1987, p. 1.

[2] Voy. Wilhelm Stäglich, Le Mythe d'Auschwitz, Paris, La Vieille Taupe, 1986.

[3] Voy. William B. Lindsey, « Zyklon B, Auschwitz, and the Trial of Dr. Bruno Tesch » in Journal of Historical Review, Fall 1983.

[4] Voy. Robert Faurisson, « Le Révisionnisme au Canada ― Les procès Zündel », reproduit dans le volume II des Ecrits révisionnistes (1974-1998), p. 763.

[5] Voy. R. Faurisson, « Comment les Britanniques ont obtenu les aveux de Rudolf Höss, commandant d'Auschwitz », reproduit dans le volume II des ER, p. 657-669.

[6] p. 197-222.

[7] Pour la rétractation de Y. Bauer, voy. les p. 33-34 de l'indigente plaquette publiée en 1989 par le Dokumentationsarchiv des österreichischen Widerstandes sous le titre : Das Lachout - »Dokument«, Anatomie einer Fälschung ; pour la rétraction de C. Lanzmann, on lira la lettre qu'il a publiée dans Le Monde Juif, juillet-septembre 1986, p. 97.

[8] Cet ouvrage, intitulé Les Camions à gaz en question, est paru en 1994, édition Polémiques, Paris, 325 p. Il indique comme dépositaire principal : Mercure, 146 rue Saint-Honoré, 75001 Paris. [NdÉ]

[9] Jewish Chronicle (Londres), 23 juin 1989.

Labels: Amouroux, Auschwitz, Birkenau, Dachau, Hartheim, Irving, Klarsfeld, Lanzmann, Leuchter, Majdanek, Pressac, Tadeusz Iwaszko, Treblinka, Yehuda Bauer, Zündel
