<!-- http://robertfaurisson.blogspot.com/1988/04/preface-au-rapport-leuchter-sur.html -->

<!-- Saturday, April 23, 1988 -->

Préface au Rapport Leuchter sur Auschwitz

Fred A. Leuchter est ingénieur ; il est âgé de quarante-cinq ans ; il vit à Boston où il s'est spécialisé dans l'étude et la fabrication des systèmes d'exécution capitale dans les pénitenciers américains. Il vient notamment de mettre au point un projet pour la modernisation de la chambre à gaz du pénitencier de Jefferson City (Missouri).

En janvier 1988, je me trouvais à Toronto où je participais à la défense d'Ernst Zündel, un Allemand établi au Canada, actuellement poursuivi en justice pour avoir «propagé une fausse assertion» en publiant une brochure intitulée : Did Six Million Really Die ? (En est-il vraiment mort six millions ?). Cette brochure conteste l'opinion généralement reçue selon laquelle les Nazis auraient tué six millions de juifs durant la seconde guerre mondiale, principalement à l'aide de « chambres à gaz » fonctionnant à l'acide cyanhydrique (Zyklon B).

Déjà en 1985, E. Zündel était passé en jugement pour le même motif. Le procès avait duré sept semaines et il s'était achevé par une condamnation à quinze mois de prison ferme. En janvier 1987, la cour d'appel de l'Ontario cassa le jugement pour de graves motifs de fond et un nouveau procès fut décidé, qui commença le 18 janvier 1988 et se poursuit encore à l'heure qu'il est.

Mes premiers entretiens avec Fred Leuchter eurent lieu à Boston les 3 et 4 février 1988. Je fus étonné par la pertinence et la concision de ses réponses à mes questions et par son aptitude à justifier tout détail des procédures d'exécution par le gaz. Il me confirma le caractère particulièrement dangereux d'une exécution par le gaz cyanhydrique.

C'est aux États-Unis, en 1924, qu'on procéda pour la première fois à des exécutions au moyen de ce gaz ; mais, encore en 1988, la construction des chambres à gaz se heurte à de graves difficultés et, en particulier, au problème de l'étanchéité. Je remarquais en passant que F. Leuchter ne s'était pas posé de question sur l'opinion qu'on a généralement de l'« Holocauste » des juifs.

Dès mon retour de Boston à Toronto et après le compte rendu que je lui fis de mes entretiens avec F. Leuchter, E. Zündel décida de demander à ce dernier une expertise des « chambres à gaz » d'Auschwitz, de Birkenau et de Majdanek.

F. Leuchter accepta la mission après un week-end passé à Toronto, où il examina des photographies aériennes de camps de concentration prises pendant la guerre, des plans des crématoires et des « chambres à gaz », des documents sur le Zyklon B et des diapositives prises sur place par un chercheur suédois, Ditlieb Felderer.

Le 25 février 1988, F. Leuchter partit pour la Pologne avec une secrétaire (sa femme), son dessinateur (Howard Miller), un vidéo-cameraman (Jürgen Neumann) et un interprète de polonais (Tijudar Rudolph). Il en revint une semaine plus tard, le 3 mars.

A son retour, il écrivit un rapport de cent quatre-vingt-douze pages, annexes comprises. Sa conclusion était claire : la preuve était là, écrasante, qu'il n'y avait pas eu de chambre à gaz homicide à Auschwitz, à Birkenau et à Majdanek ; on ne pouvait pas sérieusement considérer « qu'aux emplacements inspectés les présumées chambres à gaz aient été autrefois utilisées ou puissent aujourd'hui fonctionner comme des chambres à gaz pour exécution ».

Les 20 et 21 avril 1988, il témoigna à la barre du tribunal de Toronto. Il répondit d'abord aux questions que lui posait l'avocat d'E. Zündel, Douglas H. Christie, assisté de Keltie Zubko. Puis il eut à répondre au contre-interrogatoire du procureur de la Couronne, John Pearson, représentant le ministère public et assisté durant tout le procès par un autre procureur et un clerc, non sans de fréquentes consultations avec des conseillers juifs qui se tenaient derrière lui dans la salle du tribunal.

L'interrogatoire par l'avocat et le contre-interrogatoire par le procureur se déroulèrent devant un juge et un jury de onze membres. Dans la salle, la tension était extrême. J'étais aux côtés d'un certain nombre d'experts révisionnistes, dont William Lindsey, un chimiste qui, avant de prendre sa retraite en 1986, dirigeait un laboratoire de recherches du groupe Du Pont. Il me semble que toutes les personnes présentes, indépendamment des opinions personnelles sur le sujet de l'« Holocauste », avaient pleinement conscience d'assister à un événement de portée historique. Le mythe des « chambres à gaz » touchait à sa fin.

La veille, le directeur du pénitencier de l'État du Missouri, Bill Armontrout, avait expliqué au cours de son témoignage la procédure de préparation et le mode d'opération d'une chambre à gaz fonctionnant à l'acide cyanhydrique. Tout auditeur attentif découvrait alors que, s'il était si difficile d'exécuter de la sorte une seule personne, la prétendue exécution de centaines de milliers de personnes par les Allemands avec du Zyklon B équivalait à la quadrature du cercle.

Le témoin qui succéda à F. Leuchter fut James Roth (docteur ès sciences de l'Université Cornell), administrateur des Laboratoires Alpha situés à Ashland (Massachusetts). Son exposé porta sur l'analyse d'échantillons prélevés sur les murs, les sols, les plafonds et autres emplacements des prétendues chambres à gaz d'Auschwitz-I et de Birkenau. Les examens révélaient une absence totale, ou bien un niveau infinitésimal de quantités décelables de cyanure, à une exception près : l'échantillon de référence no. 32 prélevé dans le bâtiment de désinfection no. 1 de Birkenau. Ces résultats, qu'on trouvera reproduits sous la forme d'un graphique dans l'annexe I du rapport Leuchter, furent projetés sur écran devant le jury. La différence était spectaculaire entre, d'une part, la quantité énorme de cyanure décelée dans le bâtiment de désinfection et, d'autre part, la quantité nulle ou infinitésimale trouvée dans les prétendues «chambres à gaz». (A mon avis, les quantités infinitésimales décelées dans certains crématoires résultent probablement de la désinfection de ces locaux pendant la guerre.)

Qu'on me permette, à ce point, un retour sur le passé et quelques observations d'ordre personnel.

Je crois avoir été le premier à dire que toute étude des prétendues « chambres à gaz » allemandes fonctionnant au Zyklon B devrait commencer par un examen des chambres à gaz américaines. Dès 1977, par l'intermédiaire d'un ami américain, Eugene C. Brugger, avocat à New York, j'avais commencé une enquête en ce sens. Six pénitenciers américains avaient bien voulu répondre à mes questions: ceux de San Quentin (Californie), de Jefferson City (Missouri), de Santa Fe (Nouveau Mexique), de Raleigh (Caroline du Nord), de Baltimore (Maryland) et de Florence (Arizona). A l'époque, force me fut de conclure que seul un expert en technologie des chambres à gaz américaines pourrait en fin de compte déterminer si les « chambres à gaz » allemandes pouvaient avoir été utilisées comme on nous le décrit dans la littérature de l'« Holocauste ».

Dans les années qui suivirent, mes articles sur les « chambres à gaz » allemandes firent toujours référence aux chambres à gaz américaines. Au nombre de ces articles figurèrent « La Rumeur d'Auschwitz ou "le Problème des chambres à gaz" », paru dans Le Monde du 29 décembre 1978, et une longue interview (écrite) publiée en août 1979 dans le mensuel italien Storia Illustrata. En septembre 1979, j'avais visité la chambre à gaz de Baltimore (Maryland) et j'en avais rapporté huit photographies ainsi qu'une documentation. Lors d'une conférence tenue à New York sous les auspices de Fritz Berg, je fis état de la « feuille de contrôle de la marche à suivre pour une exécution par le gaz » au pénitencier de Baltimore et j'en montrai les implications. En 1980, dans la première livraison du tout jeune Journal of Historical Review, je publiai un article intitulé « The Mechanics of Gassing », au cours duquel je décrivais les procédures d'exécution en chambre à gaz aux États-Unis. La même année, je publiai dans Vérité historique ou vérité politique ? les huit photographies de la chambre à gaz de Baltimore. En 1981, mon vidéo-film sur « Le Problème des chambres à gaz » (http://www.youtube.com/watch?v=tyMQHd9C2sU&feature=PlayList&p=17401DB9965FB051&index=0&playnext=1) s'ouvrait sur une analyse des chambres à gaz américaines. En 1983, je préparai pour notre Institute for Historical Review (Los Angeles) un livre en anglais sur la controverse à propos de l'« Holocauste » ; là encore, je revenais sur le sujet des chambres à gaz américaines. Pour la première fois allaient être publiées la liste des questions posées aux responsables des pénitenciers et les réponses que j'avais reçues. Mais ce livre ne devait pas voir le jour ; le 4 juillet 1984, le jour de l'Indépendance américaine, un incendie criminel détruisait entièrement les archives de l'institut. Ce fut une catastrophe financière et un certain nombre de projets, dont celui de mon livre, furent abandonnés.

L'« Holocauste » peut apparaître comme un sujet d'énormes proportions. Mais, ainsi que l'a dit Arthur R. Butz, auteur de The Hoax of the Twentieth Century (La Mystification du XXe siècle), il s'agit là d'un « géant aux pieds d'argile ». Pour en apercevoir les pieds d'argile, il suffit de se rendre en Pologne au camp de concentration d'Auschwitz. Wilhelm Stäglich l'a dit : « C'est là que la thèse d'une extermination planifiée des juifs résiste ou s'écroule. » A mon tour, je prétends que tout le mystère d'Auschwitz est concentré dans les soixante-cinq mètres carrés de la prétendue «chambre à gaz» d'Auschwitz-I et dans les deux cent dix mètres carrés de la prétendue « chambre à gaz » de Birkenau. Les Alliés auraient dû expertiser ces deux cent soixante-quinze mètres carrés tout de suite après la guerre, mais rien ne fut fait à l'époque et rien ne l'a été depuis. Jan Sehn, le juge d'instruction polonais, ordonna quelques expertises mais aucune ne porta sur les « chambres à gaz » elles-mêmes.

Certaines études révisionnistes ont montré que les emplacements réputés avoir servi de « chambres à gaz » homicides n'ont pas pu être utilisés à cette fin. Ditlieb Felderer a publié des photographies qui révèlent la pauvreté de construction des orifices d'aération et des portes des « chambres à gaz » et l'absence de toute marque bleue d'acide cyanhydrique (ou : prussique). J'ai moi-même découvert en 1975 dans les archives du Musée d'État d'Auschwitz (des archives autour desquelles les autorités communistes montent bonne garde) les plans de ces prétendues « chambres à gaz » et j'ai été le premier à les publier dans une série de livres et d'articles. J'ai montré ces plans au premier congrès de l'Institute for Historical Review à Los Angeles en 1979. E. Zündel était présent. Ces « chambres à gaz » avaient été, en réalité, ainsi qu'on pouvait le lire sur les plans, des chambres froides pour les cadavres : Leichenhalle pour le crématoire I et Leichenkeller pour le crématoire II (la première ayant été ultérieurement transformée en un abri anti-aérien).

Toutefois, pour apporter une confirmation totalement scientifique à ce que le simple bon sens faisait apparaître et à ce que révélaient les recherches et les documents des révisionnistes, il fallait un spécialiste des chambres à gaz américaines. Je désespérais de trouver un tel spécialiste et, à vrai dire, j'avais peu d'espoir de découvrir un homme qui, non content d'être versé dans la technologie des chambres à gaz, aurait assez de courage pour mener ce type d'enquête dans un pays communiste et pour en publier les résultats si ceux-ci venaient à confirmer les conclusions révisionnistes.

Heureusement, je me trompais.

Fred Leuchter allait être le spécialiste en question. Il s'est rendu en Pologne, il y a conduit une enquête technique, a rédigé un rapport et a témoigné en faveur d'E. Zündel devant un tribunal canadien. Ainsi est-il, sans éclat, entré dans l'Histoire.

F. Leuchter est un homme d'apparence modeste et d'une tranquille détermination ; il s'exprime avec précision. Il aurait pu être un excellent professeur et il possède un don réel pour vous faire saisir les moindres détours d'un problème compliqué. Je lui demandai s'il ne redoutait pas quelques suites dangereuses ; il eut cette réponse : « Un fait est un fait. »

A la suite de sa lecture du « Rapport Leuchter », le fameux historien britannique David Irving déclara, le 22 avril 1988, à la barre des témoins du tribunal de Toronto, qu'il s'agissait là d'un document « accablant », appelé à devenir essentiel pour tout historien de la seconde guerre mondiale.

Sans E. Zündel, à peu près rien de ce qui s'est passé là n'aurait été concevable. E. Zündel sacrifie tout à sa recherche de l'exactitude historique. Il vit aujourd'hui dans des conditions difficiles face à des ennemis influents et puissants. La répression qu'il subit est incessante et prend parfois les formes les plus vicieuses. Mais il possède une forte personnalité et un indéniable charisme. Il s'entend à analyser les situations, à évaluer les rapports de force, à tirer avantage de ce qui l'accable. Des quatre coins du monde il appelle à lui et il mobilise les compétences requises. L'homme est profond ; il est un génie où se combinent le sens commun et une vue pénétrante des êtres et des situations.

Peut-être va-t-il, une nouvelle fois, être envoyé en prison à cause de ses recherches et de ses convictions; la procédure dite de déportation l'attend peut-être. Tout est possible. Tout peut arriver quand vient à se produire une crise de l'esprit et une révision aussi vaste de certains concepts historiques. Le révisionnisme est la grande aventure intellectuelle de la fin de ce siècle. Dans tous les cas, E. Zündel aura gagné. Il aura été ce pacifiste et cet activiste qui l'emporte par les seules vertus de la raison et de la persuasion.

23 avril 1988

Labels: "Did Six Million Really Die ?", Auschwitz-Birkenau, Auschwitz-I, Butz, chambres à gaz, chambres à gaz américaines, Ditlieb Felderer, Fred Leuchter, Majdanek, Zündel, Zyklon B
