<!-- http://robertfaurisson.blogspot.com/2002/01/mon-revisionnisme-litteraire.html -->

<!-- Friday, January 25, 2002 -->

# Mon révisionnisme littéraire

(Entretien avec un universitaire. Enregistrement sur CD. Le texte ne reproduit pas nécessairement tout le contenu de l'entretien et il n'en suit pas toujours le fil.)

Les révisionnistes veulent savoir si ce qu'on dit est vrai, c'est-à-dire vérifiable. Ils s'efforcent de parvenir à l'exactitude.

On peut être révisionniste en histoire, en littérature, en science, en tout métier.

## Mon révisionnisme en histoire

Mon activité de révisionniste en histoire n'a vraiment commencé qu'au milieu des années soixante-dix. Auparavant, j'ai été, si l'on peut dire, un révisionniste en littérature (française).

Le révisionnisme historique, tel que je le conçois, n'est pas affaire d'idéologie mais de méthode. Il s'agit d'une méthode d'investigation en vue de vérifier des faits, des événements, des chiffres, des documents, des témoignages. En principe, le révisionniste ne commente pas un fait et ne tire pas de conclusion sans s'être assuré, au préalable, de la réalité de ce fait. On se rappelle l'histoire de la dent d'or, racontée par Fontenelle : « On commença par faire des livres et puis on consulta l'orfèvre ». Le révisionniste, lui, à la différence des savants dont se moque Fontenelle, sait qu'il doit, avant de commenter la soudaine apparition d'une dent d'or dans la bouche d'un enfant âgé de sept ans, consulter un orfèvre ou bien se faire orfèvre. Pour prendre une deuxième comparaison, le révisionniste va choisir comme modèle Sherlock Holmes, réputé pour son sens de l'observation élémentaire, et se défier de la vaine science du docteur Watson. Pour prendre, enfin, une troisième comparaison, avant de répéter, après tant d'autres personnes apparemment dignes de foi, que le roi est paré d'habits miraculeux, il va, au préalable, vérifier si c'est exact ; et au cas où le roi serait nu, il proclamera, à condition d'en avoir l'audace, que « le roi est nu ».

Le révisionnisme littéraire, tel que je le conçois, observe une méthode identique et s'inspire du même esprit. Il oblige d'aller droit au texte pour l'examiner sous toutes ses faces, sur toutes ses coutures, indépendamment, en particulier, de la biographie, de la bibliographie et de ce qu'on entend par le terme, galvaudé et flou, de « contexte ». Le texte doit passer avant ce trop vague « contexte »-là. Cette méthode contribue à nous épargner les contresens. Elle aide à débusquer le faux. Elle peut, selon les cas, conduire à de modestes révisions ou à des révisions déchirantes.

## Modestes révisions littéraires

Du temps de mon « révisionnisme littéraire », dans les années 1960 et 1970, j'ai surtout étudié des textes difficiles de Nerval, de « Lautréamont », de Rimbaud, d'Apollinaire et de Valéry. Mais je me suis aperçu que des textes beaucoup moins énigmatiques que ceux-là recelaient tout de même parfois de graves difficultés de sens ou bien faisaient l'objet de contresens. Il pouvait s'agir d'œuvres en vers ou en prose, parfois très connues, de Villon, Ronsard, La Fontaine, Laclos, Stendhal, Hugo, Baudelaire, Flaubert, Verlaine, Alain-Fournier, Gide, Céline.

Je prendrai ici quelques exemples dans des textes connus, qui sont de Villon, de Ronsard, de La Fontaine, de Baudelaire et, enfin, d'Apollinaire.

1\) Villon : « Mais où sont les neiges d'antan ? » (dans la « Ballade » dite « des dames du temps jadis »).[Mais, sans aller chercher si loin en matière de blanches beautés disparues, où sont, tout simplement, passées les neiges de l'an dernier ?]

2\) Ronsard : « Mignonne, allons voir si la rose … ». [Aucune mélancolie, sinon feinte ; pure hypocrisie masculine et manège de galant, y compris et surtout dans la deuxième strophe, où les commentateurs s'imaginent percevoir un accent de tristesse ou de désarroi.]

3\) Baudelaire : « Je préfère au constance, à l'opium, au nuits / L'élixir de ta bouche où l'amour se pavane » (dans « Sed non satiata », poème des *Fleurs du mal*). Il m'arrive de dicter cette phrase aux nigauds ou aux adeptes du chiqué littéraire qui, tels des perroquets, vont répétant que « la poésie, cela ne s'explique pas » ; je les mets au défi d'écrire correctement « au constance » et « au nuits ». [Le constance est un vin d'Afrique du Sud ; le nuits est un bourgogne ; l'opium, ici, est peut-être un vin opiacé : à tout cela, dit l'auteur, je préfère la salive de ta bouche où mon « amour » se déploie avantageusement.]

4\) Encore Baudelaire : « La vie antérieure ». « … antérieure à quoi ? », se demandera-t-on. [Antérieure à l'ère chrétienne. Même se rêvant dans la situation idéale d'un patricien du monde antique, l'auteur ne pourrait se défaire de son spleen.]

5\) Toujours Baudelaire : *Les Fleurs du mal.* Que veut dire au juste ce titre ? A cette question, on ne pourra normalement répondre qu'après avoir attentivement lu, dans l'ordre de leur apparition, les 126 poèmes du recueil ; chaque poème sera résumé en quelques mots ; chaque résumé devra se raccorder au résumé précédent et le résumé final sera le résumé des 126 résumés successifs. Le résumé final donnera, par exemple : « Florilège inspiré par le mal de vivre (spleen, mélancolie, nostalgie d'un monde idéal) ». Il s'agit du mal au sens de maladie, peine, souffrance morale, « mal du siècle » et non du mal au sens de ce qui est contraire aux règles que la morale impose ou du mal par opposition au bien comme dans « les forces du mal » ou « le problème du mal ».

6\) Apollinaire : « Bergère ô tour Eiffel le troupeau des ponts bêle ce matin » (dans « Zone », premier vers du premier poème d'*Alcools*) ou encore : « Les boursiers ont vendu tous mes crachats d'or fin » (dans « L'Emigrant de Landor Road »). Enfin, que veut dire au juste ce titre d'*Alcools* ? [Le troupeau est… automobile. Les crachats sont… des décorations. Le titre signifie : poèmes de mes ivresse amoureuses].

On pourrait multiplier les exemples d'énigmes de cette sorte ; celles-ci donnent souvent lieu à des erreurs, des méprises, des contresens qui, pour la plupart, ne tirent tout de même pas trop à conséquence. (Sur question de l'intervieweur, développement consacré à La Fontaine : sa précision, sa finesse, sa justesse d'esprit ou encore sa malice dans « Le loup et l'agneau » ou bien dans « Les deux amis »).

## Déchirantes révisions littéraires

Mais, parfois, le travail de révision conduit à des vues entièrement ou presque entièrement nouvelles sur des œuvres entières. C'est alors qu'on peut estimer que la révision mène à une sorte de révolution. Tel a été le cas pour moi au terme d'analyses portant sur des œuvres de Nerval, de « Lautréamont », de Rimbaud et d'Apollinaire.

En 1961, j'ai publié *A-t-on lu Rimbaud ?* (J.-J. Pauvert ; en 1991, réédition par la Vieille Taupe). Je voyais bien qu'on avait beaucoup écrit sur la vie et sur l'œuvre d'Arthur Rimbaud mais, laissant de côté sa vie, je me demandais si son œuvre, sur laquelle on multipliait les exégèses les plus alambiquées, avait été lue, ce qui s'appelle lue, la plume à la main.

En 1972, j'ai, dans le même esprit, publié *A-t-on lu Lautréamont ?* (Gallimard).

En 1977, j'ai, toujours dans cet esprit, publié *La Clé des Chimères et Autres Chimères de Nerval* (J.-J. Pauvert).

Auparavant, en 1964 et en 1967, j'avais consacré, dans une revue universitaire (*L'Information littéraire*), parmi quelques autres études, deux études portant sur des textes difficiles d'Apollinaire. De manière délibérément provocante, j'avais intitulé la première : « Traduction prosaïque de La Chanson du mal-aimé » et l'autre portait pour simple titre : « Notes sur *Alcools* ».

En fin de compte, dans les quatre cas (Nerval, « Lautréamont », Rimbaud et Apollinaire), je découvrais que des œuvres prétendument détachées ou éloignées des contingences de la logique ne marquaient en fait, sous des apparences déconcertantes pour la raison, aucune rupture avec la logique ou avec la raison ; bien au contraire. Ces écrits étaient certes énigmatiques, mais ils dissimulaient les raffinements d'une logique sans défaut. Donc, à moins que je ne me trompe dans mon explication de ces œuvres, il n'a jamais existé dans la littérature française, à partir de la seconde moitié du XIX^e^ siècle, d'insurrection contre l'ordre et la logique. Les critiques littéraires, dans leur ensemble, ainsi que les professeurs de littérature se leurraient ou nous trompaient en croyant ou en cherchant à nous faire croire à cette fausse émancipation, à cette fausse révolution, à ce faux progrès de l'illogisme sur la logique dans la seconde moitié du XIX^e^ siècle ou au début du XX^e^ siècle.

## Textes de Rimbaud

Par exemple, dans le sonnet « Voyelles », il n'y avait ni « audition colorée », ni inspiration métaphysique ou mystique, ni visions selon le rimbaldien René Etiemble, lequel osait écrire : « Pourquoi des 'mouches', des 'tentes', des 'lèvres', des 'clairons' ? Parce que le poète les a VUES. Pourquoi les a-t-il vues ? Parce qu'il est poète ». En réalité, « Voyelles » (à lire : « Voi[s]-elle[s] ») était une fiction libertine et même graveleuse : il s'agissait d'un blason du corps de la femme, décrite *in coitu* ! Les rimes en sont uniformément féminines. Deux détails à noter : 1) dans le manuscrit, la voyelle E a la forme d'un epsilon ; 2) dans la tradition antique, reprise aussi bien par Byron que par Apollinaire, les divinités marines ou fluviales ont des cheveux verts (glauques). Point de départ ou Alpha : A noir, renversé, figure le sexe. E (à forme d'epsilon) blanc, couché, figure les seins. I rouge, couché, figure les lèvres. U vert, renversé, figure la chevelure. O bleu figure l'œil. Y violet figure les yeux bleus qui, dans l'extase, s'irisent : point d'arrivée ou Oméga. Bien des textes composant les *Illuminations* n'avaient également d'autre sens qu'érotique.

## Textes de « Lautréamont »

Dans le long récit intitulé *Les Chants* de Maldoror par le Comte de Lautréamont, il n'y avait ni « romantisme flamboyant », ni surréalisme d'avant la lettre, mais une charge bouffonne de la bêtise prudhommesque. Le mystificateur, Isidore Ducasse, y parodiait l'enflure de personnages trop enclins à se prendre au sérieux et dénués de la moindre finesse. Le facétieux Gascon avait « gasconné » son monde un peu, déjà, à la manière d'un Pierre Dac débitant, sur un ton effaré ou imperturbable, des récits à vous faire dresser les cheveux sur la tête. D'ailleurs, tout à la fin de ses « chants », le loustic s'était payé le luxe de dire qu'il attendait de son lecteur l'hommage suivant à l'endroit du « poète » : « Il faut lui rendre justice. Il m'a beaucoup crétinisé ». La phrase est passée inaperçue, tout comme mille bouffonneries glissées dans le cours du récit. On ne s'en est pas avisé car, pour rire, il faut parfois, au préalable, s'accorder la permission de rire. Enfin, jamais Ducasse n'a pris pour nom de plume celui de « Comte de Maldoror » ! Il se moque de ce comte-là. Il l'a fabriqué, comme Molière, par exemple, avait inventé, mais pour les tourner en dérision, Gorgibus et bien d'autres personnages de la galerie de ses grotesques.

## Textes de Nerval

Dans les dix-sept poèmes des *Chimères* et des *Autres Chimères,* il n'y avait eu ni « supernaturalisme » au sens de « surréalité » ou de « surréalisme », ni ésotérisme religieux mais de pures et naïves confidences d'ordre familial, personnel, politique et religieux ; ces poèmes hermétiques, une fois déchiffrés, révélaient, chez un auteur tourmenté, le désir de se forger un monde chimérique où tous ces éléments disparates correspondraient harmonieusement les uns avec les autres. « Mes poèmes perdraient de leur charme à être expliqués, si la chose était possible », avait dit Nerval. Explication de cette phrase. Explication, à titre d'exemple, de « Delfica. » (Dans l'entretien, récitant ce sonnet de mémoire, j'en ai omis le premier vers du premier tercet : « Ils reviendront ces dieux que tu pleures toujours. ») Le blason de l'auteur en quatre images : au centre le fils, à la fois prince et poète, est tel un soleil noir et mélancolique ; en haut et à gauche, dans le ciel, la mère, à la fois reine et sainte, luit telle une étoile tandis que, en haut et à droite, le père, à la fois Roi des rois et Dieu, resplendit tel un soleil éclatant ; en bas, à droite, l'aimée, à la fois sirène et fée, brille telle une fleur (une ancolie, baume qui adoucit la mélancolie, ou « noire ancolie », mais ne la guérit pas). Confidence, parmi d'autres, de ces textes hermétiques : l'auteur estimait que son père, aussi froid et indifférent à la souffrance de son fils que, dans la froide religion chrétienne, Dieu refusant de répondre aux appels de Jésus au Jardin des oliviers, se rêve en fils naturel, en bâtard, d'un membre de la famille de l'empereur Napoléon, roi de Rome et nouveau César ; ce dernier n'a-t-il pas tenté de « ramener l'ordre des anciens jours », celui du paganisme terrassé ? Autre confidence : l'auteur déteste les Anglais, barbares du Nord, et les Bourbons. Il a horreur du Nord, du froid, de la neige ; il est attiré par le Sud et par l'Orient. Bizarrement, pour lui, l'Allemagne est la porte de l'Orient.

## Textes d'Apollinaire

Quant à Apollinaire, il ne délirait pas le moins du monde. Ni sa langue, ni sa syntaxe ne s'étaient émancipées des règles les plus traditionnelles. Au contraire, assez souvent, son art s'inspirait de la tradition des grands rhétoriqueurs et des précieux. Sa force est d'avoir combiné les sortilèges de l'artifice avec une langue d'une soudaine simplicité : étrange combinaison qui avait dérouté plus d'un lecteur. Ses poèmes ne comportant pas de signes de ponctuation, l'on en concluait à son affranchissement des règles. Contresens là encore : les phrases de tous les poèmes d'*Alcools* sont si remarquablement construites qu'elles peuvent se passer (comme les textes originaux de Démosthène ou de Cicéron !) de tout signe de ponctuation. Extraits de « La Chanson du mal-aimé » (« Les satyres et les pyraustes / Les égypans les feux follets … » ou « Mort d'immortels argyraspides / La neige aux boucliers d'argent… ») ou encore extraits de « La Synagogue » (« Ottomar Scholem et Abraham Lœweren / Coiffés de feutres verts le matin du sabbat… »).

## Une méthode spartiate (« La méthode Ajax »)

Toujours dans *L'Information littéraire,* à peu près chacune de mes études s'ouvrait sur un avertissement où je prenais soin d'annoncer au lecteur : *Notre étude porte sur l'œuvre elle-même* [pour prendre un exemple, ce pouvait être *Le Soulier de satin,* de Paul Claudel]*, à l'exclusion de toute biographie, bibliographie, recherche de sources ; elle ne contient aucune allusion à d'autres œuvres ; elle ne fait état d'aucune déclaration de l'auteur. Le nom de [Claudel] n'y figure pas.*

On peut s'étonner d'un tel parti pris, mais l'expérience m'avait enseigné qu'il me fallait tenter ce pari. La méthode était sévère. Elle impliquait bien des renoncements au confort des méthodes en cours. Elle exigeait une rigueur de fer. Mes étudiants l'appelaient familièrement « la méthode Ajax ». Ils la présentaient comme une « méthode qui récure, qui décape et qui lustre » et voulaient bien ajouter : « Elle apprend à apprendre ».

En toute circonstance, il faut chercher à comprendre et, pour cela, il convient d'apprendre à aiguiser son attention. Tous les mots d'un texte, sans exception, ont leur importance de même que chaque détail d'une œuvre d'art ou chaque note d'une partition musicale ; nous ne pouvons négliger aucun point d'un document de caractère juridique, administratif, réglementaire ni aucun élément d'une pièce scientifique, littéraire ou historique (voy., à ce propos, le *De Re diplomatica* du bénédictin Mabillon ; cet ouvrage du XVII^e^ siècle est comme la charte du chartiste). L'analyste peut invoquer le droit au doute et à l'erreur mais ce droit-là ne saurait exclure le devoir élémentaire de faire attention.

## Il faut chercher à comprendre

On nous débite volontiers deux sortes de poncifs : 1) « Il ne faut pas chercher à comprendre », 2) « Un texte, en particulier un texte de poésie, a le sens qu'on lui prête ». À quoi je rétorquais : 1) Il faut toujours chercher à comprendre, 2) Un texte, qu'il soit de prose ou de poésie, n'a qu'un sens ou bien il n'a pas de sens du tout ; un double sens ne fait jamais qu'un sens.

Il ne peut tout simplement pas exister de bonnes raisons de ne pas chercher à comprendre ce qu'on lit. « Chercher à comprendre » ne signifie pas nécessairement que l'on comprendra. Parfois, en un premier temps, on s'imaginera avoir réussi à comprendre avant de découvrir, en un second temps, qu'on a échoué. On repartira alors à l'assaut du texte et, en définitive, on vaincra ou l'on sera vaincu. Mais, au moins aura-t-on essayé de résoudre la difficulté. On aura lu le texte d'aussi près que possible. Les auteurs de livres qui portent sur des écrivains difficiles évitent en général de se colleter avec les textes. Au lieu de nous aider dans la compréhension des écrits qui constituent l'essentiel d'un prosateur ou d'un poète, ils nous entretiennent trop souvent de ce qui est futile, comme la vie de l'auteur, ses amours, ses aventures. Ils font diversion en évoquant ce que pompeusement ils appellent « le contexte » ; or, ce n'est pas le « con-texte » qui importe avant tout mais le texte. Parfois encore ces beaux esprits se rabattent sur des comparaisons avec d'autres auteurs ou développent des considérations historiques, idéologiques, psychologiques, psychanalytiques. Ils lisent entre les lignes avant de lire les lignes. Ils fuient la difficulté, c'est-à-dire la saisie des textes à bras le corps. Ils redoutent l'effort et la solitude du chercheur de fond qui, fermant son esprit à toutes les sollicitations venues de l'extérieur, s'acharne dans un travail d'analyse terre-à-terre, à cru et à nu. Ces paresseux, ces timides, ces discoureurs ressemblent à celui qui prétendrait savoir nager et qui, sur le bord de la piscine, ferait toutes sortes de manières au lieu de se jeter tout simplement à l'eau sans discours et sans bouée de sauvetage. Et puis, trop souvent, au lieu de s'exprimer en un français de France, les cuistres à la façon de Jean-Pierre Richard et les bas-bleus à la manière de Julia Kristeva, recourent au sabir requis pour faire sérieux. Ces universitaires semblent ignorer qu'une expression simple, accessible au plus grand nombre, est plus difficile à trouver qu'un langage compliqué. Exemples de refus du chiqué universitaire : 1) « Souvent, dans un parc de Vichy, le long de l'Allier, je m'efforçais, le prudent crayon à la main, de déchiffrer des textes difficiles comme pour les expliquer à des passants simples et sensés dont je supposais qu'ils avaient en horreur le chiqué universitaire ou parisien » ; 2) La pointe Bic expliquée successivement par l'ancienne critique, par la nouvelle critique et, enfin, par la critique de toujours (voy. Serge Thion, *Vérité historique ou vérité politique ?*, La Vieille Taupe, 1980, p. 52-54).

Un mot isolé peut avoir différents sens mais, dès qu'il est accolé à un autre mot au sein d'une phrase ou d'un texte, cette faculté se restreint d'autant et son sens va se préciser. Un ensemble de deux mots associé à un autre ensemble de mots va voir encore diminuer la faculté de « polysémie » et, plus le nombre de mots augmentera, moins nous pourrons prétendre que le texte a plusieurs sens. Ce sens pourra être double comme dans l'ironie, mais un double sens ne fait jamais au total qu'un seul sens et, pour s'en tenir précisément au cas de l'ironie, celui qui n'aura pas perçu le double sens n'aura tout simplement pas saisi le sens. Enfin, le non-sens existe et l'écrivain peut en jouer ; voyez, par exemple, Rabelais avec le récit du pourceau ailé amenant Pantagruel à cesser le massacre de « la génération andouillique » ou bien encore Benjamin Péret avec ses variations magiques sur l'air que nous respirons, lequel « à son état normal, secrète constamment du poivre qui fait éternuer la terre ». Quant à la différence entre la prose et la poésie, elle est affaire d'appréciation personnelle. Tel jugera prosaïque un texte qui se présente sous la forme d'un poème (par exemple, de Vigny, « La mort du loup ») tandis que tel autre jugera poétique telle prose de Marcel Proust (par exemple, lorsque le romancier évoque un bouquet de roses de Pennsylvanie aperçu sur un fond de mer où un bateau, avec son panache de fumée, semble se déplacer d'une rose à l'autre).

Il ne faut pas confondre « sens » avec « sentiment ». L'un est invariable tandis que l'autre varie nécessairement en chaque lecteur selon son goût, son tempérament et même son humeur du jour.

## Le yoga des lettres et le plaisir de l'attention

Beaucoup seront tentés de croire qu'une telle attention va gâter le plaisir de la lecture, en particulier quand il s'agit de poésie. C'est oublier qu'en tout domaine la jouissance peut naître ― et s'accroître ― d'une attention aiguisée. Un cuistre qui fera étalage de sa science sur ce qu'il nous offre à sa table va nous couper l'envie du boire et du manger. En revanche, le gourmet qui n'accumule de connaissances sur la cuisine et les vins que pour mieux les cacher à ses hôtes et qui, de quelques mots, saura piquer notre attention sur ce qui nous régale, celui-là aura toutes les chances d'aiguiser nos plaisirs en même temps qu'il éveillera peut-être notre curiosité et notre soif d'apprendre.

Cette application à prendre connaissance et conscience de chacun des mots d'un texte dans l'ordre de leur apparition est identique à la concentration nécessaire au yoga. Ce dernier est une technique de relaxation et de maîtrise des fonctions corporelles. Il apprend à inspirer, à expirer, à prendre conscience, avec une savante lenteur, des différentes parties du corps. On respirait peu ou mal et voici qu'on se met à respirer pleinement et bien. On se sentait tendu ou bien on ignorait qu'inconsciemment on était crispé et voilà qu'on se détend. De ces séances d'une gymnastique minutieuse et rêveuse on ressort avec le sentiment de s'être découvert soi-même et l'on en éprouve une sensation de bien-être. Il en va de même pour ce que j'appelle « le yoga des lettres ». Explication, à titre d'exemple, de ces dix mots : « Le ciel est,/Par-dessus le toit,/Si bleu, si calme ! » (Verlaine), ou du début de « Colloque sentimental » (Verlaine encore) ou, enfin, des quatre premiers vers du « Cimetière marin » (Valéry). Dans ce dernier cas, on comparera, pour l'explication d'un même texte, d'une part, les méthodes de l'ancienne ou de la nouvelle critique et, d'autre part, la méthode révisionniste. Cette dernière permet de goûter deux fois et bien ce qu'avec les premières méthodes on a goûté une fois et mal.

## Dans l'enseignement, l'explication de textes

Dans les classes de seconde, de première et de terminale, l'usage prescrit par l'inspection générale du ministère de l'Education nationale était de pratiquer, en cours de français, l'exercice appelé « explication de texte ». Le professeur choisissait un texte de prose ou de poésie et, plusieurs jours à l'avance, le donnait à préparer aux élèves. Afin de susciter la réflexion de l'élève et d'en contrôler le travail, le professeur devait poser sur la page qu'il avait choisie deux, trois ou quatre questions. Celles-ci étaient consignées dans le « cahier de textes » de la classe et chaque élève allait répondre par écrit aux questions posées. Quand survenait un inspecteur général, celui-ci ne manquait pas de réclamer le « cahier de textes » pour y voir quelle page de notre littérature devait être étudiée ce jour-là et pour vérifier si le professeur avait fait son travail et posé des questions pertinentes. Dans mes premières années d'enseignement, je me conformais à l'usage. Je me délectais de ces séances de cinquante minutes où, avec mes élèves, nous échangions nos vues sur telle ou telle page extraite du « Lagarde et Michard » (ouvrage injustement décrié, soit dit en passant). Mais, progressivement, je dus me rendre à l'évidence : il était fallacieux de multiplier les commentaires sur un texte dont on n'avait pas, au préalable, cherché à établir, d'un commun accord, le sens premier. Par ailleurs, j'observais que les élèves, du moins les plus scrupuleux d'entre eux, s'efforçaient tellement de répondre aux questions qu'ils se préoccupaient plus de ces questions que du texte même. L'attention était sollicitée en trop de directions différentes : 1) les questions du cahier de textes (y avait-on répondu et comment ?), 2) le sens littéral du texte (recherche du sens des mots, analyse grammaticale des mots, analyse logique des phrases, lien entre les phrases) et, enfin, 3) le commentaire. Ledit commentaire se révélait foisonnant et envahissant. Chez les lecteurs, la diversité des appréciations, quand ce n'était pas leur divergence, ne signifiait nullement que le texte était riche de tous les sens qu'on lui prêtait ; elle tenait, en bonne partie, au fait que les mots et les phrases avaient fait l'objet de recherches trop dispersées, sinon disparates. Il fallait donc plus de méthode, plus d'ordre, plus de clarté.

Chez mes propres maîtres, j'avais noté le phénomène suivant : quand le texte était en latin ou en grec, leurs explications étaient longues et scrupuleuses tandis que le commentaire final était réduit à la portion congrue ; rien que de normal à cela : quand on a visité les moindres recoins d'un édifice, on a déjà acquis une juste idée de l'ensemble et point n'est besoin d'un long commentaire final. En revanche, quand le cours portait sur un texte de langue française, ces mêmes maîtres ne tarissaient pas de commentaires. J'admirais la fertilité de leur esprit. Au lycée Henri IV, en cagne, l'admirable Jean Boudout nous éblouissait tous par sa virtuosité, mais avec, dans mon cas, une réserve : quittant une séance du virtuose sur un extrait du Père Goriot, je crois que mon admiration allait plus à Jean Boudout qu'à Honoré de Balzac. Ensuite, pour ma part, comme, je le suppose, pour d'autres élèves, une question sournoise parfois nous taraudait : l'auteur avait-il vraiment voulu dire ce que notre professeur lui faisait dire ? Au fond, je me demande aujourd'hui si mes bons maîtres, si brillants fussent-ils, n'étaient pas un peu les victimes d'une illusion fort commune, qui veut qu'*a priori* un Français soit supposé comprendre un texte écrit dans sa langue. Mais un Français, qui lit un texte français, ne devrait-il pas se méfier de ce qu'il croit savoir d'instinct et ne devrait-il pas, en quelque sorte, se traduire à lui-même, lentement et précautionneusement, ce qu'il a peut-être trop vite lu ? Ne devrait-il pas, en somme, traiter un texte français comme il traite un texte latin, grec, hébreu ou chinois ? Préalablement à tout commentaire, ne devrait-il pas, en quelque sorte, traduire, ligne à ligne et mot à mot, en son propre français le français de l'auteur ?

## L'explication de textes à la manière révisionniste

Dans la pratique, je fus conduit à supprimer le rituel des deux, trois ou quatre différentes questions posées au sujet de chaque texte et à ne plus poser qu'une seule question pour tous les textes, du début à la fin de l'année scolaire. Cette question était la suivante : « Que dit ce texte ? »

On remarquera que je ne demandais pas : « Que dit l'auteur ? » Interdiction était faite de prononcer le nom de l'auteur, de préciser qu'il s'agissait d'un poète, d'un romancier, d'un auteur de pièce de théâtre, d'un essayiste. Il fallait proscrire toute allusion à la biographie, à la bibliographie et même à tout élément historique autre que les éléments fournis par le texte. Le titre ne devait être mentionné qu'à la fin du résumé ; il fallait alors en donner le sens et préciser si, une fois qu'on avait pris connaissance du contenu de la page, ce titre reflétait ou non le contenu. L'élève avait évidemment le droit de dire quels mots ou quels passages lui étaient restés obscurs. La discussion générale s'engageait ensuite sur le sens littéral ou sens premier du texte. C'est seulement au terme de cette sorte d'exploration collective que chacun était invité à dire son sentiment sur le texte pris dans son ensemble.

Cette méthode révisionniste n'allait pas sans risque. D'abord, elle exposait le professeur à se faire mal noter par l'inspecteur général que surprenait, de prime abord, l'absence, dans le cahier de textes, des questions rituelles. Ensuite, l'exercice d'exploration pouvait donner lieu à des discussions oiseuses. Il appartenait au professeur de mener le tout à bonne fin sans être ennuyeux et sans rendre les textes rébarbatifs. Cette méthode apprenait à concentrer son attention au lieu de la disperser et à ne parler que de ce qu'on avait lu, et vraiment lu. Exemple vécu d'une explication de « La synagogue » dans *Alcools* lors de la visite d'un inspecteur général.

## Renouer avec une tradition et la moderniser

La paraphrase n'a pas bonne réputation. La glose non plus. On parle volontiers d'une paraphrase ennuyeuse ou d'une glose inepte. Pourtant, ces pratiques, aujourd'hui largement abandonnées sur les bancs de l'école, étaient judicieuses. La glose était une annotation en marge d'un texte pour expliquer ou interpréter un mot difficile, pour éclaircir un passage obscur ; par le simple fait de sa proximité immédiate avec le passage considéré, la glose présentait l'avantage, du moins en principe, de restreindre les risques de divagation. La paraphrase, elle, consistait en un développement explicatif d'un texte donné ; là encore, peu de risques d'errer. Enfin, de son côté, la traduction juxtalinéaire avait, elle aussi, son utilité : elle mettait face à face, à gauche, une ligne de grec ou de latin (ou de telle autre langue) et, à droite, sa traduction en français. Calquée sur l'ordre des mots de la langue à traduire, la traduction en français rendait certes un son bizarre, mais elle contraignait le lecteur à observer de près le déroulement de la phrase et à mieux saisir le mode de penser de l'auteur (Pierre Klossowski s'est essayé, avec un réel bonheur, à ce type d'exercice pour sa traduction de l'*Enéide*).

Glose, paraphrase et traduction juxtalinéaire n'auraient pas dû être négligées ou abandonnées à l'époque moderne mais dépoussiérées et adaptées à l'étude de textes de la littérature française. Cette modernisation devient possible avec la méthode révisionniste, si proche, dans son esprit, du traitement de texte informatique.

Dans l'enseignement qui se dit supérieur, je pratiquais cette méthode révisionniste. Je l'utilisais, en particulier après l'année de licence, pour la préparation des étudiants à un certificat que j'avais créé au sein d'une université lyonnaise et qui avait officiellement reçu le nom de « certificat de critique de textes et documents (littérature, histoire, médias) ». Quant aux étudiants préparant leur mémoire de maîtrise, je leur suggérais, pour le contrôle de leur propre travail, un exercice d'inspiration révisionniste : une fois le mémoire en voie d'achèvement, ils devaient résumer en une seule page les 80, 100 ou 120 pages de leur manuscrit et, à son tour, cette unique page appelait un résumé en une phrase ne dépassant pas 60 mots. Ces étudiants disposaient là d'un moyen de contrôler si le manuscrit était clairement composé et si on avait su éviter le désordre ou les redites. On apprenait la concision et, puisque aussi bien on se disait « étudiant en maîtrise », on s'entraînait ainsi à la maîtrise de l'expression, qui est une forme de la maîtrise de soi. Chez les Anglo-Saxons, on appelle *« abstracts »* ces types de sommaires. Dans les siècles passés, il arrivait couramment de donner à son ouvrage imprimé un long titre explicite et de placer, en tête de chaque section ou chapitre du livre, un résumé tenant en une ou plusieurs phrases. Il y a donc ainsi des leçons de révision à puiser aussi bien chez les anciens que chez les modernes. Encore faut-il s'aviser de ces leçons, les apprendre et les adapter à son propre travail. Il faut savoir rester indifférent aux sarcasmes de ceux qui, se fiant aux apparences, croient que la paraphrase témoigne toujours d'une certaine épaisseur de l'entendement. La paraphrase bien entendue requiert, chez qui explique, de la finesse et, chez qui entend, de « l'exquisité d'écoute » (Céline).

## Conclusion

Ma pratique de la méthode révisionniste dans l'enseignement ou dans la recherche en matière de littérature française m'a valu plus de satisfactions et moins de déboires que mon révisionnisme historique. La sagesse aurait voulu que je m'en tienne là. N'est pas sage qui veut.

Pour un révisionniste, le champ des recherches possibles dans le domaine de la littérature française reste important. Personnellement, je me félicite de ce que, grâce aux progrès de l'informatique, les chercheurs disposent de plus de moyens que par le passé pour établir, par exemple, des corpus, c'est-à-dire des ensembles finis de mots, d'éléments ou d'énoncés en vue d'une analyse linguistique. Ainsi limite-t-on dans leurs effets néfastes la logorrhée et la logomachie des commentateurs. Ainsi, trop lentement sans doute, le révisionnisme littéraire finit-il par se ménager une place au soleil tandis que la pratique du révisionnisme historique, elle, reste encore largement interdite.

Que le révisionnisme se trouve être historique, scientifique ou littéraire, son combat reste le même. Il vise à la recherche sinon de la vérité (notion souvent trop vague ou contestée), du moins de l'exactitude.

25 janvier 2002

[CD à commander, pour 15 euros, à]{.underline}

Librairie nationale, 12, Rue de la Sourdière, 75002 PARIS, 01 42 86 06 92

La Licorne bleue, 3bis, Rue Jules-Vallès, 75011 PARIS, 01 46 59 18 20

Akribeia, 45/3, Route de Vourles, 69230 ST GENIS LAVAL

[Ouvrages de Robert Faurisson]{.underline}

*A-t-on lu Rimbaud ?* (J.-J. Pauvert, 1961), 3^e^ édition, La Vieille Taupe, BP 9805, PARIS Cedex 05, 1991, 18,20 euros

*A-t-on lu Lautréamont ?* Gallimard, 1972, 9,50 euros

*La Clé des Chimères et Autres Chimères de Nerval,* J.-J. Pauvert, 1977, 8,80 euros

Labels: « Lautréamont », Apollinaire, Nerval, Révisionnisme, révisionnisme littéraire, Rimbaud
