<!-- http://robertfaurisson.blogspot.com/1982/09/lincroyable-affaire-faurisson.html -->

<!-- Wednesday, December 1, 1982 -->

L'Incroyable Affaire Faurisson

(deux éditions en 1982 ; ici, 3^ème^ édition
revue et corrigée en 2014)
Présentation du 5 juillet 2014

Parmi les nombreux procès intentés au professeur Robert Faurisson le plus important par son étendue et ses conséquences a été celui qui s'est achevé avec l'arrêt, mémorable en tout point, du 26 avril 1983, dont il n'est pas exagéré de dire qu'il a marqué, pour la LICRA (anciennement LICA) et pour pléthore d'associations juives et autres, une cuisante défaite. C'est en raison précisément de cette défaite que les adversaires du professeur se sont alors attelés à la préparation d'une loi, spéciale et exceptionnelle, qui, sept années plus tard, le 13 juillet 1990, tout bonnement punira « ceux qui auront contesté […] l'existence d'un ou plusieurs crimes contre l'humanité » tels que définis et punis avant tout, en 1945-1946, par le Tribunal militaire international (TMI) de Nuremberg où les vainqueurs ont jugé leur vaincu : l'Allemagne nationale-socialiste. Cette législation aberrante porte couramment la dénomination de « loi Faurisson » ou de « loi Fabius-Gayssot » (voy. Eric Delcroix, La Police de la pensée contre le Révisionnisme / Du jugement de Nuremberg à la loi Fabius-Gayssot, diffusion R.H.R., 1994, La Sfinge, Rome, 2006, 128 p.). Laurent Fabius, catholique non pratiquant d'origine juive, richissime sommité du Parti socialiste, était à l'époque président de l'Assemblée nationale tandis que Jean-Claude Gayssot était député stalinien de la région parisienne.

En 1982, dans ses deux premières éditions, dues à La Vieille Taupe ― c'est-à-dire à Pierre Guillaume -, L'Incroyable Affaire Faurisson se présentait sous la forme d'une plaquette de 80 pages, signée « Le Citoyen ». La couverture portait ironiquement : Les Petits Suppléments au Guide des droits des victimes, N° 1, L'Incroyable Affaire Faurisson. En page 3 se lisait : Supplément N° 1 / « Du vrai et du faux dans une très singulière controverse civile » ; puis était annoncée la présentation (p. 5-22), intitulée : « Nous n'irons plus au bois » et signée « Dagobert » (en fait, trois universitaires : Marc Rouanet, Jean-Louis Tristani et un anonyme). Etaient également annoncées d'abord les conclusions déposées par les intimées, au nombre de onze à commencer par la LICRA (p. 25-32), puis les conclusions de R. Faurisson (p. 33-76). Les trois pages finales (77-80) présentaient deux documents et une bibliographie. Le lecteur désireux d'aller tout de suite à l'essentiel peut limiter la lecture aux pages 25-32 et 33-76. Il mesurera la légèreté de l'accusation et le sérieux des arguments de la défense.

La présente édition, revue et corrigée, date de 2014, étant entendu que les dernières corrections apportées au texte datent, elles, du 5 juillet 2014. Il s'est donc passé 32 années, soit peu ou prou le temps d'une génération, depuis la première parution de cet opuscule d'apparence modeste mais de grande importance pour l'histoire du révisionnisme. On n'imagine pas aujourd'hui avec quelle assurance régnait encore en 1982, malgré les remarquables travaux de Paul Rassinier, la conviction, totalement infondée, selon laquelle l'extermination physique des juifs et les chambres à gaz nazies avaient réellement existé. Certes un coup de boutoir avait été porté à cette conviction générale d'abord en 1978-1979 avec l'apparition dans le journal Le Monde d'une vive controverse autour des découvertes et des arguments du professeur Faurisson. Auparavant, le 19 mars 1976, ce dernier avait découvert les plans, soigneusement cachés depuis 1945, des crématoires d'Auschwitz et de Birkenau censés contenir des chambres à gaz homicides. Or ces plans montraient à l'évidence qu'en fait de monstrueux abattoirs chimiques, les bâtiments de crémation n'avaient en réalité compté, à côté d'une salle des fours, que d'inoffensives salles, dites « dépositoires », où étaient entreposés les cadavres en attente d'incinération ; en allemand, ces salles, selon qu'elles étaient au niveau du sol ou semi-enterrées pour leur assurer une relative fraîcheur pendant l'été, s'appelaient « Leichenhalle » ou « Leichenkeller ». Grâce à la découverte de ces plans et grâce à ses constatations, in situ, à Auschwitz et à Birkenau, démontrant l'impossibilité d'existence et de fonctionnement de toute chambre à gaz homicide en ces lieux, le professeur avait sérieusement décontenancé ceux qu'il appelait « les historiens de papier ». Certes, en 1980, l'ouvrage de Serge Thion, Vérité historique ou vérité politique ? / Le dossier de l'affaire Faurisson / La question des chambres à gaz allait, à son tour, vivement troubler le monde de la recherche historiographique. Certes, toujours en 1980, R. Faurisson allait répliquer à ses adversaires par son Mémoire en défense contre ceux qui m'accusent d'avoir falsifié l'histoire. Mais il est probable que ce qui a définitivement rivé leur clou aux tenants de l'histoire officielle est ce modeste opuscule de 1982 où, aidé de ses amis, R. Faurisson a développé dans ses propres conclusions pour les magistrats de la Cour d'appel de Paris (1^ère^ chambre, section A, président François Grégoire) une argumentation historique, scientifique et juridique d'une telle pertinence et d'une telle méticulosité que les dignes magistrats, dans leur arrêt du 26 avril 1983, allaient, en particulier, admettre qu'ils n'avaient trouvé dans les écrits ou les déclarations du professeur sur « le problème des chambres à gaz » aucune trace de ce que ses adversaires avaient cru y déceler. Pour eux, ils ne voyaient, dans les écrits de R. Faurisson sur le sujet, pas la moindre trace 1) de légèreté, 2) de négligence, 3) d'ignorance délibérée, 4) de mensonge et ils en concluaient que tout le monde devait en conséquence se voir reconnaître éventuellement le droit de lui donner raison sur ce « problème » ; en propres termes ils allaient jusqu'à conclure : « La valeur des conclusions défendues par M. Faurisson [quant au problème de l'existence des chambres à gaz nazies] relève donc [souligné par nous] de la seule appréciation des experts, des historiens et du public ». Toutefois, courageux mais non héroïques, ces mêmes magistrats allaient assortir leur arrêt d'une restriction sur le caractère peut-être malveillant (?) du professeur et condamner ce dernier mais non pour « dommage à autrui par falsification de l'histoire » comme l'espéraient tant les plaignants.

A vrai dire, jamais depuis cet arrêt du 26 avril 1983 les adversaires du professeur ne se sont remis d'une telle défaite. Jamais, au grand jamais, malgré un flot de nouvelles tentatives pendant une trentaine d'années, ils n'ont pu obtenir des magistrats une quelconque condamnation de Faurisson pour falsification de l'histoire ou pour un quelconque faux. La dernière tentative en ce sens a été celle de Robert Badinter. Mal en a pris à l'ancien avocat, à l'ancien ministre de la Justice et Garde des Sceaux. L'arrogant personnage allait, en 2006, se vanter d'avoir personnellement fait condamner en juillet 1981 « Faurisson, pour être un faussaire de l'histoire » (sic). Poursuivi en justice, il allait en 2007 offrir à la XVII^e^ chambre du tribunal correctionnel de Paris le spectacle d'un misérable potache pris en flagrant délit de tricherie. Dans un jugement rendu le 21 mai 2007 on pouvait lire, à la page 16 du texte, que R. Badinter avait tout bonnement « échoué en son offre de preuve ». Mais attention ! Dans son extrême indulgence pour le personnage, le tribunal lui accordait le bénéfice de la bonne foi (!) et condamnait Faurisson à verser 5 000 € au millionnaire. Depuis lors, se gardant d'interjeter appel, le professeur s'accorde la satisfaction d'appeler Robert Badinter, « mon menteur, mon diffamateur … de bonne foi ».

Au cours des trois dernières décennies et, par pans entiers, l'édifice du Grand Mensonge est allé se dégradant et, sur le plan strictement historique et scientifique, il s'est finalement effondré. Plus personne, sur ce plan-là, ne peut prétendre détenir la moindre preuve de l'existence et du fonctionnement ne fût-ce que d'une seule chambre à gaz nazie (voy. « Les Victoires du révisionnisme (suite) » du 11 septembre 2011). Plus personne n'est en mesure, « malgré les recherches les plus érudites » (Raymond Aron en accord avec François Furet, le 2 juillet 1982), d'affirmer que nous possédons la preuve qu'un ordre ait été donné soit aux Einsatzgruppen soit à d'autres instances policières ou militaires par une quelconque autorité du III^e^ Reich d'exterminer physiquement les juifs. Les Allemands n'ont jamais préconisé « la solution finale de la question juive » au sens d'une extermination physique mais ils ont simplement recherché « une solution finale territoriale de la question juive » : « eine territoriale Endlösung der Judenfrage » ; autrement dit, ils voulaient éloigner les juifs de « l'espace vital allemand » et les contraindre à s'établir dans un territoire qui aurait pu, comme l'envisageaient parfois les sionistes eux-mêmes, se situer à Madagascar, en Ouganda, en Argentine, en Russie ou ailleurs mais non en Palestine, et cela « à cause du noble et vaillant peuple arabe » (voy. « Heinrich Himmler et les juifs » du 16 juillet 2012).

Aujourd'hui, en 2014, le Mythe ne tient plus que par les artifices de la Propagande, de la Mémoire, de la Croyance religieuse et de la Répression.

A l'avenir, aucun historien ne pourra écrire une histoire de « l'Holocauste » sans mentionner à sa juste place cet opuscule, modeste par ses dimensions mais si redoutablement efficace par ses conséquences historiques. Et cela d'autant plus que, grâce à l'invention d'Internet, cette troisième et dernière édition de 2014 a pu s'enrichir de « liens » qui, au prix d'un simple clic, permettent au lecteur d'aujourd'hui d'élargir considérablement le champ de sa vision et de prendre la mesure de la victoire du révisionnisme sur le plan strictement historique et scientifique.

***

L'Incroyable Affaire Faurisson

DU VRAI ET DU FAUX

DANS UNE TRÈS SINGULIÈRE

CONTROVERSE CIVILE (*)

Page

Présentation

Nous n'irons plus au bois 5

Conclusions

de la Ligue 23

du Professeur 33

Bibliographie 80

Nous n'irons plus au bois

La force oratoire des Anciens tenait à la rigueur de leur argumentation et de la part qu'ils prirent à l'invention de la démocratie et de la république. Quand vint le déclin de ces expériences politiques, la rectitude de leur parole put différer la décadence civique que fomentaient sous leurs yeux la méconnaissance, la lâcheté et l'intempérance d'une grande partie de leurs concitoyens.

Les plus grands instants, comme les vacillements du droit, rappellent ces fondements. Etablir le droit et rendre la justice sont les signes par excellence de la santé dont les démocraties sont capables.

Ainsi les lois ségrégatives de Nuremberg furent-elles en 1935 l'éclat sinistre d'une démission. Cette ville funeste vit-elle en 1945 la justice rétablir la sérénité compromise du droit ? Pour rechercher les responsabilités de ces excès guerriers, s'est-elle alors soumise aux faits et au droit international plutôt qu'à la houle inquiète de l'énorme tourmente ? Il ne le semble pas.

Tout le monde sait en effet que les États vainqueurs se sentant pressés, ou se croyant tenus, de faire des « exemples », instituèrent un tribunal spécial et surtout une méthode ad hoc au regard des exigences de la preuve. Ces facilités rendent toujours ce genre de règles vulnérables car celles-ci plongent la punition dans l'arbitraire et font perdre à la sanction ses raisons et sa vertu. Mais les inconvénients de ces règles inédites pour établir les fautes semblent déborder de très loin le problème de la condamnation des vaincus. A négliger dans la preuve le substrat matériel, celui-ci se trouva abandonné à la puissance illimitée d'une parole effrénée. Dans le dire, la tragédie concentrationnaire reprit en quelque sorte une seconde vie. Libéré de toute attache empirique, ce drame déjà ancien s'organisa en un récit puis se planifia.

Outrepassant les lois de la physique, la vulgate déboucha vite, si l'on peut dire, sur le merveilleux.

Aujourd'hui, le droit n'est-il pas toujours et encore indûment requis de s'annexer la possibilité de juger du vrai en histoire ? Ce vrai-là ne prend il pas, en nos républiques, sa source ordinaire et suffisante dans la contro-
_________________
(*) A partir de la présente page 5 de l'ouvrage, les numéros placés entre tirets reproduisent la pagination de la seconde édition de La Vieille Taupe, Paris, 1982.

- 5 -

verse des historiens réputés les plus sages ? Se pourrait-il que ceux-ci n'y pourvoient plus ? Ou bien ne veut-on pas les écouter ? Ou pis, ne serait-on plus en état de les entendre ?

C'est en tout cas à confirmer une vérité historique qu'un demandeur intempestif convoque le droit en ses juges. On attend de ceux-ci qu'ils restaurent, par le geste sacré de la condamnation infamante, le tabou défaillant qui prétend barrer l'accès au contenu de la discussion en soustrayant à l'examen l'élément essentiel de l'enquête : l'instrument criminel.

Cette controverse sur le droit à l'étude de la vie concentrationnaire, et en particulier à l'étude des usages et des moyens d'y administrer la mort servile, porte à la fois sur l'existence factuelle et sur la fonction aussi bien subjective que collective du concept de chambre assassine.

Il convient de distinguer ici l'existence de l'arme du crime des récits qui l'affirment en la nommant. Les fresques interprétatives résultantes sont plus soucieuses d'établir la culpabilité de qui les contredit que d'examiner calmement les faits. L'erreur va croissant, et croissent au fil des ans les dommages qu'elle entraîne. Souvent par elle, la détresse des proches crie sa pudeur ; à rebours, la vérité est parfois utilisée par la malveillance, mais l'erreur, à la longue, n'est-elle pas grosse de tous les maux ? Pour mettre fin à ce funeste état des choses, il importe de cheviller avec douceur les âmes au corps de la vérité. En un mot d'estimer cette erreur.

Cette erreur n'a pas été, à son origine, inspirée par le mensonge, ni d'un seul ni de plusieurs. Elle fut produite dans une rumeur. Moyennant quoi, en dépit de résistances variées, la rumeur se gonfla en un récit épique menaçant, nourri de vertiges et de terreurs, mis au service de causes morales diverses et du ressentiment profitable à quelques-uns. Aucune critique historique ne contient plus désormais l'intempérance d'imaginations fiévreuses souvent souffrantes, d'autres fois égarées.

C'est pourquoi les faits, donnant une limite après tout humaine à la parole, nous préservent de légendes qui pourraient, telles des épidémies, affecter la santé psychique de nos concitoyens en les dessaisissant par leurs allégories captieuses de leur rapport concret et véridique à la mort. Des travaux sérieux ont maintenant paru au grand jour. Un jugement inconsidéré amputerait les historiens d'un domaine d'études qui pour l'ensemble des problèmes concentrationnaires est une urgence de la pensée. Un tel jugement ferait aussi accéder une rumeur ingénue à la dignité de mensonge inondant et officiel.

Or donc, une Ligue internationale, dont la visée proclamée est de combattre le racisme et l'antisémitisme, dans l'accomplissement supposé de sa mission, a signifié, le 14 mai 1982, les conclusions que nous publions ici. Elles ont été écrites à la suite d'un appel interjeté par le Professeur à l'encontre d'un jugement obtenu par cette Ligue devant le tribunal de grande instance de Paris.

Dans ses conclusions en appel, la vertueuse Ligue demande confirmation de ce jugement qui a sanctionné l'accusé pour imprudence (art. 1382-

- 6 -

1383 du Code Civil). Ces conclusions réitèrent les imputations accusatrices portées dans l'assignation introductive, plutôt que de faire confiance aux motifs paradoxaux de la condamnation. Les conclusions du Professeur répondent point par point à cette deuxième version de l'accusation qui contient des éléments plus précis que n'en comportait la première.

Les conclusions de la Ligue d'une part, les conclusions du Professeur d'autre part, constituent les documents essentiels soumis à la Cour par chacune des parties pour lui permettre d'établir sa conviction et à partir desquels elle devra rédiger son jugement. Les plaidoiries, dans un procès civil de cet ordre, ne servent en effet qu'à présenter et illustrer une procédure essentiellement écrite.

Nous avons jugé à propos de soumettre à l'attention d'un public alerté, sinon averti, les conclusions écrites des deux parties. Elles composent ce que les Anciens auraient appelé des dissoi logoi, des discours contradictoires sur un même sujet.

Celui-ci consiste en un point des plus controversés de l'histoire contemporaine.

Attendu que cela commence à bien faire, nous avons jugé nécessaire de résumer l'état de la dispute et d'esquisser les logiques qui la soutiennent et ce, à l'intention des lecteurs que ces écritures judiciaires dérouteraient aussi bien que des juges. Un tel exercice n'est pas inutile pour apprécier le malaise du temps.

Commençons par l'accusation que porte l'honorable Ligue. Le Professeur est accusé d'avoir « faussé la présentation de l'Histoire » et d'avoir « volontairement tronqué certains témoignages tels que celui de Johann Paul Kremer », professeur de médecine, ayant effectué un service de soixante-seize jours au camp d'Auschwitz.

Cette falsification et cette troncation, sur lesquelles aucune indication textuelle n'est apportée, sont censées constituer une atteinte aux intérêts des membres de la Ligue. Ces intérêts sont définis dans trois attendus de l'assignation :

Attendu que la L.I.C.A. est une Association régulièrement déclarée, que selon ses statuts elle se propose de :

- Lutter par tous les moyens en son pouvoir contre le racisme et l'antisémitisme qui déshonorent l'humanité,

- Défendre par une action à la fois préventive et positive le droit à l'existence et à la paix des victimes du racisme dans le monde entier,

- Réaliser par l'union des hommes et des femmes de toutes opinions le rapprochement des peuples, la paix entre les races et l'égalité parmi les hommes ;

Attendu que la remise en cause de l'extermination de populations à raison de leur appartenance à une race, dont l'Allemagne nazie s'est rendue coupable sous l'influence et les directives du Chancelier Adolf Hitler et la remise en question des chambres à gaz qui ont été utilisées comme moyen pour parvenir à cette « solution finale », constituent une atteinte aux intérêts des membres de la L.I.C.A. ;

- 7 -

Attendu en effet que le rappel et le respect de la vérité historique qui a conduit à l'extermination industrielle et organisée de plus de six millions de personnes en raison de leur appartenance à une race, par la mise en œuvre d'une politique et d'une organisation criminelle, constituent précisément les moyens de lutte contre le racisme et l'antisémitisme puisqu'ils permettent de démontrer les aberrations et les crimes que ces fléaux ont engendrés au cours de l'histoire contemporaine.

En première instance, l'accusé fut condamné.

Le jugement ne lui impute aucune falsification, volontaire ou involontaire. Il ne relève aucune troncation. L'accusé fut condamné, non pas pour falsification mais pour imprudence ; pour avoir, semble-t-il, traité d'un sujet trop récent. Le jugement ne porte nulle part que l'accusé ait été imprudent pour avoir proféré un quelconque mensonge ou commis une erreur. Le tribunal se déclare à juste titre incompétent pour trancher de la vérité en histoire. Le texte du jugement n'écarte donc pas l'hypothèse que l'accusé ait commis sa coupable imprudence en disant une vérité.

Ce jugement évoque celui du célèbre procurateur romain. Ponce Pilate refusa de se prononcer sur la vérité des accusations portées contre Jésus. Comme le Christ n'était pas citoyen romain, le procurateur, injustement décrié, refusa d'entrer en d'obscures querelles de théologie judaïque et dut, par conséquent, abandonner l'accusé à la haine homicide de Sanhédrin.

C'est sans doute ce qu'eût souhaité faire le tribunal, présidé par Monsieur Caratini. Le professeur étant citoyen français, il ne pouvait pas le livrer au bras régulier de la ligue. Il le condamna donc sur ce bien vague motif qui veut tout dire et ne dit en fait que ceci : « Monsieur le Professeur, vous êtes imprudent parce que nous vous avons condamné ».

L'accusé considère cette dérobade comme fautive. Il persiste en effet à affirmer que ce jugement empêche la reconnaissance d'un fait vérace dont il n'y a pas lieu d'interdire l'énoncé : les chambres homicides n'ont d'existence qu'imaginaire. Les quarante-cinq feuillets de ses conclusions exposent une partie des raisons qui le contraignent à maintenir cet énoncé.

Ainsi, s'il est désormais imprudent de répéter l'affirmation du Professeur, c'est uniquement parce que celui qui s'y risquerait encourrait ipso facto condamnation. Le jugement du président Marcel Caratini est de caractère performatif, it does things with words, il crée l'imprudence en la disant.

Si ce jugement était confirmé, sa vertu performative se transmettrait aux générations futures et il deviendrait, de fait, imprudent de soutenir l'énoncé incriminé. On ne pourrait plus décider le moins du monde si cet énoncé est vrai ou faux. Nos enfants auraient au moins l'avantage de savoir ce qu'il convient de ne pas dire, tandis que l'infortuné Professeur n'aura su, qu'après avoir été condamné pour l'avoir dite, la vérité qu'il y avait imprudence à dire.

Il y a ici un conflit inégal entre la logique d'Aristote et celle du président Marcel Caratini.

La logique d'Aristote pose en effet que des deux énoncés suivants :

- 8 -

- les chambres à gaz homicides ont existé

- les chambres à gaz homicides n'ont pas existé,

(elles n'ont pas d'existence historique vérifiable)

seul l'un est vrai.

La Cour d'appel se trouve maintenant devant l'alternative :

- ou bien se prononcer sur le vrai et le faux,

- ou bien se déclarer incompétente et débouter la Ligue.

On voit mal en effet qu'elle puisse confirmer le jugement de première instance qu'elle rendrait ainsi exécutoire. Il serait difficile à la Cour de Cassation de maintenir un jugement évasif étayé sur un énoncé performatif qui crée la loi pour éviter de l'appliquer. Cette difficulté n'a pas échappé à nos voisins d'outre-Rhin, puisqu'ils envisagent la promulgation d'une loi qui interdirait la remise en cause des idées reçues sur le génocide et l'holocauste. Des organisations juives réclament une loi identique en Grande-Bretagne et la question a même été évoquée au parlement européen. Bien que la discussion soit en cours depuis près de quatre ans, aucun projet n'est à ce jour parvenu sur le bureau d'une de ces assemblées.

Cette solution, qui retirerait aux juges l'occasion de lourdes et épuisantes réflexions, n'est cependant pas sans objections et tout particulièrement celle-ci : il faudrait d'abord rédiger la loi et, à cette fin, énoncer avec un maximum de précision la vérité qu'il serait interdit de remettre en question, la « Vérité » que défend la vertueuse Ligue, et que le législateur aura alors reprise à son compte, c'est-à-dire au nôtre.

Il serait facile de trouver une unanimité conformiste pour voter la loi, mais un citoyen raisonnable se demanderait comment diable il se fait que la vérité des chambres homicides soit la seule vérité historique, dans l'histoire du droit laïc occidental, qui ait besoin de la loi pour exister. Car si la vérité historique des chambres meurtrières est évidente, pourquoi donc une loi ?

En revanche, une loi civile peut-elle imposer une vérité historique contraire aux critères de l'évidence tels que les historiens les définissent ? Sera-ce désormais dans le Journal Officiel qu'il conviendra d'aller rechercher la vérité historique ? Si une telle loi voyait le jour, les ayants droit des victimes de ces chambres homicides n'auraient-ils pas enfin des droits sur tous ? Ne serait-ce pas la nouvelle division des classes instituée, cette fois-ci, par la loi ? Les ayants droit des victimes de ces chambres primordiales ne feraient-ils pas de tous les autres citoyens leurs débiteurs à raison de ce droit victimaire vraiment nouveau ?

Reprenons les deux énoncés de la controverse :

- les « chambres à gaz homicides » ont existé ;

- les « chambres à gaz homicides » n'ont pas d'existence historique.

Chacun de ces énoncés repose sur des travaux qui se prétendent historiques, sur des documents et sur des arguments. Les travaux qui soutiennent l'énoncé faux (l'un des deux, rappelons-le, l'est nécessairement) comportent inéluctablement des observations lacunaires ; leurs documents sont mal interprétés, leurs arguments contiennent des faiblesses, fussent-elles invo-

- 9 -

lontaires. Mais on pourra y trouver tout aussi bien des omissions délibérées, voire des altérations, qui ont pour résultat de falsifier la présentation des documents. Volontaires ou involontaires, ces fautes sont matérielles, c'est-à-dire identifiables par une saine méthode de recherche historique, qui est ici à la portée de tout lecteur de bonne foi.

Si, d'aventure, ces fautes ont été commises de part et d'autre, on débouchera sur ce que les Anciens auraient appelé une disputatio perennis sans qu'il soit possible de décider lequel des deux énoncés en litige est faux et ce, jusqu'à ce que de nouveaux documents apparaissent. Le tribunal, lui, n'a pu considérer que les documents notoires au moment de l'assignation et le Professeur les a acceptés dans son argumentation.

Ces considérations sont d'une austère généralité : elles s'appliquent à toute recherche historique aboutissant à des résultats faux.

La Ligue honorable avait donc le choix entre deux solutions :

- soit apporter la démonstration de la vérité de son énoncé en apportant une preuve, fût-ce une seule, de l'existence d'une seule chambre homicide ;

- soit apporter la preuve de fautes rédhibitoires commises par le Professeur en ses travaux.

En effet, si les chambres assassines ont existé et si la Ligue cachottière en possède la preuve, le Professeur sera enchanté de la connaître. Si la preuve est, cette fois-ci, solide, il n'aura plus qu'à faire amende honorable. Pratiquons toutefois ici le doute hyperbolique immortalisé par Descartes et supposons qu'à l'opposé le Professeur s'acharne à maintenir ce qui serait son erreur. Alors, juste ciel, sa défense comportera nécessairement des lacunes graves ; ses arguments révéleront leur faiblesse misérable ; il sera contraint de risquer des interprétations fallacieuses de documents ; on relèvera des omissions coupables, voire (horresco referens) des falsifications de pièces. Nous n'avons, grâce aux dieux, assisté à rien de semblable, et pourtant, c'est la faute que la Ligue impute au Professeur en se gardant bien de localiser, nous le verrons en détail, les falsifications qu'elle dénonce.

Examinons, il le faut maintenant, comment l'honorable Ligue s'est comportée devant le tribunal à l'égard de ses propres preuves. Arguant d'une abondance inépuisable de preuves qui seraient en sa possession, elle a extrait sur les indications de M. G. Wellers ce qu'elle considérait à l'époque comme une pièce à conviction, certes unique, mais supputée suffisante en raison de sa limpidité diamantine : le journal du médecin SS J.-P. Kremer. Pour plus de sûreté, elle y adjoignit une seconde pièce : les aveux dudit Kremer. Le diamant, terni par les critiques textuelles du professeur dans son Mémoire en défense, fut obscurci par les précisions linguistiques de J.-G. Cohn-Bendit et lorsque ce dernier retrouva les rétractations de Kremer, le joyau perdit ses derniers feux.

Doit-on tenir pour épuisé le trésor diamantaire de la Ligue ? Nous ne le savons pas en toute certitude, mais force nous est de constater que la Ligue honorable manifeste depuis lors une sourde résistance à soumettre de nouveaux solitaires à l'examen de la justice et des historiens.

- 10 -

D'un strict point de vue argumentatif, la situation présente se résume dans le raisonnement suivant qui est un syllogisme aristotélicien (I.E.O.) :

- majeure : la rumeur dit que des chambres à gaz homicides ont existé ; (I)

- mineure : mais les preuves qu'on apporte à l'appui de la rumeur se révèlent, l'une après l'autre, illusoires ; (E)

- conclusion : donc, à tout le moins, ces chambres-ci n'ont pas existé ; et, en l'absence de tout document nouveau et irréfutable, il est raisonnable d'inférer qu'il n'y a pas eu du tout de chambres a gaz (O), (ce qui laisse entier le problème de la représentation « chambre de mort » dans les consciences). 

Les choses en étaient là quand se propagèrent, dans les milieux intellectuels, des théories prodigieuses. L'un élucubra un argument merveilleux : d'autres se drapèrent dans la position du célèbre procurateur romain ; les derniers, en désespoir de cause, aventurèrent un diagnostic sur la santé mentale du Professeur. Avant que de nous engager dans la sévère lecture des conclusions, ne négligeons pas le délassement spirituel que nous procurent ces supputations savantes.

Un éminent universitaire donc, dans les colonnes respectables du Monde, se fit fort, en utilisant la méthode réputée hyper-critique, prêtée au Professeur, de pulvériser la réalité historique de la guerre de 1914-1918. Examinons cependant la proposition suivante : « mon grand-père a été gazé à l'ypérite. Il est mort après la guerre des suites de ce gazage. » Ce témoignage est loin d'être une preuve suffisante. Le travail critique de l'historien devra rechercher et vérifier les documents concernant la date du décès, la pension d'invalidité, le lieu de la blessure... S'il vérifie tout cela, la réalité de la Grande Guerre, loin de s'évanouir, ne prendra-t-elle pas une épaisseur concrète croissante, sans qu'il soit besoin de chercher d'autres preuves ? En revanche, l'étude de n'importe quel témoignage relatif aux chambres homicides conduit, au fur et à mesure des vérifications, à une perplexité grandissante devant la désintégration des documents et témoignages qui prétendent en établir l'existence. La critique ne dissout pas le vrai, elle l'établit et le conforte ; mais elle dissout le faux. Comme le disent les philosophes : verum index sui et falsi, le vrai s'indique lui-même et il indique le faux. La sophistique peut certes faire diversion et parer le faux des couleurs bigarrées de la vérité, mais elle le fait de façon éphémère car l'inévitable fragilité du sophisme ne peut longtemps déployer ses charmes sans donner à voir, un jour ou l'autre, les dessous éventrés de sa nature sophistique.

Passons aux autres. A l'issue d'un colloque tenu à huis clos, Monsieur Raymond Aron a énoncé deux choses. La première peut se résumer ainsi : s'il n'existe pas de preuves documentaires du génocide, il demeure cependant vraisemblable que l'extermination ait été délibérée, décidée et organisée. Quoi qu'il en soit, et c'est la seconde chose, les procès de sorcières l'irritent. L'auditeur de la conférence de presse aura pu constater des progrès notables par rapport à la théorie hypercritique de l'universitaire précédent.

Raymond Aron ne s'obnubile plus sur la preuve matérielle et passe à la question suivante : il se fait un observateur éclairé de ceux qui s'acharnent

- 11 -

à la produire. L'éminent sociologue est ici apaisant et il a raison.

Peut-il cependant se contenter de tenir pour seulement vraisemblable une décision comportant un si grand nombre de conséquences pratiques ? Il passe outre à cette difficulté qui, pour un historien, est une muraille. Plus encore, il laisse entendre que, d'une façon générale, ce qui authentifie les faits historiques, même très importants, relèverait de la seule logique du vraisemblable. S'il en est ainsi, Raymond Aron, qu'en est-il alors de l'histoire ? La réponse ne peut être que celle-ci : l'histoire est inéluctablement une grandiose commémoration sans fondement vérifiable qui s'interprète indéfiniment et dont le souci n'est plus de s'informer de ce que les historiens considèrent comme faits historiques.

Quant au juste et courageux dédain pour les procès de sorcellerie, dont Raymond Aron témoigne, il appelle cependant une précision : de sorcières il n'y a pas en effet. C'est, du moins, ce qu'établit l'analyse anthropologique de la sorcellerie européenne. Mais ce qu'elle confirme aussi, c'est que les ensorcelés existent bel et bien. Ne serait-ce point eux qui contraignent Raymond Aron à aventurer ce concept invraisemblable ?

Ces ensorcelés, que tout débat effraie, jettent des sorts médicaux et profèrent des imprécations millénaires. Ils répandent que Robert Faurisson ne va pas très bien ; entendez : de la tête. Il est, disent-ils, vraiment impossible de discuter avec lui ; il est irascible ; il s'emporte sur des détails. On ne le rencontre donc pas. Davantage, on l'évite ; mieux, on recommande de l'éviter ; on ne le lit pas et l'on en vient à cette effronterie : ces dispositions calamiteuses seraient commandées chez le Professeur par une malveillance foncière, involontaire et incoercible envers les tentes d'Israël !

Trop, c'est trop !

Que les personnes qui auraient un louable souci pour la santé mentale d'un chercheur, qui dans l'exercice de sa profession a rencontré des adversaires redoutables, se rassurent : le Professeur va bien.

Mais quid de cette sollicitude diagnostique ? Ne révélerait-elle pas le souhait déguisé d'un sombre pronostic ?

Les secourables bontés thérapeutiques, les fastes intempérants du vraisemblable, l'admirable fiction d'une prétendue méthode hypercritique qui dissoudrait magiquement le vrai, tout ceci n'était qu'évasion vaine et agréable devant le problème considéré. On pensait ainsi détourner l'attention par des insultes et des exégèses piquantes pour enlever a priori toute pertinence aux arguments spartiates du Professeur, pour rendre dérisoires ses humanités, pour suppléer un temps à l'argumentation et aux documents imminents.

Hélas, confrontée à la liquéfaction incessante et douloureuse de ses preuves, la Ligue, au lieu d'y trouver la révélation d'une méthode historique éprouvée, ne vit là que motifs à s'irriter, et se plut encore à des imaginations, cette fois, quasi hallucinatoires. Bien qu'elle ait pu constater la capacité prodigieuse du Professeur de transsubstantier les diamants qu'elle produisait en verre, elle garda malgré tout sa foi entière en d'autres diamants

- 12 -

putatifs qui, à l'abri du jour, s'épargnent d'éventuelles et pénibles métamorphoses.

C'est la méconnaissance du dossier historique, adornée d'une anthologie d'obstinations variées, scandée par d'opiniâtres hésitations, qui ont transformé un simple pas de clerc en une authentique Affaire. Pour qu'une affaire soit devenue l'Affaire, il aura fallu la logique implacable dont la Ligue a fait preuve au cours du procès. Cette logique consiste essentiellement en une disputatio avec une école historique que la Ligue déclare indigne d'exister, sur un sujet dont elle proclame avec hauteur qu'il ne saurait constituer l'objet d'aucune disputatio.

Qui s'étonnera que cette syllogistique inattendue ait donné des résultats aussi réjouissants ?

Pour l'heure, la Ligue préférerait sans doute oublier l'imputation de falsification. Elle se contenterait de la confirmation du jugement obtenu en première instance, à savoir : que cette vérité fût coupable et imprudente à dire. Cela lui suffirait pour continuer à répandre allégrement le faux dans le meilleur des mondes vraisemblables où le Professeur serait un menteur.

Venons-en à l'âpre texte des conclusions. Si nous laissons de côté les attendus techniques portant sur la recevabilité des demandes, l'argumentation de la Ligue s'attache à énumérer : « les fautes commises par Monsieur Faurisson au sens des articles 1382 et 1383 du code civil ». Les voici :

- art. 1382. Tout fait quelconque de l'homme, qui cause à autrui un dommage, oblige celui par la faute duquel il est arrivé à le réparer.

- art. 1383. Chacun est responsable du dommage qu'il a causé non seulement par son fait, mais encore par sa négligence ou son imprudence.

Les fautes imputées au Professeur sont distribuées sous quatre chefs :

1. mise à l'écart d'un certain nombre de sources judiciaires importantes d'origine polonaise, autrichienne, allemande et française, ainsi que de témoignages ;

2. omission de documents importants qui vont à l'encontre de la thèse du Professeur ;

3. dénaturation de textes ;

4. interprétations techniques fallacieuses.

Après avoir pris connaissance du contenu de ces imputations, le lecteur constatera qu'en dehors du quatrième et dernier point, la Ligue ne fournit aucune démonstration à l'appui d'accusations accablantes. L'imputation de dénaturations de textes n'est étayée sur aucune référence précise à l'endroit aussi bien du texte dénaturé que du texte dénaturant qui permettrait à la Cour de constater le fait de la dénaturation.

Quant aux omissions ou mises à l'écart, la Ligue affirme par exemple : « attendu qu'il s'avère et qu'il est prouvé que... » [dans ses conclusions, ci-dessous page 29, alinéa 9]. « Il s'avère » ? Comment ? Où ? En vertu de quels critères ? « Il est prouvé » ? Au moyen de quelles preuves ? La Ligue ne daigne étayer aucune de ces affirmations mais n'hésite pas à réitérer des assertions dont la fausseté a été admise par les spé-

- 13 -

cialistes mêmes sur lesquels elle s'appuie. Elle se réfère tranquillement à des documents dont le caractère apocryphe a été démontré dans le cours même de la procédure.

Qu'elle ait cependant obtenu la condamnation du Professeur en première instance pose donc un problème considérable même si le tribunal n'a pas suivi la Ligue dans ses conclusions et s'il est resté évasif dans la définition des imprudences qu'il reproche au Professeur. Pour décrire ce troublant phénomène judiciaire, un anthropologue est contraint d'émettre l'hypothèse suivante : les lourdes accusations lancées par la Ligue n'auraient-elles pas exercé un tel effet d'incantation ou d'intimidation que le tribunal n'a pas pu exiger les justifications élémentaires qu'il aurait réclamées en toute autre accusation, ainsi qu'il était de son devoir de le faire ?

Le tribunal n'a-t-il pas confusément pressenti que la simple application des règles normales de la procédure judiciaire conduisait à la rupture du consensus religieux qui entoure ces questions, et n'a-t-il pas alors reculé devant la toute-puissance du sacré ?

Essayons de dégager les ressorts essentiels de la controverse.

I. ― Commençons par les « interprétations techniques fallacieuses ».

En ce qui concerne la crédibilité des aveux de Höss et les avis de Monsieur Truffert, le Professeur fournit dans ses propres conclusions des éclaircissements auxquels il n'est besoin d'ajouter qu'une simple remarque : ils nous révèlent la singulière façon dont l'un des avocats de la Ligue prétend s'enquérir des faits auprès d'un expert. La lettre de M^e^ Korman vise à obtenir un document revêtu de l'autorité de l'expert, susceptible d'être utilisé dans un procès contre le Professeur. Elle ne constitue guère une tentative d'obtenir une réponse claire à la question technique effectivement posée. Nous sommes pourtant au cœur du sujet : des gazages homicides de masse sont-ils matériellement et techniquement possibles, par exemple, dans le local présenté comme une chambre à gaz homicide par la Ligue, le Leichenkeller 1 du Krema II ? Et notamment, était-il possible de pénétrer sans masque à gaz dans ce local pour y manipuler, sans précaution particulière, des milliers de corps gazés ? Répondre à ces questions techniques par l'autorité généralement accordée aux aveux de Höss, c'est précisément suppléer à l'argument technique par un argument d'autorité.

En quatre ans, cette question n'a pas obtenu de réponse satisfaisante en dépit de nombreuses tentatives. Dans son livre Les Chambres à gaz ont existé, Monsieur Georges Wellers fait justement remarquer que la température des cadavres supérieure à 26°, point d'ébullition du HCN, éliminait la rétention de gaz par condensation, ce qui est vrai, mais il n'a pas traité de la dissolution du HCN dans la transpiration et les humeurs, de l'adhérence du HCN, des poches de gaz entre les corps entassés, de la rétention par capillarité, de la condensation sur les parois de béton, en hiver notamment, ni de la condensation provoquée par l'aération même lorsque la température de

- 14 -

l'air est inférieure à 26°. Aucune explication n'a été fournie sur la possibilité de ventiler une pièce remplie de cadavres dont le système de ventilation est connu, mais banal et très insuffisant, alors que dans les chambres à gaz homicides américaines, la présence d'un extracteur très puissant ne dispense pas de la nécessité de laver soigneusement le corps de l'unique condamné en prenant des précautions particulières (masque à gaz, tablier de caoutchouc, gants de caoutchouc), alors qu'il n'y a pas d'obstacle comparable à la circulation d'air, et que la température du cadavre est là aussi supérieure à 26°.

Si ces problèmes matériels et techniques ont en effet connu une solution pratique, celle-ci doit exister. Il faut bien cependant constater que les témoignages d'hommes comme Höss ou Gerstein, censés être des techniciens du gazage de masse, alors même que leurs aveux sont prétendus spontanés et coopératifs, donnent des gazages une description sommaire, simpliste et tout simplement irréelle. Ne doit-on pas en déduire que la représentation qu'ils s'en font au moment où ils écrivent ne procède pas d'une expérience véritable ?

En se refusant à entendre ces questions, en les refoulant, en opposant l'argument d'autorité à des interrogations de nature strictement technique, n'y a-t-il pas « interprétation technique fallacieuse » ? De même, en se référant à une aération magique, sans étudier les capacités réelles de l'installation de ventilation ?

Ni la Ligue, ni M. Wellers ne montrent en quoi les interprétations techniques du Professeur seraient fallacieuses. L'une et l'autre affirment qu'elles sont fallacieuses puisque les gazages ont existé.

La traduction de Vergasungskeller dans le document du 29 janvier 1943 mérite un commentaire particulier. La Ligue, dans ses écritures de justice, affirme de façon péremptoire que le terme « Vergasungskeller » se traduit par « cave de gazage », ce qui, dans son esprit, impliquerait gazage homicide. Les preuves abondent pourtant que les Allemands utilisaient le mot « Vergasung » pour désigner des gazages de désinfection. « Vergasung » peut signifier, selon le contexte, soit « carburation », soit « gazage ». Le mot « carburation » peut recouvrir des réalités diverses, selon qu'il s'agit d'un carburateur de voiture ou de l'appareillage décrit dans les notices techniques d'un constructeur de crématoires et destiné à préchauffer le mélange gazeux admis dans le four à l'aide des gaz chauds recueillis à l'arrière du four. Le mot « gazage » également peut signifier soit un gazage de désinfection, soit un gazage homicide.

Dans Le Monde du 16 janvier 1979, le Professeur avait protesté contre l'utilisation téméraire de ce document et contre la traduction abusive par « cave de gazage » au sens de gazage homicide. Il écrivait : « ... dans la lettre qu'on me cite du 29 janvier 1943 (lettre qui ne porte même pas l'habituelle mention de "Secret") Vergasung ne signifie pas "gazage" mais "carburation". Vergasungskeller désigne la pièce en sous-sol où se fait le mélange gazeux qui alimente le four crématoire. »

- 15 -

Dans sa tentative de réponse (Les Chambres à gaz ont existé), Georges Wellers ne conteste nullement que le mot « Vergasung » puisse, dans certains cas, signifier « carburation », ni que les crématoires puissent être équipés de cet appareillage identique à celui des fours Siemens, ni le fait que, lorsque cet appareillage est installé en sous-sol, les notices techniques utilisent le terme « Vergasungskeller » pour désigner aussi bien l'appareillage lui-même que la pièce en sous-sol qui le contient. Contrairement à la Ligue, Georges Wellers a entendu l'objection, il l'a comprise. Et il a, face a l'objection, une attitude partiellement scientifique. Il se refuse à créer la chose à l'aide du mot. Il prend l'avis d'un technicien des fours, il se renseigne sur les contraintes matérielles d'une telle installation, et démontre ainsi que le « Leichenkeller 1 » du plan ne peut pas avoir été une « Vergasungskeller » au sens où le Professeur prétend le traduire : « cave de carburation ». Sa démonstration est probante, à ceci près que le Professeur n'a jamais prétendu dans son article du Monde qu'il identifiait la « Vergasungskeller » avec le Leichenkeller 1. Ni le SS Hauptsturmführer, auteur de la lettre, ni le Professeur ne donnent la moindre indication qui permette de localiser et de préciser l'emplacement de cette « Vergasungskeller ». A plus forte raison, rien ne permet de l'identifier au Leichenkeller 1 et d'attribuer cette identification, comme une évidence, soit à l'auteur de la lettre, soit au Professeur.

Ce que l'on sait, en revanche, c'est qu'au moment où la lettre est écrite ― janvier 1943 ― l'installation n'est pas réalisée. On peut donc penser que l'auteur de la lettre désigne par « Vergasungskeller » l'emplacement en sous-sol prévu pour recevoir ces installations et, à ce moment, vide. S'agit-il de la pièce en sous-sol désignée sur le plan de Leichenkeller 3, et qui connaîtra finalement une autre destination, ou d'un espace non identifié clairement sous la salle des fours elle-même ?

Ces installations complexes et de haute technicité pour l'époque n'ont finalement pas été réalisées ; non plus que les générateurs latéraux indiqués sur certaines notices de la firme Topf und Söhne et prévus initialement sur le plan. En fait, n'ont finalement été installés que des ventilateurs latéraux plus sommaires destinés à augmenter le tirage des cheminées. Dans l'ensemble, la réalisation matérielle des Kremas II et III, fin 1942-début 1943, est plus sommaire que les plans conçus en 1941-1942 ne le prévoyaient. La capacité de crémation des fours s'en est trouvée réduite d'autant.

Dans l'état actuel des recherches documentaires et archéologiques, aucun spécialiste n'est encore parvenu à fournir une localisation entièrement satisfaisante de cette « Vergasungskeller ». Or, cette localisation est nécessaire pour arrêter une traduction définitive de ce terme.

Notons cependant que, contrairement à la Ligue, Monsieur Wellers ne refuse pas a priori le sens proposé par le Professeur. Ayant identifié une fois pour toutes et sans preuve la « Vergasungskeller » de la lettre et le Leichenkeller 1 du plan, il fait intervenir des arguments techniques pour prouver que ce Leichenkeller 1 ne peut en aucun cas avoir été une cave de carburation, ce qui, répétons-le, semble évident et n'avait jamais été envisagé par per-

- 16 -

sonne d'autre que lui. Il en conclut que le mot « Vergasung » ne peut donc, dans ce cas, être traduit par « carburation ». Reste le sens « gazage » que, dans son livre, il interprète aussitôt au sens de gazage homicide. Il en conclut que le Leichenkeller 1 est une chambre à gaz homicide. Le mot « Vergasung » crée la chose.

Mais, dans une lettre du 24 mai 1982 adressée au Bulletin des Amis de Paul Rassinier, M. G. Wellers prend la peine d'éliminer l'interprétation « gazage de désinfection » que personne n'avait suggérée. Là encore, il a une attitude partiellement scientifique. Il se refuse à admettre que le mot suffise à créer la chose, il se documente concrètement sur la chose elle-même. Voici ses propres termes : « ..., il serait bon de préciser tout de suite, à l'intention des lecteurs de Monsieur Faurisson, que cette suggestion ne tient pas debout. En effet, dans une lettre datée du 28.5.1942, la firme "DEGESCH", constructeur des chambres de désinfection dans les camps de concentration nazis, répond par la négative à une commande de chambres de désinfection de 75 mètres cubes, parce que cela présente de très grosses difficultés techniques par rapport à la fabrication de chambres de désinfection habituelles de 25 mètres cubes, et déclare impossible l'aménagement des chambres de désinfection de 200 mètres cubes. Alors, il est évident que dans le cas d'une chambre de 506,10 mètres cubes, son aménagement en chambre de désinfection est hors de question ».

Les arguments de Monsieur Wellers semblent ici corrects, sauf à supposer que le Leichenkeller 1 (210 mètres carrés x 2,41 mètres = 506,10 mètres cubes) était divisée par des cloisons et comportait des installations sur lesquelles nous n'avons pas le moindre élément d'information. Mais comment peut-on, après avoir valablement démontré que le Leichenkeller 1 du plan ne peut avoir été ni une cave de carburation ni une cave de désinfection, conclure qu'il s'agit nécessairement d'une chambre à gaz homicide, sans nous expliquer pourquoi les sévères contraintes techniques évoquées par la DEGESCH disparaissent magiquement dès lors qu'il s'agit de gazer des hommes ? N'y a-t-il pas ici « interprétation technique fallacieuse » ?

Nous avons dû nous écarter des écritures judiciaires et du texte des conclusions pour informer le lecteur d'une petite partie des débats qui se poursuivent sur le sujet hors des prétoires et dont la Ligue ne tient aucun compte alors même que les auteurs dont elle tire ses certitudes y participent. La Ligue, elle, refuse le débat et veut le bloquer par une décision judiciaire. S'appuyant sur un avis d'expert déposé au tribunal et signé de Monsieur Borten, traducteur assermenté honoraire, la Ligue prétend péremptoirement que « Vergasungskeller » signifie « cave de gazage » et que « cave de carburation » ou « cave de gazéification » seraient des fantaisies arbitraires, linguistiquement impossibles. Dans un autre avis d'expert que la Ligue mentionne à l'alinéa suivant, le même Victor Borten prétendait que le mot « Leichenkeller » n'existait pas en allemand, qu'il s'agissait d'un mot en usage exclusivement parmi les dirigeants nazis chargés de l'extermination pour désigner une réalité criminelle. Cette manière d'interpréter un docu-

- 17 -

ment (en l'occurrence le plan du Krema II, publié pour la première fois par le Professeur dans le livre Vérité historique ou Vérité politique ? de Serge Thion, où figure le mot « Leichenkeller » là où Victor Borten s'attendait a trouver « Gaskammer »,) fait penser au test bien connu des psychologues et qui consiste à présenter à un patient une planche de taches d'encre et à lui demander de décrire ce qu'il voit. Les descriptions renseignent davantage sur leur auteur que sur les taches.

Dans ses conclusions, le Professeur rapporte de multiples preuves d'utilisation, en dehors de tout contexte criminel, du mot « Leichenkeller ». Faut-il ajouter qu'en 1974 la municipalité de Berlin a inauguré un crématoire doté d'un « Leichenkeller » de 500 places, dont la construction a commencé en 1969, le projet décidé en 1968 sur des études préliminaires remontant à 1965 et l'idée première à 1963 ? Le mot « Leichenkeller » figure bien sur les plans et dans les notes techniques.

II. ― Venons aux « dénaturations de textes » reprochées au Professeur.

Il n'échappera pas au lecteur que les deux attendus de la Ligue [p. 30 ci-dessous] sont d'un laconisme surprenant. Le Professeur aurait ainsi dénaturé le journal de Kremer sans que l'on sache où et comment puisqu'aucune référence n'est fournie. Le lecteur désireux de vérifier les affirmations de la Ligue sera donc contraint de tout lire et de comparer sur ce sujet les écrits nommés avec ceux du Professeur. Il constatera d'abord que ce dernier n'a rien commis d'aussi inconvenant. Il remarquera à l'opposé que le Professeur cite avec scrupule les documents et les arguments susceptibles d'étayer la thèse de ses adversaires et qu'il présente sa propre argumentation en prenant le soin constant de différencier l'élément documentaire de l'activité interprétative. Si, d'aventure, venait au lecteur l'idée de poursuivre la comparaison, il serait contraint de découvrir que d'immortels écrits, émanant d'historiens éminents tels que MM. Poliakov, Wellers, Klarsfeld, etc., comportent en effet des dénaturations de textes.

Ainsi, les textes présentés par la Ligue ont bel et bien été adultérés.

III. ― Abordons maintenant les omissions reprochées au Professeur.

Une confrontation avec les réponses de l'accusé fait apparaître ici un mécanisme similaire. La Ligue se révèle imprudente dans ses accusations. Elle se réfère à des documents dont elle est seule à croire encore qu'ils existent et va jusqu'à attribuer à Eichmann l'établissement d'un prétendu procès-verbal de la réelle conférence de Wannsee, et ce, contre l'opinion de tous les spécialistes.

IV. ― Il reste, enfin, les sources judiciaires écartées.

Les deux derniers attendus méritent qu'on s'y arrête. Le Professeur y est accusé d'écarter en « quelques mots et sans plus s'expliquer sérieuse-

- 18 -

ment » les témoignages des « rares rescapés des sonderkommandos » ; il lui est ensuite reproché d'écarter « également sans aucune explication » les « témoignages et récits » de cinq « exécutants SS », Höss, Kremer, Entress, Broad et Gerstein. Or le Professeur s'est expliqué sur chacun de ces cas, y compris dans des documents et des pièces adressés à la Ligue, et fournis à la Justice. Certains de ces témoignages et récits ont fait l'objet de critiques exhaustives de la part d'autres historiens. Le Mémoire déposé au tribunal est principalement consacré au témoignage de Kremer. Les récits de Gerstein ont fait l'objet de réserves aussi bien du Professeur que d'historiens qui lui sont hostiles. Quant au récit de Pery Broad, démenti par son auteur, il raconte un gazage dont il aurait été témoin, vu de l'intérieur de la chambre homicide, en adoptant le point de vue et les sentiments d'une victime ! Plus aucun historien, digne de ce nom, n'accorde le moindre crédit au « témoignage » de Broad, qui semble beaucoup devoir aux soins attentifs des services britanniques.

Ainsi, en deux alinéas, la Ligue commet-elle les imprudences fautives qu'elle reproche au Professeur, en révélant l'extrême fragilité des sources sur lesquelles elle entend asseoir sa certitude.

Dans l'alinéa suivant, la Ligue, que rien n'arrête, reproche au Professeur d'avoir « au surplus omis, par une négligence coupable, de mentionner des documents importants allant à l'encontre de sa thèse ». La Ligue fait cette fois preuve d'une prudence trop facilement remarquable, en ne mentionnant aucun des documents prétendument omis. Faut il rappeler que la Ligue n'a jamais mentionné aucun document allant à l'encontre de sa propre thèse ? Qu'elle n'a jamais mentionné de travaux critiques qu'en les dénaturant ? Qu'elle n'a jamais cité les opinions des historiens sur lesquels elle s'appuie par ailleurs lorsque ces opinions s'écartaient un tant soit peu de la version des faits qu'elle entendait édifier ? L'insaisissable Ligue n'a-t-elle pas omis de mentionner enfin dans ses écritures judiciaires les documents probants fournis par le Professeur et déposés au tribunal ?

Cette série d'imprudences laisse transparaître le vague soupçon qui hante les ligueurs : tout bien battu et rebattu, le Professeur ne serait-il pas le dépositaire du savoir sur l'affaire ?

Car enfin, les historiens montrés du doigt pour « révisionnisme » ne sont-ils pas obligés (il faut bien préserver son droit de vivre) de consacrer l'attention la plus minutieuse aux arguments et aux documents fournis par leurs accusateurs ?

Aucun document n'a donc été omis, ainsi que les covenants veulent le faire accroire. Mais que penser, dès lors, d'accusateurs assez impitoyables pour pousser l'ébriété de leur logique jusqu'à laisser entendre dans leurs affirmations que l'accusé négligerait leurs preuves, alors qu'un seul de leurs documents, s'ils daignaient enfin le produire, déferait la thèse du Professeur ?

Nous commençons à comprendre. L'on croit de bonne foi quelque rumeur, errare humanum est ; l'on y adhère par sympathie ; l'on s'y habitue par crainte de faire de la peine à ceux qui s'y sont attachés ; l'on commence cependant à déchiffrer chez l'incrédule les défaillances de raisonnement que véhicule la rumeur ; avec le temps, les raisons de l'incroyant agacent, car in-

- 19 -

consciemment l'on a peur de s'être trompé. Perseverare diabolicum : il reste l'impérieuse obligation de bâillonner l'adversaire pour transformer une simple censure collective en refoulement définitif ; le problème n'existe pas puisque l'on n'en parle plus ; et comme l'on n'en parle plus, il n'a jamais existé.

Le procédé est simple, efficace et sans embarras.

L'expérience psychanalytique permet d'élucider ce phénomène dans lequel le message issu d'une culpabilité refoulée dans l'inconscient revient vers son émetteur mais « sous forme inversée », selon la formulation conjointe de Cl. Lévi-Strauss et J. Lacan. Qu'est-ce à dire ? La Ligue, de bonne foi, dit ce qu'elle refoule, en croyant l'identifier chez l'adversaire qu'elle accuse. La critique de la preuve lui renvoie cette accusation de falsification dont elle est inconsciemment coupable. Une alternative se présente alors ici. Ou bien l'émetteur du message entend ce qu'il disait malgré lui dans ses propos inconsidérés et le reconnaît noblement pour que commence le dialogue ; ou bien il n'entend rien, ni de ce qu'il dit malgré lui, ni par conséquent ce que dit l'adversaire et persiste à marcher sur l'eau. Dans la première hypothèse, le fait d'entendre ce qu'elle disait malgré elle, quoiqu'avec un temps de retard, permettrait à la Ligue de couper les lauriers. Ce serait pour elle le temps de conclure sur ce qu'elle désire et veut en vérité. Elle reconnaîtrait s'être d'abord méprise sur la nature du mystère ; elle avouerait s'être inquiétée à tort ; tout ceci vaudrait pour amende honorable, puis elle entrerait, de bonne grâce, dans le débat. Dans la seconde hypothèse : pour maintenir son accusation, la Ligue ― ces conséquences sont inéluctables ― doit se résigner à la falsification consciente et volontaire, au mensonge officiel.

Plutôt que de se laisser entraîner vers ces horizons, il est probable que chacun pour soi, de près ou de loin, sera touché par l'effraction de cette vérité dans l'histoire familiale et collective qui le relie aux siens et à un État qui n'est pas ici sans responsabilités.

C'est la question essentielle, lecteur, que nous te laissons.

Pour ce qui concerne la qualité de la vie civile, nous pensons qu'il est grand temps de rétablir le respect que mérite l'histoire qui est interprétation de faits vérifiables, ainsi qu'il est de règle depuis Thucydide.

L'histoire documentaire est ce bien universel qui rassemble les peuples et sans lequel nos oreilles bourdonneraient encore à la répétition infinie de récits ancestraux et inconciliables.

Le temps de conclure est venu.

Que l'outrecuidante Ligue se moque des faits, nous l'avons démontré avec les précisions nécessaires pour que le lecteur puisse le constater.

Que la Ligue méprise les autres, c'est ce qu'elle manifeste par le peu de cas qu'elle fait des historiens et par l'impolitesse sans rivage avec laquelle elle traite les arguments de son adversaire élu.

Rappelons ici une déclaration publiée dans Le Monde par trente-quatre historiens, le 19 janvier 1979. Elle se terminait sur ces phrases :

- 20 -

Il ne faut pas se demander comment, techniquement, un tel meurtre de masse a été possible. Il a été techniquement possible puisqu'il a eu lieu. Tel est le point de départ obligé de toute enquête historique sur ce sujet. Cette vérité, il nous appartenait de la rappeler simplement : il n'y a pas, il ne peut y avoir de débat sur l'existence des chambres à gaz.

La cause de tout ce tumulte, c'est ici qu'il convient d'aller la chercher.

Car enfin, les véritables responsables, ce ne sont pas le Professeur, ni quelques cohortes étiques d'un nazisme hyper-réaliste, et pas davantage la Ligue.

Non, les vrais coupables, ce sont ces profs dans la foi et la notoriété desquels s'enracine la frénésie de la Ligue.

Où en sont, trois ans plus tard, ces Inc'oyables ?

Le 21 avril 1982 a été fondée l'ASSAG (Association pour l'étude des Assassinats par Gaz). L'association se propose de « rechercher et contrôler les éléments apportant la preuve de l'utilisation des gaz toxiques par les responsables du régime national-socialiste en Europe pour tuer les [sic] personnes de différentes nationalités ; contribuer à la publication de ces éléments de preuve ; prendre à cet effet tous les contacts utiles au plan national et international. » Parmi les membres fondateurs figurent Madame Renée Aubry, chef de cabinet du ministre des Anciens Combattants ; M. Jean-Louis Crémieux-Brillac, Directeur de la Documentation Française ; M. Jacques Delarue, commissaire divisionnaire honoraire au ministère de l'intérieur ; M. Augustin Girard, Directeur d'un département au ministère de la Culture ; M. Pierre Vidal-Naquet, « historien-auteur notamment d'une étude en réponse aux affirmations faurissoniennes » ; M^e^ Bernard Jouanneau, « avocat du comité d'Action de la Résistance dans le procès Faurisson en 1981 à Paris » [1] ; M. Jean-Pierre Faye, « écrivain ― engagé dans la lutte contre les thèses révisionnistes ». On relève aussi les noms de Mme Geneviève de Gaulle Anthonioz, de Mme Anise Postel-Vinay, de M. Serge Choumoff, auteur d'un opuscule intitulé : Les chambres à gaz à Mauthausen (1972) ; ce dernier, en 1982, est présenté comme l'auteur « d'un ouvrage sur la [sic] chambre à gaz de Mauthausen ». Madame Germaine Tillion préside l'association et M. G. Wellers est vice-président.

Il s'agit en principe d'une association privée, mais cette association envisage d'en appeler aux fonds publics. Si l'on en juge par l'entregent des membres fondateurs, il faut s'attendre à ce que le citoyen finance la Quête désormais mystique de la Preuve. N'est-il pas stupéfiant que ces historiens perdus aient fondé une association pour rechercher et contrôler les éléments apportant la Preuve qu'ils ont toujours proclamée indubitable ? Ne l'auraient-ils donc pas contrôlée avant d'écrire leurs ouvrages ? La fondation de l'ASSAG n'apporte-t-elle pas un démenti transparent à leur fracassante déclaration du Monde ?

En suite de quoi, ils organisèrent un colloque à huis clos et répondirent aux

_____________

[1] On notera que M^e^ Jouanneau est l'un des avocats de la Ligue et non pas celui du C.A.R., qui est M^e^ Dubarry.

- 21 -

arguments adverses par du vent, sans abandonner l'insulte d'antisémitisme que l'inflation émousse. On admire déjà la merveilleuse sociologie et l'anthropologie incroyable qui s'élabore sur cet homme privé d'histoire.

Ces conduites puériles sont indignes de personnes de qualité.

Il n'est pas de plus grand danger que l'abandon de la rectitude de la pensée dont les clercs ont la garde. Nous faudrait-il assister sans rien dire à la disqualification publique et au déclin dès lors inévitable d'une prestigieuse école historique dont le Peuple français s'honore à juste titre : I'Ecole des Annales ?

Ceci appelle un camouflet !

Pour l'heure, le problème de la Preuve fait quatre victimes : le Professeur et les Juges de la Cour qu'irritent, eux aussi, les procès de sorcière, intentés par des ensorcelés.

Quelle sera donc l'attitude de M. le Garde des Sceaux en cette situation exiguë ? Sera-t-elle classique et conforme à la tradition qui requiert de lui une politique propre des procès politiques ? Abandonnera-t-il à la mystique du vraisemblable un problème de preuve circonscrit et ponctuel ? Livrera-t-il les juges aux forces obtuses et passionnées ?

Faut-il laisser ces historiens interdire à leurs collègues, et du coup à leurs concitoyens, d'interpréter l'histoire à partir de faits vérifiables ? Ceci reviendrait à empêcher l'étude historique et anthropologique des phénomènes concentrationnaires, car avant d'interpréter les faits, encore faut-il avoir liberté de les établir en vérité.

C'est sur cet unique plan qu'il est opportun de saluer et retenir les travaux du Professeur.

Cette étude est d'autant plus urgente que le phénomène concentrationnaire est un fait récent et mal connu de pathologie politique, caractéristique de notre siècle. Ses potentialités mortifères sont loin d'être épuisées. Pour en élucider la nature politique réelle, les règles de la méthode anthropologique conseillent d'ouvrir largement l'éventail de ses multiples interprétations possibles. Ce ne sont pas, pour l'instant, les crédits qui manquent mais les moyens éthiques.

L'interdit qui pèse sur l'interprétation de la représentation « chambre où l'on ne peut respirer sans mourir », dont la réalité psychique ne fait, elle, aucun doute, entraîne enfin une contamination inévitable du fantasme individuel et universel de scène primitive et constitue, de ce fait, un complexe fantasmatique pathogène, qui vient obnubiler la mémoire collective et individuelle. Laisser proliférer cet artefact, clef de voûte d'un mythe international, met aussi à la merci d'un éventuel passage à l'acte, c'est-à-dire, pourrait déterminer dans l'avenir l'émergence historique de réelles chambres criminelles.

Que l'opinion et la République gardent un silence expectatif serait le symptôme d'une vie civile molle où dorment les procureurs, et que Monsieur le Garde des Sceaux n'est pas homme de parquet.

Nous ne pouvons croire, Juges, qu'en votre sagesse, vous le permettrez !

Dagobert

- 22 -

*********

COUR D'APPEL

DE PARIS

____________

1^ère^ CHAMBRE A

M.E. N° 81/162 A

R.G. N° I 18042

I 15635

I 14650

Signifiées le

14 mai 1982

A Messieurs les Président et Conseillers

composant la 1^ère^ Chambre de la

COUR D'APPEL DE PARIS

CONCLUSIONS

POUR : La LIGUE INTERNATIONALE CONTRE LE RACISME ET L'ANTISEMITISME (LICRA) 40, rue de Paradis à Paris (10^e^), représentée par son Président Monsieur Jean PIERRE-BLOCH.

INTIMEE M^e^ ROBLIN

CONTRE : Monsieur Robert FAURISSON

APPELANT M^e^ Yves MENARD

Et en présence de :

Monsieur Serge THION

Monsieur Maurice DI SCUILLO

Monsieur RITTERSPORN GABOR TAMAS

Monsieur REDLINSKI Jean-Luc, Dominique,

Monsieur COHN-BENDIT Jean-Gabriel,

Monsieur GUILLAUME Pierre, Noël, Charles

Monsieur ASSOUS Jacob

APPELANTS M^e^ Yves MENARD

- 23 -

et en présence des co-intimées :

1°. ― A.N.F.R.O.N.F.

2°. ― U.N.A.D.I.F.

3°. ― F.N.D.I.R.

4°. ― C.A.R.

INTIMEES SCP Garnier Dubosq

5°. ― A.D.A.C. Hte Silésie

INTIMEE M^e^ VARIN

6°. ― M.C.R.P.A.P.

INTIMEE M^e^ VARIN

7°. ― U.N.D.I.V.G.

INTIMEE SCP Garnier Dubosq

8°. ― LE MONDE

INTIMEE M^e^ RIBADEAU-DUMAS

9°. ― NOUVEAU QUOTIDIEN

MATIN DE PARIS

INTIMEE DAUTHY

10°. ― Association des Fils et Filles des Déportés Juifs de France

INTIMEE RIBAUT

- 24 -

PLAISE A LA COUR

Statuant sur l'appel interjeté le 21 juillet 1981 par Monsieur Robert FAURISSON d'un jugement rendu le 8 juillet 1981 par la 1^è^^re^ Chambre du Tribunal de Grande Instance de Paris le condamnant à payer entre les mains de la LIGUE INTERNATIONALE CONTRE LE RACISME ET L'ANTISEMITISME (LICRA) la somme de 1 F. « à titre de dommages et intérêts, ladite somme constituant la réparation du préjudice moral subi globalement et indivisiblement par chacune des associations demanderesses ou intervenantes » et le condamnant, en outre, aux frais de publications de la partie du jugement figurant sous la rubrique « sur la responsabilité de Monsieur Robert FAURISSON » et de celle du dispositif sous la rubrique « publications judiciaires ― le problème des chambres à gaz » dans les publications :

- LE MONDE

- LE MATIN DE PARIS

- HISTORIA

Attendu que M^e^ ROBLIN, Avoué à la Cour, s'est régulièrement Constitué par acte du Palais en date du ................ pour le compte de la LICRA.

I. ― LES FAITS ET PROCEDURE

Attendu qu'il convient de rappeler qu'à partir de novembre 1978, Monsieur Robert FAURISSON a publié divers écrits dans lesquels il prétendait que « HITLER n'a jamais ordonné ni admis que quiconque fut tué en raison de sa race ou de sa religion » et que les chambres à gaz dont se sont servis les Nazis pour exterminer des millions d'individus n'auraient jamais existé.

Qu'à l'appui de sa thèse, Monsieur Robert FAURISSON, arguant de ses titres universitaires de Maître de Conférence à l'Université de Lyon, soutenait qu'après 14 ans de réflexion personnelle et 4 ans d'une « enquête acharnée », il avait la certitude que « les prétendues chambres à gaz », à la réalité desquelles il avait d'abord cru, n'avaient en réalité jamais existé.

Que se voulant « porteur d'une bonne nouvelle pour la pauvre humanité » à qui il était chargé de la révéler, Monsieur Robert FAURISSON proclamait que « les prétendues chambres à gaz hitlériennes et le prétendu génocide des juifs forment un seul et même mensonge historique ».

Attendu que cette thèse a été publiée notamment dans un article du « MATIN DE PARIS » en date du 16 novembre 1978, puis répétée par trois fois au titre du droit de réponse dans le journal « LE MONDE » aux dates des 16 et 29 décembre 1978 et 16 janvier 1979.

Qu'à la suite de ces publications, la LICRA a assigné Monsieur Robert FAURISSON devant le Tribunal de Grande Instance de Paris pour

- 25 -

le voir condamner, en raison du préjudice moral que lui portent ses allégations.

Attendu qu'a la suite d'une mise en état particulièrement longue et qui a notamment impliqué que soient versés aux débats et consultés par les parties à l'instance, les documents de la procédure militaire ouverte après la guerre contre les responsables des exactions commises au camp de concentration du Stutthof [sic, pour Struthof] que Monsieur FAURISSON désignait également dans ses écrits pour mettre en doute qu'une chambre à gaz y eut jamais fonctionné, le Tribunal a fait droit aux demandes de la LICRA en condamnant Monsieur Robert FAURISSON, d'une part à 1 F. de dommages-intérêts au titre du préjudice moral subi, et d'autre part, à assumer les frais financiers afférents à la publication du jugement entrepris.

Que Monsieur Robert FAURISSON a fait appel de ce jugement ainsi que les divers intervenants à cette instance.

II. ― DISCUSSION

1°. ― L'irrecevabilité de l'action de la LICRA et des autres Associations demanderesses :

Attendu que Monsieur Robert FAURISSON reprenant purement et simplement l'argumentation qu'il avait développée en première instance soutient que les actions des Associations intimées sont irrecevables en vertu des moyens suivants :

a) Qu'il affirme en premier lieu qu'aucune des Associations concluantes ne prétend avoir été victime en tant que personne morale « d'injures, de diffamation ou de malveillance fautive », et qu'elles sont dès lors irrecevables en leur action, n'ayant pas qualité à agir « pour réclamer la réparation des atteintes qu'aurait porté, selon elles, Monsieur Robert FAURISSON au prétendu intérêt collectif de leurs membres ».

Mais attendu qu'il est aujourd'hui de jurisprudence constante qu'une Association est recevable à demander réparation d'un préjudice, résultat des atteintes portées à son objet ou en rapport avec « la spécialité du but et l'objet de la mission de l'Association ».

Qu'en l'espèce, la LICRA a subi un préjudice répondant à ces définitions, distinct aussi bien de celui subi par ses membres que du préjudice supporté par la société toute entière dont seul le Ministère public peut poursuivre la réparation.

b) Que d'autre part Monsieur Robert FAURISSON prétend que même à admettre le droit pour les Associations d'agir dans l'intérêt collectif de leurs membres, encore faudrait-il « que les actions et interventions soient liées strictement à l'objet de chacune des Associations, et non génériquement à un trouble porté à l'ordre public ou à l'intérêt général que seul le Ministère Public a vocation, par hypothèse pour défendre dans le cadre des lois et règlements ».

- 26 -

« Qu'en l'espèce, aucune des Associations requérantes n'ont un objet qui postule la défense de telle ou telle thèse historique relative à des réalités passées, et pour l'heure concernant la nature véritable de l'univers carcéral du III^e^ Reich ».

« Que dès lors, il convient de réformer le jugement entrepris puisque les Associations demanderesses ou intervenantes ne pouvaient trouver un intérêt à agir, si ce n'est celui qui réside dans la volonté d'imposer à l'opinion l'idée que leur Président ou représentant des membres se font, nonobstant les différents objets sociaux, d'une tranche dramatique et controversée de l'Histoire du XX^e^ Siècle ».

Attendu que la thèse soutenue par Monsieur Robert FAURISSON peut être résumée en deux propositions principales :

- « HITLER n'a jamais ordonné ni admis que quiconque fut tué en raison de sa race ou de sa religion ».

- « Les prétendues chambres à gaz hitlériennes et le prétendu génocide des Juifs forment un seul et même mensonge historique ».

Attendu que ces affirmations publiées dans un esprit soi-disant purement scientifique, articulent implicitement mais nécessairement à l'égard de ceux qui sont rescapés de cette tragédie, l'imputation d'être des menteurs ;

Qu'au surplus, il est apparu en cours de mise en état de la procédure de première instance que ces allégations avaient pour fonction de servir à Monsieur FAURISSON de préparer l'articulation d'imputations encore beaucoup plus graves à caractère expressément raciste, ainsi qu'il résulte des propos qu'il a tenus le 17 décembre 1980 sur les ondes de la station de radio périphérique « Europe 1 » et qui sont rappelés par le Tribunal, sans que leur réalité soit contestée par Monsieur FAURISSON et qui sont les suivantes :

Les prétendues chambres à gaz hitlériennes et le prétendu génocide des juifs forment un seul et même mensonge historique qui a permis une gigantesque escroquerie politico-financière dont les principaux bénéficiaires sont l'état d'Israël et le sionisme international, et dont les principales victimes sont le peuple allemand ― mais non pas ses dirigeants ― et le peuple palestinien tout entier.

Attendu que La LICRA, Association régulièrement déclarée, se propose selon ses statuts de :

- lutter par tous les moyens en son pouvoir contre le racisme et l'antisémitisme qui déshonorent l'humanité,

- défendre par une action à la fois préventive et positive le droit à l'existence et à la paix des victimes du racisme dans le monde entier,

- réaliser par l'union des hommes et des femmes de toutes opinions le rapprochement des peuples, la paix entre les races et l'égalité parmi les hommes ;

- 27 -

Attendu que la remise en cause de l'extermination des populations à raison de leur appartenance à une race dont l'Allemagne nazie s'est rendue coupable sous l'influence et les directives du Chancelier Adolph Hitler et la remise en question des chambres à gaz qui ont été utilisées comme moyen pour parvenir à cette solution finale, constituent une atteinte aux intérêts collectifs des membres de la LICRA ;

Attendu en effet que le rappel et le respect de la vérité historique qui a conduit à l'extermination industrielle et organisée de plus de 6 millions de personnes en raison de leur appartenance à une race par la mise en œuvre d'une politique et d'une organisation criminelle, constituent précisément les moyens de lutte contre le racisme et l'antisémitisme, puisqu'ils permettent de démontrer les aberrations et les crimes que ces fléaux ont engendrés au cours de l'histoire contemporaine ;

Attendu que la déclaration précitée du 17 décembre 1980 est la démonstration ― si celle-ci devait encore être nécessaire ― a posteriori que les affirmations exprimées dans LE MATIN DE PARIS et LE MONDE du 16 novembre 1978 au 16 janvier 1979 portaient une atteinte directe à l'action que la LICRA se propose de mener dans ses statuts ;

Attendu que dans ces conditions, c'est à bon droit que le Tribunal a constaté que les écrits de Monsieur Robert FAURISSON « portent directement atteinte aux intérêts légitimes dont les Associations ont la charge et pour la défense desquels elles ont été créées ».

*

* *

2°. ― Sur les fautes commises par Monsieur FAURISSON au sens des articles 1382 et 1383 du Code Civil :

Attendu que Monsieur FAURISSON a commis dans l'exercice de son travail, dont il prétend rendre compte dans les articles de presse visés, un certain nombre de fautes :

1. ― Qu'il a tout d'abord abusivement écarté, et sans en justifier sérieusement, un certain nombre de sources judiciaires importantes.

Ainsi, il écarte les documents recueillis par la Justice polonaise après la guerre.

Il écrit à cet égard :

« Les chambres à gaz de Pologne (...) n'ont pas eu plus de réalité. C'est aux appareils judiciaires polonais et soviétiques que nous devons l'essentiel de notre information sur elles. (Voyez par exemple l'ébouriffante confession de R. Höss, commandant à Auschwitz) » (article du Monde, 29 décembre 1978).

- 28 -

Que FAURISSON ne s'exprime pas plus sur cette question pour expliciter l'insinuation qu'il fait au regard de la Justice polonaise.

Qu'en vérité, de source soviétique, il n'en existe pas et pour ce qui concerne les pièces rassemblées par la Justice polonaise, celles-ci sont pour l'essentiel constituées de documents d'origine allemande recueillis par la Justice polonaise.

Qu'il s'agit des ruines proprement dites des crématoires, des plans et indices et des archives laissées sur place par les S.S.

Attendu qu'au surplus FAURISSON ne s'explique pas sur les raisons pour lesquelles il écarte les actes et jugements rendus par le Tribunal international de Nuremberg, les Tribunaux allemands et autrichiens et enfin les Tribunaux militaires anglais et français ;

Attendu que Monsieur FAURISSON ne s'explique pas non plus sur les raisons pour lesquelles il écarte les aveux de Rudolph HÖSS et les expertises judiciaires de la Justice polonaise faites précisément au sujet des chambres à gaz dont il ne craint pas d'affirmer faussement que jamais aucune expertise judiciaire n'a été accomplie à leur sujet ;

Attendu enfin, que Monsieur FAURISSON écarte en quelques mots la plupart des témoignages recueillis auprès des rares rescapés des Sonderkommando sans plus s'expliquer sérieusement sur les raisons pour lesquelles ceux-ci seraient suspects.

Attendu qu'il écarte également sans aucune explication, outre Rudolph HÖSS, les témoignages et récits d'autres exécutants S.S. tels que Johan Paul KREMER, médecin à Auschwitz, Friedrich ENTRESS, médecin de camp à Auschwitz, Perry BROAD, ou encore des hommes tels que Kurt GERSTEIN ;

Attendu qu'outre des pièces abusivement écartées par FAURISSON, il s'avère que celui-ci a au surplus omis, par une négligence coupable, de mentionner des documents importants allant à l'encontre de sa thèse.

2. ― Les omissions de Monsieur FAURISSON :

Attendu qu'il s'avère et qu'il est prouvé que Monsieur FAURISSON n'a pas pris contact avec la Commission centrale d'Investigation sur les crimes hitlériens en Pologne, qu'ayant contacté le Musée d'Auschwitz il n'a fait aucune recherche de documents concernant à proprement parler l'extermination des Juifs dans les chambres à gaz d'Auschwitz.

Qu'il n'a pas pris de contact ni à Munich, ni à Ludwigsburg auprès de l'Institut d'Histoire contemporaine mondialement connu pour ses archives sur la question discutée par FAURISSON.

- 29 -

Attendu que FAURISSON a tu un certain nombre de documents importants relatifs à la décision de Hitler de procéder à la destruction physique des Juifs.

Qu'il omet volontairement les déclarations d'EICHMANN lors de son procès à Jérusalem, d'Albert SPEER dans son ouvrage Technique et Pouvoir ni de l'ordre donné par le Reichsmarechal GOERING ou de l'allocution d'HIMMLER, non plus que du compte-rendu de la Conférence dite de Wannsee du 20 juin 1942 suivant un procès-verbal établi par EICHMANN lui-même.

Attendu que FAURISSON se tait également sur l'existence des nombreux documents relatifs aux camions servant au gazage.

*

 * *

Attendu qu'après avoir écarté indûment des documents fondamentaux, d'avoir omis d'évoquer d'autres pièces et témoignages essentiels, Monsieur FAURISSON n'hésite pas à procéder à de véritables dénaturations de textes.

3. ― Les dénaturations de textes :

Attendu qu'il en est ainsi des dénaturations du journal de KREMER (cité ci-dessus), ou des aveux écrits de sa main par Rudolph HÖSS.

Attendu que des dénaturations grossières sont également commises tant en ce qui concerne les écrits de Madame Olga WORMSER-MIGOT, de Monsieur BROSZAT ou du rapport de la Croix-Rouge au camp d'Auschwitz.

4. ― Attendu enfin que Monsieur FAURISSON se livre à des interprétations techniques fallacieuses pour accréditer sa thèse.

Attendu qu'il en est ainsi à propos de l'interprétation d'un document SS relatif au crématoire n° 2 d'Auschwitz daté du 29 janvier 1943 où apparaît le terme allemand de « Wergasungskeller » qui se traduit par cave de gazage et dont seul, et sans l'appui d'aucun interprète officiel, il prétend qu'il devrait signifier chambre de carburation.

Qu'à cet égard, la demanderesse, intimée en appel, a produit deux avis d'Experts signés de Monsieur Victor BORTEN, Expert-traducteur assermenté auprès de la Cour d'Appel et du Tribunal de Grande Instance de Paris, au sujet de cette interprétation, sans que Monsieur FAURISSON n'ait pu opposer autre chose que des sarcasmes.

Attendu surtout que Monsieur FAURISSON se permet, sans conforter son avis par celui d'aucun spécialiste de ces questions, de récuser la valeur des aveux de Rudolph HÖSS quant à la possibilité de procéder rapidement à l'évacuation des chambres à gaz après que les opérations

- 30 -

de gazage se soient effectuées.

Qu'il est remarquable de relever à ce sujet que :

a) Faurisson, dans l'article du 16 janvier 1979 dans LE MONDE, procède à une véritable manipulation du texte de l'aveu de Rudolph HÖSS et,

b) a intentionnellement omis de citer l'avis de Monsieur Louis TRUFFERT, toxicologue, Expert honoraire près la Cour d'Appel de Paris, ex-liste nationale, Membre du Conseil Supérieur d'Hygiène Publique de France et Président de l'Association Internationale d'Expertise Scientifique qui, consulté par lui, lui a donné des indications démentant pour lui la possibilité de donner l'interprétation qu'il a exprimée dans les colonnes du Monde.

Monsieur TRUFFERT a écrit à l'Avocat de la LICRA le 16 février 1981 que :

J'ai reçu l'année dernière Monsieur FAURISSON qui m'a posé un certain nombre de questions, mais je ne vois rien, dans les réponses que je lui ai faites, qui permette de conclure que les Allemands n'avaient pas utilisé des chambres à gaz avec émission d'acide cyanhydrique, provenant du Zyklon B.

Que dans cette même lettre Monsieur TRUFFERT conclut :

Il ne me paraît nullement impossible que des personnes non munies de masques à gaz pénètrent sans inconvénient dans une chambre à gaz contenant des corps nus dont la température devait encore dépasser 26° (donc non susceptible de retenir du toxique par absorption) pour peu que celle-ci ait été ventilée, même très modérément.

Attendu que les faits énumérés ci-dessus constituent les fautes définies aux articles 1382 et 1383 du Code civil,

Attendu que la responsabilité civile de Monsieur FAURISSON se trouve donc ainsi engagée.

Qu'il y a lieu d'indemniser l'Association concluante du préjudice subi qui en est la conséquence.

*

 * *

Attendu que la LICRA a été contrainte d'engager des frais importants de traduction nécessités par la présente procédure.

Que par conclusions signifiées le 9 octobre 1980, elle concluait et demandait au Tribunal de dire que les dépens de l'instance aux remboursements desquels elle demandait que Monsieur FAURISSON fut condamné comprennent les frais de traduction et de photocopie exposés par la LICRA.

- 31 -

Attendu qu'il n'a pas été fait droit à cette demande, au surplus même pas évoquée par le Tribunal.

Attendu qu'il convient donc sur ce point d'émander le jugement dont appel, et de faire droit à la demande de la LICRA.

PAR CES MOTIFS

Confirmer en tous points le jugement dont appel,

L'émandant pour le surplus :

Dire et juger que les débours au remboursement desquels Monsieur FAURISSON sera condamné comprendront les frais et honoraires engagés auprès des Traducteurs-Jurés.

Condamner M. FAURISSON en tous les dépens de 1^ère^ instance et l'appel dont le montant pourra être recouvré directement par M^e^ ROBLIN Avoué dans les conditions de l'art. 699 du NCPC

SOUS TOUTES RESERVES

ET CE SERA JUSTICE.

- 32 -

CONCLUSIONS du PROFESSEUR FAURISSON

déposées devant la Cour d'appel de Paris le 11 octobre 1982)

PLAISE A LA COUR

Attendu, pour répliquer aux conclusions régularisées pour la LICRA par acte du Palais en date du 14 mai 1982, qu'il convient de rappeler encore une fois que la demande initiale reposait sur une simple et sommaire imputation précise, quoique jamais explicitée, à savoir que le Professeur Faurisson avait :

-- « volontairement tronqué » le témoignage de Johann Paul KREMER (assignation introductive, page 3, 1° alinéa) ;

Attendu que les conclusions susvisées, après trois ans et trois mois de procédure, ont eu le mérite de circonscrire enfin relativement la demande (la longueur de la procédure fut imputable à la LICRA qui, quoique Monsieur Faurisson eût conclu dès le 2 octobre 1979, mit deux ans à rechercher des pièces pour justifier a posteriori son assignation, au mépris de l'article 56 du Nouveau Code de Procédure Civile, avant-dernier alinéa) ;

Attendu qu'au vu desdites conclusions de l'intimée, il est possible en effet de mieux cerner la demande, la LICRA reprochant, moins génériquement cette fois, à Monsieur Faurisson ses thèses et certains de ses articles de presse, articles énumérés dans la demande initiale non limitativement (« divers écrits », lisait-on dans l'assignation introductive, avant l'énumération de quatre articles précédés de l'adverbe « notamment ») ;

Attendu que ces articles de presse étaient et semblent demeurer ceux publiés dans :

1° Le Matin de Paris du 16 novembre 1978 ;

2° Le Monde du 16 décembre 1978 ;

3° Le Monde du 29 décembre 1978 ;

4° Le Monde du 16 janvier 1979 ;

- 33 -

Attendu qu'on notera que l'article du Matin de Paris invoqué doit être écarté, s'agissant de l'œuvre largement mensongère d'un journal (au demeurant condamné pour diffamation envers le Professeur Faurisson) ;

Attendu que doit de même être écarté l'article publié par Le Monde du 16 décembre 1978 (page 12), Monsieur Faurisson n'y ayant pas exposé ses thèses mais seulement élevé une protestation contre les vexations, intimidations et violences dont il était victime ;

Attendu que les deux articles restants étaient nécessairement concis, puisqu'il s'agissait, dans un cas, d'un espace parcimonieusement accordé au Professeur Faurisson par Le Monde (numéro du 29 décembre 1978) et, dans l'autre cas (Le Monde du 16 janvier 1980), d'un « droit de réponse » étroitement limité par les règles du genre ;

Attendu que l'intimée n'hésite pas à utiliser de prétendus arguments qui sont étrangers à ces articles ;

Attendu toutefois que les conclusions en appel de la LICRA permettent de mieux définir ce que cette association reproche au Professeur, à savoir de n'avoir pas, dans la concision desdits articles ― et donc « en quelques mots » [conclusions de la LICRA, ci-dessus, page 29, 6^e^ alinéa] ― , donné exhaustivement ses justifications ;

Attendu que, si la Cour devait suivre le raisonnement de la LICRA, il faudrait tout d'abord détailler ce qui relève de la conviction de Monsieur Faurisson d'une part (éléments subjectifs incontrôlables), et ce qui relève des prétendues omissions ou dénaturations des éléments matériels d'autre part ;

Attendu qu'il faudrait ensuite à la Cour, motif pris de ce qu'aucune omission ne saurait être tolérée, déclarer illicite le genre du « résumé » au profit des seules œuvres complètes (?), à condition que celles-ci épuisent les sujets abordés, exigence manifestement absurde ;

- 34 -

Attendu qu'il convient de remarquer qu'on en reste à deux imputations suffisamment explicitées pour permettre la discussion, à savoir le reproche fait à l'appelant d'avoir :

1° dénaturé le journal de Johann Paul Kremer (imputation que la LICRA ne cherche pas même à fonder en raison) ;

2° omis de citer l'avis de Louis Truffert, toxicologue (argument « exhaustiviste » apparu en cause d'appel) et interprété incorrectement le mot allemand « Vergasungskeller », comme l'auraient prouvé deux avis d'expert de Monsieur Borten (première esquisse d'une démonstration après plus de trois ans d'attente) ;

Attendu que pour le reste la LICRA n'oppose à l'appelant que des généralités qu'elle prétend appuyer par des kilos de pièces versées en vrac au débat en espérant voir Messieurs les Président et Conseillers de la Cour y mettre de l'ordre pour reconstituer une logique introuvable ;

Attendu qu'en dépit de cela, et pour bien marquer la faiblesse du travail de son adversaire, le Professeur Faurisson entend répondre jusqu'aux moindres allusions de la LICRA, si vagues soient-elles ;

Attendu, pour la compréhension de l'exposé qui suit, que l'appelant se propose de traiter les trois points suivants :

I. Le travail de l'appelant est de caractère scientifique.

II. L'appelant est en mesure de répondre à chaque objection de l'intimée.

III. La LICRA, dans sa légèreté, ne soupçonnait pas la complexité du problème posé.

- 35 -

I. Le travail de l'appelant est de caractère scientifique

Attendu que la thèse de Monsieur Faurisson, professeur à l'Université Lyon-2 et membre du comité de rédaction de l'Institute for Historical Review de Los Angeles, est celle de tout un courant de pensée historique dit « révisionniste » et qu'elle constitue, dans le cas particulier de l'appelant, le fruit d'un travail méthodique et acharné qui s'est étendu sur de nombreuses années ;

Attendu que même les adversaires de l'appelant, qui sont les tenants de la thèse dite « officielle » ou « exterminationniste », y compris celui d'entre eux qui ose le traiter de « falsificateur », sont obligés de rendre à l'appelant cet hommage qu'il a :

usé un nombre incalculable de journées de travail dans les archives françaises ou allemandes (Professeur P. Vidal-Naquet, « Un Eichmann de papier », Esprit, septembre 1980, page 25) ;

Attendu que même la plus grande autorité mondiale de l'école officielle, le Professeur américain Raul Hilberg, qui, lui, s'abstient de toute attaque contre l'appelant, vient de déclarer :

Je dirai que, d'une certaine manière, Faurisson et d'autres, sans l'avoir voulu, nous ont rendu service. Ils ont soulevé des questions qui ont eu pour effet d'engager les historiens dans de nouvelles recherches. Ils nous ont obligés à rassembler davantage d'informations, à réexaminer les documents et à aller plus loin dans la compréhension de ce qui s'est passé (Le Nouvel-Observateur, 3 juillet 1982, page 71, A) ;

Attendu que le Professeur Hilberg, auteur de l'ouvrage de référence The Destruction of the European Jews, a depuis 1961 montré que, tout compte fait, pour un historien sérieux, il ne pouvait pas y avoir eu de chambres à gaz homicides ailleurs qu'en six points de Pologne occupée : Kulmhof, Majdanek-Lublin, Treblinka, Sobibor, Belzec et Auschwitz ;

- 36 -

Attendu que, dans la livraison susmentionnée du Nouvel-Observateur, le Professeur Hilberg confirme ses conclusions de 1961 (voy. page 12, début de colonne A), ce qui exclut ainsi définitivement la possibilité de gazages homicides dans des camps où, selon une tradition historique généralement accréditée, ils avaient eu lieu :

- pour l'Allemagne : à Dachau, à Buchenwald, à Ravensbrück, à Oranienburg- Sachsenhausen, à Neuengamme, à Bergen-Belsen, ...

- pour l'Autriche : à Mauthausen, à Gusen, à Hartheim, ...

- pour la France : au Struthof-Natzweiler ;

- pour la Pologne : au Stutthof-Danzig ;

Attendu que, pour en revenir aux six camps de Pologne occupée susmentionnés, le Professeur Hilberg affirme que :

- pour Belzec, Treblinka et Sobibor, nous ne possédons pas de documents, pas même un plan des bâtiments (voy. page 72, colonnes B et C) ;

- pour Kulmhof, « c'étaient des camions. Ils en avaient amené deux ou trois » (voy. page 72, colonne A) : affirmation à l'appui de laquelle le Professeur Hilberg mentionne « une masse de documents allemands » ;

- pour Majdanek-Lublin, comme d'ailleurs pour tous les autres camps, les Allemands « ont pris soin de ne rien laisser derrière eux après la guerre » (voy. page 71, colonne C) ;

- pour Auschwitz, les preuves de gazages homicides seraient les suivantes : aveux du premier des trois commandants successifs (confessions de Rudolf Höss), « photos prises par des réseaux polonais, communistes généralement », photos « prises par avion, par les services de renseignement alliés. On y voit des colonnes de gens entrant dans les chambres à gaz », « documents sur les livraisons de gaz précisant que c'est du matériel destiné à des "regroupements juifs". Cela ne signifie pas désinfection. » ;

Attendu que, sur ce dernier point, l'interviewer demande au Professeur Hilberg : « Qu'est-ce qui nous interdit de le penser ? Cela aurait pu n'être qu'un désinfectant ? » et qu'il lui est répondu : « Pas dans ces quantités. Bien sûr qu'ils ont aussi désinfecté quelques vêtements ... » ;

- 37 -

Attendu que l'interviewer insiste et demande : « Dans les mêmes chambres ? » et qu'il lui est répondu : « Peut-être ... » (voy. page 76, colonnes B et C) ;

Attendu que, pour sa part, l'appelant remarque que dans le cas des gazages homicides d'Auschwitz, la thèse officielle n'est plus soutenue que par des preuves rares et fragiles, dont il est aisé de montrer, en les prenant une à une, qu'elles n'ont en réalité pas la valeur qu'on leur accorde ;

Attendu, d'autre part, que l'école historique officielle a dû opérer, de 1960 à 1982, toute une série de révisions déchirantes, tant en ce qui concerne, ainsi qu'on vient de le voir, les prétendus gazages homicides qu'en ce qui concerne :

- l'existence d'un ordre d'exterminer les Juifs ;

- le chiffre des six millions de morts juives ;

Attendu que, lors du récent colloque de la Sorbonne et des Hautes Etudes sur « l'Allemagne nazie et l'extermination des Juifs » (Paris, 28 juin-2 juillet 1982), colloque présidé par MM. les Professeurs Raymond Aron et François Furet, on reconnaissait n'avoir, en trente ans de recherches, trouvé aucun ordre d'extermination des Juifs provenant soit de Hitler, soit de l'un des siens, et que l'existence d'un tel ordre n'était pas démontrée « par les recherches les plus érudites » (conférence de presse du 2 juillet 1982, à la Maison des Sciences de l'Homme) ;

Attendu qu'une autre grande autorité mondiale de l'école officielle, le Dr Martin Broszat, directeur de l'Institut d'Histoire Contemporaine de Munich, a dû convenir devant un tribunal de Francfort que le chiffre des six millions n'est qu'un « chiffre symbolique » (3 mai 1979, procès 50 Js 12 828/79 919 Ls contre Erwin Schönborn) ;

Attendu que selon l'appelant cette estimation exorbitante sera l'objet de considérables révisions en baisse, comme cela a été le cas pour le nombre des Juifs déportés de France (voy. Réponse à Pierre Vidal-Naquet, page 23) ;

- 38 -

Attendu d'autre part que, pour en venir à la thèse même de l'appelant, il convient de rappeler que celle-ci a été, jusqu'à ce jour, notamment développée dans les publications suivantes :

- Le Monde du 29 décembre 1978, page 8 : « La Rumeur d'Auschwitz » ;

- Le Monde du 16 janvier 1979, page 13 : « Une lettre de M. Faurisson » ;

- Vérité historique ou vérité politique ? / Le dossier de l'affaire Faurisson. La question des chambres à gaz, par Serge Thion (du CNRS), éditions de la Vieille Taupe, 1980, 352 p. ; parmi les documents figurent notamment la « pétition Chomsky » (page 163), une longue interview de Robert Faurisson à Storia Illustrata, août 1979 (pages 171-212), une étude de Robert Faurisson intitulée : « Le Journal d'Anne Frank est-il authentique ? » (pages 213-300), des documents et photographies sur la chambre à gaz de Baltimore ; une documentation photographique sur les chambres à gaz de désinfection d'Auschwitz, sur la prétendue chambre à gaz homicide du Struthof, sur la chambre à gaz pour touristes présentée à Auschwitz-I dont il est prouvé par deux photos d'archives, découvertes par le Professeur Faurisson, qu'il s'agit d'une chambre froide transformée ultérieurement en abri antiaérien ; sur les grands crématoires d'Auschwitz-Birkenau (photos de plans, des bâtiments achevés, des ruines) (pages 301-321) ;

- Mémoire en défense contre ceux qui m'accusent de falsifier l'histoire / La question des chambres à gaz, par Robert Faurisson (de l'Université Lyon-2), éditions de la Vieille Taupe, 1980, 279 p. ; parmi les documents figurent notamment « Quelques commentaires élémentaires sur le droit à la liberté d'expression », signés du Professeur Noam Chomsky ; une étude précise du journal du Professeur de médecine Johann Paul Kremer et de ses « confessions » à l'appareil judiciaire polono-communiste (page 13-148) ; une étude technique sur l'impossibilité matérielle des "chambres à gaz" homicides d'Auschwitz et notamment la reproduction d'un document allemand intitulé: "Directives pour l'utilisation de l'acide prussique (Zyklon) en vue de l'extermination de la vermine (désinfection)" ; la lettre du

- 39 -

19 août 1960 publiée par l'hebdomadaire Die Zeit intitulée « Aucun gazage à Dachau » et révélant qu'en fin de compte, pour le Dr Martin Broszat, il n'avait existé aucun gazage homicide dans tous les camps situés sur le territoire de l'Ancien Reich (Allemagne dans ses frontières de 1937), mais seulement, « avant tout » (?) en de rares points de Pologne occupée : à Auschwitz-Birkenau, à Sobibor, à Treblinka, à Kulmhof et à Belzec (pages 179-184) ; une étude qui constitue un retour en arrière sur les innombrables « preuves » et « témoignages » qui avaient servi et qui parfois servent encore à « prouver » l'existence de gazages homicides dans les camps de Buchenwald ou de Dachau, laquelle étude donne la mesure de la crédulité générale, y compris chez les hommes de science, chez les magistrats, chez les historiens, dans le monde ecclésiastique, etc. (pages 185-222) ; une étude sur « les tricheries de la LICA et tous autres » (pages 225-228) ; un rapport de la Croix-Rouge internationale sur la rumeur de gazages homicides à Auschwitz (cette rumeur circulait loin du camp, mais, dans le camp lui-même, elle semble avoir été ignorée par les détenus) (pages 241-247) ; un échange de correspondance entre le Professeur Faurisson et Monsieur Jean Daniel, du Nouvel-Observateur, où il est notamment question du témoignage de Filip Müller intitulé Trois ans dans [sic] une chambre à gaz d'Auschwitz : le témoignage de l'un des seuls rescapés des commandos spéciaux, Pygmalion/Gérard Watelet, 1980, 252 p., préface de Claude Lanzmann ;

- Réponse à Pierre Vidal-Naquet, édité par Robert Faurisson, 1982, 64 p. ; cet ouvrage propose une réponse à tous les arguments, sans exception aucune, que le Professeur P. Vidal-Naquet avait cru devoir développer dans un texte d'abord publié par la revue Esprit, septembre 1980, pages 8-56, puis repris dans son ouvrage : Les Juifs, la Mémoire et le Présent, Maspero, 1981, pages 196-289 ; cette réponse se clôt sur des remarques inspirées au Professeur Faurisson par l' « Exposition de la déportation 1933-1945 », tenue sur l'esplanade du Trocadéro (fin avril ― début mai 1982) sous l'égide du Ministère des Anciens Combattants ; la conclusion signée de Robert Faurisson était la suivante :

- 40 -

D'une façon générale, cette exposition officielle de 1982 marque une évolution intéressante du mythe des chambres à gaz homicides : les fragments que l'on nous montre de prétendues chambres à gaz homicides se font de plus en plus petits. On va vers l'infinitésimal, le zéro, le néant. Déjà beaucoup de ces chambres à gaz homicides ne sont plus montrées du tout : on se contente de nous montrer le bâtiment qui est censé les contenir.

Attendu que, pour se limiter au monde scientifique français, ces trois publications, ainsi que celles de Paul Rassinier, ancien déporté (Le Mensonge d'Ulysse, Ulysse trahi par les siens, Le Véritable procès Eichmann, L'Opération « Le Vicaire » (à propos des « confessions » de Kurt Gerstein), Le Drame des Juifs Européens), constituent quelques-uns des ouvrages de base, à lire de près, pour quiconque entend affirmer ou nier l'existence des « chambres à gaz » et du « génocide », sans se limiter à ce qu'il croit savoir de la question par les journaux, la radio, la télévision et les publications qui soutiennent la thèse officielle ;

Attendu que, s'agissant d'un sujet aussi controversé (aujourd'hui qualifié de délicat, voy. « Le nazisme et les mécanismes du génocide » par Pierre Assouline, L'Histoire, n° 46, juin 1982, page 71 : « L'Allemand Wolfgang Scheffler (Berlin) aura la délicate tâche de parler des chambres à gaz »), il sied de ne formuler une opinion qu'après avoir entendu avec le moins de passion possible les arguments de l'une et l'autre parties ;

II. L'appelant est en mesure de répondre à chaque objection de l'intimée

Attendu que l'appelant est en mesure de répondre ci-après à chaque objection de l'intimée dans l'ordre choisi par celle-ci pour ses conclusions du 14 mai 1982 ;

- 41 -

Attendu, pour commencer, que l'intimée reproche à Monsieur Robert Faurisson d'avoir écrit : « Hitler n'a jamais ordonné ni admis que quiconque fût tué en raison de sa race ou de sa religion » [ci-dessus page 27, 3° alinéa] ;

Attendu que, pour répondre à ce premier grief, l'appelant, qui n'a jamais nié ni les persécutions, ni les massacres de la guerre, insiste sur le mot de « tué » et que, pour l'explication de cette phrase, que confirme au moins dans sa partie essentielle le récent colloque de Paris susmentionné, il suffit de se reporter à la page 91 de Vérité ... où se trouve un développement intitulé : « Explication de cette phrase » ;

Attendu que l'appelant ajoute qu'à l'heure actuelle, en plus des documents qu'il signale dans la note 45 des pages 210-211 de Vérité ..., il existe trois documents au moins montrant que Hitler, soucieux avant tout de gagner la guerre, repoussait à la période de l'après-guerre la recherche de la solution de la question juive :

- le document Zeltschel du 21 janvier 1941 ;

- le « libre-propos » d'Adolf Hitler du 24 janvier 1942 (Vérité... page 188 et note 44 de la page 210) ;

- le document PS-4025, non utilisé aux procès de Nuremberg, daté de mars-avril 1942, et dont le résumé dû à l'officier américain interprète est le suivant : « Note stating that Hitler intended to postpone solution of the Jewish problem until after the war » (Note établissant que Hitler avait l'intention de repousser à l'après-guerre la solution du problème juif) ; ce document n'est pas même mentionné par la bibliographie « Holocaust » de Jacob Robinson, Yad Vashem, Jérusalem, 1976, ouvrage qui sert pourtant de référence à tout chercheur en la matière ;

Attendu que l'appelant ne se présentait pas, comme le donnent à croire les mots que lui prête l'intimée [ci-dessus, page 25, 5^e^ alinéa], en « porteur d'une bonne nouvelle pour la pauvre humanité » « à laquelle il était chargé de la révéler » ; qu'il s'agit d'une citation fautive puisque Monsieur Faurisson s'était contenté d'écrire : « L'inexistence

- 42 -

des "chambres à gaz" est une bonne nouvelle pour la pauvre humanité. Une bonne nouvelle qu'on aurait tort de tenir plus longtemps cachée » (Le Monde, 29 décembre 1978, page 8) ;

Attendu que le ton messianique ici imputé à mal à Monsieur Faurisson est une invention de la partie adverse, recopiée du vocabulaire religieux du jugement entrepris (« sur un ton quasi-messianique », page 13, 8^e^ alinéa dudit jugement) ;

Attendu que [ci-dessus page 26, 1^er^ alinéa], en ce qui concerne le Struthof, et non comme l'écrit l'intimée : le Stutthof, l'appelant rappelle (voy. ses conclusions antérieures du 25 novembre 1981, page 6, 8^e^ alinéa et suivants) qu'il s'était opposé à ce que le dossier de la Justice Militaire française concernant ce camp fût versé au débat, faute par la LICRA de justifier auparavant en quoi cela permettrait de conforter la thèse selon laquelle Monsieur Faurisson serait un « falsificateur » ;

Attendu d'ailleurs que l'intimée n'a pas exploité ce dossier, montrant ainsi sa désinvolture vis-à-vis de la Justice et son désarroi, quand les documents ne répondent pas à son attente ;

Attendu que l'on comprend ainsi l'oubli de ce dossier dont la LICRA avait demandé la production par la Justice Militaire, puisque, aussi bien, n'y figurent que des rumeurs non vérifiées dans le sens de la thèse exterminationniste et même, semble-t-il, controuvées par le seul expert toxicologue consulté, le Docteur Fabre, doyen de la Faculté de Pharmacie de Paris, dont le rapport a mystérieusement disparu et qui concluait négativement, comme l'ont reconnu dans leur propre rapport les Professeurs Simonin, Piedelièvre et Fourcade (voy. dossier de la Justice Militaire) ;

Attendu que le Professeur Faurisson versait au débat une lettre qu'il avait découverte aux Archives Nationales de Washington, émanant de la société Degesch, datée du 3 septembre 1943, prouvant qu'il ne pouvait pas y avoir eu de gazages homicides à l'acide cyanhydrique au camp du Struthof ― crime supposé perpétré en août 1943 ― , puisque les conditions d'emploi pour une périlleuse chambre à gaz insecticide au Zyklon B n'étaient pas même alors remplies (cela n'ayant rien a voir avec les essais

- 43 -

d'antidote au gaz phosgène qui provoquèrent quatre décès accidentels de détenus, après hospitalisation) ;

Attendu que figurent au dossier, pour les prétendus gazages homicides du Struthof, deux « confessions » gravement contradictoires du commandant Josef Kramer, et tout aussi absurdes l'une que l'autre, à propos de mystérieux granulés qui, versés sur de l'eau, auraient tué en une minute ;

Attendu que les absurdités et contradictions pourraient trouver leur explication dans le fait que Josef Kramer a été torturé par ses geôliers britanniques ; voy. le témoignage suivant du médecin français Docteur J. L. Fréjafon dans son livre Bergen-Belsen, préface de Louis Martin-Chauffier, Librairie Valois, 1945, XV-103 p. : « Après la libération, les [détenus] revirent le commandant Kramer de beaucoup plus près, il avait des chaînes aux pieds et d'excellents camarades de la Royal Artillerie britannique lui prodiguaient leurs plus énergiques attentions. Ils eurent un moment de relâchement en l'oubliant, par une belle nuit de mai, dans une chambre frigorifique, mais il avait la peau dure et on le retrouva au petit matin, quelque peu givré et raidi, mais toujours arrogant » (page 22) ;

Attendu que [ci-dessus, page 27] l'intimée reproche à l'appelant une phrase de soixante mots dont voici le début : « Les prétendues chambres à gaz hitlériennes et le prétendu génocide des Juifs forment un seul et même mensonge » ;

Attendu que cette phrase est hors débat puisqu'elle a été prononcée près de deux ans après l'assignation introductive ;

Attendu, cependant, que l'appelant fait observer que cette phrase constitue un résumé dont chaque mot, bien pesé, trouve son explication dans les ouvrages susmentionnés (Vérité..., Mémoire..., Réponse...) ;

Attendu, en particulier, que, comme l'appelant a eu l'occasion de le préciser le 17 décembre 1980, sur les ondes de Radio-Europe n° 1, avant même d'entamer la lecture de cette phrase, pas un seul des soixante mots qui la constituent ne lui est dicté par une sympathie ou une antipathie politique ; qu'au reste il n'est

- 44 -

ni antijuif, ni même antisioniste et que, pour ce qui est de la dernière guerre mondiale, il ne prend parti ni pour les vainqueurs ni pour les vaincus ; qu'il estime n'avoir aucune compétence pour déterminer les torts ou les raisons de quelque parti que ce soit et qu'il entend seulement se limiter à des faits vérifiables ;

Attendu que lorsqu'il parle d'un seul et même mensonge historique, il fait allusion à cent autres mensonges de l'Histoire qu'il s'agit toujours, pour un esprit libre, de débusquer et de dénoncer ;

Attendu que, pour ce qui est de l' « escroquerie politico-financière », elle est celle d'un Nahum Goldmann face au Chancelier Adenauer pour la conclusion du Traité de Luxembourg et que cette escroquerie est expliquée de façon circonstanciée aux pages 190 et 199 de Vérité... ainsi qu'à l'importante note 61 de la page 212 ;

Attendu que l'expression de « sionisme international », loin d'être une formule vague du langage antijuif, n'est que la traduction de « World Zionism », le même Nahum Goldmann ayant d'ailleurs été président de la World Zionist Organization (Organisation sioniste mondiale) ;

Attendu que, pour ce qui est de la distinction opérée entre, d'une part, le peuple allemand victime du mensonge, et, d'autre part, ses dirigeants qui n'en sont pas les victimes, cette distinction est expliquée à la page 196 du même ouvrage ;

Attendu que, en effet, l'Allemagne amputée d'un tiers de son territoire, scindée en deux états, occupée par quatre armées, est dirigée depuis 1945 par des hommes politiques qui, on peut le supposer, sont bien obligés de faire passer les contingences politiques avant le souci, propre au chercheur, de la vérité historique ; que la survie de ces deux états respectifs exige apparemment que l'Allemagne de l'est fasse entendre la voix de ses libérateurs de l'est et que l'Allemagne de l'ouest fasse entendre la voix de ses libérateurs de l'ouest ;

- 45 -

Attendu que nulle part la répression contre le nombre croissant des auteurs révisionnistes n'est plus déterminée qu'en Allemagne ; que quiconque y soutient la thèse révisionniste est poursuivi en justice pour y être condamné, selon les cas, à des peines de prison, à de lourdes amendes, à l'inscription de ses livres à l'Index, à la saisie des ouvrages et même des plombs de composition (cas de l'ouvrage scientifique du Dr Wilhelm Stäglich sur Le Mythe d'Auschwitz / légende ou réalité ?) ;

Attendu que le mythe de l'Holocauste a largement contribué à la possibilité de création d'un état comme l'État d'Israël et que le peuple palestinien tout entier est en droit de se considérer comme victime de cette création ;

Attendu que l'appelant n'a pas précisé quels étaient à ses yeux les bénéficiaires « non principaux » du mensonge historique mais qu'il est prêt à le faire maintenant en disant qu'il s'agit de l'ensemble des vainqueurs de la seconde guerre mondiale ; qu'en effet, si les chambres à gaz homicides des Allemands n'ont pas existé, le « crime de guerre » par excellence pourrait être Dresde, Hiroshima ou Katyn ;

Attendu que l'appelant n'a pas non plus précisé quelles étaient à ses yeux les victimes « non principales » mais qu'il est prêt à le faire maintenant, en disant qu'il s'agit par exemple du Vatican et du Comité international de la Croix-Rouge, tous deux accusés de n'avoir pas vu et dénoncé les « chambres à gaz » et l'Holocauste ;

Attendu qu'à propos des victimes « non principales », il convient de souligner particulièrement que les jeunes Juifs sont, eux aussi, à leur manière, les victimes de cette religion ténébreuse et aberrante de l'Holocauste ;

Attendu que cette religion de l'Holocauste donne naissance à tout un monde de phénomènes du genre de la « Victimologie », avec ses congrès et ses symposiums internationaux en Israël, en Allemagne, aux États-Unis (voy. « The Reparations Agreements: A New Perspective », par Leslie Sebba, dans The Annals of the American Academy of Political and Social Science, Philadelphie, juillet 1980, pages 202-217), à la création de « chaires universitaires d'Holo-

- 46 -

causte », détenues par des « docteurs en Holocauste », à des cours d'Holocauste dans les écoles primaires et secondaires des États-Unis accompagnés d' « expériences en Holocauste », etc. ;

Attendu que, selon l'appelant, le rappel incantatoire d'horreurs mythiques ne semble pas constituer un moyen de lutte efficace contre les haines raciales [ci-dessus, page 28, 2^e^ alinéa] ; que de telles incantations risquent de dissimuler la réalité des conflits et de rendre banales les atrocités réelles ; que la mise en spectacle de bons sentiments, la bonne conscience qui en résulte, enfin la conviction d'avoir acquis des droits particuliers alimentent une propagande de haine et de guerre qui est toujours actuelle ;

Attendu que [ci-dessus, page 28, 1^er^ alinéa] , pour l'appelant, l' « extermination » (c'est-à-dire le crime) et les « chambres à gaz » (c'est-à-dire l'arme du crime, par excellence) constituent non pas une vérité établie dont la LICRA cherche à obtenir en justice l'institutionnalisation, mais un mensonge historique qu'il appartient au chercheur de réfuter ;

Attendu que [ci-dessus, page 28, 2^e^ alinéa] le Professeur Faurisson estime qu'il est de sa liberté de chercher la vérité, c'est-à-dire ce qui est vérifiable, sans avoir à se préoccuper de ménager telle ou telle ligue ;

Attendu que [même page et même alinéa] le chiffre de plus de six millions de personnes tuées en raison de leur appartenance à une race ne repose sur aucune recherche statistique sérieuse et qu'il a été lancé au lendemain de la guerre sans même qu'on ait eu le temps de procéder au moindre décompte ;

Attendu que, ainsi qu'il a été dit plus haut, ce chiffre constitue une sorte de réalité « symbolique » [voy., ci-dessus, page 38, 5^e^ alinéa] ;

Attendu que (ci-dessus, pages 28-29), loin d'écarter les documents recueillis par la Justice polonaise après la guerre, le Professeur en fait au contraire le plus grand usage ;

- 47 -

Attendu que, pour ne prendre que quelques exemples, le Professeur Faurisson a étudié les fragments des diverses « confessions » de Höss qu'a bien voulu révéler la Justice polonaise tandis que d'autres fragments restent encore aujourd'hui inaccessibles par la décision de cette même Justice ; qu'il a étudié de près le texte des « confessions » du Professeur Johann Paul Kremer ; qu'il a lu un ouvrage publié par Jan Sehn, juge d'instruction cracovien auquel nous sommes redevables de ces « confessions » ou fragments de « confessions » ; que dans l'ouvrage de ce dernier sur le camp d'Auschwitz (Le camp de concentration d'Oswiecim-Brezezinka, Wydawnickwo Prawnicze, Varsovie, 172 p., 3^e^ édition française en 1961) l'on relève des affirmations qui donnent une idée intéressante de la personnalité de ce juge communiste, lequel n'hésite pas à écrire, par exemple, que le rendement des « chambres à gaz » de Birkenau était de près de 60.000 personnes par 24h (page 132), tandis que le préfacier du livre, directeur de cette Commission générale d'Enquête sur les Crimes hitlériens en Pologne, que la LICRA reproche au Professeur Faurisson de n'avoir pas consultée, écrit par exemple : « Au total près de quatre millions d'êtres humains ont été engloutis par Auschwitz » ;

Attendu, d'autre part, que le Professeur Faurisson s'est rendu en Pologne pour en rapporter de nombreuses archives notamment photographiques dont on trouvera un exemple avec la photographie de la page 320 de Vérité... (photo n° 12 publiée pour la première fois au monde, semble-t-il, et reproduite ci-dessous à la page 79) ; que, soit personnellement, soit par l'intermédiaire de certaines aides, il a pu obtenir des documents techniques d'origine allemande, détenus par les autorités polonaises ; qu'il a eu des échanges de correspondance avec les autorités du Musée d'Auschwitz (voy. Mémoire... pages 153-156 pour un exemple de lettre en polonais de caractère rigoureusement technique), ... ;

Attendu que [ci-dessus, page 29, 2^e^ alinéa] l'intimée prétend que l'appelant ne peut pas, comme il le dit, avoir utilisé de sources soviétiques, pour la raison que « de sources soviétiques, il n'en existe pas » ;

Attendu que cette affirmation est tout à fait inexacte ; que nous disposions au procès de Nuremberg déjà de 522 documents soviéti-

- 48 -

ques ; qu'en particulier nous disposons du résultat de l'enquête unilatérale menée par les Soviétiques à propos d'Auschwitz, ainsi qu'en témoigne l'important document URSS-008 du 6 mai 1945 qu'on trouve au tome XXXIX, pages 241-261 (compte rendu du Tribunal Militaire International), document cité et commenté dans Mémoire..., page 261 ;

Attendu qu'il existe aussi des ouvrages officiels soviétiques, comme celui de Constantin Simonov, sur Maïdanek, un camp d'extermination, traduction française par les Editions Sociales, Paris, 1945, 41 p., où l'on apprend, au passage, qu'à la différence d'Auschwitz, qui ne semble pas en avoir possédé, le camp de Majdanek avait des « machines asphyxiantes » (page 5) ;

Attendu qu'en annexe de cet ouvrage figure un « communiqué de la Commission Extraordinaire polono-soviétique chargée d'établir les forfaits commis par les Allemands au camp d'extermination de Majdanek, à Lublin » et que ce communiqué est signé de dix noms dont trois sont soviétiques (page 40) ;

Attendu que le Professeur Faurisson fait remarquer que les « documents d'origine allemande » en question ont tous leur intérêt mais que, recueillis par la Justice polono-communiste, ils ont été triés et que certains d'entre eux restent inaccessibles [voy. ci-dessus page 48, 1^er^ alinéa] ;

Attendu que [ci-dessus, page 29, 3^e^ alinéa] l'intimée parle de fours crématoires alors que la discussion porte sur les « chambres à gaz » ;

Attendu que, là, il s'agit d'un procédé coutumier à la LICRA et que Monsieur Jean Pierre-Bloch, son président, avait prétendu, sur les antennes d'Europe n° 1, le 16 décembre 1980, que Monsieur Faurisson niait l'existence des fours crématoires, le même Jean Pierre-Bloch ajoutant que les œuvres de Monsieur Faurisson étaient traduites en chinois et que Monsieur Faurisson recevait pour son travail de l'argent du Colonel Khadafi ;

Attendu que l'appelant s'explique sur les raisons pour lesquelles, loin d'écarter les actes et jugements

- 49 -

rendus par le T.M.I. de Nuremberg, par les tribunaux allemands et autrichiens et enfin par les tribunaux militaires anglais et français, il croit au contraire les analyser avec grande attention ;

Attendu que ces actes et jugements constituent une bonne partie du matériel de base que le Professeur utilise dans son travail ; qu'il est possible de vérifier ce point en constatant qu'il recourt très souvent aux documents cotés à Nuremberg PS, NO, NI, NIK, NOKW, etc. ; que, par exemple, il déplore au contraire que les historiens n'accordent pour ainsi dire aucune attention au contenu du tome XLII (voy. Vérité... page 209, note 35) ;

Attendu que le Professeur Faurisson fait souvent référence aux dix-neuf tomes jusqu'ici parus de Justiz und NS-Verbrechen (Amsterdam University Press) où se trouvent réunis un grand nombre de jugements de procès de « crimes de guerre » ;

Attendu qu'il fait référence aux nombreux procès américains (extraits publiés dans les « Green Series »), aux procès britanniques (par exemple pour Höss), aux procès français (par exemple pour Ravensbrück et pour le Struthof), aux procès autrichiens (par exemple le très intéressant procès de Walter Dejaco et de Fritz Ertl en 1972 devant la Cour de Vienne, où ces deux architectes, qui avaient construit et entretenu les grands crématoires d'Auschwitz-Birkenau, furent acquittés ; voy. Vérité... page 319) ;

Attendu que Monsieur Faurisson a passé des années au Centre de documentation juive contemporaine de Paris pour y dépouiller notamment les pièces de procès afférentes à la rubrique « Extermination-Gazage » (pièces de toutes provenances) ;

Attendu qu'en divers centres de recherche américains, en particulier aux Archives nationales de Washington, il a, soit directement, soit par personne interposée, dépouillé des centaines de documents judiciaires répertoriés dans la bibliographie susmentionnée de Jacob Robinson ;

- 50 -

Attendu que, si Monsieur Faurisson a cru devoir utiliser ces documents avec prudence, c'est que tous les tribunaux en question s'inspiraient des règles observées par le T.M.I. de Nuremberg dont les articles 19 et 21 du Statut disposent :

Le Tribunal ne sera pas lié par les règles techniques relatives à l'administration des preuves (...), n'exigera pas que soit rapportée la preuve de faits de notoriété publique, mais les tiendra pour acquis.

Attendu que bien des jugements des tribunaux alliés ont fini par être controuvés par des recherches historiques ultérieures, par exemple pour ce qui concerne la prétendue chambre à gaz de Ravensbrück ;

Attendu que le jugement entrepris rappelle d'ailleurs, non sans raison, que la vérité judiciaire est « par essence, relative » (page 11, 7^e^ alinéa dudit jugement) ;

Attendu que l'instruction de bien des procès s'est accompagnée d'actes de torture avérés ; que même le Professeur Vidal-Naquet ne conteste pas les mauvais traitements infligés à Rudolf Höss par les Anglais, au point que ce dernier a signé, sans en savoir le contenu, le document PS-3868 qui a constitué la pièce la plus importante de toutes les pièces présentées au grand procès de Nuremberg ; que, par la lecture de fragments de cette pièce, le Procureur américain dévoilait à la stupéfaction des accusés allemands et de leurs défenseurs que les Nazis avaient fait construire de gigantesques « chambres à gaz » pour l'extermination des Juifs ; que Rudolf Höss avait alors étonné tout le monde par son « apathie schizoïde » à l'audience ;

Attendu que, par exemple, au « procès de Malmédy », d'affreuses tortures « systématiques » avaient été utilisées par les Américains ainsi que l'établissait la commission d'enquête Simpson/Van Roden/Laurenzen (Vérité... page 208, note 32) ;

Attendu qu'à cet égard il y a lieu de s'interroger sur la qualité des travaux d'historiens qui, comme François Delpech, peuvent

- 51 -

penser qu'« on ne torturait pas dans les prisons alliées » (voy. Le Monde du 8 mars 1979, page 31 : « La vérité sur la solution finale ») ;

Attendu cependant que le même historien qui déclarait ainsi ne pas croire aux tortures avait le bon sens d'ajouter : « Les aveux des Nazis aux divers procès de criminels de guerre sont généralement encore plus sujets à caution [que les témoignages des survivants] et doivent être critiqués de près. » (voy. dans la revue Historiens et Géographes, « La persécution nazie et l'attitude de Vichy », mai-juin 1979, page 610) ;

Attendu que, pour ce qui est des témoins, on peut, sans mettre en doute leur bonne foi, manifester une certaine prudence et déclarer par exemple, comme l'historien Jean B. Neveux, de Strasbourg : « Mais les témoins, même s'ils utilisent ces sources [historiques] sont-ils de bons historiens ? Une fois de plus, je suis tenté de répondre négativement. A. Wolowski a en effet un parti pris : il dramatise, politise et héroïse. » (Bulletin du Comité d'Histoire de la seconde guerre mondiale, n° 236, mai-juin-juillet 1979, page 6, à propos de : Alexandre Wolowski, La vie quotidienne à Varsovie sous l'occupation nazie (1939-1945), Hachette, 1977, 381 p.) ;

Attendu que [ci-dessus, page 29, 6^e^ alinéa] le Professeur Faurisson apporte un soin particulier à l'étude des « témoignages recueillis auprès des rares rescapés des Sonderkommandos », précisément parce que ces témoignages sont « rares » ;

Attendu, par exemple, qu'il s'est attardé à l'étude du témoignage du « Témoin inconnu » qui raconte que, dans une même « chambre à gaz », après la vibrante allocution d'une jeune Polonaise nue, les Polonais, à genoux, chantaient leur hymne national, cependant que les Juifs chantaient la Hatikwa, le tout se confondant à la fin pour donner paroles et chant de l'Internationale ;

Attendu que ce dernier point a fait l'objet, de la part de la LICRA, d'une coupure volontaire (voy. nos conclusions précédentes du 25 novembre 1981, page 7, 4^e^ et 7^e^ alinéa, ainsi que

- 52 -

page 9, 2^e^ alinéa, et Mémoire ... pages 232-236) ;

Attendu que l'appelant traite aussi des témoignages, entre autres, de Martin Gray, auteur de Au nom de tous les miens, œuvre en réalité écrite par Monsieur Max Gallo et que la LICRA a cru devoir mettre au nombre des pièces déposées ;

Attendu que Martin Gray a complètement inventé son séjour à Treblinka et qu'il le reconnaît aujourd'hui sans difficulté : ne fallait-il pas témoigner pour les autres ? (voy. New Statesman, 2 novembre 1979, pages 670-673) ;

Attendu que l'appelant a traité du témoignage de Filip Muller, lequel a forgé une sorte de roman intitulé Trois ans dans une chambre à gaz d'Auschwitz (voy. Mémoire... pages 256-260 et Réponse... page 19) ;

Attendu que le Professeur Faurisson serait également prêt à montrer quelle valeur il convient d'accorder aux témoignages d'un Maurice Benroubi ou d'un Docteur Sigismond Bendel ;

Attendu surtout que la LICRA a découvert à Paris l'un de ces rares rescapés ;

- qu'il s'appelle Alter Fajnzylberg et qu'il a fait, le 6 octobre 1980, une déposition par-devant notaire, qui figure sous la cote 133 des pièces versées par la LICRA ;

- que la Cour pourrait convoquer à l'enquête ce témoin vivant dont la mémoire, au fil de ses diverses dépositions de 1945 à 1980, semble s'être améliorée ;

- que sur ce point il ne serait pas sans intérêt de comparer les pièces suivantes relatives à ce témoin, à savoir :

• la pièce 33 communiquée le 18 septembre 1979 avec traduction d'extraits par traducteur anonyme ;

• la pièce 3 communiquée le 9 juillet 1980 avec traduction d'extraits par Monsieur Victor Borten ;

• la pièce 133 communiquée le 6 octobre 1980 : déposition par-devant notaire ;

Attendu que si on veut avoir le texte complet du témoignage de ce témoin il suffit de se reporter à l'ouvrage suivant :

- 53 -

Hefte von Auschwitz (Cahiers d'Auschwitz), Sonderheft I, Handschriften von Mitgliedern des Sonderkommandos, 1972, où on retrouvera sa déposition du 16 avril 1945 devant la Justice polonaise, à Cracovie (pages 32-71 : traduction du polonais en allemand) (voy. nos conclusions antérieures du 25 novembre 1981, page 9, 9^e^ alinéa) ;

Attendu que [ci-dessus, page 29, 7^e^ alinéa] il est mensonger de prétendre que le Professeur Faurisson « écarte sans aucune explication le témoignage du Professeur Johann Paul Kremer », vu que, dans son Mémoire..., précisément rédigé pour répondre à cette imputation, il consacre à ce témoignage environ cent trente pages (pages 13-148) ;

Attendu que dans le journal de Johann Paul Kremer il n'est nullement question de « chambres à gaz » homicides et que les « confessions » obtenues par la Justice polonaise ne concordent pas du tout avec la matérialité des lieux, des actes et des écritures ;

Attendu qu'il convient de signaler ici un point d'histoire intéressant que rapporte sur le « procès de Münster » L'Anthologie (bleue) d'Auschwitz, tome I, première partie, Varsovie, 1969, pages 239-261, à savoir que le Professeur Kremer, après dix ans de captivité en Pologne, revint dans sa ville natale de Münster, reprit sa chaire d'anatomie à l'Université, protesta contre le traitement qu'il avait subi de la part de l'appareil judiciaire polono-communiste, expliqua que « seule la haine avait [eu] voix au chapitre » (page 241), « contesta les explications qu'il avait fournies pendant l'enquête à Cracovie et dont on lui donna lecture » (page 242) ;

Attendu que ces protestations avaient attiré, dit l'Anthologie, l'attention « de certains cercles et de certaines personnes qui le firent comparaître à nouveau devant la Justice » (page 239) ;

Attendu que le Professeur Kremer fut condamné par la Justice de son pays une nouvelle fois à dix ans de prison, peine dont il fut dispensé pour l'avoir déjà subie en Pologne, mais qu'on lui retira sa chaire ainsi que ses deux titres de Docteur obtenus à

- 54 -

l'Université Humboldt de Berlin (pages 275-276) ;

Attendu que le Juge d'instruction polonais Jan Sehn, convoqué par le Tribunal de Munster, affirma que dans le cas de Kremer : « une déclaration de non culpabilité aurait été incompatible avec ce que l'accusé avait écrit » (page 246) ;

Attendu que, dans sa dernière déclaration, l'accusé Kremer dit : « Si en vertu des critères humains j'ai accompli quelque chose de mal, je ne puis que prier de prendre en considération mon âge et mon tragique destin. Je n'ai connaissance d'aucune faute dans le sens juridique et pénal. Je confie au juge suprême de tous les mondes le soin de trancher un dilemme qui n'est pas simple pour l'entendement humain » (page 258) ;

Attendu que [ci-dessus, même page et même alinéa] dans le document NO-2368, on remarquera que le Docteur Friedrich Entress ne se présente pas un seul instant comme le témoin oculaire de ce qui se rapporte précisément aux prétendus gazages homicides d'Auschwitz ; qu'il débite sur le sujet un récit stéréotypé ; que toute sa déposition est manifestement rédigée pour aider la Justice américaine à mettre en cause telles ou telles personnes ; qu'elle contient une affirmation qui sera totalement infirmée quinze ans plus tard au « procès des gardiens d'Auschwitz » (à Francfort, 1963-1965), à savoir que c'était le personnel SS entraîné pour la désinfection par le Zyklon B qui gazait les détenus, puisque aussi bien à ce procès il a été établi que le responsable des opérations de désinfection, A. Breitwieser, n'avait jamais pu participer à des gazages homicides (pour l'acquittement de ce dernier, voy. H. Langbein, Der Auschwitz Prozess, page 198) ;

Attendu au surplus que le Dr Entress signait ce document alors qu'il était en attente d'une mesure de grâce, qui d'ailleurs ne vint pas puisqu'il fut pendu ;

Attendu que [ci-dessus, même page et même alinéa], à propos du SS Pery (et non pas Perry) Broad, même le Professeur Vidal-Naquet parle de « témoignages qui donnent l'impression d'adopter entièrement le langage des vainqueurs » (Esprit, article susmentionné, page 28) ;

- 55 -

Attendu que, le 20 avril 1964, devant la Cour de Francfort, Pery Broad révéla qu'il n'était pas l'auteur de la fameuse « déposition de Broad » qu'il aurait entièrement rédigée dans une prison britannique (Agence AFP, Francfort, 21 avril 1964, rapporté par le journal Le Monde du même jour) ;

Attendu que, pour savoir ce que Broad a déclaré à la Cour de Francfort, il est plus prudent de s'en remettre au livre de B. Naumann, Auschwitz-Bericht (Athenäum Verlag, Francfort/Bonn, 1965), plutôt qu'à celui de H. Langbein (Der Auschwitz Prozess, Vienne, Europa Verlag, 1965, 2 tomes), ce dernier, président du Comité international des Anciens d'Auschwitz, ayant été partie prenante dans ledit procès ; voy. dans le livre de B. Naumann les pages 49 et 50 sur Broad témoin d'un gazage de désinfection et répondant à la question du tribunal : « Avez-vous su que des transports de gens étaient tout entiers gazés ? » ― « Je n'en ai pas entendu parler et je n'ai rien vu. » ;

Attendu que [ci-dessus, même page et même alinéa] jusqu'à 1981 on connaissait cinq versions différentes et nettement contradictoires de la « confession » de Kurt Gerstein ;

Attendu à cet égard qu'un chercheur français, dont la thèse sur la « confession » de Gerstein sera publiée en 1983, vient de découvrir une sixième version où il n'est plus du tout question de « chambres à gaz » ;

Attendu que, dans cette « confession » protéiforme, les absurdités fourmillent ; que, par exemple, dans les « chambres à gaz » de Belzec l'ingénieur et chimiste Gerstein prétend avoir vu 700 à 800 hommes debout sur une surface de 25 m² (soit, si on fait le calcul, de 28 à 32 hommes au mètre carré) ; que les victimes attendent ainsi pendant 2h 49 qu'un moteur Diesel se mette en marche pour les « gazer » ; que cette absurdité se trouve répétée dans les cinq premières versions ;

Attendu que, pour les défenseurs de la légende de Gerstein, il serait radicalement impossible de lire de bout en bout devant un tribunal les quelques pages de cette « confession » et que, pour cette raison, quand on la cite, c'est toujours en découpant soi-

- 56 -

gneusement un extrait lyrique fait de clichés ; que c'est avec raison que ni un André Brissaud (Hitler et l'ordre noir, Genève, Famot, 1974, page 443), ni une Olga Wormser-Migot (Le système concentrationnaire nazi, 1933-1945, thèse, P.U.F., 1968, page 11, note 1 et page 426) n'arrivent à admettre l'authenticité intégrale de cette « confession » ou la véracité de tous ses éléments ;

Attendu que [ci-dessus, page 29, 9^e^ et 10^e^ alinéa] le Professeur Faurisson a été ou reste encore aujourd'hui en contact direct ou indirect avec ces organismes qu'on lui reproche de n'avoir pas consultés ;

- qu'il a entretenu une correspondance avec le Dr Broszat, de l'Institut de Munich et qu'il lit et cite des publications de cet Institut (par exemple, note 28 de la page 207 de Vérité...) ;

- qu'il a pris contact, en se recommandant de Monsieur Simon Wiesenthal, avec la Centrale de Ludwigsburg (M. Biener) et qu'il a lu les ouvrages de l'ancien directeur de cette Centrale, le Procureur Adalbert Rückerl ;

- qu'il connaît les ouvrages publiés par la Commission centrale des Crimes hitlériens en Pologne et, en particulier, l'ouvrage Les Crimes allemands en Pologne, Varsovie, 1948, vol. I, 224 p. ;

- qu'en 1976, à Varsovie, il a visité une exposition photographique sur les crimes hitlériens organisée par cette Commission sans y trouver d'ailleurs trace d'une seule photographie de « chambre à gaz » ;

- qu'il s'est rendu à Auschwitz en 1975 et en 1976 ; qu'il a passé commande d'un nombre important de photographies intéressant son sujet ; qu'il a été, de 1976 à 1979, en relation épistolaire soit avec l'archiviste de ce Musée (M. Tadeusz Iwaszko), soit avec un autre membre de ce Musée ; que, depuis 1976 jusqu'en 1981, il n'a cessé, par personnes interposées, d'obtenir une abondante documentation sur la prétendu « extermination dans les chambres à gaz » ;

Attendu que Monsieur Faurisson se demande si la LICRA voudrait insinuer que l'un des organismes précités cache jalousement dans

- 57 -

un fond de tiroir une preuve, une preuve enfin, de l'existence des « chambres à gaz » de Hitler ;

Attendu que Monsieur Faurisson a même pu avoir accès à des procès-verbaux d'interrogatoires par l'intermédiaire d'un magistrat allemand chargé de la poursuite des « criminels de guerre » ;

Attendu que [ci-dessus, page 30, 1^er^ alinéa] le récent colloque de Paris a conclu qu'il n'existait apparemment aucun document relatif à la décision de Hitler de procéder à la destruction des Juifs et qu'à ce compte on est en droit de se demander quel peut être ce « certain nombre de documents importants » dont parle la LICRA sans en citer un seul et que celle-ci reproche à Monsieur Faurisson d'avoir tus ;

Attendu que [ci-dessus, page 30, 2^e^ alinéa] le Professeur Faurisson, loin d'omettre volontairement dans ses travaux les déclarations faites par Eichmann lors de son procès à Jérusalem, prend le soin de citer mot à mot et selon les sténogrammes du procès ce que Eichmann a dit des « bâtiments de mort » (voy. Vérité... pages 209-210 ainsi que Réponse... pages 38-39) ;

Attendu que, de ce qu'il a déclaré, il ressort que le captif, dans une cellule où on lui faisait lire quantité d'ouvrages dont ceux de Léon Poliakov, ne savait plus distinguer entre ce qu'il avait réellement vu, ce qu'il croyait avoir vu, ce qu'il avait entendu dire et ce qu'il avait lu ;

Attendu en effet que le Commissaire du Gouvernement israélien lui demanda : « Avez-vous parlé avec Höss du nombre de Juifs qui ont été exterminés à Auschwitz ? » et que l'accusé Eichmann lui répondit : « Non, jamais. Il m'a dit qu'il avait fait construire de nouveaux bâtiments et qu'il pouvait mettre à mort chaque jour dix mille Juifs. Je me souviens de quelque chose comme cela. Je ne sais pas si j'imagine cela aujourd'hui seulement mais je ne crois pas l'imaginer. Je ne peux pas me rappeler exactement quand et comment il me l'a dit et de quoi avaient l'air les environs où il m'avait dit cela. Je l'ai peut-être lu et m'imagine peut-être maintenant que ce que j'ai lu, je l'ai entendu de sa bouche. Cela est aussi possible. » (sténogrammes J1-MJ à 02-RM) ;

- 58 -

Attendu que [ci-dessus, même page et même alinéa], quant à Albert Speer, dans son ouvrage Technique et Pouvoir, il affirme n'avoir jamais eu connaissance ni d'un ordre de tuer les Juifs, ni d'une exécution de cet ordre ;

Attendu que, porté, ainsi qu'il le dit lui-même, à l' « auto-accusation » (Journal de Spandau, R. Laffont, 1975, page 411), il s'accuse seulement d'avoir été aveugle ;

Attendu que [ci-dessus, même page et même alinéa] le Professeur Faurisson répète que, pour le récent colloque de Paris, on n'a trouvé aucun ordre relatif à l'extermination des Juifs et que, loin d'omettre « l'ordre du Reichsmarechal Göring », il mentionne cet ordre auquel il consacre une longue note à la page 211 de Vérité... ;

Attendu que la LICRA fait ici allusion à la lettre que Göring adressa à Heydrich le 31 juillet 1941 ;

- que dans cette lettre il n'est question ni de massacres, ni d'extermination mais d'immigration et d'évacuation ;

- que l'expression de « solution globale » ou de « solution finale » de la question juive n'implique pas plus l'assassinat des Juifs que l'expression de « solution finale de la question palestinienne » ou de « solution finale de la question du chômage » n'impliquerait nécessairement l'assassinat des Palestiniens ou des chômeurs ;

Attendu que [ci-dessus, même page et même alinéa] les allocutions ou discours prétendument « secrets » de Himmler sont évidemment à replacer dans leur contexte, et cela sans coupures ni traductions tendancieuses (voy. Réponse..., pages 14-17) ;

Attendu que, selon une certaine tradition, on prête à Himmler un ordre d'arrêter le massacre des juifs, ordre daté du 22 novembre 1944, mais que cet ordre n'a pas plus existé que celui d'entamer le massacre des juifs ;

Attendu que, dans sa thèse susmentionnée, l'historienne Olga Wormser-Migot écrit à la page 13 : « Dernière remarque à propos

- 59 -

des chambres à gaz : ni aux procès de Nuremberg, ni au cours des différents procès de zone, ni au procès de Höss à Cracovie, d'Eichmann en Israël, ni aux procès des commandants de camps, ni, de novembre 1963 à août 1965, au procès de Francfort [accusés d'Auschwitz « de seconde zone »] n'a été produit le fameux ordre, signé d'Himmler, du 22 novembre 1944, sur la fin de l'extermination des juifs par les gaz, l'ordre de mettre fin à la Solution finale » ;

Attendu qu'à l'historienne cet ordre « semble aussi mythique que l'ordre écrit d'exterminer les survivants des camps auquel maints témoins ont fait allusion dans leurs récits » ;

Attendu que [ci-dessus, même page et même alinéa] la conférence de la villa de Wannsee est du 20 janvier et non pas du 20 juin 1942 comme l'écrit l'intimée ;

- que son procès-verbal ne possède pas d'en-tête ;

- qu'il ne possède pas de références ;

- qu'il n'a pas même de signature ;

- qu'il ne porte pas l'indication obligatoire des noms des destinataires ;

- qu'il s'agit d'un simple papier dactylographié par un inconnu ;

- que, par ailleurs, il ne parle pas d'extermination (voy. le colloque de Paris susmentionné) ;

- que la preuve que ce curieux document est maintenant discrédité réside dans le fait que plus aucun historien exterminationniste ne se fait fort de dire quand a été donné l'ordre d'exterminer les juifs ;

Attendu que [ci-dessus, page 30, 3^e^ alinéa], pour ce qui est des « camions à gaz », on se reportera à nos conclusions précédentes du 25 novembre 1981 sur les « croquis enfantins et brouillons dont on voudrait nous faire croire qu'ils sont les plans probants de camions à gaz homicides » (pièce 66, page 3 ; pièce 81, page 19) ;

- 60 -

Attendu que [ci-dessus, page 30, 5^e^ et 6^e^ alinéa] le Professeur Faurisson, accusé d'avoir grossièrement dénaturé les écrits de Johann Paul Kremer, de Rudolf Höss, d'Olga Wormser-Migot, de Monsieur Broszat et de la Croix-Rouge, attend un commencement de citation et de démonstration pour y donner une réponse ;

Attendu cependant que, pour ce qui est « des aveux écrits de sa main par Rudolf Höss », le Professeur Faurisson veut bien dire ceci :

- cet « aveu » a été rédigé au crayon dans une geôle communiste et en attente soit de la grâce, soit du gibet ;

- de cet aveu, nous ne possédons que des bribes, elles-mêmes tronquées ainsi qu'il est facilement prouvé pour tous dans Vérité..., note 26 de la page 206 ;

- cet aveu que l'on dit d'une importance capitale et qui est, en effet, la pierre angulaire de la légende exterminationniste, il a fallu attendre cinq ans pour en obtenir la version polonaise et onze ans pour en avoir la version originale en allemand, cela par les soins du Dr Broszat * ;

- on peut se demander quel crédit accorder à un texte où l'auteur raconte qu'il a vu des fosses à cadavres où, à l'aide de seaux, on recueillait la graisse des brûlés au fond des fosses pour la reverser sur le bûcher (voy. Mémoires, en allemand, Kommandant in Auschwitz, von Rudolf Höss, Eingeleitet u. kommentiert von Martin Broszat, Deutsche Verlags Anstalt, Stuttgart, 1958, page 126, ainsi que document le NO-1210 ; ce passage est généralement omis par les traductions en français) ;

- dans cet aveu, l'auteur dit que les Sonderkommandos affectés aux crématoires traînaient hors de la chambre à gaz les cadavres des victimes vers l'ascenseur, tout juste après la mort des victimes, alors que se mettait en marche un appareil d'aération, ce qui revient à dire que ces hommes travaillaient dans une atmosphère encore pleine de gaz cyanhydrique, et cela en mangeant et en fumant, c'est-à-dire sans masques à gaz, ce qui est impossible, comme est impossible le fait d'entreposer quelque part près des fours crématoires 2.000 cadavres à

____________

* Note de l'AAARGH [http://vho.org/aaargh/fran/archFaur/1980-1985/RF8212xx3.html] : curieusement, l'auteur de ces conclusions ignore que Broszat, en 1964, a déclaré publiquement devant le tribunal de Francfort qu'« on ne pouvait pas faire confiance aux déclarations de Höss ». Est-ce un oubli ? Cf. la critique de Höss par Rassinier et la référence de la citation.

- 61 -

incinérer, incinération qui aurait exigé de huit à neuf jours pour les quinze fours, et les arrivages de victimes, dit-on, se faisaient tous les jours par milliers ou dizaines de milliers ;

Attendu que [ci-dessus, page 30, 7^e^ alinéa] il n'est pas besoin d'un interprète mais seulement d'un dictionnaire pour constater que « Vergasung » peut avoir, entre autres sens, celui de « carburation » (voy. Réponse... page 32) ;

Attendu que Raul Hilberg, dans son ouvrage de référence mentionné ci-dessus à la page 36, cite bien la lettre du 29 janvier 1943 où apparaît le terme de « Vergasungskeller » sans y voir une preuve, semble-t-il, d'un quelconque gazage homicide ;

Attendu que [ci-dessus, page 30, 8^e^ alinéa], pour ce qui est des traductions de Monsieur Victor Borten, le Professeur Faurisson maintient ses précédentes conclusions, signifiées le 25 novembre 1981, page 8, 4^e^ alinéa desdites conclusions ;

Attendu que, en complément à ses écritures précédentes et pour appeler l'attention de l'expert honoraire Borten sur l'une de ses graves erreurs, Monsieur Faurisson relève que ce dernier n'a pas craint d'affirmer : « La langue allemande ignore le terme de Leichenkeller », affirmation qui lui a permis, du moins le croyait-il, de remettre en cause ce que Monsieur Faurisson soutenait, à savoir que les bâtiments des crématoires possédaient tout simplement, ainsi que l'indiquent les plans, des pièces appelées « Leichenkeller », c'est-à-dire « cellier à cadavres » ou « chambre froide en sous-sol » ;

Attendu, d'abord, que la construction de ce mot est classique en allemand (Leichen : cadavres ; Keller : cave) et qu'elle est en tous points comparable à un mot comme « Leichenhalle » qui signifie « halle à cadavres » ou « chambre froide » ;

Attendu que ce mot est si peu suspect que dans leurs écrits les Polonais l'emploient eux-mêmes pour désigner une chambre froide en sous-sol, soit que cette chambre se fût trouvée au bloc 28 d'Auschwitz-I où il ne fut jamais question de voir une « chambre à gaz », soit qu'elle se fût trouvée à l'Hôpital civil de Strasbourg

- 62 -

où il est question d'un « Leichenkeller der Anatomie » (voy. L'Anthologie (bleue) d'Auschwitz tome I, première partie, pages 63 et 190 ainsi que tome I, deuxième partie, page 67) ;

Attendu que plus généralement, les traductions faites à la requête de la LICRA, y compris les traductions jurées, sont tendancieuses, l'expert Madame Heesch ayant par exemple traduit le mot « Absetzgrube » par « fosse à cadavres », alors qu'en réalité (voy. déjà nos conclusions antérieures du 25 novembre 1981, page 8, 3^e^ alinéa desdites conclusions) ce mot désigne simplement une « fosse de décantation », sens qui figure littéralement dans plusieurs dictionnaires techniques français-allemand ;

Attendu que [ci-dessus, page 30, 9^e^ alinéa jusqu'à, page 31, la fin de la citation de la lettre de Monsieur Truffert] le Professeur Faurisson fait remarquer qu'on lui reproche, encore une fois sans un commencement de preuve, d'avoir procédé « à une véritable manipulation du texte de l'aveu de Höss » ;

Attendu que, pour ce qui est des expertises, l'appelant a dit, et il répète ici, qu'il n'existe aucune expertise de l'arme du crime établissant que tel bâtiment était conçu pour fonctionner comme une chambre à gaz homicide, contrairement à ce qu'affirmait la LICRA au 5^e^ alinéa de la page 7 de ses conclusions [ci-dessus, page 29, 5^e^ alinéa] ; qu'il ajoute que l'intéressante lettre de Monsieur Louis Truffert, toxicologue, mentionnée par la LICRA, gagnerait considérablement en intérêt si on lui ajoutait une autre lettre de Monsieur Louis Truffert que la LICRA a omis de mentionner ;

Attendu que Monsieur Truffert a écrit à M^e^ Kormann, avocat de la LICRA, une lettre en réponse aux questions de ce dernier, lettre datée du 16 février 1981, et que, d'autre part, le même Monsieur Louis Truffert a envoyé à M^e^ Kormann copie d'une lettre complémentaire, d'une importance capitale, adressée à Monsieur Faurisson, le 3 avril 1981 ;

- 63 -

Attendu que Monsieur Faurisson verse donc au débat cette lettre du 3 avril 1981 ;

Attendu, en ce qui concerne ces échanges de correspondance, que Monsieur Faurisson fait les remarques suivantes :

- il n'est pas vrai que Monsieur Truffert, expert consulté par lui, ait donné des « indications démentant pour lui la possibilité de donner l'interprétation qu'il a exprimée dans les colonnes du Monde » ;

- en effet, il avait consulté Monsieur Truffert à propos des effets des gaz CO, CO2 et HCN sur le corps humain, mais sans jamais lui révéler son opinion sur les prétendues « chambres à gaz » nazies ;

- il est donc compréhensible que Monsieur Truffert ait écrit à M^e^ Kormann qu'il ne voyait rien, dans les réponses faites à Monsieur Faurisson, qui permette à ce dernier de conclure que les Allemands n'avaient pas utilisé des chambres à gaz avec émission de HCN provenant du Zyklon B ;

- la lettre de M^e^ Kormann à Monsieur Truffert était captieuse ; par exemple, M^e^ Kormann, posant en principe que les chambres à gaz homicides avaient existé sans l'ombre d'un doute, écrivait à Monsieur Truffert que « les pièces où s'effectuaient les gazages étaient munies d'un système de ventilation mis en marche au terme de l'opération (...) ces pièces étaient nues (...) elles étaient remplies au maximum de leurs possibilités d'êtres humains nus » : toutes choses qui restaient précisément à démontrer et que M^e^ Kormann présentait comme définitivement acquises ;

- M^e^ Kormann, sachant que Monsieur Truffert était un expert en toxicologie et non pas, comme certains de ses collègues américains, un expert en exécutions homicides par le HCN, aurait dû lui fournir tout renseignement sur le mode d'exécution par chambre à gaz américaine fonctionnant à l'acide cyanhydrique ;

- or, il s'en gardait bien et ne lui envoyait sur le sujet aucune information, alors même que dans Vérité... il disposait de nombreux documents sur le fonctionnement des chambres à gaz américaines ;

- 64 -

- il ne lui envoyait aucune copie des nombreux passages (notamment pages 172-180 et page 307) où le Professeur Faurisson révélait combien l'exécution d'un seul homme par le HCN, contrairement à ce que s'imagine le profane, était redoutablement difficile à mettre au point et quelles précautions draconiennes il fallait prendre pour gazer un prisonnier et pour extraire son cadavre de la chambre à gaz ;

- M^e^ Kormann n'envoyait à Monsieur Truffert aucune des huit photos de chambre à gaz américaine figurant, avec des explications à l'appui, aux pages 301-309 de Vérité... ;

- il ne lui envoyait pas le mode d'emploi suivi, par exemple, pour une exécution par le gaz au pénitencier de Baltimore, lequel mode d'emploi énumérait quarante-sept opérations successives, la moins périlleuse n'étant pas l'extraction du cadavre de la chambre à gaz ;

- M^e^ Kormann ne révélait donc pas à Monsieur Truffert combien les premiers toxicologues américains, vers 1917-1920, et bien plus tard encore, avaient été surpris de voir se lever sous leurs pas toutes sortes de difficultés techniques qui, à première vue, étaient insoupçonnables ;

- Monsieur Truffert répondait donc à M^e^ Kormann en toute bonne foi : « Il ne me paraît nullement impossible que des personnes non munies de masques à gaz pénètrent sans inconvénient dans une chambre à gaz contenant des corps nus dont la température devait encore dépasser 26° (donc non susceptible de retenir du toxique par adsorption) » ; Monsieur Truffert écrivait bien « adsorption » et non pas, comme l'écrit l'intimée, « absorption » ;

- Monsieur Truffert faisait dans sa lettre un rapprochement avec une expérience personnelle : il lui était arrivé de pénétrer, sans en être incommodé, dans une chambre d'hôtel où gisait le cadavre d'un client tué par des restes de HCN ;

- ce dernier fait à lui seul prouvait qu'un homme pouvait être tué par les restes ultimes d'une désinfection de sa chambre au HCN, désinfection qui avait été pourtant suivie d'une longue

- 65 -

aération de la pièce ;

- le premier jour, l'hôtelier avait déposé sous le lit un œuf de cyanure dans une solution d'acide sulfurique et ensuite il avait soigneusement calfeutré la porte de la chambre ; le deuxième jour, il avait pénétré dans la pièce en retenant sa respiration pour aller ouvrir la fenêtre et assurer ainsi la ventilation nécessaire, manœuvre accomplie avec précipitation ; le soir du deuxième jour, ou peut-être le lendemain, après le temps jugé nécessaire pour une bonne aération de la pièce, celle-ci était mise à la disposition d'un client... et le lendemain, il pouvait arriver qu'on trouvât un cadavre : c'est que, malgré la ventilation et étant donné que le HCN est « d'une ventilabilité difficile, vu qu'il adhère fortement aux surfaces » (document NI-9098 ; voy. Mémoire..., page 161), la chaleur du corps du client avait en quelque sorte éveillé les molécules restantes du gaz HCN qui avaient imprégné la literie ;

- tout cela confirme la dangerosité durable de simples traces de HCN et fait comprendre qu'en France, à partir de 1949, on ait interdit aux hôteliers toute désinfection au HCN ;

Attendu d'ailleurs qu'il suffit aux juristes français de se rappeler les propres termes du décret du 18 octobre 1950 « fixant les modalités d'application de la loi autorisant l'utilisation des gaz toxiques pour la désinfection, la désinsectisation et la dératisation », pour prendre la mesure des problèmes posés par les simples gazages de désinfection à l'acide cyanhydrique sur les navires, puisque en telle hypothèse :

- « aucun autre navire ne devra se trouver en couple ou en contact direct avec le navire traité » (article 8) ;

- « une fois les opérations terminées, les locaux seront aérés mécaniquement. L'aération naturelle prolongée ne pourra être autorisée que pour les navires désarmés » (article 12, 1^er^ alinéa) ;

- « La libre pratique ne sera donnée par les agents de la santé que si ces animaux [il s'agit d'animaux cobayes obligatoires ― note du concluant], après trente minutes de séjour, ont été remontés sains et saufs » (article 12, 2^e^ alinéa) ;

- 66 -

- « ... les objets de literie ou de couchage devront être exposés à l'air pendant six heures et battus à plusieurs reprises. L'équipage ne couchera dans les postes traités que 24h après le début des opérations » (article 15) ;

Attendu d'ailleurs que les relations des praticiens du Zyklon B confirment surabondamment le danger que représente ce produit pour qui le manipule ;

Attendu que, pour avoir une idée de ce danger, il suffit d'écouter ce que A. Breitwieser, responsable à Auschwitz des opérations de désinfection, déclarait au Tribunal à propos du Zyklon B : « Le Zyklon B, il faut bien le dire, agissait avec une rapidité foudroyante. Je me souviens que le sergent Theurer est entré une fois dans une maison qu'on venait de désinsectiser. On avait déjà commencé à aérer la veille, au rez-de-chaussée, le soir ; le lendemain matin, Theurer voulut aller ouvrir les fenêtres du premier étage. Il avait probablement respiré des vapeurs nocives sur son passage, car il s'effondra soudain, perdit aussitôt connaissance et roula jusqu'au bas de l'escalier où il se retrouva au grand air. S'il était tombé dans une autre direction, il ne serait pas ressorti vivant de la maison. » (B. Naumann, Auschwitz-Bericht, Frankfurt, 1968, Fischer-Buecherei, page 70).

Attendu que, après avoir pris connaissance de la réponse écrite de Monsieur Truffert à M^e^ Kormann, Monsieur Faurisson, ainsi que son éditeur, Monsieur Pierre Guillaume, allaient soumettre à Monsieur Truffert une copie de la reproduction, par le Musée d'Auschwitz, des crématoires d'Auschwitz-Birkenau avec leurs prétendues « chambres à gaz » en sous-sol ; que M. Truffert, manifestant une grande surprise en voyant la disposition des lieux, admettait sans aucune peine que d'importantes réserves s'imposaient et, en réponse à une lettre du Professeur Faurisson, envoyait donc la lettre susmentionnée du 3 avril 1981 où Monsieur Truffert, après avoir exprimé son désir de ne pas participer à une polémique au sujet des chambres à gaz, écrit notamment ceci : « Toutefois, l'observation que j'ai faite, concernant la possibilité de pénétrer sans masque dans une pièce

- 67 -

contenant des corps intoxiqués par l'acide cyanhydrique, concerne le cas d'une chambre à gaz au niveau du sol, débouchant à l'air libre, et il est évident que d'importantes réserves doivent être faites dans le cas d'installations en sous-sol. Une telle situation nécessiterait un dispositif de ventilation très important et des précautions draconiennes pour éviter des pollutions susceptibles d'être à l'origine d'accidents. » ;

III. La LICRA, dans sa légèreté, ne soupçonnait pas

la complexité du problème posé

Attendu que la LICRA, dans sa légèreté, ne soupçonnait pas la complexité du problème et que, peut-être de bonne foi, elle s'est lancée dans une affaire où l'ampleur du problème lui a peu à peu révélé l'ampleur de son incompétence ;

Attendu que le Professeur Faurisson tient à rappeler une fois de plus que dans cette affaire on compte en définitive très peu de menteurs et une masse innombrable de victimes d'un grand mensonge historique ;

Attendu qu'à travers l'histoire des hommes, les rumeurs, les illusions, les rêves, les mensonges ont été peut-être aussi nombreux que les scrupules d'honnêteté, les soucis de voir clair, les ambitions de découvrir des vérités et que, comme l'a dit Anatole France, on peut vouloir aimer la vérité mais il faut bien convenir que sans le mensonge l'humanité périrait de désespoir ou d'ennui ;

Attendu qu'au commencement de l'affaire des chambres à gaz la LICRA a pu croire que Monsieur Faurisson soutenait une thèse mensongère et facile à réfuter ; que la LICRA s'imaginait pouvoir trouver sans peine une quantité de preuves matérielles, de photographies, de témoins oculaires ; tout le monde n'avait-il

- 68 -

vu des chambres à gaz ? entendu parler du Zyklon B ? su ce qu'il convenait d'entendre par Solution finale ? appris que Hitler avait tué six millions de Juifs ? compris que les Nazis n'étaient pas des hommes et s'étaient mis, par des crimes exceptionnels, en dehors des lois ? N'avait-on pas encore sous les yeux les charniers de Bergen-Belsen et les fours crématoires ? etc. ;

Attendu que, se tournant vers des spécialistes, la LICRA devait progressivement découvrir qu'au lieu de lui apporter une preuve, une seule preuve, mais bien solide, des « chambres à gaz » ou du « génocide », on lui fournissait un ensemble de preuves illusoires où chaque preuve, pour tenir à peu près ferme, avait besoin de l'appui d'une autre preuve, elle-même quelque peu chancelante ;

Attendu que, déçus ou abandonnés par les spécialistes, les avocats de la LICRA étaient bien obligés de prendre leur bâton de pèlerins et de se rendre en Allemagne, en Pologne, et jusqu'en Israël (voy. l'interview de Jean Pierre-Bloch à Expliquez-vous, émission d'Ivan Levai le 16 décembre 1980, sur les ondes de Radio Europe n° 1) ;

Attendu que, toujours plus déçus et abandonnés, il ne leur restait plus qu'à user de quelques subterfuges : communication de pièces indigentes, suivie de communication de pièces disparates et mal traduites, suivie encore de communication de pièces en avalanches où l'on cherchait à suppléer à la qualité par la quantité, demande à tout hasard des dossiers de la Justice Militaire française sur le Struthof, alors que l'Amicale des Anciens Internés du Struthof se gardait bien de joindre ses efforts à ceux de la LICRA ;

Attendu que la LICRA, voyant le problème s'aggraver de mois en mois, n'avait plus que la ressource de publier les présentes conclusions du 14 mai 1982, qui sont vagues, imprécises et désordonnées ;

Attendu que la LICRA paraît aujourd'hui définitivement incapable de répondre aux questions que se posent ses avocats ;

- 69 -

Attendu que Monsieur Faurisson n'est pas du tout le falsificateur qu'elle croyait d'abord voir en lui mais un homme qui cherche simplement la vérité sur un point délicat de l'histoire contemporaine ;

Attendu qu'il ne veut pas imposer à quiconque la thèse révisionniste mais seulement éveiller quelques doutes scientifiques dans l'esprit de ses adversaires, et qu'en conséquence il leur soumet les questions suivantes :

- Si les chambres à gaz homicides de Hitler n'ont en fin de compte pas existé, faut-il le dire ou faut-il continuer à le cacher ? Dira-t-on alors, selon le mot de Soljénitsyne : « Ce qui est exigé de nous, c'est d'obéir au mensonge, c'est de participer chaque jour au mensonge » (voy. Le Monde, 4 février 1978, page 2) ;

- Quand on détient une parcelle de vérité historique et qu'on s'interroge sur le point de savoir si le moment est venu de la révéler au public, ne devrait-on pas penser que, pour dire la vérité en cette matière, le moment est toujours venu ?

- Si l'on pense que certaines vérités sont dures à entendre et peuvent froisser certaines personnes, ne faut-il pas penser aussi que le mensonge ne peut survivre sans faire de mal ?

- Comment se pourrait-il que le falsificateur que serait Robert Faurisson fît progresser, comme tend à le dire le Professeur Raul Hilberg, la recherche de la vérité historique ?

- Comment ce falsificateur, usant d'une seule et même méthode d'analyse, serait-il parvenu à découvrir que le Journal d'Anne Frank est une supercherie littéraire, point qui est aujourd'hui démontré par une analyse des encres des manuscrits conduite par les Laboratoires de la Police fédérale de Wiesbaden, tandis que, appliquée à un problème comme celui des « chambres à gaz », sa méthode l'aurait conduit à accumuler falsifications sur falsifications ?

- On a fini, sur l'insistance du Professeur Faurisson, par expertiser sérieusement le Journal d'Anne Frank et par découvrir ainsi la supercherie ; pourquoi, depuis trente-huit ans,

- 70 -

refuse-t-on d'expertiser de même tous les locaux qualifiés de chambres à gaz « en état d'origine » au Struthof, à Mauthausen, à Majdanek, à Auschwitz-I ? Pourquoi n'a-t-on jamais voulu procéder à une expertise archéologique des ruines des « chambres à gaz » d'Auschwitz-Birkenau ?

- Pourquoi, dès 1944 et 1945, les Soviétiques n'ont-ils pas proposé, pour Majdanek et pour Auschwitz, une expertise internationale comme celle que les Allemands, en 1943, avaient sollicitée pour le charnier de Katyn ?

- Comment expliquer qu'en plein cœur de l'Europe, de 1942 à 1944, une énorme machinerie forcément sophistiquée ait pu tuer des millions d'hommes pour ensuite disparaître sans laisser de traces incontestables du genre de celles qu'ont laissées soit les fours crématoires qui les flanquaient, soit les camps de concentration qui les contenaient ?

- Quelle différence, en définitive, y a-t-il entre les preuves des « gazages » de Dachau, qui sont désormais controuvées, et celles d'Auschwitz auxquelles on persiste à accorder foi ?

- D'où vient que les documents français, anglais ou américains qui attestaient de l'existence de chambres à gaz homicides aient, à juste titre, tant perdu de leur crédit, alors que les documents polonais ou soviétiques, c'est-à-dire communistes, devraient garder tout leur crédit ?

- Pourquoi Monsieur Wellers, dans son livre intitulé Les chambres à gaz ont existé (Gallimard, 1981) ne présente-t-il, parmi ses photographies, aucune photographie d'aucune « chambre à gaz », qu'elles soient d'Auschwitz ou d'ailleurs, et que des flots de touristes ont visitées et visitent encore ? Et pourquoi, lorsqu'il veut prouver l'existence de « chambres à gaz », présente-t-il des plans de crématoires ? Pourquoi enfin le même mot de « Leichenkeller » est-il traduit par lui, selon les besoins de la cause, par « chambre de déshabillage » ou « chambre à gaz » ?

- Comment se fait-il que les services secrets alliés, disposant ― on le sait aujourd'hui ― d'innombrables renseignements sur Auschwitz pendant toute la durée de la guerre et possédant

- 71 -

même des photographies prises lors de trente-deux missions aériennes au-dessus du camp, n'aient pas conclu un seul instant à l'existence de formidables abattoirs, avec foules humaines pressées à l'entrée des bâtiments des crématoires, aux cheminées infernales lançant jour et nuit des volutes de flammes et des langues de feu ?

- D'où vient que leurs très précises photographies aériennes prises en 1943-1944 et au début de 1945, toutes publiées en 1979, ne montrent rien qui puisse laisser soupçonner l'existence d'immenses abattoirs humains, et tout qui puisse faire penser qu'Auschwitz n'était qu'un grand camp de concentration (voy. Vérité..., page 318-319) ?

- Pourquoi Auschwitz-Birkenau, qualifié après la guerre de « camp d'extermination », possédait-il à proximité, à la fois des fours crématoires et d'un terrain de sport, des installations hospitalières modernes, avec soixante médecins et trois cents infirmières (voy. The Atlantic Monthly, « The Kingdom of Auschwitz », par Otto Friedrich, sept. 1981, pages 30-60 ; page 27) ?

- Comment expliquer que dans L'Anthologie (bleue) d'Auschwitz, publiée par le Comité international d'Auschwitz, on puisse lire le rapport d'une sage-femme polonaise qui, sur trente-huit ans de carrière, avait, en l'espace de deux ans passés à Auschwitz-Birkenau, accouché 3.000 femmes juives et non juives, et cela, dit-elle, avec un taux de réussite exceptionnellement élevé ? [1]

- Comment se fait-il qu'à leur arrivée à Auschwitz le 27 janvier 1945 les Soviétiques aient trouvé des vieillards ou des enfants apparemment en bonne santé comme nous le montre le film tourné alors par leurs services ?

- Comment se fait-il que vers 1965 les Polonais aient été en mesure de procéder à toute une série d'études médicales d'un grand nombre d' « enfants d'Auschwitz », c'est-à-dire d'adultes qui étaient nés dans le camp d'Auschwitz ou qui y avaient été concentrés avec leurs parents dès leur plus jeune âge ? [2]

_________________

[1] L'Anthologie (bleue) d'Auschwitz, Varsovie, 1969, t. II, 2^e^ p., p. 159-169 : « Rapport d'une accoucheuse d'Auschwitz », S. Leszczynska (trad. d'un article paru dans la revue médicale Przeglad Lekarski en 1965).

[2] Ibid., t. II, 3^e^ p., p. 31-114 : « Résultats des examens psychiatriques de personnes nées ou internées durant leur enfance dans les camps nazis de concentration » (trad. de la revue susmentionnée en 1966).

- 72 -

- Pourquoi a-t-on besoin, à ce point, d'aveux et de confessions pour établir la réalité d'un massacre en abattoirs de, dit-on, des millions d'hommes et de femmes en des points précis de Pologne, alors qu'on n'a nul besoin d'aveux ou de confessions pour prouver les massacres de Dresde (135.000 morts environ : « le plus grand crématoire du monde »), d'Hiroshima (71.370 morts), de Katyn (4.143 morts), d'Oradour (642 morts), de Lidice (184 morts) ?

- Pourquoi n'accepte-t-on, du côté des historiens officiels, aucune proposition d'une rencontre et d'une discussion avec les auteurs révisionnistes ?

- Pourquoi déformer presque systématiquement les travaux des révisionnistes jusqu'à la caricature, jusqu'à leur faire dire qu'ils nient tout ; que pour eux il n'y a, chez les exterminationnistes, que des menteurs ; que pour eux tous les aveux des prisonniers allemands ont été extorqués par la violence, la pression ou la torture ; alors que, à bien les lire, les révisionnistes ne font que perpétuer une tradition historiographique, qui consiste à tout examiner et à ne rien recevoir comme vrai qui ne leur paraisse vérifiable ?

*

* *

Attendu que le Professeur Faurisson voit dans la cascade de poursuites en justice dont il est l'objet une tentative pour interdire en France les recherches de l'école historique à laquelle il se rattache ;

Attendu que l'école révisionniste date des années qui ont suivi la première guerre mondiale ; qu'elle a eu des représentants, en particulier aux États-Unis (Professeur Harry Elmer Barnes), en Grande-Bretagne (Lord Ponsonby), en France (Jean Norton Cru) ; que tous avaient cherché à faire justice de mythes

- 73 -

abominables comme celui des enfants belges aux mains coupées, des aviateurs canadiens crucifiés, des usines allemandes à savon et à engrais humains ; qu'ils avaient ainsi ramené la guerre à un épisode horrible et détestable de l'aventure humaine mais sans tomber dans le mensonge et la propagande de guerre ;

Attendu que, après la seconde guerre mondiale, ce mouvement de pensée a eu son représentant le plus connu en la personne de Paul Rassinier, ancien déporté ; qu'il a essaimé à travers le monde et qu'il connaît aujourd'hui une vitalité exceptionnelle malgré une persécution vigilante, surtout en Allemagne ;

Attendu que l'intimée semble ignorer les travaux, aux États-Unis, du Professeur Arthur Robert Butz, de James J. Martin, du Professeur R. K. Buchner ; en Grande-Bretagne, de l'historien David Irving ; en Allemagne, du Docteur Wilhelm Stäglich (ancien magistrat), de J. G. Burg (ancien interné israélite), du Professeur Helmut Diwald ; en Autriche, du Dr Franz J. Scheidl et de Erich Kern ; en Australie, de John Bennett (secrétaire du Victorian Council for Civil Liberties : équivalent, en plus libéral, de notre Ligue des droits de l'homme), etc. ;

Attendu que, pour se limiter à la France, l'intimée semble vouloir ignorer l'existence de publications comme celle de La Guerre sociale, du Frondeur, du Lutteur de classe sur le mythe des « chambres à gaz » et le livre même d'Intolérable Intolérance (éditions de la Différence, 1981, 207 p.) où sont dénoncés les procédés dont est victime depuis 1978 le Professeur Faurisson à la fois dans l'Université et hors de l'Université ;

Attendu que tout récemment, dans la conférence de presse qui a suivi le colloque de la Sorbonne et des Hautes Etudes sur l'Allemagne nazie et l'Extermination des Juifs, les deux organisateurs du colloque ont fait une déclaration à titre personnel sur les procès intentés au Professeur Faurisson ;

Attendu que le Professeur Raymond Aron a déclaré textuellement : « A titre personnel, je suis contre les procès de cet ordre... Absurde... A titre personnel, moi, je suis entièrement contre... Je n'aime pas les procès de sorcellerie ... » ;

- 74 -

Attendu que les mots du Professeur François Furet, Directeur de l'Ecole des Hautes Etudes en sciences sociales, ont été textuellement : « Je trouve cela absurde... enfin ! Ce n'est pas à un tribunal de trancher ! » ;

Attendu que Paul Rassinier, ancien député socialiste S.F.I.O., ancien déporté, écrivait le 5 mai 1960 à Eugène Kogon et faisait ainsi allusion à la persécution subie par Galilée : « Il ne vous échappera peut-être pas que, si l'idée a pu venir à l'esprit d'un Pape de faire trancher un problème scientifique par des Juristes, quatre siècles ont tout de même passé depuis, et qu'aujourd'hui aucun homme vraiment cultivé n'aurait celle de soumettre à ceux de notre temps un problème historique. » (Ulysse trahi par les siens, page 182) ;

Attendu que la Cour, en réformant le jugement entrepris et en déboutant la LICRA, rejettera l'argument du Tribunal selon lequel « il est profondément vrai que "l'Histoire se doit d'attendre que le Temps permette une étude sans agressivité de certains problèmes d'horreur" », argument qui laisserait supposer qu'il existe dans le temps une prescription acquisitive de liberté ;

Attendu qu'à ce compte, certaines maisons d'édition n'auraient plus qu'à supprimer les collections intitulées par exemple « L'Histoire immédiate » (titre de collection des éditions du Seuil qui, en 1973, ont publié sur Ravensbrück un ouvrage perturbant de Germaine Tillion) ;

Attendu qu'après chaque guerre où les passions et les haines se sont déchaînées il faudrait interdire aux historiens de publier des œuvres du genre de celles du Français Jean Norton Cru qui, après la première guerre mondiale, contribua à rétablir la vérité des faits, laquelle avait été outrageusement violentée par des propagandes de haine et de guerre ; lequel Jean Norton Cru fut insulté jusqu'à ce qu'on rendît hommage à l'honnêteté et au courage qu'il avait manifesté en publiant Témoins ou Du témoignage ;

Attendu qu'on serait en droit, par pur arbitraire, de rectifier l'histoire en ce qui concerne, par exemple, le mythe des « 75.000

- 75 -

fusillés du Parti communiste français » ou, à l'inverse, le mythe des « 105.000 victimes de l'Epuration », tandis qu'il serait interdit de poursuivre, sur le mythe des « chambres à gaz hitlériennes » ou du « génocide », le travail de révision entrepris à contrecœur par tant d'auteurs exterminationnistes qui, après avoir ignoré ou insulté Paul Rassinier de son vivant, finissaient par lui rendre hommage longtemps après sa mort ;

Attendu que, pour Monsieur Faurisson, il ne s'agit ni de triompher, ni de faire triompher une thèse, mais qu'il s'agit d'obtenir le droit de s'exprimer, de discuter, de critiquer, de chercher... qu'il s'agit, en somme, du droit de vivre.

PAR CES MOTIFS

Adjuger à Monsieur Faurisson ses précédentes écritures dans l'ordre des subsidiarités y énoncées ;

Dire qu'il a été répondu par Monsieur Faurisson à toutes les questions soulevées, même de façon allusive, par la LICRA ;

Lui donner acte de ce qu'il ne saurait voir confirmer le jugement entrepris :

- sans avoir été mis à même de présenter à la Cour un film vidéoscopique concernant le « problème des chambres à gaz », film conçu par Monsieur Faurisson expressément à l'intention de la Cour et illustrant le sérieux de ses travaux de chercheur ;

- sans avoir été entendu en comparution personnelle sur lesdits travaux afin que la Cour puisse vérifier s'il a fait preuve ou non de souci d'information dans ses recherches.

[Vu : R. Faurisson]

- 76 -

[lire cette page 77 après la page 78]

PREMIER

EXTRAIT

Raymond ARON : ... l'incertitude tient que, pour les historiens, on a besoin de documents d'archives, ou de preuves. Si on fait simplement du raisonnement, disons, du type compréhensif... [silence] Si on dit : « Etant donné sa nature, ses propos, sa doctrine, il est tout à fait compréhensible qu'il ait fait ceci ou cela... » Bon, c'est ce qu'on fait quand on n'a pas de documents. Mais, quand il y a des historiens qui disent : « Bien sûr que c'est compréhensible à partir d'une certaine représentation de Hitler... » [silence] Mais ils n'ont pas les preuves, et ils ont... [silence] Tout le monde a cherché, mais on a constaté que l'on n'a pas trouvé ce qu'on cherchait ; et que d'autre part dans le déroulement, on n'a pas trouvé l'activité personnelle de Hitler.

DEUXIEME

EXTRAIT

Un journaliste : Et donc aujourd'hui, après ce colloque, après les travaux qu'ont faits tous les historiens qui étaient là, on peut considérer comme un fait certain que la décision de la solution finale a été prise ? Et par Hitler personnellement ?

Raymond ARON : Non.

François FURET : Non, je ne dirais pas ça.

Raymond ARON : Non. On pourrait dire que c'est le plus probable, mais en fonction de raisonnements. Mais ce n'est pas démontré par les recherches les plus érudites.

TROISIEME EXTRAIT

Un journaliste : Est-ce que vous estimez judicieux qu'il y ait eu des procès devant la justice ?

Raymond ARON : Le colloque n'a rien dit. Moi, à titre personnel, je suis contre les procès de cet ordre.

Francois FURET : Je trouve ça absurde. Enfin, ce n'est pas à un tribunal de trancher.

Raymond ARON : Je trouve absurde que les organisations juives fassent des, des... [inaudible]

Interlocuteur : On n'en a pas discuté.

Raymond ARON : On n'en a pas discuté. Mais... C'est en dehors du colloque, à titre personnel, moi, je suis entièrement contre.

Interlocuteur : C'est aussi la position de Vidal-Naquet.

Francois FURET : Je pense oui.

Raymond ARON : Je n'aime pas les procès de sorcellerie.

Fait à Paris le 7 septembre 1982

Pour valoir ce que de droit

- 77 -

[lire cette page 78 avant la page 77]

William Skyvington -- RUE ------------------, 75004 PARIS TEL ----

Je soussigné, William Skyvington, né le 24 septembre 1940 à Crafton (Australie), de nationalité australienne, ingénieur indépendant en informatique, domicilié -- rue ------------------, 75004 Paris, ayant assisté à la conférence de presse tenue par Messieurs les Professeurs Raymond Aron et François Furet dans les locaux de la Maison des Sciences de l'Homme, le 2 juillet 1982 à 18h30, à l'issue du colloque « Le National-socialisme et les Juifs », déclare avoir procédé à l'enregistrement sonore sur cassette magnétique de la totalité de cette conférence de presse, en accord avec les organisateurs et d'une manière parfaitement visible, de sorte qu'aucun interlocuteur ne pouvait ignorer le fait que j'enregistrais ses paroles.

Cet enregistrement devait constituer un élément intéressant dans le dossier que je prépare depuis quelque temps sur ce que l'on appelle parfois l' « affaire Faurisson » et ses rapports avec la liberté de l'expression en France, sujet dont je pensais me servir éventuellement pour rédiger un ouvrage en langue anglaise.

Je certifie que les textes suivants constituent une transcription rigoureuse de trois extraits de cet enregistrement, que je tiens par ailleurs à la disposition du Tribunal. Je n'ai effectué aucune coupure volontaire de mots à l'intérieur de ces trois passages.

- 78 -

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| []                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| Plan du Krematorium II (le plan du Krematorium III est identique) découvert par R. Faurisson aux Archives du Musée d'État d'Auschwitz-Birkenau le 19 mars 1976 et jusque-là caché. Il montre que la prétendue « chambre à gaz » n'était qu'un dépositoire (Leichenkeller 1) aux dimensions typiques (30m x 7m, soit 2m pour un cadavre + en face, 2m pour un autre cadavre + 3m entre les deux cadavres pour les mouvements du chariot), en cul-de-sac et sans ventilation forcée. Il y avait, en général, deux Leichenkellern : l'un pour les cadavres non en cercueil et l'autre pour les cadavres en cercueil. Il y en avait parfois un troisième, à système d'isolation renforcée, pour les cadavres de victimes d'épidémies.  |
+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+

- 79 -

BIBLIOGRAPHIE

Le lecteur désireux de consulter les précédentes écritures du procès de première instance pourra se reporter aux ouvrages suivants :

Mémoire en défense, Robert Faurisson, éditions de la Vieille Taupe, Paris 1980, 281 p., pour le texte de l'assignation introductive : p. 227-231.

Intolérable Intolérance, Jean-Gabriel Cohn-Bendit et alii, éditions de la Différence, Paris, 1981, 208 p., pour le texte du jugement : p. 175-191.

(Les versions du jugement publiées dans Le Monde du 11 juillet 1981, ainsi que dans le Dalloz-Sirey sont toutes les deux gravement fautives).

La plupart des références du Professeur renvoient à :

Vérité historique ou vérité politique ?, Serge Thion, La Vieille Taupe, Paris 1980, 352 p.

Robert Faurisson, Réponse à Pierre Vidal-Naquet, édité par l'auteur, imprimé à Gentilly, [juin] 1982, 64 p., bib., Avertissement de P. Guillaume

La présente plaquette est en vente dans plusieurs librairies du Quartier latin et chez l'éditeur.

- 80 -

Le texte de l'arrêt de la Cour d'appel de Paris 1^re^ chambre, section A du 26 avril 1983 se trouve ici (http://robertfaurisson.blogspot.it/1983/04/communique-texte-de-larret-du-26-avril.html).

Labels: ASSAG, colloque de la Sorbonne, Europe 1, Georges Wellers, Johann Paul Kremer, Jouanneau, Korman, Le Matin de Paris, Le Monde, Leichenkeller, LICA, LICRA, Pierre Guillaume, Raymond Aron
