<!-- https://robertfaurisson.blogspot.com/2006/12/les-victoires-du-revisionnisme.html -->

<!-- Monday, December 11, 2006 -->

# Les victoires du révisionnisme

Au Président Mahmoud Ahmadinejad

À nos prisonniers de conscience Ernst Zündel, Germar Rudolf, Horst Mahler

À Arthur Butz, Fred Leuchter, Barbara Kulaszka, Ahmed Rami, Gerd Honsik, Heinz Koppe

## Résumé

Au procès de Nuremberg (1945-1946), le tribunal des vainqueurs a notamment accusé l'Allemagne vaincue

1\) d'avoir ordonné et planifié l'extermination physique des juifs d'Europe ;

2\) d'avoir, dans ce but, mis au point et utilisé des armes de destruction massive appelées, en particulier, « chambres à gaz » ;

3\) d'avoir, essentiellement par ces armes mais aussi par d'autres moyens, provoqué la mort de six millions de juifs.

À l'appui de cette triple accusation, reprise depuis soixante ans par l'ensemble des grands médias occidentaux, on n'a produit aucune preuve qui résiste à l'examen. Le professeur Robert Faurisson en a conclu en 1980 :

> « Les prétendues chambres à gaz hitlériennes et le prétendu génocide des juifs forment un seul et même mensonge historique, qui a permis une gigantesque escroquerie politico-financière, dont les principaux bénéficiaires sont l'État d'Israël et le sionisme international et dont les principales victimes sont le peuple allemand ― mais non pas ses dirigeants ― et le peuple palestinien tout entier. »

En 2006, il maintient intégralement cette conclusion. En près de soixante ans, les révisionnistes, à commencer par les Français Maurice Bardèche et Paul Rassinier, ont accumulé, du point de vue historique et scientifique, une impressionnante série de victoires sur leurs adversaires. Vingt exemples sont ici donnés de ces victoires, qui vont de 1951 à nos jours.

Le révisionnisme n'est pas une idéologie mais une méthode inspirée par la recherche de l'exactitude en matière d'histoire. Les circonstances font que le révisionnisme est aussi devenu la grande aventure intellectuelle du temps présent.

Né en 1929 d'un père français et d'une mère britannique (écossaise), Robert Faurisson a enseigné les lettres classiques (français, latin, grec), puis s'est spécialisé d'abord dans l'analyse de textes de la littérature française moderne et contemporaine et, enfin, dans la critique de textes et documents (littérature, histoire, médias). Il a enseigné, en particulier à la Sorbonne et à l'Université de Lyon. À cause de ses prises de position révisionnistes, il a été interdit d'enseignement. À de multiples reprises il a été condamné en justice. Il a subi dix agressions physiques. En France, presse, radio et télévision lui sont fermées ainsi qu'à tout révisionniste. Parmi ses ouvrages : *Ecrits révisionnistes (1974-1998),* en quatre volumes (2^e^ édition, LV-2027 p.).

## Avertissement

Le présent exposé a pour titre « Les victoires du révisionnisme » et non pas « Histoire du révisionnisme » ou « Arguments de la thèse révisionniste ». Il traite des seules victoires que nos adversaires ont dû nous concéder de manière explicite ou implicite. Il ne faut donc pas s'attendre ici à trouver mention systématique d'auteurs, d'ouvrages ou d'arguments révisionnistes. Si toutefois il me fallait recommander un bref échantillon de lectures révisionnistes, je conseillerais l'ouvrage de première référence que constitue *The Hoax of the Twentieth Century / The Case Against the Presumed Extermination of European Jewry,* publié en 1976 par Arthur Robert Butz. Le livre est magistral. Dans ses trente années d'existence personne n'en a tenté la réfutation tant il est solidement bâti ; j'en conseille la lecture dans l'édition de 2003, qui a l'avantage de contenir cinq remarquables suppléments. Il conviendrait également de lire, de Fred Leuchter, son fameux rapport, *An Engineering Report on the Alleged Execution Gas Chambers at Auschwitz, Birkenau and Majdanek, Poland* ; j'en recommande la lecture dans l'édition à couverture dorée, éditée par Samisdat Publishers à Toronto en 1988 et contenant, à la page 42 [p. 59 au lien indiqué ― Ndt], le texte d'une lettre du 14 mai 1988 sur l'absence totale d'orifices dans les toits des prétendues chambres à gaz des crématoires II et III d'Auschwitz-Birkenau ; F. Leuchter a également publié trois autres rapports sur la question des chambres à gaz. Du chimiste allemand Germar Rudolf on ne manquera pas de lire au moins *Lectures on the Holocaust / Controversial Issues Cross Examined,* Theses and Dissertations Press (PO Box 257768, Chicago, IL 60625, USA), 2005, 566 p., ainsi que l'impressionnante série (plus de trente volumes à cette heure) qu'il a publiée sous le titre de *Vierteljahreshefte für freie Geschichtsforschung,* sans compter, en anglais, sa revue *The Revisionist* et bien d'autres publications qui font déjà de l'œuvre de G. Rudolf (aujourd'hui âgé de 42 ans et prisonnier en Allemagne) un formidable monument scientifique. Enfin, citons l'opus magnum de l'avocate canadienne Barbara Kulaszka, *Did Six Million Really Die? / Report of the Evidence in the Canadian « False News » Trial of Ernst Zündel,* 1988, publié en 1992 ; sa densité typographique en fait un ouvrage d'environ mille pages de format usuel ; on y voit que, lors de deux très longs procès intentés à Ernst Zündel en 1985 et en 1988 devant un tribunal de Toronto, la partie adverse, confrontée à l'argumentation révisionniste, s'est effondrée : un vrai Stalingrad pour les historiens orthodoxes, à commencer par le plus grand d'entre eux, Raul Hilberg. Des études essentielles ont été écrites par les Allemands Wilhelm Stäglich et Udo Walendy, l'Italien Carlo Mattogno, l'Espagnol Enrique Aynat Eknes, le Suisse Jürgen Graf et une dizaine d'autres auteurs. Les 97 livraisons de The Journal of Historical Review (1980-2002), dues pour une bonne partie à l'Américain Mark Weber, constituent une mine de renseignements sur tous les aspects de la recherche révisionniste. En France, Pierre Guillaume, Serge Thion, Henri Roques, Pierre Marais, Vincent Reynouard, Jean Plantin ont pris la suite de Maurice Bardèche et de Paul Rassinier. On ne compte plus à travers le monde les publications et les sites Internet de caractère révisionniste, et ce malgré la censure et la répression.

L'« Holocauste » reste néanmoins l'unique religion officielle de tout l'Occident, une religion meurtrière s'il en fut. Et qui continue d'abuser des millions de braves gens par les procédés les plus grossiers : étalage de tas de lunettes, de cheveux, de chaussures ou de bagages présentés comme des « reliques » de « gazés », photographies falsifiées ou détournées de leur sens, usage de documents inoffensifs altérés ou interprétés à contresens, mises en scène de témoins professionnels, multiplication à l'infini de monuments, de cérémonies, de spectacles, matraquage shoatique dès l'école, déplacements organisés vers les lieux saints du prétendu martyre juif et procès à grand spectacle avec appels au lynchage.

―――

Le président Ahmadinejad a eu le mot juste : le prétendu « Holocauste » des juifs est un « mythe », c'est-à-dire une croyance entretenue par la crédulité ou l'ignorance. En France, il est parfaitement licite de proclamer qu'on ne croit pas en Dieu mais il est interdit de dire qu'on ne croit pas en « l'Holocauste », ou simplement qu'on en doute. Cette interdiction de toute espèce de contestation est devenue formelle et officielle avec la loi du 13 juillet 1990. Ladite loi a été publiée au Journal officiel de la République française le lendemain, c'est-à-dire le 14 juillet, jour de commémoration de la République et de la Liberté. Elle prononce que la peine peut aller jusqu'à un an de prison et une amende de 45 000 euros ; mais est également possible la condamnation au versement de dommages-intérêts et de considérables frais de publications judiciaires. La jurisprudence précise que tout cela s'applique « même si [cette contestation] est présentée sous une forme déguisée ou dubitative ou par voie d'insinuation » (Code pénal, Paris, Dalloz, 2006, p. 2059). La France n'a donc qu'un mythe officiel, celui de « l'Holocauste », et ne connaît qu'un blasphème, celui qui outrage « l'Holocauste ».

Personnellement, le 11 juillet 2006, j'ai été une fois de plus assigné en justice devant un tribunal de Paris sur le fondement de cette loi spéciale. Le président du tribunal qui allait me juger, Nicolas Bonnal, avait suivi un stage de formation à la répression du révisionnisme sur Internet, un stage organisé par le Centre Simon Wiesenthal de Paris sous l'égide du Conseil représentatif des institutions juives de France (CRIF) ! Dans un communiqué triomphalement intitulé : « Le CRIF partie active de la formation des magistrats européens », cet organisme juif, dont le pouvoir politique est exorbitant, n'avait pas craint d'annoncer *urbi et orbi* qu'il comptait Nicolas Bonnal parmi ses élèves ou stagiaires. Ce n'est pas tout. A mon procès, pour faire bonne mesure, la procureuse de la République s'est trouvée être une juive du nom d'Anne de Fontette ; dans la péroraison de son réquisitoire, cette dernière, bien que censée parler au nom d'un État laïc, en a appelé à la vengeance de « Yahweh, protecteur de son peuple élu » contre « les lèvres fausses » de Faurisson, coupable d'avoir accordé un entretien téléphonique de caractère révisionniste à une station de radio-télévision iranienne, Sahar 1.

## Les conclusions de la recherche révisionniste

Les Allemands du Troisième Reich ont voulu extirper les juifs d'Europe mais non les exterminer. Ils ont souhaité « une solution finale territoriale de la question juive » et non pas une « solution finale » au sens d'une quelconque suppression physique (souhaiter une « solution finale du chômage », ce n'est pas vouloir la mort des chômeurs). Les Allemands ont eu des camps de concentration mais non des « camps d'extermination » (expression forgée par la propagande alliée). Ils ont utilisé des chambres à gaz de désinfection fonctionnant notamment avec un insecticide appelé Zyklon B (à base d'acide cyanhydrique) mais ils n'ont jamais eu de chambres à gaz homicides ou de camions à gaz homicides. Ils ont utilisé des fours crématoires pour l'incinération de cadavres et non pour y enfourner des êtres vivants. Après la guerre, les photographies dites « d'atrocités nazies » nous montraient soit des malades, soit des mourants, soit des morts mais non des tués. À cause du blocus des Alliés, à cause de leurs bombardements généralisés et à cause de l'apocalypse vécue par l'Allemagne à la fin d'un conflit de près de six années, la famine et les épidémies, notamment de typhus, avaient ravagé le pays et, en particulier, les camps de l'ouest surpeuplés par l'arrivée massive des détenus évacués des camps de l'est et privés de nourriture, de médicaments et du Zyklon B nécessaire à la protection contre le typhus.

Dans cette boucherie qu'est une guerre, on souffre. Dans une guerre moderne, les civils des nations belligérantes souffrent parfois autant, sinon plus, que les soldats. Durant le conflit qui, de 1933 à 1945, les a opposés aux Allemands, les juifs européens ont donc eu à souffrir mais infiniment moins qu'ils n'osent l'affirmer avec aplomb. Certes, les Allemands les ont traités comme une minorité hostile ou dangereuse (il y avait des raisons à cela) et contre ces gens les autorités du III^e^ Reich ont été amenées à prendre, à cause de la guerre, des mesures, de plus en plus coercitives, de police ou de sécurité militaire. Dans certains cas, ces mesures sont allées jusqu'à la mise en camps d'internement ou bien jusqu'à la déportation vers des camps de concentration ou de travail forcé. Parfois des juifs ont été exécutés pour sabotage, pour espionnage, pour terrorisme et, surtout, pour activités de guérilla en faveur des Alliés, principalement sur le front russe mais non pour la simple raison qu'ils étaient juifs. Jamais Hitler n'a ordonné ou permis qu'on tue une personne en raison de sa race ou de sa religion. Quant au chiffre de six millions de morts juives, il est une pure invention qui n'a jamais reçu de justification malgré les efforts en ce sens de l'institut Yad Vashem de Jérusalem.

Devant les formidables accusations lancées contre l'Allemagne vaincue les révisionnistes ont dit aux accusateurs:

1\) Montrez-nous un seul document qui, à votre avis, prouve que Hitler ou un quelconque national-socialiste a ordonné et planifié l'extermination physique des juifs ;

2\) Montrez-nous cette arme de destruction massive qu'aurait été une chambre à gaz ; montrez-en nous une seule, à Auschwitz ou ailleurs ; et si, par hasard, vous prétendez que vous ne pouvez pas nous en montrer une parce que les Allemands auraient, selon vous, détruit « l'arme du crime », fournissez-nous au moins un dessin technique représentant l'un de ces abattoirs qui, à vous en croire, auraient été détruits par les Allemands et expliquez-nous comment cette arme aux rendements fantastiques a bien pu fonctionner sans entraîner la mort des exécutants ou de leurs aides ;

3\) Expliquez-nous comment vous êtes parvenus à votre chiffre de six millions de victimes.

Or, en plus de soixante ans, les historiens-accusateurs juifs ou non juifs se sont révélés incapables d'apporter une réponse à ces trois demandes. Ils ont donc accusé sans preuves. Cela s'appelle calomnier.

Mais il y a plus grave : les révisionnistes ont énuméré une série de faits réels qui prouvent que cette extermination physique, ces chambres à gaz et ces six millions n'ont pas pu exister. 1) Le premier de ces faits est que, pendant toute la durée de la guerre, des millions de juifs européens ont vécu au vu et au su de tous, une bonne partie d'entre eux étant employés en usines par les Allemands qui manquaient cruellement de main-d'œuvre, et ces millions de juifs-là n'ont donc pas été tués. Mieux : les Allemands ont obstinément offert aux Alliés, jusque dans les derniers mois du conflit, de leur livrer autant de juifs qu'ils le souhaiteraient à la condition expresse que ce ne fût pas pour les envoyer en Palestine, et cela par égard pour « le noble et vaillant peuple arabe » déjà accablé par les colons juifs. 2) Le deuxième de ces faits, qu'on nous cache soigneusement, est que les excès éventuellement commis contre les juifs pouvaient entraîner les sanctions les plus sévères ; tuer un seul juif ou une seule juive pouvait valoir, y compris pour les soldats allemands, d'être condamné à mort par un tribunal militaire et fusillé. Autrement dit, les juifs vivant sous administration allemande continuaient, s'ils observaient les règlements en vigueur, de jouir de la protection de la loi pénale, même vis-à-vis des forces armées. 3) Le troisième de ces faits est que les prétendues chambres à gaz nazies d'Auschwitz ou d'ailleurs sont tout simplement inconcevables pour des raisons physiques ou chimiques qui sont évidentes : jamais, après le prétendu gazage au gaz cyanhydrique de centaines ou de milliers d'hommes dans un local, d'autres hommes auraient pu pénétrer dans un véritable bain de ce poison pour y manipuler et extraire tant de cadavres qui, cyanurés en surface comme en profondeur, seraient devenus intouchables. Le gaz cyanhydrique adhère fortement aux surfaces ; il pénètre même le ciment ou la brique et il est difficile à ventiler ; il pénètre la peau, il s'installe dans les corps, il se mêle aux humeurs. Aux États-Unis, c'est précisément ce gaz qu'on utilise encore de nos jours dans une chambre à gaz pour exécuter un condamné à mort, mais précisément cette chambre est d'acier et de verre, elle est pourvue d'une machinerie obligatoirement très compliquée et nécessite d'extraordinaires précautions d'emploi ; il suffit de voir une chambre à gaz américaine destinée à exécuter un seul individu pour se rendre compte que les prétendues chambres à gaz d'Auschwitz supposées avoir servi à exécuter des foules d'individus, jour après jour, n'ont pu ni exister ni fonctionner.

Mais alors, dira-t-on, que sont devenus tous ces juifs dont, nous, révisionnistes, nous concluons de nos recherches qu'ils n'ont jamais été tués ? La réponse est là, sous nos yeux et à la portée de tous : une partie des juifs d'Europe est morte, comme des dizaines de millions de non-juifs, du fait de la guerre, de la faim, des épidémies et une autre partie des juifs a bel et bien survécu, par millions, à la guerre. Ces derniers se sont fait abusivement appeler des « miraculés ». En 1945, les « survivants » ou les « miraculés » juifs européens se comptaient par millions et ils ont essaimé dans une cinquantaine de pays du monde, à commencer par la Palestine. Comment une prétendue décision de totale extermination physique des juifs aurait-elle pu ainsi engendrer des millions de « miraculés » juifs ? Des millions de « miraculés », ce n'est plus un miracle ; c'est un faux miracle, c'est un mensonge, c'est une fraude.

Pour ma part, j'ai, en 1980, résumé en une phrase de soixante mots français les conclusions des recherches révisionnistes :

> Les prétendues chambres à gaz hitlériennes et le prétendu génocide des juifs forment un seul et même mensonge historique, qui a permis une gigantesque escroquerie politico-financière dont les principaux bénéficiaires sont l'État d'Israël et le sionisme international et dont les principales victimes sont le peuple allemand ― mais non pas ses dirigeants ― et le peuple palestinien tout entier.

Aujourd'hui, en 2006, soit vingt-six ans plus tard, je maintiens cette phrase dans son intégralité. Celle-ci ne m'était inspirée par aucune sympathie ou antipathie politique ou religieuse. Elle trouvait son fondement dans des faits avérés qu'avaient commencé de mettre au jour, d'une part, Maurice Bardèche, en 1948 et en 1950, avec ses deux livres sur le procès de Nuremberg et, d'autre part, Paul Rassinier, en 1950, en publiant *Le Mensonge d'Ulysse*. A partir de 1951, année après année, nos adversaires, si riches, si puissants, si acharnés à pratiquer toutes les formes possibles de répression contre le révisionnisme, se sont vus contraints de nous donner progressivement raison sur les plans technique, scientifique et historique. Les victoires remportées par le révisionnisme de la Deuxième guerre mondiale sont nombreuses et significatives, mais, il faut malheureusement le reconnaître, elles restent encore de nos jours quasiment inconnues du grand public. Ces victoires, les puissants ont tout fait pour les cacher au monde. Cela se comprend : leur domination et leur partage du monde sont en quelque sorte fondés sur la religion du prétendu « Holocauste » des juifs. Mettre en cause « l'Holocauste », en dévoiler publiquement l'extraordinaire imposture, arracher leur masque aux hommes politiques, aux journalistes, aux historiens, aux universitaires, aux hommes d'églises, de clans, de chapelles qui, pendant plus de soixante ans, ont prêché le faux tout en brandissant l'anathème contre les impies, constitue une périlleuse aventure. Mais, comme on va le voir, malgré la répression, le temps semble finir par jouer en faveur des révisionnistes.

## Exemples de victoires révisionnistes

Je ne rappellerai ici que vingt de ces victoires.

1\) En 1951, le juif Léon Poliakov, qui avait été attaché à la délégation française au procès de Nuremberg (1945-1946), a conclu que, pour tous les points de l'histoire du III^e^ Reich nous disposions d'une surabondance de documents à l'exception d'un seul point : la « campagne d'extermination des juifs ». Là, écrit-il, «[a]ucun document n'est resté, n'a peut-être jamais existé » (*Bréviaire de la haine,* Paris, Calmann-Lévy, 1974 [1951], p. 171).

Remarque : Il y a là une extraordinaire concession à la thèse révisionniste. En effet, une aussi formidable entreprise criminelle censément conçue, ordonnée, organisée et perpétrée par les Allemands aurait nécessité un ordre, un plan, des instructions, un budget,... Une telle entreprise, menée pendant des années, sur tout un continent et produisant la mort de millions de victimes aurait laissé un flot de preuves documentaires. En conséquence, si l'on vient nous dire qu'il n'a peut-être jamais existé de telles preuves documentaires, c'est que le crime en question n'a pas été perpétré. En l'absence de tout document, l'historien n'a plus qu'à se taire. L. Poliakov a fait cette concession en 1951, c'est-à-dire il y a cinquante-cinq ans. Or il faut savoir que, de 1951 à 2006, ses successeurs ont également échoué à trouver la moindre preuve documentaire. Episodiquement, çà et là, on a assisté à des tentatives pour nous faire croire à telle ou telle découverte mais, à chaque fois, comme on le verra ci-dessous, il a fallu déchanter.

2\) En 1960, Martin Broszat, membre de l'Institut d'histoire contemporaine de Munich, a écrit : « Ni à Dachau, ni à Bergen-Belsen, ni à Buchenwald, des juifs ou d'autres détenus n'ont été gazés » (*Die Zeit,* 19 août 1960, p. 16).

Remarque : Cette concession soudaine et inexpliquée est significative. Au procès de Nuremberg, la seule chambre à gaz homicide que l'accusation se fût hasardée à nous montrer dans un film avait été celle de Dachau et nombreux avaient été les témoignages de prétendus gazages homicides dans les trois camps susmentionnés. M. Broszat reconnaît donc implicitement que ces témoignages étaient faux. Il ne nous dit pas en quoi ils étaient faux. Il ne nous dit pas non plus en quoi d'autres témoignages portant, par exemple, sur Auschwitz, Majdanek, Treblinka, Sobibor ou Belzec continueraient, eux, d'être dignes de foi. Dans les années 1980, à Dachau, une pancarte indiquait en cinq langues que la « chambre à gaz déguisée en douche » que visitaient les touristes n'avait « jamais servi » en tant que telle. Les révisionnistes avaient alors demandé en quoi la pièce pouvait être qualifiée de «chambre à gaz» homicide. Du coup, les autorités du Musée de Dachau ont retiré cette pancarte pour la remplacer par une autre où, en allemand et en anglais, il est maintenant dit : « Chambre à gaz. Ici se trouvait le centre du meurtre de masse potentiel » et on ajoute que « jusqu'à 150 hommes à la fois pouvaient être gazés » dans cet espace avec du Zyklon B. On remarquera les mots de « potentiel » et de « pouvaient » (en anglais, *« potential »* et *« could »*). Le choix de ces mots témoigne d'une belle fourberie : il fait naître chez les touristes l'idée que ladite « chambre à gaz » a effectivement servi à tuer mais, en même temps, il permet de rétorquer aux révisionnistes : «Nous n'avons pas dit expressément que cette chambre à gaz a servi à tuer ; nous avons simplement dit qu'elle pouvait ou qu'elle aurait pu, à l'époque, servir à tuer tant de personnes ». Pour conclure, en 1960, M. Broszat a, sans aucune explication, décrété dans une simple lettre que personne n'avait été gazé à Dachau ; puis, dans les années qui ont suivi, les autorités du Musée de Dachau, fort embarrassées, ont essayé, au prix de différentes supercheries qui ont varié avec le temps, de tromper les visiteurs en leur laissant croire que, dans cette pièce à allure de douche (et pour cause, car c'en était une), on avait bel et bien gazé des gens.

3\) En 1968, l'historienne juive Olga Wormser-Migot, dans sa thèse sur Le Système concentrationnaire nazi, 1933-1945 (Paris, Presses universitaires de France, 1968), a consacré tout un développement à ce qu'elle appelle « Le problème des chambres à gaz » (p. 541-544). Elle y exprime son scepticisme sur la valeur de célèbres témoignages attestant de l'existence de chambres à gaz dans des camps comme ceux de Mauthausen ou de Ravensbrück. Sur Auschwitz-I, elle est formelle : ce camp où, aujourd'hui encore, les touristes visitent une prétendue chambre à gaz était, en réalité, « sans chambre à gaz » (p. 157).

Remarque : Pour porter contre les vaincus d'horribles accusations de gazages homicides, on s'est seulement fié à des témoignages et ces témoignages n'ont pas été vérifiés. Notons ici le cas particulier d'Auschwitz-I : il y a donc 38 ans, une historienne juive a eu le courage d'écrire que ce camp était « sans chambre à gaz » ; or, encore aujourd'hui, en 2006, les touristes visitent en foule à Auschwitz-I une pièce qu'on ose, fallacieusement, leur présenter comme une « chambre à gaz ». On est là devant une supercherie.

4\) En 1979, trente-quatre historiens français ont signé une longue déclaration commune en réponse aux arguments techniques que j'avais personnellement invoqués pour démontrer que l'existence et le fonctionnement des chambres à gaz nazies se heurtent à des impossibilités matérielles radicales. Selon la thèse officielle, Rudolf Höss, l'un des trois commandants successifs d'Auschwitz, avait avoué (!) et décrit comment à Auschwitz et à Birkenau on gazait les juifs. D'après cet aveu, très vague, lorsque les victimes semblaient avoir rendu leur dernier soupir, on mettait en marche un appareil de ventilation et une équipe de prisonniers juifs entrait immédiatement dans la vaste pièce pour en retirer les cadavres et les transporter jusqu'aux fours crématoires. R. Höss disait que ces juifs procédaient à ce travail négligemment en fumant et en mangeant. J'ai fait observer que c'était impossible : on ne peut pas pénétrer en fumant et en mangeant dans un local saturé d'acide cyanhydrique (gaz virulent, pénétrant et explosible) pour y toucher, manipuler et en extraire à grand ahan des milliers de cadavres imprégnés d'acide cyanhydrique et donc intouchables. Dans leur déclaration, les trente-quatre historiens m'ont répondu : « Il ne faut pas se demander comment, techniquement, un tel meurtre de masse a été possible. Il a été possible techniquement puisqu'il a eu lieu » (*Le Monde,* 21 février 1979, p. 23).

Remarque : Cette réponse revient à esquiver la question posée. Si on se dérobe ainsi, c'est qu'on est incapable de répondre. Et si trente-quatre historiens se trouvent à ce point incapables d'expliquer comment un crime de cette dimension a été perpétré, c'est que ce crime défie les lois de la nature; il est donc imaginaire.

5\) En 1979, également, les autorités américaines se sont enfin décidées à rendre publiques des photographies aériennes d'Auschwitz que, jusqu'à présent, elles tenaient cachées. Avec cynisme ou naïveté, les deux auteurs de la publication, Dino A. Brugioni et Robert G. Poirier, anciens membres de la CIA, donnent au petit recueil de photos le titre de *The Holocaust Revisited* et collent çà et là des étiquettes portant les mots de « gas chamber(s) », mais, dans leurs commentaires, rien ne vient justifier de telles appellations (Central Intelligence Agency, Washington, February 1979, ST-79-10001).

Remarques : Aujourd'hui, en 2006, cette supercherie nous fait songer à la misérable démonstration de l'ancien ministre américain Colin Powell essayant de prouver, avec le même procédé des étiquettes apposées sur des photos aériennes, l'existence d'usines de fabrication d'«armes de destruction massive» dans l'Irak de Saddam Hussein. En réalité, ces photographies d'Auschwitz infligent un démenti à la thèse des chambres à gaz nazies. Ce que l'on voit distinctement sur elles, ce sont de paisibles crématoires sans aucune foule de gens agglutinés à l'extérieur en attente de pénétrer dans les prétendus vestiaires et les prétendues chambres de la mort. Les terrains aux alentours sont dégagés et visibles de partout. Les plates-bandes des jardinets de ces crématoires sont bien dessinées et ne portent aucune trace d'un piétinement, chaque jour, de milliers de personnes. Le crématoire n°3, par exemple, est contigu à ce que nous savons être, grâce à des documents sûrs du Musée d'État d'Auschwitz, un terrain de football et il est proche d'un terrain de volley-ball (*Hefte von Auschwitz,* 15, 1975, hors-texte de la page 56 et page 64). Il est également proche des dix-huit baraquements hospitaliers du camp des hommes. Il y a eu trente-deux missions aériennes des Alliés au-dessus de toute cette zone qui comprenait aussi les importantes installations industrielles de Monowitz. On comprend que les Alliés y aient bombardé à plusieurs reprises le secteur industriel tout en épargnant autant que possible ce qui était évidemment un camp de concentration, de travail et de transit et non un « camp d'extermination », sur lequel ne sont tombées en fin de compte que quelques bombes perdues.

6\) En 1982, le 21 avril, une association a été fondée à Paris pour l'étude des assassinats par gaz sous le régime national-socialiste (ASSAG) « en vue de rechercher et contrôler les éléments apportant la preuve de l'utilisation des gaz toxiques par les responsables du régime national-socialiste en Europe pour tuer les personnes de différentes nationalités, contribuer à la publication de ces éléments de preuve, prendre à cet effet tous les contacts utiles au plan national et international ». L'article 2 des statuts dispose : « La durée de l'Association est limitée à la réalisation de son objet énoncé à l'article 1. » Or cette association fondée par quatorze personnes, dont Germaine Tillion, Georges Wellers, Geneviève Anthonioz née de Gaulle, M^e^ Bernard Jouanneau et Pierre Vidal-Naquet, n'a, en près d'un quart de siècle, jamais rien publié et elle continue d'exister en 2006. Pour le cas où l'on soutiendrait, à tort, qu'elle a produit un livre intitulé *Chambres à gaz, secret d'État,* il conviendrait de rappeler qu'il s'agit là en fait de la traduction en français d'un ouvrage publié en allemand par Eugen Kogon, Hermann Langbein et Adalbert Rückerl et où figurent quelques contributions de quelques membres de l'ASSAG (Paris, Editions de Minuit, 1984).

Remarque : A lui seul, le titre de cet ouvrage donne une bonne idée de son contenu : au lieu de preuves, appuyées de photographies de chambres à gaz, de dessins, de croquis, de rapports d'expertises sur l'arme du crime, le lecteur ne trouve que des spéculations à partir de ce qui est appelé « éléments de preuves » (et non « preuves »), et cela parce que, nous dit-on, ces chambres à gaz auraient constitué le plus grand des secrets possibles, un « secret d'État ». S'il est une « arme de destruction massive » qui aurait mérité une expertise en bonne et due forme, c'est bien cette arme-là. En effet, elle constitue une anomalie dans l'histoire de la science pour deux raisons au moins : elle n'a pas eu de précédent et elle n'a pas eu de suite ; elle a surgi du néant pour retourner au néant. Or, l'histoire de la science ne connaît aucun phénomène de ce genre. En tout cas, du seul fait de son existence encore aujourd'hui en 2006, on peut dire que cette association dite ASSAG n'a toujours pas réalisé l'objet pour lequel elle a été fondée, il y aura bientôt vingt-cinq ans. Elle n'a donc encore trouvé ni preuves, ni même éléments de preuves de l'existence des « chambres à gaz nazies ».

7\) En 1982, du 29 juin au 2 juillet, s'est tenu à Paris, à la Sorbonne, un colloque international sous la présidence de deux historiens juifs, François Furet et Raymond Aron. Selon ses organisateurs, il s'agissait de répliquer solennellement et publiquement à Robert Faurisson et à « une poignée d'anarcho-communistes » qui lui avaient apporté leur soutien (allusion à Pierre Guillaume, Jean-Gabriel Cohn-Bendit, Serge Thion ainsi qu'à d'autres libertaires, parfois juifs). Le dernier jour, lors de la conférence de presse tant attendue, les deux organisateurs ont dû admettre publiquement que, « malgré les recherches les plus érudites », on n'avait pas trouvé un ordre de Hitler de tuer les juifs. Quant aux chambres à gaz, ils n'y ont pas même fait allusion.

Remarque : Ce colloque a constitué la première tentative en vue de montrer au grand public que les révisionnistes mentaient. Comme d'autres colloques du même genre (notamment en 1987, toujours à la Sorbonne), l'accès en a été interdit aux révisionnistes et, comme tous les autres colloques, sans exception, il a débouché sur un complet échec pour ses organisateurs.

8\) En 1983, le 26 avril, prenait fin, en appel, le long procès qui m'avait été intenté en 1979, notamment par des organisations juives, pour « dommage à autrui » par « falsification de l'histoire » (sic). Ce jour-là, la première chambre de la cour d'appel civile de Paris, section A (président Grégoire), tout en confirmant ma condamnation pour « dommage à autrui » rendait un hommage appuyé à la qualité de mes travaux. Elle prononçait, en effet, qu'on ne pouvait déceler dans mes écrits sur les chambres à gaz aucune trace de légèreté, aucune trace de négligence, aucune trace d'ignorance délibérée, ni aucune trace de mensonge et que, par voie de conséquence, « la valeur des conclusions défendues par M. Faurisson [sur les chambres à gaz] relève donc de la seule appréciation des experts, des historiens et du public ».

Remarque : Si l'on ne peut relever chez l'auteur de travaux réfutant la thèse des chambres à gaz ni légèreté, ni négligence, ni ignorance délibérée, ni mensonge, ni «falsification», c'est la preuve que ces travaux sont ceux d'un chercheur sérieux, appliqué, consciencieux, probe et authentique, et cela à un tel degré qu'on doit avoir le droit de soutenir publiquement, comme il le fait, que lesdites chambres à gaz ne sont qu'un mythe.

9\) En 1983, le 7 mai, Simone Veil, qui est juive et elle-même une « survivante du génocide », a déclaré au sujet des chambres à gaz : « Au cours d'un procès intenté à Faurisson pour avoir nié l'existence des chambres à gaz, ceux qui intentent le procès sont contraints d'apporter la preuve formelle de la réalité des chambres à gaz. Or chacun sait que les nazis ont détruit ces chambres à gaz et supprimé systématiquement tous les témoins » (*France-Soir Magazine,* 7 mai 1983, p. 47).

Remarque : S'il n'y a ni arme du crime, ni témoignages, que reste-t-il ? Que penser des locaux présentés à des millions de visiteurs abusés comme étant des chambres à gaz ? Que penser des personnages qui se présentent en témoins ou en miraculés des chambres à gaz ? Pour sa part, S. Veil est la première autorité holocaustique qui ait ainsi donné à entendre que tout prétendu témoin des gazages ne peut être qu'un faux témoin. Déjà le 6 mars 1979, lors d'un débat des « Dossiers de l'écran » organisé par la télévision française autour de la sortie du feuilleton américain «Holocaust», elle avait manifesté son mépris pour Maurice Benroubi présenté comme un « témoin des chambres à gaz ». Ce dernier s'était du coup montré d'une extrême discrétion par rapport à son « témoignage » paru peu auparavant dans *L'Express* (3-9 mars 1979, p. 107-110).

10\) En 1961, le juif Raul Hilberg, *number one* des historiens orthodoxes, avait publié la première édition de son œuvre majeure et c'est en 1985 qu'il en a publié la seconde édition, profondément revue et corrigée. La distance est considérable entre ces deux éditions et ne peut s'expliquer que par la succession de victoires remportées entre-temps par les révisionnistes. Dans la première édition, l'auteur avait froidement affirmé que « la destruction des juifs d'Europe » avait été déclenchée à la suite de deux ordres successifs donnés par Hitler. Il ne précisait ni la date, ni le contenu de ces ordres. Ensuite il prétendait expliquer par le menu le processus politique, administratif et bureaucratique de cette destruction ; par exemple il allait jusqu'à écrire qu'à Auschwitz l'extermination des juifs était organisée par un bureau qui était chargé à la fois de la désinfection des vêtements et de l'extermination des êtres humains (*The Destruction of the European Jews,* 1961, réédité en 1979 par Quadrangle Books, Chicago, p. 177, 570). Or, en 1983, renonçant totalement à cette explication, R. Hilberg en est soudain venu à affirmer que le processus de « destruction des juifs d'Europe » s'était, en fin de compte, déroulé sans plan, sans organisation, sans centralisation, sans projet, sans budget, mais, en tout et pour tout, grâce à « une incroyable rencontre des esprits, une transmission de pensée consensuelle au sein d'une vaste bureaucratie », la bureaucratie allemande (an incredible meeting of minds, a consensus mind reading by a far-flung bureaucracy) (Newsday, New York, 23 février 1983, p. II/3). Cette explication, R. Hilberg la confirmera sous serment au procès Zündel de 1985 à Toronto, le 16 janvier 1985 (compte rendu verbatim, p. 848) ; puis, il la confirmera de nouveau mais avec d'autres mots dans la version profondément révisée de son ouvrage (*The Destruction of the European Jews,* New York, Holmes & Meier, 1985, p. 53, 55, 62 ; en français, *La Destruction des juifs d'Europe,* Paris, Fayard, 1988, p. 51, 53, 60). Il vient, enfin, de la confirmer à nouveau en octobre 2006 dans un entretien accordé au Monde : « Il n'y avait pas de schéma directeur préétabli. Quant à la question de la décision, elle est en partie insoluble : on n'a jamais retrouvé d'ordre signé de la main d'Hitler, sans doute parce qu'un tel document n'a jamais existé. Je suis persuadé que les bureaucraties sont mues par une sorte de structure latente : chaque décision en entraîne une autre, puis une autre, et ainsi de suite, même s'il n'est pas possible de prévoir exactement l'étape suivante » (Le Monde des livres, 20 octobre 2006, p. 12).

Remarque : L'historien *number one* du génocide des juifs s'est donc trouvé si désemparé qu'il en est soudain venu à se renier et à expliquer une gigantesque entreprise d'assassinat collectif comme si celle-ci s'était faite en quelque sorte par l'opération du Saint-Esprit. Il évoque, en effet, une « rencontre des esprits » au sein d'une bureaucratie et il qualifie cette rencontre d'« incroyable ». Si elle est incroyable, pourquoi faudrait-il y croire ? Faut-il croire à l'incroyable ? Il invoque aussi la «transmission de pensée» et qualifie celle-ci de « consensuelle », mais il s'agit là d'une pure spéculation intellectuelle à base de croyance dans le surnaturel. Comment croire à un phénomène de ce genre, en particulier au sein d'un vaste appareil bureaucratique et, plus particulièrement encore, au sein de la bureaucratie du III^e^ Reich ? Il est à noter qu'à l'instar de R. Hilberg, les historiens officiels se sont mis, dans les années 1980-1990, à abandonner l'histoire et à verser dans la métaphysique et le jargon. Ils se sont interrogés sur le point de savoir s'il fallait être «intentionnaliste» ou « fonctionnaliste »: fallait-il supposer que l'extermination des juifs s'était produite à la suite d'une « intention » (non encore prouvée) et selon un plan concerté (non encore trouvé) ou bien cette extermination s'était-elle produite d'elle-même, spontanément et dans l'improvisation, sans intention formelle et sans aucun plan ? Ce type de controverse fumeuse témoigne du désarroi d'historiens qui, incapables de fournir des preuves et des documents à l'appui de leur thèse, en sont réduits à théoriser dans le vide. Au fond, les uns, les «intentionnalistes», nous disent : «Il y a nécessairement eu une intention et un plan, que nous n'avons pas encore trouvés mais que nous découvrirons peut-être bien un jour », tandis que les autres nous affirment : « Il n'y a pas besoin de rechercher les preuves d'une intention et d'un plan car tout a pu se passer sans intention, sans plan et sans laisser de traces ; de telles traces sont introuvables parce qu'elles n'ont jamais existé.»

11\) En mai 1986, en France, des juifs, s'alarmant de constater qu'ils ne parvenaient pas à répliquer aux révisionnistes sur le simple plan de la raison, ont décidé d'entreprendre une action en vue d'obtenir la répression légale du révisionnisme. Ces juifs sont principalement Georges Wellers et Pierre Vidal-Naquet réunis, avec leurs amis, autour du grand rabbin de France, René Samuel Sirat (Bulletin quotidien de l'Agence télégraphique juive, 2 juin 1986, p. 1, 3). Au bout de quatre ans, ils obtiendront, grâce notamment au juif Laurent Fabius, président de l'Assemblée nationale, le vote, le 13 juillet 1990, d'une loi spéciale permettant d'infliger à toute personne tenant publiquement des propos révisionnistes au sujet de « l'extermination des juifs » une peine pouvant aller jusqu'à un an de prison, une amende d'un maximum de 300 000 F (45 000 euros) et d'autres peines encore. Ce coup de force constitue un flagrant aveu de faiblesse.

Remarque : G. Wellers et P. Vidal-Naquet ont été surtout alarmés par l'arrêt du 26 avril 1983 (voyez, ci-dessus, le paragraphe 8). Le premier a écrit : « La cour a reconnu que [Faurisson] s'était bien documenté. Ce qui est faux. C'est étonnant que la cour ait marché » (Le Droit de vivre, juin-juillet 1987, p. 13). Le second a écrit que la Cour d'appel de Paris « a reconnu le sérieux du travail de Faurisson, ce qui est un comble, et ne l'a, en somme, condamné que pour avoir agi avec malveillance en résumant ses thèses en slogans » (Les Assassins de la mémoire, Paris, La Découverte, 1987, p. 182).

12\) En 1986, en août, Michel de Boüard, ancien résistant déporté, professeur d'histoire, doyen de la faculté des lettres de l'université de Caen, membre de l'Institut de France, responsable, au sein du Comité d'histoire de la Deuxième guerre mondiale, de la commission d'histoire de la déportation, a déclaré qu'en fin de compte « le dossier est pourri ». Il précisait que le dossier en question, celui de l'histoire du système concentrationnaire allemand, était « pourri » par, selon ses propres mots, « énormément d'affabulations, d'inexactitudes obstinément répétées, notamment sur le plan numérique, d'amalgames, de généralisations ». Faisant allusion aux études des révisionnistes, il ajoutait qu'il y avait « d'autre part, des études critiques très serrées pour démontrer l'inanité de ces exagérations » (Ouest-France, 2-3 août 1986, p. 6).

Remarque : M. de Boüard était un historien professionnel et même l'historien français le plus compétent en matière d'histoire de la déportation. Jusqu'en 1985 il défendait la position strictement orthodoxe et officielle. A la lecture de la thèse du révisionniste Henri Roques sur le prétendu témoignage du SS Kurt Gerstein, il a compris son erreur. Il l'a honnêtement reconnue, allant jusqu'à dire que, s'il avait personnellement jusqu'ici cautionné l'existence d'une chambre à gaz dans le camp de Mauthausen, c'était à tort, sur la foi de ce qui se disait. (Sa mort prématurée en 1989 a privé le camp révisionniste d'une éminente personnalité qui s'était promis de publier un ouvrage destiné à mettre en garde les historiens contre les mensonges officiels de l'histoire de la Deuxième guerre mondiale).

13\) En 1988, Arno Mayer, professeur américain d'origine juive, enseignant à l'université de Princeton l'histoire de l'Europe contemporaine, a écrit à propos des « chambres à gaz nazies » : « Les sources pour l'étude des chambres à gaz sont à la fois rares et non fiables » (Sources for the study of the gas chambers are at once rare and unreliable) (The "Final Solution" in History, New York, Pantheon Books, 1988, p. 362 ; en français, La « solution finale » dans l'histoire, préface de Pierre Vidal-Naquet, Paris, La Découverte, 1990, p. 406).

Remarque : Encore aujourd'hui, en 2006, le grand public persiste à croire que, comme le lui suggèrent inlassablement les médias, les sources pour l'étude des chambres à gaz sont innombrables et indiscutables. Au colloque de la Sorbonne de 1982, A. Mayer n'avait, comme son ami Pierre Vidal-Naquet, pas eu de mot assez dur pour les révisionnistes ; or, six ans plus tard, voilà que cet historien ultra-orthodoxe s'est considérablement rapproché des conclusions révisionnistes.

14\) En 1989, l'historien helvétique Philippe Burrin, posant en principe et sans le démontrer que chambres à gaz nazies et génocide juif ont existé, a tenté de déterminer à quelle date et par qui la décision avait été prise d'exterminer physiquement les juifs d'Europe. Il n'y est pas plus parvenu que tous ses confrères «intentionnalistes» ou « fonctionnalistes » (*Hitler et les juifs / Genèse d'un génocide,* Paris, Seuil, 1989). Il lui a fallu constater l'absence de traces du crime et noter ce qu'il a décidé d'appeler « l'effacement obstiné de la trace d'un passage d'homme » (p. 9). Il déplore « les grandes lacunes de la documentation » et il ajoute : « Il ne subsiste aucun document portant un ordre d'extermination signé de Hitler. […] Selon toute vraisemblance, les ordres furent donnés verbalement. […] les traces sont ici non seulement peu nombreuses et éparses, mais difficiles d'interprétation » (p. 13).

Remarque : Voici encore un historien professionnel qui reconnaît qu'il ne peut produire aucun document à l'appui de la thèse officielle. Le grand public s'imagine que les traces du crime de Hitler sont nombreuses et sans ambiguïté mais l'historien qui a examiné la documentation afférente n'a, lui, rien trouvé sinon de rares semblants de «traces» auxquelles il se demande quelle interprétation donner.

15\) En 1992, Yehuda Bauer, professeur à l'Université hébraïque de Jérusalem, a déclaré lors d'une conférence internationale qui s'est tenue à Londres sur le génocide des juifs : « Le public répète encore continuellement la sotte histoire (the silly story) selon laquelle l'extermination des juifs a été décidée à Wannsee » (communiqué de la Jewish Telegraphic Agency reproduit dans The Canadian Jewish News, 30 janvier 1992, p. 8).

Remarque : Outre le fait qu'une lecture attentive du « procès-verbal » de la réunion de Berlin-Wannsee du 20 janvier 1942 prouve que les Allemands envisageaient une « solution finale territoriale [eine territoriale Endlösung] de la question juive », débouchant sur une implantation des juifs dans un espace géographique à déterminer, la déclaration bien tardive de Yehuda Bauer confirme que ce point majeur de la thèse de l'extermination des juifs n'a en fait aucune valeur. Ajoutons, à notre tour, que l'extermination des juifs n'a été décidée ni à Wannsee ni ailleurs. L'expression de « camps d'extermination » n'est qu'une invention de la propagande de guerre américaine et des exemples prouvent que, pendant cette guerre, l'assassinat d'un seul juif ou d'une seule juive exposait son auteur, qu'il fût civil ou militaire, membre ou non de la SS, à passer en conseil de guerre de l'armée allemande et à être fusillé (en soixante ans, jamais un seul historien orthodoxe n'a fourni d'explication à ce genre de faits révélés par la défense jusque devant le tribunal de Nuremberg).

16\) En janvier 1995, l'historien français Eric Conan, co-auteur avec Henry Rousso de *Vichy, un passé qui ne passe pas* (Paris, Gallimard, 2001 [1994, 1996]), a écrit que j'avais finalement eu raison de certifier, à la fin des années 1970, que la chambre à gaz visitée à Auschwitz par des millions de touristes était entièrement fausse. Selon E. Conan, s'exprimant dans un grand hebdomadaire français : « Tout y est faux […]. A la fin des années 70, Robert Faurisson exploita d'autant mieux ces falsifications que les responsables du musée rechignaient alors à les reconnaître ». E. Conan poursuit : « [Des personnes], comme Théo Klein, [préfèrent qu'on laisse la chambre à gaz] en l'état mais en expliquant au public le travestissement : "l'Histoire est ce qu'elle est ; il suffit de la dire, même lorsqu'elle n'est pas simple, plutôt que de rajouter l'artifice à l'artifice" ». E. Conan rapporte ensuite un propos stupéfiant de la sous-directrice du Musée national d'Auschwitz, qui, elle, ne se résout pas à expliquer au public le travestissement. Il écrit : « Krystyna Oleksy […] ne s'y résout pas : "Pour l'instant, on la laisse en l'état [cette pièce qualifiée de chambre à gaz] et on ne précise rien au visiteur. C'est trop compliqué. On verra plus tard" » (Eric Conan, « Auschwitz : la mémoire du mal», L'Express, 19-25 janvier 1995, p. 68).

Remarque : Ce propos d'une responsable polonaise signifie en clair : on a menti, on ment et, jusqu'à nouvel ordre, on continuera de mentir. En 2005, j'ai demandé à E. Conan si les autorités du Musée d'Auschwitz avaient publié un démenti ou élevé une protestation contre le propos qu'il avait, en 1995, prêté à K. Oleksy. Sa réponse a été qu'il n'y avait eu ni démenti, ni protestation. En 1996, cette imposture-ci et d'autres concernant aussi le camp d'Auschwitz-I ont été dénoncées par deux auteurs juifs, Robert Jan van Pelt et Deborah Dwork, dans un ouvrage écrit en commun : *Auschwitz, 1270 to the Present,* Yale University Press, 443 p. Voici un échantillon des mots qui leur viennent sous la plume : « postwar obfuscation », « additions », « deletions », « suppression », « reconstruction », « largely a postwar reconstruction » (p. 363), « reconstructed », « usurpation », « re-created », « four hatched openings in the roof, as if for pouring Zyklon B into the gas chamber below, were installed [after the war] » (p.364), « falsified », « inexact », « misinformation », « inappropriate » (p. 367), « falsifying » (p. 369). En 2001, le caractère fallacieux de cette chambre à gaz Potemkine a été aussi reconnu dans un livret accompagnant deux CD-Rom et intitulé : *Le Négationnisme.* Rédigé par Jean-Marc Turine et Valérie Igounet, ce livret est préfacé par Simone Veil (Radio-France ― INA, Vincennes, Frémeaux et Associés).

17\) En 1996, Jacques Baynac, historien français, de gauche et résolument antirévisionniste dès 1978, a fini par admettre, toute réflexion faite, qu'il n'y avait pas de preuves de l'existence des chambres à gaz nazies. On ne peut, écrit-il, que constater « l'absence de documents, de traces ou d'autres preuves matérielles » (*Le Nouveau Quotidien de Lausanne,* 2 septembre 1996, p. 16, et 3 septembre 1996, p. 14). Mais il dit qu'il persiste à croire en l'existence de ces magiques chambres à gaz.

Remarque : En somme, J. Baynac dit : « Il n'y a pas de preuves mais je crois », tandis qu'un révisionniste pense : « Il n'y a pas de preuves, donc je refuse de croire et mon devoir est de contester ».

18\) En 2000, à la fin de son *Histoire du négationnisme en France* (Paris, Seuil), Valérie Igounet a publié un long texte à la fin duquel Jean-Claude Pressac, qui avait été l'un des adversaires les plus déterminés des révisionnistes, signe un véritable acte de capitulation. En effet, reprenant le mot du professeur Michel de Boüard, il déclare que le dossier du système concentrationnaire est « pourri », et ce de façon irrémédiable. Il écrit : « Peut-on redresser la barre ? » et il répond : « Il est trop tard ». Il ajoute : «La forme actuelle, pourtant triomphante, de la présentation de l'univers des camps est condamnée ». Il termine en estimant que tout ce qu'on a ainsi inventé autour de trop réelles souffrances est promis « aux poubelles de l'histoire » (p. 651-652). En 1993-1994, ce protégé du juif français Serge Klarsfeld et du rabbin américain Michael Berenbaum, directeur scientifique du Musée de l'Holocauste de Washington, avait été célébré dans le monde entier comme un extraordinaire chercheur qui, dans son livre sur Les Crématoires d'Auschwitz, la machinerie du meurtre de masse (Paris, CNRS éditions, 1993), avait, paraît-il, terrassé l'hydre du révisionnisme. Ici, dans le livre de V. Igounet, on le voit signer sa capitulation.

Remarque : Le grand public est tenu dans l'ignorance d'un fait capital : l'homme providentiel que la presse du monde entier avait présenté comme un extraordinaire chercheur qui avait enfin découvert la preuve scientifique de l'existence des chambres à gaz nazies, cet homme-là a fini par reconnaître son erreur. Quelques années plus tard, pas un organe de presse n'a signalé sa mort.

19\) En 2002, R.J. van Pelt, déjà nommé, a publié The Case for Auschwitz. Evidence from the Irving Trial, Indiana University Press, XVIII-571 p. On sait que David Irving, qui est tout au plus un semi-révisionniste et qui connaît mal l'argumentation révisionniste, a perdu le procès en diffamation qu'il avait eu l'imprudence d'intenter à l'universitaire juive américaine Deborah Lipstadt. Il a maladroitement essayé de soutenir la thèse ― parfaitement juste au demeurant ― selon laquelle il n'a pas existé de chambres à gaz homicides à Auschwitz. Mais il a tout de même marqué un point essentiel et, si le juge Charles Gray, puis d'autres juges après ce dernier avaient eu plus de courage, ce point aurait dû lui permettre de gagner sa cause. L'argument se résumait en une formule de quatre mots que j'avais lancée en 1994 : «No holes, no Holocaust». Mon raisonnement avait été le suivant : 1. Auschwitz est au centre de l' «Holocauste» ; 2. Les grands crématoires d'Auschwitz-Birkenau, ou Auschwitz-II, sont au centre du vaste complexe d'Auschwitz ; 3. Au cœur de ces crématoires se trouvaient, paraît-il, une ou plusieurs chambres à gaz homicides ; 4. Aujourd'hui un seul de ces crématoires (le crématoire n° 2), bien qu'il soit en ruines, permet d'aller examiner la pièce censée avoir été une chambre à gaz homicide ; c'est le lieu présumé d'un crime lui-même présumé ; 5. On nous affirme que, pour tuer les détenus juifs entassés dans la pièce, un SS, se déplaçant sur le toit en béton de ladite chambre à gaz, déversait des granulés de Zyklon B par quatre orifices réguliers situés dans le plafond ; 6. Or il suffit de ses yeux pour se rendre compte que de tels orifices n'ont jamais existé; 7. Donc le crime n'a pu être commis. R. J. van Pelt, témoignant contre D. Irving, a été à la torture pour essayer de trouver une parade à cet argument. En fin de compte, ni lui, ni ses collaborateurs n'y sont parvenus. Le juge Gray a dû, lui aussi, reconnaître « l'apparent absence de preuves d'orifices » (the apparent absence of evidence of holes, compte rendu verbatim, p. 490) et, d'une manière plus générale, il a concédé que « les documents contemporains livrent peu d'éléments de preuve clairs de l'existence de chambres à gaz conçues pour tuer des êtres humains » (contemporaneous documents yield little clear evidence of the existence of gas chambers designed to kill humans, p. 489) ; pour plus de détails, on se reportera aux pages 458-460, 466-467, 475-478 et 490-506). Dans le texte même de son jugement, Charles Gray reconnaît sa surprise : « Je dois admettre que, comme, j'imagine, la plupart des gens, j'avais supposé que les éléments de preuve d'une extermination massive de juifs dans les chambres à gaz d'Auschwitz était irrésistibles. Néanmoins, j'ai écarté cette idée préconçue au moment d'évaluer les éléments de preuve fournis par les parties » (I have to confess that, in common I suspect with most other people, I had supposed that the evidence of mass extermination of Jews in the gas chambers at Auschwitz was compelling. I have, however, set aside this preconception when assessing the evidence adduced by the parties in these proceedings, 13.71). L'échec des historiens-accusateurs est ici flagrant et D. Irving aurait dû gagner son procès grâce à cette constatation d'un juge qui lui était hostile : les documents d'époque ne nous livrent décidément que peu d'éléments de preuves, qui soient clairs, de l'existence des chambres à gaz nazies et donc d'une politique allemande d'extermination des juifs. N'est-ce pas, après tout, ce que concluaient déjà, comme nous l'avons vu plus haut, bien des historiens juifs, à commencer par Léon Poliakov en 1951 ?

20\) En 2004, un historien français, Florent Brayard, a publié un ouvrage intitulé : *La « solution finale de la question juive ». La technique, le temps et les catégories de la décision,* Paris, Fayard, 640 p. En 2005, dans un compte rendu de cet ouvrage, on a pu lire les trois phrases suivantes : « On sait que le Führer n'a ni rédigé, ni signé un ordre de suppression des juifs, que les décisions ― car il y en eut plusieurs ― ont été prises dans le secret d'entretiens avec Himmler, peut-être Heydrich et/ou Göring. On suppose que, plutôt qu'un ordre explicite, Hitler a donné son accord à des demandes ou projets de ses interlocuteurs. Peut-être ne l'a-t-il pas même formulé, mais s'est-il fait comprendre par un silence ou un acquiescement » (Yves Ternon, Revue d'histoire de la Shoah, juillet décembre 2005, p. 537).

Remarque : Presque à chaque mot, ces phrases montrent que leur auteur en est réduit à d'aventureuses spéculations. Quand il ose avancer sans le moindre indice que Hitler s'est peut-être fait comprendre « par un silence ou un acquiescement », il ne fait que reprendre la théorie du « nod » (signe de tête du Führer !) émise par le professeur Christopher Browning au procès Zündel de Toronto en 1988. Pas un universitaire de conviction antirévisionniste ne s'est montré plus pitoyable et plus niais que ce shabbat-goy. Tant il est vrai que, anéantie par les victoires révisionnistes, la thèse officielle a fini par se vider de tout contenu scientifique.

## Bilan de ces victoires révisionnistes

Récapitulons brièvement ces victoires révisionnistes.

Mis au pied du mur par les révisionnistes, les historiens officiels de la prétendue extermination physique des juifs ont fini par reconnaître que, du point de vue historique et scientifique, il ne leur reste plus aucun argument pour soutenir leur atroce accusation. Ils reconnaissent en effet : 1) qu'ils ne peuvent invoquer aucun document prouvant le crime ; 2) qu'ils sont incapables de fournir la moindre représentation de l'arme du crime ; 3) qu'ils ne possèdent pas de preuves ni même des éléments de preuves ; 4) qu'ils ne peuvent nommer aucun témoin véridique (voy., ci-dessus, l'opinion de S. Veil) ; 5) que leur dossier est pourri (bis), irrémédiablement pourri et qu'il est destiné aux poubelles de l'histoire ; 6) que les sources autrefois invoquées se sont révélées non seulement bien plus rares qu'on ne le prétendait mais aussi douteuses ; 7) que les prétendues traces sont peu nombreuses, éparses, difficiles d'interprétation ; 8) qu'il y avait eu de leur part falsifications, travestissement, artifice ; 9) qu'à l'appui de la thèse officielle on a trop souvent invoqué une « histoire sotte » (sic), celle d'une décision d'exterminer les juifs qui aurait été prise le 20 janvier 1942 à Berlin-Wannsee ; 10) que le premier d'entre eux, Raul Hilberg, en est aujourd'hui réduit à tout expliquer, de manière farfelue, par de supposées initiatives que la bureaucratie allemande aurait, d'après lui, hardiment prises sans ordre, sans plan, sans instruction, sans contrôle et simplement grâce, paraît-il, à une incroyable rencontre des esprits et à une transmission de pensée consensuelle. Ces historiens officiels n'ont su répondre à aucune demande ou constatation des révisionnistes du genre de : 1) « Show me or draw me a Nazi gas chamber » ; 2) « Bring me one proof, one single piece of evidence of your own choosing, on the grounds of which to assert that there was a genocide » ; 3) « Bring me one testimony, one single testimony, the best one in your opinion » ou encore 4) « No holes, no Holocaust ». Acculés dans les cordes du ring, les historiens de cour ont fait appel aux tribunaux pour condamner les révisionnistes, mais, contre toute attente, il est arrivé que les juges sont parfois allés jusqu'à rendre hommage à la probité des révisionnistes ou bien ont manifesté leur surprise devant la rareté ou l'absence des preuves documentaires chez les accusateurs. Alors, d'abord en France, puis en bien d'autres pays d'Europe, ces accusateurs en ont appelé au vote de lois spéciales pour faire taire les révisionnistes. Là ils ont signé leur perte. Recourir à des lois spéciales, à la police et à la prison, c'est avouer son impuissance à utiliser les arguments de la raison, de l'histoire et de la science.

Cent autres arguments encore pourraient être ici rappelés qui prouvent que, sur le plan de l'histoire et de la science, il ne reste plus pierre sur pierre de l'immense édifice de mensonges dressé par les sectateurs de l'« Holocauste » ou de la «Shoah». En contraste avec ce champ de ruines l'on a vu se construire l'édifice de toute une littérature révisionniste. On y découvre à profusion documents, photographies, expertises, transcriptions de procès, rapports techniques et scientifiques, témoignages, études statistiques, le tout portant sur cent aspects de l'histoire de la Deuxième guerre mondiale qui montrent ce qu'a été en réalité le sort des juifs européens et qui démontrent de manière éclatante que la version juive de cette guerre est largement de l'ordre du mythe. Du mythe, les juifs sont allés à la mythologie et de la mythologie à la religion ou, plutôt, à un semblant de religion. Aujourd'hui, les servants de cette fausse religion ressemblent de plus en plus à des prêtres qui continuent d'officier et qui ressassent les formules consacrées mais, manifestement, sans plus avoir la foi. Ils ne croient plus vraiment à leur « credo ». C'est ainsi, par exemple, que, depuis une dizaine d'années, on les voit conseiller à leurs ouailles d'observer la plus grande discrétion possible sur le sujet des chambres à gaz. Dans ses mémoires le grand faux témoin Elie Wiesel a écrit en 1994 : « Les chambres à gaz, il vaut mieux qu'elles restent fermées au regard indiscret. Et à l'imagination » (Tous les fleuves vont à la mer …, Paris, Le Seuil, 1994, p. 97). Comme lui, Claude Lanzmann (auteur du film Shoah), Daniel Goldhagen (auteur de Hitler's Willing Executioners), Simone Veil (ancienne présidente du Parlement européen, citée plus haut), François Léotard (ancien ministre) deviennent depuis quelques années étonnamment réservés, prudents ou silencieux sur le sujet. Il y a quelques mois, Jacques Attali (homme d'affaires juif et historien) vient de décréter : « L'immense majorité des juifs assassinés l'ont été par les armes individuelles des soldats et des gendarmes allemands, entre 1940 et 1942, et non par les usines de mort, mises en place ensuite » (« Groupes de criminels ? », L'Express, 1^er^ juin 2006, p. 60). Cette manière implicite de passer par pertes et profits les prétendues chambres à gaz nazies devient courante. On essaie de remplacer le mensonge d'Auschwitz par le mensonge de Babi Yar ou d'autres fantastiques massacres en Ukraine ou dans les Pays baltes mais, pas une fois, on ne nous fournit à leur propos des preuves scientifiques telles que des rapports d'exhumation et d'autopsie comme cela a été le cas pour de réels massacres perpétrés, eux, par les Soviétiques à Katyn, à Vinnitsa ou ailleurs. Quant au nombre des morts d'Auschwitz, on ne nous dit plus guère qu'il a été de 9 000 000 (comme dans Nuit et Brouillard), de 8 000 000, de 6 000 000 ou de 4 000 000 (comme au Procès de Nuremberg ou sur les stèles d'Auschwitz-Birkenau jusqu'en 1990). On se contente de 1 500 000 (comme sur ces mêmes stèles depuis 1995), ou de 1 100 000, ou de 700 000 (comme l'écrivait J.-C. Pressac), ou encore de 510 000 (comme a conclu Fritjof Meyer en 2002 : « Die Zahl der Opfer von Auschwitz», Osteuropa, mai 2003, p. 631-641), tous ces derniers chiffres n'étant pas plus fondés que les précédents.

## Conclusion générale

Le privilège nous est donné d'assister, en ce début du XXI^e^ siècle, à une sérieuse remise en cause de l'un des plus grands mensonges de l'histoire. Le mythe de l'« Holocauste » a beau briller de mille feux, en réalité il se consume. Il a servi à justifier la création en terre de Palestine d'une colonie guerrière qui a pris le nom d'« État juif » et qui s'est dotée d'une « Armée juive ». Il impose au monde occidental le joug d'une tyrannie juive ou sioniste qui s'exerce dans tous les domaines de la vie intellectuelle, universitaire et médiatique. Il empoisonne jusqu'à l'âme d'un grand pays, l'Allemagne. Il a permis d'extorquer à cette dernière ainsi qu'à bien d'autres pays du monde occidental des sommes exorbitantes en marks, en dollars ou en euros. Il nous accable de films, de musées, de livres qui entretiennent le feu d'une haine au caractère talmudique. Il permet d'en appeler à la croisade armée contre « l'axe du mal » et, pour cela, de fabriquer, à la demande, les plus éhontés mensonges sur le modèle précisément du Grand Mensonge de l'« Holocauste » car il n'y a aucune différence entre les « armes de destruction massive » d'Adolf Hitler et celles de Saddam Hussein. Il permet d'accuser quasiment le monde entier et d'exiger partout « repentance » et « réparations » à cause, soit de prétendues actions dirigées contre « le peuple élu de Yahweh », soit d'une prétendue complicité dans le crime, soit d'une prétendue indifférence générale au sort des juifs durant la Deuxième Guerre mondiale. Il a à son actif des flots de procès truqués, à commencer par l'infâme procès de Nuremberg. Il a autorisé des milliers de pendaisons de soldats vaincus, une atroce Epuration, la déportation de millions de civils chassés de la terre de leurs ancêtres, des pillages sans nom, des dizaines de milliers de scandaleuses procédures judiciaires, y compris aujourd'hui des poursuites visant des octogénaires ou des nonagénaires contre lesquels viennent rendre faux témoignage des « miraculés » juifs. Ces abominations, cette démesure dans le mensonge et la haine, cette « hybris » qu'un jour ou l'autre le destin vient toujours à punir, bref, tous ces excès doivent prendre fin. Pas un peuple ne s'est montré plus patient avec cette « hybris » juive ou sioniste que le peuple arabe ; or voici que ce peuple lui-même est à bout de patience. Il va se débarrasser du joug israélien et faire comprendre à l'Occident que le temps est venu de rechercher une véritable paix au lieu de soutenir par les armes un État artificiel qui ne se maintient que par la force. Même en Occident, même aux États-Unis, les yeux se dessillent chez certains et l'on prend conscience des risques qu'on fait courir à la communauté internationale par une soumission aussi prolongée à la fausse religion de l'« Holocauste », arme n° 1, épée et bouclier de l'État d'Israël.

## Conclusion pratique

Il existe des moyens pratiques d'entamer une véritable action contre cette fausse religion dont le sanctuaire se situe à Auschwitz.

Comme on le sait, au cœur d'Auschwitz se trouve une chambre à gaz emblématique. Jusqu'ici environ trente millions de touristes l'ont visitée. Il s'agit d'une imposture ; tous les historiens en ont conscience et les autorités du Musée d'État d'Auschwitz le savent mieux que personne. Or l'UNESCO (Organisation des Nations Unies pour l'éducation, la science et la culture), sur la demande du Gouvernement polonais a, le 26 octobre 1979, inscrit ce camp dans la liste des sites ou biens culturels (Cultural Property) du Patrimoine mondial, et cela à charge, pour l'UNESCO, d'en préserver l'authenticité. Pour ma part, je suggère donc que l'UNESCO soit saisie de ce cas de supercherie, qui constitue une atteinte à l'éducation, à la science et à la culture. D'une façon plus générale, nous pourrions reprendre le mot prononcé en 1979 par Jean-Gabriel Cohn Bendit : « Battons-nous donc pour qu'on détruise ces chambres à gaz qu'on montre aux touristes dans les camps où l'on sait maintenant qu'il n'y en eut point » (*Libération,* 5 mars 1979, p. 4).

Il existe d'autres moyens pratiques de lutter contre la tyrannie du mythe de l'« Holocauste », à commencer par l'annonce au monde entier de ces « victoires révisionnistes » qu'on lui a jusqu'ici cachées. Je fais confiance aux révisionnistes présents dans cette assemblée pour nous suggérer d'autres moyens et pour en discuter.

Pratiquant le mensonge à grande échelle, les religionnaires de l' « Holocauste » se sont faits peu à peu les ennemis du genre humain. Depuis plus de soixante ans, ils mettent progressivement en accusation le monde entier ou peu s'en faut. Leur principale cible a, bien sûr, été l'Allemagne et tous ceux qui, aux côtés de ce pays, ont cru devoir lutter contre Staline de la même façon que d'autres, dans le camp adverse, pensaient devoir lutter contre Hitler. Mais, dans leur frénésie accusatrice, les organisations juives sont allées jusqu'à blâmer les Alliés pour leur prétendue « indifférence » criminelle au sort des juifs européens. Elles s'en sont prises à Roosevelt, à Churchill, à de Gaulle, au Pape Pie XII, au Comité international de la Croix-Rouge ainsi qu'à bien d'autres personnalités, instances ou pays pour n'avoir pas dénoncé l'existence des « chambres à gaz ». Mais comment aurait-on pu tenir pour vérifié ce qui n'était si évidemment qu'une grotesque rumeur de guerre ? Il suffit de lire l'ouvrage du juif Walter Laqueur, The Terrible Secret (Londres, Weidenfeld & Nicolson, 1980, 262 p.), pour y relever une trentaine de références au scepticisme, parfaitement justifié, du camp allié devant le flot des rumeurs provenant de sources juives. Des enquêtes avaient été menées, qui avaient permis de conclure que ces rumeurs étaient infondées. C'est donc de clairvoyance et non d'indifférence que les Alliés et les autres accusés ont fait preuve. C'est de cette même clairvoyance qu'après la guerre, dans leurs discours ou dans leurs mémoires, Churchill, de Gaulle et Eisenhower ont témoigné en se gardant de mentionner, ne fût-ce qu'une seule fois, lesdites « chambres à gaz ».

La guerre et la propagande de guerre ont besoin du mensonge tout comme les croisades et l'esprit de croisade se nourrissent de haine. A l'opposé, la paix et l'amitié entre les peuples ne peuvent que gagner au souci de l'exactitude en matière de recherche historique, une recherche qui doit pouvoir s'exercer en toute liberté.

## Deux pièces jointes portant sur la prétendue chambre à gaz d'Auschwitz-I

1\) Intégralité de ce qu'en a dit Eric Conan, en 1995

Autre sujet délicat : que faire des falsifications léguées par la gestion communiste ? Dans les années 50 et 60, plusieurs bâtiments, qui avaient disparu ou changé d'affectation, furent reconstruits avec de grosses erreurs, et présentés comme authentiques. Certains, trop « neufs », ont été fermés au public. Sans parler de chambres à gaz d'épouillage, présentées parfois comme des chambres à gaz homicides. Ces aberrations ont beaucoup servi aux négationnistes, qui en ont tiré l'essentiel de leurs affabulations. L'exemple du crématoire I, le seul d'Auschwitz I, est significatif. Dans sa morgue fut installée la première chambre à gaz. Elle fonctionna peu de temps, au début de 1942 : l'isolement de la zone, qu'impliquaient les gazages, perturbait l'activité du camp. Il fut donc décidé, à la fin d'avril 1942, de transférer ces gazages mortels à Birkenau où ils furent pratiqués, sur des victimes essentiellement juives, à une échelle industrielle. Le crématoire I fut, par la suite, transformé en abri antiaérien, avec salle d'opération. En 1948, lors de la création du musée, le crématoire I fut reconstitué dans un état d'origine supposé. Tout y est faux : les dimensions de la chambre à gaz, l'emplacement des portes, les ouvertures pour le versement du Zyklon B, les fours, rebâtis selon les souvenirs de quelques survivants, la hauteur de la cheminée. A la fin des années 70, Robert Faurisson exploita d'autant mieux ces falsifications que les responsables du musée rechignaient alors à les reconnaître. Un négationniste américain vient de tourner un film vidéo dans la chambre à gaz (toujours présentée comme authentique) : on l'y voit interpeller les visiteurs avec ses « révélations ». Jean-Claude Pressac, l'un des premiers à établir exactement l'histoire de cette chambre à gaz et de ses modifications pendant et après la guerre, propose de la restaurer dans son état de 1942, en se fondant sur des plans allemands qu'il vient de retrouver dans les archives soviétiques. D'autres, comme Théo Klein, préfèrent la laisser en l'état, mais en expliquant au public le travestissement : « l'Histoire est ce qu'elle est ; il suffit de la dire, même lorsqu'elle n'est pas simple, plutôt que de rajouter l'artifice à l'artifice. » Krystyna Oleksy, dont le bureau directorial, qui occupe l'ancien hôpital des SS, donne directement sur le crématoire I, ne s'y résout pas : « Pour l'instant on la laisse en l'état et on ne précise rien au visiteur. C'est trop compliqué. On verra plus tard. » (Eric Conan, « Auschwitz : la mémoire du mal », L'Express, 19-25 janvier 1995, pages 54-69 ; p. 68).

Dans sa longue étude, E. Conan a voulu montrer combien il y a loin de « la mémoire » à l'histoire. Il l'a fait sans remettre en cause le dogme de « l'Holocauste » ; il est même allé jusqu'à dire sa croyance en l'existence de l'arme de destruction massive appelée « chambre à gaz » et il a posé comme exactes et démontrées des assertions qui n'ont pas le moindre fondement scientifique. Néanmoins il a eu le courage de dénoncer de graves mensonges dont celui de la « chambre à gaz » emblématique qu'on présente aujourd'hui aux visiteurs d'Auschwitz. Et il ose admettre que, dès la fin des années 1970, j'ai eu raison sur le sujet. En 2005, je lui ai demandé si son étude avait suscité des rectifications ou des protestations, en particulier de la part des autorités du Musée national d'Auschwitz et de Krystyna Oleksy. Sa réponse a été : « Aucune ».

2\) Intégralité de ce qui en est dit dans un livret de CD-Rom préfacé par Simone Veil

La motivation [Robert Faurisson] l'a : l'amour exclusif de la vérité, telle serait l'une de ses obsessions. Universitaire, Robert Faurisson ne cessera d'utiliser cette caution scientifique, gage soi-disant de respectabilité. Il lit Maurice Bardèche. Il découvre Paul Rassinier. Il « décortique » Rimbaud, Lautréamont et Apollinaire. Homme brillant et cultivé, il n'en est pas moins un provocateur. Pendant les années soixante-dix, Robert Faurisson travaille. Il ébauche sa méthode historico-littéraire. Il se rend aux archives d'Auschwitz. Sa négation va s'y construire. Elle repose sur un fait réel : la chambre à gaz du camp d'Auschwitz I est une « reconstitution », puisqu'elle a servi d'entrepôt pour les médicaments des S.S. et d'abri antiaérien après la mise en service des chambres à gaz d'Auschwitz II-Birkenau ; ce qu'il a pu voir (et ce que l'on peut encore voir) est une chambre à gaz supposée. C'est indéniable. Il n'empêche que pour Robert Faurisson, il s'agit d'une supercherie dont les Juifs sont les auteurs [Le Négationnisme (1948-2000). Entretiens diffusés sur France Culture sous la direction de Jean-Marc Turine. Livret par Valérie Igounet et Jean-Marc Turine préfacé par Simone Veil, Vincennes, Frémeaux et associés, 2001, 48 pages ; p. 27-28].

Ci-après, deux dessins de « Chard »

[]

1^er^ novembre 2006 : ce dessin de « Chard » (Françoise Pichard, de Paris) reçoit le second prix du concours international des caricatures de « l'Holocauste » organisé par l'Iran.

[]

Le professeur Bruno Gollnisch avait simplement déclaré que, sur le sujet des chambres à gaz, les historiens devaient pouvoir se prononcer librement. Il a d'abord été suspendu d'enseignement pour cinq ans par l'Université Lyon-III. Puis, les 7 et 8 novembre 2006, il a dû comparaître devant le tribunal de Lyon, constitué du juge Fernand Schir et de ses deux assesseurs. Pressions et chantage l'ont conduit à s'effondrer et à reconnaître devant ses juges l'existence du génocide des juifs et des chambres à gaz nazies. Le jugement sera rendu le 18 janvier 2007. Il faut savoir qu'en France, la loi interdit la contestation de l'existence des crimes nazis contre les juifs « même si [cette contestation] est présentée sous une forme déguisée ou dubitative ou par voie d'insinuation » (Code pénal, 2006, p. 2059). Par conséquent, en la matière, il ne faut ni contester ni même paraître contester.

Téhéran, 11 décembre 2006

Labels: Arno Mayer, Auschwitz-I, Baynac, chambres à gaz, Conan, Fritjof Meyer, Georges Wellers, Hilberg, Michel de Boüard, Pressac, Simone Veil, van Pelt, Vidal-Naquet, Wannsee
