<!-- http://robertfaurisson.blogspot.com/2011/09/les-victoires-du-revisionnisme-suite.html -->

<!-- Sunday, September 11, 2011 -->

# Les victoires du révisionnisme (suite)

Le 11 décembre 2006 je signais une étude d'une vingtaine de pages intitulée « Les victoires du révisionnisme ». J'y faisais état, à titre d'exemples, de vingt victoires remportées par les révisionnistes sur le strict plan historique et scientifique, tandis que, sur le plan médiatique et le plan judiciaire, la partie adverse continuait d'occuper presque tout le terrain. Les religionnaires de « l'Holocauste » occultaient leurs défaites et continuaient à leurrer le grand public comme ils le faisaient depuis 1945. Mais voici que, soudain, le développement accéléré d'Internet et l'évolution de la situation internationale, si fâcheuse pour l'État d'Israël et pour les États-Unis, ont peu à peu changé la donne. Les victoires du révisionnisme ont commencé à faire parler d'elles. En particulier, les sites, les forums et les blogs se sont multipliés où l'on a pu apprendre d'abord les concessions faites aux révisionnistes par des historiens de « l'Holocauste », puis les véritables capitulations auxquelles certains d'entre ces historiens ont été contraints. Pour commencer, dès 1979, un groupe de 34 universitaires français avait signé une déclaration commune qui en disait long sur leur incapacité à décrire le fonctionnement de « la magique chambre à gaz » (Céline) ; piteusement ils avaient déclaré : « Il ne faut pas se demander comment, techniquement, un tel meurtre de masse a été possible. Il a été possible techniquement puisqu'il a eu lieu » (Le Monde, 21 février 1979, p. 23). En 1985 Raul Hilberg, le plus éminent historien de « l'Holocauste », finissait par reconnaître qu'on ne possédait au fond aucune preuve de la réalité d'un ordre, d'un plan, d'une organisation quelconque visant à la destruction physique des juifs d'Europe et, pour continuer tout de même à soutenir la fiction, il décidait de recourir à de stupéfiantes explications relevant de ce qu'on pourrait appeler « la parapsychologie de groupe » (voyez ci-dessous). En 1995 Jean-Claude Pressac, l'homme lige de Serge Klarsfeld, rendait définitivement les armes et signait un acte de capitulation (voy. ci-dessous). Dans les années qui ont suivi on a pu constater chez les historiens de « l'Holocauste » une sorte de désertion ou de déroute généralisées : feignant d'ignorer ce qu'en 1968, dans sa thèse principale, l'historienne juive Olga Wormser-Migot était elle-même contrainte d'appeler « le problème des chambres à gaz » et passant sous silence bien d'autres « problèmes » historiques du même genre, ils se contentaient de répéter les affirmations purement gratuites des juges de Nuremberg et, pour la plupart d'entre eux, ne se hasardaient plus à chercher des preuves historiques et scientifiques de leur « Holocauste ». Mais, au début de l'année 2007, un seul chercheur juif restait en piste, celui que, pour ma part, j'appelais « le dernier des Mohicans juifs » ; je désignais par là Robert Jan van Pelt. Or, une fois de plus, l'affaire allait se conclure par une sorte de capitulation. Comme on le verra ci-dessous, le 27 décembre 2009 notre homme concluait ses longues recherches par le constat suivant : pour ce qui est d'Auschwitz, à peu près tout de ce que « nous savons » sur ce camp (capitale de « l'Holocauste », visitée par des millions de croyants) ne trouve tout simplement pas sa preuve… à Auschwitz ; il en concluait que mieux valait ne plus dépenser tant d'argent pour préserver un tel lieu ; la nature devrait y reprendre ses droits ! On comprend l'embarras de ce chercheur : il aimerait voir disparaître les pures fabrications pour touristes comme celle du crématoire d'Auschwitz I : « Tout y est faux », avait fini par constater en 1995 l'historien Eric Conan (L'Express, 19-25 janvier 1995, p. 68 ainsi que le point 16 du texte à http://robertfaurisson.blogspot.com/2006/12/les-victoires-du-revisionnisme.html ; voy. également, en anglais, l'article de Mark Weber http://www.ihr.org/jhr/v15/v15n1p23_Weber.html).

De 1979 à 2009, soit pendant trente années, les tenants de la thèse autorisée ont ainsi échoué dans leurs tentatives de répondre aux révisionnistes sur le plan de l'histoire, de la science, de la recherche matérielle et de l'étude attentive des documents et des témoignages. Pour compenser cet échec les adorateurs de « l'Holocauste » ont cherché refuge dans les ressources de l'imagination ou de la croyance ; d'où une prolifération de romans, de « témoignages » notoirement faux, de pièces de théâtre, de films, de cérémonies, de pèlerinages. Et c'est ainsi que le « Shoa Business » et la « Religion de l'Holocauste » ont inondé le monde de leurs produits et de leurs fantasmagories.

Pour leur part, se sentant désormais le vent en poupe, les révisionnistes persisteront dans la voie où ils se sont engagés dès la fin des années 1940 avec, en particulier, Maurice Bardèche et Paul Rassinier. Des auteurs révisionnistes ou des activistes du révisionnisme sont apparus en bien des pays du monde, surtout en Europe et aux États-Unis. Le plus remarquable de ces auteurs est sans conteste l'Américain Arthur Robert Butz ; afin de ne pas compromettre sa sécurité personnelle, j'éviterai de nommer ici le plus extraordinaire des activistes. J'ai présents à l'esprit bien d'autres noms d'auteurs en particulier d'origine allemande, autrichienne, belge, espagnole, française, italienne, suisse, canadienne, australienne ou sud-américaine. La liste est relativement importante des Nord-Américains qui ont participé dans le passé ou qui, tel Bradley Smith et ses amis, participent aujourd'hui au combat révisionniste.

Une image hante nos contemporains, celle des monceaux de cadavres découverts à la libération des camps de concentration allemands en 1945. Dans cette image obsédante ils croient voir la preuve de l'inhumanité des « Nazis » et, par conséquent, d'instinct ils s'imaginent que les révisionnistes sont essentiellement des individus qui se donnent pour tâche de réhabiliter Adolf Hitler. Je souhaiterais que ces profanes qui, d'emblée, ferment ainsi leur cœur et leur esprit au révisionnisme et se laissent porter par l'émotion se mettent à réfléchir sur le sens réel de ces photographies et de ces films, dans lesquels ils s'imaginent voir des preuves, qui les bouleversent, des « atrocités nazies ».

## Les photographies et les films montrant des cadavres

Dans ma jeunesse j'avais été moi-même choqué par le spectacle des morts ou des cadavres ambulants du camp de Bergen-Belsen. On voyait un bulldozer pousser vers le bord de grandes fosses des cadavres de détenus que des femmes SS jetaient ensuite dans ces fosses. On nous montrait un médecin SS, le Dr Fritz Klein, campant, les jambes écartées, au plein milieu d'une fosse et prenant apparemment une posture avantageuse, tandis que Franz Hössler, encore un SS, semblait, devant un camion chargé de cadavres, tenir un discours d'autosatisfaction. Bien des années plus tard j'allais comprendre que j'avais été la victime des artifices d'un film de propagande.

Au cours des derniers mois d'une guerre atroce, dans le chaos où avait été réduite l'Allemagne, le camp de Bergen-Belsen, submergé de détenus provenant de l'Est, avait été ravagé par une épidémie de typhus. Dans les jours suivant la libération de ce camp, le 15 avril 1945, alors que les Britanniques étaient devenus les maîtres des lieux, des milliers de personnes (près de 14 000 ?) allaient encore mourir, notamment du typhus. Dans ce qui restait de leurs villes les civils allemands étaient devenus des troglodytes qui, terrés dans des trous de fortune, étaient en proie à la faim et au froid. A Bergen-Belsen il n'y avait pour ainsi dire plus de ravitaillement, plus de médicaments, plus de moyens de désinfection. C'est dans cette situation désastreuse que le SS Josef Kramer, commandant du camp, décidait alors d'envoyer une délégation avec drapeau blanc vers les troupes du Field Marshal britannique Montgomery afin de les prévenir qu'elles approchaient d'un vaste foyer d'infection : il fallait éviter que les détenus, une fois libérés, aillent propager le typhus dans les rangs des soldats alliés et dans la population allemande. Un accord de coopération était conclu entre, d'une part, la Wehrmacht (à l'exclusion des SS) et, d'autre part, les responsables de l'armée britannique. Ces derniers, arrivés sur place, décidaient d'ouvrir les charniers, de compter les morts, puis, après le comptage, d'enterrer ces morts dans de nouvelles fosses. Effectivement un bulldozer poussait les cadavres sur le bord de ces fosses mais le conducteur en était un Tommy, qu'à l'instar de foules d'autres spectateurs j'avais autrefois pris pour un soldat allemand. Encore en 1978, sans doute pour mieux entretenir la méprise, une photographie allait être publiée qui « décapitait » le chauffeur de ce bulldozer (Arthur Suzman & Denis Diamond, Six Million Did Die: The Truth Shall Prevail, Johannesburg, South African Jewish Board of Deputies, Second Edition, 1978, p. 19). Sur les bords des fosses c'est sous la contrainte que les femmes SS, à mains nues, avaient jeté les cadavres. Quant au Dr F. Klein et à F. Hössler, ils avaient été obligés de jouer un rôle de composition apparemment pour illustrer la fierté qu'aurait inspirée aux SS leur supposée œuvre de mort. Pour briser son « arrogance », des soldats de « la Royale Artillerie britannique » rouaient de coups J. Kramer, puis l'enfermaient toute une nuit dans une chambre frigorifique (Dr G.-L. Fréjafon, Bergen-Belsen Bagne Sanatorium, Paris, Librairie Valois, 1947, p. 22). Bien d'autres camps ont offert le spectacle de tant de cadavres et on imagine sans peine l'écœurement des libérateurs saisis par l'odeur de ces victimes du typhus ou de la dysenterie et qui, vu leur nombre, n'avaient pu être enterrées.

Pour prendre un autre exemple de tromperie par la photographie, tout le monde, sur le moment, a pu être révolté par la vue des cadavres soigneusement alignés au camp de Nordhausen ; cependant des chercheurs devaient finir par montrer que ces morts étaient en réalité des victimes d'un bombardement allié qui visait principalement les bâtiments de la Bölke Kaserne. Au même moment, à Dachau, à Buchenwald et ailleurs des spectacles identiques accréditaient la légende selon laquelle ces camps, conçus et administrés comme des « camps de la mort », étaient dotés de « chambres à gaz » homicides aux rendements journaliers extravagants. Vérification faite, les historiens officiels finissaient par admettre, sous la poussée exercée par des auteurs révisionnistes et notamment par Paul Rassinier, l'auteur du Mensonge d'Ulysse, qu'en dépit de multiples « témoignages » de prêtres, de professeurs, de médecins, ces prétendus « gazages » de détenus n'avaient jamais eu lieu (Martin Broszat, de l'Institut für Zeitgeschichte de Munich, « Keine Vergasung in Dachau [Bergen-Belsen, Buchenwald, …] », Die Zeit, 19 août 1960, p. 16).

## Honte aux Allemands ? Ou aux Alliés ? Ou à la guerre ?

Le jour où Copernic a démontré que le soleil ne tournait pas autour de la terre mais qu'au contraire la terre tournait autour du soleil il s'est produit ce que, par la suite, on a pris l'habitude d'appeler une « révolution copernicienne ». L'expression signifie non pas seulement que la réalité peut différer de l'apparence ― ce qui se constate aisément ― mais aussi que la réalité peut se situer à l'exact opposé de l'apparence. C'est ce qui s'est produit après la guerre quand certains chercheurs se sont rendu compte que bien des horreurs d'abord imputées aux vaincus, c'est-à-dire, en Europe, principalement aux Allemands, étaient peut-être, en réalité, imputables aux Alliés. Du coup, devant toutes ces photographies qui faisaient s'exclamer : « Honte à l'Allemagne ! » il serait sans doute plus juste de dire : « Honte aux Alliés qui ont mis l'Allemagne dans cet état ! » ou encore de conclure : « Honte à la guerre et à son cortège d'abominations ! ». Pénétrant en Allemagne, les GI eux-mêmes avaient été surpris par l'étendue des dégâts qu'avaient provoqués les bombardements de leur propre aviation. Il faut savoir que Churchill et Roosevelt avaient innové quand, dotant leurs flottes aériennes des capacités adéquates, ils avaient entrepris contre les civils une guerre systématique, dont l'ampleur n'avait encore jamais existé dans l'histoire. Ils avaient décidé de raser les villes, grosses ou petites, et parfois même les villages. De leur point de vue il fallait, par le feu du ciel, par le bombardement intensif des villes et des villages, par le mitraillage en rase-motte soit des fugitifs cherchant à échapper aux fournaises, soit des paysans dans leurs champs, rendre la vie impossible à tous les Allemands sans exception. Maisons, hôpitaux, écoles, universités, hommes, femmes, enfants, vieillards, bestiaux, tout était appelé à disparaître. Les trains ne devaient plus pouvoir circuler : il leur faudrait plusieurs jours pour un trajet qui en temps normal aurait été de quelques heures : on imagine dans quel état arrivaient à destination les convois, par exemple, d'internés qui, de force ou par choix, avaient quitté les camps de l'Est devant l'arrivée des Soviétiques. A considérer la décision prise par Churchill et Roosevelt, il faut convenir qu'il était plus aisé de faire ainsi la guerre à des civils plutôt qu'à des militaires. Parfois, dans le camp des Alliés occidentaux, de hautes consciences, notamment ecclésiastiques, élevaient des protestations contre une telle sauvagerie, dont les bombardements de « Dresde » restent l'exemple emblématique. Mais la propagande, elle, faisait valoir l'obligation de détruire tout ce qui de près ou de loin représentait Satan ou, pour les propagandistes juifs, Amalek. A vrai dire, par la suite, au Japon, au Vietnam, en Irak et en quelques autres coins du monde, les Américains ont été conduits à mener ce même type de guerre dévastatrice.

## Les mascarades judiciaires des vainqueurs jugeant les vaincus

Personnellement, me situant, si j'ose dire, à l'extrême centre des opinions en matière de politique ou d'histoire, je ne saurais porter condamnation de ce qu'au cours d'une guerre tel belligérant, comme dans une sorte de compétition en la matière, ait cherché à inventer encore plus de moyens de tuer que l'adversaire. Je me contenterais de dire que, pour moi, toute guerre étant une boucherie, le vainqueur est un bon boucher et le vaincu un moins bon boucher ; en revanche, à la fin d'une guerre, le vainqueur peut à la rigueur administrer au vaincu des leçons de boucherie mais non pas des leçons de droit, de justice ou de vertu. C'est bien pourtant ce qui s'est passé au procès de Nuremberg (1945-1946) et lors de mille autres procès de même calibre, et cela jusqu'à nos jours où l'on voit des organisations juives exiger que des nonagénaires égrotants soient transportés en civière devant les tribunaux pour des crimes supposés remontant généralement à soixante-dix ans et pour lesquels il n'y a aucune preuve ni même quelquefois pas le moindre témoin. Simplement l'accusé s'était peut-être trouvé à la mauvaise place au mauvais moment ; par exemple, il aurait été à Treblinka, camp dans lequel, sans la moindre preuve, on ose affirmer que fonctionnaient, selon certains, des « chambres à vapeur » homicides [steam chambers] (document PS-3311), selon d'autres, des « chambres à gaz » homicides ; quant aux « témoignages » sur ce camp, comme sur bien d'autres, ils sont pour le moins vagues, contradictoires et on ne s'est jamais donné la peine de les vérifier, ce qui, comme l'ont prouvé certains chercheurs du type de l'Australien Richard Krege, était pourtant possible et donnait raison aux révisionnistes (« Treblinka Ground Radar Examination Finds No Trace of Mass Graves », in The Journal of Historical Review, mai-juin 2000 (Vol. 19, No. 3), p. 20 : http://www.ihr.org/jhr/v19/v19n3p20_radar.html).

A Nuremberg les vainqueurs ont jugé les vaincus ; ils étaient donc juge et partie ; ils avaient décidé d'avance qu'au besoin on se passerait de vraies preuves : « le Tribunal ne sera pas lié par les règles techniques relatives à l'administration des preuves […]. Le Tribunal n'exigera pas que soit rapportée la preuve de faits de notoriété publique mais les tiendra pour acquis […] » (articles 19 et 21 du Statut [Charter] du Tribunal militaire international). En outre, la justice des vainqueurs violait les usages de la justice normale en ignorant la séparation des pouvoirs (ont participé à la rédaction du Statut des hommes qui allaient devenir des juges et des procureurs), en instituant la responsabilité collective (tout membre d'un groupe déclaré criminel était lui-même d'emblée réputé criminel), en pratiquant la rétroactivité des lois et en déniant aux condamnés toute possibilité d'appel. Aucun représentant des nations neutres ne figurait parmi les juges et les procureurs. Le plus sérieusement du monde les Soviétiques, avec l'assentiment des juges américains, britanniques et français, avaient en particulier l'audace de reprocher aux Allemands d'avoir procédé à des déportations et d'avoir usé de camps de concentration ou de camps de travail forcé. Recourant à une spécification complémentaire de l'article 19 du Statut, le procureur soviétique obtenait des juges que fût refusé tout examen sérieux du crime de Katyn, imputé aux Allemands. Quant au juge principal soviétique, le Major Général I.T. Nikitchenko, il avait fait office de procureur en 1936 aux mascarades judiciaires précédentes appelées « procès de Moscou », ce qui ne l'avait pas empêché d'être recruté à Nuremberg.

Au fond, si l'on garde présents à l'esprit les crimes perpétrés contre le peuple allemand par le moyen d'une guerre aérienne visant à l'extermination des civils, si l'on se rappelle les déportations (appelées déplacements) des minorités allemandes de l'Europe orientale et centrale, si l'on ajoute à cela les viols en série des femmes et des filles allemandes (ce fut le cas, entre autres, à l'âge de douze ans, d'Hannelore Kohl, future épouse du chancelier ; voy. Heribert Schwan, Die Frau an seiner Seite / Leben und Leiden der Hannelore Kohl, Munich, Wilhelm Heyne Verlag, 2011, p. 54-58), si l'on garde présents à l'esprit les pillages, l'accaparement officiel par les Alliés de l'argent, de l'or, du platine, des bijoux, des valeurs, de certaines propriétés, de banques, de musées, de brevets scientifiques ou industriels et si, pour couronner le tout, on s'avise de ce qu'à Nuremberg le procès des dirigeants allemands a mérité d'être appelé une mascarade ou, selon le mot de Harlan Fiske Stone, président de la cour suprême des États-Unis (Chief Justice of the Supreme Court of the United States), une « high-grade lynching party » (une opération sophistiquée de lynchage), on ne peut que trouver déplorable le fait que, depuis 66 ans, on persiste dans nos écoles, à l'université et dans les médias à prêcher que, lors de la dernière guerre mondiale, les vainqueurs ont représenté le Bien et les vaincus, le Mal.

## Elie Wiesel : un grand faux témoin

Elie Wiesel incarne idéalement cette incompréhension de la nature humaine, laquelle partout, en réalité, est faite d'une combinaison du Bien et du Mal. Cette inintelligence le conduit, pour soutenir la thèse selon laquelle le peuple d'Israël constitue le sel de la terre et souffre du Mal plus que tout autre, à mentir avec aplomb, à prêcher la haine de l'adversaire et à demander inlassablement qu'on aille en quelque sorte cracher sur les tombes des vaincus. En janvier 1945 il avait eu avec son père le choix, offert par les Allemands, de rester à Auschwitz jusqu'à l'arrivée des Soviétiques ou d'être transféré dans un camp situé à l'intérieur de l'Allemagne ; tous deux, après mûre réflexion, avaient choisi de partir avec leurs « exterminateurs » plutôt que d'attendre leurs « libérateurs ». Parvenu à Buchenwald où son père allait mourir de la dysenterie et où, paraît-il, les Allemands tuaient quotidiennement 10 000 personnes par jour (Stephan Kapter, « Author, Teacher, Witness », Time Magazine, 18 mars 1985, p. 79), il n'en jouait pas moins, parfois, aux échecs (Jorge Semprún et Elie Wiesel, Se taire est impossible, Paris, Arte Editions, 1997, p. 12). Chez E. Wiesel on note beaucoup des traits du clown qui sait que plus il exagérera, plus il sera apprécié de l'assistance. Le 7 février 1996 il recevait les insignes de docteur honoris causa de l'Université Jules Verne de Picardie. Dans sa livraison du 9 février Le Courrier Picard écrivait au sujet de la conférence donnée par E. Wiesel et de ses réponses aux questions posées dans la salle : « Une question fuse : 'Que pensez-vous de l'émergence des courants révisionnistes et négationnistes ?' [E. Wiesel répond :] 'Ce sont des antisémites virulents, vicieux, structurés et bien financés. Le jour où j'ai reçu le Prix Nobel [le 10 décembre 1986 à Oslo], ils étaient des centaines dans la rue à manifester contre moi. Jamais je ne leur accorderai la dignité du débat. Ce sont des êtres moralement malades. Je crois savoir combattre l'injustice, je ne sais pas combattre la laideur' ». Pierre Guillaume et Serge Thion, qui m'accompagnaient à Oslo en 1986, peuvent en attester avec moi : le nombre de ces manifestants a été rigoureusement égal à zéro. La vérité est qu'avec mes deux amis révisionnistes nous avions ce jour-là distribué des exemplaires en anglais et en suédois (facilement lisible pour les Norvégiens) de mon dépliant sur « Elie Wiesel : un grand faux témoin » (reproduit dans mes Ecrits révisionnistes (1974-1998), p. 606-611, ainsi qu'à http://robertfaurisson.blogspot.com/1986/03/un-grand-faux-temoin-elie-wiesel.html). A l'entrée de la salle où allait se faire la remise du prix nous avions, en une action extrêmement rapide, distribué le texte à une quarantaine de personnes, puis nous étions à notre tour entrés dans la salle où, pour ma part, j'ai eu du mal à comprimer mon rire quand le candidat s'est mis à entonner je ne sais quel chant, peut-être juif mais assurément d'un effet bouffon. A la sortie, le philosophe milliardaire Bernard-Henri Lévy flanquait à sa gauche Elie Wiesel et nous jetait un noir regard.

## Il faut revenir au souci de l'exactitude

Mais, personnellement, j'ai fait un rêve : un jour viendra peut-être où, après la projection, imposé à tous les enfants de France, de Nuit et Brouillard (film classique de propagande signé d'Alain Resnais), le maître, au lieu de nourrir chez l'élève la tendance à l'indignation irréfléchie et au jugement téméraire, l'invitera à la réflexion. Il lui apprendra à évaluer la distance qu'il peut y avoir, dans ce film comme dans bien d'autres documentaires-documenteurs, entre l'image et le commentaire. Les images qu'on nous donne à voir, que signifient-elles au juste ? Que veulent dire ces horreurs, ces piles de cadavres, ce bulldozer ? Cette pièce de béton au « plafond labouré par les ongles », sur quelle expertise criminelle se fonde-t-on pour l'appeler une « chambre à gaz », c'est-à-dire un abattoir chimique d'êtres humains ? Où a-t-on jamais vu que des ongles (de la kératine) puissent « labourer » une surface de béton ? A la vue de tant de cadavres, qui incriminer ? Le vaincu ? Ou tout simplement la guerre et son inévitable cortège d'horreurs ? Ou encore, tout bien réfléchi, dans ce cas précis, ne serait-ce pas l'impitoyable politique guerrière menée par le vainqueur ? Plus tard, il sera toujours temps d'apprendre soit à l'adolescent, soit à l'adulte que sera devenu cet élève que, comme trop souvent dans l'aventure humaine, « la première victime d'une guerre est la vérité », que « c'est le vainqueur qui écrit l'histoire », que « la justice couche volontiers dans le lit du vainqueur » et que, selon la formule de Céline, « le délire de mentir et de croire s'attrape comme la gale ». Oui, mensonge et crédulité vont souvent de pair. De ces deux maux il faut essayer de se prémunir ou de se guérir. Pour cela il est nécessaire, avant d'émettre un jugement, de travailler, réfléchir, scruter, peser puis, derechef, de peser, scruter, réfléchir, et travailler encore. Il n'est pas d'école plus rude que celle de la révision des idées reçues. Cette école-là n'est autre que celle du révisionnisme. Les révisionnistes ne nient pas. Ils ne sont ni des négateurs ni des « négationnistes ». Ils s'efforcent d'être constructifs, positifs et parfois certains d'entre eux pourraient être qualifiés de positivistes. Leur méthode de recherche est vieille comme le monde ; elle est comme la soif de connaissance ou comme l'amour de la science et de l'exactitude. Soyons modestes : n'allons pas prétendre que nous recherchons la vérité ou que nous l'avons trouvée. « La vérité », surtout quand le mot s'affuble d'une majuscule, risque d'être vague ou inaccessible. Ce qu'il convient de rechercher, c'est l'exactitude, c'est-à-dire à chaque instant la découverte d'une petite vérité vérifiable ; à la fin, la somme de ces petites vérités vérifiables permettra d'énoncer une conclusion qui, à son tour, aura quelques chances d'être exacte.

## Il faut chercher les boîtes noires de « l'Holocauste » et en examiner le contenu

Ce type de recherche ou d'activité révisionniste n'est pas sans risque. Pour se lancer et surtout pour se maintenir dans l'action révisionniste, il faut avoir le cœur bien accroché. Elie Wiesel et ses amis montent bonne garde autour des boîtes noires de « l'Holocauste » : pas question pour nous d'en approcher afin de voir ce qu'elles contiennent. Personnellement, j'ai eu un jour la chance de découvrir et d'ouvrir un instant la boîte noire d'Auschwitz et de Birkenau au Musée d'État d'Auschwitz. Cela s'est passé en deux temps. En 1975, lors de mon premier examen des lieux du « crime », j'avais détecté de franches anomalies dans ce qu'on nous présentait comme étant un crématoire « en état d'origine » (le Krema I à Auschwitz I) ou des crématoires en ruines (les Krema II et III ainsi que IV et V à Birkenau ou Auschwitz II). J'avais alors contraint un haut responsable du Musée d'État à reconnaître que le Krema I avait été « reconstruit », alors que le public croyait avoir affaire à un crématoire authentique conservé dans son état d'origine. Je lui avais fait constater l'absence de suie à la bouche d'un four crématoire, qu'il me garantissait « d'origine » ; il m'avait alors dit que ledit four était en réalité une « reconstruction » ; sur quoi je lui avais fait admettre que cette « reconstruction » impliquait nécessairement la connaissance et donc l'existence de plans d'origine. Je lui ai demandé où étaient ces plans. Non sans embarras il m'a avoué qu'ils se trouvaient au service des Archives du camp. Obligé de regagner la France, je remettais à l'année suivante ma visite aux Archives. Je passerai ici sur les détails des difficultés rencontrées alors, et j'en arrive tout de suite à la conclusion : le 19 mars 1976 je découvrais dans les archives du Musée d'État les plans des crématoires d'Auschwitz et de Birkenau censés avoir contenu des « chambres à gaz » homicides. Ces plans, on nous les avait cachés depuis 1945 (voy. mon écrit « Retour sur ma découverte, le 19 mars 1976, des plans des crématoires d'Auschwitz et de Birkenau » : http://robertfaurisson.blogspot.com/2010/09/retour-sur-ma-decouverte-le-19-mars_14.html). Et pour cause puisqu'ils révélaient le pot aux roses. Dans le Krema I, la pièce qu'on prétendait avoir été une « chambre à gaz » homicide n'avait été, en réalité, qu'une « Leichenhalle », c'est-à-dire un inoffensif dépositoire fait pour y mettre les cadavres en attente de crémation. Les grands Krema II et III de Birkenau n'avaient possédé que des « Leichenkeller », c'est-à-dire des dépositoires construits en partie sous terre afin de leur assurer à l'intérieur une fraîcheur relative. Les Krema IV et V, également situés à Birkenau, ne possédaient que des pièces inoffensives dont certaines étaient équipées de poêles et n'auraient donc jamais pu servir de « chambres à gaz ». Au terme d'études prolongées portant successivement sur le Zyklon B (à base d'acide cyanhydrique, le produit a été inventé en 1922 par un assistant du chimiste juif allemand Fritz Haber ; le brevet d'invention date du 27 décembre 1926), sur les chambres à gaz de désinfection ou d'épouillage, et surtout sur les chambres à gaz américaines d'exécution (au gaz cyanhydrique) je concluais que les « témoignages » ou « aveux » portant sur l'exécution systématique des juifs en « chambres à gaz » se heurtaient à de radicales impossibilités physiques et chimiques. Encore aujourd'hui je reste étonné par le fait que les États-Unis, abreuvés de littérature holocaustique mais possédant tant d'hommes de science, tant de chimistes et d'ingénieurs, n'aient eu personne pour procéder à une comparaison entre les « chambres à gaz » nazies, passablement vagues, et la réalité facilement vérifiable (au moins jusqu'à une époque récente) des chambres à gaz américaines. Il suffit de voir une chambre à gaz américaine pour se rendre instantanément compte que les « chambres à gaz » nazies sont une pure création de l'esprit. Une véritable chambre à gaz américaine pour l'exécution d'une seule personne est nécessairement d'une effroyable complication car il ne faut pas que le gazeur se gaze lui-même 1) soit pendant l'exécution, 2) soit pendant la ventilation, 3) soit au moment de pénétrer dans le local pour y manipuler et extraire un cadavre hautement cyanuré et qui, de ce fait, reste hautement dangereux. Je répète qu'il suffit même à un profane de voir de près une chambre à gaz de pénitencier américain et de s'en faire expliquer le fonctionnement pour comprendre que non seulement les « chambres à gaz » nazies n'ont pas existé mais aussi qu'elles n'ont pas même pu exister. Pour ma part, en 1979, j'avais vu et étudié la chambre à gaz de Baltimore (Maryland). C'est aussi en 1979, à Los Angeles, lors de la première conférence internationale de l'Institute for Historical Review, que j'avais pu rendre publique avec ces plans ma découverte de la boîte noire d'Auschwitz et de Birkenau. « C'est de la dynamite ! », avait jugé une participante.

## Les victoires du révisionnisme

Trois ans auparavant, en 1976, un universitaire américain, Arthur Robert Butz, avait publié sur la prétendue extermination des juifs un magistral ouvrage intitulé The Hoax of the Twentieth Century. En 1985, puis en 1988, à Toronto, aux procès d'Ernst Zündel, les révisionnistes anéantissaient d'abord Raul Hilberg , l'historien n° 1 de la thèse exterminationniste, puis Rudolf Vrba, le témoin n° 1 des prétendus gazages criminels d'Auschwitz ; enfin, grâce en particulier aux expertises et au rapport de Fred Leuchter (193 pages), le mythe tout entier de ces gazages est entré en agonie le 20 avril 1988. Plus tard on verra se déliter lentement cet élément central, ce « cœur » des accusations portées contre les Allemands du III^e^ Reich. Mais, dès 1988, Arno Mayer, professeur d'histoire à Princeton, écrivait : « Les sources pour l'étude des chambres à gaz sont à la fois rares et douteuses » [Sources for the study of the gas chambers are at once rare and unreliable] (Why did the Heavens not Darken? The « Final Solution » in History, New York, Pantheon Books, p. 362). D'autres chercheurs qui avaient autrefois claironné leur certitude en l'existence de ces « chambres à gaz » ont fini par admettre qu'on n'en avait pas de preuves. Le Français Jean-Claude Pressac, qui était le protégé de Beate et Serge Klarsfeld, « chasseurs d'anciens nazis », est allé jusqu'à écrire que le dossier tout entier de l'histoire de la déportation était « pourri » par trop de mensonges et que ce dossier, en dépit des réelles souffrances de tant de déportés, n'était plus bon que pour les « poubelles de l'histoire » ; il l'a écrit en 1995 mais sa capitulation n'a été révélée qu'en 2000. A ceux qui souhaiteraient en savoir plus sur le sujet je me permets de recommander la lecture de mon étude sur « Les Victoires du révisionnisme » datée du 11 décembre 2006 (http://robertfaurisson.blogspot.com/2006/12/les-victoires-du-revisionnisme.html).

## Le coup de grâce porté, le 27 décembre 2009, au mythe des « chambres à gaz » nazies

Trois ans plus tard, le 27 décembre 2009, le mythe d'Auschwitz a reçu le coup de grâce. Ce coup lui a été administré par un universitaire juif, Robert Jan van Pelt, qu'on peut tenir pour le dernier à avoir voulu prouver scientifiquement qu'Auschwitz, capitale de « l'Holocauste », avait été un « camp d'extermination » (expression américaine forgée en novembre 1944), c'est-à-dire un camp qui aurait été équipé de « chambres à gaz » d'extermination. Les révisionnistes n'avaient pas d'adversaire plus déterminé et plus décidé à les combattre sur le plan historique et scientifique que ce professeur enseignant l'histoire de l'architecture à l'Université de Waterloo (Ontario, Canada). Il défendait la thèse habituelle selon laquelle, pour gazer plusieurs milliers de juifs à la fois, un SS, monté sur le toit de certaines « chambres à gaz », déversait des granulés de Zyklon B par quatre orifices aménagés dans le plafond de béton desdites « chambres à gaz ». Toujours sous la poussée des découvertes révisionnistes, il avait fallu convenir que les orifices du Krema I avaient été créés par… les Soviétiques et les communistes polonais. Mais R.J. van Pelt et ses amis se faisaient fort de trouver de tels orifices dans le toit de béton, en ruines, des Krema II et III. Cependant, après des années de recherches, ils se révélaient incapables de fournir une seule photographie de ces orifices ou des conduits perforés (?) ― qui, au-dessous, auraient permis la diffusion du gaz cyanhydrique ― et de relever un défi que j'avais résumé en la formule : « No holes, no Holocaust » (Pas d'orifices, pas d'Holocauste). D'où la capitulation de R.J. van Pelt. Le 27 décembre 2009, cité dans un article du Toronto Star, il révélait qu'à son avis la préservation du camp d'Auschwitz-Birkenau n'avait guère de sens : mieux valait laisser la nature reprendre ses droits. Et il ajoutait textuellement, en parlant de ce que nous sommes censés savoir du camp (c'est-à-dire qu'il s'y trouvait des « chambres à gaz », etc.) : « 99 % de ce que nous savons, nous n'en avons pas en fait les éléments physiques pour le prouver » [Ninety-nine per cent of what we know we do not actually have the physical evidence to prove] et de prétendre qu'à l'avenir : « Nous puiserons notre connaissance [de l'Holocauste en général] dans les livres et dans les témoignages des témoins oculaires […]. Exiger de nous-mêmes que nous ayons plus de preuves matérielles, c'est en réalité, d'une certaine façon, céder aux négateurs de l'Holocauste en fournissant une espèce, en quelque sorte, de preuve spéciale » [To demand that we have more material evidence is actually us somehow giving in to the Holocaust deniers by providing some sort of special evidence] (« A case for letting nature take back Auschwitz », Toronto Star, 27 décembre 2009).

Voilà qui n'était pas sans rappeler l'extraordinaire aveu, propre à réjouir les révisionnistes, auquel avait été réduit le juge anglais Charles Gray quand, à Londres, le 11 avril 2000, il avait rendu son jugement lors du procès en diffamation qu'avait intenté David Irving aux éditions Penguin et à Deborah Lipstadt. Mlle Lipstadt avait obtenu la présence et le soutien de R.J. van Pelt tandis que D. Irving, qui avait une médiocre connaissance de l'argumentation révisionniste, par crainte d'être associé à Germar Rudolf et à moi-même n'avait pas voulu de notre assistance : il était allé jusqu'à fonder sa plainte sur le fait qu'il avait été présenté au monde comme un « Holocaust denier » (négateur de l'Holocauste). Cet aveu du juge était dévastateur pour R.J. van Pelt, qui avait consacré une partie de sa vie à essayer de trouver des preuves de l'existence des « chambres à gaz » homicides. Voici cet aveu du juge Charles Gray : « Je dois avouer », écrit-il, « que, comme je pense, la plupart des gens, j'avais supposé que les preuves d'une extermination massive de juifs dans les chambres à gaz d'Auschwitz étaient imparables. Pourtant, j'ai écarté cette idée préconçue quand j'ai eu pesé le pour et le contre des preuves que les parties ont apportées aux débats » [I have to confess that, in common I suspect with most other people, I had supposed that the evidence of mass extermination of Jews in the gas chambers at Auschwitz was compelling. I have, however, set aside this preconception when assessing the evidence adduced by the parties in these proceedings] (High Court of Justice, Queen's Bench Division 1996-I-1113, Judgment, § 13.71 : http://www.fpp.co.uk/docs/trial/judgment/extract1.html). Juste après le paragraphe qui contient son renversant « aveu », le juge nous fournit, dans les § 13.72, 13.73 et 13.74, les raisons précises pour lesquelles il a, à l'instar d'un révisionniste, revu et corrigé son « idée préconçue ». Au fond, l'on voit ici un juge britannique adopter en avril 2000, à Londres, ce que, dix-sept ans auparavant, le 26 avril 1983, à Paris, la première chambre de la Cour d'appel (section A, présidée par François Grégoire) avait conclu de son côté : pour elle, Robert Faurisson, accusé par des organisations essentiellement juives d'avoir, dans son travail, fait preuve 1) de légèreté, 2) de négligence, 3) d'ignorance délibérée et 4) de mensonge, et cela pour aboutir à la conclusion que les « chambres à gaz » nazies n'avaient jamais existé, avait, en réalité, accompli un travail où l'on ne pouvait trouver trace 1) ni de légèreté, 2) ni de négligence, 3) ni d'ignorance délibérée, 4) ni de mensonge. Les magistrats avaient alors prononcé : « La valeur des conclusions défendues par M. Faurisson [sur le problème des « chambres à gaz »] relève donc [je souligne ce mot] de la seule appréciation des experts, des historiens et du public. » En bon français cela signifiait que, vu le caractère sérieux des écrits de Faurisson sur le sujet, tout le monde devait avoir le droit de dire : « Les prétendues chambres à gaz hitlériennes n'ont jamais existé ».

Mais, bien entendu, j'avais été néanmoins condamné à Paris ce 26 avril 1983 parce que, paraît-il, j'avais fait preuve de malveillance ; en particulier, la Cour d'appel me reprochait de n'avoir « jamais su trouver un mot pour marquer [m]on respect aux victimes » (ce qui était inexact) et elle pensait que mon « 'révisionnisme' [pouvait] faire figure d'une tentative de réhabilitation globale des criminels de guerre nazis » (ce qui était une pensée ou une arrière-pensée que je n'avais jamais eue). De son côté, à Londres, le 14 avril 2000, David Irving a été débouté et condamné à verser deux millions de livres sterling aux défendeurs essentiellement parce que, paraît-il, il avait été aussi malveillant qu'un raciste peut l'être.

## Les Einsatzgruppen : aucun ordre de tuer les juifs

La thèse de l'existence des « chambres à gaz » nazies devenant de plus en plus difficile à soutenir, les historiens officiels et les médias se sont mis à insister sur le cas des Einsatzgruppen. Ne reculant devant aucune tricherie ils ont, dans certains cas, commencé par affubler ces « Groupes d'intervention » du nom, inventé par eux, de « Groupes mobiles de tuerie ». Les Einsatzgruppen exerçant leur activité en URSS avaient, en fait, pour mission d'assurer la sécurité à l'arrière du front en particulier à cause de la présence des francs-tireurs et des partisans qui multipliaient les assassinats de soldats allemands et les sabotages. Jamais les Einsatzgruppen n'ont reçu d'ordre d'exécuter des juifs en tant que tels. Des juifs pouvaient être exécutés ou pour actes de terrorisme, ou pour sabotage, ou en qualité d'otages à la suite, par exemple, d'attentats, ou pour tel autre motif de ce genre. Les affirmations en sens contraire et les constructions de l'esprit autour d'un prétendu « Kommissar Befehl » ou à propos de la confession du Général SS Otto Ohlendorf à Nuremberg sont de l'ordre du mythe. D'une manière générale, « malgré les recherches les plus érudites » (François Furet à la fin d'un colloque à la Sorbonne, le 2 juillet 1982), jamais un tel ordre n'a été trouvé. Même les historiens les plus complaisants ont dû l'admettre ; voyez, par exemple, pour les Einsatzgruppen, en particulier, Helmut Krausnick et Hans-Heinrich Wilhelm dans Die Truppe des Weltanschauungskrieges / Die Einsatzgruppen des Sicherheitspolizei und des SD, Stuttgart, Deutsche Verlags-Anstalt, 1981, p. 634, ou encore Yaacov Lozowick dans « Rollbahn : The Early Activities of Einsatzgruppe C », Holocaust and Genocide Studies, 1987, Vol. 2, p. 221-241.

## Faute de preuve, Raul Hilberg explique tout par le paranormal

Pour ce qui est du caractère délibéré d'une prétendue extermination des juifs sur tout un continent, Raul Hilberg n'a pas craint d'affirmer, en 1961, dans la première édition de son œuvre de référence, qu'il avait existé deux ordres de Hitler de tuer les juifs (The Destruction of the European Jews, Chicago, Quadrangle Books, 1961, p. 177). A la suite de l'irruption du révisionnisme historique sur la scène internationale il a renoncé à cette affirmation, qui n'était accompagnée d'aucun document, d'aucune preuve et il en est venu à une autre affirmation selon laquelle, si l'on ne pouvait découvrir aucun document, aucune preuve, c'est que la destruction des juifs d'Europe s'était faite spontanément, sans ordres, sans plan, sans rien, grâce à l'initiative et à l'action d'une vaste bureaucratie travaillant par transmission de pensée (The Destruction of the European Jews, Revised and Definitive Edition, New York & Londres, Holmes & Meier, 3 volumes, 1985, p. 53, 55, 62). Selon le nouvel Hilberg, cette étrange bureaucratie, que l'on croyait obéissante et pointilleuse, avait soudain pris l'initiative de jeter par-dessus bord toute contrainte bureaucratique, toute obéissance à un ordre quelconque venu d'en haut, afin de tuer les juifs ; dès lors, elle n'avait plus œuvré que « par une incroyable rencontre des esprits, une transmission de pensée consensuelle » [by an incredible meeting of minds, a consensus-mind reading], et cela sans « plan pré-établi » [basic plan], avec des « directives écrites non publiées » [written directives not published], avec de « larges délégations de pouvoirs aux subordonnés, non publiées » [broad authorizations to subordinates not published], avec des « directives et des autorisations orales » [oral directives and authorizations], avec « des accords implicites et généralisés entre fonctionnaires, aboutissant à des décisions prises sans ordres précis ni explications » [basic understandings of officials resulting in décisions not requiring orders or explanations]. R. Hilberg nous l'explique, « l'opération ne fut pas confiée à une agence unique » [no one agency was charged with the whole operation] ; « il n'y eut jamais d'organisme central chargé de diriger et coordonner à lui seul l'ensemble du processus » [no single organization directed or coordinated the entire process] ; « pour détruire les Juifs d'Europe, il ne fut créé ni organisme spécial, ni budget particulier » [No special agency was created and no special budget was devised to destroy the Jews of Europe] ; « en dernière analyse », écrit-il, « la destruction des Juifs ne fut pas tant accomplie par l'exécution de lois et d'ordres que par suite d'un état d'esprit, d'une compréhension tacite, d'une consonance et d'une synchronisation » [In the final analysis, the destruction of the Jews was not so much a product of laws and commands, as it was a matter of spirit, of shared comprehension, of consonance and synchronization] (« Raul Hilberg explique maintenant le génocide par télépathie », http://robertfaurisson.blogspot.com/1988/09/raul-hilberg-explique-maintenant-le.html). On ne peut qu'être abasourdi devant ces fantasmagories inventées par le numéro 1 des historiens de « l'Holocauste », devant ces absurdes explications par l'opération du Saint Esprit de la bureaucratie germanique, devant cette « rencontre des esprits » qualifiée par Hilberg en personne d' « incroyable », devant ce recours au pouvoir de la « transmission de pensée », devant cet « état d'esprit », cette « compréhension tacite », cette « consonance » et cette « synchronisation ». Jamais, je pense, dans l'historiographie mondiale on n'avait ainsi exposé et défendu une thèse en usant de notions qui relèvent à ce point de la magie. Une magie noire quand on songe aux effets nocifs ou criminels que la croyance générale en « la destruction des Juifs d'Europe » a pu avoir de 1945 jusqu'à nos jours sur des milliards d'hommes un peu partout dans le monde.

## Des faits excluent qu'il ait existé une destruction des juifs d'Europe

Curieusement les auteurs qui osent soutenir la thèse selon laquelle le III^e^ Reich a eu une politique d'extermination des juifs ne nous expliquent pas un nombre considérable de faits qui, si une telle politique avait existé, n'auraient pas pu se produire. Comme l'écrit A.R. Butz, « La plus simple raison valable pour être sceptique au sujet de l'affirmation qu'il y a eu une extermination est aussi la plus simple raison qui se puisse concevoir ; à la fin de la guerre ils étaient encore là » (The Hoax of the Twentieth Century, p. 10) [The simplest valid reason for being skeptical about the extermination claim is also the simplest conceivable reason; at the end of the war they were still there]. En 1945, à la fin de la guerre, le nombre des « survivants » juifs ou des « miraculés » juifs était stupéfiant. Tant de « miraculés » ne pouvaient être un miracle mais plutôt la manifestation d'un fait naturel. Chaque survivant qui ose témoigner de ce qu'on massacrait systématiquement les gens de sa catégorie s'inflige un démenti par le seul fait de ce qu'il est encore en vie : il est une « preuve vivante » de ce que son affirmation est absurde. Encore en 1997, soit cinquante-deux ans après la guerre, le nombre officiel des survivants juifs était évalué, selon les uns, à 834 000 et selon d'autres à 960 000 (« Holocaust Survivors » par Adina Mishkoff, Administrative Assistant, Amcha, Jérusalem, 13 août 1997 ; il s'agissait de chiffres fournis par le cabinet du Premier ministre israélien). D'après une estimation du statisticien suédois Carl Nordling, à qui j'avais soumis ces évaluations du gouvernement israélien, si l'on ramène ces chiffres à une moyenne de 900 000 on est en droit de conclure qu'en 1945 le nombre des survivants dépassait de peu le chiffre de trois millions. Aujourd'hui encore, les organisations de « survivants » pullulent sous les dénominations les plus diverses ; elles rassemblent d'anciens résistants juifs, des travailleurs forcés juifs, des fugitifs ou des clandestins juifs ainsi que d'anciens « enfants d'Auschwitz », ces derniers comprenant des enfants juifs nés dans ce camp ou internés dès leur plus jeune âge avec leurs parents. Auschwitz, comme bien d'autres camps, était équipé de bâtiments hospitaliers ou d'infirmeries où les juifs, comme Elie Wiesel lui-même, avaient accès aux soins.

## En plein Reich, en pleine guerre, homes et hôpitaux pour juifs

Dans certaines villes allemandes, jusqu'à la fin de la guerre, il y a eu des hôpitaux ou des homes réservés aux juifs. Prenons l'exemple de Vienne : d'après un document allemand, publié en anglais par R. Hilberg lui-même, on constate qu'à la date du 17 octobre 1944, c'est-à-dire quelques mois avant la fin de la guerre, le Conseil juif de Vienne [the Council of Elders of the Jews in Vienna] avait la responsabilité d'hôpitaux juifs, d'un home d'enfants et d'un externat [Children's Home and Dayschool], d'une cuisine communautaire [Community Kitchen], d'un établissement de bains [Bath], d'un home pour personnes âgées [Poor People's Home], d'un dépôt de vêtements et de mobilier [Clothes and Furniture Depot], d'un bureau d'aide sociale [Relief Division], d'une bibliothèque [Library], d'une administration du cimetière [Cemetery Administration and Grounds], d'une agence technique avec son atelier [Technical Column and Workshop]. Le tout était réparti en onze différents points de la ville. Le 17 octobre 1944 un bombardement des Alliés a complètement détruit l'hôpital pour enfants. Dans la nuit même qui a suivi, un nouvel hôpital de fortune a dû être installé [as an emergency measure a new hospital had to be set up overnight] et, en accord avec la Gestapo / Direction Générale de la Gestapo à Vienne et le Bureau municipal de la construction [the Secret State Police/Secret State Police Main Directorate Vienna, and the City Construction Office], le Conseil a pu payer en un seul versement un architecte compétent pour la reconstruction et la menuiserie de l'hôpital [the Council handed the supervision of construction and carpentry to a competent architect against payment of a lump sum]. La cuisine de la communauté, réservée en priorité aux travailleurs juifs (43 892 repas en 1944), a été endommagée durant le raid du 5 novembre 1944 mais les dégâts ont été très vite réparés (Yad Vashem document O 30/5, Excerpts from the Annual Report of the Director of the Council of Elders of the Jews in Vienna, signed Josef Israel Lowenherz, dated Jan. 22, 1945, Documents of Destruction / Germany and Jewry 1933-1945, Edited with Commentary by Raul Hilberg, Chicago, Quadrangle Books, 1971, p. 125-130 ; p. 127-128).

Un autre exemple, tout à fait parlant, est celui de Berlin et, en particulier, de son « Hôpital de la communauté juive » (Krankenhaus der Jüdischen Gemeinde) au n° 2 de l'Iranischestrasse. Il faut lire, de Daniel B. Silver, Refuge in Hell / How Berlin's Jewish Hospital Outlasted the Nazis, Boston, Houghton Mifflin, 2003, 352 p. ou, à défaut, la traduction en français de cet ouvrage : Refuge en Enfer / Comment l'Hôpital juif de Berlin a survécu au nazisme, Bruxelles, André Versaille éditeur, 2011, 304 p. L'auteur, un homme de loi juif, et ses témoins juifs se battent les flancs pour trouver une solution à la question suivante : « Puisque Hitler avait décidé l'extermination des juifs, comment se fait-il que tant de juifs aient, durant toute la guerre, reçu tant de soins dans cet hôpital dirigé par le Dr Walter Lustig ? » La réponse, en fin de compte, tient en deux phrases : cela ne saurait s'expliquer ; il s'est agi d'un miracle. Ce miracle lui-même aurait tenu à deux facteurs principaux : « la pure et simple chance et les conflits bureaucratiques internes au sein des organisations nazies » (« sheer blind luck and bureaucratic infighting among Nazi organisations », comme l'indique la présentation du livre en 4^e^ page de couverture). S'il était une crainte qui obsédait tous les juifs de Berlin, y compris, dans cet hôpital, les malades, les chirurgiens, les médecins, les infirmières et le reste du personnel, c'était celle des terrifiants bombardements à l'aveugle de l'aviation anglo-américaine.

Enfin, sur ce chapitre des faits qui contredisent l'affirmation, sans preuves, selon laquelle l'Allemagne du III^e^ Reich exterminait les juifs il convient de lire une étude, riche de stupéfiantes révélations ; intitulée « Vie quotidienne des juifs allemands pendant la guerre (Trois documents) », elle est parue dans la Revue d'histoire révisionniste n° 6 (mai 1992) aux pages 131-140 ; signée de « Célestin Loos », elle a eu en réalité deux auteurs : le Belge Pierre Moreau, récemment décédé, et moi-même. Le cas de l'hôpital juif de Berlin, dirigé par le Dr Walter Lustig, y est mentionné en passant (p. 138, n. 3).

## La collaboration des juifs avec l'occupant allemand

En 1992, dans une étude consacrée aux « juifs bruns » et reproduite dans mes Ecrits révisionnistes (1974-1998) aux pages 1421-1433 (http://robertfaurisson.blogspot.com/1992/05/propos-de-larret-touvier-laffaire-des.html), j'ai évoqué l'existence et le rôle des « Conseils juifs en Europe » (p. 1429-1430) dans les termes suivants :

Dès la fin de 1939, les Allemands imposèrent la création de « Conseils juifs » pour l'administration des communautés juives de Pologne par villes, ghettos ou provinces. Certains Conseils s'efforcèrent de contrarier la politique allemande, mais la plupart apportèrent une importante contribution à l'effort de guerre allemand. Elles fournirent main-d'œuvre et produits manufacturés. Cette politique de collaboration résolue fut suivie par le fameux Mordechaï Chaïm Rumkowski, « le roi de Lodz », qui alla jusqu'à frapper sa propre monnaie, Jacob Gens de Vilna, Moshe Merin de Sosnowiec en Silésie et Efraim Barasz de Bialystok. Ces Conseils réprouvaient la lutte armée contre les Allemands et certains allèrent jusqu'à combattre les résistants. L'Allemagne eut sa « Représentation des juifs allemands du Reich », la France eut son « Union générale des Israélites de France » [UGIF], la Belgique une « Association des juifs en Belgique ». Les Pays-Bas, la Slovaquie, la Hongrie, la Roumanie et, en Grèce, Salonique eurent leurs Conseils juifs. Ceux des Pays-Bas, de Slovaquie et de Hongrie furent particulièrement coopératifs. Grâce à leur collaboration avec les Allemands, beaucoup de juifs assurèrent largement leur subsistance : certains comme Joinovici et Skolnikoff bâtirent de colossales fortunes.

Pendant la guerre les contacts entre certains milieux sionistes et les Allemands persistèrent. En 1941 le « Groupe Stern » ou « Lehi » alla jusqu'à proposer une alliance militaire à l'Allemagne contre la Grande-Bretagne. A ce sujet un émissaire de cette organisation juive, Naftali Lubenchik, rencontra à Beyrouth le diplomate Otto Werner von Hentig.

## L'Allemagne était prête à livrer les juifs aux Américains et aux Britanniques

Après avoir envisagé plusieurs solutions territoriales de la question juive, solutions qui, comme le « Madagaskar Projekt », se sont révélées impraticables, l'Allemagne était prête à livrer les juifs d'Europe aux Américains et aux Britanniques mais à la condition que ces derniers gardent ces juifs chez eux jusqu'à la fin de la guerre et ne leur permettent pas d'émigrer en Palestine, et cela pour épargner « le noble et vaillant peuple arabe ».

En effet, par exemple en 1944, le Ministère des Affaires étrangères (dirigé par Joachim von Ribbentrop) fait savoir au gouvernement britannique que l'Allemagne est prête à lui remettre 5 000 personnes « non aryennes » ― 85% d'enfants et 15% d'adultes pour les accompagner ― originaires de Pologne, de Lituanie et de Lettonie mais à condition de recevoir la garantie que ceux-ci seront hébergés jusqu'à la fin de la guerre dans l'Empire britannique (par exemple au Canada) à l'exception de la Palestine et du Proche-Orient. « Le Gouvernement du Reich ne peut se prêter à une manœuvre tendant à permettre aux Juifs de chasser le noble et vaillant peuple arabe de sa mère patrie, la Palestine » (Document de Nuremberg NG-1794 ; Eberhardt von Thadden, les 29 avril et 5 mai 1944 ; Wagner, le 29 juillet 1944. Henri Monneray, Ancien Substitut au Tribunal Militaire International, La Persécution des juifs dans les pays de l'Est présentée à Nuremberg, Paris, Editions du Centre de documentation juive contemporaine, 1949, p. 168-169).

Le 15 janvier 1945 Heinrich Himmler rencontre à Bad Wildbad, en Forêt Noire, le Suisse Jean Marie Musy, ancien président de la Confédération helvétique, venu de la part des Américains discuter une fois de plus de « l'amélioration du sort des juifs ». Les tractations ont déjà eu leur effet sur un point ; jusque là assignés parfois comme tous les autres aux travaux les plus durs, les juifs se sont vu accorder un privilège, celui de n'être plus affectés aux « travaux durs » mais seulement aux « travaux normaux ». Dans une note consacrée à cette rencontre H. Himmler en vient à écrire :

Je lui ai à nouveau précisé ma position. Nous affectons les juifs au travail et, bien entendu, y compris à des travaux durs tels que la construction de routes, de canaux, les entreprises minières et ils ont là une forte mortalité. Depuis que sont en cours les discussions sur l'amélioration du sort des juifs, ils sont employés à des travaux normaux, mais il va de soi qu'ils doivent, comme tout Allemand, travailler dans l'armement. Notre point de vue sur la question juive est la suivante : la prise de position de l'Amérique et de l'Angleterre quant aux juifs ne nous intéresse d'aucune façon. Ce qui est clair, c'est que nous ne voulons pas les avoir en Allemagne et dans le domaine de vie allemand en raison des décennies d'expérience après la [première] guerre mondiale et que nous n'engagerons aucune discussion à ce sujet. Si l'Amérique veut les prendre, nous nous en féliciterons. Mais il doit être exclu, et là-dessus une garantie devra nous être donnée, que les juifs que nous laisserons sortir [d'Europe continentale] par la Suisse puissent jamais être refoulés vers la Palestine. Nous savons que les Arabes, tout autant que nous Allemands le faisons, refusent les juifs et nous ne voulons pas nous prêter à une indécence telle que d'envoyer de nouveaux juifs à ce pauvre peuple martyrisé par les juifs (zu einer solchen Unanständigkeit, diesem armen, von der Juden gequälten Volke neue Juden hinzuschicken) (Document de l'US-Document-Center Berlin. Photographie dans Werner Maser, Nürnberg, Tribunal der Sieger, Munich-Zurich, Droemer Knauer, 1979, p. 262-263).

## Les excès commis contre les juifs pouvaient être punis par la peine de mort

Bien d'autres précisions matérielles excluent que les autorités allemandes aient suivi une quelconque politique d'extermination des juifs mais je pense que la preuve majeure de l'inexistence d'une telle politique réside dans le fait que le meurtre d'un seul juif ou d'une seule juive risquait de valoir à son auteur des condamnations pouvant aller jusqu'à la peine de mort suivie de l'exécution. Faute de place, je renvoie à ce sujet aux notes en anglais d'une conférence que j'ai prononcée en 2002 dans le cadre de l'Institute for Historical Review (IHR) : « Punishment of Germans, by Third Reich authorities, for mistreatment of Jews (1939-1945) » ; ultérieurement paraîtra une traduction en français sous le titre de « Répression par les autorités du III^e^ Reich des excès commis par des Allemands contre des juifs (1939-1945) ».

## L'imposture des Six Millions. Wilhelm Höttl et le Tribunal de Nuremberg démasqués

Dans les lignes qui suivent je me propose de montrer d'abord comment est né le mythe des Six Millions de juifs prétendument tués ou morts durant la Seconde Guerre mondiale, puis grâce à quel menteur et quels mensonges il a été avalisé par le Tribunal militaire international (TMI) de Nuremberg et, enfin, comment, en 1987, je suis personnellement arrivé, devant témoin, à confondre Wilhelm Höttl, ancien officier SS, d'avoir porté faux témoignage en déclarant par écrit et sous serment qu'il tenait ce chiffre de la bouche même d'Adolf Eichmann.

C'est en 2003 que l'Américain Don Heddesheimer, un avocat de profession, nous a révélé que le mythe des Six Millions a eu la source la plus sordide qu'on puisse imaginer : dès 1900 (et peut-être même avant ?) des juifs de New York avaient fabriqué et lancé un juteux slogan publicitaire qui leur permettait de collecter des millions de dollars lors de campagnes de levées de fonds (fund-raising campaigns). Le slogan mis au point par ces juifs tenait, si l'on peut dire, en deux phrases : « En ce moment des millions de nos frères sont en train de mourir en Europe ; donnez-nous de l'argent pour leur venir en aide ». En général, ces juifs européens étaient supposés être au nombre de « cinq millions » ou de « plus de cinq millions » ou, surtout, de « six millions ». Selon les cas et les périodes, les bourreaux des juifs étaient présentés comme étant les Russes, les Ukrainiens, les Tsars, les Polonais,… (The First Holocaust / Jewish Fund-Raising Campaigns with Holocaust Claims During and After World War One, Preface by Germar Rudolf, Theses & Dissertations Press, Chicago, octobre 2003, 144 p.). Le journal qui a le plus contribué à la diffusion des slogans propres à ces campagnes de levées de fonds a été le New York Times. L'une des personnalités les plus actives a été le rabbin Stephen Wise (1874-1949), ami successivement des présidents Wilson et, surtout, F.D. Roosevelt ; fondateur du World Jewish Congress, il était un militant sioniste.

A partir de la Seconde guerre mondiale les bourreaux désignés sont devenus Hitler ou les Allemands tandis que les juifs européens étaient décrétés « morts » ou « tués » et non plus seulement « en train de mourir ». En 1945-1946 la délégation américaine au Procès de Nuremberg s'est trouvée, paraît-il, constituée de juifs à proportion de 75% ; cette estimation est celle de l'avocat général américain Thomas J. Dodd (son fils Christopher J. Dodd & Larry Bloom, Letters [of Thomas J. Dodd] from Nuremberg, Crown Publishers [Random House], lettre du 20 septembre 1945 à sa femme, p. 136 ; Lettres de Nuremberg / Le procureur américain raconte, Paris, Presses de la Cité, 2009, p. 163). On peut penser qu'au moins une partie de ces juifs, bercés par la rengaine des « millions de juifs européens morts ou destinés à mourir », ont fini par croire de bonne foi à ce qu'ils entendaient ou lisaient sur le sujet. Pour eux, le tout était de faire avaliser cette croyance par les juges de Nuremberg. Alors, pour parvenir à leurs fins ils allaient utiliser un personnage des plus douteux, un ancien commandant, puis lieutenant-colonel SS, qui, dans les derniers mois de la guerre, en Italie, sentant qu'il risquait l'exclusion de la SS pour malversations et pour contacts avec l'ennemi, s'était abouché avec les autorités alliées. A la fin de la guerre, prisonnier d'une docilité exemplaire, il est transféré à Nuremberg où il collabore pleinement avec l'accusation. C'est à lui, notamment, que l'accusation doit, signé de son nom, l'impressionnant organigramme de la Police de sécurité et du Service de Sûreté allemands (Document PS-2346). Il accepte de signer un affidavit (une déclaration écrite sous serment) le 26 novembre 1945 (Document PS-2738) où il prétend qu'à la fin du mois d'août 1944, dans son appartement, à Budapest, il a reçu la visite de son collègue le lieutenant-colonel Adolf Eichmann qui lui aurait annoncé avoir récemment remis un rapport à Himmler, lequel voulait savoir le nombre exact des juifs jusqu'ici tués. D'après ce rapport, A. Eichmann aurait textuellement déclaré qu'environ quatre millions de juifs avaient été tués (getötet) dans les différents camps d'extermination (Vernichtungslagern) cependant que deux autres millions avaient trouvé la mort d'une autre façon, la plupart ayant été fusillés par les Einsatzkommandos de la Police de Sûreté durant la campagne de Russie. Et A. Eichmann d'ajouter que Himmler n'avait pas apprécié ce rapport car, pour lui, le nombre des juifs tués devait être supérieur à six millions. L'affidavit est lu devant le tribunal, le 14 décembre 1945, par le substitut américain William Walsh qui commet la malhonnêteté de traduire le suspect Vernichtungslagern par le classique « concentration camps ». Un avocat allemand intervient. Il demande la comparution de Höttl. Il ne l'obtiendra jamais. Et le comble sera atteint quand, dans le jugement final, le Tribunal osera conclure le 30 septembre 1946 : « Adolf Eichmann, que Hitler avait chargé de ce programme [d'extermination], a estimé que cette politique avait causé la mort de six millions de Juifs, dont quatre millions périrent dans les camps d'extermination » (TMI, I, p. 266). La vérité est que jamais Hitler n'avait chargé A. Eichmann ou qui que ce fût d'un tel programme et que cette estimation n'était pas d'A. Eichmann mais lui avait été attribuée par W. Höttl. Après la guerre, W. Höttl avait continué de collaborer avec les Alliés dans la crainte d'être livré à une Hongrie gouvernée par des communistes qui n'auraient pas manqué de l'exécuter. Pendant ce temps son collègue A. Eichmann vivait en Argentine jusqu'au jour où, en 1960, il était enlevé par le Mossad et emmené de force en Israël pour y être jugé au terme d'une mascarade judiciaire encore pire que celle de Nuremberg. Lors de l'instruction de son affaire le juge Avner Less, capitaine de l'Armée israélienne, demande au prisonnier s'il a des commentaires à faire sur les déclarations de W. Höttl à son propos ; sa réponse est la suivante : « Certainement ! Les allégations de Höttl, c'est un salmigondis de salades que cet homme s'est ici fourrées dans la tête » (Jawohl ! Die Angaben von Höttl, das ist ein Sammelsurium von Durcheinander, das der Mann hier in seinen Kopf bekommen hat ; voy. Jochen von Lang, Das Eichmann-Protokoll, Severin und Siedler, 1982, p. 107). A. Eichmann montre ensuite que le surgissement après la guerre de millions de survivants vient contredire la possibilité qu'il ait existé un programme d'extermination physique des juifs. Il déclare, par exemple, à la page suivante : « Mon Capitaine, après la guerre les Alliés ont tout de même recensé ― je crois ― 2,4 millions de juifs. Et des centaines et des centaines de milliers de juifs sont ressortis des camps de concentration » (Herr Hauptmann, da sind immerhin ― glaube ich ― wie gesagt, es sind 2,4 Millionen von den Allierten nach Kriegsschluss gezählt worden. Und Hunderttausende von Juden kamen aus den Konzentrationslagern). Quand, pour sa part, il emploie à propos des juifs le mot de « Vernichtung », il l'entend au sens d'annihilation du pouvoir des juifs (dans le cadre de la recherche d'une possible « solution finale territoriale de la question juive ») et non pas dans le sens que les traducteurs aiment à lui donner d'« extermination physique » (p. 110).

En 1987 W. Höttl, assailli par ses compatriotes de critiques ou de demandes d'éclaircissements au sujet des propos qu'il a prêtés à son collègue A. Eichmann, commence à battre en retraite. Il prétend soudain que c'est sous l'effet de l'alcool que ce dernier avait parlé ; Höttl lui avait, paraît-il, fait boire à profusion de son alcool hongrois préféré, le barack, qui est à base d'abricot (Welt am Sonntag, 8 mars 1987, p. 2). Je lui écris à son domicile d'Altaussee en Autriche où il est directeur d'école. J'obtiens de le voir deux jours de suite en compagnie d'un Autrichien du nom de R.M. Le 3 février 1989 R.M. et moi, nous sommes reçus dans son bureau. Je ne lui avais rien caché de mes convictions révisionnistes. Je lui pose quelques questions sur son entretien d'août 1944 avec A. Eichmann. Je le laisse parler d'abondance mais soudain je lui déclare que, pour deux raisons au moins, je ne crois pas au contenu de son affidavit : d'abord six millions de juifs tués en juillet ou août 1944, alors qu'il restait encore environ neuf mois de guerre, cela laisserait supposer pour toute la durée de la guerre un chiffre encore supérieur à celui, déjà énorme et non prouvé, de six millions (l'équivalent de la population d'un pays comme la Suisse) ; ensuite, je relève dans ce même affidavit un mot qui me semble bien être un anachronisme ― et l'on sait qu'en histoire l'anachronisme est l'un des signes du faux. Le mot en question est celui de Vernichtungslagern, c'est-à-dire « camps d'extermination ». Il est précisément la traduction en allemand d'un néologisme américain, celui d' « extermination camps », apparu en novembre 1944 à Washington dans un célèbre rapport : le « War Refugee Report » ou « Auschwitz Protocol[s] » dû au témoin mythomane Rudolf Vrba (http://www.holocaustresearchproject.org/othercamps/auschproto.html). Il est invraisemblable qu'A. Eichmann ait employé une telle expression en août 1944 à Budapest. Visiblement frappé par l'argument, notre interlocuteur, perdant toute assurance, nous déclare sur un ton plaintif : « Mais pourquoi accordez-vous tant d'importance à cette déclaration d'Eichmann ? » Et de nous expliquer que l'homme était alors sous l'emprise de l'alcool et qu'il souffrait à son égard, à lui, W. Höttl, d'un complexe d'infériorité qui l'amenait à grossir les faits et les chiffres. Autrement dit, W. Höttl remettait soudain en question le point central de sa propre déclaration sous serment. Il lui retirait même toute valeur. Or c'est cette retentissante déclaration qui, par la suite, allait permettre au Tribunal de lancer à la face du monde que l'Allemagne avait exterminé six millions de juifs. W. Höttl avait menti puis, comme on l'a vu, à ce mensonge-là les juges de Nuremberg avaient ensuite ajouté leur propre mensonge en attribuant froidement ladite déclaration à A. Eichmann en personne.

Le lendemain matin de notre première journée d'entretien nous nous apprêtions, R.M. et moi, à quitter notre hôtel pour, comme convenu, nous rendre au second entretien quand le téléphone a sonné : Madame Höttl nous faisait savoir que, souffrant, son mari ne pouvait nous recevoir.

A ce jour, R.M. est toujours en vie et peut attester de ce que je dis là et qui, de toute façon, se trouve consigné dans notre correspondance. Je dois dire que, par la suite, j'ai continué d'entretenir avec W. Höttl une correspondance. Je lui ai suggéré de laisser à la postérité un écrit où il rétablirait la vérité. Sa réponse et les lettres qui s'en sont suivies montrent un homme décidé à rejeter ma suggestion mais perturbé. En 1997, il publiera Einsatz für das Reich (Au Service du Reich) (Coblence, Editions S. Bublies, 1997). Curieusement, dans la partie consacrée à « Eichmann et les 6 millions », il se montrera discret et fuyant sur le cœur du sujet et ira jusqu'à écrire : « Ce chiffre de 6 millions paraît être de toute façon magique » (Diese Zahl von 6 Millionen scheint irgendwie magisch zu sein) (p. 83). Certaines de ses remarques seront franchement révisionnistes (p. 82-85 et 420-423) mais il prendra la précaution de conclure sur une profession de foi holocaustique que je qualifierais de verbale. Il mourra deux ans plus tard à l'âge de 84 ans. L'histoire retiendra sa forfaiture. Mais Höttl peut se voir reconnaître des circonstances atténuantes : d'abord, personnellement, s'il avait refusé de collaborer avec les Américains, il aurait été livré aux Hongrois, qui l'auraient pendu ; ensuite, il lui aurait fallu être un héros pour défier à la fois la justice des vainqueurs, la police juive de la pensée et cette religion de « l'Holocauste », enveloppée d'une aura de terreur sacrée et qui, peu à peu, dans les années 1980 envahira tout l'Occident.

## Le bilan

A ce jour, sur le strict plan historique et scientifique, le bilan est désastreux pour les tenants de la vérité officielle. Il ne reste plus pierre sur pierre de l'édifice construit par le Tribunal de Nuremberg en 1945-1946, par le Tribunal de Jérusalem en 1961, ainsi que par Léon Poliakov, Gerald Reitlinger, Raul Hilberg et une foule d'auteurs principalement juifs. Pour nous en tenir aux trois éléments essentiels de l'accusation portée contre Adolf Hitler et le III^e^ Reich, personne, dans les soixante-cinq années et plus qui ont suivi la guerre, n'a pu trouver un seul ordre de tuer les juifs, ni une seule preuve qu'il ait existé une seule chambre à gaz ou un seul camion à gaz homicide, ni une seule preuve que six millions de juifs européens aient été assassinés ou même seulement aient trouvé la mort pendant la Seconde Guerre mondiale. Quand le révisionniste américain Bradley Smith, responsable du Committee for Open Debate on the Holocaust (CODOH), demande aux universitaires de son pays qu'on veuille bien lui fournir, preuves à l'appui, le nom d'une seule personne qui soit morte dans une chambre à gaz d'Auschwitz, on lui répond par l'insulte ou le silence ; pourquoi ?

Pour sa part, E.Wiesel a écrit en 1994 : « Les chambres à gaz, il vaut mieux qu'elles restent fermées au regard indiscret. Et à l'imagination » (Tous les fleuves vont à la mer / Mémoires, Paris, Seuil, 1994, p. 97) (Let the gas chambers remain closed to prying eyes, and to imagination, All Rivers Run to the Sea, Memoirs, New York, Knopf, 1995, p. 74) ; il nous fait par là un aveu, celui d'un terrible embarras qu'il partage avec tous ses pareils, historiens compris. Quand il ajoute : « On ne saura jamais ce qui s'est passé derrière les portes d'acier », il se laisse aller à son « imagination » car la seule prétendue « chambre à gaz » qu'on puisse visiter à Auschwitz possède deux très ordinaires portes de bois, dont l'une est en partie vitrée (et s'ouvre vers l'intérieur, là où se seraient accumulés les cadavres !) ; quant à la troisième ouverture, elle donne libre accès à la salle à la fois des fours, du dépôt de coke et des urnes : ces fours, chauffant parfois à 900°, auraient été à proximité immédiate de la « chambre à gaz » pleine d'un produit (de désinfection, le Zyklon B) laissant se dégager du gaz cyanhydrique, un gaz connu pour son caractère explosible ! Dans le second volume de ses Mémoires E. Wiesel revient sur cette nécessité de ne rien dire, rien raconter, rien imaginer au sujet des prétendus « gazages » : « Je crois tout savoir, tout deviner sur les heures ultimes des victimes. Je ne dirai rien. Imaginer serait indiscret. Raconter serait indécent » et il ajoute que, sur place, à Auschwitz-Birkenau, « tout en avançant vers l'endroit où les tueurs avaient bâti leurs chambres à gaz et leurs crématoires [en réalité, des ruines de simples crématoires ― RF], il faut serrer les dents et réprimer le désir de hurler ». Pourtant avec ses camarades juifs il va d'abord murmurer, puis « le murmure devient un cri, le cri d'une communauté devenue folle, folle de douleur et de lucidité (… et la mer n'est pas remplie / Mémoires 2, Paris, Seuil, 1996, p. 291[1]). Encore plus loin E. Wiesel répètera : « Je m'interdis d'imaginer ce qui s'est passé à l'intérieur des chambres à gaz, ne faisant que suivre du regard les vivants qui y entraient pour mourir étouffés » (p. 482). Nous sommes là en plein pathos. Dans La Nuit on ne trouve aucune mention des « chambres à gaz » ; E. Wiesel nous y raconte qu'à Auschwitz comme à Buchenwald c'est en plein air, dans le feu de brasiers, que les Allemands exterminaient les juifs. Dans la traduction allemande de son livre, les « chambres à gaz » font irruption : en quinze occurrences le traducteur a mis du gaz là où l'auteur ne l'avait pas fait (voy. « Un grand faux témoin : Elie Wiesel (suite) » soit dans mes Ecrits révisionnistes (1974-1998), p. 1526-1529, soit dans mon blog à http://robertfaurisson.blogspot.com/1993/06/un-grand-faux-temoin-elie-wiesel-suite.html). C'est François Mauriac qui, dans sa préface, avait parlé de « la chambre à gaz » ainsi que du « four alimenté par des créatures vivantes » et, pour commencer, il avait évoqué « ces wagons bourrés de petits garçons » (p. 10 ; ici on aura noté le mot de « bourrés » et l'absence de toute petite fille). L'intellectuel catholique Mauriac (« Anus Dei », selon un mot attribué à Paul Léautaud) avait été séduit par le jeune Wiesel et ne pouvait rien lui refuser. La traduction du livre en anglais ne manque pas d'intérêt (Night, New York, Bantam Books, édition en livre de poche de 1982, avec, à la page du titre, la précision suivante : « This edition contains the complete text of the original hardcover edition [1960]. NOT ONE WORD HAS BEEN OMITTED, XIV, 111 p.). La préface de F. Mauriac y est l'objet de quelques transformations ou atténuations significatives : à trois reprises « Israélien » ou « israélien » est traduit par « Jew » ; « l'œil bleu » du jeune Elie Wiesel se transforme en « dark eyes » ; « millions de morts » s'atténue en « thousands of dead » et, surtout, « ces wagons bourrés de petits garçons » deviennent « those trainloads of little children ». Au début du chapitre II de La Nuit on pouvait lire dans l'édition française originale (1958) que, dans les wagons remplis de quatre-vingts personnes, « libérés de toute censure sociale, les jeunes se laissaient aller ouvertement à leurs instincts et à la faveur de la nuit, s'accouplaient au milieu de nous, sans se préoccuper de qui que ce fût, seuls dans le monde. Les autres faisaient semblant de ne rien voir ». Dans les éditions les plus récentes, par exemple en 2007, « s'accouplaient » est devenu « s'attouchaient ». Les traductions en anglais ont parfois conservé « to copulate » (The Night Trilogy, Paperback edition, first published 1987, Canada, Harper Collins, fifteenth printing, 1997) et d'autres ont choisi « to flirt ». Avec E. Wiesel, qu'il parle ou qu'il écrive, les transformations et les tricheries se rencontrent à chaque coin de rue.

Durant toute son existence publique « le pape de la religion de l'Holocauste » a suppléé à la faillite des historiens officiels. Nous n'avons pas une seule preuve, pas un seul document pour prouver « l'Holocauste » mais nous avons les prestations du clown Elie Wiesel et de ses acolytes. Là où un sujet historique aussi grave exigeait des historiens sérieux, nous n'avons eu que des histrions ; Elie Wiesel est le premier d'entre eux : un clown, un histrion couronné d'un Prix Nobel.

## Une bonne nouvelle pour la pauvre humanité

Grâce à Internet, les acquis et les victoires du révisionnisme vont être enfin à la portée du monde entier. Pour E. Wiesel et ses associés, pour les organisations juives dans leur ensemble, pour les sionistes et l'État d'Israël, la nouvelle est mauvaise mais, pour la commune humanité, elle est bonne. Réputée capable de toutes les horreurs possibles, l'humanité n'a tout de même pas commis l'horreur suprême qui aurait consisté à vouloir froidement exterminer toute une « race », en particulier dans de véritables usines de mort. Ce « crime des crimes » n'a pas été commis : l'Allemagne n'a pas commis l'irréparable. Elle a été atrocement calomniée. Est-on parvenu à tuer jusqu'à son âme ? L'avenir nous le dira.

Pendant 66 ans, partant du principe que cette horreur sans précédent s'était incontestablement produite, on nous a accablés des mêmes antiennes : « Comment le pays de Goethe et de Beethoven, la patrie de tant de grands esprits, de savants, de bienfaiteurs de l'humanité a-t-il pu commettre le crime des crimes ? » ou encore : « Comment le monde a-t-il pu se taire ? D'où vient que le Pape Pie XII, si hostile à Adolf Hitler, n'ait jamais dénoncé un tel crime ni pendant ni après la guerre ? » ou « Comment s'explique-t-on que ni dans leurs déclarations ni dans leurs mémoires respectifs Churchill, Eisenhower, de Gaulle, pourtant impitoyables dans leurs dénonciations des crimes du national-socialisme, n'aient jamais mentionné ces chambres à gaz qui étaient par excellence l'arme de destruction massive des juifs ? » ou « Comment se fait-il que tant de juifs ― appelés par dérision 'juifs bruns' ― aient accepté dans les pays occupés par l'armée allemande ou dans les ghettos ou dans les camps de coopérer avec les Nazis ? » ou enfin « Que signifie ce silence général des nations et, en particulier, celui de la Suisse et celui du Comité international de la Croix-Rouge devant cet Holocauste alors en cours ? ». Ces questions et d'autres de même nature ont une réponse : le crime des crimes n'a pas été commis. Les juifs ont été traités par l'Allemagne nationale-socialiste comme des ennemis déclarés ou potentiels mais ils n'ont jamais été voués à l'extermination physique ; pendant une guerre totale où des millions de civils ont péri beaucoup de civils juifs sont morts mais beaucoup ont survécu. Plus de soixante-cinq ans après la guerre nous attendons toujours des estimations qui puissent être vérifiées.

Après la guerre, les survivants ou les miraculés juifs se sont comptés par millions, et cela au point de peupler un nouvel État, celui dit d'Israël, et de se disperser dans une cinquantaine de pays du vaste monde.

## Les temps changent et vite et profondément

« L'Holocauste » passera à l'histoire comme l'une des plus fabuleuses impostures de tous les temps. L'État d'Israël n'a dû jusqu'ici sa survie qu'à cette imposture qui, à ses yeux, justifie le vol d'un territoire, un cruel apartheid et la guerre perpétuelle : cet État va, lui aussi, à sa perte. Les organisations juives de la diaspora ont échoué. Leur arrogance, leurs pressions, leurs procédés de chantage, leurs constants appels à la répression contre ceux qui ouvrent, l'une après l'autre, les boîtes noires de « l'Holocauste » n'ont pu empêcher le développement à travers le monde d'un scepticisme et d'une lassitude généralisés à l'endroit des récits illustrant le caractère prétendument exceptionnel de l'incomparable souffrance juive. Les juifs dans leur ensemble ont eu de mauvais bergers, qui les mènent à l'abîme. Ils seraient bien inspirés d'écouter ceux d'entre eux, pour le moment en petit nombre, qui, à voix basse ou à voix haute, dénoncent la Grande Imposture de l'Holocauste, la Grande Imposture de l'État d'Israël et les Grands Faux Témoins du style d'Elie Wiesel.

Les révisionnistes ont découvert les sinistres boîtes noires de « l'Holocauste », les ont ouvertes et nous en ont déchiffré le contenu. Ils ont été en mesure de démasquer les apôtres ou les disciples d'une religion séculière fondée sur l'orgueil, le mensonge, la haine et la cupidité. A l'ensemble des hommes, sans distinction, les révisionnistes peuvent apporter un soulagement : ils nous apprennent que, bien que capable de toutes les horreurs, l'humanité n'a tout de même jamais commis l'innommable massacre que, depuis plusieurs générations, certains osent lui reprocher à chaque heure du jour ou de la nuit en exigeant toujours plus de compensations financières, toujours plus de privilèges. Nous voici aujourd'hui face à une religion séculière, celle de « l'Holocauste « ou de « la Shoah » qui à jamais restera dans l'histoire comme le déshonneur des hommes. Cette religion a pris naissance dans le monde occidental, s'y est développée avec une rapidité fulgurante mais déjà va vers sa décrépitude. Le reste du monde n'en veut pas et même parfois la rejette expressément. L'Occident « judéo-chrétien » devra s'en aviser et suivre l'exemple que lui donne le reste du monde.

11 septembre 2011

------------------------------------------------------------------------

[1] Les portions en italique ne figurent pas dans l'édition anglaise. Selon un chercheur américain, la traductrice, Marion Wiesel, l'épouse d'Elie Wiesel, avait déjà par le passé délibérément altéré la traduction de certains mots et, dans plusieurs passages de La Nuit, elle en avait ainsi usé pour rectifier les confusions dans la chronologie du récit. Ce chercheur, qui maîtrise parfaitement le français, nous apprend également que, comme c'est ici le cas, Marion Wiesel a parfois choisi d'omettre certains mots ou certaines phrases dans l'idée qu'une traduction fidèle donnerait l'éveil au lecteur de langue anglaise qui découvrirait alors qu'après tout E. Wiesel n'est pas un témoin digne de foi.

Labels: Arno Mayer, Bergen-Belsen, Butz, chambres à gaz, Charles Gray, Eichmann, Elie Wiesel, Hilberg, Himmler, Irving, Josef Kramer, Marion Wiesel, Nuremberg, Richard Krege, six millions, van Pelt, Wilhelm Höttl
