<!-- http://robertfaurisson.blogspot.com/1993/11/les-temoins-des-chambres-gaz-dauschwitz.html -->

<!-- Wednesday, November 10, 1993 -->

Les témoins des chambres à gaz d'Auschwitz

RÉSUMÉ : Un témoignage doit toujours être vérifié. Il existe deux moyens essentiels de vérifier un témoignage en matière criminelle : la confrontation du témoignage avec les éléments matériels (en particulier avec l'expertise de l'arme du crime) et le contre-interrogatoire minutieux du témoin sur ce qu'il prétend avoir vu. Or, dans les procès où il a été question des chambres à gaz homicides d'Auschwitz, aucun magistrat, ni aucun avocat n'ont réclamé ne fût-ce qu'une expertise de l'arme du crime ; par ailleurs, aucun avocat n'a contre-interrogé les témoins en leur demandant de décrire avec précision un seul de ces abattoirs chimiques. Cela jusqu'en 1985. Lorsqu'enfin, en 1985, à Toronto, au premier procès Zündel, des témoins ont été contre-interrogés sur ces sujets, leur déroute a été totale. A cause de cet échec retentissant et en raison d'autres échecs antérieurs ou postérieurs à 1985, les défenseurs de la thèse de l'extermination des juifs ont commencé à abandonner une histoire d'Auschwitz essentiellement fondée sur les témoignages et ils s'efforcent, à l'heure actuelle, de lui substituer une histoire scientifique ou, du moins, d'apparence scientifique, fondée sur la recherche des faits et des preuves. «L'histoire-témoignage» d'Auschwitz à la manière d'Elie Wiesel et de Claude Lanzmann est discréditée. Elle a fait son temps. Il reste aux exterminationnistes à essayer de travailler comme les révisionnistes sur les faits et sur les preuves.

Dans la présente étude, «chambres à gaz» s'entend au sens de «chambres à gaz homicides » ou « chambres à gaz nazies ». Par « Auschwitz», il faut comprendre aussi bien Auschwitz-I ou Auschwitz Stammlager qu'Auschwitz-II ou Birkenau. Enfin, par «témoins des chambres à gaz», je désigne indifféremment ceux qui prétendent avoir assisté à une opération de gazage homicide en ces lieux et ceux qui se contentent de dire qu'ils y ont vu ou aperçu une chambre à gaz homicide. Enfin, par «témoins», j'entends ceux qu'on désigne habituellement comme tels, qu'il s'agisse de témoins judiciaires ou de témoins médiatiques ; les premiers se sont exprimés sous serment à la barre d'un tribunal tandis que les seconds ont porté témoignage dans des livres, des articles, des films, à la télévision ou à la radio. Il va de soi que certains témoins ont été, tour à tour, judiciaires et médiatiques.

Cette étude est dépourvue de toute considération psychologique ou sociologique sur les témoignages concernant les chambres à gaz d'Auschwitz ainsi que sur les raisons d'ordre physique, chimique, topographique, architectural, documentaire et historique pour lesquelles ces témoignages sont inacceptables. Elle vise surtout à mettre en évidence un point que les révisionnistes n'ont jusqu'ici pas relevé et qui est, pourtant, capital : jusqu'en 1985 aucun témoin judiciaire de ces chambres à gaz n'a été contre-interrogé sur la matérialité des faits rapportés ; quand, en 1985, à Toronto, au premier procès Zündel, j'ai pu obtenir que de tels témoins fussent, enfin, contre-interrogés, ils se sont effondrés ; depuis cette date, il ne s'est plus présenté devant les tribunaux de témoins des chambres à gaz sauf peut-être au procès Demjanjuk en Israël où, là encore, les témoignages se sont révélés faux.

Pour commencer, je m'attarderai sur les graves motifs pour lesquels, dès 1983, Simone Veil [1] a été conduite à reconnaître qu'il n'existait pas de témoin des chambres à gaz.

La thèse de Simone Veil

Après la fin de la guerre s'était progressivement accréditée l'illusion que les témoins des chambres à gaz d'Auschwitz étaient innombrables. A la fin des années soixante-dix, avec l'arrivée du révisionnisme historique sur la scène médiatique, particulièrement en France, il commençait d'apparaître à certains que ces témoins n'étaient peut-être pas aussi nombreux qu'on l'aurait cru. C'est ainsi que, lors des préparatifs du grand procès que m'intentaient les organisations juives, leurs avocats et, en particulier, Robert Badinter, futur ministre de la Justice, éprouvèrent au début des années quatre-vingt les plus grandes difficultés à découvrir des preuves et des témoins. Prenant leur bâton de pèlerin, ils durent se rendre en Pologne et en Israël pour en ramener, si possible, ce qu'ils ne trouvaient pas en France. Peine perdue. Vint mon procès, d'abord en première instance (1981) puis en appel (1983). Pas un seul témoin ne prit le risque de comparaître à la barre. Le 26 avril 1983, la cour d'appel de Paris rendit son arrêt. J'étais, certes, condamné, comme on pouvait s'y attendre, pour «dommage à autrui», c'est-à-dire en fait pour dommage causé aux juifs par l'exposé de mes thèses dans la grande presse. Mais la cour assortissait cette condamnation de remarques propres à jeter la consternation dans le camp de mes adversaires. Mon travail était jugé sérieux mais dangereux. Il était dangereux parce que, de l'avis des magistrats, je laissais, paraît-il, à d'autres personnes la possibilité d'exploiter mes découvertes à des fins répréhensibles ! Toutefois ce même travail était sérieux en ce sens que, de l'avis de la cour, on n'y décelait ni négligence, ni légèreté, ni ignorance délibérée, ni mensonge, et cela contrairement à ce qu'avait affirmé la partie adverse qui m'avait accusé de «dommage à autrui par falsification de l'histoire» (sic).

Au sujet des témoignages, la cour allait jusqu'à prononcer :

Les recherches de M. Faurisson ont porté sur l'existence des chambres à gaz qui, à en croire de multiples témoignages, auraient été utilisées durant la seconde guerre mondiale pour mettre à mort de façon systématique une partie des personnes déportées par les autorités allemandes [souligné par moi].

La cour résumait parfaitement ce qu'elle appelait ma «démarche logique » et mon « argumentation» en précisant que, pour moi,

l'existence des chambres à gaz, telles que décrites habituellement depuis 1945, se heurte à une impossibilité absolue, qui suffirait à elle seule à invalider tous les témoignages existants ou à tout le moins à les frapper de suspicion [souligné par moi].

Enfin, la cour, tirant une conclusion pratique de ces considérants, décrétait le droit pour tout Français de ne plus croire aux preuves et aux témoins des chambres à gaz. Elle prononçait :

La valeur des conclusions défendues par M. Faurisson [quant au problème des chambres à gaz] relève donc de la seule appréciation des experts, des historiens et du public.

Deux semaines plus tard, Simone Veil réagit publiquement à cette décision de justice ― bouleversante pour elle et pour ses coreligionnaires ― par une déclaration d'une importance extrême. Elle admit l'absence de preuves, de traces et même de témoins des chambres à gaz, mais ajouta que cette absence s'expliquait facilement car :

Chacun sait [affirmait-elle] que les nazis ont détruit ces chambres à gaz et supprimé systématiquement tous les témoins.

Pour commencer, « chacun sait » n'est pas un argument digne d'une juriste. Ensuite, S. Veil, croyant peut-être se tirer d'affaire, aggravait son cas ; en effet, pour soutenir ce qu'elle affirmait, il lui aurait fallu prouver non seulement que les chambres à gaz avaient existé mais que les nazis les avaient détruites et qu'ils avaient supprimé tous les témoins : vaste entreprise criminelle dont on se demande sur quel ordre, quand, avec qui et par quels moyens les Allemands l'auraient menée dans le plus grand secret.

Mais qu'importe ! On prendra acte de cette concession de S. Veil : il n'y a ni preuve, ni traces, ni témoins des chambres à gaz. Il va de soi que, pour tenter de rassurer son monde, S. Veil enrobait cette surprenante concession de remarques conventionnelles. Voici donc, en propres termes, ce qu'elle confiait dans une « interview-événement » de France-Soir Magazine dont le titre était : «La mise en garde de Simone Veilà propos des carnets de Hitler : "On risque de banaliser le génocide"» :

Ce qui me frappe aujourd'hui, c'est le paradoxe de la situation : on publie un journal attribué à Hitler avec grand renfort de publicité et beaucoup d'argent sans, semble-t-il, prendre de grandes précautions pour s'assurer de son authenticité, mais, dans le même temps, au cours d'un procès intenté à Faurisson pour avoir nié l'existence des chambres à gaz, ceux qui intentent le procès sont contraints d'apporter la preuve formelle de la réalité des chambres à gaz. Or chacun sait que les nazis ont détruit ces chambres à gaz et supprimé systématiquement tous les témoins [2].

Un choix aussi lourd de conséquences que celui de S. Veil ne s'expliquait pas seulement par le désastre du 26 avril 1983 mais par toute une série d'événements qui, pour elle, avaient fait de 1982 une année noire sur le plan de l'histoire des chambres à gaz et de la crédibilité des témoins. Je ne rappellerai ici que trois de ces événements :

1) le 21 avril 1982, des historiens, des personnalités politiques et d'anciens déportés avaient fondé à Paris une association ayant pour objet la recherche de preuves de l'existence et du fonctionnement des chambres à gaz (ASSAG : Association pour l'étude des assassinats par gaz sous le régime national-socialiste) ; un an plus tard, cette association n'avait toujours pas découvert de preuve [c'est encore le cas aujourd'hui en 1993, puisque, prévue, selon ses statuts, pour une «durée limitée à la réalisation de son objet», cette association existe toujours] ;

2) en mai 1982, le ministère des Anciens combattants avait lancé à Paris une importante «Exposition de la déportation 1933-1945» ; cette exposition devait ensuite faire le tour de la France ; je diffusais immédiatement un texte dans lequel je démontrais le caractère fallacieux de cette exposition : aucune preuve ― sinon une preuve frauduleuse ― ni aucun témoignage précis de l'existence des chambres à gaz nazies n'avaient pu être montrés aux visiteurs ; aussi, Mlle Jacobs, responsable de cette initiative au ministère, faisait-elle immédiatement supprimer cette exposition itinérante ;

3) du 29 juin au 2 juillet 1982 s'était tenu à la Sorbonne un colloque international sur «l'Allemagne nazie et l'extermination des juifs» ; ce colloque avait été annoncé comme une réplique décisive à l'offensive révisionniste en France ; il devait se clore sur une retentissante conférence de presse. La réalité avait été toute différente : le jour de l'ouverture, nous avions distribué dans le hall de la Sorbonne des exemplaires, tout récents, de ma Réponse à Pierre Vidal-Naquet (ce qui n'allait pas sans risques pour nous) ; le colloque allait se dérouler à huis clos et dans une atmosphère houleuse ; enfin, lors de la conférence de presse, les deux organisateurs du colloque, les historiens François Furet et Raymond Aron, n'allaient même pas prononcer l'expression de «chambre(s) à gaz».

Je dis souvent que c'est à cette date du 2 juillet 1982 que le mythe des chambres à gaz nazies et de leurs témoins est mort ou est entré en agonie, du moins sur le plan de la recherche historique. En plein cœur de la Sorbonne, on avait ainsi découvert avec consternation l'absence de toute preuve solide et de tout témoin digne de foi. Or, on avait auparavant claironné que ce colloque mettrait fin aux «inepties de Faurisson» par la production d'une foule de preuves et de témoignages. Un tel silence après un tel fracas était éloquent.

Le témoignage écrit de Fajnzylberg-Jankowski

J'ai dit plus haut qu'à mon procès pas un seul témoin ne prit le risque de comparaître devant le tribunal. A la dernière minute, l'accusation avait tout de même fourni le témoignage écrit d'un juif qui vivait à Paris mais qu'on s'était bien gardé d'amener à la barre. Ce juif était le fameux Alter Szmul Fajnzylberg, né à Stockek (Pologne) le 23 octobre 1911. Cet ancien garçon de café, polonais, juif athée, communiste, délégué politique des brigades internationales en Espagne, avait été interné pendant trois ans dans le camp d'Auschwitz-Birkenau.

Dans son bref témoignage écrit, il affirmait essentiellement que, travaillant au crématoire d'Auschwitz (Altes Krematorium ou Krematorium-I), il avait passé une bonne partie de son temps enfermé, avec ses camarades, dans la cokerie, car, à chaque fois que les SS gazaient des juifs dans la pièce d'à côté, ils prenaient la précaution de séquestrer le Sonderkommando dans la cokerie pour qu'aucun juif ne pût constater de visu l'opération de gazage ! Une fois l'opération de gazage achevée, les Allemands libéraient les membres du Sonderkommando et leur faisaient ramasser et incinérer les victimes. Ainsi, aux mêmes personnes, les Allemands auraient dissimulé le crime et révélé le résultat du crime !

Ce témoin non oculaire est également connu sous les noms d'Alter Feinsilber, de Stanislaw Jankowski ou de Kaskowiak. On peut lire son témoignage sous une autre forme dans les Cahiers d'Auschwitz [3].

La défaite des témoins au premier procès Zündel (1985)

L'importante victoire remportée le 26 avril 1983 par le révisionnisme en France allait se confirmer en 1985 avec le premier procès Zündel à Toronto. Je voudrais m'arrêter un instant à ce procès pour en souligner la portée à tous les points de vue et, spécialement en ce qui concerne les témoignages sur les chambres à gaz d'Auschwitz : pour la première fois depuis la guerre, des témoins juifs allaient subir un contre-interrogatoire normal. Par ailleurs, sans vouloir minimiser l'importance du second procès Zündel (celui de 1988), je voudrais que l'on comprenne que le procès de 1985 contient déjà en germe tous les acquis du procès de 1988, y compris le Rapport Leuchter et tous les rapports scientifiques qui, par la suite, allaient proliférer dans le sillage du rapport Leuchter.

En 1985, comme d'ailleurs, par la suite, en 1988, j'ai été le conseiller d'Ernst Zündel et de son avocat Douglas Christie. En 1985, je n'avais accepté cette lourde responsabilité qu'à la condition que tous les témoins juifs seraient, pour la première fois, contre-interrogés sur la matérialité des faits rapportés, et cela sans ménagements particuliers. J'avais, en effet, noté que, de 1945 à 1985, les témoins juifs avaient bénéficié d'un véritable privilège. Jamais aucun avocat de la défense n'avait pensé ou osé leur demander des explications matérielles sur les chambres à gaz (localisation précise, apparence physique, dimensions, structure interne et externe) ou sur les gazages homicides (procédure de l'opération de son début jusqu'à sa fin, instruments utilisés, précautions prises par les exécutants avant, pendant et après l'exécution). En de rares occasions, comme au procès Tesch, Drosihn et Weinbacher, des avocats avaient formulé de rares questions d'ordre matériel, quelque peu embarrassantes pour le témoin, mais celles-ci se situaient toujours en marge des questions centrales qu'il aurait fallu poser [4]. Aucun avocat n'avait exigé d'éclaircissements sur une arme qu'il n'avait pourtant jamais vue et qu'on ne lui avait jamais montrée. Au grand procès de Nuremberg (1945-1946), les avocats allemands avaient été sur ce point d'une totale discrétion. Au procès Eichmann de Jérusalem (1961), l'avocat Dr Robert Servatius n'avait pas voulu soulever la question ; dans une correspondance sur le sujet, il m'écrivait : «Eichmann hat selbst keine Gaskammer gesehen ; die Frage wurde nicht diskutiert ; er hat sich aber auch nicht gegen deren Existenz gewandt» [Eichmann lui-même n'a pas vu de chambre à gaz ; la question n'a pas été discutée ; mais il n'a pas non plus remis en cause leur existence] (21 juin 1974).

Au procès de Francfort (1963-1965), les avocats se montrèrent particulièrement timides ; il faut dire que l'atmosphère fut irrespirable pour la défense et pour les accusés. Ce procès à grand spectacle restera comme une tache sur le blason de la justice allemande et sur la personne de Hans Hofmeyer, d'abord Landgerichtsdirektor, puis Senatspräsident. Pendant plus de cent quatre-vingts sessions, les juges et les jurés, le ministère public et les parties civiles, les accusés et leurs avocats, ainsi que des journalistes venus du monde entier, acceptèrent que, pour toute représentation physique de «l'arme du crime», on leur fournît seulement une carte du camp d'Auschwitz et une carte du camp de Birkenau où figuraient, à l'emplacement des prétendues chambres à gaz homicides, cinq minuscules figures géométriques avec les mots, pour Auschwitz, d'« Altes Krematorium » et, pour Birkenau, de «Krematorium-II », « Krematorium-III », « Krematorium-IV » et « Krematorium-V» ! Ces cartes étaient exposées dans le prétoire [5]. On a souvent, chez les révisionnistes, comparé le procès de Francfort aux procès de sorcellerie des années 1450-1650. Cependant, au moins, dans ces procès-là, se donnait-on parfois la peine de décrire ou de dessiner les sabbats de sorcellerie. Au procès de Francfort, même parmi les avocats qui mirent en difficulté un témoin comme Filip Müller, pas un ne demanda à un témoin juif ou à un accusé allemand repenti de lui décrire plus en détail ce qu'il prétendait avoir vu. Malgré deux descentes de justice sur les lieux du crime, à Auschwitz, avec quelques avocats allemands, pas un seul de ces derniers n'exigea, semble-t-il, d'explication technique ou d'expertise criminologique de l'arme du crime. Au contraire, l'un d'entre eux, Anton Reiners, avocat à Francfort, poussa la complaisance jusqu'à se faire photographier par la presse en train de soulever le couvercle de la trappe par laquelle, disait-on, les SS déversaient les granulés de Zyklon B dans la prétendue chambre à gaz d'Auschwitz.

Aussi, à Toronto, en 1985, étais-je bien décidé à rompre avec ces anomalies, à briser le tabou et, pour commencer, à poser ou, plutôt, à faire poser par l'intermédiaire de D. Christie aux experts et aux témoins juifs les questions qu'on pose normalement dans tout procès où l'on est censé établir si un crime a été commis et, si oui, par qui, quand et comment. Heureusement pour moi, E. Zündel acceptait mes conditions et D. Christie consentait à adopter cette ligne de conduite et à poser aux experts et aux témoins les questions que je lui préparerais. J'étais convaincu que, de cette manière, tout pouvait changer et que le voile tissé par tant de faux témoignages se déchirerait. Je ne comptais pas pour autant sur l'acquittement d'E. Zündel et nous étions tous résignés à payer le prix de notre audace mais j'avais l'espoir qu'avec l'aide de cet homme de caractère aux vues si profondes et grâce à son intrépide avocat, l'histoire, sinon la justice, l'emporterait enfin sur la légende.

Dès le premier contre-interrogatoire, un vent de panique se mit à souffler dans les rangs de l'accusation. Tous les soirs et pendant une grande partie de la nuit, je préparais les questions à poser. Le matin, je remettais ces questions, accompagnées des dossiers nécessaires, à l'avocat D. Christie qui, de son côté, avec l'aide de sa collaboratrice, menait une tâche essentiellement juridique. Lors des séances de contre-interrogatoire, je me tenais tout contre le pupitre de l'avocat et, inlassablement, lui fournissais, sur des étiquettes collantes, les questions supplémentaires à improviser selon les réponses de l'expert ou du témoin.

L'expert cité par l'accusation était le Dr Raul Hilberg, l'auteur de The Destruction of the European Jews. Il eut à subir, jour après jour, une telle humiliation que, sollicité en 1988 par un nouveau procureur pour un nouveau procès contre E. Zündel, il refusa de revenir témoigner ; il motiva son refus dans une lettre confidentielle où il avouait sa crainte d'avoir à affronter à nouveau les questions de D. Christie. Du contre-interrogatoire du Dr Raul Hilberg il était ressorti qu'en définitive on ne possédait aucune preuve de l'existence soit d'un ordre, soit d'un plan, soit d'une instruction, soit d'un budget pour la prétendue entreprise d'extermination physique des juifs ; on ne possédait non plus ni une expertise de l'arme du crime (chambre à gaz ou camion à gaz) ni un rapport d'autopsie établissant le meurtre d'un détenu par gaz-poison. Mais, à défaut de preuves, d'arme et de cadavre, existait-il des témoins du crime ?

Un témoignage doit toujours être vérifié. Le premier moyen usuel de procéder à cette vérification est de confronter les assertions du témoin avec les résultats d'enquêtes ou d'expertises portant sur la matérialité du crime. Dans le cas présent, il n'y avait eu ni enquêtes ni expertises sur les prétendues chambres à gaz d'Auschwitz. Voilà qui rendait difficile tout contre-interrogatoire. Mais, cette difficulté ne devait pas servir d'excuse et, même, un contre-interrogatoire devenait d'autant plus indispensable car, sans lui, il ne restait plus aucun moyen de savoir si le témoin disait vrai ou faux.

Des témoins juifs enfin contre-interrogés :

A. Friedman et Dr R. Vrba

Aux personnes intéressées par les moyens techniques et documentaires grâce auxquels nous fûmes néanmoins en mesure de sévèrement contre-interroger les deux principaux témoins juifs Arnold Friedman et le Dr Rudolf Vrba, je ne peux que recommander la lecture de la transcription du procès de 1985 [6]. Les pages 304-371 retracent l'interrogatoire et le contre-interrogatoire d'Arnold Friedman ; ce dernier s'effondre aux pages 445-446 quand il finit par avouer qu'il n'a en fait rien vu, qu'il a parlé par ouï-dire parce que, disait-il, il avait rencontré des personnes convaincantes ; peut-être, ajoutait-il, aurait-il adopté la position de D. Christie plutôt que celle de ces personnes si D. Christie avait pu lui dire à l'époque ce qu'il lui disait maintenant !

Le Dr Vrba était un témoin d'une exceptionnelle importance. On peut même dire qu'à ce procès de Toronto l'accusation avait trouvé le moyen de recruter en matière d' « Holocauste» l'expert n° 1 avec le Dr Hilberg et le témoin n° 1 avec le Dr Vrba. Le témoignage de ce dernier avait été l'une des principales sources du fameux War Refugee Board Report sur les German Extermination Camps ― Auschwitz and Birkenau, publié en novembre 1944 par l'Executive Office of the President [Roosevelt]. Le Dr R. Vrba était également l'auteur de I Cannot Forgive, écrit en collaboration avec Alan Bestic qui, dans sa préface, déclarait à son propos : «Indeed I would like to pay tribute to him for the immense trouble he took over every detail; for the meticulous, almost fanatical respect he revealed for accuracy [7]. »

Jamais peut-être une cour de justice ne vit-elle un témoin s'exprimer avec autant d'assurance sur les chambres à gaz d'Auschwitz. Mais, au terme du contre-interrogatoire, la situation se renversa au point que le Dr Vrba n'eut plus qu'une explication pour ses erreurs et ses mensonges : dans son livre il avait, reconnaissait-il, eu recours à la «poetic licence» ou, comme il se plut à le dire en latin, à la « licentia poetarum » !

Un coup de théâtre se produisit à la fin : le procureur Griffiths lui-même, qui avait fait venir ce témoin n° 1, apparemment excédé par les mensonges du Dr R. Vrba, le fusilla de la question suivante :

You told Mr. Christie several times in discussing your book I Cannot Forgive that you used poetic licence in writing that book. Have you used poetic licence in your testimony ? [8]

Le faux témoin essaya de parer le coup mais le procureur Griffiths l'acheva d'une seconde question tout aussi perfide concernant, cette fois, les chiffres de gazés donnés par Vrba ; le témoin répondit par des bavardages ; Griffiths s'apprêtait à lui poser une troisième et dernière question quand, soudain, l'affaire tourna court et l'on entendit le procureur dire au juge : «I have no further questions for Dr. Vrba [9]. »

La mine décomposée, le témoin quitta la barre. L'interrogatoire, le contre- interrogatoire et le réinterrogatoire de ce personnage occupent quatre cents pages de la transcription [10]. Ces pages pourraient figurer dans une encyclopédie du droit au chapitre des méthodes de détection du faux témoignage.

L'accusation renonce à convoquer des témoins

Trois ans plus tard, en 1988, lors du second procès contre E. Zündel, le ministère public jugea prudent d'abandonner tout recours à un témoin. La justice canadienne avait apparemment compris la leçon du premier procès : il n'existait pas de témoin véritable de l'existence et du fonctionnement des chambres à gaz nazies.

Tous les autres pays du monde ont peu à peu compris la leçon. En 1987, en France, au procès de Klaus Barbie, on parla des chambres à gaz d'Auschwitz mais on ne produisit pas de témoins à proprement parler de ces chambres à gaz. L'avocat Jacques Vergès, courageux mais non téméraire, préféra esquiver le sujet. Ce fut une chance pour les avocats juifs qui ne craignaient rien tant que de me voir apparaître aux côtés de J. Vergès. Si ce dernier avait accepté mon offre de le conseiller, nous aurions pu porter en France un redoutable coup au mythe des chambres à gaz.

Toujours en France, lors de quelques procès révisionnistes, des témoins juifs sont quelquefois venus évoquer ces chambres à gaz mais aucun n'a attesté, à la barre, en avoir vu une ou avoir assisté à un gazage homicide.

Aujourd'hui, les témoins des chambres à gaz se font extrêmement rares et le procès Demjanjuk en Israël, qui a, une fois de plus, révélé combien le faux témoignage était courant en la matière, a contribué à cette mutation. Il y a encore quelques années, il m'arrivait de me faire interpeller agressivement dans le fond du prétoire par de vieux juifs qui se présentaient à moi comme des «témoins vivants des chambres à gaz d'Auschwitz» ; ils me montraient leurs tatouages. Il me suffisait de leur demander de me regarder dans les yeux et de me décrire une chambre à gaz pour qu'immanquablement ils me rétorquent : «Comment le pourrais-je ? Si j'avais vu une chambre à gaz de mes propres yeux, je ne serais pas là aujourd'hui à vous parler ; j'aurais, moi aussi, été gazé». Ce qui, comme on le voit, nous ramène à Simone Veil et à sa déclaration du 7 mai 1983, dont nous avons vu ce qu'il faut penser.

Les témoins médiatiques

A côté des témoins judiciaires, il existe des témoins médiatiques des chambres à gaz ou des gazages homicides d'Auschwitz ou de Birkenau. On songe ici aux noms d'Olga Lengyel, Gisela Perl, Fania Fénelon, Ota Kraus, Erich Kulka, Hermann Langbein, André Lettich, Samuel Pisar, Maurice Benroubi, André Rogerie, Robert Clary... Ma bibliothèque est pleine de ces récits qui se copient les uns les autres. Paul Rassinier a été le premier à nous indiquer de quelle manière pouvait se démontrer la fausseté de ces témoignages ; il l'a notamment fait, pour Auschwitz, dans Le Véritable Procès Eichmann ou les Vainqueurs incorrigibles où l'appendice V est consacré à Médecin à Auschwitz de Miklos Nyiszli.

Dans les années cinquante à quatre-vingt, il y avait quelque intérêt pour les révisionnistes à entreprendre de telles études critiques des témoignages. Aujourd'hui, il me semble que cet exercice est devenu superflu. Abstenons-nous de tirer sur les ambulances et laissons aux exterminationnistes eux- mêmes et à Jean-Claude Pressac, en particulier, le soin de critiquer cette sous-littérature car ― ainsi qu'on peut le constater aujourd'hui ― les plus farouches antirévisionnistes se mettent enfin à l'école révisionniste. Le résultat est parfois plein de sel. En octobre 1991, le périodique Le Déporté pour la liberté, organe de l'Union nationale des associations de déportés, internés et familles de disparus (UNADIF), annonçait en première page : «En pages centrales de ce numéro, première partie du témoignage de Henry Bily, l'un des rares rescapés d'un Sonderkommando. » Dans sa livraison de novembre 1991, H. Bily continuait le récit de son expérience d'Auschwitz sous le titre de «Mon histoire extraordinaire».

Or, dans la livraison suivante du Déporté pour la liberté, celle de décembre 1991-janvier 1992, paraissait une «Mise au point après l'insertion dans nos colonnes du texte d'Henry Bily». La direction et la rédaction de la publication révélaient le faux : H. Bily avait, dans la plus grande partie de son témoignage, procédé à :

la copie intégrale sans aucune mention de références, de passages (notamment des chapitres 7 et 28) du livre du Dr Myklos Nyiszli : Médecin à Auschwitz, écrit en 1946 et traduit et publié en 1961 aux éditions René Julliard. Malencontreusement, les erreurs commises à l'origine par le Dr Nyiszli ont été, elles aussi, reprises ; enfin, l'emprunt le plus long porte sur la description du fonctionnement du Sonderkommando d'Auschwitz-Birkenau, dans lequel Henry Bily déclare [s. e. mensongèrement] avoir travaillé...

Il résulte de cette analyse qu'il n'est possible, en au- cune manière, de considérer le texte d'Henry Bily comme un témoignage original et personnel.

A un lecteur attentif de ce communiqué, la phrase «Malencontreusement, les erreurs commises à l'origine par le Dr Nyiszli ont été, elles aussi, reprises » pouvait laisser entrevoir que, pour comble de malheur, H. Bily, marchand de cravates juif, avait recopié un témoignage qui, par lui-même, était déjà un faux. Depuis longtemps, P. Rassinier avait, comme je viens de le dire, prouvé que Médecin à Auschwitz, œuvre chère à Jean-Paul Sartre qui, en 1951, en avait publié des fragments dans Les Temps modernes, ne pouvait être qu'une imposture des plus grossières. Bien des révisionnistes, et en particulier Carlo Mattogno, ont ensuite confirmé ce diagnostic. Pour ma part, dans mon compte rendu du livre de Jean-Claude Pressac Auschwitz: Technique and Operation of the Gas Chambers, j'ai glissé un développement intitulé : « Drôlerie [involontaire] de Pressac à propos de M. Nyiszli ». Je me permets d'y renvoyer les amateurs de faux témoignages sur Auschwitz, faux témoignages que J.-C. Pressac, à force de contorsions, d'inventions laborieuses et de spéculations oiseuses, cherche à défendre à tout prix mais que, sans le vouloir, il discrédite pour toujours [11].

Les faux témoins Élie Wiesel et Primo Levi

Sur Élie Wiesel et Primo Levi quelques mots s'imposent.

Sur le premier, je renvoie à mon article «Un grand faux témoin : Élie Wiesel» ainsi qu'à «Un grand faux témoin : Élie Wiesel (suite)». Dans La Nuit, compte rendu biographique en particulier de son internement à Auschwitz et à Buchenwald, É. Wiesel ne mentionne même pas les chambres à gaz mais il appert que, par une sorte de convention médiatique universelle, on le tient pour le témoin par excellence de l' « Holocauste» et des chambres à gaz. Selon lui, si les Allemands exterminaient des foules de juifs, c'était en les précipitant dans des brasiers ou des fournaises ! La fin de son témoignage comporte un épisode extrêmement curieux sur lequel j'attends depuis des an- nées qu'Élie Wiesel veuille bien nous fournir une explication : en janvier 1945, nous raconte-t-il, les Allemands lui laissèrent, ainsi qu'à son père, le choix entre rester au camp pour y attendre l'arrivée des Soviétiques ou partir avec les troupes allemandes ; après s' être concertés, le père et le fils décidèrent de partir avec leurs exterminateurs pour l'Allemagne au lieu d'attendre sur place leurs libérateurs soviétiques [12]...

Curieusement, depuis quelques années, Primo Levi a, de manière posthume, accédé dans les médias au premier rang des témoins des chambres à gaz d'Auschwitz. Il est l'auteur de Si c'est un homme. La première partie du livre est la plus longue et la plus importante ; elle comprend cent quatre-vingts pages (p. 7-186) et a été rédigée en 1947 ; l'auteur dit, dès la page 19, que c'est après la guerre qu'il a appris le gazage des juifs à Birkenau ; lui-même travaillait à Buna-Monowitz et n'avait jamais mis les pieds à Birkenau ; aussi ne parle-t-il qu'en termes extrêmement vagues et seulement à six reprises de «la» chambre à gaz et à une seule reprise des «chambres à gaz» [13] ; il se contente de la mentionner, toujours au singulier et comme une rumeur dont « tout le monde parle [14] ». Soudain, dans son « Appendice », écrit en 1976, soit près de trente ans plus tard, les chambres à gaz font une entrée en force : en l'espace de vingt-six pages qui, vu leur typographie plus resserrée, peuvent être comptées pour trente pages, l'auteur les mentionne à onze reprises [15] ; à deux reprises, il parle de «gaz» et à neuf reprises de «chambres à gaz» (toujours au pluriel) ; il écrit comme s'il les avait vues : « Les chambres à gaz étaient en effet camouflées en salles de douches avec tuyauteries, robinets, vestiaires, portemanteaux, bancs, etc. [16]. » Il ne craint pas d'écrire encore : « Les chambres à gaz et les fours crématoires avaient été délibérément conçus pour détruire des vies et des corps humains par millions ; l'horrible record en revient à Auschwitz, avec vingt-quatre mille morts en une seule journée au mois d'août 1944 [17]. »

Élie Wiesel et Primo Levi ne sont pas les seuls à avoir ainsi «enrichi» leurs souvenirs.

Primo Levi était ingénieur chimiste. Sur son naufrage ou son délire au point de vue scientifique dans Si c'est un homme, on consultera, de Pierre Marais, En lisant de près les écrivains chantres de la Shoah. Primo Levi, Georges Wellers, Jean-Claude Pressac ; voy., en particulier, «Le chimiste, la batterie de camion et... les chambres à gaz » (p. 7-21), chapitre qui concerne Primo Levi. Ce dernier s'est suicidé ou est mort accidentellement le 11 avril 1987. C'est à sa qualité de juif qu'il avait dû de n'être pas fusillé lorsqu'il avait été fait prisonnier par la Milice fasciste le 13 décembre 1943, à l'âge de vingt- quatre ans. «Les fascistes l'avaient capturé en tant que partisan (il avait enco- re un pistolet sur lui), et il s'était déclaré juif afin de n'être pas fusillé immédiatement. Et c'est en tant que juif qu'il fut livré aux Allemands. Les Allemands l'envoyèrent à Auschwitz [...] [18]. »

Conclusion

De 1945 à 1985, les prétendus témoins judiciaires des chambres à gaz d'Auschwitz ont bénéficié d'un extraordinaire privilège : on leur a toujours épargné l'épreuve du contre-interrogatoire sur la matérialité des faits qu'ils prétendaient rapporter. En 1985, au premier des deux procès Zündel, à Toronto, l'avocat Douglas Christie a bien voulu, sur ma suggestion et avec mon aide, contre-interroger selon la norme ce type de témoins. Le résultat en a été la déroute des témoins Arnold Friedman et Dr Rudolf Vrba. Cette déroute a été si grave qu'on ne trouve plus aujourd'hui de témoins pour prendre le risque d'affirmer à la barre d'un tribunal qu'ils on vu un gazage homicide à Auschwitz ou dans n'importe quel camp de concentration du IIIe Reich.

Les prétendus témoins médiatiques continuent de se répandre dans le monde de la radio, de la télévision et des livres, où ils ne courent guère le risque d'être mis en difficulté par des questions embarrassantes. Mais même ces témoins-là se font de plus en plus vagues et il peut leur arriver d'être dénoncés par des représentants de la thèse exterminationniste. Ces derniers se mettent, en effet, de plus en plus à l'école du révisionnisme parce qu'ils se rendent compte qu'ils ont jusqu'ici cautionné les mensonges de trop de faux témoins, des mensonges qui finissent par coûter cher à leur propre cause.

Comme il y a notoirement de plus en plus de risques à se présenter maintenant en témoin des chambres à gaz ― comme le faisait encore le juif Filip Müller en 1979 ― la solution qui tend à prévaloir aujourd'hui est celle que, dès le 7 mai 1983, Simone Veil avait dû adopter à la suite d'une décision de la cour d'appel de Paris du 26 avril 1983, estimant que mon travail sur le problème des chambres à gaz était sérieux, un travail où je démontrais que les prétendus témoignages se heurtaient à des impossibilités physico-chimiques radicales. La solution ou, plutôt, l'échappatoire préconisée par S. Veil consistait à dire que, s'il n'y avait effectivement ni preuves, ni traces, ni témoins du crime, c'est que les Allemands avaient détruit toutes les preuves, toutes les traces et tous les témoins. Une telle affirmation, outre qu'elle est absurde, aurait, à son tour, besoin de preuves que S. Veil ne fournit pas. Mais il importe peu. Prenons acte de cette affirmation et, après S. Veil et ceux qui, dans la pratique, semblent se rallier à sa thèse, prenons bonne note de cette évidence depuis longtemps mise au jour par les révisionnistes : non seulement il n'existe ni preuves, ni traces des chambres à gaz nazies, mais il n'en existe nul témoin.

Aujourd'hui, en cette fin d'année 1993, les témoignages sur les chambres à gaz d'Auschwitz sont discrédités y compris chez les exterminationnistes. L'histoire fondée sur les témoignages commence à laisser place à l'histoire fondée soit sur des faits, soit sur des arguments d'ordre scientifique.

C'est ce que j'avais préconisé dans mon article du Monde du 29 décembre 1978 et dans ma lettre au Monde du 16 janvier 1979.

Il aura fallu attendre plus de dix ans pour voir nos adversaires s'aventurer sur le terrain où je les invitais à venir se mesurer avec nous : le terrain scientifique.

J.-C. Pressac a été chargé, notamment par le couple Klarsfeld, de dénoncer «l'histoire-témoignage» et de lui substituer une histoire scientifique ou, du moins, d'apparence scientifique.

Claude Lanzmann et les tenants de «l'histoire-témoignage» en sont désespérés [19]. Les révisionnistes s'en félicitent. Un demi-siècle de témoignages non vérifiés doit maintenant laisser place, définitivement, à la recherche des faits et des preuves sur les plans judiciaire, scientifique et historique.

10 novembre 1993



[Ce texte constitue un chapitre de Grundlagen zur Zeitgeschichte, Ein Handbuch über strittige Fragen des 20. Jahrhunderts, ouvrage collectif publié en 1994 sous la direction d'Ernst Gauss [Germar Rudolf] aux éditions Grabert de Tübingen. Le texte original français est inédit. Le professeur Faurisson a également rédigé l'avant-propos de ce livre très important, qui est classé ici à sa date de rédaction, le 23 septembre 1994. ― NdÉ]

Notes

[1] S. Veil, ancien ministre de la Justice, ancienne présidente du Parlement européen.

[2] France-Soir Magazine, 7 mai 1983, p. 47.

[3] Hefte von Auschwitz, Sonderheft (I), 1972, S. 32-71.

[4] Sur le contre-interrogatoire du témoin Dr Charles Sigismund Bendel par l'avocat Dr Zippel, voy. «Excerpt from transcript of proceedings...», p. 30-31 (doc. NI-11953). Sur cet abominable procès, il est indispensable de lire : Dr William Lindsey, « Zyklon B, Auschwitz, and the Trial of Dr Bruno Tesch ». Cette étude a été reproduite en partie par Udo Walendy dans Historische Tatsachen.

[5] Pour une reproduction de ces deux cartes, voy. H. Langbein, Der Auschwitz- Prozess..., p. 930-933. Pour une étude magistrale du procès, voy. Dr Wilhelm Stäglich, Der Auschwitz-Prozess, Legende oder Wirklichkeit?.

[6] Queen vs. Zündel.

[7] Rudolf Vrba, I Cannot Forgive, p. 2 : «Je voudrais vraiment lui rendre hommage pour la peine immense qu'il a prise à propos de chaque détail ; pour le respect méticuleux, quasi fanatique qu'il a révélé pour l'exactitude.»

[8] Queen vs. Zündel, p. 1636 : «Vous avez dit à M. Christie plusieurs fois dans la discussion au sujet de votre livre Je ne puis pardonner que vous aviez utilisé la licence poétique en écrivant ce livre. Avez-vous utilisé la licence poétique dans votre témoignage à la barre ?»

[9] Id., p. 1643 : «Je n'ai pas d'autre question pour le Dr Vrba.»

[10] Id., p. 1244-1643.

[11] R. Faurisson, «Auschwitz : Technique and Operation of the Gas Chambers ou Bricolage et "gazouillages" à Auschwitz et à Birkenau selon J.-C. Pressac (1989)», Revue d'histoire révisionniste, n° 3, novembre 1990 ― janvier 1991, p. 65-154.

[12] É. Wiesel, La Nuit, p. 129-133. Un point qui ne manque pas d'intérêt : dans la traduction en allemand de ce livre (Die Nacht zu begraben, Elisha p. 17-153), les fours crématoires de la version originale française sont supprimés pour être remplacés par des chambres à gaz (y compris à Buchenwald). Je dois cette découverte au révisionniste suisse Jürgen Graf et c'est à une révisionniste allemande vivant en France, A.W., que je suis redevable de la liste des occurrences où le traducteur allemand a cru bon, à quinze reprises, de mettre du gaz là où il n'y en avait pas dans le texte original.

[13] P. Levi, Si c'est un homme, p. 19, 48, 51, 96, 135, 198 et 159.

[14] Id., p. 51.

[15] Id., p. 189-214 : p. 193 (deux fois), 198 (trois fois), 199, 201 (deux fois), 202, 209, 210.

[16] Id., p. 198.

[17] Id., p. 201-202.

[18] F. Camon, «Chimie. Levi, la mort».

[19] Voy., notamment, l'article signé de Robert Redeker qu'il a publié, dans sa revue Les Temps Modernes, sous le titre : « La Catastrophe du révisionnisme » (novembre 1993, p. 1-6) ; le révisionnisme y est présenté comme le signe catastrophique d'un changement d'époque : « Auschwitz » était ― et reste pour l'auteur ― une « mystique », c'est-à-dire une croyance entourée d'un respect religieux ; or, « Auschwitz » devient, dit-il en le déplorant, un sujet de considérations historiques et technologiques. Cet article était sous presse quand est paru dans L'Express tout un dossier sur le nouveau livre de J.-C. Pressac (23 septembre 1993, p. 76-80, 82-87). C. Lanzmann a protesté avec virulence contre cette tournure prise par l'histoire de l'« Holocauste ». Il écrit : « Même pour les réfuter, on légitime ainsi les arguments des révisionnistes, qui deviennent ce par rapport à quoi, à qui, tous se situent. Les révisionnistes occupent tout le terrain» (Le Nouvel Observateur, 30 septembre 1993, p. 97).

Labels: arrêt Grégoire, ASSAG, Auschwitz, Badinter, chambres à gaz, Demjanjuk, Douglas Christie, Germar Rudolf, Hilberg, Simone Veil, témoins, Vrba, Zündel
