<!-- http://robertfaurisson.blogspot.com/1994/02/les-chambres-gaz-des-penitenciers.html -->

<!-- Monday, February 28, 1994 -->

Les chambres à gaz des pénitenciers américains

Pour l'exécution des condamnés à mort, certains états des États-Unis emploient des chambres à gaz dites «execution gas chambers». Le produit utilisé est toujours le gaz cyanhydrique (hydrogen cyanide). Depuis 1922, c'est précisément ce gaz que les Allemands emploient pour la destruction des parasites dans les bâtiments, les navires, les silos... ou encore dans des chambres à gaz spéciales dites chambres à gaz de désinfection, de désinfestation ou d'épouillage. La dénomination commerciale du produit, à base d'acide cyanhydrique, est «Zyklon», qui veut dire «cyclone». Le plus répandu de ces produits s'appelle « Zyklon B ». La légende prétend que, pendant la seconde guerre mondiale, en particulier à Auschwitz, les Allemands se sont servis du Zyklon B non seulement comme insecticide mais aussi comme moyen chimique d'extermination physique des juifs.

Ceux qui, au procès de Nuremberg et dans d'autres procès du même genre, se sont permis de porter une aussi terrible accusation auraient dû exiger une expertise de l'arme du crime prétendument utilisée par les Allemands. Ils ne l'ont pas fait, sauf dans le cas du Struthof-Natzweiler (Alsace) où l'expertise du professeur René Fabre, en décembre 1945, a révélé que la prétendue chambre à gaz n'était pas une chambre à gaz homicide. Ils auraient également dû, pour comparaison, examiner les chambres à gaz des pénitenciers américains pour s'interroger sur la procédure à suivre en vue d'exécuter un individu avec du gaz cyanhydrique. Ils ne l'ont pas fait non plus. Mais le plus extraordinaire peut-être est que les révisionnistes eux-mêmes ne semblent pas avoir songé à entamer une recherche sur les chambres à gaz américaines. Les révisionnistes allemands, pourtant armés de toute la science allemande, surtout en matière de chimie, ont été particulièrement timides dans le domaine de l'investigation chimique et les révisionnistes américains, qui pourtant savaient que dans leur propre pays on exécutait des prisonniers avec du gaz cyanhydrique, ont, eux aussi, négligé l'argument chimique et, en particulier, l'argument des chambres à gaz américaines.

C'est vers 1977 que j'ai personnellement pensé qu'il était indispensable d'examiner ces chambres-là. Je connaissais déjà assez bien les procédés de désinfection, de désinfestation ou d'épouillage à l'aide du Zyklon B et j'avais notamment étudié sur ce sujet des documents relatifs aux chambres à gaz Degesch. Mais l'expérience m'avait appris à me méfier des raisonnements par analogie. Du fait qu'on sait comment utiliser le gaz cyanhydrique pour désinfecter une matière morte comme des tissus ou des vêtements, il ne s'ensuit pas qu'on sache comment tuer des êtres vivants avec ce même gaz. Vers le milieu de 1978, je me tournais vers un avocat américain, Eugene Brugger, pour lui demander d'entreprendre une enquête auprès des pénitenciers possédant des chambres à gaz. E. Brugger apporta à ses investigations le plus grand soin. Il adressa à ces pénitenciers deux questionnaires minutieux. Il reçut de six d'entre eux des réponses qu'il me communiqua. A la simple lecture des réponses et des documents accompagnant celles-ci, il devenait d'une évidence implacable que les prétendues chambres à gaz nazies (« à l'état d'origine», «reconstruites» ou «à l'état de ruines») n'étaient que des impostures et que les prétendus récits de gazages homicides à Auschwitz n'étaient que des inventions de la propagande de guerre. L'exécution d'un seul homme dans une chambres à gaz américaine exige une machinerie si compliquée qu'il est impensable que les Allemands aient pu, de leur côté, exécuter des centaines de milliers d'hommes dans des « chambres à gaz » aussi frustes que celles qu'on présente aux touristes d'Auschwitz ou que les témoins nous décrivent parfois si succinctement.

La première exécution d'un condamné par le moyen du gaz eut lieu à Carson City (Nevada) en 1924. Elle faillit tourner à la catastrophe. La raison de cette mésaventure vaut d'être méditée parce qu'elle permet de mesurer la naïveté de la plupart des gens ― y compris des scientifiques, des ingénieurs et même parfois des toxicologues ― qui parlent des chambres à gaz nazies. Ces gens ont tendance à oublier que, de toutes les armes, le gaz toxique est probablement la plus difficile à utiliser, surtout si on l'applique à la matière humaine.

C'est, semble-t-il, vers 1917 que des Américains épris d'idées humanitaires ont imaginé qu'une exécution par un gaz mortel constituerait un procédé à la fois plus humain, plus discret et plus aisé que la fusillade, la pendaison ou la chaise électrique. Ils se trompaient. Se tuer soi-même avec un gaz peut être relativement facile (encore que beaucoup de tentatives de suicide par le gaz se soldent par des échecs, par des explosions ou par des catastrophes pour l'entourage) mais tuer avec un gaz quelqu'un d'autre que soi sans encourir de risques pour autant est particulièrement difficile.

Sur les champs de bataille de la première guerre mondiale, en Europe, il est souvent arrivé que l'usage d'un gaz contre l'ennemi se soit retourné contre l'utilisateur. Plus récemment, un désastre comme celui de Bhopal, en Inde, montre à quel point, malgré les progrès de la science, on maîtrise encore mal l'emploi de certains gaz particulièrement toxiques. Aujourd'hui encore, soixante-dix ans après l'expérience de Carson City, le problème n° 1 des chambres à gaz américaines reste celui... de l'étanchéité ! Il faut savoir que l'acide cyanhydrique présente la particularité de ronger jusqu'aux joints d'étanchéité. Après chaque exécution, il est d'usage de changer tous ces joints en vue d'une nouvelle exécution ou d'un nouvel essai.

J'ai expliqué par ailleurs la procédure du gazage d'exécution aux États-Unis et je n'y reviendrai donc pas. Je me contenterai d'apporter ici huit photographies de la chambre à gaz du pénitencier de Baltimore (Maryland) que j'avais déjà publiées en France en 1980 [1], avec leurs explications et j'y ajouterai quelques observations complémentaires. Mais, auparavant, il convient sans doute d'aller au devant de certaines objections qui pourraient se résumer ainsi :

Si les chambres à gaz américaines sont si compliquées, ne serait-ce pas à cause d'une propension ― bien américaine ― au luxe de précautions, à la sophistication scientifique, aux égards pour le condamné et même, dans ces dernières années, au souci de ménager l'environnement ? Les nazis, eux, étaient brutaux, rudimentaires et n'avaient aucun égard pour leurs victimes.

Cet argument n'a pas grande valeur. Il est sûr qu'avec le temps la technologie des chambres à gaz américaines a bénéficié des acquis les plus récents de la science ; par exemple, au lieu d'un simple stéthoscope, le médecin qui surveille les battements de cœur du condamné dispose maintenant d'un stéthoscope électronique. Mais, si on passe en revue tous les détails de cette technologie (en prenant pour exemple une chambre à gaz américaine des années trente, quarante ou cinquante) et si on élimine tous les détails dont l'existence peut être due soit à un excès de sophistication, soit aux égards pour le condamné, on découvre que la simple nécessité de protéger ceux qui emploient la chambre à gaz exige des mesures draconiennes, bien plus encore que pour les chambres à gaz qui servent à la désinfection des vêtements. En effet, au terme d'une opération de désinfection, on peut, sans trop de difficultés, chasser les molécules de gaz cyanhydrique qui se sont accumulées dans les vêtements : des courants d'air chaud et d'air froid chassent une grande partie de ces molécules et les vêtements peuvent être battus, tandis qu'au terme de l'exécution d'un homme par le même gaz il est extrêmement difficile de chasser ces molécules car celles-ci se sont incrustées dans la peau, la graisse et les humeurs : on ne peut ni chauffer ni battre ce cadavre pour en chasser le gaz. On a besoin, dans ce dernier cas, d'instruments particuliers et d'une procédure spéciale. Le médecin et ses deux aides qui vont pénétrer dans la chambre à gaz où se trouve le cadavre du prisonnier doivent d'abord attendre que des ventilateurs orientables et un système d'aspiration puissant balaient et expulsent le gaz qui est dans la chambre à gaz. Ce gaz est expulsé vers un barboteur où il est neutralisé (au moins partiellement). Après une attente plus ou moins longue, ce médecin et ses deux aides, munis de masques à gaz, de tabliers et de gants de caoutchouc, doivent décontaminer le cadavre et ses vêtements. Le médecin commence par secouer la chevelure du cadavre, puis les deux aides vont laver le cadavre lui-même à grande eau, jusque dans ses ouvertures naturelles, sans oublier le pli des bras et des jambes : rien de comparable avec une désinfection de vêtements !

Au début de 1988, Ernst Zündel, révisionniste établi à Toronto (Canada), me demandait de lui communiquer les lettres que j'avais reçues des différents pénitenciers américains munis de chambres à gaz. Grâce à ces lettres, son avocate, Barbara Kulaszka, put se mettre en rapport avec Bill Armontrout, directeur de l'un de ces pénitenciers, qui lui signala que le meilleur spécialiste des chambres à gaz aux États-Unis était Fred Leuchter, lequel habitait Boston.

Sur la demande d'E. Zündel, je rencontrais F. Leuchter à Boston. Je découvris que ce dernier croyait, comme presque tout Américain, à l'existence des chambres à gaz nazies sans s'être jamais posé de questions sur la nature exacte, la configuration et le fonctionnement de ces extraordinaires abattoirs chimiques, capables, si l'on en croit la légende, de performances qui auraient laissé loin derrière elles les performances des chambres à gaz américaines. F. Leuchter, à qui je montrais des photographies et des documents concernant les prétendues chambres à gaz nazies, commença à se poser des questions. Rapidement il se rendit compte qu'il existait un «problème des chambres à gaz» nazies. Par la suite, il accepta de se rendre à Toronto pour y analyser la question de plus près, notamment en examinant les maquettes qu'E. Zündel avait fait construire par Hans Beisner à l'aide des plans que j'avais trouvés à Auschwitz en 1976. Il accepta de se rendre en Pologne, bien décidé à tirer l'affaire au clair, et en rapporta son fameux rapport sur les présumées chambres à gaz d'Auschwitz et de Majdanek.

Visite de la chambre à gaz de Baltimore

Le 14 septembre 1979, je visitais la chambre à gaz du pénitencier de Baltimore sous la conduite du lieutenant Walter Farrier. Celui-ci n'avait pas assisté à une exécution et ce qu'il me dit fut, par conséquent, simplement ce qu'il lui avait fallu apprendre pour le cas où il aurait eu à procéder à une exécution. Il chargea un prisonnier, James F. P..., de prendre huit photographies selon mes instructions. On trouvera ci-dessous ces photographies [2].

La chambre à gaz de Baltimore a été bâtie dans les années cinquante mais, d'après la documentation que j'avais obtenue d'autres pénitenciers, sa technologie n'était pas essentiellement différente de celle des chambres à gaz des années trente ou quarante.

Le lieutenant me fournit des explications sur la chambre, sur son fonctionnement ainsi que sur l'exécution du condamné et sur le traitement du cadavre. Ces explications corroboraient celles que j'avais puisées dans ma documentation écrite (avec des variantes, parfois surprenantes comme on en découvre toujours chez les «spécialistes» ou prétendus tels). Je compris, par exemple, que s'il suffit de quelques milligrammes de cyanure pour tuer un homme, il faut, en réalité, jusqu'à une ou deux livres de cyanure dans une chambre à gaz car tout l'espace de la chambre doit être rempli du gaz mortel (ce qui complique l'opération d'évacuation de quantités si importantes). Il m'expliqua également pourquoi l'habitacle devait être fait d'acier et, pour les vitres, de verre Herculite (avec un dispositif pour empêcher la formation de buée).

A la fin de la visite, il me demanda la raison de ma curiosité. Je lui répondis que je m'intéressais aux chambres à gaz nazies. C'est alors que cet homme me dit : « Terrible ! Have you seen Holocaust ? » Il voulait parler du soap-opera consacré au prétendu génocide des juifs. Cet homme sensé venait de m'expliquer combien l'exécution d'une seule personne, aux États-Unis, par le moyen du gaz, était compliquée et dangereuse, et voilà que ce même homme n'éprouvait apparemment aucune difficulté à croire qu'en Allemagne on avait, pendant des années et le plus aisément du monde, gazé des milliers de personnes par jour.

Au cours des années suivantes, j'allais me rendre compte que même des ingénieurs, des toxicologues, des médecins, des scientifiques et des professeurs, même des spécialistes de la désinfection des vêtements au gaz cyanhydrique, avaient de ces naïvetés-là. Il y a, même chez l'homme bardé de connaissances, une forme de crédulité particulièrement déconcertante.

Le meilleur ouvrage technique que je puisse personnellement recommander sur les chambres à gaz américaines est The Third Leuchter Report: A Technical Report on the Execution Gas Chamber at Mississippi State Penitentiary, Parchman, Mississippi.

Sur mes conseils, E. Zündel a juxtaposé, à la page 2, la porte de la chambre à gaz de ce pénitencier et une porte de la prétendue chambre à gaz d'Auschwitz-I : une misérable petite porte vitrée. La juxtaposition des deux photographies est parlante.

Au sujet de la première exécution en chambre à gaz, celle de Gee Jon à Carson City en 1924, et au sujet de quelques autres parmi les premières exécutions aux États-Unis, on peut lire Frederick Drimmer, Until You Are Dead / The Book of Executions in America.

28 février 1994

Notes

[1] Serge Thion, Vérité historique ou vérité politique ?, p. 301-309.

[2] Elles sont reproduites ci-après.

***

[]
[]
[]
[]
[]

Labels: Auschwitz, Barbara Kulaszka, Bhopal, Bill Armontrout, Carson City (Nevada), chambres à gaz américaines, Degesch, étanchéité, Eugene Brugger, Leuchter, René Fabre, Struthof-Natzweiler, Zyklon B
