<!-- http://robertfaurisson.blogspot.com/1988/08/le-revisionnisme-au-canada-les-proces.html -->

<!-- Wednesday, August 31, 1988 -->

Le révisionnisme au Canada : Les procès Zündel

Ernst Zündel a été condamné le 13 mai 1988 par le juge Ron Thomas (District Court of Ontario, Toronto, Canada) à neuf mois de prison ferme et immédiatement incarcéré pour avoir diffusé une revue révisionniste aujourd'hui vieille de quatorze ans : Did Six Million Really Die ?

Ernst Zündel vit à Toronto où, jusqu'à ces dernières années, il exerçait la profession de graphiste et de publicitaire. Il est âgé de quarante-neuf ans. Né en Allemagne, il a conservé la nationalité allemande. Sa vie a connu de graves bouleversements du jour où, vers 1981, il a commencé à diffuser la brochure révisionniste de Richard Harwood : Did Six Million Really Die ? (En est-il vraiment mort six millions ?). Cette brochure avait été publiée pour la première fois en Grande-Bretagne en 1974 et elle avait suscité l'année suivante une longue controverse dans Books and Bookmen. Sur intervention de la communauté juive sud-africaine, elle allait être interdite en Afrique du Sud. Au Canada, lors d'un premier procès, en 1985, E. Zündel était condamné à quinze mois de prison ferme. Ce procès a été cassé en 1987. Un nouveau procès avait commencé le 18 janvier 1988. J'ai participé aux préparatifs et au déroulement de ces actions judiciaires. J'ai consacré des milliers d'heures à la défense d'E. Zündel.

Déjà François Duprat

Dès 1967, François Duprat avait publié un article sur «Le mystère des chambres à gaz » [1]. Il allait s'intéresser à la brochure de R. Harwood et en assurer activement la diffusion. Le 18 mars 1978, il était tué par des assassins dotés de moyens trop complexes pour ne pas appartenir à un service secret. Cet assassinat fut revendiqué par un « Commando du Souvenir » et par un « Groupe révolutionnaire juif » [2]. Patrice Chairoff avait publié l'adresse de F. Duprat dans Dossier néo-nazisme ; il justifia l'assassinat dans les colonnes du Monde (26 avril 1978, p. 9) où le révisionnisme de la victime lui inspira la réflexion suivante : « François Duprat est responsable. Il y a des responsabilités qui tuent. » Dans Le Droit de vivre, organe de la LICRA, Jean Pierre-Bloch exprima une position ambiguë : il réprouvait le crime mais, en même temps, il laissait entrevoir qu'il n'y aurait pas de pitié pour ceux qui, à l'instar de la victime, s'engageraient sur la voie révisionniste [3].

Pierre Viansson-Ponté

Huit mois avant l'assassinat, le journaliste Pierre Viansson-Ponté avait lancé une virulente attaque contre la brochure de R. Harwood. Sa chronique s'intitulait «Le mensonge» [4]. Elle était reprise avec un commentaire élogieux dans Le Droit de vivre. Six mois après l'assassinat, P. Viansson-Ponté repartait à l'attaque [5]. Il passait sous silence l'assassinat de F. Duprat ; il révélait les noms, prénoms et villes d'origine de trois lecteurs révisionnistes et il en appelait à la répression judiciaire contre le révisionnisme.

Sabina Citron contre E. Zündel

En 1984, au Canada, Sabina Citron, responsable d'une association pour le souvenir de l'Holocauste, provoqua de violentes manifestations contre E. Zündel. Un attentat eut lieu contre le domicile de ce dernier. L'administration des postes canadiennes, assimilant la littérature révisionniste à la littérature pornographique, lui avait refusé tout envoi et toute réception de courrier et il n'avait recouvré ses droits postaux qu'au terme d'une année de procédures judiciaires. Entre-temps, son affaire avait périclité. A l'instigation de Sabina Citron, le procureur général de l'Ontario déposa une plainte contre E. Zündel pour « propagation de fausse assertion (ou allégation ou nouvelle). » L'accusation tenait le raisonnement suivant : l'inculpé avait abusé de son droit à la liberté d'expression ; en diffusant la brochure de R. Harwood, il propageait une assertion qu'il savait être fausse ; en effet, il ne pouvait pas ignorer que le «génocide des juifs» et les «chambres à gaz» sont un fait établi.

E. Zündel était également inculpé pour avoir personnellement écrit et diffusé une lettre de même inspiration que la brochure.

Le premier procès (1985)

Le premier procès dura sept semaines. Le jury déclara E. Zündel non coupable pour sa propre lettre mais coupable pour la diffusion de la brochure. Il fut condamné par le juge H. Locke à quinze mois de prison ferme. Le consulat allemand de Toronto lui retira son passeport. La RFA prépara contre lui une procédure dite de déportation. Auparavant les autorités de la RFA avaient lancé sur tout le territoire allemand une gigantesque opération de descentes de police le même jour chez tous ses correspondants allemands. En 1987, les États-Unis allaient lui interdire l'accès de leur territoire. Mais E. Zündel avait remporté une victoire médiatique ; jour après jour, pendant sept semaines, tous les médias anglophones avaient couvert un procès aux révélations spectaculaires ; il en était ressorti que les révisionnistes possédaient une documentation et une argumentation de première force tandis que les exterminationnistes étaient aux abois.

Leur expert : Raul Hilberg

A ce premier procès, l'expert de l'accusation fut Raul Hilberg, un professeur américain d'origine juive, auteur d'un ouvrage de référence : The Destruction of the European Jews (1961) dont traite Paul Rassinier dans Le Drame des juifs européens (1964). R. Hilberg commença par développer sans encombres sa thèse de l'extermination des juifs. Puis vint son contre-interrogatoire, mené par l'avocat d'E. Zündel, Douglas Christie, avec l'assistance de Keltie Zubko et ma propre assistance. Dès les premières questions, il se révéla que R. Hilberg, qui était la plus haute autorité mondiale en matière d'histoire de l'Holocauste, n'avait pas examiné un seul camp de concentration, pas même Auschwitz. Il ne l'avait fait ni avant de publier son livre en 1961, ni depuis cette date. Encore en 1985, alors qu'il annonçait la sortie imminente d'une nouvelle édition en trois volumes, revue, corrigée et augmentée, il n'avait examiné aucun camp. Il s'était rendu à Auschwitz en 1979 pour une seule journée à l'occasion d'une cérémonie. Il n'avait eu la curiosité d'examiner ni les lieux ni les archives. De toute sa vie, il n'avait vu une « chambre à gaz », soit « en état d'origine », soit à l'état de ruines (pour l'historien, des ruines sont toujours parlantes). Il fut acculé à reconnaître qu'il n'avait existé, pour ce qu'il appelait la politique d'extermination des juifs, ni plan, ni organisme central, ni budget, ni contrôle. Il lui fallut admettre ensuite que, depuis 1945, les Alliés n'avaient procédé à aucune expertise de « l'arme du crime » concluant à l'existence d'une chambre à gaz homicide. Aucun rapport d'autopsie n'avait conclu a l'assassinat d'un détenu par gaz-poison. R. Hilberg affirma que Hitler avait donné des ordres pour l'extermination des juifs et que Himmler, le 25 novembre 1944 (quelle précision !), avait donné l'ordre de cesser cette extermination, mais il fut incapable de produire ces ordres. La défense lui demanda si, dans la nouvelle édition de son livre, il maintenait l'existence de ces ordres de Hitler. Il osa répondre oui. Il mentait. Et même il commettait un parjure. Dans cette nouvelle édition (dont la préface est datée de septembre 1984), R. Hilberg a supprimé systématiquement toute mention d'un ordre de Hitler [6]. Prié par la défense d'expliquer comment les Allemands, dépourvus de tout plan, avaient pu mener à bien une gigantesque entreprise comme celle de l'extermination de millions de juifs, il répondit qu'il y avait eu dans les diverses instances nazies «une incroyable rencontre des esprits, une transmission de pensée consensuelle au sein d'une vaste bureaucratie» (an incredible meeting of minds, a consensus mind-reading by a far-flung bureaucracy).

Le témoin Arnold Friedmann

L'accusation comptait sur le témoignage des « survivants ». Ces « survivants » avaient été choisis avec soin. Ils allaient prouver qu'ils avaient vu, de leurs yeux vu, préparatifs et procédures de gazages homicides. Depuis la guerre, dans une série de procès comme ceux de Nuremberg (1945-1946), de Jérusalem (1961) ou de Francfort (1963-1965), de tels témoins n'avaient pas manqué. Toutefois, ainsi que je l'ai souvent fait observer, aucun avocat de la défense n'avait eu le courage ou la compétence nécessaires pour contre-interroger ces témoins sur les gazages eux-mêmes. Or, pour la première fois, à Toronto, en 1985, un avocat, Douglas Christie, osa demander des explications ; il le fit [grâce à ma documentation] à l'aide de cartes topographiques et des plans de bâtiments ainsi qu'avec une documentation scientifique aussi bien sur les propriétés des gaz censément employés que sur les capacités de crémation soit en fours crématoires, soit sur bûchers. Pas un de ces témoins ne résista à l'épreuve, et surtout pas un certain Arnold Friedmann ; ce dernier, en désespoir de cause, finit par confesser qu'il avait bien été à Auschwitz-Birkenau (où, d'ailleurs, il n'avait jamais eu à travailler sauf une fois pour un déchargement de pommes de terre) mais que, pour ce qui était des gazages, il s'en était rapporté à des on-dit.

Le témoin Rudolf Vrba

Le témoin Rudolf Vrba était de notoriété internationale. Juif slovaque, interné à Auschwitz et à Birkenau, il s'était, disait-il, échappé du camp en avril 1944 en compagnie de Fred Wetzler. De retour en Slovaquie, il avait dicté un rapport sur Auschwitz, sur Birkenau, sur leurs crématoires et leurs « chambres à gaz ».

Par l'intermédiaire d'organisations juives slovaques, hongroises et helvétiques, ce rapport parvint à Washington où il servit de base au fameux War Refugee Board Report, publié en novembre 1944. Tout organisme allié chargé de la poursuite des « crimes de guerre » et tout procureur allié responsable de procès de « criminels de guerre » allaient disposer ainsi de la version officielle de l'histoire de ces camps.

R. Vrba devint par la suite citoyen britannique et publia sa biographie sous le titre de I Cannot Forgive (Je ne puis pardonner) ; en réalité, ce livre, publié en 1964, avait été écrit par Alan Bestic qui, dans sa préface, rendait hommage au « souci considérable [de R. Vrba] pour chaque détail » et à son « respect méticuleux et quasi fanatique pour l'exactitude ». Le 30 novembre 1964, R. Vrba témoigna au procès de Francfort. Puis il s'établit au Canada et acquit la nationalité canadienne. Il figura dans divers films sur Auschwitz et en particulier dans Shoah de Claude Lanzmann. Tout souriait à ce témoin jusqu'au jour où, en 1985, au procès Zündel, il fut contre-interrogé sans ménagement. Il se révéla alors comme un imposteur. On découvrit que, dans son rapport de 1944, il avait inventé de toutes pièces le nombre et l'emplacement des « chambres à gaz » et des fours crématoires. Son livre de 1964 s'ouvrait sur une visite de Himmler à Birkenau pour l'inauguration, en janvier 1943, d'un nouveau crématoire avec « chambre à gaz » ; or, la dernière visite de Himmler remontait à juillet 1942 et, en janvier 1943, le premier des nouveaux crématoires était loin d'être terminé. Grâce, paraît-il, à des moyens mnémotechniques spéciaux, et grâce à un véritable don d'ubiquité, R. Vrba avait compté qu'en l'espace de vingt-cinq mois (d'avril 1942 à avril 1944) les Allemands avaient « gazé » dans le seul camp de Birkenau 1.765.000 juifs, dont 150.000 venus de France. Or, Serge Klarsfeld, en 1978, dans son Mémorial de la déportation des juifs de France, devait conclure que, pour toute la durée de la guerre, les Allemands avaient déporté vers tous les camps de concentration un total de 75.721 juifs de France. Le plus grave est que le chiffre de 1.765.000 juifs «gazés» à Birkenau avait été retenu dans un document (L-022) du Tribunal de Nuremberg. Cerné de tous côtés par l'avocat d'E. Zündel, l'imposteur n'eut d'autre ressource que d'invoquer, en latin, la licentia poetarum, la licence des poètes, le droit à la fiction. Son livre vient d'être publié en français ; il se présente comme un livre de « Rudolf Vrba avec Alan Bestic » ; il ne comporte plus la préface enthousiaste d'Alan Bestic ; dans la courte présentation d'Emile Copfermann, il est dit : «en accord avec Rudolf Vrba, les deux annexes de l'édition anglaise ont été supprimées». On ne précise pas que ces deux annexes avaient, elles aussi, valu de sérieux ennuis à notre homme en 1985 au procès de Toronto.

Le second procès Zündel (1988)

En janvier 1987, une cour composée de cinq hauts magistrats décida de casser le procès de 1985 pour des motifs de fond : le juge H. Locke n'avait permis aucune garantie à la défense dans le choix du jury et le jury avait été trompé par le juge sur le sens même du procès. Personnellement, j'ai assisté à bien des procès dans ma vie, y compris en France à l'époque de l'Épuration. Jamais je n'ai rencontré de magistrat aussi partial, autocratique et violent que le juge H. Locke. La justice anglo-saxonne offre beaucoup plus de garanties que la justice française mais il peut suffire d'un homme pour pervertir le meilleur des systèmes. Le juge H. Locke a été cet homme.

Le second procès commença le 18 janvier 1988 sous la conduite du juge Ron Thomas, qui est un ami, semble-t-il, du juge H. Locke. L'homme est colérique, franchement hostile à la défense mais il a plus de finesse que son prédécesseur, et puis les observations des cinq hauts magistrats sont là qui le tiennent un peu en lisière. Le juge H. Locke avait multiplié les entraves à la libre expression des témoins et des experts de la défense ; il m'avait, par exemple, interdit dans la pratique toute utilisation des photos que j'avais prises à Auschwitz ; je n'avais pas eu le droit d'employer des arguments d'ordre chimique, d'ordre topographique, d'ordre architectural (alors que j'avais été le premier au monde à publier les plans des crématoires d'Auschwitz et de Birkenau) ; je n'avais pu parler ni des chambres à gaz américaines, ni des photographies aériennes d'Auschwitz et de Birkenau. Même un éminent chimiste comme William Lindsey avait été bridé dans sa déposition. Le juge R. Thomas, lui, allait permettre plus de liberté à la défense mais d'emblée, sur requête de l'accusation, il prit une décision de nature à ligoter le jury.

La « notification judiciaire » du juge R. Thomas

En droit anglo-saxon, tout doit être prouvé sauf certaines évidences (« La Grande-Bretagne est gouvernée par une monarchie », « sa capitale s'appelle Londres », « le jour succède à la nuit »...). Encore faut-il que le juge prenne « notification judiciaire » [« ou note d'office »] (judicial notice) de ces évidences sur requête de l'une ou de l'autre des parties en présence.

Le procureur John Pearson demanda au juge de prendre notification judiciaire de l'Holocauste. Restait à définir ce terme. Il est vraisemblable que, sans l'intervention de la défense, le juge aurait défini l'Holocauste comme on aurait pu le faire en 1945-1946. A cette époque, le « génocide des juifs » (on ne disait pas encore « l'Holocauste ») aurait pu être défini comme « la destruction ordonnée et planifiée de six millions de juifs, en particulier par l'emploi de chambres à gaz ». L'ennui pour l'accusation est que la défense avertit le juge que, depuis 1945-1946, il s'était produit de profonds changements dans l'idée que les historiens exterminationnistes eux-mêmes se faisaient de l'extermination des juifs. Pour commencer, ils ne parlaient plus d'une extermination mais d'une tentative d'extermination. Ensuite, ils avaient fini par admettre que, « malgré les recherches les plus érudites », on n'avait pas trouvé trace d'un ordre d'exterminer les juifs. Puis s'était produite la scission entre « intentionnalistes » et « fonctionnalistes » : tous s'accordaient à dire qu'on n'avait pas la preuve d'une intention exterminatrice mais les historiens de la première école estimaient qu'il fallait néanmoins supposer l'existence de cette intention, tandis que les historiens de la seconde école jugeaient que l'extermination avait été le fruit d'initiatives individuelles, locales et anarchiques : la fonction avait en quelque sorte créé l'organe ! Enfin, le chiffre de six millions avait été déclaré «symbolique» et il y avait bien des dissensions sur le «problème des chambres à gaz». Le juge R. Thomas, manifestement surpris par ce flot d'informations, décida de jouer la prudence et, après un délai de réflexion, il opta pour la définition suivante : l'Holocauste était «l'extermination et/ou meurtre de masse de juifs» par le national-socialisme. Cette définition était remarquable à plus d'un titre : on n'y trouvait plus trace ni d'un ordre d'extermination, ni d'un plan, ni de « chambres à gaz », ni de six millions de juifs, ni même de millions de juifs. Elle était à tel point vidée de toute substance qu'elle ne correspondait plus à rien car on ne voit pas ce que pourrait être un « meurtre de masse de juifs » (le juge avait soigneusement évité de dire : des juifs). A elle seule, cette définition permettait de mesurer les progrès accomplis par le révisionnisme historique de 1945 à 1988.

R. Hilberg refuse de comparaître à nouveau

Une déconvenue attendait le procureur J. Pearson : R. Hilberg, malgré des demandes réitérées, refusait de comparaître à nouveau. La défense, ayant eu vent d'un échange de correspondance entre J. Pearson et R. Hilberg, exigea et obtint la publication des lettres échangées et, en particulier, d'une lettre « confidentielle » de R. Hilberg où ce dernier ne cachait pas qu'il gardait un mauvais souvenir de son contre-interrogatoire de 1985. Il craignait de la part de Douglas Christie une récidive sur les points mêmes où il avait été interrogé. Pour reprendre les propres mots de cette lettre confidentielle, il redoutait, disait-il, «une tentative pour me piéger en signalant toute contradiction apparente, si léger qu'en fût le sujet, entre mon précédent témoignage et toute réponse que je pourrais faire en 1988 » (every attempt to entrap me by pointing out to any seeming contradiction, however trivial the subject might be, between my earlier testimony and an answer that I might give in 1988). En fait, ainsi que je l'ai dit plus haut, R. Hilberg avait commis un parjure caractérisé et il ne pouvait que craindre une accusation de parjure.

Christopher Browning, expert de l'accusation

A la place de R. Hilberg vint son ami Christopher Browning, un professeur américain, spécialiste de l'Holocauste. Admis à titre d'expert (et payé pendant plusieurs jours à raison de six cents francs de l'heure par le contribuable canadien), il s'efforça de prouver que la brochure de R. Harwood était un tissu de mensonges et que la tentative d'extermination des juifs était un fait scientifiquement établi. Mal lui en prit. Lors du contre-interrogatoire, la défense se servit de ses propres arguments pour l'anéantir. Au fil des jours, on vit le grand et naïf professeur, qui plastronnait debout, s'asseoir et se ratatiner derrière le pupitre des témoins comme un élève pris en faute ; d'une voix éteinte et soumise, il finit par reconnaître que, décidément, ce procès lui en apprenait sur le plan de l'information historique. A l'exemple de R. Hilberg, il n'avait examiné aucun camp de concentration. Il n'avait visité aucun emplacement de « chambres à gaz ». Il ne lui était pas venu à l'idée de chercher ou de demander une expertise de « l'arme du crime ». Dans ses écrits, il faisait grand cas des camions à gaz homicides ; toutefois, il n'était en mesure de se référer à aucune vraie photographie, à aucun plan, à aucune étude technique, à aucune expertise. Il ignorait que des mots allemands comme Gaswagen, Spezialwagen, Entläusungswagen (camion d'épouillage) pouvaient avoir un sens parfaitement bénin. Ses connaissances techniques étaient nulles. Il n'avait jamais examiné les photographies aériennes d'Auschwitz. Il ignorait tout des tortures subies par les Allemands qui avaient, tel Rudolf Höss, parlé de gazages. Il ne savait rien des doutes émis sur certains discours de Himmler ou sur le journal de Goebbels.

Grand amateur de procès de criminels de guerre, il n'avait interrogé que les procureurs et jamais les avocats. Son ignorance du compte rendu du procès de Nuremberg était confondante. Il n'avait pas même lu ce que Hans Frank, ancien gouverneur général de Pologne, avait dit devant le tribunal de Nuremberg sur son « journal » et sur « l'extermination des juifs ». Faute impardonnable ! En effet, C. Browning prétendait avoir trouvé dans le « journal » de Hans Frank la preuve irréfutable de l'existence d'une politique d'extermination des juifs. Il avait découvert une phrase accusatrice. Il ne savait pas que H. Frank avait fourni devant le tribunal une explication à ce type de phrases, prélevées parmi les centaines de milliers de phrases d'un journal personnel et administratif de onze mille cinq cents pages. Hans Frank avait d'ailleurs spontanément remis ce « journal » aux Américains venus l'arrêter. La sincérité de l'ancien gouverneur général fait si peu de doute pour qui lit sa déposition que C. Browning, invité à en entendre le contenu, ne souleva pas la moindre objection.

Une dernière humiliation l'attendait.

Pour les besoins de sa thèse, il avait invoqué un passage du procès-verbal de la conférence de Wannsee (20 janvier 1942) ; il en avait donné sa propre traduction ; la traduction était gravement fautive. Du même coup, sa thèse s'effondrait. Enfin, quant à son explication personnelle d'une « politique d'extermination des juifs », elle valait celle de R. Hilberg : pour C. Browning tout s'expliquait par le « signe de tête » (the nod) d'Adolf Hitler. Entendons par là que le Führer du peuple allemand n'avait eu nul besoin de donner un ordre écrit ou un ordre oral pour l'extermination des juifs : il lui avait suffi de donner un «signe de tête» au départ de l'opération et, pour la suite, une série de «signaux» (signals). Et il avait été compris !

Charles Biedermann

L'autre expert, appelé par l'accusation avant C. Browning, avait été Charles Biedermann, citoyen helvétique, délégué du Comité international de la Croix-Rouge (CICR) et, surtout, directeur du Service international de recherches (SIR) établi, en RFA, à Arolsen. Ce dernier organisme possède des informations d'une richesse inouïe sur le sort individuel des victimes du national-socialisme et, en particulier, sur les anciens concentrationnaires. Je prétends que c'est à Arolsen qu'on pourrait, si on le voulait, déterminer le véritable nombre de juifs morts durant la guerre.

L'accusation ne tira pour ainsi dire aucun profit de la déposition de cet expert. En revanche, le contre-interrogatoire permit à la défense de marquer de nombreux points. C. Biedermann reconnut que le CICR n'avait jamais trouvé de preuve de l'existence de chambres à gaz homicides dans les camps allemands. La visite de l'un de ses délégués à Auschwitz en septembre 1944 avait conclu tout au plus à l'existence d'une rumeur en la matière. A sa confusion, l'expert fut obligé d'admettre qu'il commettait une erreur en prêtant aux nationaux-socialistes l'expression de « camps d'extermination» ; il ne s'était pas rendu compte qu'il s'agissait là d'une expression forgée par les Alliés. Il prétendait que le CICR s'était montré impartial pendant et après le conflit ; on lui démontra le contraire. Après le conflit, le CICR avait fait chorus avec les Alliés. C. Biedermann déclara ne pas connaître de rapports du CICR sur les atrocités subies par les Allemands vers la fin de la guerre et juste après la guerre ; en particulier, il ne savait rien du traitement affreux réservé à bien des prisonniers allemands. Le CICR ne possédait rien, paraît-il, sur les déportations massives des minorités allemandes de l'Est, rien sur les horreurs de «la grande débâcle», rien sur les exécutions sommaires et, en particulier, le massacre au fusil, à la mitrailleuse, à la pelle et à la pioche de cinq cent vingt soldats et officiers allemands qui s'étaient rendus aux Américains à Dachau le 29 avril 1945 (pourtant, Victor Maurer, délégué du CICR, était là). Le SIR classait au nombre des « persécutés » du nazisme même les prisonniers de droit commun qui s'étaient trouvés en camps de concentration. Il se fiait aux données du «musée d'Auschwitz » (organisme communiste). A partir de 1978, afin d'entraver toute recherche révisionniste, le SIR avait fermé ses portes aux historiens et chercheurs, sauf à ceux pourvus d'une autorisation spéciale de l'un des dix gouvernements (dont celui d'Israël) qui surveillent l'activité du SIR. Désormais, il fut interdit au SIR d'établir, comme il l'avait fait jusque-là, des évaluations statistiques du nombre des morts dans les différents camps. Les précieux rapports d'activité annuels ne devaient plus être communiqués au public sinon pour leur premier tiers, qui ne présente aucun intérêt pour le chercheur. C. Biedermann confirma une nouvelle qui avait filtré en 1964 au procès de Francfort : à la libération d'Auschwitz, les Soviétiques et les Polonais avaient découvert le registre mortuaire de cet ensemble de trente-neuf camps et sous-camps. Le registre se composait de trente-huit ou trente-neuf volumes. Les Soviétiques conservent à Moscou trente-six ou trente-sept de ces volumes tandis que les Polonais gardent au « musée d'Auschwitz » les deux ou trois autres volumes, dont ils ont fourni copie au SIR d'Arolsen. Mais ni les Soviétiques, ni les Polonais, ni le SIR n'autorisent la consultation de ces volumes. C. Biedermann ne voulut pas même révéler le nombre des morts répertoriés dans les deux ou trois volumes dont le SIR possède la copie. Il est clair que, si le contenu du registre mortuaire d'Auschwitz était rendu public, c'en serait fini du mythe des millions de morts de ce camp.

Pas de «survivants» pour l'accusation

Le juge demanda au procureur s'il appellerait des « survivants » à la barre des témoins. Le procureur répondit que non. L'expérience de 1985 avait été trop cruelle. L'épreuve du contre-interrogatoire avait été dévastatrice. Il est regrettable qu'en France, au procès Barbie (1987), et qu'en Israël, au procès Demjanjuk (1987-1988), aucun avocat n'ait suivi l'exemple donné par Douglas Christie au Canada lors du premier procès Zündel (1985) : D. Christie avait démontré qu'on pouvait, par un contre-interrogatoire sur la procédure même du « gazage », détruire à sa racine le mythe du « camp d'extermination ».

Les témoins et les experts de la défense

La plupart des témoins et des experts de la défense furent aussi précis et matérialistes qu'un R. Hilberg ou un C. Browning avaient pu être imprécis et métaphysiques. Le Suédois Ditlieb Felderer projeta environ trois cent cinquante clichés d'Auschwitz et des camps de Pologne. L'Américain Mark Weber, dont l'érudition documentaire est impressionnante, procéda à des mises au point sur plusieurs aspects de l'Holocauste et, en particulier, sur les Einsatzgruppen. L'Allemand Tijudar Rudolph traita du ghetto de Lodz ; il donna aussi un témoignage personnel sur une tournée d'inspection du Comité international de la Croix-Rouge dans des camps de Silésie et du Gouvernement général de Pologne (Auschwitz, Majdanek,...) en automne 1941, à la fin de laquelle le délégué du CICR remercia Hans Frank, gouverneur général de Pologne, pour sa coopération. Thies Christophersen avait commandé, en 1944, dans le secteur d'Auschwitz, une entreprise de recherches agricoles ; il se rendait souvent au camp de Birkenau pour y réquisitionner du personnel ; il n'y avait jamais constaté les horreurs habituellement décrites ; à la barre des témoins, il reprit point par point ce qu'il avait décrit dès 1973 dans un document de dix-neuf pages [7].

La Canadienne Maria Van Herwaarden avait été internée à Birkenau dès 1942 ; elle n'y avait rien vu qui, de près ou de loin, ressemblât à un meurtre de masse mais beaucoup d'internés étaient morts du typhus. L'Américain Bradley Smith, membre d'un «Comité pour un débat public sur l'Holocauste», relata son expérience de près de cent débats aux États-Unis sur le sujet de l'Holocauste. L'Autrichien Emil Lachout commenta le fameux « document Müller » qui, depuis décembre 1987, met en émoi les autorités autrichiennes : ce document, daté du 1er octobre 1948, révèle que, déjà à cette date, les commissions d'enquête alliées ne croyaient plus aux « gazages » homicides dans toute une série de camps comme ceux de Dachau, Ravensbrück, Struthof (Natzweiler), Stuttof (Danzig), Sachsenhausen, Mauthausen (Autriche), etc. Le document précise que les confessions des Allemands avaient été extorquées par la torture et que les témoignages étaient faux.

Le Dr Russel Barton retraça sa découverte horrifiée du camp de Bergen-Belsen à la libération ; sur le moment il avait cru à un massacre délibéré, puis il s'était rendu compte que, dans une Allemagne d'apocalypse, ces amoncellements de cadavres et ces squelettes ambulants étaient dus aux conditions affreuses d'un camp surpeuplé, ravagé par les épidémies, dépourvu d'eau à cause d'un bombardement des Alliés, presque entièrement dépourvu de médicaments et de ravitaillement. L'Allemand Udo Walendy fit le point de ses recherches révisionnistes. J.-G. Burg, juif mosaïque, vivant à Munich, relata son expérience de la guerre et prouva qu'il n'avait jamais existé de politique d'extermination des juifs par les nazis.

Des universitaires comme MM. Kuang Fu ou Gary Botting apportèrent leur contribution sur le plan de l'analyse à la fois des faits historiques, des opinions et des interprétations. Jürgen Neumann s'expliqua sur la nature des recherches qu'il avait menées aux côtés d'Ernst Zündel. Ernst Nielsen témoigna sur les entraves apportées, au sein d'une université canadienne, à une libre recherche sur l'Holocauste. Ivan Lagacé, responsable du crématoire de Calgary (Canada), démontra l'impossibilité pratique des chiffres retenus par R. Hilberg pour les crémations d'Auschwitz.

A mon tour, je déposais à titre d'expert pendant près de six jours. J'insistais particulièrement sur mes enquêtes à propos des chambres à gaz américaines. Je rappelais que le Zyklon B est essentiellement du gaz cyanhydrique et que c'est avec ce gaz que certains pénitenciers américains exécutent leurs condamnés à mort. En 1945, les Alliés auraient dû demander à des spécialistes des chambres à gaz américaines de venir examiner les locaux qui, à Auschwitz et ailleurs, étaient censés avoir servi à gazer des millions de détenus. Dès 1977, mon idée était la suivante : quand on a affaire à un vaste problème historique comme celui de la réalité ou de la légende de l'Holocauste, il faut s'efforcer de trouver le centre de ce problème ; en la circonstance, le centre est le problème d'Auschwitz et, à son tour, le cœur de ce problème-là peut se limiter à un espace de deux cent soixante-quinze mètres carrés, soit, à Auschwitz, les soixante-cinq mètres carrés de la « chambre à gaz » du crématoire-I et, à Birkenau, les deux cent dix mètres carrés de la « chambre à gaz » du crématoire-II. En 1988, mon idée restait la même : expertisons les deux cent soixante-quinze mètres carrés et nous aurons une réponse au vaste problème de l'Holocauste ! Je montrais au jury mes photos de la chambre à gaz du pénitencier de Baltimore ainsi que mes plans des « chambres à gaz » d'Auschwitz et je soulignais les impossibilités physiques et chimiques de ces dernières.

Un coup de théâtre : le rapport Leuchter

E. Zündel, en possession de la correspondance que j'avais échangée en 1977-1978 avec six pénitenciers américains disposant de chambres à gaz, avait chargé l'avocate Barbara Kulaszka de se mettre en rapport avec les gardiens-chefs de ces pénitenciers afin de voir si l'un d'entre eux accepterait de venir expliquer devant le tribunal le mode de fonctionnement d'une vraie chambre à gaz. Bill Armontrout, gardien-chef du pénitencier de Jefferson City (Missouri), accepta de venir témoigner et signala que nul aux États-Unis ne connaissait mieux la question du fonctionnement de ces chambres à gaz qu'un ingénieur de Boston : Fred A. Leuchter. J'allais rendre visite à cet ingénieur les 3 et 4 février 1988. F. Leuchter ne s'était jamais posé de questions sur les « chambres à gaz » des camps allemands. Il croyait jusque-là à leur existence. Dès que je commençai à lui ouvrir mes dossiers, il prit conscience de l'impossibilité matérielle et chimique de ces « gazages ». Il accepta de se rendre à Toronto pour y examiner nos documents.

Puis, aux frais d'E. Zündel, il partit pour la Pologne avec une secrétaire (sa femme), son dessinateur, un vidéo-cameraman et un interprète. Il en revint pour rédiger un rapport de cent quatre-vingt-douze pages (annexes comprises) et avec trente-deux échantillons prélevés, d'une part, dans les crématoires d'Auschwitz et de Birkenau à l'emplacement des « gazages » homicides et, d'autre part, dans une chambre à gaz de désinfection de Birkenau. Sa conclusion était nette : il n'y avait eu aucun « gazage » homicide ni à Auschwitz, ni à Birkenau, ni d'ailleurs à Majdanek.

Les 20 et 21 avril 1988, F. Leuchter déposa à la barre du tribunal de Toronto. Il fit le récit de son enquête et développa sa conclusion. Je dis que, ces deux jours-là, j'ai assisté à la mort en direct du mythe des chambres à gaz, un mythe qui, pour moi, était entré en agonie au colloque de la Sorbonne sur « l'Allemagne nazie et l'extermination des juifs » (29 juin ― 2 juillet 1982).

Dans la salle du tribunal de Toronto, l'émotion était intense, en particulier chez les amis de Sabina Citron. Les amis d'E. Zündel étaient bouleversés mais pour d'autres raisons : ils voyaient enfin se déchirer le voile de la grande imposture. Pour moi, je ressentais soulagement et mélancolie : soulagement parce qu'une thèse que je défendais depuis tant d'années trouvait enfin sa pleine confirmation, et mélancolie parce que j'avais eu la paternité de l'idée ; j'avais même, avec la maladresse d'un littéraire, exposé des arguments d'ordre physique, chimique, topographique et architectural que je voyais reprendre par un scientifique étonnamment précis et didactique. Se rappellerait-on un jour le scepticisme que j'avais rencontré, y compris auprès de certains révisionnistes ?

Juste avant F. Leuchter, B. Armontrout était venu à la barre et il avait, en tout point, confirmé ce que j'avais dit au jury sur les difficultés extrêmes d'un gazage homicide (à ne pas confondre avec un gazage suicidaire ou accidentel). De son côté, un spécialiste des photographies aériennes, Ken Wilson, avait montré que les « chambres à gaz » homicides d'Auschwitz et de Birkenau ne possédaient pas les cheminées d'évacuation des gaz qui auraient été indispensables. Il montrait aussi que j'avais eu raison d'accuser Serge Klarsfeld et J.-C. Pressac d'avoir falsifié le plan de Birkenau dans L'Album d'Auschwitz [8]. Ces auteurs, pour faire croire au lecteur que les groupes de femmes et d'enfants juifs surpris par le photographe entre les crématoires-I et III ne pouvaient pas aller plus loin et allaient donc finir dans les «chambres à gaz» de ces crématoires, avaient tout bonnement coupé là un chemin qui, en réalité, se poursuivait jusqu'au grand établissement de douches (situé au-delà de la zone des crématoires) où se rendaient ces femmes et ces enfants. James Roth, directeur d'un laboratoire du Massachusetts, vint ensuite à la barre pour y rendre compte de l'analyse des 32 échantillons, dont il ignorait la provenance : tous les échantillons prélevés dans les « chambres à gaz » homicides contenaient une quantité de cyanure qui était soit indécelable, soit infinitésimale tandis que l'échantillon de la chambre à gaz de désinfection de Birkenau, prise pour référence, contenait, par comparaison, une quantité vertigineuse de cyanure (la quantité infinitésimale détectée dans le premier cas peut s'expliquer par le fait que les prétendues chambres à gaz homicides étaient en fait des chambres froides pour la conservation des cadavres ; de telles chambres froides avaient pu faire l'objet de désinfections au Zyklon B).

David Irving

L'historien britannique David Irving jouit d'un grand prestige. E. Zündel songeait à lui demander son témoignage. Mais une difficulté se présentait : D. Irving n'était qu'à moitié révisionniste. La thèse qu'il défendait, par exemple dans Hitler's War, pouvait se résumer ainsi : Hitler n'a jamais donné un ordre d'extermination des juifs ; au moins jusqu'à la fin de 1943, il a été tenu dans l'ignorance de cette extermination ; seuls Himmler et un groupe probable de soixante-dix personnes étaient informés ; en octobre 1944, Himmler, qui cherchait désormais à entrer dans les bonnes grâces des Alliés, avait donné l'ordre de cesser l'extermination des juifs.

J'avais personnellement rencontré D. Irving à Los Angeles en septembre 1983 au congrès annuel de l'Institute for Historical Review et je l'avais mis dans l'embarras en lui posant quelques questions sur les preuves dont il disposait à l'appui de sa thèse. Puis j'avais publié dans The Journal of Historical Review un article intitulé : « A Challenge to David Irving » (Un défi à David Irving) [9]. J'essayais d'y convaincre ce brillant historien qu'en bonne logique il ne pouvait plus se contenter d'une position semi-révisionniste et, pour commencer, je le mettais au défi de nous montrer cet ordre de Himmler qui, en réalité, n'avait jamais existé. Par la suite, j'apprenais de diverses sources que D. Irving subissait une mutation dans un sens favorable au révisionnisme.

En 1988, E. Zündel acquérait la conviction que l'historien britannique n'attendait plus qu'un événement décisif pour franchir un dernier pas en notre direction. Arrivé à Toronto, D. Irving découvrit coup sur coup le rapport Leuchter et une somme impressionnante de documents qu'E. Zündel, ses amis et moi-même nous avions accumulés au cours des années. Les dernières réserves ou les derniers malentendus se dissipaient au cours d'une réunion. Il acceptait de témoigner à la barre. De l'avis de ceux qui ont assisté aux deux procès (celui de 1985 et celui de 1988), pas un témoignage, sauf celui de F. Leuchter, n'allait provoquer une telle sensation. Pendant plus de trois jours, D. Irving, se livrant à une sorte de confession publique, revint sur tout ce qu'il avait dit de l'extermination des juifs et se rallia sans aucune réserve à la position révisionniste. Avec courage et probité, il montra comment un historien peut être conduit à réviser profondément ses vues sur l'histoire de la seconde guerre mondiale.

La victoire d'E. Zündel

E. Zündel avait promis que son procès serait « le procès du procès de Nuremberg » ou « le Stalingrad des exterminationnistes ». Le déroulement de ces deux longs procès lui a donné raison, et cela même si le jury, « instruit » par le juge et sommé de tenir l'Holocauste pour un fait établi «que nulle personne raisonnable ne peut mettre en doute», en est venu à le déclarer coupable. E. Zündel a déjà gagné. Il lui reste à le faire savoir au Canada et au monde entier. Pour le procès de 1988, le black-out des médias a été à peu près complet. Les organisations juives avaient fait campagne pour obtenir ce black-out et avaient été jusqu'à dire qu'elles ne voulaient pas d'un compte rendu impartial. Elles ne voulaient d'aucun compte rendu. Le paradoxe est que la seule publication qui se soit fait l'écho du procès dans des conditions relativement honnêtes soit l'hebdomadaire The Canadian Jewish News.

Ernst Zündel et le rapport Leuchter sont entrés dans l'Histoire ; ils ne sont pas près d'en sortir.

31 août 1988

Notes

[1] Défense de l'Occident, juin 1967, p. 30-33.

[2] Le Monde, 23 mars 1977, p. 7.

[3] Le Monde, 7-8 mai 1978.

[4] Le Monde, 17-18 juillet 1977, p. 13.

[5] « Le mensonge (suite) », Le Monde, 3-4 septembre 1978, p. 9.

[6] Voy. à ce propos le compte rendu de Christopher Browning, « The Revised Hilberg », p. 294.

[7] Kritik no 23, p. 14-32.

[8] J.-C. Pressac, L'Album d'Auschwitz p. 42.

[9] Dans le désir de ménager David Irving, Willis Carto, responsable à l'époque du Journal of Historical Review, avait, sans mon consentement, pratiqué des coupures dans ce texte dont on retrouvera l'intégralité dans mes Ecrits révisionnistes (1974-1998) volume I, p. 455.

Labels: "Did Six Million Really Die ?" Richard Harwood, Biedermann, François Duprat, Hilberg, Irving, Patrice Chairoff, Révisionnisme, Ron Thomas, Sabina Citron, Vrba, Zündel
