<!-- http://robertfaurisson.blogspot.com/1998/12/lauto-destruction-de-raul-hilberg.html -->

<!-- Wednesday, December 30, 1998 -->

L'auto-destruction de Raul Hilberg

Raul Hilberg est le plus prestigieux des historiens de l'« Holocauste ». Juif américain, d'origine autrichienne, il a écrit The Destruction of the European Jews (La Destruction des juifs d'Europe). Il a commencé ses recherches en 1948. En 1961, soit treize ans plus tard, il a publié la première édition de son livre sous la forme d'un ouvrage de sept cent quatre-vingt-dix pages. Puis, en 1985, soit vingt-cinq ans plus tard, il en a publié une édition « revue et définitive » de 1274 pages (New York, Holmes and Meier). Il a donc consacré trente-sept ans de sa vie à l'édification de ce monument, dont la dimension est, certes, admirable par la quantité du travail fourni mais dont la qualité est exécrable, tout simplement parce qu'il s'agit d'une construction factice. On peut dire qu'en cherchant à décrire ce qu'il appelle la destruction des juifs d'Europe par les Allemands, R. Hilberg s'est, en réalité, détruit lui-même.

Dès 1976, le révisionniste américain Arthur Robert Butz avaient mis ses lecteurs en garde contre ce qu'il appelait, avec beaucoup de pertinence, la « remarquable mentalité cabalistique » de R. Hilberg. Il le faisait dans la préface de The Hoax of the Twentieth Century. A l'époque, il conseillait de se reporter aux pages 567-571 de l'édition de 1961, pour prendre la mesure de ce que, pour ma part, j'appelle la malhonnêteté foncière de R. Hilberg.

Le sommet de la construction

Il est exact que ces cinq pages (p. 567-571) constituent le sommet de l'édifice. Elles portent sur le Zyklon B, un insecticide censé avoir été utilisé par les Allemands pour exterminer des foules de juifs dans des abattoirs chimiques appelés « chambres à gaz ». Pour ma part, j'ai voulu rechercher le sommet de ce sommet, la clé de voûte en quelque sorte, et je pense l'avoir trouvé au haut de la page 570, dans un fragment de sept phrases ou de quatre-vingt-quinze mots, que voici :

The amounts [of Zyklon B] required by Auschwitz were not large, but they were noticeable. Almost the whole Auschwitz supply was needed for the gassing of people ; very little was used for fumigation. The camp administration itself did not buy the gas. The purchaser was Obersturmführer Gerstein, Chief Disinfection officer in the Office of the Hygienic Chief of the Waffen-SS (Mrugowski). As a rule, all orders passed through the hands of TESTA, DEGESCH, and Dessau. From the Dessau Works, which produced the gas, shipments were sent directly to Auschwitz Extermination and Fumigation Division (Abteilung Entwesung und Entseuchung) [1].

Le sens de ce fragment ne souffre aucune équivoque : selon l'historien américain, une division administrative du camp d'Auschwitz, camp toujours présenté comme le centre même de l'entreprise d'extermination des juifs, organisait à la fois le gazage des gens et, par ailleurs, les travaux de désinfection. Toujours selon notre historien, qui ne fournit aucune précision ni aucune source à l'appui de ses dires, la presque totalité du Zyklon B reçu par cette division servait à tuer les gens et très peu servait à désinfecter. Avec le cynisme de froids criminels, les Allemands avaient donc choisi, pour cette division administrative, une désignation des plus claires : « Division d'extermination et de désinfection. »

La clé de voûte

Cette construction tout entière tient au sens d'un seul mot, celui d'Entwesung. R. Hiberg, dont la langue maternelle est pourtant l'allemand, a commis la malhonnêteté de la traduire ici par « extermination (des gens) » alors qu'en réalité le mot signifie « désinfection » ou, pour être plus précis, « désinfestation » tandis que le mot d'Entseuchung désigne, lui, la décontamination. On n'entrera pas ici dans des considérations pédantes sur le sens précis de tels mots du langage technique et l'on sait que l'usage courant souffre toutes sortes de confusions ou de méprises dans l'emploi de mots comme désinfection, désinfestation, désinsectisation, fumigation, épouillage, décontamination, etc., mais il est exclu qu'Entwesung ait jamais pu désigner l'extermination d'être humains et que le verbe entwesen ait jamais signifié « exterminer des gens ». De la même façon, en anglais, un « exterminator » n'est, dans le langage technique, qu'un employé de la désinfestation. Il y avait donc tout simplement à Auschwitz une « division de la désinfestation et de la décontamination » dépendant, pour son approvisionnement en un certain nombre de produits, dont le Zyklon B, de l'Institut d'hygiène de la Waffen-SS à Berlin.

Le parjure de R. Hilberg

En janvier 1985, avant la parution de la nouvelle édition «revue et corrigée» alors sous presses, R. Hilberg fut appelé à témoigner en qualité d'expert de l'« Holocauste» contre le germano-canadien Ernst Zündel devant le tribunal de Toronto. Sur mes conseils et avec mon aide, Douglas Christie, avocat d'E. Zündel, entreprit d'interroger l'expert sur le sens qu'il avait donné au mot-clé d'Entwesung dans ce passage de son livre. Comme la transcription du procès en fait foi, D. Christie eut recours à un dictionnaire et à un ouvrage technique. Pour Entwesung, le dictionnaire allemand-anglais proposait : « extermination of vermin, delousing, disinfection » (extermination de la vermine, épouillage, désinfection) et pour le verbe entwesen : « to disinfect, to sterilize, to exterminate vermin, to delouse » (désinfecter, stériliser, exterminer la vermine, épouiller). Quant à l'ouvrage technique, il fit sensation ; il s'agissait d'un traité portant pour titre Entkeimung, Entseuchung und Entwesung (stérilisation, décontamination, désinsectisation) ; l'auteur en était un médecin, le docteur Walter Dötzer ; l'ouvrage avait été publié à Berlin, en 1943, par l'Institut d'hygiène de la Waffen-SS et, dans sa préface, l'auteur ne remerciait de son aide personne d'autre que, précisément, l'Obersturmführer Dipl.-Ing. Gerstein (lieutenant ingénieur diplômé Gerstein).

Manifestement ébranlé, R. Hilberg tenta une parade. Il s'engagea dans des considérations laborieuses sur l'étymologie des mots Entwesung et entwesen. Il fit remarquer que Wesen désignait tout être vivant et que le préfixe ent- avait valeur privative. En conséquence, il s'estimait fondé à traduire Entwesung par « extermination des gens » [2]. Il parut si peu convaincu de sa propre explication que l'avocat D. Christie n'insista plus et, ce matin-là, passa à d'autres questions mais, à l'audience de l'après-midi du même jour, R. Hilberg tint, avec l'aide du procureur, à rouvrir le débat. Il apporta, en tout et pour tout, un modeste dictionnaire allemand-anglais où... manquaient les mots techniques d'Entwesung et d'entwesen ! Fort de l'absence de ces mots, il se rabattit sur le mot, très courant, de Wesen et, reprenant son explication du matin, il fit remarquer que la définition du dictionnaire lui donnait raison : Wesen, disait-il, était défini comme « reality, substance, essence ; being, creature, living thing, organism, etc. » (réalité, substance, essence ; être, créature, être vivant, organisme, etc.) Satisfait de lui-même, le procureur fit à son tour remarquer que, dans la définition de ce mot, il n'était question ni de vermine, ni d'insectes. Les contraintes du procès (D. Christie n'avait plus le droit de ré-interroger R. Hilberg) permirent ainsi à l'expert de se tirer d'une situation périlleuse grâce à un véritable tour de passe-passe. Mais R. Hilberg venait de commettre un parjure [3].

La preuve du parjure

Il aurait été possible de river définitivement son clou au tricheur en portant à son attention un autre passage de son livre situé à plus de cent pages du passage incriminé. Là, dans une note, l'auteur lui-même avait, pour ses lecteurs anglais, éclairé le sens d'Entwesung. Sa définition était : « ridding of vermin, or fumigation [4]. »

Conclusion

Le gros ouvrage de R. Hilberg fait songer à ces productions érudites du passé où des savants chrétiens, juifs, byzantins rivalisaient dans la fabrication de faux littéraires ou historiques en tous genres. Leur science était digne d'admiration mais elle était sans conscience. Mais, plus précisément, R. Hilberg avec, comme le dit A. R. Butz, sa « remarquable mentalité cabalistique» rappelle ces juifs alexandrins qui, nous dit Bernard Lazare lui-même, « se livrèrent à un extraordinaire travail de falsification des textes propres à devenir un appui pour leur cause [5]. »

30 décembre 1998

Notes

[1] R. Hilberg, The Destruction of the European Jews, éd. de 1961, Chicago, Quadrangle Books, p. 570 ; éd. de 1985, New York, Holmes and Meier, p. 889-891. « Les quantités [de Zyklon B] demandées par Auschwitz, sans être énormes, étaient néanmoins appréciables. La presque totalité des approvisionnements du camp servait au gazage des gens ; très peu servait à la désinfection. Ce n'était pas l'administration du camp qui achetait le gaz. Les commandes étaient passées par l'Obersturmführer [lieutenant] Gerstein, chef de la désinfection du Bureau du chef de l'hygiène de la Waffen-SS (Mrugowski). En règle générale, toutes les commandes passaient par les mains de la Testa, de la Degesch et de Dessau. Les usines [de] Dessau, qui produisaient le gas, expédiaient directement celui-ci à la Division d'extermination et de désinfestion (Abteilung Entwesung und Entseuchung) d'Auschwitz », La Destruction des juifs d'Europe, Paris, Fayard, 1988, p. 771-772.

[2] Transcription, p. 1130-1133.

[3] Id., p. 1236-1237.

[4] « élimination de la vermine, ou fumigation. ». Éd. de 1961, p. 658, note 94 ; éd. de 1985, p. 1023, note 94 ; dans l'édition française, p. 883, note 94, où la définition donnée est « désinfection, ou désinfection par fumigation ».

[5] B. Lazare, L'Antisémitisme, son histoire et ses causes, Paris, La Vieille Taupe, 1982, p. 24.

Labels: Abteilung Entwesung und Entseuchung, Auschwitz, Bernard Lazare, Butz, Douglas Christie, Entwesung, Gerstein, Hilberg, Walter Dötzer, Zündel, Zyklon B
