<!-- http://robertfaurisson.blogspot.com/2013/10/la-victoire-du-revisionnisme-sur-le.html -->

<!-- Wednesday, October 2, 2013 -->

# La victoire du révisionnisme sur le plan historique et scientifique

## Préface au volume VII d’Écrits révisionnistes (2008-2010)

*Les quatre premiers volumes de mes* Écrits révisionnistes (1974-1998), *publiés, pour la première édition, en 1999 ont connu en 2004 une seconde édition de 2 082 pages. Le cinquième volume (1999-2004), paru en 2009, contenait 522 pages. Le sixième volume (2005-2007), paru en 2011, comprenait 383 pages. Ce septième volume (2008-2010), publié en 2013, contient 375 pages. Soit, pour le moment, un total de 3 362 pages. Le huitième volume (2011-2013) devrait paraître en 2015. Les commandes sont à adresser aux Éditions Akribeia, 45/3, route de Vourles, 69230 Saint-Genis-Laval (site Internet : www.akribeia.fr). Peuvent également se commander à la même adresse une dizaine d’ouvrages ou opuscules d’inspiration révisionniste (en littérature ou en histoire) que j’ai fait paraître de 1961 à 2007 sans compter nombre d’ouvrages d’auteurs français ou étrangers qui ont leur place dans une bibliothèque révisionniste. C’est grâce à Jean Plantin, responsable d’Akribeia, à son énergie, à son courage dans l’épreuve que ce tour de force a été réalisé. Saura-t-on jamais lui en être assez reconnaissant ?*

À près de 85 ans, à l’heure où la Parque noire (l’inflexible Atropos) me gratte le fil, je m’interroge encore sur la raison pour laquelle, né en 1929, j’ai décidé vers 1974, à l’âge de 45 ans et après bien des années de recherches, surtout au Centre de documentation juive contemporaine de Paris (CDJC), de sacrifier le reste de mon existence au profit d’une aventure intellectuelle qui, je dois en faire l’aveu, relevait d’une forme de donquichottisme. Dès le premier instant de mon combat en faveur de la cause du révisionnisme historique, j’ai eu conscience de la faiblesse de mes moyens et j’ai pensé que, de mon vivant, jamais je ne verrais le triomphe d’une si vaste entreprise. Mais qu’en serait-il plus tard ? J’ai d’abord longtemps douté des chances que pouvait avoir notre cause d’atteindre le grand public, même après ma mort, quand un jour, en 1995, aux États-Unis, constatant sur place la prodigieuse expansion d’Internet, j’ai par la suite, peu à peu, acquis la certitude que plus rien ne pourrait arrêter le cours du révisionnisme. Les révisionnistes n’étant pas des prévisionnistes, surtout à long terme, je ne saurais dire quand, au XXI^e^ siècle, notre cause aura gagné la partie mais inéluctablement l’heureux événement se produira, non toutefois sous la forme spectaculaire d’une soudaine apocalypse. La révélation se fera graduellement de la même façon que, soudain, un beau jour, on finit par découvrir qu’une croyance générale et de nature religieuse, comme, par exemple, celle du communisme stalinien, au fond, tout bonnement, vient de « faire son temps ». Il en va parfois des mouvements de l’histoire comme des cycles biologiques. Proust a su décrire ces longs sommeils, ces cauchemars persistants, qui se prolongent au-delà du réveil et qui continuent de nous tromper jusqu’au moment où, de manière progressive, il nous est enfin donné de constater notre retour à la lumière, à la conscience, à la vie, à la vérité physique des êtres et des choses.

## Le révisionnisme : son vrai sens, sa consolidation

Les trois années qui vont de janvier 2008 à décembre 2010 témoignent de la montée en force et de la consolidation, en France comme ailleurs, du révisionnisme, un phénomène que, pour le dénigrer, ses adversaires appellent le « négationnisme ». Ce néologisme ou ce barbarisme prétend stigmatiser le refus de l’évidence. Or, dans leur matérialisme, pour ne pas dire leur positivisme, les révisionnistes acceptent pourtant tout ce qui est de l’ordre de l’évidence (un fait, un document, une photographie, un film, un témoignage) mais ils se font aussi une obligation de n’accepter de croire à cette évidence que sous bénéfice d’inventaire. Après avoir vu, lu ou entendu, ils s’astreignent à revoir, à relire et, quand c’est possible, à réentendre. Ils pèsent ou soupèsent. Ils examinent ou scrutent. Il est bien connu qu’en temps de guerre la première victime à succomber sera la vérité ; aussi, quand il se voit demander de croire en une « évidence » qui est en rapport avec une guerre, le révisionniste redouble-t-il, dans son enquête, de prudence et de lenteur. En outre, les images d’atrocités « nazies » de la Seconde Guerre mondiale, assorties de commentaires haineux, surtout quand ces atrocités sont mises sur le compte d’un vaincu qui se retrouve à la merci de son vainqueur, exigent de la part de l’historien un redoublement d’attention, de prudence et de lenteur. Le révisionniste ne croit pas en la justice du plus fort telle qu’elle s’est exprimée, par exemple, à l’occasion du « procès de Nuremberg » (1945-1946) ou de mille autres procès de même calibre où les vainqueurs jugent le vaincu sans lui accorder, sinon en apparence, le droit de se défendre. En droit, le « procès de Nuremberg » (1945-1946) – à proprement parler le « procès-spectacle de Nuremberg » – est une « voie de fait » comparable, toutes proportions gardées, au « traité de Versailles » (1919), lequel, pour sa part, devrait être appelé le « diktat de Versailles ». Comme j’ai eu l’occasion de l’écrire, le vainqueur est toujours un bon boucher et le vaincu, un moins bon boucher ; à la fin d’une guerre, le vainqueur peut, au vaincu, administrer des leçons de boucherie mais il ne saurait lui infliger des leçons de droit, de justice ou de vertu.

## Quand les Américains tuent et mentent

Le « procès de Nuremberg » a été, pour l’essentiel, une opération américaine. Le film qu’en lever de rideau les Américains ont présenté dès le 29 novembre 1945 sous le titre de *Nazi Concentration Camps* n’a été que l’une des plus audacieuses impostures que l’Histoire ait jamais connues. Encore aujourd’hui, soixante-huit ans plus tard, des millions d’enfants auxquels on prétend enseigner l’histoire de la Seconde Guerre mondiale ingurgitent de force le poison instillé par les auteurs de ce film. J’ai suffisamment traité de ce sujet pour n’y pas revenir ici [1]. Cela dit, la prouesse de Truman et d’Eisenhower dans le lancement officiel de ce mensonge aux proportions hollywoodiennes mérite qu’on la salue au passage. Pas un pays au monde, y compris l’Union soviétique, alors alliée des États-Unis, n’est parvenu avec un succès aussi durable au renversement de la vérité vérifiable sur le compte de l’Allemagne vaincue.

Pour commencer, tout au long d’une bonne partie du XX^e^ siècle et au début de ce XXI^e^ siècle, les États-Unis d’Amérique auront été, sur le chapitre des horreurs et des atrocités de la guerre, les champions du monde en presque tous les points du globe et par tous les procédés imaginables. Ce n’est pas que le peuple américain soit plus inhumain que tout autre peuple. Pour être juste, c’est sa puissance économique, bancaire, industrielle et scientifique qui lui a permis de tuer et de mutiler plus d’hommes, de femmes et d’enfants que toute autre nation au monde. Sa force, également remarquable, dans le maniement de la propagande, du cinéma, des moyens modernes de communication lui a en grande partie permis de donner au caractère exceptionnellement inhumain de ses propres actions guerrières l’apparence d’une guerre pour les droits de l’homme. Comme bien d’autres, les Américains claironnent que, s’ils font la guerre, c’est pour la paix. Cependant, chez eux, où tout s’automatise si vite, il s’agit, comme on peut le constater, d’une guerre perpétuelle pour une paix perpétuelle. La bouche en cœur ― mais cette bouche est celle de la Gorgone ―, ils nous font valoir que pas un peuple ne serait plus aimant que le leur. *« We are good! »* (Nous sommes bons !), *« We love you! »* (Nous vous aimons !) ou *« God is love! »* (Dieu est Amour !) : c’est le thème du discours qu’ils nous tiennent en préambule avant d’ajouter : *« Do love us! »* (Aimez-nous bien !). Sous-entendu : si vous êtes durs au point de fermer vos cœurs à nos décisions, vous le paierez, selon les cas, du boycott de votre pays, de l’embargo, de la famine, de l’excommunication humanitaire ou encore, si nécessaire, nous nous ferons comprendre à la bombe, au napalm, à l’agent orange, à l’uranium appauvri, aux missiles lancés de nos drones et, le cas échéant, à la bombe atomique. En outre, c’est, la Bible à la main ou dans le cœur, que nous vous châtierons pour l’amour de Dieu ou, plutôt, de Yahweh. Car, s’il est un pays au monde où le Dieu vétéro-testamentaire de haine et de vengeance, incapable de clémence, garde encore une bonne part de son crédit, c’est l’Amérique. L’agent de transmission du mal y est la religion de « l’Holocauste », dont la jeunesse du pays est imprégnée. Pas un peuple aujourd’hui n’est plus dangereux que le peuple américain en la personne de ses dirigeants. S’il lui arrive en telle circonstance de renoncer à telle aventure guerrière, ce n’est que partie remise ; tôt ou tard, il reviendra à sa « mission », à sa « croisade » messianique.

## Le révisionnisme prémunit contre le mensonge et la guerre

Le révisionnisme historique, lui, est salutaire : il tend à prémunir contre la haine et le mensonge, contre la guerre et les guerres. Non sans l’accent de la gouaille, Louis-Ferdinand Céline en a fait la remarque : le bien comme le mal se paie tôt ou tard et « le bien, c’est beaucoup plus cher, forcément ». Il nous rappelle par là que de remarquables bienfaiteurs de l’humanité ont cher payé le bien qu’ils ont fait à l’homme. Il faut voir à quel point, des siècles durant, on a cruellement traité les novateurs et tous ceux qui, ne se contentant pas de « chercher », ont eu le malheur de « trouver » et de révéler au grand public combien celui-ci était abusé par les apparences. Céline, pour sa part, songeait en particulier à Harvey, à Galilée ou à Philippe-Ignace Semmelweis, ce médecin hongrois (1818-1865), peut-être juif, qui allait, pour son malheur, découvrir les causes de la fièvre puerpérale (à force de persécutions exercées par les sommités médicales et les esprits forts de son temps, il aurait, selon certains de ses biographes, mis fin à ses jours). Parce qu’ils font le bien, tout en s’attirant l’hostilité des puissants, les révisionnistes sont condamnés à le payer cher. Sitôt après avoir lu *Le Mensonge d’Ulysse de Paul Rassinier* [2], Céline a compris que l’auteur allait lourdement payer son donquichottisme et la générosité de son entreprise révisionniste ; il suffit à ce propos de lire la lettre qu’il adresse le 8 novembre 1950 à Albert Paraz [3].

## Il faudra rendre justice au révisionnisme

Le jour viendra où les nouvelles générations rendront justice aux révisionnistes. Le flot des ordures déversées sur P. Rassinier et ses successeurs, la répression qui s’exerce à leur encontre, le conformisme et la couardise dont font preuve devant cette répression les autorités politiques, religieuses, judiciaires et universitaires de notre temps susciteront alors l’incompréhension ou l’indignation. Cette forme de tyrannie exercée contre les révisionnistes ne sera pas plus admise qu’on n’admet aujourd’hui, chez bien des Occidentaux, la tyrannie judéo-sioniste en terre de Palestine. Voilà soixante-huit ans depuis la fin de la Seconde Guerre mondiale que, jusqu’aux jeunes enfants du monde occidental, on ose imposer comme une vérité d’évidence la Sainte Trinité du prétendu « Holocauste » des juifs. Selon nos religionnaires, 1) pendant la Seconde Guerre mondiale un ordre aurait été donné par les plus hautes instances allemandes, et transmis par leur bureaucratie, de tuer tous les juifs, et un vaste programme de tuerie systématique aurait été ainsi établi et exécuté; 2) l’arme spécifique de ce crime spécifique et sans précédent aurait été la chambre à gaz homicide ; 3) le total des victimes juives aurait atteint soit six millions soit, à tout le moins, plusieurs millions. Le scandale réside dans le fait qu’au bout de soixante-huit ans on reste encore incapable de fournir une seule preuve à l’appui de cette triple accusation. Les révisionnistes, de leur côté, ont accumulé victoires sur victoires et preuves sur preuves de ce que leurs adversaires ont triché [4]. S’il fallait aujourd’hui prendre exemple sur ces magistrats français qui, appartenant à un syndicat de gauche, ont récemment affiché, dans leur local privé, sur un « Mur des cons », des photographies de personnalités leur ayant déplu, les révisionnistes, eux, pourraient un jour, afficher une interminable « Liste des imposteurs » à la manière d’Élie Wiesel, de Simon Wiesenthal, de Claude Lanzmann, du père Patrick Desbois et d’une foule de trompeurs et de trompeuses en tout genre. Peut-être le jour viendra-t-il où une encyclopédie en ligne nous fournira une liste exhaustive de ces gens avec le rappel, références à l’appui, de leurs mensonges, de leurs calomnies et de leurs violences ainsi que des crimes légaux ou illégaux qu’ils ont commis contre les révisionnistes.

## Déjà, chez les historiens, la chambre à gaz nazie se fait de plus en plus rare

Le dogme de la Trinité holocaustique continue de s’imposer à une grande partie du monde mais il trouve de moins en moins d’historiens pour le soutenir et pour argumenter en sa faveur. Telle est la leçon que le lecteur attentif peut tirer des récents ouvrages – d’apparence historique ou scientifique – de la bibliographie holocaustique. Je suis frappé par la raréfaction, depuis quelques années chez ces historiens, de mots tels que « chambre à gaz », « gazer », « gazages ». Manifestement ils perdent foi en « la magique chambre à gaz ». On la mentionne parfois encore, cette arme de destruction massive, mais à la va-vite. On ne s’y attarde plus. On marmonne encore ces mots mais comme dans les formules rituelles du moulin à prières. Dans l’avant-dernier programme trimestriel du Mémorial de la Shoah de Paris (avril-août 2013, 60 pages) on ne rencontrait pas même une seule fois les mots de la famille de « chambre à gaz », « gazage », « gazer » ; dans la version en ligne, à la recherche automatique du mot « gaz » et de ses dérivés, la réponse était : « introuvable ». Dans la dernière livraison du même programme (septembre-décembre 2013, 52 pages) on ne relève qu’une fois ce mot, sous la forme « gazés » (p. 25), et cela à propos d’un gazage qui, comme l’a établi dès le 1<sup>er</sup> décembre 1944 une expertise du professeur René Fabre, n’a jamais pu avoir lieu [5]. À la date, mémorable entre toutes, du 27 décembre 2009, « le dernier des Mohicans », parmi les historiens et chercheurs, à vouloir prouver l’existence de « l’Holocauste », a fini par capituler. À cette date, en effet, le professeur Robert Jan van Pelt [6], juif néerlandais établi au Canada, qui avait voué toute une partie de sa vie à la sauvegarde du mythe d’Auschwitz, centre mondial de l’extermination des juifs, a fini par rendre les armes ; il a écrit qu’au lieu de dépenser pour la conservation d’Auschwitz tant d’efforts et d’argent, on ferait mieux de laisser la nature y reprendre ses droits car, tout bien réfléchi, 99 % de ce que « nous savons » sur ce camp (ses chambres à gaz, etc.) ne trouve pas sa preuve sur le terrain [7]. Le grand public, lui, a évidemment été tenu dans l’ignorance de cette capitulation. Au contraire, plus que jamais on invite le monde entier et surtout la jeunesse à venir voir sur place, à Auschwitz, les prétendues preuves, rassemblées sous la forme d’entrepôts de reliques : à défaut de fournir des preuves matérielles on y fait parler des chaussures, des brosses à dents, des cheveux qui n’étaient en réalité que de purs objets de « récupération » ou de « recyclage » en temps de guerre (les cheveux, en particulier, pour l’industrie textile).

Dès 1992, apprenant qu’allait s’ouvrir à Washington un gigantesque bunker-musée de « l’Holocauste », j’avais publiquement annoncé que j’attendais de voir comment on allait nous y représenter sous une forme physique le mécanisme nécessaire au fonctionnement d’une chambre à gaz conçue pour mettre à mort, jour après jour, nuit après nuit, des foules de détenus à Auschwitz. Or, en 1993, à l’ouverture officielle de l’énorme musée, il se révélait que mon défi n’avait pu être relevé [8]. Au lieu d’une chambre à gaz homicide dans son intégralité on nous offrait en guise de consolation le fac-similé de la porte de ce qui, en fait, n’avait été qu’une simple chambre à gaz d’épouillage du camp de... Majdanek. Il est vrai qu’en outre une maquette artistique était censée nous représenter un amoncellement de cadavres dans une pièce du crématoire II ou III d’Auschwitz-Birkenau mais cette pièce était dépourvue de tout dispositif, mécanique ou autre, soit pour la mise à mort des victimes, soit pour la surpuissante ventilation du lieu afin qu’après le gazage un personnel chargé de manipuler, d’enlever et de transporter des milliers de cadavres puisse le faire sans risque d’empoisonnement instantané. Supposée être une « chambre à gaz nazie », elle n’était en réalité qu’un inoffensif dépositoire semi-enterré (*Leichenkeller*), désigné comme tel sur les plans de construction que j’avais découverts le 19 mars 1976 dans les archives du musée d’État d’Auschwitz-Birkenau [9] et qui, jusque-là, avait été soigneusement cachés. Cependant ladite maquette était d’une pauvreté, d’un schématisme et d’une abstraction si affligeants que, dans le livre-guide du musée (212 pages), seuls de vagues fragments, quasi immatériels, en avaient été reproduits. Le 24 août 1994, lors d’un entretien dans son bureau directorial, le rabbin Michael Berenbaum, à qui j’avais posé la question de savoir pourquoi mon défi n’avait pas été relevé, m’avait répondu avec un beau sang-froid que, si son musée n’abritait pas de représentation d’une chambre à gaz nazie, c’est que la décision avait été prise de ne pas y représenter une telle chambre à gaz ! Il me faisait cette réponse en la présence de quatre témoins : deux Américains qui m’accompagnaient et deux hauts administrateurs du musée convoqués pour la circonstance. Sagement assis sur un sofa, ces deux derniers hommes, consternés, allaient assister à la pitoyable prestation de leur responsable scientifique, le rabbin Berenbaum, aux prises avec un révisionniste bien décidé à ne s’en pas laisser conter.

Nul doute, en tout cas, que, face à la raréfaction depuis quelques années des « chambres à gaz nazies » dans les ouvrages historiques, des personnages comme Élie Wiesel et Claude Lanzmann ont dû pousser un soupir de soulagement. Les historiens paraissent avoir enfin entendu les admonestations que ces belles consciences, alarmées par les progrès du révisionnisme, lançaient au début des années quatre-vingt-dix. Ils semblent avoir compris que mieux vaut porter son attention ailleurs que sur « la chambre à gaz nazie ». É. Wiesel, pour sa part, a écrit : « Les chambres à gaz, il vaut mieux qu’elles restent fermées au regard indiscret. Et à l’imagination » (*Tous les fleuves vont à la mer. Mémoires,* Le Seuil, Paris, 1994, p. 97). C. Lanzmann, lui, a écrit : « Si j’avais trouvé [un film nazi montrant un gazage de juifs à Auschwitz], non seulement je ne l’aurais pas montré, mais je l’aurais détruit. Je ne suis pas capable de dire pourquoi. Cela va de soi » (« Holocauste, la représentation impossible », *Le Monde,* 3 mars 1994 [10]).

« Porter son attention ailleurs que sur la chambre à gaz nazie », soit ! Mais où exactement ? Il ne reste à ces historiens que deux directions de recherche : 1) celle d’un ordre d’exterminer les juifs (à trouver, si possible, dans les documents des *Einsatzgruppen* ou « groupes d’intervention »), 2) celle de la réalité du chiffre de six millions de juifs (ou un chiffre approchant). Or, dans l’un et l’autre cas, ils ont fait chou blanc comme pour « la chambre à gaz nazie ». Répétons-le : les juges-accusateurs de l’Allemagne nationale-socialiste ont échoué sur toute la ligne. Ils ont appris à leurs dépens qu’on ne saurait découvrir dans le noir un chat de couleur noire, surtout quand ledit chat ne s’y trouve pas.

## Toujours aucun ordre d’extermination physique des juifs

Ainsi que je l’ai, par ailleurs, démontré, pas un seul document ne prouve qu’il ait existé un ordre de procéder à la destruction physique des juifs d’Europe. On a multiplié les tentatives en vue de nous faire croire que tel nouveau document contenait un ordre de ce genre mais, nous disait-on toutefois, cet ordre s’y trouvait seulement sous une forme cachée, cryptique, sous-entendue ou « codée ». En vain. J’ai examiné de près chacune de ces tentatives, j’ai décrit les traductions erronées, frauduleuses, les falsifications de texte et j’ai conclu : « Assez décodé ! » La formule semble alors avoir refroidi les ardeurs de nos marchands d’orviétan. Le sens commun nous l’enseigne : si, depuis la guerre, on avait trouvé un seul texte de Hitler, de Himmler (avec ses discours prétendument secrets de Posen), de Göring, de Goebbels ou de moindres sires ordonnant d’éliminer les représentants de la race juive, ce texte aurait été brandi et publié partout et dans toutes les langues du monde. La tentative la plus grotesque pour nous abuser aura peut-être été soit le texte du « procès-verbal de Wannsee », soit les documents de l’« Aktion Reinhard » (sic, c’est-à-dire sans le « t » final et comme s’il s’était agi du prénom que portait le chef du SD Reinhard Heydrich !).

## « Wannsee » : sans le vouloir, Édouard Husson lui administre le coup de grâce en 2012

J’ai beaucoup écrit sur la thèse selon laquelle le texte du compte rendu de la très brève rencontre de Berlin-Wannsee, tenue le 20 janvier 1942 (pendant une heure et demie ?) sous la présidence de Reinhard Heydrich, loin d’apporter la preuve qu’il existait un ordre d’exterminer les juifs, prouvait que, pour les Allemands, les juifs seraient pendant la guerre astreints au travail forcé ; après quoi, ceux d’entre ces juifs qui auraient survécu aux épreuves seraient, à leur remise en liberté, à tenir pour une élite naturelle permettant une renaissance juive. Il suffisait d’une lecture attentive du texte pour constater cette évidence. Au dernier alinéa de la page 7 et au premier alinéa de la page 8 du document, il était dit en toutes lettres que les juifs capables de travailler seraient déportés vers l’Est, en colonnes de travail, les hommes d’un côté et les femmes de l’autre, tout en construisant des routes. Vu la séparation des sexes et la dureté de ce type de travail forcé, « sans doute une grande partie d’entre eux s’éliminera-t-elle par réduction naturelle. – Ce qu’il en restera de toute façon à la fin, vu qu’il s’agira sans doute de la partie la plus résistante, devra être traité de façon appropriée, parce que, constituant une sélection naturelle, ce reste, à sa remise en liberté (*bei Freilassung*), sera à considérer comme la cellule germinative d’une renaissance juive (*als Keimzelle eines jüdischen Aufbaues*). » Or, au lieu d’une lecture attentive de ces deux alinéas, les historiens ont élucubré. Ils l’ont fait dans une plaisante cacophonie. À telle enseigne qu’Édouard Husson, le plus naïf d’entre eux, a recensé dix-huit interprétations, dont la sienne, de ce qu’il appelle, sans autre précision, « l’ordre donné aux *Einsatzgruppen* » (*Heydrich et la solution finale,* préface de Ian Kershaw, postface de Jean-Paul Bled, Perrin, Paris, 2012, 767 p., p. 701-706 ; il s’agit d’une édition « revue et augmentée », la première, de 487 pages, datant de 2008). Si les *Einsatzgruppen* ou tout autre corps militaire, étatique ou administratif avait vraiment reçu un pareil ordre de tuer les juifs, les historiens n’en seraient pas encore à spéculer ainsi et à produire dix-huit hypothèses dont chacune, presque à chaque fois, nous est présentée comme la vraie preuve qu’un ordre aussi barbare aurait été donné. Le cas d’É. Husson est étrange. Professeur à l’université de Lille, cet universitaire a cautionné l’entreprise du père Patrick Desbois [11], le sacré farceur de la « Shoah par balles » et de la « Shoah par étouffement ». Le bon père, on le sait, osait nous dire qu’à l’Est il avait personnellement découvert huit cents charniers contenant au total un million et demi de cadavres juifs mais, à l’appui d’une telle accusation, il ne produisait rigoureusement aucune preuve ni aucun cadavre de juif exécuté. Comment expliquer ce mystère ? Rien de plus simple. Il nous l’affirmait : 1) le cadavre d’un juif victime de la Shoah est sacré ; 2) il est le cadavre d’un saint; 3) c’est un rabbin consulté à Londres qui lui a certifié cela ; 4) il n’est donc question ni d’aller ouvrir un seul de ces charniers ni d’exhumer, ni d’examiner, ni enfin de produire à la vue des incrédules ou des sceptiques un seul cadavre juif ! Mais, pour en revenir à É. Husson, je constate qu’il a également commis l’imprudence de bâtir son ouvrage sur un faux aussi notoire que la prétendue réflexion de Hitler : « Qui parle encore, aujourd’hui, de l’anéantissement des Arméniens ? » (titre du chapitre 6, p. 191-211 ; voy. mon article « Gilbert Collard joue la carte de la Shoah et de Marine Le Pen » [6 juin 2011]). Par ailleurs, ses démonstrations sont entachées de « spéculations » qu’il lui arrive parfois d’avouer ingénument, par exemple quand il écrit : « Faute de documents, on doit laisser une part à la spéculation... » (p. 188). Mais ce n’est pas tout. Comme tant d’autres il nous donne à entendre que les expressions soit de « solution finale », soit de « solution finale de la question juive », soit encore de « solution finale de la question juive en Europe » n’étaient que des euphémismes pour désigner un programme d’extermination physique des juifs d’Europe. Observons pour commencer que la recherche de la solution finale d’une question quelconque, celle du chômage, par exemple, n’implique pas nécessairement qu’on se propose de tuer en masse les intéressés, c’est-à-dire les chômeurs. Mais surtout, É. Husson nous cache que les trois formulations qu’il nous cite n’étaient pas les seules : il arrivait aux Allemands de parler d’ « une solution finale territoriale de la question juive [12] ». Pour Hitler, il fallait trouver à la fin des fins la solution d’un problème aussi vieux en quelque sorte que le peuple juif lui-même ; cette solution aurait consisté à donner une terre à un peuple sans terre, c’est-à-dire un foyer qui fût propre aux juifs. En quel point du globe au juste ? On verrait cela plus tard, après la guerre. Avec une guerre à livrer sur quatre fronts (Est, Ouest, dans le ciel et sur la mer), Hitler avait bien d’autres soucis que « la question juive ». En 2012, pour ajouter à ses bévues, le malheureux É. Husson en était encore à nous entretenir de l’« Aktion Reinhard » (sic) comme si cette « action » portait pour étiquette le prénom du susmentionné Heydrich et désignait, par conséquent, une entreprise exterminatrice dans des « camps d’extermination » (néologisme de la propagande judéo-américaine), alors qu’en réalité – les documents l’attestent – l’« Aktion Reinhardt » (avec un « t ») tenait son nom de Fritz Reinhardt, secrétaire d’État aux Finances, et concernait essentiellement les biens confisqués aux Polonais ou aux juifs avant leur entrée ou à leur entrée dans des camps de transit comme Treblinka, Sobibor ou Belzec. Déjà au colloque de la Sorbonne tenu en 1982 contre les révisionnistes et, en particulier, contre ma personne, l’historien allemand Uwe Dietrich Adam avait mis ses collègues en garde contre le genre d’erreur où, trente ans plus tard, l’on voit donc tomber É. Husson [13].

## Les Six Millions : un slogan publicitaire remontant à 1900 !

Certes le chiffre de six millions de victimes juives a été qualifié de « symbolique » dès 1960 par l’historien Martin Broszat, qui allait devenir le directeur de l’Institut d’histoire contemporaine de Munich de 1972 à 1989. En bon allemand comme en bon français, « symbolique » est ici un mot auquel on a recours pour éviter d’avoir à dire franchement que ce chiffre est « non fondé sur des preuves » ou « imaginaire ». Mais d’où pouvait bien provenir ce chiffre et qui avait bien pu le lancer pour la première fois ? À ces questions on trouvera une réponse détaillée dans un article que j’ai intitulé « L’imposture des 6.000.000 : source et histoire d’une mirobolante arnaque » ; datée du 18 juin 2009, cet article comporte deux compléments, l’un de 2011 et l’autre de 2013. On y verra que nous devons cette découverte à un avocat américain du nom de Don Heddesheimer, auteur de *The First Holocaust. Jewish Fund Raising Campaigns With Holocaust Claims During and After World War One (Le Premier Holocauste. Campagnes juives de levées de fonds au titre d’un holocauste, pendant et après la Première Guerre mondiale),* Theses & Dissertations Press, Chicago, 2003. « En ce moment, en Europe, six millions de nos frères juifs sont en train de mourir [à cause, successivement, ou des tsars ou des Russes ou des Ukrainiens, ou des Polonais, etc.]. Il faut leur venir en aide. Nous comptons sur votre générosité ! » De l’année 1900 (pour le moins) jusqu’à la Seconde Guerre mondiale, cet appel au portefeuille ou ce slogan publicitaire a été inlassablement répété en particulier dans le *New York Times,* par des responsables juifs tels que le rabbin Stephen Wise (1874-1949). Ce dernier, un proche du président Roosevelt, était un membre éminent de l’American Federation of Zionists et de l’International Zionist Executive Committee; il avait aussi été le président-fondateur de l’American Jewish Congress. Il a joué un rôle capital dans le lancement du mensonge historique de « l’Holocauste » et dans le succès de la formidable escroquerie politico-financière qui s’en est suivie. Le 8 février 2012, un certain « Toshiro », visiteur régulier du site www.codoh.com (Committee for Open Debate on the Holocaust) de Bradley Smith, a pu porter à 236 le nombre d’occurrences dans la presse américaine, entre 1900 et 1945, du slogan publicitaire des six millions [14]. À force de se l’entendre répéter et à force de le lire dans leurs journaux, on comprend que nombre de juifs américains et surtout des juifs new-yorkais de bonne foi aient fini par se mettre en tête cet « holocauste » de six millions de victimes juives dans une Europe devenue à leurs yeux férocement « antisémite ». C’est ainsi que, d’une certaine manière, les juifs eux-mêmes sont à compter parmi les dupes d’un énorme mensonge historique qui les a fait vivre, penser, raisonner et calculer dans un ghetto mental où l’on voit qu’ils ont perdu le sens des réalités matérielles et des chiffres.

On ne comprend que trop le silence total des historiens officiels lorsque, à partir de 2003, Don Heddesheimer et ses successeurs ont révélé le pot aux roses des Six Millions. Cette découverte de la source malodorante et commerciale des Six Millions confirmait ce qu’en 1980 j’avais déclaré dans ma « phrase de soixante mots » sur le fait que le mensonge historique de « l’Holocauste » avait ouvert la voie à une « gigantesque escroquerie politico-financière ». Impossible de mieux tomber : le monstrueux bobard avait pris forme dans une mirobolante truanderie née des milieux juifs de New York.

## L’irrésistible poussée du révisionnisme

À partir de la fin de 1978, la poussée du révisionnisme et ses victoires se sont révélées d’une telle ampleur qu’à la veille de l’année 2012 un journal comme *Le Monde,* pourtant si hostile à ce qu’il appelle « le négationnisme », s’est finalement vu contraint d’en faire l’aveu, sur le ton de l’amertume, et cela dans un éditorial paru en première page de sa livraison du 23 décembre 2011. Sous le titre : « Les lois mémorielles ne servent à rien. Hélas ! », le lecteur a été invité à prendre acte du fait que la « loi Faurisson » ou « loi Fabius-Gayssot » du 13 juillet 1990 n’a pas réussi à entraver le développement du révisionnisme historique, et de ce que les révisionnistes maintenant « ont pignon sur rue, comme jamais, grâce notamment à Internet [15] ». Nous sommes loin d’avoir « pignon sur rue » mais il est exact qu’en dépit d’une répression judiciaire et extrajudiciaire nous avons poursuivi notre combat et gagné toutes les batailles sur le plan strictement historique et scientifique.

Jamais *Le Monde* n’a informé ses lecteurs de ce que le plus prestigieux des historiens de « l’Holocauste », l’Américain Raul Hilberg, avait, dès 1982, rendu hommage à la qualité des travaux de « Faurisson et d’autres » et de ce que le même Hilberg avait été obligé de revoir de fond en comble sa thèse originelle de *The Destruction of the European Jews* (première édition en 1961, édition profondément révisée et « définitive » – sic – en 1985). Dans la première édition, l’auteur nous présentait la destruction des juifs d’Europe comme une vaste entreprise criminelle décidée par Hitler en personne qui aurait lancé deux ordres d’extermination (1961, p. 177); l’exécution de ces ordres se serait déroulée de manière normale avec un plan d’extermination nettement défini, un office central chargé de la sinistre besogne, des directives, etc. Or, soudain, dans la nouvelle édition on ne trouvait plus rien de tel. Tout y passait à la trappe, à commencer par le Führer et ses deux ordres : à leur place, comme par magie, voici qu’apparaissait une entité, la bureaucratie allemande, qui, comme par l’opération du Saint-Esprit, improvisait spontanément, sans aucun plan, sans office central, sans budget, sans rien, le plus grand massacre de l’histoire ; elle avait, paraît-il, progressivement renoncé à l’écrit pour l’oral et même pour la « transmission de pensée consensuelle » ; elle s’était mise d’elle-même à fonctionner sans laisser aucune trace de son crime, sans rien de concret, de visible, de vérifiable mais seulement grâce, en son sein, « à une incroyable rencontre des esprits, à une transmission de pensée consensuelle » (*« an incredible meeting of minds, a consensus-mind  reading », Newsday,* New York, 23 février 1983, p. II, 3). Du même coup et par voie de conséquence, l’historien d’après guerre qu’était Hilberg ne pouvait évidemment fournir aucune preuve, aucun texte, aucun document à l’appui de son assertion selon laquelle le III^e^ Reich avait « détruit » ou « voulu détruire » par millions les juifs d’Europe. En apparence, il réussissait là un coup de maître : il s’épargnait l’effort de partir à la recherche d’introuvables preuves et, en complément, il montrait le caractère profondément diabolique de ces Germains capables par le seul fait de leur haine du juif d’inventer, d’élaborer, de construire et de mener à bien, dans la clandestinité et sans même le blanc-seing du bien-aimé Führer, une entreprise qui, à la fois par sa nature criminelle et par sa dimension industrielle, allait rester sans exemple dans l’histoire.

Ce naufrage du plus prestigieux des historiens de « l’Holocauste » allait être, dans la suite des années quatre-vingt et dans les années quatre-vingt-dix, suivi des fiascos de moindres ténors holocaustiques tels que Léon Poliakov, Pierre Vidal-Naquet, Jean-Claude Pressac ou Robert Jan van Pelt. Aujourd’hui, l’école « intentionnaliste » (pour qui il y avait nécessairement eu un ordre de Hitler mais on ne l’avait pas encore trouvé « malgré les recherches les plus érudites », pour reprendre les termes de la déclaration à la Sorbonne des deux organisateurs du colloque antirévisionniste mentionné plus haut, Raymond Aron et François Furet) a disparu corps et âme et l’école « fonctionnaliste » ou « structuraliste » (pour qui il n’y a pas lieu de chercher un ordre de Hitler ; tout s’est fait plus ou moins spontanément et sans laisser de traces) est dans les limbes. À ce jour, on est en droit d’affirmer qu’il n’existe plus d’historiens de « l’Holocauste » ni d’histoire de « l’Holocauste », même si les préposés des médias, eux, dans leur rôle de propagandistes, ne se gênent nullement pour ressasser au grand public que l’extermination des juifs fut sataniquement planifiée par « les nazis » jusqu’au dernier détail d’exécution. Il ne subsiste, parmi les historiens orthodoxes, que quelques tâcherons qui, en général, aux frais d’universités ou de fondations, reprennent les vieilles antiennes ou bien s’attardent à des aspects secondaires de la vie et du destin des juifs de 1933 à 1945.

En revanche, à défaut d’une Histoire de « l’Holocauste » il ne reste plus qu’une Mémoire de « l’Holocauste » ou de « la Shoah », qui se développe tel un cancer. À défaut d’historiens, on voit se ruer au service de cette Mémoire une masse de religionnaires, romanciers, théâtreux, cinéastes, documenteurs, journaleux, essayistes, penseurs, philosophes, propagandistes, conférenciers, folliculaires, batteurs d’estrade et de tambours. Ils tentent leurs chances ou font carrière dans le business et l’industrie de cette sacro-sainte Mémoire sous la bannière du clown et faussaire Élie Wiesel. Un petit nombre d’entre ces personnages recyclent indéfiniment leurs inventions ou déjections lesquelles, c’est manifeste, leur fleurent bon au nez et leur permettent de vivre et de se faire un nom. Régulièrement ils nous annoncent une trouvaille sensationnelle comme, par exemple, la découverte d’un mot ou d’une phrase qui, venant d’un « nazi », prouverait enfin, à la fin des fins, que l’Allemagne nationale-socialiste avait une politique d’extermination des juifs. Une semaine ou un mois plus tard le canard ne vole plus. Il ne reste qu’à attendre le passage du prochain volatile, du prochain bobard. Mais, encore une fois, à défaut de preuves scientifiques du crime, nous aurons droit aux clowneries shoatiques, au guignol, au spectacle de marionnettes illustrant la mort dans les chambres à gaz, à la danse macabre de « la Shoah », à la musique, à la BD, aux romans, aux spectacles sportifs comme la natation synchronisée de « l’Holocauste », aux recettes de cuisine des camps de la mort, à la gastronomie, à la pâtisserie de tel camp, aux concours de beauté de la Shoah où s’exhibent des octogénaires ou des nonagénaires rescapées d’Auschwitz ou d’autres « camps d’extermination ». Il arrive cependant que certains se lassent de leur rôle de « clown de l’Holocauste » ; tel a été tout récemment le cas du juif hongrois Imre Kertesz, rescapé des camps d’Auschwitz et de Buchenwald tout comme son compatriote É. Wiesel. Ce dernier avait reçu en 1986 le prix Nobel de la paix ; I. Kertesz, lui, a été en 2002 lauréat du prix Nobel de littérature. Le premier ne se lasse pas de son rôle de clown tandis que le second s’en est dégoûté :  *« Ich war ein Holocaust-Clown »* : « J’étais un clown de l’Holocauste » : tel a été, à la fin, son cri du cœur ; tel est le titre du long article que vient de lui consacrer l’hebdomadaire *Die Zeit* (12 septembre 2013, p. 47). Admirons ici l’attitude du Monde et des grands médias qui, autrefois, auraient, en un même chœur de lamentations et d’invectives, dénoncé l’outrage et qui, là, ont observé un silence religieux : une preuve de plus de ce que « les temps ont changé » et de ce que la croyance holocaustique est en péril.

La jeune génération, la troisième après 1945, ne s’y trompe pas. Dans de nombreux cas elle se révèle moins malléable que ses devanciers ; il lui arrive souvent de réagir, comme à une agression, à cet enseignement de « l’Holocauste » dont on l’assomme à l’école ou à l’université; elle se lasse vite de tout l’arsenal du matraquage obligatoire et se rebiffe ou se rebelle, quitte, par la suite, sous la pression des aînés, à présenter des excuses et à se couvrir la tête de cendres (voy. l’incident raconté par Mara Goyet, *Collèges de France,* Fayard, Paris, 2003, p. 89-90 [16]). Parfois aussi, les jeunes tournent en dérision cette forme de radotage qui consiste à leur débiter des récits stéréotypés, ennuyeux et pleurnichards. Là où le prof prononce « Shoah », l’écho répond « Show », ou « Chaud, chaud, chaud », ou « Nanas », ou « Ananas » ou, surtout, « Shoananas ». La force irrépressible du rire secoue jusque dans ses fondements l’édifice du Grand Mensonge. Les foules se pressent aux spectacles de Dieudonné qui, tel Aristophane ou Molière, par l’action purificatrice de la comédie, nous purge de nos dégoûts trop longtemps refoulés. Accompagnent Dieudonné en un joyeux charivari, surtout sur Internet, ces « antisimythes » ou « shoartistes » qui ont pour nom Chard, Konk, Zéon, Azim, Arkidinon, Joe Le Corbeau, Mister Mayo, Mérée Drante, Travis, Adolf, Bernamej, Hugo, Krampon, Rico Royco, Bluj, Bizz’Art le Détoucheur, Dedko, Teddijo, Eris, Sani, Boris Boiteux, Jakob, L’Artisan Quenellier, Stiopa, Révolutionnaire de la Quenelle, Mas, L’Andalou, Olive, J’aime-ça, Cyclone B, F. Nathan, Oggy, Ramo, Celestino, Anzar et d’autres encore : la police de la pensée n’y peut plus rien, le flot est devenu trop puissant. Entre Élie Wiesel et Dieudonné le choix est fait. À l’histrion qui-ment-et-qui-pleure-comme-il-respire l’homme libre toujours préférera le génie qui dit vrai et qui rit.

## Une répression inutile et indigne

La propagande holocaustique a pris de gigantesques proportions dans le monde entier, y compris dans une partie du monde musulman, par exemple au Maroc ; il n’est pas question de la voir diminuer de sitôt [17]. Quant à la répression du révisionnisme, elle a encore de beaux jours devant elle. En Allemagne et en Autriche elle garde toute sa sévérité mais ailleurs, là où parfois les lois mémorielles se voient contester, elle donne des signes d’essoufflement. En ce qui concerne les poursuites judiciaires contre les « vieux criminels nazis », elles présentent un certain nombre d’inconvénients pour la cause holocaustique. D’abord, elles aboutissent au spectacle à tout le moins troublant de nonagénaires « nazis » extraits de leurs mouroirs pour être traînés devant les tribunaux avec tout un appareillage médical; on se demande quelle haine, quelle soif de vengeance, quelle inhumanité foncière peuvent bien conduire à un tel degré d’inhumanité des justiciers qui, par ailleurs, font profession de dénoncer ce qu’ils appellent « les crimes contre l’humanité », des crimes, soit dit en passant, qu’on ne dénonce que chez les vaincus et jamais chez les vainqueurs. Ensuite, on s’avise de ce que la justice américaine, la justice israélienne et la justice allemande, conjuguant leurs efforts ou se relayant, peuvent accumuler une somme révoltante d’atteintes aux « droits fondamentaux de la personne humaine ».

L’exemple le plus criant est celui d’Ivan (devenu John) Demjanjuk, livré par les États-Unis à la justice israélienne qui l’a condamné à mort sur le fondement de preuves qui allaient se révéler fausses et de témoignages qui allaient également se révéler faux. Dans sa geôle, pendant cinq ans, chaque nuit et chaque matin, le malheureux a attendu qu’on vienne le chercher pour le pendre (ou l’étrangler comme Julius Streicher à Nuremberg). Il a fallu le miracle de l’effondrement de l’URSS et la soudaine révélation de la « fort probable fabrication » d’un document par le KGB, sans compter d’autres raisons encore, pour qu’en fin de compte on s’aperçoive que le gardien de Treblinka surnommé « Ivan le Terrible » n’était nullement Demjanjuk comme l’avaient assuré successivement tant de témoins juifs, mais un certain Marchenko qui ne lui ressemblait ni par l’âge ni par la corpulence ! Accusé en un premier temps d’avoir servi à Treblinka, finalement absous et relâché, revenu aux États-Unis, recouvrant la citoyenneté américaine dont il avait été privé à la demande des Israéliens et convaincu qu’il allait pouvoir enfin vivre ses derniers jours au milieu des siens, le voici qui, un jour, apprend qu’il va, sur la demande des Israéliens, être à nouveau poursuivi en justice, se voir à nouveau priver de la citoyenneté américaine, mais, cette fois-ci, simple changement de lieux et de décors, il va être livré à la justice allemande, et cela pour avoir été présent non plus à Treblinka – c’était une erreur (sic) – mais à Sobibor. Et là – merveilles des merveilles – le tribunal 1) se dispensera de toute preuve de ce que Demjanjuk ait commis quelque action criminelle ou autre que ce fût, 2) se passera de tout témoignage ! Poussé en chaise roulante devant ses juges, puis allongé sur une civière, âgé de 91 ans, il s’entendra condamner pour sa simple présence supposée au camp de Sobibor, qualifié de « camp d’extermination » alors qu’en réalité Sobibor faisait fonction de camp de transit. Il semble n’avoir pas plus été à Sobibor qu’il n’a été à Treblinka et il a toujours démenti s’y être trouvé. Et puis, quand même aurait-il été dans l’un de ces camps, il aurait fallu – n’est-ce pas ? – prouver qu’il y avait commis un crime. Eh bien, non : la cour de Munich va décider que sa simple présence (supposée) sur le lieu (supposé) d’un crime (supposé) le transforme *ipso facto* en un coupable avéré. Le fait que, dans le passé, des SS ayant exercé à Sobibor ou Treblinka aient été acquittés rend scandaleuse cette condamnation purement automatique de Demjanjuk pour sa seule présence supposée dans l’un ou l’autre de ces camps. Exemple : au procès de Sobibor, à Hagen (6 septembre 1965 – 20 décembre 1966), quatre SS ont été acquittés (*Encyclopedia of the Holocaust,* Macmillan, New York-Londres, 1990, article d’Yitzhak Arad, vol. 4, p. 1378). Il en est allé de même pour le procès de Treblinka, à Düsseldorf (12 octobre – 24 août 1965), où l’un des dix accusés a été acquitté (ibid., p. 1487-1488). Demjanjuk a donc été bien plus sévèrement traité par la justice allemande que ne l’ont été dans les années soixante des soldats de la SS. On ne lui a laissé aucune chance. Dix mois après sa condamnation, prononcée le 12 mai 2011, il expirait le 17 mars 2012.

Mais il y a pire que le travestissement de la justice : il y a l’hommage qu’un journaliste français peut rendre à des juges qui ont procédé à ce travestissement. Tel a été le cas de Nicolas Bourcier, journaliste du *Monde* qui a osé écrire que les juges de Munich ont réalisé « un tour de force juridique » (sic) et qui a conclu : « Près de soixante-dix ans après les faits [lesquels, exactement ? et comment peut-on juger un homme de 91 ans pour ce qu’il est censé avoir fait à 21 ans ?], la cour a abouti à la conclusion [comment ? par quelle voie ?], sans qu’aucun témoin direct ou survivant ait pu confirmer ses crimes [merci pour l’aveu mais où sont ces crimes, au pluriel, puisque pas un acte criminel n’a été établi ?], que John Demjanjuk avait bel et bien pris part “à toutes les étapes du processus meurtrier nazi” [si sa présence n’a été notée et décrite à aucune étape, comment peut-on dire qu’il a pris part à toutes les étapes ?]. Un tour de force [non : un renversant tour de passe-passe]. » Et Nicolas Bourcier de poursuivre : « Avec ce procès de Munich, les juges allemands ont montré que même au pays des bourreaux [l’Allemagne est toujours le pays des bourreaux !], le passé peut rattraper quiconque, où qu’il se trouve [quel est ce passé non défini, non décrit, non connu ?] », « Criminel nazi, gardien du camp de Sobibor, John Demjanjuk », par Nicolas Bourcier, *Le Monde,* 21 mars 2012, p. 30).

En Allemagne, en Autriche, aux États-Unis, dès qu’Israël l’exige, tous les droits de la personne humaine peuvent être ainsi bafoués dès lors qu’il s’agit de réchauffer les vieilles haines. Les Américains pratiquent sur leur propre territoire le kidnapping en plein jour de révisionnistes tels qu’Ernst Zündel ou Germar Rudolf et livrent leurs proies au Canada ou à l’Allemagne où la liberté d’opinion et même la liberté de recherche sont bafouées à l’extrême, ce qui est aussi le cas en Autriche. En Allemagne, Horst Mahler a été condamné à treize années de prison ! Y sont ou ont été récemment en prison, en plus d’Ernst Zündel et Germar Rudolf déjà nommés, l’avocate Sylvia Stolz (« la Jeanne d’Arc allemande »), Günter Deckert, Arnold Höfs, Axel Möller, Gerd Ittner et, en Autriche, Wolfgang Fröhlich et Gerd Honsik. La Suisse s’est déshonorée dans de nombreux cas et, notamment, dans ceux de Gaston-Armand Amaudruz, de René-Louis Berclaz et de Jürgen Graf. Le Canada a un comportement d’une remarquable hypocrisie qui a, par exemple, permis au juge Pierre Blais (un nom à garder en mémoire) de maintenir l’incarcération du révisionniste Zündel pendant deux ans dans des conditions dignes, par certains aspects, d’Abou Ghraib ou de Guantanamo. La victime a d’abord été livrée au Canada par les États-Unis, puis, au terme de ces deux années, le Canada l’a livrée à l’Allemagne qui, à son tour, l’a condamnée à cinq années d’emprisonnement pour des publications contraires à la sainte écriture de « la Shoah ».

En Italie, le prétendu « criminel de guerre » Erich Priebke, qui a 100 ans, est toujours en résidence surveillée ! En Allemagne, la chasse aux vieux nazis est organisée avec accompagnement de primes de délation, éventuellement au bénéfice des petits-enfants, petits-neveux, petites-nièces qui dénonceront le grand-père ou le grand-oncle qui pourrait intéresser la justice de leur pays. Au besoin l’accusé sera, comme Demjanjuk, jugé en chaise roulante ou sur civière. Il pourra être condamné sans preuve et sans témoin. L’avantage de ce type de procès, rapidement suivi de la mort d’un vieillard recru d’épreuves, est que le peuple allemand et la communauté internationale auront droit à des procès à grand spectacle. On leur fera ainsi revivre « les heures les plus sombres » et, conséquence non négligeable, on donnera corps et substance aux revendications d’associations juives spécialisées dans le commerce international des « réparations » financières, lesquelles engraisseront de plus belle les Madoff assez habiles pour ne pas se faire prendre en flagrant délit d’escroquerie. Ce gangstérisme de mafia « communautaire » est, pour leur honneur, dénoncé par des juifs conscients du tort ainsi causé à leur image. La dernière condamnation de Demjanjuk, sans preuves et sans témoins d’un crime quelconque, constitue une extraordinaire innovation et permet désormais de poursuivre en justice des personnes, par exemple, nées entre 1920 et 1925 : elles ont pu être inquiétées après la guerre et relâchées parce que considérées comme des lampistes ; cette fois-ci on recherchera les lampistes pour les livrer à la nouvelle justice allemande ! L’un d’eux a 97 ans. Hans Lipschis, lui, a 93 ans ; il a subi deux pontages coronariens. Pendant la guerre, jeune SS de 21 ans, il a travaillé comme cuisinier à Auschwitz. « De gazages il avait entendu parler mais il n’en a rien vu. » On ne lui connaît aucun crime. La justice allemande, en pleine connaissance de cause, jusqu’ici le laissait vivre en paix, mais, grâce à la « jurisprudence Demjanjuk », elle s’est empressée de se jeter sur sa proie (« Zahnrad in der Mordmaschine », *Der Spiegel,* no. 40, 30 septembre 2013, p. 42-44).

## Des juifs prennent conscience de ce qu’ils sont dans une impasse

En 2012, Alain Michel publie *Vichy et la Shoah. Enquête sur le paradoxe français,* préface de Richard Prasquier, président du CRIF (Conseil représentatif des institutions juives de France), CLD éditions, Paris, 408 p. Juif français installé en Israël, historien et rabbin, l’auteur a enseigné à Yad Vashem. Il rappelle en propres termes que « [d]epuis trente ans, en France, l’affaire semble entendue : le régime de Vichy a été un complice actif du génocide perpétré par les nazis » (quatrième de couverture). Il ajoute que pourtant, « face à cette thèse officielle » (remarquons le choix, justifié, de l’adjectif), « des pierres d’achoppement subsistent : comment expliquer, en effet, que 75 % des Juifs vivant en France pendant la guerre aient pu échapper à la Shoah ? Et comment expliquer, aussi, que la France fut le pays d’Europe où les réseaux de sauvetage furent les plus nombreux, les plus actifs et les plus efficaces ? Autant de “paradoxes français” » (ibid.). A. Michel pose en principe qu’il y a eu un « génocide » mais il fait partie de ces nouveaux historiens qui, au sujet de l’existence problématique (en fait inexistante) d’une décision d’exterminer les juifs, fût-ce sur le front de l’Est, sont soit vagues, soit réservés (en particulier, dans la note 267, à la page 216, avec des expressions telles que « il semble », « apparemment », ou « serait »). Sur le sujet des « gazages » ou des « chambres à gaz », à l’exception de trois mentions à la seule page 214, il se montre dans son livre d’une remarquable discrétion et préfère user d’euphémismes tels que « la mort immédiate » (p. 215). Il juge assez sévèrement Serge Klarsfeld (note 337, à la page 284) et condamne sévèrement Marrus et Paxton dont la position extrémiste sur la responsabilité criminelle de la France (celle de Pétain) rencontrait jusqu’ici un si grand succès dans notre pays. Citant un extrait de ce que ces deux derniers auteurs ont écrit contre la Milice, il en vient à écrire : « Malheureusement, comme c’est souvent le cas dans leur livre [*Vichy et les Juifs,* Calmann-Lévy, Paris, 1981], l’affirmation de Marrus et Paxton n’est soutenue par aucune preuve ou référence sérieuse » (p. 294). Le dernier chapitre de l’ouvrage (p. 371-381), avec parfois des accents quasi révisionnistes, est intitulé : « En conclusion : des difficultés du métier d’historien ». On y lit, par exemple : « [...] il est toujours grave, en matière d’historiographie, de bloquer le débat en imposant une vérité officielle. On peut être totalement opposé à l’interprétation de la partie adverse, et pourtant considérer qu’il est normal que celle-ci puisse exprimer son opinion » (p. 373). Ou encore : « Dans [notre livre] nous avons proposé aux lecteurs d’abandonner une vision officielle et de se confronter aux faits et aux questions réelles [...] » (p. 375). Sur le conflit entre « Histoire » et « Mémoire », il rappelle l’importance primordiale qu’il convient d’accorder à l’histoire et il met en garde contre « ces abus de mémoire que peuvent devenir les commémorations imposées par le pouvoir politique ou par des groupes de pression » (p. 377). Dans sa dernière phrase il émet le vœu que son livre puisse « permettre qu’un vrai débat s’instaure enfin » (p. 381). Dès qu’il lui vient un peu d’audace, il s’empresse de nous rappeler sa foi en la Shoah mais il n’empêche que, d’une manière générale, il « révise » sérieusement les croyances qu’il qualifie d’« officielles ». L’épigraphe de son livre, d’abord en anglais puis traduite en français, pourrait figurer en tête de tout ouvrage révisionniste. Elle provient d’un célèbre roman policier, *The Daughter of Time,* de l’écrivain britannique Elizabeth Mackintosh (publié sous le nom de plume Josephine Tey : First Scribner Paperback Fiction Edition, New York, 1995, p. 131-132). La voici (traduction personnelle) :

> C’est une chose curieuse mais, lorsque vous dites aux gens la vérité qui se cache derrière un récit mythique, ce n’est pas contre le narrateur qu’ils s’indignent mais contre vous. Ils ne veulent pas qu’on dérange leurs idées. Cela les met mal à l’aise, je pense, et cela les contrarie. Aussi rejettent-ils ce que vous dites et refusent-ils d’y réfléchir. S’ils se montraient simplement indifférents, ce serait naturel et compréhensible. Mais c’est bien plus fort que cela, bien plus concret. Ils sont fâchés. Très curieux, n’est-ce pas ?

Mais Alain Michel est loin d’être le seul dans son entreprise; d’autres auteurs s’efforcent de quitter « les histoires » pour l’histoire. Tel est le cas de Jacques Semelin, directeur de recherches au Centre d’études et de recherches internationales (CERI-CNRS), qui, dans *Persécutions et entraides dans la France occupée* (Les Arènes-Le Seuil, Paris, 2013, plus de 900 pages), a montré comment 75 % des juifs vivant en France ont échappé à la déportation. Dans un entretien avec Laurent de Boissieu (*La Croix,* 22 mars 2013), il déclare : « Ce chiffre est connu des spécialistes mais pas des Français, comme j’ai pu m’en apercevoir au cours de mon enquête. Là où je romps avec l’explication mémorielle, c’est que le nombre de Justes français – 3.500 environ – ne peut pas expliquer à lui seul la survie d’au moins 200.000 personnes perçues comme juives. Je suis désolé de contredire, sur ce point, les présidents Jacques Chirac et François Hollande. » Et il ajoute : « 90 % des Français juifs n’ont pas été déportés, contre 50 à 60 % des juifs étrangers vivant en France. Ce fut une découverte et une surprise pour moi. » Au sujet du régime du maréchal Pétain il remarque que « quelles qu’aient été les intentions d’un régime pratiquant l’antisémitisme d’État [...], en soi, le maintien d’un appareil étatique a eu un effet positif pour la survie des juifs de France ». Une idée reçue veut que, si des juifs ont survécu, c’est parce qu’ils auraient vécu cachés ; J. Semelin conteste cette idée et rappelle une évidence : même à Paris et dans ce qu’on appelait « la zone Nord », où le port de l’étoile juive avait été rendu obligatoire par les autorités militaires allemandes, même dans les derniers jours de l’Occupation, de nombreux juifs circulaient à la vue de tous. Dans « la zone Sud », les juifs ne portaient pas l’étoile.

En dépit de sa réputation de juif porté à l’extrémisme, même Serge Klarsfeld, le « chasseur de nazis », a été conduit à réviser l’histoire de la déportation et à en corriger des exagérations ou des mensonges si bien qu’on pourrait dire que son nom, comme celui de quelques autres spécialistes, s’inscrit dans une lignée d’historiens qui commencent à se soucier un peu plus des exigences de l’histoire et un peu moins des oukases de la Mémoire. Le plus récent exemple des révisions auxquelles a procédé S. Klarsfeld concerne le nombre des juifs refoulés par la Suisse pendant la guerre. Ce nombre, tel qu’il figure, par exemple, dans le « Rapport Bergier » sur lequel on s’est fondé pour mettre la Suisse en accusation et qui sert après coup à moralement justifier les colossales extorsions de fonds à ses dépens par certaines organisations juives internationales, était de 24.000. Vérification faite, S. Klarsfeld pense qu’en réalité ce chiffre a été de moins de 3.000, chiffre, précise-t-il, qui est celui de « refoulés » et non, pour autant, de « morts ». Par ailleurs, ajoute-t-il, la Suisse a bel et bien accueilli 30.000 juifs. Le colportage dans le monde entier du chiffre de 24.000 juifs refoulés (sous-entendu : et donc envoyés à la mort) a été une calomnie à l’égard d’un pays qui a été « en réalité une terre d’asile pour les juifs » (la formule est de S. Klarsfeld en personne). Il estime aussi que l’affaire a été « extrêmement dommageable pour la vérité [18] ». Il faut ici reconnaître qu’il n’hésite pas à se réviser lui-même notamment en ce qui concerne, pour la première édition (1978), les données de son propre Mémorial de la déportation des juifs de France. C’est également à lui que nous sommes redevables de la division par quatre du nombre des fusillés du Mont-Valérien : non pas 4500 mais un peu plus de 1 000 [19]. Même un Claude Lanzmann peut être conduit à réviser une vérité d’usage devenue en quelque sorte officielle. Tel est le cas lorsqu’il déclare : « Les images de cadavres de *Nuit et Brouillard,* le film d’Alain Resnais, sont celles de victimes de typhus dans un camp de concentration. » Et d’ajouter : « Des camps d’extermination, il n’y a pas d’image [20]. » L’ajout ne manque pas de piquant : « Pas d’image, et pour cause ! », a-t-on envie d’ajouter.

## Le tam-tam shoatique et la répression sont les signes d’un désarroi

Le tam-tam shoatique se fait, dans le monde occidental, de plus en plus assourdissant et la répression continue en dépit de l’impuissance des pouvoirs publics à endiguer le flot de la contestation. Ni ce tam-tam ni cette répression ne prouvent que l’histoire officielle se renforce ; au contraire. En réalité, le tam-tam a pour but de couvrir la petite musique révisionniste qui manifestement inquiète de plus en plus les défenseurs du Grand Mensonge. Les bonnes gens s’étonnent du ramdam de la propagande holocaustique et certains révisionnistes s’en désespèrent. Ils ont tort. L’intensité même de tout ce charivari et du matraquage est proportionnelle à l’angoisse des imposteurs qui, chaque année, constatent leur propre impuissance à répondre aux révisionnistes sur le plan des faits, des documents et des preuves. Le désarroi de nos marchands de faux ne peut qu’augmenter. Où qu’ils tournent leurs regards, leur situation est angoissante. L’enseignement de la Shoah perturbe jusqu’aux jeunes Israéliens [21]. Même aux États-Unis on note les signes d’une *« Holocaust fatigue »* : l’expression s’emploie dans la grande presse depuis au moins dix ans [22]. Dans une bonne partie du monde et jusque dans nos banlieues on ne cache plus son exaspération devant l’« entubage » et l’« enfumage » des jeunes par la pleurnicherie shoatique.

Par ailleurs, l’histoire de la Seconde Guerre mondiale s’enrichit de plus en plus de recherches et d’ouvrages sur les horreurs commises par des vainqueurs qui, cyniquement, se sont faits et continuent de se faire les juges des vaincus. Le bombardement systématique des civils allemands, les gigantesques « transferts » de populations, le viol des Allemandes, les exécutions sauvages, le vol organisé, le traitement ignoble de foules de prisonniers allemands condamnés à mort par la famine organisée, les crimes de guerre, les « crimes contre l’humanité », l’entente cordiale du crime à l’échelle planétaire entre Churchill, Roosevelt, Truman et Staline, tout cela commence enfin à refaire surface [23]. En Allemagne, les bombardements au phosphore avaient des conséquences hallucinantes : un enfant transformé en torche pouvait être plongé dans l’eau d’une rivière, le feu s’éteignait mais reprenait sitôt que la petite victime était ressortie de l’eau et elle mourait, la peau du palais cloquée. Lors du bombardement d’Hiroshima, « jusqu’à 4 kilomètres de l’épicentre, les yeux fondent instantanément dans leurs orbites » et « les viscères des victimes sont expulsés par l’anus » (Véronique Chalmet, « 6 août 1945 : un B-29 met le cap sur  Hiroshima », *Ça m’intéresse. Histoire,* juillet-août 2013, p. 94-97).

À elle seule, l’histoire de la Résistance devient l’objet de mises au point ou de révisions déchirantes. À ce titre il convient de signaler les travaux, remarquables en tout point, de Jean-Marc Berlière, professeur à l’Université de Bourgogne. Avec François Le Goarant de Tromelin, il a récemment publié *Liaisons dangereuses. Miliciens, truands, résistants,* Paris, 1944, Perrin, Paris, 2013, 381 p. La conclusion de l’ouvrage (p. 271-274) a pour sous-titre « Une histoire à (re)voir, une mémoire à (re)construire ». Il est également l’auteur, parfois en collaboration avec d’autres, de livres tels que *Le Sang des communistes. Les bataillons de la jeunesse dans la lutte armée, automne 1941* (avec Frank Liaigre), Fayard, Paris, 2004, *Liquider les traîtres. La face cachée du PCF clandestin, 1941-1943* (avec Frank Liaigre également), Robert Laffont, Paris, 2007, et *L’Affaire Guy Môquet. Enquête sur une mystification officielle* (encore avec Frank Liaigre), Larousse, Paris, 2009. À mes étudiants de « Critique de textes et documents (littérature, histoire, médias) », j’avais pour habitude de recommander, dans la recherche de l’exactitude (mot que je préfère à celui, un peu trop vague et prétentieux, de « vérité »), l’attitude et la méthode des spécialistes soit de la police technique, soit de la police scientifique. J.-M. Berlière me semble avoir été à cette école de rigueur, de précision et de modestie. Je souhaiterais le voir s’engager un jour dans l’étude d’un sujet en rapport avec « l’Holocauste » mais  je crains qu’à l’exemple des meilleurs historiens il ne s’abstienne d’aller, comme il dit, « (re)voir » l’histoire de ce côté-là.

Le jour viendra peut-être où, sur le plan moral, l’on ne tranchera plus entre « les résistants » qui seraient « les bons » et « les collaborateurs » qui seraient « les méchants », ou entre « les juifs » et les autres victimes de la Seconde Guerre mondiale, étant « entendu » que les premiers auraient souffert infiniment plus que les autres, ce qui est faux. Déjà, au sujet du cas relativement récent de la Première Guerre mondiale, ce type de distinguo moral a effectivement disparu ; avec l’effondrement de mythes aussi grotesques et scandaleux que celui des Uhlans coupeurs de mains de petits enfants belges ou des « Boches » créant et utilisant à l’échelle industrielle des « usines à cadavres », on ne trouve plus d’historien pour soutenir sérieusement que, de 1914 à 1918, les Allemands ou les Austro-Hongrois ont été moralement pires que « les Alliés ». Pour l’histoire de la Seconde Guerre mondiale, avec la disparition progressive de mythes tels que ceux du prétendu « savon juif », des « abat-jour en peau humaine tannée » ou encore des « usines à cadavres » (où, selon les cas, on tuait au gaz, à l’électricité ou à la vapeur d’eau), il semble inévitable qu’on finira par se lasser de prétendre que, de 1939 à 1945, les vaincus ont été inférieurs aux vainqueurs sur le plan de la morale.

Peut-être ira-t-on jusqu’à rendre hommage aux vaincus du Front de l’Est. Après tout, si, à la fin de la guerre, le communisme soviétique n’a mis sous son joug qu’une moitié de l’Europe occidentale et si l’autre moitié lui a échappé, ne le doit-on pas à l’héroïsme de ceux qui ont lutté contre Staline ? Sans eux, sans leur sacrifice, les troupes soviétiques, au lieu de s’arrêter à Vienne, auraient poursuivi leur course, leurs pillages, leurs viols, leurs massacres jusqu’à Brest, point qu’elles auraient pu atteindre un an après leur écrasante victoire de Stalingrad, le 2 février 1943. L’empire soviétique, avec ses possessions, se serait alors étendu du Pacifique à l’Atlantique et, pour reprendre la formule de Pascal, « toute la face de la terre aurait été changée ».

Quant aux « résistants » et aux « collaborateurs », il est probable que la proportion des bons et des méchants, des héros et des lâches, des honnêtes gens et des truands, a été égale, là encore, dans le camp des vainqueurs et dans celui des vaincus. Indépendamment de leurs nuances et des choix intimes de chaque individu, le fait est que tous les « résistants » se sont retrouvés dans le même camp que Staline et ont contribué à sa victoire ; de la même façon, qu’ils l’aient voulu ou non, le fait est que tous les « collaborateurs » se sont retrouvés dans le même camp que Hitler. En conséquence, on voit mal comment un ancien « résistant », qui a *de facto* combattu dans le même camp que Staline, serait en droit d’infliger à un ancien « collaborateur », qui s’est retrouvé *de facto* du côté de Hitler, la moindre leçon morale. Quant à la plupart des organisations juives, le grand public commence à découvrir leur constant bellicisme, leurs appels à la haine et à la vengeance, ainsi que l’aide que beaucoup d’entre elles apportent à la politique de racisme agressif et d’apartheid en terre de Palestine et tout cela, qui provoque à la réflexion, invite nécessairement à une forme de révision de l’histoire, tout entière, de la Seconde Guerre mondiale.

## Le bilan de la recherche révisionniste

Nous l’avons vu : la religion de « l’Holocauste », son commerce, sa presse aux ordres, sa propagande et sa publicité prospèrent plus que jamais; en revanche, les historiens accrédités de « l’Holocauste » sont en pleine crise, en pleine déroute. Ils sont pris entre, d’une part, l’offensive de ceux qu’ils appellent « les négationnistes » et, d’autre part, les fanatiques de « la Mémoire » qui les empêchent de faire leur travail d’historiens. Les premiers leur rappellent que leur obligation professionnelle et morale est tout de même, en priorité, de servir l’Histoire tandis que les seconds les somment de protéger et de servir coûte que coûte la cause sacrée de la Mémoire, quitte pour chacun à trahir son devoir d’historien. Edgar Morin, Henry Rousso et Annette Wieviorka ont, par moments, manifesté leur impatience à l’endroit de ces censeurs, dont ils sentent qu’ils les observent, les contrôlent et prétendent en quelque sorte leur dicter les conclusions de leurs recherches. Au fond, ces trois auteurs et leurs pareils ne sont jamais bien loin de connaître l’épreuve qu’en son temps le prestigieux historien israélien Ben-Zion Dinur (né Dinaburg) a traversée, pour son plus grand malheur. Ministre de l’Instruction publique et de la Culture de 1951 à 1955 et fondateur à Jérusalem, en 1953, de Yad Vashem (« un mémorial et un nom » : Mémorial et institut de recherche de l’Holocauste), il lui avait fallu, au terme d’un long combat, démissionner de son poste de président en 1959. Pour avoir préconisé une étude critique des témoignages rendus par les « survivants », notamment d’origine polonaise, il avait eu à subir de violentes attaques du lobby des innombrables « miraculés ». N’avait-il pas poussé l’audace jusqu’à proposer en modèle le travail critique du révisionniste de la Première Guerre mondiale, Jean Norton Cru, l’admirable auteur de *Témoins* (1929 [24]) ? En ce qui regarde la Seconde Guerre mondiale, l’historienne Olga Wormser-Migot, à son tour, allait, à partir de 1968, subir une épreuve identique pour avoir, dans sa thèse principale, conclu d’abord qu’Auschwitz I n’avait jamais possédé de « chambre à gaz », puis que, d’une manière générale, les historiens de la déportation devaient s’interroger sur ce qu’elle appelait « Le problème des chambres à gaz », c’est-à-dire le problème de savoir où exactement de tels abattoirs avaient réellement existé (O. Wormser-Migot, *Le Système concentrationnaire nazi (1933-1945),* Presses universitaires de France, Paris, 1968).

On aura remarqué que jusqu’ici je me suis abstenu, dans la mesure du possible, d’en appeler à l’autorité de chercheurs révisionnistes, y compris du plus prestigieux d’entre eux, Arthur Robert Butz. J’ai également passé sous silence les noms d’auteurs, juifs ou non juifs, qui semblent proches des révisionnistes. Je crois cependant nécessaire de faire une exception pour un auteur qui, sous le nom de Philippe Mozart, a tout récemment signé un livre intitulé *Shoah Story* (DIE, Jessains, 2013, 231 p., à commander aux Éditions Akribeia). Dédié « À Robert Faurisson et Serge Klarsfeld », ce livre contient une analyse sans concession de la thèse officielle, celle que soutient et protège la loi Fabius-Gayssot. Il dénonce une histoire « sans documents », « sans témoins » et « sans débats », une justice qui se fait « professeur d’histoire » (et, qui plus est, d’une histoire elle-même devenue « professeur de politique et de morale »), « une arithmétique » extraordinairement variable, « une technologie du crime incohérente », et j’en passe. Il indique aux historiens orthodoxes des pistes de recherche qui, à l’avenir et à la différence du passé et du présent, devront être examinées « sans haine ni peur, sans restriction ». À première vue, on s’étonne de ce qu’il soit allé jusqu’à écrire : « [...] j’aimerais que les dédicataires de cet ouvrage, Serge Klarsfeld et Robert Faurisson, se serrent la main » (p. 17), mais on a toujours le droit de rêver et il est exact que nul n’est mieux placé que S. Klarsfeld pour mesurer l’étendue des ruines qu’ont laissées derrière eux Raul Hilberg, Léon Poliakov, Joseph Billig, Georges Wellers, Pierre Vidal-Naquet qui, avec d’autres historiens orthodoxes, se sont ou déshonorés ou ridiculisés en essayant de défendre l’absurde thèse du génocide, des chambres à gaz et des millions de juifs prétendument exterminés. S. Klarsfeld a fait une cuisante expérience : à partir de 1978-1979, quand « l’affaire Faurisson » a éclaté dans Le Monde, il a d’abord cru devoir placer sa confiance dans ces personnages pour régler son compte à l’impertinent, puis, vers 1986, se rendant compte qu’aucun des historiens de son bord n’apportait une preuve solide de l’existence et du fonctionnement de la moindre chambre à gaz nazie, il a reporté ses espoirs sur un certain Jean-Claude Pressac (1944-2003), qu’il a soutenu de toutes ses forces, y compris par l’argent. Tout cela pour finalement constater qu’en 1995 son protégé se voyait contraint, dans des conditions humiliantes, à l’abandon de la thèse exterminationniste : J.-C. Pressac, en effet, s’apercevant que cette thèse reposait, selon ses propres termes, sur un dossier « pourri » par trop de mensonges, la jugeait tout juste bonne à jeter « aux poubelles de l’histoire » (à la toute fin d’un « Entretien avec Jean-Claude Pressac » in Valérie Igounet, *Histoire du négationnisme en France,* Le Seuil, Paris, 2000, p. 613-652). Ajoutons à ce désastre le fait que, dans ces dernières années, « la Mémoire », qui consiste essentiellement en « témoignages », a connu, elle aussi, ses avanies : des récits prétendument autobiographiques comme ceux de « Wilkomirski » ou de *Survivre avec les loups* se révélaient n’être que des impostures où les grands médias et les institutions shoatiques n’avaient, pour leur part, vu que des merveilles de sincérité et d’authenticité. Le public, généralement tenu dans l’ignorance de la découverte des supercheries shoatiques, pour une fois allait apprendre qu’on lui avait menti. (Pour ces deux impostures on peut se reporter à une étude rédigée par les psychiatres Jean-Pierre Luauté et Olivier Saladini ; intitulée « Fausses victimes de persécutions nazies. Entre imposture et littérature », elle est consultable sous une forme résumée au site www.sciencedirect.com. On y traite d’une « identification très précoce au sort des juifs, prototype de la victime innocente et parangon du malheur »). Sur le chapitre, plus général, des fausses victimes de la Shoah, on interrogera google.fr avec « fausses victimes de la shoah ». Aujourd’hui, où qu’il tourne son regard, S. Klarsfeld, qui a tenté, avec des fortunes diverses, de conduire une enquête relativement précise notamment sur le véritable nombre des juifs déportés de France, ne peut donc que constater la totale faillite à ce jour de la thèse exterminationniste. Cette dernière s’incarne de plus en plus dans la personne de l’histrion Élie Wiesel dont l’égal, dans la mafia de la finance, est son coreligionnaire Bernard Madoff, l’homme de « la plus grande arnaque du monde ». À défaut d’aller « serrer la main de Faurisson », S. Klarsfeld, pour sauver son honneur, devrait, pour le moins, prendre publiquement ses distances d’avec les fumistes qui continuent d’abuser le grand public. Qu’attend-il, par exemple, pour dénoncer le charlatanisme du père Desbois avec ses deux inventions de « la Shoah par balles » et de « la Shoah par étouffement » sous édredons ou coussins [25]?

## CONCLUSION

Tôt ou tard les historiens orthodoxes seront contraints d’admettre clairement et non, comme le font certains, de manière indirecte ou confidentielle, que, malgré leurs recherches « les plus érudites », aucun d’entre eux n’a trouvé la preuve 1) de l’existence d’un ordre ou d’un plan d’extermination des juifs, 2) de l’existence et du fonctionnement d’une chambre à gaz pour cette extermination, 3) de la mort de six millions de juifs. En plus d’admettre l’existence de cette triple imposture il leur faudra également reconnaître qu’au moins depuis 1992 ils ont laissé sans réponse le défi que je leur avais lancé à Stockholm : « Montrez-moi ou dessinez-moi une chambre à gaz nazie [26]  ! » Semblablement ils ont laissé sans réponse le défi que je leur ai ensuite lancé de Los Angeles en 2002 : « Expliquez-moi comment il se fait que, pendant la guerre, des cours martiales ou des tribunaux du III^e^ Reich ont lourdement condamné, parfois jusqu’à leur infliger la peine de mort, des soldats, des officiers, des civils coupables d’avoir assassiné ne fût-ce qu’un juif ou une juive, et cela même sur le front de l’Est [27] ! » La triple imposture a reçu l’aval du tribunal de Nuremberg il y a soixante-sept ans. Trois générations constituant un siècle, nous en sommes aujourd’hui à l’arrivée de la troisième génération, celle où censément se tirent les bilans de l’histoire. C’est dire si l’heure est fatidique pour ce qu’A. R. Butz a décrit, en 1976, comme *The Hoax of the Twentieth Century*. Le titre de ce magistral ouvrage, si redouté par les gardiens de la légende, est généralement traduit par *La Mystification du XX^e^ siècle* ; il signifie en réalité *Le Canular du XX^e^ siècle.* En septembre 1979, A. R. Butz s’en est expliqué à Los Angeles lors de la première conférence de notre Institute for Historical Review : « Laissez-moi vous assurer que c’est délibérément que j’ai choisi ce terme et qu’aujourd’hui je suis encore plus convaincu qu’il s’agissait d’un choix heureux, pour la raison que la chose est piètre (*trivial*). Le terme de "canular" (*hoax*) suggère quelque chose de minable (*cheap*) et de grossier (*crude*), et c’est précisément ce que je souhaite suggérer. Un terme comme "mythe", bien qu’il soit exact et que je l’aie parfois utilisé, ne traduit pas cet aspect important de la nature des preuves sur lesquelles se fonde l’allégation d’extermination » (« The International “Holocaust” Controversy, » *The Journal of Historical Review,* vol. 1, n° 1, printemps 1980, p. 8; c’est à la librairie Akribeia qu’on peut commander la version française de *La Mystification du XX^e^ siècle* [La Sfinge, Rome, 2002], présentée par mes soins, et de ses trois magistraux suppléments, en particulier de son « Supplément A » où figure (p. 503) le passage concernant le choix du terme correspondant à « canular »).

D’une souffrance juive qui a été vraie (au milieu de tant d’autres souffrances qui, bien souvent, l’ont dépassée en intensité), on a fait un « canular », une farce, une basse imposture. En France comme en d’autres pays, ce que je dis là tombe sous le coup de la loi Fabius-Gayssot. Certes notre devoir est, en principe, de respecter cette loi comme toute autre loi mais un devoir supérieur nous fait une obligation de lutter contre « la force injuste de la loi, bref l’oppression, la tyrannie » (François Mitterrand, le 16 décembre 1984, qui pourtant signera la loi Fabius-Gayssot du 13 juillet 1990). Personnellement, depuis près de quarante ans, il se trouve donc que, comme tant d’autres révisionnistes, je me bats pour ce qui s’appelle communément « la justice » sous sa forme la plus élevée. Je ne connais guère de combat qui soit plus éprouvant et plus ingrat que celui-là quand, comme c’est ici le cas, il vous amène à défier à la fois le pouvoir, l’argent, la presse, la voix publique et la crédulité générale.

Un mot personnel pour en terminer. Sur un aspect de ce que m’a réellement coûté un tel choix de vie, j’ai jusqu’ici préféré me taire même si, à mon corps défendant, j’ai pu, çà et là et, en particulier auprès de François Brigneau, laisser échapper quelques confidences sur ma vie personnelle [28]. Sans doute devrais-je, de mon vivant, toucher quelques mots de cet aspect-là mais je préfère m’en abstenir. En revanche, il est prévu qu’après ma mort et celle de mon épouse des personnes de notre entourage révéleront le contenu de documents confidentiels qui jetteront quelque lumière sur certaines conditions de mon combat. L’histoire dira alors, en toute connaissance de cause, de quel prix, à notre époque, peut se payer la recherche de l’exactitude quand cette recherche se trouve porter sur l’une des plus phénoménales impostures de tous les temps.

2 octobre 2013

――――――――――――――――

Notes

[1] Voy., par exemple, « Contre l’hollywoodisme, le révisionnisme », dans le présent blog à la date du 3 février 2012.  
[2] Réédité par La Sfinge en 2012 et disponible aux Éditions Akribeia – NDÉ.  
[3] Voy. « Céline devant le mensonge du siècle (suite) » (1^er^ octobre 1982), *Écrits révisionnistes (1974-1998),* vol. I, R. Faurisson, Vichy, 2004 (1999), p. 322-324  – NDÉ.  
[4] Voy. « Les Victoires du révisionnisme » (11 décembre 2006), *Écrits révisionnistes (2005-2007),* vol. V, R. Faurisson, Vichy, 2009, p. 192-226, et « Les Victoires du révisionnisme (suite) » (11 septembre 2011) – NDÉ.  
[5] Voy. « Il est temps d’en finir avec la “chambre à gaz” du Struthof et ses 86 “gazés” » (30 mai 2013).  
[6] « A case for letting nature take back Auschwitz », *Toronto Star,* 27 décembre 2009.  
[7] Voy. « Les Victoires du révisionnisme (suite) » (11 septembre 2011).  
[8] Voy. « Une date dans l’histoire du révisionnisme : le 22 avril 1993 » (2 mai 1993), *Écrits révisionnistes (1974-1998),* vol. IV, R. Faurisson, Vichy, 2004 (1999), p. 1500-1508 – NDÉ.  
[9] Voy. « Retour sur ma découverte, le 19 mars 1976, des plans des crématoires d’Auschwitz et de Birkenau » (14 septembre 2010).  
[10] Voy. « Shoah, film de Claude Lanzmann. Vers un krach du Shoah-Business… » (18 juin 1987), *Écrits révisionnistes (1974-1998),* vol. II, R. Faurisson, Vichy, 2004 (1999), p. 699-707  – NDÉ.  
[11] Voy. « Le Père Patrick Desbois est un sacré farceur » (30 novembre 2007), *Écrits révisionnistes (2005-2007),* vol. V, op. cit., p. 336-339 – NDÉ.  
[12] Voy. « La “Solution finale de la question juive” était “territoriale” ! » (20 janvier 2012).  
[13] Sur l’omission du « t » de Reinhardt voy. « Pierre Vidal-Naquet à Lyon » (23 février 2002), *Écrits révisionnistes (1999-2004),* vol. V, op. cit., p. 304-305, ou « Aktion Reinhardt [1986] » (3 août 2009) – NDÉ.  
[14] Voy., au blog winstonsmithministryoftruth.blogspot.com, « 256 references to 6,000,000 Jews prior to the Nuremberg Trial announcement ».  
[15] Voy. « Au cadran de l’Histoire il est minuit pour les menteurs et les dupes de l’Holocauste ! » (23 décembre 2011).  
[16] Voy. aussi mon article « La “Shoah” : effets désastreux de l'endoctrinement des jeunes » (21 septembre 2013).  
[17] Voy., par exemple, « Bearing Witness Ever More », *The Economist,* Londres, 24 août 2013.  
[18] Voy., à dailymotion.com, la vidéo « Serge Klarsfled remet en cause le rapport Bergier ».  
[19] Voy. « Serge Klarsfeld divise par quatre le nombre des fusillés du Mont-Valérien » (30 mars 1995), *Écrits révisionnistes (1974-1998),* vol. IV, op. cit., p. 1656-1657 – NDÉ.  
[20] Voy. « Claude Lanzmann à Nankin » (29 septembre 2004), *Écrits révisionnistes (1999-2004),* vol. V, op. cit., p. 456 – NDÉ.  
[21] Voy., au site medicalxpress.com (Phys.org_network), « “Holocaust journeys” can cause mental health problems ».  
[22] Voy. Barry GEWEN, « Holocaust Documentaries : Too Much of a Bad Thing ? », New York Times, 15 juin 2003.  
[23]  Voy. « Le syndrome de Dresde » (15 février 2005), *Écrits révisionnistes (2005-2007),* vol. VI, op. cit., p. 17-20 – NDÉ.  
[24] Voy. « La “mémoire juive” contre l’histoire ou l’aversion juive pour toute recherche approfondie sur la Shoah » (15 juin 2006), *Écrits révisionnistes (2005-2007),* vol. VI, op. cit., p. 141-151 – NDÉ.  
[25] Voy. « Le Père Patrick Desbois est un sacré farceur » (22 octobre 2007), *Écrits révisionnistes (2005-2007),* vol. V, op. cit., p. 336-339, ainsi que « Pour finir, la mascarade du Père Patrick Desbois » (11 septembre 2008).  
[26] Voy. « Mon second séjour en Suède (3-6 décembre 1992) », (9 décembre 1992), *Écrits révisionnistes (1974-1998),* vol. III, R. Faurisson, Vichy, p. 1457-1460.  
[27] Voy. « Punishment of Germans, by Third Reich authorities, for mistreatment of Jews (1939-1945) » (23 juin 2002).  
[28]  Voy. *Mais qui est donc le Professeur Faurisson ? Une enquête. Un portrait. Une analyse. Quelques révélations,* La Sfinge, Rome, 2005 (1992). À compléter par le documentaire de Paul-Éric BLANRUE, « Un homme: Robert Faurisson », www.unhommefaurisson.com – NDÉ.  

Labels: Akribeia, Jean Plantin, procès de Nuremberg, Rassinier
