<!-- http://robertfaurisson.blogspot.com/1996/09/la-repression-du-revisionnisme-en.html -->

<!-- Sunday, September 1, 1996 -->

La répression du révisionnisme en France

La loi antiraciste du 13 juillet 1990 contient une disposition anti-révisionniste qui prévoit une peine de un mois à un an de prison et une amende de deux mille à trois cent mille francs, sans compter d'autres sanctions, contre ceux qui auront contesté « l'existence des crimes contre l'humanité » tels que définis et punis à Nuremberg en 1945-1946 par les vainqueurs de la seconde guerre mondiale.

Cette loi porte le nom de « loi Gayssot », du nom du député communiste Jean-Claude Gayssot qui en a eu l'initiative parlementaire. Elle s'appelle aussi, chez les révisionnistes, « loi Fabius-Gayssot » ou loi « Sirat-Fabius-Gayssot », ou « loi Faurisson », ou « lex Faurissonia ». Le grand rabbin de France, René-Samuel Sirat, en a émis l'idée en 1986. Le président de l'Assemblée nationale, le socialiste Laurent Fabius, qui est juif, est intervenu directement au parlement pour en obtenir le vote. Cette loi du 13 juillet 1990 visait en particulier mes travaux ainsi que mon action en faveur du révisionnisme historique.

Il faut bien comprendre que, dans son origine, c'est-à-dire dans l'esprit de J.-C. Gayssot et du Parti communiste français, cette loi était seulement destinée à renforcer la lutte contre le racisme. Ce sont les responsables de la communauté juive et du Parti socialiste (en particulier, L. Fabius) qui sont parvenus à insérer, dans cette loi antiraciste, une disposition antirévisionniste.

Avant d'en venir à l'étude de cette loi et à son application, rappelons ce qu'a été, en France, la répression antirévisionniste antérieurement au 13 juillet 1990.

Pour ce rappel, comme pour la suite, je m'inspirerai largement de l'ouvrage d'Éric Delcroix, avocat au barreau de Paris, La Police de la pensée contre le révisionnisme. J'ai collaboré à la documentation de cet ouvrage qui, aujourd'hui, fait l'objet d'une poursuite judiciaire précisément sur le fondement de la « loi Fabius-Gayssot ». L'audience de plaidoirie est prévue pour le 24 septembre 1996 devant la XVIIe chambre du tribunal correctionnel de Paris.

La répression de 1949 à 1989

De 1949 à 1989, en l'absence de toute loi spécifique contre le révisionnisme, les tribunaux ont condamné les révisionnistes pour les raisons et les prétextes les plus divers.

En 1954, l'universitaire Maurice Bardèche, chassé de l'Université, se voit condamner par la cour d'appel de Paris à un an de prison et cinquante mille francs d'amende pour « apologie de crime ». Son délit avait consisté à écrire Nuremberg ou la Terre promise, une œuvre qu'il avait courageusement fait suivre de Nuremberg II ou les Faux Monnayeurs. L'auteur, sans en contester vraiment l'existence, tendait à mettre en doute le « génocide des juifs » et les « chambres à gaz nazies ». En 1950, Paul Rassinier, résistant et ancien déporté, publie Le Mensonge d'Ulysse où il commence à mettre en doute l'existence de ces chambres à gaz. Il est condamné par la cour d'appel de Lyon à quinze jours de prison avec sursis et à cent mille francs (de l'époque) d'amende ainsi qu'à de lourds dommages-intérêts pour injure et diffamation à l'égard des anciens déportés. La Cour de cassation casse l'arrêt. En mai 1955, la cour d'appel de Grenoble le relaxe. Mais, jusqu'à la fin de sa vie (1967), il connaîtra d'autres démêlés avec la justice ; dans un cas, il sera débouté de sa plainte ; dans un autre cas, il sera condamné pour diffamation. C'est en novembre 1978 que débute « l'affaire Faurisson ». Les poursuites judiciaires commenceront dès 1979. Jusqu'en 1989, de nombreux révisionnistes seront, comme moi, poursuivis ou condamnés pour les motifs les plus divers : diffamation envers un particulier, diffamation raciale, provocation à la haine raciale, apologie de crime, propagation de fausse nouvelle, trouble de l'ordre public, procédure « abusive » contre, par exemple, des diffamateurs, etc., mais, par-dessus tout, les censeurs poursuivront les révisionnistes devant les juridictions civiles sous prétexte de « dommage causé à autrui ». Leur argument sera qu'en contestant « génocide » et « chambres à gaz », les révisionnistes causent aux juifs un dommage moral pour lequel ils doivent réparation aux organisations représentant les intérêts des juifs. C'est ainsi que ces organisations ont cherché à me faire condamner pour « dommage par falsification de l'histoire ». En première instance, elles ont failli obtenir satisfaction grâce à un jugement prononcé par un tribunal que présidait Pierre Drai, un juif connu pour son attachement à la cause juive, mais même P. Drai n'a pas osé retenir le grief de « falsification » (il lui aurait fallu fournir une preuve, au moins, de falsification et c'était impossible). J'ai donc été condamné pour légèreté ou négligence. Mais, dans un arrêt retentissant, la cour d'appel de Paris a reconnu que, dans mes travaux sur ce qu'elle appelait elle-même le « problème » des chambres à gaz, il n'y avait ni légèreté, ni négligence et, ajoutait-elle, ni ignorance délibérée ni mensonge. En conséquence, elle déclarait :

La valeur des conclusions défendues par M. Faurisson [sur ce sujet] relève donc de la seule appréciation des experts, des historiens et du public [1].

La cour autorisait ainsi la contestation des chambres à gaz nazies. Elle me condamnait néanmoins pour un motif qu'on pourrait résumer en ces termes : le professeur Faurisson est, certes, honnête et sérieux dans son travail mais il manque de cœur et ne montre pas de respect pour la souffrance des déportés (lire : des juifs). Cet arrêt provoquait la déception des juifs et, en particulier, celle de l'historien de l'antiquité Pierre Vidal-Naquet, qui écrivait :

Le procès intenté en 197[9] à Faurisson par diverses associations antiracistes a abouti à un arrêt de la cour d'appel de Paris en date du 26 avril 1983, qui a reconnu le sérieux du travail de Faurisson, ce qui est un comble, et ne l'a, en somme condamné que pour avoir agi avec malveillance en résumant ses thèses en slogans [2].

De son côté, Georges Wellers, directeur du Monde Juif (revue du Centre de documentation juive contemporaine de Paris) écrivait :

En appel, la cour a reconnu que [Faurisson] s'était bien documenté. Ce qui est faux. C'est étonnant que la cour ait marché [3].

Si je m'attarde à ces réactions, c'est qu'elles expliquent pourquoi des personnalités comme P. Vidal-Naquet et G. Wellers se sont ensuite retrouvées au côté du grand rabbin Sirat pour demander la création d'une loi spécifique contre les révisionnistes.

En juin 1985, Henri Roques est reçu docteur de l'université de Nantes pour une thèse sur les « confessions » de l'officier SS Kurt Gerstein. Sa thèse est révisionniste. Le feu couve pendant quelques mois où, fébrilement, G. Wellers prépare une réplique. En avril 1986 éclate, avec la publication de cette prétendue réplique, « l'affaire Roques ». L'émoi est considérable. La pression des organisations juives aboutit à l'annulation de la soutenance de thèse pour vices de forme.

Serge Klarsfeld demande la création d'une loi antirévisionniste. Il use pour cela d'un argument fallacieux. Il prétend que l'Allemagne dispose déjà d'une loi spécifique contre le révisionnisme. C'est faux et il le sait bien. Dans les années soixante-dix, il avait lancé en Allemagne le projet d'une loi dite « du mensonge d'Auschwitz », une « lex Klarsfeld », mais, au terme de longues années de discussion, le Bundestag avait simplement voté l'article 194 du code pénal allemand. Cet article n'interdit nullement la contestation des « crimes [du vaincu] contre l'humanité ». Il autorise seulement un procureur à déposer plainte pour dommage causé « au membre d'un groupe qui a été persécuté sous un gouvernement de violence ou d'arbitraire, national-socialiste ou autre » ; le mot « autre » vise, par exemple, le gouvernement d'un pays communiste (wenn der verletzte als Angehöriger einer Gruppe unter der nationalsozialistischen oder einer anderen Gewalt- und Willkürherrschaft verfolgt wurde). Le procureur peut alors poursuivre l'inculpé sur le fondement de l'ensemble des lois punissant, en particulier, la diffamation des morts (Verunglimpfung Verstorbener). C'est dans ce cadre qu'est effectivement poursuivie l'« Auschwitz-Lüge » (mensonge d'Auschwitz) et que pourrait être, en théorie, poursuivie la «Vertreibungslüge» (mensonge de l'expulsion [des Allemands de l'Europe de l'Est]). Le 2 juin 1986, sous l'égide du grand rabbin Sirat, un groupe d'universitaires et de personnalités, toutes (sauf une) d'origine juive, formule « l'espoir d'une extension à tous les pays européens de la loi allemande interdisant la mise en doute du génocide »[4]. Dans ce groupe figurent notamment P. Vidal-Naquet, G. Wellers et S. Klarsfeld. Le 7 juillet 1987, Charles Pasqua, ministre (gaulliste) de l'Intérieur, reçoit un certain nombre d'organisations juives ou d'organisations de défense contre l'antisémitisme pour leur proposer «d'inventer ensemble un arsenal juridique garantissant, dans l'avenir, la vérité sur les chambres à gaz» [5].

Le 13 septembre 1987, au cours d'une émission de radio, Jean-Marie Le Pen, président du Front national, interrogé sur la manière dont les juifs auraient été exterminés, répond que cette manière (les chambres à gaz nazies) constitue un « point de détail » de l'histoire de la seconde guerre mondiale. Une formidable tempête médiatique s'ensuit. Dix jours plus tard, J.-M. Le Pen est condamné en référé pour « trouble ». Beaucoup plus tard, le 18 mars 1991, la cour d'appel de Versailles, présidée par Pierre Estoup, le condamnera, pour « dommage à autrui » par « consentement à l'horrible » (sic), à la peine stupéfiante d'un million deux cent mille francs ; il s'agit là, principalement, de dommages-intérêts cumulés au profit d'une kyrielle d'associations invoquant un seul et même préjudice moral.

Le 20 septembre 1987, Charles Pasqua déclare que, s'il ne dépendait que de lui, le professeur Faurisson « irait en prison » [6].

Le 8 octobre 1987, par un tour de passe-passe, Albin Chalandon, ministre de la Justice, parvient, en pleine nuit, à faire voter par l'Assemblée nationale deux amendements à une loi sur la protection de la jeunesse contre la drogue ; ces amendements permettront d'empêcher, dans la pratique, la vente publique d'ouvrages révisionnistes.

Le 2 avril 1988 voit la mise en route, sur l'initiative de L. Fabius, d'une proposition de loi antirévisionniste devant le Parlement. Le 23 mars 1989, le député Jacques Chirac [futur président de la République] se prononce en faveur d'une loi antirévisionniste. Il avait d'abord été hostile à une telle loi mais il avait changé d'avis à la suite d'une rencontre avec les responsables du B'naï B'rith, organisation exclusivement juive, de caractère maçonnique [7]. Le 16 septembre 1989, je suis l'objet d'une grave agression physique revendiquée par « Les Fils de la Mémoire juive ». Cette agression est justifiée par Serge et Beate Klarsfeld qui la trouvent « naturelle » et « normale » [8].

Préparatifs et adoption de la loi antirévisionniste

(avril-juillet 1990)

En janvier 1990 éclate «l'affaire Notin». Bernard Notin, maître de conférences en sciences économiques à l'université Jean-Moulin de Lyon, se voit reprocher d'avoir écrit dans une revue de sociologie un article sur la puissance des médias, article où il manifeste, en passant, son scepticisme quant aux preuves et aux témoins de l'existence des chambres à gaz nazies [9]. Le scandale prend des proportions internationales. B. Notin et sa famille connaîtront un véritable calvaire. Malgré son abjuration et sa condamnation du révisionnisme, il ne pourra plus jamais reprendre ses cours parce qu'ainsi en a décidé le Dr Marc Aron, président du Comité de liaison des institutions et des organisations juives de Lyon, et, avec lui, l'Union des étudiants juifs de France (UEJF). Le 1er et le 2 avril 1990, l'ancienne communiste Annie Kriegel, bien que juive, s'inquiète de voir la communaute juive française apparaître «comme un groupe exigeant que règne en sa faveur une véritable police de la pensée [...] une insupportable police juive de la pensée» [10]. Pour les débats au Parlement (c'est-à-dire à l'Assemblée nationale et au Sénat), on consultera le Journal officiel de la République française aux dates suivantes de l'année 1990 : 3 mai, 12, 29 et 30 juin, 1er juillet [11]. La mise en condition de l'opinion française atteint de telles proportions que même les adversaires d'une telle loi osent à peine soulever d'objections.

L'historien Henri Amouroux dénonce la loi mais, par peur, affecte de n'y voir qu'une loi dirigée contre J.-M. Le Pen ; lui, l'historien, il n'ose même pas révéler à ses lecteurs que la « loi Gayssot » vise les historiens et cherche à mettre ces derniers en tutelle [12]. Bien que timide, l'opposition au vote d'une disposition antirévisionniste est certaine.

C'est alors qu'éclate, providentiellement pour les adversaires des révisionnistes, l'affaire de la violation de sépultures du cimetière juif de Carpentras. Nous sommes le 10 mai 1990. Pêle-mêle, J.-M. Le Pen et les révisionnistes sont immédiatement dénoncés par les médias et par le monde de l'établissement politique (y compris François Mitterrand, président de la République, qui signera la «loi Gayssot») comme les responsables moraux de cette «profanation». Cette fois, l'intimidation est totale. A la veille du vote définitif de la loi par l'Assemblée nationale, le juriste François Terré écrit : «Face à la proposition Gayssot le silence infini de presque tous les juristes, de presque tous les historiens effraie [13]. »

Le 2 juillet 1990, Pierre Joxe, ministre de l'Intérieur, socialiste d'origine juive, prend des arrêtés interdisant, dans la pratique, la vente publique de trois revues révisionnistes (souvent poursuivies en justice, pour deux d'entre elles).

Le 14 juillet 1990, le texte de la loi Fabius-Gayssot paraît au Journal officiel, Lois et décrets, p. 8333-8334, sous la signature de F. Mitterrand. Huit pages plus loin paraît le décret de nomination au grade de chevalier de la Légion d'honneur de « M. Vidal-Naquet (Pierre), historien ; 35 ans d'activités littéraires» sur proposition de Jack Lang, socialiste d'origine juive, ministre de la Culture. Pour le juif P. Vidal-Naquet, c'est l'honneur tandis que, pour le révisionniste R. Faurisson, c'est le banc d'infamie des tribunaux.

Applications de la loi antirévisionniste

Depuis 1990, la loi antirévisionniste semble s'être appliquée une trentaine de fois. Les sanctions financières sont parfois si lourdes qu'elles ont pu entraîner, par exemple, la disparition d'une revue, de qualité exceptionnelle : Le Choc du mois. Il faut noter que, comme dans ce dernier cas, les condamnations au nom de la loi Gayssot sont quelquefois associées à des condamnations au nom d'autres lois comme, par exemple, la traditionnelle loi antiraciste du 1er juillet 1972, dite loi Pleven. Personnellement, pour une seule interview publiée dans Le Choc du mois, j'ai été l'objet de trois procédures judiciaires distinctes en dépit de l'adage « non bis in idem » (que les Anglo-Saxons connaissent sous la forme « ne bis in idem »). A plusieurs reprises, des peines de prison avec sursis ont été prononcées. A quelques reprises, des peines de prison ferme ont été requises. En un cas, celui d'Alain Guionnet, la peine de prison (trois mois) a été effectivement subie.

Mais cette répression judiciaire est loin d'être aussi grave et aussi lourde qu'en Autriche et en Allemagne, par exemple. Sur le modèle de la France, l'Autriche a adopté, le 19 mars 1992, une loi spécifiquement antirévisionniste. L'Allemagne a suivi, le 1er décembre 1994. Puis, la Suisse le 1er janvier 1995, la Belgique le 30 mars 1995 et, enfin, l'Espagne le 11 mai 1995.

Velléités de résistance contre la loi antirévisionniste

Dès l'entrée en vigueur de cette loi, j'ai déclaré :

La clause antirévisionniste va à l'encontre de l'évolution des mœurs. Elle rétablit clairement la censure. Elle institue une vérité historique officielle protégée par la police, la gendarmerie, les magistrats et les gardiens de prison. Elle crée un dogme, un catéchisme, un décalogue : celui de Nuremberg. On veut nous faire croire qu'un tribunal ― un tribunal « militaire » ― aurait, lui, écrit l'histoire une fois pour toutes. Il sévissait depuis longtemps une histoire officielle de la seconde guerre mondiale. Quand je le disais, nos tartuffes se récriaient. Aujourd'hui, ils ne peuvent plus protester [...]. Je ne chercherai pas à tourner la nouvelle loi, je lui ferai front [14].

Et j'ai, depuis six ans, tenu parole. A tous mes juges successifs, je déclare que je me moque de cet ukase et j'ajoute : « Je suis prêt à aller en prison. Pour moi, ce serait un honneur. Pour ceux qui m'y enverraient, ce serait un déshonneur ».

Six ans après, ce sont mes adversaires et mes juges qui se lassent. Ils expriment naïvement leur fatigue d'avoir à constater que dans mon cas les condamnations semblent ne servir à rien. Je peux même dire qu'à chaque procès le ton monte et que je prouve, par mon attitude et par mes propos, que je ne me laisserai pas intimider. Un jeune révisionniste, Vincent Reynouard, adopte, à Caen, la même attitude. Il refuse de justifier devant un tribunal ce qu'il a pu écrire ou publier soit dans sa revue (aujourd'hui disparue faute d'argent), Nouvelle Vision, soit dans des tracts.

Le 21 juin 1991, Jacques Toubon, député gaulliste, a demandé l'abrogation de cette loi, affirmant que «le délit de révisionnisme fait reculer le droit et affaiblit l'histoire [15] ». Il était alors dans l'opposition. Quand la droite et les gaullistes sont arrivés au pouvoir, J. Toubon est devenu ministre de la Justice. Il a alors déclaré qu'il n'était plus question, pour lui, d'abroger cette loi qu'en 1991 il avait trouvée digne de Staline. Il affirme maintenant : «Remettre en cause cette loi, ce serait maintenant donner raison dans l'opinion aux négationnistes [16]. »

Les récentes protestations contre

la loi antirévisionniste

A l'occasion de l'affaire Garaudy-abbé Pierre, on a récemment entendu une série de protestations, plus ou moins sincères, contre cette loi. Je ne mentionnerai ici que les noms des personnes citées à ce propos dans L'Événement du jeudi de la semaine du 27 juin au 3 juillet 1996 ; on voudra bien garder à l'esprit que toutes ces personnes sont hostiles au révisionnisme :

- à la page 3, Albert du Roy, directeur de ce magazine de l'établissement, écrit que Simone Veil a raison de plaider pour l'abandon de toute attitude dogmatique dans le style de la « loi Gayssot » ;

- à la page 13, Jean-François Kahn dénonce la traque des révisionnistes ; il demande : «A quoi rime cette espèce de chasse aux sorcières délirante, ce maccarthysme retourné [c'est-à-dire : à rebours] qui consiste, deux fois par semaine, à démasquer, à traquer, à débusquer un nouveau « révisionniste » ou « négationniste » [...] ? » et il se plaint de ce qu'« on organise un lynchage par semaine » ;

- à la page 20, on rappelle le mot de P. Vidal-Naquet : « Je suis prêt à tuer Faurisson, mais pas à le poursuivre en justice. » ;

- à la page 21, Dominique Jamet signe un article intitulé : « L'Histoire ne relève pas des tribunaux. » ;

- à la page 22, Simone Veil est interrogée ; elle demande l'abrogation de «la loi Gayssot » ;

- à la page 23, on rappelle : « En 1980, Chomsky défendant Faurisson [sur le plan de la liberté d'expression] ébranlait une partie de la gauche. » ;

- à la page 21, on pouvait lire : « "De grands historiens ont été ébranlés par Faurisson", reconnaît Taguieff. » ;

- à la même page 23, un avocat farouchement antirévisionniste, Me Korman, propose l'amendement de la loi [17].

Je n'entretiens cependant aucune illusion au sujet de ces soudaines manifestations en faveur du bon sens et de la justice. Des personnes comme P. Vidal-Naquet et M. Rebérioux ont une main droite qui ignore ce que fait leur main gauche. Ces personnes m'ont, dans le passé, poursuivi jusque devant les tribunaux où elles m'accusaient alors d'être un faussaire de l'histoire ! Il se trouve simplement que, devant la farouche détermination de certains révisionnistes (pas tous, malheureusement !) et devant la répugnance de certains magistrats à utiliser pleinement la loi antirévisionniste, des intellectuels ou des responsables juifs commencent à sentir qu'une telle répression les dessert. De fait, lorsqu'on regarde de près les arguments invoqués par ces tartufes contre «la loi Gayssot», on s'aperçoit que l'argument le plus souvent invoqué est... l'intérêt des juifs.

La réalité présente de la répression

La répression du révisionnisme a pris en France un caractère à ce point vicieux que, peu à peu, les révisionnistes se sont vus priver d'une série de droits pourtant inscrits dans la loi. Dans la pratique, leurs procès, par exemple, ne sont plus vraiment publics car plus un seul représentant de la grande presse n'y assiste ; en effet, que viendrait faire un journaliste ? Il ne pourrait, en aucun cas, reproduire soit les propos incriminés, soit les arguments révisionnistes développés à la barre par l'accusé. Un journaliste risquerait, par ailleurs, de compromettre sa carrière si on voyait qu'il s'intéresse de près au procès d'un révisionniste.

Dans la pratique, un révisionniste ne peut plus utiliser le «droit de réponse» aux attaques incessantes et aux calomnies de la grande presse, de la radio ou de la télévision car lui donner la parole ce serait prendre le risque d'encourir les foudres de la loi antirévisionniste. Toujours dans la pratique, un révisionniste ne peut plus exiger une protection contre la diffamation, l'agression physique, le vol de documents, le refus d'accès à un centre de recherches. L'expérience enseigne, en effet, que, s'il porte plainte, les tribunaux risquent fort de lui donner raison mais seulement en théorie. C'est l'adversaire, en fin de compte, qui l'emportera. Par exemple, un tribunal décidera que « traiter Faurisson de faussaire, c'est le diffamer, MAIS DE BONNE FOI ». Cette bonne foi est systématiquement du côté du diffamateur et non du diffamé.

Pour les révisionnistes, en France, il n'y a plus de justice ; ni foi, ni loi, ni droit : ils ne peuvent plus compter sur rien.

Je sais d'avance qu'il ne me sert à rien de porter plainte contre un juif qui me frappe ou qui me cause un tort ou un dommage quelconque. Je suis, dans mon pays, traité en Palestinien.

L'affaire Notin : les organisations juives font la loi

J'ai déjà mentionné « l'affaire Notin ». J'y reviens pour signaler que ce jeune maître de conférences, père de cinq jeunes enfants, ne disposant pour toute sa famille que de son seul salaire, a donné son dernier cours à l'université de Lyon le 2 mai 1990. Depuis cette date, année après année, il a demandé ― comme il en avait le droit, reconnu par la loi et par les autorités administratives ― d'exercer son métier d'enseignant, pour lequel il est payé. En pure perte. Chaque année, le président de son université lui répond oralement (afin que nulle pièce écrite n'en atteste) qu'il « sait bien que ce n'est pas possible » (sic). Il n'est pas possible de lui prescrire un « emploi du temps » parce que les autorités juives ont opposé, une fois pour toutes, leur veto à la reprise des activités de cet enseignant.

En désespoir de cause, B. Notin a cru trouver un poste d'enseignant à l'université d'Oujda (Maroc). Immédiatement, le journal Le Monde a répandu la nouvelle et les organisations juives ont manifesté leur émotion et leur colère [18] ; dans les quarante-huit heures, l'université d'Oujda s'est inclinée et a fait savoir qu'elle n'engagerait pas le malheureux universitaire. Depuis plus de six ans, la situation du maître de conférences, aujourd'hui âgé de quarante-cinq ans, constitue une anomalie du point de vue de la loi et du droit. Par un arrêt du 15 mai 1991, B. Notin avait été condamné en justice pour son article. Quant à la procédure administrative, elle n'est toujours pas achevée. Mais personne n'a le droit de l'empêcher d'exercer le métier pour lequel il est payé. Les organisations juives le savent mais elles se moquent de la loi. Les autorités de l'Éducation nationale le savent, elles aussi, mais elles ont manifestement peur. Les présidents de la République successifs, les milliers de collègues de B. Notin, les journalistes, tous sont au courant de cette criante anomalie. Mais tous se taisent. Les institutions et les organisations juives, porte-parole de la communauté juive, bénéficient en France de privilèges. L'affaire Notin montre qu'elles peuvent dicter leur loi à l'État. Je ne connais, dans notre pays, aucune autre communauté capable de déclencher une affaire de ce genre, de persécuter un homme avec cet acharnement, de le poursuivre jusque dans l'exil, et tout cela, sinon avec l'approbation de tous, du moins dans le silence général.

Les milices juives au secours de la « loi Gayssot »

En France, les milices armées sont strictement interdites sauf... pour les juifs. En 1986, à l'époque où L. Fabius était premier ministre, sa femme, Françoise Castro, également juive, a révélé que des milices juives et le ministère de l'Intérieur travaillaient main dans la main :

Extraordinaire nouveauté dans le comportement politique, la gauche a permis à des milices juives de s'installer dans des quartiers de Paris, mais aussi à Toulouse, à Marseille, à Strasbourg [et d'avoir] des contacts réguliers avec le ministre de l'Intérieur [19].

A ceux qui souhaiteraient plus de détails sur les actions criminelles des milices, je recommande de consulter, sur les sites révisionnistes d'Internet, un texte du 1er juin 1995 intitulé : « Milices juives : quinze ans ― et plus ― de terrorisme en France » [20]. On y verra notamment comment, au mépris de la loi, les milices du Bétar ont pour habitude de faire la loi au Palais de justice de Paris, en particulier quand les révisionnistes viennent y passer en jugement pour avoir enfreint la « loi Gayssot ». J'ai moi-même été blessé, comme d'autres révisionnistes, le 22 mars 1991, par des membres de cette milice.

La situation aujourd'hui même

Mes deux dernières condamnations remontent au 6 septembre 1993 et au 13 juin 1995. Je dois la première de ces condamnations au fait que, rendant compte d'un documentaire sur Auschwitz et Birkenau, j'ai simplement parlé des « réalités qui prouvent que ces camps n'étaient pas des "camps d'extermination" malgré les ravages exercés par les épidémies de typhus». Je dois la seconde de ces condamnations à ma Réponse à Jean-Claude Pressac sur le problème des chambres à gaz. Le 29 février 1996, j'étais miraculeusement acquitté dans deux autres procès. Le 15 novembre prochain, je comparaîtrai pour un communiqué de presse envoyé le 19 avril 1996 à l'Agence France-Presse sur l'affaire Garaudy-abbé Pierre. Roger Garaudy a été simplement «mis en examen», ainsi que son éditeur Pierre Guillaume, pour avoir publié, dans une revue distribuée aux seuls abonnés, Les Mythes fondateurs de la politique israélienne. Le 3 janvier 1996, Vincent Reynouard a été condamné par le tribunal de Caen qui n'a pas craint d'accuser dans son jugement le jeune révisionniste de « véhiculer ses idées fausses » ; cette formulation prouve bien que, comme au siècle dernier, on peut en France, aujourd'hui, être condamné pour des « idées » qu'un tribunal se permet de juger « fausses ». Comme je l'ai dit plus haut, Éric Delcroix, avocat au barreau de Paris, passera en jugement le 24 septembre 1996 pour avoir écrit et publié à son compte La Police de la pensée contre le révisionnisme.

Le moindre mot, la moindre attitude qui puisse laisser supposer qu'on a des pensées ou même, plus simplement, des arrière-pensées révisionnistes expose aujourd'hui à des poursuites judiciaires sur le fondement de la « loi Gayssot », loi dite officiellement « sur la liberté de la presse ».

Et à l'avenir ?

En ce domaine, rien ne permet de présager de l'avenir. On peut aussi bien craindre une aggravation des mesures de répression, notamment par l'adoption d'une loi encore plus sévère que la « loi Gayssot » qu'espérer une sorte de relâchement ou de tolérance. Cette dernière éventualité est concevable à cause du progrès d'Internet. Récemment, l'UEJF, découvrant que certains de mes textes étaient consultables sur Internet, a saisi le juge Jean-Pierre Marcus, juif, en vue d'obtenir une interdiction judiciaire de certains sites. Le juge s'est rendu compte qu'une mesure de censure était impossible. L'UEJF semble avoir compris que la « loi Gayssot » est, dans un tel cas, inapplicable. Les révisionnistes français ont aujourd'hui tendance à diffuser leurs écrits sur Internet au lieu de les confier à l'imprimerie.

Mise à jour (31 décembre 1996)

Depuis le 1er septembre 1996, date de rédaction de cette étude, la répression du révisionnisme en France s'est aggravée.

Le 5 septembre, la radio Ici et Maintenant a dû cesser ses émissions à la suite d'une décision du Conseil supérieur de l'audiovisuel qui reproche à cette radio des « propos racistes, antisémites et négationnistes ».

Le 7 septembre, quatre jeunes juifs ont agressé Patrick Hélin, bouquiniste des bords de Seine, qu'ils ont traité de « révisionniste ».

Le 22 octobre, mon avocat, Éric Delcroix, a été condamné pour avoir écrit et publié La Police de la pensée contre le révisionnisme ; à la suite de cette condamnation, l'Ordre des avocats, en la personne de l'avocat Bernard Vatier, s'est empressé d'entamer une procédure contre son confrère É. Delcroix.

Le 30 novembre, M. Piscoci-Danesco, le libraire déjà agressé le 16 juillet (avec deux cent cinquante mille francs de dégâts dans sa boutique, somme dont l'assurance ne lui remboursera rien), voit trois jeunes juifs briser sa vitrine.

Le 20 décembre, Vincent Reynouard, professeur de mathématiques et de physique, est suspendu d'enseignement sine die. Le recteur Philippe Lucas lui fait grief de ses convictions révisionnistes. Le jeune professeur, marié, père de deux enfants (salaire unique), est menacé de radiation et de chômage.

Mon propre procès pour un communiqué de presse au sujet de l'affaire Garaudy-abbé Pierre est remis au 6 juin 1997.

Bibliographie

En plus de l'ouvrage d'Éric Delcroix, que j'ai mentionné, le chercheur devra consulter la Revue d'histoire révisionniste dont les six livraisons ont paru de mai 1990 à mai 1992. Les articles suivants concernent plus spécialement le sujet :

- « L'affaire Notin» (RHR n° 1, p. 143-146) ;

- « Arrêté [du] ministère de l'Intérieur » (RHR n° 2, p. 8) et « Contre le révisionnisme historique, la loi Fabius alias Gayssot » (Id., p. 16-35) ;

- Éric Delcroix, « Un séquestre pour l'éternité ?» (RHR n° 3, p. 33-43) ;

- « Trois juges français dénaturent un procès-verbal » (RHR n° 3, p. 204-205) ; « Deleatur dans l'affaire Notin» (Id., p. 206) ; «Non-lieu dans l'affaire de Nantes» (Id., p. 207) ;

- Henri Roques, « La RHR devant le Conseil d'État » (RHR n° 4, p. 9-11) ; « Procès Faurisson » (Id., p. 107-133) ; « Wannsee : une dénaturation confirmée » (Id., p. 192-193).

1er septembre 1996

Notes

[1] Cour d'appel de Paris, première chambre, section A, François Grégoire, Paul Fouret, Germain Le Foyer de Costil, 26 avril 1983.

[2] P. Vidal-Naquet, Les Assassins de la mémoire, Paris, La Découverte, 1987, p. 182.

[3] G. Wellers, Le Droit de vivre, juin-juillet 1987, p. 13.

[4] Bulletin quotidien de l'Agence télégraphique juive, p. 13.

[5] Actualité juive.

[6] Le Figaro, 21 septembre 1987, p. 7.

[7] Le Monde, 26-27 mars 1989, p. 18.

[8] Radio J[uive], le 16 septembre, et Le Monde, 19 septembre 1989, p. 14.

[9] Le Monde, 28-29 janvier 1990, p. 9.

[10] L'Arche, avril 1990, p. 25-26 ; Le Figaro, 2 avril 1990, p. 2.

[11] Pour plus de détails, voy. É. Delcroix, La Police de la pensée contre le révisionnisme. Du jugement de Nuremberg à la loi Fabius-Gayssot, Colombes, Diffusion RHR, 1994, p. 79.

[12] Le Figaro Magazine, 5 mai 1990, p. 82-83.

[13] Le Figaro, 29 juin 1990, p. 2.

[14] Le Choc du mois, septembre 1990, p. 9-11.

[15] Journal officiel, Assemblée nationale, 22 juin 1991, p. 3571-3573.

[16] Paris Match, 6 juin 1996, p. 63.

[17] Voy. aussi Le Monde, 21 mai 1996, p. 14.

[18] Le Monde, 7 juin 1994.

[19] Le Monde, 7 mars 1986, p. 8.

[20] Voy. Ecrits révisionnistes (1974-1998), p. 1694-1712.

Labels: Bardèche, Bernard Notin, Charles Pasqua, Chirac, Éric Delcroix, Fabius, Garaudy, Henri Roques, Klarsfeld, Le Pen, Loi Gayssot, Pressac, Rassinier, Samuel Sirat, Vincent Reynouard
