<!-- https://robertfaurisson.blogspot.com/2008/05/invite-mais-censure-par-radio.html -->

<!-- Thursday, May 1, 2008 -->

# Invité, mais censuré, par Radio Courtoisie

Le mercredi 9 avril, j’ai été invité par Martin Peltier à m’exprimer sur les ondes de Radio Courtoisie. Notre entretien était prévu pour durer de 19h30 à 21h mais il a été interrompu au bout de vingt-sept minutes. Il l’a été sans préavis et aucune explication n’a suivi. Radio Courtoisie est une modeste station, à but non lucratif, qui se présente en « radio de toutes les droites ». Elle est dirigée par Henry de Lesquen. Sur l’affaire, on trouvera ci-dessous une série d’éléments classés dans l’ordre chronologique.

## 1) Communiqué de « Bocage » (11 avril)

C’est dans le plus grand secret que Martin Peltier, pour son émission mensuelle de Radio Courtoisie, avant-hier, mercredi 9 avril, avait invité le professeur Faurisson. Tous deux s’étaient bien mis d’accord pour faire en sorte de ne jamais transgresser la loi Fabius-Gayssot, non seulement pour échapper eux-mêmes à toute poursuite, mais pour préserver la station radio mise, comme on le sait, par le CSA (Conseil supérieur de l’audiovisuel) en liberté surveillée.

L’émission a commencé à 19h 30 ; les deux interlocuteurs, avec d’infinies précautions, ont relaté les persécutions dont sont victimes les révisionnistes à travers le monde. Les correspondants qui le désireront pourront nous réclamer la transcription de cette émission.

Mais, au bout de 27 minutes, l’entretien a été coupé... Motif invoqué sur place : « La coupure est faite à la demande du CSA ».

Or, voici ce qu’on pouvait lire sur le site du quotidien Le Parisien, avant-hier soir, à 22h 30 :

> Etrange silence sur Radio Courtoisie
> 
> Brutale interruption des programmes ce mercredi soir sur Radio Courtoisie.
> 
> Alors que la station ― qui se définit comme « la radio de toutes les droites » ― diffusait une émission sur le révisionnisme, l’antenne a soudain été coupée. Sans préavis, « Le libre journal » présenté par Martin Peltier a laissé la place à de la musique classique. Il n’a pas repris.
> 
> Quant à l’émission du député européen Paul-Marie Coûteaux, qui devait commencer à 21h30, elle a été reportée à une date ultérieure.
> 
> Contacté, Henry de Lesquen, le responsable de la station, nous a expliqué que l’émission avait été interrompue vers 19h30 « par la déléguée aux questions éditoriales qui a considéré que l’un des invités tenait des propos inacceptables ».
> 
> Il n’a cependant pas indiqué de quels propos il s’agissait, ni pourquoi les programmes n’avaient toujours pas repris.
> 

Non seulement il semble qu’il y ait eu censure de la part de la radio elle-même, mais il y a censure dans l’article ci-dessus faisant état de la censure, puisque le nom du professeur Faurisson n’est même pas mentionné !

## 2) Transcription, due à « Bocage, » de l’entretien

Martin Peltier : Bonsoir, Professeur.

Je dois expliquer aux auditeurs pourquoi j’ai décidé d’inviter dans ce studio un repris de justice. Tout nous sépare : vous êtes professeur de faculté, j’ai toujours été un cancre ; vous êtes à moitié britannique et la Grande-Bretagne est ma bête noire politique ; vous êtes athée, je suis catholique. Alors pourquoi ?

Eh bien il y a des raisons inavouables – d’abord, on aime toujours faire le malin. Et puis il y a des raisons frivoles : vous êtes un amateur de Nerval et vous tenez Isidore Ducasse pour un farceur, ce qui est très sympathique.

Et puis il y a deux raisons avouables :

La première, d’abord, j’écoute l’Evangile : « Ce que vous ferez au plus petit d’entre les miens c’est à moi que vous le ferez », a dit le Christ. Or aujourd’hui, dans notre société, le plus petit ce n’est pas le chômeur, ce n’est pas non plus l’immigré clandestin, qui a bénéficié de la bienveillance et du soutien d’une foule d’associations bien-pensantes ; le plus petit c’est le révisionniste, ce pelé, ce galeux, de qui vient la pire des pestes : celle qui affecte la mémoire.

Et il y a une deuxième raison à cette invitation : nous ne parlerons pas aujourd’hui de vos idées ni de vos travaux, Professeur Faurisson, parce que c’est interdit par la loi. Mais la façon dont les médias et l’appareil d’État vous ont traité est dégoûtante et choquante. On peut très bien soutenir que la pensée et son expression doivent être limitées, doivent être dirigées – c’est peut-être même souhaitable, sait-on jamais ? Mais qu’une société, qui a fait du blasphème une vertu et qui proclame à tout va son désir de liberté totale, réprime avec la dernière férocité le délit d’opinion est insupportable, du point de vue de la logique et du point de vue de la morale. Il faut donc dénoncer ce fait avec force et précision : on ne peut pas rester toute sa vie couché devant les oukases des puissants et les [inaudible] qu’ils imposent. Pour l’honneur de la presse et pour celui du peuple français, il faut bien qu’on redresse de temps en temps ne serait-ce que le bout d’une oreille.

Alors nous allons faire aujourd’hui de l’histoire, un peu d’histoire du révisionnisme. Il ne s’agira absolument pas de justifier quelque thèse que ce soit mais de raconter ce qui s’est passé.

Cela dit, soyons clairs : nous ne parlerons pas des chambres à gaz ! La loi Gayssot de 1990 réprime la contestation du crime contre l’humanité tel que l’a défini le tribunal de Nuremberg en 1946. Et, si je ne me trompe, elle condamne cette contestation même par insinuation. Quel est le texte exact ? Vous pouvez me le citer, de mémoire ?

Robert Faurisson : Il est exact que cette loi du 13 juillet 1990, qu’on a pris l’habitude d’appeler la loi Fabius-Gayssot ou Gayssot, interdit la contestation de ce qu’on appelle les crimes contre l’humanité tels qu’ils ont été définis, jugés, condamnés, notamment par le tribunal militaire international de Nuremberg en 1945-46. Mais cette loi du 13 juillet 1990 a reçu des applications qui font qu’il existe aujourd’hui une jurisprudence qui fait que, non seulement vous n’avez pas le droit de contester mais, pour résumer, vous n’avez pas le droit de paraître contester. Il est dit exactement, dans le Code pénal, que vous n’avez pas le droit de procéder à une contestation, même par voie d’insinuation. Par conséquent tout peut, ou à peu près tout peut s’interpréter comme une contestation.

MP : Absolument. Et c’est là que – je reprends la parole – c’est un secret pour personne, professeur, que vous avez mis en doute l’existence des chambres à gaz homicides dans l’Europe occupée par Hitler et que vous révisez fortement à la baisse le nombre communément admis de six millions de juifs morts pendant la seconde guerre mondiale. Je ne vous interrogerai donc pas à ce sujet et si vous aviez envie d’y venir spontanément je vous couperais avec la dernière rigueur et sans la moindre courtoisie, je vous en préviens. Vous êtes ici en quelque sorte en liberté surveillée – c’est ce que je peux vous offrir de mieux – et nous nous en tiendrons à trois sujets strictement définis avant l’émission. D’ailleurs, pour vous faire une confidence, même sans la loi Gayssot, je ne vous aurais pas laissé développer vos thèses révisionnistes ; en dehors des sanctions légales prévues par le législateur et décidées par les juges il y en a d’autres, spontanément appliquées, tacitement ou hautement revendiquées : il y a les pressions sur les familles, les brimades dans le travail, les voies de fait qui s’exercent contre ceux qui pensent mal et ceux qui les laissent s’exprimer. Il y a des puissances para-légales qui s’exercent en toute tranquillité dans notre pays, il y a des milices au-dessus des lois et j’avoue que j’en ai peur ; j’ai la trouille de la puissance plus ou moins occulte que l’on voit au travail autour de la mémoire des années dites les plus sombres de notre histoire.

Et le premier sujet que je voudrais que vous abordiez est précisément la persécution contre les révisionnistes en France et dans le monde. Vous-même vous avez été battu et laissé pour mort par une bande de voyous que la police a préféré laisser courir en fin de compte. Vous avez perdu votre emploi et plusieurs procès vous ont ruiné. Mais finalement vous estimez avoir de la chance parce que vous n’avez jamais fait de prison pour révisionnisme, finalement. Quel est… comment vous jugez-vous vous-même dans cette affaire-là ?

RF : Pour répondre à votre question, « juger c’est comparer » ; je compare mon sort à celui de bien d’autres révisionnistes, notamment allemands ou autrichiens. Je juge la justice qui m’a condamné mais par rapport également à la justice allemande, la justice autrichienne, la justice suisse, la justice britannique, la justice canadienne anglophone, la justice américaine et d’autres justices encore, la justice australienne, par exemple. Et j’estime que j’ai de la chance de vivre dans un pays de cocagne qui s’appelle la France ; j’ajoute que pour moi la République est bonne fille quand elle n’est pas en guerre, en guerre civile, ouverte ou larvée ; et enfin, je dois le confesser, j’ai la baraka.

MP : Vous avez fait un petit tour d’horizon. J’aimerais qu’on revienne point par point sur… Est-ce que… Justement il faut faire de la pédagogie. Déjà l’histoire des différentes persécutions. Est-ce qu’on peut faire le point des différents pays avec vous ? Est-ce que vous pouvez me dire, par exemple, où on en est en Suisse ? Quels sont les procès qui ont eu lieu contre les révisionnistes, quelles sont les persécutions qu’ils ont subies ? Je pense à Amaudruz, peut-être ?

RF : Alors, il y a Amaudruz, qui, à l’âge, je crois, de 82 ans, a été en prison, peut-être pour 3 mois, mais il y a eu d’autres personnes – je vous avoue que c’est un sujet que je n’ai pas tellement envie de traiter parce que c’est une façon de se plaindre que de parler des persécutions qu’on a subies. Parce que la question est de savoir si sur le fond nous avons raison ou non, et là, vous m’interdisez de parler.

MP : Absolument. Là je suis très clair. Mais, par définition, on ne peut pas parler de choses dont on ne peut pas parler. C’est une tautologie. Mais j’adore la tautologie : c’est mon sport préféré. Alors je crois qu’il est quand même intéressant – vous n’avez pas envie d’en parler mais j’ai envie de vous en faire parler parce que je crois que le public, le public même cultivé n’a pas… – Vous, vous nagez dedans, un peu comme Obélix, depuis que vous êtes tout petit mais le grand public, même cultivé, même éclairé n’a pas pris la mesure de l’extrême, je ne dirai pas sévérité, mais de l’extrême bizarrerie des sanctions portées contre plusieurs personnes. Alors, bon, allons-y pour l’Autriche. Moi j’ai deux cas dont j’aimerais que vous parliez : c’est le cas de M. Honsik et le cas de M. Fröhlich. Je ne vous demande pas de m’en parler pendant trois heures mais en deux minutes, voilà, déjà, vous pouvez faire du bon travail.

RF : Gerd Honsik est effectivement un révisionniste et il a habité Vienne ; il a été condamné pour révisionnisme ; il s’est réfugié en Espagne et, il y a peu de temps, l’Espagne l’a extradé, rendu à l’Autriche et donc Honsik est en prison.

MP : On extrade, pour ce délit-là…

RF : Voilà !

MP : C’est un délit ou un crime ? C’est un délit, tout de même.

RF : Alors, « délit » ou « crime », tout dépend, n’est-ce pas ; par exemple, en justice anglo-saxonne, on parle de « crime » ; ça peut être un délit, c’est une question de vocabulaire, peu importe. Le fait, le fait important – vous avez raison de le souligner – c’est qu’on arrive à extrader. Alors, à ce propos, je vais continuer, donc, de répondre, puisque vous m’avez parlé de Honsik mais également de Fröhlich ; je vais donc rapidement parler de Fröhlich puis je reviendrai à cette affaire d’extradition car, vous avez raison, elle est importante. Fröhlich est un spécialiste des chambres à gaz de désinfection et il a dit que les chambres à gaz nazies, pour lui, étaient impossibles pour des raisons…

MP : Oui, mais, là on va vraiment…

RF : Attendez : voilà. Donc, en tant que révisionniste il a été condamné et je crois qu’il est condamné pour quelque chose comme six ans et cinq mois de prison.

MP : D’accord.

RF : J’en arrive à la question d’extradition. Vous savez, on fait valoir que la France possède des lois antirévisionnistes.

MP : Oui.

RF : C’est le cas également de la Suisse, de la Belgique, de l’Espagne, de l’Allemagne évidemment, d’autres pays encore. On fait valoir que dans les pays anglo-saxons il n’y a pas de loi antirévisionniste. Pure hypocrisie ! Et c’est là que j’en viens à la question d’extradition. Prenez les États-Unis. Voilà un pays où je dois dire que personnellement je me sentais libre. C’était à peu près le seul pays du monde où je me sentais libre. Eh bien, c’est fini. Puisque si nous prenons le cas d’un des principaux révisionnistes, Ernst Zündel, il vivait dans le Tennessee et un beau jour il a vu arriver cinq malabars de la police, qui l’ont menotté, qui l’ont conduit en prison puis qui l’ont livré au Canada ; le Canada – tenez-vous bien – l’a mis en prison pendant deux ans dans des conditions a-bo-mi-nables…

MP : C’est-à-dire ?

RF : C’est-à-dire : dans sa cellule, où en hiver il crevait de froid, pas le droit à une chaise, pas le droit à un oreiller, pas le droit à quoi que ce soit, des fouilles anales continuelles et intimidation en amenant des chiens – on le mettait à terre, lui, et les chiens, n’est-ce pas, lui bavaient dessus : voilà comment il a été traité pendant deux ans au Canada, puis…

MP : Une question technique, pendant que j’y pense : il avait été amené des États-Unis au Canada sur un mandat d’arrêt international, une demande d’extradition ?

RF : Même pas. Si, c’est une demande ; ce n’était pas international : c’est le Canada qui l’a réclamé et qui l’a obtenu, c’était d’accord entre les États-Unis et le Canada. Donc les États-Unis, où vous avez le Premier Amendement, où vous êtes censé pouvoir vous exprimer librement, traitent un révisionniste comme un gangster et avec des méthodes de gangster. Il a donc été livré. Bien. Et il est passé devant un tribunal spécial – je dis bien : spécial – dit « commission des droits de l’homme ». Et je sais d’expérience ce que c’est et je pense que les auditeurs vont quand même être intéressés par ce point.

MP : Alors qu’est-ce que c’est qu’une commission…

RF : Voici. On a dit, lorsqu’en 1992 Zündel a fini par gagner ses fantastiques procès de 1985 et de 1988 par une décision de 1992, certaines personnes – je ne les désigne pas – ont dit : c’est intolérable ; il faut faire quelque chose. Elles ont dit : il faut des commissions des droits de l’homme. Alors le bon peuple a dit Oui. Enfin, les parlementaires ont dit Oui. Puis, second pas : mais attendez : il faudrait des tribunaux des droits de l’homme, pas des tribunaux ordinaires, et on a créé des tribunaux spéciaux où les juges sont recrutés d’après leur sensitivity – je n’ai pas besoin de traduire – à un certain problème et vous arrivez devant ces tribunaux – moi ça m’est arrivé quand je suis venu défendre Ernst Zündel, on vous fait lever la main droite, on vous fait jurer de dire la vérité, toute la vérité, rien que la vérité, et, la minute d’après, si vous avez le malheur de dire « Mais, Ernst Zündel, on ne peut rien lui reprocher car ce qu’il dit est exact et peut se démontrer, et je me fais fort de le démontrer », à ce moment-là le tribunal intervient et vous dit : « Attention, here, Truth is no defence », c’est-à-dire qu’ici « la Vérité n’est pas défense. Il nous importe peu de savoir si ce que vous dites est exact ou non, ce qui nous intéresse c’est de savoir la douleur qu’éventuellement vous pouvez déclencher dans un segment de la société canadienne ».

MP : Très bien. Vous me disiez, la suite, donc il a été jugé au Canada, de cette façon…

RF : Et ensuite l’Allemagne l’a réclamé, et il a été livré à l’Allemagne, jugé dans des conditions épouvantables…

MP : Une deuxième extradition…

RF : Une deuxième extradition et, en Allemagne, non seulement il a été condamné à cinq ans mais on a refusé de tenir compte des deux ans qu’il avait passés au Canada et, en plus, une de ses avocates est maintenant en prison…

MP : Qui s’appelle ?

RF : Sylvia Stolz. « Stolz » en allemand veut dire « fier ». On l’appelle couramment « la Jeanne d’Arc allemande ». Et un autre de ses avocats va passer en jugement, il s’appelle Jürgen Rieger.

MP : Ça fait beaucoup, finalement.

RF : Oui. Mais, vous savez, si vous faites le compte des misères physiques qui sont arrivées aux révisionnistes, c’est finalement peu de chose !

MP : On y reviendra tout à l’heure…

RF : Je ne sais pas si c’est vraiment utile…

MP : Mais pour l’instant on est sur la question purement judiciaire. Il y a le cas de l’Australie, je crois, il y a un monsieur Töben, en [Belgique] il y a un ancien sénateur du Vlams [Blok], et en Grèce il y a un Constantinos Plevris… En dehors des questions purement judiciaires, pour en rester dans des sanctions qui ne sont pas des sanctions brutales et qui ne sont pas des sanctions légales, il y a des sanctions disciplinaires ou universitaires. Je pense, en France, à des gens comme Notin, Plantin, Bruno Gollnisch…

RF : Bien sûr !

MP : Pouvez-vous nous en dire quelques mots quand même ? Ça ne me semble pas du tout négligeable.

RF : Prenons le cas de Notin. Pour avoir, dans une revue scientifique vraiment confidentielle, glissé une toute petite réflexion où il manifestait son scepticisme quant à une question dont vous ne voulez pas que je vous parle, eh bien, Notin a connu l’enfer. Ça a commencé par l’exécution de ses animaux domestiques : on a tué ses chiens…

MP : Ses chats…

RF : Oui, ses chats, pardon. [Note : En fait, on a d’abord tenté de tuer son chien, puis on a réussi à tuer son chat]. Ensuite on s’en est pris à sa femme, à ses enfants, à lui-même, puis…

MP : Des insultes ? des menaces ?

RF : Tout ce que vous voudrez. Je dois aller vite ; je vous donne le résultat de ces courses : ses collègues se sont permis, bien sûr, de le juger, de le condamner. La malheureuse revue qui avait publié son article a été pilonnée : on est allé en rechercher les exemplaires dans toutes les bibliothèques ; ensuite, lui, n’a plus pu exercer son métier d’enseignant à Lyon-3 et, là-dessus, se voyant condamné, avec un procès sur le dos, eh bien il a eu le malheur de choisir un avocat – dont je ne donnerai pas le nom mais qui est un sacré farceur – et qui lui a fait signer une abjuration. J’aime autant vous dire que Notin – il ne s’en cache plus, je pense, aujourd’hui – m’a présenté ses excuses pour cette abjuration mais on lui conseillait ça : ça n’a servi à rien du tout : quand il a voulu obtenir un poste à l’étranger il a cru qu’il allait en obtenir un ; « on » l’a su, et, bien entendu, il n’en a plus été question. Ce devait être le Maroc. Finalement il s’est retrouvé au Mexique et, bien sûr, divorce : femme, quatre enfants, terminé. Et c’est un exemple.

Ensuite vous m’avez parlé d’un autre cas : le cas Plantin. Il est extraordinaire.

Plantin est un homme très sérieux et très prudent, très modéré. Il avait soutenu une thèse qui lui avait valu de la part d’un certain professeur du nom de Régis Ladous, L-A-D-O-U-S, la mention Très Bien. Ce n’était pas à proprement parler révisionniste mais enfin ça y touchait. Puis, il a eu, l’année d’après, un autre diplôme. Peu importe. Dix ans après on s’est avisé de cette affaire, alors que Plantin était parti dans la nature et qu’il y avait longtemps qu’il n’était plus à l’université. Voici ce qu’on a osé faire – écoutez ça, c’est absolument extraordinaire ; je pense que ça ne s’est jamais passé dans l’histoire mondiale, et ça s’est produit à Lyon, Rhône :

Eh bien on a inventé une soutenance fictive, dix ans après ! C’est-à-dire qu’on a obligé Ladous à venir, on a convoqué Plantin – qui, bien sûr, n’est pas venu – et, là, on a fait semblant de procéder à une soutenance de thèse ; ça a duré, je crois, dix minutes ; Ladous s’est retiré et puis il est venu déclarer que la thèse, à laquelle il avait donné la mention Très Bien, recevait maintenant, dix ans après, la mention… alors je ne me rappelle plus l’adjectif mais quelque chose comme « intolérable ». [Note : en fait, « inacceptable »].

Mais nous avons des exemples extravagants. Je voudrais vous donner, puisque ça vous intéresse…

MP : Oui ça m’intéresse, ce sujet.

RF : Moi il ne m’intéresse pas spécialement, mais il vous intéresse vous, alors je vais vous faire plaisir : comme vous me menacez je vais vous faire plaisir !

MP : Eh bien voilà !

RF : Voilà. Eh bien, prenez ce qui m’est arrivé l’année dernière : je suis invité par un professeur italien prestigieux à venir enfin délivrer un petit cours – « délivrer » est un anglicisme, donner un petit cours…

MP : C’est mieux…

RF : N’est-ce pas que c’est mieux ? Je suis comme vous, là-dessus.

Et je vais donc à l’université de Teramo. Teramo : vous voyez Rome ? Bon, eh bien, vous tirez une flèche vers l’Adriatique, à cette hauteur-là, et vous avez Teramo. Je vais à l’université de Teramo et il est entendu que dès le matin je vais m’y rendre. Et que fait le président de l’université ? Je ne sais pas si un pareil précédent existe. Eh bien il a fait fermer l’université !

MP : C’est très italien. Ils sont très malins, parce qu’il fallait trouver une solution.

RF : (Riant) Vous approuvez presque !

MP : Non mais il faut avoir de l’imagination.

RF : Et alors, la suite est intéressante : eh bien nous nous sommes portés vers un hôtel où nous pensions pouvoir tenir cette petite conférence, et là j’ai trouvé un groupe de journalistes italiens. L’Italien, vous savez, a tendance à être subtil…

MP : Ça oui !

RF : … et il est humain. Je me suis trouvé, à la porte de l’hôtel qui a refusé de me recevoir et, là, au bord d’une de ces belles places italiennes, les journalistes m’ont interrogé, j’ai répondu, et pas comme avec vous : tout de suite sur le fond, j’ai sorti mon magnum, c’est-à-dire la phrase de soixante mots, que je ne vous dirai pas…

MP : Non !

RF : Et là-dessus je leur ai dit : « Mais vous savez, ce qui se passe en ce moment, c’est extraordinaire. Parce que c’est inconcevable en France que je puisse comme ça, quasiment sur la voie publique, et avec des journalistes, m’entretenir de ce sujet. » Je leur ai dit : « Jusqu’à présent ! Jusqu’ici ça s’est bien passé ». Je n’avais pas terminé cette phrase que j’entends un hourvari et c’est une bande de personnes particulières que je ne qualifierai pas, qui sont venues par train de Rome, avec à leur tête un garçon boucher particulièrement musculeux qui a porté un coup – mais un coup qui aurait pu être mortel – au professeur qui m’invitait et [coupure « à la demande du CSA » (?), puis musique en continu].

## 3) Message d’Eric et Monique Delcroix à Martin Peltier

Cher Ami,

Nous nous étions réjouis un peu trop tôt d’entendre votre dialogue avec le professeur Faurisson... La censure la plus brutale, soi-disant à la demande verbale du CSA, a mis fin à une ultime illusion... Pourtant vous aviez pris toutes les précautions pour ne pas transgresser la loi Fabius-Gayssot. Les vaticinations de feu l’humoriste Pierre Desproges se réalisent. Rappelez-vous son « Tribunal des flagrants délires », lorsqu’il fit annoncer le prévenu par l’huissier : « Monsieur Faurisson », provoquant la réponse du président : « Non, pas ce nom-là, c’est interdit ! » Nous n’aurons bientôt même plus de nom, plus d’existence. « Blow up » ! Orwell nous l’avait bien dit.

Bien amicalement. Éric et Monique Delcroix.

## 4) Trois jours après l’entretien du 9 avril

Martin Peltier a reçu d’Henry de Lesquen une lettre lui annonçant la suppression définitive de son émission et son renvoi de Radio Courtoisie où il travaillait bénévolement. Aux auditeurs qui avaient téléphoné pour s’en étonner, Radio Courtoisie avait expliqué que l’ordre d’arrêter l’entretien venait du CSA. Mais, à 19h30/20h, il est probable qu’au CSA les bureaux sont vides et que ne fonctionnent plus que les appareils d’enregistrement, qui seront consultés le lendemain par les censeurs. En réalité, la décision de censure paraît avoir été prise, au sein de Radio Courtoisie, par Madame Paoli, déléguée aux questions éditoriales, après consultation de M. Henry de Lesquen. A la décharge de Radio Courtoisie il faut admettre que l’intolérance en matière de presse est aujourd’hui telle que l’autocensure en est presque devenue une nécessité. Martin Peltier n’a écouté que son courage ; il se fera donc traiter d’irresponsable mettant toute une entreprise en péril. « Il aurait au moins dû demander à d’autres que Faurisson de venir parler de la répression du révisionnisme ! » Quels autres ?

Député européen de la tendance de Philippe de Villiers, Paul-Marie Coûteaux devait, à son tour, intervenir à Radio Courtoisie vers 21h, mais il a fait savoir qu’il refusait de prendre la parole après Faurisson. Il n’est donc pas venu. De leur côté, Emmanuel Ratier et Alain Sanders ont spontanément fait savoir à Henry de Lesquen qu’ils ignoraient que Faurisson allait s’exprimer après eux. Il est peu probable que, dans sa prochaine livraison de *Faits & Documents*, E. Ratier ose rapporter quoi que ce soit de toute cette affaire.

Rompant avec les usages, Radio Courtoisie n’a procédé le lendemain à aucune nouvelle diffusion de l’entretien. Elle n’a, par la suite, fourni aucune explication ni présenté d’excuses à ses auditeurs. Elle n’a pas même fait état d’un événement qui, dans les vingt années de son existence, n’a probablement pas connu de précédent.

## 5) Henry de Lesquen s’explique le 14 avril

Cinq jours après l’affaire du 9 avril, Henry de Lesquen s’explique enfin sur sa décision d’interrompre l’entretien. Il le fait sur un ton de satisfaction. Il présente Radio Courtoisie comme une radio libre où « la liberté d’émission est totale ». Il précise que les patrons de chaque émission sont libres et nullement tenus d’annoncer le contenu de leurs émissions respectives. Il déclare en passant que les auditeurs de Radio Courtoisie sont « fins et intelligents ». Mais, ajoute-t-il, Radio Courtoisie est soumise aux autorisations d’émission délivrées par le Conseil supérieur de l’audiovisuel et, dans le passé, elle a eu à payer de lourdes amendes. Il explique que, le 9 avril, « un invité » (?) ayant tenu des propos (?) susceptibles de mettre Radio Courtoisie en péril, il avait rapidement décidé d’interrompre l’émission. Il dit que, par la suite, tous les responsables de Radio Courtoisie ont approuvé son initiative. Il qualifie l’affaire de « malheureux incident ». Il ne nomme ni Robert Faurisson ni Martin Peltier et **il ne révèle pas qu’il a sanctionné ce dernier par une lettre lui signifiant son renvoi.** Il ne prononce pas le mot de « révisionnisme » et ne donne aucune idée du contenu de l’émission. Il affirme que, si l’émission suivante, celle de Paul-Marie Coûteaux et de ses deux invités, prévue pour durer de 21h30 à minuit, a été, elle aussi, remplacée par de la musique, cela n’a été dû qu’à « un fâcheux concours de circonstances » et à la malencontreuse « indisponibilité » de certains des invités. La vérité est que P.-M. Coûteaux et ses invités, apprenant que le professeur les avait précédés dans le studio, ont refusé de s’exprimer « après Faurisson ».

## 6) Martin Peltier s’explique le 17 avril. Propos diffusés sous le titre « Survivre entre censure et autocensure »

Bocage : Que s’est-il passé à Radio Courtoisie le mercredi 9 avril ?

Martin Peltier : J’avais invité en deuxième partie de mon « Libre Journal », de 19h 30 à 21h, le professeur Faurisson. Un peu avant 20h, la musique a couvert nos voix et le technicien m’a signalé par geste que l’émission était finie. On nous a indiqué qu’un membre du CSA avait conseillé cette censure dans l’intérêt de la station, et c’est ce qui a été répété pendant une heure aux innombrables auditeurs qui téléphonaient pour la déplorer.

B : Le Parisien du lendemain 10 avril donne une autre version.

MP : En effet. Selon lui, l’un de ses journalistes, surpris par cette brusque interruption des programmes, a interrogé immédiatement Henry de Lesquen, le patron de Radio Courtoisie, qui lui aurait fait la réponse suivante: c’est la déléguée aux questions éditoriales, Mme Paoli, qui aurait pris la décision de couper parce que « l'un des invités aurait tenu des propos inacceptables », sans que soient précisés lesquels. Quelle que soit la version véritable, on doit remarquer la promptitude des réactions de tous. Mme Paoli, ou un membre du CSA à l’écoute de mon émission, n’a pas hésité à déranger Lesquen, qui présidait à ce moment une réunion. Le journaliste du Parisien a été encore plus réactif. Avant le bouclage, il a eu le temps de s’étonner, d’appeler, d’écrire et de caser son papier. C’est certainement un bon professionnel. Quoi qu’il en soit, vendredi 11 avril, j’ai reçu une lettre recommandée de Lesquen m’annonçant que mon "Libre Journal" était supprimé. L’après-midi, il me téléphonait pour s’expliquer, non pas tant sur les faits que sur la raison de la censure.

B : Elle est limpide : Robert Faurisson nie l’existence de chambres à gaz homicides dans l’Europe occupée par Hitler. Or c’est interdit par la loi Gayssot et il a été condamné plusieurs fois pour cela. Votre invitation était donc une provocation suicidaire.

MP : Non. J'avais formellement interdit à Faurisson d'aborder la chose. Nous étions convenus de nous cantonner à quatre thèmes. D’abord, la persécution des révisionnistes, judiciaire, disciplinaire et autre. Ensuite, la critique des lois restreignant la liberté de recherche, à la lumière des pétitions signées ces dernières années par des historiens français réputés. Troisièmement, l’examen des faussaires profiteurs de la Shoah, dont l'actualité récente offre de bons exemples. Enfin, à la suite de Raul Hilberg, principal historien de l’Holocauste, nous devions relever les progrès que l’hérésie révisionniste fait faire à l’histoire officielle.

B : Ces sujets, quoique un peu « borderline », peuvent en effet être abordés, mais pourquoi avec Faurisson ? Sa personne est elle-même devenue symbole de provocation.

MP : La question est de savoir si Robert Faurisson est un homme ou une bête. « Si c'est un homme », comme dirait Primo Levi, il a des droits. Certes, c’est un multirécidiviste, un repris de justice, mais il a payé ses dettes à la société ; il a donc droit de vivre et de s’exprimer comme tout autre, pourvu qu’il n’enfreigne pas la loi. Une comparaison va vous éclairer. La campagne pour la dépénalisation de l'avortement a culminé avec le « Manifeste des salopes » : des femmes en vue y revendiquaient leur crime pour obtenir l’abrogation de la loi qui le réprimait. Or, loin de les condamner, on les loue. Et l’on bâillonnerait Faurisson, même s'il s'engage à respecter la loi Gayssot ? Quel cœur normal, quel esprit droit, tolérerait ce « deux poids deux mesures » ?

B : Bien sûr, mais demeurer au niveau des principes peut être parfois enfantin. Lesquen est responsable de Radio Courtoisie, de sa survie. Vous auriez dû lui soumettre la liste de vos invités.

MP : Non. Lorsqu’il m'a demandé de venir à Radio Courtoisie, il m’a détaillé verbalement un cahier des charges contraignant, mais il m’a laissé libre de mes invités et de mes sujets. Ce qu’il me reproche est une erreur d’appréciation. Pour lui, Faurisson étant ce qu'il est et la jurisprudence en matière de révisionnisme ce que nous savons, aborder le sujet comme je l’ai fait était impossible. Il en voit une preuve surabondante dans le fait suivant : les invités de l’émission de Coûteaux, ayant appris que le professeur diabolique était passé avant eux dans le studio, se sont défilés et leur émission a dû être reportée. Ils « avaient des bouches à nourrir ».

B : Vous voyez, l’interdit porte sur Faurisson.

MP : Pas tout à fait. Henry fait une analyse plus subtile. Depuis trente ans que Robert Faurisson mène ses recherches révisionnistes, il a été l'objet de tant d'attaques qu'il se compare, d'une certaine manière, à Galilée. De toutes ses paroles sourdent, même quand il se domine, une révolte indomptable et la certitude d’avoir raison. Pendant ses vingt-cinq minutes d’antenne, il n’a tenu aucun propos révisionniste passible de la loi Gayssot mais, à plusieurs reprises, il a laissé entendre que, s'il pouvait parler, on verrait ce qu’on verrait... UN ESPRIT TORDU POURRAIT POURSUIVRE EN CONTESTATION DE CRIME CONTRE L'HUMANITÉ EN S'APPUYANT SUR LA SEULE CONVICTION IMPLICITE DU PRÉVENU ! Henry ne veut courir aucun risque et il a coupé. Si une telle procédure était menée, elle pourrait entraîner des dépenses de justice insupportables pour Radio Courtoisie, une réputation qui ferait fuir une part de ses invités et de ses auditeurs, et peut-être, à terme, supprimer l’autorisation d’émettre. Un chef responsable doit prendre sa décision en quelques secondes. Lesquen est d’une famille de marins. Il a préféré sacrifier une chaloupe en perdition pour préserver sa frégate.

B : Ainsi, vous approuvez ses décisions ?

MP : N'exagérons rien, mais je les comprends, surtout celle qu'il a prise à chaud. La suppression de mon « Libre Journal » me paraît, elle, inutile et risque de dégoûter une partie des auditeurs. Quant à moi, je la regrette un peu, car nous avions retrouvé, avec quelques amis de la presse nationale, un ton et une ambiance qui rappelaient de bonnes heures et qui pouvaient contribuer à maintenir l'unité de notre camp dans les passes difficiles que nous traversons. Mais, d’un autre côté, c’est un poids en moins : moins de travail et moins de dépenses, car vous savez que l’on n’est ni payé ni défrayé à Radio Courtoisie, et, n’habitant pas Paris, cela me faisait des frais chaque mois. Le journalisme à compte d’auteur, je ne sais pas si c'est encore de mon âge.

B : Et l’émission avec Faurisson, comment la jugez-vous?

MP : Un peu courte, on en était au tour de chauffe, on n’a pas abordé les points les plus intéressants. Mais enfin ça a le mérite d’exister. Et les plus courtes sont parfois les meilleures. Nous avons fait la démonstration qu’un tabou interdit toute expression libre en France. Et qu’il impose l’autocensure aux plus intelligents et aux plus courageux ; car je ne tiens nullement Radio Courtoisie pour un ramassis de moules. Nous rappelons ainsi, de la manière la plus explicite, que notre pays est aujourd’hui un territoire occupé. Il est très difficile d'y survivre, entre censure et autocensure. C’est pourquoi je comprends si bien la position de Lesquen. Il y a deux armes pour servir l’information en France : l’épée et le bouclier.

J’ai choisi l'épée, Lesquen le bouclier.

B : Vous reprenez les mots du colonel Rémy, quand il pensait que De Gaulle et Pétain s’étaient partagé les rôles sous l’Occupation.

MP : Sauf qu’à la différence de De Gaulle, je ne souhaite pas diviser le camp des Français attachés à leur patrie. Je n’aimerais pas que certains se détachent de Radio Courtoisie à cause de je ne sais quelle tiédeur supposée. La comparaison avec l’Occupation me paraît fructueuse. Radio Courtoisie est une radio aussi libre que l’était la zone du même nom : libre, mais sous la menace permanente de l’occupant. C’est une radio « nono », non occupée, ce n’est déjà pas si mal. Le Maréchal ménage ce qui doit l’être pour sauver ce qui peut l’être.

B : Alors, pas de regrets?

MP : Vous êtes devant un équilibriste qui vient de se casser la figure. Je regrette d’être tombé. Ma femme m’a dit : « Tu t’es cru plus malin que tout le monde et maintenant, tu te retrouves dans la m..., comme d’habitude. » Mais je préfère conclure autrement. C’est avec le temps qu’apparaissent les dernières conséquences et la portée finale d’un acte. Peut-être un jour Radio Courtoisie s’honorera-t-elle d'être la station qui a laissé parler Faurisson vingt-cinq minutes. Et il ne s’agit pas seulement de défendre l’honneur de la presse et des Français, il s’agit de ménager l’avenir. Je n’en veux pas à Lesquen de son réalisme, je m’occupe de réalités plus hautes. En refusant que l’on piétine le droit, la vérité, la liberté, la justice, je préserve les chances d’une jeunesse qui souffre sous le joug, et qui trouvera demain, n’en doutons pas, les moyens efficaces de la victoire.

Propos recueillis par Memona Pfennigstein.

## 7) Un message de R. Faurisson, le 19 avril

Henry de Lesquen, directeur de Radio Courtoisie, a, vous le savez, ordonné l’arrêt immédiat d’une interview que j’étais en train de donner au journaliste Martin Peltier. Puis, il a envoyé une lettre recommandée à ce journaliste pour lui signifier son renvoi. J’ajoute que des personnes qui devaient participer le même soir à une autre émission ont refusé de s’exprimer « après Faurisson », dont ils avaient ignoré la venue.

Radio Courtoisie est une modeste station. Elle est proche à la fois de Jean-Marie Le Pen et des catholiques intégristes ; elle se définit comme la « radio de toutes les droites ». Elle est surveillée par le Conseil supérieur de l’audiovisuel (CSA), qui fonctionne comme une sorte de commission gouvernementale de la censure. Le CSA se vante de ne rien interdire à l’avance (c’est encore heureux !) mais, à tout moment, il peut, après l’audition d’une émission qui lui déplaît, retirer à une station le droit de continuer d’émettre.

En 34 ans, les grands médias français ne m’ont jamais donné la parole.

Aucune de nos chaînes de télévision ne m’a proposé de m’expliquer.

Aucune radio non plus sauf une fois. Le 17 décembre 1980, Ivan Levaï m’a fait venir dans son studio d’Europe n°1. Mais son invitation était due à la peur de poursuites judiciaires parce que, peu auparavant, il avait laissé dire à l’antenne par son coreligionnaire Jean Pierre-Bloch que Faurisson était payé par Khadafi. Mon ami Pierre Guillaume avait alors prévenu Ivan Levaï que je risquais de le poursuivre en justice s’il ne me permettait pas de m’exprimer à mon tour sur Europe n° 1.

Quant aux rares textes que je suis parvenu à faire paraître dans les grands journaux, en particulier dans Le Monde du 29 décembre 1978 et du 16 janvier 1979, je ne dois leur parution qu’au jeu de ce que la loi française appelle « le droit de réponse ».

Bilan à ce jour : pendant 34 années consécutives, un professeur est dénoncé par l’unanimité des grands médias de France comme l’auteur d’un crime inouï, bouleversant, incompréhensible (pour Le Monde, il est un « gangster de l’histoire ») et pas une fois on ne lui offre de s’expliquer (sinon une fois à la radio pour la raison que je viens de dire). Faut-il que soient remarquables en France à la fois le pouvoir du lobby juif et la crainte qu’il inspire !

## 8) Martin Peltier, à nouveau, le 29 avril

### Jeanne d’Arc et Iéna. Quel réalisme pour aujourd’hui ?

Il y a quinze jours, j’invitais le professeur Faurisson sur Radio Courtoisie. Je fus censuré en direct et viré. Un ami (vrai) a soupiré :

― « Quand tu vois un mur, il faut décidément que tu fonces dedans ! »

Je lui ai raconté que, ma tête ayant rencontré par inadvertance, naguère, une cheminée de pierre, celle-ci avait cassé. Il a répondu :

― « Ça n’arrive pas tous les jours. »

Je le sentais retenir, par amitié, les innombrables reproches qu’appelait mon cas : entêtement, aveuglement, irresponsabilité n’étaient que les plus criantes de mes sottises. Je suis un peu responsable de cette façon de voir : quand on m'a coupé l’antenne, je suis parti avec le sourire, pour ne pas diviser ma famille politique. Ce silence a été mal interprété. On y a vu la gentillesse d’un benêt ou la résignation d’un honteux. C’est une erreur. J’ai ravalé ma colère mais ce n’était pas l’aveu d’une faute. Au contraire, je suis convaincu que ce fut une bonne chose d’inviter Faurisson, et je vais le montrer.

Appliquons d’abord à aujourd’hui une citation célèbre : « Lorsqu’ils sont venus chercher Faurisson, je n’ai pas bougé… » Les excès de la prudence ne nous soustrairont pas à la vindicte du totalitarisme et nous soumettront un jour aux reproches de notre conscience. Ce rappel moral fait, ne nous préoccupons plus que de politique, concrète et réaliste : l’invitation de Faurisson entre dans la meilleure stratégie possible aujourd’hui.

On a parlé de mur, parlons donc de murs, puisqu’il y a des murs et qu’il faut bien en faire quelque chose.

Prenons un premier cas : le mur de l’Atlantique. Si vous disposez des forces conjointes de l’Amérique et de l’Angleterre, vous débarquez le 6 juin 1944 et l’on n’en parle plus.

Examinons maintenant les murs de Jéricho. Chacun fera la lecture qui lui convient de la Bible, mais ce qu’elle dit, dans tous les cas, c’est que Jéricho est tombée et qu’elle est tombée d’une manière inhabituelle, alors que le rapport de forces apparent ne le laissait pas prévoir. Il est tout aussi clair que la ville serait restée intacte derrière ses remparts si Josué, découragé, s’était arrêté au quatrième ou au cinquième tour. Ce n’est qu’au sixième tour que les murailles se sont effondrées devant les trompettes sacrées. Quels enseignements en tirer ? Ceux-ci : lorsque, à vue humaine, le rapport des forces ne permet pas de solution satisfaisante, il convient d’utiliser des moyens qui sortent de l’ordinaire, et de persister avec détermination dans cette voie, quelle qu’en soit l’apparente absurdité.

Revenons à nos moutons, à Radio Courtoisie.

On me dit : la loi, la jurisprudence, les associations, les lobbies, la manipulation des esprits, les médias, la veulerie et les intérêts des hommes politiques font que parler de certaines choses ne sert à rien et met en danger le peu d’espace d’information qui nous reste. Il ne faut donc pas, pour une cause secondaire, d’ailleurs jugée d’avance, sacrifier l’une des rares armes qui nous permettent de défendre d’autres causes. Aussi limités que soient les moyens de Courtoisie, elle est utile à la France. Il faut donc la conserver à tout prix. Sacrifier des dizaines de journalistes bénévoles, souvent talentueux et courageux, leurs invités, non moins courageux, le réseau d’amis et d’informateurs tissé dans les médias, l’édition, toutes les branches de la société, et même parmi les hommes politiques, sacrifier des dizaines de milliers d’auditeurs, sacrifier tout cela sur l’autel du révisionnisme, n’aurait pas de sens.

J’entends ce message, et je ne puis m’empêcher d’en sourire. C’est vrai, il se trouve à Radio Courtoisie de vrais talents et de vrais caractères. Mais, puisque l’on parle politique, responsabilité, stratégie et rapport de forces, qu’y a-t-il derrière Courtoisie ? Jean Tibéri ? Marine et Louis Aliot ? Dupont Aignan, Catherine Mégret, les frères et sœurs de Philippe de Villiers ? Qui d’autre ? Qu’est-ce que cela pèse ? Combien de divisions ? Avons-nous de quoi monter une opération Overlord ? Non. En américain, on dirait que c’est peanuts. Même pas un bretzel liquide.

Alors, il ne reste de réaliste que la solution Jéricho. Nous ne comptons que par l’esprit, et seule une stratégie de l’esprit peut être efficace.

Il faut comprendre cela. Les notions mêmes de réalisme et de responsabilité dépendent de la situation historique où l’on se trouve. Peut-être, quand le Front national rassemblait entre 15 et 20 pour cent des électeurs, qu’il était bien encadré et qu’il y avait sur sa gauche une grosse réserve de voix et d’alliés potentiels, avant, d’ailleurs, que les prétoires et les médias ne soient complètement colonisés, avant qu’il faille plus des deux mains pour compter les millions d’immigrés, peut-être pouvait-on entretenir l’espoir, ou l’illusion, d’une politique classique des rapports de forces. Ce n’est plus qu’un rêve aujourd’hui, et s’y accrocher serait un signe de débilité mentale. La seule politique réaliste est de tenter une révolution spirituelle.

Retournons-nous vers l’histoire pour établir encore mieux cette évidence.

Que faire, quand on est vaincu par l’envahisseur, pour survivre et préparer la revanche ? Il y a, ce me semble, deux cas de figure radicalement différents.

― Le roi de Prusse après Iéna put collaborer avec Napoléon, le maréchal Pétain put finasser avec Hitler, parce que l’un et l’autre espéraient raisonnablement qu’en fin de compte leur vainqueur provisoire serait soumis à des forces supérieures aux siennes. L’Angleterre avide d’hégémonie saurait rallier à elle une Russie et une Autriche que la Révolution française révulsait. Le monde juif, que la révolution allemande épouvantait, saurait maintenir ensemble les ploutocraties anglo-saxonnes et la tyrannie soviétique, il suffisait de garder la Manche quelques mois. Dans le cas du Maréchal et du roi de Prusse, une politique de ménagement, une collaboration plus ou moins active se comprend donc, en attendant, en préparant le retournement de marée.

― Mais prenons maintenant le cas de Jeanne d’Arc. Là, si on regarde le rapport des forces, l’affaire est entendue. Il ne reste au dauphin Charles qu’un mouchoir de poche et quelques villes pas très fortes, avec des troupes médiocres, lasses et mal payées. La puissante Bourgogne, l’Angleterre, l’université de Paris, et la légalité du traité de Troyes sont contre lui. A terme, il n’a strictement rien à espérer, c’est plié. Et c’est pourquoi la stratégie de Jeanne d’Arc est nette et sans bavure : à la vérité, il n’y en a pas d’autre possible. Elle n’a pour elle, elle n’a pour Charles VII, que leur double légitimité : celle que la coutume du royaume donne au dauphin et celle dont Dieu a marqué sa mission de pucelle. Ce sont les seules forces qui puissent contrebalancer les puissances du monde, qui puissent inverser le rapport des forces. Si cette double légitimité est une foutaise, alors c’est terminé, et Jeanne d’Arc, et Charles VII, et la France que nous connaissons n’ont plus qu’à disparaître. Pourtant, finalement, ce sont les Anglais et leur bastringue qui finiront par aller se rhabiller. Cela me surprend toujours, et n’en finit pas de me rassurer.

Transposons à aujourd’hui. Il ne s’agit pas de sacrifier Radio Courtoisie sur l’autel du révisionnisme : ni l’un ni l’autre ne sont ici primordiaux. Radio Courtoisie n’est qu’un pion parmi d’autres sur l’échiquier de la France libre, et il n’est même pas question de défendre les révisionnistes. Il est question de juger la situation politique et historique où se trouve la France. Sommes-nous en 1429 ou en 1940 ? La réponse est facile. Nous n’avons aucune des immenses réserves qui justifiaient l’Appel du dix-huit juin et la politique de Vichy. Nous sommes même sensiblement plus atteints que ne l’étaient le roi de Bourges et ses sujets. Notre identité et notre souveraineté prennent l’eau. Nous n’avons donc d’autre stratégie possible que celle de Jeanne d’Arc. Le rapport de forces entre nous et d’éventuels alliés d’une part, l’occupant de l’autre, est du zéro à l’infini. Tout ménagement, tout calcul, toute alliance, toute collaboration, tout échafaudage tactique sont donc hors de portée, hors de propos, ils appartiennent à un monde plus virtuel que celui des jeux vidéos. Notre seul espoir est spirituel, notre seule force est la légitimité de notre cause.

Or, de quoi s’agit-il, avec Faurisson ? De chambres à gaz ? Pas du tout. Il s’agit qu’en ne dénonçant pas la façon dont le système le traite, nous acceptons d’être les esclaves de ce système, et ses complices. Nous bafouons avec lui le droit, la liberté, la vérité, la justice. Et nous nous prosternons devant le socle sur lequel se dresse l’idole dominatrice qui nous dévore. Nous piétinons donc notre propre cause, nous renonçons à notre légitimité, nous réduisons à rien notre force, nous brisons à jamais l’épée spirituelle, l’espoir que nous portons. A persister dans cette erreur, non seulement nous nous déshonorerions mais nous nous suiciderions par-dessus le marché.

Alors, je ne dis pas que donner de la tête dans le mur soit une stratégie bien agréable, ni bien délurée ; je ne sais pas du tout ce qu’elle va produire, je constate seulement qu’il n’y en a pas d’autre. Je ne me fais pas d’illusions. Sans doute joins-je l’inutile au désagréable et ne suis-je qu’un tout petit crachat dans l’océan, une goutte dérisoire. N’importe, je fais ce que je dois. J’espère que le Ciel nous aidera, faute de quoi nous passerions aux poubelles de l’histoire, comme c’est tranquillement programmé. Du moins aurons-nous fait ce qu’il fallait et gardé intacte la possibilité d’une victoire. A l’inverse, la soumission et la finasserie, qui paraissent subtiles et responsables, ne sont aujourd’hui que des illusions mortelles, en raison du moment historique où nous nous situons. La stratégie du sacrifice est la seule raisonnable.

## 9) Emmanuel Ratier, le 1er mai

Dans la livraison de *Faits & Documents* qui a suivi (1er au 31 mai 2008, p. 9), E. Ratier a passé sous silence aussi bien la censure de R. Faurisson que le limogeage de M. Peltier, patron d’émission, mais, en revanche, parlant de lui-même à la troisième personne, il a annoncé la nouvelle suivante : « Directeur de *Faits & Documents,* Emmanuel Ratier a été nommé patron d’émission à Radio Courtoisie (95,6Mhz en région parisienne), "la radio libre du pays réel et de la francophonie" à laquelle il collaborait depuis une dizaine d’années dans le cadre du *Libre Journal de Claude Giraud* et dont il était devenu le suppléant depuis l’année dernière. Il animera désormais, un mercredi sur quatre, durant trois heures, *Le Libre Journal de la résistance française* […] ».

Les mots sonnent haut et fort : « courtoisie », « radio libre », « libre journal » (2 fois) et, enfin, « résistance ». Mais la réalité a été la suivante : censure, discourtoisie, limogeage et des comportements qui ont été à l’opposé du souci de la liberté et de la volonté de résistance à l’oppression. Pour couronner le tout, un petit camarade, Emmanuel Ratier, se fait nommer à la place de son collègue, Martin Peltier, dont il s’était, dès la nuit de l’incident, aussitôt désolidarisé, avec quelques autres, auprès du directeur de la station.

## 10) Conclusion : la preuve de l’existence d’un tabou et non d’un simple interdit.

La loi Fabius-Gayssot prononce un interdit et cet interdit, elle le formule. Un tabou, lui, ne se formule pas. Il n’en a que plus de force. La peur qu’il inspire est de caractère sacré. Le tabou crée un lien social à base de sous-entendus dans le langage et le comportement des individus d’un même groupe. Dans le microcosme de Radio Courtoisie il est des noms qu’on ne prononcera plus et des sujets qu’on proscrira sans qu’il soit besoin de dire lesquels. Quant à celui qui a enfreint le tabou, il a été mis au ban de la petite société qui l’employait, et ce dans la discrétion. Aucun détail, aucune précision n’ont été ni ne seront fournis aux auditeurs de Radio Courtoisie ou aux lecteurs de *Faits & Documents*. Dans ladite société qui, pendant un instant, s’est sentie en danger, la vie va donc reprendre son cours. Comme par le passé, on se targuera d’être indépendant, libre, courageux mais – c’est le grand mot, le mot magique – on se proclamera désormais plus que jamais « RESPONSABLE ». On le sera à la différence d’autres qui, eux, se sont montrés « IRRESPONSABLES » et dont on ne rappellera ni les noms ni les crimes. On criera victoire tout en cachant de quel prix on a payé cette victoire. Le seul authentique tabou du monde occidental, celui de « l’Holocauste », aura été ainsi respecté. Dans le monde environnant, la religion triomphante de « l’Holocauste » continuera d’être célébrée à grand fracas et le tabou qui la fonde restera puissant. Seuls des « irresponsables » continueront d’ouvrir par effraction la porte d’un tabernacle qui, censé contenir le fin mot des mystères holocaustiques, ne renferme en réalité que du vide et du vent. Au moins la petite histoire vécue par une modeste station de radio parisienne a-t-elle ainsi apporté sa contribution à la grande histoire de la plus mirifique imposture des temps modernes. Grâce à l’incident de Radio Courtoisie et à ses suites, un profane pourra comprendre ce qu’est un véritable tabou et comment un mythe gigantesque, celui de « l’Holocauste », qui s’est construit sur la peur ne peut se survivre que par la peur.

## Complément (1er juillet)

Pour la première fois de ma vie, je reçois aujourd’hui un courrier de « Radio Courtoisie, la radio libre du pays réel et de la francophonie ». Il s’agit d’une lettre circulaire de quatre pages adressée aux « amis » de cette station par « Henry de Lesquen, président de Radio Courtoisie ». La date en est du 3 juin mais le cachet porte celle du 24 juin. Il s’agit d’un appel de fonds. J’en extraie les passages suivants :

La famille des auditeurs de Radio Courtoisie est une élite à qui la France doit beaucoup. – Vous savez que Radio Courtoisie n’a pas d’équivalent en France. Vous savez quel est le rôle crucial qui est le sien pour sortir les Français de la confusion des esprits et pour leur faire découvrir les vraies valeurs. Ce rôle, elle est seule à le tenir, non seulement parmi toutes les autres radios, mais même parmi tous les autres moyens de communication audiovisuelle. Il suffit d’imaginer un seul instant que Radio Courtoisie n’existe plus pour mesurer la perte irréparable que ce serait pour notre pays. C’est bien pourquoi elle est portée par la ferveur de ses auditeurs. – « Oui. Il y a MIRACLE, écrivait autrefois Jean Cau à Jean Ferré : sans Radio Courtoisie, une lumière, la plus vive qui brille dans notre temps, s’éteindrait. Mais oui, Radio Courtoisie nous a aidés à marcher sur des chemins droits, à ne pas tâtonner, à recueillir les bons grains de la vérité et à jeter les ivraies du mensonge. – Où il y a miracle, c’est ici : le pluralisme d’expression s’exerce à Radio Courtoisie sur un tel ton de liberté, de politesse (et de courtoisie !) que l’on s’en frotte les oreilles d’étonnement ravi. Quoi ! Il existe encore, de nos jours, des exemplaires de l’Honnête Homme ? Et qui ne se pique de rien sauf de dire sinon sa vérité, du moins ce qu’il croit, en connaissance et bonne foi. Bref, à Radio Courtoisie, on entend des … VOIX ! » […] Radio Courtoisie est une oasis de santé morale dans un désert de désinformation et d’intoxication intellectuelle.

9 avril ― 1er mai 2008

Labels: Emmanuel Ratier, Henry de Lesquen, Interviews, Le Parisien, Martin Peltier, Plantin, Radio Courtoisie, Toben
