<!-- http://robertfaurisson.blogspot.com/1998/12/introduction-aux-ecrits-revisionnistes.html -->

<!-- Thursday, December 3, 1998 -->

Introduction aux "Écrits Révisionnistes (1974-1998)"

In memoriam

La coutume voudrait qu'en tête de ces Écrits révisionnistes je remercie tous ceux, sans distinction, qui me sont venus en aide dans mes recherches ou dans la réalisation de l'ouvrage.

A l'encontre de cette coutume, je m'abstiendrai de nommer ici les vivants et je ne nommerai que les morts.

En un temps où désigner un révisionniste par son nom c'est en quelque sorte le dénoncer à la police de la pensée ou à la meute des médias et l'exposer ainsi au risque de la perquisition, de la saisie, du chômage, de l'amende ou de la prison, on comprendra que je ne puis, en conscience, dédier le présent ouvrage à aucun de ceux ni à aucune de celles qui mériteraient que je leur exprime publiquement, de leur vivant, ma gratitude ou mon admiration.

De la cohorte des morts que marque le sceau du révisionnisme je ne retiendrai ici que quelques noms sous l'invocation desquels j'ai, pendant un quart de siècle, vécu l'aventure du révisionnisme historique et auxquels je voudrais dire ma reconnaissance posthume : Jean Norton Cru (pour la première guerre mondiale), Paul Rassinier, Maurice Bardèche, Louis-Ferdinand Céline, Albert Paraz, Jean Genet et François Duprat. À ces noms j'ajouterai ceux, pour la France, de Jean Beaufret et de Michel de Boüard ; pour l'Autriche, de Franz Scheidl ; pour l'Allemagne, de Hellmut Diwald et, pour les États-Unis, de James Morgan Read, le premier historien au monde qui se soit interrogé sur la réalité des prétendues chambres à gaz nazies, et cela dès le mois de mai 1945, en même temps d'ailleurs ― pure rencontre de grands esprits ― que l'Anglais George Orwell.

Je dédie aussi ces pages à l'Allemand Reinhold Elstner qui, à Munich le 25 avril 1995, s'est immolé par le feu en signe de pro­testation contre « le Niagara de mensonges » déversé sur son peuple ; la police allemande a, sur ordre, confisqué les bouquets déposés à l'endroit du sacrifice et procédé à l'inter­pellation de ceux qui, par ce geste de compassion, témoignaient de leur propre souffrance.

Au risque d'être mal compris par certains, je dédie également cet ouvrage à ceux, parmi les vainqueurs ensanglantés de la seconde guerre mondiale, qui, tels Churchill, Eisenhower ou de Gaulle, se sont refusés, aussi bien pendant la bataille qu'après la bataille, à cautionner, ne fût-ce que d'un mot, l'atroce, la grotesque, l'insolente imposture du prétendu génocide des juifs et des prétendues chambres à gaz nazies.

Je souhaite enfin que le présent ouvrage puisse s'inscrire sous le signe d'une mémoire, non pas sélective et tribale, mais universelle, sans exclusive aucune : in memoriam omnium. Puisse-t-il aussi se lire comme un hommage aux vraies souffrances de toutes les victimes de la guerre de 1939-1945, que ces victimes aient appartenu au camp des vainqueurs qu'on encense ou à celui des vaincus qu'on ne cesse, depuis près d'un demi-siècle, d'humilier et d'offenser !

------------------------------------------------------------------------

* N'en déplaise aux mânes de Jean-Paul Sartre, Jean Genet ne croyait pas au génocide des juifs ; il y voyait même une imposture. Pour lui, « le peuple juif […] a fait croire au génocide » et l'État d'Israël a le comportement d'un « dément parmi les nations » (Quatre heures à Chatila ; les passages censurés par la Revue d'études palestiniennes se retrouvent dans L'Ennemi déclaré, Paris, Gallimard, 1991, p. 408, n. 30).

***

Introduction aux

ÉCRITS RÉVISIONNISTES (1974-1998)

Ce n'est pas un révisionniste qui l'affirme mais un antirévi­sionniste :

« Négateur de l'Holocauste », « révisionniste », « néga­tionniste », tout le monde sait ce que signifient de tels reproches. L'exclusion de l'humanité civilisée. Quelqu'un qui est en proie à de tels soupçons est anéanti. Sa vie civique est détruite, sa réputation scientifique ruinée.

Et d'ajouter :

Il faudra débattre de l'état de l'opinion publique dans un pays où il suffit de brandir l'accusation redoutable du négationnisme d'Auschwitz pour détruire moralement, en l'espace d'une seconde, un savant renommé [1].

Contre la loi

Le présent ouvrage ne peut être diffusé. Son édition est privée et hors-commerce. Son contenu enfreint la loi.

En France, il est interdit de contester la Shoah.

En application d'une loi du 13 juillet 1990 « sur la liberté de la presse », la Shoah, en ses trois hypostases ― le prétendu génocide des juifs, les prétendues chambres à gaz nazies et les prétendus six millions de victimes juives de la seconde guerre mondiale ― est devenue incon­testable sous peine d'un emprisonnement de un mois à un an, d'une amende de 2 000 francs à 300 000 francs [300 euros à 45 000 euros], du versement de dommages-intérêts dont le montant peut être considérable et sous peine d'autres sanctions encore. Plus précisément, cette loi interdit de contester l'existence d'un ou plusieurs « crimes contre l'humanité » tels que définis en 1945 et punis en 1946 par les juges du Tribunal militaire international de Nu­remberg, tribunal institué exclusivement par des vainqueurs pour juger exclusivement un vaincu.

Certes, débats et controverses sur la Shoah ― qu'on appelle aussi l' « Holocauste » ― restent autorisés mais dans le cadre tracé par le dogme officiel. Controverses ou débats qui conduiraient à remettre en cause tout ou partie de la Shoah ou simplement à la révoquer en doute sont interdits. Répétons-le : en la matière, même le doute est proscrit, et puni.

L'idée d'une telle loi, d'inspiration israélienne [2], avait été formu­lée, en France, pour la première fois en 1986 par un certain nombre d'historiens d'origine juive dont Pierre Vidal-Naquet, Georges Wellers et François Bédarida, réunis autour du grand rabbin René-Samuel Si­rat [3]. La loi fut votée en 1990 grâce aux initiatives de Laurent Fabius, président de l'Assemblée nationale et lui-même juif de combat. A la même époque, une violation de sépultures dans le cimetière juif de Carpentras donna lieu à une exploitation médiatique qui paralysa, chez les députés et les sénateurs de l'opposition, toute velléité de résistance effective au vote de cette loi. Dans Paris, drapeaux israéliens au vent, environ 200 000 manifestants protestèrent contre « la résurgence de la bête immonde ». Le bourdon de Notre-Dame fit entendre sa voix comme pour un événement particulièrement tragique ou significatif de l'histoire de France. La loi une fois publiée au Journal officiel de la République française (avec nomination, le même jour, de P. Vidal-Naquet dans l'ordre de la Légion d'honneur), le scandale de Carpentras ne fut plus évoqué que de loin en loin, pour mémoire. Ne resta alors que la loi « Fabius-Gayssot ».

Sous la pression d'organisations juives nationales et internatio­nales, d'autres pays adoptèrent à leur tour, sur les modèles israélien et français, des lois interdisant toute contestation de la Shoah. Ce fut le cas pour l'Allemagne, l'Autriche, la Belgique, la Suisse, l'Espagne et la Lituanie. D'autres pays, encore, du monde occidental ont promis aux organisations juives d'en faire autant, en particulier la Grande-Bretagne et le Canada. Mais, en réalité, une telle loi, de caractère spécifique, n'est pas indispensable pour la chasse au révisionnisme historique. En France, comme en d'autres pays, l'usage a été, et parfois reste, de poursuivre les contestataires de la Shoah en application d'autres lois, par exemple celles réprimant, selon le cas, le racisme ou l'antisémitisme, la diffamation de personnes vivantes, l'outrage à la mémoire des morts, l'apologie de crime, la propagation de fausses nouvelles et ― source d'indemnités pécuniaires pour les plaignants ― le dommage à autrui.

En France, policiers et juges assurent avec rigueur la protection ainsi accordée à une version officielle de l'histoire de la seconde guerre mondiale. Selon cette version rabbinique, l'événement majeur du con­flit aurait été la Shoah, autrement dit une extermination physique ou une tentative d'extermination physique des juifs que les Allemands auraient perpétrée de 1941-1942 à 1944-1945 (ne disposant d'aucun document ― et pour cause, puisqu'il s'agit d'une fiction ― les historiens officiels ne proposent que des dates aussi divergentes qu'approxi­matives).

Caractère particulier du présent ouvrage :

une chronique révisionniste

De 1974 à ce jour, il m'a fallu mener tant de combats judiciaires que je n'ai pu trouver le loisir de rédiger l'exposé démonstratif qu'on était en droit d'attendre d'un universitaire qui, pendant de longues années, aura consacré ses recherches à un point et un seul de l'histoire de la seconde guerre mondiale : l' « Holocauste » ou la Shoah.

Année après année, une avalanche de procès, aux conséquences les plus graves, est venue contrarier tous mes projets de publication d'un tel ouvrage. En plus de mes propres procès, il m'a fallu consacrer une large part de mon temps à la défense, devant leurs tribunaux respectifs, de révisionnistes français et étrangers. Encore aujourd'hui, à l'heure où je rédige cette introduction, deux procès m'attendent person­nellement (l'un aux Pays-Bas et l'autre en France) cependant qu'il me faut intervenir de manière directe ou indirecte dans les procès de révisionnistes qui vivent respectivement en Suisse, au Canada et en Australie. Faute de temps, j'ai dû refuser mon aide à d'autres révision­nistes, notamment à deux révisionnistes japonais.

Dans le monde entier, la tactique de nos adversaires est la même : en appeler aux tribunaux afin de paralyser les travaux de recherche des révisionnistes à défaut d'obtenir la condamnation de ces derniers soit à la prison, soit au versement d'amendes ou de dommages-intérêts. Pour le condamné, la prison entraînera l'arrêt de toute activité révisionniste tandis que le versement d'amendes ou de dommages-intérêts signifiera pour lui la recherche fébrile de l'argent, une recherche stimulée par les menaces de l'huissier, les « saisies-assignations », les « avis à tiers dé­tenteurs » et le blocage du compte bancaire. De ce simple point de vue, ma vie, pendant ce dernier quart de siècle, aura été difficile ; elle le reste et, selon toute vraisemblance, le restera.

Ajoutons à cela, pour aggraver la situation, que ma conception de la recherche n'a jamais été celle de l'universitaire ou de l'historien « de papier ». J'estime indispensable de me porter sur le terrain : soit le terrain de l'investigation matérielle, soit le terrain où se déploie l'adversaire. Je ne saurais parler de Dachau, de Majdanek, d'Auschwitz ou de Treblinka sans me rendre sur place afin d'y interroger les lieux et les gens. Je ne saurais entendre parler d'une action antirévisionniste (manifestation, conférence, colloque, procès) sans m'y rendre en per­sonne ou sans y déléguer un observateur que je prépare à sa mission ; ce qui ne va pas sans risque mais permet d'obtenir des renseignements à bonne source. Je suscite d'innombrables lettres ou interventions. Je me porte à tous les créneaux. Pour ne prendre qu'un exemple, je crois pouvoir dire que, si l'impressionnante conférence internationale de l' « Holocauste » organisée à Oxford en 1988 par le milliardaire Robert Maxwell (dit « Bob le menteur ») a, du propre aveu de son instigateur [4], pitoyablement échoué, c'est grâce à une opération que j'ai person­nellement menée sur place avec l'aide d'une révisionniste française qui ne manquait ni de courage, ni d'audace, ni d'ingéniosité : son action, à elle seule, aura certainement valu mieux que plusieurs livres. Mais les confectionneurs de livres à tout va comprendront-ils ce que je dis là ?

Aux jours et aux heures ainsi passés à la préparation des procès ou à ces multiples actions ponctuelles, on ajoutera les heures et les jours perdus dans les hôpitaux à se remettre soit des effets d'un exté­nuant combat, soit des conséquences d'agressions physiques menées par des milices juives (en France, les milices armées sont strictement interdites sauf pour la communauté juive).

Enfin, il m'a fallu inspirer, diriger ou coordonner, en France ou à l'étranger, de multiples actions ou travaux de caractère révisionniste, soutenir les énergies chancelantes, assurer une relève, répondre aux appels, mettre en garde contre les provocations, les erreurs, les dérives, et surtout lutter contre les complaisances car, chez certains révision­nistes, grande est la tentation, en un pareil combat, de rechercher un compromis avec l'adversaire et, parfois même, de se rétracter. Il ne manque malheureusement pas d'exemples où des révisionnistes sont, de guerre lasse, tombés dans la repentance publique. Je ne leur jette pas la pierre. Je sais d'expérience que le découragement guette chacun d'entre nous parce que le combat est inégal : nos moyens sont déri­soires et ceux de nos adversaires, immenses.

Nécessité faisant loi, le présent ouvrage se réduit donc à un choix de notes, d'articles, d'essais, de préfaces, d'interviews, de recensions que j'ai rédigés de 1974 à 1998 et qui sont ici présentés dans l'ordre chro­nologique de leur composition ou de leur publication. Le lecteur en tirera peut-être l'impression d'un ensemble disparate, entaché de bien des redites. Je sollicite son indulgence. Au moins cette diversité même lui permettra-t-elle de suivre au jour le jour l'aventure révisionniste dans ses vicissitudes. Quant aux redites, il arrive que je m'en console en songeant que, somme toute, je ne me suis peut-être pas encore assez répété puisque persistent aujourd'hui tant de méprises sur l'exacte nature du révisionnisme historique.

Le révisionnisme historique

Le révisionnisme est une affaire de méthode et non une idéologie.

Il préconise, pour toute recherche, le retour au point de départ, l'examen suivi du réexamen, la relecture et la réécriture, l'évaluation suivie de la réévaluation, la réorientation, la révision, la refonte ; il est, en esprit, le contraire de l'idéologie. Il ne nie pas mais il vise à affirmer avec plus d'exactitude. Les révisionnistes ne sont pas des « né­gateurs » ou des « négationnistes » ; ils s'efforcent de chercher et de trouver là où, paraît-il, il n'y avait plus rien à chercher ni à trouver.

Le révisionnisme peut s'exercer en cent activités de la vie cou­rante et en cent domaines de la recherche historique, scientifique ou littéraire. Il ne remet pas forcément en cause des idées acquises mais souvent amène à les nuancer. Il cherche à démêler le vrai d'avec le faux. L'histoire est, par essence, révisionniste ; l'idéologie est son ennemie. Comme l'idéologie n'est jamais aussi forte qu'en temps de guerre ou de conflit, et comme elle fabrique alors du faux à profusion pour les nécessités de sa propagande, l'historien sera, en la circons­tance, conduit à redoubler de vigilance : passant au crible de l'examen ce qu'on a pu lui assener de « vérités », il s'apercevra sans doute que, là où une guerre a provoqué des dizaines de millions de victimes, la pre­mière des victimes aura été la vérité vérifiable : une vérité qu'il s'agira de rechercher et de rétablir.

L'histoire officielle de la seconde guerre mondiale contient un peu de vrai combiné avec beaucoup de faux.

L'histoire officielle: un peu de vrai combiné avec beaucoup de faux

Ses reculs successifs devant les avancées

du révision­nisme historique

Il est exact que l'Allemagne nationale-socialiste a créé des camps de concentration ; elle l'a fait après ― et avec ― bien d'autres pays, tous convaincus que ces camps seraient plus humains que la prison ; Hitler voyait dans ces camps ce que Napoléon III avait cru voir dans la création des colonies pénitentiaires : un progrès pour l'homme. Mais il est faux qu'elle ait jamais créé des « camps d'extermination » (expres­sion forgée par les Alliés).

Il est exact que les Allemands ont fabriqué des camions fonction­nant au gaz (Gaswagen). Mais il est faux qu'ils aient jamais fabriqué des camions à gaz homicides (si un seul de ces camions avait existé, il figurerait au Musée de l'automobile ou dans les musées de l'« Holo­causte », ne fût-ce que sous la forme d'un croquis de valeur scienti­fique).

Il est exact que les Allemands employaient le Zyklon (produit à base d'acide cyanhydrique utilisé dès 1922) pour protéger par la désin­sectisation la santé des civils, des troupes, des prisonniers ou des internés. Mais ils n'ont jamais employé le Zyklon pour tuer qui que ce fût et surtout pas des foules d'êtres humains ; en raison des précautions draconiennes d'emploi du gaz cyanhydrique, les prétendus gazages ho­micides d'Auschwitz ou d'autres camps auraient été, d'ailleurs, radicale­ment impossibles ; je m'étends longuement sur ce point dans le corps du présent ouvrage.

Il est exact que les Allemands envisageaient une « solution finale de la question juive » (Endlösung der Judenfrage). Mais cette solution était territoriale (territoriale Endlösung der Judenfrage) et non pas ho­micide ; il s'agissait de pousser ou, si nécessaire, de forcer les juifs à quitter l'Allemagne et sa sphère d'influence en Europe pour établir, en accord avec les sionistes, un foyer national juif, à Madagascar ou ailleurs. Beaucoup de sionistes ont collaboré avec l'Allemagne natio­nale-socialiste en vue de cette solution.

Il est exact que des Allemands se sont réunis, le 20 janvier 1942, dans une villa d'une banlieue de Berlin (Berlin-Wannsee) pour traiter de la question juive. Mais ils y ont envisagé l'émigration forcée ou la déportation des juifs ainsi que la création future d'une entité juive spécifique et non pas un programme d'extermination physique.

Il est exact que des camps de concentration possédaient des fours crématoires pour l'incinération des cadavres. Mais c'était pour mieux combattre les épidémies et non pour y incinérer, comme on a parfois osé le dire, des êtres vivants en plus des cadavres [5].

Il est exact que les juifs ont connu les souffrances de la guerre, de l'internement, de la déportation, des camps de rétention, des camps de concentration, des camps de travail forcé, des ghettos, des épidémies, des exécutions sommaires pour toutes sortes de raisons ; ils ont aussi souffert de représailles ou même de massacres car il n'est pas de guerre sans massacres. Mais il est également vrai que toutes ces souffrances ont été aussi le lot de bien d'autres nations ou communautés pendant la guerre et, en particulier, des Allemands et de leurs alliés (les souf­frances des ghettos mises à part, car le ghetto est d'abord et avant tout une création spécifique des juifs eux-mêmes [6]) ; il est surtout vraisem­blable, pour qui n'est pas affligé d'une mémoire hémiplégique et pour qui s'efforce de connaître les deux faces de l'histoire de la seconde guerre mondiale (la face toujours montrée et la face presque toujours cachée), que les souffrances des vaincus pendant la guerre et après la guerre ont été, en nombre et en qualité, pires que celles des juifs et des vainqueurs, surtout pour ce qui est des déportations.

Il est faux que, comme on a longtemps osé le prétendre, il ait existé un ordre quelconque de Hitler ou de l'un de ses proches d'exter­miner les juifs. Pendant la guerre, des soldats et des officiers allemands ont été condamnés par leurs propres cours martiales, et parfois fu­sillés, pour avoir tué des juifs.

Il est bon que les exterminationnistes (c'est-à-dire ceux qui croient à l'extermination des juifs) aient fini, de guerre lasse, par reconnaître qu'on ne trouve trace d'aucun plan, d'aucune instruction, d'aucun do­cument relatif à une politique d'extermination physique des juifs et que, de la même façon, ils aient enfin admis qu'on ne trouve trace d'aucun budget pour une pareille entreprise ni d'aucun organisme chargé de mener à bien une telle politique.

Il est bon que les exterminationnistes aient enfin concédé aux révisionnistes que les juges du procès de Nuremberg (1945-1946) ont accepté pour vrais des faits de pure invention comme l'histoire du sa­von fabriqué à partir de la graisse des juifs, l'histoire des abat-jour faits de peau humaine, celle des « têtes réduites », l'histoire des gazages homicides de Dachau ; et surtout il est bon que les exterminationnistes aient enfin reconnu que l'élément le plus spectaculaire, le plus terri­fiant, le plus significatif de ce procès, c'est-à-dire l'audience du 15 avril 1946 au cours de laquelle on a vu et entendu un ex-commandant du camp d'Auschwitz (Rudolf Höss) confesser publiquement que, dans son camp, on avait gazé des millions de juifs, n'était que le résultat de tortures infligées à ce dernier. Cette confession, présentée durant tant d'années et en tant d'ouvrages historiques comme la « preuve » n° 1 du génocide des juifs, est maintenant reléguée aux oubliettes, du moins par les historiens.

Il est heureux que des historiens exterminationnistes aient enfin reconnu que le fameux témoignage du SS Kurt Gerstein, élément essentiel de leur thèse, est dénué de valeur ; il est détestable que l'Uni­versité française ait retiré au révisionniste Henri Roques son titre de docteur pour l'avoir démontré en 1985.

Il est pitoyable que Raul Hilberg, le pape de l'extermina­tionnisme, ait osé écrire, en 1961, dans la première édition de The Destruction of the European Jews, qu'il avait existé deux ordres de Hitler d'exterminer les juifs, pour ensuite déclarer, à partir de 1983, que cette extermination s'était faite d'elle-même, sans aucun ordre ni plan mais par « une incroyable rencontre des esprits, une transmission de pensée consensuelle » au sein de la vaste bureaucratie allemande. R. Hilberg a ainsi remplacé l'assertion gratuite par l'explication magi­que (la télépathie).

Il est bon que les exterminationnistes aient enfin, dans la pratique, à peu près abandonné l'accusation, appuyée de « témoignages », selon laquelle il existait des chambres à gaz homicides à Ravensbrück, à Oranienburg-Sachsenhausen, à Mauthausen, à Hartheim, au Struthof-Natzweiler, au Stutthof-Danzig, à Bergen-Belsen,…

Il est bon que la chambre à gaz nazie la plus visitée du monde ― celle d'Auschwitz-I ― ait été enfin reconnue, en 1995, pour ce qu'elle était, c'est-à-dire une fabrication. Il est heureux qu'on ait enfin admis que « TOUT Y EST FAUX » et, personnellement, je me réjouis de ce qu'un historien appartenant à l'Etablissement officiel ait pu écrire : « A la fin des années 70, Robert Faurisson exploita d'autant mieux ces falsifications que les responsables du musée rechignaient alors à les re­connaître » [7]. Je m'en réjouis d'autant plus qu'au fond la justice fran­çaise m'avait, de façon inique, condamné pour l'avoir dit.

Il est bon que, dans le même article, le même historien ait révélé qu'une sommité du monde juif comme Théo Klein ne voit dans cette « chambre à gaz » qu'un « artifice ».

Il est également bon que, dans le même article, le même histo­rien ait révélé d'abord que les autorités du Musée d'Auschwitz ont conscience d'avoir trompé des millions de visiteurs (500 000 par an au début des années quatre-vingt-dix), puis qu'elles continueront néan­moins à l'avenir de tromper les visiteurs car, selon la sous-directrice du musée : « [Dire la vérité sur cette "chambre à gaz"], c'est trop compli­qué. On verra plus tard » ! [8]

Il est heureux qu'en 1996 deux historiens d'origine juive, le Canadien Robert Jan van Pelt et l'Américaine Debórah Dwork, aient, enfin, dénoncé quelques-unes des énormes supercheries du camp-musée d'Auschwitz et le cynisme avec lequel on y trompe les visiteurs [9].

Il est, en revanche, inadmissible que l'UNESCO (United Nations Educational, Scientific and Cultural Organisation) maintienne depuis 1979 son patronage à un site comme celui d'Auschwitz dont le centre recèle, avec cette fausse « chambre à gaz » (sans compter d'autres énor­mes falsifications), une imposture maintenant avérée ; l'UNESCO (dont le siège est à Paris et qui est dirigée par Federico Mayor) n'a pas le droit d'utiliser les cotisations des pays adhérents pour cautionner une vaste escroquerie aussi contraire à « l'éducation », à « la science » et à « la culture ».

Il est heureux que Jean-Claude Pressac, après avoir été porté aux nues, soit tombé dans le discrédit. Lancé par le couple Klarsfeld, ce pharmacien a cru intelligent de rechercher une position médiane entre ceux qui croient aux chambres à gaz et ceux qui n'y croient pas. Pour lui, en quelque sorte, la femme à examiner n'était ni enceinte ni non enceinte mais à demi-enceinte et même, le temps passant, de moins en moins enceinte. Auteur d'écrits censés porter sur les chambres à gaz nazies mais où l'on ne pouvait trouver ni une photographie d'ensem­ble, ni un dessin d'ensemble d'un seul de ces abattoirs chimiques, le pitoyable gribouille devait faire la démonstration, le 9 mai 1995, à la XVIIe chambre du tribunal correctionnel de Paris, de sa totale impuis­sance à répondre aux questions de la présidente du tribunal sur ce qu'aurait bien pu être l'un de ces abattoirs. Trois ans plus tard, il en est réduit à écrire : « Ainsi, d'après les dires d'anciens membres du Sonder­kommando, on estime avec une forte certitude qu'un film sur les gazages homicides fut tourné par les SS à Birkenau. Pourquoi ne serait-il pas retrouvé par hasard dans le grenier ou la cave d'un ancien SS ? » [10]

Il est heureux que « la chambre à gaz » à l'état de ruines, appar­tenant au Krematorium II de Birkenau (Auschwitz-II), puisse surtout servir à démontrer « in vivo » et « de visu » qu'il n'y a jamais eu d' « Ho­locauste », ni dans ce camp ni ailleurs. En effet, d'après les interro­gatoires d'un accusé allemand et d'après des photographies aériennes « retouchées » par les Alliés, le toit de cette chambre à gaz aurait possédé quatre ouvertures spéciales (de 25 cm ´ 25 cm, précisait-on) pour le déversement du Zyklon. Or, tout le monde peut constater sur place qu'aucune de ces ouvertures n'existe ni n'a jamais existé. Ausch­witz étant la capitale de l' « Holocauste » et ce crématoire en ruines étant au cœur de l'extermination des juifs à Auschwitz, j'ai pu dire en 1994 ― et la formule semble avoir fait son chemin dans les esprits - : « No holes, no "Holocaust" » (Pas d'orifices, pas d' « Holocauste »).

Il est également heureux qu'on ait ainsi finalement invalidé une pléthore de « témoignages » selon lesquels ces gazages-là avaient existé et il est, du même coup, extrêmement déplorable que tant d'Allemands, jugés par leurs vainqueurs, aient été condamnés et parfois même exé­cutés pour des crimes qu'ils n'avaient pas pu commettre.

Il est bon qu'à la lumière de procès qui ressemblent à des mas­carades judiciaires les exterminationnistes eux-mêmes émettent des doutes sur la validité de maints témoignages ; ces témoignages apparaî­traient encore plus clairement erronés si l'on se donnait enfin la peine d'ordonner des expertises judiciaires de l'arme supposée du crime supposé puisque, à l'occasion de mille procès concernant Auschwitz ou d'autres camps, aucun tribunal n'a ordonné une telle expertise (la seule exception, très peu connue, étant celle du Struthof-Natzweiler, dont les résultats ont été tenus cachés jusqu'à ce que je les révèle). On savait pourtant bien que des témoignages ou des aveux doivent être circonstanciés et vérifiés et que, faute de ces deux conditions, ils sont dépourvus de valeur probatoire.

Il est heureux que l'histoire officielle ait révisé à la baisse ― sou­vent dans de considérables proportions ― le nombre supposé des victi­mes. Il a fallu plus de quarante années de pressions révisionnistes pour que les autorités juives et celles du Musée d'Auschwitz retirent les dix-neuf plaques qui, en dix-neuf langues différentes, annonçaient que le nombre des victimes du camp s'élevait à quatre millions. Il a ensuite fallu cinq années de disputes internes pour qu'on s'accorde sur le nou­veau chiffre de un million et demi, chiffre qui, ensuite, à son tour, a été très vite contesté par des auteurs exterminationnistes ; J.-C. Pressac, le protégé de S. Klarsfeld, ne propose plus, pour sa part, que le chiffre de 600 000 à 800 000 victimes juives et non juives pour toute la durée de l'existence du complexe d'Auschwitz. Il est dommage que cette quête du vrai chiffre ne se poursuive pas pour atteindre le chiffre proba­ble de 150 000 personnes, victimes, principalement, d'épidémies en près de quarante camps du complexe d'Auschwitz. Il est déplorable que, dans les écoles de France, on continue de projeter Nuit et Brouillard où le chiffre des morts d'Auschwitz est fixé à neuf millions ; en outre, dans ce film on perpétue le mythe du « savon fabriqué avec les corps », celui des abat-jour en peau humaine et celui des traces d'ongles des victimes dans le béton des chambres à gaz ; on y entend dire que « rien ne distinguait la chambre à gaz d'un block ordinaire » !

Il est bon qu'en 1988 Arno Mayer, professeur d'origine juive, enseignant à l'université de Princeton, ait soudainement écrit : « Les sources pour l'étude des chambres à gaz sont à la fois rares et dou­teuses » [10 bis] ; mais pourquoi avoir si longtemps affirmé que les sources étaient innombrables et dignes de confiance, et pourquoi avoir vili­pendé les révisionnistes qui écrivaient dès 1950 ce qu'Arno Mayer découvrait en 1988 ?

Il est surtout bon qu'en 1996 un historien, Jacques Baynac, qui s'était fait une spécialité, y compris dans le journal Le Monde, de traiter les révisionnistes de faussaires, ait enfin reconnu qu'il n'y a, en définitive, aucune preuve de l'existence des chambres à gaz. C'est, pré­cise-t-il, « pénible à dire comme à entendre » [11]. Peut-être, dans certaines circonstances, la vérité est-elle, pour certains, « pénible à dire comme à entendre » mais, pour les révisionnistes, la vérité est agréable à dire comme à entendre.

Il est enfin heureux que les exterminationnistes se soient permis de porter atteinte au troisième et dernier élément de la trinité de la Shoah : le chiffre de six millions de morts juives. Il semble que ce chiffre ait été lancé pour la première fois (un an avant la fin de la guerre en Euro­pe !) [12] par le rabbin Michael Dov Weissmandel (1903-1956) ; établi en Slovaquie, ce rabbin a été l'artisan principal du mensonge d'Auschwitz à partir des prétendus témoignages de Slovaques comme Rudolf Vrba et Alfred Wetzler ; il organisait d'intenses « campagnes d'information » en direction des Alliés, de la Suisse et du Vatican. Dans une lettre du 31 mai 1944, il n'hésitait pas à écrire : « Jusqu'à ce jour, six fois un million de juifs d'Europe et de Russie ont été détruits [13] ».

Egalement bien avant la fin de la guerre, on trouve ce chiffre de six millions chez le juif soviétique Ilia Ehrenbourg (1891-1967) qui fut peut-être le plus haineux propagandiste de la seconde guerre mon­diale [14]. En 1979, ce chiffre a été soudainement qualifié de « symboli­que » (c'est-à-dire de faux) par l'exterminationniste Martin Broszat lors du procès d'un révisionniste allemand. En 1961, Raul Hilberg, le plus prestigieux des historiens conventionnels, estimait le nombre des morts juives à 5,1 millions. En 1953, un autre de ces historiens, Gerald Reitlinger, avait proposé un chiffre compris entre 4,2 et 4,6 millions. Mais, en fait, aucun historien de cette école n'a présenté de chiffres fondés sur une enquête ; il ne s'agit que de supputations propres à cha­cun. Le révisionniste Paul Rassinier, pour sa part, a avancé le chiffre d'environ un million de morts juives mais en partant, précisait-il, de chiffres fournis par la partie adverse ; donc, là aussi, il s'agissait d'une supputation. La vérité est que beaucoup de juifs européens ont péri et que beaucoup ont survécu. Avec les moyens modernes de calcul, il devrait être possible de déterminer ce que « beaucoup » signifie dans chacun des deux cas. Mais les trois sources auxquelles on pourrait puiser les renseignements nécessaires sont, dans la pratique, interdites aux chercheurs indépendants ou d'un accès limité :

- Il s'agit d'abord de l'énorme documentation assemblée par le Service international de recherches (SIR) de Bad Arolsen (Allema­gne), dépendant du Comité international de la Croix-Rouge (Suisse) et dont l'accès est jalousement contrôlé par dix États dont celui d'Israël ;

- Il s'agit ensuite des documents possédés par la Pologne et la Russie et dont seulement une partie a été rendue accessible : registres mortuaires de certains camps, registres des incinérations, etc. ;

- Il s'agit enfin des noms des millions de survivants juifs qui ont perçu ou perçoivent des indemnités ou réparations financières, soit en Israël, soit dans plusieurs dizaines de pays représentés au sein du Congrès juif mondial. La simple énumération de ces noms montrerait à quel point une communauté souvent dite « exterminée » n'a pas du tout été exterminée.

Encore cinquante-deux ans après la guerre, l'État d'Israël évalue officiellement à environ 900 000 le nombre, dans le monde, des « sur­vivants » de l' « Holocauste » (exactement : entre 834 000 et 960 000) [15]. D'après une estimation du statisticien suédois Carl O. Nordling, à qui j'ai soumis cette évaluation du gouvernement israélien, il est possible, à partir de l'existence de 900 000 « survivants » en 1997, de conclure à l'existence, en 1945, d'un peu plus de trois millions de « survivants » au sortir de la guerre. Aujourd'hui encore, les organisations de « survi­vants » pullulent sous les dénominations les plus diverses ; elles ras­semblent aussi bien d'anciens « résistants » juifs que d'anciens enfants d'Auschwitz (c'est-à-dire des enfants juifs nés dans ce camp ou internés dès leur jeune âge avec leurs parents), des travailleurs forcés juifs ou, plus simplement, des fugitifs ou des clandestins juifs. Des « miracu­lés » par millions ne sont plus un « miracle » mais les produits d'un phénomène naturel. La presse américaine rapporte assez souvent des retrouvailles entre survivants d'une même famille dont chaque membre était, nous assure-t-on, convaincu jusque-là que « toute sa famille » avait disparu.

En résumé, malgré le dogme et malgré les lois, la recherche de la vérité historique sur la seconde guerre mondiale en général et sur la Shoah en particulier a progressé dans ces dernières années ; le grand public est tenu dans l'ignorance de ces progrès ; il serait suffoqué d'apprendre que beaucoup de ses croyances les plus solides ont été, depuis le début des années quatre-vingt, reléguées par les historiens les plus orthodoxes au rayon des légendes populaires. On pourrait dire qu'il existe, à ce point de vue, deux conceptions de l' « Holocauste » : d'une part, celle du grand public et, d'autre part, celle des historiens conformistes ; l'une paraît inébranlable tandis que l'autre menace ruine, tant on y procède à de hâtives réparations.

Les concessions faites aux révisionnistes par les historiens ortho­doxes, année après année, surtout à partir de 1979, ont été si importan­tes en nombre et en qualité que ces historiens se trouvent aujourd'hui dans une impasse. Ils n'ont plus rien à dire de substantiel sur le sujet même de l' « Holocauste ». Ils ont passé le relais aux cinéastes, aux ro­manciers, aux gens de théâtre. Même les muséographes sont en panne. A l'Holocaust Memorial Museum de Washington on a pris la « déci­sion » de n'offrir aux visiteurs « aucune représentation physique des chambres à gaz » (déclaration qui m'a été faite en août 1994 par Mi­chael Berenbaum, responsable scientifique du musée, en présence de quatre témoins, et auteur d'un livre-guide de plus de deux cents pages où, en effet, ne se trouve aucune représentation physique des chambres à gaz, pas même d'une misérable et fallacieuse maquette tout de même présentée aux visiteurs [16]). Les visiteurs du musée n'ont pas le droit de prendre des photographies. Claude Lanzmann, auteur de Shoah, film remarquable par son absence de contenu historique ou scientifique, n'a plus aujourd'hui que la ressource de vaticiner en déplorant que « les ré­visionnistes occupent tout le terrain » [17]. Quant à Elie Wiesel, il en ap­pelle à la discrétion de tous ; il nous adjure de ne plus chercher à voir de près ou à imaginer ce qui se passait, selon lui, dans les chambres à gaz : « Les chambres à gaz, il vaut mieux qu'elles restent fermées au re­gard indiscret. Et à l'imagination » [18]. Les historiens de l' « Holocauste » se sont mués en théoriciens, en philosophes, en penseurs. Leurs que­relles entre « intentionnalistes » et « fonctionnalistes » ou encore entre tenants et adversaires d'une thèse comme celle de Daniel Goldhagen sur la propension quasi naturelle des Allemands à verser dans l'antisémi­tisme et dans le crime raciste ne sauraient nous dissimuler l'indigence de leurs travaux proprement historiques.

Succès et insuccès du révision­nisme

En 1998, le bilan de l'entreprise révisionniste s'établit comme suit : un éclatant succès sur le plan de l'histoire et de la science (sur ce plan-là, nos adversaires ont signé leur capitulation en 1996) mais un échec sur le plan de la communication (nos adversaires ont verrouillé tout accès du révisionnisme aux médias sauf, pour l'instant, au réseau Internet).

Dans les années 1980 et tout au début des années 1990, des au­teurs antirévisionnistes avaient tenté d'engager le fer avec les révision­nistes sur le terrain de la science historique. Tour à tour, Pierre Vidal-Naquet, Nadine Fresco, Georges Wellers, Adalbert Rückerl, Hermann Langbein, Eugen Kogon, Arno Mayer ou Serge Klarsfeld (ce dernier avec l'aide du pharmacien Jean-Claude Pressac) avaient essayé de faire croire aux médias que réponse avait été trouvée aux arguments maté­riels ou documentaires des révisionnistes. Même Michael Berenbaum, même l'Holocaust Memorial Museum avaient, en 1993 et au début de l'année 1994, voulu relever le défi que j'avais lancé de nous montrer ne fût-ce qu'une seule chambre à gaz nazie et ne fût-ce qu'une seule preuve, de leur choix, qu'il avait existé un génocide des juifs. Mais leurs échecs ont été si cuisants qu'il leur a fallu progressivement aban­donner le combat sur ce terrain. Tout récemment, en 1998, M. Beren­baum a bien publié un gros ouvrage intitulé : The Holocaust and His­tory [19] mais, précisément, loin d'y étudier ce qu'il appelle l' « Holocaus­te » sur le plan de l'histoire (ce qu'avait expressément tenté A. Mayer en 1988), il nous montre plutôt, sans le vouloir, que l' « Holocauste » est une chose et l' « Histoire » une tout autre chose. D'ailleurs, l'ouvra­ge est quasi immatériel. Il ne contient ni photographie, ni dessin, ni la moindre tentative de représenter physiquement une réalité quelconque. Seule la couverture de l'ouvrage donne à voir… un amas de chaussu­res. Ces chaussures sont supposées être parlantes comme à l'Holocaust Memorial Museum de Washington où elles nous disent, paraît-il : « We are the shoes, we are the last witnesses » (Nous sommes les chaussures, nous sommes les derniers témoins). L'ouvrage n'est qu'un ensemble de cinquante-cinq contributions écrites et publiées sous la haute surveillance du rabbin Berenbaum : même Raul Hilberg, même Yehuda Bauer, même Franciszek Piper y renoncent à tout véritable effort de recherche scientifique et l'anathème y est prononcé contre un Arno Mayer qui, dans un récent passé, avait tenté de replacer l' « Holo­causte » dans l'histoire [20]. L'irrationnel l'a emporté sur les tentatives de rationalisation. E. Wiesel, C. Lanzmann, Steven Spielberg (avec un film, La Liste de Schindler, inspiré d'un roman), ont finalement triom­phé de ceux qui, dans leur propre camp, essayaient de prouver l' « Holo­causte ».

L'avenir montrera rétrospectivement que c'est en septembre 1996 que le glas a sonné pour les espérances de ceux qui avaient voulu combattre le révisionnisme sur le terrain de la science et de l'histoire. Les deux longs articles publiés à cette époque par l'historien antirévi­sionniste J. Baynac dans un journal helvétique ont définitivement clos le chapitre des tentatives de réponse rationnelle aux arguments des révisionnistes [21].

Au milieu et à la fin des années 1970, j'avais apporté ma propre contribution au développement du révisionnisme ; j'avais alors décou­vert et formulé ce qu'il est, depuis lors, convenu d'appeler l'argument physico-chimique, c'est-à-dire les raisons physiques et chimiques pour lesquelles les prétendues chambres à gaz nazies étaient tout simple­ment inconcevables. A l'époque, je me flattais d'avoir mis au jour un argument décisif que n'avaient jusqu'ici exposé ni un chimiste alle­mand (l'Allemagne ne manque pas de chimistes), ni un ingénieur américain (les États-Unis possèdent des ingénieurs qui, au vu des complications draconiennes requises pour la construction d'une cham­bre à gaz dans les pénitenciers de leur pays, auraient dû se rendre compte que les prétendues chambres à gaz nazies étaient impossibles à fabriquer pour des raisons physico-chimiques). Si, à cette époque, au milieu du fracas provoqué par ma découverte, un devin m'avait prédit que, vingt ans plus tard, vers 1994-1996, mes adversaires, après bien des tentatives pour montrer que j'étais dans l'erreur, se résigneraient, comme l'a fait J. Baynac, à reconnaître qu'en fin de compte il n'existe pas la moindre preuve de la réalité d'une seule chambre à gaz nazie, je m'en serais certainement réjoui. Et j'en aurais peut-être conclu que le mythe de l' « Holocauste », frappé en plein cœur, ne survivrait pas, que les médias abandonneraient le service du Grand Mensonge et que, tout normalement, la répression antirévisionniste s'éteindrait d'elle-même.

J'aurais commis là une erreur à la fois de diagnostic et de pro­nostic.

Car la croyance superstitieuse vit d'une autre vie que celle de la science. Elle va son propre chemin. Le monde de la religion, de l'idéo­logie, de l'illusion, des médias et du cinéma de fiction peut se déve­lopper en dehors des réalités scientifiques. Même Voltaire n'est jamais parvenu à « écraser l'infâme ». Ainsi pourrait-on dire que, comme Voltaire dénonçant les absurdités des récits hébraïques, les révision­nistes sont condamnés, en dépit du caractère scientifique de leurs travaux, à ne jamais l'emporter sur les élucubrations de la Synagogue, cependant que la Synagogue, elle, de son côté, ne parviendra jamais à étouffer la voix des révisionnistes. La propagande de l' « Holocauste » et le « Shoah-Business » continueront de prospérer. Reste aujourd'hui aux révisionnistes à montrer comment cette croyance, ce mythe, en sont venus à naître, à croître, puis à prospérer avant, peut-être, de dis­paraître pour laisser place, un jour, non pas à la raison mais à d'autres croyances et à d'autres mythes.

Comment trompe-t-on les hommes et pourquoi se trompent-ils eux-mêmes de si bon cœur ?

La propagande de l'« Holocauste » :
montrer des morts et parler de tués, montrer des fours crématoires et parler de
chambres a gaz

C'est par la manipulation des images qu'il est le plus facile d'abuser les foules. Dès avril 1945, des journalistes britanniques et américains se sont empressés, à l'ouverture des camps de concentration allemands, de photographier ou de filmer des horreurs vraies dont on a ensuite fait, si l'on peut dire, des horreurs plus vraies que nature. Dans le langage familier cher aux gens de presse, on a « bidonné » ; on nous a fourni du « Timisoara » avant la lettre [22]. D'une part, on nous a montré de vrais morts ainsi que d'authentiques crématoires et, d'autre part, grâce à des commentaires fallacieux et à une mise en scène cinémato­graphique, on a procédé à un tour de passe-passe dont le résultat peut tenir en une formule propre à servir de sésame pour la découverte de toutes ces impostures :

« On nous a fait prendre des morts pour des tués et des fours cré­matoires pour des chambres à gaz homicides. »

On aurait envie d'ajouter : « …et des vessies pour des lanternes ».

Ainsi est née la confusion, encore si répandue de nos jours, entre, d'une part, les fours crématoires, qui ont réellement existé (mais non à Bergen-Belsen) pour servir à l'incinération des morts, et, d'autre part, les chambres à gaz nazies qui, elles, auraient servi à tuer des foules d'hommes et de femmes mais qui n'ont, en réalité, jamais existé ni même pu exister.

Le mythe, sous sa forme médiatique, des chambres à gaz nazies associées à des fours crématoires trouve son point de départ dans les images et les commentaires de la presse au sujet d'un camp ― Bergen-Belsen ― qui, de l'avis même des historiens orthodoxes, ne possédait ni chambres à gaz homicides ni même de simples fours crématoires.

Des « chambres à gaz » jamais vues, jamais montrées

En mars 1992, à Stockholm, lors d'une conférence de presse, je lançais un défi au parterre de journalistes de la presse et de la télévi­sion. Ce défi tenait en quelques mots : « Montrez-moi ou dessinez-moi une chambre à gaz nazie ! »

Le lendemain, les journalistes rapportaient la conférence de presse mais en passaient sous silence l'objet essentiel : ce défi, précisément. Ils avaient cherché des photographies et n'en avaient pas trouvé.

Des milliards d'hommes, en ce demi-siècle, s'imaginent (ou se sont imaginé) avoir vu des chambres à gaz nazies dans des livres ou dans des films documentaires. Beaucoup sont convaincus d'avoir, au moins une fois en leur vie, rencontré la photographie d'une telle cham­bre à gaz. Certains ont visité Auschwitz ou d'autres camps où les gui­des leur ont expliqué que tel local avait été une chambre à gaz. On leur a dit qu'ils avaient sous les yeux une chambre à gaz, selon le cas, « à l'état d'origine » ou « à l'état de reconstitution » (cette dernière formule impliquant que ladite reconstitution est honnête et conforme à l'origi­nal). Parfois, on leur a désigné des ruines comme « ruines d'une cham­bre à gaz » [23]. Or, dans tous les cas, ils ont été abusés ou, mieux, ils se sont abusés eux-mêmes. Ce phénomène s'explique aisément. Trop de personnes s'imaginent qu'une chambre à gaz peut se réduire à une pièce quelconque avec du gaz dedans. C'est confondre un gazage d'exécution avec un gazage suicidaire ou accidentel. Un gazage d'exécution, comme aux États-Unis pour la mise à mort d'un seul condamné, est néces­sairement d'une redoutable complication car, dans ce cas, il faudra veiller à tuer sans provoquer d'accident et sans mettre en danger sa pro­pre vie ou celle de personnes de son entourage, surtout dans la phase finale, c'est-à-dire quand il faudra pénétrer dans le local pour y manipu­ler un cadavre contaminant et l'extraire de la chambre à gaz. Cela, la plupart des visiteurs de musées, ainsi que la plupart des lecteurs, la plupart des spectateurs de films et même la plupart des historiens l'ignorent manifestement. Les responsables des musées, eux, tirent profit de cette ignorance générale. En guise de chambre à gaz nazie, il leur suffit de présenter au bon public un local d'apparence lugubre, une chambre froide de morgue, une salle de douches (de préférence située en sous-sol), un abri antiaérien (doté d'une porte à judas) et le tour sera joué. Les trompeurs peuvent se contenter de moins : il leur suffit de faire voir une simple porte, un mur, un toit d'une prétendue « chambre à gaz ». Les trompeurs les plus avisés se contenteront d'encore moins : ils montreront un ballot de cheveux, un monceau de chaussures, un tas de lunettes et ils prétendront qu'il s'agit des seules traces ou vestiges qu'on ait retrouvés des « gazés » ; évidemment, ils se garderont de rappeler que, pendant la guerre et le blocus, dans une Europe en proie à la disette et à la pénurie, on procédait à la « récupération », puis au « recyclage » de tout matériau transformable, y compris des cheveux, lesquels, pour leur part, servaient, par exemple, à faire des vêtements.

Les témoins de l'« Holocauste » :

des témoignages non vérifiés

A propos des témoins règne la même confusion. On nous présen­te des cohortes de témoins du génocide des juifs. Par la parole ou par l'écrit, ces témoins prétendent attester de ce que l'Allemagne exécutait un plan d'extermination générale des juifs en Europe. En réalité, ces témoins peuvent seulement attester de la réalité de la déportation, de celle des camps de rétention, des camps de concentration ou des camps de travail forcé, et même, dans quelques cas, du fonctionnement des fours crématoires. Les juifs étaient si peu voués à l'extermination ou aux chambres à gaz homicides que chacun de ces innombrables té­moins survivants ou rescapés, loin de constituer, comme on veut nous le faire croire, une « preuve vivante du génocide », est, au contraire, une preuve vivante de ce qu'il n'y a pas eu de génocide. Comme on l'a vu ci-dessus, à la fin de la guerre le nombre des « survivants » juifs de l' « Holocauste » dépassait probablement le chiffre de trois millions.

Pour le seul camp d'Auschwitz, la liste est considérable des an­ciens internés juifs qui, sur l'extermination des juifs dans ce camp, ont porté un témoignage public par la parole ou par l'écrit, à la télévision, dans des livres, devant des tribunaux. Parmi les plus connus, citons :

Odette Abadie, Louise Alcan, Esther Alicigüzel, Jehuda Bacon, Charles Baron, Bruno Baum, Charles-Sigismond Bendel, Paul Bendel, Maurice Benroubi, Henri Bily, Ada Bimko, Suzanne Birnbaum, Eva Brewster, Henry Bulawko, Robert Clary, Jehiel Dinour alias K. Tzet­nik, Szlama Dragan, Fania Fénelon, Arnold Friedman, Philip Fried­man, Michel Gelber, Israël Gutman, Dr Hafner, Henry Heller, Benny Hochman, Régine Jacubert, Wanda Jakubowska, Stanislas Jankowski alias Alter Fajnzylberg, Simone Kadouch-Lagrange, Raya Kagan, Rudolf Kauer, Marc Klein, Ruth Klüger, Guy Kohen, Erich Kulka, Simon Laks, Hermann Langbein, Leo Laufer, Sonia Letwinska, Renée Louria, Henryk Mandelbaum, Françoise Maous, Mel Mermel­stein, Ernest Morgan, Filip Müller, Flora Neumann, Anna Novac, Myklos Nyiszli, David Olère, Dounia Ourisson, Dov Paisikovic, Gisella Perl, Samuel Pisar, Macha Ravine-Speter, Jérôme Scorin, Georges Snyders, Henri Sonnenbluck, Jacques Stroumsa, David Szmulewski, Henri Tajchner, Henryk Tauber, Sima Vaïsman, Simone Veil née Jacob, Rudolf Vrba, Robert Weil, Georges Wellers,…

Parmi les derniers venus, citons également le cas retentissant du clarinettiste Binjamin Wilkomirski. On ne sait trop pourquoi, ce faux témoin-là a été publiquement démasqué après trois ans d'une gloire qui lui avait valu, aux États-Unis, le National Jewish Book Award ; en Grande-Bretagne, le Jewish Quarterly Literary Prize ; en France, le prix Mémoire de la Shoah, ainsi qu'une impressionnante série d'articles dithyrambiques dans la presse du monde entier. Sa prétendue auto­biographie d'enfant déporté à Majdanek et à Auschwitz (?) avait paru chez Suhrkampf en 1995 sous le titre de : Bruchstücke. Aus einer Kindheit, 1939 bis 1948 (Fragments. D'une enfance, de 1939 à 1948). En France, le livre avait été publié chez Calmann-Lévy en 1997 sous le titre de : Fragments d'une enfance, 1939-1948. Au terme de son en­quête, un auteur juif, Daniel Ganzfried, révélait que Binjamin Wilko­mirski, alias Bruno Doessekker, né Bruno Grosjean, avait certes connu Auschwitz et Majdanek mais seulement après la guerre, en touriste [24]. En 1995, l'Australien Donald Watt avait, lui aussi, abusé les grands médias de langue anglaise avec son prétendu témoignage de « chauf­feur » des crématoires II et III à Auschwitz-Birkenau [25]. En septembre-novembre 1998, en Allemagne et en France, une vaste opération mé­diatique s'organisait également autour de soudaines « révélations » du Dr Hans-Wilhelm Münch, ancien médecin SS d'Auschwitz. La veine est décidément intarissable.

Primo Levi, lui, tend à nous être présenté encore aujourd'hui comme un témoin digne de foi. On verra dans le présent ouvrage que cette réputation était peut-être méritée en 1947 à la parution de son livre Se questo è un uomo ; malheureusement, P. Levi a, par la suite, démérité. Elie Wiesel reste incontestablement « le grand faux témoin » de l' « Holocauste ». Dans La Nuit, récit autobiographique, il ne men­tionne pas les « chambres à gaz » ; pour lui, les Allemands jetaient les juifs dans des fournaises ; encore le 2 juin 1987, au procès Barbie, il témoignera sous serment avoir « vu, dans un petit bois, quelque part dans [Auschwitz-] Birkenau, des enfants vivants que des SS jetaient dans les flammes ». Dans le présent ouvrage, on notera comment le traducteur et l'éditeur de la version allemande de La Nuit ont ressuscité les « chambres à gaz » dans le récit d'E. Wiesel. En France, Fred Sedel agira de même et mettra en 1990, dans la réédition d'un livre publié en 1963, des « chambres à gaz » là où il n'avait mentionné, vingt-sept ans plus tôt, que des « fours crématoires » [26].

On logera à la même enseigne du « pieux mensonge » les té­moignages de certains non juifs et, en particulier, du général André Rogerie qui, fort de l'appui que lui accordait Georges Wellers, se présentait en 1988 en « témoin de l'Holocauste » ayant « assisté à la Shoah à Birkenau » [27] alors que, dans l'édition originale de ses sou­venirs, Vivre, c'est vaincre, publiée en 1946, il disait seulement avoir entendu parler des « chambres à gaz » [28]. Notre héros jouissait dans le camp même d'Auschwitz-Birkenau d'un sort privilégié. Il était installé au bloc des « caïds » 4 et y bénéficiait d'une « planque royale » dont il « garde de bons souvenirs » 5. Il y mangeait des crêpes à la confiture et y jouait au bridge 6. Certes, écrivait-il, « il ne se passe pas [dans le camp] que des événements gais » 7 mais, au moment de quitter Birke­nau, il a cette pensée : « A l'encontre de bien d'autres, j'y ai été moins malheureux que partout ailleurs » 8.

Samuel Gringauz avait passé la guerre dans le ghetto de Kaunas (Lituanie). En 1950, c'est-à-dire à une époque où l'on pouvait encore s'exprimer avec une certaine liberté sur le sujet, il allait dresser le bi­lan de la littérature des survivants de « la grande catastrophe juive ». Il déplorait alors dans cette littérature les méfaits du « complexe hyper­historique » (hyperhistorical complex) ou complexe de surenchère par rapport à l'histoire. Il écrivait :

Le complexe hyperhistorique peut se décrire comme judéo­centrique, lococentrique et égocentrique. Il ne trouve essentiellement de signification historique qu'à des pro­blèmes juifs liés à des événements locaux, et cela sous l'aspect d'une expérience personnelle. C'est la raison pour laquelle, dans la plupart des souvenirs et des récits, s'étalent une absurde verbosité, l'exagération de l'écri­vassier, les effets de théâtre, une présomptueuse inflation de l'ego, une philosophie d'amateur, un lyrisme d'em­prunt, des rumeurs non vérifiées, des distorsions, des attaques partisanes et de minables discours [29].

On ne peut que souscrire à ce jugement qui, formulé en 1950, s'appliquerait aujourd'hui idéalement à un Claude Lanzmann ou à un Elie Wiesel. Pour le « complexe hyperhistorique » de ce dernier, pour le caractère « judéocentrique, lococentrique et égocentrique » de ses écrits, on pourra se reporter aux deux volumes de ses mémoires : Tous les fleuves vont à la mer (Mémoires), puis : …et la mer n'est pas remplie (Mémoires 2). On s'y rendra compte, d'ailleurs, que, loin d'avoir été exterminés, les juifs roumains-hongrois de la seule petite ville de Sighet ont vraisemblablement survécu en grand nombre à la déporta­tion, notamment vers Auschwitz, en mai-juin 1944. Originaire de cette ville de Sighet, E. Wiesel a subi le sort commun. Après la guerre, ses pas l'ont porté en différents points du monde où, par l'effet d'une succession de « miracles », il a rencontré un nombre étonnant de pa­rents, d'amis, de vieilles connaissances ou d'autres personnes de Sighet ayant survécu à Auschwitz ou à l' « Holocauste ».

Aperçu d'autres mystifications de la

Seconde Guerre Mondiale

Toujours aussi perplexes, les générations futures se poseront des questions identiques sur bien d'autres mythes de la seconde guerre mon­diale que celui des chambres à gaz nazies : en plus du « savon juif », des peaux humaines tannées, des « têtes réduites » et des « camions à gaz » ci-dessus mentionnés, citons les expériences médicales loufoques attri­buées au Dr Mengele, les ordres d'Adolf Hitler pour entreprendre l'exter­mination des juifs, l'ordre de Heinrich Himmler pour faire cesser cette extermination, les exterminations de juifs par l'électricité, par la vapeur d'eau, par l'emploi de la chaux vive, en des fours crématoires, en des fosses de crémation, par des pompes à faire le vide ; citons également la prétendue extermination des Tziganes et des homosexuels ou le prétendu gazage des aliénés.

Ces générations futures s'interrogeront sur bien d'autres sujets : les massacres sur le front de l'Est tels que rapportés par écrit, et seule­ment par écrit, au procès de Nuremberg par le faux témoin profession­nel Hermann Gräbe ; les impostures maintenant avérées comme le Hitler m'a dit, livre signé d'Hermann Rauschning, dû, en grande partie, au juif hongrois Imre Révész, alias Emery Reves, et pourtant abondam­ment utilisé au procès de Nuremberg comme s'il avait été authentique ; l'expérimentation possible d'une bombe atomique pour éliminer des juifs près d'Auschwitz, mentionnée au procès de Nuremberg ; les « aveux » aberrants extorqués à des prisonniers allemands ; le prétendu journal d'Anne Frank ; le jeune garçon du ghetto de Varsovie présenté comme allant à la mort alors qu'il a vraisemblablement émigré à New York après la guerre ; et tant de faux mémoires, faux récits, faux témoignages, fausses attributions dont, avec un minimum d'attention, il était facile de détecter la vraie nature.

Mais il est probable que ces mêmes futures générations s'étonne­ront surtout du mythe instauré et sacralisé par le procès de Nuremberg (et, à moindre degré, par le procès de Tokyo) : celui de l'intrinsèque barbarie des vaincus et de l'intrinsèque vertu des vainqueurs qui pour­tant, à y voir de près, ont commis des horreurs bien plus saisissantes, en qualité comme en quantité, que celles perpétrées par les vaincus.

Une boucherie universelle

A l'heure où l'on finirait par croire que seuls les juifs ont vrai­ment souffert durant la seconde guerre mondiale et que seuls les Alle­mands se sont comportés en véritables criminels, un retour s'impose sur les vraies souffrances et les véritables crimes de tous les belligérants.

« Juste » ou « injuste », toute guerre est une boucherie et même un concours de boucherie, et cela en dépit de l'héroïsme de bien des combattants ; si bien qu'à la fin du conflit le vainqueur n'est plus qu'un bon boucher, et le vaincu, un mauvais boucher. Le vainqueur peut alors infliger au vaincu une leçon de boucherie mais il ne saurait lui administrer une leçon de droit ou de justice. C'est pourtant ce qu'au procès de Nuremberg (1945-1946) les quatre grands vainqueurs, agis­sant en leur propre nom et au nom de dix-neuf puissances victorieuses (sans compter le Congrès juif mondial bénéficiant du statut d'amicus curiae, c'est-à-dire d' « ami de la cour »), ont eu le cynisme de faire à l'endroit d'un vaincu réduit à une totale impuissance. Selon Nahum Goldmann, président du Congrès juif mondial et président de l'Organi­sation sioniste mondiale, l'idée du procès est tout droit sortie de quel­ques cerveaux juifs [30]. Quant au rôle des juifs dans le procès même de Nuremberg, il a été considérable. La délégation américaine, qui menait toute l'affaire, était largement composée de « rémigrants », c'est-à-dire de juifs qui, après avoir quitté l'Allemagne dans les années trente pour émigrer aux États-Unis, étaient revenus en Allemagne. Le fameux psychologue G.M. Gilbert, auteur du Nuremberg Diary (1947), qui travaillait en sous-main avec le ministère public américain, était juif et ne se privait pas, à sa façon, de pratiquer la torture psychologique sur les accusés allemands. Dans un livre préfacé par le juge-assesseur Lord Justice Birkett, Airey Neave, attaché à la délégation britannique, constatait que les interrogateurs américains étaient « pour beau­coup de naissance allemande et tous d'origine juive » [31].

Pour des raisons qu'on me verra exposer dans le présent ouvrage, on peut estimer qu'en ce siècle le procès de Nuremberg aura été le cri­me des crimes. Ses conséquences se sont révélées tragiques. Il a accré­dité une somme extravagante de mensonges, de calomnies et d'injusti­ces qui, à leur tour, ont servi à justifier des abominations de tous ordres, à commencer par les crimes de l'expansionnisme bolchevique ou sioniste aux dépens des peuples d'Europe, d'Asie et de Palestine.

Mais, comme les juges de Nuremberg ont, d'abord et avant tout, condamné l'Allemagne pour sa responsabilité unilatérale dans la prépa­ration et le déclenchement de la seconde guerre mondiale, c'est ce point qu'il nous faut examiner en premier.

Quatre géants et trois nains :

qui a voulu la guerre ?

L'histoire étant d'abord de la géographie, considérons un pla­nisphère de l'année 1939 et marquons-y d'une seule couleur quatre immenses ensembles : la Grande-Bretagne avec son empire qui occu­pait un cinquième du globe et « sur lequel le soleil ne se couchait pas », la France avec son vaste empire colonial, les États-Unis et leurs vassaux et, enfin, l'impressionnant empire de l'Union des Républiques socialistes soviétiques ; puis, d'une autre couleur, marquons la modeste Allemagne en ses frontières d'avant-guerre, la maigre Italie et son petit empire colonial et, enfin, le Japon dont les armées, à l'époque, occupaient une partie du territoire chinois. Laissons de côté les pays qui allaient se ranger, au moins provisoirement, au côté de l'un ou de l'autre de ces deux groupes de belligérants.

Le contraste, pour ce qui est des deux groupes, est frappant au point de vue d'abord de la superficie, puis à celui des ressources naturelles, industrielles et commerciales. Certes, à la fin des années trente, l'Allemagne et le Japon commençaient ― ainsi que l'après-guerre allait le prouver ― à secouer le joug et à se forger une économie et une armée capables d'inquiéter de plus grands et de plus forts qu'eux. Certes, les Allemands et les Japonais allaient déployer une somme d'énergie peu ordinaire et, pendant les premières années de la guerre, se tailler d'éphémères empires. Mais, tout considéré, l'Allemagne, l'Italie et le Japon n'étaient, pour ainsi dire, que des nains comparés à ces quatre géants qu'étaient les empires britannique, français, américain et soviétique.

A qui fera-t-on croire qu'à la fin des années trente les trois nains cherchaient délibérément, comme on l'a prétendu au procès de Nurem­berg et au procès de Tokyo, à provoquer une guerre mondiale ? Et qui osera affirmer qu'en 1945, quand le combat s'est achevé, les quatre géants avaient commis moins d'horreurs que les trois nains ? Mieux : qui croira un seul instant que, dans la boucherie généralisée, le premier de ces trois nains (l'Allemagne) s'est rendu coupable de tous les crimes imaginables tandis que le deuxième (le Japon) est venu loin derrière le premier et que le troisième (l'Italie), passé en septembre 1943 dans l'autre camp, n'a commis aucun acte vraiment répréhensible ? Qui acceptera l'idée que les quatre géants n'ont, pour reprendre la terminologie de Nurem­berg, commis aucun « crime contre la paix », aucun « crime de guerre » ni aucun « crime contre l'humanité » qui ait mérité, après 1945, d'être jugé par un tribunal international ?

Il est pourtant facile de montrer, preuves à l'appui, que les vain­queurs ont, en six années de guerre et en quelques années de l'après-guerre, accumulé plus d'horreurs que les vaincus en fait de massacres de prisonniers de guerre, de massacres de populations civiles, de dé­portations gigantesques, de pillages systématiques et d'exécutions sommaires ou judiciaires. Katyn, le Goulag, Dresde, Hiroshima, Nagasaki, la déportation de douze à quinze millions d'Allemands (de Prusse orientale, de Poméranie, de Silésie, de Pologne, de Tchéco­slovaquie, de Hongrie, de Roumanie, de Yougoslavie) dans d'horribles conditions, la livraison de millions d'Européens au Moloch soviétique, la plus sanglante « Epuration » qui ait balayé tout un continent, était-ce vraiment si peu que pas un tribunal n'ait eu à en juger ? En ce siècle, pas un corps de bataille n'aura tué autant d'enfants que l'US Air Force en Europe, au Japon, en Corée, au Vietnam, en Irak, en Amé­rique Centrale et, pourtant, aucune juridiction internationale ne lui a demandé compte de ces tueries, que ses « boys » sont toujours prêts à déclencher encore une fois en n'importe quel point du globe, car tel est leur « job ».

Les Français voulaient-ils la guerre ?

« Maudite soit la guerre ! » porte le monument aux morts de la commune de Gentioux dans le département de la Creuse. Le monu­ment de Saint-Martin-d'Estréaux, dans le département de la Loire, est plus prolixe mais son « Bilan de la guerre » lance le même cri [32]. En France, dans nos églises ou sur nos monuments publics, la liste des morts de la guerre de 1914-1918 est un crève-cœur. Aujourd'hui, personne, au fond, n'est plus capable de dire pour quelle raison au juste la jeunesse française (tout comme, de son côté, la jeunesse allemande) a été ainsi fauchée.

Sur les mêmes monuments de nos communes figurent parfois, en nombre sensiblement plus restreint, les noms de jeunes Français morts ou disparus durant la campagne de 1939-1940 : environ 87 000. Parfois aussi on y lit les noms de victimes civiles ; à eux seuls, les Anglo-Américains ont tué dans leurs bombardements environ 67 000 Français. Parfois encore on y lit des noms de résistants, y compris quelquefois, pour faire nombre, les noms de résistants décédés bien après la guerre dans leur lit. Manquent, presque partout et presque tou­jours, les noms de Français victimes de l' « Epuration » (probablement 14 000 et non 30 000 ou même, comme on l'a parfois dit, 105 000) dans laquelle les juifs, les communistes et les gaullistes de la dernière heure ont joué un rôle primordial. Sauf exception, manquent égale­ment, parce qu'ils n'appartenaient pas de naissance à ces communes, les noms de membres des troupes coloniales « morts pour la France ».

Pour la France, les deux guerres mondiales ont constitué un désastre : la première par le nombre des pertes humaines et la seconde par son caractère de guerre civile qui se perpétue encore aujourd'hui.

A contempler ces listes des morts de la première guerre mondiale, à les compléter des noms des disparus, à se remémorer les bataillons entiers de « gueules cassées », de blessés, de mutilés, d'infirmes à vie, à faire le compte des destructions de toute sorte, à songer aux familles dévastées par ces pertes, aux prisonniers, aux « fusillés pour déser­tion », aux suicides entraînés par tant d'épreuves, à se remémorer égale­ment les vingt-cinq millions de morts provoquées en Amérique et en Europe à partir de 1918 par une épidémie de grippe improprement appelée « grippe espagnole » et importée en France, au moins en partie, par les soldats américains [33], ne peut-on comprendre aussi bien les pacifistes et les « munichois » d'avant 1939-1945 que les pétai­nistes de juin 1940 ? De quel droit, aujourd'hui, parle-t-on volontiers de lâcheté aussi bien à propos des accords de Munich, passés les 29 et 30 septembre 1938, que de l'armistice signé à Re­thondes le 22 juin 1940 ? Les Français qui, en ces temps-là, portaient encore, dans leur chair ou dans leur esprit, la marque de l'holocauste de 1914-1918 et de ses suites immédiates ― un véritable holocauste, pour le coup ― pouvaient-ils, à la fin des années trente, envisager comme une obliga­tion morale d'avoir à se lancer dans une nouvelle boucherie ? Et, après la signature d'un armistice qui, si dur fût-il, n'avait rien d'infamant, qu'y avait-il de déshonorant à rechercher l'entente avec l'adversaire, non pour faire la guerre mais pour conclure la paix ?

Les Allemands voulaient-ils la guerre ?

« Hitler [est] né à Versailles » : la formule a servi de titre à un ouvrage de Léon Degrelle. Le diktat de Versailles ― car il n'y eut pas vraiment de traité ― fut, en 1919, d'une telle rigueur et si infamant pour le vaincu que les sénateurs américains refusèrent de le reconnaître (20 novembre 1919) et qu'il tomba peu à peu dans le discrédit. Il dépe­çait l'Allemagne, la soumettait à une impitoyable occupation mi­litaire, l'affamait. En particulier, il obligeait le vaincu à céder à la Pologne la Posnanie, la Silésie et une partie de la Prusse occidentale. Les quatre cent quarante articles du « Traité de paix entre les puissances alliées et associées et l'Allemagne » (ainsi que les pièces annexes) signés à Versailles le 28 juin 1919 constituent, avec les traités con­nexes, un monument d'iniquités que seule la fureur d'une guerre qui venait de s'achever peut, à la rigueur, expliquer. « On a beau jeu de reprocher aux Allemands de n'avoir pas respecté Versailles. Leur rôle et leur vertu d'Allemands étaient de le tourner d'abord, et de le déchirer, de même que le rôle et la vertu des Français étaient de le maintenir » [34].

Vingt ans après l'écrasante humiliation, Hitler voudra recouvrer une partie des territoires livrés à la Pologne, de même que la France, après la défaite de 1870, avait voulu recouvrer l'Alsace et une partie de la Lorraine.

Comme aucun historien n'est en mesure ― à moins de légèreté ― de désigner le responsable principal d'un conflit mondial, on se gardera de faire porter à Hitler l'unique responsabilité de la guerre de 1939-1945 sous prétexte que, le 1er septembre 1939, il est entré en guerre contre la Pologne. En revanche, justifier l'entrée en guerre, deux jours plus tard, de la Grande-Bretagne et de la France contre l'Allemagne par la nécessité, au nom d'un traité, de secourir la Pologne n'a pas grand sens puisque, deux semaines plus tard, l'URSS entrait à son tour en guerre contre la Pologne pour en occuper une bonne partie, sans pro­voquer pour autant de réaction militaire de la part des Alliés.

Les conflits mondiaux ressemblent à ces gigantesques catastrophes naturelles qu'on ne saurait exactement prédire même si, quelquefois, on les sent venir. On ne les explique qu'après coup, laborieusement, et non sans déployer des trésors de mauvaise foi dans les accusations mu­tuelles de négligence, d'aveuglement, de mauvaise volonté ou d'irres­ponsabilité.

On peut toutefois constater qu'en Allemagne, à la fin des années trente, le parti de la guerre avec l'Occident était pour ainsi dire inexis­tant ; les Allemands n'envisageaient au pire qu'une « poussée vers l'Est » (Drang nach Osten). En revanche, en Occident, le parti de la guerre avec l'Allemagne était puissant. La « coterie de guerre » voulut « la croisade des démocraties », et l'obtint.

Parmi ces nouveaux croisés figuraient au premier rang, à de notables exceptions près, l'ensemble des juifs américains et européens.

Winston Churchill et les Britanniques

en maîtres de la propagande de guerre

Durant la première guerre mondiale, les Britanniques avaient, avec cynisme, exploité toutes les ressources de la propagande à base de récits d'atrocités entièrement fictives. Durant la seconde guerre mon­diale ils n'ont pas dérogé.

On est aujourd'hui sévère pour la politique d' « apaisement » menée par Neville Chamberlain à l'égard des Allemands et on admire, ou affecte d'admirer, Winston Churchill pour sa détermination à pour­suivre la guerre. Il n'est pas dit que l'histoire, avec le temps, main­tiendra ce jugement. Ce qu'on découvre peu à peu de la personnalité et du rôle de Churchill amène à s'interroger sur les motifs plutôt douteux de cette détermination et sur les fruits de sa politique. Au moins Chamberlain avait-il prévu que même une victoire de la Grande-Bre­tagne tournerait au désastre pour elle-même, pour son empire et aussi pour d'autres vainqueurs. Churchill ne le vit pas ou ne sut pas le voir. Il annonçait la sueur, les larmes, le sang, et puis la victoire. Il ne prévoyait pas les lendemains amers de la victoire : la disparition accé­lérée de cet empire britannique auquel il tenait et la livraison de près de la moitié de l'Europe à l'impérialisme communiste.

Dans l'une de ses conférences, David Irving, biographe de Chur­chill, montre le caractère illusoire des motifs successifs que Churchill fut amené à invoquer, d'abord pour lancer ses compatriotes dans la guerre, puis pour les y maintenir.

L'affaire, si l'on peut dire, se passa en quatre temps.

En un premier temps, Churchill assura aux Britanniques que leur devoir était de venir en aide à la Pologne agressée par Hitler, mais, deux semaines plus tard, ce motif devenait caduc avec l'agression de la Pologne par l'Union soviétique.

En un deuxième temps, il expliqua à ses concitoyens qu'ils devaient continuer la guerre pour sauvegarder l'empire britannique ; il refusait les offres de paix réitérées de l'Allemagne ; en mai 1941, il faisait interner le messager de paix Rudolf Hess ; et, alors que l'Allemagne était attachée au maintien de l'empire britannique, il choisit de conclure une alliance avec le pire ennemi qui fût de cet empire : l'Américain Franklin Roosevelt. Le deuxième motif devenait ainsi caduc à son tour.

En un troisième temps, Churchill annonça à ses compatriotes qu'il leur fallait se battre pour la démocratie, y compris sous sa forme la plus paradoxale : la démocratie socialiste soviétique ; il fallait, disait-il, ouvrir un second front en Europe pour soulager les efforts de Staline. C'était venir en aide à une dictature qui avait pourtant agressé la Pologne le 17 septembre 1939 et qui s'apprêtait à une nouvelle conquête de ce pays.

Encore un mois avant la fin de la guerre en Europe (8 mai 1945), la propagande anglaise tournait ainsi à vide, cependant que beaucoup de soldats britanniques et américains découvraient avec effarement à quel point l'aviation anglo-américaine avait ravagé l'Allemagne.

C'est alors que, soudain, en avril 1945, un miracle se produisit qui permit à Churchill de trouver cette fois-ci le quatrième et bon mo­tif : la découverte du camp de Bergen-Belsen l'amena à prétendre que, si la Grande-Bretagne s'était tant battue et avait provoqué et subi tant de destructions pendant près de six ans, ce n'était pour rien moins que la civilisation. Assurément, Churchill avait déjà, plus d'une fois, débité aux Britanniques les habituels couplets, depuis la guerre de 1914-1918, sur la Grande-Bretagne, ce berceau de la civilisation mis en péril par les hordes teutoniques (par « les Huns », disait-il), mais la méca­nique oratoire tournait à vide. Le miracle fut la découverte en avril 1945 de ce camp de concentration ravagé par les épidémies : une aubaine pour Churchill et pour la propagande britannique.

Les Britanniques inaugurent à Bergen-Belsen

les Reality Shows des « crimes nazis »

Situé près de Hanovre, Bergen-Belsen avait d'abord été un camp pour blessés de guerre allemands. En 1943, les Allemands y établirent un camp de détention pour juifs européens à échanger contre des civils allemands détenus par les Alliés. En pleine guerre, des juifs furent transférés de ce camp vers la Suisse ou même vers la Palestine via la Turquie (preuve supplémentaire, soit dit en passant, de l'absence de toute politique d'extermination physique des juifs).

Jusqu'à la fin de 1944, les conditions de vie des détenus de Ber­gen-Belsen furent à peu près normales quand, avec l'arrivée de convois de déportés venus de l'Est devant la poussée soviétique, les épidémies de dysenterie, de choléra et de typhus exanthématique provoquèrent un désastre aggravé par les bombardements anglo-américains qui empê­chaient l'arrivée des médicaments, de la nourriture et ― ce fut le coup de grâce ― de l'eau. Les convois des nouveaux arrivants ne mettaient plus deux ou trois jours à venir de l'Est mais une à deux semaines ; à cause des bombardements et des mitraillages de l'aviation alliée, ils ne pouvaient circuler que de nuit ; le résultat en fut qu'à leur arrivée ces convois ne contenaient plus guère que des morts, des mourants ou bien des hommes et des femmes épuisés et donc incapables d'affronter de telles épidémies. Le 1er mars 1945, le commandant du camp, Josef Kramer, adressa au général Richard Glücks, responsable des camps de concentration, une lettre décrivant en propres termes cette « catastro­phe » et se terminant par : « J'implore votre aide pour surmonter cette situation » [35].

L'Allemagne, à bout de forces, ne pouvait plus faire face à l'afflux de ses propres réfugiés de l'Est arrivant par millions. Elle ne parvenait plus à ravitailler son armée en armes et en munitions et sa propre population en nourriture. Enfin, elle ne pouvait plus remédier aux conditions de vie dramatiques des camps où même les gardiens mouraient parfois du typhus. Himmler autorisa des responsables de la Wehrmacht à prendre contact avec les Britanniques pour avertir ces derniers de ce qu'ils approchaient, dans leur avance, d'un redoutable foyer d'infection. Des négociations s'ensuivirent. Une large zone autour de Bergen-Belsen fut déclarée hors-combats et Britanniques et membres de la Wehrmacht décidèrent, d'un commun accord, de se partager la surveillance du camp.

Mais le spectacle que découvrirent les Britanniques et l'odeur insoutenable des cadavres en décomposition ainsi que des baraquements ou des tentes inondés de matière fécale finirent par soulever l'indi­gnation générale. On crut ou on laissa croire que les SS avaient délibérément choisi de tuer ou de laisser mourir les détenus. Et, malgré leurs efforts, les Britanniques furent incapables d'enrayer l'effrayante mortalité.

Comme une nuée de vautours, les journalistes s'abattirent sur le camp et filmèrent ou photographièrent toutes les horreurs possibles. Ils procédèrent, au surplus, à des montages. Une scène fameuse, reprise dans Nuit et Brouillard, montre un bulldozer poussant des cadavres dans une fosse commune. Beaucoup de spectateurs de cette scène furent conduits à croire qu'il s'agissait de « bulldozers allemands » [36]. Ils ne s'aperçurent pas que le bulldozer (au singulier) était conduit par un soldat britannique qui, sans doute, après le décompte des cadavres, repoussait ceux-ci dans une vaste fosse creusée après la libération du camp.

Encore en 1978, une publication juive montrera ce bulldozer mais non sans en décapiter, opportunément, sur la photographie le conduc­teur de manière à cacher son béret de soldat anglais [37]. Le juif Sydney Lewis Bernstein, responsable, à Londres, de la section cinémato­graphique du ministère de l'Information, fit appel à Alfred Hitchcock pour produire un film sur ces « atrocités nazies ». En fin de compte, seuls des fragments de ce film furent rendus publics, probablement parce que le film dans son intégralité contenait des assertions propres à faire douter de son authenticité [38].

Mais, dans son ensemble, le « coup de Bergen-Belsen » constitua une extraordinaire réussite pour la propagande des Alliés. C'est à partir de cette prouesse médiatique que le monde entier apprit à ne pas voir ce qu'il avait sous les yeux : on lui présenta soit des morts, soit des mourants mais le commentaire l'amena à croire qu'il avait sous les yeux soit des tués, des assassinés, des exterminés, soit des cadavres ambulants condamnés à la tuerie, à l'assassinat, à l'extermination. Ainsi, comme on l'a vu plus haut, c'est à partir d'un camp qui ne possédait ni fours crématoires, ni ― de l'avis même des historiens con­formistes ― la moindre chambre à gaz homicide, que s'édifia le mythe général de la présence à Auschwitz et ailleurs de « chambres à gaz » couplées avec des fours crématoires.

Dans ce camp, parmi les plus célèbres victimes des épidémies se trouvèrent Anne Frank et sa sœur Margot que, pendant près de quarante ans après la guerre, on persistera généralement à présenter comme gazées à Auschwitz (camp dont elles provenaient effectivement) ou comme tuées à Bergen-Belsen ; aujourd'hui, on s'accorde à reconnaître qu'elles sont mortes du typhus à Bergen-Belsen en février-mars 1945.

Le « coup de Bergen-Belsen » fut très vite imité par les Améri­cains qui, faisant appel à Hollywood, tournèrent une série de films sur la libération des camps allemands ; ils procédèrent à une sélection de leurs prises de vue (6 000 pieds de pellicule sur un total de 80 000 pieds, c'est-à-dire 1 800 mètres seulement sur près de 25 000 mètres) qui, le 29 novembre 1945, fut projetée au procès de Nuremberg où tout le monde, y compris la plupart des accusés, en éprouva un choc. Quelques accusés flairèrent la supercherie mais il était trop tard : le bulldozer du grand mensonge était lancé. Il roule encore aujourd'hui. Les spectateurs de tous ces films d'horreur sur les « camps nazis » furent, à la longue, mis en condition par le choix des images et par le commentaire. Un pan de mur, un tas de chaussures, une cheminée : il ne leur en fallut pas plus pour croire qu'on leur avait montré un abattoir chimique.

Cinquante-deux ans après la libération du camp de Bergen-Belsen, Maurice Druon, secrétaire perpétuel de l'Académie française, viendra déposer au procès de Maurice Papon. Voici un extrait de cette déposi­tion où sont évoquées les chambres à gaz homicides de Bergen-Belsen (dont tous les historiens reconnaissent aujourd'hui que ce camp était dépourvu), le fameux bulldozer et les « cheveux tondus sur les morts pour en faire quelque ersatz » :

Quand aujourd'hui on parle des camps on a dans les yeux, et les jurés présents ont dans les yeux ces images atroces que les films et les écrans nous présentent et nous repré­sentent ; et l'on a bien raison de le faire, et on devrait les rediffuser dans toutes les classes terminales, chaque année. Mais ces images-là, des chambres à gaz, des mon­ceaux de cheveux tondus sur les morts pour en faire quelque ersatz, de ces enfants jouant parmi les cadavres, et de ces cadavres si nombreux qu'on était forcé de les pousser dans les fosses au bulldozer, et de ces cohortes squelettiques, titubantes et hagardes, en vestes rayées, avec la mort dans les yeux, ces images-là, et j'en livre ici témoignage, je fus, en ma modeste qualité d'officier d'information, l'un des vingt officiers alliés à les « visionner » en premier, quand parvint le matériel cinématographique brut, comme on dit, de la libération par les Anglais du camp de Bergen-Belsen. Mais c'était au printemps de 1945. Jusque-là, on ne savait pas. ― Il ne faut pas juger avec nos yeux instruits [sic] d'aujourd'hui, mais avec nos yeux aveugles d'hier [39].

M. Druon, en réalité, avait hier des « yeux instruits » et il a aujourd'hui des « yeux aveugles ». Plus de cinquante années de propa­gande l'ont rendu définitivement aveugle. Mais déjà pendant la guerre, M. Druon et son oncle Joseph Kessel, tous deux juifs, n'étaient-ils pas aveuglés par la haine du soldat allemand lorsqu'ils composaient l'atroce Chant des Partisans (« Tueurs à la balle et au couteau, tuez vite ! ») ?

Américains et Soviétiques renchérissent

sur les Britanniques

Au moins, en 1951, une juive comme Hannah Arendt avait-elle l'honnêteté d'écrire : « Il n'est pas sans importance de savoir que toutes les photographies de camps de concentration sont de nature à induire en erreur (mis­leading) dans la mesure où elles montrent les camps dans leurs derniers stades, au moment où les Alliés y pénétrèrent […]. Les conditions régnant dans les camps résultaient des faits de guerre durant les derniers mois : Himmler avait ordonné l'évacuation de tous les camps d'exter­mination de l'Est ; en conséquence, les camps allemands furent consi­dérablement surpeuplés et [on] n'était plus en mesure d'assurer le ravitaillement en Allemagne [40]. » Rappelons ici, une fois de plus, que l'expression de « camps d'extermination » (extermination camps) est une création de la propagande de guerre alliée.

Eisenhower emboîta donc le pas à Churchill et procéda, sur une échelle américaine, à une telle propagande à base de récits d'atrocités que tout devint permis aussi bien à l'égard du vaincu qu'à l'endroit de la simple vérité des faits. Dans les prétendus reportages sur les camps allemands on ajouta, comme je l'ai dit, aux horreurs vraies des horreurs plus vraies que nature. On élimina les photographies ou les fragments de films montrant des internés à la mine aussi florissante que celle de Marcel Paul, ou encore des internés en bonne santé relative malgré la disette ou les épidémies, ou bien encore, comme à Dachau, des mères juives hongroises en bonne santé donnant le biberon à de beaux poupons. On ne retint guère que les cachectiques, les infirmes, les loques humaines qui étaient, en réalité, des victimes tout autant des Allemands que des Alliés qui, avec leurs bombardements en tapis de bombes sur toute l'Allemagne et leurs mitraillages systématiques des civils jusque dans les champs, avaient créé une situation apocalyptique au cœur même de l'Europe.

La vérité oblige à dire que ni Churchill, ni Eisenhower, ni Tru­man, ni de Gaulle ne poussèrent tout de même l'impudence jusqu'à cautionner les histoires d'abattoirs chimiques ; ils laissèrent ce soin à leurs officines de propagande et aux juges de leurs tribunaux militaires. D'affreuses tortures furent infligées aux Allemands coupables, aux yeux des Alliés, de tous ces « crimes » ; des représailles furent exercées sur les prisonniers allemands et sur les civils. Jusqu'en 1951 on fusilla ou pendit des Allemands et des Allemandes (encore dans les années quatre-vingt, les Soviétiques fusilleront des « criminels de guerre » allemands ou alliés des Allemands). Les militaires britanniques et américains, un instant bouleversés par le spectacle à la fois des villes allemandes ré­duites en cendres et de leurs habitants transformés en troglodytes, purent rentrer chez eux la conscience tranquille. Churchill et Eisen­hower s'en portaient garants : les troupes alliées avaient terrassé le Mal ; elles incarnaient le Bien ; on allait procéder à la « rééducation » du vaincu en brûlant par millions ses mauvais livres. Tout compte fait, la Grande Tuerie avait été conduite à bonne fin et pour le bon motif.

C'est ce bluff que consacra le procès-spectacle de Nuremberg.

Un bluff enfin dénoncé en 1995

Il ne fallut pas moins de cinquante ans pour qu'une historienne, Annette Wieviorka, et un cinéaste, William Karel, révèlent au grand public, dans un documentaire intitulé Contre l'oubli, les mises en scène et les fabrications américaines et soviétiques de 1945 au sujet de la libération des camps de l'Ouest et de l'Est.

A. Wieviorka, juive française, et W. Karel, Israélien vivant en France depuis 1985, ont manifestement subi l'influence de l'école révisionniste française. Très hostiles aux révisionnistes, ils n'en ont pas moins admis que l'heure était enfin venue de dénoncer quelques inventions trop voyantes de la propagande exterminationniste. On se reportera sur le sujet soit à un article de Philippe Cusin [41], soit, sur­tout, à l'occasion de la rediffusion du documentaire sur Antenne 2, à un article de Béatrice Bocard dont le titre, à lui seul, en dit long : « La Shoah, de la réalité aux shows. Face aux récits des déportés, l'indé­cente mise en scène de leurs libérateurs » [42]. La journaliste écrit :

En exagérant à peine, on pourrait dire que la libération des camps de concentration a inauguré les reality shows […]. Les prémices de la société du spectacle qu'allaient bana­liser cinquante ans plus tard les chaînes de télévision comme CNN étaient déjà là, avec la surenchère à l'indé­cence, au voyeurisme, et le recours à la mise en scène […]. Devant les caméras, on fait répéter leur texte aux moins mal en point des survivants : « J'ai été déporté parce que j'étais juif », dit l'un. Une fois, deux fois… […] Pour ne pas être en reste après le « show » américain, les Soviéti­ques, qui n'avaient rien fait au moment de la libération d'Auschwitz, filment une « fausse libération » quelques semaines plus tard, avec des figurants polonais acclamant les soldats à grands cris… « William Karel est le premier à décortiquer ces images fausses que l'on nous a toujours montrées, encore très récemment, comme authentiques », dit Annette Wieviorka. Comment a-t-on pu y croire ? « On n'a pas l'habitude de mettre les images en doute comme on le fait pour l'écrit », explique l'historienne. « L'exemple du charnier de Timisoara n'est pas si lointain ».

Il va sans dire que, dans cet article de B. Bocard, les manipulations étaient montrées comme outrageantes… pour les déportés. Quant aux Allemands, civils et militaires, certains d'entre eux avaient dénoncé dès 1945 ce type de montages mais, plutôt que de les croire, on les accusa de nazisme ou d'antisémitisme.

Eminente responsabilité des organisations juives
dans cette propagande

De son origine, en 1941, à nos jours, la propagande qui s'est développée autour du « génocide » ou des « chambres à gaz » est essen­tiellement le fait d'organisations juives. En conséquence s'est peu à peu formée dans le grand public la conviction qu'une entreprise d'exter­mination physique menée par les Allemands visait, avant tout, les juifs et que les « chambres à gaz » étaient en quelque sorte réservées aux juifs (y compris aux juifs du « Sonderkommando » conduisant leurs coreligionnaires à l'abattoir). Aujourd'hui, les innombrables « musées de l'Holocauste » constituent un monopole juif et c'est un mot hébreu, celui de « Shoah » (catastrophe), qui désigne de plus en plus souvent ce prétendu génocide. Quelle qu'ait pu être leur partici­pation à la constitution et au succès du mythe, les Alliés n'ont joué en la circonstance qu'un rôle secondaire et toujours sous la pression des organisations juives. Cependant, le cas des Soviétiques pourrait avoir été différent : leur propre fabrication d'un « Auschwitz » où l'accent n'est pas mis sur le sort des juifs pourrait avoir trouvé son origine dans la nécessité d'une propagande, par-delà le Rideau de fer, en direc­tion des progressistes occidentaux.

Et ce n'est pas parce qu'aujourd'hui des voix juives s'élèvent pour demander qu'on parle moins des « chambres à gaz » que la propagande de l' « Holocauste » ou de la Shoah baisse de ton chez les responsables de la communauté juive. Plus simplement, aux yeux des historiens juifs, ces incroyables « chambres à gaz » sont devenues encombrantes pour la propagation de la foi en la Shoah.

Une personnalité politique française a dit des chambres à gaz nazies qu'elles étaient un détail de la seconde guerre mondiale. Or, dans leurs ouvrages respectifs sur cette guerre, Eisenhower, Churchill et de Gaulle ont apparemment jugé que ces abattoirs chimiques étaient même moins qu'un détail puisqu'ils n'en ont pas pipé mot. On note la même discrétion chez l'historien René Rémond, membre important d'abord du Comité d'histoire de la Deuxième Guerre mondiale, puis de l'Institut d'histoire du temps présent : dans deux de ses ouvrages où l'on s'atten­drait à voir figurer les mots de « chambre à gaz », on ne trouve rien de tel. L'historien américain Daniel Jonah Goldhagen parle de ces chambres comme d'un « épiphénomène ». Dans la version française du jugement de Nuremberg, seuls 520 mots, extrêmement vagues, sur environ 84 000 leur sont consacrés, ce qui constitue 0,62 % du texte de ce jugement.

Pour un révisionniste, les chambres à gaz sont moins qu'un détail parce qu'elles n'ont tout simplement pas existé mais le mythe des chambres à gaz, lui, est beaucoup plus qu'un détail : il est la pierre angulaire d'un immense édifice de croyances en tout genre que la loi nous interdit de contester.

« Chambres à gaz ou pas, quelle importance ? » On entend parfois cette question, empreinte de scepticisme. Elle irrite l'historien P. Vidal-Naquet pour lequel abandonner les chambres à gaz reviendrait à « capi­tuler en rase campagne » [43]. On ne peut que lui donner raison. En effet, selon que ces chambres à gaz ont existé ou non, on nous présentera les Allemands comme de fieffés criminels ou bien les juifs comme de fieffés menteurs (ou bonimenteurs). Dans le premier cas, les Alle­mands ont, pendant trois ou quatre ans, tué, par un moyen industriel et en des proportions industrielles, de malheureuses victimes désarmées tandis que, dans le second cas, les juifs, depuis plus d'un demi-siècle, colportent un mensonge de dimension historique.

En 1976 l'universitaire américain Arthur Robert Butz publiait son ouvrage The Hoax of the Twentieth Century ; de mon côté, je pu­bliais dans Le Monde du 29 décembre 1978 et du 16 janvier 1979 deux textes sur « la rumeur d'Auschwitz » et, tout au début de la même année 1979, Wilhelm Stäglich publiait Der Auschwitz Mythos. Se faisant le porte-parole de bien des inquiétudes juives devant l'éclosion des écrits révisionnistes, le sioniste W.D. Rubinstein, professeur à l'université Deakin de Melbourne (Australie), écrivait alors :

Si l'on démontrait que l'Holocauste est une mystification, l'arme n° 1 de l'arsenal de la propagande d'Israël dispa­raîtrait [44].

Se répétant quelque temps plus tard, il déclarait :

[C'est] un fait que, si l'on peut démontrer que l'Holocauste est un « mythe sioniste », la plus forte de toutes les armes de l'arsenal de la propagande d'Israël s'effondre [45].

Huit ans plus tard, comme en écho, un avocat de la LICRA déclarait :

Si les chambres à gaz ont existé, la barbarie nazie n'est égale à aucune autre. Si elles n'ont pas existé, les juifs ont menti et l'antisémitisme s'en trouverait justifié. Voilà l'enjeu du débat [46].

Selon la formule d'E. Zündel, « l' "Holocauste" est l'épée et le bouclier d'Israël ».

L'enjeu n'est donc pas simplement historique mais politique. Cet enjeu politique est paradoxal : le mythe de l' « Holocauste » sert à condamner d'abord le national-socialisme allemand, puis toute forme de nationalisme ou d'idée nationale sauf le nationalisme israélien et l'idée sioniste que ce mythe, au contraire, renforce.

L'enjeu est également financier quand on songe que, au moins de­puis les accords sur les « réparations » signés à Luxembourg en 1952, les contribuables allemands ont versé des sommes « astronomiques » (le qualificatif est de Nahum Goldmann) à l'ensemble des juifs de l'État d'Israël ou de la Diaspora et qu'ils continueront, à cause de la Shoah, de payer pour les crimes qu'on leur impute au moins jusqu'en l'an 2030. Le « Shoah-Business », dénoncé même par un P. Vidal-Naquet, est indissociable de la Shoah.

Aujourd'hui, le bluff de la Shoah autorise un racket à l'échelle mondiale. Pour commencer, une série croissante de pays riches ou pauvres, dont la France, se voient réclamer, par le Congrès juif mon­dial que préside le milliardaire Edgar Bronfman et par de richissimes organisations juives américaines, des montagnes d'or et d'argent à titre de nouvelles « restitutions » ou de nouvelles « réparations ». Les pays d'Europe, à commencer par la Suisse, ne sont pas les seuls visés. Pour l'instant, une maffia, qui a pignon sur rue, opère en quatre directions principales (il y en aura d'autres, à n'en pas douter) : « l'or nazi », les avoirs juifs, les collections d'art juives et les polices d'assurances souscrites par des juifs. Les principales cibles sont les gouvernements, les banques, les musées, les salles de vente publique et les compagnies d'assurance. Aux États-Unis, sous la pression des organisations juives, l'État du New Jersey a déjà voté des mesures de boycottage contre les institutions bancaires suisses. Ce n'est qu'un début. Le seul véritable argument invoqué par les maîtres-chanteurs tient en un mot : celui de Shoah. Pas un gouvernement, pas une banque, pas une société d'assu­rance n'ose rétorquer pour sa défense qu'il s'agit là d'un mythe et qu'il n'y a pas lieu de payer pour un crime qui n'a pas été commis. Les Suisses, sous la pression des organisations juives, en un premier temps ont eu la naïveté de voter une loi interdisant toute remise en cause de la Shoah ; mais ils n'ont pas plus tôt publié cette loi qu'E. Bronfman leur a présenté la note à payer. Les Suisses ont alors offert des sommes considérables. Peine perdue. E. Bronfman, « en colère », a fait savoir qu'il lui en fallait infiniment plus. « Mon expérience des Suisses », a-t-il déclaré, « est qu'à moins que vous ne leur teniez les pieds tout près du feu, ils ne vous prennent pas au sérieux » [47].

Quant au préjudice moral causé à l'Allemagne en particulier et aux non juifs en général par la propagation de la religion de l' « Holo­causte », il est incalculable. Les organisations juives ne cessent de réitérer leurs accusations contre une Allemagne coupable d'un « géno­cide » des juifs et contre Churchill, Roosevelt, de Gaulle, Staline, le pape Pie XII, le Comité international de la Croix-Rouge, les pays neutres et d'autres pays encore, coupables, paraît-il, d'avoir laissé l'Alle­magne commettre ce « génocide » et redevables, par conséquent, de « ré­parations » financières, eux aussi.

Les organisations juives imposent

le credo de l'« Holocauste »

Mon ouvrage, comme on le verra, touche peu à la « question juive ».

Si, durant tant de lustres, j'ai poursuivi avec acharnement l'en­quête historique sans trop me soucier de la « question juive » en tant que telle, c'est que, dans mon esprit, cette dernière n'était que d'une importance secondaire. Elle risquait de me détourner de l'essentiel : je cherchais, d'abord et avant tout, à déterminer les parts respectives de la vérité et du mythe dans l'histoire dite de l' « Holocauste » ou de la Shoah ; il m'importait donc beaucoup plus d'établir la matérialité des faits que de rechercher les responsabilités.

Pourtant, malgré moi, deux faits allaient me contraindre à sortir de ma réserve : l'attitude de nombreux juifs à l'endroit de mes travaux et leur mise en demeure lancinante d'avoir à me prononcer sur ce qui passionne tant d'entre eux : la « question juive ».

Quand, au début des années soixante, j'abordai ce qu'Olga Worm­ser-Migot allait, dans sa thèse de 1968, appeler « le problème des chambres à gaz », je sus d'emblée les conséquences que pourrait entraî­ner pareille entreprise. L'exemple de P. Rassinier m'avertissait que je pouvais craindre de graves répercussions. Je décidais néanmoins d'aller de l'avant, de m'en tenir à une recherche de caractère purement histo­rique et d'en publier le résultat. Je choisissais aussi de laisser à l'adver­saire éventuel la responsabilité de sortir du domaine de la controverse universitaire pour employer les moyens de la coercition et peut-être même de la violence physique.

C'est précisément ce qui se produisit. Usant d'une comparaison, je pourrais dire qu'en quelque sorte la fragile porte de bureau derrière laquelle je rédigeais mes écrits révisionnistes céda, un jour, subite­ment, sous la poussée d'une tourbe vociférante de protestataires. Force me fut alors de le constater, la totalité ou la quasi-totalité des trublions étaient des fils et des filles d'Israël. « Les juifs » venaient de faire irrup­tion dans ma vie. Je les découvrais soudain non plus tels que je les avais connus jusque-là, c'est-à-dire comme des individus à distinguer les uns des autres, mais comme les éléments, impossibles à détacher les uns des autres, d'un groupe particulièrement soudé dans la haine et, pour employer leur propre mot, dans la « colère ». Frénétiques, l'écume à la bouche, sur le ton à la fois du gémissement et de la menace, ils venaient me corner aux oreilles que mes travaux les hérissaient, que mes conclusions étaient fausses et qu'il me fallait impérativement faire allégeance à leur propre interprétation de l'histoire de la seconde guerre mondiale. Cette interprétation casher place « les juifs » au centre de cette guerre en tant que victimes, à nulle autre pareilles, d'un conflit qui a tout de même causé probablement près de quarante millions de morts. Pour eux, leur massacre était unique dans l'histoire du monde. On me prévenait qu'à moins de me soumettre je verrais ma carrière ruinée. On me mènerait devant les tribunaux. Puis, par la voie média­tique, le Grand Sanhédrin, formé des prêtres, des notables et des doc­teurs de la loi juive, lança contre ma personne une virulente campagne d'appels à la haine et à la violence. Je ne m'attarderai pas sur la suite, interminable, des outrages, des agressions physiques et des procès.

Les responsables de ces organisations me traitent volontiers de « nazi », ce que je ne suis pas. Comparaison pour comparaison, je serais plutôt, par rapport à elles, un « Palestinien », traité comme tel et porté à croire qu'à l'égard de ceux qui leur déplaisent les juifs se com­portent dans la Diaspora comme on les voit se conduire en Palestine. Mes écrits sont, si l'on veut, les pierres de mon Intifada. A franchement parler, je ne découvre pas de différence essentielle entre le comporte­ment des responsables sionistes à Tel-Aviv ou à Jérusalem et celui des responsables juifs à Paris ou à New York : même dureté, même esprit de conquête et de domination, mêmes privilèges, sur un fond incessant de chantage, de pressions accompagnées de plaintes et de gémissements. Cela dans l'espace. En est-il autrement dans le temps ? Le peuple juif a-t-il été aussi malheureux dans les siècles passés qu'il veut bien le dire ? A-t-il autant souffert de guerres et de guerres civiles que les autres communautés humaines ? A-t-il connu autant de détresses et de misère ? N'a-t-il vraiment aucune responsabilité dans les réactions d'hostilité dont il se plaint volontiers ? Sur ce point, Bernard Lazare écrit :

Si cette hostilité, cette répugnance même, ne s'étaient exercées vis-à-vis des Juifs qu'en un temps et en un pays, il serait facile de démêler les causes restreintes de ces colères ; mais cette race a été, au contraire, en butte à la haine de tous les peuples au milieu desquels elle s'est établie. Il faut donc, puisque les ennemis des Juifs appar­tenaient aux races les plus diverses, qu'ils vivaient dans des contrées fort éloignées les unes des autres, qu'ils étaient régis par des lois différentes, gouvernés par des principes opposés, qu'ils n'avaient ni les mêmes mœurs, ni les mêmes coutumes, qu'ils étaient animés d'esprits dissemblables ne leur permettant pas de juger également de toutes choses, il faut donc que les causes générales de l'antisémitisme aient toujours résidé en Israël même et non chez ceux qui le combattirent.

Ceci n'est pas pour affirmer que les persécuteurs des Israélites eurent toujours le droit de leur côté, ni qu'ils ne se livrèrent pas à tous les excès que comportent les haines vives, mais pour poser en principe que les Juifs causèrent ― en partie du moins ― leurs maux [48].

B. Lazare, qui n'est nullement hostile à ses coreligionnaires ― bien au contraire -, a la franchise de rappeler à plusieurs reprises combien les juifs ont su, tout au long de leur histoire, dès l'Antiquité, s'acquérir des privilèges : « [Beaucoup] d'entre les pauvres gens étaient attirés par les privilèges accordés aux Juifs [49]. »

On me permettra ici une confidence.

En mes qualités à la fois d'ancien latiniste, de justiciable pour­suivi devant les tribunaux par des organisations juives, de professeur d'université empêché de donner ses cours à cause de manifestations juives, et, enfin, d'auteur interdit de publication à cause de décisions du grand rabbinat entérinées par la République française, il m'arrive de confronter mes expériences avec celles d'illustres pré­décesseurs. C'est ainsi que je songe à l'aristocrate romain Lucius Flaccus. En 59 avant notre ère, Cicéron eut à le défendre notamment contre ses accusateurs juifs ; la description que fait l'illustre orateur de l'influence, de la puissance et des procédés des juifs de Rome dans le prétoire me donne à penser que, s'il revenait sur terre, au XX^e^siècle, pour y défendre un révisionniste, il n'aurait pour ainsi dire pas un mot à changer sur ce point dans sa plaidoirie du Pro Flacco.

Ayant eu à enseigner à la Sorbonne, je songe également à mon prédécesseur Henri Labroue, auteur d'un ouvrage sur Voltaire antijuif. A la fin de l'année 1942, en pleine occupation allemande, à une époque où l'on veut nous faire croire que les juifs et leurs défenseurs se fai­saient le plus discrets possible, il dut renoncer à donner ses cours sur l'histoire du judaïsme. Citons André Kaspi : « Une chaire d'histoire du judaïsme a été créée à la Sorbonne pour la rentrée de 1942 et confiée à Henri Labroue. Les premières leçons ont donné lieu à des manifes­tations d'hostilité et à des incidents qui ont entraîné la suppression des cours » [50].

Mais, aujourd'hui, immanquablement se retrouveraient devant les tribunaux, sur plainte d'associations juives, des dizaines de grands noms de la littérature mondiale dont Shakespeare, Voltaire, Hugo ainsi que Zola (le défenseur de Dreyfus a également écrit L'Argent). Parmi les grands noms de la politique, même un Jaurès siégerait au banc d'infamie.

De telles considérations pourraient me valoir l'épithète d'antisé­mite ou d'antijuif. Je récuse ces qualificatifs que je tiens pour de faciles insultes. Je ne veux aucun mal à aucun juif. En revanche, je trouve détestable le comportement de la plupart des associations, organisa­tions et groupes de pression qui prétendent représenter les intérêts juifs ou la « mémoire juive ».

Les responsables de ces associations, organisations ou groupes ont manifestement le plus grand mal à comprendre qu'on puisse agir par simple honnêteté intellectuelle. Si, pour ma part, j'ai consacré une bonne partie de ma vie au révisionnisme, d'abord dans le domaine des études littéraires, puis dans celui de la recherche historique, ce n'est nullement à la suite d'odieux calculs ou pour servir un complot anti­juif, mais par un mouvement aussi naturel que celui qui fait que l'oi­seau chante, que la feuille pousse et que, dans les ténèbres, l'homme aspire à la lumière.

Résistance naturelle de la science historique

à ce credo

A l'instar de quelques autres révisionnistes, j'aurais pu opérer ma soumission, faire acte de repentance, me rétracter ; autre échappatoire : j'aurais pu me contenter d'ourdir de savants et biscornus stratagèmes. Non seulement je décidai, dès les années soixante-dix, de résister à visage découvert et en pleine lumière mais je me promis de ne pas entrer dans le jeu de l'adversaire. Je formai la résolution de ne rien changer à mon propre comportement et de laisser les excités s'exciter chaque jour davantage. Parmi les juifs, je n'écouterais que ceux, parti­culièrement courageux, qui osaient prendre ma défense au moins l'espace d'une saison [51].

Les organisations juives dans leur ensemble traitent d'antisémites ceux qui n'adoptent pas leur propre conception de l'histoire de la se­conde guerre mondiale. On peut les comprendre puisque aller jusqu'à dire, comme je le fais ici et maintenant, qu'elles comptent, pour moi, parmi les principaux responsables du colportage d'un gigantesque mythe a les apparences d'une opinion inspirée par l'antisémitisme. Mais, en réalité, je ne fais que tirer les conclusions évidentes d'une enquête historique qui, selon toute vraisemblance, doit être des plus sérieuses puisque aucun tribunal, malgré les fiévreuses recherches de l'accu­sation, n'a pu y déceler trace de légèreté, de négligence, d'ignorance délibérée ou de mensonge.

Par ailleurs, à des groupes de personnes qui n'ont pas manifesté le moindre respect pour mes recherches, mes publications, ma vie per­sonnelle, familiale ou professionnelle, je ne vois pas pourquoi, de mon côté, je témoignerais du respect. Je n'attaque ni ne critique ces groupes pour leurs convictions religieuses ou leur attachement à l'État d'Israël. Tous les groupes humains se repaissent de fantasmagories. Libre, par conséquent, à chacun d'entre eux de s'offrir de son histoire une représentation plus ou moins réelle, plus ou moins imaginaire. Mais cette représentation, il ne faut pas l'imposer aux autres. Or, les organisations juives nous imposent la leur, ce qui, en soi, est inaccep­table et l'est encore plus quand cette représentation est manifestement erronée. Et je ne connais pas en France d'autre groupe qui, d'un article de foi de sa religion (comme celle de la Shoah) soit parvenu à faire un article de la loi républicaine ; qui bénéficie du privilège exorbitant de posséder des milices armées avec l'assentiment du ministère de l'Intérieur ; et qui, enfin, peut décréter que des universitaires qui lui déplaisent n'au­ront plus le droit d'enseigner ni en France, ni à l'étranger (voy., en particulier, l'affaire Bernard Notin).

Pour un révisionnisme sans complexes

Les révisionnistes ne connaissent en fait ni maître ni disciple. Ils forment une troupe hétéroclite. Ils répugnent à s'organiser, ce qui présente autant d'inconvénients que d'avantages. Leur individualisme les rend inaptes à l'action concertée ; en revanche, les services de police se révèlent incapables de pénétrer et de surveiller un ensemble aussi disparate ; ils ne peuvent remonter aucune filière puisque précisément il n'existe aucun réseau révisionniste. Ces individus se sentent libres d'improviser, chacun selon ses aptitudes ou ses goûts, une activité révisionniste qui prendra les formes les plus diverses. La qualité des travaux entrepris s'en ressent et il faut reconnaître que le résultat est inégal. De ce point de vue, on peut dire qu'il reste encore beaucoup à faire. Le simple amateur côtoie l'érudit, et l'homme d'action, le cher­cheur dans ses archives. Je ne donnerai pas ici de noms par crainte de cataloguer chacun de ces individus [52].

Sur la manière de mener le combat révisionniste, il va de soi que les révisionnistes se partagent entre partisans et adversaires d'une sorte de réalisme politique. La plupart estiment que, face à la puissance du tabou, mieux vaut procéder par des voies obliques et ne pas heurter de front les tenants de l'orthodoxie. Pour ces révisionnistes-là, il est maladroit et imprudent de lancer, par exemple, que l'« Holocauste » est un mythe ; mieux vaut, selon eux, insinuer que l'« Holocauste » a bel et bien existé mais non dans les proportions généralement admises. Epris de stratégie ou de tactiques, ces révisionnistes chercheront à ménager les susceptibilités juives et suggéreront, à tort, que la partie légendaire de l'« Holocauste » est surtout imputable aux communistes ou aux Alliés mais non aux juifs, ou si peu. Ne voit-on pas des apprentis révisionnistes pratiquer le fallacieux amalgame qui consiste à présenter les juifs comme victimes, au même titre que les autres, d'une sorte de croyance universelle erronée ? Les juifs se seraient vus obli­gés, en quelque sorte par une force immanente, de croire au génocide et aux chambres à gaz, cependant, sans doute, que la même force les pousserait à réclamer encore et plus d'argent pour réparation de souf­frances fictives [53]. Un juif errant viendra-t-il à passer dans le camp révisionniste, on lui fera fête comme au plus pur génie du révision­nisme. Reprendra-t-il à son compte, et maladroitement, les découvertes de ses prédécesseurs non juifs sur Auschwitz, on saluera en ce nouveau venu un phare de la pensée scientifique.

J'admets certaines formes de ce réalisme politique mais à la con­dition qu'il ne s'accompagne pas d'arrogance. Il n'y a nulle supériorité, ni intellectuelle ni morale, à penser que la fin justifie les moyens et qu'il faut bien parfois emprunter à l'adversaire les armes de la dissimu­lation et du mensonge. Mais, personnellement, ma préférence va à un révisionnisme sans complexes et sans trop de compromissions. On déclare la couleur. On marche droit au but. Seul, s'il le faut. On ne ménage pas l'adversaire. D'ailleurs, une bien longue expérience du combat révisionniste me donne à penser que la meilleure stratégie, la meilleure tactique peuvent consister en une succession d'attaques fron­tales ; l'adversaire ne s'y attendait pas ; il s'imaginait qu'on n'aurait jamais l'audace de le défier ainsi ; il découvre qu'il ne fait plus peur ; il en est décontenancé.

Un conflit sans fin

Les révisionnistes ont cent fois proposé à leurs adversaires un débat public sur le génocide, les chambres à gaz et les six millions. Les organisations juives se sont toujours dérobées à cette proposition. La preuve est maintenant faite qu'elles ne l'accepteront pas. Au moins l'Eglise catholique admet-elle aujourd'hui une forme de dialogue avec les athées mais la Synagogue, elle, n'oubliera pas l'offense qui lui a été faite [54] et ne se résoudra jamais à courir le risque d'un tel dialogue avec les révisionnistes. Par ailleurs, trop d'intérêts politiques, finan­ciers et moraux sont en jeu pour que, de leur côté, les responsables de l'État d'Israël ou de la Diaspora acceptent d'entamer un pareil débat sur la version casher de l'histoire de la seconde guerre mondiale.

L'épreuve de force continuera donc. Je ne lui vois pas de fin. Le conflit auquel nous assistons entre « exterminationnisme » et « révi­sionnisme », c'est-à-dire entre, d'une part, une histoire officielle, figée, sacrée et, d'autre part, une histoire critique, scientifique, profane, s'inscrit dans la lutte sans fin que se livrent dans les sociétés hu­maines, depuis des millénaires, la foi et la raison ou la croyance et la science. La foi en l'« Holocauste » ou Shoah fait partie intégrante d'une religion, la religion hébraïque dont, à y regarder de près, les fantas­magories de l'« Holocauste » ne sont qu'une émanation. On n'a jamais vu une religion s'effondrer sous les coups de la raison. Ce n'est pas demain que disparaîtra la religion juive avec l'une de ses composantes les plus vivaces. Selon les interprétations en cours, cette religion est vieille de mille cinq cents ans ou bien de trois, sinon de quatre, mille ans. On ne voit pas pourquoi les hommes de l'an 2000 bénéficieraient du privilège d'assister en direct au naufrage d'une religion qui remonte à des temps aussi anciens.

On entend parfois dire que le mythe de l'« Holocauste » ou de la Shoah pourrait un jour s'effacer comme s'est effondré il n'y a guère le communisme stalinien ou comme s'effondreront un jour prochain le mythe sioniste et l'État d'Israël. C'est comparer ce qui n'est pas compa­rable. Communisme et sionisme reposent sur des bases fragiles ; tous deux présupposent chez l'homme de hautes aspirations qui sont large­ment illusoires : le désintéressement généralisé, le partage à égalité entre tous, le sens du sacrifice, le travail au profit de tous ; leurs emblèmes sont, dans un cas, la faucille, le marteau et le kholkoze et, dans l'autre cas, l'épée, la charrue et le kibboutz. La religion juive, elle, sous les dehors alambiqués de la massore ou du pilpoul, ne plane pas dans ces rêveries ; elle vise bas pour viser juste ; elle table sur le réel ; sous le couvert d'extravagances talmudiques et de prestidigi­tations intellectuelles ou verbales, on voit qu'elle a surtout partie liée avec l'argent, le roi-dollar, le Veau d'Or et les blandices de la société de consommation. Qui peut croire que ces valeurs-là perdront un jour prochain de leur pouvoir ? Et, par ailleurs, comment la disparition de l'État d'Israël entraînerait-elle de néfastes conséquences pour le mythe de l' « Holocauste » ? Au contraire, des millions de juifs, forcés de gagner ou de regagner les pays riches de l'Occident, ne manqueraient pas de crier au « Second Holocauste » et, à nouveau et encore plus fort, accu­seraient le monde entier de cette nouvelle épreuve imposée au peuple juif, qu'il faudrait alors « dédommager ».

Enfin, la religion juive ― on ne le voit que trop avec les récits de l' « Holocauste » ― s'ancre dans ce qu'il y a peut-être de plus profond en l'homme : la peur. Là est sa force. Là est sa chance d'une survie malgré tous les aléas et malgré les coups de boutoir portés contre ses mythes par le révisionnisme historique. En jouant avec la peur, les religion­naires juifs gagnent à tous les coups.

Je souscris au constat du sociologue et historien Serge Thion [55] pour lequel « le révisionnisme historique, qui a gagné toutes les batailles intellectuelles depuis vingt-cinq ans, perd tous les jours la guerre idéologique. Le révisionnisme se heurte à l'irrationnel, à une pensée quasi religieuse, au refus de prendre en considération ce qui provient d'un pôle non juif ; nous sommes en présence d'une sorte de théologie laïque dont Elie Wiesel est le grand prêtre international consacré par l'attribu­tion d'un prix Nobel ».

L'avenir entre répression et Internet

Les nouveaux venus du révisionnisme ne devront pas se bercer d'illusions. Leur tâche sera rude. Le sera-t-elle moins que pour Paul Rassinier et ses successeurs les plus directs ? La répression sera-t-elle moins féroce ?

Personnellement, j'en doute. Cependant, dans le monde, le chan­gement des équilibres politiques et des techniques de la communication donnera peut-être aux minorités la chance de se faire mieux entendre que dans un récent passé. Grâce à Internet, pour les révisionnistes la censure sera peut-être plus facile à déjouer et les sources d'information historiques deviendront sans doute plus accessibles.

Il reste qu'en cette fin de siècle et de millénaire l'homme est appelé à vivre l'étrange expérience d'un monde où livres, journaux, radios et chaînes de télévision sont, plus que jamais, étroitement contrôlés par le pouvoir de l'argent ou par la police de la pensée alors que, parallèlement, se développent, à vitesse accélérée, de nouveaux moyens de communication qui échappent, en partie, à tout contrôle. On croirait un monde à deux faces : l'une se fige et vieillit, l'autre a l'insolence de la jeunesse et regarde vers l'avenir. Le même contraste s'observe dans la recherche historique, celle du moins que surveille la police de la pensée : d'un côté, les historiens officiels, qui multiplient les ouvrages sur l' « Holocauste » ou la Shoah, s'enferment dans le domaine de la croyance religieuse ou de la ratiocination en vase clos tandis que, de l'autre côté, des esprits indépendants s'efforcent de n'observer que les préceptes de la raison et de la science ; grâce à ces derniers, la libre recherche historique manifeste, notamment sur Inter­net, une impressionnante vitalité.

Les tenants d'une histoire officielle protégée et garantie par la loi seront, pour toujours, condamnés à trouver devant eux les contestataires d'une vérité d'office. Les uns ont, avec l'âge, le pouvoir et l'argent ; les autres, un véritable avenir.

Une répression qui s'aggrave

S'il est un point sur lequel le présent ouvrage peut apporter au­tant d'information aux révisionnistes qu'aux antirévisionnistes, c'est celui de la répression que subissent les premiers par le fait des seconds.

Chaque révisionniste est payé pour savoir ce qu'il lui en coûte de s'exprimer sur un sujet tabou mais il n'a pas toujours conscience de ce que subissent à la même heure ses pareils en d'autres pays que le sien. Les antirévisionnistes, de leur côté, minimisent systématiquement l'ampleur de leurs actions répressives ; ils n'ont de pensée que pour leurs propres tourments, comparables à ceux de Torquemada et des Grands Inquisiteurs : il leur faut frapper, toujours frapper ; leur bras se fatigue, les crampes leur viennent, ils souffrent, ils gémissent ; ils trouvent que, s'il est des hommes à plaindre, ce sont les bourreaux ; ils se bouchent les yeux et les oreilles pour éviter de voir et d'entendre toutes leurs victimes. Parfois même, ils s'étonnent, peut-être de bonne foi, quand on leur présente la liste des révisionnistes qu'ils sont parve­nus à briser dans leur vie personnelle, familiale ou professionnelle, à ruiner, à accabler d'amendes ou de peines de prison, à grièvement bles­ser, à vitrioler, à tuer, à pousser au suicide, cependant qu'à l'inverse on ne saurait produire un seul cas où un révisionniste aurait touché ne fût-ce qu'un cheveu de l'un de ses adversaires.

Il faut dire que la presse s'emploie à dissimuler le plus possible certains effets de cette répression généralisée. En France, le journal Le Monde s'est fait sur ce chapitre une spécialité, comme on le verra, de passer sous silence certaines abominations qui, si des juifs antirévi­sionnistes à la Vidal-Naquet en avaient été les victimes, auraient sus­cité, sur toute la surface du globe, défilés de protestation et manifesta­tions en tous genres.

Le mieux qu'on puisse attendre des apôtres de la Shoah sera, tout au plus, une mise en garde contre des excès d'antirévisionnisme qui pourraient causer du tort à la bonne renommée des juifs et à la cause sacrée de la Shoah.

Dans le flot des toutes dernières mesures de répression prises contre les révisionnistes, on notera, pour la France, la révocation de l'Education nationale de Michel Adam, qui enseignait l'histoire et la géographie dans un collège de Bretagne ; à cinquante-sept ans, avec cinq enfants à charge, il se retrouve sans la moindre ressource et même, pour l'instant, sans le revenu minimum d'insertion (RMI). Quant à Vincent Reynouard, lui aussi révoqué de l'Education nationale, il vient d'être condamné par le tribunal de Saint-Nazaire, ce 10 novembre, à trois mois de prison ferme et à dix mille francs d'amende pour avoir diffusé le Rapport Rudolf ; âgé de vingt-neuf ans, marié, père de trois jeunes enfants, il se retrouve, avec sa femme, sans la moindre ressour­ce. Toujours en France, le pasteur Roger Parmentier est exclu du Parti socialiste pour avoir apporté son soutien devant un tribunal à Roger Garaudy tandis que Jean-Marie Le Pen, lui, est mis en examen, en France comme en Allemagne, pour une déclaration anodine sur « le détail » des chambres à gaz.

A Barcelone, le 16 novembre 1998, sur plainte du Centre Simon Wiesen­thal, de SOS-Racisme-Espagne, des deux communautés israélites de la ville et du Mouvement juif libéral espagnol, le libraire Pedro Varela a été condamné à cinq ans de prison ferme pour « négation de l'Holo­causte » et « incitation à la haine raciale » par l'écrit. Il est également condamné à une amende de trente mille francs [4 500 euros] et à de lourds frais de justice. Les 20 972 livres et les centaines de cassettes qui composent le fonds de sa librairie seront détruits… par le feu. Sa librairie avait été l'objet d'attentats et d'incendies ; à plusieurs reprises, son employée ou lui-même avaient été agressés. Le Centre Simon Wiesenthal tenterait aujourd'hui d'obtenir l'annulation du doctorat en histoire accordé à Pedro Varela il y a plus de dix ans [56].

En Allemagne, on saisit et on brûle de plus en plus d'écrits révisionnistes. Gary Lauck (citoyen américain extradé par le Danemark vers l'Allemagne), Günter Deckert et Udo Walendy végètent toujours en prison et peuvent se tenir pour heureux si on ne prolonge pas leur incarcération sous le moindre prétexte. Erhard Kemper, de Münster, après un an de prison et sous la menace de nouvelles et lourdes peines qui le maintiendraient en prison probablement jusqu'à la fin de sa vie, a dû se réfugier dans la clandestinité. D'autres Allemands ou Autri­chiens vivent en exil.

Au Canada, le calvaire d'Ernst Zündel et de ses amis continue devant l'un de ces tribunaux ad hoc, dits « commissions des droits de l'homme », où se trouvent bafoués, comme à plaisir, les droits nor­maux de la défense ; par exemple, il y est interdit de plaider que ce qu'on a écrit correspond à une vérité vérifiable ; ces commissions ne se soucient pas de la vérité ; seul les intéresse le point de savoir si ce qui est écrit fait ou non de la peine à certains ! D'autres commissions spéciales, rattachées à l'Intelligence Service du Canada, prennent, dans le cas des révisionnistes étrangers vivant au Canada, leurs décisions à huis-clos sur dossier non communiqué à l'intéressé. En 1999, Ottawa adoptera une loi anti­révisionniste autorisant la police à saisir à domicile tout livre ou matériel qui pourrait, selon la police elle-même, propager le révision­nisme ; cette même loi stipulera que les tribunaux aligneront leur pratique sur celle des commissions ad hoc et ne permettront plus à l'accusé de se défendre en invoquant la vérité de ce qu'il écrit [57].

Partout dans le monde les associations juives multiplient les initiatives en vue de l'adoption d'une loi antirévisionniste spécifique. Récemment, lors d'une conférence réunie à Salonique, l'Association internationale des avocats et juristes juifs a réclamé l'instauration en Grèce d'une telle loi et a fait savoir qu'elle tiendrait des conférences identiques en plus de vingt autres pays [58].

Le devoir de résistance

Quelles que puissent être les tempêtes et les vicissitudes pré­sentes ou à venir, l'historien révisionniste doit maintenir le cap. Au culte d'une mémoire tribale fondée sur la peur, la vengeance et le lucre, il préférera la recherche obstinée de l'exactitude. De cette manière, sans même l'avoir voulu, il rendra justice aux vraies souffrances de toutes les victimes de la seconde guerre mondiale. Et, de ce point de vue, c'est lui qui évitera toute discrimination de race, de religion, de commu­nauté. Par-dessus tout, il refusera l'imposture suprême qui a couronné ce conflit : celle du procès de Nuremberg, du procès de Tokyo et de mille autres procès de l'après-guerre à l'occasion desquels, encore aujourd'hui, le vainqueur, sans avoir à rendre le moindre compte de ses propres crimes, s'arroge le droit de poursuivre et de condamner le vaincu.

Contrairement à la vision romantique de Chateaubriand, l'histo­rien n'est nullement « chargé de la vengeance des peuples » et, encore moins, de la vengeance d'un peuple qui se prétend élu de Dieu.

Sur quelque sujet que ce soit, l'historien en général et l'historien révisionniste en particulier n'ont pas d'autre mission que de vérifier si ce qu'on dit est exact. Il s'agit là d'une mission élémentaire, évidente, mais ― l'expérience l'enseigne ― périlleuse.

3 décembre 1998

Notes

------------------------------------------------------------------------

[1] Ces mots sont de Karl Schlögel, prenant la défense de Gabor Tamas Ritter­sporn accusé par Maxime Leo (Berliner Zeitung, 12 février 1998) d'avoir apporté son soutien à la liberté d'expression de Robert Faurisson en 1980 (« Eine Jagdpartie. Wie man einen Wissenschaftler ruiniert », Frankfurter Allgemeine Zeitung, 18 février 1998, p. 42).

[2] « En juillet 1981, la Knesset vota une loi interdisant la négation du Génocide : "La diffusion, écrite ou orale, d'œuvres niant les actes commis durant la période du régime nazi ― crimes contre le peuple juif, crimes contre l'humanité ― ainsi que les propos minimisant l'importance de ces actes dans le but de défendre ceux qui les ont perpétrés, et le soutien ou l'identification aux coupables sont passibles de cinq ans d'emprisonnement". Une proposition d'élever la peine à dix ans de prison fut rejetée. Ainsi l'extermination des Juifs ne constituait plus un sujet de recherche historique ; cet événement avait été, en quelque sorte, extrait de l'Histoire elle-même, et il était deve­nu un dogme national, protégé par la loi, jouissant d'un statut juridique similaire à celui de la croyance religieuse, plus élevé même : la peine maximale pour "grossièreté" à l'égard de la sensibilité ou de la tradition religieuse ― y compris sans doute la négation de l'existence de Dieu ― est d'un an de prison » (Tom Segev, Le Septième Million. Les Israéliens et le Génocide, p. 535).

[3] Bulletin quotidien d'informations de l'Agence télégraphique juive, 2 juin 1986, p. 1, 3.

[4] Voy. Robert Maxwell, « J'accuse » [en français dans le texte], Sunday Mirror (Londres), dont il fut le propriétaire, 17 juillet 1988, p. 2.

[5] Les « bébés juifs [étaient] jetés tout vivants dans les crématoires » (Pierre Weil, directeur de la SOFRES, « L'anniversaire impossible », Le Nouvel Observateur, 9 février 1995, p. 53).

[6] « Il est d'ailleurs intéressant […] de souligner que le ghetto est historiquement une invention juive » (Nahum Goldmann, Le Paradoxe juif, p. 83-84) ; voy. aussi Pierre-André Taguieff, « L'identité juive et ses fantasmes », L'Expresse, 20-26 janvier 1989, p. 65.

[7] Eric Conan, « Auschwitz : la mémoire du mal », L'Expresse, 19-25 janvier 1995, p. 68.

[8] Ibid. En 1992, c'est-à-dire longtemps après la « fin des années 70 », un jeune révisionniste californien d'origine juive, David Cole, se présentera en découvreur des falsifications de la « chambre à gaz » d'Auschwitz-I. Dans une médiocre vidéo, il montrera, d'une part, la version des guides du musée (cette chambre à gaz est au­thentique) et, d'autre part, la version d'un responsable du musée, Franciszek Piper (cette chambre à gaz est « very similar » [très semblable] à l'originale). Jusque-là rien de nouveau. L'ennui est que D. Cole et ses amis ont ensuite fortement exagéré ― pour ne pas dire plus ― quand ils sont venus prétendre que F. Piper avait reconnu qu'il y avait eu « fraude ». Effectivement, il y avait eu fraude mais malheureusement D. Cole n'avait pas su le démontrer parce qu'il connaissait mal le dossier révisionniste. Il aurait pu définitivement confondre F. Piper en lui montrant, à la caméra, les plans originaux que j'avais découverts en 1975/1976 et publiés « à la fin des années 70 ». On y voit fort bien que l'actuelle prétendue « chambre à gaz » est la résultante d'un certain nombre de maquillages du lieu auxquels on a procédé après la guerre. Par exemple, les quatre prétendus « orifices de déversement du Zyklon B » pratiqués dans le plafond ont été percés ― très grossièrement et très maladroitement ― après la guerre : les fers à béton ont été brisés par les communistes polonais et laissés en l'état.

[9] R.J. van Pelt et D. Dwork, Auschwitz. 1270 to the Present, p. 363-364, 367, 369.

[10] J.-C. Pressac, « Enquête sur les chambres à gaz » in Auschwitz, la Solution finale, collections de L'Histoire n° 3, octobre 1998, p. 41.

[10 bis] Arno Mayer, La « Solution finale » dans l'histoire, Paris, La Découverte, 1990, p. 406. L'édition originale, américaine, porte : « Sources for the study of the gas chambers are at once rare and unreliable », The « Final Solution » in History, p. 362 ; unreliable signifie non fiable[s].

[11] Jacques Baynac dans Le Nouveau Quotidien (de Lausanne), 2 septembre 1996, p. 16, et 3 septembre 1996, p. 14 ; voy., auparavant, Jacques Baynac et Nadine Fresco, « Comment s'en débarrasser ? », Le Monde, 18 juin 1987, p. 2.

[12] On a parfois soutenu que le chiffre de six millions trouvait sa source dans un article de journal de… 1919 : Martin H. Glynn (ancien gouverneur de l'État de New York), « The Crucifixion of Jews Must Stop! », The American Hebrew, 31 octobre 1919, p. 582. Ledit M. H. Glynn lançait un appel de fonds en faveur de six millions de juifs euro­péens qui, disait-il, étaient affamés et persécutés et vivaient ainsi un « holo­caus­te », une « crucifixion ». Le mot d'« holocauste » dans son acception de « désastre » est attesté en anglais dès le XVII^e^siècle ; ici, en 1919, il désignait les conséquences d'une famine décrite comme un désastre menaçant. En 1894, Bernard Lazare appli­quait le mot aux massacres de juifs : « …de temps en temps, rois, nobles ou bourgeois offraient à leurs esclaves un holocauste de juifs […] on offrait des juifs en holo­causte » (L'Anti­sémitisme, son histoire et ses causes, p. 67, 71).

[13] « Till now six times a million Jews from Europe and Russia have been des­troyed », Lucy S. Dawidowicz, dans une compilation, A Holocaust Reader, p. 327 ; il s'agit de lettres traduites de l'hébreu et publiées à New York en 1960 sous le titre de Min hametzar.

[14] Je suis redevable de cette découverte à l'historien allemand Joachim Hoff­mann ; dans Stalins Vernichtungskrieg 1941-1945, p. 161 et n. 42 de la p. 169, il signa­le qu'Ilia Ehrenbourg donne ce chiffre dans un article de Soviet War News (Londres) du 4 jan­vier 1945 intitulé : « Once Again Remember ! » En cherchant à vérifier ce point à l'Impe­rial War Museum de Londres, je n'ai rien trouvé à cette date ; en revanche, j'ai trouvé le texte signalé par J. Hoffmann sous un autre titre et à une autre date : sous le titre de « Remember, Remember, Remember » et à la date du 22 décembre 1944, p. 4-5. Faudrait-il en conclure que Soviet War News était publié sous différentes formes ?

[15] Voy. « Number of Living Holocaust Survivors », Adina Mishkoff, Administrative Assistant, AMCHA, Jérusalem, 13 août 1997 (chiffres fournis par le cabinet du premier ministre israélien).

[16] La misérable et fallacieuse maquette (avec ses prétendues ouvertures pour le Zyklon dans le toit alors que de telles ouvertures, on le constate encore aujourd'hui, n'ont jamais existé, et avec ses prétendues colonnes perforées alors que les colonnes de béton, comme on peut encore le voir, étaient pleines) est reproduite dans un autre livre-guide publié en 1995 ; voy. Jeshajahu Weinberg et Rina Elieli, The Holocaust Museum in Washington, New York, Rizzo­li, p. 126-127 ; en revanche, ce livre-guide ne reproduit pas ce qui, dans le précédent livre-guide, celui de M. Berenbaum, était présenté comme la pièce à conviction par excellence des gazages homicides : une prétendue porte de chambre à gaz à Majdanek.

[17] Le Nouvel Observateur, 30 septembre 1993, p. 96.

[18] Tous les fleuves vont à la mer, p. 97.

[19] The Holocaust and History, edited by Michael Berenbaum and Abraham J. Peck.

[20] Ibid., p. 15.

[21] Voy., ci-dessus, sous l'intertitre "Succès et insuccès du révisionnisme".

[22] A propos de Timisoara, voy., dans le présent ouvrage, vol. III, p. 1141-1150, mon étude du livre de Michel Castex, Un Mensonge gros comme le siècle. Roumanie, histoire d'une manipulation.

[23] La prétendue maquette de crématoire avec « chambre à gaz » qu'on présente au Musée national d'Auschwitz et celle qu'on peut voir à l'Holocaust Memorial Mu­seum de Washington sont tellement succinctes en ce qui concerne précisément la « chambre à gaz » et tellement en contradiction avec les vestiges qu'on peut examiner sur place, à Auschwitz-Birkenau, qu'il est dérisoirement facile de prouver que ces deux maquettes sont de pures fantaisies ; voy., ci-dessus, p. XX, n. 1.

[24] Voy. Weltwoche (Zurich), 27 août et 3 septembre 1998 ; Nicolas Weill, « La mémoire suspectée de Binjamin Wilkomirski », Le Monde, 23 octobre 1998, p. V.

[25] Donald Watt, Stoker.

[26] Fred Sedel, Habiter les ténèbres.

[27] Vivre, c'est vaincre est présenté comme ayant été écrit en 1945 et imprimé au troisième trimestre de 1946. En 1988, il est réédité à grand fracas par Hérault-Edi­tions. La bande annonce porte : « J'ai été témoin de l'Holocauste ». C'est dans Le Figaro du 15 mai 1996 (p. 2) que le général Rogerie déclarera avoir « assisté à la Shoah à Birkenau ». La description, extrêmement succincte, qu'on lui a faite des « chambres à gaz » et des fours est contraire à la version aujourd'hui admise : son « témoin » lui a parlé de gaz arrivant par les pommes de douche et de fours électriques (p. 75).

[28] A. Rogerie, Vivre, c'est vaincre, p. 70, 85. ― 4. Id., p. 82. ― 5. Id., p. 83. ― 6. Id., p. 84. ― 7. Ibid. ― 8. Id., p. 87.

[29] Samuel Gringauz, « Some Methodological Problems in the Study of the Ghetto » in Jewish Social Studies / A Quarterly Journal Devoted to Contemporary and Historical Aspects of Jewish Life, Volume XII, New York, 1950, p. 65-72 ; p. 65.

[30] Op. cit., p. 148-149.

[31] They Have Their Exits, p. 172.

[32] D'un texte de plus de deux cent cinquante mots on retiendra en particulier : « Plus de douze millions de morts ! Autant d'individus qui ne sont pas nés ! Plus encore de mutilés, blessés, veuves et orphelins ! Pour d'innombrables milliards de destructions diverses. Des fortunes scandaleuses édifiées sur des misères humaines. Des innocents au poteau d'exécution. Des coupables aux honneurs. La vie atroce pour les déshéri­tés. La formidable note à payer. » Ailleurs se lit : « Il faut améliorer l'esprit des Nations en améliorant celui des individus par une instruction assainie et largement répandue. Il faut que le peuple sache lire. Et surtout comprendre la valeur de ce qu'il lit. » Le texte se termine sur : « Maudite soit la guerre. Et ses auteurs ! »

[33] Voy. Christiane Gallus, « Une pandémie qui a fait trois fois plus de victimes que la guerre de 1914-1918 », Le Monde, 31 décembre 1997, p. 17.

[34] Pierre Kaufmann, « Le danger allemand », Le Monde, 8 février 1947.

[35] Voy. Mark Weber, « Bergen-Belsen Camp : The Suppressed Story » in The Journal of Historical Review, mai-juin 1995, p. 23-30.

[36] Tel fut le cas, par exemple, de Bartley C. Crum, Behind the Silken Curtain, p. 114.

[37] Arthur Suzman & Denis Diamond, Six million did die. The truth shall prevail, p. 18.

[38] En 1945, A. Hitchcock, né en 1899, était déjà connu. Pour ses goûts macabres ou morbides, pour son art de « manipuler son public », pour l'étrange fascination que le gaz exerçait sur son esprit, on lira Bruno Villien, Hitchcock, Paris, Colonna, 1982, p. 9-10.

[39] Le Figaro, 24 octobre 1997, p. 10.

[40] The Origins of Totalitarianism, p. 446, n. 138.

[41] Le Figaro, 16 janvier 1995, p. 29.

[42] Libération, 18 décembre 1995, p. 41.

[43] Pierre Vidal-Naquet, « Le secret partagé », Le Nouvel Observateur, 21 septembre 1984, p. 80.

[44] Lettre à Nation Review, Melbourne (Australie).

[45]. « The Left, the Right and the Jews », Part II, Quadrant, Sydney (Australie), septembre 1979, p. 27.

[46] M^e^Bernard Jouanneau, La Croix, 23 septembre 1987, p. 2.

[47] Globe and Mail (Canada), 2 juin 1998, p. A1, 15. Edgar Bronfman, président du Congrès juif mondial, est l'empereur de l'alcool et de la pornographie. Il préside le groupe Seagrams et, à Hollywood, possède Universal Studios. Il vient de recevoir, d'un jury d'hommes politiques américains, la distinction du « Silver Sewer » (Egout d'argent), no­tamment pour les reality shows du juif Jerry Springer, émissions mettant en scène stripteaseuses enceintes, jeunes prostituées se battant avec leurs souteneurs, croque-morts copulant avec des cadavres, etc. (Finan­cial Times, 21-22 mars 1998, p. 2).

[48] B. Lazare, L'Antisémitisme…, première page du chapitre premier.

[49] Id., p. 27.

[50] A. Kaspi, Les Juifs pendant l'Occupation, p. 109, n. 27.

[51] J'entends parfois dire qu'il risque d'en coûter plus cher à un juif qu'à un non-juif de faire profession de révisionnisme. Les faits démentent cette assertion. Pas un juif n'a été condamné en justice pour révisionnisme, pas même Roger-Guy Dommer­gue (Polacco de Menasce) qui, depuis des années, multiplie les écrits les plus véhé­ments contre ce qu'il appelle les mensonges de ses « congénères ». Jusqu'ici on n'a osé lui appliquer ni la loi Pleven (1972) ni la loi Fabius-Gayssot (1990). Il convient toutefois de rappeler le cas du jeune révisionniste américain David Cole qui montre à quelle violence certaines organisations juives peuvent recourir afin de faire taire des juifs qui ont pris partie pour la cause révisionniste.

[52] Un chercheur indépendant, qui ne s'en réclame pourtant pas, peut indirecte­ment contribuer au révisionnisme par la simple qualité de son travail. Je donnerai ici un nom, celui de Jean Plantin, responsable d'une publication dont le titre, à lui seul, indique le caractère érudit : Akribeia ― tel est le titre de cette publication semestrielle ― signifie « exactitude », « soin minutieux » et a donné en français le mot d' « acribie » (qualité de l'érudit qui travaille avec un soin extrême). AKRIBEIA, 45/3 route de Vourles, 69230 Saint-Genis-Laval.

[53] Voy. la pertinente analyse de Guillermo Coletti, « The Taming of Holocaust Revisionism » [Apprivoiser le révisionnisme de l'Holocauste].

[54] « L'oubli n'est pas notre principale vertu » (le président du Consistoire de Tou­louse, selon Le Figaro, 9 octobre 1997, p. 10).

[55] S. Thion est, en particulier, l'auteur d'un ouvrage révisionniste qui porte le titre parlant de Une Allumette sur la banquise. Un ouvrage révisionniste, même si son contenu paraît être de la dynamite, n'apporte, en fin de compte, peut-être pas plus de clarté et de chaleur qu'une allumette « dans la nuit polaire, sur la banquise des idées gelées » (p. 90).

[56] Voy. « Un libraire espagnol condamné pour "apologie du génocide" », Le Monde, 19 novembre 1998, p. 3 ; Emmanuel Ratier, Faits & Documents, 1er décembre 1998, p. 12.

[57] Voy. « Crackdown on hate materials planned », National Post, 25 novembre 1998.

[58] Voy. Athens News, 28 juin 1998, p. 1.

Labels: "Nuremberg", Baynac, Berenbaum, Bergen-Belsen, Broszat, chambres à gaz, Churchill, Mayer, Pressac, Versailles, Vrba, Weissmandel, Wiesel, Wilkomirski
