<!-- https://robertfaurisson.blogspot.com/2013/05/il-est-temps-den-finir-avec-la-chambre.html -->

<!-- Thursday, May 30, 2013 -->

# Il est temps d’en finir avec la "chambre à gaz" du Struthof et ses 86 "gazés"

L’actualité m’oblige à revenir sur la rumeur du camp de Natzweiler-Struthof qu’on tente aujourd’hui de revivifier, une fois de plus. Déjà le 12 décembre 2005, il m’avait fallu rédiger un texte intitulé *« Résurrection d’un vieux serpent de mer : la chambre à gaz et les 86 gazés du Struthof »*. Comme mainte rumeur de guerre celle-ci a connu des versions extraordinairement variables et contradictoires mais elle a fini par se fixer sous la forme suivante : en août 1943, Josef Kramer, le commandant de ce camp situé à 50 kilomètres de Strasbourg, y aurait, en personne (!), avec de l’acide cyanhydrique exécuté dans une petite chambre à gaz, en plusieurs fournées, un total de 86 juifs, envoyés spécialement d’Auschwitz à la demande du professeur August Hirt… désireux d’enrichir sa collection de squelettes à Strasbourg !

**Or voilà plus de soixante-six ans qu’un rapport d’expertise toxicologique signée du Dr René Fabre, doyen de la Faculté de pharmacie de Paris, a pourtant établi, dans des conclusions rendues le 1^er^ décembre 1945, que ni ce local ni ces cadavres (ou restes de cadavres) ne présentaient de traces d’acide cyanhydrique ! Ainsi, à la date du 1^er^ décembre 1945, la cause était-elle entendue et les conclusions parfaitement claires : il n’y avait, en réalité, pour confirmer la rumeur de ces assassinats, ni arme (une prétendue chambre à gaz d’exécution), ni victimes (86 prétendus gazés). La rumeur n’était donc qu’une rumeur. Or l’existence de ce rapport d’expertise est obstinément passée sous silence. De quel droit ? Et comment peut-on continuer d’écrire sur cette prétendue chambre à gaz homicide et ces prétendues victimes sans tenir le moindre compte dudit rapport et même en prenant la précaution de n’en jamais nommer l’auteur ?**

## Mes découvertes du 27 mars 1980

Puisqu’en réalité le crime n’a pas été commis, deux mystères se dissipent d’un même coup. Jusque là, en effet, on se demandait par quel mystère, à la fin de 1944, décidant d’abandonner le camp du Struthof, les Allemands n’avaient pas pris le soin de faire disparaître l’arme du crime et par quel autre mystère, à Strasbourg, le Dr Hirt avait pu laisser sur place les cadavres de ses victimes. La clé de ces deux « mystères » réside, on le voit grâce à l’expertise Fabre, dans le fait que cette arme prodigieuse et ces victimes d’un crime abominable n’ont tout simplement pas existé. Cette expertise nous explique également un troisième mystère : le fait qu’après la guerre, lors des procès dits des médecins du Struthof (à Metz en 1952 et à Lyon en 1954), les tribunaux français n’ont — apparemment — pas condamné cette « horreur nazie » qui, si elle s’était vraiment produite, aurait été le crime majeur du Struthof. Il me faut dire « apparemment » parce que, n’ayant pu, malgré ma demande écrite, avoir accès aux dossiers mêmes des procès, j’ai dû me limiter 1) d’abord aux comptes rendus de presse de ces procès, 2) puis aux dires de trois avocats consultés (dont M^e^ Albert Naud et M^e^ Raymond Geouffre de la Pradelle) et, enfin, 3) aux ouvrages portant sur le Struthof. **En revanche, j’ai pu avoir accès, dans des circonstances que j’exposerai ci-dessous, à certains épais dossiers de la Gendarmerie et de la Justice militaire concernant ce camp. Et là, le 27 mars 1980, j’ai fait, en la présence de trois personnes qui m’accompagnaient dans mon enquête, une double découverte : 1) un document signé de deux professeurs de médecine (Piédelièvre et Simonin) et d’un médecin (Fourcade) attestait de l’existence et des conclusions négatives de l’expertise Fabre ; 2) en revanche, l’expertise Fabre elle-même allait rester INTROUVABLE dans l’intégralité des dossiers consultables.**

Aujourd’hui et depuis la fin des années 1990 on constate chez les historiens, mais non dans les médias et dans le grand public, que les chambres à gaz nazies sont en voie de raréfaction ou de disparition. La foi n’y est plus (voyez, à ce propos, mes observations in [« Les chambres à gaz et *Le Monde* en perdition »](http://robertfaurisson.blogspot.it/2012/09/les-chambres-gaz-et-le-monde-en.html) et [« Serge Klarsfeld : à Auschwitz 1000 juifs déportés de France ont été gazés… au lit ! »](http://robertfaurisson.blogspot.it/2012/12/serge-klarsfeld-auschwitz-1000-juifs.html)). Certes des historiens affirment encore, çà et là, la présence de chambres à gaz nazies à Auschwitz ou ailleurs et ils continuent d’employer les mots de « gazer », « gazages » ou « gazés » mais comme par convention et pur automatisme de langage. Ils ne s’attardent plus au sujet, ils l’esquivent. A telle enseigne que, vers la fin de ces années 1990, la mode de « la Shoah par gaz » a paru céder le pas à la mode de « la Shoah par balles » mais cette dernière invention, due au Père Patrick Desbois (un sacré farceur !), a commencé, elle aussi, à perdre de son lustre.

## En 2005 et 2009, l’historien Robert Steegmann cautionne la thèse officielle

À ce peu de foi des historiens en la chambre à gaz nazie on note une exception : celle de Robert Steegmann, historien du Struthof. Sa « chambre à gaz », il est vrai, ne mesure pas même 9m² mais, c’est égal, elle lui suffit. Notre historien s’y attache et en défend encore l’existence et l’authenticité au contraire, par exemple, de ses collègues qui, même dans le cas d’Auschwitz, n’osent plus prétendre qu’on possède des preuves physiques de l’existence et du fonctionnement de prétendues chambres à gaz homicides (voy. sur Robert Jan van Pelt : [« Les Victoires du révisionnisme (suite) »](http://robertfaurisson.blogspot.it/2011/09/les-victoires-du-revisionnisme-suite.html)). Dans deux gros livres savants qu’il a consacrés au Struthof en 2005 (*Struthof,* Strasbourg, La Nuée bleue, 496 p.) et en 2009 (*Le camp de Natzweiler-Struthof,* Paris, Seuil, 379 p.) R. Steegmann a parlé de cette « chambre », et même non sans insistance dans le premier de ces deux ouvrages. Mais il nous cache l’arme du crime, obstinément : il ne nous en montre aucune photo, aucun dessin technique, aucune étude technique ou scientifique ! Ce premier ouvrage contenait pourtant (page de couverture et page de « quatrième de couv’ » comprises) près de quarante photos et, dans le second ouvrage, il nous est dit que « Seul le bâtiment de la chambre à gaz reste fermé [aux visiteurs] » (p. 354), ce qui aurait dû inciter l’auteur à nous la montrer en photo. Enfin, à l’instar de ses prédécesseurs, il nous gratifie de l’horrifique histoire du Dr Hirt, de sa commande de juifs à Auschwitz et du gazage de ces juifs au Struthof.

## Remise en cause de la thèse officielle

Personnellement, j’ai autrefois beaucoup traité de cette « chambre à gaz » du Struthof, que j’ai pu examiner en 1974, avant de revenir sur les lieux en 1978 avec M^e^ Eric Delcroix et d’autres témoins. J’en ai publié des photographies et j’en ai souvent rappelé aussi bien la légende que la vérité. En 1980, Serge Thion a fidèlement reproduit un grand nombre de mes écrits sur le sujet dans *Vérité historique ou vérité politique ? / Le dossier de l’affaire Faurisson / La question des chambres à gaz,* Paris, La Vieille Taupe. Voyez les pages 26, 61, 78, 82, 86, 89, 101, 104, 108-109, 111, 123, 173, 185, 207 (n.), 312-313, 335. C’est à la page 312 que figurent deux photographies qui, à elles seules, montrent l’absurdité de la thèse d’un gazage dans un pareil local : l’acide cyanhydrique étant ce qu’il est, le gazeur immanquablement se serait gazé du fait de l’absence 1) d’une isolation draconienne, 2) d’une porte d’acier à volant comme on en voit aux sous-marins, 3) de ventilateurs orientables, 4) d’un puissant extracteur et d’un barboteur ou neutralisateur du gaz à évacuer. Auparavant, j’avais effleuré le sujet dans une [lettre au *Monde* (16 janvier 1979, p. 13)](http://robertfaurisson.blogspot.com/1979/01/lettre-de-robert-faurisson-publiee-par.html) ; cette lettre était ensuite reproduite dans mon *Mémoire en défense contre ceux qui m’accusent de falsifier l’histoire,* Paris, La Vieille Taupe, 1980, p. 83-88. J’y faisais la remarque qu’à l’instar de toutes les autres prétendues chambres à gaz nazies, soit « à l’état d’origine », soit à l’état de ruines, celle du Struthof n’avait fait l’objet juste au lendemain de la guerre d’aucune expertise criminelle complète. Mais, par la suite, comme je viens de le dire ci-dessus, le 27 mars 1980, j’allais découvrir 1) que la « chambre à gaz » du Struthof avait bel et bien fait l’objet d’une expertise en bonne et due forme ; 2) que les conclusions de ladite expertise avaient été négatives ; 3) que le texte de cette expertise avait certes disparu mais que son existence était attestée par trois experts sinon en toxicologie, du moins en médecine légale.

Pendant des années je suis inlassablement revenu sur le sujet mais on n’a jamais répondu ni à la nouvelle de ma triple découverte, ni à mes arguments, ni à mes questions ; mieux, on a fait comme si le professeur René Fabre n’avait jamais rédigé d’expertise. Dans les seuls quatre premiers volumes de mes *Ecrits révisionnistes,* le nom du professeur apparaît aux pages 177, 232, 253, 395, 519, 879, 1060, 1230, 1399, 1552-1553, 1576, 1682 tandis que le nom du Struthof apparaît en une soixantaine de pages répertoriées dans l’index. C’est dans le volume VI, à la date du 12 décembre 2005, aux pages 87-88, que j’ai reproduit mon article sur la « Résurrection d’un vieux serpent de mer ».

## En 2013 *Le Monde* relance la thèse officielle !

En avril 2013, le serpent de mer (en jargon de presse, « le marronnier ») a fait sa réapparition. A cette occasion, c’est avec empressement que la presse française a tenté de nous resservir la rumeur du Struthof. C’est ainsi que, dans son supplément « Télévisions » (28-29 avril 2013, p. 9), *Le Monde* en est venu à publier un article signé de Jean-Baptiste de Montvalon pour nous annoncer que, le lundi 29 avril, *France 3* diffuserait un documentaire de 55 minutes : « Au nom de la race et de la science / Quand les nazis voulaient garder trace des juifs qu’ils exterminaient » : tels étaient le titre et le sous-titre de l’article dont voici un extrait :

> Une mission est envoyée [en 1943] à Auschwitz pour y choisir 115 personnes. Leurs caractéristiques sont adressées à Hirt, qui en retient 87. Parce que des cadavres risqueraient d’être endommagés lors du transport, les juifs sont convoyés jusqu’au bloc 13 du camp du Struthof, en Alsace. Afin de leur rendre une apparence physique convenable, ils y sont correctement nourris. Pendant ce temps une petite chambre à gaz est aménagée dans une ancienne salle des fêtes, située à 800 mètres de là. Un soir d’août 1943, tous y sont conduits, en quatre groupes distincts. Une femme se révolte, elle est abattue ; son corps sera écarté de la « collection ». – Le 1er décembre 1944, ce sont donc 86 corps – 16 cadavres restés entiers, les autres mutilés et méconnaissables – qui sont découverts par les Alliés dans des cuves d’alcool au sous-sol de l’Institut d’anatomie de l’université du Reich de Strasbourg. Pour des raisons restées mystérieuses, Hirt n’a rien fait de sa ‘collection’ une fois qu’elle fut constituée. Sauf tenter de maquiller le crime, pour ensuite le nier.

En 1979, la LICA (LICRA), à laquelle allaient se joindre huit autres associations, m’avait intenté un vaste procès pour un « dommage à autrui » causé, disait-elle, « par falsification de l’histoire » parce que, dans *Le Monde* et ailleurs, j’avais conclu à l’époque, au terme d’une longue et méticuleuse enquête, que les prétendues chambres à gaz hitlériennes (au Struthof ou ailleurs) et le prétendu génocide des juifs formaient un seul et même mensonge historique. On n’imagine plus aujourd’hui combien cette conclusion avait pu indigner même des historiens chevronnés ; les temps ont changé et, notamment grâce à Internet, il y a « de l’eau dans le gaz » et « du mou dans la corde à nœuds ». La LIC[R]A était partie à la bataille flamberge au vent et sûre de sa victoire. Il lui avait vite fallu déchanter. Deux avocats juifs, dont Robert Badinter, étaient revenus quasiment bredouilles d’une mission en Pologne et en Israël où ils étaient allés chercher des preuves de l’existence de chambres à gaz nazies : abondantes en quantité, les pièces collectées se révélaient d’une si mauvaise qualité qu’elles allaient, en décembre 1982, faire publiquement, devant la première chambre de la cour d’appel de Paris, section A, le désespoir de M^e^ Bernard Jouanneau, le coryphée de la LIC[R]A. Décidant d’une initiative qui allait se retourner contre eux, mes adversaires avaient alors demandé aux autorités compétentes le droit d’accéder aux pièces judiciaires relatives au camp du Struthof et détenues au Blanc (Indre) par la Direction de la Gendarmerie et de la Justice militaire. Ils en ignoraient le contenu mais comptaient sur la Providence pour leur faire découvrir dans un monceau de documents la preuve qu’au moins au Struthof il avait existé et fonctionné une chambre à gaz nazie. L’accès à ces documents leur fut accordé et, par voie de conséquence, il nous fut également accordé. Au Palais de justice de Paris, du 27 mars au 5 juin 1980, en huit longues séances de consultation, sous la surveillance, passablement relâchée, d’une fonctionnaire, nous eûmes la possibilité, M^e^ Eric Delcroix, moi-même et deux autres personnes nous accompagnant, de découvrir un certain nombre de pièces qui allaient nettement renforcer les conclusions révisionnistes. Les photocopies étant interdites, il nous fallut prendre des notes. Dès le premier jour et dès mon examen du premier dossier, je tombai sur ce que nous allions appeler entre nous « le pot aux roses » et qui n’était autre que la double conclusion du rapport Fabre. Comme nous allions malheureusement le constater par la suite, le texte du rapport resterait, jusqu’au bout, introuvable. Sa disparition était-elle ancienne ou récente ? Ce singulier et précieux rapport avait-il, comme par hasard, disparu l’avant-veille de notre propre première consultation, c’est-à-dire le 25 mars 1980, jour où Georges Wellers, pour le compte de la LIC[R]A, s’était vu accorder le privilège d’ouvrir la série des consultations ?

## Les conclusions négatives de l’expertise du professeur René Fabre

Toujours est-il que nous disposions heureusement là de la preuve circonstanciée que René Fabre avait conclu son enquête de manière doublement négative. Le même carton n° 1 contenait, en effet, un « Document 96/B » consistant en un « rapport d’expertise » des Professeurs et Docteurs Piédelièvre (Paris) et Simonin (Strasbourg) ainsi que du Docteur Fourcade (Strasbourg). Ce rapport concernait 1) au Struthof, la « chambre à gaz » que, curieusement, *les Allemands n’avaient pas pris la peine de détruire* ; 2) à l’Hôpital civil de Strasbourg, les cadavres ou restes de cadavres que, non moins curieusement, *les Allemands n’avaient pas pris le soin de faire disparaître*. Pourtant, l’évacuation du camp ne s’était pas faite dans la précipitation : elle avait commencé au début de 1944 et les Américains n’étaient arrivés que le 25 novembre ; pour ne prendre que son exemple, le professeur Hirt, comme normalement en temps de guerre, avait fait détruire des documents par sa secrétaire avant de quitter la place (Steegmann, 2009, p. 327). Dans leur rapport les trois experts (qui n’étaient pas des toxicologues et que décevaient les conclusions du prestigieux toxicologue R. Fabre) écrivaient :

> Recherches toxicologiques. Inventaire des bocaux adressés à l’expert toxicologue, M. le Professeur FABRE de la Faculté de Pharmacie de Paris. – Bocaux W. Produit de raclage du mur extérieur de la chambre à gaz, autour de la cheminée. – Bocaux X. Plâtras provenant de la cheminée extérieure de la chambre à gaz au moment de son enlèvement (p. 52). Recherches toxicologiques. Les prélèvements de sang, de viscères faits au cours des autopsies ont donné lieu, de la part du professeur FABRE, à des recherches toxicologiques. – De son rapport, daté du 1er décembre 1945, nous reproduisons les conclusions : « Dans les viscères conservés dans le liquide conservateur (alcool + formol) et remis aux fins d’analyse, il n’a pas été décelé de toxiques volatils, et particulièrement d’acide cyanhydrique ». – Il convient de rappeler que ce toxique n’aurait pu, d’après les essais préliminaires, être décelé que s’il avait été présent à une dose supérieure à 6 milligrammes dans la prise d’essais (p. 61). [Donnant ensuite leur opinion, les trois médecins ajoutaient en guise de commentaire :] Les conclusions négatives du rapport d’expertise du professeur FABRE ne s’inscrivent pas en faux contre la possibilité et même la grande probabilité de l’intoxication par l’acide cyanhydrique (p. 67).

Notons que cette dernière affirmation, où il n’était question que de « possibilité » ou de « grande probabilité » et non de « certitude », ne faisait l’objet d’aucune ébauche de justification de la part des trois médecins. Lors du procès que m’avaient intenté la LIC[R]A et huit autres associations, ma découverte du 27 mars 1980 allait mettre mes adversaires dans l’embarras et, je suppose, contribuer à l’hommage que les magistrats de la cour d’appel devaient par la suite rendre à la qualité de mes recherches sur la question générale des chambres à gaz nazies. De toute façon, une quantité importante de faits que j’avais rapportés dans mes nombreux écrits sur le sujet rendait totalement impossible, en particulier sur le plan physique, l’existence en ce lieu d’une chambre à gaz d’exécution à l’acide cyanhydrique. Je renvoie également là-dessus aux constats que j’ai pu faire aux États-Unis sur l’effroyable complexité et l’extrême dangerosité de [l’exécution d’un seul condamné au moyen précisément de ce gaz](http://robertfaurisson.blogspot.it/1994/02/les-chambres-gaz-des-penitenciers.html). Au procès, mes adversaires ont, dans la pratique, d’eux-mêmes renoncé à invoquer l’argument de la « chambre à gaz » du Struthof. Le cours de ce procès a si manifestement tourné en ma faveur qu’aux audiences mêmes nos adversaires n’ont rien pu exploiter de ces archives dont, pour ma part, j’ai personnellement tiré le plus grand profit. D’où [la conclusion formulée, le 26 avril 1983](http://robertfaurisson.blogspot.com/1983/04/communique-texte-de-larret-du-26-avril.html), par la première chambre de la cour d’appel (président François Grégoire), conclusion qui, dans le langage du profane, pouvait se résumer en ces termes : sur le chapitre des chambres à gaz nazies il n’y a dans les recherches de M. Faurisson ni légèreté, ni négligence, ni ignorance délibérée, ni mensonge ; en conséquence tout le monde (experts, historiens et public réunis) doit avoir le droit d’affirmer éventuellement comme M. Faurisson que les chambres à gaz nazies n’ont pas existé. Certes, je fus condamné mais, si l’on peut ainsi résumer ce fameux arrêt, si clair et ferme dans sa première partie et si confus dans la seconde, il semble qu’aux yeux des magistrats de la cour, en dépit du caractère impeccable de mon travail sur les chambres à gaz nazies, je m’étais rendu coupable de malveillance.

## Au-delà de deux générations on ne peut persister dans un mensonge de ce calibre

La Faculté de pharmacie de Paris compte depuis longtemps une salle qui porte le nom de René Fabre (1889-1966) et qu’orne un buste de l’honorable doyen mais, dans le répertoire des œuvres de ce dernier, consultable à la Bibliothèque interuniversitaire de pharmacie, 4, avenue de l’Observatoire à Paris (VI^e^), le texte de son rapport d’expertise est absent. De ce rapport il a dû exister plus d’un exemplaire. Aujourd’hui que ressurgit l’affaire du Struthof, **il convient plus que jamais d’entreprendre des recherches pour retrouver un exemplaire du rapport disparu**. Je mesure la gravité du dilemme devant lequel vont se trouver les historiens qui ont jusqu’ici soutenu la thèse officielle et j’imagine la confusion des associations et des autorités qui ont demandé ou décidé l’inscription de la chambre à gaz du Struthof sur la liste des monuments historiques. Mais on ne peut persister dans un mensonge qui, avec l’arrivée d’une troisième génération, devient de plus en plus fragile. De 1941 à 1944, le Struthof a été le témoin des souffrances des uns, puis, de 1945 à 1948, le témoin des souffrances des autres (appelés « collabos »). Ramené à son authenticité il constitue un emblème, parmi tant d’autres, des vraies horreurs et des vraies souffrances de la guerre et de la guerre civile. Voilà qui devrait suffire.

## Le cas personnel de R. Steegmann

Quant à R. Steegman, qui écrivait au sujet de son ouvrage de 2009 : « Ce livre est le résultat d’un travail long de près de vingt années » (p. 375) et qui manifestement connaît toutes les pièces du dossier, on aimerait qu’il accepte de répondre aux questions suivantes :

1\) Pourquoi avoir totalement passé sous silence l’existence du rapport Fabre et de ses conclusions négatives ?

2\) Pourquoi avoir mentionné les médecins Piédelièvre, Simonin et Fourcade mais non ce qu’ils ont dit du rapport Fabre (Steegmann, 2005, p. 313-316, ainsi que les notes 1261 à 1264, situées aux pages 479-480) ?

3\) Pourquoi avoir mentionné, de Jean-Claude Pressac, *The Struthof Album* (New York, The Beate Klarsfeld Foundation, 1985) sans révéler le contenu des passages dévastateurs où Pressac, sans pour autant nommer René Fabre, cite les conclusions de ce dernier en paraissant les approuver quand il écrit *« toxicological testing was negative »* (p. 12), *« toxicological analyses, which seem to have yielded negative results »* ou *« the toxicological examination for cyanides did not yield any positive results »* (p. 41) ?

4\) Pourquoi n’avoir pas signalé la mise en capilotade par le même J.-C. Pressac de certains « témoignages » dont celui du prétendu gazeur Josef Kramer, ancien libraire, en particulier aux pages 5, 9, 29, 30-36 de son livre, où l’on peut lire, sous la plume de l’auteur, une conclusion révisionniste jusque dans sa formulation : *« he would have ended up gassing himself »* ([si ce qu’il dit était vrai,] il aurait fini par se gazer lui-même » (p. 5) ?

5\) Pourquoi, dans les deux ouvrages de 2005 et de 2009, n’avoir jamais donné la moindre représentation physique de la « chambre à gaz du Struthof » ?

6\) Pourquoi n’avoir pas publié l’intégralité de la lettre où le professeur Auguste Hirt, mis en cause par le *Daily Mail* de Londres le 3 (et le 6) janvier 1945, a rédigé, de Tübingen, une longue et ferme « Prise de position » (*Stellungnahme*) en trois points commençant par : « Ce reportage [du *Daily Mail*] est un typique conte imaginaire d’atrocités » (*ein typisches Greuelmärchen*) ?

7\) Pourquoi, au lieu de nous reproduire ce texte (ce qui, pour une fois, aurait permis d’accorder la parole à un perpétuel accusé), s’être contenté de nous en indiquer la référence et de nous en résumer quelques fragments sur le ton du persiflage (en particulier, 2009, p. 337) ? Au sujet de Hirt on lit: « Très affecté par la disparition de sa femme et de son fils, morts dans le bombardement de Strasbourg, le 25 septembre 1944, il se suicide le 2 juin 1945 à Schönenbach en Forêt Noire (actuellement Schluschsee) » (p. 338) ; pourquoi cette seule note humaine (où, soit dit en passant, est évoquée l’atrocité — vraie, celle-là — du bombardement systématique des populations civiles par les Anglo-Américains), est-elle couverte par de faciles outrages adressés à la mémoire de l’homme qui s’est tué de désespoir : « vaniteux », « orgueilleux », « obséquieux », « monstrueu[x] », « criminel » ?

R. Steegmann a eu le mérite de corriger les formidables exagérations colportées par certains historiens du Struthof et par Henri Amouroux, donnant à croire que la minuscule « chambre à gaz » de ce camp avait servi à des tueries massives et régulières. Dans les années 1970, alors que fleurissaient encore les récits les plus échevelés sur « la barbarie nazie », on accueillait favorablement l’ouvrage d’Henry Allainmat, mentionné par R. Steegmann et intitulé, de manière significative, *Auschwitz en France / La vérité sur le seul camp d’extermination nazi en France,* Presses de la Cité, 1974, 249 p. Or R. Steegman, révisant et rectifiant ce point de vue, est amené à conclure :

> Pour considérable qu’elle soit, surtout en cinq années, la mortalité, malgré la présence d’une chambre à gaz, ne peut faire de Natzweiler [ou du Struthof] un camp d’extermination. L’expression est pourtant récurrente depuis 1945, perpét[u]ée par les témoignages et les récits des rescapés. Cruel dilemme entre histoire et mémoire ! Le débat n’a pas lieu d’être. Car, si extermination il y a eu, elle a été perçue et vécue comme telle par les effets du travail, de l’usure, du non-respect des droits les plus élémentaires de l’homme, mais elle ne résultait pas de la mise à mort planifiée et systématique de groupes entiers » (2009, p. 308-309).

Malheureusement R. Steegmann en est parfois resté, comme on l’a vu, au langage vengeur des années 1950 et aux simplifications outrancières des historiens de l’époque. Citant un passage du livre de François Bayle paru en 1955 sous le titre de *Croix gammée contre caducée,* il fait sienne la conclusion suivante sur l’affaire Hirt (j’en mets certains mots en gras) : « Ainsi l’idée **monstrueuse** d’un seul **criminel** [Hirt], confiée à un **grand débile** bien placé [Brandt] et à un **démoniaque violent** [Sievers], rationnée par un chef **cruel, borné, curieux et insensible** [Himmler], fut réalisée par les soins d’une **brute disciplinée** [Kramer] » (2009, p. 338).

On peut concevoir que, pour des raisons d’ordre personnel, la haine que nourrit R. Steegmann à l’endroit du national-socialisme le conduise à approuver chez F. Bayle de tels excès de pensée et de langage mais notre historien serait bien inspiré d’aller voir de près ces écrits révisionnistes qu’il n’a fort probablement pas lus et qu’il se contente d’appeler « l’abjecte production des négationnistes » (2009, p. 329). Il y puiserait un nombre considérable d’enseignements sur la façon de mener une enquête historique autrement que comme le font ceux que j’appelle les « historiens de papier », lesquels se soucient trop peu de la matérialité des faits, en particulier quand il s’agit d’étudier un crime. Il s’y verrait remettre en mémoire qu’il faut établir les faits avant de les commenter et qu’il sied avant tout d’être concret, terre-à-terre et matérialiste comme le sont en principe un spécialiste de la police technique (sur la scène d’un crime) et un spécialiste de la police scientifique (en laboratoire). Il apprendrait également à lire de plus près les documents et, dans le cas présent, parmi d’autres, [les « aveux » du SS Kramer](http://robertfaurisson.blogspot.it/1980/10/sur-la-pretendue-chambre-gaz-homicide.html) dans leurs différentes versions, qui sont absurdes et inconciliables. Peut-être prendrait-il aussi en considération les fermes dénégations d’Allemands interrogés par la Justice française au sujet à la fois de la chambre à gaz prétendument homicide et du prétendu gazage des 86 juifs. Il prêterait plus d’attention aux témoignages selon lesquels cette misérable chambre à gaz, si élémentaire, si bricolée, avec ses joints de « feutre » (!), avait été en réalité utilisée pour l’inoffensif entraînement des recrues au port du masque à gaz (avec passage en atmosphère simplement viciée) quand ce n’était pas aux recherches du Dr Bickenbach sur l’urotropine ou tel autre antidote destiné aux malheureuses victimes des bombardements au phosphore ou du typhus. Dans mes écrits, il apprendrait que, durant l’été 1943, les autorités du camp en étaient encore à envisager l’installation d’une simple chambre à gaz de désinfestation et que le plan de construction qu’ils avaient soumis à Berlin et à Francfort leur avait été retourné avec des observations désobligeantes sur le peu de sérieux de leur projet (lettre de l’entreprise de désinfestation Heerdt-Lingler du 3 septembre 1943). A ce compte on se demande comment, peu auparavant, Kramer, libraire de profession dans la vie civile, avait pu, muni de quelques conseils, s’improviser maître en chambre à gaz homicide au point d’accumuler quatre exécutions de groupes humains totalisant 86 victimes et cela avec un matériel et une technique qui auraient normalement dû provoquer une série de catastrophes aussi bien pour l’exécutant que pour l’entourage proche et lointain.

## Le devoir d’exactitude

R. Steegmann devrait se faire à l’idée que nous vivons en des temps où les nouvelles générations conçoivent mal qu’on cherche à leur faire la morale avec une aussi lourde insistance. Elles sourient ou s’irritent de voir qu’on s’obstine, au lycée ou ailleurs, à leur inculquer des choix d’ordre moral et à philosopher sur « l’innommable » ou l’importance de « dire l’indicible » (2009, p. 311). La haine du Nazi au couteau entre les dents, l’obligation morale qui nous est faite d’aller cracher sur les tombes du vaincu, l’habitude répugnante prise par le vainqueur de se faire à la fois l’accusateur et le juge d’un vaincu totalement réduit à sa merci, le cynisme qui consiste à déclarer d’emblée : « Le Tribunal ne sera pas lié par les règles techniques relatives à l’administration des preuves … » ou encore : « Le Tribunal n’exigera pas que soit rapportée la preuve de faits de notoriété publique mais les tiendra pour acquis … » (articles 19 et 21 du Statut du Tribunal de Nuremberg), tout cela, qui persiste si longtemps après la guerre, commence à dater et à lasser. Les Américains appellent ce phénomène de rejet *« Holocaust Fatigue »*. Déjà en 1938-1939 les jeunes Français avaient les oreilles rebattues à la fois par les couplets de la Première Guerre mondiale sur « les Boches », leurs « usines à cadavres », « les enfants belges aux mains coupées » et par les slogans à visées trop souvent bellicistes sur « l’amour de la patrie », « la gloire des armes » ou le mythe de « la tranchée des baïonnettes ». Les couplets d’aujourd’hui, recyclés de ceux d’hier, rendent le même son de l’exagération, du faux et de l’endoctrinement.

R. Steegmann répète souvent que l’historien n’est ni juge, ni accusateur mais le malheur veut que, d’un bout à l’autre des ses deux principaux ouvrages sur le Struthof, il ait adopté le langage d’un juge-accusateur trop peu soucieux de dire « la vérité, toute la vérité, rien que la vérité ». Il a surtout caché à son lecteur l’existence et le contenu d’une expertise scientifique de première importance et il a ignoré trop de faits d’ordre essentiellement matériel qui, à eux seuls, suffisaient à convaincre que le récit des prétendus gazages homicides du Struthof ne pouvait être qu’une imposture.

Le proche avenir nous dira si cette imposture-là ne va pas bientôt aller rejoindre tant d’autres récits de « chambres à gaz nazies » qui, de 1960 à nos jours, ont fini dans les poubelles de l’histoire. Ce ne serait que justice pour le respect que méritent les vraies souffrances de toutes les vraies victimes de la Seconde Guerre mondiale.

NB : R. Steegmann évalue le nombre des détenus morts au Struthof à un total proche de 20 000, qui lui paraît « plausible, dont 3 000 au camp-souche » (2009, p. 287). C’est précisément à ce chiffre de 3 000 que s’était arrêté dans son acte d’accusation, au procès de Metz, en 1952, le lieutenant-colonel de Justice militaire Guyon, commissaire du gouvernement au Tribunal militaire permanent des forces armées, qui déclarait : « En trois ans ½ d’existence le camp du Struthof qui est à classer parmi les plus redoutables, a été le tombeau de 2 156 victimes dénombrées, abstraction faite d’une trentaine d’exécutions clandestines et de tous les Russes, Polonais, Juifs décédés entre mi-septembre 1943 et le 29 mai 1944. Le nombre des décès doit approcher de 3 000. L’effectif moyen des déportés pendant la même période a été de 1 983 ». R. Steegmann n’est parvenu à une estimation de 20 000 que par l’addition d’éléments hétéroclites et non accompagnés de justifications vérifiables. La « nébuleuse » des camps satellites, avec ses propres morts, occupait des espaces géographiques parfois considérablement éloignés du Struthof, allant, par exemple, des frontières du Luxembourg à l’Autriche. Quant aux victimes des « marches de la mort », elles sont difficilement imputables à une Allemagne qui, en proie aux bombardements et aux épidémies, était à l’agonie et au bord du chaos, notamment dans les transports.

Enfin, pour en revenir au cœur de notre sujet, la chambre à gaz du Struthof, il convient de savoir qu’au procès de Metz, selon un journal, le capitaine Henriez, substitut du commissaire du gouvernement, aurait pour sa part déclaré : « Je ne puis apporter la preuve qu’il y a eu des morts par empoisonnement au Struthof » (*Dernières Nouvelles d’Alsace,* 18 décembre 1952, p. 15). 

30 mai 2013

Labels: August Hirt, Badinter, Daily Mail, François Bayle, Jean-Baptiste de Montvalon, Josef Kramer, Jouanneau, Pressac, René Fabre, Robert Steegmann, Struthof
