<!-- http://robertfaurisson.blogspot.com/1987/05/how-british-obtained-confessions-of.html -->

<!-- Thursday, May 7, 1987 -->

How the British Obtained the Confessions of Rudolf Höss, commandant of Auschwitz

Rudolf Höss was the first of three successive commandants of the Auschwitz concentration camp. He is often called "the Auschwitz Commandant", and the general public may know of writings of his as published under the title Commandant of Auschwitz (in German: Kommandant in Auschwitz: Autobiographische Aufzeichnungen des Rudolf Höss). He appeared as a witness before the International Military Tribunal (IMT) in Nuremberg on April 15, 1946. His testimony caused a sensation. To the astonishment of the defendants and in the presence of the world press, he confessed to the most ghastly crimes that History had ever known. He told of having personally received the order from Himmler to exterminate the Jews. He estimated that at Auschwitz three million persons had been exterminated, two and a half million of them in homicidal gas chambers. Those confessions were false. They had been extorted from him by torture. It took until 1983 for the identity of the torturers and the nature of the tortures to be known.

The core of Höss's confessions is composed of four elements which are, in chronological order:

1) A written deposition signed on March 14 (or 15?) 1946 at 2.30 am: an 8-page typewritten text in German. I do not think that, in normal times, any court of the democratic countries would agree to take these pages into consideration, bereft as they are of any heading and of any official printed reference, swarming with various corrections, either typed or handwritten ― all unsigned ― and bearing no note, at the end, of the number of words changed or deleted. Höss first signed it after writing: "14.3.46 230". He did so again after two lines which ought to have been handwritten but were instead typed, and which read:

I have read the above account and confirm that it is corresponding to my own statement and that it was the pure truth.

Then follow the names and signatures of two witnesses, both British sergeants; one signature bears no date, whilst the other specifies March 15. A third signature is that of a captain of the 92nd Field Security Section, certifying that the two sergeants were present throughout the entire proceedings during which prisoner Rudolf Höss made his deposition voluntarily. The date is March 14, 1946. Nothing indicates the place!

The Allies gave this document the file number NO-1210.

2) An affidavit signed 22 days later on April 5, 1946: a typewritten text of two and a half pages in English. This point is surprising, for Höss thus signed a statement under oath not in his own language but in that of his guards. His signature appears three times: first at the bottom of the first two sheets, then, on the third and final sheet, after a text of four lines ― again in English, again typed ― which reads:

I understand English as it is written above. The above statements are true: this declaration is made by me voluntarily and without compulsion; after reading over the statement, I have signed and executed the same at Nurnberg, Germany, on the fifth day of April 1946.

There follows the signature of Lieutenant-Colonel Smith W. Brookhart, after the words:

Subscribed and sworn before me this 5th day of April 1946, at Nurnberg, Germany.

By its form this text is, if possible, even less acceptable than the preceding one. In particular, whole lines have been added in capital letters, handwritten in English style, whilst others are deleted by a stroke of the pen. There is no initialling in the margin beside these corrections, no note, at the end, of the number of words struck out.

The Allies gave this document the file number PS-3868.

In order to conceal the fact that Höss had signed an affidavit that was in English whereas it ought to have been in his own language ― i.e., in German -, and in order to make the crossings-out, additions and corrections disappear, the following trickery was employed at Nuremberg: the entire text was retyped and presented as a translation *, understood as being from German into English! But the trickster, reading the original too quickly, got the impression that a handwritten addition to paragraph 10 (made by an English hand) was an addition to the end of paragraph 9, and composed the "translation" accordingly. The effect of this mistake was to render the end of paragraph 9 wholly incomprehensible.

Thus there exist two different documents under the same file number PS-3868: the paper signed by Höss and the remake †. It is the remake, in other words the crude forgery, that was used at the Nuremberg tribunal. One historical work claiming to reproduce Höss's statement as shown in PS-3868 would in fact reproduce the remake whilst deleting, without giving any indication of so doing, the end of paragraph 9 along with all of paragraph 10 [1].

3) The aforementioned oral testimony, so spectacular, made before the IMT on April 15, 1946, that is, ten days after the drafting of document PS-3868. Paradoxically, it was a lawyer for the defence who had requested Höss's appearance: Kurt Kauffmann, barrister of Ernst Kaltenbrunner, with the obvious intent of showing that the person responsible for the presumed extermination was Himmler and not Kaltenbrunner. When the time came for the prosecution's representative, American assistant prosecutor Colonel Harlan Amen, to examine Höss, he pretended to read aloud from the latter's affidavit but actually read out excerpts from the remake. Amen gave a pretext for not reading paragraph 9 (and, along with it, paragraph 8). Stopping after each excerpt, he asked Höss whether what he had just read was indeed what the latter had stated. He received, all told, the following replies:

Jawohl, Jawohl, Jawohl. Ja, es stimmt. [A two-line answer (containing an egregious falsehood: that the Hungarian Jews had been killed at Auschwitz from 1943 onwards, whereas the first Jewish-Hungarian convoy did not arrive there until May 2, 1944).] Jawohl. Jawohl. Jawohl. [A one-line answer.] Jawohl. Jawohl [2].

Normally there would have been a hundred questions to ask about that extermination and those gas chambers ― that is, a crime and an instrument of crime without precedent in history -, but no one asked those questions. In particular, Col. Amen sought no specifications or additional information about the truly appalling text he read aloud that day, in the presence of reporters who would use it to make the front-page headlines of the following day's newspapers.

4) The texts generally grouped under the title Commandant of Auschwitz.

Höss is supposed to have written these texts in pencil under the supervision of his Polish-Communist gaolers in a Cracow prison while awaiting trial. He was sentenced to death on April 2, 1947 and hanged fourteen days later at the Auschwitz camp. It would take 11 years for his alleged memoirs ― originally released in Polish in 1951 ― to be published in German by the historian Martin Broszat, without respect for the routine methods of scholarly publication. Broszat went so far as to suppress fragments which, if included, would have made it appear too clearly that either Höss or his Polish masters had proffered some outlandish statements, a fact prejudicial to the trustworthiness of the prisoner's accounts as a whole.

The four elements outlined above are closely related. Looked at carefully, they do not fail to show contradictions between their respective contents but, for the most part, they confirm one another. The eight pages of NO-1210 are, in a sense, summed up in the two and a quarter pages of PS-3868: the latter served as the central document in Höss's oral testimony before the IMT; finally, the "memoirs" written in Cracow crown the whole. NO-1210 is thus the base and the matrix. I shall deal with it further on.

Disclosures by Höss in Poland about his first confession

(doc. NO-1210 of March 14 or 15, 1946)

The war had ended in Germany on May 8, 1945. Höss fell into the hands of the British, who interned him in a camp for SS men. In his capacity as a professional farmer he obtained early release: his captors were unaware of their prey's importance. He was placed by an employment office as an agricultural labourer at a farm near Flensburg, not far from the Danish border, where he would remain for eight months. Meanwhile the military police started looking for him. His family, with whom he had managed to maintain contact, were closely watched and subjected to frequent searches. In his "memoirs" he recounts the circumstances of his arrest and what followed. The treatment he endured was particularly brutal. At first it seems surprising that the Poles should have allowed Höss to make his disclosures about the British military police. On reflection, one realises that they may have been led to do so by one or more of the following motives:

- the wish to give the confession an appearance of sincerity and veracity;

- the intent to have the reader make a comparison, flattering for the Polish Communists, of British and Polish methods; indeed, Höss was to write that, during the first part of his detention in Cracow, he came close to being "finished off" physically and especially morally but that, subsequently, he was treated with "so much understanding, so much humanity" that he agreed to write his memoirs;

- the need to provide an explanation for certain absurdities contained in the text (NO-1210) that the British police had had Höss sign, one of those absurdities being the invention of an "extermination camp" in a place that has never existed on any map of Poland: "Wolzek near Lublin"; the possibility of confusion with Belzec is not to be considered since Höss writes of three camps: "Belzek" (sic), "Tublinka" (sic) and "Wolzek near Lublin". Further on, Treblinka will be spelt correctly. Let us note in passing that the camps of Belzec and Treblinka did not yet exist at the time (June 1941) when Himmler, according to Höss, told him that they were already functioning as "extermination camps".

Here are the words in which Höss tells, successively, of his arrest by the British, his signing of the document that would become NO-1210, his transfer to Minden-on-the-Weser (where the treatment he underwent was worse still), his stay at the Nuremberg tribunal's prison and, finally, his extradition to Poland.

I was arrested on 11 March 1946 (at 11 pm).

My phial of poison had been broken two days before.

When I was aroused from sleep, I thought at first I was being attacked by robbers, for many robberies were taking place at that time. That was how they managed to arrest me. I was maltreated by the Field Security Police.

I was taken to Heide where I was put in those very barracks from which I had been released by the British eight months earlier.

At my first interrogation, evidence was obtained by beating me. I do not know what is in the record, although I signed it. Alcohol and the whip were too much for me. The whip was my own, which by chance had got into my wife's luggage. It had hardly ever touched my horse, far less the prisoners. Nevertheless, one of my interrogators was convinced that I had perpetually used it for flogging the prisoners.

After some days I was taken to Minden-on-the-Weser, the main interrogation centre in the British Zone. There I received further rough treatment at the hands of the English public prosecutor, a major.

The conditions in the prison accorded with this behaviour.

After three weeks, to my surprise, I was shaved and had my hair cut and I was allowed to wash. My handcuffs had not previously been removed since my arrest.

On the next day I was taken by lorry to Nuremberg, together with a prisoner of war who had been brought over from London as a witness in Fritzsche's defence [3]. My imprisonment by the International Military Tribunal was a rest-cure compared to what I had been through before. I was accommodated in the same building as the principal accused, and was able to see them daily as they were taken to the court. Almost every day we were visited by representatives for all the Allied nations. I was always pointed out as an especially interesting animal.

I was in Nuremberg because Kaltenbrunner's counsel had demanded me as a witness for his defence. I have never been able to grasp, and it is still not clear to me, how I of all people could have helped to exonerate Kaltenbrunner. Although the conditions in prison were, in every respect, good ― I read whenever I had the time, and there was a well stocked library available ― the interrogations were extremely unpleasant, not so much physically, but far more because of their strong psychological effect. I cannot really blame the interrogators ― they were all Jews.

Psychologically I was almost cut in pieces. They wanted to know all about everything, and this was also done by Jews. They left me in no doubt whatever as to the fate that was in store for me.

On 25 May, my wedding anniversary as it happened, I was driven with von Burgsdorff and Bühler to the aerodrome and there handed over to Polish officers. We flew in an American plane via Berlin to Warsaw [4].

Revelations in 1983 about Rudolf Höss's British torturers

The revisionists proved long ago that the various confessions of Rudolf Höss presented so many gross errors, nonsensical elements and impossibilities of all kinds that it was no longer possible to lend them the credence that the judges at Nuremberg and Cracow ― as well as some casual historians ― had, without prior analysis of their content or the circumstances in which they had been obtained, lent them.

In all likelihood Höss had been tortured by the British of the 92^nd^ Field Security Section. But a confirmation of that hypothesis was needed. Confirmation was to come with the publication of a book containing the name of the main torturer (a British sergeant of Jewish origin) and describing the circumstances both of Höss's arrest and of his third-degree interrogation.

The book is by Rupert Butler. It was published in 1983 (Hamlyn Paperbacks, Feltham, England). Butler is the author of three other works: The Black Angels, Hand of Steel and Gestapo, all from the same publisher. What interests us here is his Legions of Death. Its inspiration is anti-Nazi. Butler says he did his research for it at the Imperial War Museum, the Institute of Contemporary History (Wiener Library) and other equally prestigious institutions. At the start of this book he expresses gratitude to these institutions and, moreover, to two persons, one of whom is a "Jew" called Bernard Clarke, "who captured Auschwitz Commandant Rudolf Höss", and of whom he quotes some fragments of writings or recorded speech.

Bernard Clarke feels no remorse but, on the contrary, rather a certain pride in having tortured a "Nazi". Nor does Rupert Butler, for his part, see anything wrong in that. Neither of the two gauges the import of their revelation. They say that Höss was arrested on March 11, 1946 and that three days of torture were needed to obtain "a coherent statement". They seem not to realise that this alleged "coherent statement" is nothing but a truly mad confession, signed by the gasping torture victim on the 14^th^ or 15^th^ of March 1946 at 2.30 in the morning, a statement which was to seal his fate definitively and mark forever the history of the myth of Auschwitz, the alleged grand centre for the extermination of the Jews especially by means of alleged homicidal gas chambers.

On March 11, 1946 Clarke and five other intelligence agents in British uniform, for the most part tall and threatening-looking, entered the home of Mrs Höss and her children. The six men, we are told, were all "practised in the more sophisticated techniques of sustained and merciless investigation". Clarke started shouting:

If you don't tell us [where your husband is] we'll turn you over to the Russians and they'll put you before a firing-squad. Your son will go to Siberia [5].

Mrs Höss broke down and disclosed, says Clarke, the location of the farm where her husband was hiding, as well as his assumed name: Franz Lang. Clarke adds:

Suitable intimidation of the son and daughter produced precisely identical information.

The Jewish sergeant and the five other specialists in third degree interrogation then departed in search of Höss, whom they surprised at the farm in the middle of the night, lying in a corner of the room used as an abattoir.

Höss screamed in terror at the mere sight of British uniforms.

Clarke yelled "What is your name?"

With each answer of "Franz Lang", Clarke's hand crashed into the face of his prisoner.

The fourth time that happened, Höss broke and admitted who he was.

The admission suddenly unleashed the loathing of the Jewish sergeants in the arresting party whose parents had died in Auschwitz following an order signed by Höss.

The prisoner was torn from the top bunk, the pyjamas ripped from his body. He was then dragged naked to one of the slaughter tables, where it seemed to Clarke the blows and screams were endless.

Eventually, the Medical Officer urged the Captain: "Call them off, unless you want to take back a corpse."

A blanket was thrown over Höss and he was dragged to Clarke's car, where the sergeant poured a substantial slug of whisky down his throat. Then Höss tried to sleep.

Clarke thrust his service stick under the man's eyelids and ordered in German: "Keep your pig eyes open, you swine."

For the first time Höss trotted out his oft-repeated justification: "I took my orders from Himmler. I am a soldier in the same way as you are a soldier and we had to obey orders."

The party arrived back at Heide around three in the morning. The snow was swirling still, but the blanket was torn from Höss and he was made to walk completely nude through the prison yard to his cell.

So it is that Bernard Clarke reveals:

It took three days to get a coherent statement out of [Höss].

This admission was corroborated by one Ken Jones, quoted in an article appearing in the Wrexham Leader (October 17, 1986):

Mr Ken Jones was then a private with the fifth Royal Horse Artillery stationed at Heid[e] in Schleswig-Holstein. "They brought him to us when he refused to cooperate over questioning about his activities during the war. He came in the winter of 1945/6 and was put in a small jail cell in the barracks", recalls Mr Jones. Two other soldiers were detailed with Mr Jones to join Höss in his cell to help break him down for interrogation. "We sat in the cell with him, night and day, armed with axe handles. Our job was to prod him every time he fell asleep to help break down his resistance", said Mr Jones. When Höss was taken out for exercise he was made to wear only jeans and a thin cotton shirt in the bitter cold. After three days and nights without sleep, Höss finally broke down and made a full confession to the authorities.

Thus, what is known as Höss's first confession ― the vital text catalogued under number NO-1210 ― is the statement obtained by thugs of British Military Security in the conditions we have seen, and under the inspiration of sergeant-interpreter Bernard Clarke's sick mind. Once the tortured prisoner had begun to talk, Clarke says it was impossible to stop him. And Clarke, no more conscious in 1982 or 1983 than in 1946 of the outlandish nature of what he forced Höss to confess, then reports a series of fictitious horrors presented as real: Höss set about telling how, after the heaps of dead bodies had been set alight, the liquefied fat seeping out was collected (sic) and poured on them (!). He reckoned the number of dead solely during his time at Auschwitz at two million (!); the killings sometimes attained the number of ten thousand victims per day (!).

Clarke was in charge of censoring the letters sent by Höss to his wife and children. Every police force in the world knows that the power over a prisoner's capacity to write to his family constitutes a psychological weapon. To get what one wants from a prisoner it is sometimes enough merely to suspend or withdraw correspondence privileges. Clarke makes an interesting remark about the content of Höss's letters, confiding:

Sometimes a lump came to my throat. There were two different men in that one man. One was brutal with no regard for human life. The other was soft and affectionate [6].

Rupert Butler ends his narrative saying that Höss sought neither to deny nor escape his responsibilities. It is a fact that, at the Nuremberg trial, Höss conducted himself with a "schizoid apathy". The expression is that of the Jewish-American G. M. Gilbert, the prison psychologist in charge of psychological surveillance of the captives, working in connection with the American prosecutors. One may readily believe that Höss was "split in two"! He had the look of a wreck because the others had made a wreck of him. "Apathetic", writes Gilbert on page 229 of his book [7]; "apathetic", he repeats on the next page; "schizoid apathy", he writes on page 239.

At the end of his own trial, in Cracow, Höss received the death sentence with apparent indifference. Rupert Butler comments:

[Höss] reasoned that the Allies had their orders and that there could be absolutely no question of these not being carried out [8].

One could hardly put it better. Rudolf Höss, like thousands of accused Germans put at the mercy of conquerors wholly convinced they were in the right, had quickly grasped that he had no choice but to give those who were detaining him and preparing to judge him ― be they of the West or the East ― what they wanted.

Butler then quickly evokes the case of Hans Frank, the former Governor of Poland. With the same tone of moral satisfaction he recounts the circumstances of Frank's capture and the treatment he endured:

Celebrity status of any kind singularly failed to impress the two coloured GIs who arrested him and made sure he was transported to the municipal prison in Miesbach only after he had been savagely beaten up and flung into a lorry.

A tarpaulin had been thrown over him to hide the more obvious signs of ill-treatment; Frank found the cover useful when he attempted to slash an artery in his left arm.

Clearly, no such easy way out could be permitted; a US army medical officer saved his life and he stood trial at the International Military Tribunal at Nuremberg [9].

Rudolf Höss and Hans Frank were not the only ones to undergo treatment of that kind. Amongst the best known cases are those of Julius Streicher, Hans Fritzsche, Oswald Pohl, Franz Ziereis and Josef Kramer.

But the case of Rudolf Höss is, by far, the most serious in its consequences. There is no document to prove that the Germans had a policy of extermination of the Jews, as "Holocaust" historian Léon Poliakov agreed, already in 1951:

The three or four people chiefly involved in the actual drawing up of the plan for total extermination are dead and no documents have survived; perhaps none ever existed [10].

In the absence of any documents, the Poliakov-style historians have time and again fallen back, primarily, on dubious confessions like those of Kurt Gerstein or Rudolf Höss, often not without modifying the texts to suit their convenience.

Today Bernard Clarke is a "successful businessman working in the south of England". It can, in fact, rightly be said that it is his voice, and his sick mind, that made themselves heard at Nuremberg on April 15, 1946, when Assistant Prosecutor Amen read aloud, fragment by fragment, to a stupefied and shaken audience, the purported confession of Rudolf Höss. On that day a lie of world-wide dimensions truly took off: the lie of Auschwitz. At the origin of that prodigious media event: Jewish sergeants of British Military Security, including Bernard Clarke, "today a successful businessman working in the south of England [11]".

Moritz von Schirmeister's testimony

During the war Moritz von Schirmeister had been personal press adviser to Joseph Goebbels. On June 29, 1946, he was examined before the IMT as a defence witness for Hans Fritzsche. His testimony was particularly interesting with regard to the true personality of Dr Goebbels, as well as to the official German services' attitude towards the flood of atrocity stories about the concentration camps poured out by the Allies during the war.

At the end of the war Schirmeister had been arrested by the British and interned in a camp in England, where he was put in charge of the political "re-education" of his fellow prisoners. To have him go testify at Nuremberg he was flown from London to Germany. At first he was kept at Minden-on-the-Weser, the British military police's main interrogation centre. From there he was taken by car (March 31 ― April 1, 1946) to Nuremberg prison. In the same car rode Rudolf Höss. Schirmeister was precisely that "prisoner of war who had been brought over from London as a witness in Fritzsche's defence" of whom Höss speaks in his "memoirs" (see above). Thanks to a document, a copy of which the American researcher Mark Weber was kind enough to hand me in September 1983 in Washington ― but whose source I am not yet authorised to specify -, we know that the two Germans were able to converse freely in the car that was taking them to Nuremberg. In that document of slightly more than two pages, Schirmeister relates that, with regard to the charges hanging over Höss, the latter confided to him:

Gewiß, ich habe unterschrieben, daß ich 2 ½ Millionen Juden umgebracht habe. Aber ich hätte genausogut unterschrieben, daß es 5 Millionen Juden gewesen sind. Es gibt eben Methoden, mit denen man jedes Geständnis erreichen kann ― ob es nun wahr ist oder nicht [12] .

Another confession signed by Rudolf Höss

The British torturers of Rudolf Höss had no reason to deny themselves anything. After making him sign document NO-1210 at 2.30 in the morning of either the 14^th^ or 15^th^ of March 1946, they got a new signature on March 16, this time at the foot of a text in English, written in an English hand, with a blank where the name of the place ought to have appeared. It took all his captors' cynicism, rashness and naïve cunning to have Höss sign a simple note that read:

Statement made voluntarily at ______ Gaol by Rudolf Höss, former Commandant of Auschwitz Concentration Camp on 16th day of March 1946.

I personally arranged on orders received from Himmler in May 1941 the gassing of two million persons between June/July 1941 and the end of 1943 during which time I was commandant of Auschwitz.

Signed:

Rudolf Höss

SS-Stubfhr.

Eh. Kdt. v. Auschwitz-Birkenau

Even the word "signed" was written in an English hand.

The Auschwitz Myth

It has been known for some time that the Auschwitz myth is of essentially or exclusively Jewish origin. Arthur R. Butz expounds the pertinent facts in The Hoax of the Twentieth Century, as does Wilhelm Stäglich in The Auschwitz Myth. The main persons behind the creation and peddling of the "rumour of Auschwitz" have been, successively, two Slovak Jews: Alfred Wetzler (or Weczler) and Rudolf Vrba (or Rosenberg or Rosenthal); then a Hungarian, Rabbi Michael Dov Ber Weissmandel (or Weissmandl); then, in Switzerland, representatives of the World Jewish Congress who, like Gerhard Riegner, were in contact with London and Washington; and finally, Americans like Harry Dexter White, Henry Morgenthau Jr and Rabbi Stephen Samuel Wise. Thus was born the famous War Refugee Board report on Auschwitz and Birkenau, produced in Washington in November 1944 and of which copies were included in the briefs of the American "judges advocate general" later heading the prosecution of Germans who had served at Auschwitz. It constituted the official version of the story of gassings of Jews there. It was most likely used as a reference work by the investigators-interrogators-torturers of "the Commandant of Auschwitz". All the aforesaid names are those of Jews.

Moreover, we now see that Bernard Clarke, the first British torturer, is a Jew (the second British torturer, Major Draper (?), may also have been a Jew). The same is true of the two Americans, psychologist G. M. (Gustave Mahler) Gilbert and Col. Harlan Amen. Finally, in Poland, Höss was faced with Polish Jews who treated him in more or less the same way. When he wrote his "memoirs" it was under the supervision of examining magistrate Jan Sehn, who was probably a Jew as well.

Establishment historians dispute that Höss had been tortured and that he confessed under duress. With the publication of Rupert Butler's book in 1983, however, it is no longer possible for them to maintain that stance. The revisionists have been right all along. And since 1985 it has been even less possible. In January-March of that year, the trial of Ernst Zündel, accused by a Canadian Jewish group and by a public prosecutor of disseminating revisionist literature, took place in Toronto. Rudolf Vrba testified as a Crown witness. (He then resided in British Columbia). Affirmative and self-assured as long as he was answering questions from the prosecutor, he suffered a spectacular rout when cross-examined by Zündel's barrister, Doug Christie. For the first time since 1945 ― indeed, for the first time ever ― a Jewish witness to the alleged gassings in Auschwitz was asked to explain in court his assertions and figures. The result was so terrible for Vrba that finally the Crown itself gave a kind of coup de grâce to its key witness. That unexpected event, along with a few others (like the leading specialist of "the Holocaust", Raul Hilberg, being manifestly caught out in his lies), truly made the "Toronto Trial" the "Trial of the Nuremberg Trial".

The unintentional revelations of Rupert Butler in 1983 and those of the "Toronto Trial" in 1985 succeeded at last in showing fully and clearly how the Auschwitz myth was fabricated from 1944 to 1947 or, to be exact, from April 1944 ― when Rudolf Vrba and Alfred Wetzler are supposed to have escaped from Auschwitz to tell their story to the world ― up until April 1947, when Rudolf Höss was hanged after having supposedly told the same world his own story about Auschwitz.

It is remarkable that from beginning to end that story comes essentially or perhaps even exclusively from Jewish sources. Two Jewish liars (Vrba and Wetzler) from Slovakia convinced or seem to have convinced other Jews from Hungary, Switzerland, the United States, Britain and Poland with their tale. This is not a conspiracy or a plot; it is the story of the birth of a religious belief: the myth of Auschwitz, centre of the Holocaust religion.

***

[]

This image (click to enlarge) appears after p. 161 of Lord Russell of Liverpool's Geissel der Menschheit, Berlin, Verlag Volk und Welt, 1960; the title of the original book in English is The Scourge of the Swastika. The caption at the top reads: "The Confession of Rudolf Höss". It is not a reproduction of NO-1210 or PS-3868 but only a very short text of March 16, 1946. One may note the difference between the handwriting of the text of the confession and Höss's own handwriting. In his introduction to the English edition of Kommandant in Auschwitz Lord Russell claims to furnish some information on the conditions in which Höss had to sign that note, but, since he commits errors in the chronology of the events in that regard, his information is to be received with reservations. (See Commandant of Auschwitz, p. 18.)

[]

This second image was produced as photograph n° 22 in Tom Bower's Blind Eye to Murder (Britain, America and the Purging of Nazi Germany ― A Pledge Betrayed), Granada Publishing, London, Toronto, Sydney, New York 1981. The caption reads: "Colonel Gerald Draper of the British War Crimes Group photographed as he finally secured the confession of Rudolf Höss, the commandant of Auschwitz, to the murder of three million people." As will be recalled, Höss wrote in his "memoirs": "I received further rough treatment at the hands of the English public prosecutor, a major" (Commandant of Auschwitz, p. 174). Did that major become a colonel and was his name "Draper"?

May 7, 1987

Notes

 * The English word "remake" is used throughout in the original French text ― translator's note.

† The English word "translation" is used in the original French text ― translator's note.

[1] See Henri Monneray, La Persécution des Juifs dans les pays de l'Est présentée à Nuremberg, Paris, Centre de documentation juive contemporaine, 1949, p. 159-162.

[2] IMG (the German-language edition of the tribunal documents) XI, p. 457-461.

[3] Hans Fritzsche, head of radio and press at the ministry of Education and Propaganda from 1938, acquitted at Nuremberg.

[4] Commandant of Auschwitz: the autobiography of Rudolf Hoess, English translation by Constantine FitzGibbon, London, Weidenfeld and Nicolson, 1959, p. 173-175.)

[5] Legions of Death, p. 235.

[6] Id., p. 238.

[7] Nuremberg Diary, New York: Farrar, Strauss, 1947; Signet Books, 1961.

[8] Legions of Death, p. 238.

[9] Id., p. 238-239.

[10] (Bréviaire de la haine: Le III^e^ Reich et les Juifs, Paris, Calmann-Levy, 1951, Livre de Poche, 1974, p. 171; English language edition: Harvest of Hate: the Nazi Program for the Destruction of the Jews of Europe, Syracuse University Press, New York, 1954, p. 108).

[11] Legions of Death, p. 235.

[12] "Certainly, I signed a statement that I killed two and a half million Jews. But I could just as well have said it was five million Jews. There are certain methods by which any confession can be obtained ― whether it is true or not".

Labels: aveux, Bernard Clarke, Broszat, Harlan Amen, Himmler, Kurt Kauffmann, Moritz von Schirmeister, Nuremberg, Rudolf Höss
