<!-- http://robertfaurisson.blogspot.com/1987/05/comment-les-britanniques-ont-obtenu-les.html -->

<!-- Thursday, May 7, 1987 -->

# Comment les Britanniques ont obtenu les aveux de Rudolf Höss, commandant d'Auschwitz

Rudolf Höss fut le premier des trois commandants successifs du camp de concentration d'Auschwitz. Il est souvent appelé "le commandant d'Auschwitz" et le grand public connaît de lui des écrits qui ont été publiés sous le titre : *Le Commandant d'Auschwitz parle...* (en allemand : *Kommandant in Auschwitz: Autobiographische Aufzeichnungen des Rudolf Höss*). Il a comparu devant le TMI (Tribunal militaire international) en qualité de témoin, le 15 avril 1946. Sa déposition fit sensation. À la stupéfaction des accusés et en présence de la presse du monde entier, il confessa les crimes les plus affreux que l'Histoire eût jamais connus. Il disait avoir personnellement reçu l'ordre de Himmler d'exterminer les juifs. Il estimait qu'à Auschwitz on avait exterminé trois millions d'hommes dont deux millions et demi par le moyen de chambres à gaz homicides. Ces aveux étaient faux. Ils lui avaient été extorqués par la torture. Il a fallu attendre 1983 pour connaître l'identité des tortionnaires et la nature des tortures.

Le cœur même des aveux de R. Höss est constitué par quatre pièces qui, dans l'ordre chronologique, sont les suivantes :

1\) Une déposition écrite signée le 14 mars (ou le 15 mars ?) 1946 à 2h 30 du matin ; il s'agit d'un texte dactylographié de huit pages, rédigées en allemand ; je ne pense pas qu'en temps ordinaire une seule instance judiciaire des pays démocratiques accepterait de prendre en considération ces pages dépourvues de tout en-tête et de toute référence administrative imprimée et fourmillant de corrections diverses, soit dactylographiées, soit manuscrites, sans l'accompagnement du moindre paraphe et sans aucun rappel, à la fin, du nombre de mots corrigés ou supprimés. Höss a signé une première fois après avoir écrit : "14.3.46 ― 2h 30". Il a procédé de même après deux lignes qui auraient dû être manuscrites mais qui sont dactylographiées et qui disent :

> J'ai lu le texte ci-dessus ; je confirme qu'il correspond à mes propres déclarations et que c'est la pure vérité.

Suivent les noms et les signatures de deux témoins : deux sergents britanniques ; l'un n'a pas mentionné la date tandis que l'autre indique celle du 15 mars. Vient enfin la signature d'un capitaine de la 92^e^ section de la sécurité militaire en campagne qui certifie que les deux sergents ont été présents durant toute la procédure où le prisonnier Rudolf Höss a fait volontairement sa déposition. La date est celle du 14 mars 1946. Rien n'indique le lieu !

La cote que les Alliés ont attribuée à ce document est NO-1210.

2\) Une déclaration sous serment (en anglais : *affidavit*) signée le 5 avril 1946, soit vingt-deux jours plus tard. Il s'agit d'un texte dactylographié de deux pages et demie rédigées en anglais. Ce dernier point est surprenant. Höss a donc signé là une déclaration sous serment, non pas dans sa langue mais dans celle de ses gardiens. Sa signature apparaît à trois reprises : d'abord en bas des deux premières pages, puis, à la troisième et dernière page après un texte de quatre lignes, toujours en anglais, toujours dactylographiées et qui disent :

> Je comprends l'anglais, langue dans laquelle est rédigé le texte ci-dessus. J'ai déposé selon la vérité ; j'ai fait cette déclaration volontairement et sans contrainte ; après avoir relu ma déposition, je l'ai signée et certifiée, à Nuremberg, Allemagne, le 5e jour d'avril.

Suit la signature du lieutenant-colonel Smith W. Broockhart après la formule :

> Après avoir prêté serment et signé en ma présence, le 5^e^ jour d'avril 1946, à Nuremberg, Allemagne.

Par la forme, ce texte est, s'il se peut, encore moins acceptable que le précédent. En particulier, des lignes entières sont ajoutées en capitales manuscrites à la manière anglaise tandis que d'autres sont biffées d'un trait de plume. Il n'y a aucun paraphe en marge de ces corrections, aucun rappel, en fin de document, du nombre de mots rayés nuls.

La cote que les Alliés ont attribuée à ce document est PS-3868.

Pour dissimuler le fait que Höss avait signé une déposition sous serment qui était en anglais alors qu'elle aurait dû être dans sa propre langue, c'est-à-dire en allemand, et pour faire disparaître les ratures, les ajouts et les corrections, voici la supercherie qui fut utilisée à Nuremberg : on retapa le texte au propre et on le présenta comme une translation, sous-entendu de l'allemand en anglais ! Mais le tricheur alla trop vite en besogne. Il crut qu'un ajout manuscrit au paragraphe 10 (dû à une main anglaise) était un ajout à la fin du paragraphe 9. Le résultat de cette méprise est que la fin du paragraphe 9 est rendue totalement incompréhensible.

Il existe donc deux documents différents sous la même cote PS-3868 : la pièce signée par Höss et le remake. C'est le remake, autrement dit le faux grossier, qui fut utilisé devant le Tribunal de Nuremberg. Un ouvrage historique qui prétend reproduire la déclaration PS-3868 de Höss reproduira en fait le remake mais en supprimant sans le dire la fin du paragraphe 9 ainsi que le paragraphe 10 tout entier [1].

3\) La déposition orale, si spectaculaire, que j'ai déjà mentionnée et qui fut faite devant le TMI le 15 avril 1946, soit dix jours après la rédaction du document PS-3868. Paradoxalement, c'est un avocat de la défense qui a demandé la comparution de R. Höss : Kurt Kauffmann, défenseur de Ernst Kaltenbrunner, dans l'intention manifeste de montrer que le responsable de l'extermination présumée était Himmler et non Kaltenbrunner. Quand vint le tour pour le représentant du ministère public (en la circonstance, le procureur adjoint américain, le colonel Harlan Amen) d'interroger Höss, il fit semblant de lire la déposition signée par ce dernier et, en réalité, il lut des extraits du remake. Harlan Amen donna un prétexte pour ne pas lire le paragraphe 9 (et, du même coup, le paragraphe 8). S'interrompant après la lecture de chaque fragment, il demanda à Höss si c'était bien là ce qu'il avait déclaré. Il reçut en tout et pour tout les réponses suivantes :

> "Jawohl", "Jawohl", "Jawohl", "Ja, es stimmt". [Une réponse de deux lignes (contenant une énormité, à savoir que les juifs hongrois auraient été tués à Auschwitz à partir de 1943 alors que le premier convoi de ces juifs n'est arrivé à Auschwitz que le 2 mai 1944).] "Jawohl", "Jawohl", "Jawohl". [Une réponse d'une ligne.] "Jawohl", "Jawohl" [2].

Il y aurait eu normalement cent questions à poser sur cette extermination et ces chambres à gaz, c'est-à-dire sur un crime et sur un instrument du crime sans précédent dans l'Histoire, mais personne ne posa ces questions. En particulier, le colonel Amen ne sollicita aucune précision ni aucun complément sur le texte véritablement effrayant dont il donnait lecture ce jour-là en présence de journalistes qui, le lendemain, allaient en faire les grands titres de leurs journaux.

4\) Les textes rassemblés généralement sous le titre *Le Commandant d'Auschwitz parle*.

Höss aurait rédigé ces textes au crayon sous la surveillance de ses geôliers polono-communistes, dans sa prison de Cracovie, en attente de son procès. Il fut condamné à mort le 2 avril 1947 et pendu quatorze jours plus tard dans le camp d'Auschwitz. Il fallut attendre 1958, soit onze ans, pour voir publier en allemand ce qu'on peut appeler ses mémoires. La publication en fut faite par l'historien allemand Martin Broszat, sans respect pour les méthodes de routine des publications scientifiques. Broszat alla jusqu'à supprimer des fragments qui auraient fait trop clairement apparaître que R. Höss ou ses maîtres polonais avaient proféré des énormités, ce qui était dommageable pour la véracité de l'ensemble de ses récits.

Les quatre pièces que je viens d'énumérer ont un étroit rapport de filiation. À y regarder de près, les contradictions ne manquent pas dans leurs contenus respectifs, mais, pour l'essentiel, elles se confirment. Les huit pages de NO-1210 sont en quelque sorte résumées dans les deux pages et quart de PS-3868 ; ce dernier a servi de pièce centrale dans la déposition orale devant le TMI ; enfin, les mémoires rédigés à Cracovie couronnent le tout. La base et la matrice sont donc le document NO-1210. Je vais en reparler.

## Révélations de Höss en Pologne, sur sa première confession (doc. NO-1210 du 14 ou 15 mars 1946)

La guerre avait pris fin en Allemagne le 8 mai 1945. Höss tomba aux mains des Britanniques qui l'enfermèrent dans un camp pour SS. En sa qualité d'agriculteur professionnel, il obtint une libération anticipée. Ses gardiens ignoraient alors l'importance de leur proie. Il fut placé par un bureau de travail comme ouvrier agricole dans une ferme près de Flensburg, non loin de la frontière du Danemark. Il y resta huit mois. La police militaire le recherchait. Sa famille, avec laquelle il avait réussi à maintenir le contact, était strictement surveillée et soumise à des perquisitions fréquentes. Il raconte dans ses mémoires les circonstances de son arrestation et ce qui s'ensuivit. Le traitement qu'il subit fut particulièrement brutal. À première vue on s'étonne que les Polonais aient permis à Höss de faire ces révélations sur la police militaire britannique. À la réflexion, on découvre qu'ils ont pu être guidés par un ou plusieurs des motifs suivants :

― le désir de donner à cette confession une apparence de sincérité et de véracité ;

― l'intention de susciter chez le lecteur une comparaison, flatteuse pour les communistes polonais, entre les méthodes britanniques et les méthodes polonaises ; Höss dira, en effet, plus loin que, dans la première partie de sa détention à Cracovie, on faillit l'"achever" physiquement et surtout moralement mais que, par la suite, on le traita "avec tant de compréhension, tant d'humanité" qu'il consentit à écrire ses mémoires ;

― la nécessité de fournir une explication à certaines absurdités contenues dans le texte (NO-1210) que les policiers britanniques avaient fait signer à R. Höss, l'une de ces absurdités consistant à inventer l'existence d'un "camp d'extermination" en un lieu qui n'a jamais existé sur aucune carte de Pologne : "Wolzek près de Lublin" ; la confusion avec Belzec n'est pas à envisager puisque, aussi bien, Höss parle de trois camps : "Belzek (sic)", "Tublinka (sic)" et "Wolzek près de Lublin". Plus loin, Treblinka sera correctement orthographié. Notons en passant que les camps de Belzec et de Treblinka n'existaient pas encore à l'époque (juin 1941) où Himmler, selon Höss, lui aurait dit qu'ils fonctionnaient déjà comme "camps d'extermination".

Voici en quels termes Höss raconte successivement son arrestation par les Britanniques, sa signature du document qui deviendra le NO-1210, son transfert à Minden-sur-la-Weser où le traitement qu'il subit fut encore pire, son séjour à la prison du Tribunal de Nuremberg et, enfin, son extradition vers la Pologne.

> Le 11 mars 1946, à vingt-trois heures, on vint m'arrêter.  
> Deux jours avant cette date, ma fiole de poison s'était brisée.  
> Réveillé en sursaut, je pensai être attaqué par des cambrioleurs qui étaient alors très nombreux dans la région : on n'eut donc aucune peine à m'arrêter. Le traitement que je subis de la part de la Field Security Police ne fut pas particulièrement clément.  
> On m'emmena à Heide et je me retrouvai par hasard dans la caserne même d'où les Anglais m'avaient libéré huit mois plus tôt.  
> Mon premier interrogatoire fut "frappant" au sens exact du terme. J'ai signé le procès-verbal, mais je ne sais pas ce qu'il contenait : l'alternance de l'alcool et du fouet était trop sensible, même pour moi. Le fouet était ma propriété personnelle : il se trouvait par hasard dans les bagages de ma femme. Je ne crois pas que j'en aie frappé mon cheval et certainement pas les détenus. Mais l'homme qui m'interrogeait pensait probablement que je m'en servais pour battre des prisonniers à longueur de journée.  
> Au bout de quelques jours, je fus conduit à Minden-sur-la-Weser, centre des interrogatoires de la zone anglaise. Là, j'ai subi un traitement encore plus brutal de la part du procureur militaire, un commandant anglais. Le régime de la prison où je me vis enfermé correspondait à son attitude.  
> Au bout de trois semaines, je fus brusquement conduit chez le coiffeur qui me rasa la barbe et me coupa les cheveux ; on m'autorisa aussi à me laver. Depuis mon arrestation, c'était la première fois qu'on m'enlevait mes menottes.  
> Le lendemain, on me transporta en voiture spéciale à Nuremberg, en compagnie d'un prisonnier de guerre qu'on avait amené de Londres comme témoin à décharge pour Fritzsche [3]. Après mes expériences précédentes, mon séjour dans la maison d'arrêt me fit l'effet d'une cure en sana. Je me trouvais dans le même pavillon que les principaux accusés et je pouvais les voir constamment lorsqu'on les conduisait au tribunal. Des représentants de tous les pays alliés venaient presque tous les jours faire un tour dans notre prison : chaque fois on me montrait comme une "bête féroce" particulièrement curieuse.  
> On m'avait fait venir à Nuremberg comme témoin à décharge de Kaltenbrunner, sur demande de son défenseur. Jusqu'à ce jour, je ne suis pas parvenu à comprendre pourquoi c'était moi entre tous qu'on avait choisi pour ce rôle.  
> Les conditions de mon séjour étaient excellentes sous tous les rapports ; nous disposions d'une grande bibliothèque et je pouvais employer tout mon temps à lire. Mais les interrogatoires étaient vraiment très pénibles : on ne m'infligeait pas de sévices, mais la pression morale était très dure à supporter. Je ne puis en vouloir à mes juges : ils étaient tous juifs.  
> Ce sont ces juifs désireux de tout savoir qui m'ont psychologiquement disséqué. Ils ne laissaient subsister aucun doute sur le sort qui nous attendait.  
> Le 25 mai, anniversaire de mon mariage, je fus conduit avec Bihler [sic pour Buehler] et von Burgsdorf à l'aérodrome où l'on me remit à des officiers polonais. Un avion USA nous transporta par Berlin à Varsovie [4].

## Révélations, en 1983, sur les tortionnaires britanniques de R. Höss

Les révisionnistes ont, depuis longtemps, prouvé que les diverses confessions de R. Höss présentaient tant d'erreurs grossières, de non-sens et d'impossibilités de toute nature qu'il n'était plus possible de leur accorder le crédit que les juges de Nuremberg et ceux de Cracovie, ainsi que des historiens de rencontre, leur avaient accordé sans analyse préalable de leur contenu et des circonstances dans lesquelles ces confessions avaient été obtenues.

Selon toute vraisemblance, Höss avait été torturé par des Britanniques de la 92nd Field Security Section. Mais il fallait une confirmation à cette hypothèse. La confirmation allait venir avec la publication d'un livre anglais contenant le nom du principal tortionnaire (un sergent britannique d'origine juive) et décrivant les circonstances de l'arrestation de R. Höss ainsi que de son interrogatoire au troisième degré.

Le livre est de Rupert Butler. Il a été publié en 1983 (Hamlyn Paperbacks). R. Butler est l'auteur de trois autres ouvrages : *The Black Angels, Hand of Steel* et *Gestapo,* publiés chez le même éditeur. Celui qui nous intéresse s'intitule : *Legions of Death.* Son inspiration est antinazie. R. Butler dit que, pour ce livre, il a fait des recherches auprès de l'Imperial War Museum de Londres, de l'Institute of Contemporary History (Wiener Library) et d'autres institutions aussi prestigieuses. Au début de son livre, il exprime sa gratitude à ces institutions et, par ailleurs, à deux personnes dont l'une est un "juif" du nom de Bernard Clarke "qui captura Rudolf Höss, le commandant d'Auschwitz" et dont il cite quelques fragments d'écrits ou bien de propos enregistrés.

Bernard Clarke n'éprouve aucun remords mais, au contraire, une certaine fierté d'avoir torturé un "nazi". Rupert Butler, lui non plus, n'y voit aucun mal. Ni l'un ni l'autre ne mesurent l'importance de leur révélation. Ils disent que R. Höss a été arrêté le 11 mars 1946 et qu'il a fallu trois jours de torture pour obtenir "une déclaration cohérente". Ils ne se rendent pas compte que cette prétendue "déclaration cohérente" n'est autre que la confession, véritablement folle, qui a été signée par la victime pantelante le 14 ou le 15 mars 1946 à 2h 30 du matin et qui allait définitivement sceller le sort de R. Höss et marquer à jamais l'histoire du mythe d'Auschwitz, prétendu haut lieu de l'extermination des juifs, en particulier grâce à l'emploi de prétendues chambres à gaz homicides.

Le 11 mars 1946, Bernard Clarke et cinq autres spécialistes du renseignement, en uniforme britannique, de haute taille pour la plupart et l'air menaçant, pénètrent au domicile de Mme Höss et de ses enfants. Les six hommes, nous dit-on, sont tous "entraînés aux techniques les plus sophistiquées des interrogatoires soutenus et sans merci" (p. 235). Clarke se met à crier :

> Si vous ne nous dites pas où est [votre mari], nous vous livrerons aux Russes qui vous flanqueront devant un poteau d'exécution et votre fils ira en Sibérie [5].

Mme Höss craque et révèle, dit Clarke, l'emplacement de la ferme où se cache son mari. Elle révèle aussi son faux nom : Franz Lang. Et Bernard Clarke d'ajouter :

> Une intimidation appropriée exercée sur le fils et la fille produisit des informations identiques.

Le sergent juif et les cinq autres spécialistes de l'interrogatoire au troisième degré partent alors à la recherche de R. Höss qu'ils surprennent en pleine nuit, couché dans un recoin de la salle servant d'abattoir à la ferme.

Höss poussa un cri à la simple vue des uniformes britanniques. Clarke hurla : "Ton nom ?"

À chaque fois que la réponse était "Franz Lang", Clarke écrasait de son poing la face du prisonnier. Au quatrième coup Höss craqua et reconnut qui il était.

Soudain cet aveu déchaîna l'écoeurement des sergents juifs venus l'arrêter, dont les parents étaient morts à Auschwitz en vertu d'un ordre signé de Höss. Tout là-haut le prisonnier fut arraché de sa couchette et on lui arracha son pyjama. Il fut ensuite traîné nu vers l'une des tables d'abattage et là Clarke crut que coups et cris n'auraient pas de fin.

En fin de compte, l'officier de santé intervint avec insistance auprès du capitaine : "Dites-leur d'arrêter ou c'est un cadavre que vous ramènerez". On jeta sur Höss une couverture et il fut traîné vers la voiture de Clarke où ce dernier lui déversa dans la gorge une bonne rasade de whisky. Höss essayant alors de s'endormir, Clarke lui plongea son stick de commandement sous les paupières et en allemand lui ordonna : "Tiens ouverts tes yeux de cochon, espèce de porc !"

Alors, pour la première fois, Höss débita une justification qu'il allait si souvent répéter : "Je recevais mes ordres de Himmler. Je suis un soldat comme vous. Il fallait obéir aux ordres".

L'équipe fut de retour à Heide vers trois heures du matin. La neige continuait de tourbillonner mais on arracha à Höss sa couverture et il lui fallut traverser complètement nu la cour de la prison jusqu'à sa cellule.

C'est ainsi que Bernard Clarke révèle :

> Il y fallut trois jours pour obtenir [de Höss] une déclaration cohérente.

C'est cette déclaration, obtenue dans les conditions que l'on voit par des brutes de la Sécurité militaire britannique et sous l'inspiration du cerveau malade du sergent interprète Bernard Clarke, qui deviendra la première confession de Höss, la confession primordiale répertoriée sous la cote NO-1210. Une fois que le prisonnier torturé eut commencé de parler, Clarke dit qu'il fut impossible de l'arrêter. Et Clarke, pas plus conscient en 1982 ou 1983 qu'en ces jours de 1946 de l'énormité de ce qu'il forçait Höss à confesser, rapporte alors une série d'horreurs fictives présentées ici comme réelles : Höss se mit en effet à raconter comment, ayant mis le feu aux monceaux de cadavres, on recueillait (sic) la graisse qui en coulait pour la reverser sur les cadavres (!). Il évaluait à deux millions le nombre des morts du seul temps où il avait été à Auschwitz (!) ; les tueries atteignaient parfois le nombre de dix mille victimes par jour (!).

Clarke était chargé de la censure des lettres adressées par Höss à sa femme et à ses enfants. Toutes les polices du monde savent que cette autorisation d'écrire à la famille constitue une arme psychologique. Pour faire chanter le prisonnier il suffit parfois de suspendre ou de supprimer cette autorisation. Clarke fait une intéressante remarque sur le contenu des lettres de Höss ; il nous confie :

> Parfois le morceau était dur à avaler. Il y avait deux hommes dans cet homme. L'un était brutal et sans égard pour la vie humaine. L'autre était tendre et affectueux [6].

Rupert Butler termine son récit en disant que Höss ne chercha plus à nier ou à échapper à ses responsabilités. Il est de fait qu'au procès de Nuremberg Höss se conduisit avec une "apathie schizoïde". L'expression est de l'Américain G. M. Gilbert, le psychologue de la prison chargé de la surveillance psychologique des prisonniers, en relation avec le ministère public américain. On veut bien croire que R. Höss était "scindé en deux" ! Il avait l'air d'une loque parce qu'on en avait fait une loque. "Apathetic", dit Gilbert à la page 229 de son livre (*Nuremberg Diary,* New York, Farrar, Strauss, 1947, Signet Books, 1961) ; "apathetic", répète-t-il à la page suivante ; "schizoid apathy", écrit-il à la page 239.

À la fin de son propre procès, à Cracovie, Höss accueillit la sentence de mort avec une indifférence apparente. Rupert Butler observe à ce propos :

> [Höss] s'était fait la remarque que les Alliés avaient reçu des ordres et qu'il n'était absolument pas question que ces ordres ne fussent pas exécutés [7].

On ne saurait mieux dire. R. Höss, à l'instar de milliers d'accusés allemands rendus à la merci de vainqueurs totalement convaincus de leur bon droit, avait vite compris qu'il n'avait pas d'autre choix que d'en passer par la volonté de ces justiciers de l'Ouest ou de l'Est.

Rupert Butler évoque ensuite rapidement le cas de Hans Frank, l'ancien gouverneur de Pologne. Sur le même ton de satisfaction morale, il raconte les circonstances de la capture et le traitement subi :

> La célébrité du personnage ne fut d'aucun effet sur les deux GI de couleur qui l'arrêtèrent et firent le nécessaire pour qu'il fût transporté à la prison municipale de Miesbach seulement après avoir été sauvagement battu puis flanqué dans un camion. On lui avait jeté dessus une toile goudronnée pour cacher les traces les plus marquantes du traitement qu'il avait subi ; Frank profita de cette couverture pour s'entailler l'artère du bras gauche. Il n'était évidemment pas question de le laisser s'en tirer si facilement : un officier de santé de l'armée américaine lui sauva la vie et Frank put comparaître devant le Tribunal militaire international de Nuremberg [8].

Hans Frank, on le sait, fut pendu.

Rudolf Höss et Hans Frank ne furent pas les seuls à subir des traitements de ce genre. Parmi les cas les plus célèbres on connaît ceux de Julius Streicher, de Hans Fritzsche, de Franz Ziereis, de Josef Kramer, de Oswald Pohl.

Mais le cas de Höss est, de loin, le plus grave par ses conséquences. Aucun document ne prouve, de la part des Allemands, une politique d'extermination des juifs. Léon Poliakov en convenait dès 1951 :

> En ce qui concerne la conception proprement dite du plan d'une extermination totale, les trois ou quatre principaux acteurs se sont suicidés en mai 1945. Aucun document n'est resté, n'a peut-être jamais existé [9].

En l'absence de tout document, les historiens à la Poliakov se sont rabattus principalement sur des confessions douteuses comme celles de Kurt Gerstein ou de Rudolf Höss, non sans modifier les textes à leur convenance.

Bernard Clarke est "aujourd'hui un businessman prospère établi dans le sud de l'Angleterre" (Legions of Death, 1983, p. 235). On peut bien dire que c'est sa voix, et son esprit malade, qui se sont fait entendre à Nuremberg, le 15 avril 1946, quand le procureur Amen donnait lecture, fragment par fragment, à un auditoire stupéfait et bouleversé, de la prétendue confession de R. Höss. Ce jour-là prenait véritablement son envol un mensonge aux dimensions planétaires : le mensonge d'Auschwitz. A l'origine de cette prodigieuse affaire médiatique : quelques sergents juifs de la Sécurité militaire britannique, dont Bernard Clarke, aujourd'hui "businessman prospère établi dans le sud de l'Angleterre [10]".

## Le témoignage de Moritz von Schirmeister

Moritz von Schirmeister avait été, pendant la guerre, le conseiller de presse personnel de Joseph Goebbels. Le 29 juin 1946, il fut interrogé devant le TMI en tant que témoin à décharge de Hans Fritzsche. Sa déposition fut particulièrement intéressante en ce qui concernait la personnalité véritable du Dr Goebbels et l'attitude des services officiels allemands face au flot de récits d'atrocités déversés pendant la guerre par les Alliés sur le compte des camps de concentration. À la fin de la guerre, Moritz von Schirmeister avait été arrêté par les Britanniques et interné en Angleterre dans un camp où il avait été chargé de la "rééducation" politique de ses camarades prisonniers. Pour venir témoigner à Nuremberg, il fut d'abord transféré en avion de Londres en Allemagne. Il fut gardé à Minden-sur-la-Weser qui était le centre principal des interrogatoires de la police militaire britannique. De là il fut conduit en voiture (31 mars-1er avril 1946) à la prison de Nuremberg. Dans la même voiture se trouvait R. Höss. Moritz von Schirmeister est précisément ce "prisonnier de guerre qu'on avait amené de Londres comme témoin à décharge pour Fritzsche" dont parle Höss dans ses "mémoires" (voy. ci-dessus). Grâce à un document que je dois à l'obligeance de l'Américain Mark Weber qui m'en a remis copie en septembre 1983 à Washington, document dont je ne suis pas encore autorisé à indiquer la source exacte, nous savons que les deux Allemands ont pu librement converser dans la voiture qui les menait à Nuremberg. Dans ce document d'un peu plus de deux pages, Moritz von Schirmeister rapporte qu'à propos des charges qui pesaient sur lui, R. Höss lui confia :

> Gewiss, ich habe unterschrieben, dass ich 2 ½ Millionen Juden umgebracht habe. Aber ich hatte genausogut unterschrieben, dass es 5 Millionen Juden gewesen sind. Es gibt eben Methoden, mit denen man jedes Gestaendnis erreichen kann ― ob es nun wahr ist oder nicht [11].

## Un autre aveu signé de R. Höss

Les tortionnaires britanniques de R. Höss n'avaient aucune raison de se gêner. Après lui avoir fait signer le document NO-1210 à 2h 30 du matin le 14 ou le 15 mars 1946, ils obtinrent de lui une nouvelle signature le 16 mars, cette fois-ci au bas d'un texte en anglais, rédigé de la main d'un Anglais, avec un blanc à la place de l'endroit où aurait dû figurer le nom du lieu. Il fallait tout le cynisme, l'inconscience et la naïve rouerie de ses gardiens pour lui faire signer un simple billet où se lisait en anglais :

> Déclaration faite volontairement à la prison de [passage en blanc] par Rudolf Höss ancien commandant du camp de concentration d'Auschwitz le 16^e^ jour de mars 1946.
> J'ai personnellement organisé sur ordres reçus de Himmler en mai 1941 le gazage de deux millions de personnes entre juin-juillet 1941 et la fin de 1943, temps durant lequel j'ai été le commandant d'Auschwitz.
> Signé :
> Rudolf Höss
> SS-Stubfhr.
> Ancien Kdt. d'Auschwitz-Birkenau

Même le mot *signed* ("signé") était d'une main anglaise.

## Conclusion

Le "témoignage" de Rudolf Höss était d'une importance primordiale pour les historiens défendant la thèse de l'extermination des juifs et de l'existence, à Auschwitz, de chambres à gaz homicides. Avec la publication de Legions of Death par Rupert Butler, ce "témoignage" s'effondre définitivement. Ainsi que le disaient les historiens révisionnistes, Rudolf Höss a rendu ce témoignage sous la torture. L'ironie veut que cette confirmation de la thèse révisionniste ait été involontairement apportée par un historien exterminationniste. Ce dernier ne soupçonnait certainement pas l'importance de sa découverte, que vient de corroborer en octobre 1986 une émission télévisée britannique : *Secret Hunters.* (Voyez Mike Mason, "In a cell with a Nazi war criminal ― We kept him awake until he confessed" [En cellule avec un criminel de guerre nazi ― Nous l'avons tenu éveillé jusqu'à ce qu'il avoue], Wrexham Leader, 17 octobre 1986.)

―――

![ ](images/comment-les-britanniques-ont-obtenu-les-1.jpg)

Cette image apparaît après la p. 161 du livre de Lord Russell de Liverpool *Geissel der Menschheit* (Berlin, Verlag Volk und Welt, 1960), dont le titre d'origine est *The Scourge of the Swastika.* La légende porte : « L'aveu de Rudolf Höss ». Il ne s'agit pas d'une reproduction de NO-1210 ou de PS-3868 mais seulement d'un très court texte du 16 mars 1946. On remarquera la différence entre l'écriture du texte de l'aveu et la propre écriture de Höss. Dans son introduction à l'édition anglaise de *Kommandant in Auschwitz* Lord Russell prétend fournir des informations sur les conditions dans lesquelles Höss dut signer cette note mais, vu qu'il commet des erreurs dans la chronologie des événements concernés, ses informations sont à recevoir avec des réserves. (Voir Commandant of Auschwitz, p. 18.)

![ ](images/comment-les-britanniques-ont-obtenu-les-2.jpeg)

Cette seconde image a été reproduite en tant que photographie n° 22 dans l'ouvrage de Tom Bower *Blind Eye to Murder. Great Britain, America and the Purging of Nazi Germany* (Granada Publishing, Londres, Toronto, Sydney, New York 1981). La légende dit : « Le colonel Gerald Draper du British War Crimes Group photographié lorsqu'il obtint enfin l'aveu de Rudolf Höss, le commandant d'Auschwitz, à l'assassinat de trois millions de personnes. » On se souviendra que Höss a écrit dans ses « mémoires » : « Là, j'ai subi un traitement encore plus brutal de la part du procureur militaire, un commandant anglais. » (*Le Commandant d'Auschwitz parle,* p. 248). Ce commandant devint-il colonel et s'appelait-il "Draper"?

7 mai 1987

Notes

[1] Voy. Henri Monneray, *La Persécution des Juifs dans les pays de l'Est présentée à Nuremberg,* Paris, éditions du Centre de documentation juive, 1949, p. 159-162.

[2] IMG, XI, p. 457-461.

[3] Hans Fritzsche, chargé de la radio et de la presse au ministère de l'Éducation et de la Propagande depuis 1938, acquitté à Nuremberg.

[4] Rudolf Höss, *Le Commandant d'Auschwitz parle,* traduit de l'allemand par Constantin de Grunwald, Julliard, (1959) 1970, p. 248-250.

[5] R. Butler, *Legions of Death,* Londres, Hamlyn, 1983, p. 235.

[6] Id., p. 238.

[7] Id., p. 238.

[8] Id., p. 238-239.

[9] L. Poliakov, *Bréviaire de la haine,* Paris, Calmann-Lévy, 1951, p. 171.

[10] R. Butler, *Legions of Death,* p. 235.

[11] "Assurément, j'ai signé que j'avais tué 2 millions et demi de juifs. Mais j'aurais tout aussi bien signé qu'il y en avait eu 5 millions. Il y a précisément des méthodes pour obtenir n'importe quel aveu ― que ce soit vrai ou non."

Labels: "Nuremberg", Auschwitz, aveux, Bernard Clarke, Broszat, Harlan Amen, Himmler, Kurt Kauffmann, Moritz von Schirmeister, Rudolf Höss, Rupert Butler
