---

<!-- http://robertfaurisson.blogspot.com/1996/11/bilan-de-laffaire-garaudy-abbe-pierre.html -->
<!-- Friday, November 1, 1996 -->

# Bilan de l'affaire Garaudy-abbé Pierre (janvier-octobre 1996)

L'affaire Garaudy a commencé en janvier 1996 et celle de l'abbé Pierre en avril de la même année. Les deux affaires, confondues, ont occupé une place importante dans les médias jusqu'à la rétractation de l'abbé Pierre, annoncée le 23 juillet. Leur retombée principale est constituée par deux articles de l'historien Jacques Baynac publiés le 2 et le 3 septembre dans *Le Nouveau Quotidien* de Lausanne.

Il est regrettable que Roger Garaudy et l'abbé Pierre n'aient pas manifesté plus de courage. Dès qu'en France, la tempête médiatique s'est levée, ils ont commencé à battre en retraite. Leurs moyens financiers et les multiples appuis dont ils bénéficiaient depuis des années à l'étranger leur ont permis, pendant un certain temps, de s'absenter de France, l'un pour les pays arabes et l'autre pour l'Italie et la Suisse. On ne leur en tiendra pas rigueur. Il faut savoir la violence de ces tempêtes ; les plus vigoureux y prennent peur ; à plus forte raison, des hommes de leur âge. Jusque-là, tous deux avaient connu, dans leur vie respective, quelques rudes épreuves. Ils savaient ce qu'est la haine, d'autant plus que, l'un comme l'autre, ils avaient, pour leur part, pratiqué la haine de l'ennemi. R. Garaudy a, en effet, longtemps considéré les anticommunistes et même les antistaliniens comme des sous-hommes et l'abbé Pierre a, dans son activité politique, fait la preuve d'un remarquable manque de charité à l'égard de ses adversaires. Mais, enfin, la vie avait fini par choyer ces deux hommes. Or, là, soudain, en 1996, le ciel leur tombait sur la tête. Et, manifestement, ils en étaient, au plein sens du mot, atterrés.

## La première édition du livre de R. Garaudy

En décembre 1995, Pierre Guillaume, responsable de la revue *La Vieille Taupe,* publie, de R. Garaudy, *Les Mythes fondateurs de la politique israélienne*. Il le fait avec toutes sortes de précautions, pour éviter les foudres de la loi Fabius-Gayssot (ou *lex Faurissonia*). Le livre est vendu hors commerce comme un « bulletin confidentiel réservé aux Amis de la Vieille Taupe » ; alors que toute la partie révisionniste du livre est faite d'emprunts manifestes à mes propres textes, mon nom est soigneusement évité ; il n'apparaît qu'une fois [1], et encore seulement comme celui d'un professeur victime de la répression antirévisionniste mais sans qu'on sache au juste pourquoi : ni un livre, ni un article de ce professeur ne sont cités.

Les considérations religieuses et politiques du livre de R. Garaudy peuvent froisser certains adeptes de la religion juive et la plupart des sionistes ; mais les pages qui déchaînent, en France d'abord, puis, dans une bonne partie du monde occidental, l'ire des organisations juives et des médias sont les quelque soixante-quinze pages d'inspiration révisionniste qui occupent le cœur de l'ouvrage [2]. Elles portent sur « le mythe de la justice de Nuremberg », sur la « solution finale », sur « les témoignages », sur « les procès », sur « l'arme du crime » (c'est-à-dire les chambres à gaz nazies) et sur « le mythe de l'Holocauste ». Sur les chambres à gaz, cœur du cœur de ce sujet brûlant, l'auteur exprime son doute « et même [son] scepticisme » [3]. Ces soixante-quinze pages ont été écrites hâtivement ; elles se composent de pièces disparates ; l'exposé est plutôt décousu ; les négligences foisonnent ; il y a aussi des erreurs, notamment sur David Irving qui, l'auteur aurait dû le savoir, ne peut servir de référence ni sur l' « Holocauste » puisque D. Irving n'a jamais étudié le sujet, ni sur le *Journal d'Anne Frank* puisque l'historien anglais n'en a jamais fourni la moindre analyse et qu'il est allé jusqu'à prendre à son compte la rumeur, fondée sur une grossière méprise, selon laquelle le livre avait été écrit par un certain Meyer Levin !

Mais, tel quel, avec toutes ses insuffisances, le livre de R. Garaudy ne pouvait qu'inquiéter les organisations juives, qui n'avaient déjà que trop tendance à voir des révisionnistes surgir de partout et qui découvraient là un homme dont les opinions politiques ― il avait été un apparatchik stalinien des plus orthodoxes ― ne pouvaient tout de même pas être qualifiées de fascistes. R. Garaudy avait aussi été protestant, puis catholique avant de devenir musulman dans les années quatre-vingt et, à ces divers titres, il s'était montré un adversaire de tout racisme.

## La seconde édition remaniée

*Le Canard enchaîné* et *Le Monde* ouvrent le feu en janvier 1996. Des organisations antiracistes portent plainte. Une bonne partie de la presse française et de la presse internationale se fait alors l'écho de « l'affaire Garaudy ».

Le 11 mars, P. Guillaume, agissant pour le compte de R. Garaudy, s'efforce d'obtenir de son imprimeur habituel l'impression ― qu'il avait annoncée dans le bulletin de *La Vieille Taupe* ― d'une édition, publique cette fois-ci, des *Mythes fondateurs de la politique israélienne*. Pour une raison que j'ignore, l'imprimeur refuse le travail. C'est alors que R. Garaudy décide de publier son ouvrage en samizdat.

Le 3 avril, P. Guillaume remet au « dépôt légal » un exemplaire de ce samizdat. Doté d'un avant-propos ainsi que d'une annexe contenant, en particulier, une liste des ouvrages du même auteur improprement appelée « bibliographie », le texte original a été remanié de manière à en atténuer le caractère révisionniste. Mais rien n'indique au lecteur qu'il s'agit d'une édition remaniée. Des passages ont été retranchés, d'autres ajoutés, d'autres enfin récrits. Dans les pages 119-120 de la première édition, neuf alinéas avaient été consacrés à la politique de silence ou à la persécution subies par les principaux révisionnistes ; et c'est là, comme je l'ai dit plus haut, que mon nom figurait pour une seule et unique fois avec ceux d'Arthur Butz et de Wilhelm Stäglich ; dans les pages 134-135 de la seconde édition, ces neuf alinéas disparaissent pour laisser place au récit des tribulations, en vérité bien légères, vécues par l'auteur lui-même, d'abord en 1982-1983 pour une prise de position en faveur des Palestiniens et, en ce début de l'année 1996, pour la publication des *Mythes fondateurs* en livraison hors commerce de la Vieille Taupe. Les noms de Butz, Stäglich et Faurisson disparaissent totalement du livre. Quant au nom de Serge Thion, il n'apparaît ni dans la première ni dans la seconde édition, ce qui, pour un ouvrage révisionniste publié par la Vieille Taupe, constitue une anomalie.

Dans la première édition, R. Garaudy avait opté pour l'orthographe de « médiat[s] » avec un « t » (signe de ralliement des révisionnistes amis de la Vieille Taupe, avait décrété P. Guillaume) ; dans la seconde édition, il rétablit l'orthographe consacrée par le bon usage avec « média[s] » sans « t ». Manifestement, il ne veut pas montrer qu'il est en bons termes avec l'éditeur révisionniste.

## L'abbé Pierre entre en scène

Le 15 avril, l'abbé Pierre adresse à son ami Garaudy (« Très cher Roger ») une longue lettre de soutien. Seuls des extraits en paraîtront çà et là et il faudra attendre le mois de juin pour en connaître l'intégralité.

Les passages suivants m'en paraissent intéressants :

> De ton nouveau livre il m'est impossible de parler avec tous les soins que réclament non seulement son sujet fondamental, mais aussi l'étonnante et éclatante érudition, scrupuleuse, sur laquelle chaque propos se fonde comme j'ai pu le constater en le parcourant. ― Autour de moi quelques personnes dont les exigences et la compétence sont grandes et qui l'ont entièrement lu me disaient l'importance de ce qu'elles en ont reçu. ― Il faut tout faire, et je m'y emploie, pour que bientôt des historiens vrais, de la même passion du vrai qui est la tienne, s'attachent à en débattre avec toi. ― Les insultes contre toi que j'ai pu connaître [...] sont déshonorantes.

> Nous entendons dire une intention du Pape, en l'an 2000 (sera-ce le même Pape ?) de confesser les fautes historiques [contre les juifs] qui ont accompagné le zèle des missions chrétiennes. ― Puisse [le Pape, dans sa future déclaration] ne pas sous-estimer la part prise dans l'antisémitisme avec les mots « peuple déicide », ce qui est insensé car c'est pour tous les peuples, pour tous les humains que Jésus s'est offert en rançon !

> Retiens de ces lignes [...] la force et la fidélité de mon affectueuse estime et de mon respect pour l'énorme travail de ton nouveau livre. Le confondre avec ce qui fut appelé « révisionnisme » est une imposture et [une] véritable calomnie d'inconscients.

Il ressort de cette lettre que l'abbé Pierre n'a pris connaissance du livre de son ami qu'« en le parcourant » et qu'il se distingue par là de ceux « qui l'ont entièrement lu », ce qui est son droit ; on a, en effet, le droit de porter un jugement sur un livre après l'avoir seulement parcouru, si on avoue précisément ne l'avoir pas lu dans son intégralité.

Mais l'abbé paraît naïf ou aveugle quand il en vient à parler d'« énorme travail » et d'une œuvre totalement étrangère au « révisionnisme » ; il est possible que, pour lui, les « révisionnistes » ne soient qu'une catégorie de nazis contestant ― qui sait ? ― l'existence des camps de concentration ; en réalité, le cœur de l'ouvrage est d'inspiration exclusivement révisionniste.

Le passage consacré à une possible déclaration du pape est important. Il prouve que l'abbé Pierre n'est nullement antijuif et qu'on ne saurait en aucun cas l'accuser ― comme on le fera si souvent par la suite ― d'être une sorte de catholique rétrograde qui n'aurait pas su se dégager d'un enseignement reçu dans sa jeunesse et imprégné d'antijudaïsme religieux.

## L'abbé Pierre sur l'avant-scène

Le 2 février, le journal *La Croix* publie, sous la signature de Michel Crépu, un article intitulé : « Terminal Garaudy ». L'abbé Pierre est ulcéré de l'agression ainsi commise contre son très cher ami Garaudy.

Le 18 avril, au cours d'une conférence de presse, R. Garaudy révèle, avec son défenseur, Me Jacques Vergès, le nom de quelques-unes des personnalités dont il a obtenu le soutien ; parmi celles-ci figurent le père Michel Lelong, l'essayiste suisse Jean Ziegler ainsi que l'abbé Pierre. Nicolas Weill rapporte, en son style, cette information dans *Le Monde* daté du 20 avril (paraissant, à Paris, dans l'après-midi du 19).

J'envoie immédiatement, par fax du 19 avril, un communiqué au *Monde,* à *Libération* et à l'Agence France-Presse [4].

Dès le lendemain et dans les jours suivants, les cinq intéressés (R. Garaudy, abbé Pierre, Jacques Vergès, père Lelong et J. Ziegler) battent en retraite. R. Garaudy dénonce « l'horreur absolue du nazisme » et précise qu'il ne faut pas parler d'« Holocauste » parce que cela signifierait que Dieu est responsable du massacre des juifs alors que seuls les nazis en sont responsables ; d'ailleurs, ces derniers n'ont-ils pas provoqué cinquante millions de morts ? L'abbé Pierre dit qu'on a exagéré le nombre des morts d'Auschwitz puisque le chiffre de quatre millions a été officiellement remplacé par celui d'un million (le musée d'Auschwitz a opté pour le chiffre d'un million et demi) mais il dénonce « les négationnismes et révisionnismes comme tromperies intellectuelles et morales qu'il faut à tout prix combattre ». J. Vergès déclare à propos du livre de R. Garaudy : « Qualifier ce livre de négationniste est une imposture ». Le père Lelong prendra, à son tour, ses distances. J. Ziegler déclare que « le révisionnisme est une infâme connerie ».

L'abbé Pierre, tout en multipliant actes de contrition et protestations de bonne foi, tient des propos qui irritent la Ligue internationale contre le racisme et l'antisémitisme (LICRA), présidée par Pierre Aidenbaum. Il conserve sa confiance à son ami R. Garaudy et souhaite un colloque rassemblant des personnes d'opinions différentes. Il se dit assuré que, si l'on apporte la preuve à son ami qu'il s'est trompé, celui-ci reconnaîtra son erreur.

## Velléités de résistance de l'abbé Pierre

Le 27 avril, l'hebdomadaire *Le Point* publie un article bien informé sur le révisionnisme et sur toute l'affaire. Il cite un extrait de mon communiqué de presse du 19 avril. L'article se termine sur une phrase de l'abbé Pierre parue dans *La Croix* : « Ne plus pouvoir dire un mot relatif au monde juif à travers les millénaires sans se faire traiter d'antisémite, c'est intolérable ».

Le grand rabbin Sitruk suggère un débat sur la Shoah. Immédiatement, Henri Roques et moi-même lui signifions publiquement notre accord. Le lendemain, il retire sa suggestion.

Le 29 avril, *Libération* titre : « L'abbé Pierre refuse de condamner les thèses négationnistes de Garaudy ». Effectivement, le vieil homme a un sursaut. Il dit de la LICRA et d'autres groupes : « Ils n'acceptent absolument pas le dialogue, contrairement à Garaudy ». On lui demande : « Vous n'êtes pas choqué qu'un négationniste comme Faurisson se soit "réjoui" de votre soutien à Garaudy ? » Il répond : « Vous me l'apprenez. Bien entendu que ça me fait mal. [Faurisson] représente tout l'opposé de mon engagement, de ma vie ». L'abbé fait allusion, du moins est-ce probable, autant à mon athéisme qu'à mon révisionnisme. Il dit qu'à l'aéroport de Bruxelles il a vu, pour la première fois depuis longtemps, des gens venir spontanément à sa rencontre pour le remercier ; ces gens lui ont dit : « Merci, parce que vous avez eu le courage de mettre en cause un tabou. » Il ajoute qu'il est « convaincu qu'il y a une espèce de "Ouf !" : le tabou est levé ! On ne se laissera plus traiter d'antijuif ou d'antisémite si on dit qu'un juif chante faux ! » Il ajoute : « Une fois la tornade passée, beaucoup de Français moyens diront : "Il nous a aidés à y voir plus clair". »

## Offensive généralisée contre l'abbé Pierre

En un premier temps, la hiérarchie catholique déclare qu'elle ne veut pas être entraînée dans la polémique. Puis, la conférence épiscopale déplore l'attitude de l'abbé Pierre et réaffirme que l'extermination des juifs est un fait incontesté ; elle dénonce le scandale que constitue toute remise en cause de la Shoah.

R. Garaudy, en « état de détresse », conjure l'abbé Pierre, par de multiples appels téléphoniques, de lui venir en aide.

Le 1er mai, P. Guillaume me téléphone pour me lancer un appel au secours : R. Garaudy a besoin d'urgence d'un document. Je lui réponds que son mandant n'a qu'à me réclamer lui-même cette pièce. « Il ne le fera pas », me dit P. Guillaume à deux reprises. Je lui exprime mon étonnement d'être ainsi traité et de n'avoir pas même reçu un exemplaire des *Mythes fondateurs*. Je lui signale que, comme il le sait, ce livre n'est, pour la partie révisionniste, qu'une compilation de mes écrits. « C'est évident », me dit-il. Plus tard, le 9 mai, lors d'une émission de Radio Courtoisie, à une auditrice qui dira : « Le rapport de Faurisson à Garaudy, c'est le rapport d'un volé à un voleur », il répondra : « Ben... Tout le monde le sait ! »

Le 2 mai, Jean-François Kahn choisit pour titre de sa chronique de *L'Événement du jeudi* : « Comment, avec l'abbé Pierre, on sert la soupe à Le Pen et à Faurisson. » Le même jour, la presse quotidienne annonce que la LICRA vient d'expulser l'abbé Pierre de son comité d'honneur.

Le 9 mai, dans *Libération,* Jean-Luc Allouche déclare que R. Garaudy, l'abbé Pierre et R. Faurisson n'ont « qu'une visée : frapper encore et toujours d'illégitimité l'État d'Israël ». Il cite un extrait de mon introduction, datée d'août 1989, au second Rapport Leuchter :

> À l'avenir, les tenants de l'"Holocauste" conserveront leur argent, leur puissance, leur capacité de produire des films, de célébrer des cérémonies, de construire des musées : des films, des cérémonies, des musées de plus en plus vides de sens. Ils multiplieront les moyens de répression contre les révisionnistes par les coups et blessures, les campagnes de presse, les procès, le vote de lois spéciales. Ils multiplieront aussi, cinquante ans après la guerre, les poursuites contre ceux qu'ils appellent les "criminels de guerre". Les révisionnistes, eux, leur répliqueront par des études historiques ou des ouvrages scientifiques et techniques. Ces ouvrages, ces études seront nos pierres, notre Intifada.

Le 9 mai, l'Américain Joseph Sobran écrit : « If [l'abbé Pierre] had denied the divinity of Christ, the press would be hailing him for his fierce independence of mind [5]. »

Le 9 et le 16 mai, dans *National Hebdo,* le dessinateur Konk publie deux dessins qui reflètent bien l'actualité ; l'un montre les gardiens de la vérité officielle observant à la jumelle un amas de béton sous lequel on avait cru enterrer le révisionnisme mais le sarcophage montre des fissures ; il menace d'exploser et de contaminer le monde entier ; l'autre montre des gardiens de cimetière passant devant trois tombes, celles de Faurisson, de Garaudy et de l'abbé Pierre, tandis que l'un des gardiens souffle à l'autre : « C'est le coin des enterrés vivants ». L'angoisse des censeurs est là : malgré de formidables campagnes de presse, malgré les procès, malgré les violences physiques, le révisionnisme historique persiste et même se développe. Les belles consciences commencent à s'interroger sur l'utilité de la loi Fabius-Gayssot, « véritable cadeau pour les révisionnistes » (sic).

Le 13 mai, les mouvements « Emmaüs France » et « Emmaüs International » font paraître, à grands frais, un communiqué où « le Mouvement Emmaüs » indique que « toute caution, d'où qu'elle vienne, apportée aux thèses révisionnistes lui est intolérable » et déplore que « l'homme du combat total et généreux » ait été conduit « hors du terrain qui est le sien et qui est le nôtre ».

## R. Garaudy cherche des appuis

R. Garaudy annonce qu'il a des amis rabbins et que l'un d'eux, le rabbin Elmer Berger, âgé de quatre-vingt-huit ans, vivant en Floride, « a écrit un texte qui sera une très bonne préface pour mon livre lorsqu'il sera publié aux États-Unis [6]. » Il cherche également refuge auprès de ses amis arabes.

François Brigneau signe, le 16 mai, dans *National Hebdo,* un article sur « Le samizdat de Garaudy » où il esquisse un tableau de l'incessante persécution subie en France par les écrivains affligés du stigmate de « l'extrême droite ». Au passage, il note : «Je ne reviendrai pas sur le fond du livre. M. Garaudy n'est pas de notre paroisse. Certains aspects de son ouvrage sont déplaisants. Je pense à l'exploitation qui est faite des découvertes du professeur Faurisson (en particulier sur l'histoire d'Anne Frank), de ses travaux d'investigation et de l'ensemble de son œuvre qu'il a payée si cher, alors que Garaudy ne lui consacre [dans la première édition de son livre] que trois lignes, en passant... C'est assez pénible. »

Le 23 mai, *Libération* fait état d'un éditorial d'Al-Ahram, journal au nom prestigieux, considéré comme la voix officieuse du pouvoir égyptien. Ce journal se dit « fier » d'avoir accueilli dans ses pages R. Garaudy, auteur d'un livre poursuivi en France, et il souligne qu'« une campagne médiatique a interdit [à ce dernier] d'exprimer ouvertement son point de vue ». Dans son éditorial, ce journal reproche à *Libération* ses « procédés de propagande sioniste » à l'égard de R. Garaudy alors que le même *Libération* défend le droit de Salman Rushdie d'attaquer l'Islam.

Le 31 mai, R. Garaudy envoie à ses amis une lettre circulaire qui commence ainsi : « Chers amis, Je vous remercie de la confiance que vous m'avez témoignée à propos de mon livre *Les Mythes fondateurs de la politique israélienne* dans lequel vous n'avez trouvé nulle trace de "négationnisme". ― Ceux qui m'ont accolé cette étiquette barbare, ou bien n'ont pas lu mon livre ou bien l'ont fait avec une mauvaise foi délibérée. »

Le même jour, *Le Figaro* publie des extraits d'une interview de R. Garaudy. À en croire le journaliste Élie Maréchal, voici une question et sa réponse : « Pourquoi avez-vous publié à La Vieille Taupe [éditeur de R. Faurisson] la première édition de votre livre [...] ? ― Par nécessité. Mais je ne connaissais pas cet éditeur. Sinon, je ne me serais jamais lié avec lui ». Mais, les mœurs de la grande presse étant ce qu'on sait, on peut douter que R. Garaudy soit allé aussi loin dans le reniement.

Le 29 mai, la presse avait annoncé : « L'abbé Pierre a quitté définitivement la France pour un monastère italien. » R. Garaudy va rendre visite à l'abbé Pierre au monastère de Praglia. Il déclare à la presse que ce dernier a enfin trouvé le temps de lire son livre : « Cette lecture a conforté [l'abbé Pierre]. Il a constaté qu'aucun article paru dans la presse n'a réfuté mes thèses. »

Mais l'affaire va soudain s'aggraver.

L'abbé Pierre déclare au *Corriere della Sera* : « L'Église de France est [...] intervenue pour me faire taire sous la pression de la presse, inspirée par un lobby sioniste international [7]. » La formule provoque un hourvari à travers le monde.

Au mois de juin, les journalistes Michel-Antoine Burnier et Cécile Romane publient un opuscule, *Le Secret de l'abbé Pierre,* où ils révèlent que, près de trois ans auparavant, le 27 mars 1993, ils ont eu un entretien avec l'abbé Pierre, à son lieu de résidence, et cela en présence des juifs Bernard Kouchner et Marek Halter. Il s'agissait de recueillir et de mettre en forme les dialogues de l'abbé Pierre et de son ami B. Kouchner pour le livre *Dieu et les hommes*. Or, l'abbé Pierre leur avait déjà tenu sur certains livres de l'Ancien Testament et sur le sionisme les propos les plus sévères. Les deux journalistes avaient censuré ces propos dans leur livre. Censeurs et fiers de l'être, ils déclarent aujourd'hui qu'à l'époque ils ont fait leur travail de journalistes responsables. Ce qui leur permet d'administrer une leçon de morale à l'abbé Pierre et aux révisionnistes.

## R. Garaudy cherche refuge dans la surenchère

Paraît également au mois de juin un autre opuscule : *Droit de réponse. Réponse au lynchage médiatique de l'abbé Pierre et de Roger Garaudy* (samizdat R. Garaudy). R. Garaudy, faisant le point sur ce qu'il affirme, sur ce qu'il conteste et sur ce qu'il nie, dit que son « révisionnisme » s'apparente simplement à celui d'historiens orthodoxes comme François Bédarida. Pour ce qui est des chambres à gaz, il rappelle qu'aucun tribunal n'a cherché à examiner l'arme du crime, qu'il y a le rapport Leuchter ainsi que « les contre-expertises de Cracovie et de Vienne » et qu'il s'« étonne que ces rapports n'aient pas fait l'objet d'une publication et d'un débat ouvert ». Il ajoute : « Alors qu'est-ce que je nie ? ― Ce que je nie, c'est le droit que s'arrogent les sionistes de minimiser les crimes de Hitler en les réduisant à l'incontestable persécution des juifs. Sa volonté d'expansion a fait cinquante millions de morts, dont seize millions de Slaves, russes ou polonais, comme le rappelait à Miami le pape Jean-Paul II ».

Ainsi qu'on le constate, R. Garaudy pratique dans l'antinazisme une surenchère identique à la surenchère dans l'antiracisme dont se délectait l'avocat J. Vergès au procès de Klaus Barbie, à Lyon, en 1987 ; J. Vergès, lui, s'en était pris à la France qui, disait-il, se permettait de condamner le racisme de K. Barbie alors qu'elle avait pratiqué, elle-même, un racisme criminel contre les peuples coloniaux noirs, jaunes ou arabes.

En annexes de son opuscule, R. Garaudy ne craint pas de reproduire « Le témoignage d'un pasteur protestant [8] » et « Le cri d'un déporté [9] ». Du pasteur Roger Parmentier, il retranscrit la phrase suivante, sans l'assortir de la moindre réserve ou correction : « On appelle "négationnistes" les nazis d'aujourd'hui qui veulent réviser l'Histoire pour donner raison aux nazis d'hier ». Et le pasteur d'ajouter : « On ne me fera jamais croire [après lecture des déclarations de l'abbé Pierre et du livre de R. Garaudy] que ces frères se sont convertis au nazisme ». Quant au « déporté », il écrit, dans le même esprit de surenchère que R. Garaudy lui-même : « Que les journalistes sachent une chose : la très grande majorité des déportés dans les camps nazis n'ont pas été les juifs, bien que tous les médias aient accrédité la thèse que seuls les juifs ont été déportés et exterminés ». Et le déporté d'invoquer des chiffres fantaisistes quant au nombre des soldats soviétiques, des Tsiganes et des Polonais « exterminés ».

Une publication islamique prend la défense de R. Garaudy qui est allé trouver ses amis musulmans hors de France ; elle écrit : « Garaudy n'a jamais remis en question l'existence des chambres à gaz ; il n'a jamais tenté de falsifier ou de banaliser le génocide des juifs pendant la seconde guerre mondiale. Les sionistes font là un mauvais procès à Garaudy, car la seule chose que l'auteur conteste, c'est le nombre de juifs exterminés [10]. »

P. Guillaume et R. Garaudy sont mis en examen pour la première édition des *Mythes*. Au surplus, R. Garaudy est mis en examen pour la seconde édition des *Mythes* et son *Droit de réponse*.

## L'ultra-gauche en effervescence

Dans un petit ouvrage collectif publié en juin par des libertaires, on tient des propos confus sur ― ou plutôt contre ― les libertaires ou les gauchistes qui ont, à un moment de leur vie, manifesté leur sympathie pour le révisionnisme [11]. L'avant-propos est signé de Gilles Perrault qui, avec le plus grand sérieux, écrit que « les négationnistes ont reçu avec la loi Gayssot un inappréciable cadeau [12] » ; il dénonce « la crapule révisionniste [13] ». Dans le corps de l'ouvrage, P. Guillaume est traité de « menteur », de « pervers » et de « salaud » [14] et on revient sur les procès «qui, ironiquement, assurent aux révisionnistes une véritable rente publicitaire inespérée [15] ». Il faut dire qu'on y dénonce aussi « des témoins douteux comme Élie Wiesel » et que la LICRA y est accusée de « détournement de cadavres » au profit d'Israël [16] ; on s'en prend également à «la littérature de gare concentrationnaire des Bernadac, Steiner, Gray et compagnie qui fait appel aux plus bas instincts pour se vendre [et] a fait beaucoup de mal à la recherche historique [17] ». La zizanie s'est mise dans les rangs de la gauche et de l'ultra-gauche. Un auteur de romans policiers, Didier Daeninckx, lève l'étendard de l'épuration antirévisionniste dans les rangs des intellectuels de gauche. L'universitaire Philippe Videlier, fortement enclin à la délation, reprend du service.

## L'abbé Pierre lance son appel du 18 juin

Un sondage réalisé par Louis Harris pour le magazine lyonnais Golias les 7 et 8 juin fait apparaître que l'abbé Pierre, comme le dit *Libération* (11 juin), « garde la cote chez les catholiques ». Le livre de R. Garaudy se vend bien, malgré les difficultés de diffusion. Toutefois, en Suisse, il est saisi et séquestré chez un libraire de Montreux, Aldo Ferraglia, sur ordonnance d'une jugesse d'instruction de Lausanne, Valérie Barth. Par la même occasion, cette personne pousse le zèle jusqu'à faire saisir également deux livres dont je suis l'auteur, qui ont été publiés en 1982 et 1983 et n'ont jamais été l'objet de plaintes ou de condamnations en France ou ailleurs ; elle réserve le même traitement au livre de François Brigneau : *Mais qui est donc le professeur Faurisson ?* ; elle prend enfin l'initiative d'envoyer des policiers dans des librairies pour mettre en garde les libraires contre la vente de tout ouvrage révisionniste. Or, il se trouve que l'abbé Pierre a quitté l'Italie pour la Suisse. De « Zermatt, le 18 juin », il envoie à un journaliste du Monde un fax de douze pages intitulé : « Vivre la vérité ».

Ce journal a multiplié les articles les plus venimeux. L'abbé Pierre a, en principe, le droit de répondre à ces articles. Les lecteurs du *Monde* constatent, jour après jour, que leur quotidien ne publie aucun texte de l'accusé. Un journaliste du *Monde,* avec l'accord de sa hiérarchie, fait, enfin, miroiter à l'abbé la possibilité de publier un texte. L'abbé se met au travail. En trois jours il compose ces douze pages dactylographiées dont, fidèle à ses habitudes de censure vertueuse, le journal ne publiera pas une ligne. Dans ce texte, l'abbé assure que son ami Garaudy, en « cinquante ans de dialogue [...] n'a jamais cessé de crier l'horreur des crimes, scientifiquement organisés par les nazis, surtout contre les juifs ». Il dit vivre « la plus cruelle des épreuves de [s]a longue vie » ; il parle de « véritable lynchage, étonnamment simultané et identique, comme sur commande (de qui ?) de tous les médias » ; il dit : « Jamais sans doute je n'aurai tant eu mal, [tant été] calomnié, insulté, accusé d'antisémitisme. » Il fait état de ses bonnes relations avec Shimon Perès et avec leur ami commun, André Chouraqui. Il proteste de son amour pour les juifs qu'il considère comme une sorte d'élite, des « ferments », dit-il, mais il dénonce « l'ivresse sioniste ». Il ne parle quasiment pas du contenu du livre de R. Garaudy. Il affirme : « Pour moi, au monastère, j'ai pu au calme lire et annoter le livre incriminé. N'ayant rien pu y trouver de blâmable et me sachant bien peu savant, j'ai demandé aux recteurs de deux des plus grandes universités catholiques en Europe de bien vouloir remettre le livre, traduit en leur langue, à trois maîtres hautement spécialistes d'histoire, de théologie et de science biblique. Leurs avis m'importeront plus que ceux de la LICRA, et aussi de quelques excellents amis s'étant dits "atterrés devant le livre". » L'abbé Pierre s'en prend également à la loi Gayssot.

Le professeur Albert Jacquard, coqueluche de la gauche caviar, envoie au *Monde* une lettre de soutien à l'abbé Pierre mais le journal en refuse la publication.

Mgr Lustiger, cardinal-archevêque de Paris, d'origine juive, déclare à l'hebdomadaire *Tribune juive* (édition du 20 juin) qu'il a « vécu cette polémique comme un immense gâchis » ; il adresse une sorte de blâme public à l'abbé Pierre et dégage la responsabilité de l'Église. Plus tard, le 26 septembre, lors d'une « soirée-débat sur la Shoah » à la Sorbonne, il déclarera : « Le négationnisme est le type même du mensonge de l'homme qui tue son frère pour fuir la vérité », et son ami Élie Wiesel lui dira en écho : « Les négationnistes n'ont peut-être pas d'âme. »

## L'offensive antirévisionniste

Dans sa livraison du 26 juin, *Le Monde* annonce que « des mains anonymes ont collé ces dernières nuits, sur le boulevard périphérique, à Paris, des affiches interrogeant : "Et si l'abbé Pierre avait raison ?" ».

Le 27 juin, la France découvre des affiches publicitaires de *L'Événement du jeudi* reproduisant la page de couverture avec le titre : « Holocauste. La victoire des révisionnistes. » Bien entendu, l'hebdomadaire déplore ce qu'il appelle « la victoire des révisionnistes » ; il s'agit là d'une exagération car, plus que jamais, règne la terreur et les révisionnistes se voient privés de tout moyen d'exposer publiquement leurs arguments et de répondre aux innombrables attaques dont ils sont la cible.

Quant à l'abbé Pierre et à R. Garaudy, ils veillent, plus que jamais, à prendre leurs distances d'avec ces « révisionnistes », qu'ils ont décrits ou laissé décrire comme des suppôts du nazisme.

Le jour même où *L'Événement du jeudi* arbore ce titre, le tribunal de grande instance de Bordeaux condamne le libraire bordelais Jean-Luc Lundi, père de onze enfants, à un mois de prison avec sursis et cinq mille francs d'amende pour exposition et vente de livres révisionnistes. Assorti d'une mise à l'épreuve de cinq ans, le jugement ordonne, en outre, la destruction des livres saisis dans la boutique du libraire.

Le 16 juillet, Georges Piscoci-Danesco, réfugié politique de Roumanie, tenant dans le quartier Latin la modeste Librairie du Savoir (5, rue Malebranche, 75005 Paris) où peuvent s'acheter des ouvrages révisionnistes et, notamment, celui de R. Garaudy, est blessé par des membres du Betar et sa librairie est dévastée : deux mille volumes (dont certains sont très rares) se trouvent maculés au point d'en être rendus invendables ; les dégâts ― dont l'assurance ne remboursera pas un franc ― sont évalués à deux cent cinquante mille francs. Le Betar jouit de la protection du ministère de l'Intérieur et, comme d'habitude, rien n'est fait par la police pour interpeller les malfaiteurs ou les criminels. Dans ces quinze dernières années, les troupes de choc juives ont ainsi accumulé impunément plus de cinquante actions criminelles aux conséquences les plus graves tandis que pas un seul « antisémite » n'a touché un seul cheveu d'un seul juif [18].

## La rétractation de l'abbé Pierre

Le 23 juillet, *La Croix* publie deux textes de l'abbé Pierre, datés du 22 juillet.

Le premier est une lettre adressée à R. Garaudy. L'abbé Pierre rappelle à son ami dans quel « état de détresse » se trouvait ce dernier en avril : « Cher Roger, sûrement tu te souviens de l'état de détresse où tu te trouvais en avril dernier lorsque, en de multiples téléphones, tu m'appelais à l'aide ». Il lui dit qu'à l'époque il ne savait personnellement rien du « révisionnisme » et «négationnisme». Il ne se doutait pas alors du « fol déchaînement de passion, à travers les médias » qui allait s'abattre sur tous deux. Il lui annonce que, pour sa part, il doit « cesser toute participation à ce cruel débat ». Il lui conserve toute sa confiance en sa sincérité mais, dit-il, « conformément aux termes du communiqué ci-joint, ma décision absolue et définitive est que, à dater de ce jour, mon nom ne soit plus d'aucune façon lié au tien à propos de ce livre ».

Le communiqué adressé à *La Croix* est le suivant : « Soucieux de Vivre la Vérité, libre de toutes pressions, voyant mes propos relatifs aux travaux de Roger Garaudy, spécialement le livre *Les Mythes fondateurs de la politique israélienne,* exploités par des courants qui jouent dangereusement avec les périls antisémites, que j'ai combattus et que je combattrai toujours, je décide de retirer mes propos, m'en remettant entièrement aux seules opinions des experts de l'Église, et, demandant pardon à ceux que j'ai pu blesser, je veux laisser Dieu seul juge de la droiture des intentions de chacun ».

Il retire donc ses propos. Il bat sa coulpe. Il demande pardon et va jusqu'à se dire « libre de toutes pressions » ! C'est ce qu'il appelle, en usant de majuscules, être « soucieux de Vivre la Vérité ». Plus tard, il dira au professeur Léon Schwartzenberg : « Je te demande pardon [19]. » Plus tard encore, il choisira une voie typiquement médiatique pour essayer d'obtenir le pardon des juifs et son retour en grâce auprès des médias. Dans sa livraison de *Faits et Documents* du 15 octobre, Emmanuel Ratier écrit en effet : « L'abbé Pierre a vraiment fait sa *techouva* (pénitence juive) quant à son soutien à Roger Garaudy. Il sort avec le groupe Planet Generation Global Move, un groupe musical « engagé et humanitaire », un CD de quatre titres intitulé Le Grand Pardon. Ce mini-CD, qui se veut "une musique pour une conscience planétaire contre tous les nationalismes", comporte aussi pour titres No Escape (abbé Pierre-Dee Nasty, père du hip-hop en France), 2 Zion (King-MajaSutra) et Kaï in ze sky (King) ». Dans sa livraison du 31 octobre au 6 novembre, *Le Nouvel Observateur* reprend l'information ; dans un article intitulé « Le rap du repentir », le magazine précise que le projet de ce CD a été conçu par l'association « Les Anges pressés » et qu'il « se veut une mise au point hip hop sur l'affaire Garaudy ».

Cependant, les maximalistes juifs se déclarent évidemment insatisfaits ; la rétractation de l'abbé Pierre ne les convainc pas. La « confiance » qu'il maintient en la sincérité de son ami Garaudy laisse perplexes le Conseil représentatif des institutions juives de France (CRIF) et la LICRA.

## Les à-côtés de l'affaire

L'affaire Garaudy-abbé Pierre a créé l'habituel climat de chasse aux sorcières entretenu par les médias en général et le journal *Le Monde* en particulier. Pendant plusieurs mois se sont succédé en France toutes sortes d'autres « affaires » du même genre, dont les victimes ont été soupçonnées d'avoir commis le péché mortel de révisionnisme. Citons, à titre d'exemples, l'affaire Olivier Pernet, professeur de philosophie à Lyon, celle de Marc Sautet, le promoteur des cafés de philosophie, celle de Raymond Boudon et de Bernard Bourgeois, membres de la Société française de philosophie, celle de Noëlle Schulman, enseignante de physique-chimie dans un collège du département des Yvelines, celle des nageuses olympiques préparant pour les Jeux d'Atlanta un spectacle destiné à évoquer l'« Holocauste » et celle de l'hebdomadaire corse *U Ribombu,* organe d'un mouvement autonomiste corse, prenant parti pour R. Garaudy et l'abbé Pierre. Ainsi qu'on l'a vu plus haut, l'ultra-gauche et la gauche libertaire ont été saisies d'une frénésie d'accusations mutuelles et d'auto-accusations. La loi Fabius-Gayssot a été remise en question, sauf par les communistes « lignards » Jean-Claude Gayssot et Charles Lederman. Une foule d'hommes politiques sont intervenus, la plupart du temps avec le souci d'insulter les révisionnistes, privés, comme d'habitude, de tout droit de réponse à la vague déferlante des attaques, des calomnies, des diffamations. Les porte-parole de la communauté juive ont entonné à nouveau leurs couplets sur la résurgence de la bête immonde ; ils ont exprimé leur colère, sentiment dans lequel, apparemment, ils se plaisent à vivre.

## Une conséquence positive : l'aveu de Jacques Baynac

Jacques Baynac, âgé de cinquante-sept ans, est un historien orthodoxe, marqué à gauche. Il est l'auteur de *Ravachol et ses compagnons, Mai [1968] retrouvé, Les Socialistes révolutionnaires russes (1881-1917), La Révolution gorbatchévienne*. Antirévisionniste convaincu depuis toujours, il a collaboré avec l'historienne Nadine Fresco, jusque dans les colonnes du *Monde,* à la dénonciation, en particulier, de R. Faurisson et de P. Guillaume [20]. Je me souviens d'une algarade personnelle avec lui, à Paris, en octobre 1980.

Or, les 2 et 3 septembre, *Le Nouveau Quotidien* (de Lausanne) publie une longue étude, très informée, sur le révisionnisme à la lueur, si l'on peut dire, de l'affaire Garaudy-abbé Pierre. J. Baynac y affirme que les révisionnistes, qu'il appelle « négationnistes », ont tout lieu de se réjouir de ce scandale qui a « changé l'atmosphère en leur faveur ». Il note que, chez les adversaires des révisionnistes, « le désarroi a succédé à la consternation », que Pierre Vidal-Naquet « se désole », que Bernard-Henri Lévy « s'affole », que Pierre-André Taguieff « s'effraie » et que, depuis le début de « l'affaire Faurisson» en 1978-1979, les historiens ont préféré se dérober : ils « se sont défilés ». Il reproche à ces historiens d'avoir fait confiance à Jean-Claude Pressac, un pharmacien, un « historien amateur». Il considère que, pour prouver l'existence des chambres à gaz nazies, on a trop eu recours aux témoignages, ce qui est « ascientifique ». Quant aux preuves scientifiques, il commence par rappeler le constat de l'historien juif américain Arno Mayer en 1988 :

> Les sources dont nous disposons pour étudier les chambres à gaz sont à la fois rares et peu sûres.

Puis, allant plus loin, il dit qu'il faut avoir la franchise de reconnaître qu'en fait de documents, de traces ou d'autres preuves matérielles prouvant l'existence desdites chambres à gaz, il n'y a tout simplement... rien ! Il croit, pour finir, que les historiens devraient désormais s'efforcer à l'avenir d'explorer une autre voie : puisqu'il est décidément impossible de prouver que ces chambres à gaz ont existé, J. Baynac suggère que les historiens cherchent à prouver qu'il est impossible qu'elles n'aient pas existé !

Cette prise de position n'est pas vraiment nouvelle pour les connaisseurs. Depuis plusieurs années, des historiens orthodoxes ont tenu des propos analogues ou se sont comportés comme s'ils cherchaient à se débarrasser de ces encombrantes chambres à gaz. Mais c'est probablement la première fois qu'un historien orthodoxe fait ainsi publiquement des aveux d'une telle candeur [21].

## Une dure leçon, un progrès

Deux octogénaires, qui croyaient connaître la vie et les hommes, ont découvert soudainement, et avec une surprise d'enfants, qu'en réalité leur existence passée avait été, en somme, facile. Tous deux, en quelques jours, ont eu à affronter une épreuve exceptionnelle : celle que les organisations juives ont pour habitude d'infliger aux individus qui ont le malheur de provoquer leur colère. Il n'y a là, de la part de ces organisations, ni complot, ni conjuration mais comme un réflexe ancestral. Les médias, qui sont à leur dévotion et à qui il peut coûter très cher de les contrarier, savent se mobiliser contre les « antisémites », c'est-à-dire contre des personnes qui, sauf exception, ne haïssent pas les juifs mais sont haïes par les juifs. La haine vétéro-testamentaire est l'une des plus redoutables qui soient : anxieuse, fébrile, frénétique, illimitée, elle suffoque ses victimes par la soudaineté et la durée de sa violence. Elle est inextinguible parce que ceux qui l'éprouvent ne peuvent pas se permettre d'en révéler le vrai motif et de soulager ainsi, au moins en partie, leur fureur. Par exemple, on a, pendant des mois, cherché querelle à R. Garaudy sur son estimation « minimisante » du nombre des juifs qui sont morts pendant la seconde guerre mondiale. Mais ce n'était qu'affectation. Le vrai motif était ailleurs ; il était dans la mise en doute sacrilège de l'existence des chambres à gaz. Cependant, révéler cette mise en doute, c'était prendre le risque de faire naître ce doute dans le grand public ou de l'accroître. D'où la nécessité de parler d'autre chose. Dès le 27 avril, j'écrivais :

> Je note jusqu'ici la timidité, pour ne pas dire le quasi-silence, des journalistes sur le sujet des chambres à gaz. Tous auraient dû, sur-le-champ, dénoncer le profond scepticisme de Garaudy en la matière. Mais telle est précisément la caractéristique du tabou : ceux qui ont pour mission de le préserver n'osent pas même révéler qu'il a été profané. Garaudy a pénétré dans le saint des saints et il a découvert que le tabernacle censé contenir la magique chambre à gaz était vide. Taisons la nouvelle !

Cette observation, qui date du 27 avril, est restée valable pour tous les mois qui ont suivi.

En ce qui concerne l'abbé Pierre, on s'est livré au même manège. On a tempêté contre son prétendu antisémitisme et contre son entêtement à soutenir un vieil ami qui s'était égaré ; en réalité, son crime a été de réclamer... un débat et de le réclamer avec insistance et ingénuité. Agir comme le faisait le vieil homme, c'était d'abord révéler au grand public qu'il n'y avait précisément pas de débat ; ensuite, c'était placer les historiens, les journalistes et les responsables des organisations juives dans la plus inconfortable des positions : celle d'avoir à forger de minables prétextes pour fuir un débat dont on avait manifestement peur comme de la peste.

R. Garaudy et l'abbé Pierre ont une haute idée d'eux-mêmes ; leurs écrits ou leurs propos respirent la fausse humilité ; ils parlent un peu trop du cœur, de leur cœur ; ils s'affirment volontiers « épris d'absolu », ce qui est beaucoup, et ils se disent animés « de la même passion du vrai », ce qui est présomptueux. En la circonstance, il leur est arrivé de fortement maltraiter la simple vérité.

L'épreuve soudaine qu'ils ont eue à subir en fin de vie devrait les amener à plus de modestie. Comme on dit dans le langage de tous les jours, ils ont « craqué ». R. Garaudy a le mérite de continuer son combat mais il ne peut plus l'appeler un combat pour toute la vérité puisque, par peur et par opportunisme, il en est venu, selon les circonstances, soit à fortement atténuer, soit à totalement abandonner le combat pour la vérité historique sur ce qu'il appelait, dans son livre, le mythe de l'Holocauste. Quant à l'abbé Pierre, il en est venu à abandonner toute dignité. Personnellement, je ne puis leur en faire vraiment grief parce que je suis payé pour savoir ce qu'il en coûte d'affronter les forces de la haine, du mensonge ou de la bêtise dans le domaine limité de la recherche historique. Mais je regrette que l'affaire Garaudy-abbé Pierre ait, en fin de compte, pris cette tournure. Je le regrette pour les deux intéressés et pour les révisionnistes français, quoique, pour le révisionnisme lui-même, cette affaire ait, en dépit de tout, marqué un nouveau progrès, à l'échelle du monde entier, dans la recherche de la vérité historique.

C'est ainsi que, pour la première fois depuis 1945, un historien orthodoxe, J. Baynac, s'est vu contraint d'admettre qu'il n'y a aucune preuve de l'existence des prétendues chambres à gaz nazies.

BIBLIOGRAPHIE

- Roger GARAUDY, *Les Mythes fondateurs de la politique israélienne,* paru en numéro spécial, hors commerce, de la revue *La Vieille Taupe,* n° 2, décembre 1995, 240 p.

- Roger GARAUDY, *Les Mythes fondateurs de la politique israélienne,* Samizdat Roger Garaudy, 1996 [mars], 279 p. ; sans en prévenir le lecteur, l'auteur a sensiblement modifié son texte pour en atténuer le caractère révisionniste. On comparera, par exemple, les pages 119-120 de la première édition avec les pages 134-135 de la seconde édition. Il n'y a pas de bibliographie, sinon, sous la dénomination de « bibliographie », une liste des ouvrages du même auteur ainsi qu'une liste des études qui lui ont été consacrées.

- Roger GARAUDY, *Le Communisme et la morale,* Éditions sociales, 1945, 126 p. ; cet opuscule, qui s'ouvre, en guise de préface, sur un long extrait d'un texte de Maurice Thorez (secrétaire général du Parti communiste français), permet de faire le point sur le communisme orthodoxe de l'auteur en 1945.

- Roger GARAUDY, *Parole d'homme,* Robert Laffont, 1975, 269 p. ; cet ouvrage permet de faire le point sur la personnalité de l'auteur et sur ses idées en 1975.

- Michel-Antoine BURNIER et Cécile ROMANE, éditions Mille et Une Nuits, collection « Les petits libres », n° 11, 1996 [juin], 48 p. in-16 ; les auteurs révèlent que, dans un ouvrage qu'ils avaient publié en 1993 aux éditions Robert Laffont, ils avaient jugé bon de censurer certains propos de l'abbé Pierre.

- Collectif (Pierre Rabcoz, François-Georges Lavacquerie, Serge Quadruppani, Gilles Dauvé, «Reflex») *Libertaires et ultra-gauche contre le négationnisme,* préface de Gilles Perrault, 1996 [juin], 111 p.

- Pierre-André TAGUIEFF, « L'abbé Pierre et Roger Garaudy. Négationnisme, antijudaïsme, antisionisme », *Esprit,* août-septembre 1996, p. 205-216.

- Roger GARAUDY, *Droit de réponse. Réponse au lynchage médiatique de l'abbé Pierre et de Roger Garaudy,* Samizdat Roger Garaudy, 1996, 38 p. ― Le n° 47 du bimestriel Golias Magazine (mai 1996), organe de catholiques de gauche ou d'extrême gauche.

- *La Croix,* 23 juillet 1996 ; cette livraison contient le « Communiqué à La Croix » du 22 juillet (« je décide de retirer mes propos »), le texte d'une lettre « A Roger Garaudy, le 22 juillet 1996 », ainsi que des extraits d'une circulaire de quatre pages, rédigée en juillet 1996 à l'abbaye de Praglia et intitulée « Réponse à un inconnu ». L'intégralité de cette circulaire n'a nulle part été reproduite. La Croix en a édulcoré le contenu par d'habiles coupures dont l'une, non signalée, est particulièrement malhonnête. Les propos de l'abbé Pierre sur la mise en examen de R. Garaudy, due à une plainte de la LICRA, et sur la loi Gayssot sont passés sous silence. Ils constituent le seul passage où l'abbé fait preuve de caractère, quand il écrit :

La LICRA a attaqué [R. Garaudy] en justice ; je suis tenté de dire : "tant mieux !" Mais j'ai compassion pour les juges qui auront à décider en fonction d'une loi, dite Gayssot, déclarée par Simone Veil "loi qui affaiblit la vérité historique en essayant de lui donner valeur légale". Loi contre laquelle votèrent, avec Chirac, Juppé, Deniau, Jean de Gaulle, Barre, Balladur, les actuels ministres de la Justice et de l'Intérieur Debré, et plus de deux cent cinquante députés, membres aujourd'hui de la majorité. Certes les termes de la loi Gayssot sont si nouveaux, et si absurdes, qu'ils placent les juges dans une position impossible, selon les propos de Monsieur Toubon [le 21 juin 1991] déclarant cette loi "inapplicable".

- *Le Nouveau Quotidien de Lausanne,* 2 et 3 septembre 1996 ; ces deux livraisons comportent une longue étude de Jacques Baynac, intitulée « Le débat sur les chambres à gaz ».

- Robert FAURISSON, « Un historien orthodoxe admet enfin qu'il n'y a pas de preuves des chambres à gaz nazies » ; ce texte, daté « 2 et 3 septembre 1996 », porte sur l'étude, susmentionnée, de J. Baynac.

1er novembre 1996

Notes

[1] R. Garaudy, *Les Mythes fondateurs de la politique israélienne,* paru dans La Vieille Taupe, n° 2, hiver 1995, p. 119.

[2] Id., p. 72-147.

[3] Id., p. 135.

[4] Voy. *Écrits révisionnistes* (1974-1998), p. 1759.

[5] « Si [l'abbé Pierre] avait nié la divinité du Christ, la presse l'acclamerait pour sa farouche indépendance d'esprit. » J. Sobran, *The Wanderer,* 9 mai 1996 (hebdomadaire catholique de l'Ohio ― États-Unis.).

[6] *Tribune juive,* 16 mai 1996.

[7] Selon *Le Figaro,* 1er-2 juin 1996.

[8] *Droit de réponse. Réponse au lynchage médiatique de l'abbé Pierre et de Roger Garaudy,* Chennevières-sur-Marne, samizdat Roger Garaudy, 1996, p. 33-34.

[9] Id., p. 35-36.

[10] *Le Message de l'Islam,* Téhéran, juin 1996, p. 21.

[11] Collectif, *Libertaires et ultra-gauche contre le négationnisme,* Paris, Reflex, 1996.

[12] Id., p. 8.

[13] Id., p. 9.

[14] Id., p. 57.

[15] Id., p. 60.

[16] Id., p. 47.

[17] Id., p. 66.

[18] Voy. « Milices juives. Quinze ans ― et plus ― de terrorisme en France », *Écrits révisionnistes (1974-1998),* p. 1694.

[19] *Le Figaro,* 22 août 1996.

[20] J. Baynac et N. Fresco, « Comment s'en débarrasser ? », *Le Monde,* 18 juin 1987, p. 2.

[21] Pour plus de détails, voy. R. Faurisson, « Un historien orthodoxe admet enfin qu'il n'y a pas de preuves des chambres à gaz nazies », *Écrits révisionnistes (1974-1998),* p. 1794.

Labels: Le Monde, rapport Leuchter, abbé Pierre, Arno Mayer, Baynac, Garaudy, Henri Roques, Joseph Sitruk, LICRA, Loi Gayssot, Nouveau Quotidien de Lausanne, Pierre Guillaume

---

- [Sommaire des articles](index.html)
