---

<!-- http://robertfaurisson.blogspot.com/1983/01/apres-laudience-dappel-de-decembre-1982.html -->
<!-- Wednesday, January 12, 1983 -->

# Après l'audience d'appel de décembre 1982

Je laisse le soin à mon avocat de développer les moyens juridiques et je me contenterai de répondre ici aux affirmations et aux insinuations de la Ligue internationale contre le racisme et l'antisémitisme (LICRA), du Mouvement contre le racisme et pour l'amitié entre les peuples (MRAP) et, enfin, de la société Amicale des anciens déportés des camps d'Auschwitz et de Haute-Silésie (ADAC-Haute-Silésie).

Depuis quatre ans, ces associations me font grief d'appartenir à une école historique, dite révisionniste, pour laquelle les prétendues chambres à gaz homicides de Hitler et le prétendu génocide des juifs forment un seul et même mensonge historique. Dès la fin de la première guerre mondiale, des auteurs révisionnistes avaient pris pour objet d'étude les rumeurs et les propagandes d'atrocités des belligérants des deux camps et s'étaient interrogés sur le problème des responsabilités dans le déclenchement du conflit. À ce dernier problème, nulle réponse bien claire n'avait pu être apportée. (Pour ma part, je n'ai jamais su dire, pour quelque guerre que ce fût, qui était le responsable et qui était la victime.) En revanche, pour ce qui est des rumeurs et des propagandes d'atrocités, des auteurs comme Harry Elmer Barnes pour les États-Unis, Arthur Ponsonby pour la Grande-Bretagne et Jean Norton Cru pour la France avaient démontré que l'imagination et la crédulité étaient sans bornes pour décrire la barbarie de l'ennemi [1]. Il n'y a pas de guerre sans propagande de guerre. La première victime d'une guerre est toujours, comme on l'a dit, la vérité. La vérité, c'est ce qui est vérifiable ; et le contraire de la vérité s'appelle le mensonge. S'il est quelquefois difficile ou impossible de discerner la vérité, il est souvent facile de débusquer le mensonge. L'affaire des enfants belges aux mains coupées par les Allemands était un mensonge que dès 1914 André Gide avait percé à jour. Il faut dire qu'il entendait, d'après ses propres paroles, ne pas croire son ennemi capable de tout et de n'importe quoi. L'affaire des usines allemandes où l'on se servait de graisse humaine pour en faire du savon ou des engrais était un autre mensonge. L'affaire du Lusitania présenté comme un navire inoffensif était encore un mensonge. Aujourd'hui, certains bobards journalistiques de la première guerre mondiale apparaissent d'une telle naïveté qu'il suffit de les rapporter pour que leur nature de bobards se révèle sans difficulté à l'esprit le plus obtus. C'est que le temps a passé. En voici un exemple cité par Arthur Ponsonby dans *Falsehood in Wartime* [2]. En novembre 1914, les Allemands venaient de prendre Anvers et, pour fêter cette victoire, on avait fait sonner les cloches des églises. On avait, bien entendu, fait sonner ces cloches en Allemagne et non pas à Anvers ! Aussi le journal de Cologne (*Die Kölnische Zeitung*) put-il écrire :

Quand la chute d'Anvers fut connue, les cloches des églises se mirent à sonner.

Or, voici en quels termes la nouvelle fut répercutée dans la presse alliée, c'est-à-dire dans des journaux respectivement français, britannique, italien, puis à nouveau dans le journal français :

*Le Matin* : D'après la *Kölnische Zeitung,* le clergé d'Anvers a été contraint de sonner les cloches après la prise de la forteresse.

*The Times* : D'après les informations que *Le Matin* a reçues de Cologne, les prêtres belges qui ont refusé de sonner les cloches après la prise d'Anvers ont été chassés de leurs postes.

*Corriere della Sera* : D'après les informations que le *Times* a reçues de Cologne, via Paris, les malheureux prêtres qui ont refusé de sonner les cloches des églises après la prise d'Anvers ont été condamnés aux travaux forcés.

*Le Matin* (à nouveau) : D'après les informations du *Corriere della Sera* reçues de Cologne, via Londres, on confirme que les barbares vainqueurs d'Anvers ont puni les malheureux prêtres belges de leur refus héroïque de sonner les cloches des églises, en les pendant aux cloches comme des battants.

Il est probable que les lecteurs français de novembre 1914 ont pris pour argent comptant cet ignoble et grotesque mensonge et qu'il aurait été dangereux d'aller prétendre que le journal *Le Matin* avait utilisé dans la fabrication de cette nouvelle tous les ingrédients les plus classiques de la propagande de haine. Parmi ces ingrédients je me contenterai de citer celui des « diverses sources », celui de la scansion par trois adjectifs stéréotypés (barbares vainqueurs ― malheureux prêtres ― refus héroïque) et surtout l'ingrédient idéal que constitue le martyre du saint (ici, il s'agit de prêtres ; ailleurs on choisit des bonnes sœurs ou un évêque ou un saint). Je ne veux pas dire, bien sûr, qu'il n'y ait pas eu de victimes réelles des Allemands parmi les gens du clergé. Je dis simplement, pour l'avoir bien des fois constaté, que les fabulateurs abusent souvent du crédit accordé au clergé pour mieux faire passer un mensonge antiallemand. [Rectification de 1997 : constatant que les sources invoquées (des journaux allemand, français, anglais, italien) étaient dépourvues de toute précision, en particulier de dates, je demandais, dans les années quatre-vingt, à un chercheur américain, D. G., d'entreprendre une recherche sur le sujet. Vérification faite, A. Ponsonby s'était trompé et je l'avais suivi dans ses errements. A l'origine de cette histoire des prêtres d'Anvers se trouvait, en fait, un article de la Kölnische Zeitung [3] où un journaliste allemand avait, de toutes pièces, inventé ces extraits de journaux alliés avec l'intention de se moquer de la propagande alliée. Le fait était signalé par James Morgan Read en 1941 [4]. J'en prévenais ultérieurement le révisionniste Jean Plantin qui allait en faire état dans *Mensonges et rumeurs en temps de guerre,* avec insertion d'une note rectificative [5]. Voy. mon article « Le premier historien révisionniste après la seconde guerre mondiale », reproduit dans le volume III des Écrits révisionnistes (1974-1998), p. 1322.]

Pour le comparer avec un mensonge de la première guerre mondiale, je citerai maintenant un mensonge de la seconde guerre mondiale. Fort probablement, le lecteur cette fois-ci ne verra pas d'emblée que ce mensonge-ci est tout aussi ignoble et grotesque que ce mensonge-là. C'est que le temps n'a pas encore fait son office et que nous restons encore imprégnés par la propagande d'atrocités de la dernière guerre. Il s'agit d'un témoignage concernant la « chambre à gaz » de Dachau. Il émane d'un Français qui est toujours en vie en 1983, à l'heure où j'écris. Ce Français s'appelle Fernand Grenier et son livre s'intitule *C'était ainsi*. Voici le texte du témoignage :

> À côté des quatre fours crématoires qui ne s'éteignaient jamais, une chambre : des douches avec, au plafond, des pommes d'arrosoir. L'année précédente [1944] on avait remis à cent vingt enfants de huit à quatorze ans une serviette et un savon. Ils étaient entrés tout joyeux. On ferma les portes. Des douches s'échappèrent des gaz asphyxiants. Dix minutes après, la mort avait tué ces innocents que les fours crématoires réduisaient en cendres une heure après [6].

Il y a ainsi sur les prétendus gazages homicides de Dachau une quantité de témoignages, de preuves, sinon d'aveux. Par exemple, dans son livre *Prison et Déportation,* Mgr Piguet, évêque de Clermont-Ferrand, avait écrit que des prêtres polonais étaient passés par la « chambre à gaz » de Dachau [7]. On possède même un début d'expertise de cette « chambre à gaz » ; elle émane d'un capitaine de l'armée française nommé Fribourg. Jusqu'en 1960, la réalité de cette « chambre à gaz » constituait une vérité officielle. Malheur à qui aurait mis en doute son authenticité ! On l'aurait insulté, traité de nazi, accusé de diffamation ; et de pieuses associations, chargées, par elles-mêmes, de la défense des vérités patriotiques, l'auraient attrait en justice pour « dommage » par « falsification de l'Histoire » (articles 1382 et 1383 du Code civil). Mais il se trouve qu'en 1960, exactement à partir du 19 août, une haute autorité de l'Institut d'histoire contemporaine de Munich, pourvue de toutes les cautions exterminationnistes, a déclaré subitement dans l'hebdomadaire *Die Zeit* qu'il n'y avait jamais eu de gazage homicide à Dachau, non plus que dans tous les camps situés dans l'Ancien Reich (Allemagne dans ses frontières de 1937) ; il n'y avait eu avant tout (?) de tels gazages que dans le territoire occupé polonais : à Auschwitz-Birkenau, à Sobibor-sur-Bug, à Treblinka, Chelmno et Belzec (autrement dit en Pologne communiste). Du même coup s'évanouissaient les gazages de Ravensbrück, de Mauthausen, du Struthof-Natzweiler, de Neuengamme, d'Oranienburg-Sachsenhausen, de Buchenwald, de Majdanek-Lublin, etc. S'évanouissaient avec ces gazages cent, mille ou dix mille témoignages, preuves et aveux. Çà et là on avait pendu ou conduit au suicide des responsables de camps qui, sans ces gazages, auraient sans doute eu la vie sauve. Cette haute autorité (le Dr Broszat) se gardait bien de nous révéler pourquoi il ne fallait plus croire aux gazages dans ces camps-là et pourquoi il fallait persister à croire aux gazages des camps situés en Pologne. Depuis le 19 août 1960, nous attendons la liste des critères de la vraie et de la fausse «chambre à gaz» et cette liste ne vient toujours pas, malgré nos objurgations répétées. Car, il faut le savoir, rien ne ressemble plus à une preuve d'Auschwitz qu'une preuve de Dachau.

Fernand Grenier ― on a le droit de le dire aujourd'hui mais on ne pouvait le dire avant 1960 ― n'est qu'un de ces innombrables faux témoins pour qui la haine de l'Allemagne, le souci de se faire passer pour un héros, un martyr ou un saint, ou tel autre motif du même genre l'a emporté sur le devoir d'être vrai : un devoir qui exige du courage dans la France d'aujourd'hui et qui, en République fédérale d'Allemagne, va jusqu'à exiger de l'héroïsme. Le court témoignage de F. Grenier ne contient que douze inventions ; c'est peu quand on le compare à des Martin Gray ou à des Filip Müller (ce dernier a publié un livre intitulé *Trois ans dans une chambre à gaz d'Auschwitz* qui a bénéficié d'une sortie tapageuse et la LICRA lui a décerné le prix Bernard Lecache à l'unanimité). Ces douze inventions sont les suivantes :

1° les quatre fours crématoires qui ne s'éteignaient jamais (il n'existe pas de fours capables de ces prouesses) ;

2° les chambres aux fausses douches avec leurs pommes d'arrosoir ;

3° l'année où l'événement s'est produit (à la différence de bien des témoins, il ne va pas jusqu'à donner le mois, le jour et l'heure) ;

4° les enfants ;

5° le nombre de ces enfants ;

6° les âges de ces enfants ;

7° les cent vingt serviettes et les cent vingt savons (sic) ;

8° la toute joie des enfants en entrant ;

9° la fermeture des portes (au pluriel : plusieurs portes pour une « chambre à gaz » !) ;

10° les gaz asphyxiants ;

11° le délai de dix minutes pour que survienne la mort ;

12° la durée-record de la crémation de cent vingt cadavres d'enfants dans quatre fours : une heure seulement alors qu'aujourd'hui, avec des moyens autrement modernes que ceux de 1944, il faudrait à quatre fours du genre de ceux qui fonctionnent au cimetière parisien du Père-Lachaise... deux cent vingt-cinq heures, soit environ neuf jours (quarante-cinq minutes pour les cadavres n'ayant pas reçu d'antibiotiques ; sinon, cinquante à soixante minutes).

Le faux témoignage en matière d'atrocités allemandes reste encore aujourd'hui d'un grand rendement financier, politique et moral. Dans ce domaine une véritable compétition et une surenchère dans l'antinazisme de sex-shop ont permis le développement d'une industrie prospère. Les productions de Christian Bernadac ont été souvent dénoncées à ce titre par les anciens déportés eux-mêmes, mais il ne semble pas que ce soit pour des motifs tout à fait louables. On a surtout reproché à ce dernier d'avoir exploité le filon d'une manière éhontée. Car, si l'exploitation du filon paraît se faire pour la bonne cause, les associations ne protestent plus ; au contraire elles se soutiennent par un silence complice. Prenons un exemple. Nous savons depuis plus de vingt-deux ans qu'il n'y a jamais eu de gazage homicide au camp d'Oranienburg-Sachsenhausen. Or, l'Amicale des anciens internés de ce camp vient de publier un gros ouvrage intitulé *Sachso* dans lequel on affirme l'existence et le fonctionnement dans ce camp d'une chambre à gaz homicide. Deux photos prétendent venir appuyer cette affirmation ; elles ont la lourde naïveté de la propagande soviétique à qui nous devons ces photos et leurs légendes. Il y est notamment question d'une ampoule de Zyklon B. Or, le Zyklon B, qui fut inventé en 1917 et qui est encore couramment utilisé dans le monde entier comme désinfectant, n'a jamais existé en ampoule ; le Zyklon B est un absorbat d'acide cyanhydrique sur base poreuse inerte : la terre d'infusoires, par exemple. Ajoutons que le Zyklon B, selon les besoins de son emploi, possède ou ne possède pas, en complément, une substance d'avertissement.

La crédulité générale en matière de chambre à gaz homicide tient pour une bonne part dans le fait que les gens qui emploient cette expression de « chambre à gaz » n'ont pas réfléchi au sens de ces mots. Comme bien souvent, ils n'ont pas commencé par le commencement. La question préalable à tout développement sur ce sujet devrait être : « Mais, au fait, à quelle réalité matérielle peut bien correspondre cette expression ? Qu'est-ce qu'une chambre à gaz ? Comment y fait-on pénétrer un gaz mortel ? Comment le gazeur et son entourage peuvent-ils se prémunir contre les dangers d'emploi de ce gaz? Et, surtout, comment faire après la mise à mort du condamné pour évacuer ce gaz et pénétrer dans la pièce pour en extraire le cadavre ? » Trop de gens se représentent une « chambre à gaz » comme une réalité au fond assez proche d'une simple chambre à coucher sous la porte de laquelle il passe du gaz domestique. Ces gens constituent une proie facile pour tous ceux qui font visiter au bon touriste une pièce aux murs nus (dotée de quelques trous dans le plafond) et auquel on dit : « Voici une chambre à gaz homicide ! » Le touriste ne voit pas pourquoi il ne croirait pas aux paroles du guide. Si dans cette pièce, comme c'est le cas à Majdanek, il y a toute une série de minces fenêtres à hauteur d'homme, il ne lui viendra pas à l'idée que la présence de telles fenêtres constitue une absurdité dans une chambre à gaz. Les carreaux une fois brisés, le gaz s'échapperait à l'extérieur et mettrait en péril la vie de l'entourage ; quant aux victimes que les premières émanations n'auraient pas étourdies ou tuées, elles prendraient facilement la fuite.

L'installation et le fonctionnement d'une chambre à gaz destinée à ne tuer qu'une seule personne constituent un redoutable problème technique. J'ai pu m'en rendre compte en cherchant comment les Américains s'y étaient pris pour fabriquer leurs premières chambres à gaz, comment ils les utilisaient aujourd'hui dans une demi-douzaine de pénitenciers dont j'ai obtenu une intéressante documentation et, en particulier, comment fonctionnait la chambre à gaz de Baltimore dont j'ai publié les photos et le mode d'emploi dans le livre de S. Thion, *Vérité historique ou Vérité politique ?*... On y trouvera la liste des quarante-sept opérations nécessitées par une exécution à l'acide cyanhydrique [8]. Pour ne prendre qu'un exemple, la quarante-septième et dernière opération est ainsi résumée : « Vider la chambre, enlever le corps. » On pourrait croire que cette opération est simple. En réalité, elle consiste en ceci :

Le médecin et ses assistants, après avoir laissé passer près d'une heure pour que de puissants exhausteurs aspirent le gaz pour le conduire vers un barboteur où il est neutralisé par de l'ammoniaque et rejeté par une cheminée située au plus haut du pénitencier, doivent entrer dans la chambre à gaz avec un masque à gaz, un tablier de caoutchouc, des gants de caoutchouc ; le médecin secoue la chevelure du mort pour en chasser autant que possible les molécules d'acide cyanhydrique que les fumées d'ammoniaque et le système de ventilateurs orientables n'ont pas pu neutraliser ; les deux assistants doivent laver le corps avec un jet ; ils doivent apporter un grand soin à ce travail ; ils doivent notamment laver la bouche, toutes les ouvertures du corps et ils ne doivent surtout pas oublier les plis des bras et des genoux.

C'est vers 1917 que, pour la première fois, des Américains à la recherche d'une façon plus humaine de tuer les condamnés avaient songé à l'emploi du gaz cyanhydrique. Ils n'imaginaient pas que les problèmes techniques rencontrés en cours de route exigeraient des années pour être surmontés. La première exécution eut lieu en 1924 au pénitencier de Carson City, Nevada. Deux heures après l'exécution on relevait encore des traces de gaz dans la cour de la prison. M. Dickerson, gouverneur du pénitencier, déclara qu'en ce qui concernait le condamné la méthode était certainement la plus humaine jusqu'ici employée. Mais il ajouta qu'il renoncerait à cette méthode à cause du danger qu'elle faisait courir aux témoins. C'est seulement vers 1936-1938 que les Américains semblent avoir mis au point leurs chambres à gaz.

De toutes les armes, le gaz est la moins maniable. L'acide cyanhydrique présente, de plus, l'inconvénient d'adhérer longuement et fortement aux surfaces. Son emploi encore actuel dans la désinfection des locaux d'habitation, des usines, des bateaux, des meuneries, des silos, des bibliothèques, exige un luxe de précautions. J'ai retrouvé dans les archives nationales de Washington un texte allemand datant de la guerre intitulé : « Directives pour l'utilisation de l'acide prussique (Zyklon) en vue de l'extermination de la vermine (désinfection) ». Je l'ai reproduit en traduction dans mon *Mémoire en défense* [9]. Pour tuer la vermine, il faut, selon la température, de six à trente-deux heures. Puis viendra le moment le plus critique : celui de l'aération. Le texte porte :

> L'aération présente le plus grand danger pour les participants comme pour les non-participants. Il faut donc y procéder avec une prudence particulière et toujours en portant des masques à gaz.

Cette aération devra durer « au moins vingt heures ». Pour que commence cette aération, il a fallu entrer dans les lieux avec un masque au filtre le plus sévère (filtre J). On a ouvert les portes et les fenêtres. Si les fenêtres requièrent un effort pour être ouvertes, il ne faut pas insister. Tout effort physique est à éviter. Il faut à plusieurs reprises interrompre son travail, se porter à l'air libre et, là, ôter son masque pour respirer l'air frais pendant dix minutes. Lorsque les vingt heures sont passées (vingt-quatre heures dans le cas de la législation française), on pénètre dans les lieux avec le masque et on procède à un test, avec un papier indicateur de gaz résiduel, dans chaque pièce séparément. En aucun cas on ne peut dormir pendant la nuit qui suit le gazage dans une pièce qui a été gazée. Les matelas, paillasses, etc. ont dû être portés à l'air libre ou dans un hall aéré pour être battus pendant une ou deux heures selon la température. Car les molécules de gaz cyanhydrique ont tout imprégné.

On est dès lors stupéfié par les récits de gazages homicides dans les camps allemands. Il est manifeste que tous ces récits, repris en antiennes, à d'étonnantes variations près, offensent les lois de la physique et de la chimie. Les exterminationnistes invoquent le plus souvent pour Auschwitz ce qu'ils appellent le témoignage de Rudolf Höss, l'un des trois commandants successifs du camp. En réalité, il s'agit de confessions obtenues par la justice communiste de Pologne avant la pendaison de l'intéressé. Pour toutes sortes de raisons que je ne peux énumérer ici, le texte de ces confessions est totalement inacceptable. Seules des juridictions d'exception peuvent admettre de prendre en considération de telles impostures. J'appelle juridiction d'exception celle, par exemple, du Tribunal militaire international de Nuremberg ; les articles 19 et 21 du statut de ce tribunal disposaient que :

> Le Tribunal ne sera pas lié par les règles techniques relatives à l'administration des preuves [...], n'exigera pas que soit rapportée la preuve de faits de notoriété publique, mais les tiendra pour acquis. [...]

Höss est censé avoir dit qu'on enfermait deux mille victimes à la fois dans une chambre à gaz dont seul le toit émergeait du sol. Une demi-heure après avoir « lancé » le gaz on ouvrait la porte et on mettait en marche l'appareil de ventilation. On commençait alors *immédiatement* (mot souligné par moi) à extraire les cadavres. Cette extraction était faite par une équipe de détenus avec une morne indifférence ; en effet, tout en tirant les cadavres, ces détenus mangeaient ou fumaient. C'est assez dire qu'ils ne portaient pas de masques à gaz. D'ailleurs, en eussent-ils même porté, on a vu que tout effort physique était impossible. Il aurait été radicalement impossible de pénétrer ainsi dans une salle pleine de gaz cyanhydrique pour en extraire deux mille cadavres eux-mêmes imprégnés de gaz. Qu'on ne vienne pas nous dire que les Allemands ne se souciaient pas de la santé de l'équipe spéciale affectée à ce travail sur-herculéen ! Si, en effet, ces gens devaient entrer dans la chambre à gaz pour s'y empoisonner à leur tour, jamais la chambre à gaz n'aurait été vidée de ses victimes pour laisser place à une nouvelle fournée de victimes. Ce récit paraît encore plus absurde à ceux qui, comme moi, se sont donné la peine de retrouver les plans des lieux pour constater, en fin de compte, que l'espace baptisé « chambre à gaz » n'était en réalité qu'une chambre froide destinée à l'entreposement des cadavres.

Pour ce qui est des plans retrouvés, des photographies aériennes et autres, prises soit par les Allemands, soit par les Alliés, pendant ou après la guerre, on pourra se reporter aux deux ouvrages publiés par les éditions de La Vieille Taupe. On y verra en particulier à quelles supercheries d'ordre physique les Polonais se sont livrés pour abuser le touriste.

Nous savons, aujourd'hui, où le mythe des chambres à gaz a pris naissance, comment il s'est développé, les difficultés rencontrées par les Alliés pour mettre au point un court récit stéréotypé et nous pouvons voir également aujourd'hui comment ce mythe entre en agonie dans les milieux scientifiques. Sur ce dernier point, on pourra se reporter à ma *Réponse à Pierre Vidal-Naquet* où figure sous le titre de « Le mythe des chambres à gaz entre en agonie » le compte rendu d'une surprenante étude récemment parue dans *Le Monde juif,* revue du CDJC de Paris [10].

---

## « Jamais Hitler n'a ordonné ni admis que quiconque fût tué en raison de sa race ou de sa religion. »

La partie adverse me fait le reproche d'avoir écrit cette phrase. Or, chacun des mots qui composent cette phrase a été mûrement choisi. Je commence par remarquer que ces mots ont été lus hâtivement. L'un d'entre eux notamment doit être souligné à l'attention des distraits. Ce mot est celui de « tué ». Je n'ai jamais dit que Hitler n'avait pas poursuivi les juifs de son hostilité dès son arrivée au pouvoir. Et la guerre a aggravé cette hostilité. J'ai dit, et je le maintiens, que jamais Hitler n'a ordonné de tuer un juif, un Tzigane, un catholique, un protestant, un Français, un Slave, ou quiconque en raison de sa race ou de sa religion. Les médias ont peu à peu instillé dans l'esprit de la masse des profanes que pendant la guerre les Allemands se livraient à une continuelle chasse aux juifs afin de les tuer. Chaque juif aurait ainsi été une sorte de mort en sursis. C'est faux. Dans le camp de Hitler comme dans le camp des Alliés (mais pour ce qui est de ces derniers cela ne se dit guère), on a accumulé les horreurs et les atrocités. Partout il y a eu des massacres, des prises d'otages, des fusillades, des déportations. Et même les plus importantes déportations n'ont pas été le fait des Allemands, mais le fait des Alliés, non pas que les Alliés aient été plus cruels mais il se trouve qu'ils disposaient simplement de beaucoup plus de temps et de moyens. Douze à quatorze millions de minoritaires allemands ont été chassés ou déportés de l'Est européen dans des conditions qui, la plupart du temps, ont été abominables. Il faut malheureusement dire qu'il y a eu là un phénomène classique de beaucoup de guerres modernes. Les camps de concentration ne sont d'ailleurs pas une invention de Hitler. Ces camps, et leurs horreurs obligées en temps de guerre et de famine, sont une invention de la guerre civile américaine. Ce que les exterminationnistes voudraient nous faire croire, c'est que dans le cas des juifs, par exemple, Hitler aurait innové dans l'horreur. Ses troupes ne se seraient pas contentées de massacres comme il y en a dans toutes les guerres. Hitler aurait créé une abomination bien particulière à l'endroit des juifs et, comme ce qui est nouveau appelle, pour être désigné, un nouveau vocable, un juif polonais réfugié aux États-Unis a inventé en 1944 le mot de « génocide ». Le « génocide » ou l'« ethnocide » serait ainsi une politique d'extermination délibérée de toute une race, de tout un peuple. Hitler aurait ordonné : « Tuez-moi les juifs, tous les juifs qui vous tombent sous la main ! » En réalité, jamais un tel ordre n'a été donné et jamais les Allemands n'ont agi comme si cet ordre avait été donné. Les Allemands et le camp des Alliés (de ce dernier camp les juifs étaient partie prenante) se sont combattus. Ni d'un côté, ni de l'autre on n'a épargné les civils ou les enfants. À propos des massacres de Beyrouth, on a couramment imprimé que les Israéliens se livraient à un « génocide » ou même à des « génocides » : mensonges de propagande là encore. Les Israéliens et les Palestiniens n'ont, ni les uns, ni les autres entrepris une politique systématique d'extermination de l'adversaire. Ils sont en guerre. Étant en guerre, ils se font le plus de mal possible. Quand un belligérant s'abstient d'utiliser telle ou telle arme, ce n'est jamais, je pense, pour des considérations morales, mais pour toutes sortes de raisons qui peuvent aller de la crainte de représailles du même calibre à la crainte des réactions des non-belligérants. Dans les territoires occupés par l'armée israélienne, les autochtones et les réfugiés peuvent avoir toutes les craintes possibles, même celle de la mort : ils ne sont pas pour autant des morts en sursis.

Pour en revenir aux Allemands, il n'y a eu chez eux, ni dans les textes, ni dans les faits, de plan d'extermination des juifs, des Tziganes, des Slaves, des homosexuels. Du côté des Alliés, il n'y a pas eu non plus de plan d'extermination des Allemands. Il y a eu les bombardements systématiques des villes allemandes ou japonaises. Le seul bombardement de Dresde (« la Florence de l'Elbe ») a causé environ cent trente-cinq mille morts (« le plus grand crématoire du monde »). Il y a eu la guerre et son banal cortège d'horreurs. La guerre, c'est la banalisation du mal. Tout le monde en ressort bien dégoûtant. Il faudrait, après la tuerie, rentrer chez soi et se faire tout petit. Au lieu de cela, les vainqueurs de la dernière tuerie ont pris des airs de justiciers et les voici, encore en 1983, à poursuivre, emprisonner ou exécuter certains de leurs vaincus. Une énorme propagande de guerre continue à semer des idées de haine, de vengeance et de réparation. La grande masse des Français s'imagine que Hitler a donné l'ordre d'exterminer les juifs. Mais les historiens, eux, savent bien qu'on n'a jamais trouvé trace d'un tel ordre ni de quoi que ce fût qui impliquerait l'existence d'un tel ordre. Dès 1960, le Dr Kubovy, historien israélien, l'avait dit mais les médias sont d'une telle discrétion dans ces cas-là que les historiens qui ne sont pas des spécialistes de l'ère nazie continuent de propager l'erreur. À Paris, à la Sorbonne, du 29 juin au 2 juillet 1982, il s'est tenu un colloque d'historiens exclusivement exterminationnistes sur « L'Allemagne nazie et l'extermination des Juifs » (titre d'origine : « Le National-socialisme et les Juifs »). Ce colloque était manifestement destiné à contrecarrer le développement croissant des idées révisionnistes dont aucun représentant n'était admis à assister au colloque, même à titre d'auditeur.

Les professeurs Raymond Aron et François Furet présidaient ce colloque, l'un pour la Sorbonne, et l'autre pour l'Ecole des hautes études en sciences sociales. Tous deux allaient découvrir au fil des communications faites par des spécialistes de l'ère nazie une vérité qu'ils auraient dû connaître depuis plus de vingt ans, à savoir que, malgré les recherches les plus érudites, on n'avait rien pu trouver qui pût démontrer que Hitler avait donné un ordre quelconque de tuer les juifs. On voudra bien se reporter ici à mon annexe sur la conférence de presse donnée par les deux professeurs à la fin d'un colloque qui avait duré quatre jours. Les médias n'ont, comme on pouvait le penser, rien dit de cette conclusion d'un colloque annoncé à son de trompe comme devant répliquer aux arguments des auteurs révisionnistes. C'est que les suites de ce constat auraient été difficiles à expliquer au profane. À ce dernier il aurait, du même coup, fallu révéler que l'expression de « solution finale » située dans son exact contexte impliquait l'émigration ou l'évacuation des juifs et que le fameux « protocole de Wannsee » n'était qu'un prétendu procès-verbal non signé, sans en-tête, sans référence, tapé à la machine par on ne sait qui sur du papier ordinaire. La « solution finale de la question juive » n'impliquait pas plus l'extermination des juifs que la solution finale de la question palestinienne ou de la question du chômage n'impliquerait nécessairement l'assassinat des Palestiniens ou des chômeurs. Ni les discours de Himmler, ni les instructions de Heydrich, ni les « confessions » de Höss ou d'autres Allemands tombés aux mains de l'appareil judiciaire des Alliés n'apportaient la moindre preuve de l'existence d'un ordre ou d'une directive ou d'une instruction appelant à exterminer les juifs.

Mais il y a mieux : des quantités de textes et de faits (certains faits étant de l'ordre de la simple évidence oculaire) prouvent qu'un tel ordre n'a pas pu exister. En quarante ans de procès dits de criminels de guerre (il n'y a de criminels de guerre que chez les vaincus) aucun Allemand, des procès de Kharkov en 1943 jusqu'aux procès actuels de 1983, n'a pu faire valoir pour sa défense qu'un tel ordre avait existé. Au contraire, nous avons la preuve que des tribunaux militaires allemands ont condamné, parfois même à mort, jusqu'à des SS pour des meurtres de juifs. Je cite exemples et références dans la longue note 45 de la page 210 de *Vérité historique ou vérité politique ?* Hitler se préoccupait d'abord et avant tout de mener la guerre. Il voulait utiliser pour la machine de guerre allemande la main-d'œuvre juive dans les camps ou hors des camps et les juifs constituaient également des sortes d'otages. En temps de guerre, un usage barbare veut que les représentants des puissances belligérantes hostiles soient mis en camps de concentration. Les Américains eux-mêmes n'ont pas hésité à mettre en camp de concentration, lors de la dernière guerre, des hommes, des femmes et des enfants qui, tout en possédant la nationalité américaine, étaient d'ascendance japonaise. Je ne compare évidemment pas les conditions respectives des camps dirigés par les Américains ou par les Allemands. Dans le premier cas, il s'agissait d'une nation opulente et qui n'a jamais eu à conduire de « guerre totale » et dans l'autre cas il s'agissait d'un pays de peu de ressources et, à la fin de la guerre, exsangue et en proie à la famine. C'est dans les derniers mois de la guerre que les déportés ont le plus souffert. L'apocalypse était générale et le typhus sévissait à l'état latent ou patent. Les charniers de Bergen-Belsen sont des charniers de typhiques. Dès 1942, le camp d'Auschwitz avait été ravagé par une violente épidémie de typhus dont on sait qu'elle a provoqué des morts jusque chez les médecins, les officiers, les soldats allemands et leurs familles (car, bien souvent, pour les médecins et les officiers, ils avaient leur famille dans cet ensemble de villes et de villages et d'usines et de mines et d'exploitations agricoles, etc., qu'on a pris l'habitude d'appeler Auschwitz). La pièce n° 4 du document de Nuremberg PS-4025 (mars-avril 1942) est ainsi résumée par l'organisme américain de poursuite des criminels de guerre :

> Note exposant que Hitler avait l'intention de repousser à l'après-guerre la solution du problème juif

Cette note, terriblement encombrante pour la thèse du « génocide », devait disparaître des Archives nationales américaines. L'historien britannique D. Irving passe pour l'avoir retrouvée il y a quelques années. Il s'agissait d'un mémorandum de routine envoyé par le Dr Schlegelberger, secrétaire d'État au ministère de la Justice. En voici le contenu :

> M. le ministre du Reich Lammers m'a fait part de ce que le Führer a déclaré à plusieurs reprises en sa présence qu'il voulait voir repousser à l'après-guerre la solution de la question juive. En conséquence, les considérations présentes ont, selon Monsieur le ministre du Reich Lammers, une valeur simplement théorique. Mais il veillera dans tous les cas à ce que des décisions de fond ne soient pas rendues sans sa connaissance à la suite d'un rapport inattendu d'une autre instance [11].

Il n'est pas sans intérêt de savoir que ce document n'est pas répertorié par la bibliographie de Jacob Robinson et de Henry Sachs, *The Holocaust. The Nuremberg Evidence. Part One : Documents.* Il n'apparaît ni sous la cote PS-4025, ni sous la cote PS-4055. Tous les spécialistes de l'ère nazie utilisent cette bibliographie comme un ouvrage de référence obligatoire, comme une bible en quelque sorte. Le 24 juillet 1942, dans un cercle restreint de familiers, Hitler, rappelant que « les juifs [lui] avaient déclaré la guerre » par l'intermédiaire de Chaïm Weizmann (car c'est toujours l'adversaire qui porte, bien entendu, la responsabilité de la guerre), dit qu'après la guerre il détruira leurs villes les unes après les autres et il précise qu'il le fera « si ces ordures de juifs ne décampent pas et s'ils n'émigrent pas vers Madagascar ou vers quelque autre foyer national juif ». Le plan de Madagascar avait été envisagé par les sionistes, par les Français et par les Allemands déjà avant la guerre. En plein conflit, Hitler, nous le savons par bien d'autres sources, n'envisageait pas plus de régler la question juive qu'il ne voulait, en Union soviétique occupée par ses troupes, réformer le système communiste de production ou de propriété.

Le grand public l'ignore, mais les spécialistes le savent bien, le chiffre de six millions de morts juives n'a jamais été qu'un chiffre de propagande ou, comme l'a pudiquement reconnu le Dr Broszat susmentionné, « un chiffre symbolique » [12]. On pourrait déterminer le chiffre réel ; on en a les moyens grâce au Service international de recherches d'Arolsen (organisme situé en RFA mais dépendant du Comité international de la Croix-Rouge de Genève), mais on se garde bien d'utiliser ces moyens. Quelquefois ― c'est le cas pour la France ― l'organisme officiellement chargé de déterminer le nombre réel des déportés résistants ou raciaux travaille pendant vingt ans à la question, puis, en possession des chiffres, s'abstient de les publier par crainte d'incidents avec certaines associations de déportés. Notre Comité d'histoire de la Deuxième Guerre mondiale, office directement rattaché au premier ministre, faisait cet aveu dans son bulletin confidentiel à la fin de 1973. J'ai pu entrer en possession de ces chiffres et je les ai récemment publiés [13]. Ils sont déroutants pour tous ceux qui défendent la thèse d'une extermination des juifs.

---

## La phrase de soixante mots

La partie adverse me fait grief d'avoir prononcé sur les antennes de radio Europe n° 1 une phrase qui résumait en soixante mots le résultat de mes recherches historiques. J'avais fait précéder cette phrase de l'avertissement suivant : « Pas un de ces mots ne m'est dicté par une sympathie ou une antipathie politique.» Voici cette phrase :

> Les prétendues chambres à gaz hitlériennes et le prétendu génocide des juifs forment un seul et même mensonge historique, qui a permis une gigantesque escroquerie politico-financière dont les principaux bénéficiaires sont l'État d'Israël et le sionisme international et dont les principales victimes sont le peuple allemand ― *mais non pas ses dirigeants* ― et le peuple palestinien *tout entier*.

Les sept mots que j'ai soulignés sont souvent omis dans l'intention de faire disparaître la distinction que j'opère entre, d'une part, les dirigeants de la RFA et, d'autre part, le peuple allemand. Le grand public ignore, en effet, la formidable répression exercée en RFA contre tout auteur révisionniste et on tient à le laisser dans cette ignorance.

La fable des chambres à gaz homicides et la fable du génocide sont intimement liées l'une à l'autre. Le génocide aurait été un crime exceptionnel et les chambres à gaz auraient été l'arme exceptionnelle de ce crime exceptionnel.

Le crime et l'arme du crime ne sauraient se concevoir l'un sans l'autre. Lorsque je parle d'un seul et même mensonge historique, c'est pour faire allusion à cent autres mensonges de l'Histoire qu'il s'agit toujours, pour un esprit qui entend rester libre, de débusquer et de dénoncer.

Pour ce qui est de la « gigantesque escroquerie politico-financière », elle est celle d'un Nahum Goldmann face au chancelier Adenauer dans ses efforts pour obtenir la conclusion des accords dits de Luxembourg (10 septembre 1952) ; cette escroquerie est exposée de façon circonstanciée aux pages 198 et 199 de *Vérité historique ou vérité politique ?* ainsi qu'à la note 61 de la page 212. Il faut lire la longue et suffocante interview de N. Goldmann parue dans la livraison n° 624 du *Nouvel Observateur* [14] ; rarement a-t-on vu exposer avec un pareil cynisme le récit d'une escroquerie politico-financière où Ben Gourion a eu aussi sa part. Par ailleurs, N. Goldmann ne cache pas que les colossales « réparations » obtenues du chancelier allemand « constituent une innovation extraordinaire en matière de droit international ». Il confirme cyniquement que le chancelier allemand a dû prendre en la circonstance une décision personnelle qui était contraire à la constitution allemande. N. Goldmann et Ben Gourion ont dicté *expressis verbis* la lettre d'acceptation signée de Konrad Adenauer. N. Goldmann a obtenu en 1950 d'une Allemagne se relevant tout juste de la famine la promesse d'un versement de quatre-vingts milliards de marks, soit une somme, nous confie-t-il, de dix à quatorze fois supérieure aux sommes qu'au tout début de l'opération on s'apprêtait à demander à l'Allemagne de l'Ouest. N. Goldmann déclarait en 1976 :

> Sans les réparations allemandes [...], Israël n'aurait pas la moitié de son infrastructure actuelle : tous les trains en Israël sont allemands, les bateaux sont allemands, ainsi que l'électricité, une grande partie de l'industrie... sans même parler des pensions individuelles versées aux survivants [...]. Certaines années, les sommes d'argent qu'Israël recevait d'Allemagne dépassaient le montant des collectes du judaïsme international ― les multipliant par deux ou par trois. Aujourd'hui plus personne n'est contre ce principe : même certains membres du Hérouth [parti nationaliste israélien, fondé en 1948 par Menahem Begin] perçoivent les réparations.

Dans ces « négociations », N. Goldmann et Ben Gourion avaient une arme, celle dite des Six Millions. La création de l'État d'Israël et les réparations obtenues de l'Allemagne forment avec les Six Millions un ensemble. Dans la même interview, N. Goldmann affirme avoir dit à Ben Gourion : « Nous avons connu de terribles défaites ; six millions de juifs ont été exterminés. Mais nous avons aussi remporté deux immenses succès historiques : la création de l'État d'Israël et les réparations obtenues de l'Allemagne. » C'est dire l'importance de ces réparations.

Dans ma phrase de soixante mots j'ai employé l'expression de « sionisme international ». La partie adverse me l'a reprochée comme si cette expression appartenait au vocabulaire de l'antisémitisme. Loin d'être ici une formule vague du langage antijuif et de désigner on ne sait trop quelle fumeuse conjuration, cette expression n'est que la traduction de « World Zionism », le même Nahum Goldmann ayant d'ailleurs été le président de deux grandes organisations sionistes : la WZO (World Zionist Organization) et le WJC (World Jewish Congress : parlement juif mondial, qui s'est toujours dit « sioniste »). D'ailleurs, ainsi qu'on l'a vu ci-dessus par les deux mots que j'ai soulignés, N. Goldmann, qui parlait un excellent français, utilisait, lui, dans cette interview, l'expression de « judaïsme international ». Cette expression est trompeuse puisque beaucoup de juifs non sionistes estiment qu'ils n'ont rien à voir avec le WJC ou avec N. Goldmann et ses successeurs.

Pour ce qui est de la distinction opérée entre, d'une part, le peuple allemand victime du mensonge et, d'autre part, ses dirigeants qui n'en sont pas les victimes, cette distinction est expliquée à la page 196 de *Vérité historique ou vérité politique ?* En effet, depuis 1945, l'Allemagne, amputée d'un tiers de son territoire, scindée en deux États, occupée par quatre armées, est dirigée par des hommes politiques qui, on peut le supposer, sont bien obligés de faire passer les contingences politiques avant le souci, propre au chercheur, de la vérité historique. Apparemment la survie de ces deux États respectifs exige que l'Allemagne de l'Est fasse entendre la voix de ses libérateurs de l'Est et que l'Allemagne de l'Ouest fasse entendre la voix de ses libérateurs de l'Ouest. Dans le camp des démocraties occidentales, les responsables de l'Allemagne de l'Ouest se signalent par une répression déterminée contre le nombre croissant des auteurs révisionnistes. Quiconque y soutient l'argumentation révisionniste est poursuivi en justice pour être condamné, selon les cas, à des peines de prison, à de lourdes amendes, à l'inscription de ses livres à l'Index (*Indizierung*) des ouvrages dangereux pour la jeunesse, à la saisie des ouvrages et même à la fonte des plombs de composition. Pour s'en tenir au seul cas du Dr Stäglich, cet ancien magistrat, auteur d'un ouvrage important sur *Le Mythe d'Auschwitz,* a vu la saisie de son livre, a été condamné à de lourdes amendes, a eu le montant de sa retraite amputé d'un cinquième pendant cinq ans et, actuellement, fait l'objet d'une procédure de retrait de son grade de docteur en droit de la part du Conseil des doyens de l'université de Göttingen. Ce grade obtenu en 1951 doit lui être retiré au nom d'une loi de 1939 signée du chancelier Hitler. Quant à J. G. Burg, de nationalité allemande et juif pratiquant, il est l'auteur de plusieurs écrits révisionnistes dont *Majdanek in alle Ewigkeit ?* (Majdanek jusqu'à la fin des temps ?) et se voit pour cela menacé d'internement dans un asile psychiatrique.

Dans ma phrase de soixante mots, je n'ai pas précisé quels étaient les bénéficiaires « non principaux » du mensonge historique, mais je suis prêt à le faire ici en disant qu'il s'agit de l'ensemble des vainqueurs de la seconde guerre mondiale ; en effet, si les chambres à gaz homicides n'ont pas existé, le « crime de guerre » par excellence pourrait être Dresde ou Hiroshima ou Katyn ou la déportation des minorités allemandes de l'Est européen ou la livraison, après la guerre, de centaines de milliers de Russes aux maîtres du Kremlin (« Opération Keelhaul » menée par les Britanniques) ou le commencement d'exécution du plan Morgenthau par les Américains.

Je n'ai pas non plus précisé quelles étaient à mes yeux les victimes « non principales » du mensonge historique, mais je suis prêt à le faire ici en disant qu'il s'agit, par exemple, du Vatican, en particulier de Pie XII, et du Comité international de la Croix-Rouge. Tous deux sont encore aujourd'hui accusés de n'avoir pas vu ni dénoncé l'existence des chambres à gaz homicides alors que l'un et l'autre étaient admirablement renseignés sur ce qui se passait en Europe et tout particulièrement en Pologne, pays avec lequel le Saint-Siège conservait les liens les plus étroits et pays où la Croix-Rouge internationale avait pu mener des enquêtes. À ce propos, il convient de remarquer précisément que, si le Vatican et le CICR, très bien renseignés sur la Pologne, n'ont parlé ni de chambres à gaz homicides, ni d'extermination systématique des juifs, c'est tout simplement qu'ils voyaient bien que ces bobards de guerre n'étaient que des bobards de guerre. Pie XII n'en a fait mention ni du temps de l'occupation de Rome par les Allemands, ni après la libération de Rome. Il avait d'excellentes et simples raisons de n'en pas faire mention : c'est que ces horreurs avaient été inventées dans l'exacerbation d'une guerre déjà suffisamment riche d'horreurs réelles, de part et d'autre, sans qu'on aille en ajouter de pires encore. Comment peut-on imaginer un instant que serait passé inaperçu un massacre qui, à l'échelle du temps, aurait duré trois ou quatre ans, qui, à l'échelle de la géographie, aurait intéressé tout un continent et qui, à l'échelle du nombre des victimes, aurait touché des millions de gens ? Même les conjurés allemands du 20 juillet 1944 n'en ont pas fait mention, même les juifs déportés vers Auschwitz ou d'autres camps ne croyaient pas au bien-fondé de ces rumeurs [15]. Menahem Begin reproche aux Alliés de n'avoir jamais dénoncé l'Holocauste au moment où il se produisait et de n'avoir rien entrepris pour le faire cesser, mais qui pourrait croire que Churchill, Roosevelt, Staline et tous les gouvernements en exil à Londres auraient su que se produisait cette abomination et auraient, sans se concerter, décidé de n'en rien dire ? Qui ne voit que, si ce crime gigantesque avait été perpétré par les Allemands, l'annonce de cette nouvelle au monde entier aurait constitué pour les Alliés la plus formidable des armes psychologiques ?

Parmi les victimes « non principales » du mensonge, je nommerais les jeunes générations juives. À leur manière elles ne peuvent que souffrir de cette religion ténébreuse et aberrante de l'Holocauste. Cette religion donne naissance à tout un monde de phénomènes du genre de la « victimologie » avec ses congrès et ses symposiums internationaux en Israël, en Allemagne de l'Ouest, aux États-Unis [16], à la création de « chaires universitaires d'Holocauste », détenues par des « docteurs en Holocauste », à des cours d'Holocauste dans les écoles primaires et secondaires des États-Unis, accompagnés de traumatisantes « expériences en Holocauste ». Du point de vue de l'histoire de la communauté juive mondiale, la dernière guerre a été tragique, non pas dans le sens qu'il y aurait eu une EXTERMINATION spécifique du peuple juif européen mais dans le sens qu'il s'est effectivement produit une DISSOLUTION de la communauté juive européenne. Les guerres ne freinent pas le progrès scientifique ; au contraire, elles accélèrent ce progrès ; de la même façon, elles accélèrent tragiquement certains processus de transformation sociale. Depuis des siècles, il se faisait dans la communauté juive mondiale un mouvement géographique de translation de l'Est vers l'Ouest. Ce mouvement se faisait de la Russie ou de l'Ukraine vers la Pologne ; puis, de la Pologne ― longtemps lieu privilégié et terre d'asile ― vers l'Allemagne ; de l'Allemagne vers l'extrémité occidentale de l'Europe ; de l'Europe vers l'Amérique (États-Unis, Canada, Argentine...) ; on constate qu'aujourd'hui la communauté juive américaine, après s'être principalement concentrée sur la côte est des États-Unis, se transfère de manière sensible vers la côte ouest : Los Angeles et la Californie sont en passe de devenir la nouvelle Terre promise. Dès avant la dernière guerre, le mouvement de translation d'est en ouest de la communauté juive européenne était si irrésistible qu'un grand nombre de juifs polonais quittaient la Pologne pour venir s'établir dans l'Allemagne de Hitler ; celle-ci prenait alors des mesures de refoulement (*Zurückdrängung nach Osten*) à l'égard des juifs à passeports polonais.

Les parents du jeune Herschel Grynspan furent ainsi refoulés. À Paris, Grynspan assassina Ernst vom Rath, conseiller de légation à l'ambassade d'Allemagne. En réaction à cet assassinat se produisit la « Nuit de Cristal » et, contre les juifs vivant en Allemagne, de nouvelles répressions. Il est tout à fait contraire à la vérité d'affirmer qu'à la fin de la guerre il n'existait pour ainsi dire plus de juifs en Pologne. En l'absence de tout recensement leur nombre ne peut être déterminé, mais même des auteurs exterminationnistes comme Raul Hilberg font état d'un très important mouvement de migration des juifs polonais vers les zones d'occupation britannique ou américaine en Allemagne [17]. Vers 1968, le mouvement de migration reprenait avec force. Quant aux juifs d'Union soviétique, ils émigrent encore aujourd'hui principalement vers les États-Unis, via l'Autriche. Considérées par rapport à ce profond mouvement d'est en ouest, la création même de l'État d'Israël et la migration déjà presque tarie vers ce nouvel État apparaissent comme un phénomène historique qui semble à la fois précaire et pathétique. De profonds changements sociologiques et politiques accélérés par la guerre ou provoqués par elle font qu'aujourd'hui certains systèmes de vie propres à la communauté juive polonaise ne se trouvent plus à Varsovie ou du côté des Carpates mais, par exemple, dans les faubourgs de New York, de Chicago ou de Los Angeles. Comme l'écrit Jacques Madaule, « [...] si Sighet, au fond des Carpates, est morte à jamais, tous les lecteurs d'Elie Wiesel le savent bien, elle revit dans les faubourgs de New York, où les hassidim se sont regroupés autour de leurs rabbis [18] ».

L'auteur anglais George Orwell (1903-1950) est de nos jours souvent cité pour avoir écrit une œuvre d'anticipation intitulée *1984*. Avec raison on le présente comme un type d'esprit libre, anxieux devant l'avenir réservé à la liberté de l'esprit. Ce que l'on ne sait guère à son propos, c'est qu'il fut probablement le premier auteur révisionniste de notre après-guerre. Dès la fin de la guerre, dès le mois de mai 1945, il posa comme un fait établi qu'il y avait eu une « extermination des juifs allemands et polonais » mais, poursuivant sa réflexion sur la force des moyens de propagande et sur les altérations les plus grossières de la vérité objective, il écrivait qu'il est difficile de croire que les gens sont tout simplement en train de mentir quand ils forgent l'Histoire à leur goût. Il disait : « On peut souvent nourrir un doute sérieux à propos des événements les plus énormes. » Et, parmi un certain nombre de questions qu'il se posait, figurait celle-ci :

> Est-ce vrai ce qu'on dit des fours à gaz allemands en Pologne ? [19]

Par cette simple question, traduisant ce que les Anglais appellent « a genuine doubt », George Orwell, partant d'une affirmation exterminationniste et posant ensuite une question de sens révisionniste, esquissait le chemin qu'après lui les principaux auteurs de l'école révisionniste ont tous eu à parcourir, ce chemin qui, de la foi, mène au doute. Pour ma part, je ne cherche pas à triompher ou à faire triompher une thèse ; je revendique le droit de m'exprimer, de discuter, de critiquer, de chercher. Je ne connais pas pour un chercheur de bonnes raisons de ne pas révéler le sujet de ses recherches historiques. Si les chambres à gaz homicides de Hitler n'ont pas existé, ne pas le dire c'est participer à un mensonge. Pour reprendre le mot de Soljenitsyne, je ne veux pas croire que « ce qui est exigé de nous c'est d'obéir au mensonge, c'est de participer chaque jour au mensonge » [20].

Je ne livre pas de combat. Je travaille d'abord, je publie ensuite ; enfin, si je viens à me battre, c'est pour qu'on ne déforme pas mon travail. Où voit-on que je me fasse l'apologiste de Hitler ? Où ai-je avancé qu'il n'y avait pas eu de victimes raciales de la politique hitlérienne ? Où aurais-je présenté l'histoire des chambres à gaz et du génocide comme une invention de comploteurs cherchant à monter de toutes pièces une vaste escroquerie politico-financière? J'ai esquissé l'histoire de ce qui, dans le temps, a pris la forme d'une rumeur parmi bien d'autres, née à la fois d'une peur et d'une haine qui ne sont que trop normales en temps de guerre ; cette rumeur entretenue à petit feu dans des officines sionistes de Berne et de Genève parmi cent autres rumeurs (camions à gaz, wagons à gaz, électrocutions, pompes à vide, ébouillantement, usines à savon, etc.) a été répercutée à Washington par des sionistes du type du rabbin Stephen Wise, président du World Jewish Congress ; il a fallu attendre novembre 1944 pour qu'elle accède, par les soins du War Refugee Board, au statut de vérité officieuse. Elle n'a commencé d'apparaître comme une sorte de vérité officielle qu'à l'extrême fin de la guerre avec la révélation au monde, stupéfait et écœuré, du charnier des typhiques de Bergen-Belsen. Pendant longtemps elle a connu une singulière ubiquité ; elle était partout ; la magique chambre à gaz homicide, capable de défier toutes les lois de la physique et de la chimie, se trouvait partout où il y avait eu soit des fours crématoires, soit des chambres à gaz de désinfection. Dans la saga de la déportation, tout déporté survivant était censé avoir échappé à la chambre à gaz, principalement les déportés juifs ; puis, le temps passant, le récit s'est transformé et, comme l'a dit l'historienne juive française Olga Wormser-Migot, la chambre à gaz est devenue une sorte de privilège juif que les non-juifs ont essayé de revendiquer aussi pour eux-mêmes ; mais sans succès. Aujourd'hui nombreux sont les juifs qui s'émeuvent de l'emploi politique que Menahem Begin fait de l'Holocauste et des chambres à gaz. Ils vont jusqu'à lui faire le reproche de tirer des chèques en blanc sur l'Holocauste. Ainsi d'immenses souffrances vraies d'un peuple qui, pendant la dernière guerre, a probablement pâti autant que, chacun de son côté, le peuple allemand, le peuple polonais, le peuple russe, le peuple japonais et ― on l'oublie toujours ― le peuple chinois, se trouvent aujourd'hui converties en argent et en politique pour le profit de quelques-uns. Dans cette affaire, on compte en définitive très peu de menteurs et une masse innombrable de victimes d'un énorme mensonge historique.

L'homme a évidemment besoin de mensonge ; comme l'a dit Anatole France, on peut vouloir aimer la vérité mais il faut bien convenir que sans le mensonge l'humanité périrait de désespoir ou d'ennui. À ce titre, le mensonge des chambres à gaz, peu intéressant en lui-même, offre au sociologue, au psychologue, au psychanalyste, à l'historien, au moraliste, au spécialiste des croyances religieuses et des sectes, des tabous et des rites d'une société qui se croit laïque, un champ d'investigation aussi intéressant que l'histoire de la sorcellerie, une histoire, rappelons-le, qui s'est développée non pas au Moyen Âge, comme on l'entend dire trop souvent, mais dans cette période de crise intellectuelle intense qu'a été l'époque de la Renaissance et de la Réforme. Le procès de Galilée remonte à la fin de cette période.

Paul Rassinier est le plus célèbre des auteurs révisionnistes français. Il est connu pour avoir écrit *Le Mensonge d'Ulysse* : Ulysse a connu cent épreuves mais, revenu chez lui, il en a raconté mille. P. Rassinier a écrit *Ulysse trahi par les siens* : il suffit d'écouter les divers récits de ses compagnons d'infortune pour voir qu'Ulysse est un fabulateur qui prétend avoir vu des êtres et des choses qui n'ont pas pu exister. P. Rassinier a aussi écrit *Le Véritable Procès Eichmann ou Les Vainqueurs incorrigibles* : les vainqueurs ne se lassant pas d'instruire le procès des vaincus ne font qu'accumuler les preuves de leurs propres mensonges, surtout en ce qui concerne les prétendues chambres à gaz homicides et le prétendu génocide des juifs. Il a écrit *Le Drame des juifs européens* : au-delà du drame de la guerre, les juifs vivent un autre drame : on a menti à leur propos et cela commence à se savoir. Il a écrit *L'Opération « Vicaire ». Le rôle de Pie XII devant l'Histoire* : un auteur allemand a fait jouer une pièce intitulée *Le Vicaire* ; dans cette œuvre il accuse le Vicaire du Christ d'avoir été mis au courant de l'extermination des juifs par l'intermédiaire du SS Kurt Gerstein et, à travers le monde entier, cette pièce a été reprise, ainsi que l'accusation sur laquelle elle était bâtie, de sorte qu'on a assisté à une véritable opération politique contre le Saint-Siège ; or, Rassinier le démontre magistralement, les « confessions » du SS Gerstein sont un tissu d'insanités ; donc la base même de l'opération s'effondre ; Rassinier publiait ce livre en 1965 aux éditions de la Table Ronde ; en 1983, une thèse universitaire française va apporter une éclatante confirmation de ses arguments [21].

P. Rassinier était un homme de gauche. Il avait été l'un des responsables du réseau de résistance « Libé-Nord ». Arrêté et torturé par le service de sécurité allemand, il avait été déporté à Buchenwald et à Dora. De retour en France, invalide à cent pour cent plus cinq degrés, il reprit un instant la lutte politique et il fut député de la deuxième assemblée constituante. À partir de 1950 il entreprit sa quête de la vérité sur les camps de concentration allemands. Son œuvre, vilipendée en particulier par les communistes mais non par un résistant comme Edmond Michelet, lui valut les attaques habituelles dès lors qu'on porte atteinte à certains tabous. Des associations s'efforcèrent sans succès d'entraîner les tribunaux français dans une condamnation des thèses historiques de P. Rassinier. Jusqu'à sa mort, en 1967, P. Rassinier, sa femme et son fils connurent une existence très difficile. Or, aujourd'hui, on commence à rendre hommage à sa valeur, même dans les rangs de ceux qui le bafouaient. Eugen Kogon faisait partie des auteurs qui, sur les camps de concentration allemands, défendaient la thèse des chambres à gaz. Le 5 mai 1960, P. Rassinier lui écrivait :

> Il ne vous échappera peut-être pas que, si l'idée a pu venir à l'esprit d'un Pape de faire trancher un problème scientifique par des juristes, quatre siècles ont tout de même passé depuis, et qu'aujourd'hui aucun homme vraiment cultivé n'aurait celle de soumettre à ceux de notre temps un problème historique.

Pour ma part, depuis le début de l'année 1979 je suis l'objet de procès en cascade de la part de la LICRA et de toutes sortes d'associations. Celles-ci souhaitaient me faire condamner en justice pour « dommage » par « falsification de l'Histoire ». Au cours des procès et des années, elles se sont rendu compte que c'était trop demander. Elles ont trouvé un biais : elles se contenteraient aujourd'hui d'une condamnation pour « imprudence » ou pour tel autre motif du même genre ; puis, sans vergogne, elles feraient ce qu'elles ont fait à Rassinier et ce qu'elles m'ont fait à moi-même jusqu'ici dans la presse ; elles répandraient partout que le faussaire Faurisson ou le falsificateur Faurisson a été condamné. Le Jewish Chronicle de Londres ne répand-il pas déjà à travers le monde que Faurisson a été condamné par les tribunaux français pour, entre autres motifs, « falsification de l'Histoire » ? Cette condamnation est présentée comme un modèle à suivre par la justice britannique à l'endroit des révisionnistes britanniques. En France, ces associations ont pu croire, de bonne foi, que je soutenais une thèse mensongère et facile à réfuter. Elles ont pu le croire en 1979 mais, aujourd'hui, au terme de quatre années de réflexion et d'expériences diverses, elles ne peuvent plus entretenir d'illusions.

Deux personnes portent la responsabilité des imprudences de la LICRA et tous autres : Pierre Vidal-Naquet, historien de l'Antiquité, et Georges Wellers, biologiste (?). À la fin de 1978 et au début de 1979, ces deux personnes, aidées de Léon Poliakov, avaient lancé une violente campagne, dans *Le Monde* notamment, à la suite de la parution de mon article sur « La rumeur d'Auschwitz » (29 décembre 1978). Le même jour, G. Wellers avait tenté de me donner la réplique. Mon texte en droit de réponse du 16 janvier 1979 rouvrait la question. G. Wellers répondait. À sa réponse très faiblement argumentée, je répliquais par un texte que *Le Monde* refusait d'insérer. Là commençaient les méprises de la LICRA. Ne connaissant pas ma réplique, elle s'imaginait que G. Wellers avait montré que j'avais faussé le sens d'un témoignage : celui du médecin d'Auschwitz, Johann Paul Kremer. Dans leur assignation, la LICRA et tous autres ne formulaient que des accusations vagues ; sur un seul point l'accusation se faisait précise : j'avais, paraît-il, faussé le témoignage du Dr J. P. Kremer. Dans un *Mémoire en défense contre ceux qui m'accusent de falsifier l'Histoire,* je montrais, en me référant au texte allemand du journal de ce médecin, qu'une véritable tradition falsificatrice lui avait fait dire ce qu'il n'avait jamais dit. Je prouvais également que les aveux du médecin à la justice polono-communiste étaient absurdes. À l'époque de la rédaction de ce mémoire je ne savais pas encore que les autorités du musée d'Auschwitz possédaient la preuve que, de retour en Allemagne, le médecin avait rétracté ses aveux et avait protesté contre le traitement dont il avait été l'objet de la part de la justice polonaise. P. Vidal-Naquet et L. Poliakov, de leur côté, avaient pris l'initiative de faire circuler une pétition qui se terminait ainsi :

> Il ne faut pas se demander comment techniquement un tel meurtre de masse a été possible. Il a été possible techniquement puisqu'il a eu lieu. Tel est le point de départ obligé de toute enquête historique sur ce sujet. Cette vérité, il nous appartenait de la rappeler simplement : il n'y a pas, il ne peut y avoir de débat sur l'existence des chambres à gaz.

Cette déclaration devait paraître dans *Le Monde* du 21 février 1979 ; trente-quatre historiens la signaient ; pas un de ces historiens n'était un spécialiste de l'histoire des camps de concentration ni même de la période considérée. René Rémond, membre du Comité d'histoire de la Deuxième Guerre mondiale et responsable de la section chargée de l'histoire de la déportation, refusait sa signature. Henri Michel, président du même comité, ne signait pas non plus. Logiquement, il ne devait pas y avoir de débat sur l'existence des chambres à gaz. En réalité, tout en faisant signer cette déclaration, P. Vidal-Naquet incitait ses collègues à se mettre au travail sur le sujet et, lui-même, il allait donner l'exemple. Dix-neuf mois plus tard, il publiait dans la revue *Esprit* une étude intitulée : « Un Eichmann de papier ». Cette étude allait être reprise dans un livre intitulé *Les Juifs, la mémoire et le présent*. À la page 196 de ce livre on pouvait lire : « Bon nombre d'historiens ont signé la déclaration publiée dans *Le Monde* du 21 février 1979, très peu se sont mis au travail, une des rares exceptions étant F. Delpech. » En réalité, F. Delpech avait été le seul des signataires à publier un article ; il l'avait intitulé « La persécution nazie et l'attitude de Vichy » et l'avait publié dans la revue *Historiens et Géographes* [22] ; il s'agissait de la reprise, développée, d'un article qu'il avait fait paraître dans *Le Monde* du 8 mars 1979. Continuant son œuvre, P. Vidal-Naquet multipliait à tous les échos, en France et à l'étranger, des déclarations sur l'entreprise de falsification de l'Histoire que constituait à ses yeux le travail des révisionnistes. On pouvait s'étonner de voir déployer tant d'efforts sur le sujet des chambres à gaz, un problème qui « ne se posait même pas » à propos d'une réalité historique sur laquelle on possédait, par ailleurs, une « abondance de preuves » (titre de l'un des articles de G. Wellers). Plus étonnante encore était l'initiative de provoquer une rencontre internationale sur le sujet (on voudra bien se reporter à ce que j'ai dit ci-dessus du colloque de Paris, 29 juin-2 juillet 1982, strictement réservé aux auteurs exterminationnistes et qui devait se clore sur une débâcle : celle de la conférence de presse finale). Mais, par-dessus tout, P. Vidal-Naquet allait fournir involontairement la preuve... qu'on ne possédait pas de preuve de l'existence des chambres à gaz ou des camions à gaz homicides. En effet, le 21 avril 1982 allait être fondée à Paris une association appelée l'ASSAG : Association pour l'étude des assassinats par gaz sous le régime national-socialiste. Cette association se donne pour objet de :

> ... rechercher et contrôler les éléments apportant la preuve de l'utilisation des gaz toxiques par les responsables du régime national-socialiste en Europe pour tuer les personnes de différentes nationalités ; ― contribuer à la publication de ces éléments de preuve ; ― prendre à cet effet tous les contacts utiles au plan national et international.

J'ai souligné les mots éléments apportant la preuve et éléments de preuve... et ― je cite le texte ― « la durée de l'Association est limitée à la réalisation de son objet énoncé à l'art. 1 ». P. Vidal-Naquet et G. Wellers font partie des membres fondateurs de cette association dont la seule existence serait inconcevable si nous possédions ne serait-ce qu'une seule preuve de la réalité de l'« utilisation des gaz toxiques par les responsables du régime national-socialiste en Europe pour tuer (d)es personnes de différentes nationalités ».

## Résumé des trois annexes

### Annexe 1 :

Attestation de William Skyvington au sujet de la conférence de presse tenue par les professeurs Raymond Aron et François Furet le 2 juillet 1982 à la fin du colloque international sur « Le national-socialisme et les Juifs » :

1\. Malgré les recherches les plus érudites on n'a pas trouvé de preuve que Hitler ait ordonné l'extermination des juifs ; on n'a pas non plus trouvé de preuve d'une activité personnelle de Hitler.

2\. Les deux professeurs se déclarent, à titre personnel, contre les procès intentés [au professeur Faurisson] : « ... Je suis contre les procès de cet ordre... je trouve ça absurde... enfin, ce n'est pas à un tribunal de trancher... je trouve absurde que les organisations juives fassent des, des... [inaudible]... je suis entièrement contre... je n'aime pas les procès de sorcellerie... »

### Annexe 2 :

Remarques du professeur Faurisson sur l'*Exposition de la déportation (1933-1945),* Esplanade du Trocadéro (avril-mai 1982) et, en N.B., sur le livre de G. Wellers : *Les chambres à gaz ont existé* :

Pas une photographie représentant une chambre à gaz homicide, pas même une photographie des prétendues chambres à gaz homicides que visitent les touristes d'Auschwitz, de Majdanek, de Mauthausen, de Hartheim (celle du Struthof est fermée à toute visite depuis le débat ouvert dans *Le Monde* et *Libération* fin 1978-début 1979).

### Annexe 3 :

Mise en garde contre le texte du Recueil Dalloz-Sirey : J'ai chargé mon avocat de poursuivre la société éditrice du Dalloz-Sirey pour avoir gravement dénaturé le texte et le sens du jugement du 8 juillet 1981.

---

## Texte de l'annexe 1

William Skyvington [demeurant à] Paris :

Je soussigné, William John Skyvington, né le 24 septembre 1940 à Grafton (Australie), de nationalité australienne, ingénieur indépendant en informatique, domicilié [à] Paris, ayant assisté à la conférence de presse tenue par MM. les professeurs Raymond Aron et François Furet dans les locaux de la Maison des sciences de l'homme, le 2 juillet 1982 à 18h30, à l'issue du colloque « Le national-socialisme et les Juifs », déclare avoir procédé à l'enregistrement sonore sur cassette magnétique de la totalité de cette conférence de presse, en accord avec les organisateurs, et d'une manière parfaitement visible, de sorte qu'aucun interlocuteur ne pouvait ignorer le fait que j'enregistrais ses paroles.

Cet enregistrement devait constituer un élément intéressant dans le dossier que je prépare depuis quelque temps sur ce que l'on appelle parfois l'« affaire Faurisson » et ses rapports avec la liberté de l'expression en France, sujet dont je pensais me servir éventuellement pour rédiger un ouvrage en langue anglaise.

Je certifie que les textes suivants constituent une transcription rigoureuse de trois extraits de cet enregistrement, que je tiens par ailleurs à la disposition du tribunal. Je n'ai effectué aucune coupure volontaire de mots à l'intérieur de ces trois passages.

### Premier extrait

> Raymond Aron : [...] l'incertitude tient que, pour les historiens, on a besoin de documents d'archives, ou de preuves. Si on fait simplement du raisonnement, disons, du type compréhensif... [Silence.] Si on dit : "Étant donné sa nature, ses propos, sa doctrine, il est tout à fait compréhensible qu'il ait fait ceci ou cela...", bon, c'est ce qu'on fait quand on n'a pas de documents. Mais quand il y a des historiens qui disent : "Bien sûr que c'est compréhensible à partir d'une certaine représentation de Hitler..." [Silence.] Mais ils n'ont pas les preuves, et ils ont... [Silence.] Tout le monde a cherché, mais on a constaté que l'on n'a pas trouvé ce que l'on cherchait ; et que, d'autre part, dans le déroulement on n'a pas trouvé l'activité personnelle de Hitler.

### Second extrait

> Un journaliste : Et donc aujourd'hui, après ce colloque, après les travaux qu'ont faits tous les historiens qui étaient là, on peut considérer comme un fait certain que la décision de la solution finale a été prise ? Et par Hitler personnellement ?
> 
> Raymond Aron : Non.
> 
> François Furet : Non, je ne dirais pas ça.
> 
> Raymond Aron : Non. On pourrait dire que c'est le plus probable, mais en fonction de raisonnements. Mais ce n'est pas démontré par les recherches les plus érudites.

### Troisième extrait

> Un journaliste : Est-ce que vous estimez judicieux qu'il y ait eu des procès devant la justice ?
> 
> Raymond Aron : Le colloque n'a rien dit. Moi, à titre personnel, je suis contre les procès de cet ordre.
> 
> François Furet : Je trouve ça absurde. Enfin, ce n'est pas à un tribunal de trancher.
> 
> Raymond Aron : Je trouve absurde que les organisations juives fassent des, des... [inaudible].
> 
> Interlocuteur : On n'en a pas discuté.
> 
> Raymond Aron : On n'en a pas discuté. Mais... C'est en dehors du colloque, à titre personnel, moi je suis entièrement contre.
> 
> Interlocuteur : C'est aussi la position de Vidal-Naquet.
> 
> François Furet : Je pense que oui.
> 
> Raymond Aron : Je n'aime pas les procès de sorcellerie...

## Texte de l'annexe 3

Mise en garde contre le texte du Recueil Dalloz-Sirey

Dans leurs mémoires ampliatifs (p. 2, fin du premier alinéa), les parties adverses font référence au jugement rendu le 8 juillet 1981 par le tribunal de grande instance de Paris tel qu'il a été reproduit dans le Recueil Dalloz-Sirey du 3 février 1972, p. 59, note Bernard Edelman.

Dès lors, deux observations me paraissent s'imposer :

1\. le 10 novembre 1982 le tribunal de police de Paris a condamné le directeur responsable du Recueil Dalloz-Sirey pour m'avoir refusé l'exercice du droit de réponse ;

2\. j'ai, par ailleurs, chargé mon avocat, Mᵉ Eric Delcroix, du barreau de Paris, de poursuivre devant la juridiction civile la société éditrice du Recueil Dalloz-Sirey pour avoir gravement dénaturé le texte et le sens du jugement qu'elle prétendait reproduire.

Indépendamment de coupures signalées, parfois accompagnées d'un résumé dont le lecteur scrupuleux a toujours la possibilité (bien hypothétique en fait) de vérifier l'objectivité en se référant à la source, le texte publié par Dalloz-Sirey comporte des coupures non signalées qui altèrent gravement le sens du jugement. Ces coupures non signalées par des points de suspension sont particulièrement graves :

1° ― parce que la présence de coupures signalées rassure sur le caractère rigoureux et honnête de la publication et endort la vigilance du lecteur ;

2° ― parce que toutes les coupures non signalées visent à empêcher le lecteur de prendre connaissance des parties du jugement qui contredisent les interprétations de Mᵉ Edelman. Aucune de ces coupures n'est anodine et la volonté d'induire en erreur est manifeste.

Sont notamment supprimées les « prétentions des parties » dont la lecture aurait conduit à découvrir que le tribunal, bien qu'ayant condamné, n'avait pas suivi le plaignant dans sa demande, le plaignant n'étant parvenu à objectiver aucune faute précise, aucune dénaturation de texte, aucune falsification prétendument commises par le professeur défendeur.

Sont également supprimés toute mention et tout élément du texte pouvant laisser supposer l'existence de l'intervention volontaire à titre principal et à titre accessoire, au côté du professeur, de Serge Thion, sociologue, chargé de recherches au CNRS ; Maurice Di Scuillo, homme sans qualité ; Gabor Tamas Rittersporn, historien, sociologue, attaché de recherches au CNRS ; Jean-Luc Redlinski, homme sans qualité ; Jean-Gabriel Cohn-Bendit, auteur d'une étude sur le journal de J. P. Kremer et travaillant à une recherche sur les confessions de Rudolf Höss ; Pierre Guillaume, éditeur sans qualité ; Jacob Assous, homme sans qualité.

Ainsi, dans un procès particulièrement grave au regard des principes, qui met en cause la liberté du chercheur, la déontologie de l'historien et la liberté d'expression, parvient-on à cacher la présence au côté du professeur de chercheurs et d'historiens qui attestent du caractère sérieux de ses travaux.

C'est ainsi que de nombreux juristes sont amenés à travailler sur le texte gravement tronqué d'un jugement, sans qu'aucun d'entre eux ait même envisagé que la publication par le Recueil Dalloz-Sirey pût être déficiente.

12 janvier 1983

---

Notes

[1] Le grand livre de Jean Norton Cru, *Témoins,* a été réédité par les Presses universitaires de Nancy en 1993. [NdE]

[2] A. Ponsonby, *Falsehood in Wartime* (rééd., Torrance, Californie, Institute for Historical Review, 1980).

[3] 4 juillet 1915, p. 2.

[4] J. M. Read, *Atrocity Propaganda, 1914-1919,* New Haven, Yale University Press, 1941, p. 24-25.

[5] Arthur Ponsonby, *Mensonges et rumeurs en temps de guerre,* préface, traduction et notes par J. Plantin, St-Genis-Laval, Le Dragon vert, 1996, p. 196, n. 73.

[6] F. Grenier, *C'était ainsi,* Paris, Editions Sociales, 7ᵉ édition, 1970, p. 26.

[7] Mgr Piguet, *Prison et Déportation,* Paris, Spes, 1947, p. 77.

[8] S. Thion, *Vérité historique ou vérité politique ?,* Paris, La Vieille Taupe, 1980, p. 301-330.

[9] R. Faurisson, *Mémoire en défense contre ceux qui m'accusent de falsifier l'histoire,* Paris, La Vieille Taupe, 1980, p. 165-178 ; traduction reproduite dans *Écrits révisionnistes* (1974-1998) vol. I, p. 18.

[10] R. Faurisson, *Réponse à Pierre Vidal-Naquet,* Paris, La Vieille Taupe, 1982, 2ᵉ édition. Le texte intitulé « Le mythe des chambres à gaz entre en agonie » est reproduit dans Ecrits révisionnistes (1974-1998) vol. I, p. 325.

[11] Le document qui passe pour avoir été trouvé par D. Irving, je l'avais personnellement découvert dans les années 1960 ou 1970, à Paris, aux archives du Centre de documentation juive contemporaine (CDJC, cote V-59).

[12] « Eine symbolische Zahl », Procès contre Erwin Schönborn, Francfort, 3 mai 1979, 50 Js 12 828-78 919.

[13] R. Faurisson, *Réponse à Pierre Vidal-Naquet,* p. 31.

[14] [N. Goldmann], « Nahum Goldmann : au nom d'Israël », *Le Nouvel Observateur,* n° 624, 23-29 octobre 1976.

[15] Voy. G. Wellers, *L'Etoile jaune à l'heure de Vichy,* Paris, Fayard, 1973, chapitre 1.

[16] Voy. L. Sebba, « The Reparations Agreements : A New Perspective », *Annals of the American Academy of Political and Social Sciences,* Philadelphie, juillet, 1980.

[17] R. Hilberg, *The Destruction of the European Jews,* 1979, p. 728.

[18] À propos de Paroles d'étranger d'Elie Wiesel, *Le Monde,* 24 décembre 1982, p. 11.

[19] G. Orwell, « Notes on Nationalism », mai 1945, réédité dans *The Collected Essays,* Londres, Penguin Books, 1978, p. 21.

[20] *Le Monde,* 4 février 1978, p. 2.

[21] Cette thèse a été soutenue en 1985 par H. Roques et a provoqué « l'affaire Roques ». [NdE]

[22] *Historiens et Géographes,* mai-juin 1979, p. 591-635.

Labels: Nuremberg, ASSAG, Broszat, Fernand Grenier, Hilberg, Johann Paul Kremer, Lammers, LICRA, MRAP, Nahum Goldmann, Olga Wormser-Migot, phrase de 60 mots, Rassinier, Thion, Vidal-Naquet, Wellers

---

- [Sommaire des articles](index.html)
