---

<!-- http://robertfaurisson.blogspot.com/2001/08/a-vichy-un-monument-diniquite.html -->
<!-- Monday, August 20, 2001 -->

# À Vichy, un monument d'iniquité

![Plaque Vichy](images/1237795609_plaque_Vichy.png)

## Résumé

À la demande d'organisations israélites, une stèle commémorative vient d'être édifiée à Vichy. Le nom de Vichy y est associé à celui d'Auschwitz comme dans l'ouvrage de Serge Klarsfeld, *Vichy-Auschwitz*. On y insinue que le maréchal Pétain et Pierre Laval ont, de 1942 à 1944, consciemment participé à une entreprise d'extermination physique des Juifs et notamment d'enfants juifs. Lors de la cérémonie, des orateurs ont accusé le général de Gaulle et le président François Mitterrand d'avoir manqué de courage en cherchant à masquer l'existence de ce crime. Ces orateurs ont remercié la ville de Vichy et la France d'avoir enfin rétabli une vérité bafouée et d'avoir fait acte de repentance à l'égard des Juifs.

Ces accusations sont calomnieuses et ces remerciements sont fallacieux. Ni en intention, ni dans les faits, ni à Auschwitz ni dans aucun autre camp de concentration les Allemands n'ont eu une politique d'extermination physique des Juifs. Il n'a existé ni « camps d'extermination » (expression forgée par la propagande alliée et reprise dans le texte de la stèle comme s'il s'agissait d'une expression officielle allemande), ni chambres à gaz d'exécution (impossibles pour d'évidentes raisons physiques et chimiques qui ont d'abord été exposées dans des écrits révisionnistes et qui ont été, ensuite, confirmées par des expertises *in situ*).

Durant la guerre le silence général des plus hautes autorités alliées sur le sujet desdites chambres à gaz tient au fait que ces prétendus abattoirs chimiques n'ont jamais existé. Charles de Gaulle a refusé de les mentionner tant dans ses discours de guerre que dans ses mémoires de guerre. Il en a été de même pour Winston Churchill, pour le général Dwight Eisenhower ainsi que pour des historiens tels que Raymond Aron et René Rémond, qui comptaient parmi les Résistants de toute l'Europe. Il en est allé de même pour le pape Pie XII ainsi que pour de hautes autorités catholiques, protestantes, musulmanes et même juives !

Ce qui a existé, c'est une politique allemande en vue de la « solution finale territoriale de la question juive » (les faussaires de l'histoire suppriment l'adjectif de « territoriale »). Pendant le conflit, cette politique, devant le refus des Alliés et des neutres d'accueillir les millions d'immigrants potentiels que leur offrait Adolf Hitler, a consisté en un refoulement provisoire des Juifs vers des régions d'où, pour la plupart, ils provenaient, c'est-à-dire vers l'Est européen : après la guerre les Juifs auraient eu, toujours dans le cadre de la politique allemande, un territoire à Madagascar ou ailleurs. En France ces Juifs, souvent communistes et, dès le début de la campagne contre l'Union soviétique, particulièrement actifs dans le terrorisme, constituaient un danger pour les troupes allemandes et pour la population civile, laquelle faisait les frais des inévitables représailles allemandes (autorisées par les conventions internationales). Nous avons du respect pour les vraies souffrances de toutes les vraies victimes de cette épouvantable boucherie qu'a été la Seconde guerre mondiale.

Les déportations de populations civiles (hommes, femmes, enfants) avant, pendant et après la guerre de 1939-1945 ont été nombreuses. Les Allemands n'ont été ni les seuls, ni les premiers, ni les derniers à déporter des civils. Ils ont même été les victimes des pires déportations du siècle et peut-être de tous les temps. Les Soviétiques, alliés des États-Unis, de la France gaulliste et de la Grande-Bretagne, ont pratiqué les déportations à une échelle inégalée et se sont dotés des pires camps de concentration (ceux du Goulag). Il est suffocant de voir les Alliés, qui ont systématiquement provoqué l'holocauste des villes allemandes et japonaises, donner des leçons de morale aux Allemands et à ceux qui s'étaient alliés ou collaboraient avec les Allemands. Le procès de Nuremberg (1945-1946), où les vainqueurs ont jugé les vaincus, a été une ignominie, tout comme l'Épuration de l'après-guerre qui, sur la demande d'organisations juives, continue encore aujourd'hui d'instruire des procès contre des vieillards condamnés d'avance.

Beaucoup de Juifs sont morts durant la Seconde guerre mondiale, surtout du fait des épidémies de typhus, de choléra, de fièvre typhoïde ou de dysenterie. Beaucoup ont survécu. Le nombre des « survivants » ou des « miraculés », comme souvent on les qualifie, est heureusement considérable. L'historienne juive Annette Wieviorka admet que 80% des Juifs de France (Juifs français, étrangers, apatrides) ont survécu à la guerre. Les communautés juives européennes, y compris en Pologne, n'ont nullement été exterminées. À lui seul, le territoire qui allait devenir l'État d'Israël a recueilli des flots de survivants d'un prétendu « Holocauste ».

Le « Grand Mensonge du XX^e^ siècle » est celui du prétendu « Holocauste des Juifs ». Il a donné lieu au « Shoah Business », à « l'Industrie de l'Holocauste » et à la création de l'État factice d'Israël, État raciste, colonialiste et expansionniste. Cette imposture a fait son temps. Elle devra prendre fin au XXI^e^ siècle.

Quant à la stèle commémorative de Vichy, elle restera comme un produit et un exemple en réduction de ce « Grand Mensonge ».

Au lieu d'administrer des leçons au reste du monde, les responsables qui prétendent parler au nom des communautés juives feraient mieux de se pencher sur leur passé et de s'interroger sur leur avenir.

Dans le passé, nombre de sionistes ont collaboré avec l'Allemagne d'A. Hitler dès 1933 ; leur idéologie était pour ainsi dire identique à celle du national-socialisme et ils avaient un ennemi commun : la Grande-Bretagne. En janvier 1941, Yitzhak Shamir et ses compagnons du Groupe Stern ont même offert à l'Allemagne une alliance militaire contre les Britanniques et, jusqu'à la fin de la guerre, des sionistes ont gardé des contacts avec Heinrich Himmler et Adolf Eichmann. Ces « Juifs bruns » ont fait partie de « l'internationale juive de la collaboration » avec l'Allemagne.

S'interroger sur leur avenir, c'est aussi ce que devraient faire les donneurs de leçons. Les Hébreux installés en terre de Palestine vont-ils se trouver devant le choix trop connu de « la valise ou du cercueil » ? Si oui, pourquoi ? Qu'y a-t-il dans l'histoire de ce peuple qui fait qu'à la longue, immanquablement, comme le dit Bernard Lazare, il lasse la patience des nations au sein desquelles il est venu s'installer ?

Dans l'intérêt bien compris de tous, à commencer par celui des Juifs, il convient que prennent fin ces campagnes de propagande haineuses, mensongères et bassement intéressées. Pris d'une frénésie d'accusations gémissantes contre la terre entière ou peu s'en faut, les responsables des organisations juives dénoncent aujourd'hui pêle-mêle l'Allemagne — éternelle coupable —, Pétain, de Gaulle, Churchill, Roosevelt, Staline, la Suisse, la Suède, la Pologne, la France (sauf si elle se soumet) et Vichy quand ce ne sont pas aussi les Palestiniens, Arafat, l'Iran, l'Irak, la Syrie, le Liban, l'ONU, les leaders noirs américains, le révisionnisme des Japonais, l'antisémitisme russe, ukrainien ou polonais, Amnistie Internationale, Reporters sans frontières, les papes Pie XII ou Jean-Paul II, sans compter les universitaires ou chercheurs révisionnistes ou simplement sceptiques.

Dans les journaux, à la radio, à la télévision, au théâtre, au cinéma, on assiste à un déferlement de productions sur les infinies vertus et les incommensurables souffrances du peuple hébreu. Par moments, on se prend à espérer que les Juifs vont se rendre compte qu'ils vont trop loin. Point du tout. Ils en rajoutent. Ils exigent et obtiennent des monuments dans nos villes. Ils réclament et obtiennent des indemnités financières pour les orphelins des déportés juifs et organisent des manifestations contre ceux qui sollicitent des indemnités identiques pour les orphelins soit des autres déportés, soit des otages, soit des fusillés qui ne sont pas juifs ! Ils font la loi. Une loi spéciale (la loi Fabius-Gayssot du 13 juillet 1990) leur permet d'envoyer en prison ou d'accabler d'amendes et de dommages-intérêts ceux qui ne croient pas en leur version de l'histoire. À partir de septembre 2001, l'enseignement de « la Shoah » deviendra obligatoire dans les lycées !

Les Français ne sont pas antijuifs en ce sens qu'ils ne veulent pas de mal aux Juifs et les habitants de Vichy ne sont pas nécessairement pétainistes mais tous aspirent à la paix. Il serait temps que les responsables des organisations juives finissent par s'en rendre compte.

Pour leur part, les auteurs du présent texte dénoncent le Grand Mensonge du prétendu « Holocauste » des Juifs et s'indignent du monument d'iniquité dressé devant l'ancien Hôtel du Parc à Vichy. Cependant, soucieux de la paix civile, ils mettent en garde contre toute exploitation de ce texte à des fins polémiques ou politiques et contre toute provocation d'où qu'elle vienne. Attention, en particulier, à toute dégradation du monument ! Le délit serait immédiatement imputé, sans la moindre enquête préalable, à des « antisémites inspirés par un ignoble libelle » alors qu'une telle dégradation pourrait être due à des provocateurs qui ont intérêt à faire croire que l'antisémitisme est vivace en France. Encore une fois, il n'y a pas d'antisémitisme dans notre pays mais une lassitude qui tourne à l'irritation devant les excès d'une certaine propagande.

---

Le 22 juillet 2001, à Vichy, des personnalités et des organisations juives ont inauguré, en face de l'ancien Hôtel du Parc, une stèle commémorative qui restera comme un monument d'iniquité pour le maréchal Pétain, pour Pierre Laval mais aussi pour la République française et les Français dans leur ensemble. Sans qu'on les nomme, on insinue que les plus hauts responsables de l'État français ont agi en pourvoyeurs du « camp d'extermination d'Auschwitz ». Ils auraient ainsi envoyé consciemment à la mort, de l'été 1942 à l'été 1944, 10 000 Juifs étrangers, dont des centaines d'enfants, qui résidaient en zone dite « libre ». Par ailleurs, dans le principal discours prononcé lors de l'inauguration, le général de Gaulle et le président François Mitterrand ont été dépeints en hommes politiques dénués de courage, en négateurs, en désinformateurs et en dissimulateurs de la vérité historique. Quant à la ville de Vichy et à la France tout entière, elles ont eu droit à un hommage appuyé mais seulement pour autant qu'elle ont, enfin, à la fin des fins, bien voulu admettre le caractère déshonorant de leur passé.

Les trois personnalités principales qui ont formulé ces accusations, procédé à ces amalgames et décerné ces compliments empoisonnés ont été Serge Klarsfeld, Jean Kahn et Richard Wertenschlag. Le premier préside l'Association des Fils et Filles des déportés juifs de France ; il est, avec l'Association cultuelle israélite de Vichy, l'auteur du texte de la plaque fixée sur la stèle. Le deuxième préside le Consistoire central israélite de France ; ancien président du Conseil des institutions israélites de France (le CRIF), J. Kahn est également président d'honneur du Comité national consultatif des droits de l'homme auprès du gouvernement présidé par Jacques Chirac ; il est l'auteur de la diatribe lancée contre le général de Gaulle et F. Mitterrand. Le troisième est le grand rabbin de Lyon et de la région Rhône-Alpes-Auvergne ; saluant « la présence massive des corps constitués » à la cérémonie, il s'est félicité de cet « acte de réparation » et de la « repentance » de la ville de Vichy et de la France. Assistaient en particulier à l'inauguration René Fertier, sous-préfet de Vichy, Gérard Charasse, député de l'Allier (à ne pas confondre avec Michel Charasse, sénateur du Puy-de-Dôme), et Claude Malhuret, maire de Vichy. Tous trois ont déposé leurs gerbes respectives. Des associations juives et sionistes ont fait de même.

## Faire honte à Pétain et à Laval

Le texte de ladite plaque, signé « Les Fils et Filles des Déportés Juifs de France » et « Association Cultuelle Israélite de Vichy », stigmatise l'État français alors dirigé par le maréchal Pétain et Pierre Laval. Il prononce :

> Le 26 Août 1942, le gouvernement de l'État Français, installé dans cet immeuble à Vichy, a déclenché sur tout le territoire de la zone libre une gigantesque rafle de Juifs étrangers. Plus de 6 500 d'entre eux, dont des centaines d'enfants, ont été arrêtés ce jour là et livrés aux Nazis en zone occupée, d'où ils ont été aussitôt déportés sans retour vers le camp d'extermination d'Auschwitz. Au total ce fut le sort tragique de plus de 10 000 Juifs étrangers vivant en zone libre.
> 
> Dans leur ensemble la population française et les clergés catholique et protestant se sont immédiatement opposés à ces mesures qui violaient les traditions et l'honneur de la France.
> 
> Qu'ils en soient remerciés.
> 
> N'oublions jamais.

## Faire honte à de Gaulle et à Mitterrand

J. Kahn a rendu hommage à J. Chirac pour avoir, le 16 juillet 1995, enfin déclaré la France coupable de crimes commis contre les Juifs par l'État français de 1940 à 1944, et « restitué ainsi l'authenticité à l'histoire ». Le général de Gaulle et le socialiste François Mitterrand (et, cela va de soi, leurs prédécesseurs) n'avaient pas eu « le courage » d'agir ainsi. J. Kahn les a, en conséquence, accusés d'avoir été des négateurs, d'avoir pratiqué en quelque sorte la désinformation et d'avoir porté atteinte à la vérité historique. En un français approximatif il a déclaré :

> Nier l'existence de ce régime [de Vichy] n'est-elle pas une forme de désinformation à laquelle se sont complus, tant le général de Gaulle que le président Mitterrand, le tout pour préserver la paix civile ? La vérité de l'histoire doit être rétablie.

## Serge Klarsfeld

L'avocat S. Klarsfeld, né à Bucarest en 1935, est connu pour son prosélytisme, ses actions violentes, son goût de la manipulation et du chantage. Il est l'auteur d'un Mémorial de la déportation des Juifs de France entaché d'erreurs, d'exagérations et d'inventions. Le titre de l'ouvrage donne à croire qu'il s'agit d'un registre de morts alors que nous sommes là en présence d'une simple liste de déportés. Son père, Arno Klarsfeld ― dont il a hérité la violence ― a été déporté à Auschwitz en tant que « déporté politique » et non « déporté résistant ». Quatre mois après son arrivée, A. Klarsfeld est mort à l'infirmerie du camp des suites d'une rixe avec un co-détenu (un kapo ?). S. Klarsfeld le sait mais, en général, il laisse planer le doute ou laisse dire, y compris par son épouse, que cette mort s'est produite dans une chambre à gaz. En 1983 et en 1985, il a publié chez Fayard un ouvrage en deux volumes intitulé *Vichy-Auschwitz*. À elle seule, la photographie de couverture du premier volume est révélatrice de ses habituelles manipulations ; elle montre, en 1940, un agent de la police parisienne en train de se pencher sur l'épaule d'un officier SS pour lui indiquer son chemin sur un plan de la ville ; par le choix de cette photographie S. Klarsfeld a voulu faire naître chez le lecteur l'idée d'une entente cordiale et criminelle entre l'armée allemande et la police française. On n'en finirait pas d'énumérer les actions violentes, les tentatives d'assassinat ou d'enlèvement, les menaces de mort, les destructions de biens et les provocations de cet étrange avocat que même son coreligionnaire Alain Finkielkraut décrivait, dans *Le Monde* du 26 octobre 1999, comme un homme caractérisé par la « passion justiciaire » (et non judiciaire), « la haine du droit » et « un comportement détestable ». S. Klarsfeld ne manque pas d'aplomb. En 1989, il a qualifié de « naturel et normal » un attentat juif dans un parc de Vichy contre le professeur Robert Faurisson. En 1993, toujours à Vichy, il a apposé sur les deux montants de la porte d'entrée de l'ancien Hôtel du Parc, devenu une copropriété, un texte provocateur tout en déclarant en substance : « Je sais que je n'en ai pas le droit mais j'attends de voir qui osera retirer ce texte ». Puis, il a obtenu qu'une plaque au contenu accusateur et provocateur fût fixée dans le hall de la copropriété. Enfin, pour que les copropriétaires boivent la coupe jusqu'à la lie, il a fait transférer le contenu de la plaque en question sur cette stèle qu'on vient donc d'édifier juste en face de l'ancien hôtel à un endroit où touristes et curistes, gens de Vichy et d'ailleurs, Français et étrangers, passent en grand nombre.

Le texte de cette plaque ― on l'a lu plus haut ― taxe froidement l'État français (à l'époque entre les mains du maréchal Pétain et de P. Laval) de complicité dans l'assassinat massif, à Auschwitz, de 10 000 Juifs étrangers déportés de France entre l'été 1942 et l'été 1944. Rien peut-être ne caractérise mieux l'impudence de ce fils d'Israël que le subterfuge qu'il a employé pour que F. Mitterrand cesse de faire déposer une gerbe chaque année dans le cimetière de l'Île d'Yeu sur la tombe du maréchal Pétain. Il a commencé par annoncer à la presse qu'on avait des informations de l'Elysée selon lesquelles le président de la République cesserait de fleurir la tombe. Ce n'était qu'un mensonge. F. Mitterrand, après d'inutiles manœuvres de retardement et après avoir cherché à calmer l'agitation juive par la création de la « Journée de commémoration » du 16 juillet 1942 (date de la rafle des Juifs à Paris et de leur concentration au Vélodrome d'hiver), dut capituler et renonça au dépôt de gerbe traditionnel. S. Klarsfeld publia alors, dans Libération du 12 septembre 1994, une « Lettre à François Mitterrand » d'une stupéfiante arrogance. Il rappela fièrement au président de la République qu'il l'avait menacé d'« un scandale retentissant », qu'il avait exercé sur lui des « pressions » et qu'il lui avait ainsi arraché des concessions successives ; puis, sur sa lancée, il se fit gloire de la supercherie qui lui avait permis d'obtenir que la tombe du maréchal Pétain ne reçût plus l'hommage habituel de la présidence de la République. Ce ne fut pas tout. Il se vanta de sa propre « insolence », une insolence dont il se déclarait heureux parce qu'elle était « justifiée ». Enfin, pour ainsi dire en pleine face, il jeta à F. Mitterrand qu'il l'avait « humilié » pour son bien. « [Je me flatte] », lui lança-t-il, de « l'insolence d'évoquer seul votre passé à Vichy et de vous humilier pour vous diriger dans le bon sens ».

## Jean Kahn

J. Kahn, ami de S. Klarsfeld, est connu pour sa richesse, pour ses liens avec les Rothschild, pour son appétit des honneurs et des titres, pour l'ivresse qu'il éprouve à se sentir Juif et pour sa tendance à la surenchère dans la propagation du mythe de la Shoah. En 1986, dans Tribune juive, il déclarait : « Mon parti politique, c'est le peuple juif ». La même année, dans Le Quotidien de Paris (11 février 1986, p. 6), il lançait avant les élections législatives : « L'électeur juif est un électeur avec un supplément d'âme ». En 1991, dans La Croix, il affirmait : « Les juifs ont apporté énormément à l'Europe et je crois qu'ils ont été les premiers Européens ». J. Kahn n'a jamais eu à souffrir des Allemands ; aussi, selon un processus courant chez les Juifs d'aujourd'hui, ne le leur pardonne-t-il pas. En 1995, dans L'Arche, mensuel israélite, on pouvait lire à ce propos :

> Lorsqu'il a dix ans, c'est la guerre. Il ne l'a pas vécue de près et néanmoins il ne s'en est jamais remis [sic]. Ou peut-être ne s'est-il jamais remis de ne pas l'avoir vécue [sic]. Lorsqu'il s'agit de la guerre, des camps d'extermination, de la Shoah, il y a chez cet homme, par ailleurs modéré, une grande violence qui naît sans doute d'une blessure : celle d'avoir été épargné [sic]. Celle d'avoir été trop jeune et trop chanceux pour partager la souffrance de son peuple.

## Hommages trompeurs

Le texte de S. Klarsfeld contient un hommage à la population française de 1942 dans son ensemble ainsi qu'aux clergés catholique et protestant dans leur ensemble. De son côté, J. Kahn, à la fin de son discours, a remercié les Vichyssois d'aujourd'hui d'avoir, par l'édification de cette stèle, contribué à un début de rétablissement de ce qu'il appelle la vérité historique. Mais seul un naïf prendra ces hommages pour argent comptant. Le contexte suggère que de tels compliments ont pour office de renforcer les accusations. On remercie les Français de 1942 d'avoir dénoncé un crime qu'aujourd'hui les Vichyssois sont, enfin, censés reconnaître : un crime atroce contre 10 000 Juifs étrangers expédiés vers Auschwitz et ses prétendues chambres à gaz. Au surplus, on veut nous faire croire qu'aucun de ces Juifs n'a survécu à son internement dans ce prétendu « camp d'extermination ». Le bilan s'analyse donc comme suit : la ville de Vichy a été autrefois le siège d'un gouvernement d'assassins et la France d'aujourd'hui porte l'entière responsabilité d'un crime affreux ; cette ville et ce pays ont d'abord cherché à dissimuler de telles horreurs et à fuir leurs responsabilités ; heureusement Vichy et la France ont, après un demi-siècle de négation ou de déformation des faits, finalement confessé leur ignominie et reconnu la vérité.

## Chirac (et Jospin) félicités

J. Chirac a, lui, bénéficié d'un hommage sincère. Il faut dire que, cédant à la pression continue des organisations juives, il a fini, le 16 juillet 1995, par déclarer la France coupable d'avoir, un demi-siècle auparavant, perpétré un crime exceptionnel contre les Juifs et il en a, au nom de son pays, demandé pardon aux Juifs. Lionel Jospin, son premier ministre, a pris, en conséquence, non sans de sérieuses pressions venues de S. Klarsfeld, toute une série d'exceptionnelles mesures financières en faveur des Juifs ; par exemple, mais ce n'est qu'un exemple, il a fini par instituer des « réparations » financières au seul profit des orphelins de déportés juifs et, malgré les protestations des familles concernées, il a refusé la même mesure en faveur des orphelins de déportés non juifs, de résistants non juifs et de fusillés non juifs. Le Conseil d'État lui a donné raison. Faut-il s'en étonner ? Les organisations juives et, en particulier celle de S. Klarsfeld, avaient proclamé que, si jamais des droits identiques étaient accordés aux orphelins non juifs, il en cuirait au Conseil d'État : une campagne serait déclenchée sur le thème de la complaisance des conseillers d'État, pendant la guerre, pour le maréchal Pétain. Le 23 mars 2001, à Paris, des manifestants, conduits par l'incendiaire devant les bâtiments du Conseil d'État en train de délibérer, brandissaient une pancarte où pouvait se lire : « Le Conseil d'État s'est trop mal conduit à l'égard des Juifs de 1940 à 1944 pour récidiver en 2001 ! ».

## En fait, de Gaulle et Mitterrand pour la concorde ; les Juifs pour la vengeance

Aux yeux de J. Kahn, de S. Klarsfeld et des organisations juives, le crime de Charles de Gaulle et de François Mitterrand est d'avoir dissimulé la vérité « pour préserver la paix civile ». Ici, il faut bien reconnaître qu'avant J. Chirac tous nos présidents de la République se sont montrés, à des degrés divers, soucieux de la paix civile. Pour reprendre le mot de Georges Pompidou, ils ont souhaité qu'on en finisse avec « ces temps où les Français ne s'aimaient pas ». Or J. Kahn et S. Klarsfeld ne l'entendent pas de cette oreille. Ils n'ont cure de la paix entre Français. Ils rouvrent les plaies. Ils les avivent. Ils les fouaillent. Ils ne rappellent que les « crimes » dont les Juifs auraient été les innocentes victimes, puis, menaces à la bouche et sébile dans la main, ils réclament encore et plus d'argent et de faveurs. Chemin faisant, ils exagèrent considérablement en nombre et en qualité ces crimes-là. En revanche, ils n'ont pas un mot pour les crimes de la Résistance ou de l'Epuration où, pourtant, les Juifs ont eu leur lourde part de responsabilité. Depuis la Libération, c'est-à-dire depuis près de soixante ans les enfants de Sion continuent cette Epuration et pourchassent sur tous les points du globe des vieillards égrotants, qu'ils accusent, le plus souvent sans preuves mais seulement avec les « témoignages » de Juifs octogénaires ou nonagénaires, d'avoir persécuté ou tué des Juifs. C'est ce qu'ils entendent par leur devise « Servir la Mémoire » ou par leur slogan « N'oublions jamais », lequel veut surtout dire « Ne pardonnons jamais » et « Sachons, en conséquence, exiger le traitement de faveur et l'argent que nous estimons nous être dus au nom de la repentance des non juifs ». Excipant de ce que Jacques Chirac a déclaré que la France avait « commis l'irréparable », ils ont audacieusement conclu que la France devait aux juifs des réparations financières.

## Les profits de la vengeance : Shoah business et Industrie de l'Holocauste

Les organisations juives ou sionistes accumulent depuis 1946 des fortunes en « réparations » ou en « indemnisations ». Elles pratiquent un racket international que certains Juifs, honteux de tels procédés maffieux, appellent « le Shoah Business » ou « l'Industrie de l'Holocauste ». Rien qu'en France, le contribuable, qui ne s'en doute guère, en est à verser par divers moyens des flots d'argent. Le simple Français qui paie ses impôts ou qui possède un compte en banque et des actions ou qui souscrit un contrat d'assurances ou qui visite certains musées ou qui envoie ses enfants au lycée, ignore en général qu'à chaque fois il acquitte ainsi par la même occasion une dîme forcée au bénéfice de ces maîtres-chanteurs. De puissantes organisations juives ont, en effet, obtenu, par la pression politique ou médiatique, que différents ministères, certaines banques, des groupes industriels ou commerciaux, des compagnies d'assurances, la SNCF et des musées versent aux organisations juives ou à des particuliers juifs des rentes ou des « réparations » qui sont autant de pactoles. Etendues à l'échelle internationale, de telles ponctions enrichissent une foule d'aigrefins qui ne voient pas pourquoi cesserait cette manne céleste. D'où la multiplication des musées de l'Holocauste et la prolifération des programmes scolaires ou universitaires intégrant désormais l'enseignement obligatoire de « la Shoah ». D'où l'incessant défilé, dans les médias, de Juifs qui, en nombre stupéfiant, nous révèlent qu'ils sont des rescapés, des « miraculés » de « la Shoah » et qui nous débitent les mêmes rengaines, vides de sens ou de précision, sur les infernales chambres à gaz nazies. Ils étaient dans des « camps d'extermination » où les Allemands ont oublié de les « exterminer ». Ils ne sont tous, uniformément, revenus que « par miracle » et, presque à chaque fois, toute leur famille « a disparu ». La loi nous interdit de contester leurs récits.

## Une loi spéciale pour protéger le grand tabou juif

En France et en d'autres pays on a fini par créer, à partir des années 1990, des lois spéciales interdisant, sous peine de prison ou d'amende, la contestation ou la simple mise en doute de la version que des organisations juives nous imposent ainsi de la Seconde guerre mondiale. A telle enseigne que, si vous ne croyez pas aux mystérieuses « chambres à gaz » (à ne pas confondre avec les fours crématoires), ce sera pour vous, au choix ou simultanément, l'amende ou la prison, l'interdiction professionnelle ou bien le retrait de vos titres ou de vos activités universitaires normales. En France, les Juifs, sous la houlette du millionnaire juif (et socialiste) Laurent Fabius, ont exigé et obtenu une loi, improprement appelée « loi Gayssot » ; datée du 13 juillet 1990, elle officialise ainsi une vérité casher et punit sévèrement les contestataires ou les mécréants de l'école révisionniste. Pas une seule autre communauté française n'est parvenue à se voir accorder pareil privilège. On se croirait revenu au temps de la Rome de Jules César où les Juifs, déjà, obtenaient tant de faveurs exorbitantes que les Romains flattaient outrageusement ces privilégiés jusqu'à vouloir, pour certains, adopter la religion hébraïque. A. Finkielkraut, encore lui, écrivait dans Le Monde du 7 octobre 1998 :

Ah, qu'il est doux d'être juif en cette fin de XX^e^ siècle ! Nous ne sommes plus les accusés de l'Histoire, nous en sommes les chouchous. L'esprit du monde nous aime, nous honore, nous défend, prend en charge nos intérêts ; il a même besoin de notre imprimatur.

## De Gaulle avait refusé de payer tribut au grand tabou juif

Les griefs de bien des Juifs à l'égard du général de Gaulle ne sont pas toujours clairement exprimés. De 1940 à 1945, Charles de Gaulle s'était entouré de Juifs et de communistes encore plus que ne l'avait fait Léon Blum, en 1936-1937, au moment du gouvernement du Front populaire. Pour des raisons d'opportunité politique, il lui avait fallu leur accorder toutes sortes de gages. En 1944-1946, à Londres, à Alger et à Paris, il avait souvent donné satisfaction à leurs désirs de vengeance épuratrice contre ceux qu'on appelait « les collabos », ces derniers étant des Français qui avaient, bon gré mal gré, choisi le camp de l'Allemagne pour lutter, en France ou sur le front de l'Est, contre ce qu'ils appelaient la terreur judéo-communiste ou le terrorisme judéo-bolchevique. Mais de Gaulle, par la suite, revenant au pouvoir en 1958, allait chercher à se dégager de toute emprise. Se faisant « une certaine idée de la France », il fut conduit à prendre ses distances d'avec ceux qui voulaient lui dicter une conduite, en particulier dans le conflit judéo-palestinien. C'est ainsi qu'il en vint un jour à décrire le peuple juif comme un « peuple d'élite, sûr de lui et dominateur ». Il venait de signer là son arrêt de mort politique. « Dominateur » déplut, et même irrita fortement « le peuple élu de Dieu » qui aime à se décrire aussi comme « le peuple à la nuque raide » et dont l'irascibilité ne se compare qu'à celle du Dieu vengeur, du Dieu de colère de l'Ancien Testament. En avril 1969, moins d'un an après l'agitation de mai 1968 orchestrée par Cohn-Bendit et ses amis, de Gaulle dut se retirer de la scène politique. De nos jours, les Juifs ne font plus mystère du rôle joué par les leurs dans cette élimination. Contre de Gaulle ils nourrissent aussi un autre grief, bien plus profond : celui de révisionnisme. De Gaulle, en effet, était révisionniste en ce qu'il ne croyait manifestement ni au génocide des Juifs ni aux « camps d'extermination » ou aux « chambres à gaz ». Il a certes condamné le traitement des Juifs par les Allemands et il a eu les mots les plus durs pour le « système totalitaire » et le « Moloch » hitlériens, mais jamais il n'a, pour autant, cautionné l'existence de chambres à gaz d'extermination. Il n'ajoutait manifestement pas foi aux récits de gazages de Juifs en chambres ou en camions, sinon il ne se serait pas fait faute d'en parler dans ses discours de guerre et surtout dans ses mémoires de guerre, rédigés bien après 1945.

## Même attitude chez Churchill, Eisenhower, Pie XII…

De ce point de vue, il devait partager les convictions d'un Churchill (assez crédule au demeurant sur le compte des « Huns ») ou d'un Eisenhower (qui lança en avril 1945 une opération hollywoodienne en Allemagne sur les « atrocités nazies »). Pour eux, on peut le dire, ces prétendus gazages ont été moins qu'un « détail » puisqu'ils ne les ont même jamais mentionnés, y compris dans leurs mémoires rédigés après la guerre à une époque où le grand public était abreuvé de récits et de prétendus témoignages sur ces abattoirs chimiques. Un haut responsable politique n'est-il pas le premier à savoir que ses officines de propagande sont capables de forger les pires horreurs en matière de récits d'atrocités sur le compte de l'ennemi ? Ni le pape Pie XII, tant critiqué par les Juifs pour son « silence » à ce sujet, ni les sommités politiques du camp des Alliés n'ont consenti à souiller leurs noms par la propagation de calomnies aussi nauséabondes. On le sait maintenant : les Alliés, le Vatican, le Comité international de la Croix-Rouge étaient parfaitement renseignés sur le camp de concentration d'Auschwitz ; ils savaient pertinemment que, si ce camp était ravagé par des épidémies de typhus que les Allemands cherchaient à combattre de toutes leurs forces, les rumeurs d'extermination industrielle et d'abattoirs chimiques n'étaient que des ragots, recyclés des bobards de la Première guerre mondiale.

Dès l'été 1942, les hauts responsables britanniques avaient compris que ces histoires de chambres à gaz n'étaient qu'un article de propagande guerrière. En août 1943, ils convaincront les Américains de renoncer à faire mention de ces chambres à gaz dans un communiqué commun sur « les atrocités allemandes ». Nous possédons le texte du projet de déclaration où figurait l'expression « gas chambers » et le texte final où toute mention de « gas chambers » a été délibérément supprimée à cause de l'insuffisance des preuves (« insufficient evidence ») de l'existence de chambres à gaz. Voilà pourquoi l'aviation américaine n'a bombardé d'Auschwitz que la zone industrielle dite de Monowitz et jamais, dans Birkenau, la zone des prétendues chambres à gaz. De cette zone ils avaient obtenu des photographies aériennes d'une remarquable précision ; or jamais on n'y avait détecté d'indices d'un meurtre de masse en cours tels que la présence de foules humaines à proximité des bâtiments supposés contenir de vastes « chambres à gaz » homicides ; tous les éléments matériels ainsi que les renseignements puisés à bonne source démontraient que ces bâtiments n'étaient que des crématoires dont les fours d'incinération avaient d'ailleurs des rendements tout à fait modestes par rapport à ceux qu'une certaine propagande juive leur prêtait alors, et que l'histoire officielle leur prête aujourd'hui, de manière insensée.

## Pétain, de Gaulle et la politique

La sagesse des nations nous l'enseigne : la politique n'est ni la morale ni une science exacte ; elle n'est que l'art du possible. Alexandre et César, Napoléon et Hitler, Pétain et de Gaulle, Roosevelt, Churchill et Staline ont tous du sang sur les mains. Ils ont tous menti et trompé. Ils ont tous louvoyé ou navigué à vue. Mais au moins se sont-ils colletés avec le monde réel. Prenant leurs responsabilités, ils ont tranché. Les professeurs de morale religieuse, de vertu républicaine, de catéchisme humanitaire affectent d'ignorer les vicissitudes du monde réel. Ils portent des jugements trop éloignés des contingences. Eux aussi, ils tranchent mais dans le confort et la facilité. Ils sont de ces gens « qui ont les mains propres parce qu'en réalité ils n'ont pas de mains ». Comment formuler un jugement d'ordre moral, par exemple, sur l'action politique du maréchal Pétain et du général de Gaulle ainsi que sur les Français qui ont respectivement choisi « Vichy » ou « Londres » ? Nous savons qui a perdu la bataille et qui l'a gagnée, mais sait-on pour autant qui a perdu l'honneur et qui l'a sauvé ? Il est présomptueux celui qui prétend répondre à une telle question. Aussi l'historien a-t-il pour tâche de fermer l'oreille au concert des louanges et des blâmes ; il s'efforcera de comprendre plutôt que de juger ; en tout cas, il ne cèlera rien des éléments qui ont pu, dans telle circonstance précise, dicter au vaincu ou au vainqueur telle décision apparemment condamnable d'un point de vue moral.

## Une accusation juive contre Pétain

Prenons l'accusation suivante : le 26 août 1942, Pétain a fait procéder sur le territoire de la zone libre à une rafle de plus de 6 500 Juifs étrangers, dont des centaines d'enfants ; ces Juifs ont été livrés aux Allemands en zone occupée, d'où ils ont été aussitôt déportés sans retour vers le « camp d'extermination » d'Auschwitz ; plus tard, dans les deux années qui ont suivi, environ 3 500 autres Juifs étrangers vivant en zone libre ont connu le même sort.

La formulation choisie par S. Klarsfeld dans le texte de sa plaque est celle d'un tricheur. Elle donne à entendre que Pétain et Laval savaient l'existence de « camps d'extermination » ou d'« usines de mort » dotées de « chambres à gaz » pour y tuer les Juifs. Mais, comme S. Klarsfeld ne détient pas la preuve que Pétain et Laval savaient tout de ces horreurs (et pour cause, puisqu'il s'agissait d'inventions d'une certaine propagande de guerre), il a tourné sa phrase de sorte que, si on lui en fait la remarque, il pourra toujours rétorquer qu'il n'a pas, en propres termes, affirmé que Pétain et Laval étaient au courant de ces abominations. Il n'a pas accusé ; il s'est contenté d'insinuer !

Nouvelle tricherie : en ajoutant la phrase : « Au total ce fut le sort tragique de plus de 10 000 Juifs étrangers vivant en zone libre », il parvient à masquer un autre fait : Pétain et Laval ont, juste après août 1942, fait machine arrière. Ils se sont prévalus auprès des Allemands des troubles provoqués dans la population française par ces mesures si bien que les arrestations de Juifs étrangers par les autorités françaises ont cessé sauf, bien entendu, dans des cas de crimes ou de délits ou de circonstances exceptionnelles. Pour le reste de l'Occupation, soit pendant près de deux ans, le nombre des Juifs étrangers « livrés » aux Allemands tombera à moins de 3 500 (en supposant que, par exception, les chiffres de S. Klarsfeld soient exacts).

## Hitler face aux Juifs

Puisque Pétain est accusé d'avoir prêté la main à la politique anti-juive de Hitler, il convient de rappeler ce qu'a été cette politique dans la réalité et non dans la légende. La question juive est aussi vieille que le peuple juif. En tout temps et en tout lieu, les Juifs ont fini par susciter, y compris chez les nations les plus hospitalières, un phénomène de rejet. En 1894, Bernard Lazare l'a dit mieux que personne au chapitre premier de L'Antisémitisme, son histoire et ses causes (réédition en 1982 aux éditions de la Différence, 207 p., p. 11). Plutôt que de s'en prendre à la méchanceté des non juifs et à ce qu'il appelle les préjugés anti-juifs ou les conspirations antisémites, le peuple qui se déclare « élu de Dieu » gagnerait à s'interroger sur ses propres responsabilités dans cette constante de l'histoire. Hitler a voulu « une solution finale territoriale de la question juive » (« eine territoriale Endlösung der Judenfrage »). Nous disons bien « territoriale ». De nos jours, les faussaires de l'histoire prennent grand soin d'éliminer cet adjectif. Ainsi nous font-ils croire plus aisément que « solution finale » serait un euphémisme désignant en réalité une suppression physique. En réalité Hitler souhaitait la résolution, une bonne fois pour toutes, de la lancinante question juive par la dévolution aux Juifs d'un territoire qui leur serait propre (les Soviétiques l'avaient tenté avec la création dans les années 1920-1930 de l'Oblast autonome juif de Birobidjan). Les Juifs ne vivraient plus en parasites d'autres peuples mais constitueraient une nation parmi les autres nations. Jamais Hitler n'a voulu ni ordonné une « extermination » des Juifs. Il n'existe aucun ordre, aucune directive, aucune instruction en ce sens. Le plus réputé des historiens juifs du prétendu « Holocauste » est l'Américain Raul Hilberg, auteur d'une somme intitulée La Destruction des Juifs d'Europe ; or, invité par les révisionnistes à expliquer comment les Allemands auraient perpétré un crime de cette dimension sans ordre ni directive, il n'a eu d'autre ressource que d'affirmer que cela s'était fait par « transmission de pensée ». Pour lui, la vaste bureaucratie allemande s'est organisée pour assassiner les Juifs « par l'effet d'une incroyable rencontre des esprits, d'une consensuelle transmission de pensée au sein d'une vaste bureaucratie » (an incredible meeting of minds, a consensus-mind reading by a far-flung bureaucracy »). R. Hilberg, en revanche, n'explique pas les cas de soldats allemands condamnés, pendant la guerre, par des cours martiales allemandes pour « excès » contre des Juifs : l'explication de tels cas est que, loin d'être voués à l'extermination, les Juifs dans les zones sous autorité allemande restaient protégés par la loi pénale.

Hitler a voulu débarrasser d'abord son pays, puis les territoires occupés par ses armées d'une minorité qu'il jugeait active, puissante ou dangereuse. Il en a voulu l'émigration si possible, l'expulsion si nécessaire. La guerre venant, il a souhaité la neutralisation et le contrôle militaire de ces gens comme tout pays en guerre le fait avec les ressortissants d'une puissance belligérante hostile. Il souhaitait qu'un État juif fût créé hors du continent européen. Dès avant la guerre, la Pologne et la France n'avaient-elles pas étudié, de ce point de vue, ce qui s'était appelé « le Plan de Madagascar » ? Les Allemands, eux, ont envisagé cette solution (Madagaskar Projekt) en 1940 mais l'ont par la suite estimée impossible dans la pratique. Quant à la Palestine, elle offrait en principe une possibilité d'accueil et les Allemands, avant la guerre, ont œuvré en ce sens. Puis, ils y ont renoncé ; ils ont refusé de « prêter la main pour permettre aux Juifs de chasser le noble et vaillant peuple arabe de sa mère-patrie, la Palestine » (document NG 1783 et surtout document NG 1794 tels que rapportés et commentés par Henri Monneray aux pages 168-169 de La Persécution des Juifs dans les pays de l'Est présentée à Nuremberg, Paris, Editions du Centre [de documentation juive contemporaine], 1949, 362 p.). Par la suite, en 1942, Hitler a fait savoir à son administration que la solution du problème devait être repoussée à l'après-guerre (la pièce n°4 du document de Nuremberg PS-4025 de mars-avril 1942 est ainsi résumée par l'organisme américain de poursuite des criminels de guerre : Note exposant que Hitler avait l'intention de repousser à l'après-guerre la solution du problème juif). En attendant, les Juifs furent, en grand nombre, regroupés dans des camps de concentration, des camps de travail, des camps de transit, des ghettos, tous endroits où ceux qui étaient en mesure de travailler étaient employés au service de l'économie allemande qui souffrait d'un besoin criant de main-d'œuvre.

Rappelons au demeurant que tous les pays en guerre se dotaient alors de camps de concentration ou d'internement. Les États-Unis eux-mêmes et le Canada ont enfermé dans de tels camps des populations jugées dangereuses et, en particulier, ne se sont pas privés d'incarcérer nos seulement leurs minorités japonaises mais aussi des citoyens américains ou canadiens d'ethnie japonaise. Le plus important des Alliés, l'Union soviétique, possédait un gigantesque réseau de camps de concentration et ni Churchill, ni Roosevelt, ni de Gaulle n'ont songé à leur en faire grief. La situation affreuse dans laquelle, à la fin du conflit, en mars, avril et mai 1945, on a découvert les camps de concentration allemands était due au délabrement général du pays où vivres et médicaments ne pouvaient quasiment plus circuler. Les villes allemandes elles-mêmes avaient été réduites à des monceaux de ruines où l'aviation alliée avait déchiqueté ou brûlé au phosphore hommes, femmes et enfants coupables d'appartenir à la nation allemande.

La propagande alliée, pour contrebalancer le sentiment d'horreur éprouvé par les vainqueurs eux-mêmes à la vue ― et à l'odeur ― de ces villes, prit soin de photographier et de filmer dans les camps allemands des morts vivants exténués par les épidémies (notamment de typhus et de dysenterie) et les monceaux de cadavres exhumés de charniers et chargés dans des wagons. Ne fallait-il pas faire croire aux troupes américaines ou britanniques qu'elles avaient combattu un peuple satanique ? C'est ainsi qu'aux spectateurs naïfs et indignés des films d'actualités on a fait prendre les morts des camps allemands pour des tués. En fait, c'était la guerre avec son inévitable cortège d'horreurs qui avait été la vraie responsable de ces réels malheurs ; et c'était la propagande de guerre avec ses mensonges obligés qui était la vraie responsable de ces odieuses mises en scène. Il serait aujourd'hui temps, 56 ans après les faits, de s'aviser qu'il n'y a jamais eu de « camps d'extermination » (expression forgée par les Alliés) ni de « camps de la mort » au sens de « camps conçus pour y faire mourir les détenus ».

## Hitler face aux sionistes

Sionistes et nationaux-socialistes partageaient peu ou prou les mêmes idées. Aussi, dès son arrivée au pouvoir en 1933, Hitler s'était-il acquis la sympathie de toute une frange de sionistes qui croyaient en la nécessité de préserver l'identité raciale ou culturelle des Juifs et qui donc refusaient l'assimilation. La masse des autres Juifs entra en violente opposition avec la nouvelle Allemagne au point de lui déclarer, surtout à partir de la Grande-Bretagne et des États-Unis, une sorte de guerre économique par le boycottage. L'Allemagne, saignée par les clauses inhumaines du Traité de Versailles et encore sous l'effet du désastre produit par le blocus naval franco-britannique, en proie à la famine et à une monstrueuse inflation, n'était nullement en mesure de faire face à une exclusion de ses produits du marché international. Ses chômeurs étaient au nombre de six millions. Hitler chercha la parade. Il la trouva grâce aux sionistes, qui lui proposèrent une transaction. Jean-Claude Valla vient, après bien d'autres auteurs juifs ou non juifs, de rapporter l'histoire de cette transaction dans une étude au titre parlant : « Le Pacte germano-sioniste (7 août 1933) », (Les Cahiers libres d'histoire n° 4, 2001, La Librairie Nationale) ; la couverture de la revue s'orne des portraits d'Adolf Hitler et de David Ben Gourion. Ce 7 août 1933, des représentants de l'Agence juive de Palestine et de l'Organisation sioniste mondiale signèrent avec de hauts fonctionnaires du ministère de l'Economie du Reich ce que l'on a appelé l'accord de la Haavara (mot hébreu signifiant transfert) ou, en anglais « the Transfer Agreement ». Cet accord permit, au bénéfice à la fois des nationaux-socialistes et des sionistes, le transfert de capitaux que les Juifs allemands, candidats à l'émigration, souhaitaient emporter avec eux : une partie de ces capitaux servirait à l'achat de marchandises allemandes par ailleurs boycottées. Ce ne fut là que la première étape d'une collaboration prolongée des sionistes avec le III^e^ Reich, y compris en pleine guerre.

En janvier 1941, en Palestine, le Groupe Stern, partie dissidente de l'organisation indépendantiste dite « l'Irgoun », alla jusqu'à proposer une alliance militaire à l'Allemagne contre la Grande-Bretagne. Pendant toute la guerre, des tractations continuèrent entre groupes sionistes et autorités allemandes pour le transport de Juifs, internés dans des camps, en direction de pays neutres avec l'espoir, du côté des sionistes, que ces Juifs gagneraient ensuite la Palestine malgré les forces d'occupation britanniques et la politique de Londres qui interdisait une telle immigration. On lira, par exemple, à ce sujet le livre de Yehuda Bauer, Juifs à vendre ? Les négociations entre nazis et Juifs (1933-1945), publié par Liana Levi en 1996.

Mais s'il est un autre chapitre encore plus embarrassant pour les organisations juives d'aujourd'hui, c'est celui de la collaboration active avec l'Allemagne de tous les « Conseils juifs » avant et pendant la guerre. En France, ce « Conseil » portait le nom d'UGIF (Union générale des Israélites de France). Adolf Eichmann qui, dans l'imagination populaire a pris les traits d'un féroce antisémite, était, en réalité, pro-sioniste et même pro-juif. Il entretenait de bonnes relations avec un grand nombre d'autorités juives, allant jusqu'à les associer à la préparation et à la composition de convois de déportation ou de convois d'échanges. Son enlèvement en Argentine en mai 1960 et son procès préfabriqué à Jérusalem en 1961, suivi de sa pendaison en 1962, forment un chapitre étonnant par ses révélations inattendues sur le degré de collaboration jusqu'en 1945 entre, d'une part, des dirigeants juifs et, d'autre part, des dirigeants nationaux socialistes comme Heinrich Himmler, supérieur hiérarchique d'A. Eichmann. (Précisons, au passage, que ce dernier n'a, contrairement à ce qu'on propage volontiers, jamais avalisé l'histoire des chambres à gaz et n'a parlé de sa prétendue confidence sur les « six millions de Juifs exterminés » que comme d'une pure invention de son collègue Wilhelm Höttl qui, juste après la guerre, est devenu le collaborateur attitré du ministère public américain au procès-spectacle de Nuremberg).

Le 20 janvier 1942, dans une villa de Berlin-Wannsee, Reinhard Heydrich et un ensemble de dirigeants allemands de second ordre n'avaient, pour leur part, nullement mis au point un plan d'extermination physique des Juifs mais avaient évoqué un vague projet de refoulement des Juifs européens vers l'Est. La partie du procès-verbal sur laquelle on ose s'appuyer pour y déchiffrer une prétendue décision d'extermination dit, en fait, exactement le contraire ; elle précise que les Juifs qui auront survécu à l'épreuve de la guerre et du travail forcé constitueront, à leur REMISE EN LIBERTE, la cellule germinative d'un RENOUVEAU JUIF. Encore en 1942, en pleine Allemagne national-socialiste luttant contre les Alliés, il existait des camps pour la formation de jeunes sionistes aux métiers de la terre.

## Le maréchal Pétain face aux Juifs et aux sionistes

Le maréchal Pétain, comme le président Laval et peut-être bien l'ensemble des Français, n'étaient ni antisémites ni anti-antisémites et ne voyaient sans doute pas grande différence entre les Juifs sionistes et les Juifs non sionistes. En revanche, ils opéraient une distinction entre les Français et les étrangers et, par conséquent, entre les Juifs français et les Juifs étrangers ou apatrides. Afin de lever, d'ores et déjà, toute équivoque sur une prétendue politique d'extermination des Juifs de France, il convient de noter qu'au moins 80% de ces derniers (aussi bien les Juifs de nationalité française ou assimilés que les Juifs étrangers ou apatrides) ont survécu à la guerre. A ce propos l'historienne juive Annette Wieviorka écrit :

Sur les 330 000 Juifs qui habitaient la France en 1939, 75 000 environ sont morts en déportation […]. 2 500 […] ont été déportés et ont survécu à Auschwitz. Quatre Juifs sur cinq ont donc été sauvés (Auschwitz expliqué à ma fille, Seuil, 1999, p. 45).

Mais le chiffre des rescapés sur lequel s'appuie l'historienne est celui de S. Klarsfeld ; or ce dernier n'a, de son propre aveu, pas tenu compte des Juifs qui, après la guerre, n'ont pas regagné la France mais se sont installés dans d'autres pays ; puis, dans ses additifs au Mémorial, il a été obligé de « ressusciter » des Juifs qu'il s'était empressé d'enregistrer comme gazés et dont tout le monde, à cause de la notoriété de ces Juifs-là, voyait qu'ils étaient vivants ; enfin, il a procédé à d'autres manipulations et il a fait partie de ceux qui ont obtenu que le Service international de recherches dépendant du Comité international de la Croix-Rouge refuse la consultation de ses archives aux chercheurs désireux de vérifier les données du Mémorial. Aussi, en l'absence actuelle de toute possibilité de vérification, il est raisonnable de penser que le nombre des Juifs de France qui ont survécu à la guerre a été encore supérieur à celui qu'avance A. Wieviorka. Quant aux Juifs d'Afrique du Nord, ils ont survécu à près de 100% : pas un seul d'entre eux n'a été livré aux Allemands, y compris en Tunisie. Et le fait est qu'en aucun pays d'Europe occupé par les Allemands, y compris la Pologne, les Juifs n'ont été exterminés.

Après la guerre, les Juifs polonais ont déferlé sur toute l'Europe occidentale et beaucoup se sont installés, malgré certaines mesures prises par les Américains ou les Britanniques pour contenir ce flot, soit aux États-Unis, soit en Palestine sous mandat britannique. Dans Justice n'est pas vengeance, publié en 1989 chez Robert Laffont, le Juif polonais (et non autrichien) Simon Wiesenthal écrit qu'« une proportion considérable de la population israélienne [quatre millions dans les années 1980 alors qu'en 1945 les Juifs en Palestine étaient au nombre d'un demi-million] est originaire de Pologne » (p. 232) ; il écrit aussi qu'après la guerre, en Pologne même, « un nombre relativement important de juifs occupaient des postes éminents au sein du Parti communiste polonais » (p. 223). A la question : « Si les Juifs n'ont pas été exterminés, où sont-ils passés ? », notre réponse est : « Les survivants sont à rechercher dans les cinquante-sept pays où le cinéaste Stephen Spielberg a envoyé ses émissaires interroger un choix de 50 000 survivants pour ses vidéos-interviews de la Fondation de la Shoah » (voy. Libération, 3 novembre 1999, p. 36).

## Les Juifs et les sionistes face à Pétain, en 1940

En 1940, la population française dans son ensemble, hébétée par l'ampleur de la défaite, voit dans le maréchal Pétain le sauveur du pays. A une écrasante majorité, députés et sénateurs, avec une chambre de gauche, lui délèguent des pouvoirs considérables. L'ensemble des Juifs français partage ces mêmes sentiments. Mais leur situation est particulière. Cette guerre, trop d'entre eux l'avaient voulue alors que la masse des autres Français, quelques bruyants bellicistes mis à part, aspirait à la paix. La communauté juive internationale, à de rares exceptions près, notamment celle de certains sionistes, avait appelé à la croisade contre Hitler. Les médias juifs anglais et américains avaient embouché la trompette guerrière avec une incroyable intensité. La population française, qui avait tant souffert de l'holocauste de 1914-1918, n'avait pas voulu d'un nouvel holocauste. Elle ne souhaitait mourir ni « pour les 100 000 Juifs des Sudètes » ni « pour Dantzig ».

Le 3 septembre 1939, la Grande-Bretagne avait déclaré la guerre à l'Allemagne. Le même jour, la France « entrait » en guerre contre l'Allemagne. Par une manœuvre indigne, Daladier, chef du gouvernement, Herriot, président de la chambre des députés, et Jeanneney, président du Sénat, avaient, en violation de l'article 9 de la loi constitutionnelle, engagé la guerre sans consultation du Parlement ! On a pu écrire que, ce faisant, ils avaient, bien avant le prétendu assassinat de la République le 10 juillet 1940 à Vichy, déjà « assassiné la République » le 3 septembre 1939. Le motif invoqué (l'attaque de la Pologne par Hitler) était fallacieux. En effet, l'invasion de la Pologne occidentale par l'Allemagne allait être suivie de l'invasion de la Pologne orientale par son alliée de circonstance, l'Union soviétique, dès le 17 septembre 1939. Or ni la France ni la Grande-Bretagne ne se croiront pour autant obligées de déclarer la guerre aux Soviétiques, même lorsque ces derniers s'en prendront, tout de suite après, à la Finlande, aux trois Pays baltes et à la Roumanie.

À partir de juin 1941, avec le début de la guerre (offensive ou préventive) de Hitler contre l'Union soviétique, le danger du terrorisme communiste prit en France des proportions alarmantes. Beaucoup de Juifs étrangers ou apatrides, récemment établis en France, avaient des activités communistes ou, à tout le moins, nourrissaient des sympathies pour le communisme sous ses différentes formes. Dans l'esprit de la population française, l'amalgame entre Juifs et communistes allait s'aggraver. Les Juifs français eux-mêmes tendirent à se démarquer nettement des Juifs étrangers. Ils admettaient que Léon Blum, en 1936-1937, s'était entouré de trop de Juifs pour ne pas nuire à leur image. Certains d'entre eux, en petit nombre, s'indigneront des premières mesures prises par l'État français contre les Juifs dans l'indifférence générale des Français qui, tout à leurs angoisses de l'heure, devaient songer que, s'il y avait des gens à plaindre, ce ne pouvait être ceux qui avaient tant poussé à la guerre. Ces mesures visaient à limiter le nombre et l'influence des Juifs dans divers corps de l'État et dans certaines professions. D'une manière plus générale, la politique de l'État français en la matière était peut-être moins anti-juive que xénophobe. En France, en temps de guerre, on se méfiait des étrangers, surtout quand ceux-ci se trouvaient parler allemand ou, avec le yiddish, une langue proche de l'allemand. Les Juifs français pouvaient donc admettre au moins en partie le bien-fondé de ces mesures qui, d'ailleurs, ne se traduisaient que partiellement dans les faits.

## Que répondre à l'iniquité ?

Il nous semble qu'à tant de mensonges, à tant de haine, à tant d'iniquité il importe de répondre par le calme, le sang-froid et le désir d'une pacification des esprits. Sur sa lancée toute une génération de Juifs de France va malheureusement sans doute poursuivre sa course à l'abîme et même intensifier ses campagnes en faveur du maintien de la loi Gayssot ou, plutôt, Fabius-Gayssot. Mais, tôt ou tard, chez les historiens, le besoin de l'exactitude contre les excès de la Mémoire va finir par s'imposer. De même que les sionistes sont condamnés à perdre la partie en terre de Palestine, de même la propagande holocaustique perdra-t-elle à la longue de son crédit. Pour ne prendre que cet exemple, il deviendra impossible de tenir plus longtemps caché que le plus prestigieux des historiens de « l'Holocauste », le Juif américain Raul Hilberg, a fini en 1985 ― nous l'avons vu ― par totalement capituler en reconnaissant que, contrairement à ce qu'il affirmait en 1961 dans la première édition de son grand œuvre, The Destruction of the European Jews (p. 177), il n'avait existé aucun ordre d'exterminer physiquement les Juifs. En 1982, rendant hommage à la qualité des travaux de « Faurisson et d'autres [révisionnistes] », il s'est engagé dans de toutes nouvelles recherches. Certes il n'a nullement révisé ses conclusions et il a persisté à défendre l'indéfendable thèse d'une politique de destruction physique des Juifs d'Europe mais le nouvel édifice de « preuves » qu'il lui a fallu construire s'est effondré dans la spéculation cabalistique.

R. Hilberg s'est en effet mis, sans rire, à nous expliquer à partir de 1983-1985 que l'Allemagne de Hitler et, en particulier, ses bureaucrates ont spontanément créé « un climat » (sic) qui leur a permis de progressivement renoncer au « formalisme écrit » pour adopter « une incroyable rencontre des esprits, une transmission de pensée consensuelle au sein d'une vaste bureaucratie » bien décidée à exterminer secrètement les Juifs. En 1985, dans sa nouvelle et « définitive » (sic) édition, se jetant à corps perdu dans une sorte d'ivresse mystique, il s'est mis à prétendre que ce crime sans précédent avait été « une affaire d'esprit, de compréhension tacite, de consonance et de synchronisation », et cela sans aucun « organisme central chargé de diriger et coordonner à lui seul l'ensemble du processus. L'appareil de destruction s'étendait de tous côtés ; il était diversifié, et, avant tout décentralisé ».

Et, continuant dans ce même registre, R. Hilberg de conclure : « Ainsi la destruction des Juifs fut-elle l'œuvre d'une très vaste machine administrative. Cet appareil avança pas à pas ; l'initiative des décisions, comme leur application, dépendit toujours largement de lui. Pour détruire les Juifs d'Europe, il ne fut créé ni organisme spécial, ni budget particulier. Chacune des branches devait jouer dans le processus un rôle spécifique, et chacune trouver en elle-même les moyens d'y accomplir sa tâche » (version française : La Destruction des Juifs d'Europe, Fayard, 1988, 1101 pages, p. 51-53, 60 ; au lieu de nous montrer une image de l'arme du crime qu'aurait été une chambre à gaz nazie, la page de couverture s'illustre de la photo d'une pitoyable Juive de camp ou de ghetto en train de manger sa soupe).

Il existe peu de destins plus pathétiques que celui de Raul Hilberg, né le 6 juin 1926. Chercheur hors paire de l'« Holocauste », il a d'abord été porté aux nues dans tout le monde occidental. Puis, à la fin des années 1970 et au début des années 1980, découvrant soudain la formidable puissance des arguments physico-chimiques de ceux qu'il a appelés « Faurisson et d'autres », il s'est rendu compte qu'il avait fait fausse route. Changeant du tout au tout son explication de l'« Holocauste », il a alors fabriqué une explication totalement irrationnelle : pour décider et mener « la destruction des Juifs d'Europe, le III^e^ Reich n'avait eu, en fait, besoin ni d'un ordre, ni d'un plan, ni d'une organisation, ni d'un budget, ni de préparatifs, ni d'une somme d'instructions et de documents écrits ; il avait suffi à la vaste bureaucratie allemande d'abandonner, en silence et de manière spontanée, l'écrit au profit de l'oral et de procéder, comme on l'a vu plus haut, « par une incroyable rencontre des esprits, une transmission de pensée consensuelle » ! Quelle humiliation ! Mais R. Hilberg allait connaître une autre humiliation. Alors que, pour sa part, il avait en quelque sorte « capitulé », d'autres juifs avaient persisté à défendre la thèse habituelle. Tels étaient, en particulier, les cas respectifs de Serge Klarsfeld et de Pierre Vidal-Naquet. Ces deux derniers avaient placé toute leur confiance en un pharmacien du nom de Jean-Claude Pressac qui s'imaginait avoir trouvé des « commencements de preuves » de l'existence des chambres à gaz nazies. En 1995, le malheureux Pressac allait connaître une terrible humiliation à la XVII^e^ chambre du tribunal correctionnel de Paris : sommé de montrer une seule preuve de l'existence d'une seule de ces magiques chambres à gaz, il s'en était montré incapable au désespoir de la présidente Martine Ract-Madoux qui conduisait le procès. Rentré à son domicile, Pressac accordait à la doctorante Valérie Igounet un assez long entretien où il finissait par admettre que, « pourri » par trop de mensonges et d'approximations, le dossier de l'histoire traditionnelle des camps était irrémédiablement promis « aux poubelles de l'histoire ». Pendant cinq ans son texte allait être tenu caché. En 2000, V. Igounet le révélait discrètement à la toute fin, et en petit caractère, de son Histoire du négationnisme en France (Seuil, 2000 [mars], 701 p. ; entretien du 15 juin 1995 aux pages 613-652 ; en particulier, les deux dernières pages).

Les Français restent divisés sur le rôle joué par le maréchal Pétain et le président Laval à la tête de « l'État français » et sans doute le resteront-ils encore longtemps. C'est leur droit. Ils ont le droit et le devoir de s'interroger et de s'exprimer librement. Tel n'est malheureusement pas encore le cas. On les bride, on les bâillonne. On les menace de prison ou d'amende s'ils contestent une certaine version officielle de la Seconde guerre mondiale que leur impose la loi Fabius-Gayssot du 13 juillet 1990. Certes, il faut obéir à la loi mais il faut également « résister à la force injuste de la loi, à la tyrannie ». Il convient également que prenne fin ce retour incessant, qu'on leur impose, à « ces temps où les Français ne s'aimaient pas ». Nulle part, et surtout pas en France, le fanatisme ne saurait imposer sa loi. La résistance est possible. Le temps du libre débat reviendra. La « Mémoire » et sa propagande devront s'effacer devant l'Histoire.

20 août 2001

NB : Un touriste de passage à Vichy cherche-t-il un monument qui rappelle que le maréchal Pétain a, pendant quatre ans, installé et maintenu dans cette ville le gouvernement de la France ? Il ne trouvera que ce monument où s'expriment la haine et le mensonge. Puis, il cherche des visites guidées ; il en trouvera mais où on lui débitera à peu près la même leçon. Enfin, il cherche un musée consacré à « Vichy 1940-1944 » ; il n'en découvrira aucun ; c'est que, dans leur prudence et leur sagesse, les autorités locales savent que, si jamais la décision était prise de créer un tel musée, ce dernier serait principalement d'inspiration juive et holocaustique ; il ne ferait que développer les leitmotive de l'infamante plaque.

Quant au maréchal Pétain lui-même et à ses choix personnels dans un conflit aux multiples rebondissements, il semble qu'on puisse dire qu'il n'éprouvait de sympathie ou d'indulgence ni pour les Britanniques (surtout après l'affaire, le 3 juillet 1940, de Mers el-Kébir où 1297 marins français avaient trouvé la mort), ni pour les Allemands qui, de leur côté, au temps de l'Occupation, avaient tendance à l'appeler « der Marschall immer nein » (le maréchal toujours non) ; en revanche, il nourrissait une indéniable sympathie pour les Américains. Quant aux Soviétiques, en dépit du fait qu'ils avaient reconnu la légitimité de l'État français et envoyé un ambassadeur à Vichy, il en pensait tout le mal que la Terreur rouge pouvait inspirer à un sympathisant de l'Espagne franquiste.

Labels: Chirac, de Gaulle, Déportation, Finkielkraut, Haavara, Hilberg, Jean Kahn, Klarsfeld, Laval, Mitterrand, Pétain, Vichy, Wannsee

---

- [Sommaire des articles](index.html)
