-- =============================================================================
-- 
-- =============================================================================

-- =============================================================================

function FileExists(file)
  local f = io.open(file, 'rb')
  if f then f:close() end
  return f ~= nil
end

function LinesFrom(file)
  if not FileExists(file) then return {} end
  local lines = {}
  for line in io.lines(file) do 
    --lines[#lines + 1] = line
    lines[#lines + 1] = string.gsub(line, '%s+', '')
  end
  return lines
end

function ReadText(AFileName)
  local LFile, LErr = io.open(AFileName, 'r')
  if LFile then
    local LText = LFile:read('*a')
    io.close(LFile)
    return LText
  else
    io.write('[ERR] ' .. LErr)
    return nil
  end
end

function WriteText(AFileName, AText)
  local LFile, LErr = io.open(AFileName, 'w')
  if LFile then
    LFile:write(AText)
    io.close(LFile)
  else
    io.write('[ERR] ' .. LErr)
  end
end

-- =============================================================================

-- fpc cleanhtml
-- ./cleanhtml dl-old/a-vichy-un-monument-diniquite.html dl/a-vichy-un-monument-diniquite.html

-- Main program

for s in io.lines('basenames.txt') do
  local cmd = './cleanhtml dl-old/' .. s .. '.html dl/' .. s .. '.html'
  os.execute(cmd)
end

--local LBaseNames = LinesFrom('basenames.txt')
--io.write('[INFO] ' .. #LBaseNames .. ' basenames loaded\n')

--local LAppName = 'Pascal Code Beautifier 0.1'
--local LUsage =
--  'Usage:\n' ..
--  '  lua pcb.lua IN_FILE [OUT_FILE]\n'
--io.write(LAppName .. '\n')
--if #arg >= 2 then
--  local LKeywordsFile = arg[1]
--  local LFileName     = arg[2]
--  local LDestName     = (#arg >= 3) and arg[3] or LFileName
--  local LText = ReadText(LFileName)
--  WriteText(LDestName, LText)
--else
--  io.write(LUsage)
--end
