{

  Adaption of the delphi3d.net OpenGL units to FreePascal
  Sebastian Guenther (sg@freepascal.org) in 2002
  These units are free to use
}

{ modified 2011-2013 by Martin Schreiber }

unit mseglext;
{$ifdef FPC}{$MACRO ON}{$mode objfpc} {$h+}{$endif}
{$IFDEF msWindows}
 {$define wincall}
//  {$DEFINE extdecl:=stdcall }
{$ELSE}
//  {$DEFINE extdecl:=cdecl }
{$ENDIF}

(**************************************************
 *        OpenGL extension loading library        *
 * Generated by MetaGLext, written by Tom Nuydens *
 *  (tom@delphi3d.net -- http://www.delphi3d.net  *
 **************************************************)

//*** Generated on 10/11/2002

interface

uses
  SysUtils,
  {$IFDEF msWindows}
  Windows,
  {$ELSE}
  {$ifdef FPC}dynlibs,{$endif}
  {$ENDIF}
  msegl,mseglextglob{$ifndef FPC},msetypes{$endif};

{$IFDEF msWindows}
{ Declared in Windows unit as well in FPC; but declared here as well, to be
  fully compatible to upstream version  - sg }
function wglGetProcAddress(proc: PChar): Pointer; {$ifdef wincall}stdcall{$else}cdecl{$endif}; external 'OpenGL32.dll';
{$ENDIF}
(*
// Test if the given extension name is present in the given extension string.
function glext_ExtensionSupported(const extension: String; const searchIn: String): Boolean;

// Load the extension with the given name.
function glext_LoadExtension(ext: String): Boolean;
*)
type
  GLcharARB = Char;
  TGLcharARB = GLcharARB;
  PGLcharARB = ^GLcharARB;
  PPGLchar = ^PGLchar;

  GLhandleARB = Cardinal;
  TGLhandleARB = GLhandleARB;
  PGLhandleARB = ^GLhandleARB;

  GLintptr = PtrInt;
  TGLintptr = GLintptr;
  PGLintptr = ^GLintptr;

  GLsizeiptr = PtrInt;
  TGLsizeiptr = GLsizeiptr;
  PGLsizeiptr = ^GLsizeiptr;

  GLchar = Char;
  TGLchar = GLchar;
  PGLchar = Pchar;

  GLint64 = Int64;
  TGLint64 = GLint64;
  PGLint64 = ^GLint64;

  GLuint64 = QWord;
  TGLuint64 = GLuint64;
  PGLuint64 = ^GLuint64;


//***** GL_version_1_2 *****//
const
  GL_UNSIGNED_BYTE_3_3_2 = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
  GL_UNSIGNED_INT_8_8_8_8 = $8035;
  GL_UNSIGNED_INT_10_10_10_2 = $8036;
  GL_RESCALE_NORMAL = $803A;
  GL_UNSIGNED_BYTE_2_3_3_REV = $8362;
  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_UNSIGNED_SHORT_5_6_5_REV = $8364;
  GL_UNSIGNED_SHORT_4_4_4_4_REV = $8365;
  GL_UNSIGNED_SHORT_1_5_5_5_REV = $8366;
  GL_UNSIGNED_INT_8_8_8_8_REV = $8367;
  GL_UNSIGNED_INT_2_10_10_10_REV = $8368;
  GL_BGR = $80E0;
  GL_BGRA = $80E1;
  GL_MAX_ELEMENTS_VERTICES = $80E8;
  GL_MAX_ELEMENTS_INDICES = $80E9;
  GL_CLAMP_TO_EDGE = $812F;
  GL_TEXTURE_MIN_LOD = $813A;
  GL_TEXTURE_MAX_LOD = $813B;
  GL_TEXTURE_BASE_LEVEL = $813C;
  GL_TEXTURE_MAX_LEVEL = $813D;
  GL_LIGHT_MODEL_COLOR_CONTROL = $81F8;
  GL_SINGLE_COLOR = $81F9;
  GL_SEPARATE_SPECULAR_COLOR = $81FA;
  GL_SMOOTH_POINT_SIZE_RANGE = $0B12;
  GL_SMOOTH_POINT_SIZE_GRANULARITY = $0B13;
  GL_SMOOTH_LINE_WIDTH_RANGE = $0B22;
  GL_SMOOTH_LINE_WIDTH_GRANULARITY = $0B23;
  GL_ALIASED_POINT_SIZE_RANGE = $846D;
  GL_ALIASED_LINE_WIDTH_RANGE = $846E;
  GL_PACK_SKIP_IMAGES = $806B;
  GL_PACK_IMAGE_HEIGHT = $806C;
  GL_UNPACK_SKIP_IMAGES = $806D;
  GL_UNPACK_IMAGE_HEIGHT = $806E;
  GL_TEXTURE_3D = $806F;
  GL_PROXY_TEXTURE_3D = $8070;
  GL_TEXTURE_DEPTH = $8071;
  GL_TEXTURE_WRAP_R = $8072;
  GL_MAX_3D_TEXTURE_SIZE = $8073;
var
  glBlendColor: procedure(red: GLclampf; green: GLclampf; blue: GLclampf; alpha: GLclampf); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBlendEquation: procedure(mode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawRangeElements: procedure(mode: GLenum; start: GLuint; _end: GLuint; count: GLsizei; _type: GLenum; const indices: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorTable: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const table: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorTableParameterfv: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorTableParameteriv: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyColorTable: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTable: procedure(target: GLenum; format: GLenum; _type: GLenum; table: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorSubTable: procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyColorSubTable: procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionFilter1D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionFilter2D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameterf: procedure(target: GLenum; pname: GLenum; params: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameterfv: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameteri: procedure(target: GLenum; pname: GLenum; params: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameteriv: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyConvolutionFilter1D: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyConvolutionFilter2D: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionFilter: procedure(target: GLenum; format: GLenum; _type: GLenum; image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSeparableFilter: procedure(target: GLenum; format: GLenum; _type: GLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSeparableFilter2D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const row: PGLvoid; const column: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogram: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogramParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogramParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmax: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmaxParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmaxParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glHistogram: procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMinmax: procedure(target: GLenum; internalformat: GLenum; sink: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glResetHistogram: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glResetMinmax: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexImage3D: procedure(target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_version_1_2: Boolean;

//***** GL_ARB_imaging *****//
const
  GL_CONSTANT_COLOR = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR = $8002;
  GL_CONSTANT_ALPHA = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA = $8004;
  GL_BLEND_COLOR = $8005;
  GL_FUNC_ADD = $8006;
  GL_MIN = $8007;
  GL_MAX = $8008;
  GL_BLEND_EQUATION = $8009;
  GL_FUNC_SUBTRACT = $800A;
  GL_FUNC_REVERSE_SUBTRACT = $800B;
  GL_CONVOLUTION_1D = $8010;
  GL_CONVOLUTION_2D = $8011;
  GL_SEPARABLE_2D = $8012;
  GL_CONVOLUTION_BORDER_MODE = $8013;
  GL_CONVOLUTION_FILTER_SCALE = $8014;
  GL_CONVOLUTION_FILTER_BIAS = $8015;
  GL_REDUCE = $8016;
  GL_CONVOLUTION_FORMAT = $8017;
  GL_CONVOLUTION_WIDTH = $8018;
  GL_CONVOLUTION_HEIGHT = $8019;
  GL_MAX_CONVOLUTION_WIDTH = $801A;
  GL_MAX_CONVOLUTION_HEIGHT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE = $801F;
  GL_POST_CONVOLUTION_RED_BIAS = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS = $8023;
  GL_HISTOGRAM = $8024;
  GL_PROXY_HISTOGRAM = $8025;
  GL_HISTOGRAM_WIDTH = $8026;
  GL_HISTOGRAM_FORMAT = $8027;
  GL_HISTOGRAM_RED_SIZE = $8028;
  GL_HISTOGRAM_GREEN_SIZE = $8029;
  GL_HISTOGRAM_BLUE_SIZE = $802A;
  GL_HISTOGRAM_ALPHA_SIZE = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE = $802C;
  GL_HISTOGRAM_SINK = $802D;
  GL_MINMAX = $802E;
  GL_MINMAX_FORMAT = $802F;
  GL_MINMAX_SINK = $8030;
  GL_TABLE_TOO_LARGE = $8031;
  GL_COLOR_MATRIX = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS = $80BA;
  GL_POST_COLOR_MATIX_ALPHA_BIAS = $80BB;
  GL_COLOR_TABLE = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE = $80D2;
  GL_PROXY_COLOR_TABLE = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = $80D5;
  GL_COLOR_TABLE_SCALE = $80D6;
  GL_COLOR_TABLE_BIAS = $80D7;
  GL_COLOR_TABLE_FORMAT = $80D8;
  GL_COLOR_TABLE_WIDTH = $80D9;
  GL_COLOR_TABLE_RED_SIZE = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE = $80DF;
  GL_IGNORE_BORDER = $8150;
  GL_CONSTANT_BORDER = $8151;
  GL_WRAP_BORDER = $8152;
  GL_REPLICATE_BORDER = $8153;
  GL_CONVOLUTION_BORDER_COLOR = $8154;

function Load_GL_ARB_imaging: Boolean;

//***** GL_version_1_3 *****//
const
  GL_TEXTURE0 = $84C0;
  GL_TEXTURE1 = $84C1;
  GL_TEXTURE2 = $84C2;
  GL_TEXTURE3 = $84C3;
  GL_TEXTURE4 = $84C4;
  GL_TEXTURE5 = $84C5;
  GL_TEXTURE6 = $84C6;
  GL_TEXTURE7 = $84C7;
  GL_TEXTURE8 = $84C8;
  GL_TEXTURE9 = $84C9;
  GL_TEXTURE10 = $84CA;
  GL_TEXTURE11 = $84CB;
  GL_TEXTURE12 = $84CC;
  GL_TEXTURE13 = $84CD;
  GL_TEXTURE14 = $84CE;
  GL_TEXTURE15 = $84CF;
  GL_TEXTURE16 = $84D0;
  GL_TEXTURE17 = $84D1;
  GL_TEXTURE18 = $84D2;
  GL_TEXTURE19 = $84D3;
  GL_TEXTURE20 = $84D4;
  GL_TEXTURE21 = $84D5;
  GL_TEXTURE22 = $84D6;
  GL_TEXTURE23 = $84D7;
  GL_TEXTURE24 = $84D8;
  GL_TEXTURE25 = $84D9;
  GL_TEXTURE26 = $84DA;
  GL_TEXTURE27 = $84DB;
  GL_TEXTURE28 = $84DC;
  GL_TEXTURE29 = $84DD;
  GL_TEXTURE30 = $84DE;
  GL_TEXTURE31 = $84DF;
  GL_ACTIVE_TEXTURE = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE = $84E1;
  GL_MAX_TEXTURE_UNITS = $84E2;
  GL_TRANSPOSE_MODELVIEW_MATRIX = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX = $84E6;
  GL_MULTISAMPLE = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_ALPHA_TO_ONE = $809F;
  GL_SAMPLE_COVERAGE = $80A0;
  GL_SAMPLE_BUFFERS = $80A8;
  GL_SAMPLES = $80A9;
  GL_SAMPLE_COVERAGE_VALUE = $80AA;
  GL_SAMPLE_COVERAGE_INVERT = $80AB;
  GL_MULTISAMPLE_BIT = $20000000;
  GL_NORMAL_MAP = $8511;
  GL_REFLECTION_MAP = $8512;
  GL_TEXTURE_CUBE_MAP = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE = $851C;
  GL_COMPRESSED_ALPHA = $84E9;
  GL_COMPRESSED_LUMINANCE = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA = $84EB;
  GL_COMPRESSED_INTENSITY = $84EC;
  GL_COMPRESSED_RGB = $84ED;
  GL_COMPRESSED_RGBA = $84EE;
  GL_TEXTURE_COMPRESSION_HINT = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE = $86A0;
  GL_TEXTURE_COMPRESSED = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
  GL_CLAMP_TO_BORDER = $812D;
  GL_CLAMP_TO_BORDER_SGIS = $812D;
  GL_COMBINE = $8570;
  GL_COMBINE_RGB = $8571;
  GL_COMBINE_ALPHA = $8572;
  GL_SOURCE0_RGB = $8580;
  GL_SOURCE1_RGB = $8581;
  GL_SOURCE2_RGB = $8582;
  GL_SOURCE0_ALPHA = $8588;
  GL_SOURCE1_ALPHA = $8589;
  GL_SOURCE2_ALPHA = $858A;
  GL_OPERAND0_RGB = $8590;
  GL_OPERAND1_RGB = $8591;
  GL_OPERAND2_RGB = $8592;
  GL_OPERAND0_ALPHA = $8598;
  GL_OPERAND1_ALPHA = $8599;
  GL_OPERAND2_ALPHA = $859A;
  GL_RGB_SCALE = $8573;
  GL_ADD_SIGNED = $8574;
  GL_INTERPOLATE = $8575;
  GL_SUBTRACT = $84E7;
  GL_CONSTANT = $8576;
  GL_PRIMARY_COLOR = $8577;
  GL_PREVIOUS = $8578;
  GL_DOT3_RGB = $86AE;
  GL_DOT3_RGBA = $86AF;
var
  glActiveTexture: procedure(texture: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClientActiveTexture: procedure(texture: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1d: procedure(target: GLenum; s: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1dv: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1f: procedure(target: GLenum; s: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1fv: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1i: procedure(target: GLenum; s: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1iv: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1s: procedure(target: GLenum; s: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1sv: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2d: procedure(target: GLenum; s: GLdouble; t: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2dv: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2f: procedure(target: GLenum; s: GLfloat; t: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2fv: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2i: procedure(target: GLenum; s: GLint; t: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2iv: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2s: procedure(target: GLenum; s: GLshort; t: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2sv: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3d: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3dv: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3f: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3fv: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3i: procedure(target: GLenum; s: GLint; t: GLint; r: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3iv: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3s: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3sv: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4d: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4dv: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4f: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4fv: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4i: procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4iv: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4s: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4sv: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLoadTransposeMatrixf: procedure(const m: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLoadTransposeMatrixd: procedure(const m: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultTransposeMatrixf: procedure(const m: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultTransposeMatrixd: procedure(const m: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSampleCoverage: procedure(value: GLclampf; invert: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexImage3D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexImage2D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexImage1D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage2D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage1D: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCompressedTexImage: procedure(target: GLenum; level: GLint; img: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_version_1_3: Boolean;

//***** GL_ARB_multitexture *****//
const
  GL_TEXTURE0_ARB = $84C0;
  GL_TEXTURE1_ARB = $84C1;
  GL_TEXTURE2_ARB = $84C2;
  GL_TEXTURE3_ARB = $84C3;
  GL_TEXTURE4_ARB = $84C4;
  GL_TEXTURE5_ARB = $84C5;
  GL_TEXTURE6_ARB = $84C6;
  GL_TEXTURE7_ARB = $84C7;
  GL_TEXTURE8_ARB = $84C8;
  GL_TEXTURE9_ARB = $84C9;
  GL_TEXTURE10_ARB = $84CA;
  GL_TEXTURE11_ARB = $84CB;
  GL_TEXTURE12_ARB = $84CC;
  GL_TEXTURE13_ARB = $84CD;
  GL_TEXTURE14_ARB = $84CE;
  GL_TEXTURE15_ARB = $84CF;
  GL_TEXTURE16_ARB = $84D0;
  GL_TEXTURE17_ARB = $84D1;
  GL_TEXTURE18_ARB = $84D2;
  GL_TEXTURE19_ARB = $84D3;
  GL_TEXTURE20_ARB = $84D4;
  GL_TEXTURE21_ARB = $84D5;
  GL_TEXTURE22_ARB = $84D6;
  GL_TEXTURE23_ARB = $84D7;
  GL_TEXTURE24_ARB = $84D8;
  GL_TEXTURE25_ARB = $84D9;
  GL_TEXTURE26_ARB = $84DA;
  GL_TEXTURE27_ARB = $84DB;
  GL_TEXTURE28_ARB = $84DC;
  GL_TEXTURE29_ARB = $84DD;
  GL_TEXTURE30_ARB = $84DE;
  GL_TEXTURE31_ARB = $84DF;
  GL_ACTIVE_TEXTURE_ARB = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE_ARB = $84E1;
  GL_MAX_TEXTURE_UNITS_ARB = $84E2;
var
  glActiveTextureARB: procedure(texture: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClientActiveTextureARB: procedure(texture: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1dARB: procedure(target: GLenum; s: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1dvARB: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1fARB: procedure(target: GLenum; s: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1fvARB: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1iARB: procedure(target: GLenum; s: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1ivARB: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1sARB: procedure(target: GLenum; s: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1svARB: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2dvARB: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2fvARB: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2iARB: procedure(target: GLenum; s: GLint; t: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2ivARB: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2sARB: procedure(target: GLenum; s: GLshort; t: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2svARB: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3dvARB: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3fvARB: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3iARB: procedure(target: GLenum; s: GLint; t: GLint; r: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3ivARB: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3sARB: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3svARB: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4dvARB: procedure(target: GLenum; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4fvARB: procedure(target: GLenum; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4iARB: procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4ivARB: procedure(target: GLenum; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4sARB: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4svARB: procedure(target: GLenum; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_multitexture: Boolean;

//***** GL_ARB_transpose_matrix *****//
const
  GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX_ARB = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX_ARB = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX_ARB = $84E6;
var
  glLoadTransposeMatrixfARB: procedure(m: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLoadTransposeMatrixdARB: procedure(m: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultTransposeMatrixfARB: procedure(m: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultTransposeMatrixdARB: procedure(m: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_transpose_matrix: Boolean;

//***** GL_ARB_multisample *****//
const
  WGL_SAMPLE_BUFFERS_ARB = $2041;
  WGL_SAMPLES_ARB = $2042;
  GL_MULTISAMPLE_ARB = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_ARB = $809F;
  GL_SAMPLE_COVERAGE_ARB = $80A0;
  GL_MULTISAMPLE_BIT_ARB = $20000000;
  GL_SAMPLE_BUFFERS_ARB = $80A8;
  GL_SAMPLES_ARB = $80A9;
  GL_SAMPLE_COVERAGE_VALUE_ARB = $80AA;
  GL_SAMPLE_COVERAGE_INVERT_ARB = $80AB;
var
  glSampleCoverageARB: procedure(value: GLclampf; invert: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_multisample: Boolean;

//***** GL_ARB_texture_env_add *****//

function Load_GL_ARB_texture_env_add: Boolean;

{$IFDEF msWindows}
//***** WGL_ARB_extensions_string *****//
var
  wglGetExtensionsStringARB: function(hdc: HDC): Pchar; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_extensions_string: Boolean;

//***** WGL_ARB_buffer_region *****//
const
  WGL_FRONT_COLOR_BUFFER_BIT_ARB = $0001;
  WGL_BACK_COLOR_BUFFER_BIT_ARB = $0002;
  WGL_DEPTH_BUFFER_BIT_ARB = $0004;
  WGL_STENCIL_BUFFER_BIT_ARB = $0008;
var
  wglCreateBufferRegionARB: function(hDC: HDC; iLayerPlane: GLint; uType: GLuint): THandle; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDeleteBufferRegionARB: procedure(hRegion: THandle); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglSaveBufferRegionARB: function(hRegion: THandle; x: GLint; y: GLint; width: GLint; height: GLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglRestoreBufferRegionARB: function(hRegion: THandle; x: GLint; y: GLint; width: GLint; height: GLint; xSrc: GLint; ySrc: GLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_buffer_region: Boolean;
{$ENDIF}

//***** GL_ARB_texture_cube_map *****//
const
  GL_NORMAL_MAP_ARB = $8511;
  GL_REFLECTION_MAP_ARB = $8512;
  GL_TEXTURE_CUBE_MAP_ARB = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP_ARB = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP_ARB = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = $851C;

function Load_GL_ARB_texture_cube_map: Boolean;

//***** GL_ARB_depth_texture *****//
const
  GL_DEPTH_COMPONENT16_ARB = $81A5;
  GL_DEPTH_COMPONENT24_ARB = $81A6;
  GL_DEPTH_COMPONENT32_ARB = $81A7;
  GL_TEXTURE_DEPTH_SIZE_ARB = $884A;
  GL_DEPTH_TEXTURE_MODE_ARB = $884B;

function Load_GL_ARB_depth_texture: Boolean;

//***** GL_ARB_point_parameters *****//
const
  GL_POINT_SIZE_MIN_ARB = $8126;
  GL_POINT_SIZE_MAX_ARB = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_ARB = $8128;
  GL_POINT_DISTANCE_ATTENUATION_ARB = $8129;
var
  glPointParameterfARB: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameterfvARB: procedure(pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_point_parameters: Boolean;

//***** GL_ARB_shadow *****//
const
  GL_TEXTURE_COMPARE_MODE_ARB = $884C;
  GL_TEXTURE_COMPARE_FUNC_ARB = $884D;
  GL_COMPARE_R_TO_TEXTURE_ARB = $884E;

function Load_GL_ARB_shadow: Boolean;

//***** GL_ARB_shadow_ambient *****//
const
  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = $80BF;

function Load_GL_ARB_shadow_ambient: Boolean;

//***** GL_ARB_texture_border_clamp *****//
const
  GL_CLAMP_TO_BORDER_ARB = $812D;

function Load_GL_ARB_texture_border_clamp: Boolean;

//***** GL_ARB_texture_compression *****//
const
  GL_COMPRESSED_ALPHA_ARB = $84E9;
  GL_COMPRESSED_LUMINANCE_ARB = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA_ARB = $84EB;
  GL_COMPRESSED_INTENSITY_ARB = $84EC;
  GL_COMPRESSED_RGB_ARB = $84ED;
  GL_COMPRESSED_RGBA_ARB = $84EE;
  GL_TEXTURE_COMPRESSION_HINT_ARB = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = $86A0;
  GL_TEXTURE_COMPRESSED_ARB = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS_ARB = $86A3;
var
  glCompressedTexImage3DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexImage2DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexImage1DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage3DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage2DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompressedTexSubImage1DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCompressedTexImageARB: procedure(target: GLenum; lod: GLint; img: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_texture_compression: Boolean;

//***** GL_ARB_texture_env_combine *****//
const
  GL_COMBINE_ARB = $8570;
  GL_COMBINE_RGB_ARB = $8571;
  GL_COMBINE_ALPHA_ARB = $8572;
  GL_SOURCE0_RGB_ARB = $8580;
  GL_SOURCE1_RGB_ARB = $8581;
  GL_SOURCE2_RGB_ARB = $8582;
  GL_SOURCE0_ALPHA_ARB = $8588;
  GL_SOURCE1_ALPHA_ARB = $8589;
  GL_SOURCE2_ALPHA_ARB = $858A;
  GL_OPERAND0_RGB_ARB = $8590;
  GL_OPERAND1_RGB_ARB = $8591;
  GL_OPERAND2_RGB_ARB = $8592;
  GL_OPERAND0_ALPHA_ARB = $8598;
  GL_OPERAND1_ALPHA_ARB = $8599;
  GL_OPERAND2_ALPHA_ARB = $859A;
  GL_RGB_SCALE_ARB = $8573;
  GL_ADD_SIGNED_ARB = $8574;
  GL_INTERPOLATE_ARB = $8575;
  GL_SUBTRACT_ARB = $84E7;
  GL_CONSTANT_ARB = $8576;
  GL_PRIMARY_COLOR_ARB = $8577;
  GL_PREVIOUS_ARB = $8578;

function Load_GL_ARB_texture_env_combine: Boolean;

//***** GL_ARB_texture_env_crossbar *****//

function Load_GL_ARB_texture_env_crossbar: Boolean;

//***** GL_ARB_texture_env_dot3 *****//
const
  GL_DOT3_RGB_ARB = $86AE;
  GL_DOT3_RGBA_ARB = $86AF;

function Load_GL_ARB_texture_env_dot3: Boolean;

//***** GL_ARB_texture_mirrored_repeat *****//
const
  GL_MIRRORED_REPEAT_ARB = $8370;

function Load_GL_ARB_texture_mirrored_repeat: Boolean;

//***** GL_ARB_vertex_blend *****//
const
  GL_MAX_VERTEX_UNITS_ARB = $86A4;
  GL_ACTIVE_VERTEX_UNITS_ARB = $86A5;
  GL_WEIGHT_SUM_UNITY_ARB = $86A6;
  GL_VERTEX_BLEND_ARB = $86A7;
  GL_MODELVIEW0_ARB = $1700;
  GL_MODELVIEW1_ARB = $850A;
  GL_MODELVIEW2_ARB = $8722;
  GL_MODELVIEW3_ARB = $8723;
  GL_MODELVIEW4_ARB = $8724;
  GL_MODELVIEW5_ARB = $8725;
  GL_MODELVIEW6_ARB = $8726;
  GL_MODELVIEW7_ARB = $8727;
  GL_MODELVIEW8_ARB = $8728;
  GL_MODELVIEW9_ARB = $8729;
  GL_MODELVIEW10_ARB = $872A;
  GL_MODELVIEW11_ARB = $872B;
  GL_MODELVIEW12_ARB = $872C;
  GL_MODELVIEW13_ARB = $872D;
  GL_MODELVIEW14_ARB = $872E;
  GL_MODELVIEW15_ARB = $872F;
  GL_MODELVIEW16_ARB = $8730;
  GL_MODELVIEW17_ARB = $8731;
  GL_MODELVIEW18_ARB = $8732;
  GL_MODELVIEW19_ARB = $8733;
  GL_MODELVIEW20_ARB = $8734;
  GL_MODELVIEW21_ARB = $8735;
  GL_MODELVIEW22_ARB = $8736;
  GL_MODELVIEW23_ARB = $8737;
  GL_MODELVIEW24_ARB = $8738;
  GL_MODELVIEW25_ARB = $8739;
  GL_MODELVIEW26_ARB = $873A;
  GL_MODELVIEW27_ARB = $873B;
  GL_MODELVIEW28_ARB = $873C;
  GL_MODELVIEW29_ARB = $873D;
  GL_MODELVIEW30_ARB = $873E;
  GL_MODELVIEW31_ARB = $873F;
  GL_CURRENT_WEIGHT_ARB = $86A8;
  GL_WEIGHT_ARRAY_TYPE_ARB = $86A9;
  GL_WEIGHT_ARRAY_STRIDE_ARB = $86AA;
  GL_WEIGHT_ARRAY_SIZE_ARB = $86AB;
  GL_WEIGHT_ARRAY_POINTER_ARB = $86AC;
  GL_WEIGHT_ARRAY_ARB = $86AD;
var
  glWeightbvARB: procedure(size: GLint; weights: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightsvARB: procedure(size: GLint; weights: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightivARB: procedure(size: GLint; weights: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightfvARB: procedure(size: GLint; weights: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightdvARB: procedure(size: GLint; weights: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightvARB: procedure(size: GLint; weights: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightubvARB: procedure(size: GLint; weights: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightusvARB: procedure(size: GLint; weights: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightuivARB: procedure(size: GLint; weights: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWeightPointerARB: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexBlendARB: procedure(count: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_vertex_blend: Boolean;

//***** GL_ARB_vertex_program *****//
const
  GL_VERTEX_PROGRAM_ARB = $8620;
  GL_VERTEX_PROGRAM_POINT_SIZE_ARB = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB = $8643;
  GL_COLOR_SUM_ARB = $8458;
  GL_PROGRAM_FORMAT_ASCII_ARB = $8875;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = $8625;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = $886A;
  GL_CURRENT_VERTEX_ATTRIB_ARB = $8626;
  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = $8645;
  GL_PROGRAM_LENGTH_ARB = $8627;
  GL_PROGRAM_FORMAT_ARB = $8876;
  GL_PROGRAM_BINDING_ARB = $8677;
  GL_PROGRAM_INSTRUCTIONS_ARB = $88A0;
  GL_MAX_PROGRAM_INSTRUCTIONS_ARB = $88A1;
  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A2;
  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A3;
  GL_PROGRAM_TEMPORARIES_ARB = $88A4;
  GL_MAX_PROGRAM_TEMPORARIES_ARB = $88A5;
  GL_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A6;
  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A7;
  GL_PROGRAM_PARAMETERS_ARB = $88A8;
  GL_MAX_PROGRAM_PARAMETERS_ARB = $88A9;
  GL_PROGRAM_NATIVE_PARAMETERS_ARB = $88AA;
  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = $88AB;
  GL_PROGRAM_ATTRIBS_ARB = $88AC;
  GL_MAX_PROGRAM_ATTRIBS_ARB = $88AD;
  GL_PROGRAM_NATIVE_ATTRIBS_ARB = $88AE;
  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = $88AF;
  GL_PROGRAM_ADDRESS_REGISTERS_ARB = $88B0;
  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = $88B1;
  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B2;
  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B3;
  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = $88B4;
  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = $88B5;
  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = $88B6;
  GL_PROGRAM_STRING_ARB = $8628;
  GL_PROGRAM_ERROR_POSITION_ARB = $864B;
  GL_CURRENT_MATRIX_ARB = $8641;
  GL_TRANSPOSE_CURRENT_MATRIX_ARB = $88B7;
  GL_CURRENT_MATRIX_STACK_DEPTH_ARB = $8640;
  GL_MAX_VERTEX_ATTRIBS_ARB = $8869;
  GL_MAX_PROGRAM_MATRICES_ARB = $862F;
  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = $862E;
  GL_PROGRAM_ERROR_STRING_ARB = $8874;
  GL_MATRIX0_ARB = $88C0;
  GL_MATRIX1_ARB = $88C1;
  GL_MATRIX2_ARB = $88C2;
  GL_MATRIX3_ARB = $88C3;
  GL_MATRIX4_ARB = $88C4;
  GL_MATRIX5_ARB = $88C5;
  GL_MATRIX6_ARB = $88C6;
  GL_MATRIX7_ARB = $88C7;
  GL_MATRIX8_ARB = $88C8;
  GL_MATRIX9_ARB = $88C9;
  GL_MATRIX10_ARB = $88CA;
  GL_MATRIX11_ARB = $88CB;
  GL_MATRIX12_ARB = $88CC;
  GL_MATRIX13_ARB = $88CD;
  GL_MATRIX14_ARB = $88CE;
  GL_MATRIX15_ARB = $88CF;
  GL_MATRIX16_ARB = $88D0;
  GL_MATRIX17_ARB = $88D1;
  GL_MATRIX18_ARB = $88D2;
  GL_MATRIX19_ARB = $88D3;
  GL_MATRIX20_ARB = $88D4;
  GL_MATRIX21_ARB = $88D5;
  GL_MATRIX22_ARB = $88D6;
  GL_MATRIX23_ARB = $88D7;
  GL_MATRIX24_ARB = $88D8;
  GL_MATRIX25_ARB = $88D9;
  GL_MATRIX26_ARB = $88DA;
  GL_MATRIX27_ARB = $88DB;
  GL_MATRIX28_ARB = $88DC;
  GL_MATRIX29_ARB = $88DD;
  GL_MATRIX30_ARB = $88DE;
  GL_MATRIX31_ARB = $88DF;
var
  glVertexAttrib1sARB: procedure(index: GLuint; x: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1fARB: procedure(index: GLuint; x: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1dARB: procedure(index: GLuint; x: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2sARB: procedure(index: GLuint; x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NubARB: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1svARB: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1fvARB: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1dvARB: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2svARB: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2fvARB: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2dvARB: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3svARB: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3fvARB: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3dvARB: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4bvARB: procedure(index: GLuint; const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4svARB: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4ivARB: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4ubvARB: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4usvARB: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4uivARB: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4fvARB: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4dvARB: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NbvARB: procedure(index: GLuint; const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NsvARB: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NivARB: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NubvARB: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NusvARB: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4NuivARB: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribPointerARB: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEnableVertexAttribArrayARB: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDisableVertexAttribArrayARB: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramStringARB: procedure(target: GLenum; format: GLenum; len: GLsizei; const _string: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindProgramARB: procedure(target: GLenum; _program: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteProgramsARB: procedure(n: GLsizei; const programs: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenProgramsARB: procedure(n: GLsizei; programs: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramEnvParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramEnvParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramEnvParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramEnvParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramLocalParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramLocalParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramLocalParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramLocalParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramEnvParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramEnvParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramLocalParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramLocalParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramivARB: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramStringARB: procedure(target: GLenum; pname: GLenum; _string: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribdvARB: procedure(index: GLuint; pname: GLenum; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribfvARB: procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribivARB: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribPointervARB: procedure(index: GLuint; pname: GLenum; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsProgramARB: function(_program: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_vertex_program: Boolean;

//***** GL_ARB_window_pos *****//
var
  glWindowPos2dARB: procedure(x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2fARB: procedure(x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2iARB: procedure(x: GLint; y: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2sARB: procedure(x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2dvARB: procedure(const p: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2fvARB: procedure(const p: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2ivARB: procedure(const p: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2svARB: procedure(const p: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3dARB: procedure(x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3fARB: procedure(x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3iARB: procedure(x: GLint; y: GLint; z: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3sARB: procedure(x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3dvARB: procedure(const p: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3fvARB: procedure(const p: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3ivARB: procedure(const p: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3svARB: procedure(const p: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_window_pos: Boolean;

//***** GL_EXT_422_pixels *****//
const
  GL_422_EXT = $80CC;
  GL_422_REV_EXT = $80CD;
  GL_422_AVERAGE_EXT = $80CE;
  GL_422_REV_AVERAGE_EXT = $80CF;

function Load_GL_EXT_422_pixels: Boolean;

//***** GL_EXT_abgr *****//
const
  GL_ABGR_EXT = $8000;

function Load_GL_EXT_abgr: Boolean;

//***** GL_EXT_bgra *****//
const
  GL_BGR_EXT = $80E0;
  GL_BGRA_EXT = $80E1;

function Load_GL_EXT_bgra: Boolean;

//***** GL_EXT_blend_color *****//
const
  GL_CONSTANT_COLOR_EXT = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR_EXT = $8002;
  GL_CONSTANT_ALPHA_EXT = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA_EXT = $8004;
  GL_BLEND_COLOR_EXT = $8005;
var
  glBlendColorEXT: procedure(red: GLclampf; green: GLclampf; blue: GLclampf; alpha: GLclampf); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_blend_color: Boolean;

//***** GL_EXT_blend_func_separate *****//
const
  GL_BLEND_DST_RGB_EXT = $80C8;
  GL_BLEND_SRC_RGB_EXT = $80C9;
  GL_BLEND_DST_ALPHA_EXT = $80CA;
  GL_BLEND_SRC_ALPHA_EXT = $80CB;
var
  glBlendFuncSeparateEXT: procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_blend_func_separate: Boolean;

//***** GL_EXT_blend_logic_op *****//

function Load_GL_EXT_blend_logic_op: Boolean;

//***** GL_EXT_blend_minmax *****//
const
  GL_FUNC_ADD_EXT = $8006;
  GL_MIN_EXT = $8007;
  GL_MAX_EXT = $8008;
  GL_BLEND_EQUATION_EXT = $8009;
var
  glBlendEquationEXT: procedure(mode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_blend_minmax: Boolean;

//***** GL_EXT_blend_subtract *****//
const
  GL_FUNC_SUBTRACT_EXT = $800A;
  GL_FUNC_REVERSE_SUBTRACT_EXT = $800B;

function Load_GL_EXT_blend_subtract: Boolean;

//***** GL_EXT_clip_volume_hint *****//
const
  GL_CLIP_VOLUME_CLIPPING_HINT_EXT = $80F0;

function Load_GL_EXT_clip_volume_hint: Boolean;

//***** GL_EXT_color_subtable *****//
var
  glColorSubTableEXT: procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyColorSubTableEXT: procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_color_subtable: Boolean;

//***** GL_EXT_compiled_vertex_array *****//
const
  GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = $81A8;
  GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = $81A9;
var
  glLockArraysEXT: procedure(first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUnlockArraysEXT: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_compiled_vertex_array: Boolean;

//***** GL_EXT_convolution *****//
const
  GL_CONVOLUTION_1D_EXT = $8010;
  GL_CONVOLUTION_2D_EXT = $8011;
  GL_SEPARABLE_2D_EXT = $8012;
  GL_CONVOLUTION_BORDER_MODE_EXT = $8013;
  GL_CONVOLUTION_FILTER_SCALE_EXT = $8014;
  GL_CONVOLUTION_FILTER_BIAS_EXT = $8015;
  GL_REDUCE_EXT = $8016;
  GL_CONVOLUTION_FORMAT_EXT = $8017;
  GL_CONVOLUTION_WIDTH_EXT = $8018;
  GL_CONVOLUTION_HEIGHT_EXT = $8019;
  GL_MAX_CONVOLUTION_WIDTH_EXT = $801A;
  GL_MAX_CONVOLUTION_HEIGHT_EXT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE_EXT = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE_EXT = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE_EXT = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = $801F;
  GL_POST_CONVOLUTION_RED_BIAS_EXT = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS_EXT = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS_EXT = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = $8023;
var
  glConvolutionFilter1DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyConvolutionFilter1DEXT: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyConvolutionFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionFilterEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; image: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSeparableFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const row: PGLvoid; const column: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSeparableFilterEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameteriEXT: procedure(target: GLenum; pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameterivEXT: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameterfEXT: procedure(target: GLenum; pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glConvolutionParameterfvEXT: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetConvolutionParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_convolution: Boolean;

//***** GL_EXT_fog_coord *****//
const
  GL_FOG_COORDINATE_SOURCE_EXT = $8450;
  GL_FOG_COORDINATE_EXT = $8451;
  GL_FRAGMENT_DEPTH_EXT = $8452;
  GL_CURRENT_FOG_COORDINATE_EXT = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE_EXT = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER_EXT = $8456;
  GL_FOG_COORDINATE_ARRAY_EXT = $8457;
var
  glFogCoordfEXT: procedure(coord: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoorddEXT: procedure(coord: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordfvEXT: procedure(coord: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoorddvEXT: procedure(coord: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordPointerEXT: procedure(_type: GLenum; stride: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_fog_coord: Boolean;

//***** GL_EXT_histogram *****//
const
  GL_HISTOGRAM_EXT = $8024;
  GL_PROXY_HISTOGRAM_EXT = $8025;
  GL_HISTOGRAM_WIDTH_EXT = $8026;
  GL_HISTOGRAM_FORMAT_EXT = $8027;
  GL_HISTOGRAM_RED_SIZE_EXT = $8028;
  GL_HISTOGRAM_GREEN_SIZE_EXT = $8029;
  GL_HISTOGRAM_BLUE_SIZE_EXT = $802A;
  GL_HISTOGRAM_ALPHA_SIZE_EXT = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE_EXT = $802C;
  GL_HISTOGRAM_SINK_EXT = $802D;
  GL_MINMAX_EXT = $802E;
  GL_MINMAX_FORMAT_EXT = $802F;
  GL_MINMAX_SINK_EXT = $8030;
var
  glHistogramEXT: procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glResetHistogramEXT: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogramEXT: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogramParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHistogramParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMinmaxEXT: procedure(target: GLenum; internalformat: GLenum; sink: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glResetMinmaxEXT: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmaxEXT: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmaxParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMinmaxParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_histogram: Boolean;

//***** GL_EXT_multi_draw_arrays *****//
var
  glMultiDrawArraysEXT: procedure(mode: GLenum; first: PGLint; count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawElementsEXT: procedure(mode: GLenum; count: PGLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_multi_draw_arrays: Boolean;

//***** GL_EXT_packed_depth_stencil *****//
const
  GL_DEPTH_STENCIL_EXT = $84F9;
  GL_UNSIGNED_INT_24_8_EXT = $84FA;
  GL_DEPTH24_STENCIL8_EXT = $88F0;
  GL_TEXTURE_STENCIL_SIZE_EXT = $88F1;

function Load_GL_EXT_packed_depth_stencil: Boolean;

//***** GL_EXT_packed_pixels *****//
const
  GL_UNSIGNED_BYTE_3_3_2_EXT = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4_EXT = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1_EXT = $8034;
  GL_UNSIGNED_INT_8_8_8_8_EXT = $8035;
  GL_UNSIGNED_INT_10_10_10_2_EXT = $8036;

function Load_GL_EXT_packed_pixels: Boolean;

//***** GL_EXT_paletted_texture *****//
const
  GL_COLOR_INDEX1_EXT = $80E2;
  GL_COLOR_INDEX2_EXT = $80E3;
  GL_COLOR_INDEX4_EXT = $80E4;
  GL_COLOR_INDEX8_EXT = $80E5;
  GL_COLOR_INDEX12_EXT = $80E6;
  GL_COLOR_INDEX16_EXT = $80E7;
  GL_COLOR_TABLE_FORMAT_EXT = $80D8;
  GL_COLOR_TABLE_WIDTH_EXT = $80D9;
  GL_COLOR_TABLE_RED_SIZE_EXT = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_EXT = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_EXT = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_EXT = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_EXT = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_EXT = $80DF;
  GL_TEXTURE_INDEX_SIZE_EXT = $80ED;
  GL_TEXTURE_1D = $0DE0;
  GL_TEXTURE_2D = $0DE1;
  GL_TEXTURE_3D_EXT = $806F;
  // GL_TEXTURE_CUBE_MAP_ARB  { already defined }
  GL_PROXY_TEXTURE_1D = $8063;
  GL_PROXY_TEXTURE_2D = $8064;
  GL_PROXY_TEXTURE_3D_EXT = $8070;
  // GL_PROXY_TEXTURE_CUBE_MAP_ARB  { already defined }
  // GL_TEXTURE_1D  { already defined }
  // GL_TEXTURE_2D  { already defined }
  // GL_TEXTURE_3D_EXT  { already defined }
  // GL_TEXTURE_CUBE_MAP_ARB  { already defined }
var
  glColorTableEXT: procedure(target: GLenum; internalFormat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  // glColorSubTableEXT  { already defined }
  glGetColorTableEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_paletted_texture: Boolean;

//***** GL_EXT_point_parameters *****//
const
  GL_POINT_SIZE_MIN_EXT = $8126;
  GL_POINT_SIZE_MAX_EXT = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_EXT = $8128;
  GL_DISTANCE_ATTENUATION_EXT = $8129;
var
  glPointParameterfEXT: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameterfvEXT: procedure(pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_point_parameters: Boolean;

//***** GL_EXT_polygon_offset *****//
const
  GL_POLYGON_OFFSET_EXT = $8037;
  GL_POLYGON_OFFSET_FACTOR_EXT = $8038;
  GL_POLYGON_OFFSET_BIAS_EXT = $8039;
var
  glPolygonOffsetEXT: procedure(factor: GLfloat; bias: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_polygon_offset: Boolean;

//***** GL_EXT_secondary_color *****//
const
  GL_COLOR_SUM_EXT = $8458;
  GL_CURRENT_SECONDARY_COLOR_EXT = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = $845D;
  GL_SECONDARY_COLOR_ARRAY_EXT = $845E;
var
  glSecondaryColor3bEXT: procedure(components: GLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3sEXT: procedure(components: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3iEXT: procedure(components: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3fEXT: procedure(components: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3dEXT: procedure(components: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ubEXT: procedure(components: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3usEXT: procedure(components: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3uiEXT: procedure(components: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3bvEXT: procedure(components: GLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3svEXT: procedure(components: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ivEXT: procedure(components: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3fvEXT: procedure(components: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3dvEXT: procedure(components: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ubvEXT: procedure(components: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3usvEXT: procedure(components: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3uivEXT: procedure(components: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColorPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_secondary_color: Boolean;

//***** GL_EXT_separate_specular_color *****//
const
  GL_LIGHT_MODEL_COLOR_CONTROL_EXT = $81F8;
  GL_SINGLE_COLOR_EXT = $81F9;
  GL_SEPARATE_SPECULAR_COLOR_EXT = $81FA;

function Load_GL_EXT_separate_specular_color: Boolean;

//***** GL_EXT_shadow_funcs *****//

function Load_GL_EXT_shadow_funcs: Boolean;

//***** GL_EXT_shared_texture_palette *****//
const
  GL_SHARED_TEXTURE_PALETTE_EXT = $81FB;

function Load_GL_EXT_shared_texture_palette: Boolean;

//***** GL_EXT_stencil_two_side *****//
const
  GL_STENCIL_TEST_TWO_SIDE_EXT = $8910;
  GL_ACTIVE_STENCIL_FACE_EXT = $8911;
var
  glActiveStencilFaceEXT: procedure(face: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_stencil_two_side: Boolean;

//***** GL_EXT_stencil_wrap *****//
const
  GL_INCR_WRAP_EXT = $8507;
  GL_DECR_WRAP_EXT = $8508;

function Load_GL_EXT_stencil_wrap: Boolean;

//***** GL_EXT_subtexture *****//
var
  glTexSubImage1DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexSubImage2DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexSubImage3DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_subtexture: Boolean;

//***** GL_EXT_texture3D *****//
const
  GL_PACK_SKIP_IMAGES_EXT = $806B;
  GL_PACK_IMAGE_HEIGHT_EXT = $806C;
  GL_UNPACK_SKIP_IMAGES_EXT = $806D;
  GL_UNPACK_IMAGE_HEIGHT_EXT = $806E;
  // GL_TEXTURE_3D_EXT  { already defined }
  // GL_PROXY_TEXTURE_3D_EXT  { already defined }
  GL_TEXTURE_DEPTH_EXT = $8071;
  GL_TEXTURE_WRAP_R_EXT = $8072;
  GL_MAX_3D_TEXTURE_SIZE_EXT = $8073;
var
  glTexImage3DEXT: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; _type: GLenum; const pixels: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_texture3D: Boolean;

//***** GL_EXT_texture_compression_s3tc *****//
const
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT = $83F0;
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;

function Load_GL_EXT_texture_compression_s3tc: Boolean;

//***** GL_EXT_texture_env_add *****//

function Load_GL_EXT_texture_env_add: Boolean;

//***** GL_EXT_texture_env_combine *****//
const
  GL_COMBINE_EXT = $8570;
  GL_COMBINE_RGB_EXT = $8571;
  GL_COMBINE_ALPHA_EXT = $8572;
  GL_SOURCE0_RGB_EXT = $8580;
  GL_SOURCE1_RGB_EXT = $8581;
  GL_SOURCE2_RGB_EXT = $8582;
  GL_SOURCE0_ALPHA_EXT = $8588;
  GL_SOURCE1_ALPHA_EXT = $8589;
  GL_SOURCE2_ALPHA_EXT = $858A;
  GL_OPERAND0_RGB_EXT = $8590;
  GL_OPERAND1_RGB_EXT = $8591;
  GL_OPERAND2_RGB_EXT = $8592;
  GL_OPERAND0_ALPHA_EXT = $8598;
  GL_OPERAND1_ALPHA_EXT = $8599;
  GL_OPERAND2_ALPHA_EXT = $859A;
  GL_RGB_SCALE_EXT = $8573;
  GL_ADD_SIGNED_EXT = $8574;
  GL_INTERPOLATE_EXT = $8575;
  GL_CONSTANT_EXT = $8576;
  GL_PRIMARY_COLOR_EXT = $8577;
  GL_PREVIOUS_EXT = $8578;

function Load_GL_EXT_texture_env_combine: Boolean;

//***** GL_EXT_texture_env_dot3 *****//
const
  GL_DOT3_RGB_EXT = $8740;
  GL_DOT3_RGBA_EXT = $8741;

function Load_GL_EXT_texture_env_dot3: Boolean;

//***** GL_EXT_texture_filter_anisotropic *****//
const
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;

function Load_GL_EXT_texture_filter_anisotropic: Boolean;

//***** GL_EXT_texture_lod_bias *****//
const
  GL_TEXTURE_FILTER_CONTROL_EXT = $8500;
  GL_TEXTURE_LOD_BIAS_EXT = $8501;
  GL_MAX_TEXTURE_LOD_BIAS_EXT = $84FD;

function Load_GL_EXT_texture_lod_bias: Boolean;

//***** GL_EXT_texture_object *****//
const
  GL_TEXTURE_PRIORITY_EXT = $8066;
  GL_TEXTURE_RESIDENT_EXT = $8067;
  GL_TEXTURE_1D_BINDING_EXT = $8068;
  GL_TEXTURE_2D_BINDING_EXT = $8069;
  GL_TEXTURE_3D_BINDING_EXT = $806A;
var
  glGenTexturesEXT: procedure(n: GLsizei; textures: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteTexturesEXT: procedure(n: GLsizei; const textures: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindTextureEXT: procedure(target: GLenum; texture: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPrioritizeTexturesEXT: procedure(n: GLsizei; const textures: PGLuint; const priorities: PGLclampf); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAreTexturesResidentEXT: function(n: GLsizei; const textures: PGLuint; residences: PGLboolean): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsTextureEXT: function(texture: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_texture_object: Boolean;

//***** GL_EXT_vertex_array *****//
const
  GL_VERTEX_ARRAY_EXT = $8074;
  GL_NORMAL_ARRAY_EXT = $8075;
  GL_COLOR_ARRAY_EXT = $8076;
  GL_INDEX_ARRAY_EXT = $8077;
  GL_TEXTURE_COORD_ARRAY_EXT = $8078;
  GL_EDGE_FLAG_ARRAY_EXT = $8079;
  GL_DOUBLE_EXT = $140A;
  GL_VERTEX_ARRAY_SIZE_EXT = $807A;
  GL_VERTEX_ARRAY_TYPE_EXT = $807B;
  GL_VERTEX_ARRAY_STRIDE_EXT = $807C;
  GL_VERTEX_ARRAY_COUNT_EXT = $807D;
  GL_NORMAL_ARRAY_TYPE_EXT = $807E;
  GL_NORMAL_ARRAY_STRIDE_EXT = $807F;
  GL_NORMAL_ARRAY_COUNT_EXT = $8080;
  GL_COLOR_ARRAY_SIZE_EXT = $8081;
  GL_COLOR_ARRAY_TYPE_EXT = $8082;
  GL_COLOR_ARRAY_STRIDE_EXT = $8083;
  GL_COLOR_ARRAY_COUNT_EXT = $8084;
  GL_INDEX_ARRAY_TYPE_EXT = $8085;
  GL_INDEX_ARRAY_STRIDE_EXT = $8086;
  GL_INDEX_ARRAY_COUNT_EXT = $8087;
  GL_TEXTURE_COORD_ARRAY_SIZE_EXT = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE_EXT = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = $808A;
  GL_TEXTURE_COORD_ARRAY_COUNT_EXT = $808B;
  GL_EDGE_FLAG_ARRAY_STRIDE_EXT = $808C;
  GL_EDGE_FLAG_ARRAY_COUNT_EXT = $808D;
  GL_VERTEX_ARRAY_POINTER_EXT = $808E;
  GL_NORMAL_ARRAY_POINTER_EXT = $808F;
  GL_COLOR_ARRAY_POINTER_EXT = $8090;
  GL_INDEX_ARRAY_POINTER_EXT = $8091;
  GL_TEXTURE_COORD_ARRAY_POINTER_EXT = $8092;
  GL_EDGE_FLAG_ARRAY_POINTER_EXT = $8093;
var
  glArrayElementEXT: procedure(i: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawArraysEXT: procedure(mode: GLenum; first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalPointerEXT: procedure(_type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIndexPointerEXT: procedure(_type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEdgeFlagPointerEXT: procedure(stride: GLsizei; count: GLsizei; const pointer: PGLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetPointervEXT: procedure(pname: GLenum; params: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_vertex_array: Boolean;

//***** GL_EXT_vertex_shader *****//
const
  GL_VERTEX_SHADER_EXT = $8780;
  GL_VARIANT_VALUE_EXT = $87E4;
  GL_VARIANT_DATATYPE_EXT = $87E5;
  GL_VARIANT_ARRAY_STRIDE_EXT = $87E6;
  GL_VARIANT_ARRAY_TYPE_EXT = $87E7;
  GL_VARIANT_ARRAY_EXT = $87E8;
  GL_VARIANT_ARRAY_POINTER_EXT = $87E9;
  GL_INVARIANT_VALUE_EXT = $87EA;
  GL_INVARIANT_DATATYPE_EXT = $87EB;
  GL_LOCAL_CONSTANT_VALUE_EXT = $87EC;
  GL_LOCAL_CONSTANT_DATATYPE_EXT = $87ED;
  GL_OP_INDEX_EXT = $8782;
  GL_OP_NEGATE_EXT = $8783;
  GL_OP_DOT3_EXT = $8784;
  GL_OP_DOT4_EXT = $8785;
  GL_OP_MUL_EXT = $8786;
  GL_OP_ADD_EXT = $8787;
  GL_OP_MADD_EXT = $8788;
  GL_OP_FRAC_EXT = $8789;
  GL_OP_MAX_EXT = $878A;
  GL_OP_MIN_EXT = $878B;
  GL_OP_SET_GE_EXT = $878C;
  GL_OP_SET_LT_EXT = $878D;
  GL_OP_CLAMP_EXT = $878E;
  GL_OP_FLOOR_EXT = $878F;
  GL_OP_ROUND_EXT = $8790;
  GL_OP_EXP_BASE_2_EXT = $8791;
  GL_OP_LOG_BASE_2_EXT = $8792;
  GL_OP_POWER_EXT = $8793;
  GL_OP_RECIP_EXT = $8794;
  GL_OP_RECIP_SQRT_EXT = $8795;
  GL_OP_SUB_EXT = $8796;
  GL_OP_CROSS_PRODUCT_EXT = $8797;
  GL_OP_MULTIPLY_MATRIX_EXT = $8798;
  GL_OP_MOV_EXT = $8799;
  GL_OUTPUT_VERTEX_EXT = $879A;
  GL_OUTPUT_COLOR0_EXT = $879B;
  GL_OUTPUT_COLOR1_EXT = $879C;
  GL_OUTPUT_TEXTURE_COORD0_EXT = $879D;
  GL_OUTPUT_TEXTURE_COORD1_EXT = $879E;
  GL_OUTPUT_TEXTURE_COORD2_EXT = $879F;
  GL_OUTPUT_TEXTURE_COORD3_EXT = $87A0;
  GL_OUTPUT_TEXTURE_COORD4_EXT = $87A1;
  GL_OUTPUT_TEXTURE_COORD5_EXT = $87A2;
  GL_OUTPUT_TEXTURE_COORD6_EXT = $87A3;
  GL_OUTPUT_TEXTURE_COORD7_EXT = $87A4;
  GL_OUTPUT_TEXTURE_COORD8_EXT = $87A5;
  GL_OUTPUT_TEXTURE_COORD9_EXT = $87A6;
  GL_OUTPUT_TEXTURE_COORD10_EXT = $87A7;
  GL_OUTPUT_TEXTURE_COORD11_EXT = $87A8;
  GL_OUTPUT_TEXTURE_COORD12_EXT = $87A9;
  GL_OUTPUT_TEXTURE_COORD13_EXT = $87AA;
  GL_OUTPUT_TEXTURE_COORD14_EXT = $87AB;
  GL_OUTPUT_TEXTURE_COORD15_EXT = $87AC;
  GL_OUTPUT_TEXTURE_COORD16_EXT = $87AD;
  GL_OUTPUT_TEXTURE_COORD17_EXT = $87AE;
  GL_OUTPUT_TEXTURE_COORD18_EXT = $87AF;
  GL_OUTPUT_TEXTURE_COORD19_EXT = $87B0;
  GL_OUTPUT_TEXTURE_COORD20_EXT = $87B1;
  GL_OUTPUT_TEXTURE_COORD21_EXT = $87B2;
  GL_OUTPUT_TEXTURE_COORD22_EXT = $87B3;
  GL_OUTPUT_TEXTURE_COORD23_EXT = $87B4;
  GL_OUTPUT_TEXTURE_COORD24_EXT = $87B5;
  GL_OUTPUT_TEXTURE_COORD25_EXT = $87B6;
  GL_OUTPUT_TEXTURE_COORD26_EXT = $87B7;
  GL_OUTPUT_TEXTURE_COORD27_EXT = $87B8;
  GL_OUTPUT_TEXTURE_COORD28_EXT = $87B9;
  GL_OUTPUT_TEXTURE_COORD29_EXT = $87BA;
  GL_OUTPUT_TEXTURE_COORD30_EXT = $87BB;
  GL_OUTPUT_TEXTURE_COORD31_EXT = $87BC;
  GL_OUTPUT_FOG_EXT = $87BD;
  GL_SCALAR_EXT = $87BE;
  GL_VECTOR_EXT = $87BF;
  GL_MATRIX_EXT = $87C0;
  GL_VARIANT_EXT = $87C1;
  GL_INVARIANT_EXT = $87C2;
  GL_LOCAL_CONSTANT_EXT = $87C3;
  GL_LOCAL_EXT = $87C4;
  GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = $87C5;
  GL_MAX_VERTEX_SHADER_VARIANTS_EXT = $87C6;
  GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = $87C7;
  GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87C8;
  GL_MAX_VERTEX_SHADER_LOCALS_EXT = $87C9;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CA;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = $87CB;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87CC;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = $87CD;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = $87CE;
  GL_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CF;
  GL_VERTEX_SHADER_VARIANTS_EXT = $87D0;
  GL_VERTEX_SHADER_INVARIANTS_EXT = $87D1;
  GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87D2;
  GL_VERTEX_SHADER_LOCALS_EXT = $87D3;
  GL_VERTEX_SHADER_BINDING_EXT = $8781;
  GL_VERTEX_SHADER_OPTIMIZED_EXT = $87D4;
  GL_X_EXT = $87D5;
  GL_Y_EXT = $87D6;
  GL_Z_EXT = $87D7;
  GL_W_EXT = $87D8;
  GL_NEGATIVE_X_EXT = $87D9;
  GL_NEGATIVE_Y_EXT = $87DA;
  GL_NEGATIVE_Z_EXT = $87DB;
  GL_NEGATIVE_W_EXT = $87DC;
  GL_ZERO_EXT = $87DD;
  GL_ONE_EXT = $87DE;
  GL_NEGATIVE_ONE_EXT = $87DF;
  GL_NORMALIZED_RANGE_EXT = $87E0;
  GL_FULL_RANGE_EXT = $87E1;
  GL_CURRENT_VERTEX_EXT = $87E2;
  GL_MVP_MATRIX_EXT = $87E3;
var
  glBeginVertexShaderEXT: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndVertexShaderEXT: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindVertexShaderEXT: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenVertexShadersEXT: function(range: GLuint): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteVertexShaderEXT: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glShaderOp1EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glShaderOp2EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glShaderOp3EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint; arg3: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSwizzleEXT: procedure(res: GLuint; _in: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWriteMaskEXT: procedure(res: GLuint; _in: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glInsertComponentEXT: procedure(res: GLuint; src: GLuint; num: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glExtractComponentEXT: procedure(res: GLuint; src: GLuint; num: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenSymbolsEXT: function(datatype: GLenum; storagetype: GLenum; range: GLenum; components: GLuint): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSetInvariantEXT: procedure(id: GLuint; _type: GLenum; addr: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSetLocalConstantEXT: procedure(id: GLuint; _type: GLenum; addr: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantbvEXT: procedure(id: GLuint; addr: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantsvEXT: procedure(id: GLuint; addr: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantivEXT: procedure(id: GLuint; addr: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantfvEXT: procedure(id: GLuint; addr: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantdvEXT: procedure(id: GLuint; addr: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantubvEXT: procedure(id: GLuint; addr: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantusvEXT: procedure(id: GLuint; addr: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantuivEXT: procedure(id: GLuint; addr: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantPointerEXT: procedure(id: GLuint; _type: GLenum; stride: GLuint; addr: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEnableVariantClientStateEXT: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDisableVariantClientStateEXT: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindLightParameterEXT: function(light: GLenum; value: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindMaterialParameterEXT: function(face: GLenum; value: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindTexGenParameterEXT: function(_unit: GLenum; coord: GLenum; value: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindTextureUnitParameterEXT: function(_unit: GLenum; value: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindParameterEXT: function(value: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsVariantEnabledEXT: function(id: GLuint; cap: GLenum): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantPointervEXT: procedure(id: GLuint; value: GLenum; data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetInvariantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetInvariantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetInvariantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetLocalConstantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetLocalConstantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetLocalConstantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_vertex_shader: Boolean;

//***** GL_EXT_vertex_weighting *****//
const
  GL_VERTEX_WEIGHTING_EXT = $8509;
  GL_MODELVIEW0_EXT = $1700;
  GL_MODELVIEW1_EXT = $850A;
  GL_MODELVIEW0_MATRIX_EXT = $0BA6;
  GL_MODELVIEW1_MATRIX_EXT = $8506;
  GL_CURRENT_VERTEX_WEIGHT_EXT = $850B;
  GL_VERTEX_WEIGHT_ARRAY_EXT = $850C;
  GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = $850D;
  GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = $850E;
  GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = $850F;
  GL_MODELVIEW0_STACK_DEPTH_EXT = $0BA3;
  GL_MODELVIEW1_STACK_DEPTH_EXT = $8502;
  GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = $8510;
var
  glVertexWeightfEXT: procedure(weight: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexWeightfvEXT: procedure(weight: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexWeightPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_vertex_weighting: Boolean;

//***** GL_HP_occlusion_test *****//
const
  GL_OCCLUSION_TEST_HP = $8165;
  GL_OCCLUSION_TEST_RESULT_HP = $8166;

function Load_GL_HP_occlusion_test: Boolean;

//***** GL_NV_blend_square *****//

function Load_GL_NV_blend_square: Boolean;

//***** GL_NV_copy_depth_to_color *****//
const
  GL_DEPTH_STENCIL_TO_RGBA_NV = $886E;
  GL_DEPTH_STENCIL_TO_BGRA_NV = $886F;

function Load_GL_NV_copy_depth_to_color: Boolean;

//***** GL_NV_depth_clamp *****//
const
  GL_DEPTH_CLAMP_NV = $864F;

function Load_GL_NV_depth_clamp: Boolean;

//***** GL_NV_evaluators *****//
const
  GL_EVAL_2D_NV = $86C0;
  GL_EVAL_TRIANGULAR_2D_NV = $86C1;
  GL_MAP_TESSELLATION_NV = $86C2;
  GL_MAP_ATTRIB_U_ORDER_NV = $86C3;
  GL_MAP_ATTRIB_V_ORDER_NV = $86C4;
  GL_EVAL_FRACTIONAL_TESSELLATION_NV = $86C5;
  GL_EVAL_VERTEX_ATTRIB0_NV = $86C6;
  GL_EVAL_VERTEX_ATTRIB1_NV = $86C7;
  GL_EVAL_VERTEX_ATTRIB2_NV = $86C8;
  GL_EVAL_VERTEX_ATTRIB3_NV = $86C9;
  GL_EVAL_VERTEX_ATTRIB4_NV = $86CA;
  GL_EVAL_VERTEX_ATTRIB5_NV = $86CB;
  GL_EVAL_VERTEX_ATTRIB6_NV = $86CC;
  GL_EVAL_VERTEX_ATTRIB7_NV = $86CD;
  GL_EVAL_VERTEX_ATTRIB8_NV = $86CE;
  GL_EVAL_VERTEX_ATTRIB9_NV = $86CF;
  GL_EVAL_VERTEX_ATTRIB10_NV = $86D0;
  GL_EVAL_VERTEX_ATTRIB11_NV = $86D1;
  GL_EVAL_VERTEX_ATTRIB12_NV = $86D2;
  GL_EVAL_VERTEX_ATTRIB13_NV = $86D3;
  GL_EVAL_VERTEX_ATTRIB14_NV = $86D4;
  GL_EVAL_VERTEX_ATTRIB15_NV = $86D5;
  GL_MAX_MAP_TESSELLATION_NV = $86D6;
  GL_MAX_RATIONAL_EVAL_ORDER_NV = $86D7;
var
  glMapControlPointsNV: procedure(target: GLenum; index: GLuint; _type: GLenum; ustride: GLsizei; vstride: GLsizei; uorder: GLint; vorder: GLint; _packed: GLboolean; const points: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMapParameterivNV: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMapParameterfvNV: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMapControlPointsNV: procedure(target: GLenum; index: GLuint; _type: GLenum; ustride: GLsizei; vstride: GLsizei; _packed: GLboolean; points: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMapParameterivNV: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMapParameterfvNV: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMapAttribParameterivNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMapAttribParameterfvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEvalMapsNV: procedure(target: GLenum; mode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_evaluators: Boolean;

//***** GL_NV_fence *****//
const
  GL_ALL_COMPLETED_NV = $84F2;
  GL_FENCE_STATUS_NV = $84F3;
  GL_FENCE_CONDITION_NV = $84F4;
var
  glGenFencesNV: procedure(n: GLsizei; fences: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteFencesNV: procedure(n: GLsizei; const fences: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSetFenceNV: procedure(fence: GLuint; condition: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTestFenceNV: function(fence: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFinishFenceNV: procedure(fence: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsFenceNV: function(fence: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFenceivNV: procedure(fence: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_fence: Boolean;

//***** GL_NV_fog_distance *****//
const
  GL_FOG_DISTANCE_MODE_NV = $855A;
  GL_EYE_RADIAL_NV = $855B;
  GL_EYE_PLANE_ABSOLUTE_NV = $855C;

function Load_GL_NV_fog_distance: Boolean;

//***** GL_NV_light_max_exponent *****//
const
  GL_MAX_SHININESS_NV = $8504;
  GL_MAX_SPOT_EXPONENT_NV = $8505;

function Load_GL_NV_light_max_exponent: Boolean;

//***** GL_NV_multisample_filter_hint *****//
const
  GL_MULTISAMPLE_FILTER_HINT_NV = $8534;

function Load_GL_NV_multisample_filter_hint: Boolean;

//***** GL_NV_occlusion_query *****//
  // GL_OCCLUSION_TEST_HP  { already defined }
  // GL_OCCLUSION_TEST_RESULT_HP  { already defined }
const
  GL_PIXEL_COUNTER_BITS_NV = $8864;
  GL_CURRENT_OCCLUSION_QUERY_ID_NV = $8865;
  GL_PIXEL_COUNT_NV = $8866;
  GL_PIXEL_COUNT_AVAILABLE_NV = $8867;
var
  glGenOcclusionQueriesNV: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteOcclusionQueriesNV: procedure(n: GLsizei; const ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsOcclusionQueryNV: function(id: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginOcclusionQueryNV: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndOcclusionQueryNV: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetOcclusionQueryivNV: procedure(id: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetOcclusionQueryuivNV: procedure(id: GLuint; pname: GLenum; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_occlusion_query: Boolean;

//***** GL_NV_packed_depth_stencil *****//
const
  GL_DEPTH_STENCIL_NV = $84F9;
  GL_UNSIGNED_INT_24_8_NV = $84FA;

function Load_GL_NV_packed_depth_stencil: Boolean;

//***** GL_NV_point_sprite *****//
const
  GL_POINT_SPRITE_NV = $8861;
  GL_COORD_REPLACE_NV = $8862;
  GL_POINT_SPRITE_R_MODE_NV = $8863;
var
  glPointParameteriNV: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameterivNV: procedure(pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_point_sprite: Boolean;

//***** GL_NV_register_combiners *****//
const
  GL_REGISTER_COMBINERS_NV = $8522;
  GL_COMBINER0_NV = $8550;
  GL_COMBINER1_NV = $8551;
  GL_COMBINER2_NV = $8552;
  GL_COMBINER3_NV = $8553;
  GL_COMBINER4_NV = $8554;
  GL_COMBINER5_NV = $8555;
  GL_COMBINER6_NV = $8556;
  GL_COMBINER7_NV = $8557;
  GL_VARIABLE_A_NV = $8523;
  GL_VARIABLE_B_NV = $8524;
  GL_VARIABLE_C_NV = $8525;
  GL_VARIABLE_D_NV = $8526;
  GL_VARIABLE_E_NV = $8527;
  GL_VARIABLE_F_NV = $8528;
  GL_VARIABLE_G_NV = $8529;
  GL_CONSTANT_COLOR0_NV = $852A;
  GL_CONSTANT_COLOR1_NV = $852B;
  GL_PRIMARY_COLOR_NV = $852C;
  GL_SECONDARY_COLOR_NV = $852D;
  GL_SPARE0_NV = $852E;
  GL_SPARE1_NV = $852F;
  GL_UNSIGNED_IDENTITY_NV = $8536;
  GL_UNSIGNED_INVERT_NV = $8537;
  GL_EXPAND_NORMAL_NV = $8538;
  GL_EXPAND_NEGATE_NV = $8539;
  GL_HALF_BIAS_NORMAL_NV = $853A;
  GL_HALF_BIAS_NEGATE_NV = $853B;
  GL_SIGNED_IDENTITY_NV = $853C;
  GL_SIGNED_NEGATE_NV = $853D;
  GL_E_TIMES_F_NV = $8531;
  GL_SPARE0_PLUS_SECONDARY_COLOR_NV = $8532;
  GL_SCALE_BY_TWO_NV = $853E;
  GL_SCALE_BY_FOUR_NV = $853F;
  GL_SCALE_BY_ONE_HALF_NV = $8540;
  GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = $8541;
  GL_DISCARD_NV = $8530;
  GL_COMBINER_INPUT_NV = $8542;
  GL_COMBINER_MAPPING_NV = $8543;
  GL_COMBINER_COMPONENT_USAGE_NV = $8544;
  GL_COMBINER_AB_DOT_PRODUCT_NV = $8545;
  GL_COMBINER_CD_DOT_PRODUCT_NV = $8546;
  GL_COMBINER_MUX_SUM_NV = $8547;
  GL_COMBINER_SCALE_NV = $8548;
  GL_COMBINER_BIAS_NV = $8549;
  GL_COMBINER_AB_OUTPUT_NV = $854A;
  GL_COMBINER_CD_OUTPUT_NV = $854B;
  GL_COMBINER_SUM_OUTPUT_NV = $854C;
  GL_NUM_GENERAL_COMBINERS_NV = $854E;
  GL_COLOR_SUM_CLAMP_NV = $854F;
  GL_MAX_GENERAL_COMBINERS_NV = $854D;
var
  glCombinerParameterfvNV: procedure(pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCombinerParameterivNV: procedure(pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCombinerParameterfNV: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCombinerParameteriNV: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCombinerInputNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCombinerOutputNV: procedure(stage: GLenum; portion: GLenum; abOutput: GLenum; cdOutput: GLenum; sumOutput: GLenum; scale: GLenum; bias: GLenum; abDotProduct: GLboolean; cdDotProduct: GLboolean; muxSum: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFinalCombinerInputNV: procedure(variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCombinerInputParameterfvNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCombinerInputParameterivNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCombinerOutputParameterfvNV: procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCombinerOutputParameterivNV: procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFinalCombinerInputParameterfvNV: procedure(variable: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFinalCombinerInputParameterivNV: procedure(variable: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_register_combiners: Boolean;

//***** GL_NV_register_combiners2 *****//
const
  GL_PER_STAGE_CONSTANTS_NV = $8535;
var
  glCombinerStageParameterfvNV: procedure(stage: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetCombinerStageParameterfvNV: procedure(stage: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_register_combiners2: Boolean;

//***** GL_NV_texgen_emboss *****//
const
  GL_EMBOSS_MAP_NV = $855F;
  GL_EMBOSS_LIGHT_NV = $855D;
  GL_EMBOSS_CONSTANT_NV = $855E;

function Load_GL_NV_texgen_emboss: Boolean;

//***** GL_NV_texgen_reflection *****//
const
  GL_NORMAL_MAP_NV = $8511;
  GL_REFLECTION_MAP_NV = $8512;

function Load_GL_NV_texgen_reflection: Boolean;

//***** GL_NV_texture_compression_vtc *****//
  // GL_COMPRESSED_RGB_S3TC_DXT1_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT1_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT3_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT5_EXT  { already defined }

function Load_GL_NV_texture_compression_vtc: Boolean;

//***** GL_NV_texture_env_combine4 *****//
const
  GL_COMBINE4_NV = $8503;
  GL_SOURCE3_RGB_NV = $8583;
  GL_SOURCE3_ALPHA_NV = $858B;
  GL_OPERAND3_RGB_NV = $8593;
  GL_OPERAND3_ALPHA_NV = $859B;

function Load_GL_NV_texture_env_combine4: Boolean;

//***** GL_NV_texture_rectangle *****//
const
  GL_TEXTURE_RECTANGLE_NV = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_NV = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_NV = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = $84F8;

function Load_GL_NV_texture_rectangle: Boolean;

//***** GL_NV_texture_shader *****//
const
  GL_TEXTURE_SHADER_NV = $86DE;
  GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = $86D9;
  GL_SHADER_OPERATION_NV = $86DF;
  GL_CULL_MODES_NV = $86E0;
  GL_OFFSET_TEXTURE_MATRIX_NV = $86E1;
  GL_OFFSET_TEXTURE_SCALE_NV = $86E2;
  GL_OFFSET_TEXTURE_BIAS_NV = $86E3;
  GL_PREVIOUS_TEXTURE_INPUT_NV = $86E4;
  GL_CONST_EYE_NV = $86E5;
  GL_SHADER_CONSISTENT_NV = $86DD;
  GL_PASS_THROUGH_NV = $86E6;
  GL_CULL_FRAGMENT_NV = $86E7;
  GL_OFFSET_TEXTURE_2D_NV = $86E8;
  GL_OFFSET_TEXTURE_RECTANGLE_NV = $864C;
  GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = $864D;
  GL_DEPENDENT_AR_TEXTURE_2D_NV = $86E9;
  GL_DEPENDENT_GB_TEXTURE_2D_NV = $86EA;
  GL_DOT_PRODUCT_NV = $86EC;
  GL_DOT_PRODUCT_DEPTH_REPLACE_NV = $86ED;
  GL_DOT_PRODUCT_TEXTURE_2D_NV = $86EE;
  GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = $864E;
  GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = $86F0;
  GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = $86F1;
  GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = $86F2;
  GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = $86F3;
  GL_HILO_NV = $86F4;
  GL_DSDT_NV = $86F5;
  GL_DSDT_MAG_NV = $86F6;
  GL_DSDT_MAG_VIB_NV = $86F7;
  GL_UNSIGNED_INT_S8_S8_8_8_NV = $86DA;
  GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = $86DB;
  GL_SIGNED_RGBA_NV = $86FB;
  GL_SIGNED_RGBA8_NV = $86FC;
  GL_SIGNED_RGB_NV = $86FE;
  GL_SIGNED_RGB8_NV = $86FF;
  GL_SIGNED_LUMINANCE_NV = $8701;
  GL_SIGNED_LUMINANCE8_NV = $8702;
  GL_SIGNED_LUMINANCE_ALPHA_NV = $8703;
  GL_SIGNED_LUMINANCE8_ALPHA8_NV = $8704;
  GL_SIGNED_ALPHA_NV = $8705;
  GL_SIGNED_ALPHA8_NV = $8706;
  GL_SIGNED_INTENSITY_NV = $8707;
  GL_SIGNED_INTENSITY8_NV = $8708;
  GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = $870C;
  GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = $870D;
  GL_HILO16_NV = $86F8;
  GL_SIGNED_HILO_NV = $86F9;
  GL_SIGNED_HILO16_NV = $86FA;
  GL_DSDT8_NV = $8709;
  GL_DSDT8_MAG8_NV = $870A;
  GL_DSDT_MAG_INTENSITY_NV = $86DC;
  GL_DSDT8_MAG8_INTENSITY8_NV = $870B;
  GL_HI_SCALE_NV = $870E;
  GL_LO_SCALE_NV = $870F;
  GL_DS_SCALE_NV = $8710;
  GL_DT_SCALE_NV = $8711;
  GL_MAGNITUDE_SCALE_NV = $8712;
  GL_VIBRANCE_SCALE_NV = $8713;
  GL_HI_BIAS_NV = $8714;
  GL_LO_BIAS_NV = $8715;
  GL_DS_BIAS_NV = $8716;
  GL_DT_BIAS_NV = $8717;
  GL_MAGNITUDE_BIAS_NV = $8718;
  GL_VIBRANCE_BIAS_NV = $8719;
  GL_TEXTURE_BORDER_VALUES_NV = $871A;
  GL_TEXTURE_HI_SIZE_NV = $871B;
  GL_TEXTURE_LO_SIZE_NV = $871C;
  GL_TEXTURE_DS_SIZE_NV = $871D;
  GL_TEXTURE_DT_SIZE_NV = $871E;
  GL_TEXTURE_MAG_SIZE_NV = $871F;

function Load_GL_NV_texture_shader: Boolean;

//***** GL_NV_texture_shader2 *****//
const
  GL_DOT_PRODUCT_TEXTURE_3D_NV = $86EF;
  // GL_HILO_NV  { already defined }
  // GL_DSDT_NV  { already defined }
  // GL_DSDT_MAG_NV  { already defined }
  // GL_DSDT_MAG_VIB_NV  { already defined }
  // GL_UNSIGNED_INT_S8_S8_8_8_NV  { already defined }
  // GL_UNSIGNED_INT_8_8_S8_S8_REV_NV  { already defined }
  // GL_SIGNED_RGBA_NV  { already defined }
  // GL_SIGNED_RGBA8_NV  { already defined }
  // GL_SIGNED_RGB_NV  { already defined }
  // GL_SIGNED_RGB8_NV  { already defined }
  // GL_SIGNED_LUMINANCE_NV  { already defined }
  // GL_SIGNED_LUMINANCE8_NV  { already defined }
  // GL_SIGNED_LUMINANCE_ALPHA_NV  { already defined }
  // GL_SIGNED_LUMINANCE8_ALPHA8_NV  { already defined }
  // GL_SIGNED_ALPHA_NV  { already defined }
  // GL_SIGNED_ALPHA8_NV  { already defined }
  // GL_SIGNED_INTENSITY_NV  { already defined }
  // GL_SIGNED_INTENSITY8_NV  { already defined }
  // GL_SIGNED_RGB_UNSIGNED_ALPHA_NV  { already defined }
  // GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV  { already defined }
  // GL_HILO16_NV  { already defined }
  // GL_SIGNED_HILO_NV  { already defined }
  // GL_SIGNED_HILO16_NV  { already defined }
  // GL_DSDT8_NV  { already defined }
  // GL_DSDT8_MAG8_NV  { already defined }
  // GL_DSDT_MAG_INTENSITY_NV  { already defined }
  // GL_DSDT8_MAG8_INTENSITY8_NV  { already defined }

function Load_GL_NV_texture_shader2: Boolean;

//***** GL_NV_texture_shader3 *****//
const
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = $8850;
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = $8851;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8852;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = $8853;
  GL_OFFSET_HILO_TEXTURE_2D_NV = $8854;
  GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = $8855;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = $8856;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8857;
  GL_DEPENDENT_HILO_TEXTURE_2D_NV = $8858;
  GL_DEPENDENT_RGB_TEXTURE_3D_NV = $8859;
  GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = $885A;
  GL_DOT_PRODUCT_PASS_THROUGH_NV = $885B;
  GL_DOT_PRODUCT_TEXTURE_1D_NV = $885C;
  GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = $885D;
  GL_HILO8_NV = $885E;
  GL_SIGNED_HILO8_NV = $885F;
  GL_FORCE_BLUE_TO_ONE_NV = $8860;

function Load_GL_NV_texture_shader3: Boolean;

//***** GL_NV_vertex_array_range *****//
const
  GL_VERTEX_ARRAY_RANGE_NV = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_NV = $851E;
  GL_VERTEX_ARRAY_RANGE_VALID_NV = $851F;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_NV = $8521;
var
  glVertexArrayRangeNV: procedure(length: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFlushVertexArrayRangeNV: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
{$IFDEF msWindows}
  wglAllocateMemoryNV: function(size: GLsizei; readFrequency: GLfloat; writeFrequency: GLfloat; priority: GLfloat): PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglFreeMemoryNV: procedure(pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
{$ENDIF}

function Load_GL_NV_vertex_array_range: Boolean;

//***** GL_NV_vertex_array_range2 *****//
const
  GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = $8533;

function Load_GL_NV_vertex_array_range2: Boolean;

//***** GL_NV_vertex_program *****//
const
  GL_VERTEX_PROGRAM_NV = $8620;
  GL_VERTEX_PROGRAM_POINT_SIZE_NV = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_NV = $8643;
  GL_VERTEX_STATE_PROGRAM_NV = $8621;
  GL_ATTRIB_ARRAY_SIZE_NV = $8623;
  GL_ATTRIB_ARRAY_STRIDE_NV = $8624;
  GL_ATTRIB_ARRAY_TYPE_NV = $8625;
  GL_CURRENT_ATTRIB_NV = $8626;
  GL_PROGRAM_PARAMETER_NV = $8644;
  GL_ATTRIB_ARRAY_POINTER_NV = $8645;
  GL_PROGRAM_TARGET_NV = $8646;
  GL_PROGRAM_LENGTH_NV = $8627;
  GL_PROGRAM_RESIDENT_NV = $8647;
  GL_PROGRAM_STRING_NV = $8628;
  GL_TRACK_MATRIX_NV = $8648;
  GL_TRACK_MATRIX_TRANSFORM_NV = $8649;
  GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = $862E;
  GL_MAX_TRACK_MATRICES_NV = $862F;
  GL_CURRENT_MATRIX_STACK_DEPTH_NV = $8640;
  GL_CURRENT_MATRIX_NV = $8641;
  GL_VERTEX_PROGRAM_BINDING_NV = $864A;
  GL_PROGRAM_ERROR_POSITION_NV = $864B;
  GL_MODELVIEW_PROJECTION_NV = $8629;
  GL_MATRIX0_NV = $8630;
  GL_MATRIX1_NV = $8631;
  GL_MATRIX2_NV = $8632;
  GL_MATRIX3_NV = $8633;
  GL_MATRIX4_NV = $8634;
  GL_MATRIX5_NV = $8635;
  GL_MATRIX6_NV = $8636;
  GL_MATRIX7_NV = $8637;
  GL_IDENTITY_NV = $862A;
  GL_INVERSE_NV = $862B;
  GL_TRANSPOSE_NV = $862C;
  GL_INVERSE_TRANSPOSE_NV = $862D;
  GL_VERTEX_ATTRIB_ARRAY0_NV = $8650;
  GL_VERTEX_ATTRIB_ARRAY1_NV = $8651;
  GL_VERTEX_ATTRIB_ARRAY2_NV = $8652;
  GL_VERTEX_ATTRIB_ARRAY3_NV = $8653;
  GL_VERTEX_ATTRIB_ARRAY4_NV = $8654;
  GL_VERTEX_ATTRIB_ARRAY5_NV = $8655;
  GL_VERTEX_ATTRIB_ARRAY6_NV = $8656;
  GL_VERTEX_ATTRIB_ARRAY7_NV = $8657;
  GL_VERTEX_ATTRIB_ARRAY8_NV = $8658;
  GL_VERTEX_ATTRIB_ARRAY9_NV = $8659;
  GL_VERTEX_ATTRIB_ARRAY10_NV = $865A;
  GL_VERTEX_ATTRIB_ARRAY11_NV = $865B;
  GL_VERTEX_ATTRIB_ARRAY12_NV = $865C;
  GL_VERTEX_ATTRIB_ARRAY13_NV = $865D;
  GL_VERTEX_ATTRIB_ARRAY14_NV = $865E;
  GL_VERTEX_ATTRIB_ARRAY15_NV = $865F;
  GL_MAP1_VERTEX_ATTRIB0_4_NV = $8660;
  GL_MAP1_VERTEX_ATTRIB1_4_NV = $8661;
  GL_MAP1_VERTEX_ATTRIB2_4_NV = $8662;
  GL_MAP1_VERTEX_ATTRIB3_4_NV = $8663;
  GL_MAP1_VERTEX_ATTRIB4_4_NV = $8664;
  GL_MAP1_VERTEX_ATTRIB5_4_NV = $8665;
  GL_MAP1_VERTEX_ATTRIB6_4_NV = $8666;
  GL_MAP1_VERTEX_ATTRIB7_4_NV = $8667;
  GL_MAP1_VERTEX_ATTRIB8_4_NV = $8668;
  GL_MAP1_VERTEX_ATTRIB9_4_NV = $8669;
  GL_MAP1_VERTEX_ATTRIB10_4_NV = $866A;
  GL_MAP1_VERTEX_ATTRIB11_4_NV = $866B;
  GL_MAP1_VERTEX_ATTRIB12_4_NV = $866C;
  GL_MAP1_VERTEX_ATTRIB13_4_NV = $866D;
  GL_MAP1_VERTEX_ATTRIB14_4_NV = $866E;
  GL_MAP1_VERTEX_ATTRIB15_4_NV = $866F;
  GL_MAP2_VERTEX_ATTRIB0_4_NV = $8670;
  GL_MAP2_VERTEX_ATTRIB1_4_NV = $8671;
  GL_MAP2_VERTEX_ATTRIB2_4_NV = $8672;
  GL_MAP2_VERTEX_ATTRIB3_4_NV = $8673;
  GL_MAP2_VERTEX_ATTRIB4_4_NV = $8674;
  GL_MAP2_VERTEX_ATTRIB5_4_NV = $8675;
  GL_MAP2_VERTEX_ATTRIB6_4_NV = $8676;
  GL_MAP2_VERTEX_ATTRIB7_4_NV = $8677;
  GL_MAP2_VERTEX_ATTRIB8_4_NV = $8678;
  GL_MAP2_VERTEX_ATTRIB9_4_NV = $8679;
  GL_MAP2_VERTEX_ATTRIB10_4_NV = $867A;
  GL_MAP2_VERTEX_ATTRIB11_4_NV = $867B;
  GL_MAP2_VERTEX_ATTRIB12_4_NV = $867C;
  GL_MAP2_VERTEX_ATTRIB13_4_NV = $867D;
  GL_MAP2_VERTEX_ATTRIB14_4_NV = $867E;
  GL_MAP2_VERTEX_ATTRIB15_4_NV = $867F;
var
  glBindProgramNV: procedure(target: GLenum; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteProgramsNV: procedure(n: GLsizei; const ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glExecuteProgramNV: procedure(target: GLenum; id: GLuint; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenProgramsNV: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAreProgramsResidentNV: function(n: GLsizei; const ids: PGLuint; residences: PGLboolean): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glRequestResidentProgramsNV: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramParameterfvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramParameterdvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramivNV: procedure(id: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramStringNV: procedure(id: GLuint; pname: GLenum; _program: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTrackMatrixivNV: procedure(target: GLenum; address: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribdvNV: procedure(index: GLuint; pname: GLenum; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribfvNV: procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribivNV: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribPointervNV: procedure(index: GLuint; pname: GLenum; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsProgramNV: function(id: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLoadProgramNV: procedure(target: GLenum; id: GLuint; len: GLsizei; const _program: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramParameter4fNV: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramParameter4fvNV: procedure(target: GLenum; index: GLuint; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramParameters4dvNV: procedure(target: GLenum; index: GLuint; num: GLuint; const params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramParameters4fvNV: procedure(target: GLenum; index: GLuint; num: GLuint; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTrackMatrixNV: procedure(target: GLenum; address: GLuint; matrix: GLenum; transform: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribPointerNV: procedure(index: GLuint; size: GLint; _type: GLenum; stride: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1sNV: procedure(index: GLuint; x: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1fNV: procedure(index: GLuint; x: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1dNV: procedure(index: GLuint; x: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2sNV: procedure(index: GLuint; x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3sNV: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4sNV: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4ubNV: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1svNV: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1fvNV: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1dvNV: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2svNV: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2fvNV: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2dvNV: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3svNV: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3fvNV: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3dvNV: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4svNV: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4fvNV: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4dvNV: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4ubvNV: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs1svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs1fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs1dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs2svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs2fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs2dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs3svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs3fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs3dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs4svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs4fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs4dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs4ubvNV: procedure(index: GLuint; n: GLsizei; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_vertex_program: Boolean;

//***** GL_NV_vertex_program1_1 *****//

function Load_GL_NV_vertex_program1_1: Boolean;

//***** GL_ATI_element_array *****//
const
  GL_ELEMENT_ARRAY_ATI = $8768;
  GL_ELEMENT_ARRAY_TYPE_ATI = $8769;
  GL_ELEMENT_ARRAY_POINTER_ATI = $876A;
var
  glElementPointerATI: procedure(_type: GLenum; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawElementArrayATI: procedure(mode: GLenum; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawRangeElementArrayATI: procedure(mode: GLenum; start: GLuint; _end: GLuint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_element_array: Boolean;

//***** GL_ATI_envmap_bumpmap *****//
const
  GL_BUMP_ROT_MATRIX_ATI = $8775;
  GL_BUMP_ROT_MATRIX_SIZE_ATI = $8776;
  GL_BUMP_NUM_TEX_UNITS_ATI = $8777;
  GL_BUMP_TEX_UNITS_ATI = $8778;
  GL_DUDV_ATI = $8779;
  GL_DU8DV8_ATI = $877A;
  GL_BUMP_ENVMAP_ATI = $877B;
  GL_BUMP_TARGET_ATI = $877C;
var
  glTexBumpParameterivATI: procedure(pname: GLenum; param: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexBumpParameterfvATI: procedure(pname: GLenum; param: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTexBumpParameterivATI: procedure(pname: GLenum; param: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTexBumpParameterfvATI: procedure(pname: GLenum; param: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_envmap_bumpmap: Boolean;

//***** GL_ATI_fragment_shader *****//
const
  GL_FRAGMENT_SHADER_ATI = $8920;
  GL_REG_0_ATI = $8921;
  GL_REG_1_ATI = $8922;
  GL_REG_2_ATI = $8923;
  GL_REG_3_ATI = $8924;
  GL_REG_4_ATI = $8925;
  GL_REG_5_ATI = $8926;
  GL_CON_0_ATI = $8941;
  GL_CON_1_ATI = $8942;
  GL_CON_2_ATI = $8943;
  GL_CON_3_ATI = $8944;
  GL_CON_4_ATI = $8945;
  GL_CON_5_ATI = $8946;
  GL_CON_6_ATI = $8947;
  GL_CON_7_ATI = $8948;
  GL_MOV_ATI = $8961;
  GL_ADD_ATI = $8963;
  GL_MUL_ATI = $8964;
  GL_SUB_ATI = $8965;
  GL_DOT3_ATI = $8966;
  GL_DOT4_ATI = $8967;
  GL_MAD_ATI = $8968;
  GL_LERP_ATI = $8969;
  GL_CND_ATI = $896A;
  GL_CND0_ATI = $896B;
  GL_DOT2_ADD_ATI = $896C;
  GL_SECONDARY_INTERPOLATOR_ATI = $896D;
  GL_SWIZZLE_STR_ATI = $8976;
  GL_SWIZZLE_STQ_ATI = $8977;
  GL_SWIZZLE_STR_DR_ATI = $8978;
  GL_SWIZZLE_STQ_DQ_ATI = $8979;
  GL_RED_BIT_ATI = $0001;
  GL_GREEN_BIT_ATI = $0002;
  GL_BLUE_BIT_ATI = $0004;
  GL_2X_BIT_ATI = $0001;
  GL_4X_BIT_ATI = $0002;
  GL_8X_BIT_ATI = $0004;
  GL_HALF_BIT_ATI = $0008;
  GL_QUARTER_BIT_ATI = $0010;
  GL_EIGHTH_BIT_ATI = $0020;
  GL_SATURATE_BIT_ATI = $0040;
  // GL_2X_BIT_ATI  { already defined }
  GL_COMP_BIT_ATI = $0002;
  GL_NEGATE_BIT_ATI = $0004;
  GL_BIAS_BIT_ATI = $0008;
var
  glGenFragmentShadersATI: function(range: GLuint): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindFragmentShaderATI: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteFragmentShaderATI: procedure(id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginFragmentShaderATI: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndFragmentShaderATI: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPassTexCoordATI: procedure(dst: GLuint; coord: GLuint; swizzle: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSampleMapATI: procedure(dst: GLuint; interp: GLuint; swizzle: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorFragmentOp1ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorFragmentOp2ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorFragmentOp3ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAlphaFragmentOp1ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAlphaFragmentOp2ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAlphaFragmentOp3ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSetFragmentShaderConstantATI: procedure(dst: GLuint; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_fragment_shader: Boolean;

//***** GL_ATI_pn_triangles *****//
const
  GL_PN_TRIANGLES_ATI = $87F0;
  GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F1;
  GL_PN_TRIANGLES_POINT_MODE_ATI = $87F2;
  GL_PN_TRIANGLES_NORMAL_MODE_ATI = $87F3;
  GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F4;
  GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = $87F5;
  GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = $87F6;
  GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = $87F7;
  GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = $87F8;
var
  glPNTrianglesiATI: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPNTrianglesfATI: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_pn_triangles: Boolean;

//***** GL_ATI_texture_mirror_once *****//
const
  GL_MIRROR_CLAMP_ATI = $8742;
  GL_MIRROR_CLAMP_TO_EDGE_ATI = $8743;

function Load_GL_ATI_texture_mirror_once: Boolean;

//***** GL_ATI_vertex_array_object *****//
const
  GL_STATIC_ATI = $8760;
  GL_DYNAMIC_ATI = $8761;
  GL_PRESERVE_ATI = $8762;
  GL_DISCARD_ATI = $8763;
  GL_OBJECT_BUFFER_SIZE_ATI = $8764;
  GL_OBJECT_BUFFER_USAGE_ATI = $8765;
  GL_ARRAY_OBJECT_BUFFER_ATI = $8766;
  GL_ARRAY_OBJECT_OFFSET_ATI = $8767;
var
  glNewObjectBufferATI: function(size: GLsizei; const pointer: PGLvoid; usage: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsObjectBufferATI: function(buffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUpdateObjectBufferATI: procedure(buffer: GLuint; offset: GLuint; size: GLsizei; const pointer: PGLvoid; preserve: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetObjectBufferfvATI: procedure(buffer: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetObjectBufferivATI: procedure(buffer: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteObjectBufferATI: procedure(buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glArrayObjectATI: procedure(_array: GLenum; size: GLint; _type: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetArrayObjectfvATI: procedure(_array: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetArrayObjectivATI: procedure(_array: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVariantArrayObjectATI: procedure(id: GLuint; _type: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantArrayObjectfvATI: procedure(id: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVariantArrayObjectivATI: procedure(id: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_vertex_array_object: Boolean;

//***** GL_ATI_vertex_streams *****//
const
  GL_MAX_VERTEX_STREAMS_ATI = $876B;
  GL_VERTEX_STREAM0_ATI = $876C;
  GL_VERTEX_STREAM1_ATI = $876D;
  GL_VERTEX_STREAM2_ATI = $876E;
  GL_VERTEX_STREAM3_ATI = $876F;
  GL_VERTEX_STREAM4_ATI = $8770;
  GL_VERTEX_STREAM5_ATI = $8771;
  GL_VERTEX_STREAM6_ATI = $8772;
  GL_VERTEX_STREAM7_ATI = $8773;
  GL_VERTEX_SOURCE_ATI = $8774;
var
  glVertexStream1s: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1i: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1f: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1d: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1sv: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1iv: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1fv: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream1dv: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2s: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2i: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2f: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2d: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2sv: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2iv: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2fv: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream2dv: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3s: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3i: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3f: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3d: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3sv: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3iv: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3fv: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream3dv: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4s: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4i: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4f: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4d: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4sv: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4iv: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4fv: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexStream4dv: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3b: procedure(stream: GLenum; coords: GLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3s: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3i: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3f: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3d: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3bv: procedure(stream: GLenum; coords: GLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3sv: procedure(stream: GLenum; coords: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3iv: procedure(stream: GLenum; coords: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3fv: procedure(stream: GLenum; coords: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalStream3dv: procedure(stream: GLenum; coords: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClientActiveVertexStream: procedure(stream: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexBlendEnvi: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexBlendEnvf: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_vertex_streams: Boolean;

{$IFDEF msWindows}
//***** WGL_I3D_image_buffer *****//
const
  WGL_IMAGE_BUFFER_MIN_ACCESS_I3D = $0001;
  WGL_IMAGE_BUFFER_LOCK_I3D = $0002;
var
  wglCreateImageBufferI3D: function(hDC: HDC; dwSize: DWORD; uFlags: UINT): PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDestroyImageBufferI3D: function(hDC: HDC; pAddress: PGLvoid): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglAssociateImageBufferEventsI3D: function(hdc: HDC; pEvent: PHandle; pAddress: PGLvoid; pSize: PDWORD; count: UINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglReleaseImageBufferEventsI3D: function(hdc: HDC; pAddress: PGLvoid; count: UINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_image_buffer: Boolean;

//***** WGL_I3D_swap_frame_lock *****//
var
  wglEnableFrameLockI3D: function(): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDisableFrameLockI3D: function(): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglIsEnabledFrameLockI3D: function(pFlag: PBOOL): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglQueryFrameLockMasterI3D: function(pFlag: PBOOL): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_swap_frame_lock: Boolean;

//***** WGL_I3D_swap_frame_usage *****//
var
  wglGetFrameUsageI3D: function(pUsage: PGLfloat): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglBeginFrameTrackingI3D: function(): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglEndFrameTrackingI3D: function(): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglQueryFrameTrackingI3D: function(pFrameCount: PDWORD; pMissedFrames: PDWORD; pLastMissedUsage: PGLfloat): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_swap_frame_usage: Boolean;
{$ENDIF}

//***** GL_3DFX_texture_compression_FXT1 *****//
const
  GL_COMPRESSED_RGB_FXT1_3DFX = $86B0;
  GL_COMPRESSED_RGBA_FXT1_3DFX = $86B1;

function Load_GL_3DFX_texture_compression_FXT1: Boolean;

//***** GL_IBM_cull_vertex *****//
const
  GL_CULL_VERTEX_IBM = $1928A;

function Load_GL_IBM_cull_vertex: Boolean;

//***** GL_IBM_multimode_draw_arrays *****//
var
  glMultiModeDrawArraysIBM: procedure(mode: PGLenum; first: PGLint; count: PGLsizei; primcount: GLsizei; modestride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiModeDrawElementsIBM: procedure(mode: PGLenum; count: PGLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei; modestride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_IBM_multimode_draw_arrays: Boolean;

//***** GL_IBM_raster_pos_clip *****//
const
  GL_RASTER_POSITION_UNCLIPPED_IBM = $19262;

function Load_GL_IBM_raster_pos_clip: Boolean;

//***** GL_IBM_texture_mirrored_repeat *****//
const
  GL_MIRRORED_REPEAT_IBM = $8370;

function Load_GL_IBM_texture_mirrored_repeat: Boolean;

//***** GL_IBM_vertex_array_lists *****//
const
  GL_VERTEX_ARRAY_LIST_IBM = $1929E;
  GL_NORMAL_ARRAY_LIST_IBM = $1929F;
  GL_COLOR_ARRAY_LIST_IBM = $192A0;
  GL_INDEX_ARRAY_LIST_IBM = $192A1;
  GL_TEXTURE_COORD_ARRAY_LIST_IBM = $192A2;
  GL_EDGE_FLAG_ARRAY_LIST_IBM = $192A3;
  GL_FOG_COORDINATE_ARRAY_LIST_IBM = $192A4;
  GL_SECONDARY_COLOR_ARRAY_LIST_IBM = $192A5;
  GL_VERTEX_ARRAY_LIST_STRIDE_IBM = $192A8;
  GL_NORMAL_ARRAY_LIST_STRIDE_IBM = $192A9;
  GL_COLOR_ARRAY_LIST_STRIDE_IBM = $192AA;
  GL_INDEX_ARRAY_LIST_STRIDE_IBM = $192AB;
  GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = $192AC;
  GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = $192AD;
  GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = $192AE;
  GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = $192AF;
var
  glColorPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColorPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEdgeFlagPointerListIBM: procedure(stride: GLint; const pointer: PGLboolean; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordPointerListIBM: procedure(_type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalPointerListIBM: procedure(_type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_IBM_vertex_array_lists: Boolean;

//***** GL_MESA_resize_buffers *****//
var
  glResizeBuffersMESA: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_MESA_resize_buffers: Boolean;

//***** GL_MESA_window_pos *****//
var
  glWindowPos2dMESA: procedure(x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2fMESA: procedure(x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2iMESA: procedure(x: GLint; y: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2sMESA: procedure(x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2ivMESA: procedure(const p: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2svMESA: procedure(const p: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2fvMESA: procedure(const p: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2dvMESA: procedure(const p: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3iMESA: procedure(x: GLint; y: GLint; z: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3sMESA: procedure(x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3fMESA: procedure(x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3dMESA: procedure(x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3ivMESA: procedure(const p: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3svMESA: procedure(const p: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3fvMESA: procedure(const p: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3dvMESA: procedure(const p: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4iMESA: procedure(x: GLint; y: GLint; z: GLint; w: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4sMESA: procedure(x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4fMESA: procedure(x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4dMESA: procedure(x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4ivMESA: procedure(const p: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4svMESA: procedure(const p: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4fvMESA: procedure(const p: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos4dvMESA: procedure(const p: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_MESA_window_pos: Boolean;

//***** GL_OML_interlace *****//
const
  GL_INTERLACE_OML = $8980;
  GL_INTERLACE_READ_OML = $8981;

function Load_GL_OML_interlace: Boolean;

//***** GL_OML_resample *****//
const
  GL_PACK_RESAMPLE_OML = $8984;
  GL_UNPACK_RESAMPLE_OML = $8985;
  GL_RESAMPLE_REPLICATE_OML = $8986;
  GL_RESAMPLE_ZERO_FILL_OML = $8987;
  GL_RESAMPLE_AVERAGE_OML = $8988;
  GL_RESAMPLE_DECIMATE_OML = $8989;
  // GL_RESAMPLE_AVERAGE_OML  { already defined }

function Load_GL_OML_resample: Boolean;

//***** GL_OML_subsample *****//
const
  GL_FORMAT_SUBSAMPLE_24_24_OML = $8982;
  GL_FORMAT_SUBSAMPLE_244_244_OML = $8983;

function Load_GL_OML_subsample: Boolean;

//***** GL_SGIS_generate_mipmap *****//
const
  GL_GENERATE_MIPMAP_SGIS = $8191;
  GL_GENERATE_MIPMAP_HINT_SGIS = $8192;

function Load_GL_SGIS_generate_mipmap: Boolean;

//***** GL_SGIS_multisample *****//
const
  GLX_SAMPLE_BUFFERS_SGIS = $186A0;
  GLX_SAMPLES_SGIS = $186A1;
  GL_MULTISAMPLE_SGIS = $809D;
  GL_SAMPLE_ALPHA_TO_MASK_SGIS = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_SGIS = $809F;
  GL_SAMPLE_MASK_SGIS = $80A0;
  GL_MULTISAMPLE_BIT_EXT = $20000000;
  GL_1PASS_SGIS = $80A1;
  GL_2PASS_0_SGIS = $80A2;
  GL_2PASS_1_SGIS = $80A3;
  GL_4PASS_0_SGIS = $80A4;
  GL_4PASS_1_SGIS = $80A5;
  GL_4PASS_2_SGIS = $80A6;
  GL_4PASS_3_SGIS = $80A7;
  GL_SAMPLE_BUFFERS_SGIS = $80A8;
  GL_SAMPLES_SGIS = $80A9;
  GL_SAMPLE_MASK_VALUE_SGIS = $80AA;
  GL_SAMPLE_MASK_INVERT_SGIS = $80AB;
  GL_SAMPLE_PATTERN_SGIS = $80AC;
var
  glSampleMaskSGIS: procedure(value: GLclampf; invert: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplePatternSGIS: procedure(pattern: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_SGIS_multisample: Boolean;

//***** GL_SGIS_pixel_texture *****//
const
  GL_PIXEL_TEXTURE_SGIS = $8353;
  GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = $8354;
  GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = $8355;
  GL_PIXEL_GROUP_COLOR_SGIS = $8356;
var
  glPixelTexGenParameteriSGIS: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPixelTexGenParameterfSGIS: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetPixelTexGenParameterivSGIS: procedure(pname: GLenum; params: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetPixelTexGenParameterfvSGIS: procedure(pname: GLenum; params: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_SGIS_pixel_texture: Boolean;

//***** GL_SGIS_texture_border_clamp *****//
  // GL_CLAMP_TO_BORDER_SGIS  { already defined }

function Load_GL_SGIS_texture_border_clamp: Boolean;

//***** GL_SGIS_texture_color_mask *****//
const
  GL_TEXTURE_COLOR_WRITEMASK_SGIS = $81EF;
var
  glTextureColorMaskSGIS: procedure(r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_SGIS_texture_color_mask: Boolean;

//***** GL_SGIS_texture_edge_clamp *****//
const
  GL_CLAMP_TO_EDGE_SGIS = $812F;

function Load_GL_SGIS_texture_edge_clamp: Boolean;

//***** GL_SGIS_texture_lod *****//
const
  GL_TEXTURE_MIN_LOD_SGIS = $813A;
  GL_TEXTURE_MAX_LOD_SGIS = $813B;
  GL_TEXTURE_BASE_LEVEL_SGIS = $813C;
  GL_TEXTURE_MAX_LEVEL_SGIS = $813D;

function Load_GL_SGIS_texture_lod: Boolean;

//***** GL_SGIS_depth_texture *****//
const
  GL_DEPTH_COMPONENT16_SGIX = $81A5;
  GL_DEPTH_COMPONENT24_SGIX = $81A6;
  GL_DEPTH_COMPONENT32_SGIX = $81A7;

function Load_GL_SGIS_depth_texture: Boolean;

//***** GL_SGIX_fog_offset *****//
const
  GL_FOG_OFFSET_SGIX = $8198;
  GL_FOG_OFFSET_VALUE_SGIX = $8199;

function Load_GL_SGIX_fog_offset: Boolean;

//***** GL_SGIX_interlace *****//
const
  GL_INTERLACE_SGIX = $8094;

function Load_GL_SGIX_interlace: Boolean;

//***** GL_SGIX_shadow_ambient *****//
const
  GL_SHADOW_AMBIENT_SGIX = $80BF;

function Load_GL_SGIX_shadow_ambient: Boolean;

//***** GL_SGI_color_matrix *****//
const
  GL_COLOR_MATRIX_SGI = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH_SGI = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE_SGI = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS_SGI = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = $80BA;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = $80BB;

function Load_GL_SGI_color_matrix: Boolean;

//***** GL_SGI_color_table *****//
const
  GL_COLOR_TABLE_SGI = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D2;
  GL_PROXY_COLOR_TABLE_SGI = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D5;
  GL_COLOR_TABLE_SCALE_SGI = $80D6;
  GL_COLOR_TABLE_BIAS_SGI = $80D7;
  GL_COLOR_TABLE_FORMAT_SGI = $80D8;
  GL_COLOR_TABLE_WIDTH_SGI = $80D9;
  GL_COLOR_TABLE_RED_SIZE_SGI = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_SGI = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_SGI = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_SGI = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_SGI = $80DF;
var
  glColorTableSGI: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const table: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCopyColorTableSGI: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorTableParameterivSGI: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorTableParameterfvSGI: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableSGI: procedure(target: GLenum; format: GLenum; _type: GLenum; table: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameterivSGI: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetColorTableParameterfvSGI: procedure(target: GLenum; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_SGI_color_table: Boolean;

//***** GL_SGI_texture_color_table *****//
const
  GL_TEXTURE_COLOR_TABLE_SGI = $80BC;
  GL_PROXY_TEXTURE_COLOR_TABLE_SGI = $80BD;

function Load_GL_SGI_texture_color_table: Boolean;

//***** GL_SUN_vertex *****//
var
  glColor4ubVertex2fSUN: procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4ubVertex2fvSUN: procedure(const c: PGLubyte; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4ubVertex3fSUN: procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4ubVertex3fvSUN: procedure(const c: PGLubyte; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor3fVertex3fSUN: procedure(r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor3fVertex3fvSUN: procedure(const c: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormal3fVertex3fSUN: procedure(nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormal3fVertex3fvSUN: procedure(const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4fNormal3fVertex3fSUN: procedure(r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4fNormal3fVertex3fvSUN: procedure(const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fVertex3fvSUN: procedure(const tc: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4fVertex4fSUN: procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4fVertex4fvSUN: procedure(const tc: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor4ubVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor4ubVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLubyte; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor3fVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fNormal3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fNormal3fVertex3fvSUN: procedure(const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor4fNormal3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2fColor4fNormal3fVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4fColor4fNormal3fVertex4fSUN: procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4fColor4fNormal3fVertex4fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiVertex3fSUN: procedure(rc: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiVertex3fvSUN: procedure(const rc: PGLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor4ubVertex3fSUN: procedure(rc: GLuint; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor4ubVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLubyte; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor3fVertex3fSUN: procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor3fVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiNormal3fVertex3fSUN: procedure(rc: GLuint; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor4fNormal3fVertex3fSUN: procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_SUN_vertex: Boolean;

//***** GL_ARB_fragment_program *****//
const
  GL_FRAGMENT_PROGRAM_ARB = $8804;
  // GL_PROGRAM_FORMAT_ASCII_ARB  { already defined }
  // GL_PROGRAM_LENGTH_ARB  { already defined }
  // GL_PROGRAM_FORMAT_ARB  { already defined }
  // GL_PROGRAM_BINDING_ARB  { already defined }
  // GL_PROGRAM_INSTRUCTIONS_ARB  { already defined }
  // GL_MAX_PROGRAM_INSTRUCTIONS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB  { already defined }
  // GL_PROGRAM_TEMPORARIES_ARB  { already defined }
  // GL_MAX_PROGRAM_TEMPORARIES_ARB  { already defined }
  // GL_PROGRAM_NATIVE_TEMPORARIES_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB  { already defined }
  // GL_PROGRAM_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_ATTRIBS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_ENV_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB  { already defined }
  GL_PROGRAM_ALU_INSTRUCTIONS_ARB = $8805;
  GL_PROGRAM_TEX_INSTRUCTIONS_ARB = $8806;
  GL_PROGRAM_TEX_INDIRECTIONS_ARB = $8807;
  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $8808;
  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $8809;
  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $880A;
  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = $880B;
  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = $880C;
  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = $880D;
  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $880E;
  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $880F;
  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $8810;
  // GL_PROGRAM_STRING_ARB  { already defined }
  // GL_PROGRAM_ERROR_POSITION_ARB  { already defined }
  // GL_CURRENT_MATRIX_ARB  { already defined }
  // GL_TRANSPOSE_CURRENT_MATRIX_ARB  { already defined }
  // GL_CURRENT_MATRIX_STACK_DEPTH_ARB  { already defined }
  // GL_MAX_PROGRAM_MATRICES_ARB  { already defined }
  // GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB  { already defined }
  GL_MAX_TEXTURE_COORDS_ARB = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB = $8872;
  // GL_PROGRAM_ERROR_STRING_ARB  { already defined }
  // GL_MATRIX0_ARB  { already defined }
  // GL_MATRIX1_ARB  { already defined }
  // GL_MATRIX2_ARB  { already defined }
  // GL_MATRIX3_ARB  { already defined }
  // GL_MATRIX4_ARB  { already defined }
  // GL_MATRIX5_ARB  { already defined }
  // GL_MATRIX6_ARB  { already defined }
  // GL_MATRIX7_ARB  { already defined }
  // GL_MATRIX8_ARB  { already defined }
  // GL_MATRIX9_ARB  { already defined }
  // GL_MATRIX10_ARB  { already defined }
  // GL_MATRIX11_ARB  { already defined }
  // GL_MATRIX12_ARB  { already defined }
  // GL_MATRIX13_ARB  { already defined }
  // GL_MATRIX14_ARB  { already defined }
  // GL_MATRIX15_ARB  { already defined }
  // GL_MATRIX16_ARB  { already defined }
  // GL_MATRIX17_ARB  { already defined }
  // GL_MATRIX18_ARB  { already defined }
  // GL_MATRIX19_ARB  { already defined }
  // GL_MATRIX20_ARB  { already defined }
  // GL_MATRIX21_ARB  { already defined }
  // GL_MATRIX22_ARB  { already defined }
  // GL_MATRIX23_ARB  { already defined }
  // GL_MATRIX24_ARB  { already defined }
  // GL_MATRIX25_ARB  { already defined }
  // GL_MATRIX26_ARB  { already defined }
  // GL_MATRIX27_ARB  { already defined }
  // GL_MATRIX28_ARB  { already defined }
  // GL_MATRIX29_ARB  { already defined }
  // GL_MATRIX30_ARB  { already defined }
  // GL_MATRIX31_ARB  { already defined }
  // glProgramStringARB  { already defined }
  // glBindProgramARB  { already defined }
  // glDeleteProgramsARB  { already defined }
  // glGenProgramsARB  { already defined }
  // glProgramEnvParameter4dARB  { already defined }
  // glProgramEnvParameter4dvARB  { already defined }
  // glProgramEnvParameter4fARB  { already defined }
  // glProgramEnvParameter4fvARB  { already defined }
  // glProgramLocalParameter4dARB  { already defined }
  // glProgramLocalParameter4dvARB  { already defined }
  // glProgramLocalParameter4fARB  { already defined }
  // glProgramLocalParameter4fvARB  { already defined }
  // glGetProgramEnvParameterdvARB  { already defined }
  // glGetProgramEnvParameterfvARB  { already defined }
  // glGetProgramLocalParameterdvARB  { already defined }
  // glGetProgramLocalParameterfvARB  { already defined }
  // glGetProgramivARB  { already defined }
  // glGetProgramStringARB  { already defined }
  // glIsProgramARB  { already defined }

function Load_GL_ARB_fragment_program: Boolean;

{***** GL_ATI_text_fragment_shader *****}
const
     GL_TEXT_FRAGMENT_SHADER_ATI = $8200;

function Load_GL_ATI_text_fragment_shader: Boolean;

{***** GL_ARB_vertex_buffer_object *****}
const
     GL_BUFFER_SIZE_ARB = $8764;
     GL_BUFFER_USAGE_ARB = $8765;
     GL_ARRAY_BUFFER_ARB = $8892;
     GL_ELEMENT_ARRAY_BUFFER_ARB = $8893;
     GL_ARRAY_BUFFER_BINDING_ARB = $8894;
     GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = $8895;
     GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = $8896;
     GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = $8897;
     GL_COLOR_ARRAY_BUFFER_BINDING_ARB = $8898;
     GL_INDEX_ARRAY_BUFFER_BINDING_ARB = $8899;
     GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = $889A;
     GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = $889B;
     GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = $889C;
     GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = $889D;
     GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = $889E;
     GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = $889F;
     GL_READ_ONLY_ARB = $88B8;
     GL_WRITE_ONLY_ARB = $88B9;
     GL_READ_WRITE_ARB = $88BA;
     GL_BUFFER_ACCESS_ARB = $88BB;
     GL_BUFFER_MAPPED_ARB = $88BC;
     GL_BUFFER_MAP_POINTER_ARB = $88BD;
     GL_STREAM_DRAW_ARB = $88E0;
     GL_STREAM_READ_ARB = $88E1;
     GL_STREAM_COPY_ARB = $88E2;
     GL_STATIC_DRAW_ARB = $88E4;
     GL_STATIC_READ_ARB = $88E5;
     GL_STATIC_COPY_ARB = $88E6;
     GL_DYNAMIC_DRAW_ARB = $88E8;
     GL_DYNAMIC_READ_ARB = $88E9;
     GL_DYNAMIC_COPY_ARB = $88EA;

var
     glBindBufferARB : procedure(target : GLenum; buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glDeleteBuffersARB : procedure(n : GLsizei; buffers : PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glGenBuffersARB : procedure(n : GLsizei; buffers : PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glIsBufferARB : function (buffer : GLuint) :GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glBufferDataARB : procedure(target : GLenum; size:GLsizei; data:PGLvoid;usage: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glBufferSubDataARB : procedure(target : GLenum; offset :GLint; size : GLsizei; data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glGetBufferSubDataARB : procedure(target : GLenum; offset :GLint; size : GLsizei; data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glMapBufferARB : function (target :GLenum; access: GLenum) : PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glUnmapBufferARB : function (target :GLenum) :GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glGetBufferParameterivARB:procedure(target:GLenum; pname:GLenum; params:PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
     glGetBufferPointervARB : procedure(target: GLenum; pname:GLenum; params: PPGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
function Load_GL_ARB_vertex_buffer_object : boolean;

//***** GL_APPLE_client_storage *****//
const
  GL_UNPACK_CLIENT_STORAGE_APPLE = $85B2;

function Load_GL_APPLE_client_storage: Boolean;

//***** GL_APPLE_element_array *****//
const
  GL_ELEMENT_ARRAY_APPLE = $8768;
  GL_ELEMENT_ARRAY_TYPE_APPLE = $8769;
  GL_ELEMENT_ARRAY_POINTER_APPLE = $876A;
var
  glElementPointerAPPLE: procedure(_type: GLenum; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawElementArrayAPPLE: procedure(mode: GLenum; first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawRangeElementArrayAPPLE: procedure(mode: GLenum; start: GLuint; _end: GLuint; first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawElementArrayAPPLE: procedure(mode: GLenum; const first: PGLint; const count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawRangeElementArrayAPPLE: procedure(mode: GLenum; start: GLuint; _end: GLuint; const first: PGLint; const count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_APPLE_element_array: Boolean;

//***** GL_APPLE_fence *****//
const
  GL_DRAW_PIXELS_APPLE = $8A0A;
  GL_FENCE_APPLE = $8A0B;
var
  glGenFencesAPPLE: procedure(n: GLsizei; fences: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteFencesAPPLE: procedure(n: GLsizei; const fences: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSetFenceAPPLE: procedure(fence: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsFenceAPPLE: function(fence: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTestFenceAPPLE: function(fence: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFinishFenceAPPLE: procedure(fence: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTestObjectAPPLE: function(_object: GLenum; name: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFinishObjectAPPLE: procedure(_object: GLenum; name: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_APPLE_fence: Boolean;

//***** GL_APPLE_vertex_array_object *****//
const
  GL_VERTEX_ARRAY_BINDING_APPLE = $85B5;
var
  glBindVertexArrayAPPLE: procedure(_array: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteVertexArraysAPPLE: procedure(n: GLsizei; const arrays: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenVertexArraysAPPLE: procedure(n: GLsizei; const arrays: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsVertexArrayAPPLE: function(_array: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_APPLE_vertex_array_object: Boolean;

//***** GL_APPLE_vertex_array_range *****//
const
  GL_VERTEX_ARRAY_RANGE_APPLE = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = $851E;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = $8521;
  GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = $851F;
  GL_STORAGE_CACHED_APPLE = $85BE;
  GL_STORAGE_SHARED_APPLE = $85BF;
var
  glVertexArrayRangeAPPLE: procedure(length: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFlushVertexArrayRangeAPPLE: procedure(length: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexArrayParameteriAPPLE: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_APPLE_vertex_array_range: Boolean;

{$IFDEF msWindows}
//***** WGL_ARB_pixel_format *****//
const
  WGL_NUMBER_PIXEL_FORMATS_ARB = $2000;
  WGL_DRAW_TO_WINDOW_ARB = $2001;
  WGL_DRAW_TO_BITMAP_ARB = $2002;
  WGL_ACCELERATION_ARB = $2003;
  WGL_NEED_PALETTE_ARB = $2004;
  WGL_NEED_SYSTEM_PALETTE_ARB = $2005;
  WGL_SWAP_LAYER_BUFFERS_ARB = $2006;
  WGL_SWAP_METHOD_ARB = $2007;
  WGL_NUMBER_OVERLAYS_ARB = $2008;
  WGL_NUMBER_UNDERLAYS_ARB = $2009;
  WGL_TRANSPARENT_ARB = $200A;
  WGL_TRANSPARENT_RED_VALUE_ARB = $2037;
  WGL_TRANSPARENT_GREEN_VALUE_ARB = $2038;
  WGL_TRANSPARENT_BLUE_VALUE_ARB = $2039;
  WGL_TRANSPARENT_ALPHA_VALUE_ARB = $203A;
  WGL_TRANSPARENT_INDEX_VALUE_ARB = $203B;
  WGL_SHARE_DEPTH_ARB = $200C;
  WGL_SHARE_STENCIL_ARB = $200D;
  WGL_SHARE_ACCUM_ARB = $200E;
  WGL_SUPPORT_GDI_ARB = $200F;
  WGL_SUPPORT_OPENGL_ARB = $2010;
  WGL_DOUBLE_BUFFER_ARB = $2011;
  WGL_STEREO_ARB = $2012;
  WGL_PIXEL_TYPE_ARB = $2013;
  WGL_COLOR_BITS_ARB = $2014;
  WGL_RED_BITS_ARB = $2015;
  WGL_RED_SHIFT_ARB = $2016;
  WGL_GREEN_BITS_ARB = $2017;
  WGL_GREEN_SHIFT_ARB = $2018;
  WGL_BLUE_BITS_ARB = $2019;
  WGL_BLUE_SHIFT_ARB = $201A;
  WGL_ALPHA_BITS_ARB = $201B;
  WGL_ALPHA_SHIFT_ARB = $201C;
  WGL_ACCUM_BITS_ARB = $201D;
  WGL_ACCUM_RED_BITS_ARB = $201E;
  WGL_ACCUM_GREEN_BITS_ARB = $201F;
  WGL_ACCUM_BLUE_BITS_ARB = $2020;
  WGL_ACCUM_ALPHA_BITS_ARB = $2021;
  WGL_DEPTH_BITS_ARB = $2022;
  WGL_STENCIL_BITS_ARB = $2023;
  WGL_AUX_BUFFERS_ARB = $2024;
  WGL_NO_ACCELERATION_ARB = $2025;
  WGL_GENERIC_ACCELERATION_ARB = $2026;
  WGL_FULL_ACCELERATION_ARB = $2027;
  WGL_SWAP_EXCHANGE_ARB = $2028;
  WGL_SWAP_COPY_ARB = $2029;
  WGL_SWAP_UNDEFINED_ARB = $202A;
  WGL_TYPE_RGBA_ARB = $202B;
  WGL_TYPE_COLORINDEX_ARB = $202C;
var
  wglGetPixelFormatAttribivARB: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; const piAttributes: PGLint; piValues: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetPixelFormatAttribfvARB: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; const piAttributes: PGLint; pfValues: PGLfloat): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglChoosePixelFormatARB: function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: GLuint; piFormats: PGLint; nNumFormats: PGLuint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_pixel_format: Boolean;

//***** WGL_ARB_make_current_read *****//
const
  WGL_ERROR_INVALID_PIXEL_TYPE_ARB = $2043;
  WGL_ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB = $2054;
var
  wglMakeContextCurrentARB: function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetCurrentReadDCARB: function(): HDC; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_make_current_read: Boolean;

//***** WGL_ARB_pbuffer *****//
const
  WGL_DRAW_TO_PBUFFER_ARB = $202D;
  // WGL_DRAW_TO_PBUFFER_ARB  { already defined }
  WGL_MAX_PBUFFER_PIXELS_ARB = $202E;
  WGL_MAX_PBUFFER_WIDTH_ARB = $202F;
  WGL_MAX_PBUFFER_HEIGHT_ARB = $2030;
  WGL_PBUFFER_LARGEST_ARB = $2033;
  WGL_PBUFFER_WIDTH_ARB = $2034;
  WGL_PBUFFER_HEIGHT_ARB = $2035;
  WGL_PBUFFER_LOST_ARB = $2036;
var
  wglCreatePbufferARB: function(hDC: HDC; iPixelFormat: GLint; iWidth: GLint; iHeight: GLint; const piAttribList: PGLint): THandle; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetPbufferDCARB: function(hPbuffer: THandle): HDC; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglReleasePbufferDCARB: function(hPbuffer: THandle; hDC: HDC): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDestroyPbufferARB: function(hPbuffer: THandle): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglQueryPbufferARB: function(hPbuffer: THandle; iAttribute: GLint; piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_pbuffer: Boolean;

//***** WGL_EXT_swap_control *****//
var
  wglSwapIntervalEXT: function(interval: GLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetSwapIntervalEXT: function(): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_EXT_swap_control: Boolean;

//***** WGL_ARB_render_texture *****//
const
  WGL_BIND_TO_TEXTURE_RGB_ARB = $2070;
  WGL_BIND_TO_TEXTURE_RGBA_ARB = $2071;
  WGL_TEXTURE_FORMAT_ARB = $2072;
  WGL_TEXTURE_TARGET_ARB = $2073;
  WGL_MIPMAP_TEXTURE_ARB = $2074;
  WGL_TEXTURE_RGB_ARB = $2075;
  WGL_TEXTURE_RGBA_ARB = $2076;
  WGL_NO_TEXTURE_ARB = $2077;
  WGL_TEXTURE_CUBE_MAP_ARB = $2078;
  WGL_TEXTURE_1D_ARB = $2079;
  WGL_TEXTURE_2D_ARB = $207A;
  // WGL_NO_TEXTURE_ARB  { already defined }
  WGL_MIPMAP_LEVEL_ARB = $207B;
  WGL_CUBE_MAP_FACE_ARB = $207C;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $207D;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $207E;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $207F;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $2080;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $2081;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $2082;
  WGL_FRONT_LEFT_ARB = $2083;
  WGL_FRONT_RIGHT_ARB = $2084;
  WGL_BACK_LEFT_ARB = $2085;
  WGL_BACK_RIGHT_ARB = $2086;
  WGL_AUX0_ARB = $2087;
  WGL_AUX1_ARB = $2088;
  WGL_AUX2_ARB = $2089;
  WGL_AUX3_ARB = $208A;
  WGL_AUX4_ARB = $208B;
  WGL_AUX5_ARB = $208C;
  WGL_AUX6_ARB = $208D;
  WGL_AUX7_ARB = $208E;
  WGL_AUX8_ARB = $208F;
  WGL_AUX9_ARB = $2090;
var
  wglBindTexImageARB: function(hPbuffer: THandle; iBuffer: GLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglReleaseTexImageARB: function(hPbuffer: THandle; iBuffer: GLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglSetPbufferAttribARB: function(hPbuffer: THandle; const piAttribList: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_ARB_render_texture: Boolean;

//***** WGL_EXT_extensions_string *****//
var
  wglGetExtensionsStringEXT: function(): Pchar; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_EXT_extensions_string: Boolean;

//***** WGL_EXT_make_current_read *****//
var
  wglMakeContextCurrentEXT: function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetCurrentReadDCEXT: function(): HDC; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_EXT_make_current_read: Boolean;

//***** WGL_EXT_pbuffer *****//
const
  WGL_DRAW_TO_PBUFFER_EXT = $202D;
  WGL_MAX_PBUFFER_PIXELS_EXT = $202E;
  WGL_MAX_PBUFFER_WIDTH_EXT = $202F;
  WGL_MAX_PBUFFER_HEIGHT_EXT = $2030;
  WGL_OPTIMAL_PBUFFER_WIDTH_EXT = $2031;
  WGL_OPTIMAL_PBUFFER_HEIGHT_EXT = $2032;
  WGL_PBUFFER_LARGEST_EXT = $2033;
  WGL_PBUFFER_WIDTH_EXT = $2034;
  WGL_PBUFFER_HEIGHT_EXT = $2035;
var
  wglCreatePbufferEXT: function(hDC: HDC; iPixelFormat: GLint; iWidth: GLint; iHeight: GLint; const piAttribList: PGLint): THandle; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetPbufferDCEXT: function(hPbuffer: THandle): HDC; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglReleasePbufferDCEXT: function(hPbuffer: THandle; hDC: HDC): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDestroyPbufferEXT: function(hPbuffer: THandle): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglQueryPbufferEXT: function(hPbuffer: THandle; iAttribute: GLint; piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_EXT_pbuffer: Boolean;

//***** WGL_EXT_pixel_format *****//
const
  WGL_NUMBER_PIXEL_FORMATS_EXT = $2000;
  WGL_DRAW_TO_WINDOW_EXT = $2001;
  WGL_DRAW_TO_BITMAP_EXT = $2002;
  WGL_ACCELERATION_EXT = $2003;
  WGL_NEED_PALETTE_EXT = $2004;
  WGL_NEED_SYSTEM_PALETTE_EXT = $2005;
  WGL_SWAP_LAYER_BUFFERS_EXT = $2006;
  WGL_SWAP_METHOD_EXT = $2007;
  WGL_NUMBER_OVERLAYS_EXT = $2008;
  WGL_NUMBER_UNDERLAYS_EXT = $2009;
  WGL_TRANSPARENT_EXT = $200A;
  WGL_TRANSPARENT_VALUE_EXT = $200B;
  WGL_SHARE_DEPTH_EXT = $200C;
  WGL_SHARE_STENCIL_EXT = $200D;
  WGL_SHARE_ACCUM_EXT = $200E;
  WGL_SUPPORT_GDI_EXT = $200F;
  WGL_SUPPORT_OPENGL_EXT = $2010;
  WGL_DOUBLE_BUFFER_EXT = $2011;
  WGL_STEREO_EXT = $2012;
  WGL_PIXEL_TYPE_EXT = $2013;
  WGL_COLOR_BITS_EXT = $2014;
  WGL_RED_BITS_EXT = $2015;
  WGL_RED_SHIFT_EXT = $2016;
  WGL_GREEN_BITS_EXT = $2017;
  WGL_GREEN_SHIFT_EXT = $2018;
  WGL_BLUE_BITS_EXT = $2019;
  WGL_BLUE_SHIFT_EXT = $201A;
  WGL_ALPHA_BITS_EXT = $201B;
  WGL_ALPHA_SHIFT_EXT = $201C;
  WGL_ACCUM_BITS_EXT = $201D;
  WGL_ACCUM_RED_BITS_EXT = $201E;
  WGL_ACCUM_GREEN_BITS_EXT = $201F;
  WGL_ACCUM_BLUE_BITS_EXT = $2020;
  WGL_ACCUM_ALPHA_BITS_EXT = $2021;
  WGL_DEPTH_BITS_EXT = $2022;
  WGL_STENCIL_BITS_EXT = $2023;
  WGL_AUX_BUFFERS_EXT = $2024;
  WGL_NO_ACCELERATION_EXT = $2025;
  WGL_GENERIC_ACCELERATION_EXT = $2026;
  WGL_FULL_ACCELERATION_EXT = $2027;
  WGL_SWAP_EXCHANGE_EXT = $2028;
  WGL_SWAP_COPY_EXT = $2029;
  WGL_SWAP_UNDEFINED_EXT = $202A;
  WGL_TYPE_RGBA_EXT = $202B;
  WGL_TYPE_COLORINDEX_EXT = $202C;
var
  wglGetPixelFormatAttribivEXT: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; piAttributes: PGLint; piValues: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetPixelFormatAttribfvEXT: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; piAttributes: PGLint; pfValues: PGLfloat): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglChoosePixelFormatEXT: function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: GLuint; piFormats: PGLint; nNumFormats: PGLuint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_EXT_pixel_format: Boolean;

//***** WGL_I3D_digital_video_control *****//
const
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D = $2050;
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D = $2051;
  WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D = $2052;
  WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D = $2053;
var
  wglGetDigitalVideoParametersI3D: function(hDC: HDC; iAttribute: GLint; piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglSetDigitalVideoParametersI3D: function(hDC: HDC; iAttribute: GLint; const piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_digital_video_control: Boolean;

//***** WGL_I3D_gamma *****//
const
  WGL_GAMMA_TABLE_SIZE_I3D = $204E;
  WGL_GAMMA_EXCLUDE_DESKTOP_I3D = $204F;
  // WGL_GAMMA_EXCLUDE_DESKTOP_I3D  { already defined }
var
  wglGetGammaTableParametersI3D: function(hDC: HDC; iAttribute: GLint; piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglSetGammaTableParametersI3D: function(hDC: HDC; iAttribute: GLint; const piValue: PGLint): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetGammaTableI3D: function(hDC: HDC; iEntries: GLint; puRed: PGLUSHORT; puGreen: PGLUSHORT; puBlue: PGLUSHORT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglSetGammaTableI3D: function(hDC: HDC; iEntries: GLint; const puRed: PGLUSHORT; const puGreen: PGLUSHORT; const puBlue: PGLUSHORT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_gamma: Boolean;

//***** WGL_I3D_genlock *****//
const
  WGL_GENLOCK_SOURCE_MULTIVIEW_I3D = $2044;
  WGL_GENLOCK_SOURCE_EXTERNAL_SYNC_I3D = $2045;
  WGL_GENLOCK_SOURCE_EXTERNAL_FIELD_I3D = $2046;
  WGL_GENLOCK_SOURCE_EXTERNAL_TTL_I3D = $2047;
  WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D = $2048;
  WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D = $2049;
  WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D = $204A;
  WGL_GENLOCK_SOURCE_EDGE_RISING_I3D = $204B;
  WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D = $204C;
var
  wglEnableGenlockI3D: function(hDC: HDC): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglDisableGenlockI3D: function(hDC: HDC): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglIsEnabledGenlockI3D: function(hDC: HDC; pFlag: PBOOL): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGenlockSourceI3D: function(hDC: HDC; uSource: GLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetGenlockSourceI3D: function(hDC: HDC; uSource: PGLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGenlockSourceEdgeI3D: function(hDC: HDC; uEdge: GLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetGenlockSourceEdgeI3D: function(hDC: HDC; uEdge: PGLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGenlockSampleRateI3D: function(hDC: HDC; uRate: GLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetGenlockSampleRateI3D: function(hDC: HDC; uRate: PGLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGenlockSourceDelayI3D: function(hDC: HDC; uDelay: GLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglGetGenlockSourceDelayI3D: function(hDC: HDC; uDelay: PGLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  wglQueryGenlockMaxSourceDelayI3D: function(hDC: HDC; uMaxLineDelay: PGLUINT; uMaxPixelDelay: PGLUINT): BOOL; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_WGL_I3D_genlock: Boolean;
{$ENDIF}

//***** GL_ARB_matrix_palette *****//
const
  GL_MATRIX_PALETTE_ARB = $8840;
  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = $8841;
  GL_MAX_PALETTE_MATRICES_ARB = $8842;
  GL_CURRENT_PALETTE_MATRIX_ARB = $8843;
  GL_MATRIX_INDEX_ARRAY_ARB = $8844;
  GL_CURRENT_MATRIX_INDEX_ARB = $8845;
  GL_MATRIX_INDEX_ARRAY_SIZE_ARB = $8846;
  GL_MATRIX_INDEX_ARRAY_TYPE_ARB = $8847;
  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = $8848;
  GL_MATRIX_INDEX_ARRAY_POINTER_ARB = $8849;
var
  glCurrentPaletteMatrixARB: procedure(index: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMatrixIndexubvARB: procedure(size: GLint; indices: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMatrixIndexusvARB: procedure(size: GLint; indices: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMatrixIndexuivARB: procedure(size: GLint; indices: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMatrixIndexPointerARB: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_matrix_palette: Boolean;

//***** GL_NV_element_array *****//
const
  GL_ELEMENT_ARRAY_TYPE_NV = $8769;
  GL_ELEMENT_ARRAY_POINTER_NV = $876A;
var
  glElementPointerNV: procedure(_type: GLenum; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawElementArrayNV: procedure(mode: GLenum; first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawRangeElementArrayNV: procedure(mode: GLenum; start: GLuint; _end: GLuint; first: GLint; count: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawElementArrayNV: procedure(mode: GLenum; const first: PGLint; const count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawRangeElementArrayNV: procedure(mode: GLenum; start: GLuint; _end: GLuint; const first: PGLint; const count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_element_array: Boolean;

//***** GL_NV_float_buffer *****//
const
  GL_FLOAT_R_NV = $8880;
  GL_FLOAT_RG_NV = $8881;
  GL_FLOAT_RGB_NV = $8882;
  GL_FLOAT_RGBA_NV = $8883;
  GL_FLOAT_R16_NV = $8884;
  GL_FLOAT_R32_NV = $8885;
  GL_FLOAT_RG16_NV = $8886;
  GL_FLOAT_RG32_NV = $8887;
  GL_FLOAT_RGB16_NV = $8888;
  GL_FLOAT_RGB32_NV = $8889;
  GL_FLOAT_RGBA16_NV = $888A;
  GL_FLOAT_RGBA32_NV = $888B;
  GL_TEXTURE_FLOAT_COMPONENTS_NV = $888C;
  GL_FLOAT_CLEAR_COLOR_VALUE_NV = $888D;
  GL_FLOAT_RGBA_MODE_NV = $888E;
{$IFDEF msWindows}
  WGL_FLOAT_COMPONENTS_NV = $20B0;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV = $20B1;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV = $20B2;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV = $20B3;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV = $20B4;
  WGL_TEXTURE_FLOAT_R_NV = $20B5;
  WGL_TEXTURE_FLOAT_RG_NV = $20B6;
  WGL_TEXTURE_FLOAT_RGB_NV = $20B7;
  WGL_TEXTURE_FLOAT_RGBA_NV = $20B8;
{$ENDIF}

function Load_GL_NV_float_buffer: Boolean;

//***** GL_NV_fragment_program *****//
const
  GL_FRAGMENT_PROGRAM_NV = $8870;
  GL_MAX_TEXTURE_COORDS_NV = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_NV = $8872;
  GL_FRAGMENT_PROGRAM_BINDING_NV = $8873;
  GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = $8868;
  GL_PROGRAM_ERROR_STRING_NV = $8874;
var
  glProgramNamedParameter4fNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramNamedParameter4dNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramNamedParameterfvNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramNamedParameterdvNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  // glProgramLocalParameter4dARB  { already defined }
  // glProgramLocalParameter4dvARB  { already defined }
  // glProgramLocalParameter4fARB  { already defined }
  // glProgramLocalParameter4fvARB  { already defined }
  // glGetProgramLocalParameterdvARB  { already defined }
  // glGetProgramLocalParameterfvARB  { already defined }

function Load_GL_NV_fragment_program: Boolean;

//***** GL_NV_primitive_restart *****//
const
  GL_PRIMITIVE_RESTART_NV = $8558;
  GL_PRIMITIVE_RESTART_INDEX_NV = $8559;
var
  glPrimitiveRestartNV: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPrimitiveRestartIndexNV: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_primitive_restart: Boolean;

//***** GL_NV_vertex_program2 *****//

function Load_GL_NV_vertex_program2: Boolean;

{$IFDEF msWindows}
//***** WGL_NV_render_texture_rectangle *****//
const
  WGL_BIND_TO_TEXTURE_RECTANGLE_RGB_NV = $20A0;
  WGL_BIND_TO_TEXTURE_RECTANGLE_RGBA_NV = $20A1;
  WGL_TEXTURE_RECTANGLE_NV = $20A2;

function Load_WGL_NV_render_texture_rectangle: Boolean;
{$ENDIF}

//***** GL_NV_pixel_data_range *****//
const
  GL_WRITE_PIXEL_DATA_RANGE_NV = $8878;
  GL_READ_PIXEL_DATA_RANGE_NV = $8879;
  GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = $887A;
  GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = $887B;
  GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = $887C;
  GL_READ_PIXEL_DATA_RANGE_POINTER_NV = $887D;
var
  glPixelDataRangeNV: procedure(target: GLenum; length: GLsizei; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFlushPixelDataRangeNV: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  // wglAllocateMemoryNV  { already defined }
  // wglFreeMemoryNV  { already defined }

function Load_GL_NV_pixel_data_range: Boolean;

//***** GL_EXT_texture_rectangle *****//
const
  GL_TEXTURE_RECTANGLE_EXT = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_EXT = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_EXT = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_EXT = $84F8;

function Load_GL_EXT_texture_rectangle: Boolean;

//***** GL_S3_s3tc *****//
const
  GL_RGB_S3TC = $83A0;
  GL_RGB4_S3TC = $83A1;
  GL_RGBA_S3TC = $83A2;
  GL_RGBA4_S3TC = $83A3;

function Load_GL_S3_s3tc: Boolean;

//***** GL_ATI_draw_buffers *****//
const
  GL_MAX_DRAW_BUFFERS_ATI = $8824;
  GL_DRAW_BUFFER0_ATI = $8825;
  GL_DRAW_BUFFER1_ATI = $8826;
  GL_DRAW_BUFFER2_ATI = $8827;
  GL_DRAW_BUFFER3_ATI = $8828;
  GL_DRAW_BUFFER4_ATI = $8829;
  GL_DRAW_BUFFER5_ATI = $882A;
  GL_DRAW_BUFFER6_ATI = $882B;
  GL_DRAW_BUFFER7_ATI = $882C;
  GL_DRAW_BUFFER8_ATI = $882D;
  GL_DRAW_BUFFER9_ATI = $882E;
  GL_DRAW_BUFFER10_ATI = $882F;
  GL_DRAW_BUFFER11_ATI = $8830;
  GL_DRAW_BUFFER12_ATI = $8831;
  GL_DRAW_BUFFER13_ATI = $8832;
  GL_DRAW_BUFFER14_ATI = $8833;
  GL_DRAW_BUFFER15_ATI = $8834;
var
  glDrawBuffersATI: procedure(n: GLsizei; const bufs: PGLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_draw_buffers: Boolean;

{$IFDEF msWindows}
//***** WGL_ATI_pixel_format_float *****//
const
  WGL_RGBA_FLOAT_MODE_ATI = $8820;
  WGL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = $8835;
  WGL_TYPE_RGBA_FLOAT_ATI = $21A0;

function Load_WGL_ATI_pixel_format_float: Boolean;
{$ENDIF}

//***** GL_ATI_texture_env_combine3 *****//
const
  GL_MODULATE_ADD_ATI = $8744;
  GL_MODULATE_SIGNED_ADD_ATI = $8745;
  GL_MODULATE_SUBTRACT_ATI = $8746;

function Load_GL_ATI_texture_env_combine3: Boolean;

//***** GL_ATI_texture_float *****//
const
  GL_RGBA_FLOAT32_ATI = $8814;
  GL_RGB_FLOAT32_ATI = $8815;
  GL_ALPHA_FLOAT32_ATI = $8816;
  GL_INTENSITY_FLOAT32_ATI = $8817;
  GL_LUMINANCE_FLOAT32_ATI = $8818;
  GL_LUMINANCE_ALPHA_FLOAT32_ATI = $8819;
  GL_RGBA_FLOAT16_ATI = $881A;
  GL_RGB_FLOAT16_ATI = $881B;
  GL_ALPHA_FLOAT16_ATI = $881C;
  GL_INTENSITY_FLOAT16_ATI = $881D;
  GL_LUMINANCE_FLOAT16_ATI = $881E;
  GL_LUMINANCE_ALPHA_FLOAT16_ATI = $881F;

function Load_GL_ATI_texture_float: Boolean;

//***** GL_NV_texture_expand_normal *****//
const
  GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = $888F;

function Load_GL_NV_texture_expand_normal: Boolean;

//***** GL_NV_half_float *****//
const
  GL_HALF_FLOAT_NV = $140B;
var
  glVertex2hNV: procedure(x: GLushort; y: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertex2hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertex3hNV: procedure(x: GLushort; y: GLushort; z: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertex3hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertex4hNV: procedure(x: GLushort; y: GLushort; z: GLushort; w: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertex4hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormal3hNV: procedure(nx: GLushort; ny: GLushort; nz: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormal3hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor3hNV: procedure(red: GLushort; green: GLushort; blue: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor3hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4hNV: procedure(red: GLushort; green: GLushort; blue: GLushort; alpha: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColor4hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord1hNV: procedure(s: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord1hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2hNV: procedure(s: GLushort; t: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord2hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord3hNV: procedure(s: GLushort; t: GLushort; r: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord3hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4hNV: procedure(s: GLushort; t: GLushort; r: GLushort; q: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoord4hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1hNV: procedure(target: GLenum; s: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord1hvNV: procedure(target: GLenum; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2hNV: procedure(target: GLenum; s: GLushort; t: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord2hvNV: procedure(target: GLenum; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3hNV: procedure(target: GLenum; s: GLushort; t: GLushort; r: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord3hvNV: procedure(target: GLenum; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4hNV: procedure(target: GLenum; s: GLushort; t: GLushort; r: GLushort; q: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoord4hvNV: procedure(target: GLenum; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordhNV: procedure(fog: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordhvNV: procedure(const fog: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3hNV: procedure(red: GLushort; green: GLushort; blue: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3hvNV: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexWeighthNV: procedure(weight: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexWeighthvNV: procedure(const weight: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1hNV: procedure(index: GLuint; x: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1hvNV: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2hNV: procedure(index: GLuint; x: GLushort; y: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2hvNV: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3hNV: procedure(index: GLuint; x: GLushort; y: GLushort; z: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3hvNV: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4hNV: procedure(index: GLuint; x: GLushort; y: GLushort; z: GLushort; w: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4hvNV: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs1hvNV: procedure(index: GLuint; n: GLsizei; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs2hvNV: procedure(index: GLuint; n: GLsizei; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs3hvNV: procedure(index: GLuint; n: GLsizei; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribs4hvNV: procedure(index: GLuint; n: GLsizei; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_NV_half_float: Boolean;

//***** GL_ATI_map_object_buffer *****//
var
  glMapObjectBufferATI: function(buffer: GLuint): PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUnmapObjectBufferATI: procedure(buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_map_object_buffer: Boolean;

//***** GL_ATI_separate_stencil *****//
const
  GL_KEEP = $1E00;
  GL_ZERO = $0000;
  GL_REPLACE = $1E01;
  GL_INCR = $1E02;
  GL_DECR = $1E03;
  GL_INVERT = $150A;
  GL_NEVER = $0200;
  GL_LESS = $0201;
  GL_LEQUAL = $0203;
  GL_GREATER = $0204;
  GL_GEQUAL = $0206;
  GL_EQUAL = $0202;
  GL_NOTEQUAL = $0205;
  GL_ALWAYS = $0207;
  GL_FRONT = $0404;
  GL_BACK = $0405;
  GL_FRONT_AND_BACK = $0408;
  GL_STENCIL_BACK_FUNC_ATI = $8800;
  GL_STENCIL_BACK_FAIL_ATI = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = $8803;
var
  glStencilOpSeparateATI: procedure(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glStencilFuncSeparateATI: procedure(frontfunc: GLenum; backfunc: GLenum; ref: GLint; mask: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_separate_stencil: Boolean;

//***** GL_ATI_vertex_attrib_array_object *****//
var
  glVertexAttribArrayObjectATI: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; buffer: GLuint; offset: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribArrayObjectfvATI: procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribArrayObjectivATI: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ATI_vertex_attrib_array_object: Boolean;

//***** GL_ARB_occlusion_query *****//
const
  GL_SAMPLES_PASSED_ARB = $8914;
  GL_QUERY_COUNTER_BITS_ARB = $8864;
  GL_CURRENT_QUERY_ARB = $8865;
  GL_QUERY_RESULT_ARB = $8866;
  GL_QUERY_RESULT_AVAILABLE_ARB = $8867;
var
  glGenQueriesARB: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteQueriesARB: procedure(n: GLsizei; const ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsQueryARB: function(id: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginQueryARB: procedure(target: GLenum; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndQueryARB: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryivARB: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjectivARB: procedure(id: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjectuivARB: procedure(id: GLuint; pname: GLenum; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_occlusion_query: Boolean;

//***** GL_ARB_shader_objects *****//
const
  GL_PROGRAM_OBJECT_ARB = $8B40;
  GL_OBJECT_TYPE_ARB = $8B4E;
  GL_OBJECT_SUBTYPE_ARB = $8B4F;
  GL_OBJECT_DELETE_STATUS_ARB = $8B80;
  GL_OBJECT_COMPILE_STATUS_ARB = $8B81;
  GL_OBJECT_LINK_STATUS_ARB = $8B82;
  GL_OBJECT_VALIDATE_STATUS_ARB = $8B83;
  GL_OBJECT_INFO_LOG_LENGTH_ARB = $8B84;
  GL_OBJECT_ATTACHED_OBJECTS_ARB = $8B85;
  GL_OBJECT_ACTIVE_UNIFORMS_ARB = $8B86;
  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = $8B87;
  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = $8B88;
  GL_SHADER_OBJECT_ARB = $8B48;
  GL_FLOAT = $1406;
  GL_FLOAT_VEC2_ARB = $8B50;
  GL_FLOAT_VEC3_ARB = $8B51;
  GL_FLOAT_VEC4_ARB = $8B52;
  GL_INT = $1404;
  GL_INT_VEC2_ARB = $8B53;
  GL_INT_VEC3_ARB = $8B54;
  GL_INT_VEC4_ARB = $8B55;
  GL_BOOL_ARB = $8B56;
  GL_BOOL_VEC2_ARB = $8B57;
  GL_BOOL_VEC3_ARB = $8B58;
  GL_BOOL_VEC4_ARB = $8B59;
  GL_FLOAT_MAT2_ARB = $8B5A;
  GL_FLOAT_MAT3_ARB = $8B5B;
  GL_FLOAT_MAT4_ARB = $8B5C;
var
  glDeleteObjectARB: procedure(obj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetHandleARB: function(pname: GLenum): GLhandleARB; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDetachObjectARB: procedure(containerObj: GLhandleARB; attachedObj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCreateShaderObjectARB: function(shaderType: GLenum): GLhandleARB; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glShaderSourceARB: procedure(shaderObj: GLhandleARB; count: GLsizei; const _string: PGLvoid; const length: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompileShaderARB: procedure(shaderObj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCreateProgramObjectARB: function(): GLhandleARB; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAttachObjectARB: procedure(containerObj: GLhandleARB; obj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLinkProgramARB: procedure(programObj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUseProgramObjectARB: procedure(programObj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glValidateProgramARB: procedure(programObj: GLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1fARB: procedure(location: GLint; v0: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2fARB: procedure(location: GLint; v0: GLfloat; v1: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3fARB: procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4fARB: procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1iARB: procedure(location: GLint; v0: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2iARB: procedure(location: GLint; v0: GLint; v1: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3iARB: procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4iARB: procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1fvARB: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2fvARB: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3fvARB: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4fvARB: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1ivARB: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2ivARB: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3ivARB: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4ivARB: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2fvARB: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3fvARB: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4fvARB: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetObjectParameterfvARB: procedure(obj: GLhandleARB; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetObjectParameterivARB: procedure(obj: GLhandleARB; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetInfoLogARB: procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; infoLog: PGLcharARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetAttachedObjectsARB: procedure(containerObj: GLhandleARB; maxCount: GLsizei; count: PGLsizei; obj: PGLhandleARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformLocationARB: function(programObj: GLhandleARB; const name: PGLcharARB): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniformARB: procedure(programObj: GLhandleARB; index: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLcharARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformfvARB: procedure(programObj: GLhandleARB; location: GLint; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformivARB: procedure(programObj: GLhandleARB; location: GLint; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetShaderSourceARB: procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; source: PGLcharARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_shader_objects: Boolean;

//***** GL_ARB_vertex_shader *****//
const
  GL_VERTEX_SHADER_ARB = $8B31;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = $8B4A;
  GL_MAX_VARYING_FLOATS_ARB = $8B4B;
  // GL_MAX_VERTEX_ATTRIBS_ARB  { already defined }
  // GL_MAX_TEXTURE_IMAGE_UNITS_ARB  { already defined }
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = $8B4D;
  // GL_MAX_TEXTURE_COORDS_ARB  { already defined }
  // GL_VERTEX_PROGRAM_POINT_SIZE_ARB  { already defined }
  // GL_VERTEX_PROGRAM_TWO_SIDE_ARB  { already defined }
  // GL_OBJECT_TYPE_ARB  { already defined }
  // GL_OBJECT_SUBTYPE_ARB  { already defined }
  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = $8B89;
  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = $8B8A;
  // GL_SHADER_OBJECT_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB  { already defined }
  // GL_CURRENT_VERTEX_ATTRIB_ARB  { already defined }
  // GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB  { already defined }
  // GL_FLOAT  { already defined }
  // GL_FLOAT_VEC2_ARB  { already defined }
  // GL_FLOAT_VEC3_ARB  { already defined }
  // GL_FLOAT_VEC4_ARB  { already defined }
  // GL_FLOAT_MAT2_ARB  { already defined }
  // GL_FLOAT_MAT3_ARB  { already defined }
  // GL_FLOAT_MAT4_ARB  { already defined }
  // glVertexAttrib1fARB  { already defined }
  // glVertexAttrib1sARB  { already defined }
  // glVertexAttrib1dARB  { already defined }
  // glVertexAttrib2fARB  { already defined }
  // glVertexAttrib2sARB  { already defined }
  // glVertexAttrib2dARB  { already defined }
  // glVertexAttrib3fARB  { already defined }
  // glVertexAttrib3sARB  { already defined }
  // glVertexAttrib3dARB  { already defined }
  // glVertexAttrib4fARB  { already defined }
  // glVertexAttrib4sARB  { already defined }
  // glVertexAttrib4dARB  { already defined }
  // glVertexAttrib4NubARB  { already defined }
  // glVertexAttrib1fvARB  { already defined }
  // glVertexAttrib1svARB  { already defined }
  // glVertexAttrib1dvARB  { already defined }
  // glVertexAttrib2fvARB  { already defined }
  // glVertexAttrib2svARB  { already defined }
  // glVertexAttrib2dvARB  { already defined }
  // glVertexAttrib3fvARB  { already defined }
  // glVertexAttrib3svARB  { already defined }
  // glVertexAttrib3dvARB  { already defined }
  // glVertexAttrib4fvARB  { already defined }
  // glVertexAttrib4svARB  { already defined }
  // glVertexAttrib4dvARB  { already defined }
  // glVertexAttrib4ivARB  { already defined }
  // glVertexAttrib4bvARB  { already defined }
  // glVertexAttrib4ubvARB  { already defined }
  // glVertexAttrib4usvARB  { already defined }
  // glVertexAttrib4uivARB  { already defined }
  // glVertexAttrib4NbvARB  { already defined }
  // glVertexAttrib4NsvARB  { already defined }
  // glVertexAttrib4NivARB  { already defined }
  // glVertexAttrib4NubvARB  { already defined }
  // glVertexAttrib4NusvARB  { already defined }
  // glVertexAttrib4NuivARB  { already defined }
  // glVertexAttribPointerARB  { already defined }
  // glEnableVertexAttribArrayARB  { already defined }
  // glDisableVertexAttribArrayARB  { already defined }
var
  glBindAttribLocationARB: procedure(programObj: GLhandleARB; index: GLuint; const name: PGLcharARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveAttribARB: procedure(programObj: GLhandleARB; index: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLcharARB); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetAttribLocationARB: function(programObj: GLhandleARB; const name: PGLcharARB): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  // glGetVertexAttribdvARB  { already defined }
  // glGetVertexAttribfvARB  { already defined }
  // glGetVertexAttribivARB  { already defined }
  // glGetVertexAttribPointervARB  { already defined }

function Load_GL_ARB_vertex_shader: Boolean;

//***** GL_ARB_fragment_shader *****//
const
  GL_FRAGMENT_SHADER_ARB = $8B30;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = $8B49;
  // GL_MAX_TEXTURE_COORDS_ARB  { already defined }
  // GL_MAX_TEXTURE_IMAGE_UNITS_ARB  { already defined }
  // GL_OBJECT_TYPE_ARB  { already defined }
  // GL_OBJECT_SUBTYPE_ARB  { already defined }
  // GL_SHADER_OBJECT_ARB  { already defined }

function Load_GL_ARB_fragment_shader: Boolean;

//***** GL_ARB_shading_language_100 *****//

function Load_GL_ARB_shading_language_100: Boolean;

//***** GL_ARB_texture_non_power_of_two *****//

function Load_GL_ARB_texture_non_power_of_two: Boolean;

//***** GL_ARB_point_sprite *****//
const
  GL_POINT_SPRITE_ARB = $8861;
  GL_COORD_REPLACE_ARB = $8862;

function Load_GL_ARB_point_sprite: Boolean;

//***** GL_EXT_depth_bounds_test *****//
const
  GL_DEPTH_BOUNDS_TEST_EXT = $8890;
  GL_DEPTH_BOUNDS_EXT = $8891;
var
  glDepthBoundsEXT: procedure(zmin: GLclampd; zmax: GLclampd); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_depth_bounds_test: Boolean;

//***** GL_EXT_texture_mirror_clamp *****//
const
  GL_MIRROR_CLAMP_EXT = $8742;
  GL_MIRROR_CLAMP_TO_EDGE_EXT = $8743;
  GL_MIRROR_CLAMP_TO_BORDER_EXT = $8912;

function Load_GL_EXT_texture_mirror_clamp: Boolean;

//***** GL_EXT_blend_equation_separate *****//
const
  GL_BLEND_EQUATION_RGB_EXT = $8009;
  GL_BLEND_EQUATION_ALPHA_EXT = $883D;
var
  glBlendEquationSeparateEXT: procedure(modeRGB: GLenum; modeAlpha: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_blend_equation_separate: Boolean;

//***** GL_MESA_pack_invert *****//
const
  GL_PACK_INVERT_MESA = $8758;

function Load_GL_MESA_pack_invert: Boolean;

//***** GL_MESA_ycbcr_texture *****//
const
  GL_YCBCR_MESA = $8757;
  GL_UNSIGNED_SHORT_8_8_MESA = $85BA;
  GL_UNSIGNED_SHORT_8_8_REV_MESA = $85BB;

function Load_GL_MESA_ycbcr_texture: Boolean;

//***** GL_ARB_fragment_program_shadow *****//

function Load_GL_ARB_fragment_program_shadow: Boolean;

//***** GL_NV_fragment_program_option *****//

function Load_GL_NV_fragment_program_option: Boolean;

//***** GL_EXT_pixel_buffer_object *****//
const
  GL_PIXEL_PACK_BUFFER_EXT = $88EB;
  GL_PIXEL_UNPACK_BUFFER_EXT = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING_EXT = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = $88EF;

function Load_GL_EXT_pixel_buffer_object: Boolean;

//***** GL_NV_fragment_program2 *****//
const
  GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = $88F4;
  GL_MAX_PROGRAM_CALL_DEPTH_NV = $88F5;
  GL_MAX_PROGRAM_IF_DEPTH_NV = $88F6;
  GL_MAX_PROGRAM_LOOP_DEPTH_NV = $88F7;
  GL_MAX_PROGRAM_LOOP_COUNT_NV = $88F8;

function Load_GL_NV_fragment_program2: Boolean;

//***** GL_NV_vertex_program2_option *****//
  // GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV  { already defined }
  // GL_MAX_PROGRAM_CALL_DEPTH_NV  { already defined }

function Load_GL_NV_vertex_program2_option: Boolean;

//***** GL_NV_vertex_program3 *****//
  // GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB  { already defined }

function Load_GL_NV_vertex_program3: Boolean;

//***** GL_ARB_draw_buffers *****//
const
  GL_MAX_DRAW_BUFFERS_ARB = $8824;
  GL_DRAW_BUFFER0_ARB = $8825;
  GL_DRAW_BUFFER1_ARB = $8826;
  GL_DRAW_BUFFER2_ARB = $8827;
  GL_DRAW_BUFFER3_ARB = $8828;
  GL_DRAW_BUFFER4_ARB = $8829;
  GL_DRAW_BUFFER5_ARB = $882A;
  GL_DRAW_BUFFER6_ARB = $882B;
  GL_DRAW_BUFFER7_ARB = $882C;
  GL_DRAW_BUFFER8_ARB = $882D;
  GL_DRAW_BUFFER9_ARB = $882E;
  GL_DRAW_BUFFER10_ARB = $882F;
  GL_DRAW_BUFFER11_ARB = $8830;
  GL_DRAW_BUFFER12_ARB = $8831;
  GL_DRAW_BUFFER13_ARB = $8832;
  GL_DRAW_BUFFER14_ARB = $8833;
  GL_DRAW_BUFFER15_ARB = $8834;
var
  glDrawBuffersARB: procedure(n: GLsizei; const bufs: PGLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_draw_buffers: Boolean;

//***** GL_ARB_texture_rectangle *****//
const
  GL_TEXTURE_RECTANGLE_ARB = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_ARB = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_ARB = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = $84F8;

function Load_GL_ARB_texture_rectangle: Boolean;

//***** GL_ARB_color_buffer_float *****//
const
  GL_RGBA_FLOAT_MODE_ARB = $8820;
  GL_CLAMP_VERTEX_COLOR_ARB = $891A;
  GL_CLAMP_FRAGMENT_COLOR_ARB = $891B;
  GL_CLAMP_READ_COLOR_ARB = $891C;
  GL_FIXED_ONLY_ARB = $891D;
  WGL_TYPE_RGBA_FLOAT_ARB = $21A0;
var
  glClampColorARB: procedure(target: GLenum; clamp: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_color_buffer_float: Boolean;

//***** GL_ARB_half_float_pixel *****//
const
  GL_HALF_FLOAT_ARB = $140B;

function Load_GL_ARB_half_float_pixel: Boolean;

//***** GL_ARB_texture_float *****//
const
  GL_TEXTURE_RED_TYPE_ARB = $8C10;
  GL_TEXTURE_GREEN_TYPE_ARB = $8C11;
  GL_TEXTURE_BLUE_TYPE_ARB = $8C12;
  GL_TEXTURE_ALPHA_TYPE_ARB = $8C13;
  GL_TEXTURE_LUMINANCE_TYPE_ARB = $8C14;
  GL_TEXTURE_INTENSITY_TYPE_ARB = $8C15;
  GL_TEXTURE_DEPTH_TYPE_ARB = $8C16;
  GL_UNSIGNED_NORMALIZED_ARB = $8C17;
  GL_RGBA32F_ARB = $8814;
  GL_RGB32F_ARB = $8815;
  GL_ALPHA32F_ARB = $8816;
  GL_INTENSITY32F_ARB = $8817;
  GL_LUMINANCE32F_ARB = $8818;
  GL_LUMINANCE_ALPHA32F_ARB = $8819;
  GL_RGBA16F_ARB = $881A;
  GL_RGB16F_ARB = $881B;
  GL_ALPHA16F_ARB = $881C;
  GL_INTENSITY16F_ARB = $881D;
  GL_LUMINANCE16F_ARB = $881E;
  GL_LUMINANCE_ALPHA16F_ARB = $881F;

function Load_GL_ARB_texture_float: Boolean;

//***** GL_EXT_texture_compression_dxt1 *****//
  // GL_COMPRESSED_RGB_S3TC_DXT1_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT1_EXT  { already defined }

function Load_GL_EXT_texture_compression_dxt1: Boolean;

//***** GL_ARB_pixel_buffer_object *****//
const
  GL_PIXEL_PACK_BUFFER_ARB = $88EB;
  GL_PIXEL_UNPACK_BUFFER_ARB = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING_ARB = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = $88EF;

function Load_GL_ARB_pixel_buffer_object: Boolean;

//***** GL_EXT_framebuffer_object *****//
const
  GL_FRAMEBUFFER_EXT = $8D40;
  GL_RENDERBUFFER_EXT = $8D41;
  GL_STENCIL_INDEX_EXT = $8D45;
  GL_STENCIL_INDEX1_EXT = $8D46;
  GL_STENCIL_INDEX4_EXT = $8D47;
  GL_STENCIL_INDEX8_EXT = $8D48;
  GL_STENCIL_INDEX16_EXT = $8D49;
  GL_RENDERBUFFER_WIDTH_EXT = $8D42;
  GL_RENDERBUFFER_HEIGHT_EXT = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = $8D44;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = $8CD4;
  GL_COLOR_ATTACHMENT0_EXT = $8CE0;
  GL_COLOR_ATTACHMENT1_EXT = $8CE1;
  GL_COLOR_ATTACHMENT2_EXT = $8CE2;
  GL_COLOR_ATTACHMENT3_EXT = $8CE3;
  GL_COLOR_ATTACHMENT4_EXT = $8CE4;
  GL_COLOR_ATTACHMENT5_EXT = $8CE5;
  GL_COLOR_ATTACHMENT6_EXT = $8CE6;
  GL_COLOR_ATTACHMENT7_EXT = $8CE7;
  GL_COLOR_ATTACHMENT8_EXT = $8CE8;
  GL_COLOR_ATTACHMENT9_EXT = $8CE9;
  GL_COLOR_ATTACHMENT10_EXT = $8CEA;
  GL_COLOR_ATTACHMENT11_EXT = $8CEB;
  GL_COLOR_ATTACHMENT12_EXT = $8CEC;
  GL_COLOR_ATTACHMENT13_EXT = $8CED;
  GL_COLOR_ATTACHMENT14_EXT = $8CEE;
  GL_COLOR_ATTACHMENT15_EXT = $8CEF;
  GL_DEPTH_ATTACHMENT_EXT = $8D00;
  GL_STENCIL_ATTACHMENT_EXT = $8D20;
  GL_FRAMEBUFFER_COMPLETE_EXT = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT = $8CD8;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = $8CDA;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = $8CDC;
  GL_FRAMEBUFFER_UNSUPPORTED_EXT = $8CDD;
  GL_FRAMEBUFFER_STATUS_ERROR_EXT = $8CDE;
  GL_FRAMEBUFFER_BINDING_EXT = $8CA6;
  GL_RENDERBUFFER_BINDING_EXT = $8CA7;
  GL_MAX_COLOR_ATTACHMENTS_EXT = $8CDF;
  GL_MAX_RENDERBUFFER_SIZE_EXT = $84E8;
  GL_INVALID_FRAMEBUFFER_OPERATION_EXT = $0506;
var
  glIsRenderbufferEXT: function(renderbuffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindRenderbufferEXT: procedure(target: GLenum; renderbuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteRenderbuffersEXT: procedure(n: GLsizei; const renderbuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenRenderbuffersEXT: procedure(n: GLsizei; renderbuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glRenderbufferStorageEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetRenderbufferParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsFramebufferEXT: function(framebuffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindFramebufferEXT: procedure(target: GLenum; framebuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteFramebuffersEXT: procedure(n: GLsizei; const framebuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenFramebuffersEXT: procedure(n: GLsizei; framebuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCheckFramebufferStatusEXT: function(target: GLenum): GLenum; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture1DEXT: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture2DEXT: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture3DEXT: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferRenderbufferEXT: procedure(target: GLenum; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFramebufferAttachmentParameterivEXT: procedure(target: GLenum; attachment: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenerateMipmapEXT: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_EXT_framebuffer_object: Boolean;

//**** GL_ARB_framebuffer_object *****//
const
  GL_INVALID_FRAMEBUFFER_OPERATION = $0506;
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = $8210;
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = $8211;
  GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = $8212;
  GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = $8213;
  GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = $8214;
  GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = $8215;
  GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = $8216;
  GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = $8217;
  GL_FRAMEBUFFER_DEFAULT = $8218;
  GL_FRAMEBUFFER_UNDEFINED = $8219;
  GL_DEPTH_STENCIL_ATTACHMENT = $821A;
  GL_MAX_RENDERBUFFER_SIZE = $84E8;
  GL_DEPTH_STENCIL = $84F9;
  GL_UNSIGNED_INT_24_8 = $84FA;
  GL_DEPTH24_STENCIL8 = $88F0;
  GL_TEXTURE_STENCIL_SIZE = $88F1;
  GL_TEXTURE_RED_TYPE = $8C10;
  GL_TEXTURE_GREEN_TYPE = $8C11;
  GL_TEXTURE_BLUE_TYPE = $8C12;
  GL_TEXTURE_ALPHA_TYPE = $8C13;
  GL_TEXTURE_DEPTH_TYPE = $8C16;
  GL_UNSIGNED_NORMALIZED = $8C17;
  GL_FRAMEBUFFER_BINDING = $8CA6;
  GL_DRAW_FRAMEBUFFER_BINDING = GL_FRAMEBUFFER_BINDING;
  GL_RENDERBUFFER_BINDING = $8CA7;
  GL_READ_FRAMEBUFFER = $8CA8;
  GL_DRAW_FRAMEBUFFER = $8CA9;
  GL_READ_FRAMEBUFFER_BINDING = $8CAA;
  GL_RENDERBUFFER_SAMPLES = $8CAB;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = $8CD4;
  GL_FRAMEBUFFER_COMPLETE = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = $8CDC;
  GL_FRAMEBUFFER_UNSUPPORTED = $8CDD;
  GL_MAX_COLOR_ATTACHMENTS = $8CDF;
  GL_COLOR_ATTACHMENT0 = $8CE0;
  GL_COLOR_ATTACHMENT1 = $8CE1;
  GL_COLOR_ATTACHMENT2 = $8CE2;
  GL_COLOR_ATTACHMENT3 = $8CE3;
  GL_COLOR_ATTACHMENT4 = $8CE4;
  GL_COLOR_ATTACHMENT5 = $8CE5;
  GL_COLOR_ATTACHMENT6 = $8CE6;
  GL_COLOR_ATTACHMENT7 = $8CE7;
  GL_COLOR_ATTACHMENT8 = $8CE8;
  GL_COLOR_ATTACHMENT9 = $8CE9;
  GL_COLOR_ATTACHMENT10 = $8CEA;
  GL_COLOR_ATTACHMENT11 = $8CEB;
  GL_COLOR_ATTACHMENT12 = $8CEC;
  GL_COLOR_ATTACHMENT13 = $8CED;
  GL_COLOR_ATTACHMENT14 = $8CEE;
  GL_COLOR_ATTACHMENT15 = $8CEF;
  GL_DEPTH_ATTACHMENT = $8D00;
  GL_STENCIL_ATTACHMENT = $8D20;
  GL_FRAMEBUFFER = $8D40;
  GL_RENDERBUFFER = $8D41;
  GL_RENDERBUFFER_WIDTH = $8D42;
  GL_RENDERBUFFER_HEIGHT = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT = $8D44;
  GL_STENCIL_INDEX1 = $8D46;
  GL_STENCIL_INDEX4 = $8D47;
  GL_STENCIL_INDEX8 = $8D48;
  GL_STENCIL_INDEX16 = $8D49;
  GL_RENDERBUFFER_RED_SIZE = $8D50;
  GL_RENDERBUFFER_GREEN_SIZE = $8D51;
  GL_RENDERBUFFER_BLUE_SIZE = $8D52;
  GL_RENDERBUFFER_ALPHA_SIZE = $8D53;
  GL_RENDERBUFFER_DEPTH_SIZE = $8D54;
  GL_RENDERBUFFER_STENCIL_SIZE = $8D55;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = $8D56;
  GL_MAX_SAMPLES = $8D57;
var
  glIsRenderbuffer: function(renderbuffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindRenderbuffer: procedure(target: GLenum; renderbuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteRenderbuffers: procedure(n: GLsizei; const renderbuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenRenderbuffers: procedure(n: GLsizei; renderbuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glRenderbufferStorage: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetRenderbufferParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsFramebuffer: function(framebuffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindFramebuffer: procedure(target: GLenum; framebuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteFramebuffers: procedure(n: GLsizei; const framebuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenFramebuffers: procedure(n: GLsizei; framebuffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCheckFramebufferStatus: function(target: GLenum): GLenum; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture1D: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture2D: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture3D: procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferRenderbuffer: procedure(target: GLenum; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFramebufferAttachmentParameteriv: procedure(target: GLenum; attachment: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenerateMipmap: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBlitFramebuffer: procedure(srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glRenderbufferStorageMultisample: procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTextureLayer: procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_framebuffer_object(): Boolean;

//**** GL_ARB_framebuffer_object DEPRECATED *****//
const
  GL_INDEX = $8222;
  GL_TEXTURE_LUMINANCE_TYPE = $8C14;
  GL_TEXTURE_INTENSITY_TYPE = $8C15;


//**** GL_ARB_map_buffer_range *****//
const
  GL_MAP_READ_BIT = $0001;
  GL_MAP_WRITE_BIT = $0002;
  GL_MAP_INVALIDATE_RANGE_BIT = $0004;
  GL_MAP_INVALIDATE_BUFFER_BIT = $0008;
  GL_MAP_FLUSH_EXPLICIT_BIT = $0010;
  GL_MAP_UNSYNCHRONIZED_BIT = $0020;
var
  glMapBufferRange: function(target: GLenum; offset: GLintptr; length: GLsizeiptr; access: GLbitfield): PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFlushMappedBufferRange: procedure(target: GLenum; offset: GLintptr; length: GLsizeiptr); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_map_buffer_range(): Boolean;

//**** GL_ARB_vertex_array_object *****//
const
  GL_VERTEX_ARRAY_BINDING = $85B5;
var
  glBindVertexArray: procedure(_array: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteVertexArrays: procedure(n: GLsizei; const arrays: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenVertexArrays: procedure(n: GLsizei; arrays: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsVertexArray: function(_array: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_vertex_array_object(): Boolean;

//**** GL_ARB_copy_buffer *****//
const
  GL_COPY_READ_BUFFER = $8F36;
  GL_COPY_WRITE_BUFFER = $8F37;
var
  glCopyBufferSubData: procedure(readTarget: GLenum; writeTarget: GLenum; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_copy_buffer(): Boolean;

//**** GL_ARB_uniform_buffer_object *****//
const
  GL_UNIFORM_BUFFER = $8A11;
  GL_UNIFORM_BUFFER_BINDING = $8A28;
  GL_UNIFORM_BUFFER_START = $8A29;
  GL_UNIFORM_BUFFER_SIZE = $8A2A;
  GL_MAX_VERTEX_UNIFORM_BLOCKS = $8A2B;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS = $8A2C;
  GL_MAX_FRAGMENT_UNIFORM_BLOCKS = $8A2D;
  GL_MAX_COMBINED_UNIFORM_BLOCKS = $8A2E;
  GL_MAX_UNIFORM_BUFFER_BINDINGS = $8A2F;
  GL_MAX_UNIFORM_BLOCK_SIZE = $8A30;
  GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = $8A31;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = $8A32;
  GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = $8A33;
  GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = $8A34;
  GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = $8A35;
  GL_ACTIVE_UNIFORM_BLOCKS = $8A36;
  GL_UNIFORM_TYPE = $8A37;
  GL_UNIFORM_SIZE = $8A38;
  GL_UNIFORM_NAME_LENGTH = $8A39;
  GL_UNIFORM_BLOCK_INDEX = $8A3A;
  GL_UNIFORM_OFFSET = $8A3B;
  GL_UNIFORM_ARRAY_STRIDE = $8A3C;
  GL_UNIFORM_MATRIX_STRIDE = $8A3D;
  GL_UNIFORM_IS_ROW_MAJOR = $8A3E;
  GL_UNIFORM_BLOCK_BINDING = $8A3F;
  GL_UNIFORM_BLOCK_DATA_SIZE = $8A40;
  GL_UNIFORM_BLOCK_NAME_LENGTH = $8A41;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = $8A42;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = $8A43;
  GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = $8A44;
  GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = $8A45;
  GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = $8A46;
  GL_INVALID_INDEX = DWord($FFFFFFFF);
var
  glGetUniformIndices: procedure(_program: GLuint; uniformCount: GLsizei; const uniformNames: PPGLchar; uniformIndices: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniformsiv: procedure(_program: GLuint; uniformCount: GLsizei; const uniformIndices: PGLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniformName: procedure(_program: GLuint; uniformIndex: GLuint; bufSize: GLsizei; length: PGLsizei; uniformName: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformBlockIndex: function(_program: GLuint; const uniformBlockName: PGLchar): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniformBlockiv: procedure(_program: GLuint; uniformBlockIndex: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniformBlockName: procedure(_program: GLuint; uniformBlockIndex: GLuint; bufSize: GLsizei; length: PGLsizei; uniformBlockName: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformBlockBinding: procedure(_program: GLuint; uniformBlockIndex: GLuint; uniformBlockBinding: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_uniform_buffer_object(): Boolean;

//**** GL_ARB_draw_elements_base_vertex *****//
var
  glDrawElementsBaseVertex: procedure(mode: GLenum; count: GLsizei; _type: GLenum; const indices: PGLvoid; basevertex: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawRangeElementsBaseVertex: procedure(mode: GLenum; start: GLuint; _end: GLuint; count: GLsizei; _type: GLenum; const indices: PGLvoid; basevertex: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawElementsInstancedBaseVertex: procedure(mode: GLenum; count: GLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei; basevertex: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawElementsBaseVertex: procedure(mode: GLenum; const count: PGLsizei; _type: GLenum; const indices: PPGLvoid; primcount: GLsizei; const basevertex: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_draw_elements_base_vertex(): Boolean;

//**** GL_ARB_provoking_vertex *****//
const
  GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = $8E4C;
  GL_FIRST_VERTEX_CONVENTION = $8E4D;
  GL_LAST_VERTEX_CONVENTION = $8E4E;
  GL_PROVOKING_VERTEX = $8E4F;
var
  glProvokingVertex: procedure(mode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_provoking_vertex(): Boolean;

//**** GL_ARB_sync *****//
type
  GLsync = Pointer;
  TGLsync = GLSync;
  PGLsync = ^GLSync;

const
  GL_MAX_SERVER_WAIT_TIMEOUT = $9111;
  GL_OBJECT_TYPE = $9112;
  GL_SYNC_CONDITION = $9113;
  GL_SYNC_STATUS = $9114;
  GL_SYNC_FLAGS = $9115;
  GL_SYNC_FENCE = $9116;
  GL_SYNC_GPU_COMMANDS_COMPLETE = $9117;
  GL_UNSIGNALED = $9118;
  GL_SIGNALED = $9119;
  GL_ALREADY_SIGNALED = $911A;
  GL_TIMEOUT_EXPIRED = $911B;
  GL_CONDITION_SATISFIED = $911C;
  GL_WAIT_FAILED = $911D;
  GL_SYNC_FLUSH_COMMANDS_BIT = $00000001;
  GL_TIMEOUT_IGNORED = QWord($FFFFFFFFFFFFFFFF);
var
  glFenceSync: function(condition: GLenum; flags: GLbitfield): GLsync; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsSync: function(sync: GLsync): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteSync: procedure(sync: GLsync); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClientWaitSync: function(sync: GLsync; flags: GLbitfield; timeout: GLuint64): GLenum; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWaitSync: procedure(sync: GLsync; flags: GLbitfield; timeout: GLuint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetInteger64v: procedure(pname: GLenum; params: PGLint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSynciv: procedure(sync: GLsync; pname: GLenum; bufSize: GLsizei; length: PGLsizei; values: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_sync(): Boolean;

//**** GL_ARB_texture_multisample *****//
const
  GL_SAMPLE_POSITION = $8E50;
  GL_SAMPLE_MASK = $8E51;
  GL_SAMPLE_MASK_VALUE = $8E52;
  GL_MAX_SAMPLE_MASK_WORDS = $8E59;
  GL_TEXTURE_2D_MULTISAMPLE = $9100;
  GL_PROXY_TEXTURE_2D_MULTISAMPLE = $9101;
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY = $9102;
  GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = $9103;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE = $9104;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = $9105;
  GL_TEXTURE_SAMPLES = $9106;
  GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = $9107;
  GL_SAMPLER_2D_MULTISAMPLE = $9108;
  GL_INT_SAMPLER_2D_MULTISAMPLE = $9109;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = $910A;
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY = $910B;
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910C;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910D;
  GL_MAX_COLOR_TEXTURE_SAMPLES = $910E;
  GL_MAX_DEPTH_TEXTURE_SAMPLES = $910F;
  GL_MAX_INTEGER_SAMPLES = $9110;
var
  glTexImage2DMultisample: procedure(target: GLenum; samples: GLsizei; internalformat: GLint; width: GLsizei; height: GLsizei; fixedsamplelocations: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexImage3DMultisample: procedure(target: GLenum; samples: GLsizei; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetMultisamplefv: procedure(pname: GLenum; index: GLuint; val: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSampleMaski: procedure(index: GLuint; mask: GLbitfield); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_texture_multisample(): Boolean;

//**** GL_ARB_blend_func_extended *****//
const
  GL_SRC1_COLOR = $88F9;
// reuse GL_SRC1_ALPHA
const
  GL_ONE_MINUS_SRC1_COLOR = $88FA;
  GL_ONE_MINUS_SRC1_ALPHA = $88FB;
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = $88FC;
var
  glBindFragDataLocationIndexed: procedure(_program: GLuint; colorNumber: GLuint; index: GLuint; const name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFragDataIndex: function(_program: GLuint; const name: PGLchar): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_blend_func_extended(): Boolean;

//**** GL_ARB_sampler_objects *****//
const
  GL_SAMPLER_BINDING = $8919;
var
  glGenSamplers: procedure(count: GLsizei; samplers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteSamplers: procedure(count: GLsizei; const samplers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsSampler: function(sampler: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindSampler: procedure(_unit: GLenum; sampler: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameteri: procedure(sampler: GLuint; pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameteriv: procedure(sampler: GLuint; pname: GLenum; const param: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameterf: procedure(sampler: GLuint; pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameterfv: procedure(sampler: GLuint; pname: GLenum; const param: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameterIiv: procedure(sampler: GLuint; pname: GLenum; const param: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSamplerParameterIuiv: procedure(sampler: GLuint; pname: GLenum; const param: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSamplerParameteriv: procedure(sampler: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSamplerParameterIiv: procedure(sampler: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSamplerParameterfv: procedure(sampler: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSamplerParameterIfv: procedure(sampler: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_sampler_objects(): Boolean;

//**** GL_ARB_timer_query *****//
const
  GL_TIME_ELAPSED = $88BF;
  GL_TIMESTAMP = $8E28;
var
  glQueryCounter: procedure(id: GLuint; target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjecti64v: procedure(id: GLuint; pname: GLenum; params: PGLint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjectui64v: procedure(id: GLuint; pname: GLenum; params: PGLuint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_timer_query(): Boolean;

//**** GL_ARB_vertex_type_2_10_10_10_rev *****//

const
  GL_INT_2_10_10_10_REV = $8D9F;
var
  glVertexP2ui: procedure(_type: GLenum; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexP2uiv: procedure(_type: GLenum; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexP3ui: procedure(_type: GLenum; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexP3uiv: procedure(_type: GLenum; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexP4ui: procedure(_type: GLenum; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexP4uiv: procedure(_type: GLenum; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP1ui: procedure(_type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP1uiv: procedure(_type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP2ui: procedure(_type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP2uiv: procedure(_type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP3ui: procedure(_type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP3uiv: procedure(_type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP4ui: procedure(_type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexCoordP4uiv: procedure(_type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP1ui: procedure(texture: GLenum; _type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP1uiv: procedure(texture: GLenum; _type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP2ui: procedure(texture: GLenum; _type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP2uiv: procedure(texture: GLenum; _type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP3ui: procedure(texture: GLenum; _type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP3uiv: procedure(texture: GLenum; _type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP4ui: procedure(texture: GLenum; _type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiTexCoordP4uiv: procedure(texture: GLenum; _type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalP3ui: procedure(_type: GLenum; coords: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glNormalP3uiv: procedure(_type: GLenum; const coords: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorP3ui: procedure(_type: GLenum; color: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorP3uiv: procedure(_type: GLenum; const color: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorP4ui: procedure(_type: GLenum; color: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glColorP4uiv: procedure(_type: GLenum; const color: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColorP3ui: procedure(_type: GLenum; color: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColorP3uiv: procedure(_type: GLenum; const color: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP1ui: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP1uiv: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP2ui: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP2uiv: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP3ui: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP3uiv: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP4ui: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; value: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribP4uiv: procedure(index: GLuint; _type: GLenum; normalized: GLboolean; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_vertex_type_2_10_10_10_rev(): Boolean;

//**** GL_ARB_gpu_shader_fp64 *****//
// reuse GL_DOUBLE
const
  GL_DOUBLE_VEC2 = $8FFC;
  GL_DOUBLE_VEC3 = $8FFD;
  GL_DOUBLE_VEC4 = $8FFE;
  GL_DOUBLE_MAT2 = $8F46;
  GL_DOUBLE_MAT3 = $8F47;
  GL_DOUBLE_MAT4 = $8F48;
  GL_DOUBLE_MAT2x3 = $8F49;
  GL_DOUBLE_MAT2x4 = $8F4A;
  GL_DOUBLE_MAT3x2 = $8F4B;
  GL_DOUBLE_MAT3x4 = $8F4C;
  GL_DOUBLE_MAT4x2 = $8F4D;
  GL_DOUBLE_MAT4x3 = $8F4E;
var
  glUniform1d: procedure(location: GLint; x: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2d: procedure(location: GLint; x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3d: procedure(location: GLint; x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4d: procedure(location: GLint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1dv: procedure(location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2dv: procedure(location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3dv: procedure(location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4dv: procedure(location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2x3dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2x4dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3x2dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3x4dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4x2dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4x3dv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformdv: procedure(_program: GLuint; location: GLint; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform1dEXT: procedure(_program: GLuint; location: GLint; x: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform2dEXT: procedure(_program: GLuint; location: GLint; x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform3dEXT: procedure(_program: GLuint; location: GLint; x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform4dEXT: procedure(_program: GLuint; location: GLint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform1dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform2dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform3dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniform4dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix2dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix3dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix4dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix2x3dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix2x4dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix3x2dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix3x4dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix4x2dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramUniformMatrix4x3dvEXT: procedure(_program: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_gpu_shader_fp64(): Boolean;

//**** GL_ARB_shader_subroutine *****//
const
  GL_ACTIVE_SUBROUTINES = $8DE5;
  GL_ACTIVE_SUBROUTINE_UNIFORMS = $8DE6;
  GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = $8E47;
  GL_ACTIVE_SUBROUTINE_MAX_LENGTH = $8E48;
  GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = $8E49;
  GL_MAX_SUBROUTINES = $8DE7;
  GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = $8DE8;
  GL_NUM_COMPATIBLE_SUBROUTINES = $8E4A;
  GL_COMPATIBLE_SUBROUTINES = $8E4B;

var
  glGetSubroutineUniformLocation: function(_program: GLuint; shadertype: GLenum; const name: PGLchar): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetSubroutineIndex: function(_program: GLuint; shadertype: GLenum; const name: PGLchar): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveSubroutineUniformiv: procedure(_program: GLuint; shadertype: GLenum; index: GLuint; pname: GLenum; values: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveSubroutineUniformName: procedure(_program: GLuint; shadertype: GLenum; index: GLuint; bufsize: GLsizei; length: PGLsizei; name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveSubroutineName: procedure(_program: GLuint; shadertype: GLenum; index: GLuint; bufsize: GLsizei; length: PGLsizei; name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformSubroutinesuiv: procedure(shadertype: GLenum; count: GLsizei; const indices: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformSubroutineuiv: procedure(shadertype: GLenum; location: GLint; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramStageiv: procedure(_program: GLuint; shadertype: GLenum; pname: GLenum; values: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_shader_subroutine(): Boolean;

//**** GL_ARB_tessellation_shader *****//
const
  GL_PATCHES = $000E;
  GL_PATCH_VERTICES = $8E72;
  GL_PATCH_DEFAULT_INNER_LEVEL = $8E73;
  GL_PATCH_DEFAULT_OUTER_LEVEL = $8E74;
  GL_TESS_CONTROL_OUTPUT_VERTICES = $8E75;
  GL_TESS_GEN_MODE = $8E76;
  GL_TESS_GEN_SPACING = $8E77;
  GL_TESS_GEN_VERTEX_ORDER = $8E78;
  GL_TESS_GEN_POINT_MODE = $8E79;
// reuse GL_TRIANGLES
// reuse GL_QUADS
const
  GL_ISOLINES = $8E7A;
// reuse GL_EQUAL
const
  GL_FRACTIONAL_ODD = $8E7B;
  GL_FRACTIONAL_EVEN = $8E7C;
// reuse GL_CCW
// reuse GL_CW
const
  GL_MAX_PATCH_VERTICES = $8E7D;
  GL_MAX_TESS_GEN_LEVEL = $8E7E;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = $8E7F;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E80;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = $8E81;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = $8E82;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = $8E83;
  GL_MAX_TESS_PATCH_COMPONENTS = $8E84;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = $8E85;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = $8E86;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = $8E89;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = $8E8A;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = $886C;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = $886D;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = $8E1E;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E1F;
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = $84F0;
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = $84F1;
  GL_TESS_EVALUATION_SHADER = $8E87;
  GL_TESS_CONTROL_SHADER = $8E88;
var
  glPatchParameteri: procedure(pname: GLenum; value: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPatchParameterfv: procedure(pname: GLenum; const values: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_tessellation_shader(): Boolean;

//**** GL_ARB_transform_feedback2 *****//
const
  GL_TRANSFORM_FEEDBACK = $8E22;
  GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = $8E23;
  GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = $8E24;
  GL_TRANSFORM_FEEDBACK_BINDING = $8E25;
var
  glBindTransformFeedback: procedure(target: GLenum; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteTransformFeedbacks: procedure(n: GLsizei; const ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenTransformFeedbacks: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsTransformFeedback: function(id: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPauseTransformFeedback: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glResumeTransformFeedback: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawTransformFeedback: procedure(mode: GLenum; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_transform_feedback2(): Boolean;

//**** GL_ARB_transform_feedback3 *****//
const
  GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = $8E70;
var
  glDrawTransformFeedbackStream: procedure(mode: GLenum; id: GLuint; stream: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginQueryIndexed: procedure(target: GLenum; index: GLuint; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndQueryIndexed: procedure(target: GLenum; index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryIndexediv: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_ARB_transform_feedback3(): Boolean;


//***** GL_version_1_4 *****//
const
  GL_BLEND_DST_RGB = $80C8;
  GL_BLEND_SRC_RGB = $80C9;
  GL_BLEND_DST_ALPHA = $80CA;
  GL_BLEND_SRC_ALPHA = $80CB;
  GL_POINT_SIZE_MIN = $8126;
  GL_POINT_SIZE_MAX = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE = $8128;
  GL_POINT_DISTANCE_ATTENUATION = $8129;
  GL_GENERATE_MIPMAP = $8191;
  GL_GENERATE_MIPMAP_HINT = $8192;
  GL_DEPTH_COMPONENT16 = $81A5;
  GL_DEPTH_COMPONENT24 = $81A6;
  GL_DEPTH_COMPONENT32 = $81A7;
  GL_MIRRORED_REPEAT = $8370;
  GL_FOG_COORDINATE_SOURCE = $8450;
  GL_FOG_COORDINATE = $8451;
  GL_FRAGMENT_DEPTH = $8452;
  GL_CURRENT_FOG_COORDINATE = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER = $8456;
  GL_FOG_COORDINATE_ARRAY = $8457;
  GL_COLOR_SUM = $8458;
  GL_CURRENT_SECONDARY_COLOR = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER = $845D;
  GL_SECONDARY_COLOR_ARRAY = $845E;
  GL_MAX_TEXTURE_LOD_BIAS = $84FD;
  GL_TEXTURE_FILTER_CONTROL = $8500;
  GL_TEXTURE_LOD_BIAS = $8501;
  GL_INCR_WRAP = $8507;
  GL_DECR_WRAP = $8508;
  GL_TEXTURE_DEPTH_SIZE = $884A;
  GL_DEPTH_TEXTURE_MODE = $884B;
  GL_TEXTURE_COMPARE_MODE = $884C;
  GL_TEXTURE_COMPARE_FUNC = $884D;
  GL_COMPARE_R_TO_TEXTURE = $884E;
var
  glBlendFuncSeparate: procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordf: procedure(coord: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordfv: procedure(const coord: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordd: procedure(coord: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoorddv: procedure(const coord: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFogCoordPointer: procedure(_type: GLenum; stride: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawArrays: procedure(mode: GLenum; first: PGLint; count: PGLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMultiDrawElements: procedure(mode: GLenum; const count: PGLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameterf: procedure(pname: GLenum; param: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameterfv: procedure(pname: GLenum; const params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameteri: procedure(pname: GLenum; param: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPointParameteriv: procedure(pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3b: procedure(red: GLbyte; green: GLbyte; blue: GLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3bv: procedure(const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3d: procedure(red: GLdouble; green: GLdouble; blue: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3dv: procedure(const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3f: procedure(red: GLfloat; green: GLfloat; blue: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3fv: procedure(const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3i: procedure(red: GLint; green: GLint; blue: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3iv: procedure(const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3s: procedure(red: GLshort; green: GLshort; blue: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3sv: procedure(const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ub: procedure(red: GLubyte; green: GLubyte; blue: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ubv: procedure(const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3ui: procedure(red: GLuint; green: GLuint; blue: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3uiv: procedure(const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3us: procedure(red: GLushort; green: GLushort; blue: GLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColor3usv: procedure(const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glSecondaryColorPointer: procedure(size: GLint; _type: GLenum; stride: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2d: procedure(x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2dv: procedure(const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2f: procedure(x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2fv: procedure(const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2i: procedure(x: GLint; y: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2iv: procedure(const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2s: procedure(x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos2sv: procedure(const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3d: procedure(x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3dv: procedure(const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3f: procedure(x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3fv: procedure(const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3i: procedure(x: GLint; y: GLint; z: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3iv: procedure(const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3s: procedure(x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glWindowPos3sv: procedure(const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_version_1_4: Boolean;

//***** GL_version_1_5 *****//
const
  GL_BUFFER_SIZE = $8764;
  GL_BUFFER_USAGE = $8765;
  GL_QUERY_COUNTER_BITS = $8864;
  GL_CURRENT_QUERY = $8865;
  GL_QUERY_RESULT = $8866;
  GL_QUERY_RESULT_AVAILABLE = $8867;
  GL_ARRAY_BUFFER = $8892;
  GL_ELEMENT_ARRAY_BUFFER = $8893;
  GL_ARRAY_BUFFER_BINDING = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING = $8898;
  GL_INDEX_ARRAY_BUFFER_BINDING = $8899;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = $889A;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = $889B;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = $889C;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = $889D;
  GL_WEIGHT_ARRAY_BUFFER_BINDING = $889E;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = $889F;
  GL_READ_ONLY = $88B8;
  GL_WRITE_ONLY = $88B9;
  GL_READ_WRITE = $88BA;
  GL_BUFFER_ACCESS = $88BB;
  GL_BUFFER_MAPPED = $88BC;
  GL_BUFFER_MAP_POINTER = $88BD;
  GL_STREAM_DRAW = $88E0;
  GL_STREAM_READ = $88E1;
  GL_STREAM_COPY = $88E2;
  GL_STATIC_DRAW = $88E4;
  GL_STATIC_READ = $88E5;
  GL_STATIC_COPY = $88E6;
  GL_DYNAMIC_DRAW = $88E8;
  GL_DYNAMIC_READ = $88E9;
  GL_DYNAMIC_COPY = $88EA;
  GL_SAMPLES_PASSED = $8914;
  GL_FOG_COORD_SRC = $8450;
  GL_FOG_COORD = $8451;
  GL_CURRENT_FOG_COORD = $8453;
  GL_FOG_COORD_ARRAY_TYPE = $8454;
  GL_FOG_COORD_ARRAY_STRIDE = $8455;
  GL_FOG_COORD_ARRAY_POINTER = $8456;
  GL_FOG_COORD_ARRAY = $8457;
  GL_FOG_COORD_ARRAY_BUFFER_BINDING = $889D;
  GL_SRC0_RGB = $8580;
  GL_SRC1_RGB = $8581;
  GL_SRC2_RGB = $8582;
  GL_SRC0_ALPHA = $8588;
  GL_SRC1_ALPHA = $8589;
  GL_SRC2_ALPHA = $858A;
var
  glGenQueries: procedure(n: GLsizei; ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteQueries: procedure(n: GLsizei; const ids: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsQuery: function(id: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginQuery: procedure(target: GLenum; id: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndQuery: procedure(target: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryiv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjectiv: procedure(id: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetQueryObjectuiv: procedure(id: GLuint; pname: GLenum; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindBuffer: procedure(target: GLenum; buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteBuffers: procedure(n: GLsizei; const buffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGenBuffers: procedure(n: GLsizei; buffers: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsBuffer: function(buffer: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBufferData: procedure(target: GLenum; size: GLsizeiptr; const data: PGLvoid; usage: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBufferSubData: procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; const data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetBufferSubData: procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; data: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glMapBuffer: function(target: GLenum; access: GLenum): PGLvoid; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUnmapBuffer: function(target: GLenum): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetBufferParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetBufferPointerv: procedure(target: GLenum; pname: GLenum; params: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_version_1_5: Boolean;

//***** GL_version_2_0 *****//
const
  GL_BLEND_EQUATION_RGB = $8009;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE = $8625;
  GL_CURRENT_VERTEX_ATTRIB = $8626;
  GL_VERTEX_PROGRAM_POINT_SIZE = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE = $8643;
  GL_VERTEX_ATTRIB_ARRAY_POINTER = $8645;
  GL_STENCIL_BACK_FUNC = $8800;
  GL_STENCIL_BACK_FAIL = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS = $8803;
  GL_MAX_DRAW_BUFFERS = $8824;
  GL_DRAW_BUFFER0 = $8825;
  GL_DRAW_BUFFER1 = $8826;
  GL_DRAW_BUFFER2 = $8827;
  GL_DRAW_BUFFER3 = $8828;
  GL_DRAW_BUFFER4 = $8829;
  GL_DRAW_BUFFER5 = $882A;
  GL_DRAW_BUFFER6 = $882B;
  GL_DRAW_BUFFER7 = $882C;
  GL_DRAW_BUFFER8 = $882D;
  GL_DRAW_BUFFER9 = $882E;
  GL_DRAW_BUFFER10 = $882F;
  GL_DRAW_BUFFER11 = $8830;
  GL_DRAW_BUFFER12 = $8831;
  GL_DRAW_BUFFER13 = $8832;
  GL_DRAW_BUFFER14 = $8833;
  GL_DRAW_BUFFER15 = $8834;
  GL_BLEND_EQUATION_ALPHA = $883D;
  GL_POINT_SPRITE = $8861;
  GL_COORD_REPLACE = $8862;
  GL_MAX_VERTEX_ATTRIBS = $8869;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = $886A;
  GL_MAX_TEXTURE_COORDS = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS = $8872;
  GL_FRAGMENT_SHADER = $8B30;
  GL_VERTEX_SHADER = $8B31;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = $8B49;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS = $8B4A;
  GL_MAX_VARYING_FLOATS = $8B4B;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = $8B4D;
  GL_SHADER_TYPE = $8B4F;
  GL_FLOAT_VEC2 = $8B50;
  GL_FLOAT_VEC3 = $8B51;
  GL_FLOAT_VEC4 = $8B52;
  GL_INT_VEC2 = $8B53;
  GL_INT_VEC3 = $8B54;
  GL_INT_VEC4 = $8B55;
  GL_BOOL = $8B56;
  GL_BOOL_VEC2 = $8B57;
  GL_BOOL_VEC3 = $8B58;
  GL_BOOL_VEC4 = $8B59;
  GL_FLOAT_MAT2 = $8B5A;
  GL_FLOAT_MAT3 = $8B5B;
  GL_FLOAT_MAT4 = $8B5C;
  GL_SAMPLER_1D = $8B5D;
  GL_SAMPLER_2D = $8B5E;
  GL_SAMPLER_3D = $8B5F;
  GL_SAMPLER_CUBE = $8B60;
  GL_SAMPLER_1D_SHADOW = $8B61;
  GL_SAMPLER_2D_SHADOW = $8B62;
  GL_DELETE_STATUS = $8B80;
  GL_COMPILE_STATUS = $8B81;
  GL_LINK_STATUS = $8B82;
  GL_VALIDATE_STATUS = $8B83;
  GL_INFO_LOG_LENGTH = $8B84;
  GL_ATTACHED_SHADERS = $8B85;
  GL_ACTIVE_UNIFORMS = $8B86;
  GL_ACTIVE_UNIFORM_MAX_LENGTH = $8B87;
  GL_SHADER_SOURCE_LENGTH = $8B88;
  GL_ACTIVE_ATTRIBUTES = $8B89;
  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = $8B8A;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT = $8B8B;
  GL_SHADING_LANGUAGE_VERSION = $8B8C;
  GL_CURRENT_PROGRAM = $8B8D;
  GL_POINT_SPRITE_COORD_ORIGIN = $8CA0;
  GL_LOWER_LEFT = $8CA1;
  GL_UPPER_LEFT = $8CA2;
  GL_STENCIL_BACK_REF = $8CA3;
  GL_STENCIL_BACK_VALUE_MASK = $8CA4;
  GL_STENCIL_BACK_WRITEMASK = $8CA5;
var
  glBlendEquationSeparate: procedure(modeRGB: GLenum; modeAlpha: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawBuffers: procedure(n: GLsizei; const bufs: PGLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glStencilOpSeparate: procedure(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glStencilFuncSeparate: procedure(frontfunc: GLenum; backfunc: GLenum; ref: GLint; mask: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glStencilMaskSeparate: procedure(face: GLenum; mask: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glAttachShader: procedure(_program: GLuint; shader: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindAttribLocation: procedure(_program: GLuint; index: GLuint; const name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCompileShader: procedure(shader: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCreateProgram: function(): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glCreateShader: function(_type: GLenum): GLuint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteProgram: procedure(_program: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDeleteShader: procedure(shader: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDetachShader: procedure(_program: GLuint; shader: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDisableVertexAttribArray: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEnableVertexAttribArray: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveAttrib: procedure(_program: GLuint; index: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetActiveUniform: procedure(_program: GLuint; index: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetAttachedShaders: procedure(_program: GLuint; maxCount: GLsizei; count: PGLsizei; obj: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetAttribLocation: function(_program: GLuint; const name: PGLchar): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramiv: procedure(_program: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetProgramInfoLog: procedure(_program: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetShaderiv: procedure(shader: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetShaderInfoLog: procedure(shader: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetShaderSource: procedure(shader: GLuint; bufSize: GLsizei; length: PGLsizei; source: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformLocation: function(_program: GLuint; const name: PGLchar): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformfv: procedure(_program: GLuint; location: GLint; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformiv: procedure(_program: GLuint; location: GLint; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribdv: procedure(index: GLuint; pname: GLenum; params: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribfv: procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribiv: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribPointerv: procedure(index: GLuint; pname: GLenum; pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsProgram: function(_program: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsShader: function(shader: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glLinkProgram: procedure(_program: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glShaderSource: procedure(shader: GLuint; count: GLsizei; const _string: PGLchar; const length: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUseProgram: procedure(_program: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1f: procedure(location: GLint; v0: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2f: procedure(location: GLint; v0: GLfloat; v1: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3f: procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4f: procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1i: procedure(location: GLint; v0: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2i: procedure(location: GLint; v0: GLint; v1: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3i: procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4i: procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1fv: procedure(location: GLint; count: GLsizei; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2fv: procedure(location: GLint; count: GLsizei; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3fv: procedure(location: GLint; count: GLsizei; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4fv: procedure(location: GLint; count: GLsizei; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1iv: procedure(location: GLint; count: GLsizei; const value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2iv: procedure(location: GLint; count: GLsizei; const value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3iv: procedure(location: GLint; count: GLsizei; const value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4iv: procedure(location: GLint; count: GLsizei; const value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glValidateProgram: procedure(_program: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1d: procedure(index: GLuint; x: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1dv: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1f: procedure(index: GLuint; x: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1fv: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1s: procedure(index: GLuint; x: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib1sv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2d: procedure(index: GLuint; x: GLdouble; y: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2dv: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2f: procedure(index: GLuint; x: GLfloat; y: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2fv: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2s: procedure(index: GLuint; x: GLshort; y: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib2sv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3d: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3dv: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3f: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3fv: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3s: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib3sv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nbv: procedure(index: GLuint; const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Niv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nsv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nub: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nubv: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nuiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4Nusv: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4bv: procedure(index: GLuint; const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4d: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4dv: procedure(index: GLuint; const v: PGLdouble); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4f: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4fv: procedure(index: GLuint; const v: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4iv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4s: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4sv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4ubv: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4uiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttrib4usv: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribPointer: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_version_2_0: Boolean;

//**** GL_VERSION_2_1 *****//
const
  GL_PIXEL_PACK_BUFFER = $88EB;
  GL_PIXEL_UNPACK_BUFFER = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING = $88EF;
  GL_FLOAT_MAT2x3 = $8B65;
  GL_FLOAT_MAT2x4 = $8B66;
  GL_FLOAT_MAT3x2 = $8B67;
  GL_FLOAT_MAT3x4 = $8B68;
  GL_FLOAT_MAT4x2 = $8B69;
  GL_FLOAT_MAT4x3 = $8B6A;
  GL_SRGB = $8C40;
  GL_SRGB8 = $8C41;
  GL_SRGB_ALPHA = $8C42;
  GL_SRGB8_ALPHA8 = $8C43;
  GL_COMPRESSED_SRGB = $8C48;
  GL_COMPRESSED_SRGB_ALPHA = $8C49;
var
  glUniformMatrix2x3fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3x2fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix2x4fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4x2fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix3x4fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniformMatrix4x3fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_VERSION_2_1(): Boolean;

//**** GL_VERSION_2_1 DEPRECATED *****//
const
  GL_CURRENT_RASTER_SECONDARY_COLOR = $845F;
  GL_SLUMINANCE_ALPHA = $8C44;
  GL_SLUMINANCE8_ALPHA8 = $8C45;
  GL_SLUMINANCE = $8C46;
  GL_SLUMINANCE8 = $8C47;
  GL_COMPRESSED_SLUMINANCE = $8C4A;
  GL_COMPRESSED_SLUMINANCE_ALPHA = $8C4B;

//**** GL_VERSION_3_0 *****//

const
  GL_COMPARE_REF_TO_TEXTURE = $884E;
  GL_CLIP_DISTANCE0 = $3000;
  GL_CLIP_DISTANCE1 = $3001;
  GL_CLIP_DISTANCE2 = $3002;
  GL_CLIP_DISTANCE3 = $3003;
  GL_CLIP_DISTANCE4 = $3004;
  GL_CLIP_DISTANCE5 = $3005;
  GL_CLIP_DISTANCE6 = $3006;
  GL_CLIP_DISTANCE7 = $3007;
  GL_MAX_CLIP_DISTANCES = $0D32;
  GL_MAJOR_VERSION = $821B;
  GL_MINOR_VERSION = $821C;
  GL_NUM_EXTENSIONS = $821D;
  GL_CONTEXT_FLAGS = $821E;
  GL_DEPTH_BUFFER = $8223;
  GL_STENCIL_BUFFER = $8224;
  GL_COMPRESSED_RED = $8225;
  GL_COMPRESSED_RG = $8226;
  GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = $0001;
  GL_RGBA32F = $8814;
  GL_RGB32F = $8815;
  GL_RGBA16F = $881A;
  GL_RGB16F = $881B;
  GL_VERTEX_ATTRIB_ARRAY_INTEGER = $88FD;
  GL_MAX_ARRAY_TEXTURE_LAYERS = $88FF;
  GL_MIN_PROGRAM_TEXEL_OFFSET = $8904;
  GL_MAX_PROGRAM_TEXEL_OFFSET = $8905;
  GL_CLAMP_READ_COLOR = $891C;
  GL_FIXED_ONLY = $891D;
  GL_MAX_VARYING_COMPONENTS = $8B4B;
  GL_TEXTURE_1D_ARRAY = $8C18;
  GL_PROXY_TEXTURE_1D_ARRAY = $8C19;
  GL_TEXTURE_2D_ARRAY = $8C1A;
  GL_PROXY_TEXTURE_2D_ARRAY = $8C1B;
  GL_TEXTURE_BINDING_1D_ARRAY = $8C1C;
  GL_TEXTURE_BINDING_2D_ARRAY = $8C1D;
  GL_R11F_G11F_B10F = $8C3A;
  GL_UNSIGNED_INT_10F_11F_11F_REV = $8C3B;
  GL_RGB9_E5 = $8C3D;
  GL_UNSIGNED_INT_5_9_9_9_REV = $8C3E;
  GL_TEXTURE_SHARED_SIZE = $8C3F;
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = $8C76;
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE = $8C7F;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = $8C80;
  GL_TRANSFORM_FEEDBACK_VARYINGS = $8C83;
  GL_TRANSFORM_FEEDBACK_BUFFER_START = $8C84;
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = $8C85;
  GL_PRIMITIVES_GENERATED = $8C87;
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = $8C88;
  GL_RASTERIZER_DISCARD = $8C89;
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = $8C8A;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = $8C8B;
  GL_INTERLEAVED_ATTRIBS = $8C8C;
  GL_SEPARATE_ATTRIBS = $8C8D;
  GL_TRANSFORM_FEEDBACK_BUFFER = $8C8E;
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = $8C8F;
  GL_RGBA32UI = $8D70;
  GL_RGB32UI = $8D71;
  GL_RGBA16UI = $8D76;
  GL_RGB16UI = $8D77;
  GL_RGBA8UI = $8D7C;
  GL_RGB8UI = $8D7D;
  GL_RGBA32I = $8D82;
  GL_RGB32I = $8D83;
  GL_RGBA16I = $8D88;
  GL_RGB16I = $8D89;
  GL_RGBA8I = $8D8E;
  GL_RGB8I = $8D8F;
  GL_RED_INTEGER = $8D94;
  GL_GREEN_INTEGER = $8D95;
  GL_BLUE_INTEGER = $8D96;
  GL_RGB_INTEGER = $8D98;
  GL_RGBA_INTEGER = $8D99;
  GL_BGR_INTEGER = $8D9A;
  GL_BGRA_INTEGER = $8D9B;
  GL_SAMPLER_1D_ARRAY = $8DC0;
  GL_SAMPLER_2D_ARRAY = $8DC1;
  GL_SAMPLER_1D_ARRAY_SHADOW = $8DC3;
  GL_SAMPLER_2D_ARRAY_SHADOW = $8DC4;
  GL_SAMPLER_CUBE_SHADOW = $8DC5;
  GL_UNSIGNED_INT_VEC2 = $8DC6;
  GL_UNSIGNED_INT_VEC3 = $8DC7;
  GL_UNSIGNED_INT_VEC4 = $8DC8;
  GL_INT_SAMPLER_1D = $8DC9;
  GL_INT_SAMPLER_2D = $8DCA;
  GL_INT_SAMPLER_3D = $8DCB;
  GL_INT_SAMPLER_CUBE = $8DCC;
  GL_INT_SAMPLER_1D_ARRAY = $8DCE;
  GL_INT_SAMPLER_2D_ARRAY = $8DCF;
  GL_UNSIGNED_INT_SAMPLER_1D = $8DD1;
  GL_UNSIGNED_INT_SAMPLER_2D = $8DD2;
  GL_UNSIGNED_INT_SAMPLER_3D = $8DD3;
  GL_UNSIGNED_INT_SAMPLER_CUBE = $8DD4;
  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = $8DD6;
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = $8DD7;
  GL_QUERY_WAIT = $8E13;
  GL_QUERY_NO_WAIT = $8E14;
  GL_QUERY_BY_REGION_WAIT = $8E15;
  GL_QUERY_BY_REGION_NO_WAIT = $8E16;
  GL_BUFFER_ACCESS_FLAGS = $911F;
  GL_BUFFER_MAP_LENGTH = $9120;
  GL_BUFFER_MAP_OFFSET = $9121;

var
  glColorMaski: procedure(index: GLuint; r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetBooleani_v: procedure(target: GLenum; index: GLuint; data: PGLboolean); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetIntegeri_v: procedure(target: GLenum; index: GLuint; data: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif}; (* Also used in GL_ARB_uniform_buffer_object *)
  glEnablei: procedure(target: GLenum; index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDisablei: procedure(target: GLenum; index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glIsEnabledi: function(target: GLenum; index: GLuint): GLboolean; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginTransformFeedback: procedure(primitiveMode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndTransformFeedback: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindBufferRange: procedure(target: GLenum; index: GLuint; buffer: GLuint; offset: GLintptr; size: GLsizeiptr); {$ifdef wincall}stdcall{$else}cdecl{$endif}; (* Also used in GL_ARB_uniform_buffer_object *)
  glBindBufferBase: procedure(target: GLenum; index: GLuint; buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif}; (* Also used in GL_ARB_uniform_buffer_object *)
  glTransformFeedbackVaryings: procedure(_program: GLuint; count: GLsizei; const varyings: PPGLchar; bufferMode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTransformFeedbackVarying: procedure(_program: GLuint; index: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLsizei; _type: PGLenum; name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClampColor: procedure(target: GLenum; clamp: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBeginConditionalRender: procedure(id: GLuint; mode: GLenum); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glEndConditionalRender: procedure(); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribIPointer: procedure(index: GLuint; size: GLint; _type: GLenum; stride: GLsizei; const _pointer: PGLvoid); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribIiv: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetVertexAttribIuiv: procedure(index: GLuint; pname: GLenum; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI1i: procedure(index: GLuint; x: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI2i: procedure(index: GLuint; x: GLint; y: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI3i: procedure(index: GLuint; x: GLint; y: GLint; z: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4i: procedure(index: GLuint; x: GLint; y: GLint; z: GLint; w: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI1ui: procedure(index: GLuint; x: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI2ui: procedure(index: GLuint; x: GLuint; y: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI3ui: procedure(index: GLuint; x: GLuint; y: GLuint; z: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4ui: procedure(index: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI1iv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI2iv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI3iv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4iv: procedure(index: GLuint; const v: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI1uiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI2uiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI3uiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4uiv: procedure(index: GLuint; const v: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4bv: procedure(index: GLuint; const v: PGLbyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4sv: procedure(index: GLuint; const v: PGLshort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4ubv: procedure(index: GLuint; const v: PGLubyte); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glVertexAttribI4usv: procedure(index: GLuint; const v: PGLushort); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetUniformuiv: procedure(_program: GLuint; location: GLint; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glBindFragDataLocation: procedure(_program: GLuint; color: GLuint; const name: PGLchar); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetFragDataLocation: function(_program: GLuint; const name: PGLchar): GLint; {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1ui: procedure(location: GLint; v0: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2ui: procedure(location: GLint; v0: GLuint; v1: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3ui: procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4ui: procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint; v3: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform1uiv: procedure(location: GLint; count: GLsizei; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform2uiv: procedure(location: GLint; count: GLsizei; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform3uiv: procedure(location: GLint; count: GLsizei; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glUniform4uiv: procedure(location: GLint; count: GLsizei; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexParameterIiv: procedure(target: GLenum; pname: GLenum; const params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexParameterIuiv: procedure(target: GLenum; pname: GLenum; const params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTexParameterIiv: procedure(target: GLenum; pname: GLenum; params: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetTexParameterIuiv: procedure(target: GLenum; pname: GLenum; params: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClearBufferiv: procedure(buffer: GLenum; drawbuffer: GLint; const value: PGLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClearBufferuiv: procedure(buffer: GLenum; drawbuffer: GLint; const value: PGLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClearBufferfv: procedure(buffer: GLenum; drawbuffer: GLint; const value: PGLfloat); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glClearBufferfi: procedure(buffer: GLenum; drawbuffer: GLint; depth: GLfloat; stencil: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetStringi: function(name: GLenum; index: GLuint): PGLubyte; {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_VERSION_3_0(): Boolean;

//**** GL_VERSION_3_0 DEPRECATED *****//
const
  GL_CLAMP_VERTEX_COLOR = $891A;
  GL_CLAMP_FRAGMENT_COLOR = $891B;
  GL_ALPHA_INTEGER = $8D97;

//**** GL_VERSION_3_1 *****//
const
  GL_SAMPLER_2D_RECT = $8B63;
  GL_SAMPLER_2D_RECT_SHADOW = $8B64;
  GL_SAMPLER_BUFFER = $8DC2;
  GL_INT_SAMPLER_2D_RECT = $8DCD;
  GL_INT_SAMPLER_BUFFER = $8DD0;
  GL_UNSIGNED_INT_SAMPLER_2D_RECT = $8DD5;
  GL_UNSIGNED_INT_SAMPLER_BUFFER = $8DD8;
  GL_TEXTURE_BUFFER = $8C2A;
  GL_MAX_TEXTURE_BUFFER_SIZE = $8C2B;
  GL_TEXTURE_BINDING_BUFFER = $8C2C;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING = $8C2D;
  GL_TEXTURE_BUFFER_FORMAT = $8C2E;
  GL_TEXTURE_RECTANGLE = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE = $84F8;
  GL_RED_SNORM = $8F90;
  GL_RG_SNORM = $8F91;
  GL_RGB_SNORM = $8F92;
  GL_RGBA_SNORM = $8F93;
  GL_R8_SNORM = $8F94;
  GL_RG8_SNORM = $8F95;
  GL_RGB8_SNORM = $8F96;
  GL_RGBA8_SNORM = $8F97;
  GL_R16_SNORM = $8F98;
  GL_RG16_SNORM = $8F99;
  GL_RGB16_SNORM = $8F9A;
  GL_RGBA16_SNORM = $8F9B;
  GL_SIGNED_NORMALIZED = $8F9C;
  GL_PRIMITIVE_RESTART = $8F9D;
  GL_PRIMITIVE_RESTART_INDEX = $8F9E;

var
  glDrawArraysInstanced: procedure(mode: GLenum; first: GLint; count: GLsizei; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glDrawElementsInstanced: procedure(mode: GLenum; count: GLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glTexBuffer: procedure(target: GLenum; internalformat: GLenum; buffer: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glPrimitiveRestartIndex: procedure(index: GLuint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_VERSION_3_1(): Boolean;

//**** GL_VERSION_3_2 *****//
const
  GL_CONTEXT_CORE_PROFILE_BIT = $00000001;
  GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = $00000002;
  GL_LINES_ADJACENCY = $000A;
  GL_LINE_STRIP_ADJACENCY = $000B;
  GL_TRIANGLES_ADJACENCY = $000C;
  GL_TRIANGLE_STRIP_ADJACENCY = $000D;
  GL_PROGRAM_POINT_SIZE = $8642;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = $8C29;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED = $8DA7;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = $8DA8;
  GL_GEOMETRY_SHADER = $8DD9;
  GL_GEOMETRY_VERTICES_OUT = $8916;
  GL_GEOMETRY_INPUT_TYPE = $8917;
  GL_GEOMETRY_OUTPUT_TYPE = $8918;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = $8DDF;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES = $8DE0;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = $8DE1;
  GL_MAX_VERTEX_OUTPUT_COMPONENTS = $9122;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS = $9123;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = $9124;
  GL_MAX_FRAGMENT_INPUT_COMPONENTS = $9125;
  GL_CONTEXT_PROFILE_MASK = $9126;

var
  glGetInteger64i_v: procedure(target: GLenum; index: GLuint; data: PGLint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glGetBufferParameteri64v: procedure(target: GLenum; pname: GLenum; params: PGLint64); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glProgramParameteri: procedure(_program: GLuint; pname: GLenum; value: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};
  glFramebufferTexture: procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint); {$ifdef wincall}stdcall{$else}cdecl{$endif};

function Load_GL_VERSION_3_2(): Boolean;

//**** GL_VERSION_3_3 *****//

function Load_GL_VERSION_3_3(): Boolean;

//**** GL_VERSION_4_0 *****//

function Load_GL_VERSION_4_0(): Boolean;

implementation
uses
 msedynload,msesys{$ifdef mswindows}{$ifdef FPC},dynlibs{$endif}{$endif}
 {$ifndef FPC},classes_del{$endif};

function getprocaddresses(const lib: tlibhandle;
                          const procedures: array of funcinfoty): boolean;
var
 int1: integer;
begin
 result:= true;
 for int1:= 0 to high(procedures) do begin
  with procedures[int1] do begin
  {$ifdef mswindows}
   d^:= wglgetprocaddress(pansichar(n));
  {$else}
   d^:= getprocaddress(libgl,pansichar(n));
  {$endif}
   if (d^ = nil) then begin
    result:= false;
   end;
  end;
 end;
end;
(*
function glext_ExtensionSupported(const extension: String; const searchIn: String): Boolean;
var
  extensions: PChar;
  start: PChar;
  where, terminator: PChar;
begin

  if (Pos(' ', extension) <> 0) or (extension = '') then
  begin
    Result := FALSE;
    Exit;
  end;

  if searchIn = '' then extensions := PChar(glGetString(GL_EXTENSIONS))
  else extensions := PChar(searchIn);
  start := extensions;
  while TRUE do
  begin
    where := StrPos(start, PChar(extension));
    if where = nil then Break;
    terminator := Pointer(PtrUInt(where) + Length(extension));
    if (where = start) or (PChar(PtrUInt(where) - 1)^ = ' ') then
    begin
      if (terminator^ = ' ') or (terminator^ = #0) then
      begin
        Result := TRUE;
        Exit;
      end;
    end;
    start := terminator;
  end;
  Result := FALSE;

end;
*)

function Load_GL_version_1_2: Boolean;
const
 funcs: array[0..5] of funcinfoty =
   (
    (n: 'glBlendColor'; d: {$ifndef FPC}@{$endif}@glBlendColor),
    (n: 'glBlendEquation'; d: {$ifndef FPC}@{$endif}@glBlendEquation),
    (n: 'glDrawRangeElements'; d: {$ifndef FPC}@{$endif}@glDrawRangeElements),
    (n: 'glTexImage3D'; d: {$ifndef FPC}@{$endif}@glTexImage3D),
    (n: 'glTexSubImage3D'; d: {$ifndef FPC}@{$endif}@glTexSubImage3D),
    (n: 'glCopyTexSubImage3D'; d: {$ifndef FPC}@{$endif}@glCopyTexSubImage3D)
    ); 
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_imaging: Boolean;
const
 funcs: array[0..31] of funcinfoty =
   (
    (n: 'glColorTable'; d: {$ifndef FPC}@{$endif}@glColorTable),
    (n: 'glColorTableParameterfv'; d: {$ifndef FPC}@{$endif}@glColorTableParameterfv),
    (n: 'glColorTableParameteriv'; d: {$ifndef FPC}@{$endif}@glColorTableParameteriv),
    (n: 'glCopyColorTable'; d: {$ifndef FPC}@{$endif}@glCopyColorTable),
    (n: 'glGetColorTable'; d: {$ifndef FPC}@{$endif}@glGetColorTable),
    (n: 'glGetColorTableParameterfv'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameterfv),
    (n: 'glGetColorTableParameteriv'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameteriv),
    (n: 'glColorSubTable'; d: {$ifndef FPC}@{$endif}@glColorSubTable),
    (n: 'glCopyColorSubTable'; d: {$ifndef FPC}@{$endif}@glCopyColorSubTable),
    (n: 'glConvolutionFilter1D'; d: {$ifndef FPC}@{$endif}@glConvolutionFilter1D),
    (n: 'glConvolutionFilter2D'; d: {$ifndef FPC}@{$endif}@glConvolutionFilter2D),
    (n: 'glConvolutionParameterf'; d: {$ifndef FPC}@{$endif}@glConvolutionParameterf),
    (n: 'glConvolutionParameterfv'; d: {$ifndef FPC}@{$endif}@glConvolutionParameterfv),
    (n: 'glConvolutionParameteri'; d: {$ifndef FPC}@{$endif}@glConvolutionParameteri),
    (n: 'glConvolutionParameteriv'; d: {$ifndef FPC}@{$endif}@glConvolutionParameteriv),
    (n: 'glCopyConvolutionFilter1D'; d: {$ifndef FPC}@{$endif}@glCopyConvolutionFilter1D),
    (n: 'glCopyConvolutionFilter2D'; d: {$ifndef FPC}@{$endif}@glCopyConvolutionFilter2D),
    (n: 'glGetConvolutionFilter'; d: {$ifndef FPC}@{$endif}@glGetConvolutionFilter),
    (n: 'glGetConvolutionParameterfv'; d: {$ifndef FPC}@{$endif}@glGetConvolutionParameterfv),
    (n: 'glGetConvolutionParameteriv'; d: {$ifndef FPC}@{$endif}@glGetConvolutionParameteriv),
    (n: 'glGetSeparableFilter'; d: {$ifndef FPC}@{$endif}@glGetSeparableFilter),
    (n: 'glSeparableFilter2D'; d: {$ifndef FPC}@{$endif}@glSeparableFilter2D),
    (n: 'glGetHistogram'; d: {$ifndef FPC}@{$endif}@glGetHistogram),
    (n: 'glGetHistogramParameterfv'; d: {$ifndef FPC}@{$endif}@glGetHistogramParameterfv),
    (n: 'glGetHistogramParameteriv'; d: {$ifndef FPC}@{$endif}@glGetHistogramParameteriv),
    (n: 'glGetMinmax'; d: {$ifndef FPC}@{$endif}@glGetMinmax),
    (n: 'glGetMinmaxParameterfv'; d: {$ifndef FPC}@{$endif}@glGetMinmaxParameterfv),
    (n: 'glGetMinmaxParameteriv'; d: {$ifndef FPC}@{$endif}@glGetMinmaxParameteriv),
    (n: 'glHistogram'; d: {$ifndef FPC}@{$endif}@glHistogram),
    (n: 'glMinmax'; d: {$ifndef FPC}@{$endif}@glMinmax),
    (n: 'glResetHistogram'; d: {$ifndef FPC}@{$endif}@glResetHistogram),
    (n: 'glResetMinmax'; d: {$ifndef FPC}@{$endif}@glResetMinmax)
    );

begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_version_1_3: Boolean;
const
 funcs: array[0..45] of funcinfoty =
   (
    (n: 'glActiveTexture'; d: {$ifndef FPC}@{$endif}@glActiveTexture),
    (n: 'glClientActiveTexture'; d: {$ifndef FPC}@{$endif}@glClientActiveTexture),
    (n: 'glMultiTexCoord1d'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1d),
    (n: 'glMultiTexCoord1dv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1dv),
    (n: 'glMultiTexCoord1f'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1f),
    (n: 'glMultiTexCoord1fv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1fv),
    (n: 'glMultiTexCoord1i'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1i),
    (n: 'glMultiTexCoord1iv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1iv),
    (n: 'glMultiTexCoord1s'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1s),
    (n: 'glMultiTexCoord1sv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1sv),
    (n: 'glMultiTexCoord2d'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2d),
    (n: 'glMultiTexCoord2dv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2dv),
    (n: 'glMultiTexCoord2f'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2f),
    (n: 'glMultiTexCoord2fv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2fv),
    (n: 'glMultiTexCoord2i'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2i),
    (n: 'glMultiTexCoord2iv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2iv),
    (n: 'glMultiTexCoord2s'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2s),
    (n: 'glMultiTexCoord2sv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2sv),
    (n: 'glMultiTexCoord3d'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3d),
    (n: 'glMultiTexCoord3dv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3dv),
    (n: 'glMultiTexCoord3f'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3f),
    (n: 'glMultiTexCoord3fv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3fv),
    (n: 'glMultiTexCoord3i'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3i),
    (n: 'glMultiTexCoord3iv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3iv),
    (n: 'glMultiTexCoord3s'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3s),
    (n: 'glMultiTexCoord3sv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3sv),
    (n: 'glMultiTexCoord4d'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4d),
    (n: 'glMultiTexCoord4dv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4dv),
    (n: 'glMultiTexCoord4f'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4f),
    (n: 'glMultiTexCoord4fv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4fv),
    (n: 'glMultiTexCoord4i'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4i),
    (n: 'glMultiTexCoord4iv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4iv),
    (n: 'glMultiTexCoord4s'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4s),
    (n: 'glMultiTexCoord4sv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4sv),
    (n: 'glLoadTransposeMatrixf'; d: {$ifndef FPC}@{$endif}@glLoadTransposeMatrixf),
    (n: 'glLoadTransposeMatrixd'; d: {$ifndef FPC}@{$endif}@glLoadTransposeMatrixd),
    (n: 'glMultTransposeMatrixf'; d: {$ifndef FPC}@{$endif}@glMultTransposeMatrixf),
    (n: 'glMultTransposeMatrixd'; d: {$ifndef FPC}@{$endif}@glMultTransposeMatrixd),
    (n: 'glSampleCoverage'; d: {$ifndef FPC}@{$endif}@glSampleCoverage),
    (n: 'glCompressedTexImage3D'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage3D),
    (n: 'glCompressedTexImage2D'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage2D),
    (n: 'glCompressedTexImage1D'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage1D),
    (n: 'glCompressedTexSubImage3D'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage3D),
    (n: 'glCompressedTexSubImage2D'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage2D),
    (n: 'glCompressedTexSubImage1D'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage1D),
    (n: 'glGetCompressedTexImage'; d: {$ifndef FPC}@{$endif}@glGetCompressedTexImage)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_multitexture: Boolean;
const
 funcs: array[0..33] of funcinfoty =
   (
    (n: 'glActiveTextureARB'; d: {$ifndef FPC}@{$endif}@glActiveTextureARB),
    (n: 'glClientActiveTextureARB'; d: {$ifndef FPC}@{$endif}@glClientActiveTextureARB),
    (n: 'glMultiTexCoord1dARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1dARB),
    (n: 'glMultiTexCoord1dvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1dvARB),
    (n: 'glMultiTexCoord1fARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1fARB),
    (n: 'glMultiTexCoord1fvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1fvARB),
    (n: 'glMultiTexCoord1iARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1iARB),
    (n: 'glMultiTexCoord1ivARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1ivARB),
    (n: 'glMultiTexCoord1sARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1sARB),
    (n: 'glMultiTexCoord1svARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1svARB),
    (n: 'glMultiTexCoord2dARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2dARB),
    (n: 'glMultiTexCoord2dvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2dvARB),
    (n: 'glMultiTexCoord2fARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2fARB),
    (n: 'glMultiTexCoord2fvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2fvARB),
    (n: 'glMultiTexCoord2iARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2iARB),
    (n: 'glMultiTexCoord2ivARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2ivARB),
    (n: 'glMultiTexCoord2sARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2sARB),
    (n: 'glMultiTexCoord2svARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2svARB),
    (n: 'glMultiTexCoord3dARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3dARB),
    (n: 'glMultiTexCoord3dvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3dvARB),
    (n: 'glMultiTexCoord3fARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3fARB),
    (n: 'glMultiTexCoord3fvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3fvARB),
    (n: 'glMultiTexCoord3iARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3iARB),
    (n: 'glMultiTexCoord3ivARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3ivARB),
    (n: 'glMultiTexCoord3sARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3sARB),
    (n: 'glMultiTexCoord3svARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3svARB),
    (n: 'glMultiTexCoord4dARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4dARB),
    (n: 'glMultiTexCoord4dvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4dvARB),
    (n: 'glMultiTexCoord4fARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4fARB),
    (n: 'glMultiTexCoord4fvARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4fvARB),
    (n: 'glMultiTexCoord4iARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4iARB),
    (n: 'glMultiTexCoord4ivARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4ivARB),
    (n: 'glMultiTexCoord4sARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4sARB),
    (n: 'glMultiTexCoord4svARB'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4svARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_transpose_matrix: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glLoadTransposeMatrixfARB'; d: {$ifndef FPC}@{$endif}@glLoadTransposeMatrixfARB),
    (n: 'glLoadTransposeMatrixdARB'; d: {$ifndef FPC}@{$endif}@glLoadTransposeMatrixdARB),
    (n: 'glMultTransposeMatrixfARB'; d: {$ifndef FPC}@{$endif}@glMultTransposeMatrixfARB),
    (n: 'glMultTransposeMatrixdARB'; d: {$ifndef FPC}@{$endif}@glMultTransposeMatrixdARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_multisample: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glSampleCoverageARB'; d: {$ifndef FPC}@{$endif}@glSampleCoverageARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_texture_env_add: Boolean;
begin
 result:= true; //no procs
end;

{$IFDEF msWindows}
function Load_WGL_ARB_extensions_string: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'wglGetExtensionsStringARB'; d: {$ifndef FPC}@{$endif}@wglGetExtensionsStringARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_ARB_buffer_region: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'wglCreateBufferRegionARB'; d: {$ifndef FPC}@{$endif}@wglCreateBufferRegionARB),
    (n: 'wglDeleteBufferRegionARB'; d: {$ifndef FPC}@{$endif}@wglDeleteBufferRegionARB),
    (n: 'wglSaveBufferRegionARB'; d: {$ifndef FPC}@{$endif}@wglSaveBufferRegionARB),
    (n: 'wglRestoreBufferRegionARB'; d: {$ifndef FPC}@{$endif}@wglRestoreBufferRegionARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;
{$ENDIF}

function Load_GL_ARB_texture_cube_map: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_depth_texture: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_point_parameters: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPointParameterfARB'; d: {$ifndef FPC}@{$endif}@glPointParameterfARB),
    (n: 'glPointParameterfvARB'; d: {$ifndef FPC}@{$endif}@glPointParameterfvARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_shadow: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_shadow_ambient: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_border_clamp: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_compression: Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glCompressedTexImage3DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage3DARB),
    (n: 'glCompressedTexImage2DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage2DARB),
    (n: 'glCompressedTexImage1DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexImage1DARB),
    (n: 'glCompressedTexSubImage3DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage3DARB),
    (n: 'glCompressedTexSubImage2DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage2DARB),
    (n: 'glCompressedTexSubImage1DARB'; d: {$ifndef FPC}@{$endif}@glCompressedTexSubImage1DARB),
    (n: 'glGetCompressedTexImageARB'; d: {$ifndef FPC}@{$endif}@glGetCompressedTexImageARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_texture_env_combine: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_env_crossbar: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_env_dot3: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_mirrored_repeat: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_vertex_blend: Boolean;
const
 funcs: array[0..10] of funcinfoty =
   (
    (n: 'glWeightbvARB'; d: {$ifndef FPC}@{$endif}@glWeightbvARB),
    (n: 'glWeightsvARB'; d: {$ifndef FPC}@{$endif}@glWeightsvARB),
    (n: 'glWeightivARB'; d: {$ifndef FPC}@{$endif}@glWeightivARB),
    (n: 'glWeightfvARB'; d: {$ifndef FPC}@{$endif}@glWeightfvARB),
    (n: 'glWeightdvARB'; d: {$ifndef FPC}@{$endif}@glWeightdvARB),
    (n: 'glWeightvARB'; d: {$ifndef FPC}@{$endif}@glWeightvARB),
    (n: 'glWeightubvARB'; d: {$ifndef FPC}@{$endif}@glWeightubvARB),
    (n: 'glWeightusvARB'; d: {$ifndef FPC}@{$endif}@glWeightusvARB),
    (n: 'glWeightuivARB'; d: {$ifndef FPC}@{$endif}@glWeightuivARB),
    (n: 'glWeightPointerARB'; d: {$ifndef FPC}@{$endif}@glWeightPointerARB),
    (n: 'glVertexBlendARB'; d: {$ifndef FPC}@{$endif}@glVertexBlendARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_vertex_program: Boolean;
const
 funcs: array[0..61] of funcinfoty =
   (
    (n: 'glVertexAttrib1sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1sARB),
    (n: 'glVertexAttrib1fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fARB),
    (n: 'glVertexAttrib1dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dARB),
    (n: 'glVertexAttrib2sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2sARB),
    (n: 'glVertexAttrib2fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fARB),
    (n: 'glVertexAttrib2dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dARB),
    (n: 'glVertexAttrib3sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3sARB),
    (n: 'glVertexAttrib3fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fARB),
    (n: 'glVertexAttrib3dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dARB),
    (n: 'glVertexAttrib4sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4sARB),
    (n: 'glVertexAttrib4fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fARB),
    (n: 'glVertexAttrib4dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dARB),
    (n: 'glVertexAttrib4NubARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NubARB),
    (n: 'glVertexAttrib1svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1svARB),
    (n: 'glVertexAttrib1fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fvARB),
    (n: 'glVertexAttrib1dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dvARB),
    (n: 'glVertexAttrib2svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2svARB),
    (n: 'glVertexAttrib2fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fvARB),
    (n: 'glVertexAttrib2dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dvARB),
    (n: 'glVertexAttrib3svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3svARB),
    (n: 'glVertexAttrib3fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fvARB),
    (n: 'glVertexAttrib3dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dvARB),
    (n: 'glVertexAttrib4bvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4bvARB),
    (n: 'glVertexAttrib4svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4svARB),
    (n: 'glVertexAttrib4ivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ivARB),
    (n: 'glVertexAttrib4ubvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ubvARB),
    (n: 'glVertexAttrib4usvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4usvARB),
    (n: 'glVertexAttrib4uivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4uivARB),
    (n: 'glVertexAttrib4fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fvARB),
    (n: 'glVertexAttrib4dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dvARB),
    (n: 'glVertexAttrib4NbvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NbvARB),
    (n: 'glVertexAttrib4NsvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NsvARB),
    (n: 'glVertexAttrib4NivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NivARB),
    (n: 'glVertexAttrib4NubvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NubvARB),
    (n: 'glVertexAttrib4NusvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NusvARB),
    (n: 'glVertexAttrib4NuivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NuivARB),
    (n: 'glVertexAttribPointerARB'; d: {$ifndef FPC}@{$endif}@glVertexAttribPointerARB),
    (n: 'glEnableVertexAttribArrayARB'; d: {$ifndef FPC}@{$endif}@glEnableVertexAttribArrayARB),
    (n: 'glDisableVertexAttribArrayARB'; d: {$ifndef FPC}@{$endif}@glDisableVertexAttribArrayARB),
    (n: 'glProgramStringARB'; d: {$ifndef FPC}@{$endif}@glProgramStringARB),
    (n: 'glBindProgramARB'; d: {$ifndef FPC}@{$endif}@glBindProgramARB),
    (n: 'glDeleteProgramsARB'; d: {$ifndef FPC}@{$endif}@glDeleteProgramsARB),
    (n: 'glGenProgramsARB'; d: {$ifndef FPC}@{$endif}@glGenProgramsARB),
    (n: 'glProgramEnvParameter4dARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4dARB),
    (n: 'glProgramEnvParameter4dvARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4dvARB),
    (n: 'glProgramEnvParameter4fARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4fARB),
    (n: 'glProgramEnvParameter4fvARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4fvARB),
    (n: 'glProgramLocalParameter4dARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dARB),
    (n: 'glProgramLocalParameter4dvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dvARB),
    (n: 'glProgramLocalParameter4fARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fARB),
    (n: 'glProgramLocalParameter4fvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fvARB),
    (n: 'glGetProgramEnvParameterdvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramEnvParameterdvARB),
    (n: 'glGetProgramEnvParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramEnvParameterfvARB),
    (n: 'glGetProgramLocalParameterdvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterdvARB),
    (n: 'glGetProgramLocalParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterfvARB),
    (n: 'glGetProgramivARB'; d: {$ifndef FPC}@{$endif}@glGetProgramivARB),
    (n: 'glGetProgramStringARB'; d: {$ifndef FPC}@{$endif}@glGetProgramStringARB),
    (n: 'glGetVertexAttribdvARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribdvARB),
    (n: 'glGetVertexAttribfvARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribfvARB),
    (n: 'glGetVertexAttribivARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribivARB),
    (n: 'glGetVertexAttribPointervARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribPointervARB),
    (n: 'glIsProgramARB'; d: {$ifndef FPC}@{$endif}@glIsProgramARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_window_pos: Boolean;
const
 funcs: array[0..15] of funcinfoty =
   (
    (n: 'glWindowPos2dARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2dARB),
    (n: 'glWindowPos2fARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2fARB),
    (n: 'glWindowPos2iARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2iARB),
    (n: 'glWindowPos2sARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2sARB),
    (n: 'glWindowPos2dvARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2dvARB),
    (n: 'glWindowPos2fvARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2fvARB),
    (n: 'glWindowPos2ivARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2ivARB),
    (n: 'glWindowPos2svARB'; d: {$ifndef FPC}@{$endif}@glWindowPos2svARB),
    (n: 'glWindowPos3dARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3dARB),
    (n: 'glWindowPos3fARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3fARB),
    (n: 'glWindowPos3iARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3iARB),
    (n: 'glWindowPos3sARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3sARB),
    (n: 'glWindowPos3dvARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3dvARB),
    (n: 'glWindowPos3fvARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3fvARB),
    (n: 'glWindowPos3ivARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3ivARB),
    (n: 'glWindowPos3svARB'; d: {$ifndef FPC}@{$endif}@glWindowPos3svARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_422_pixels: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_abgr: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_bgra: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_blend_color: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glBlendColorEXT'; d: {$ifndef FPC}@{$endif}@glBlendColorEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_blend_func_separate: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glBlendFuncSeparateEXT'; d: {$ifndef FPC}@{$endif}@glBlendFuncSeparateEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_blend_logic_op: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_blend_minmax: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glBlendEquationEXT'; d: {$ifndef FPC}@{$endif}@glBlendEquationEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_blend_subtract: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_clip_volume_hint: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_color_subtable: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glColorSubTableEXT'; d: {$ifndef FPC}@{$endif}@glColorSubTableEXT),
    (n: 'glCopyColorSubTableEXT'; d: {$ifndef FPC}@{$endif}@glCopyColorSubTableEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_compiled_vertex_array: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glLockArraysEXT'; d: {$ifndef FPC}@{$endif}@glLockArraysEXT),
    (n: 'glUnlockArraysEXT'; d: {$ifndef FPC}@{$endif}@glUnlockArraysEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_convolution: Boolean;
const
 funcs: array[0..12] of funcinfoty =
   (
    (n: 'glConvolutionFilter1DEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionFilter1DEXT),
    (n: 'glConvolutionFilter2DEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionFilter2DEXT),
    (n: 'glCopyConvolutionFilter1DEXT'; d: {$ifndef FPC}@{$endif}@glCopyConvolutionFilter1DEXT),
    (n: 'glCopyConvolutionFilter2DEXT'; d: {$ifndef FPC}@{$endif}@glCopyConvolutionFilter2DEXT),
    (n: 'glGetConvolutionFilterEXT'; d: {$ifndef FPC}@{$endif}@glGetConvolutionFilterEXT),
    (n: 'glSeparableFilter2DEXT'; d: {$ifndef FPC}@{$endif}@glSeparableFilter2DEXT),
    (n: 'glGetSeparableFilterEXT'; d: {$ifndef FPC}@{$endif}@glGetSeparableFilterEXT),
    (n: 'glConvolutionParameteriEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionParameteriEXT),
    (n: 'glConvolutionParameterivEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionParameterivEXT),
    (n: 'glConvolutionParameterfEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionParameterfEXT),
    (n: 'glConvolutionParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glConvolutionParameterfvEXT),
    (n: 'glGetConvolutionParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetConvolutionParameterivEXT),
    (n: 'glGetConvolutionParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glGetConvolutionParameterfvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_fog_coord: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'glFogCoordfEXT'; d: {$ifndef FPC}@{$endif}@glFogCoordfEXT),
    (n: 'glFogCoorddEXT'; d: {$ifndef FPC}@{$endif}@glFogCoorddEXT),
    (n: 'glFogCoordfvEXT'; d: {$ifndef FPC}@{$endif}@glFogCoordfvEXT),
    (n: 'glFogCoorddvEXT'; d: {$ifndef FPC}@{$endif}@glFogCoorddvEXT),
    (n: 'glFogCoordPointerEXT'; d: {$ifndef FPC}@{$endif}@glFogCoordPointerEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_histogram: Boolean;
const
 funcs: array[0..9] of funcinfoty =
   (
    (n: 'glHistogramEXT'; d: {$ifndef FPC}@{$endif}@glHistogramEXT),
    (n: 'glResetHistogramEXT'; d: {$ifndef FPC}@{$endif}@glResetHistogramEXT),
    (n: 'glGetHistogramEXT'; d: {$ifndef FPC}@{$endif}@glGetHistogramEXT),
    (n: 'glGetHistogramParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetHistogramParameterivEXT),
    (n: 'glGetHistogramParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glGetHistogramParameterfvEXT),
    (n: 'glMinmaxEXT'; d: {$ifndef FPC}@{$endif}@glMinmaxEXT),
    (n: 'glResetMinmaxEXT'; d: {$ifndef FPC}@{$endif}@glResetMinmaxEXT),
    (n: 'glGetMinmaxEXT'; d: {$ifndef FPC}@{$endif}@glGetMinmaxEXT),
    (n: 'glGetMinmaxParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetMinmaxParameterivEXT),
    (n: 'glGetMinmaxParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glGetMinmaxParameterfvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_multi_draw_arrays: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glMultiDrawArraysEXT'; d: {$ifndef FPC}@{$endif}@glMultiDrawArraysEXT),
    (n: 'glMultiDrawElementsEXT'; d: {$ifndef FPC}@{$endif}@glMultiDrawElementsEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_packed_depth_stencil: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_packed_pixels: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_paletted_texture: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'glColorTableEXT'; d: {$ifndef FPC}@{$endif}@glColorTableEXT),
    (n: 'glColorSubTableEXT'; d: {$ifndef FPC}@{$endif}@glColorSubTableEXT),
    (n: 'glGetColorTableEXT'; d: {$ifndef FPC}@{$endif}@glGetColorTableEXT),
    (n: 'glGetColorTableParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameterivEXT),
    (n: 'glGetColorTableParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameterfvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_point_parameters: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPointParameterfEXT'; d: {$ifndef FPC}@{$endif}@glPointParameterfEXT),
    (n: 'glPointParameterfvEXT'; d: {$ifndef FPC}@{$endif}@glPointParameterfvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_polygon_offset: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glPolygonOffsetEXT'; d: {$ifndef FPC}@{$endif}@glPolygonOffsetEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_secondary_color: Boolean;
const
 funcs: array[0..16] of funcinfoty =
   (
    (n: 'glSecondaryColor3bEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3bEXT),
    (n: 'glSecondaryColor3sEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3sEXT),
    (n: 'glSecondaryColor3iEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3iEXT),
    (n: 'glSecondaryColor3fEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3fEXT),
    (n: 'glSecondaryColor3dEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3dEXT),
    (n: 'glSecondaryColor3ubEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ubEXT),
    (n: 'glSecondaryColor3usEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3usEXT),
    (n: 'glSecondaryColor3uiEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3uiEXT),
    (n: 'glSecondaryColor3bvEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3bvEXT),
    (n: 'glSecondaryColor3svEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3svEXT),
    (n: 'glSecondaryColor3ivEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ivEXT),
    (n: 'glSecondaryColor3fvEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3fvEXT),
    (n: 'glSecondaryColor3dvEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3dvEXT),
    (n: 'glSecondaryColor3ubvEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ubvEXT),
    (n: 'glSecondaryColor3usvEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3usvEXT),
    (n: 'glSecondaryColor3uivEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3uivEXT),
    (n: 'glSecondaryColorPointerEXT'; d: {$ifndef FPC}@{$endif}@glSecondaryColorPointerEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_separate_specular_color: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_shadow_funcs: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_shared_texture_palette: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_stencil_two_side: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glActiveStencilFaceEXT'; d: {$ifndef FPC}@{$endif}@glActiveStencilFaceEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_stencil_wrap: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_subtexture: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glTexSubImage1DEXT'; d: {$ifndef FPC}@{$endif}@glTexSubImage1DEXT),
    (n: 'glTexSubImage2DEXT'; d: {$ifndef FPC}@{$endif}@glTexSubImage2DEXT),
    (n: 'glTexSubImage3DEXT'; d: {$ifndef FPC}@{$endif}@glTexSubImage3DEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_texture3D: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glTexImage3DEXT'; d: {$ifndef FPC}@{$endif}@glTexImage3DEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_texture_compression_s3tc: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_env_add: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_env_combine: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_env_dot3: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_filter_anisotropic: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_lod_bias: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_object: Boolean;
const
 funcs: array[0..5] of funcinfoty =
   (
    (n: 'glGenTexturesEXT'; d: {$ifndef FPC}@{$endif}@glGenTexturesEXT),
    (n: 'glDeleteTexturesEXT'; d: {$ifndef FPC}@{$endif}@glDeleteTexturesEXT),
    (n: 'glBindTextureEXT'; d: {$ifndef FPC}@{$endif}@glBindTextureEXT),
    (n: 'glPrioritizeTexturesEXT'; d: {$ifndef FPC}@{$endif}@glPrioritizeTexturesEXT),
    (n: 'glAreTexturesResidentEXT'; d: {$ifndef FPC}@{$endif}@glAreTexturesResidentEXT),
    (n: 'glIsTextureEXT'; d: {$ifndef FPC}@{$endif}@glIsTextureEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_vertex_array: Boolean;
const
 funcs: array[0..8] of funcinfoty =
   (
    (n: 'glArrayElementEXT'; d: {$ifndef FPC}@{$endif}@glArrayElementEXT),
    (n: 'glDrawArraysEXT'; d: {$ifndef FPC}@{$endif}@glDrawArraysEXT),
    (n: 'glVertexPointerEXT'; d: {$ifndef FPC}@{$endif}@glVertexPointerEXT),
    (n: 'glNormalPointerEXT'; d: {$ifndef FPC}@{$endif}@glNormalPointerEXT),
    (n: 'glColorPointerEXT'; d: {$ifndef FPC}@{$endif}@glColorPointerEXT),
    (n: 'glIndexPointerEXT'; d: {$ifndef FPC}@{$endif}@glIndexPointerEXT),
    (n: 'glTexCoordPointerEXT'; d: {$ifndef FPC}@{$endif}@glTexCoordPointerEXT),
    (n: 'glEdgeFlagPointerEXT'; d: {$ifndef FPC}@{$endif}@glEdgeFlagPointerEXT),
    (n: 'glGetPointervEXT'; d: {$ifndef FPC}@{$endif}@glGetPointervEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_vertex_shader: Boolean;
const
 funcs: array[0..41] of funcinfoty =
   (
    (n: 'glBeginVertexShaderEXT'; d: {$ifndef FPC}@{$endif}@glBeginVertexShaderEXT),
    (n: 'glEndVertexShaderEXT'; d: {$ifndef FPC}@{$endif}@glEndVertexShaderEXT),
    (n: 'glBindVertexShaderEXT'; d: {$ifndef FPC}@{$endif}@glBindVertexShaderEXT),
    (n: 'glGenVertexShadersEXT'; d: {$ifndef FPC}@{$endif}@glGenVertexShadersEXT),
    (n: 'glDeleteVertexShaderEXT'; d: {$ifndef FPC}@{$endif}@glDeleteVertexShaderEXT),
    (n: 'glShaderOp1EXT'; d: {$ifndef FPC}@{$endif}@glShaderOp1EXT),
    (n: 'glShaderOp2EXT'; d: {$ifndef FPC}@{$endif}@glShaderOp2EXT),
    (n: 'glShaderOp3EXT'; d: {$ifndef FPC}@{$endif}@glShaderOp3EXT),
    (n: 'glSwizzleEXT'; d: {$ifndef FPC}@{$endif}@glSwizzleEXT),
    (n: 'glWriteMaskEXT'; d: {$ifndef FPC}@{$endif}@glWriteMaskEXT),
    (n: 'glInsertComponentEXT'; d: {$ifndef FPC}@{$endif}@glInsertComponentEXT),
    (n: 'glExtractComponentEXT'; d: {$ifndef FPC}@{$endif}@glExtractComponentEXT),
    (n: 'glGenSymbolsEXT'; d: {$ifndef FPC}@{$endif}@glGenSymbolsEXT),
    (n: 'glSetInvariantEXT'; d: {$ifndef FPC}@{$endif}@glSetInvariantEXT),
    (n: 'glSetLocalConstantEXT'; d: {$ifndef FPC}@{$endif}@glSetLocalConstantEXT),
    (n: 'glVariantbvEXT'; d: {$ifndef FPC}@{$endif}@glVariantbvEXT),
    (n: 'glVariantsvEXT'; d: {$ifndef FPC}@{$endif}@glVariantsvEXT),
    (n: 'glVariantivEXT'; d: {$ifndef FPC}@{$endif}@glVariantivEXT),
    (n: 'glVariantfvEXT'; d: {$ifndef FPC}@{$endif}@glVariantfvEXT),
    (n: 'glVariantdvEXT'; d: {$ifndef FPC}@{$endif}@glVariantdvEXT),
    (n: 'glVariantubvEXT'; d: {$ifndef FPC}@{$endif}@glVariantubvEXT),
    (n: 'glVariantusvEXT'; d: {$ifndef FPC}@{$endif}@glVariantusvEXT),
    (n: 'glVariantuivEXT'; d: {$ifndef FPC}@{$endif}@glVariantuivEXT),
    (n: 'glVariantPointerEXT'; d: {$ifndef FPC}@{$endif}@glVariantPointerEXT),
    (n: 'glEnableVariantClientStateEXT'; d: {$ifndef FPC}@{$endif}@glEnableVariantClientStateEXT),
    (n: 'glDisableVariantClientStateEXT'; d: {$ifndef FPC}@{$endif}@glDisableVariantClientStateEXT),
    (n: 'glBindLightParameterEXT'; d: {$ifndef FPC}@{$endif}@glBindLightParameterEXT),
    (n: 'glBindMaterialParameterEXT'; d: {$ifndef FPC}@{$endif}@glBindMaterialParameterEXT),
    (n: 'glBindTexGenParameterEXT'; d: {$ifndef FPC}@{$endif}@glBindTexGenParameterEXT),
    (n: 'glBindTextureUnitParameterEXT'; d: {$ifndef FPC}@{$endif}@glBindTextureUnitParameterEXT),
    (n: 'glBindParameterEXT'; d: {$ifndef FPC}@{$endif}@glBindParameterEXT),
    (n: 'glIsVariantEnabledEXT'; d: {$ifndef FPC}@{$endif}@glIsVariantEnabledEXT),
    (n: 'glGetVariantBooleanvEXT'; d: {$ifndef FPC}@{$endif}@glGetVariantBooleanvEXT),
    (n: 'glGetVariantIntegervEXT'; d: {$ifndef FPC}@{$endif}@glGetVariantIntegervEXT),
    (n: 'glGetVariantFloatvEXT'; d: {$ifndef FPC}@{$endif}@glGetVariantFloatvEXT),
    (n: 'glGetVariantPointervEXT'; d: {$ifndef FPC}@{$endif}@glGetVariantPointervEXT),
    (n: 'glGetInvariantBooleanvEXT'; d: {$ifndef FPC}@{$endif}@glGetInvariantBooleanvEXT),
    (n: 'glGetInvariantIntegervEXT'; d: {$ifndef FPC}@{$endif}@glGetInvariantIntegervEXT),
    (n: 'glGetInvariantFloatvEXT'; d: {$ifndef FPC}@{$endif}@glGetInvariantFloatvEXT),
    (n: 'glGetLocalConstantBooleanvEXT'; d: {$ifndef FPC}@{$endif}@glGetLocalConstantBooleanvEXT),
    (n: 'glGetLocalConstantIntegervEXT'; d: {$ifndef FPC}@{$endif}@glGetLocalConstantIntegervEXT),
    (n: 'glGetLocalConstantFloatvEXT'; d: {$ifndef FPC}@{$endif}@glGetLocalConstantFloatvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_vertex_weighting: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glVertexWeightfEXT'; d: {$ifndef FPC}@{$endif}@glVertexWeightfEXT),
    (n: 'glVertexWeightfvEXT'; d: {$ifndef FPC}@{$endif}@glVertexWeightfvEXT),
    (n: 'glVertexWeightPointerEXT'; d: {$ifndef FPC}@{$endif}@glVertexWeightPointerEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_HP_occlusion_test: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_blend_square: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_copy_depth_to_color: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_depth_clamp: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_evaluators: Boolean;
const
 funcs: array[0..8] of funcinfoty =
   (
    (n: 'glMapControlPointsNV'; d: {$ifndef FPC}@{$endif}@glMapControlPointsNV),
    (n: 'glMapParameterivNV'; d: {$ifndef FPC}@{$endif}@glMapParameterivNV),
    (n: 'glMapParameterfvNV'; d: {$ifndef FPC}@{$endif}@glMapParameterfvNV),
    (n: 'glGetMapControlPointsNV'; d: {$ifndef FPC}@{$endif}@glGetMapControlPointsNV),
    (n: 'glGetMapParameterivNV'; d: {$ifndef FPC}@{$endif}@glGetMapParameterivNV),
    (n: 'glGetMapParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetMapParameterfvNV),
    (n: 'glGetMapAttribParameterivNV'; d: {$ifndef FPC}@{$endif}@glGetMapAttribParameterivNV),
    (n: 'glGetMapAttribParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetMapAttribParameterfvNV),
    (n: 'glEvalMapsNV'; d: {$ifndef FPC}@{$endif}@glEvalMapsNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_fence: Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glGenFencesNV'; d: {$ifndef FPC}@{$endif}@glGenFencesNV),
    (n: 'glDeleteFencesNV'; d: {$ifndef FPC}@{$endif}@glDeleteFencesNV),
    (n: 'glSetFenceNV'; d: {$ifndef FPC}@{$endif}@glSetFenceNV),
    (n: 'glTestFenceNV'; d: {$ifndef FPC}@{$endif}@glTestFenceNV),
    (n: 'glFinishFenceNV'; d: {$ifndef FPC}@{$endif}@glFinishFenceNV),
    (n: 'glIsFenceNV'; d: {$ifndef FPC}@{$endif}@glIsFenceNV),
    (n: 'glGetFenceivNV'; d: {$ifndef FPC}@{$endif}@glGetFenceivNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_fog_distance: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_light_max_exponent: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_multisample_filter_hint: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_occlusion_query: Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glGenOcclusionQueriesNV'; d: {$ifndef FPC}@{$endif}@glGenOcclusionQueriesNV),
    (n: 'glDeleteOcclusionQueriesNV'; d: {$ifndef FPC}@{$endif}@glDeleteOcclusionQueriesNV),
    (n: 'glIsOcclusionQueryNV'; d: {$ifndef FPC}@{$endif}@glIsOcclusionQueryNV),
    (n: 'glBeginOcclusionQueryNV'; d: {$ifndef FPC}@{$endif}@glBeginOcclusionQueryNV),
    (n: 'glEndOcclusionQueryNV'; d: {$ifndef FPC}@{$endif}@glEndOcclusionQueryNV),
    (n: 'glGetOcclusionQueryivNV'; d: {$ifndef FPC}@{$endif}@glGetOcclusionQueryivNV),
    (n: 'glGetOcclusionQueryuivNV'; d: {$ifndef FPC}@{$endif}@glGetOcclusionQueryuivNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_packed_depth_stencil: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_point_sprite: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPointParameteriNV'; d: {$ifndef FPC}@{$endif}@glPointParameteriNV),
    (n: 'glPointParameterivNV'; d: {$ifndef FPC}@{$endif}@glPointParameterivNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_register_combiners: Boolean;
const
 funcs: array[0..12] of funcinfoty =
   (
    (n: 'glCombinerParameterfvNV'; d: {$ifndef FPC}@{$endif}@glCombinerParameterfvNV),
    (n: 'glCombinerParameterivNV'; d: {$ifndef FPC}@{$endif}@glCombinerParameterivNV),
    (n: 'glCombinerParameterfNV'; d: {$ifndef FPC}@{$endif}@glCombinerParameterfNV),
    (n: 'glCombinerParameteriNV'; d: {$ifndef FPC}@{$endif}@glCombinerParameteriNV),
    (n: 'glCombinerInputNV'; d: {$ifndef FPC}@{$endif}@glCombinerInputNV),
    (n: 'glCombinerOutputNV'; d: {$ifndef FPC}@{$endif}@glCombinerOutputNV),
    (n: 'glFinalCombinerInputNV'; d: {$ifndef FPC}@{$endif}@glFinalCombinerInputNV),
    (n: 'glGetCombinerInputParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetCombinerInputParameterfvNV),
    (n: 'glGetCombinerInputParameterivNV'; d: {$ifndef FPC}@{$endif}@glGetCombinerInputParameterivNV),
    (n: 'glGetCombinerOutputParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetCombinerOutputParameterfvNV),
    (n: 'glGetCombinerOutputParameterivNV'; d: {$ifndef FPC}@{$endif}@glGetCombinerOutputParameterivNV),
    (n: 'glGetFinalCombinerInputParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetFinalCombinerInputParameterfvNV),
    (n: 'glGetFinalCombinerInputParameterivNV'; d: {$ifndef FPC}@{$endif}@glGetFinalCombinerInputParameterivNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_register_combiners2: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glCombinerStageParameterfvNV'; d: {$ifndef FPC}@{$endif}@glCombinerStageParameterfvNV),
    (n: 'glGetCombinerStageParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetCombinerStageParameterfvNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_texgen_emboss: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texgen_reflection: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_compression_vtc: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_env_combine4: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_rectangle: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_shader: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_shader2: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_shader3: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_vertex_array_range: Boolean;
const
 funcs: array[0..{$ifdef mswindows}3{$else}1{$endif}] of funcinfoty =
   (
    (n: 'glVertexArrayRangeNV'; d: {$ifndef FPC}@{$endif}@glVertexArrayRangeNV),
    (n: 'glFlushVertexArrayRangeNV'; d: {$ifndef FPC}@{$endif}@glFlushVertexArrayRangeNV)
{$IFDEF msWindows}
    ,
    (n: 'wglAllocateMemoryNV'; d: {$ifndef FPC}@{$endif}@wglAllocateMemoryNV),
    (n: 'wglFreeMemoryNV'; d: {$ifndef FPC}@{$endif}@wglFreeMemoryNV)
{$ENDIF}
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_vertex_array_range2: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_vertex_program: Boolean;
const
 funcs: array[0..61] of funcinfoty =
   (
    (n: 'glBindProgramNV'; d: {$ifndef FPC}@{$endif}@glBindProgramNV),
    (n: 'glDeleteProgramsNV'; d: {$ifndef FPC}@{$endif}@glDeleteProgramsNV),
    (n: 'glExecuteProgramNV'; d: {$ifndef FPC}@{$endif}@glExecuteProgramNV),
    (n: 'glGenProgramsNV'; d: {$ifndef FPC}@{$endif}@glGenProgramsNV),
    (n: 'glAreProgramsResidentNV'; d: {$ifndef FPC}@{$endif}@glAreProgramsResidentNV),
    (n: 'glRequestResidentProgramsNV'; d: {$ifndef FPC}@{$endif}@glRequestResidentProgramsNV),
    (n: 'glGetProgramParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetProgramParameterfvNV),
    (n: 'glGetProgramParameterdvNV'; d: {$ifndef FPC}@{$endif}@glGetProgramParameterdvNV),
    (n: 'glGetProgramivNV'; d: {$ifndef FPC}@{$endif}@glGetProgramivNV),
    (n: 'glGetProgramStringNV'; d: {$ifndef FPC}@{$endif}@glGetProgramStringNV),
    (n: 'glGetTrackMatrixivNV'; d: {$ifndef FPC}@{$endif}@glGetTrackMatrixivNV),
    (n: 'glGetVertexAttribdvNV'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribdvNV),
    (n: 'glGetVertexAttribfvNV'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribfvNV),
    (n: 'glGetVertexAttribivNV'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribivNV),
    (n: 'glGetVertexAttribPointervNV'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribPointervNV),
    (n: 'glIsProgramNV'; d: {$ifndef FPC}@{$endif}@glIsProgramNV),
    (n: 'glLoadProgramNV'; d: {$ifndef FPC}@{$endif}@glLoadProgramNV),
    (n: 'glProgramParameter4fNV'; d: {$ifndef FPC}@{$endif}@glProgramParameter4fNV),
    (n: 'glProgramParameter4fvNV'; d: {$ifndef FPC}@{$endif}@glProgramParameter4fvNV),
    (n: 'glProgramParameters4dvNV'; d: {$ifndef FPC}@{$endif}@glProgramParameters4dvNV),
    (n: 'glProgramParameters4fvNV'; d: {$ifndef FPC}@{$endif}@glProgramParameters4fvNV),
    (n: 'glTrackMatrixNV'; d: {$ifndef FPC}@{$endif}@glTrackMatrixNV),
    (n: 'glVertexAttribPointerNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribPointerNV),
    (n: 'glVertexAttrib1sNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1sNV),
    (n: 'glVertexAttrib1fNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fNV),
    (n: 'glVertexAttrib1dNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dNV),
    (n: 'glVertexAttrib2sNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2sNV),
    (n: 'glVertexAttrib2fNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fNV),
    (n: 'glVertexAttrib2dNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dNV),
    (n: 'glVertexAttrib3sNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3sNV),
    (n: 'glVertexAttrib3fNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fNV),
    (n: 'glVertexAttrib3dNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dNV),
    (n: 'glVertexAttrib4sNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4sNV),
    (n: 'glVertexAttrib4fNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fNV),
    (n: 'glVertexAttrib4dNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dNV),
    (n: 'glVertexAttrib4ubNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ubNV),
    (n: 'glVertexAttrib1svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1svNV),
    (n: 'glVertexAttrib1fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fvNV),
    (n: 'glVertexAttrib1dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dvNV),
    (n: 'glVertexAttrib2svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2svNV),
    (n: 'glVertexAttrib2fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fvNV),
    (n: 'glVertexAttrib2dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dvNV),
    (n: 'glVertexAttrib3svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3svNV),
    (n: 'glVertexAttrib3fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fvNV),
    (n: 'glVertexAttrib3dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dvNV),
    (n: 'glVertexAttrib4svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4svNV),
    (n: 'glVertexAttrib4fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fvNV),
    (n: 'glVertexAttrib4dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dvNV),
    (n: 'glVertexAttrib4ubvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ubvNV),
    (n: 'glVertexAttribs1svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs1svNV),
    (n: 'glVertexAttribs1fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs1fvNV),
    (n: 'glVertexAttribs1dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs1dvNV),
    (n: 'glVertexAttribs2svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs2svNV),
    (n: 'glVertexAttribs2fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs2fvNV),
    (n: 'glVertexAttribs2dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs2dvNV),
    (n: 'glVertexAttribs3svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs3svNV),
    (n: 'glVertexAttribs3fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs3fvNV),
    (n: 'glVertexAttribs3dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs3dvNV),
    (n: 'glVertexAttribs4svNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs4svNV),
    (n: 'glVertexAttribs4fvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs4fvNV),
    (n: 'glVertexAttribs4dvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs4dvNV),
    (n: 'glVertexAttribs4ubvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs4ubvNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_vertex_program1_1: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ATI_element_array: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glElementPointerATI'; d: {$ifndef FPC}@{$endif}@glElementPointerATI),
    (n: 'glDrawElementArrayATI'; d: {$ifndef FPC}@{$endif}@glDrawElementArrayATI),
    (n: 'glDrawRangeElementArrayATI'; d: {$ifndef FPC}@{$endif}@glDrawRangeElementArrayATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_envmap_bumpmap: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glTexBumpParameterivATI'; d: {$ifndef FPC}@{$endif}@glTexBumpParameterivATI),
    (n: 'glTexBumpParameterfvATI'; d: {$ifndef FPC}@{$endif}@glTexBumpParameterfvATI),
    (n: 'glGetTexBumpParameterivATI'; d: {$ifndef FPC}@{$endif}@glGetTexBumpParameterivATI),
    (n: 'glGetTexBumpParameterfvATI'; d: {$ifndef FPC}@{$endif}@glGetTexBumpParameterfvATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_fragment_shader: Boolean;
const
 funcs: array[0..13] of funcinfoty =
   (
    (n: 'glGenFragmentShadersATI'; d: {$ifndef FPC}@{$endif}@glGenFragmentShadersATI),
    (n: 'glBindFragmentShaderATI'; d: {$ifndef FPC}@{$endif}@glBindFragmentShaderATI),
    (n: 'glDeleteFragmentShaderATI'; d: {$ifndef FPC}@{$endif}@glDeleteFragmentShaderATI),
    (n: 'glBeginFragmentShaderATI'; d: {$ifndef FPC}@{$endif}@glBeginFragmentShaderATI),
    (n: 'glEndFragmentShaderATI'; d: {$ifndef FPC}@{$endif}@glEndFragmentShaderATI),
    (n: 'glPassTexCoordATI'; d: {$ifndef FPC}@{$endif}@glPassTexCoordATI),
    (n: 'glSampleMapATI'; d: {$ifndef FPC}@{$endif}@glSampleMapATI),
    (n: 'glColorFragmentOp1ATI'; d: {$ifndef FPC}@{$endif}@glColorFragmentOp1ATI),
    (n: 'glColorFragmentOp2ATI'; d: {$ifndef FPC}@{$endif}@glColorFragmentOp2ATI),
    (n: 'glColorFragmentOp3ATI'; d: {$ifndef FPC}@{$endif}@glColorFragmentOp3ATI),
    (n: 'glAlphaFragmentOp1ATI'; d: {$ifndef FPC}@{$endif}@glAlphaFragmentOp1ATI),
    (n: 'glAlphaFragmentOp2ATI'; d: {$ifndef FPC}@{$endif}@glAlphaFragmentOp2ATI),
    (n: 'glAlphaFragmentOp3ATI'; d: {$ifndef FPC}@{$endif}@glAlphaFragmentOp3ATI),
    (n: 'glSetFragmentShaderConstantATI'; d: {$ifndef FPC}@{$endif}@glSetFragmentShaderConstantATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_pn_triangles: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPNTrianglesiATI'; d: {$ifndef FPC}@{$endif}@glPNTrianglesiATI),
    (n: 'glPNTrianglesfATI'; d: {$ifndef FPC}@{$endif}@glPNTrianglesfATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_texture_mirror_once: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ATI_vertex_array_object: Boolean;
const
 funcs: array[0..11] of funcinfoty =
   (
    (n: 'glNewObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glNewObjectBufferATI),
    (n: 'glIsObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glIsObjectBufferATI),
    (n: 'glUpdateObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glUpdateObjectBufferATI),
    (n: 'glGetObjectBufferfvATI'; d: {$ifndef FPC}@{$endif}@glGetObjectBufferfvATI),
    (n: 'glGetObjectBufferivATI'; d: {$ifndef FPC}@{$endif}@glGetObjectBufferivATI),
    (n: 'glDeleteObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glDeleteObjectBufferATI),
    (n: 'glArrayObjectATI'; d: {$ifndef FPC}@{$endif}@glArrayObjectATI),
    (n: 'glGetArrayObjectfvATI'; d: {$ifndef FPC}@{$endif}@glGetArrayObjectfvATI),
    (n: 'glGetArrayObjectivATI'; d: {$ifndef FPC}@{$endif}@glGetArrayObjectivATI),
    (n: 'glVariantArrayObjectATI'; d: {$ifndef FPC}@{$endif}@glVariantArrayObjectATI),
    (n: 'glGetVariantArrayObjectfvATI'; d: {$ifndef FPC}@{$endif}@glGetVariantArrayObjectfvATI),
    (n: 'glGetVariantArrayObjectivATI'; d: {$ifndef FPC}@{$endif}@glGetVariantArrayObjectivATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_vertex_streams: Boolean;
const
 funcs: array[0..44] of funcinfoty =
   (
    (n: 'glVertexStream1s'; d: {$ifndef FPC}@{$endif}@glVertexStream1s),
    (n: 'glVertexStream1i'; d: {$ifndef FPC}@{$endif}@glVertexStream1i),
    (n: 'glVertexStream1f'; d: {$ifndef FPC}@{$endif}@glVertexStream1f),
    (n: 'glVertexStream1d'; d: {$ifndef FPC}@{$endif}@glVertexStream1d),
    (n: 'glVertexStream1sv'; d: {$ifndef FPC}@{$endif}@glVertexStream1sv),
    (n: 'glVertexStream1iv'; d: {$ifndef FPC}@{$endif}@glVertexStream1iv),
    (n: 'glVertexStream1fv'; d: {$ifndef FPC}@{$endif}@glVertexStream1fv),
    (n: 'glVertexStream1dv'; d: {$ifndef FPC}@{$endif}@glVertexStream1dv),
    (n: 'glVertexStream2s'; d: {$ifndef FPC}@{$endif}@glVertexStream2s),
    (n: 'glVertexStream2i'; d: {$ifndef FPC}@{$endif}@glVertexStream2i),
    (n: 'glVertexStream2f'; d: {$ifndef FPC}@{$endif}@glVertexStream2f),
    (n: 'glVertexStream2d'; d: {$ifndef FPC}@{$endif}@glVertexStream2d),
    (n: 'glVertexStream2sv'; d: {$ifndef FPC}@{$endif}@glVertexStream2sv),
    (n: 'glVertexStream2iv'; d: {$ifndef FPC}@{$endif}@glVertexStream2iv),
    (n: 'glVertexStream2fv'; d: {$ifndef FPC}@{$endif}@glVertexStream2fv),
    (n: 'glVertexStream2dv'; d: {$ifndef FPC}@{$endif}@glVertexStream2dv),
    (n: 'glVertexStream3s'; d: {$ifndef FPC}@{$endif}@glVertexStream3s),
    (n: 'glVertexStream3i'; d: {$ifndef FPC}@{$endif}@glVertexStream3i),
    (n: 'glVertexStream3f'; d: {$ifndef FPC}@{$endif}@glVertexStream3f),
    (n: 'glVertexStream3d'; d: {$ifndef FPC}@{$endif}@glVertexStream3d),
    (n: 'glVertexStream3sv'; d: {$ifndef FPC}@{$endif}@glVertexStream3sv),
    (n: 'glVertexStream3iv'; d: {$ifndef FPC}@{$endif}@glVertexStream3iv),
    (n: 'glVertexStream3fv'; d: {$ifndef FPC}@{$endif}@glVertexStream3fv),
    (n: 'glVertexStream3dv'; d: {$ifndef FPC}@{$endif}@glVertexStream3dv),
    (n: 'glVertexStream4s'; d: {$ifndef FPC}@{$endif}@glVertexStream4s),
    (n: 'glVertexStream4i'; d: {$ifndef FPC}@{$endif}@glVertexStream4i),
    (n: 'glVertexStream4f'; d: {$ifndef FPC}@{$endif}@glVertexStream4f),
    (n: 'glVertexStream4d'; d: {$ifndef FPC}@{$endif}@glVertexStream4d),
    (n: 'glVertexStream4sv'; d: {$ifndef FPC}@{$endif}@glVertexStream4sv),
    (n: 'glVertexStream4iv'; d: {$ifndef FPC}@{$endif}@glVertexStream4iv),
    (n: 'glVertexStream4fv'; d: {$ifndef FPC}@{$endif}@glVertexStream4fv),
    (n: 'glVertexStream4dv'; d: {$ifndef FPC}@{$endif}@glVertexStream4dv),
    (n: 'glNormalStream3b'; d: {$ifndef FPC}@{$endif}@glNormalStream3b),
    (n: 'glNormalStream3s'; d: {$ifndef FPC}@{$endif}@glNormalStream3s),
    (n: 'glNormalStream3i'; d: {$ifndef FPC}@{$endif}@glNormalStream3i),
    (n: 'glNormalStream3f'; d: {$ifndef FPC}@{$endif}@glNormalStream3f),
    (n: 'glNormalStream3d'; d: {$ifndef FPC}@{$endif}@glNormalStream3d),
    (n: 'glNormalStream3bv'; d: {$ifndef FPC}@{$endif}@glNormalStream3bv),
    (n: 'glNormalStream3sv'; d: {$ifndef FPC}@{$endif}@glNormalStream3sv),
    (n: 'glNormalStream3iv'; d: {$ifndef FPC}@{$endif}@glNormalStream3iv),
    (n: 'glNormalStream3fv'; d: {$ifndef FPC}@{$endif}@glNormalStream3fv),
    (n: 'glNormalStream3dv'; d: {$ifndef FPC}@{$endif}@glNormalStream3dv),
    (n: 'glClientActiveVertexStream'; d: {$ifndef FPC}@{$endif}@glClientActiveVertexStream),
    (n: 'glVertexBlendEnvi'; d: {$ifndef FPC}@{$endif}@glVertexBlendEnvi),
    (n: 'glVertexBlendEnvf'; d: {$ifndef FPC}@{$endif}@glVertexBlendEnvf)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

{$IFDEF msWindows}
function Load_WGL_I3D_image_buffer: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'wglCreateImageBufferI3D'; d: {$ifndef FPC}@{$endif}@wglCreateImageBufferI3D),
    (n: 'wglDestroyImageBufferI3D'; d: {$ifndef FPC}@{$endif}@wglDestroyImageBufferI3D),
    (n: 'wglAssociateImageBufferEventsI3D'; d: {$ifndef FPC}@{$endif}@wglAssociateImageBufferEventsI3D),
    (n: 'wglReleaseImageBufferEventsI3D'; d: {$ifndef FPC}@{$endif}@wglReleaseImageBufferEventsI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_I3D_swap_frame_lock: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'wglEnableFrameLockI3D'; d: {$ifndef FPC}@{$endif}@wglEnableFrameLockI3D),
    (n: 'wglDisableFrameLockI3D'; d: {$ifndef FPC}@{$endif}@wglDisableFrameLockI3D),
    (n: 'wglIsEnabledFrameLockI3D'; d: {$ifndef FPC}@{$endif}@wglIsEnabledFrameLockI3D),
    (n: 'wglQueryFrameLockMasterI3D'; d: {$ifndef FPC}@{$endif}@wglQueryFrameLockMasterI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_I3D_swap_frame_usage: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'wglGetFrameUsageI3D'; d: {$ifndef FPC}@{$endif}@wglGetFrameUsageI3D),
    (n: 'wglBeginFrameTrackingI3D'; d: {$ifndef FPC}@{$endif}@wglBeginFrameTrackingI3D),
    (n: 'wglEndFrameTrackingI3D'; d: {$ifndef FPC}@{$endif}@wglEndFrameTrackingI3D),
    (n: 'wglQueryFrameTrackingI3D'; d: {$ifndef FPC}@{$endif}@wglQueryFrameTrackingI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;
{$ENDIF}

function Load_GL_3DFX_texture_compression_FXT1: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_IBM_cull_vertex: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_IBM_multimode_draw_arrays: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glMultiModeDrawArraysIBM'; d: {$ifndef FPC}@{$endif}@glMultiModeDrawArraysIBM),
    (n: 'glMultiModeDrawElementsIBM'; d: {$ifndef FPC}@{$endif}@glMultiModeDrawElementsIBM)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_IBM_raster_pos_clip: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_IBM_texture_mirrored_repeat: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_IBM_vertex_array_lists: Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glColorPointerListIBM'; d: {$ifndef FPC}@{$endif}@glColorPointerListIBM),
    (n: 'glSecondaryColorPointerListIBM'; d: {$ifndef FPC}@{$endif}@glSecondaryColorPointerListIBM),
    (n: 'glEdgeFlagPointerListIBM'; d: {$ifndef FPC}@{$endif}@glEdgeFlagPointerListIBM),
    (n: 'glFogCoordPointerListIBM'; d: {$ifndef FPC}@{$endif}@glFogCoordPointerListIBM),
    (n: 'glNormalPointerListIBM'; d: {$ifndef FPC}@{$endif}@glNormalPointerListIBM),
    (n: 'glTexCoordPointerListIBM'; d: {$ifndef FPC}@{$endif}@glTexCoordPointerListIBM),
    (n: 'glVertexPointerListIBM'; d: {$ifndef FPC}@{$endif}@glVertexPointerListIBM)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_MESA_resize_buffers: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glResizeBuffersMESA'; d: {$ifndef FPC}@{$endif}@glResizeBuffersMESA)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_MESA_window_pos: Boolean;
const
 funcs: array[0..23] of funcinfoty =
   (
    (n: 'glWindowPos2dMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2dMESA),
    (n: 'glWindowPos2fMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2fMESA),
    (n: 'glWindowPos2iMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2iMESA),
    (n: 'glWindowPos2sMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2sMESA),
    (n: 'glWindowPos2ivMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2ivMESA),
    (n: 'glWindowPos2svMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2svMESA),
    (n: 'glWindowPos2fvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2fvMESA),
    (n: 'glWindowPos2dvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos2dvMESA),
    (n: 'glWindowPos3iMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3iMESA),
    (n: 'glWindowPos3sMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3sMESA),
    (n: 'glWindowPos3fMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3fMESA),
    (n: 'glWindowPos3dMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3dMESA),
    (n: 'glWindowPos3ivMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3ivMESA),
    (n: 'glWindowPos3svMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3svMESA),
    (n: 'glWindowPos3fvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3fvMESA),
    (n: 'glWindowPos3dvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos3dvMESA),
    (n: 'glWindowPos4iMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4iMESA),
    (n: 'glWindowPos4sMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4sMESA),
    (n: 'glWindowPos4fMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4fMESA),
    (n: 'glWindowPos4dMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4dMESA),
    (n: 'glWindowPos4ivMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4ivMESA),
    (n: 'glWindowPos4svMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4svMESA),
    (n: 'glWindowPos4fvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4fvMESA),
    (n: 'glWindowPos4dvMESA'; d: {$ifndef FPC}@{$endif}@glWindowPos4dvMESA)
   );
begin
 result:= getprocaddresses(libgl,funcs);

end;

function Load_GL_OML_interlace: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_OML_resample: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_OML_subsample: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIS_generate_mipmap: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIS_multisample: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glSampleMaskSGIS'; d: {$ifndef FPC}@{$endif}@glSampleMaskSGIS),
    (n: 'glSamplePatternSGIS'; d: {$ifndef FPC}@{$endif}@glSamplePatternSGIS)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_SGIS_pixel_texture: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glPixelTexGenParameteriSGIS'; d: {$ifndef FPC}@{$endif}@glPixelTexGenParameteriSGIS),
    (n: 'glPixelTexGenParameterfSGIS'; d: {$ifndef FPC}@{$endif}@glPixelTexGenParameterfSGIS),
    (n: 'glGetPixelTexGenParameterivSGIS'; d: {$ifndef FPC}@{$endif}@glGetPixelTexGenParameterivSGIS),
    (n: 'glGetPixelTexGenParameterfvSGIS'; d: {$ifndef FPC}@{$endif}@glGetPixelTexGenParameterfvSGIS)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_SGIS_texture_border_clamp: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIS_texture_color_mask: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glTextureColorMaskSGIS'; d: {$ifndef FPC}@{$endif}@glTextureColorMaskSGIS)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_SGIS_texture_edge_clamp: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIS_texture_lod: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIS_depth_texture: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIX_fog_offset: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIX_interlace: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGIX_shadow_ambient: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGI_color_matrix: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SGI_color_table: Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glColorTableSGI'; d: {$ifndef FPC}@{$endif}@glColorTableSGI),
    (n: 'glCopyColorTableSGI'; d: {$ifndef FPC}@{$endif}@glCopyColorTableSGI),
    (n: 'glColorTableParameterivSGI'; d: {$ifndef FPC}@{$endif}@glColorTableParameterivSGI),
    (n: 'glColorTableParameterfvSGI'; d: {$ifndef FPC}@{$endif}@glColorTableParameterfvSGI),
    (n: 'glGetColorTableSGI'; d: {$ifndef FPC}@{$endif}@glGetColorTableSGI),
    (n: 'glGetColorTableParameterivSGI'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameterivSGI),
    (n: 'glGetColorTableParameterfvSGI'; d: {$ifndef FPC}@{$endif}@glGetColorTableParameterfvSGI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_SGI_texture_color_table: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_SUN_vertex: Boolean;
const
 funcs: array[0..39] of funcinfoty =
   (
    (n: 'glColor4ubVertex2fSUN'; d: {$ifndef FPC}@{$endif}@glColor4ubVertex2fSUN),
    (n: 'glColor4ubVertex2fvSUN'; d: {$ifndef FPC}@{$endif}@glColor4ubVertex2fvSUN),
    (n: 'glColor4ubVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glColor4ubVertex3fSUN),
    (n: 'glColor4ubVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glColor4ubVertex3fvSUN),
    (n: 'glColor3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glColor3fVertex3fSUN),
    (n: 'glColor3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glColor3fVertex3fvSUN),
    (n: 'glNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glNormal3fVertex3fSUN),
    (n: 'glNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glNormal3fVertex3fvSUN),
    (n: 'glColor4fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glColor4fNormal3fVertex3fSUN),
    (n: 'glColor4fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glColor4fNormal3fVertex3fvSUN),
    (n: 'glTexCoord2fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fVertex3fSUN),
    (n: 'glTexCoord2fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fVertex3fvSUN),
    (n: 'glTexCoord4fVertex4fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord4fVertex4fSUN),
    (n: 'glTexCoord4fVertex4fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord4fVertex4fvSUN),
    (n: 'glTexCoord2fColor4ubVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor4ubVertex3fSUN),
    (n: 'glTexCoord2fColor4ubVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor4ubVertex3fvSUN),
    (n: 'glTexCoord2fColor3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor3fVertex3fSUN),
    (n: 'glTexCoord2fColor3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor3fVertex3fvSUN),
    (n: 'glTexCoord2fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fNormal3fVertex3fSUN),
    (n: 'glTexCoord2fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fNormal3fVertex3fvSUN),
    (n: 'glTexCoord2fColor4fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor4fNormal3fVertex3fSUN),
    (n: 'glTexCoord2fColor4fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord2fColor4fNormal3fVertex3fvSUN),
    (n: 'glTexCoord4fColor4fNormal3fVertex4fSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord4fColor4fNormal3fVertex4fSUN),
    (n: 'glTexCoord4fColor4fNormal3fVertex4fvSUN'; d: {$ifndef FPC}@{$endif}@glTexCoord4fColor4fNormal3fVertex4fvSUN),
    (n: 'glReplacementCodeuiVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiVertex3fSUN),
    (n: 'glReplacementCodeuiVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiVertex3fvSUN),
    (n: 'glReplacementCodeuiColor4ubVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor4ubVertex3fSUN),
    (n: 'glReplacementCodeuiColor4ubVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor4ubVertex3fvSUN),
    (n: 'glReplacementCodeuiColor3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor3fVertex3fSUN),
    (n: 'glReplacementCodeuiColor3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor3fVertex3fvSUN),
    (n: 'glReplacementCodeuiNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiNormal3fVertex3fSUN),
    (n: 'glReplacementCodeuiNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiNormal3fVertex3fvSUN),
    (n: 'glReplacementCodeuiColor4fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor4fNormal3fVertex3fSUN),
    (n: 'glReplacementCodeuiColor4fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiColor4fNormal3fVertex3fvSUN),
    (n: 'glReplacementCodeuiTexCoord2fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fVertex3fSUN),
    (n: 'glReplacementCodeuiTexCoord2fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fVertex3fvSUN),
    (n: 'glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN),
    (n: 'glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN),
    (n: 'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN),
    (n: 'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN'; d: {$ifndef FPC}@{$endif}@glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_fragment_program: Boolean;
const
 funcs: array[0..18] of funcinfoty =
   (
    (n: 'glProgramStringARB'; d: {$ifndef FPC}@{$endif}@glProgramStringARB),
    (n: 'glBindProgramARB'; d: {$ifndef FPC}@{$endif}@glBindProgramARB),
    (n: 'glDeleteProgramsARB'; d: {$ifndef FPC}@{$endif}@glDeleteProgramsARB),
    (n: 'glGenProgramsARB'; d: {$ifndef FPC}@{$endif}@glGenProgramsARB),
    (n: 'glProgramEnvParameter4dARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4dARB),
    (n: 'glProgramEnvParameter4dvARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4dvARB),
    (n: 'glProgramEnvParameter4fARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4fARB),
    (n: 'glProgramEnvParameter4fvARB'; d: {$ifndef FPC}@{$endif}@glProgramEnvParameter4fvARB),
    (n: 'glProgramLocalParameter4dARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dARB),
    (n: 'glProgramLocalParameter4dvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dvARB),
    (n: 'glProgramLocalParameter4fARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fARB),
    (n: 'glProgramLocalParameter4fvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fvARB),
    (n: 'glGetProgramEnvParameterdvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramEnvParameterdvARB),
    (n: 'glGetProgramEnvParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramEnvParameterfvARB),
    (n: 'glGetProgramLocalParameterdvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterdvARB),
    (n: 'glGetProgramLocalParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterfvARB),
    (n: 'glGetProgramivARB'; d: {$ifndef FPC}@{$endif}@glGetProgramivARB),
    (n: 'glGetProgramStringARB'; d: {$ifndef FPC}@{$endif}@glGetProgramStringARB),
    (n: 'glIsProgramARB'; d: {$ifndef FPC}@{$endif}@glIsProgramARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_text_fragment_shader: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_APPLE_client_storage: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_APPLE_element_array: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'glElementPointerAPPLE'; d: {$ifndef FPC}@{$endif}@glElementPointerAPPLE),
    (n: 'glDrawElementArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glDrawElementArrayAPPLE),
    (n: 'glDrawRangeElementArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glDrawRangeElementArrayAPPLE),
    (n: 'glMultiDrawElementArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glMultiDrawElementArrayAPPLE),
    (n: 'glMultiDrawRangeElementArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glMultiDrawRangeElementArrayAPPLE)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_APPLE_fence: Boolean;
const
 funcs: array[0..7] of funcinfoty =
   (
    (n: 'glGenFencesAPPLE'; d: {$ifndef FPC}@{$endif}@glGenFencesAPPLE),
    (n: 'glDeleteFencesAPPLE'; d: {$ifndef FPC}@{$endif}@glDeleteFencesAPPLE),
    (n: 'glSetFenceAPPLE'; d: {$ifndef FPC}@{$endif}@glSetFenceAPPLE),
    (n: 'glIsFenceAPPLE'; d: {$ifndef FPC}@{$endif}@glIsFenceAPPLE),
    (n: 'glTestFenceAPPLE'; d: {$ifndef FPC}@{$endif}@glTestFenceAPPLE),
    (n: 'glFinishFenceAPPLE'; d: {$ifndef FPC}@{$endif}@glFinishFenceAPPLE),
    (n: 'glTestObjectAPPLE'; d: {$ifndef FPC}@{$endif}@glTestObjectAPPLE),
    (n: 'glFinishObjectAPPLE'; d: {$ifndef FPC}@{$endif}@glFinishObjectAPPLE)
   );
begin
 result:= getprocaddresses(libgl,funcs);

end;

function Load_GL_APPLE_vertex_array_object: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glBindVertexArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glBindVertexArrayAPPLE),
    (n: 'glDeleteVertexArraysAPPLE'; d: {$ifndef FPC}@{$endif}@glDeleteVertexArraysAPPLE),
    (n: 'glGenVertexArraysAPPLE'; d: {$ifndef FPC}@{$endif}@glGenVertexArraysAPPLE),
    (n: 'glIsVertexArrayAPPLE'; d: {$ifndef FPC}@{$endif}@glIsVertexArrayAPPLE)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_APPLE_vertex_array_range: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glVertexArrayRangeAPPLE'; d: {$ifndef FPC}@{$endif}@glVertexArrayRangeAPPLE),
    (n: 'glFlushVertexArrayRangeAPPLE'; d: {$ifndef FPC}@{$endif}@glFlushVertexArrayRangeAPPLE),
    (n: 'glVertexArrayParameteriAPPLE'; d: {$ifndef FPC}@{$endif}@glVertexArrayParameteriAPPLE)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;


function load_GL_ARB_vertex_buffer_object : boolean;
const
 funcs: array[0..10] of funcinfoty =
   (
    (n: 'glBindBufferARB'; d: {$ifndef FPC}@{$endif}@glBindBufferARB),
    (n: 'glDeleteBuffersARB'; d: {$ifndef FPC}@{$endif}@glDeleteBuffersARB),
    (n: 'glGenBuffersARB'; d: {$ifndef FPC}@{$endif}@glGenBuffersARB),
    (n: 'glIsBufferARB'; d: {$ifndef FPC}@{$endif}@glIsBufferARB),
    (n: 'glBufferDataARB'; d: {$ifndef FPC}@{$endif}@glBufferDataARB),
    (n: 'glBufferSubDataARB'; d: {$ifndef FPC}@{$endif}@glBufferSubDataARB),
    (n: 'glGetBufferSubDataARB'; d: {$ifndef FPC}@{$endif}@glGetBufferSubDataARB),
    (n: 'glMapBufferARB'; d: {$ifndef FPC}@{$endif}@glMapBufferARB),
    (n: 'glUnmapBufferARB'; d: {$ifndef FPC}@{$endif}@glUnmapBufferARB),
    (n: 'glGetBufferParameterivARB'; d: {$ifndef FPC}@{$endif}@glGetBufferParameterivARB),
    (n: 'glGetBufferPointervARB'; d: {$ifndef FPC}@{$endif}@glGetBufferPointervARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

{$IFDEF msWindows}
function Load_WGL_ARB_pixel_format: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'wglGetPixelFormatAttribivARB'; d: {$ifndef FPC}@{$endif}@wglGetPixelFormatAttribivARB),
    (n: 'wglGetPixelFormatAttribfvARB'; d: {$ifndef FPC}@{$endif}@wglGetPixelFormatAttribfvARB),
    (n: 'wglChoosePixelFormatARB'; d: {$ifndef FPC}@{$endif}@wglChoosePixelFormatARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_ARB_make_current_read: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'wglMakeContextCurrentARB'; d: {$ifndef FPC}@{$endif}@wglMakeContextCurrentARB),
    (n: 'wglGetCurrentReadDCARB'; d: {$ifndef FPC}@{$endif}@wglGetCurrentReadDCARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_ARB_pbuffer: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'wglCreatePbufferARB'; d: {$ifndef FPC}@{$endif}@wglCreatePbufferARB),
    (n: 'wglGetPbufferDCARB'; d: {$ifndef FPC}@{$endif}@wglGetPbufferDCARB),
    (n: 'wglReleasePbufferDCARB'; d: {$ifndef FPC}@{$endif}@wglReleasePbufferDCARB),
    (n: 'wglDestroyPbufferARB'; d: {$ifndef FPC}@{$endif}@wglDestroyPbufferARB),
    (n: 'wglQueryPbufferARB'; d: {$ifndef FPC}@{$endif}@wglQueryPbufferARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);

end;

function Load_WGL_EXT_swap_control: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'wglSwapIntervalEXT'; d: {$ifndef FPC}@{$endif}@wglSwapIntervalEXT),
    (n: 'wglGetSwapIntervalEXT'; d: {$ifndef FPC}@{$endif}@wglGetSwapIntervalEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_ARB_render_texture: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'wglBindTexImageARB'; d: {$ifndef FPC}@{$endif}@wglBindTexImageARB),
    (n: 'wglReleaseTexImageARB'; d: {$ifndef FPC}@{$endif}@wglReleaseTexImageARB),
    (n: 'wglSetPbufferAttribARB'; d: {$ifndef FPC}@{$endif}@wglSetPbufferAttribARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_EXT_extensions_string: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'wglGetExtensionsStringEXT'; d: {$ifndef FPC}@{$endif}@wglGetExtensionsStringEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_EXT_make_current_read: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'wglMakeContextCurrentEXT'; d: {$ifndef FPC}@{$endif}@wglMakeContextCurrentEXT),
    (n: 'wglGetCurrentReadDCEXT'; d: {$ifndef FPC}@{$endif}@wglGetCurrentReadDCEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_EXT_pbuffer: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'wglCreatePbufferEXT'; d: {$ifndef FPC}@{$endif}@wglCreatePbufferEXT),
    (n: 'wglGetPbufferDCEXT'; d: {$ifndef FPC}@{$endif}@wglGetPbufferDCEXT),
    (n: 'wglReleasePbufferDCEXT'; d: {$ifndef FPC}@{$endif}@wglReleasePbufferDCEXT),
    (n: 'wglDestroyPbufferEXT'; d: {$ifndef FPC}@{$endif}@wglDestroyPbufferEXT),
    (n: 'wglQueryPbufferEXT'; d: {$ifndef FPC}@{$endif}@wglQueryPbufferEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_EXT_pixel_format: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'wglGetPixelFormatAttribivEXT'; d: {$ifndef FPC}@{$endif}@wglGetPixelFormatAttribivEXT),
    (n: 'wglGetPixelFormatAttribfvEXT'; d: {$ifndef FPC}@{$endif}@wglGetPixelFormatAttribfvEXT),
    (n: 'wglChoosePixelFormatEXT'; d: {$ifndef FPC}@{$endif}@wglChoosePixelFormatEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_I3D_digital_video_control: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'wglGetDigitalVideoParametersI3D'; d: {$ifndef FPC}@{$endif}@wglGetDigitalVideoParametersI3D),
    (n: 'wglSetDigitalVideoParametersI3D'; d: {$ifndef FPC}@{$endif}@wglSetDigitalVideoParametersI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_I3D_gamma: Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'wglGetGammaTableParametersI3D'; d: {$ifndef FPC}@{$endif}@wglGetGammaTableParametersI3D),
    (n: 'wglSetGammaTableParametersI3D'; d: {$ifndef FPC}@{$endif}@wglSetGammaTableParametersI3D),
    (n: 'wglGetGammaTableI3D'; d: {$ifndef FPC}@{$endif}@wglGetGammaTableI3D),
    (n: 'wglSetGammaTableI3D'; d: {$ifndef FPC}@{$endif}@wglSetGammaTableI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_WGL_I3D_genlock: Boolean;
const
 funcs: array[0..11] of funcinfoty =
   (
    (n: 'wglEnableGenlockI3D'; d: {$ifndef FPC}@{$endif}@wglEnableGenlockI3D),
    (n: 'wglDisableGenlockI3D'; d: {$ifndef FPC}@{$endif}@wglDisableGenlockI3D),
    (n: 'wglIsEnabledGenlockI3D'; d: {$ifndef FPC}@{$endif}@wglIsEnabledGenlockI3D),
    (n: 'wglGenlockSourceI3D'; d: {$ifndef FPC}@{$endif}@wglGenlockSourceI3D),
    (n: 'wglGetGenlockSourceI3D'; d: {$ifndef FPC}@{$endif}@wglGetGenlockSourceI3D),
    (n: 'wglGenlockSourceEdgeI3D'; d: {$ifndef FPC}@{$endif}@wglGenlockSourceEdgeI3D),
    (n: 'wglGetGenlockSourceEdgeI3D'; d: {$ifndef FPC}@{$endif}@wglGetGenlockSourceEdgeI3D),
    (n: 'wglGenlockSampleRateI3D'; d: {$ifndef FPC}@{$endif}@wglGenlockSampleRateI3D),
    (n: 'wglGetGenlockSampleRateI3D'; d: {$ifndef FPC}@{$endif}@wglGetGenlockSampleRateI3D),
    (n: 'wglGenlockSourceDelayI3D'; d: {$ifndef FPC}@{$endif}@wglGenlockSourceDelayI3D),
    (n: 'wglGetGenlockSourceDelayI3D'; d: {$ifndef FPC}@{$endif}@wglGetGenlockSourceDelayI3D),
    (n: 'wglQueryGenlockMaxSourceDelayI3D'; d: {$ifndef FPC}@{$endif}@wglQueryGenlockMaxSourceDelayI3D)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;
{$ENDIF}

function Load_GL_ARB_matrix_palette: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'glCurrentPaletteMatrixARB'; d: {$ifndef FPC}@{$endif}@glCurrentPaletteMatrixARB),
    (n: 'glMatrixIndexubvARB'; d: {$ifndef FPC}@{$endif}@glMatrixIndexubvARB),
    (n: 'glMatrixIndexusvARB'; d: {$ifndef FPC}@{$endif}@glMatrixIndexusvARB),
    (n: 'glMatrixIndexuivARB'; d: {$ifndef FPC}@{$endif}@glMatrixIndexuivARB),
    (n: 'glMatrixIndexPointerARB'; d: {$ifndef FPC}@{$endif}@glMatrixIndexPointerARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_element_array: Boolean;
const
 funcs: array[0..4] of funcinfoty =
   (
    (n: 'glElementPointerNV'; d: {$ifndef FPC}@{$endif}@glElementPointerNV),
    (n: 'glDrawElementArrayNV'; d: {$ifndef FPC}@{$endif}@glDrawElementArrayNV),
    (n: 'glDrawRangeElementArrayNV'; d: {$ifndef FPC}@{$endif}@glDrawRangeElementArrayNV),
    (n: 'glMultiDrawElementArrayNV'; d: {$ifndef FPC}@{$endif}@glMultiDrawElementArrayNV),
    (n: 'glMultiDrawRangeElementArrayNV'; d: {$ifndef FPC}@{$endif}@glMultiDrawRangeElementArrayNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_float_buffer: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_fragment_program: Boolean;
const
 funcs: array[0..9] of funcinfoty =
   (
    (n: 'glProgramNamedParameter4fNV'; d: {$ifndef FPC}@{$endif}@glProgramNamedParameter4fNV),
    (n: 'glProgramNamedParameter4dNV'; d: {$ifndef FPC}@{$endif}@glProgramNamedParameter4dNV),
    (n: 'glGetProgramNamedParameterfvNV'; d: {$ifndef FPC}@{$endif}@glGetProgramNamedParameterfvNV),
    (n: 'glGetProgramNamedParameterdvNV'; d: {$ifndef FPC}@{$endif}@glGetProgramNamedParameterdvNV),
    (n: 'glProgramLocalParameter4dARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dARB),
    (n: 'glProgramLocalParameter4dvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4dvARB),
    (n: 'glProgramLocalParameter4fARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fARB),
    (n: 'glProgramLocalParameter4fvARB'; d: {$ifndef FPC}@{$endif}@glProgramLocalParameter4fvARB),
    (n: 'glGetProgramLocalParameterdvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterdvARB),
    (n: 'glGetProgramLocalParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetProgramLocalParameterfvARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_primitive_restart: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPrimitiveRestartNV'; d: {$ifndef FPC}@{$endif}@glPrimitiveRestartNV),
    (n: 'glPrimitiveRestartIndexNV'; d: {$ifndef FPC}@{$endif}@glPrimitiveRestartIndexNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_NV_vertex_program2: Boolean;
begin
 result:= true; //no procs
end;

{$IFDEF msWindows}
function Load_WGL_NV_render_texture_rectangle: Boolean;
begin
 result:= true; //no procs
end;
{$ENDIF}

function Load_GL_NV_pixel_data_range: Boolean;
const
 funcs: array[0..{$ifdef mswindows}3{$else}1{$endif}] of funcinfoty =
   (
    (n: 'glPixelDataRangeNV'; d: {$ifndef FPC}@{$endif}@glPixelDataRangeNV),
    (n: 'glFlushPixelDataRangeNV'; d: {$ifndef FPC}@{$endif}@glFlushPixelDataRangeNV)
    {$IFDEF msWindows}
    ,
    (n: 'wglAllocateMemoryNV'; d: {$ifndef FPC}@{$endif}@wglAllocateMemoryNV),
    (n: 'wglFreeMemoryNV'; d: {$ifndef FPC}@{$endif}@wglFreeMemoryNV)
    {$ENDIF}
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_texture_rectangle: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_S3_s3tc: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ATI_draw_buffers: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glDrawBuffersATI'; d: {$ifndef FPC}@{$endif}@glDrawBuffersATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

{$IFDEF msWindows}
function Load_WGL_ATI_pixel_format_float: Boolean;
begin
 result:= true; //no procs
end;
{$ENDIF}

function Load_GL_ATI_texture_env_combine3: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ATI_texture_float: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_texture_expand_normal: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_half_float: Boolean;
const
 funcs: array[0..45] of funcinfoty =
   (
    (n: 'glVertex2hNV'; d: {$ifndef FPC}@{$endif}@glVertex2hNV),
    (n: 'glVertex2hvNV'; d: {$ifndef FPC}@{$endif}@glVertex2hvNV),
    (n: 'glVertex3hNV'; d: {$ifndef FPC}@{$endif}@glVertex3hNV),
    (n: 'glVertex3hvNV'; d: {$ifndef FPC}@{$endif}@glVertex3hvNV),
    (n: 'glVertex4hNV'; d: {$ifndef FPC}@{$endif}@glVertex4hNV),
    (n: 'glVertex4hvNV'; d: {$ifndef FPC}@{$endif}@glVertex4hvNV),
    (n: 'glNormal3hNV'; d: {$ifndef FPC}@{$endif}@glNormal3hNV),
    (n: 'glNormal3hvNV'; d: {$ifndef FPC}@{$endif}@glNormal3hvNV),
    (n: 'glColor3hNV'; d: {$ifndef FPC}@{$endif}@glColor3hNV),
    (n: 'glColor3hvNV'; d: {$ifndef FPC}@{$endif}@glColor3hvNV),
    (n: 'glColor4hNV'; d: {$ifndef FPC}@{$endif}@glColor4hNV),
    (n: 'glColor4hvNV'; d: {$ifndef FPC}@{$endif}@glColor4hvNV),
    (n: 'glTexCoord1hNV'; d: {$ifndef FPC}@{$endif}@glTexCoord1hNV),
    (n: 'glTexCoord1hvNV'; d: {$ifndef FPC}@{$endif}@glTexCoord1hvNV),
    (n: 'glTexCoord2hNV'; d: {$ifndef FPC}@{$endif}@glTexCoord2hNV),
    (n: 'glTexCoord2hvNV'; d: {$ifndef FPC}@{$endif}@glTexCoord2hvNV),
    (n: 'glTexCoord3hNV'; d: {$ifndef FPC}@{$endif}@glTexCoord3hNV),
    (n: 'glTexCoord3hvNV'; d: {$ifndef FPC}@{$endif}@glTexCoord3hvNV),
    (n: 'glTexCoord4hNV'; d: {$ifndef FPC}@{$endif}@glTexCoord4hNV),
    (n: 'glTexCoord4hvNV'; d: {$ifndef FPC}@{$endif}@glTexCoord4hvNV),
    (n: 'glMultiTexCoord1hNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1hNV),
    (n: 'glMultiTexCoord1hvNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord1hvNV),
    (n: 'glMultiTexCoord2hNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2hNV),
    (n: 'glMultiTexCoord2hvNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord2hvNV),
    (n: 'glMultiTexCoord3hNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3hNV),
    (n: 'glMultiTexCoord3hvNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord3hvNV),
    (n: 'glMultiTexCoord4hNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4hNV),
    (n: 'glMultiTexCoord4hvNV'; d: {$ifndef FPC}@{$endif}@glMultiTexCoord4hvNV),
    (n: 'glFogCoordhNV'; d: {$ifndef FPC}@{$endif}@glFogCoordhNV),
    (n: 'glFogCoordhvNV'; d: {$ifndef FPC}@{$endif}@glFogCoordhvNV),
    (n: 'glSecondaryColor3hNV'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3hNV),
    (n: 'glSecondaryColor3hvNV'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3hvNV),
    (n: 'glVertexWeighthNV'; d: {$ifndef FPC}@{$endif}@glVertexWeighthNV),
    (n: 'glVertexWeighthvNV'; d: {$ifndef FPC}@{$endif}@glVertexWeighthvNV),
    (n: 'glVertexAttrib1hNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1hNV),
    (n: 'glVertexAttrib1hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1hvNV),
    (n: 'glVertexAttrib2hNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2hNV),
    (n: 'glVertexAttrib2hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2hvNV),
    (n: 'glVertexAttrib3hNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3hNV),
    (n: 'glVertexAttrib3hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3hvNV),
    (n: 'glVertexAttrib4hNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4hNV),
    (n: 'glVertexAttrib4hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4hvNV),
    (n: 'glVertexAttribs1hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs1hvNV),
    (n: 'glVertexAttribs2hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs2hvNV),
    (n: 'glVertexAttribs3hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs3hvNV),
    (n: 'glVertexAttribs4hvNV'; d: {$ifndef FPC}@{$endif}@glVertexAttribs4hvNV)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_map_object_buffer: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glMapObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glMapObjectBufferATI),
    (n: 'glUnmapObjectBufferATI'; d: {$ifndef FPC}@{$endif}@glUnmapObjectBufferATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_separate_stencil: Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glStencilOpSeparateATI'; d: {$ifndef FPC}@{$endif}@glStencilOpSeparateATI),
    (n: 'glStencilFuncSeparateATI'; d: {$ifndef FPC}@{$endif}@glStencilFuncSeparateATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ATI_vertex_attrib_array_object: Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glVertexAttribArrayObjectATI'; d: {$ifndef FPC}@{$endif}@glVertexAttribArrayObjectATI),
    (n: 'glGetVertexAttribArrayObjectfvATI'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribArrayObjectfvATI),
    (n: 'glGetVertexAttribArrayObjectivATI'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribArrayObjectivATI)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_occlusion_query: Boolean;
const
 funcs: array[0..7] of funcinfoty =
   (
    (n: 'glGenQueriesARB'; d: {$ifndef FPC}@{$endif}@glGenQueriesARB),
    (n: 'glDeleteQueriesARB'; d: {$ifndef FPC}@{$endif}@glDeleteQueriesARB),
    (n: 'glIsQueryARB'; d: {$ifndef FPC}@{$endif}@glIsQueryARB),
    (n: 'glBeginQueryARB'; d: {$ifndef FPC}@{$endif}@glBeginQueryARB),
    (n: 'glEndQueryARB'; d: {$ifndef FPC}@{$endif}@glEndQueryARB),
    (n: 'glGetQueryivARB'; d: {$ifndef FPC}@{$endif}@glGetQueryivARB),
    (n: 'glGetQueryObjectivARB'; d: {$ifndef FPC}@{$endif}@glGetQueryObjectivARB),
    (n: 'glGetQueryObjectuivARB'; d: {$ifndef FPC}@{$endif}@glGetQueryObjectuivARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_shader_objects: Boolean;
const
 funcs: array[0..38] of funcinfoty =
   (
    (n: 'glDeleteObjectARB'; d: {$ifndef FPC}@{$endif}@glDeleteObjectARB),
    (n: 'glGetHandleARB'; d: {$ifndef FPC}@{$endif}@glGetHandleARB),
    (n: 'glDetachObjectARB'; d: {$ifndef FPC}@{$endif}@glDetachObjectARB),
    (n: 'glCreateShaderObjectARB'; d: {$ifndef FPC}@{$endif}@glCreateShaderObjectARB),
    (n: 'glShaderSourceARB'; d: {$ifndef FPC}@{$endif}@glShaderSourceARB),
    (n: 'glCompileShaderARB'; d: {$ifndef FPC}@{$endif}@glCompileShaderARB),
    (n: 'glCreateProgramObjectARB'; d: {$ifndef FPC}@{$endif}@glCreateProgramObjectARB),
    (n: 'glAttachObjectARB'; d: {$ifndef FPC}@{$endif}@glAttachObjectARB),
    (n: 'glLinkProgramARB'; d: {$ifndef FPC}@{$endif}@glLinkProgramARB),
    (n: 'glUseProgramObjectARB'; d: {$ifndef FPC}@{$endif}@glUseProgramObjectARB),
    (n: 'glValidateProgramARB'; d: {$ifndef FPC}@{$endif}@glValidateProgramARB),
    (n: 'glUniform1fARB'; d: {$ifndef FPC}@{$endif}@glUniform1fARB),
    (n: 'glUniform2fARB'; d: {$ifndef FPC}@{$endif}@glUniform2fARB),
    (n: 'glUniform3fARB'; d: {$ifndef FPC}@{$endif}@glUniform3fARB),
    (n: 'glUniform4fARB'; d: {$ifndef FPC}@{$endif}@glUniform4fARB),
    (n: 'glUniform1iARB'; d: {$ifndef FPC}@{$endif}@glUniform1iARB),
    (n: 'glUniform2iARB'; d: {$ifndef FPC}@{$endif}@glUniform2iARB),
    (n: 'glUniform3iARB'; d: {$ifndef FPC}@{$endif}@glUniform3iARB),
    (n: 'glUniform4iARB'; d: {$ifndef FPC}@{$endif}@glUniform4iARB),
    (n: 'glUniform1fvARB'; d: {$ifndef FPC}@{$endif}@glUniform1fvARB),
    (n: 'glUniform2fvARB'; d: {$ifndef FPC}@{$endif}@glUniform2fvARB),
    (n: 'glUniform3fvARB'; d: {$ifndef FPC}@{$endif}@glUniform3fvARB),
    (n: 'glUniform4fvARB'; d: {$ifndef FPC}@{$endif}@glUniform4fvARB),
    (n: 'glUniform1ivARB'; d: {$ifndef FPC}@{$endif}@glUniform1ivARB),
    (n: 'glUniform2ivARB'; d: {$ifndef FPC}@{$endif}@glUniform2ivARB),
    (n: 'glUniform3ivARB'; d: {$ifndef FPC}@{$endif}@glUniform3ivARB),
    (n: 'glUniform4ivARB'; d: {$ifndef FPC}@{$endif}@glUniform4ivARB),
    (n: 'glUniformMatrix2fvARB'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2fvARB),
    (n: 'glUniformMatrix3fvARB'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3fvARB),
    (n: 'glUniformMatrix4fvARB'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4fvARB),
    (n: 'glGetObjectParameterfvARB'; d: {$ifndef FPC}@{$endif}@glGetObjectParameterfvARB),
    (n: 'glGetObjectParameterivARB'; d: {$ifndef FPC}@{$endif}@glGetObjectParameterivARB),
    (n: 'glGetInfoLogARB'; d: {$ifndef FPC}@{$endif}@glGetInfoLogARB),
    (n: 'glGetAttachedObjectsARB'; d: {$ifndef FPC}@{$endif}@glGetAttachedObjectsARB),
    (n: 'glGetUniformLocationARB'; d: {$ifndef FPC}@{$endif}@glGetUniformLocationARB),
    (n: 'glGetActiveUniformARB'; d: {$ifndef FPC}@{$endif}@glGetActiveUniformARB),
    (n: 'glGetUniformfvARB'; d: {$ifndef FPC}@{$endif}@glGetUniformfvARB),
    (n: 'glGetUniformivARB'; d: {$ifndef FPC}@{$endif}@glGetUniformivARB),
    (n: 'glGetShaderSourceARB'; d: {$ifndef FPC}@{$endif}@glGetShaderSourceARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_vertex_shader: Boolean;
const
 funcs: array[0..45] of funcinfoty =
   (
    (n: 'glVertexAttrib1fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fARB),
    (n: 'glVertexAttrib1sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1sARB),
    (n: 'glVertexAttrib1dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dARB),
    (n: 'glVertexAttrib2fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fARB),
    (n: 'glVertexAttrib2sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2sARB),
    (n: 'glVertexAttrib2dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dARB),
    (n: 'glVertexAttrib3fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fARB),
    (n: 'glVertexAttrib3sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3sARB),
    (n: 'glVertexAttrib3dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dARB),
    (n: 'glVertexAttrib4fARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fARB),
    (n: 'glVertexAttrib4sARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4sARB),
    (n: 'glVertexAttrib4dARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dARB),
    (n: 'glVertexAttrib4NubARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NubARB),
    (n: 'glVertexAttrib1fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fvARB),
    (n: 'glVertexAttrib1svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1svARB),
    (n: 'glVertexAttrib1dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dvARB),
    (n: 'glVertexAttrib2fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fvARB),
    (n: 'glVertexAttrib2svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2svARB),
    (n: 'glVertexAttrib2dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dvARB),
    (n: 'glVertexAttrib3fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fvARB),
    (n: 'glVertexAttrib3svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3svARB),
    (n: 'glVertexAttrib3dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dvARB),
    (n: 'glVertexAttrib4fvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fvARB),
    (n: 'glVertexAttrib4svARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4svARB),
    (n: 'glVertexAttrib4dvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dvARB),
    (n: 'glVertexAttrib4ivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ivARB),
    (n: 'glVertexAttrib4bvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4bvARB),
    (n: 'glVertexAttrib4ubvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ubvARB),
    (n: 'glVertexAttrib4usvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4usvARB),
    (n: 'glVertexAttrib4uivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4uivARB),
    (n: 'glVertexAttrib4NbvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NbvARB),
    (n: 'glVertexAttrib4NsvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NsvARB),
    (n: 'glVertexAttrib4NivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NivARB),
    (n: 'glVertexAttrib4NubvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NubvARB),
    (n: 'glVertexAttrib4NusvARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NusvARB),
    (n: 'glVertexAttrib4NuivARB'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4NuivARB),
    (n: 'glVertexAttribPointerARB'; d: {$ifndef FPC}@{$endif}@glVertexAttribPointerARB),
    (n: 'glEnableVertexAttribArrayARB'; d: {$ifndef FPC}@{$endif}@glEnableVertexAttribArrayARB),
    (n: 'glDisableVertexAttribArrayARB'; d: {$ifndef FPC}@{$endif}@glDisableVertexAttribArrayARB),
    (n: 'glBindAttribLocationARB'; d: {$ifndef FPC}@{$endif}@glBindAttribLocationARB),
    (n: 'glGetActiveAttribARB'; d: {$ifndef FPC}@{$endif}@glGetActiveAttribARB),
    (n: 'glGetAttribLocationARB'; d: {$ifndef FPC}@{$endif}@glGetAttribLocationARB),
    (n: 'glGetVertexAttribdvARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribdvARB),
    (n: 'glGetVertexAttribfvARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribfvARB),
    (n: 'glGetVertexAttribivARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribivARB),
    (n: 'glGetVertexAttribPointervARB'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribPointervARB)
   );

begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_fragment_shader: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_shading_language_100: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_non_power_of_two: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_point_sprite: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_depth_bounds_test: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glDepthBoundsEXT'; d: {$ifndef FPC}@{$endif}@glDepthBoundsEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_EXT_texture_mirror_clamp: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_blend_equation_separate: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glBlendEquationSeparateEXT'; d: {$ifndef FPC}@{$endif}@glBlendEquationSeparateEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_MESA_pack_invert: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_MESA_ycbcr_texture: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_fragment_program_shadow: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_fragment_program_option: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_pixel_buffer_object: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_fragment_program2: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_vertex_program2_option: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_NV_vertex_program3: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_draw_buffers: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glDrawBuffersARB'; d: {$ifndef FPC}@{$endif}@glDrawBuffersARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_texture_rectangle: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_color_buffer_float: Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glClampColorARB'; d: {$ifndef FPC}@{$endif}@glClampColorARB)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_half_float_pixel: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_texture_float: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_texture_compression_dxt1: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_ARB_pixel_buffer_object: Boolean;
begin
 result:= true; //no procs
end;

function Load_GL_EXT_framebuffer_object: Boolean;
const
 funcs: array[0..16] of funcinfoty =
   (
    (n: 'glIsRenderbufferEXT'; d: {$ifndef FPC}@{$endif}@glIsRenderbufferEXT),
    (n: 'glBindRenderbufferEXT'; d: {$ifndef FPC}@{$endif}@glBindRenderbufferEXT),
    (n: 'glDeleteRenderbuffersEXT'; d: {$ifndef FPC}@{$endif}@glDeleteRenderbuffersEXT),
    (n: 'glGenRenderbuffersEXT'; d: {$ifndef FPC}@{$endif}@glGenRenderbuffersEXT),
    (n: 'glRenderbufferStorageEXT'; d: {$ifndef FPC}@{$endif}@glRenderbufferStorageEXT),
    (n: 'glGetRenderbufferParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetRenderbufferParameterivEXT),
    (n: 'glIsFramebufferEXT'; d: {$ifndef FPC}@{$endif}@glIsFramebufferEXT),
    (n: 'glBindFramebufferEXT'; d: {$ifndef FPC}@{$endif}@glBindFramebufferEXT),
    (n: 'glDeleteFramebuffersEXT'; d: {$ifndef FPC}@{$endif}@glDeleteFramebuffersEXT),
    (n: 'glGenFramebuffersEXT'; d: {$ifndef FPC}@{$endif}@glGenFramebuffersEXT),
    (n: 'glCheckFramebufferStatusEXT'; d: {$ifndef FPC}@{$endif}@glCheckFramebufferStatusEXT),
    (n: 'glFramebufferTexture1DEXT'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture1DEXT),
    (n: 'glFramebufferTexture2DEXT'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture2DEXT),
    (n: 'glFramebufferTexture3DEXT'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture3DEXT),
    (n: 'glFramebufferRenderbufferEXT'; d: {$ifndef FPC}@{$endif}@glFramebufferRenderbufferEXT),
    (n: 'glGetFramebufferAttachmentParameterivEXT'; d: {$ifndef FPC}@{$endif}@glGetFramebufferAttachmentParameterivEXT),
    (n: 'glGenerateMipmapEXT'; d: {$ifndef FPC}@{$endif}@glGenerateMipmapEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_framebuffer_object(): Boolean;
const
 funcs: array[0..19] of funcinfoty =
   (
    (n: 'glIsRenderbuffer'; d: {$ifndef FPC}@{$endif}@glIsRenderbuffer),
    (n: 'glBindRenderbuffer'; d: {$ifndef FPC}@{$endif}@glBindRenderbuffer),
    (n: 'glDeleteRenderbuffers'; d: {$ifndef FPC}@{$endif}@glDeleteRenderbuffers),
    (n: 'glGenRenderbuffers'; d: {$ifndef FPC}@{$endif}@glGenRenderbuffers),
    (n: 'glRenderbufferStorage'; d: {$ifndef FPC}@{$endif}@glRenderbufferStorage),
    (n: 'glGetRenderbufferParameteriv'; d: {$ifndef FPC}@{$endif}@glGetRenderbufferParameteriv),
    (n: 'glIsFramebuffer'; d: {$ifndef FPC}@{$endif}@glIsFramebuffer),
    (n: 'glBindFramebuffer'; d: {$ifndef FPC}@{$endif}@glBindFramebuffer),
    (n: 'glDeleteFramebuffers'; d: {$ifndef FPC}@{$endif}@glDeleteFramebuffers),
    (n: 'glGenFramebuffers'; d: {$ifndef FPC}@{$endif}@glGenFramebuffers),
    (n: 'glCheckFramebufferStatus'; d: {$ifndef FPC}@{$endif}@glCheckFramebufferStatus),
    (n: 'glFramebufferTexture1D'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture1D),
    (n: 'glFramebufferTexture2D'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture2D),
    (n: 'glFramebufferTexture3D'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture3D),
    (n: 'glFramebufferRenderbuffer'; d: {$ifndef FPC}@{$endif}@glFramebufferRenderbuffer),
    (n: 'glGetFramebufferAttachmentParameteriv'; d: {$ifndef FPC}@{$endif}@glGetFramebufferAttachmentParameteriv),
    (n: 'glGenerateMipmap'; d: {$ifndef FPC}@{$endif}@glGenerateMipmap),
    (n: 'glBlitFramebuffer'; d: {$ifndef FPC}@{$endif}@glBlitFramebuffer),
    (n: 'glRenderbufferStorageMultisample'; d: {$ifndef FPC}@{$endif}@glRenderbufferStorageMultisample),
    (n: 'glFramebufferTextureLayer'; d: {$ifndef FPC}@{$endif}@glFramebufferTextureLayer)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_map_buffer_range(): Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glMapBufferRange'; d: {$ifndef FPC}@{$endif}@glMapBufferRange),
    (n: 'glFlushMappedBufferRange'; d: {$ifndef FPC}@{$endif}@glFlushMappedBufferRange)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_vertex_array_object(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glBindVertexArray'; d: {$ifndef FPC}@{$endif}@glBindVertexArray),
    (n: 'glDeleteVertexArrays'; d: {$ifndef FPC}@{$endif}@glDeleteVertexArrays),
    (n: 'glGenVertexArrays'; d: {$ifndef FPC}@{$endif}@glGenVertexArrays),
    (n: 'glIsVertexArray'; d: {$ifndef FPC}@{$endif}@glIsVertexArray)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_copy_buffer(): Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glCopyBufferSubData'; d: {$ifndef FPC}@{$endif}@glCopyBufferSubData)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_uniform_buffer_object(): Boolean;
const
 funcs: array[0..9] of funcinfoty =
   (
    (n: 'glGetUniformIndices'; d: {$ifndef FPC}@{$endif}@glGetUniformIndices),
    (n: 'glGetActiveUniformsiv'; d: {$ifndef FPC}@{$endif}@glGetActiveUniformsiv),
    (n: 'glGetActiveUniformName'; d: {$ifndef FPC}@{$endif}@glGetActiveUniformName),
    (n: 'glGetUniformBlockIndex'; d: {$ifndef FPC}@{$endif}@glGetUniformBlockIndex),
    (n: 'glGetActiveUniformBlockiv'; d: {$ifndef FPC}@{$endif}@glGetActiveUniformBlockiv),
    (n: 'glGetActiveUniformBlockName'; d: {$ifndef FPC}@{$endif}@glGetActiveUniformBlockName),
    (n: 'glUniformBlockBinding'; d: {$ifndef FPC}@{$endif}@glUniformBlockBinding),
    (n: 'glBindBufferRange'; d: {$ifndef FPC}@{$endif}@glBindBufferRange),
    (n: 'glBindBufferBase'; d: {$ifndef FPC}@{$endif}@glBindBufferBase),
    (n: 'glGetIntegeri_v'; d: {$ifndef FPC}@{$endif}@glGetIntegeri_v)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_draw_elements_base_vertex(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glDrawElementsBaseVertex'; d: {$ifndef FPC}@{$endif}@glDrawElementsBaseVertex),
    (n: 'glDrawRangeElementsBaseVertex'; d: {$ifndef FPC}@{$endif}@glDrawRangeElementsBaseVertex),
    (n: 'glDrawElementsInstancedBaseVertex'; d: {$ifndef FPC}@{$endif}@glDrawElementsInstancedBaseVertex),
    (n: 'glMultiDrawElementsBaseVertex'; d: {$ifndef FPC}@{$endif}@glMultiDrawElementsBaseVertex)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_provoking_vertex(): Boolean;
const
 funcs: array[0..0] of funcinfoty =
   (
    (n: 'glProvokingVertex'; d: {$ifndef FPC}@{$endif}@glProvokingVertex)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_sync(): Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glFenceSync'; d: {$ifndef FPC}@{$endif}@glFenceSync),
    (n: 'glIsSync'; d: {$ifndef FPC}@{$endif}@glIsSync),
    (n: 'glDeleteSync'; d: {$ifndef FPC}@{$endif}@glDeleteSync),
    (n: 'glClientWaitSync'; d: {$ifndef FPC}@{$endif}@glClientWaitSync),
    (n: 'glWaitSync'; d: {$ifndef FPC}@{$endif}@glWaitSync),
    (n: 'glGetInteger64v'; d: {$ifndef FPC}@{$endif}@glGetInteger64v),
    (n: 'glGetSynciv'; d: {$ifndef FPC}@{$endif}@glGetSynciv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_texture_multisample(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glTexImage2DMultisample'; d: {$ifndef FPC}@{$endif}@glTexImage2DMultisample),
    (n: 'glTexImage3DMultisample'; d: {$ifndef FPC}@{$endif}@glTexImage3DMultisample),
    (n: 'glGetMultisamplefv'; d: {$ifndef FPC}@{$endif}@glGetMultisamplefv),
    (n: 'glSampleMaski'; d: {$ifndef FPC}@{$endif}@glSampleMaski)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_sampler_objects(): Boolean;
const
 funcs: array[0..13] of funcinfoty =
   (
    (n: 'glGenSamplers'; d: {$ifndef FPC}@{$endif}@glGenSamplers),
    (n: 'glDeleteSamplers'; d: {$ifndef FPC}@{$endif}@glDeleteSamplers),
    (n: 'glIsSampler'; d: {$ifndef FPC}@{$endif}@glIsSampler),
    (n: 'glBindSampler'; d: {$ifndef FPC}@{$endif}@glBindSampler),
    (n: 'glSamplerParameteri'; d: {$ifndef FPC}@{$endif}@glSamplerParameteri),
    (n: 'glSamplerParameteriv'; d: {$ifndef FPC}@{$endif}@glSamplerParameteriv),
    (n: 'glSamplerParameterf'; d: {$ifndef FPC}@{$endif}@glSamplerParameterf),
    (n: 'glSamplerParameterfv'; d: {$ifndef FPC}@{$endif}@glSamplerParameterfv),
    (n: 'glSamplerParameterIiv'; d: {$ifndef FPC}@{$endif}@glSamplerParameterIiv),
    (n: 'glSamplerParameterIuiv'; d: {$ifndef FPC}@{$endif}@glSamplerParameterIuiv),
    (n: 'glGetSamplerParameteriv'; d: {$ifndef FPC}@{$endif}@glGetSamplerParameteriv),
    (n: 'glGetSamplerParameterIiv'; d: {$ifndef FPC}@{$endif}@glGetSamplerParameterIiv),
    (n: 'glGetSamplerParameterfv'; d: {$ifndef FPC}@{$endif}@glGetSamplerParameterfv),
    (n: 'glGetSamplerParameterIfv'; d: {$ifndef FPC}@{$endif}@glGetSamplerParameterIfv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_blend_func_extended(): Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glBindFragDataLocationIndexed'; d: {$ifndef FPC}@{$endif}@glBindFragDataLocationIndexed),
    (n: 'glGetFragDataIndex'; d: {$ifndef FPC}@{$endif}@glGetFragDataIndex)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_timer_query(): Boolean;
const
 funcs: array[0..2] of funcinfoty =
   (
    (n: 'glQueryCounter'; d: {$ifndef FPC}@{$endif}@glQueryCounter),
    (n: 'glGetQueryObjecti64v'; d: {$ifndef FPC}@{$endif}@glGetQueryObjecti64v),
    (n: 'glGetQueryObjectui64v'; d: {$ifndef FPC}@{$endif}@glGetQueryObjectui64v)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_vertex_type_2_10_10_10_rev(): Boolean;
const
 funcs: array[0..37] of funcinfoty =
   (
    (n: 'glVertexP2ui'; d: {$ifndef FPC}@{$endif}@glVertexP2ui),
    (n: 'glVertexP2uiv'; d: {$ifndef FPC}@{$endif}@glVertexP2uiv),
    (n: 'glVertexP3ui'; d: {$ifndef FPC}@{$endif}@glVertexP3ui),
    (n: 'glVertexP3uiv'; d: {$ifndef FPC}@{$endif}@glVertexP3uiv),
    (n: 'glVertexP4ui'; d: {$ifndef FPC}@{$endif}@glVertexP4ui),
    (n: 'glVertexP4uiv'; d: {$ifndef FPC}@{$endif}@glVertexP4uiv),
    (n: 'glTexCoordP1ui'; d: {$ifndef FPC}@{$endif}@glTexCoordP1ui),
    (n: 'glTexCoordP1uiv'; d: {$ifndef FPC}@{$endif}@glTexCoordP1uiv),
    (n: 'glTexCoordP2ui'; d: {$ifndef FPC}@{$endif}@glTexCoordP2ui),
    (n: 'glTexCoordP2uiv'; d: {$ifndef FPC}@{$endif}@glTexCoordP2uiv),
    (n: 'glTexCoordP3ui'; d: {$ifndef FPC}@{$endif}@glTexCoordP3ui),
    (n: 'glTexCoordP3uiv'; d: {$ifndef FPC}@{$endif}@glTexCoordP3uiv),
    (n: 'glTexCoordP4ui'; d: {$ifndef FPC}@{$endif}@glTexCoordP4ui),
    (n: 'glTexCoordP4uiv'; d: {$ifndef FPC}@{$endif}@glTexCoordP4uiv),
    (n: 'glMultiTexCoordP1ui'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP1ui),
    (n: 'glMultiTexCoordP1uiv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP1uiv),
    (n: 'glMultiTexCoordP2ui'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP2ui),
    (n: 'glMultiTexCoordP2uiv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP2uiv),
    (n: 'glMultiTexCoordP3ui'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP3ui),
    (n: 'glMultiTexCoordP3uiv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP3uiv),
    (n: 'glMultiTexCoordP4ui'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP4ui),
    (n: 'glMultiTexCoordP4uiv'; d: {$ifndef FPC}@{$endif}@glMultiTexCoordP4uiv),
    (n: 'glNormalP3ui'; d: {$ifndef FPC}@{$endif}@glNormalP3ui),
    (n: 'glNormalP3uiv'; d: {$ifndef FPC}@{$endif}@glNormalP3uiv),
    (n: 'glColorP3ui'; d: {$ifndef FPC}@{$endif}@glColorP3ui),
    (n: 'glColorP3uiv'; d: {$ifndef FPC}@{$endif}@glColorP3uiv),
    (n: 'glColorP4ui'; d: {$ifndef FPC}@{$endif}@glColorP4ui),
    (n: 'glColorP4uiv'; d: {$ifndef FPC}@{$endif}@glColorP4uiv),
    (n: 'glSecondaryColorP3ui'; d: {$ifndef FPC}@{$endif}@glSecondaryColorP3ui),
    (n: 'glSecondaryColorP3uiv'; d: {$ifndef FPC}@{$endif}@glSecondaryColorP3uiv),
    (n: 'glVertexAttribP1ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribP1ui),
    (n: 'glVertexAttribP1uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribP1uiv),
    (n: 'glVertexAttribP2ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribP2ui),
    (n: 'glVertexAttribP2uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribP2uiv),
    (n: 'glVertexAttribP3ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribP3ui),
    (n: 'glVertexAttribP3uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribP3uiv),
    (n: 'glVertexAttribP4ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribP4ui),
    (n: 'glVertexAttribP4uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribP4uiv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_gpu_shader_fp64(): Boolean;
const
 funcs: array[0..34] of funcinfoty =
   (
    (n: 'glUniform1d'; d: {$ifndef FPC}@{$endif}@glUniform1d),
    (n: 'glUniform2d'; d: {$ifndef FPC}@{$endif}@glUniform2d),
    (n: 'glUniform3d'; d: {$ifndef FPC}@{$endif}@glUniform3d),
    (n: 'glUniform4d'; d: {$ifndef FPC}@{$endif}@glUniform4d),
    (n: 'glUniform1dv'; d: {$ifndef FPC}@{$endif}@glUniform1dv),
    (n: 'glUniform2dv'; d: {$ifndef FPC}@{$endif}@glUniform2dv),
    (n: 'glUniform3dv'; d: {$ifndef FPC}@{$endif}@glUniform3dv),
    (n: 'glUniform4dv'; d: {$ifndef FPC}@{$endif}@glUniform4dv),
    (n: 'glUniformMatrix2dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2dv),
    (n: 'glUniformMatrix3dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3dv),
    (n: 'glUniformMatrix4dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4dv),
    (n: 'glUniformMatrix2x3dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2x3dv),
    (n: 'glUniformMatrix2x4dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2x4dv),
    (n: 'glUniformMatrix3x2dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3x2dv),
    (n: 'glUniformMatrix3x4dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3x4dv),
    (n: 'glUniformMatrix4x2dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4x2dv),
    (n: 'glUniformMatrix4x3dv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4x3dv),
    (n: 'glGetUniformdv'; d: {$ifndef FPC}@{$endif}@glGetUniformdv),
    (n: 'glProgramUniform1dEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform1dEXT),
    (n: 'glProgramUniform2dEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform2dEXT),
    (n: 'glProgramUniform3dEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform3dEXT),
    (n: 'glProgramUniform4dEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform4dEXT),
    (n: 'glProgramUniform1dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform1dvEXT),
    (n: 'glProgramUniform2dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform2dvEXT),
    (n: 'glProgramUniform3dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform3dvEXT),
    (n: 'glProgramUniform4dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniform4dvEXT),
    (n: 'glProgramUniformMatrix2dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix2dvEXT),
    (n: 'glProgramUniformMatrix3dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix3dvEXT),
    (n: 'glProgramUniformMatrix4dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix4dvEXT),
    (n: 'glProgramUniformMatrix2x3dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix2x3dvEXT),
    (n: 'glProgramUniformMatrix2x4dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix2x4dvEXT),
    (n: 'glProgramUniformMatrix3x2dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix3x2dvEXT),
    (n: 'glProgramUniformMatrix3x4dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix3x4dvEXT),
    (n: 'glProgramUniformMatrix4x2dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix4x2dvEXT),
    (n: 'glProgramUniformMatrix4x3dvEXT'; d: {$ifndef FPC}@{$endif}@glProgramUniformMatrix4x3dvEXT)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_shader_subroutine(): Boolean;
const
 funcs: array[0..7] of funcinfoty =
   (
    (n: 'glGetSubroutineUniformLocation'; d: {$ifndef FPC}@{$endif}@glGetSubroutineUniformLocation),
    (n: 'glGetSubroutineIndex'; d: {$ifndef FPC}@{$endif}@glGetSubroutineIndex),
    (n: 'glGetActiveSubroutineUniformiv'; d: {$ifndef FPC}@{$endif}@glGetActiveSubroutineUniformiv),
    (n: 'glGetActiveSubroutineUniformName'; d: {$ifndef FPC}@{$endif}@glGetActiveSubroutineUniformName),
    (n: 'glGetActiveSubroutineName'; d: {$ifndef FPC}@{$endif}@glGetActiveSubroutineName),
    (n: 'glUniformSubroutinesuiv'; d: {$ifndef FPC}@{$endif}@glUniformSubroutinesuiv),
    (n: 'glGetUniformSubroutineuiv'; d: {$ifndef FPC}@{$endif}@glGetUniformSubroutineuiv),
    (n: 'glGetProgramStageiv'; d: {$ifndef FPC}@{$endif}@glGetProgramStageiv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_tessellation_shader(): Boolean;
const
 funcs: array[0..1] of funcinfoty =
   (
    (n: 'glPatchParameteri'; d: {$ifndef FPC}@{$endif}@glPatchParameteri),
    (n: 'glPatchParameterfv'; d: {$ifndef FPC}@{$endif}@glPatchParameterfv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_transform_feedback2(): Boolean;
const
 funcs: array[0..6] of funcinfoty =
   (
    (n: 'glBindTransformFeedback'; d: {$ifndef FPC}@{$endif}@glBindTransformFeedback),
    (n: 'glDeleteTransformFeedbacks'; d: {$ifndef FPC}@{$endif}@glDeleteTransformFeedbacks),
    (n: 'glGenTransformFeedbacks'; d: {$ifndef FPC}@{$endif}@glGenTransformFeedbacks),
    (n: 'glIsTransformFeedback'; d: {$ifndef FPC}@{$endif}@glIsTransformFeedback),
    (n: 'glPauseTransformFeedback'; d: {$ifndef FPC}@{$endif}@glPauseTransformFeedback),
    (n: 'glResumeTransformFeedback'; d: {$ifndef FPC}@{$endif}@glResumeTransformFeedback),
    (n: 'glDrawTransformFeedback'; d: {$ifndef FPC}@{$endif}@glDrawTransformFeedback)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_ARB_transform_feedback3(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glDrawTransformFeedbackStream'; d: {$ifndef FPC}@{$endif}@glDrawTransformFeedbackStream),
    (n: 'glBeginQueryIndexed'; d: {$ifndef FPC}@{$endif}@glBeginQueryIndexed),
    (n: 'glEndQueryIndexed'; d: {$ifndef FPC}@{$endif}@glEndQueryIndexed),
    (n: 'glGetQueryIndexediv'; d: {$ifndef FPC}@{$endif}@glGetQueryIndexediv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_version_1_4: Boolean;
const
 funcs: array[0..44] of funcinfoty =
   (
    (n: 'glBlendFuncSeparate'; d: {$ifndef FPC}@{$endif}@glBlendFuncSeparate),
    (n: 'glFogCoordf'; d: {$ifndef FPC}@{$endif}@glFogCoordf),
    (n: 'glFogCoordfv'; d: {$ifndef FPC}@{$endif}@glFogCoordfv),
    (n: 'glFogCoordd'; d: {$ifndef FPC}@{$endif}@glFogCoordd),
    (n: 'glFogCoorddv'; d: {$ifndef FPC}@{$endif}@glFogCoorddv),
    (n: 'glFogCoordPointer'; d: {$ifndef FPC}@{$endif}@glFogCoordPointer),
    (n: 'glMultiDrawArrays'; d: {$ifndef FPC}@{$endif}@glMultiDrawArrays),
    (n: 'glMultiDrawElements'; d: {$ifndef FPC}@{$endif}@glMultiDrawElements),
    (n: 'glPointParameterf'; d: {$ifndef FPC}@{$endif}@glPointParameterf),
    (n: 'glPointParameterfv'; d: {$ifndef FPC}@{$endif}@glPointParameterfv),
    (n: 'glPointParameteri'; d: {$ifndef FPC}@{$endif}@glPointParameteri),
    (n: 'glPointParameteriv'; d: {$ifndef FPC}@{$endif}@glPointParameteriv),
    (n: 'glSecondaryColor3b'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3b),
    (n: 'glSecondaryColor3bv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3bv),
    (n: 'glSecondaryColor3d'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3d),
    (n: 'glSecondaryColor3dv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3dv),
    (n: 'glSecondaryColor3f'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3f),
    (n: 'glSecondaryColor3fv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3fv),
    (n: 'glSecondaryColor3i'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3i),
    (n: 'glSecondaryColor3iv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3iv),
    (n: 'glSecondaryColor3s'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3s),
    (n: 'glSecondaryColor3sv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3sv),
    (n: 'glSecondaryColor3ub'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ub),
    (n: 'glSecondaryColor3ubv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ubv),
    (n: 'glSecondaryColor3ui'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3ui),
    (n: 'glSecondaryColor3uiv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3uiv),
    (n: 'glSecondaryColor3us'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3us),
    (n: 'glSecondaryColor3usv'; d: {$ifndef FPC}@{$endif}@glSecondaryColor3usv),
    (n: 'glSecondaryColorPointer'; d: {$ifndef FPC}@{$endif}@glSecondaryColorPointer),
    (n: 'glWindowPos2d'; d: {$ifndef FPC}@{$endif}@glWindowPos2d),
    (n: 'glWindowPos2dv'; d: {$ifndef FPC}@{$endif}@glWindowPos2dv),
    (n: 'glWindowPos2f'; d: {$ifndef FPC}@{$endif}@glWindowPos2f),
    (n: 'glWindowPos2fv'; d: {$ifndef FPC}@{$endif}@glWindowPos2fv),
    (n: 'glWindowPos2i'; d: {$ifndef FPC}@{$endif}@glWindowPos2i),
    (n: 'glWindowPos2iv'; d: {$ifndef FPC}@{$endif}@glWindowPos2iv),
    (n: 'glWindowPos2s'; d: {$ifndef FPC}@{$endif}@glWindowPos2s),
    (n: 'glWindowPos2sv'; d: {$ifndef FPC}@{$endif}@glWindowPos2sv),
    (n: 'glWindowPos3d'; d: {$ifndef FPC}@{$endif}@glWindowPos3d),
    (n: 'glWindowPos3dv'; d: {$ifndef FPC}@{$endif}@glWindowPos3dv),
    (n: 'glWindowPos3f'; d: {$ifndef FPC}@{$endif}@glWindowPos3f),
    (n: 'glWindowPos3fv'; d: {$ifndef FPC}@{$endif}@glWindowPos3fv),
    (n: 'glWindowPos3i'; d: {$ifndef FPC}@{$endif}@glWindowPos3i),
    (n: 'glWindowPos3iv'; d: {$ifndef FPC}@{$endif}@glWindowPos3iv),
    (n: 'glWindowPos3s'; d: {$ifndef FPC}@{$endif}@glWindowPos3s),
    (n: 'glWindowPos3sv'; d: {$ifndef FPC}@{$endif}@glWindowPos3sv)
   );
begin
 result:= getprocaddresses(libgl,funcs);

end;

function Load_GL_version_1_5: Boolean;
const
 funcs: array[0..18] of funcinfoty =
   (
    (n: 'glGenQueries'; d: {$ifndef FPC}@{$endif}@glGenQueries),
    (n: 'glDeleteQueries'; d: {$ifndef FPC}@{$endif}@glDeleteQueries),
    (n: 'glIsQuery'; d: {$ifndef FPC}@{$endif}@glIsQuery),
    (n: 'glBeginQuery'; d: {$ifndef FPC}@{$endif}@glBeginQuery),
    (n: 'glEndQuery'; d: {$ifndef FPC}@{$endif}@glEndQuery),
    (n: 'glGetQueryiv'; d: {$ifndef FPC}@{$endif}@glGetQueryiv),
    (n: 'glGetQueryObjectiv'; d: {$ifndef FPC}@{$endif}@glGetQueryObjectiv),
    (n: 'glGetQueryObjectuiv'; d: {$ifndef FPC}@{$endif}@glGetQueryObjectuiv),
    (n: 'glBindBuffer'; d: {$ifndef FPC}@{$endif}@glBindBuffer),
    (n: 'glDeleteBuffers'; d: {$ifndef FPC}@{$endif}@glDeleteBuffers),
    (n: 'glGenBuffers'; d: {$ifndef FPC}@{$endif}@glGenBuffers),
    (n: 'glIsBuffer'; d: {$ifndef FPC}@{$endif}@glIsBuffer),
    (n: 'glBufferData'; d: {$ifndef FPC}@{$endif}@glBufferData),
    (n: 'glBufferSubData'; d: {$ifndef FPC}@{$endif}@glBufferSubData),
    (n: 'glGetBufferSubData'; d: {$ifndef FPC}@{$endif}@glGetBufferSubData),
    (n: 'glMapBuffer'; d: {$ifndef FPC}@{$endif}@glMapBuffer),
    (n: 'glUnmapBuffer'; d: {$ifndef FPC}@{$endif}@glUnmapBuffer),
    (n: 'glGetBufferParameteriv'; d: {$ifndef FPC}@{$endif}@glGetBufferParameteriv),
    (n: 'glGetBufferPointerv'; d: {$ifndef FPC}@{$endif}@glGetBufferPointerv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_version_2_0: Boolean;
const
 funcs: array[0..92] of funcinfoty =
   (
    (n: 'glBlendEquationSeparate'; d: {$ifndef FPC}@{$endif}@glBlendEquationSeparate),
    (n: 'glDrawBuffers'; d: {$ifndef FPC}@{$endif}@glDrawBuffers),
    (n: 'glStencilOpSeparate'; d: {$ifndef FPC}@{$endif}@glStencilOpSeparate),
    (n: 'glStencilFuncSeparate'; d: {$ifndef FPC}@{$endif}@glStencilFuncSeparate),
    (n: 'glStencilMaskSeparate'; d: {$ifndef FPC}@{$endif}@glStencilMaskSeparate),
    (n: 'glAttachShader'; d: {$ifndef FPC}@{$endif}@glAttachShader),
    (n: 'glBindAttribLocation'; d: {$ifndef FPC}@{$endif}@glBindAttribLocation),
    (n: 'glCompileShader'; d: {$ifndef FPC}@{$endif}@glCompileShader),
    (n: 'glCreateProgram'; d: {$ifndef FPC}@{$endif}@glCreateProgram),
    (n: 'glCreateShader'; d: {$ifndef FPC}@{$endif}@glCreateShader),
    (n: 'glDeleteProgram'; d: {$ifndef FPC}@{$endif}@glDeleteProgram),
    (n: 'glDeleteShader'; d: {$ifndef FPC}@{$endif}@glDeleteShader),
    (n: 'glDetachShader'; d: {$ifndef FPC}@{$endif}@glDetachShader),
    (n: 'glDisableVertexAttribArray'; d: {$ifndef FPC}@{$endif}@glDisableVertexAttribArray),
    (n: 'glEnableVertexAttribArray'; d: {$ifndef FPC}@{$endif}@glEnableVertexAttribArray),
    (n: 'glGetActiveAttrib'; d: {$ifndef FPC}@{$endif}@glGetActiveAttrib),
    (n: 'glGetActiveUniform'; d: {$ifndef FPC}@{$endif}@glGetActiveUniform),
    (n: 'glGetAttachedShaders'; d: {$ifndef FPC}@{$endif}@glGetAttachedShaders),
    (n: 'glGetAttribLocation'; d: {$ifndef FPC}@{$endif}@glGetAttribLocation),
    (n: 'glGetProgramiv'; d: {$ifndef FPC}@{$endif}@glGetProgramiv),
    (n: 'glGetProgramInfoLog'; d: {$ifndef FPC}@{$endif}@glGetProgramInfoLog),
    (n: 'glGetShaderiv'; d: {$ifndef FPC}@{$endif}@glGetShaderiv),
    (n: 'glGetShaderInfoLog'; d: {$ifndef FPC}@{$endif}@glGetShaderInfoLog),
    (n: 'glGetShaderSource'; d: {$ifndef FPC}@{$endif}@glGetShaderSource),
    (n: 'glGetUniformLocation'; d: {$ifndef FPC}@{$endif}@glGetUniformLocation),
    (n: 'glGetUniformfv'; d: {$ifndef FPC}@{$endif}@glGetUniformfv),
    (n: 'glGetUniformiv'; d: {$ifndef FPC}@{$endif}@glGetUniformiv),
    (n: 'glGetVertexAttribdv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribdv),
    (n: 'glGetVertexAttribfv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribfv),
    (n: 'glGetVertexAttribiv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribiv),
    (n: 'glGetVertexAttribPointerv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribPointerv),
    (n: 'glIsProgram'; d: {$ifndef FPC}@{$endif}@glIsProgram),
    (n: 'glIsShader'; d: {$ifndef FPC}@{$endif}@glIsShader),
    (n: 'glLinkProgram'; d: {$ifndef FPC}@{$endif}@glLinkProgram),
    (n: 'glShaderSource'; d: {$ifndef FPC}@{$endif}@glShaderSource),
    (n: 'glUseProgram'; d: {$ifndef FPC}@{$endif}@glUseProgram),
    (n: 'glUniform1f'; d: {$ifndef FPC}@{$endif}@glUniform1f),
    (n: 'glUniform2f'; d: {$ifndef FPC}@{$endif}@glUniform2f),
    (n: 'glUniform3f'; d: {$ifndef FPC}@{$endif}@glUniform3f),
    (n: 'glUniform4f'; d: {$ifndef FPC}@{$endif}@glUniform4f),
    (n: 'glUniform1i'; d: {$ifndef FPC}@{$endif}@glUniform1i),
    (n: 'glUniform2i'; d: {$ifndef FPC}@{$endif}@glUniform2i),
    (n: 'glUniform3i'; d: {$ifndef FPC}@{$endif}@glUniform3i),
    (n: 'glUniform4i'; d: {$ifndef FPC}@{$endif}@glUniform4i),
    (n: 'glUniform1fv'; d: {$ifndef FPC}@{$endif}@glUniform1fv),
    (n: 'glUniform2fv'; d: {$ifndef FPC}@{$endif}@glUniform2fv),
    (n: 'glUniform3fv'; d: {$ifndef FPC}@{$endif}@glUniform3fv),
    (n: 'glUniform4fv'; d: {$ifndef FPC}@{$endif}@glUniform4fv),
    (n: 'glUniform1iv'; d: {$ifndef FPC}@{$endif}@glUniform1iv),
    (n: 'glUniform2iv'; d: {$ifndef FPC}@{$endif}@glUniform2iv),
    (n: 'glUniform3iv'; d: {$ifndef FPC}@{$endif}@glUniform3iv),
    (n: 'glUniform4iv'; d: {$ifndef FPC}@{$endif}@glUniform4iv),
    (n: 'glUniformMatrix2fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2fv),
    (n: 'glUniformMatrix3fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3fv),
    (n: 'glUniformMatrix4fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4fv),
    (n: 'glValidateProgram'; d: {$ifndef FPC}@{$endif}@glValidateProgram),
    (n: 'glVertexAttrib1d'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1d),
    (n: 'glVertexAttrib1dv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1dv),
    (n: 'glVertexAttrib1f'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1f),
    (n: 'glVertexAttrib1fv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1fv),
    (n: 'glVertexAttrib1s'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1s),
    (n: 'glVertexAttrib1sv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib1sv),
    (n: 'glVertexAttrib2d'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2d),
    (n: 'glVertexAttrib2dv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2dv),
    (n: 'glVertexAttrib2f'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2f),
    (n: 'glVertexAttrib2fv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2fv),
    (n: 'glVertexAttrib2s'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2s),
    (n: 'glVertexAttrib2sv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib2sv),
    (n: 'glVertexAttrib3d'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3d),
    (n: 'glVertexAttrib3dv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3dv),
    (n: 'glVertexAttrib3f'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3f),
    (n: 'glVertexAttrib3fv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3fv),
    (n: 'glVertexAttrib3s'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3s),
    (n: 'glVertexAttrib3sv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib3sv),
    (n: 'glVertexAttrib4Nbv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nbv),
    (n: 'glVertexAttrib4Niv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Niv),
    (n: 'glVertexAttrib4Nsv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nsv),
    (n: 'glVertexAttrib4Nub'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nub),
    (n: 'glVertexAttrib4Nubv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nubv),
    (n: 'glVertexAttrib4Nuiv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nuiv),
    (n: 'glVertexAttrib4Nusv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4Nusv),
    (n: 'glVertexAttrib4bv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4bv),
    (n: 'glVertexAttrib4d'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4d),
    (n: 'glVertexAttrib4dv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4dv),
    (n: 'glVertexAttrib4f'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4f),
    (n: 'glVertexAttrib4fv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4fv),
    (n: 'glVertexAttrib4iv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4iv),
    (n: 'glVertexAttrib4s'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4s),
    (n: 'glVertexAttrib4sv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4sv),
    (n: 'glVertexAttrib4ubv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4ubv),
    (n: 'glVertexAttrib4uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4uiv),
    (n: 'glVertexAttrib4usv'; d: {$ifndef FPC}@{$endif}@glVertexAttrib4usv),
    (n: 'glVertexAttribPointer'; d: {$ifndef FPC}@{$endif}@glVertexAttribPointer)
   );
begin
 result:= getprocaddresses(libgl,funcs);

end;
(*
function glext_LoadExtension(ext: String): Boolean;
begin

  Result := FALSE;

  if ext = 'GL_version_1_2' then Result := Load_GL_version_1_2
  else if ext = 'GL_ARB_imaging' then Result := Load_GL_ARB_imaging
  else if ext = 'GL_version_1_3' then Result := Load_GL_version_1_3
  else if ext = 'GL_ARB_multitexture' then Result := Load_GL_ARB_multitexture
  else if ext = 'GL_ARB_transpose_matrix' then Result := Load_GL_ARB_transpose_matrix
  else if ext = 'GL_ARB_multisample' then Result := Load_GL_ARB_multisample
  else if ext = 'GL_ARB_texture_env_add' then Result := Load_GL_ARB_texture_env_add
{$IFDEF msWindows}
  else if ext = 'WGL_ARB_extensions_string' then Result := Load_WGL_ARB_extensions_string
  else if ext = 'WGL_ARB_buffer_region' then Result := Load_WGL_ARB_buffer_region
{$ENDIF}
  else if ext = 'GL_ARB_texture_cube_map' then Result := Load_GL_ARB_texture_cube_map
  else if ext = 'GL_ARB_depth_texture' then Result := Load_GL_ARB_depth_texture
  else if ext = 'GL_ARB_point_parameters' then Result := Load_GL_ARB_point_parameters
  else if ext = 'GL_ARB_shadow' then Result := Load_GL_ARB_shadow
  else if ext = 'GL_ARB_shadow_ambient' then Result := Load_GL_ARB_shadow_ambient
  else if ext = 'GL_ARB_texture_border_clamp' then Result := Load_GL_ARB_texture_border_clamp
  else if ext = 'GL_ARB_texture_compression' then Result := Load_GL_ARB_texture_compression
  else if ext = 'GL_ARB_texture_env_combine' then Result := Load_GL_ARB_texture_env_combine
  else if ext = 'GL_ARB_texture_env_crossbar' then Result := Load_GL_ARB_texture_env_crossbar
  else if ext = 'GL_ARB_texture_env_dot3' then Result := Load_GL_ARB_texture_env_dot3
  else if ext = 'GL_ARB_texture_mirrored_repeat' then Result := Load_GL_ARB_texture_mirrored_repeat
  else if ext = 'GL_ARB_vertex_blend' then Result := Load_GL_ARB_vertex_blend
  else if ext = 'GL_ARB_vertex_program' then Result := Load_GL_ARB_vertex_program
  else if ext = 'GL_ARB_window_pos' then Result := Load_GL_ARB_window_pos
  else if ext = 'GL_EXT_422_pixels' then Result := Load_GL_EXT_422_pixels
  else if ext = 'GL_EXT_abgr' then Result := Load_GL_EXT_abgr
  else if ext = 'GL_EXT_bgra' then Result := Load_GL_EXT_bgra
  else if ext = 'GL_EXT_blend_color' then Result := Load_GL_EXT_blend_color
  else if ext = 'GL_EXT_blend_func_separate' then Result := Load_GL_EXT_blend_func_separate
  else if ext = 'GL_EXT_blend_logic_op' then Result := Load_GL_EXT_blend_logic_op
  else if ext = 'GL_EXT_blend_minmax' then Result := Load_GL_EXT_blend_minmax
  else if ext = 'GL_EXT_blend_subtract' then Result := Load_GL_EXT_blend_subtract
  else if ext = 'GL_EXT_clip_volume_hint' then Result := Load_GL_EXT_clip_volume_hint
  else if ext = 'GL_EXT_color_subtable' then Result := Load_GL_EXT_color_subtable
  else if ext = 'GL_EXT_compiled_vertex_array' then Result := Load_GL_EXT_compiled_vertex_array
  else if ext = 'GL_EXT_convolution' then Result := Load_GL_EXT_convolution
  else if ext = 'GL_EXT_fog_coord' then Result := Load_GL_EXT_fog_coord
  else if ext = 'GL_EXT_histogram' then Result := Load_GL_EXT_histogram
  else if ext = 'GL_EXT_multi_draw_arrays' then Result := Load_GL_EXT_multi_draw_arrays
  else if ext = 'GL_EXT_packed_pixels' then Result := Load_GL_EXT_packed_pixels
  else if ext = 'GL_EXT_paletted_texture' then Result := Load_GL_EXT_paletted_texture
  else if ext = 'GL_EXT_point_parameters' then Result := Load_GL_EXT_point_parameters
  else if ext = 'GL_EXT_polygon_offset' then Result := Load_GL_EXT_polygon_offset
  else if ext = 'GL_EXT_secondary_color' then Result := Load_GL_EXT_secondary_color
  else if ext = 'GL_EXT_separate_specular_color' then Result := Load_GL_EXT_separate_specular_color
  else if ext = 'GL_EXT_shadow_funcs' then Result := Load_GL_EXT_shadow_funcs
  else if ext = 'GL_EXT_shared_texture_palette' then Result := Load_GL_EXT_shared_texture_palette
  else if ext = 'GL_EXT_stencil_two_side' then Result := Load_GL_EXT_stencil_two_side
  else if ext = 'GL_EXT_stencil_wrap' then Result := Load_GL_EXT_stencil_wrap
  else if ext = 'GL_EXT_subtexture' then Result := Load_GL_EXT_subtexture
  else if ext = 'GL_EXT_texture3D' then Result := Load_GL_EXT_texture3D
  else if ext = 'GL_EXT_texture_compression_s3tc' then Result := Load_GL_EXT_texture_compression_s3tc
  else if ext = 'GL_EXT_texture_env_add' then Result := Load_GL_EXT_texture_env_add
  else if ext = 'GL_EXT_texture_env_combine' then Result := Load_GL_EXT_texture_env_combine
  else if ext = 'GL_EXT_texture_env_dot3' then Result := Load_GL_EXT_texture_env_dot3
  else if ext = 'GL_EXT_texture_filter_anisotropic' then Result := Load_GL_EXT_texture_filter_anisotropic
  else if ext = 'GL_EXT_texture_lod_bias' then Result := Load_GL_EXT_texture_lod_bias
  else if ext = 'GL_EXT_texture_object' then Result := Load_GL_EXT_texture_object
  else if ext = 'GL_EXT_vertex_array' then Result := Load_GL_EXT_vertex_array
  else if ext = 'GL_EXT_vertex_shader' then Result := Load_GL_EXT_vertex_shader
  else if ext = 'GL_EXT_vertex_weighting' then Result := Load_GL_EXT_vertex_weighting
  else if ext = 'GL_HP_occlusion_test' then Result := Load_GL_HP_occlusion_test
  else if ext = 'GL_NV_blend_square' then Result := Load_GL_NV_blend_square
  else if ext = 'GL_NV_copy_depth_to_color' then Result := Load_GL_NV_copy_depth_to_color
  else if ext = 'GL_NV_depth_clamp' then Result := Load_GL_NV_depth_clamp
  else if ext = 'GL_NV_evaluators' then Result := Load_GL_NV_evaluators
  else if ext = 'GL_NV_fence' then Result := Load_GL_NV_fence
  else if ext = 'GL_NV_fog_distance' then Result := Load_GL_NV_fog_distance
  else if ext = 'GL_NV_light_max_exponent' then Result := Load_GL_NV_light_max_exponent
  else if ext = 'GL_NV_multisample_filter_hint' then Result := Load_GL_NV_multisample_filter_hint
  else if ext = 'GL_NV_occlusion_query' then Result := Load_GL_NV_occlusion_query
  else if ext = 'GL_NV_packed_depth_stencil' then Result := Load_GL_NV_packed_depth_stencil
  else if ext = 'GL_NV_point_sprite' then Result := Load_GL_NV_point_sprite
  else if ext = 'GL_NV_register_combiners' then Result := Load_GL_NV_register_combiners
  else if ext = 'GL_NV_register_combiners2' then Result := Load_GL_NV_register_combiners2
  else if ext = 'GL_NV_texgen_emboss' then Result := Load_GL_NV_texgen_emboss
  else if ext = 'GL_NV_texgen_reflection' then Result := Load_GL_NV_texgen_reflection
  else if ext = 'GL_NV_texture_compression_vtc' then Result := Load_GL_NV_texture_compression_vtc
  else if ext = 'GL_NV_texture_env_combine4' then Result := Load_GL_NV_texture_env_combine4
  else if ext = 'GL_NV_texture_rectangle' then Result := Load_GL_NV_texture_rectangle
  else if ext = 'GL_NV_texture_shader' then Result := Load_GL_NV_texture_shader
  else if ext = 'GL_NV_texture_shader2' then Result := Load_GL_NV_texture_shader2
  else if ext = 'GL_NV_texture_shader3' then Result := Load_GL_NV_texture_shader3
  else if ext = 'GL_NV_vertex_array_range' then Result := Load_GL_NV_vertex_array_range
  else if ext = 'GL_NV_vertex_array_range2' then Result := Load_GL_NV_vertex_array_range2
  else if ext = 'GL_NV_vertex_program' then Result := Load_GL_NV_vertex_program
  else if ext = 'GL_NV_vertex_program1_1' then Result := Load_GL_NV_vertex_program1_1
  else if ext = 'GL_ATI_element_array' then Result := Load_GL_ATI_element_array
  else if ext = 'GL_ATI_envmap_bumpmap' then Result := Load_GL_ATI_envmap_bumpmap
  else if ext = 'GL_ATI_fragment_shader' then Result := Load_GL_ATI_fragment_shader
  else if ext = 'GL_ATI_pn_triangles' then Result := Load_GL_ATI_pn_triangles
  else if ext = 'GL_ATI_texture_mirror_once' then Result := Load_GL_ATI_texture_mirror_once
  else if ext = 'GL_ATI_vertex_array_object' then Result := Load_GL_ATI_vertex_array_object
  else if ext = 'GL_ATI_vertex_streams' then Result := Load_GL_ATI_vertex_streams
{$IFDEF msWindows}
  else if ext = 'WGL_I3D_image_buffer' then Result := Load_WGL_I3D_image_buffer
  else if ext = 'WGL_I3D_swap_frame_lock' then Result := Load_WGL_I3D_swap_frame_lock
  else if ext = 'WGL_I3D_swap_frame_usage' then Result := Load_WGL_I3D_swap_frame_usage
{$ENDIF}
  else if ext = 'GL_3DFX_texture_compression_FXT1' then Result := Load_GL_3DFX_texture_compression_FXT1
  else if ext = 'GL_IBM_cull_vertex' then Result := Load_GL_IBM_cull_vertex
  else if ext = 'GL_IBM_multimode_draw_arrays' then Result := Load_GL_IBM_multimode_draw_arrays
  else if ext = 'GL_IBM_raster_pos_clip' then Result := Load_GL_IBM_raster_pos_clip
  else if ext = 'GL_IBM_texture_mirrored_repeat' then Result := Load_GL_IBM_texture_mirrored_repeat
  else if ext = 'GL_IBM_vertex_array_lists' then Result := Load_GL_IBM_vertex_array_lists
  else if ext = 'GL_MESA_resize_buffers' then Result := Load_GL_MESA_resize_buffers
  else if ext = 'GL_MESA_window_pos' then Result := Load_GL_MESA_window_pos
  else if ext = 'GL_OML_interlace' then Result := Load_GL_OML_interlace
  else if ext = 'GL_OML_resample' then Result := Load_GL_OML_resample
  else if ext = 'GL_OML_subsample' then Result := Load_GL_OML_subsample
  else if ext = 'GL_SGIS_generate_mipmap' then Result := Load_GL_SGIS_generate_mipmap
  else if ext = 'GL_SGIS_multisample' then Result := Load_GL_SGIS_multisample
  else if ext = 'GL_SGIS_pixel_texture' then Result := Load_GL_SGIS_pixel_texture
  else if ext = 'GL_SGIS_texture_border_clamp' then Result := Load_GL_SGIS_texture_border_clamp
  else if ext = 'GL_SGIS_texture_color_mask' then Result := Load_GL_SGIS_texture_color_mask
  else if ext = 'GL_SGIS_texture_edge_clamp' then Result := Load_GL_SGIS_texture_edge_clamp
  else if ext = 'GL_SGIS_texture_lod' then Result := Load_GL_SGIS_texture_lod
  else if ext = 'GL_SGIS_depth_texture' then Result := Load_GL_SGIS_depth_texture
  else if ext = 'GL_SGIX_fog_offset' then Result := Load_GL_SGIX_fog_offset
  else if ext = 'GL_SGIX_interlace' then Result := Load_GL_SGIX_interlace
  else if ext = 'GL_SGIX_shadow_ambient' then Result := Load_GL_SGIX_shadow_ambient
  else if ext = 'GL_SGI_color_matrix' then Result := Load_GL_SGI_color_matrix
  else if ext = 'GL_SGI_color_table' then Result := Load_GL_SGI_color_table
  else if ext = 'GL_SGI_texture_color_table' then Result := Load_GL_SGI_texture_color_table
  else if ext = 'GL_SUN_vertex' then Result := Load_GL_SUN_vertex
  else if ext = 'GL_ARB_fragment_program' then Result := Load_GL_ARB_fragment_program
  else if ext = 'GL_ATI_text_fragment_shader' then Result := Load_GL_ATI_text_fragment_shader
  else if ext = 'GL_APPLE_client_storage' then Result := Load_GL_APPLE_client_storage
  else if ext = 'GL_APPLE_element_array' then Result := Load_GL_APPLE_element_array
  else if ext = 'GL_APPLE_fence' then Result := Load_GL_APPLE_fence
  else if ext = 'GL_APPLE_vertex_array_object' then Result := Load_GL_APPLE_vertex_array_object
  else if ext = 'GL_APPLE_vertex_array_range' then Result := Load_GL_APPLE_vertex_array_range
{$IFDEF msWindows}
  else if ext = 'WGL_ARB_pixel_format' then Result := Load_WGL_ARB_pixel_format
  else if ext = 'WGL_ARB_make_current_read' then Result := Load_WGL_ARB_make_current_read
  else if ext = 'WGL_ARB_pbuffer' then Result := Load_WGL_ARB_pbuffer
  else if ext = 'WGL_EXT_swap_control' then Result := Load_WGL_EXT_swap_control
  else if ext = 'WGL_ARB_render_texture' then Result := Load_WGL_ARB_render_texture
  else if ext = 'WGL_EXT_extensions_string' then Result := Load_WGL_EXT_extensions_string
  else if ext = 'WGL_EXT_make_current_read' then Result := Load_WGL_EXT_make_current_read
  else if ext = 'WGL_EXT_pbuffer' then Result := Load_WGL_EXT_pbuffer
  else if ext = 'WGL_EXT_pixel_format' then Result := Load_WGL_EXT_pixel_format
  else if ext = 'WGL_I3D_digital_video_control' then Result := Load_WGL_I3D_digital_video_control
  else if ext = 'WGL_I3D_gamma' then Result := Load_WGL_I3D_gamma
  else if ext = 'WGL_I3D_genlock' then Result := Load_WGL_I3D_genlock
{$ENDIF}
  else if ext = 'GL_ARB_matrix_palette' then Result := Load_GL_ARB_matrix_palette
  else if ext = 'GL_NV_element_array' then Result := Load_GL_NV_element_array
  else if ext = 'GL_NV_float_buffer' then Result := Load_GL_NV_float_buffer
  else if ext = 'GL_NV_fragment_program' then Result := Load_GL_NV_fragment_program
  else if ext = 'GL_NV_primitive_restart' then Result := Load_GL_NV_primitive_restart
  else if ext = 'GL_NV_vertex_program2' then Result := Load_GL_NV_vertex_program2
  {$IFDEF msWindows}
  else if ext = 'WGL_NV_render_texture_rectangle' then Result := Load_WGL_NV_render_texture_rectangle
  {$ENDIF}
  else if ext = 'GL_NV_pixel_data_range' then Result := Load_GL_NV_pixel_data_range
  else if ext = 'GL_EXT_texture_rectangle' then Result := Load_GL_EXT_texture_rectangle
  else if ext = 'GL_S3_s3tc' then Result := Load_GL_S3_s3tc
  else if ext = 'GL_ATI_draw_buffers' then Result := Load_GL_ATI_draw_buffers
  {$IFDEF msWindows}
  else if ext = 'WGL_ATI_pixel_format_float' then Result := Load_WGL_ATI_pixel_format_float
  {$ENDIF}
  else if ext = 'GL_ATI_texture_env_combine3' then Result := Load_GL_ATI_texture_env_combine3
  else if ext = 'GL_ATI_texture_float' then Result := Load_GL_ATI_texture_float
  else if ext = 'GL_NV_texture_expand_normal' then Result := Load_GL_NV_texture_expand_normal
  else if ext = 'GL_NV_half_float' then Result := Load_GL_NV_half_float
  else if ext = 'GL_ATI_map_object_buffer' then Result := Load_GL_ATI_map_object_buffer
  else if ext = 'GL_ATI_separate_stencil' then Result := Load_GL_ATI_separate_stencil
  else if ext = 'GL_ATI_vertex_attrib_array_object' then Result := Load_GL_ATI_vertex_attrib_array_object
  else if ext = 'GL_ARB_vertex_buffer_object' then Result := Load_GL_ARB_vertex_buffer_object
  else if ext = 'GL_ARB_occlusion_query' then Result := Load_GL_ARB_occlusion_query
  else if ext = 'GL_ARB_shader_objects' then Result := Load_GL_ARB_shader_objects
  else if ext = 'GL_ARB_vertex_shader' then Result := Load_GL_ARB_vertex_shader
  else if ext = 'GL_ARB_fragment_shader' then Result := Load_GL_ARB_fragment_shader
  else if ext = 'GL_ARB_shading_language_100' then Result := Load_GL_ARB_shading_language_100
  else if ext = 'GL_ARB_texture_non_power_of_two' then Result := Load_GL_ARB_texture_non_power_of_two
  else if ext = 'GL_ARB_point_sprite' then Result := Load_GL_ARB_point_sprite
  else if ext = 'GL_EXT_depth_bounds_test' then Result := Load_GL_EXT_depth_bounds_test
  else if ext = 'GL_EXT_texture_mirror_clamp' then Result := Load_GL_EXT_texture_mirror_clamp
  else if ext = 'GL_EXT_blend_equation_separate' then Result := Load_GL_EXT_blend_equation_separate
  else if ext = 'GL_MESA_pack_invert' then Result := Load_GL_MESA_pack_invert
  else if ext = 'GL_MESA_ycbcr_texture' then Result := Load_GL_MESA_ycbcr_texture
  else if ext = 'GL_ARB_fragment_program_shadow' then Result := Load_GL_ARB_fragment_program_shadow
  else if ext = 'GL_NV_fragment_program_option' then Result := Load_GL_NV_fragment_program_option
  else if ext = 'GL_EXT_pixel_buffer_object' then Result := Load_GL_EXT_pixel_buffer_object
  else if ext = 'GL_NV_fragment_program2' then Result := Load_GL_NV_fragment_program2
  else if ext = 'GL_NV_vertex_program2_option' then Result := Load_GL_NV_vertex_program2_option
  else if ext = 'GL_NV_vertex_program3' then Result := Load_GL_NV_vertex_program3
  else if ext = 'GL_ARB_draw_buffers' then Result := Load_GL_ARB_draw_buffers
  else if ext = 'GL_ARB_texture_rectangle' then Result := Load_GL_ARB_texture_rectangle
  else if ext = 'GL_ARB_color_buffer_float' then Result := Load_GL_ARB_color_buffer_float
  else if ext = 'GL_ARB_half_float_pixel' then Result := Load_GL_ARB_half_float_pixel
  else if ext = 'GL_ARB_texture_float' then Result := Load_GL_ARB_texture_float
  else if ext = 'GL_EXT_texture_compression_dxt1' then Result := Load_GL_EXT_texture_compression_dxt1
  else if ext = 'GL_ARB_pixel_buffer_object' then Result := Load_GL_ARB_pixel_buffer_object
  else if ext = 'GL_EXT_framebuffer_object' then Result := Load_GL_EXT_framebuffer_object
  else if ext = 'GL_version_1_4' then Result := Load_GL_version_1_4
  else if ext = 'GL_version_1_5' then Result := Load_GL_version_1_5
  else if ext = 'GL_version_2_0' then Result := Load_GL_version_2_0

end;
*)

function Load_GL_VERSION_2_1(): Boolean;
const
 funcs: array[0..5] of funcinfoty =
   (
    (n: 'glUniformMatrix2x3fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2x3fv),
    (n: 'glUniformMatrix3x2fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3x2fv),
    (n: 'glUniformMatrix2x4fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix2x4fv),
    (n: 'glUniformMatrix4x2fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4x2fv),
    (n: 'glUniformMatrix3x4fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix3x4fv),
    (n: 'glUniformMatrix4x3fv'; d: {$ifndef FPC}@{$endif}@glUniformMatrix4x3fv)
   );
begin
 result:= getprocaddresses(libgl,funcs);
end;

function Load_GL_VERSION_3_0(): Boolean;
const
 funcs: array[0..57] of funcinfoty =
   (
    (n: 'glColorMaski'; d: {$ifndef FPC}@{$endif}@glColorMaski),
    (n: 'glGetBooleani_v'; d: {$ifndef FPC}@{$endif}@glGetBooleani_v),
    (n: 'glGetIntegeri_v'; d: {$ifndef FPC}@{$endif}@glGetIntegeri_v),
    (n: 'glEnablei'; d: {$ifndef FPC}@{$endif}@glEnablei),
    (n: 'glDisablei'; d: {$ifndef FPC}@{$endif}@glDisablei),
    (n: 'glIsEnabledi'; d: {$ifndef FPC}@{$endif}@glIsEnabledi),
    (n: 'glBeginTransformFeedback'; d: {$ifndef FPC}@{$endif}@glBeginTransformFeedback),
    (n: 'glEndTransformFeedback'; d: {$ifndef FPC}@{$endif}@glEndTransformFeedback),
    (n: 'glBindBufferRange'; d: {$ifndef FPC}@{$endif}@glBindBufferRange),
    (n: 'glBindBufferBase'; d: {$ifndef FPC}@{$endif}@glBindBufferBase),
    (n: 'glTransformFeedbackVaryings'; d: {$ifndef FPC}@{$endif}@glTransformFeedbackVaryings),
    (n: 'glGetTransformFeedbackVarying'; d: {$ifndef FPC}@{$endif}@glGetTransformFeedbackVarying),
    (n: 'glClampColor'; d: {$ifndef FPC}@{$endif}@glClampColor),
    (n: 'glBeginConditionalRender'; d: {$ifndef FPC}@{$endif}@glBeginConditionalRender),
    (n: 'glEndConditionalRender'; d: {$ifndef FPC}@{$endif}@glEndConditionalRender),
    (n: 'glVertexAttribIPointer'; d: {$ifndef FPC}@{$endif}@glVertexAttribIPointer),
    (n: 'glGetVertexAttribIiv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribIiv),
    (n: 'glGetVertexAttribIuiv'; d: {$ifndef FPC}@{$endif}@glGetVertexAttribIuiv),
    (n: 'glVertexAttribI1i'; d: {$ifndef FPC}@{$endif}@glVertexAttribI1i),
    (n: 'glVertexAttribI2i'; d: {$ifndef FPC}@{$endif}@glVertexAttribI2i),
    (n: 'glVertexAttribI3i'; d: {$ifndef FPC}@{$endif}@glVertexAttribI3i),
    (n: 'glVertexAttribI4i'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4i),
    (n: 'glVertexAttribI1ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribI1ui),
    (n: 'glVertexAttribI2ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribI2ui),
    (n: 'glVertexAttribI3ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribI3ui),
    (n: 'glVertexAttribI4ui'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4ui),
    (n: 'glVertexAttribI1iv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI1iv),
    (n: 'glVertexAttribI2iv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI2iv),
    (n: 'glVertexAttribI3iv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI3iv),
    (n: 'glVertexAttribI4iv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4iv),
    (n: 'glVertexAttribI1uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI1uiv),
    (n: 'glVertexAttribI2uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI2uiv),
    (n: 'glVertexAttribI3uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI3uiv),
    (n: 'glVertexAttribI4uiv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4uiv),
    (n: 'glVertexAttribI4bv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4bv),
    (n: 'glVertexAttribI4sv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4sv),
    (n: 'glVertexAttribI4ubv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4ubv),
    (n: 'glVertexAttribI4usv'; d: {$ifndef FPC}@{$endif}@glVertexAttribI4usv),
    (n: 'glGetUniformuiv'; d: {$ifndef FPC}@{$endif}@glGetUniformuiv),
    (n: 'glBindFragDataLocation'; d: {$ifndef FPC}@{$endif}@glBindFragDataLocation),
    (n: 'glGetFragDataLocation'; d: {$ifndef FPC}@{$endif}@glGetFragDataLocation),
    (n: 'glUniform1ui'; d: {$ifndef FPC}@{$endif}@glUniform1ui),
    (n: 'glUniform2ui'; d: {$ifndef FPC}@{$endif}@glUniform2ui),
    (n: 'glUniform3ui'; d: {$ifndef FPC}@{$endif}@glUniform3ui),
    (n: 'glUniform4ui'; d: {$ifndef FPC}@{$endif}@glUniform4ui),
    (n: 'glUniform1uiv'; d: {$ifndef FPC}@{$endif}@glUniform1uiv),
    (n: 'glUniform2uiv'; d: {$ifndef FPC}@{$endif}@glUniform2uiv),
    (n: 'glUniform3uiv'; d: {$ifndef FPC}@{$endif}@glUniform3uiv),
    (n: 'glUniform4uiv'; d: {$ifndef FPC}@{$endif}@glUniform4uiv),
    (n: 'glTexParameterIiv'; d: {$ifndef FPC}@{$endif}@glTexParameterIiv),
    (n: 'glTexParameterIuiv'; d: {$ifndef FPC}@{$endif}@glTexParameterIuiv),
    (n: 'glGetTexParameterIiv'; d: {$ifndef FPC}@{$endif}@glGetTexParameterIiv),
    (n: 'glGetTexParameterIuiv'; d: {$ifndef FPC}@{$endif}@glGetTexParameterIuiv),
    (n: 'glClearBufferiv'; d: {$ifndef FPC}@{$endif}@glClearBufferiv),
    (n: 'glClearBufferuiv'; d: {$ifndef FPC}@{$endif}@glClearBufferuiv),
    (n: 'glClearBufferfv'; d: {$ifndef FPC}@{$endif}@glClearBufferfv),
    (n: 'glClearBufferfi'; d: {$ifndef FPC}@{$endif}@glClearBufferfi),
    (n: 'glGetStringi'; d: {$ifndef FPC}@{$endif}@glGetStringi)
  );
begin
 result:= getprocaddresses(libgl,funcs);
 result:= result and mseglloadextensions([
                                   gle_GL_ARB_framebuffer_object,
                                   gle_GL_ARB_map_buffer_range,
                                   gle_GL_ARB_vertex_array_object]);
end;

function Load_GL_VERSION_3_1(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glDrawArraysInstanced'; d: {$ifndef FPC}@{$endif}@glDrawArraysInstanced),
    (n: 'glDrawElementsInstanced'; d: {$ifndef FPC}@{$endif}@glDrawElementsInstanced),
    (n: 'glTexBuffer'; d: {$ifndef FPC}@{$endif}@glTexBuffer),
    (n: 'glPrimitiveRestartIndex'; d: {$ifndef FPC}@{$endif}@glPrimitiveRestartIndex)
   );
begin
 result:= getprocaddresses(libgl,funcs);
 result:= result and mseglloadextensions([
                             gle_GL_ARB_copy_buffer,
                             gle_GL_ARB_uniform_buffer_object]);
end;

function Load_GL_VERSION_3_2(): Boolean;
const
 funcs: array[0..3] of funcinfoty =
   (
    (n: 'glGetInteger64i_v'; d: {$ifndef FPC}@{$endif}@glGetInteger64i_v),
    (n: 'glGetBufferParameteri64v'; d: {$ifndef FPC}@{$endif}@glGetBufferParameteri64v),
    (n: 'glProgramParameteri'; d: {$ifndef FPC}@{$endif}@glProgramParameteri),
    (n: 'glFramebufferTexture'; d: {$ifndef FPC}@{$endif}@glFramebufferTexture)
   );
begin
 result:= getprocaddresses(libgl,funcs);
 result:= result and mseglloadextensions([
                             gle_GL_ARB_draw_elements_base_vertex,
                             gle_GL_ARB_provoking_vertex,
                             gle_GL_ARB_sync,
                             gle_GL_ARB_texture_multisample]);
end;

function Load_GL_VERSION_3_3(): Boolean;
begin
 result:= mseglloadextensions([
                             gle_GL_ARB_blend_func_extended,
                             gle_GL_ARB_sampler_objects,
                             gle_GL_ARB_timer_query,
                             gle_GL_ARB_vertex_type_2_10_10_10_rev]);
end;

function Load_GL_VERSION_4_0(): Boolean;
begin
 result:= mseglloadextensions([
                             gle_GL_ARB_gpu_shader_fp64,
                             gle_GL_ARB_shader_subroutine,
                             gle_GL_ARB_tessellation_shader,
                             gle_GL_ARB_transform_feedback2,
                             gle_GL_ARB_transform_feedback3]);
end;

end.
