
unit main;

{$MODE objfpc}{$H+}

interface

uses
  sysutils,
  msegui,
  msegraphutils,
  mseforms,
  msestream,
  msewidgetgrid,
  msesyntaxedit,
  msesimplewidgets,
  msesyntaxpainter,
  mseglob,
  msegraphedits,
  msegraphics,
  mseguiglob,
  mseificomp,
  mseificompglob,
  mseifiglob,
  msemenus,
  msescrollbar,
  msetypes;

type
  tmainfo = class(tmainform)
    grid1: twidgetgrid;
    edit1: tsyntaxedit;
    button1: tbutton;
    painter1: tsyntaxpainter;
    procedure buttonexecute(const sender: TObject);
    procedure formcreate(const sender: TObject);
    procedure formdestroy(const sender: TObject);
  private
    fhandle: integer;
  end;

var
  mainfo: tmainfo;

implementation

uses
  main_mfm;

procedure tmainfo.buttonexecute(const sender: TObject);
begin
  edit1.loadfromfile('sample.tex');
end;

procedure tmainfo.formcreate(const sender: TObject);
var
  s: ttextstream;
begin
  s := ttextstream.create('latex.sdef');
  fhandle := painter1.readdeffile(s);
  if fhandle >= 0 then
  begin
    edit1.setsyntaxdef(fhandle);
  end;

  s.free;
end;

procedure tmainfo.formdestroy(const sender: TObject);
begin
  painter1.freedeffile(fhandle);
end;

end.
