
program Demo;

{$mode objfpc}{$h+}
{$ifdef mswindows}{$apptype console}{$endif}

uses
{$ifdef unix}
  cthreads,
  cwstring,
{$endif}
  sysutils,
  msetypes, // filenamety
  msestat;  // tstatwriter, tstatreader

const
  cfilename: filenamety = 'demo.sta';
  cmsestringarty: msestringarty = ('ein');
  
var
  lstatwriter: tstatwriter;
  lstatreader: tstatreader;
  lmsestringarty: msestringarty;
  lmsestring: msestring;

begin  
  try
    lstatwriter := tstatwriter.create(cfilename);
    with lstatwriter do
    begin
      writesection('options');
      
      writemsestring('a', 'abracadabra');
      writeboolean('b', TRUE);
      writeinteger('c', 2020);
      
      writearray('d', ['ein', 'zwei', 'drei']);
    end;
  finally
    lstatwriter.free;
  end;
  
  try
    lstatreader := tstatreader.create(cfilename);
    with lstatreader do
    begin
      setsection('options');
      
      WriteLn(readmsestring('a', '?'));
      WriteLn(readboolean('b', FALSE));
      WriteLn(readinteger('c', 0));
      
      lmsestringarty := readarray('d', cmsestringarty);
      for lmsestring in lmsestringarty do
        WriteLn('* ', lmsestring);
    end;
  finally
    lstatreader.free;
  end;
end.
