
if [ -d "$1" ]
then
  WHERE="$1"
else
  WHERE=". -mindepth 2"
fi

EXT=pas
LIST=files.txt
find $WHERE -name "*.$EXT" -print > $LIST
sort $LIST -o $LIST

while read f
do
  echo "$f"
  echo "${f%.*}"
done <$LIST

exit 0

## =============================================================================

EXT=html

LIST=files.txt
find $WHERE -name "*.$EXT" -print > $LIST
sort $LIST -o $LIST

MARKDOWN=markdown_strict

while read f
do
  pandoc "$f" -f html -t plain -o "${f%.*}.txt" --columns=120
  pandoc "$f" -f html -t $MARKDOWN -o "${f%.*}.md" --columns=120
done <$LIST
